// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__7072__auto__ = (((scale == null))?null:scale);
var m__7073__auto__ = (c2.scale.invert[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(scale) : m__7073__auto__.call(null,scale));
} else {
var m__7073__auto____$1 = (c2.scale.invert["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(scale) : m__7073__auto____$1.call(null,scale));
} else {
throw cljs.core.missing_protocol("IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39095,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39098 = (((k39095 instanceof cljs.core.Keyword))?k39095.fqn:null);
switch (G__39098) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39095,else__7034__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._linear{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39094){
var self__ = this;
var G__39094__$1 = this;
return (new cljs.core.RecordIter((0),G__39094__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$domain,self__.range,cljs.core.array_seq([cljs.core.cst$kw$range,self__.domain], 0));
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39094){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39099 = cljs.core.keyword_identical_QMARK_;
var expr__39100 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39102 = cljs.core.cst$kw$domain;
var G__39103 = expr__39100;
return (pred__39099.cljs$core$IFn$_invoke$arity$2 ? pred__39099.cljs$core$IFn$_invoke$arity$2(G__39102,G__39103) : pred__39099.call(null,G__39102,G__39103));
})())){
return (new c2.scale._linear(G__39094,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39104 = cljs.core.cst$kw$range;
var G__39105 = expr__39100;
return (pred__39099.cljs$core$IFn$_invoke$arity$2 ? pred__39099.cljs$core$IFn$_invoke$arity$2(G__39104,G__39105) : pred__39099.call(null,G__39104,G__39105));
})())){
return (new c2.scale._linear(self__.domain,G__39094,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39094),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39094){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__39094,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args39097){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39097)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__39096){
return (new c2.scale._linear(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39096),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39096),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39096,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39108 = arguments.length;
var i__7485__auto___39109 = (0);
while(true){
if((i__7485__auto___39109 < len__7484__auto___39108)){
args__7491__auto__.push((arguments[i__7485__auto___39109]));

var G__39110 = (i__7485__auto___39109 + (1));
i__7485__auto___39109 = G__39110;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq39106){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39106));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39112,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39115 = (((k39112 instanceof cljs.core.Keyword))?k39112.fqn:null);
switch (G__39115) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39112,else__7034__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._power{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39111){
var self__ = this;
var G__39111__$1 = this;
return (new cljs.core.RecordIter((0),G__39111__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39111){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39116 = cljs.core.keyword_identical_QMARK_;
var expr__39117 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39119 = cljs.core.cst$kw$domain;
var G__39120 = expr__39117;
return (pred__39116.cljs$core$IFn$_invoke$arity$2 ? pred__39116.cljs$core$IFn$_invoke$arity$2(G__39119,G__39120) : pred__39116.call(null,G__39119,G__39120));
})())){
return (new c2.scale._power(G__39111,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39121 = cljs.core.cst$kw$range;
var G__39122 = expr__39117;
return (pred__39116.cljs$core$IFn$_invoke$arity$2 ? pred__39116.cljs$core$IFn$_invoke$arity$2(G__39121,G__39122) : pred__39116.call(null,G__39121,G__39122));
})())){
return (new c2.scale._power(self__.domain,G__39111,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39111),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39111){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__39111,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args39114){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39114)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__39113){
return (new c2.scale._power(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39113),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39113),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39113,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39125 = arguments.length;
var i__7485__auto___39126 = (0);
while(true){
if((i__7485__auto___39126 < len__7484__auto___39125)){
args__7491__auto__.push((arguments[i__7485__auto___39126]));

var G__39127 = (i__7485__auto___39126 + (1));
i__7485__auto___39126 = G__39127;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq39123){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39123));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39129,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39132 = (((k39129 instanceof cljs.core.Keyword))?k39129.fqn:null);
switch (G__39132) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39129,else__7034__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._log{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39128){
var self__ = this;
var G__39128__$1 = this;
return (new cljs.core.RecordIter((0),G__39128__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39128){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39133 = cljs.core.keyword_identical_QMARK_;
var expr__39134 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39136 = cljs.core.cst$kw$domain;
var G__39137 = expr__39134;
return (pred__39133.cljs$core$IFn$_invoke$arity$2 ? pred__39133.cljs$core$IFn$_invoke$arity$2(G__39136,G__39137) : pred__39133.call(null,G__39136,G__39137));
})())){
return (new c2.scale._log(G__39128,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39138 = cljs.core.cst$kw$range;
var G__39139 = expr__39134;
return (pred__39133.cljs$core$IFn$_invoke$arity$2 ? pred__39133.cljs$core$IFn$_invoke$arity$2(G__39138,G__39139) : pred__39133.call(null,G__39138,G__39139));
})())){
return (new c2.scale._log(self__.domain,G__39128,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39128),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39128){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__39128,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args39131){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39131)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__39130){
return (new c2.scale._log(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39130),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39130),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39130,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39142 = arguments.length;
var i__7485__auto___39143 = (0);
while(true){
if((i__7485__auto___39143 < len__7484__auto___39142)){
args__7491__auto__.push((arguments[i__7485__auto___39143]));

var G__39144 = (i__7485__auto___39143 + (1));
i__7485__auto___39143 = G__39144;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq39140){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39140));
});

