// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('hatti.utils.submission_review');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38354_SHARP_){
if(typeof p1__38354_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38354_SHARP_);
} else {
return p1__38354_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38360){
var vec__38361 = p__38360;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38361,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38361,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38355_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38355_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38364 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38364__$1 = ((((!((map__38364 == null)))?((((map__38364.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38364.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38364):map__38364);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38364__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38364__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38364__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__38369 = cljs.core.split_at((1),cols);
var actions = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38369,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38369,(1),null);
return cljs.core.vec(cljs.core.flatten(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(data,hatti.ona.forms.review_comment_field,cljs.core.array_seq([hatti.ona.forms.review_status_field,actions], 0))));
});
hatti.views.actions_column.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38404 = arguments.length;
var i__7485__auto___38405 = (0);
while(true){
if((i__7485__auto___38405 < len__7484__auto___38404)){
args__7491__auto__.push((arguments[i__7485__auto___38405]));

var G__38406 = (i__7485__auto___38405 + (1));
i__7485__auto___38405 = G__38406;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38375){
var map__38376 = p__38375;
var map__38376__$1 = ((((!((map__38376 == null)))?((((map__38376.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38376.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38376):map__38376);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38376__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38376__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38376__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38376__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38376__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38378 = cljs.core.false_QMARK_;
var G__38379 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38378,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38372_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38372_SHARP_)) == null);
});})(G__38378,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38378,G__38379) : chimera.core.any_QMARK_.call(null,G__38378,G__38379));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38380(s__38381){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38381__$1 = s__38381;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38381__$1);
if(temp__4657__auto__){
var s__38381__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38381__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38381__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38383 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38382 = (0);
while(true){
if((i__38382 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38382);
cljs.core.chunk_append(b__38383,(function (){var map__38394 = field;
var map__38394__$1 = ((((!((map__38394 == null)))?((((map__38394.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38394.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38394):map__38394);
var map__38395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38394__$1,cljs.core.cst$kw$instance);
var map__38395__$1 = ((((!((map__38395 == null)))?((((map__38395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38395):map__38395);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38395__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38394__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38394__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38394__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38407 = (i__38382 + (1));
i__38382 = G__38407;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38383),hatti$views$table$iter__38380(cljs.core.chunk_rest(s__38381__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38383),null);
}
} else {
var field = cljs.core.first(s__38381__$2);
return cljs.core.cons((function (){var map__38398 = field;
var map__38398__$1 = ((((!((map__38398 == null)))?((((map__38398.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38398.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38398):map__38398);
var map__38399 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38398__$1,cljs.core.cst$kw$instance);
var map__38399__$1 = ((((!((map__38399 == null)))?((((map__38399.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38399.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38399):map__38399);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38399__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38398__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38398__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38398__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38380(cljs.core.rest(s__38381__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38376,map__38376__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__((function (){var G__38402 = hatti.views.table.all_fields(form);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields(G__38402);
} else {
return G__38402;
}
})());
})();
return cljs.core.clj__GT_js((function (){var G__38403 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38403,(hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2 ? hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2(owner,has_hxl_QMARK_) : hatti.views.actions_column.call(null,owner,has_hxl_QMARK_)));
} else {
return G__38403;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38373){
var G__38374 = cljs.core.first(seq38373);
var seq38373__$1 = cljs.core.next(seq38373);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38374,seq38373__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38409 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38409);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38428(s__38429){
return (new cljs.core.LazySeq(null,(function (){
var s__38429__$1 = s__38429;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38429__$1);
if(temp__4657__auto__){
var s__38429__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38429__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38429__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38431 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38430 = (0);
while(true){
if((i__38430 < size__7188__auto__)){
var vec__38440 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38430);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38440,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38440,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38431,event.subscribe(handler_function));

var G__38446 = (i__38430 + (1));
i__38430 = G__38446;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38431),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38428(cljs.core.chunk_rest(s__38429__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38431),null);
}
} else {
var vec__38443 = cljs.core.first(s__38429__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38443,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38443,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38428(cljs.core.rest(s__38429__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38465(s__38466){
return (new cljs.core.LazySeq(null,(function (){
var s__38466__$1 = s__38466;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38466__$1);
if(temp__4657__auto__){
var s__38466__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38466__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38466__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38468 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38467 = (0);
while(true){
if((i__38467 < size__7188__auto__)){
var vec__38477 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38467);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38477,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38477,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38468,event.subscribe(handler_function));

var G__38483 = (i__38467 + (1));
i__38467 = G__38483;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38468),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38465(cljs.core.chunk_rest(s__38466__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38468),null);
}
} else {
var vec__38480 = cljs.core.first(s__38466__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38480,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38480,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38465(cljs.core.rest(s__38466__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38486 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38486__$1 = ((((!((map__38486 == null)))?((((map__38486.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38486.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38486):map__38486);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38486__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38486,map__38486__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38486,map__38486__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38492 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38493 = null;
var count__38494 = (0);
var i__38495 = (0);
while(true){
if((i__38495 < count__38494)){
var data_id = chunk__38493.cljs$core$IIndexed$_nth$arity$2(null,i__38495);
var element_38496 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38496.checked = true;

var G__38497 = seq__38492;
var G__38498 = chunk__38493;
var G__38499 = count__38494;
var G__38500 = (i__38495 + (1));
seq__38492 = G__38497;
chunk__38493 = G__38498;
count__38494 = G__38499;
i__38495 = G__38500;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38492);
if(temp__4657__auto__){
var seq__38492__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38492__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38492__$1);
var G__38501 = cljs.core.chunk_rest(seq__38492__$1);
var G__38502 = c__7220__auto__;
var G__38503 = cljs.core.count(c__7220__auto__);
var G__38504 = (0);
seq__38492 = G__38501;
chunk__38493 = G__38502;
count__38494 = G__38503;
i__38495 = G__38504;
continue;
} else {
var data_id = cljs.core.first(seq__38492__$1);
var element_38505 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38505.checked = true;

var G__38506 = cljs.core.next(seq__38492__$1);
var G__38507 = null;
var G__38508 = (0);
var G__38509 = (0);
seq__38492 = G__38506;
chunk__38493 = G__38507;
count__38494 = G__38508;
i__38495 = G__38509;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (row_map){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(row_map,"_review_status",hatti.utils.submission_review.get_submission_review_text(row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38510){
var map__38530 = p__38510;
var map__38530__$1 = ((((!((map__38530 == null)))?((((map__38530.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38530.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38530):map__38530);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38530__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38530__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38532 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38532__$1 = ((((!((map__38532 == null)))?((((map__38532.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38532.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38532):map__38532);
var map__38533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38532__$1,cljs.core.cst$kw$table_DASH_page);
var map__38533__$1 = ((((!((map__38533 == null)))?((((map__38533.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38533.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38533):map__38533);
var map__38534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38533__$1,cljs.core.cst$kw$paging);
var map__38534__$1 = ((((!((map__38534 == null)))?((((map__38534.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38534.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38534):map__38534);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38534__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38534__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38533__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38532__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$submission_DASH_review_QMARK_,submission_review_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38538_38549 = cljs.core.seq(records_to_be_deleted);
var chunk__38539_38550 = null;
var count__38540_38551 = (0);
var i__38541_38552 = (0);
while(true){
if((i__38541_38552 < count__38540_38551)){
var record_38553 = chunk__38539_38550.cljs$core$IIndexed$_nth$arity$2(null,i__38541_38552);
record_38553.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38542 = record_38553.getAttribute("data-id");
return parseInt(G__38542);
})());

var G__38554 = seq__38538_38549;
var G__38555 = chunk__38539_38550;
var G__38556 = count__38540_38551;
var G__38557 = (i__38541_38552 + (1));
seq__38538_38549 = G__38554;
chunk__38539_38550 = G__38555;
count__38540_38551 = G__38556;
i__38541_38552 = G__38557;
continue;
} else {
var temp__4657__auto___38558 = cljs.core.seq(seq__38538_38549);
if(temp__4657__auto___38558){
var seq__38538_38559__$1 = temp__4657__auto___38558;
if(cljs.core.chunked_seq_QMARK_(seq__38538_38559__$1)){
var c__7220__auto___38560 = cljs.core.chunk_first(seq__38538_38559__$1);
var G__38561 = cljs.core.chunk_rest(seq__38538_38559__$1);
var G__38562 = c__7220__auto___38560;
var G__38563 = cljs.core.count(c__7220__auto___38560);
var G__38564 = (0);
seq__38538_38549 = G__38561;
chunk__38539_38550 = G__38562;
count__38540_38551 = G__38563;
i__38541_38552 = G__38564;
continue;
} else {
var record_38565 = cljs.core.first(seq__38538_38559__$1);
record_38565.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38543 = record_38565.getAttribute("data-id");
return parseInt(G__38543);
})());

var G__38566 = cljs.core.next(seq__38538_38559__$1);
var G__38567 = null;
var G__38568 = (0);
var G__38569 = (0);
seq__38538_38549 = G__38566;
chunk__38539_38550 = G__38567;
count__38540_38551 = G__38568;
i__38541_38552 = G__38569;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38545 = elem.getAttribute("data-id");
return parseInt(G__38545);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38544 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38544__$1 = ((((!((map__38544 == null)))?((((map__38544.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38544.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38544):map__38544);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38544__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38547 = grid.getCellFromEvent(e).row;
return parseInt(G__38547);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38544,map__38544__$1,selected_table_rows,map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38544,map__38544__$1,selected_table_rows,map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38532,map__38532__$1,map__38533,map__38533__$1,map__38534,map__38534__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38530,map__38530__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js((function (){var G__38548 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status(G__38548);
} else {
return G__38548;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13879__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,event_chan){
return (function (state_38861){
var state_val_38862 = (state_38861[(1)]);
if((state_val_38862 === (7))){
var inst_38759 = (state_38861[(7)]);
var inst_38759__$1 = (state_38861[(2)]);
var inst_38761 = (inst_38759__$1 == null);
var inst_38762 = cljs.core.not(inst_38761);
var state_38861__$1 = (function (){var statearr_38863 = state_38861;
(statearr_38863[(7)] = inst_38759__$1);

return statearr_38863;
})();
if(inst_38762){
var statearr_38864_38939 = state_38861__$1;
(statearr_38864_38939[(1)] = (8));

} else {
var statearr_38865_38940 = state_38861__$1;
(statearr_38865_38940[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (20))){
var inst_38789 = (state_38861[(8)]);
var inst_38781 = (state_38861[(9)]);
var inst_38798 = (inst_38789.cljs$core$IFn$_invoke$arity$1 ? inst_38789.cljs$core$IFn$_invoke$arity$1(inst_38781) : inst_38789.call(null,inst_38781));
var state_38861__$1 = state_38861;
var statearr_38866_38941 = state_38861__$1;
(statearr_38866_38941[(2)] = inst_38798);

(statearr_38866_38941[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (27))){
var state_38861__$1 = state_38861;
var statearr_38867_38942 = state_38861__$1;
(statearr_38867_38942[(2)] = null);

(statearr_38867_38942[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (1))){
var state_38861__$1 = state_38861;
var statearr_38868_38943 = state_38861__$1;
(statearr_38868_38943[(2)] = null);

(statearr_38868_38943[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (24))){
var state_38861__$1 = state_38861;
var statearr_38869_38944 = state_38861__$1;
(statearr_38869_38944[(2)] = null);

(statearr_38869_38944[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (4))){
var state_38861__$1 = state_38861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38861__$1,(7),event_chan);
} else {
if((state_val_38862 === (15))){
var inst_38759 = (state_38861[(7)]);
var state_38861__$1 = state_38861;
var statearr_38870_38945 = state_38861__$1;
(statearr_38870_38945[(2)] = inst_38759);

(statearr_38870_38945[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (21))){
var state_38861__$1 = state_38861;
var statearr_38871_38946 = state_38861__$1;
(statearr_38871_38946[(2)] = null);

(statearr_38871_38946[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (31))){
var inst_38785 = (state_38861[(10)]);
var inst_38834 = (state_38861[(2)]);
var inst_38835 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38785,cljs.core.cst$kw$table);
var state_38861__$1 = (function (){var statearr_38872 = state_38861;
(statearr_38872[(11)] = inst_38834);

return statearr_38872;
})();
if(inst_38835){
var statearr_38873_38947 = state_38861__$1;
(statearr_38873_38947[(1)] = (32));

} else {
var statearr_38874_38948 = state_38861__$1;
(statearr_38874_38948[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (32))){
var inst_38785 = (state_38861[(10)]);
var inst_38789 = (state_38861[(8)]);
var inst_38784 = (state_38861[(12)]);
var inst_38780 = (state_38861[(13)]);
var inst_38790 = (state_38861[(14)]);
var inst_38779 = (state_38861[(15)]);
var inst_38783 = (state_38861[(16)]);
var inst_38782 = (state_38861[(17)]);
var inst_38781 = (state_38861[(9)]);
var inst_38848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38849 = (function (){var new_columns = inst_38784;
var submission_clicked = inst_38781;
var submission_unclicked = inst_38782;
var get_submission_data = inst_38790;
var re_render = inst_38785;
var update_data_BANG_ = inst_38789;
var submission_to_rank = inst_38780;
var filter_by = inst_38783;
var map__38757 = inst_38779;
var c__13879__auto____$1 = inst_38848;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan){
return (function (state_38846){
var state_val_38847 = (state_38846[(1)]);
if((state_val_38847 === (1))){
var inst_38837 = cljs.core.async.timeout((20));
var state_38846__$1 = state_38846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38846__$1,(2),inst_38837);
} else {
if((state_val_38847 === (2))){
var inst_38839 = (state_38846[(2)]);
var inst_38840 = grid.resizeCanvas();
var inst_38841 = grid.invalidateAllRows();
var inst_38842 = hatti.views.table.resizeColumns(grid);
var inst_38843 = grid.render();
var inst_38844 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38846__$1 = (function (){var statearr_38875 = state_38846;
(statearr_38875[(7)] = inst_38840);

(statearr_38875[(8)] = inst_38842);

(statearr_38875[(9)] = inst_38843);

(statearr_38875[(10)] = inst_38839);

(statearr_38875[(11)] = inst_38841);

return statearr_38875;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38846__$1,inst_38844);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_38879 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38879[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_38879[(1)] = (1));

return statearr_38879;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38846){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38846);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e38880){if((e38880 instanceof Object)){
var ex__13771__auto__ = e38880;
var statearr_38881_38949 = state_38846;
(statearr_38881_38949[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38846);

return cljs.core.cst$kw$recur;
} else {
throw e38880;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__38950 = state_38846;
state_38846 = G__38950;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38846){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_38882 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_38882[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_38882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38848,state_val_38862,c__13879__auto__,event_chan))
})();
var inst_38850 = cljs.core.async.impl.dispatch.run(inst_38849);
var state_38861__$1 = (function (){var statearr_38883 = state_38861;
(statearr_38883[(18)] = inst_38850);

return statearr_38883;
})();
var statearr_38884_38951 = state_38861__$1;
(statearr_38884_38951[(2)] = inst_38848);

(statearr_38884_38951[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (33))){
var state_38861__$1 = state_38861;
var statearr_38885_38952 = state_38861__$1;
(statearr_38885_38952[(2)] = null);

(statearr_38885_38952[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (13))){
var inst_38771 = (state_38861[(2)]);
var state_38861__$1 = state_38861;
var statearr_38886_38953 = state_38861__$1;
(statearr_38886_38953[(2)] = inst_38771);

(statearr_38886_38953[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (22))){
var inst_38782 = (state_38861[(17)]);
var inst_38801 = (state_38861[(2)]);
var state_38861__$1 = (function (){var statearr_38887 = state_38861;
(statearr_38887[(19)] = inst_38801);

return statearr_38887;
})();
if(cljs.core.truth_(inst_38782)){
var statearr_38888_38954 = state_38861__$1;
(statearr_38888_38954[(1)] = (23));

} else {
var statearr_38889_38955 = state_38861__$1;
(statearr_38889_38955[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (29))){
var inst_38783 = (state_38861[(16)]);
var inst_38826 = [cljs.core.cst$kw$query];
var inst_38827 = [inst_38783];
var inst_38828 = cljs.core.PersistentHashMap.fromArrays(inst_38826,inst_38827);
var inst_38829 = cljs.core.clj__GT_js(inst_38828);
var inst_38830 = dataview.setFilterArgs(inst_38829);
var inst_38831 = dataview.refresh();
var state_38861__$1 = (function (){var statearr_38890 = state_38861;
(statearr_38890[(20)] = inst_38830);

return statearr_38890;
})();
var statearr_38891_38956 = state_38861__$1;
(statearr_38891_38956[(2)] = inst_38831);

(statearr_38891_38956[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (6))){
var inst_38857 = (state_38861[(2)]);
var state_38861__$1 = state_38861;
var statearr_38892_38957 = state_38861__$1;
(statearr_38892_38957[(2)] = inst_38857);

(statearr_38892_38957[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (28))){
var inst_38783 = (state_38861[(16)]);
var inst_38824 = (state_38861[(2)]);
var state_38861__$1 = (function (){var statearr_38893 = state_38861;
(statearr_38893[(21)] = inst_38824);

return statearr_38893;
})();
if(cljs.core.truth_(inst_38783)){
var statearr_38894_38958 = state_38861__$1;
(statearr_38894_38958[(1)] = (29));

} else {
var statearr_38895_38959 = state_38861__$1;
(statearr_38895_38959[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (25))){
var inst_38784 = (state_38861[(12)]);
var inst_38806 = (state_38861[(2)]);
var state_38861__$1 = (function (){var statearr_38896 = state_38861;
(statearr_38896[(22)] = inst_38806);

return statearr_38896;
})();
if(cljs.core.truth_(inst_38784)){
var statearr_38897_38960 = state_38861__$1;
(statearr_38897_38960[(1)] = (26));

} else {
var statearr_38898_38961 = state_38861__$1;
(statearr_38898_38961[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (34))){
var inst_38853 = (state_38861[(2)]);
var state_38861__$1 = (function (){var statearr_38899 = state_38861;
(statearr_38899[(23)] = inst_38853);

return statearr_38899;
})();
var statearr_38900_38962 = state_38861__$1;
(statearr_38900_38962[(2)] = null);

(statearr_38900_38962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (17))){
var inst_38789 = (state_38861[(8)]);
var inst_38780 = (state_38861[(13)]);
var inst_38790 = (state_38861[(14)]);
var inst_38792 = (inst_38790.cljs$core$IFn$_invoke$arity$2 ? inst_38790.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38780) : inst_38790.call(null,hatti.constants._rank,inst_38780));
var inst_38793 = (inst_38789.cljs$core$IFn$_invoke$arity$1 ? inst_38789.cljs$core$IFn$_invoke$arity$1(inst_38792) : inst_38789.call(null,inst_38792));
var state_38861__$1 = state_38861;
var statearr_38901_38963 = state_38861__$1;
(statearr_38901_38963[(2)] = inst_38793);

(statearr_38901_38963[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (3))){
var inst_38859 = (state_38861[(2)]);
var state_38861__$1 = state_38861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38861__$1,inst_38859);
} else {
if((state_val_38862 === (12))){
var state_38861__$1 = state_38861;
var statearr_38902_38964 = state_38861__$1;
(statearr_38902_38964[(2)] = false);

(statearr_38902_38964[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (2))){
var state_38861__$1 = state_38861;
var statearr_38903_38965 = state_38861__$1;
(statearr_38903_38965[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (23))){
var inst_38789 = (state_38861[(8)]);
var inst_38803 = (inst_38789.cljs$core$IFn$_invoke$arity$1 ? inst_38789.cljs$core$IFn$_invoke$arity$1(null) : inst_38789.call(null,null));
var state_38861__$1 = state_38861;
var statearr_38905_38966 = state_38861__$1;
(statearr_38905_38966[(2)] = inst_38803);

(statearr_38905_38966[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (19))){
var inst_38781 = (state_38861[(9)]);
var inst_38796 = (state_38861[(2)]);
var state_38861__$1 = (function (){var statearr_38906 = state_38861;
(statearr_38906[(24)] = inst_38796);

return statearr_38906;
})();
if(cljs.core.truth_(inst_38781)){
var statearr_38907_38967 = state_38861__$1;
(statearr_38907_38967[(1)] = (20));

} else {
var statearr_38908_38968 = state_38861__$1;
(statearr_38908_38968[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (11))){
var state_38861__$1 = state_38861;
var statearr_38909_38969 = state_38861__$1;
(statearr_38909_38969[(2)] = true);

(statearr_38909_38969[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (9))){
var state_38861__$1 = state_38861;
var statearr_38910_38970 = state_38861__$1;
(statearr_38910_38970[(2)] = false);

(statearr_38910_38970[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (5))){
var state_38861__$1 = state_38861;
var statearr_38911_38971 = state_38861__$1;
(statearr_38911_38971[(2)] = null);

(statearr_38911_38971[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (14))){
var inst_38759 = (state_38861[(7)]);
var inst_38776 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38759);
var state_38861__$1 = state_38861;
var statearr_38912_38972 = state_38861__$1;
(statearr_38912_38972[(2)] = inst_38776);

(statearr_38912_38972[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (26))){
var inst_38785 = (state_38861[(10)]);
var inst_38789 = (state_38861[(8)]);
var inst_38784 = (state_38861[(12)]);
var inst_38780 = (state_38861[(13)]);
var inst_38790 = (state_38861[(14)]);
var inst_38779 = (state_38861[(15)]);
var inst_38783 = (state_38861[(16)]);
var inst_38782 = (state_38861[(17)]);
var inst_38781 = (state_38861[(9)]);
var inst_38819 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38820 = (function (){var new_columns = inst_38784;
var submission_clicked = inst_38781;
var submission_unclicked = inst_38782;
var get_submission_data = inst_38790;
var re_render = inst_38785;
var update_data_BANG_ = inst_38789;
var submission_to_rank = inst_38780;
var filter_by = inst_38783;
var map__38757 = inst_38779;
var c__13879__auto____$1 = inst_38819;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan){
return (function (state_38817){
var state_val_38818 = (state_38817[(1)]);
if((state_val_38818 === (1))){
var inst_38808 = cljs.core.async.timeout((20));
var state_38817__$1 = state_38817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38817__$1,(2),inst_38808);
} else {
if((state_val_38818 === (2))){
var inst_38810 = (state_38817[(2)]);
var inst_38811 = grid.setColumns(new_columns);
var inst_38812 = hatti.views.table.resizeColumns(grid);
var inst_38813 = grid.render();
var inst_38814 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38815 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38817__$1 = (function (){var statearr_38913 = state_38817;
(statearr_38913[(7)] = inst_38813);

(statearr_38913[(8)] = inst_38814);

(statearr_38913[(9)] = inst_38811);

(statearr_38913[(10)] = inst_38810);

(statearr_38913[(11)] = inst_38812);

return statearr_38913;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38817__$1,inst_38815);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_38917 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38917[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_38917[(1)] = (1));

return statearr_38917;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38817){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38817);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e38918){if((e38918 instanceof Object)){
var ex__13771__auto__ = e38918;
var statearr_38919_38973 = state_38817;
(statearr_38919_38973[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38817);

return cljs.core.cst$kw$recur;
} else {
throw e38918;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__38974 = state_38817;
state_38817 = G__38974;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38817){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_38920 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_38920[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_38920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__38757,c__13879__auto____$1,inst_38785,inst_38789,inst_38784,inst_38780,inst_38790,inst_38779,inst_38783,inst_38782,inst_38781,inst_38819,state_val_38862,c__13879__auto__,event_chan))
})();
var inst_38821 = cljs.core.async.impl.dispatch.run(inst_38820);
var state_38861__$1 = (function (){var statearr_38921 = state_38861;
(statearr_38921[(25)] = inst_38821);

return statearr_38921;
})();
var statearr_38922_38975 = state_38861__$1;
(statearr_38922_38975[(2)] = inst_38819);

(statearr_38922_38975[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (16))){
var inst_38785 = (state_38861[(10)]);
var inst_38789 = (state_38861[(8)]);
var inst_38784 = (state_38861[(12)]);
var inst_38780 = (state_38861[(13)]);
var inst_38779 = (state_38861[(15)]);
var inst_38783 = (state_38861[(16)]);
var inst_38782 = (state_38861[(17)]);
var inst_38781 = (state_38861[(9)]);
var inst_38779__$1 = (state_38861[(2)]);
var inst_38780__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38781__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38782__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38783__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38784__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38785__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38779__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38787 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38788 = (new cljs.core.PersistentVector(null,3,(5),inst_38786,inst_38787,null));
var inst_38789__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38788);
var inst_38790 = (function (){var map__38757 = inst_38779__$1;
var submission_to_rank = inst_38780__$1;
var submission_clicked = inst_38781__$1;
var submission_unclicked = inst_38782__$1;
var filter_by = inst_38783__$1;
var new_columns = inst_38784__$1;
var re_render = inst_38785__$1;
var update_data_BANG_ = inst_38789__$1;
return ((function (map__38757,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38785,inst_38789,inst_38784,inst_38780,inst_38779,inst_38783,inst_38782,inst_38781,inst_38779__$1,inst_38780__$1,inst_38781__$1,inst_38782__$1,inst_38783__$1,inst_38784__$1,inst_38785__$1,inst_38786,inst_38787,inst_38788,inst_38789__$1,state_val_38862,c__13879__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38757,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38785,inst_38789,inst_38784,inst_38780,inst_38779,inst_38783,inst_38782,inst_38781,inst_38779__$1,inst_38780__$1,inst_38781__$1,inst_38782__$1,inst_38783__$1,inst_38784__$1,inst_38785__$1,inst_38786,inst_38787,inst_38788,inst_38789__$1,state_val_38862,c__13879__auto__,event_chan){
return (function (p1__38570_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38570_SHARP_,field));
});})(map__38757,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38785,inst_38789,inst_38784,inst_38780,inst_38779,inst_38783,inst_38782,inst_38781,inst_38779__$1,inst_38780__$1,inst_38781__$1,inst_38782__$1,inst_38783__$1,inst_38784__$1,inst_38785__$1,inst_38786,inst_38787,inst_38788,inst_38789__$1,state_val_38862,c__13879__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38757,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38785,inst_38789,inst_38784,inst_38780,inst_38779,inst_38783,inst_38782,inst_38781,inst_38779__$1,inst_38780__$1,inst_38781__$1,inst_38782__$1,inst_38783__$1,inst_38784__$1,inst_38785__$1,inst_38786,inst_38787,inst_38788,inst_38789__$1,state_val_38862,c__13879__auto__,event_chan))
})();
var state_38861__$1 = (function (){var statearr_38923 = state_38861;
(statearr_38923[(10)] = inst_38785__$1);

(statearr_38923[(8)] = inst_38789__$1);

(statearr_38923[(12)] = inst_38784__$1);

(statearr_38923[(13)] = inst_38780__$1);

(statearr_38923[(14)] = inst_38790);

(statearr_38923[(15)] = inst_38779__$1);

(statearr_38923[(16)] = inst_38783__$1);

(statearr_38923[(17)] = inst_38782__$1);

(statearr_38923[(9)] = inst_38781__$1);

return statearr_38923;
})();
if(cljs.core.truth_(inst_38780__$1)){
var statearr_38924_38976 = state_38861__$1;
(statearr_38924_38976[(1)] = (17));

} else {
var statearr_38925_38977 = state_38861__$1;
(statearr_38925_38977[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (30))){
var state_38861__$1 = state_38861;
var statearr_38926_38978 = state_38861__$1;
(statearr_38926_38978[(2)] = null);

(statearr_38926_38978[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (10))){
var inst_38774 = (state_38861[(2)]);
var state_38861__$1 = state_38861;
if(cljs.core.truth_(inst_38774)){
var statearr_38927_38979 = state_38861__$1;
(statearr_38927_38979[(1)] = (14));

} else {
var statearr_38928_38980 = state_38861__$1;
(statearr_38928_38980[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (18))){
var state_38861__$1 = state_38861;
var statearr_38929_38981 = state_38861__$1;
(statearr_38929_38981[(2)] = null);

(statearr_38929_38981[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38862 === (8))){
var inst_38759 = (state_38861[(7)]);
var inst_38764 = inst_38759.cljs$lang$protocol_mask$partition0$;
var inst_38765 = (inst_38764 & (64));
var inst_38766 = inst_38759.cljs$core$ISeq$;
var inst_38767 = (inst_38765) || (inst_38766);
var state_38861__$1 = state_38861;
if(cljs.core.truth_(inst_38767)){
var statearr_38930_38982 = state_38861__$1;
(statearr_38930_38982[(1)] = (11));

} else {
var statearr_38931_38983 = state_38861__$1;
(statearr_38931_38983[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_38935 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38935[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_38935[(1)] = (1));

return statearr_38935;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_38861){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_38861);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e38936){if((e38936 instanceof Object)){
var ex__13771__auto__ = e38936;
var statearr_38937_38984 = state_38861;
(statearr_38937_38984[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38861);

return cljs.core.cst$kw$recur;
} else {
throw e38936;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__38985 = state_38861;
state_38861 = G__38985;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_38861){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_38861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_38938 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_38938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_38938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});})(c__13879__auto__,event_chan))
);

return c__13879__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39004(s__39005){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39005__$1 = s__39005;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39005__$1);
if(temp__4657__auto__){
var s__39005__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39005__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39005__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39007 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39006 = (0);
while(true){
if((i__39006 < size__7188__auto__)){
var vec__39016 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39006);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39016,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39016,(1),null);
cljs.core.chunk_append(b__39007,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39006,vec__39016,k,v,c__7187__auto__,size__7188__auto__,b__39007,s__39005__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39006,vec__39016,k,v,c__7187__auto__,size__7188__auto__,b__39007,s__39005__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39022 = (i__39006 + (1));
i__39006 = G__39022;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39007),hatti$views$table$render_options_$_iter__39004(cljs.core.chunk_rest(s__39005__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39007),null);
}
} else {
var vec__39019 = cljs.core.first(s__39005__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39019,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39019,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39019,k,v,s__39005__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39019,k,v,s__39005__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39004(cljs.core.rest(s__39005__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39024 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39024 = (function (_,owner,meta39025){
this._ = _;
this.owner = owner;
this.meta39025 = meta39025;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39024.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39026,meta39025__$1){
var self__ = this;
var _39026__$1 = this;
return (new hatti.views.table.t_hatti$views$table39024(self__._,self__.owner,meta39025__$1));
});

hatti.views.table.t_hatti$views$table39024.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39026){
var self__ = this;
var _39026__$1 = this;
return self__.meta39025;
});

hatti.views.table.t_hatti$views$table39024.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39024.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39024.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39024.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39027){
var self__ = this;
var map__39028 = p__39027;
var map__39028__$1 = ((((!((map__39028 == null)))?((((map__39028.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39028.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39028):map__39028);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39028__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39028__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39030 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39030__$1 = ((((!((map__39030 == null)))?((((map__39030.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39030.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39030):map__39030);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39030__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__39031 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__39031__$1 = ((((!((map__39031 == null)))?((((map__39031.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39031.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39031):map__39031);
var submission_review_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39031__$1,cljs.core.cst$kw$submission_DASH_review_QMARK_);
var colset_BANG_ = ((function (options,map__39030,map__39030__$1,flat_form,new_language,map__39031,map__39031__$1,submission_review_QMARK_,___$2,map__39028,map__39028__$1,field_key,language){
return (function (p1__39023_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39023_SHARP_),cljs.core.cst$kw$language,new_language,cljs.core.cst$kw$submission_DASH_review_QMARK_,submission_review_QMARK_,cljs.core.cst$kw$owner,self__.owner], 0))], null));
});})(options,map__39030,map__39030__$1,flat_form,new_language,map__39031,map__39031__$1,submission_review_QMARK_,___$2,map__39028,map__39028__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39042 = ({"className": "label-changer"});
var G__39043 = (function (){var G__39045 = ({"className": "label-changer-label"});
var G__39046 = "Show:";
return React.DOM.span(G__39045,G__39046);
})();
var G__39044 = (function (){var G__39047 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39048 = (function (){var attrs39036 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39036))?sablono.interpreter.attributes(attrs39036):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39036))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39050 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39050);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39036),(function (){var G__39051 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39051);
})()], null))));
})();
var G__39049 = (function (){var attrs39041 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39041))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39041], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39041))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39041)], null))));
})();
return React.DOM.div(G__39047,G__39048,G__39049);
})();
return React.DOM.div(G__39042,G__39043,G__39044);
});

hatti.views.table.t_hatti$views$table39024.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39025], null);
});

hatti.views.table.t_hatti$views$table39024.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39024.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39024";

hatti.views.table.t_hatti$views$table39024.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39024");
});

hatti.views.table.__GT_t_hatti$views$table39024 = (function hatti$views$table$__GT_t_hatti$views$table39024(___$1,owner__$1,meta39025){
return (new hatti.views.table.t_hatti$views$table39024(___$1,owner__$1,meta39025));
});

}

return (new hatti.views.table.t_hatti$views$table39024(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13879__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13879__auto__,query){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,query){
return (function (state_39094){
var state_val_39095 = (state_39094[(1)]);
if((state_val_39095 === (1))){
var inst_39080 = cljs.core.async.timeout((150));
var state_39094__$1 = state_39094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39094__$1,(2),inst_39080);
} else {
if((state_val_39095 === (2))){
var inst_39082 = (state_39094[(2)]);
var inst_39083 = input.value;
var inst_39084 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39083);
var state_39094__$1 = (function (){var statearr_39096 = state_39094;
(statearr_39096[(7)] = inst_39082);

return statearr_39096;
})();
if(inst_39084){
var statearr_39097_39108 = state_39094__$1;
(statearr_39097_39108[(1)] = (3));

} else {
var statearr_39098_39109 = state_39094__$1;
(statearr_39098_39109[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39095 === (3))){
var inst_39086 = [query_event_key];
var inst_39087 = [query];
var inst_39088 = cljs.core.PersistentHashMap.fromArrays(inst_39086,inst_39087);
var inst_39089 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39088);
var state_39094__$1 = state_39094;
var statearr_39099_39110 = state_39094__$1;
(statearr_39099_39110[(2)] = inst_39089);

(statearr_39099_39110[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39095 === (4))){
var state_39094__$1 = state_39094;
var statearr_39100_39111 = state_39094__$1;
(statearr_39100_39111[(2)] = null);

(statearr_39100_39111[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39095 === (5))){
var inst_39092 = (state_39094[(2)]);
var state_39094__$1 = state_39094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39094__$1,inst_39092);
} else {
return null;
}
}
}
}
}
});})(c__13879__auto__,query))
;
return ((function (switch__13767__auto__,c__13879__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13768__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13768__auto____0 = (function (){
var statearr_39104 = [null,null,null,null,null,null,null,null];
(statearr_39104[(0)] = hatti$views$table$delayed_search_$_state_machine__13768__auto__);

(statearr_39104[(1)] = (1));

return statearr_39104;
});
var hatti$views$table$delayed_search_$_state_machine__13768__auto____1 = (function (state_39094){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__(state_39094);
if(cljs.core.keyword_identical_QMARK_(result__13770__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e39105){if((e39105 instanceof Object)){
var ex__13771__auto__ = e39105;
var statearr_39106_39112 = state_39094;
(statearr_39106_39112[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39094);

return cljs.core.cst$kw$recur;
} else {
throw e39105;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13769__auto__,cljs.core.cst$kw$recur)){
var G__39113 = state_39094;
state_39094 = G__39113;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13768__auto__ = function(state_39094){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____1.call(this,state_39094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13768__auto____0;
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13768__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,query))
})();
var state__13881__auto__ = (function (){var statearr_39107 = (f__13880__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13880__auto__.cljs$core$IFn$_invoke$arity$0() : f__13880__auto__.call(null));
(statearr_39107[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_39107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13881__auto__);
});})(c__13879__auto__,query))
);

return c__13879__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39115 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39115 = (function (_,owner,meta39116){
this._ = _;
this.owner = owner;
this.meta39116 = meta39116;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39115.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39117,meta39116__$1){
var self__ = this;
var _39117__$1 = this;
return (new hatti.views.table.t_hatti$views$table39115(self__._,self__.owner,meta39116__$1));
});

hatti.views.table.t_hatti$views$table39115.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39117){
var self__ = this;
var _39117__$1 = this;
return self__.meta39116;
});

hatti.views.table.t_hatti$views$table39115.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39115.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
var G__39120 = ({"className": "table-search"});
var G__39121 = (function (){var G__39123 = ({"className": "fa fa-search"});
return React.DOM.i(G__39123);
})();
var G__39122 = (function (){var G__39124 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39120,G__39121,this__18222__auto____$1){
return (function (p1__39114_SHARP_){
return hatti.views.table.delayed_search(p1__39114_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39120,G__39121,this__18222__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39124) : sablono.interpreter.input.call(null,G__39124));
})();
return React.DOM.div(G__39120,G__39121,G__39122);
});

hatti.views.table.t_hatti$views$table39115.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39116], null);
});

hatti.views.table.t_hatti$views$table39115.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39115.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39115";

hatti.views.table.t_hatti$views$table39115.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39115");
});

hatti.views.table.__GT_t_hatti$views$table39115 = (function hatti$views$table$__GT_t_hatti$views$table39115(___$1,owner__$1,meta39116){
return (new hatti.views.table.t_hatti$views$table39115(___$1,owner__$1,meta39116));
});

}

return (new hatti.views.table.t_hatti$views$table39115(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39125 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39125 = (function (cursor,owner,meta39126){
this.cursor = cursor;
this.owner = owner;
this.meta39126 = meta39126;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39125.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39127,meta39126__$1){
var self__ = this;
var _39127__$1 = this;
return (new hatti.views.table.t_hatti$views$table39125(self__.cursor,self__.owner,meta39126__$1));
});

hatti.views.table.t_hatti$views$table39125.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39127){
var self__ = this;
var _39127__$1 = this;
return self__.meta39126;
});

hatti.views.table.t_hatti$views$table39125.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39125.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
var G__39130 = ({"className": "topbar"});
var G__39131 = (function (){var G__39135 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39135);
})();
var G__39132 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39133 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39134 = (function (){var G__39136 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39136);
})();
return React.DOM.div(G__39130,G__39131,G__39132,G__39133,G__39134);
});

hatti.views.table.t_hatti$views$table39125.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39126], null);
});

hatti.views.table.t_hatti$views$table39125.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39125.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39125";

hatti.views.table.t_hatti$views$table39125.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39125");
});

hatti.views.table.__GT_t_hatti$views$table39125 = (function hatti$views$table$__GT_t_hatti$views$table39125(cursor__$1,owner__$1,meta39126){
return (new hatti.views.table.t_hatti$views$table39125(cursor__$1,owner__$1,meta39126));
});

}

return (new hatti.views.table.t_hatti$views$table39125(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39142 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39142__$1 = ((((!((map__39142 == null)))?((((map__39142.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39142.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39142):map__39142);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39142__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39143 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39143,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39143,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39148,owner,p__39149){
var map__39150 = p__39148;
var map__39150__$1 = ((((!((map__39150 == null)))?((((map__39150.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39150.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39150):map__39150);
var cursor = map__39150__$1;
var map__39151 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39150__$1,cljs.core.cst$kw$views);
var map__39151__$1 = ((((!((map__39151 == null)))?((((map__39151.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39151.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39151):map__39151);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39151__$1,cljs.core.cst$kw$active);
var map__39152 = p__39149;
var map__39152__$1 = ((((!((map__39152 == null)))?((((map__39152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39152):map__39152);
var opts = map__39152__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39152__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39156 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39156 = (function (map__39152,owner,active_QMARK_,map__39150,slick_grid_event_handlers,p__39148,cursor,map__39151,active,opts,p__39149,meta39157){
this.map__39152 = map__39152;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.map__39150 = map__39150;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.p__39148 = p__39148;
this.cursor = cursor;
this.map__39151 = map__39151;
this.active = active;
this.opts = opts;
this.p__39149 = p__39149;
this.meta39157 = meta39157;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39156.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_39158,meta39157__$1){
var self__ = this;
var _39158__$1 = this;
return (new hatti.views.table.t_hatti$views$table39156(self__.map__39152,self__.owner,self__.active_QMARK_,self__.map__39150,self__.slick_grid_event_handlers,self__.p__39148,self__.cursor,self__.map__39151,self__.active,self__.opts,self__.p__39149,meta39157__$1));
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_39158){
var self__ = this;
var _39158__$1 = this;
return self__.meta39157;
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_,p__39159){
var self__ = this;
var map__39160 = p__39159;
var map__39160__$1 = ((((!((map__39160 == null)))?((((map__39160.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39160.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39160):map__39160);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39160__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39162 = self__.cursor;
var map__39162__$1 = ((((!((map__39162 == null)))?((((map__39162.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39162.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39162):map__39162);
var map__39163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39162__$1,cljs.core.cst$kw$table_DASH_page);
var map__39163__$1 = ((((!((map__39163 == null)))?((((map__39163.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39163.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39163):map__39163);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39163__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39162__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39162__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39164 = dataset_info;
var map__39164__$1 = ((((!((map__39164 == null)))?((((map__39164.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39164.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39164):map__39164);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39164__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39162,map__39162__$1,map__39163,map__39163__$1,submission_clicked,data,dataset_info,map__39164,map__39164__$1,num_of_submissions,no_data_QMARK_,___$1,map__39160,map__39160__$1,table_view_height,active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (p1__39147_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39147_SHARP_], 0));
});})(map__39162,map__39162__$1,map__39163,map__39163__$1,submission_clicked,data,dataset_info,map__39164,map__39164__$1,num_of_submissions,no_data_QMARK_,___$1,map__39160,map__39160__$1,table_view_height,active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$table_DASH_view_DASH_height], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height()));

if(cljs.core.truth_(self__.active_QMARK_)){
var G__39168 = ({"style": ({"overflow": "initial"}), "className": "table-view"});
var G__39169 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39170 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39171 = (function (){var G__39172 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39173 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39178 = ({"className": "alert alert-warning"});
var G__39179 = "No data";
return React.DOM.p(G__39178,G__39179);
})():(function (){var G__39180 = null;
var G__39181 = (function (){var G__39183 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39183);
})();
var G__39182 = "Loading...";
return React.DOM.span(G__39180,G__39181,G__39182);
})());
return React.DOM.div(G__39172,G__39173);
})();
return React.DOM.div(G__39168,G__39169,G__39170,G__39171);
} else {
return null;
}
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39184 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39184,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39184,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39156.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39187 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39187__$1 = ((((!((map__39187 == null)))?((((map__39187.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39187.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39187):map__39187);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39187__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39187__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39189 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39189,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39189,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js((function (){var G__39192 = new_data;
if(cljs.core.truth_(cljs.core.cst$kw$submission_DASH_review_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))))){
return hatti.views.table.replace_review_num_status_with_text_status(G__39192);
} else {
return G__39192;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.getBasis = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$map__39152,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$map__39150,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$p__39148,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__39151,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$p__39149,cljs.core.cst$sym$meta39157], null);
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39156.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39156.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39156";

hatti.views.table.t_hatti$views$table39156.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39156");
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39156 = ((function (active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39156(map__39152__$2,owner__$1,active_QMARK___$1,map__39150__$2,slick_grid_event_handlers__$1,p__39148__$1,cursor__$1,map__39151__$2,active__$1,opts__$1,p__39149__$1,meta39157){
return (new hatti.views.table.t_hatti$views$table39156(map__39152__$2,owner__$1,active_QMARK___$1,map__39150__$2,slick_grid_event_handlers__$1,p__39148__$1,cursor__$1,map__39151__$2,active__$1,opts__$1,p__39149__$1,meta39157));
});})(active_QMARK_,map__39150,map__39150__$1,cursor,map__39151,map__39151__$1,active,map__39152,map__39152__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39156(map__39152__$1,owner,active_QMARK_,map__39150__$1,slick_grid_event_handlers,p__39148,cursor,map__39151__$1,active,opts,p__39149,cljs.core.PersistentArrayMap.EMPTY));
}));
