// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('inflections.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('no.en.core');
/**
 * Coerce the string `s` to the type of `obj`.
 */
inflections.core.coerce = (function inflections$core$coerce(obj,s){
if((obj instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(s);
} else {
if((obj instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(s);
} else {
return s;

}
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
inflections.core.Rule = (function (pattern,replacement,__meta,__extmap,__hash){
this.pattern = pattern;
this.replacement = replacement;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k38316,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__38318 = (((k38316 instanceof cljs.core.Keyword))?k38316.fqn:null);
switch (G__38318) {
case "pattern":
return self__.pattern;

break;
case "replacement":
return self__.replacement;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38316,else__7034__auto__);

}
});

inflections.core.Rule.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#inflections.core.Rule{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pattern,self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$replacement,self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IIterable$ = true;

inflections.core.Rule.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38315){
var self__ = this;
var G__38315__$1 = this;
return (new cljs.core.RecordIter((0),G__38315__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pattern,cljs.core.cst$kw$replacement], null),cljs.core._iterator(self__.__extmap)));
});

inflections.core.Rule.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

inflections.core.Rule.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

inflections.core.Rule.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

inflections.core.Rule.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$replacement,null,cljs.core.cst$kw$pattern,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

inflections.core.Rule.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__38315){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__38319 = cljs.core.keyword_identical_QMARK_;
var expr__38320 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__38322 = cljs.core.cst$kw$pattern;
var G__38323 = expr__38320;
return (pred__38319.cljs$core$IFn$_invoke$arity$2 ? pred__38319.cljs$core$IFn$_invoke$arity$2(G__38322,G__38323) : pred__38319.call(null,G__38322,G__38323));
})())){
return (new inflections.core.Rule(G__38315,self__.replacement,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38324 = cljs.core.cst$kw$replacement;
var G__38325 = expr__38320;
return (pred__38319.cljs$core$IFn$_invoke$arity$2 ? pred__38319.cljs$core$IFn$_invoke$arity$2(G__38324,G__38325) : pred__38319.call(null,G__38324,G__38325));
})())){
return (new inflections.core.Rule(self__.pattern,G__38315,self__.__meta,self__.__extmap,null));
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__38315),null));
}
}
});

inflections.core.Rule.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pattern,self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$replacement,self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__38315){
var self__ = this;
var this__7030__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,G__38315,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

inflections.core.Rule.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pattern,cljs.core.cst$sym$replacement], null);
});

inflections.core.Rule.cljs$lang$type = true;

inflections.core.Rule.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"inflections.core/Rule");
});

inflections.core.Rule.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"inflections.core/Rule");
});

inflections.core.__GT_Rule = (function inflections$core$__GT_Rule(pattern,replacement){
return (new inflections.core.Rule(pattern,replacement,null,null,null));
});

inflections.core.map__GT_Rule = (function inflections$core$map__GT_Rule(G__38317){
return (new inflections.core.Rule(cljs.core.cst$kw$pattern.cljs$core$IFn$_invoke$arity$1(G__38317),cljs.core.cst$kw$replacement.cljs$core$IFn$_invoke$arity$1(G__38317),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38317,cljs.core.cst$kw$pattern,cljs.core.array_seq([cljs.core.cst$kw$replacement], 0)),null));
});

inflections.core.add_rule_BANG_ = (function inflections$core$add_rule_BANG_(rules,rule){
if(!(cljs.core.contains_QMARK_(cljs.core.set((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(rules) : cljs.core.deref.call(null,rules))),rule))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(rules,cljs.core.conj,rule);
} else {
return null;
}
});
/**
 * Returns a seq of rules, where the pattern and replacement must be
 *   given in pairs of two elements.
 */
inflections.core.slurp_rules = (function inflections$core$slurp_rules(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38329 = arguments.length;
var i__7485__auto___38330 = (0);
while(true){
if((i__7485__auto___38330 < len__7484__auto___38329)){
args__7491__auto__.push((arguments[i__7485__auto___38330]));

var G__38331 = (i__7485__auto___38330 + (1));
i__7485__auto___38330 = G__38331;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38327_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.__GT_Rule,p1__38327_SHARP_);
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),patterns_and_replacements));
});

inflections.core.slurp_rules.cljs$lang$maxFixedArity = (0);

inflections.core.slurp_rules.cljs$lang$applyTo = (function (seq38328){
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38328));
});

inflections.core.resolve_rule = (function inflections$core$resolve_rule(rule,word){
if(cljs.core.truth_((function (){var and__6397__auto__ = rule;
if(cljs.core.truth_(and__6397__auto__)){
return word;
} else {
return and__6397__auto__;
}
})())){
var pattern = cljs.core.cst$kw$pattern.cljs$core$IFn$_invoke$arity$1(rule);
var replacement = cljs.core.cst$kw$replacement.cljs$core$IFn$_invoke$arity$1(rule);
if(cljs.core.truth_(cljs.core.re_find(pattern,word))){
return clojure.string.replace(word,pattern,replacement);
} else {
return null;
}
} else {
return null;
}
});
inflections.core.resolve_rules = (function inflections$core$resolve_rules(rules,word){
return cljs.core.first(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__38332_SHARP_){
return inflections.core.resolve_rule(p1__38332_SHARP_,word);
}),rules));
});
/**
 * Resets the list of plural rules.
 */
inflections.core.reset_rules_BANG_ = (function inflections$core$reset_rules_BANG_(rules){
var G__38335 = rules;
var G__38336 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__38335,G__38336) : cljs.core.reset_BANG_.call(null,G__38335,G__38336));
});
/**
 * Same as `clojure.core/name`, but keeps the namespace for keywords
 *   and symbols.
 */
inflections.core.str_name = (function inflections$core$str_name(x){
if((x == null)){
return x;
} else {
if(typeof x === 'string'){
return x;
} else {
if(((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol))){
var temp__4655__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(cljs.core.name(x))].join('');
} else {
return cljs.core.name(x);
}
} else {
return null;
}
}
}
});
inflections.core._STAR_uncountable_words_STAR_ = (function (){var G__38337 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 81, ["gossip",null,"sadness",null,"space",null,"happiness",null,"blood",null,"silver",null,"cotton",null,"species",null,"mist",null,"paper",null,"education",null,"wine",null,"up",null,"food",null,"sugar",null,"gold",null,"literature",null,"pork",null,"lightning",null,"sheep",null,"shopping",null,"fresh",null,"news",null,"pepper",null,"experience",null,"milk",null,"honey",null,"oxygen",null,"fiction",null,"luck",null,"vinegar",null,"coffee",null,"ground",null,"peanut",null,"confusion",null,"tennis",null,"power",null,"meat",null,"butter",null,"music",null,"luggage",null,"love",null,"grass",null,"knowledge",null,"time",null,"cheese",null,"jam",null,"thunder",null,"electricity",null,"gum",null,"sunshine",null,"history",null,"snow",null,"money",null,"wool",null,"rice",null,"series",null,"liquid",null,"equipment",null,"pressure",null,"oil",null,"information",null,"steam",null,"chewing",null,"petrol",null,"research",null,"patience",null,"toothpaste",null,"speed",null,"entertainment",null,"wood",null,"tea",null,"art",null,"washing",null,"forgiveness",null,"traffic",null,"alcohol",null,"ice",null,"homework",null,"fish",null,"air",null], null), null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38337) : cljs.core.atom.call(null,G__38337));
})();
inflections.core._STAR_acronyms_STAR_ = (function (){var G__38338 = new cljs.core.PersistentArrayMap(null, 2, ["hst","HST","nasa","NASA"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38338) : cljs.core.atom.call(null,G__38338));
})();
/**
 * Returns the the acronym for `s` if it is one, otherwise nil.
 */
inflections.core.acronym = (function inflections$core$acronym(s){
if(cljs.core.truth_(s)){
var G__38340 = inflections.core.str_name(s);
var G__38340__$1 = (((G__38340 == null))?null:clojure.string.lower_case(G__38340));
var G__38340__$2 = (((G__38340__$1 == null))?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_acronyms_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_acronyms_STAR_)),G__38340__$1));
if((G__38340__$2 == null)){
return null;
} else {
return inflections.core.coerce(s,G__38340__$2);
}
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*acronyms*`.
 */
inflections.core.add_acronym_BANG_ = (function inflections$core$add_acronym_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inflections.core._STAR_acronyms_STAR_,cljs.core.assoc,clojure.string.lower_case(inflections.core.str_name(word)),inflections.core.str_name(word));
});
/**
 * Delete `word` from the set of `*acronyms*`.
 */
inflections.core.delete_acronym_BANG_ = (function inflections$core$delete_acronym_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_acronyms_STAR_,cljs.core.dissoc,clojure.string.lower_case(inflections.core.str_name(word)));
});
/**
 * Returns true if `s` is countable, otherwise false.
 */
inflections.core.countable_QMARK_ = (function inflections$core$countable_QMARK_(s){
if(cljs.core.truth_(s)){
return !(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_uncountable_words_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_uncountable_words_STAR_)),clojure.string.lower_case(inflections.core.str_name(s))));
} else {
return null;
}
});
/**
 * Returns true if `x` is uncountable, otherwise false.
 */
inflections.core.uncountable_QMARK_ = (function inflections$core$uncountable_QMARK_(x){
if(cljs.core.truth_(x)){
return cljs.core.not(inflections.core.countable_QMARK_(x));
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*uncountable-words*`.
 */
inflections.core.add_uncountable_BANG_ = (function inflections$core$add_uncountable_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_uncountable_words_STAR_,cljs.core.conj,clojure.string.lower_case(inflections.core.str_name(word)));
});
/**
 * Delete `word` from the set of `*uncountable-words*`.
 */
inflections.core.delete_uncountable_BANG_ = (function inflections$core$delete_uncountable_BANG_(word){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_uncountable_words_STAR_,cljs.core.disj,clojure.string.lower_case(inflections.core.str_name(word)));
});
inflections.core._STAR_plural_rules_STAR_ = (function (){var G__38341 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38341) : cljs.core.atom.call(null,G__38341));
})();
/**
 * Returns the plural of s.
 */
inflections.core.plural = (function inflections$core$plural(s){
var s__$1 = inflections.core.str_name(s);
if(cljs.core.truth_((function (){var or__6409__auto__ = clojure.string.blank_QMARK_(s__$1);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return inflections.core.uncountable_QMARK_(s__$1);
}
})())){
return s__$1;
} else {
return inflections.core.resolve_rules(cljs.core.rseq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_plural_rules_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_plural_rules_STAR_))),s__$1);
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (plural! #"$(?i)" "s")
 *          (plural! #"(ax|test)is$(?i)" "$1es"
 *                   #"(octop|vir)us$(?i)" "$1i")
 */
inflections.core.plural_BANG_ = (function inflections$core$plural_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38347 = arguments.length;
var i__7485__auto___38348 = (0);
while(true){
if((i__7485__auto___38348 < len__7484__auto___38347)){
args__7491__auto__.push((arguments[i__7485__auto___38348]));

var G__38349 = (i__7485__auto___38348 + (1));
i__7485__auto___38348 = G__38349;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__38343 = cljs.core.seq(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.slurp_rules,patterns_and_replacements));
var chunk__38344 = null;
var count__38345 = (0);
var i__38346 = (0);
while(true){
if((i__38346 < count__38345)){
var rule = chunk__38344.cljs$core$IIndexed$_nth$arity$2(null,i__38346);
inflections.core.add_rule_BANG_(inflections.core._STAR_plural_rules_STAR_,rule);

var G__38350 = seq__38343;
var G__38351 = chunk__38344;
var G__38352 = count__38345;
var G__38353 = (i__38346 + (1));
seq__38343 = G__38350;
chunk__38344 = G__38351;
count__38345 = G__38352;
i__38346 = G__38353;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38343);
if(temp__4657__auto__){
var seq__38343__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38343__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38343__$1);
var G__38354 = cljs.core.chunk_rest(seq__38343__$1);
var G__38355 = c__7220__auto__;
var G__38356 = cljs.core.count(c__7220__auto__);
var G__38357 = (0);
seq__38343 = G__38354;
chunk__38344 = G__38355;
count__38345 = G__38356;
i__38346 = G__38357;
continue;
} else {
var rule = cljs.core.first(seq__38343__$1);
inflections.core.add_rule_BANG_(inflections.core._STAR_plural_rules_STAR_,rule);

var G__38358 = cljs.core.next(seq__38343__$1);
var G__38359 = null;
var G__38360 = (0);
var G__38361 = (0);
seq__38343 = G__38358;
chunk__38344 = G__38359;
count__38345 = G__38360;
i__38346 = G__38361;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.plural_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.plural_BANG_.cljs$lang$applyTo = (function (seq38342){
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38342));
});

inflections.core.init_plural_rules_BANG_ = (function inflections$core$init_plural_rules_BANG_(){
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([/$/i,"s",/s$/i,"s",/(ax|test)is$/i,"$1es",/(octop|vir)us$/i,"$1i",/(alias|status)$/i,"$1es",/(bu)s$/i,"$1ses",/(buffal|tomat)o$/i,"$1oes",/([ti])um$/i,"$1a",/sis$/i,"ses",/(?:([^f])fe|([lr])f)$/i,"$1$2ves",/(hive)$/i,"$1s",/([^aeiouy]|qu)y$/i,"$1ies",/(x|ch|ss|sh)$/i,"$1es",/(matr|vert|ind)(?:ix|ex)$/i,"$1ices",/([m|l])ouse$/i,"$1ice",/^(ox)$/i,"$1en",/(quiz)$/i,"$1zes"], 0));
});
inflections.core._STAR_singular_rules_STAR_ = (function (){var G__38362 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38362) : cljs.core.atom.call(null,G__38362));
})();
/**
 * Returns the singular of s.
 */
inflections.core.singular = (function inflections$core$singular(s){
var s_SINGLEQUOTE_ = inflections.core.str_name(s);
if(cljs.core.not(inflections.core.uncountable_QMARK_(s_SINGLEQUOTE_))){
return inflections.core.coerce(s,(function (){var or__6409__auto__ = inflections.core.resolve_rules(cljs.core.rseq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_singular_rules_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_singular_rules_STAR_))),s_SINGLEQUOTE_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return s_SINGLEQUOTE_;
}
})());
} else {
return s;
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (singular! #"(n)ews$(?i)" "$1ews")
 *          (singular! #"(m)ovies$(?i)" "$1ovie"
 *                     #"([m|l])ice$(?i)" "$1ouse")
 */
inflections.core.singular_BANG_ = (function inflections$core$singular_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38368 = arguments.length;
var i__7485__auto___38369 = (0);
while(true){
if((i__7485__auto___38369 < len__7484__auto___38368)){
args__7491__auto__.push((arguments[i__7485__auto___38369]));

var G__38370 = (i__7485__auto___38369 + (1));
i__7485__auto___38369 = G__38370;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__38364 = cljs.core.seq(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(inflections.core.slurp_rules,patterns_and_replacements));
var chunk__38365 = null;
var count__38366 = (0);
var i__38367 = (0);
while(true){
if((i__38367 < count__38366)){
var rule = chunk__38365.cljs$core$IIndexed$_nth$arity$2(null,i__38367);
inflections.core.add_rule_BANG_(inflections.core._STAR_singular_rules_STAR_,rule);

var G__38371 = seq__38364;
var G__38372 = chunk__38365;
var G__38373 = count__38366;
var G__38374 = (i__38367 + (1));
seq__38364 = G__38371;
chunk__38365 = G__38372;
count__38366 = G__38373;
i__38367 = G__38374;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38364);
if(temp__4657__auto__){
var seq__38364__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38364__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38364__$1);
var G__38375 = cljs.core.chunk_rest(seq__38364__$1);
var G__38376 = c__7220__auto__;
var G__38377 = cljs.core.count(c__7220__auto__);
var G__38378 = (0);
seq__38364 = G__38375;
chunk__38365 = G__38376;
count__38366 = G__38377;
i__38367 = G__38378;
continue;
} else {
var rule = cljs.core.first(seq__38364__$1);
inflections.core.add_rule_BANG_(inflections.core._STAR_singular_rules_STAR_,rule);

var G__38379 = cljs.core.next(seq__38364__$1);
var G__38380 = null;
var G__38381 = (0);
var G__38382 = (0);
seq__38364 = G__38379;
chunk__38365 = G__38380;
count__38366 = G__38381;
i__38367 = G__38382;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.singular_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.singular_BANG_.cljs$lang$applyTo = (function (seq38363){
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38363));
});

inflections.core.init_singular_rules_BANG_ = (function inflections$core$init_singular_rules_BANG_(){
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([/s$/i,"",/(ss)$/i,"$1",/(n)ews$/i,"$1ews",/([ti])a$/i,"$1um",/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(sis|ses)$/i,"$1$2sis",/(^analy)(sis|ses)$/i,"$1sis",/([^f])ves$/i,"$1fe",/(hive)s$/i,"$1",/(tive)s$/i,"$1",/([lr])ves$/i,"$1f",/([^aeiouy]|qu)ies$/i,"$1y",/(s)eries$/i,"$1eries",/(m)ovies$/i,"$1ovie",/(x|ch|ss|sh)es$/i,"$1",/([m|l])ice$/i,"$1ouse",/(bus)(es)?$/i,"$1",/(o)es$/i,"$1",/(shoe)s$/i,"$1",/(cris|ax|test)(is|es)$/i,"$1is",/(octop|vir)(us|i)$/i,"$1us",/(alias|status)(es)?$/i,"$1",/^(ox)en/i,"$1",/(vert|ind)ices$/i,"$1ex",/(matr)ices$/i,"$1ix",/(quiz)zes$/i,"$1",/(database)s$/i,"$1"], 0));
});
inflections.core._STAR_irregular_words_STAR_ = (function (){var G__38383 = cljs.core.sorted_set();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38383) : cljs.core.atom.call(null,G__38383));
})();
/**
 * Returns true if `word` is an irregular word, otherwise false.
 */
inflections.core.irregular_QMARK_ = (function inflections$core$irregular_QMARK_(word){
if(cljs.core.truth_(word)){
return cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inflections.core._STAR_irregular_words_STAR_) : cljs.core.deref.call(null,inflections.core._STAR_irregular_words_STAR_)),clojure.string.lower_case(inflections.core.str_name(word)));
} else {
return null;
}
});
/**
 * Add `singular` and `plural` to the set of `*irregular-words*`.
 */
inflections.core.add_irregular_BANG_ = (function inflections$core$add_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case(inflections.core.str_name(singular));
var plural__$1 = clojure.string.lower_case(inflections.core.str_name(plural));
inflections.core.delete_uncountable_BANG_(singular__$1);

inflections.core.delete_uncountable_BANG_(plural__$1);

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.re_pattern([cljs.core.str("^"),cljs.core.str(plural__$1),cljs.core.str("$")].join('')),singular__$1], 0));

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.re_pattern([cljs.core.str("^"),cljs.core.str(singular__$1),cljs.core.str("$")].join('')),plural__$1], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,singular__$1);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,plural__$1);
});
/**
 * Delete `singular` and `plural` from the set of *irregular-words*.
 */
inflections.core.delete_irregular_BANG_ = (function inflections$core$delete_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case(inflections.core.str_name(singular));
var plural__$1 = clojure.string.lower_case(inflections.core.str_name(plural));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,singular__$1);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,plural__$1);
});
inflections.core.init_irregular_words_BANG_ = (function inflections$core$init_irregular_words_BANG_(){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38384_SHARP_){
return inflections.core.add_irregular_BANG_(cljs.core.first(p1__38384_SHARP_),cljs.core.second(p1__38384_SHARP_));
}),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["amenity","amenities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["child","children"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cow","kine"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["foot","feet"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["louse","lice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mailman","mailmen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["man","men"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mouse","mice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["move","moves"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ox","oxen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["person","people"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["sex","sexes"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tooth","teeth"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["woman","women"], null)], null)));
});
/**
 * Convert `word` to camel case. By default, camel-case converts to
 *   UpperCamelCase. If the argument to camel-case is set to :lower then
 *   camel-case produces lowerCamelCase. The camel-case fn will also
 *   convert "/" to "::" which is useful for converting paths to
 *   namespaces.
 * 
 *   Examples:
 * 
 *  (camel-case "active_record")
 *  ;=> "ActiveRecord"
 * 
 *  (camel-case "active_record" :lower)
 *  ;=> "activeRecord"
 * 
 *  (camel-case "active_record/errors")
 *  ;=> "ActiveRecord::Errors"
 * 
 *  (camel-case "active_record/errors" :lower)
 *  ;=> "activeRecord::Errors"
 */
inflections.core.camel_case = (function inflections$core$camel_case(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38398 = arguments.length;
var i__7485__auto___38399 = (0);
while(true){
if((i__7485__auto___38399 < len__7484__auto___38398)){
args__7491__auto__.push((arguments[i__7485__auto___38399]));

var G__38400 = (i__7485__auto___38399 + (1));
i__7485__auto___38399 = G__38400;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic = (function (word,p__38390){
var vec__38391 = p__38390;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38391,(0),null);
if(cljs.core.truth_(word)){
return inflections.core.coerce(word,(function (){var word__$1 = inflections.core.str_name(word);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$lower)){
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(word__$1,cljs.core.array_seq([clojure.string.lower_case], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$upper)){
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(word__$1,cljs.core.array_seq([clojure.string.upper_case], 0));
} else {
if(cljs.core.fn_QMARK_(mode)){
return [cljs.core.str((function (){var G__38394 = [cljs.core.str(cljs.core.first(word__$1))].join('');
return (mode.cljs$core$IFn$_invoke$arity$1 ? mode.cljs$core$IFn$_invoke$arity$1(G__38394) : mode.call(null,G__38394));
})()),cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.rest(inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(word__$1,cljs.core.array_seq([null], 0)))))].join('');
} else {
return clojure.string.replace(clojure.string.replace(word__$1,/\/(.?)/,((function (word__$1,vec__38391,mode){
return (function (p1__38385_SHARP_){
return [cljs.core.str("::"),cljs.core.str(clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__38385_SHARP_,(1))))].join('');
});})(word__$1,vec__38391,mode))
),/(^|_|-)(.)/,((function (word__$1,vec__38391,mode){
return (function (p1__38387_SHARP_){
var vec__38395 = p1__38387_SHARP_;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38395,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38395,(1),null);
var letter_to_uppercase = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38395,(2),null);
return clojure.string.upper_case(letter_to_uppercase);
});})(word__$1,vec__38391,mode))
);

}
}
}
})());
} else {
return null;
}
});

inflections.core.camel_case.cljs$lang$maxFixedArity = (1);

inflections.core.camel_case.cljs$lang$applyTo = (function (seq38388){
var G__38389 = cljs.core.first(seq38388);
var seq38388__$1 = cljs.core.next(seq38388);
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(G__38389,seq38388__$1);
});

/**
 * Convert the first letter in `word` to upper case.
 * 
 *   Examples:
 * 
 *  (capitalize "hello")
 *  ;=> "Hello"
 * 
 *  (capitalize "HELLO")
 *  ;=> "Hello"
 * 
 *  (capitalize "abc123")
 *  ;=> "Abc123"
 */
inflections.core.capitalize = (function inflections$core$capitalize(word){
if(cljs.core.truth_(word)){
var temp__4655__auto__ = inflections.core.acronym(word);
if(cljs.core.truth_(temp__4655__auto__)){
var acronym = temp__4655__auto__;
return acronym;
} else {
var word_SINGLEQUOTE_ = inflections.core.str_name(word);
return inflections.core.coerce(word,[cljs.core.str(clojure.string.upper_case([cljs.core.str(cljs.core.first(word_SINGLEQUOTE_))].join(''))),cljs.core.str(((cljs.core.next(word_SINGLEQUOTE_))?clojure.string.lower_case(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(word_SINGLEQUOTE_,(1))):null))].join(''));
}
} else {
return null;
}
});
/**
 * Convert `s` into a title.
 */
inflections.core.titleize = (function inflections$core$titleize(s){
if(cljs.core.truth_(s)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(inflections.core.capitalize,clojure.string.split.cljs$core$IFn$_invoke$arity$2(inflections.core.str_name(s),/[-_.\/ ]/)));
} else {
return null;
}
});
/**
 * Replaces all underscores in `s` with dashes.
 * 
 *   Examples:
 * 
 *  (dasherize "puni_puni")
 *  ;=> "puni-puni"
 */
inflections.core.dasherize = (function inflections$core$dasherize(s){
if(cljs.core.truth_(s)){
return inflections.core.coerce(s,clojure.string.replace(inflections.core.str_name(s),/_/,"-"));
} else {
return null;
}
});
/**
 * Removes the module part from `x`.
 * 
 *   Examples:
 * 
 *  (demodulize "inflections.MyRecord")
 *  ;=> "MyRecord"
 * 
 *  (demodulize "ActiveRecord::CoreExtensions::String::Inflections")
 *  ;=> "Inflections"
 * 
 *  (demodulize "Inflections")
 *  ;=> "Inflections"
 */
inflections.core.demodulize = (function inflections$core$demodulize(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce(x,clojure.string.replace(inflections.core.str_name(x),/^.*(::|\.)/,""));
} else {
return null;
}
});
/**
 * Hyphenate x, which is the same as threading `x` through the str,
 *   underscore and dasherize fns.
 * 
 *   Examples:
 * 
 *  (hyphenate 'Continent)
 *  ; => "continent"
 * 
 *  (hyphenate "CountryFlag")
 *  ; => "country-flag"
 */
inflections.core.hyphenate = (function inflections$core$hyphenate(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce(x,clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(inflections.core.str_name(x),/::/,"/"),/([A-Z]+)([A-Z][a-z])/,"$1-$2"),/([a-z\d])([A-Z])/,"$1-$2"),/\s+/,"-"),/_/,"-")));
} else {
return null;
}
});
/**
 * Turns `x` into an ordinal string used to denote the position in an
 *   ordered sequence such as 1st, 2nd, 3rd, 4th, etc.
 * 
 *   Examples:
 * 
 *  (ordinalize "1")
 *  ;=> "1st"
 * 
 *  (ordinalize "23")
 *  ;=> "23rd"
 */
inflections.core.ordinalize = (function inflections$core$ordinalize(x){
var temp__4655__auto__ = no.en.core.parse_integer(x);
if(cljs.core.truth_(temp__4655__auto__)){
var number = temp__4655__auto__;
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.range.cljs$core$IFn$_invoke$arity$2((11),(14))),cljs.core.mod(number,(100)))){
return [cljs.core.str(number),cljs.core.str("th")].join('');
} else {
var modulus = cljs.core.mod(number,(10));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(1))){
return [cljs.core.str(number),cljs.core.str("st")].join('');
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(2))){
return [cljs.core.str(number),cljs.core.str("nd")].join('');
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(modulus,(3))){
return [cljs.core.str(number),cljs.core.str("rd")].join('');
} else {
return [cljs.core.str(number),cljs.core.str("th")].join('');

}
}
}
}
} else {
return null;
}
});
/**
 * Replaces special characters in `x` with the default separator
 *   "-". so that it may be used as part of a pretty URL.
 * 
 *   Examples:
 * 
 *  (parameterize "Donald E. Knuth")
 *  ; => "donald-e-knuth"
 * 
 *  (parameterize "Donald E. Knuth" "_")
 *  ; => "donald_e_knuth"
 */
inflections.core.parameterize = (function inflections$core$parameterize(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38407 = arguments.length;
var i__7485__auto___38408 = (0);
while(true){
if((i__7485__auto___38408 < len__7484__auto___38407)){
args__7491__auto__.push((arguments[i__7485__auto___38408]));

var G__38409 = (i__7485__auto___38408 + (1));
i__7485__auto___38408 = G__38409;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__38403){
var vec__38404 = p__38403;
var sep = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38404,(0),null);
if(cljs.core.truth_(x)){
var sep__$1 = (function (){var or__6409__auto__ = sep;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return "-";
}
})();
return clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(inflections.core.str_name(x),/[^A-Za-z0-9]+/,sep__$1),/\++/,sep__$1),cljs.core.re_pattern([cljs.core.str(sep__$1),cljs.core.str("{2,}")].join('')),sep__$1),cljs.core.re_pattern([cljs.core.str("(?i)(^"),cljs.core.str(sep__$1),cljs.core.str(")|("),cljs.core.str(sep__$1),cljs.core.str("$)")].join('')),""));
} else {
return null;
}
});

inflections.core.parameterize.cljs$lang$maxFixedArity = (1);

inflections.core.parameterize.cljs$lang$applyTo = (function (seq38401){
var G__38402 = cljs.core.first(seq38401);
var seq38401__$1 = cljs.core.next(seq38401);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic(G__38402,seq38401__$1);
});

/**
 * Attempts to pluralize the word unless count is 1. If plural is
 *   supplied, it will use that when count is > 1, otherwise it will use
 *   the inflector to determine the plural form.
 */
inflections.core.pluralize = (function inflections$core$pluralize(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38417 = arguments.length;
var i__7485__auto___38418 = (0);
while(true){
if((i__7485__auto___38418 < len__7484__auto___38417)){
args__7491__auto__.push((arguments[i__7485__auto___38418]));

var G__38419 = (i__7485__auto___38418 + (1));
i__7485__auto___38418 = G__38419;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic = (function (count,singular,p__38413){
var vec__38414 = p__38413;
var plural = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38414,(0),null);
return [cljs.core.str(count),cljs.core.str(" "),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),count))?singular:(function (){var or__6409__auto__ = plural;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return inflections.core.plural(singular);
}
})()))].join('');
});

inflections.core.pluralize.cljs$lang$maxFixedArity = (2);

inflections.core.pluralize.cljs$lang$applyTo = (function (seq38410){
var G__38411 = cljs.core.first(seq38410);
var seq38410__$1 = cljs.core.next(seq38410);
var G__38412 = cljs.core.first(seq38410__$1);
var seq38410__$2 = cljs.core.next(seq38410__$1);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic(G__38411,G__38412,seq38410__$2);
});

/**
 * The reverse of camel-case. Makes an underscored, lowercase form from
 *   the expression in the string. Changes "::" to "/" to convert
 *   namespaces to paths.
 * 
 *   Examples:
 * 
 *  (underscore "ActiveRecord")
 *  ;=> "active_record"
 * 
 *  (underscore "ActiveRecord::Errors")
 *  ;=> "active_record/errors"
 */
inflections.core.underscore = (function inflections$core$underscore(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce(x,clojure.string.lower_case(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(inflections.core.str_name(x),/::/,"/"),/([A-Z\d]+)([A-Z][a-z])/,"$1_$2"),/([a-z\d])([A-Z])/,"$1_$2"),/-/,"_")));
} else {
return null;
}
});
/**
 * Converts `x` into a foreign key. The default separator "_" is
 *   placed between the name and "id".
 * 
 * 
 *   Examples:
 * 
 *  (foreign-key "Message")
 *  ;=> "message_id"
 * 
 *  (foreign-key "Message" false)
 *  ;=> "messageid"
 * 
 *  (foreign-key "Admin::Post")
 *  ;=> "post_id"
 */
inflections.core.foreign_key = (function inflections$core$foreign_key(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38426 = arguments.length;
var i__7485__auto___38427 = (0);
while(true){
if((i__7485__auto___38427 < len__7484__auto___38426)){
args__7491__auto__.push((arguments[i__7485__auto___38427]));

var G__38428 = (i__7485__auto___38427 + (1));
i__7485__auto___38427 = G__38428;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__38422){
var vec__38423 = p__38422;
var sep = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38423,(0),null);
var x_SINGLEQUOTE_ = inflections.core.str_name(x);
if(clojure.string.blank_QMARK_(x_SINGLEQUOTE_)){
return null;
} else {
return inflections.core.coerce(x,[cljs.core.str(inflections.core.underscore(inflections.core.hyphenate(inflections.core.singular(inflections.core.demodulize(x_SINGLEQUOTE_))))),cljs.core.str((function (){var or__6409__auto__ = sep;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return "_";
}
})()),cljs.core.str("id")].join(''));
}
});

inflections.core.foreign_key.cljs$lang$maxFixedArity = (1);

inflections.core.foreign_key.cljs$lang$applyTo = (function (seq38420){
var G__38421 = cljs.core.first(seq38420);
var seq38420__$1 = cljs.core.next(seq38420);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic(G__38421,seq38420__$1);
});

/**
 * Recursively transform all keys in the map `m` by applying `f` on them.
 */
inflections.core.transform_keys = (function inflections$core$transform_keys(m,f){
if(cljs.core.map_QMARK_(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (memo,key){
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,key);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(memo,key),(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(key) : f.call(null,key)),((cljs.core.map_QMARK_(value))?inflections$core$transform_keys(value,f):((cljs.core.sequential_QMARK_(value))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (value){
return (function (p1__38429_SHARP_){
return inflections$core$transform_keys(p1__38429_SHARP_,f);
});})(value))
,value):value
)));
}),m,cljs.core.keys(m));
} else {
return m;
}
});
/**
 * Recursively transform all map values of m by applying f on them.
 */
inflections.core.transform_values = (function inflections$core$transform_values(m,f){
if(cljs.core.map_QMARK_(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (memo,key){
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,key);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(memo,key,((cljs.core.map_QMARK_(value))?inflections$core$transform_values(value,f):(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(value) : f.call(null,value))));
}),m,cljs.core.keys(m));
} else {
return m;
}
});
/**
 * Recursively apply camel-case on all keys of m.
 */
inflections.core.camel_case_keys = (function inflections$core$camel_case_keys(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38437 = arguments.length;
var i__7485__auto___38438 = (0);
while(true){
if((i__7485__auto___38438 < len__7484__auto___38437)){
args__7491__auto__.push((arguments[i__7485__auto___38438]));

var G__38439 = (i__7485__auto___38438 + (1));
i__7485__auto___38438 = G__38439;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__38433){
var vec__38434 = p__38433;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38434,(0),null);
return clojure.walk.keywordize_keys(inflections.core.transform_keys(m,((function (vec__38434,mode){
return (function (p1__38430_SHARP_){
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(p1__38430_SHARP_,cljs.core.array_seq([mode], 0));
});})(vec__38434,mode))
));
});

inflections.core.camel_case_keys.cljs$lang$maxFixedArity = (1);

inflections.core.camel_case_keys.cljs$lang$applyTo = (function (seq38431){
var G__38432 = cljs.core.first(seq38431);
var seq38431__$1 = cljs.core.next(seq38431);
return inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic(G__38432,seq38431__$1);
});

/**
 * Recursively apply hyphenate on all keys of m.
 */
inflections.core.hyphenate_keys = (function inflections$core$hyphenate_keys(m){
return inflections.core.transform_keys(m,inflections.core.hyphenate);
});
/**
 * Recursively apply hyphenate on all values of m.
 */
inflections.core.hyphenate_values = (function inflections$core$hyphenate_values(m){
return inflections.core.transform_values(m,inflections.core.hyphenate);
});
/**
 * Recursively transform all keys of m into strings.
 */
inflections.core.stringify_keys = (function inflections$core$stringify_keys(m){
return inflections.core.transform_keys(m,(function (p1__38440_SHARP_){
if((p1__38440_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name(p1__38440_SHARP_);
} else {
return [cljs.core.str(p1__38440_SHARP_)].join('');
}
}));
});
/**
 * Recursively transform all values of m into strings.
 */
inflections.core.stringify_values = (function inflections$core$stringify_values(m){
return inflections.core.transform_values(m,(function (p1__38441_SHARP_){
if((p1__38441_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name(p1__38441_SHARP_);
} else {
return [cljs.core.str(p1__38441_SHARP_)].join('');
}
}));
});
/**
 * Recursively apply underscore on all keys of m.
 */
inflections.core.underscore_keys = (function inflections$core$underscore_keys(m){
return inflections.core.transform_keys(m,inflections.core.underscore);
});
/**
 * Initialize the Inflections library with defaults.
 */
inflections.core.init_inflections_BANG_ = (function inflections$core$init_inflections_BANG_(){
inflections.core.init_plural_rules_BANG_();

inflections.core.init_singular_rules_BANG_();

return inflections.core.init_irregular_words_BANG_();
});
inflections.core.init_inflections_BANG_();
