// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$temp_DASH_token,null,cljs.core.cst$kw$token,null,cljs.core.cst$kw$username,null,cljs.core.cst$kw$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__41557 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$client,"zebra.ona.io",cljs.core.cst$kw$data,"stage-api.ona.io",cljs.core.cst$kw$j2x,"j2x.ona.io",cljs.core.cst$kw$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__41557) : cljs.core.atom.call(null,G__41557));
})();
/**
 * Store customizable timeouts to use in the http libraries. In milliseconds.
 */
milia.utils.remote.timeouts = (function (){var G__41558 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$conn_DASH_timeout,(30000),cljs.core.cst$kw$socket_DASH_timeout,(30000)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__41558) : cljs.core.atom.call(null,G__41558));
})();
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41566 = arguments.length;
var i__7485__auto___41567 = (0);
while(true){
if((i__7485__auto___41567 < len__7484__auto___41566)){
args__7491__auto__.push((arguments[i__7485__auto___41567]));

var G__41568 = (i__7485__auto___41567 + (1));
i__7485__auto___41567 = G__41568;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__41561){
var vec__41562 = p__41561;
var client_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41562,(0),null);
var j2x_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41562,(1),null);
var request_protocol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41562,(2),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(milia.utils.remote.hosts,cljs.core.merge,(function (){var G__41565 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data_host], null);
var G__41565__$1 = ((cljs.core.some_QMARK_(client_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41565,cljs.core.cst$kw$client,client_host):G__41565);
var G__41565__$2 = ((cljs.core.some_QMARK_(j2x_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41565__$1,cljs.core.cst$kw$j2x,j2x_host):G__41565__$1);
if(cljs.core.some_QMARK_(request_protocol)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41565__$2,cljs.core.cst$kw$request_DASH_protocol,request_protocol);
} else {
return G__41565__$2;
}
})());
});

milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq41559){
var G__41560 = cljs.core.first(seq41559);
var seq41559__$1 = cljs.core.next(seq41559);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic(G__41560,seq41559__$1);
});

/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41575 = arguments.length;
var i__7485__auto___41576 = (0);
while(true){
if((i__7485__auto___41576 < len__7484__auto___41575)){
args__7491__auto__.push((arguments[i__7485__auto___41576]));

var G__41577 = (i__7485__auto___41576 + (1));
i__7485__auto___41576 = G__41577;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__41571){
var vec__41572 = p__41571;
var password = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41572,(0),null);
var temp_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41572,(1),null);
var token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41572,(2),null);
return milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$password,password,cljs.core.cst$kw$temp_DASH_token,temp_token,cljs.core.cst$kw$token,token], null);
});

milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq41569){
var G__41570 = cljs.core.first(seq41569);
var seq41569__$1 = cljs.core.next(seq41569);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic(G__41570,seq41569__$1);
});

/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_host = "images.ona.io";
milia.utils.remote.thumbor_server = milia.utils.remote.protocol_prefixed(milia.utils.remote.thumbor_host);
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41579 = arguments.length;
var i__7485__auto___41580 = (0);
while(true){
if((i__7485__auto___41580 < len__7484__auto___41579)){
args__7491__auto__.push((arguments[i__7485__auto___41580]));

var G__41581 = (i__7485__auto___41580 + (1));
i__7485__auto___41580 = G__41581;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq41578){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41578));
});

/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41583 = arguments.length;
var i__7485__auto___41584 = (0);
while(true){
if((i__7485__auto___41584 < len__7484__auto___41583)){
args__7491__auto__.push((arguments[i__7485__auto___41584]));

var G__41585 = (i__7485__auto___41584 + (1));
i__7485__auto___41584 = G__41585;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq41582){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41582));
});

/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41587 = arguments.length;
var i__7485__auto___41588 = (0);
while(true){
if((i__7485__auto___41588 < len__7484__auto___41587)){
args__7491__auto__.push((arguments[i__7485__auto___41588]));

var G__41589 = (i__7485__auto___41588 + (1));
i__7485__auto___41588 = G__41589;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq41586){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41586));
});

/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41591 = arguments.length;
var i__7485__auto___41592 = (0);
while(true){
if((i__7485__auto___41592 < len__7484__auto___41591)){
args__7491__auto__.push((arguments[i__7485__auto___41592]));

var G__41593 = (i__7485__auto___41592 + (1));
i__7485__auto___41592 = G__41593;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq41590){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41590));
});

