// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args13924 = [];
var len__7484__auto___13930 = arguments.length;
var i__7485__auto___13931 = (0);
while(true){
if((i__7485__auto___13931 < len__7484__auto___13930)){
args13924.push((arguments[i__7485__auto___13931]));

var G__13932 = (i__7485__auto___13931 + (1));
i__7485__auto___13931 = G__13932;
continue;
} else {
}
break;
}

var G__13926 = args13924.length;
switch (G__13926) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13924.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async13927 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13927 = (function (f,blockable,meta13928){
this.f = f;
this.blockable = blockable;
this.meta13928 = meta13928;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13929,meta13928__$1){
var self__ = this;
var _13929__$1 = this;
return (new cljs.core.async.t_cljs$core$async13927(self__.f,self__.blockable,meta13928__$1));
});

cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13929){
var self__ = this;
var _13929__$1 = this;
return self__.meta13928;
});

cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async13927.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async13927.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta13928","meta13928",1879014541,null)], null);
});

cljs.core.async.t_cljs$core$async13927.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13927.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13927";

cljs.core.async.t_cljs$core$async13927.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13927");
});

cljs.core.async.__GT_t_cljs$core$async13927 = (function cljs$core$async$__GT_t_cljs$core$async13927(f__$1,blockable__$1,meta13928){
return (new cljs.core.async.t_cljs$core$async13927(f__$1,blockable__$1,meta13928));
});

}

return (new cljs.core.async.t_cljs$core$async13927(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args13936 = [];
var len__7484__auto___13939 = arguments.length;
var i__7485__auto___13940 = (0);
while(true){
if((i__7485__auto___13940 < len__7484__auto___13939)){
args13936.push((arguments[i__7485__auto___13940]));

var G__13941 = (i__7485__auto___13940 + (1));
i__7485__auto___13940 = G__13941;
continue;
} else {
}
break;
}

var G__13938 = args13936.length;
switch (G__13938) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13936.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args13943 = [];
var len__7484__auto___13946 = arguments.length;
var i__7485__auto___13947 = (0);
while(true){
if((i__7485__auto___13947 < len__7484__auto___13946)){
args13943.push((arguments[i__7485__auto___13947]));

var G__13948 = (i__7485__auto___13947 + (1));
i__7485__auto___13947 = G__13948;
continue;
} else {
}
break;
}

var G__13945 = args13943.length;
switch (G__13945) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13943.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args13950 = [];
var len__7484__auto___13953 = arguments.length;
var i__7485__auto___13954 = (0);
while(true){
if((i__7485__auto___13954 < len__7484__auto___13953)){
args13950.push((arguments[i__7485__auto___13954]));

var G__13955 = (i__7485__auto___13954 + (1));
i__7485__auto___13954 = G__13955;
continue;
} else {
}
break;
}

var G__13952 = args13950.length;
switch (G__13952) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13950.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_13957 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_13957);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_13957,ret){
return (function (){
return fn1.call(null,val_13957);
});})(val_13957,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args13958 = [];
var len__7484__auto___13961 = arguments.length;
var i__7485__auto___13962 = (0);
while(true){
if((i__7485__auto___13962 < len__7484__auto___13961)){
args13958.push((arguments[i__7485__auto___13962]));

var G__13963 = (i__7485__auto___13962 + (1));
i__7485__auto___13962 = G__13963;
continue;
} else {
}
break;
}

var G__13960 = args13958.length;
switch (G__13960) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13958.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___13965 = n;
var x_13966 = (0);
while(true){
if((x_13966 < n__7324__auto___13965)){
(a[x_13966] = (0));

var G__13967 = (x_13966 + (1));
x_13966 = G__13967;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__13968 = (i + (1));
i = G__13968;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async13972 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13972 = (function (alt_flag,flag,meta13973){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta13973 = meta13973;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_13974,meta13973__$1){
var self__ = this;
var _13974__$1 = this;
return (new cljs.core.async.t_cljs$core$async13972(self__.alt_flag,self__.flag,meta13973__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_13974){
var self__ = this;
var _13974__$1 = this;
return self__.meta13973;
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13973","meta13973",-1306114200,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async13972.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13972.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13972";

cljs.core.async.t_cljs$core$async13972.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13972");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async13972 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13972(alt_flag__$1,flag__$1,meta13973){
return (new cljs.core.async.t_cljs$core$async13972(alt_flag__$1,flag__$1,meta13973));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async13972(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async13978 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13978 = (function (alt_handler,flag,cb,meta13979){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta13979 = meta13979;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13980,meta13979__$1){
var self__ = this;
var _13980__$1 = this;
return (new cljs.core.async.t_cljs$core$async13978(self__.alt_handler,self__.flag,self__.cb,meta13979__$1));
});

cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13980){
var self__ = this;
var _13980__$1 = this;
return self__.meta13979;
});

cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13978.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async13978.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13979","meta13979",-1696220687,null)], null);
});

cljs.core.async.t_cljs$core$async13978.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13978.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13978";

cljs.core.async.t_cljs$core$async13978.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13978");
});

cljs.core.async.__GT_t_cljs$core$async13978 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13978(alt_handler__$1,flag__$1,cb__$1,meta13979){
return (new cljs.core.async.t_cljs$core$async13978(alt_handler__$1,flag__$1,cb__$1,meta13979));
});

}

return (new cljs.core.async.t_cljs$core$async13978(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13981_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13981_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13982_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13982_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13983 = (i + (1));
i = G__13983;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13989 = arguments.length;
var i__7485__auto___13990 = (0);
while(true){
if((i__7485__auto___13990 < len__7484__auto___13989)){
args__7491__auto__.push((arguments[i__7485__auto___13990]));

var G__13991 = (i__7485__auto___13990 + (1));
i__7485__auto___13990 = G__13991;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13986){
var map__13987 = p__13986;
var map__13987__$1 = ((((!((map__13987 == null)))?((((map__13987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13987):map__13987);
var opts = map__13987__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13984){
var G__13985 = cljs.core.first.call(null,seq13984);
var seq13984__$1 = cljs.core.next.call(null,seq13984);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13985,seq13984__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args13992 = [];
var len__7484__auto___14042 = arguments.length;
var i__7485__auto___14043 = (0);
while(true){
if((i__7485__auto___14043 < len__7484__auto___14042)){
args13992.push((arguments[i__7485__auto___14043]));

var G__14044 = (i__7485__auto___14043 + (1));
i__7485__auto___14043 = G__14044;
continue;
} else {
}
break;
}

var G__13994 = args13992.length;
switch (G__13994) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13992.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13879__auto___14046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___14046){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___14046){
return (function (state_14018){
var state_val_14019 = (state_14018[(1)]);
if((state_val_14019 === (7))){
var inst_14014 = (state_14018[(2)]);
var state_14018__$1 = state_14018;
var statearr_14020_14047 = state_14018__$1;
(statearr_14020_14047[(2)] = inst_14014);

(statearr_14020_14047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (1))){
var state_14018__$1 = state_14018;
var statearr_14021_14048 = state_14018__$1;
(statearr_14021_14048[(2)] = null);

(statearr_14021_14048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (4))){
var inst_13997 = (state_14018[(7)]);
var inst_13997__$1 = (state_14018[(2)]);
var inst_13998 = (inst_13997__$1 == null);
var state_14018__$1 = (function (){var statearr_14022 = state_14018;
(statearr_14022[(7)] = inst_13997__$1);

return statearr_14022;
})();
if(cljs.core.truth_(inst_13998)){
var statearr_14023_14049 = state_14018__$1;
(statearr_14023_14049[(1)] = (5));

} else {
var statearr_14024_14050 = state_14018__$1;
(statearr_14024_14050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (13))){
var state_14018__$1 = state_14018;
var statearr_14025_14051 = state_14018__$1;
(statearr_14025_14051[(2)] = null);

(statearr_14025_14051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (6))){
var inst_13997 = (state_14018[(7)]);
var state_14018__$1 = state_14018;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14018__$1,(11),to,inst_13997);
} else {
if((state_val_14019 === (3))){
var inst_14016 = (state_14018[(2)]);
var state_14018__$1 = state_14018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14018__$1,inst_14016);
} else {
if((state_val_14019 === (12))){
var state_14018__$1 = state_14018;
var statearr_14026_14052 = state_14018__$1;
(statearr_14026_14052[(2)] = null);

(statearr_14026_14052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (2))){
var state_14018__$1 = state_14018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14018__$1,(4),from);
} else {
if((state_val_14019 === (11))){
var inst_14007 = (state_14018[(2)]);
var state_14018__$1 = state_14018;
if(cljs.core.truth_(inst_14007)){
var statearr_14027_14053 = state_14018__$1;
(statearr_14027_14053[(1)] = (12));

} else {
var statearr_14028_14054 = state_14018__$1;
(statearr_14028_14054[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (9))){
var state_14018__$1 = state_14018;
var statearr_14029_14055 = state_14018__$1;
(statearr_14029_14055[(2)] = null);

(statearr_14029_14055[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (5))){
var state_14018__$1 = state_14018;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14030_14056 = state_14018__$1;
(statearr_14030_14056[(1)] = (8));

} else {
var statearr_14031_14057 = state_14018__$1;
(statearr_14031_14057[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (14))){
var inst_14012 = (state_14018[(2)]);
var state_14018__$1 = state_14018;
var statearr_14032_14058 = state_14018__$1;
(statearr_14032_14058[(2)] = inst_14012);

(statearr_14032_14058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (10))){
var inst_14004 = (state_14018[(2)]);
var state_14018__$1 = state_14018;
var statearr_14033_14059 = state_14018__$1;
(statearr_14033_14059[(2)] = inst_14004);

(statearr_14033_14059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14019 === (8))){
var inst_14001 = cljs.core.async.close_BANG_.call(null,to);
var state_14018__$1 = state_14018;
var statearr_14034_14060 = state_14018__$1;
(statearr_14034_14060[(2)] = inst_14001);

(statearr_14034_14060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___14046))
;
return ((function (switch__13767__auto__,c__13879__auto___14046){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_14038 = [null,null,null,null,null,null,null,null];
(statearr_14038[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_14038[(1)] = (1));

return statearr_14038;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_14018){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14039){if((e14039 instanceof Object)){
var ex__13771__auto__ = e14039;
var statearr_14040_14061 = state_14018;
(statearr_14040_14061[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14062 = state_14018;
state_14018 = G__14062;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_14018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_14018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___14046))
})();
var state__13881__auto__ = (function (){var statearr_14041 = f__13880__auto__.call(null);
(statearr_14041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14046);

return statearr_14041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___14046))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__14250){
var vec__14251 = p__14250;
var v = cljs.core.nth.call(null,vec__14251,(0),null);
var p = cljs.core.nth.call(null,vec__14251,(1),null);
var job = vec__14251;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__13879__auto___14437 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results){
return (function (state_14258){
var state_val_14259 = (state_14258[(1)]);
if((state_val_14259 === (1))){
var state_14258__$1 = state_14258;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14258__$1,(2),res,v);
} else {
if((state_val_14259 === (2))){
var inst_14255 = (state_14258[(2)]);
var inst_14256 = cljs.core.async.close_BANG_.call(null,res);
var state_14258__$1 = (function (){var statearr_14260 = state_14258;
(statearr_14260[(7)] = inst_14255);

return statearr_14260;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14258__$1,inst_14256);
} else {
return null;
}
}
});})(c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results))
;
return ((function (switch__13767__auto__,c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_14264 = [null,null,null,null,null,null,null,null];
(statearr_14264[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__);

(statearr_14264[(1)] = (1));

return statearr_14264;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1 = (function (state_14258){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14258);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14265){if((e14265 instanceof Object)){
var ex__13771__auto__ = e14265;
var statearr_14266_14438 = state_14258;
(statearr_14266_14438[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14258);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14439 = state_14258;
state_14258 = G__14439;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = function(state_14258){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1.call(this,state_14258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results))
})();
var state__13881__auto__ = (function (){var statearr_14267 = f__13880__auto__.call(null);
(statearr_14267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14437);

return statearr_14267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___14437,res,vec__14251,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14268){
var vec__14269 = p__14268;
var v = cljs.core.nth.call(null,vec__14269,(0),null);
var p = cljs.core.nth.call(null,vec__14269,(1),null);
var job = vec__14269;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___14440 = n;
var __14441 = (0);
while(true){
if((__14441 < n__7324__auto___14440)){
var G__14272_14442 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__14272_14442) {
case "compute":
var c__13879__auto___14444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14441,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (__14441,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function (state_14285){
var state_val_14286 = (state_14285[(1)]);
if((state_val_14286 === (1))){
var state_14285__$1 = state_14285;
var statearr_14287_14445 = state_14285__$1;
(statearr_14287_14445[(2)] = null);

(statearr_14287_14445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14286 === (2))){
var state_14285__$1 = state_14285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14285__$1,(4),jobs);
} else {
if((state_val_14286 === (3))){
var inst_14283 = (state_14285[(2)]);
var state_14285__$1 = state_14285;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14285__$1,inst_14283);
} else {
if((state_val_14286 === (4))){
var inst_14275 = (state_14285[(2)]);
var inst_14276 = process.call(null,inst_14275);
var state_14285__$1 = state_14285;
if(cljs.core.truth_(inst_14276)){
var statearr_14288_14446 = state_14285__$1;
(statearr_14288_14446[(1)] = (5));

} else {
var statearr_14289_14447 = state_14285__$1;
(statearr_14289_14447[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14286 === (5))){
var state_14285__$1 = state_14285;
var statearr_14290_14448 = state_14285__$1;
(statearr_14290_14448[(2)] = null);

(statearr_14290_14448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14286 === (6))){
var state_14285__$1 = state_14285;
var statearr_14291_14449 = state_14285__$1;
(statearr_14291_14449[(2)] = null);

(statearr_14291_14449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14286 === (7))){
var inst_14281 = (state_14285[(2)]);
var state_14285__$1 = state_14285;
var statearr_14292_14450 = state_14285__$1;
(statearr_14292_14450[(2)] = inst_14281);

(statearr_14292_14450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14441,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
;
return ((function (__14441,switch__13767__auto__,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_14296 = [null,null,null,null,null,null,null];
(statearr_14296[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__);

(statearr_14296[(1)] = (1));

return statearr_14296;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1 = (function (state_14285){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14297){if((e14297 instanceof Object)){
var ex__13771__auto__ = e14297;
var statearr_14298_14451 = state_14285;
(statearr_14298_14451[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14285);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14452 = state_14285;
state_14285 = G__14452;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = function(state_14285){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1.call(this,state_14285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__;
})()
;})(__14441,switch__13767__auto__,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
})();
var state__13881__auto__ = (function (){var statearr_14299 = f__13880__auto__.call(null);
(statearr_14299[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14444);

return statearr_14299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(__14441,c__13879__auto___14444,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
);


break;
case "async":
var c__13879__auto___14453 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__14441,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (__14441,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function (state_14312){
var state_val_14313 = (state_14312[(1)]);
if((state_val_14313 === (1))){
var state_14312__$1 = state_14312;
var statearr_14314_14454 = state_14312__$1;
(statearr_14314_14454[(2)] = null);

(statearr_14314_14454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14313 === (2))){
var state_14312__$1 = state_14312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14312__$1,(4),jobs);
} else {
if((state_val_14313 === (3))){
var inst_14310 = (state_14312[(2)]);
var state_14312__$1 = state_14312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14312__$1,inst_14310);
} else {
if((state_val_14313 === (4))){
var inst_14302 = (state_14312[(2)]);
var inst_14303 = async.call(null,inst_14302);
var state_14312__$1 = state_14312;
if(cljs.core.truth_(inst_14303)){
var statearr_14315_14455 = state_14312__$1;
(statearr_14315_14455[(1)] = (5));

} else {
var statearr_14316_14456 = state_14312__$1;
(statearr_14316_14456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14313 === (5))){
var state_14312__$1 = state_14312;
var statearr_14317_14457 = state_14312__$1;
(statearr_14317_14457[(2)] = null);

(statearr_14317_14457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14313 === (6))){
var state_14312__$1 = state_14312;
var statearr_14318_14458 = state_14312__$1;
(statearr_14318_14458[(2)] = null);

(statearr_14318_14458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14313 === (7))){
var inst_14308 = (state_14312[(2)]);
var state_14312__$1 = state_14312;
var statearr_14319_14459 = state_14312__$1;
(statearr_14319_14459[(2)] = inst_14308);

(statearr_14319_14459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14441,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
;
return ((function (__14441,switch__13767__auto__,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_14323 = [null,null,null,null,null,null,null];
(statearr_14323[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__);

(statearr_14323[(1)] = (1));

return statearr_14323;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1 = (function (state_14312){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14324){if((e14324 instanceof Object)){
var ex__13771__auto__ = e14324;
var statearr_14325_14460 = state_14312;
(statearr_14325_14460[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14324;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14461 = state_14312;
state_14312 = G__14461;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = function(state_14312){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1.call(this,state_14312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__;
})()
;})(__14441,switch__13767__auto__,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
})();
var state__13881__auto__ = (function (){var statearr_14326 = f__13880__auto__.call(null);
(statearr_14326[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14453);

return statearr_14326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(__14441,c__13879__auto___14453,G__14272_14442,n__7324__auto___14440,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__14462 = (__14441 + (1));
__14441 = G__14462;
continue;
} else {
}
break;
}

var c__13879__auto___14463 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___14463,jobs,results,process,async){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___14463,jobs,results,process,async){
return (function (state_14348){
var state_val_14349 = (state_14348[(1)]);
if((state_val_14349 === (1))){
var state_14348__$1 = state_14348;
var statearr_14350_14464 = state_14348__$1;
(statearr_14350_14464[(2)] = null);

(statearr_14350_14464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (2))){
var state_14348__$1 = state_14348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14348__$1,(4),from);
} else {
if((state_val_14349 === (3))){
var inst_14346 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14348__$1,inst_14346);
} else {
if((state_val_14349 === (4))){
var inst_14329 = (state_14348[(7)]);
var inst_14329__$1 = (state_14348[(2)]);
var inst_14330 = (inst_14329__$1 == null);
var state_14348__$1 = (function (){var statearr_14351 = state_14348;
(statearr_14351[(7)] = inst_14329__$1);

return statearr_14351;
})();
if(cljs.core.truth_(inst_14330)){
var statearr_14352_14465 = state_14348__$1;
(statearr_14352_14465[(1)] = (5));

} else {
var statearr_14353_14466 = state_14348__$1;
(statearr_14353_14466[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (5))){
var inst_14332 = cljs.core.async.close_BANG_.call(null,jobs);
var state_14348__$1 = state_14348;
var statearr_14354_14467 = state_14348__$1;
(statearr_14354_14467[(2)] = inst_14332);

(statearr_14354_14467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (6))){
var inst_14334 = (state_14348[(8)]);
var inst_14329 = (state_14348[(7)]);
var inst_14334__$1 = cljs.core.async.chan.call(null,(1));
var inst_14335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14336 = [inst_14329,inst_14334__$1];
var inst_14337 = (new cljs.core.PersistentVector(null,2,(5),inst_14335,inst_14336,null));
var state_14348__$1 = (function (){var statearr_14355 = state_14348;
(statearr_14355[(8)] = inst_14334__$1);

return statearr_14355;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14348__$1,(8),jobs,inst_14337);
} else {
if((state_val_14349 === (7))){
var inst_14344 = (state_14348[(2)]);
var state_14348__$1 = state_14348;
var statearr_14356_14468 = state_14348__$1;
(statearr_14356_14468[(2)] = inst_14344);

(statearr_14356_14468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14349 === (8))){
var inst_14334 = (state_14348[(8)]);
var inst_14339 = (state_14348[(2)]);
var state_14348__$1 = (function (){var statearr_14357 = state_14348;
(statearr_14357[(9)] = inst_14339);

return statearr_14357;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14348__$1,(9),results,inst_14334);
} else {
if((state_val_14349 === (9))){
var inst_14341 = (state_14348[(2)]);
var state_14348__$1 = (function (){var statearr_14358 = state_14348;
(statearr_14358[(10)] = inst_14341);

return statearr_14358;
})();
var statearr_14359_14469 = state_14348__$1;
(statearr_14359_14469[(2)] = null);

(statearr_14359_14469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___14463,jobs,results,process,async))
;
return ((function (switch__13767__auto__,c__13879__auto___14463,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_14363 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14363[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__);

(statearr_14363[(1)] = (1));

return statearr_14363;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1 = (function (state_14348){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14364){if((e14364 instanceof Object)){
var ex__13771__auto__ = e14364;
var statearr_14365_14470 = state_14348;
(statearr_14365_14470[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14348);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14364;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14471 = state_14348;
state_14348 = G__14471;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = function(state_14348){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1.call(this,state_14348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___14463,jobs,results,process,async))
})();
var state__13881__auto__ = (function (){var statearr_14366 = f__13880__auto__.call(null);
(statearr_14366[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14463);

return statearr_14366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___14463,jobs,results,process,async))
);


var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,jobs,results,process,async){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,jobs,results,process,async){
return (function (state_14404){
var state_val_14405 = (state_14404[(1)]);
if((state_val_14405 === (7))){
var inst_14400 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
var statearr_14406_14472 = state_14404__$1;
(statearr_14406_14472[(2)] = inst_14400);

(statearr_14406_14472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (20))){
var state_14404__$1 = state_14404;
var statearr_14407_14473 = state_14404__$1;
(statearr_14407_14473[(2)] = null);

(statearr_14407_14473[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (1))){
var state_14404__$1 = state_14404;
var statearr_14408_14474 = state_14404__$1;
(statearr_14408_14474[(2)] = null);

(statearr_14408_14474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (4))){
var inst_14369 = (state_14404[(7)]);
var inst_14369__$1 = (state_14404[(2)]);
var inst_14370 = (inst_14369__$1 == null);
var state_14404__$1 = (function (){var statearr_14409 = state_14404;
(statearr_14409[(7)] = inst_14369__$1);

return statearr_14409;
})();
if(cljs.core.truth_(inst_14370)){
var statearr_14410_14475 = state_14404__$1;
(statearr_14410_14475[(1)] = (5));

} else {
var statearr_14411_14476 = state_14404__$1;
(statearr_14411_14476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (15))){
var inst_14382 = (state_14404[(8)]);
var state_14404__$1 = state_14404;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14404__$1,(18),to,inst_14382);
} else {
if((state_val_14405 === (21))){
var inst_14395 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
var statearr_14412_14477 = state_14404__$1;
(statearr_14412_14477[(2)] = inst_14395);

(statearr_14412_14477[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (13))){
var inst_14397 = (state_14404[(2)]);
var state_14404__$1 = (function (){var statearr_14413 = state_14404;
(statearr_14413[(9)] = inst_14397);

return statearr_14413;
})();
var statearr_14414_14478 = state_14404__$1;
(statearr_14414_14478[(2)] = null);

(statearr_14414_14478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (6))){
var inst_14369 = (state_14404[(7)]);
var state_14404__$1 = state_14404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14404__$1,(11),inst_14369);
} else {
if((state_val_14405 === (17))){
var inst_14390 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
if(cljs.core.truth_(inst_14390)){
var statearr_14415_14479 = state_14404__$1;
(statearr_14415_14479[(1)] = (19));

} else {
var statearr_14416_14480 = state_14404__$1;
(statearr_14416_14480[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (3))){
var inst_14402 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14404__$1,inst_14402);
} else {
if((state_val_14405 === (12))){
var inst_14379 = (state_14404[(10)]);
var state_14404__$1 = state_14404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14404__$1,(14),inst_14379);
} else {
if((state_val_14405 === (2))){
var state_14404__$1 = state_14404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14404__$1,(4),results);
} else {
if((state_val_14405 === (19))){
var state_14404__$1 = state_14404;
var statearr_14417_14481 = state_14404__$1;
(statearr_14417_14481[(2)] = null);

(statearr_14417_14481[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (11))){
var inst_14379 = (state_14404[(2)]);
var state_14404__$1 = (function (){var statearr_14418 = state_14404;
(statearr_14418[(10)] = inst_14379);

return statearr_14418;
})();
var statearr_14419_14482 = state_14404__$1;
(statearr_14419_14482[(2)] = null);

(statearr_14419_14482[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (9))){
var state_14404__$1 = state_14404;
var statearr_14420_14483 = state_14404__$1;
(statearr_14420_14483[(2)] = null);

(statearr_14420_14483[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (5))){
var state_14404__$1 = state_14404;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14421_14484 = state_14404__$1;
(statearr_14421_14484[(1)] = (8));

} else {
var statearr_14422_14485 = state_14404__$1;
(statearr_14422_14485[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (14))){
var inst_14382 = (state_14404[(8)]);
var inst_14384 = (state_14404[(11)]);
var inst_14382__$1 = (state_14404[(2)]);
var inst_14383 = (inst_14382__$1 == null);
var inst_14384__$1 = cljs.core.not.call(null,inst_14383);
var state_14404__$1 = (function (){var statearr_14423 = state_14404;
(statearr_14423[(8)] = inst_14382__$1);

(statearr_14423[(11)] = inst_14384__$1);

return statearr_14423;
})();
if(inst_14384__$1){
var statearr_14424_14486 = state_14404__$1;
(statearr_14424_14486[(1)] = (15));

} else {
var statearr_14425_14487 = state_14404__$1;
(statearr_14425_14487[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (16))){
var inst_14384 = (state_14404[(11)]);
var state_14404__$1 = state_14404;
var statearr_14426_14488 = state_14404__$1;
(statearr_14426_14488[(2)] = inst_14384);

(statearr_14426_14488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (10))){
var inst_14376 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
var statearr_14427_14489 = state_14404__$1;
(statearr_14427_14489[(2)] = inst_14376);

(statearr_14427_14489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (18))){
var inst_14387 = (state_14404[(2)]);
var state_14404__$1 = state_14404;
var statearr_14428_14490 = state_14404__$1;
(statearr_14428_14490[(2)] = inst_14387);

(statearr_14428_14490[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14405 === (8))){
var inst_14373 = cljs.core.async.close_BANG_.call(null,to);
var state_14404__$1 = state_14404;
var statearr_14429_14491 = state_14404__$1;
(statearr_14429_14491[(2)] = inst_14373);

(statearr_14429_14491[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__,jobs,results,process,async))
;
return ((function (switch__13767__auto__,c__13879__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_14433 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14433[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__);

(statearr_14433[(1)] = (1));

return statearr_14433;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1 = (function (state_14404){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14434){if((e14434 instanceof Object)){
var ex__13771__auto__ = e14434;
var statearr_14435_14492 = state_14404;
(statearr_14435_14492[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14404);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14493 = state_14404;
state_14404 = G__14493;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__ = function(state_14404){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1.call(this,state_14404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,jobs,results,process,async))
})();
var state__13881__auto__ = (function (){var statearr_14436 = f__13880__auto__.call(null);
(statearr_14436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_14436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,jobs,results,process,async))
);

return c__13879__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args14494 = [];
var len__7484__auto___14497 = arguments.length;
var i__7485__auto___14498 = (0);
while(true){
if((i__7485__auto___14498 < len__7484__auto___14497)){
args14494.push((arguments[i__7485__auto___14498]));

var G__14499 = (i__7485__auto___14498 + (1));
i__7485__auto___14498 = G__14499;
continue;
} else {
}
break;
}

var G__14496 = args14494.length;
switch (G__14496) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14494.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args14501 = [];
var len__7484__auto___14504 = arguments.length;
var i__7485__auto___14505 = (0);
while(true){
if((i__7485__auto___14505 < len__7484__auto___14504)){
args14501.push((arguments[i__7485__auto___14505]));

var G__14506 = (i__7485__auto___14505 + (1));
i__7485__auto___14505 = G__14506;
continue;
} else {
}
break;
}

var G__14503 = args14501.length;
switch (G__14503) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14501.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args14508 = [];
var len__7484__auto___14561 = arguments.length;
var i__7485__auto___14562 = (0);
while(true){
if((i__7485__auto___14562 < len__7484__auto___14561)){
args14508.push((arguments[i__7485__auto___14562]));

var G__14563 = (i__7485__auto___14562 + (1));
i__7485__auto___14562 = G__14563;
continue;
} else {
}
break;
}

var G__14510 = args14508.length;
switch (G__14510) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14508.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__13879__auto___14565 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___14565,tc,fc){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___14565,tc,fc){
return (function (state_14536){
var state_val_14537 = (state_14536[(1)]);
if((state_val_14537 === (7))){
var inst_14532 = (state_14536[(2)]);
var state_14536__$1 = state_14536;
var statearr_14538_14566 = state_14536__$1;
(statearr_14538_14566[(2)] = inst_14532);

(statearr_14538_14566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (1))){
var state_14536__$1 = state_14536;
var statearr_14539_14567 = state_14536__$1;
(statearr_14539_14567[(2)] = null);

(statearr_14539_14567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (4))){
var inst_14513 = (state_14536[(7)]);
var inst_14513__$1 = (state_14536[(2)]);
var inst_14514 = (inst_14513__$1 == null);
var state_14536__$1 = (function (){var statearr_14540 = state_14536;
(statearr_14540[(7)] = inst_14513__$1);

return statearr_14540;
})();
if(cljs.core.truth_(inst_14514)){
var statearr_14541_14568 = state_14536__$1;
(statearr_14541_14568[(1)] = (5));

} else {
var statearr_14542_14569 = state_14536__$1;
(statearr_14542_14569[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (13))){
var state_14536__$1 = state_14536;
var statearr_14543_14570 = state_14536__$1;
(statearr_14543_14570[(2)] = null);

(statearr_14543_14570[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (6))){
var inst_14513 = (state_14536[(7)]);
var inst_14519 = p.call(null,inst_14513);
var state_14536__$1 = state_14536;
if(cljs.core.truth_(inst_14519)){
var statearr_14544_14571 = state_14536__$1;
(statearr_14544_14571[(1)] = (9));

} else {
var statearr_14545_14572 = state_14536__$1;
(statearr_14545_14572[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (3))){
var inst_14534 = (state_14536[(2)]);
var state_14536__$1 = state_14536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14536__$1,inst_14534);
} else {
if((state_val_14537 === (12))){
var state_14536__$1 = state_14536;
var statearr_14546_14573 = state_14536__$1;
(statearr_14546_14573[(2)] = null);

(statearr_14546_14573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (2))){
var state_14536__$1 = state_14536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14536__$1,(4),ch);
} else {
if((state_val_14537 === (11))){
var inst_14513 = (state_14536[(7)]);
var inst_14523 = (state_14536[(2)]);
var state_14536__$1 = state_14536;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14536__$1,(8),inst_14523,inst_14513);
} else {
if((state_val_14537 === (9))){
var state_14536__$1 = state_14536;
var statearr_14547_14574 = state_14536__$1;
(statearr_14547_14574[(2)] = tc);

(statearr_14547_14574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (5))){
var inst_14516 = cljs.core.async.close_BANG_.call(null,tc);
var inst_14517 = cljs.core.async.close_BANG_.call(null,fc);
var state_14536__$1 = (function (){var statearr_14548 = state_14536;
(statearr_14548[(8)] = inst_14516);

return statearr_14548;
})();
var statearr_14549_14575 = state_14536__$1;
(statearr_14549_14575[(2)] = inst_14517);

(statearr_14549_14575[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (14))){
var inst_14530 = (state_14536[(2)]);
var state_14536__$1 = state_14536;
var statearr_14550_14576 = state_14536__$1;
(statearr_14550_14576[(2)] = inst_14530);

(statearr_14550_14576[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (10))){
var state_14536__$1 = state_14536;
var statearr_14551_14577 = state_14536__$1;
(statearr_14551_14577[(2)] = fc);

(statearr_14551_14577[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14537 === (8))){
var inst_14525 = (state_14536[(2)]);
var state_14536__$1 = state_14536;
if(cljs.core.truth_(inst_14525)){
var statearr_14552_14578 = state_14536__$1;
(statearr_14552_14578[(1)] = (12));

} else {
var statearr_14553_14579 = state_14536__$1;
(statearr_14553_14579[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___14565,tc,fc))
;
return ((function (switch__13767__auto__,c__13879__auto___14565,tc,fc){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_14557 = [null,null,null,null,null,null,null,null,null];
(statearr_14557[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_14557[(1)] = (1));

return statearr_14557;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_14536){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14558){if((e14558 instanceof Object)){
var ex__13771__auto__ = e14558;
var statearr_14559_14580 = state_14536;
(statearr_14559_14580[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14536);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14558;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14581 = state_14536;
state_14536 = G__14581;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_14536){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_14536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___14565,tc,fc))
})();
var state__13881__auto__ = (function (){var statearr_14560 = f__13880__auto__.call(null);
(statearr_14560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___14565);

return statearr_14560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___14565,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__){
return (function (state_14645){
var state_val_14646 = (state_14645[(1)]);
if((state_val_14646 === (7))){
var inst_14641 = (state_14645[(2)]);
var state_14645__$1 = state_14645;
var statearr_14647_14668 = state_14645__$1;
(statearr_14647_14668[(2)] = inst_14641);

(statearr_14647_14668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (1))){
var inst_14625 = init;
var state_14645__$1 = (function (){var statearr_14648 = state_14645;
(statearr_14648[(7)] = inst_14625);

return statearr_14648;
})();
var statearr_14649_14669 = state_14645__$1;
(statearr_14649_14669[(2)] = null);

(statearr_14649_14669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (4))){
var inst_14628 = (state_14645[(8)]);
var inst_14628__$1 = (state_14645[(2)]);
var inst_14629 = (inst_14628__$1 == null);
var state_14645__$1 = (function (){var statearr_14650 = state_14645;
(statearr_14650[(8)] = inst_14628__$1);

return statearr_14650;
})();
if(cljs.core.truth_(inst_14629)){
var statearr_14651_14670 = state_14645__$1;
(statearr_14651_14670[(1)] = (5));

} else {
var statearr_14652_14671 = state_14645__$1;
(statearr_14652_14671[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (6))){
var inst_14632 = (state_14645[(9)]);
var inst_14628 = (state_14645[(8)]);
var inst_14625 = (state_14645[(7)]);
var inst_14632__$1 = f.call(null,inst_14625,inst_14628);
var inst_14633 = cljs.core.reduced_QMARK_.call(null,inst_14632__$1);
var state_14645__$1 = (function (){var statearr_14653 = state_14645;
(statearr_14653[(9)] = inst_14632__$1);

return statearr_14653;
})();
if(inst_14633){
var statearr_14654_14672 = state_14645__$1;
(statearr_14654_14672[(1)] = (8));

} else {
var statearr_14655_14673 = state_14645__$1;
(statearr_14655_14673[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (3))){
var inst_14643 = (state_14645[(2)]);
var state_14645__$1 = state_14645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14645__$1,inst_14643);
} else {
if((state_val_14646 === (2))){
var state_14645__$1 = state_14645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14645__$1,(4),ch);
} else {
if((state_val_14646 === (9))){
var inst_14632 = (state_14645[(9)]);
var inst_14625 = inst_14632;
var state_14645__$1 = (function (){var statearr_14656 = state_14645;
(statearr_14656[(7)] = inst_14625);

return statearr_14656;
})();
var statearr_14657_14674 = state_14645__$1;
(statearr_14657_14674[(2)] = null);

(statearr_14657_14674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (5))){
var inst_14625 = (state_14645[(7)]);
var state_14645__$1 = state_14645;
var statearr_14658_14675 = state_14645__$1;
(statearr_14658_14675[(2)] = inst_14625);

(statearr_14658_14675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (10))){
var inst_14639 = (state_14645[(2)]);
var state_14645__$1 = state_14645;
var statearr_14659_14676 = state_14645__$1;
(statearr_14659_14676[(2)] = inst_14639);

(statearr_14659_14676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14646 === (8))){
var inst_14632 = (state_14645[(9)]);
var inst_14635 = cljs.core.deref.call(null,inst_14632);
var state_14645__$1 = state_14645;
var statearr_14660_14677 = state_14645__$1;
(statearr_14660_14677[(2)] = inst_14635);

(statearr_14660_14677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__))
;
return ((function (switch__13767__auto__,c__13879__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__13768__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13768__auto____0 = (function (){
var statearr_14664 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14664[(0)] = cljs$core$async$reduce_$_state_machine__13768__auto__);

(statearr_14664[(1)] = (1));

return statearr_14664;
});
var cljs$core$async$reduce_$_state_machine__13768__auto____1 = (function (state_14645){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14665){if((e14665 instanceof Object)){
var ex__13771__auto__ = e14665;
var statearr_14666_14678 = state_14645;
(statearr_14666_14678[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14645);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14679 = state_14645;
state_14645 = G__14679;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13768__auto__ = function(state_14645){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13768__auto____1.call(this,state_14645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13768__auto____0;
cljs$core$async$reduce_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13768__auto____1;
return cljs$core$async$reduce_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__))
})();
var state__13881__auto__ = (function (){var statearr_14667 = f__13880__auto__.call(null);
(statearr_14667[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_14667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__))
);

return c__13879__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,f__$1){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,f__$1){
return (function (state_14699){
var state_val_14700 = (state_14699[(1)]);
if((state_val_14700 === (1))){
var inst_14694 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14699__$1,(2),inst_14694);
} else {
if((state_val_14700 === (2))){
var inst_14696 = (state_14699[(2)]);
var inst_14697 = f__$1.call(null,inst_14696);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14699__$1,inst_14697);
} else {
return null;
}
}
});})(c__13879__auto__,f__$1))
;
return ((function (switch__13767__auto__,c__13879__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__13768__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13768__auto____0 = (function (){
var statearr_14704 = [null,null,null,null,null,null,null];
(statearr_14704[(0)] = cljs$core$async$transduce_$_state_machine__13768__auto__);

(statearr_14704[(1)] = (1));

return statearr_14704;
});
var cljs$core$async$transduce_$_state_machine__13768__auto____1 = (function (state_14699){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14705){if((e14705 instanceof Object)){
var ex__13771__auto__ = e14705;
var statearr_14706_14708 = state_14699;
(statearr_14706_14708[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14709 = state_14699;
state_14699 = G__14709;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13768__auto__ = function(state_14699){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13768__auto____1.call(this,state_14699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13768__auto____0;
cljs$core$async$transduce_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13768__auto____1;
return cljs$core$async$transduce_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,f__$1))
})();
var state__13881__auto__ = (function (){var statearr_14707 = f__13880__auto__.call(null);
(statearr_14707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_14707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,f__$1))
);

return c__13879__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14710 = [];
var len__7484__auto___14762 = arguments.length;
var i__7485__auto___14763 = (0);
while(true){
if((i__7485__auto___14763 < len__7484__auto___14762)){
args14710.push((arguments[i__7485__auto___14763]));

var G__14764 = (i__7485__auto___14763 + (1));
i__7485__auto___14763 = G__14764;
continue;
} else {
}
break;
}

var G__14712 = args14710.length;
switch (G__14712) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14710.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__){
return (function (state_14737){
var state_val_14738 = (state_14737[(1)]);
if((state_val_14738 === (7))){
var inst_14719 = (state_14737[(2)]);
var state_14737__$1 = state_14737;
var statearr_14739_14766 = state_14737__$1;
(statearr_14739_14766[(2)] = inst_14719);

(statearr_14739_14766[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (1))){
var inst_14713 = cljs.core.seq.call(null,coll);
var inst_14714 = inst_14713;
var state_14737__$1 = (function (){var statearr_14740 = state_14737;
(statearr_14740[(7)] = inst_14714);

return statearr_14740;
})();
var statearr_14741_14767 = state_14737__$1;
(statearr_14741_14767[(2)] = null);

(statearr_14741_14767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (4))){
var inst_14714 = (state_14737[(7)]);
var inst_14717 = cljs.core.first.call(null,inst_14714);
var state_14737__$1 = state_14737;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14737__$1,(7),ch,inst_14717);
} else {
if((state_val_14738 === (13))){
var inst_14731 = (state_14737[(2)]);
var state_14737__$1 = state_14737;
var statearr_14742_14768 = state_14737__$1;
(statearr_14742_14768[(2)] = inst_14731);

(statearr_14742_14768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (6))){
var inst_14722 = (state_14737[(2)]);
var state_14737__$1 = state_14737;
if(cljs.core.truth_(inst_14722)){
var statearr_14743_14769 = state_14737__$1;
(statearr_14743_14769[(1)] = (8));

} else {
var statearr_14744_14770 = state_14737__$1;
(statearr_14744_14770[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (3))){
var inst_14735 = (state_14737[(2)]);
var state_14737__$1 = state_14737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14737__$1,inst_14735);
} else {
if((state_val_14738 === (12))){
var state_14737__$1 = state_14737;
var statearr_14745_14771 = state_14737__$1;
(statearr_14745_14771[(2)] = null);

(statearr_14745_14771[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (2))){
var inst_14714 = (state_14737[(7)]);
var state_14737__$1 = state_14737;
if(cljs.core.truth_(inst_14714)){
var statearr_14746_14772 = state_14737__$1;
(statearr_14746_14772[(1)] = (4));

} else {
var statearr_14747_14773 = state_14737__$1;
(statearr_14747_14773[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (11))){
var inst_14728 = cljs.core.async.close_BANG_.call(null,ch);
var state_14737__$1 = state_14737;
var statearr_14748_14774 = state_14737__$1;
(statearr_14748_14774[(2)] = inst_14728);

(statearr_14748_14774[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (9))){
var state_14737__$1 = state_14737;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14749_14775 = state_14737__$1;
(statearr_14749_14775[(1)] = (11));

} else {
var statearr_14750_14776 = state_14737__$1;
(statearr_14750_14776[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (5))){
var inst_14714 = (state_14737[(7)]);
var state_14737__$1 = state_14737;
var statearr_14751_14777 = state_14737__$1;
(statearr_14751_14777[(2)] = inst_14714);

(statearr_14751_14777[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (10))){
var inst_14733 = (state_14737[(2)]);
var state_14737__$1 = state_14737;
var statearr_14752_14778 = state_14737__$1;
(statearr_14752_14778[(2)] = inst_14733);

(statearr_14752_14778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14738 === (8))){
var inst_14714 = (state_14737[(7)]);
var inst_14724 = cljs.core.next.call(null,inst_14714);
var inst_14714__$1 = inst_14724;
var state_14737__$1 = (function (){var statearr_14753 = state_14737;
(statearr_14753[(7)] = inst_14714__$1);

return statearr_14753;
})();
var statearr_14754_14779 = state_14737__$1;
(statearr_14754_14779[(2)] = null);

(statearr_14754_14779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__))
;
return ((function (switch__13767__auto__,c__13879__auto__){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_14758 = [null,null,null,null,null,null,null,null];
(statearr_14758[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_14758[(1)] = (1));

return statearr_14758;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_14737){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_14737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e14759){if((e14759 instanceof Object)){
var ex__13771__auto__ = e14759;
var statearr_14760_14780 = state_14737;
(statearr_14760_14780[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14737);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14781 = state_14737;
state_14737 = G__14781;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_14737){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_14737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__))
})();
var state__13881__auto__ = (function (){var statearr_14761 = f__13880__auto__.call(null);
(statearr_14761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_14761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__))
);

return c__13879__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15007 = (function (mult,ch,cs,meta15008){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta15008 = meta15008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15009,meta15008__$1){
var self__ = this;
var _15009__$1 = this;
return (new cljs.core.async.t_cljs$core$async15007(self__.mult,self__.ch,self__.cs,meta15008__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15009){
var self__ = this;
var _15009__$1 = this;
return self__.meta15008;
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta15008","meta15008",-1566981531,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15007";

cljs.core.async.t_cljs$core$async15007.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15007");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15007 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15007(mult__$1,ch__$1,cs__$1,meta15008){
return (new cljs.core.async.t_cljs$core$async15007(mult__$1,ch__$1,cs__$1,meta15008));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15007(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__13879__auto___15232 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___15232,cs,m,dchan,dctr,done){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___15232,cs,m,dchan,dctr,done){
return (function (state_15144){
var state_val_15145 = (state_15144[(1)]);
if((state_val_15145 === (7))){
var inst_15140 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15146_15233 = state_15144__$1;
(statearr_15146_15233[(2)] = inst_15140);

(statearr_15146_15233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (20))){
var inst_15043 = (state_15144[(7)]);
var inst_15055 = cljs.core.first.call(null,inst_15043);
var inst_15056 = cljs.core.nth.call(null,inst_15055,(0),null);
var inst_15057 = cljs.core.nth.call(null,inst_15055,(1),null);
var state_15144__$1 = (function (){var statearr_15147 = state_15144;
(statearr_15147[(8)] = inst_15056);

return statearr_15147;
})();
if(cljs.core.truth_(inst_15057)){
var statearr_15148_15234 = state_15144__$1;
(statearr_15148_15234[(1)] = (22));

} else {
var statearr_15149_15235 = state_15144__$1;
(statearr_15149_15235[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (27))){
var inst_15087 = (state_15144[(9)]);
var inst_15012 = (state_15144[(10)]);
var inst_15092 = (state_15144[(11)]);
var inst_15085 = (state_15144[(12)]);
var inst_15092__$1 = cljs.core._nth.call(null,inst_15085,inst_15087);
var inst_15093 = cljs.core.async.put_BANG_.call(null,inst_15092__$1,inst_15012,done);
var state_15144__$1 = (function (){var statearr_15150 = state_15144;
(statearr_15150[(11)] = inst_15092__$1);

return statearr_15150;
})();
if(cljs.core.truth_(inst_15093)){
var statearr_15151_15236 = state_15144__$1;
(statearr_15151_15236[(1)] = (30));

} else {
var statearr_15152_15237 = state_15144__$1;
(statearr_15152_15237[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (1))){
var state_15144__$1 = state_15144;
var statearr_15153_15238 = state_15144__$1;
(statearr_15153_15238[(2)] = null);

(statearr_15153_15238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (24))){
var inst_15043 = (state_15144[(7)]);
var inst_15062 = (state_15144[(2)]);
var inst_15063 = cljs.core.next.call(null,inst_15043);
var inst_15021 = inst_15063;
var inst_15022 = null;
var inst_15023 = (0);
var inst_15024 = (0);
var state_15144__$1 = (function (){var statearr_15154 = state_15144;
(statearr_15154[(13)] = inst_15022);

(statearr_15154[(14)] = inst_15024);

(statearr_15154[(15)] = inst_15021);

(statearr_15154[(16)] = inst_15023);

(statearr_15154[(17)] = inst_15062);

return statearr_15154;
})();
var statearr_15155_15239 = state_15144__$1;
(statearr_15155_15239[(2)] = null);

(statearr_15155_15239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (39))){
var state_15144__$1 = state_15144;
var statearr_15159_15240 = state_15144__$1;
(statearr_15159_15240[(2)] = null);

(statearr_15159_15240[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (4))){
var inst_15012 = (state_15144[(10)]);
var inst_15012__$1 = (state_15144[(2)]);
var inst_15013 = (inst_15012__$1 == null);
var state_15144__$1 = (function (){var statearr_15160 = state_15144;
(statearr_15160[(10)] = inst_15012__$1);

return statearr_15160;
})();
if(cljs.core.truth_(inst_15013)){
var statearr_15161_15241 = state_15144__$1;
(statearr_15161_15241[(1)] = (5));

} else {
var statearr_15162_15242 = state_15144__$1;
(statearr_15162_15242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (15))){
var inst_15022 = (state_15144[(13)]);
var inst_15024 = (state_15144[(14)]);
var inst_15021 = (state_15144[(15)]);
var inst_15023 = (state_15144[(16)]);
var inst_15039 = (state_15144[(2)]);
var inst_15040 = (inst_15024 + (1));
var tmp15156 = inst_15022;
var tmp15157 = inst_15021;
var tmp15158 = inst_15023;
var inst_15021__$1 = tmp15157;
var inst_15022__$1 = tmp15156;
var inst_15023__$1 = tmp15158;
var inst_15024__$1 = inst_15040;
var state_15144__$1 = (function (){var statearr_15163 = state_15144;
(statearr_15163[(13)] = inst_15022__$1);

(statearr_15163[(18)] = inst_15039);

(statearr_15163[(14)] = inst_15024__$1);

(statearr_15163[(15)] = inst_15021__$1);

(statearr_15163[(16)] = inst_15023__$1);

return statearr_15163;
})();
var statearr_15164_15243 = state_15144__$1;
(statearr_15164_15243[(2)] = null);

(statearr_15164_15243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (21))){
var inst_15066 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15168_15244 = state_15144__$1;
(statearr_15168_15244[(2)] = inst_15066);

(statearr_15168_15244[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (31))){
var inst_15092 = (state_15144[(11)]);
var inst_15096 = done.call(null,null);
var inst_15097 = cljs.core.async.untap_STAR_.call(null,m,inst_15092);
var state_15144__$1 = (function (){var statearr_15169 = state_15144;
(statearr_15169[(19)] = inst_15096);

return statearr_15169;
})();
var statearr_15170_15245 = state_15144__$1;
(statearr_15170_15245[(2)] = inst_15097);

(statearr_15170_15245[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (32))){
var inst_15087 = (state_15144[(9)]);
var inst_15086 = (state_15144[(20)]);
var inst_15084 = (state_15144[(21)]);
var inst_15085 = (state_15144[(12)]);
var inst_15099 = (state_15144[(2)]);
var inst_15100 = (inst_15087 + (1));
var tmp15165 = inst_15086;
var tmp15166 = inst_15084;
var tmp15167 = inst_15085;
var inst_15084__$1 = tmp15166;
var inst_15085__$1 = tmp15167;
var inst_15086__$1 = tmp15165;
var inst_15087__$1 = inst_15100;
var state_15144__$1 = (function (){var statearr_15171 = state_15144;
(statearr_15171[(9)] = inst_15087__$1);

(statearr_15171[(22)] = inst_15099);

(statearr_15171[(20)] = inst_15086__$1);

(statearr_15171[(21)] = inst_15084__$1);

(statearr_15171[(12)] = inst_15085__$1);

return statearr_15171;
})();
var statearr_15172_15246 = state_15144__$1;
(statearr_15172_15246[(2)] = null);

(statearr_15172_15246[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (40))){
var inst_15112 = (state_15144[(23)]);
var inst_15116 = done.call(null,null);
var inst_15117 = cljs.core.async.untap_STAR_.call(null,m,inst_15112);
var state_15144__$1 = (function (){var statearr_15173 = state_15144;
(statearr_15173[(24)] = inst_15116);

return statearr_15173;
})();
var statearr_15174_15247 = state_15144__$1;
(statearr_15174_15247[(2)] = inst_15117);

(statearr_15174_15247[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (33))){
var inst_15103 = (state_15144[(25)]);
var inst_15105 = cljs.core.chunked_seq_QMARK_.call(null,inst_15103);
var state_15144__$1 = state_15144;
if(inst_15105){
var statearr_15175_15248 = state_15144__$1;
(statearr_15175_15248[(1)] = (36));

} else {
var statearr_15176_15249 = state_15144__$1;
(statearr_15176_15249[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (13))){
var inst_15033 = (state_15144[(26)]);
var inst_15036 = cljs.core.async.close_BANG_.call(null,inst_15033);
var state_15144__$1 = state_15144;
var statearr_15177_15250 = state_15144__$1;
(statearr_15177_15250[(2)] = inst_15036);

(statearr_15177_15250[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (22))){
var inst_15056 = (state_15144[(8)]);
var inst_15059 = cljs.core.async.close_BANG_.call(null,inst_15056);
var state_15144__$1 = state_15144;
var statearr_15178_15251 = state_15144__$1;
(statearr_15178_15251[(2)] = inst_15059);

(statearr_15178_15251[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (36))){
var inst_15103 = (state_15144[(25)]);
var inst_15107 = cljs.core.chunk_first.call(null,inst_15103);
var inst_15108 = cljs.core.chunk_rest.call(null,inst_15103);
var inst_15109 = cljs.core.count.call(null,inst_15107);
var inst_15084 = inst_15108;
var inst_15085 = inst_15107;
var inst_15086 = inst_15109;
var inst_15087 = (0);
var state_15144__$1 = (function (){var statearr_15179 = state_15144;
(statearr_15179[(9)] = inst_15087);

(statearr_15179[(20)] = inst_15086);

(statearr_15179[(21)] = inst_15084);

(statearr_15179[(12)] = inst_15085);

return statearr_15179;
})();
var statearr_15180_15252 = state_15144__$1;
(statearr_15180_15252[(2)] = null);

(statearr_15180_15252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (41))){
var inst_15103 = (state_15144[(25)]);
var inst_15119 = (state_15144[(2)]);
var inst_15120 = cljs.core.next.call(null,inst_15103);
var inst_15084 = inst_15120;
var inst_15085 = null;
var inst_15086 = (0);
var inst_15087 = (0);
var state_15144__$1 = (function (){var statearr_15181 = state_15144;
(statearr_15181[(9)] = inst_15087);

(statearr_15181[(27)] = inst_15119);

(statearr_15181[(20)] = inst_15086);

(statearr_15181[(21)] = inst_15084);

(statearr_15181[(12)] = inst_15085);

return statearr_15181;
})();
var statearr_15182_15253 = state_15144__$1;
(statearr_15182_15253[(2)] = null);

(statearr_15182_15253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (43))){
var state_15144__$1 = state_15144;
var statearr_15183_15254 = state_15144__$1;
(statearr_15183_15254[(2)] = null);

(statearr_15183_15254[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (29))){
var inst_15128 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15184_15255 = state_15144__$1;
(statearr_15184_15255[(2)] = inst_15128);

(statearr_15184_15255[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (44))){
var inst_15137 = (state_15144[(2)]);
var state_15144__$1 = (function (){var statearr_15185 = state_15144;
(statearr_15185[(28)] = inst_15137);

return statearr_15185;
})();
var statearr_15186_15256 = state_15144__$1;
(statearr_15186_15256[(2)] = null);

(statearr_15186_15256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (6))){
var inst_15076 = (state_15144[(29)]);
var inst_15075 = cljs.core.deref.call(null,cs);
var inst_15076__$1 = cljs.core.keys.call(null,inst_15075);
var inst_15077 = cljs.core.count.call(null,inst_15076__$1);
var inst_15078 = cljs.core.reset_BANG_.call(null,dctr,inst_15077);
var inst_15083 = cljs.core.seq.call(null,inst_15076__$1);
var inst_15084 = inst_15083;
var inst_15085 = null;
var inst_15086 = (0);
var inst_15087 = (0);
var state_15144__$1 = (function (){var statearr_15187 = state_15144;
(statearr_15187[(9)] = inst_15087);

(statearr_15187[(30)] = inst_15078);

(statearr_15187[(20)] = inst_15086);

(statearr_15187[(29)] = inst_15076__$1);

(statearr_15187[(21)] = inst_15084);

(statearr_15187[(12)] = inst_15085);

return statearr_15187;
})();
var statearr_15188_15257 = state_15144__$1;
(statearr_15188_15257[(2)] = null);

(statearr_15188_15257[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (28))){
var inst_15103 = (state_15144[(25)]);
var inst_15084 = (state_15144[(21)]);
var inst_15103__$1 = cljs.core.seq.call(null,inst_15084);
var state_15144__$1 = (function (){var statearr_15189 = state_15144;
(statearr_15189[(25)] = inst_15103__$1);

return statearr_15189;
})();
if(inst_15103__$1){
var statearr_15190_15258 = state_15144__$1;
(statearr_15190_15258[(1)] = (33));

} else {
var statearr_15191_15259 = state_15144__$1;
(statearr_15191_15259[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (25))){
var inst_15087 = (state_15144[(9)]);
var inst_15086 = (state_15144[(20)]);
var inst_15089 = (inst_15087 < inst_15086);
var inst_15090 = inst_15089;
var state_15144__$1 = state_15144;
if(cljs.core.truth_(inst_15090)){
var statearr_15192_15260 = state_15144__$1;
(statearr_15192_15260[(1)] = (27));

} else {
var statearr_15193_15261 = state_15144__$1;
(statearr_15193_15261[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (34))){
var state_15144__$1 = state_15144;
var statearr_15194_15262 = state_15144__$1;
(statearr_15194_15262[(2)] = null);

(statearr_15194_15262[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (17))){
var state_15144__$1 = state_15144;
var statearr_15195_15263 = state_15144__$1;
(statearr_15195_15263[(2)] = null);

(statearr_15195_15263[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (3))){
var inst_15142 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15144__$1,inst_15142);
} else {
if((state_val_15145 === (12))){
var inst_15071 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15196_15264 = state_15144__$1;
(statearr_15196_15264[(2)] = inst_15071);

(statearr_15196_15264[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (2))){
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15144__$1,(4),ch);
} else {
if((state_val_15145 === (23))){
var state_15144__$1 = state_15144;
var statearr_15197_15265 = state_15144__$1;
(statearr_15197_15265[(2)] = null);

(statearr_15197_15265[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (35))){
var inst_15126 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15198_15266 = state_15144__$1;
(statearr_15198_15266[(2)] = inst_15126);

(statearr_15198_15266[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (19))){
var inst_15043 = (state_15144[(7)]);
var inst_15047 = cljs.core.chunk_first.call(null,inst_15043);
var inst_15048 = cljs.core.chunk_rest.call(null,inst_15043);
var inst_15049 = cljs.core.count.call(null,inst_15047);
var inst_15021 = inst_15048;
var inst_15022 = inst_15047;
var inst_15023 = inst_15049;
var inst_15024 = (0);
var state_15144__$1 = (function (){var statearr_15199 = state_15144;
(statearr_15199[(13)] = inst_15022);

(statearr_15199[(14)] = inst_15024);

(statearr_15199[(15)] = inst_15021);

(statearr_15199[(16)] = inst_15023);

return statearr_15199;
})();
var statearr_15200_15267 = state_15144__$1;
(statearr_15200_15267[(2)] = null);

(statearr_15200_15267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (11))){
var inst_15021 = (state_15144[(15)]);
var inst_15043 = (state_15144[(7)]);
var inst_15043__$1 = cljs.core.seq.call(null,inst_15021);
var state_15144__$1 = (function (){var statearr_15201 = state_15144;
(statearr_15201[(7)] = inst_15043__$1);

return statearr_15201;
})();
if(inst_15043__$1){
var statearr_15202_15268 = state_15144__$1;
(statearr_15202_15268[(1)] = (16));

} else {
var statearr_15203_15269 = state_15144__$1;
(statearr_15203_15269[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (9))){
var inst_15073 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15204_15270 = state_15144__$1;
(statearr_15204_15270[(2)] = inst_15073);

(statearr_15204_15270[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (5))){
var inst_15019 = cljs.core.deref.call(null,cs);
var inst_15020 = cljs.core.seq.call(null,inst_15019);
var inst_15021 = inst_15020;
var inst_15022 = null;
var inst_15023 = (0);
var inst_15024 = (0);
var state_15144__$1 = (function (){var statearr_15205 = state_15144;
(statearr_15205[(13)] = inst_15022);

(statearr_15205[(14)] = inst_15024);

(statearr_15205[(15)] = inst_15021);

(statearr_15205[(16)] = inst_15023);

return statearr_15205;
})();
var statearr_15206_15271 = state_15144__$1;
(statearr_15206_15271[(2)] = null);

(statearr_15206_15271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (14))){
var state_15144__$1 = state_15144;
var statearr_15207_15272 = state_15144__$1;
(statearr_15207_15272[(2)] = null);

(statearr_15207_15272[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (45))){
var inst_15134 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15208_15273 = state_15144__$1;
(statearr_15208_15273[(2)] = inst_15134);

(statearr_15208_15273[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (26))){
var inst_15076 = (state_15144[(29)]);
var inst_15130 = (state_15144[(2)]);
var inst_15131 = cljs.core.seq.call(null,inst_15076);
var state_15144__$1 = (function (){var statearr_15209 = state_15144;
(statearr_15209[(31)] = inst_15130);

return statearr_15209;
})();
if(inst_15131){
var statearr_15210_15274 = state_15144__$1;
(statearr_15210_15274[(1)] = (42));

} else {
var statearr_15211_15275 = state_15144__$1;
(statearr_15211_15275[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (16))){
var inst_15043 = (state_15144[(7)]);
var inst_15045 = cljs.core.chunked_seq_QMARK_.call(null,inst_15043);
var state_15144__$1 = state_15144;
if(inst_15045){
var statearr_15212_15276 = state_15144__$1;
(statearr_15212_15276[(1)] = (19));

} else {
var statearr_15213_15277 = state_15144__$1;
(statearr_15213_15277[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (38))){
var inst_15123 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15214_15278 = state_15144__$1;
(statearr_15214_15278[(2)] = inst_15123);

(statearr_15214_15278[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (30))){
var state_15144__$1 = state_15144;
var statearr_15215_15279 = state_15144__$1;
(statearr_15215_15279[(2)] = null);

(statearr_15215_15279[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (10))){
var inst_15022 = (state_15144[(13)]);
var inst_15024 = (state_15144[(14)]);
var inst_15032 = cljs.core._nth.call(null,inst_15022,inst_15024);
var inst_15033 = cljs.core.nth.call(null,inst_15032,(0),null);
var inst_15034 = cljs.core.nth.call(null,inst_15032,(1),null);
var state_15144__$1 = (function (){var statearr_15216 = state_15144;
(statearr_15216[(26)] = inst_15033);

return statearr_15216;
})();
if(cljs.core.truth_(inst_15034)){
var statearr_15217_15280 = state_15144__$1;
(statearr_15217_15280[(1)] = (13));

} else {
var statearr_15218_15281 = state_15144__$1;
(statearr_15218_15281[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (18))){
var inst_15069 = (state_15144[(2)]);
var state_15144__$1 = state_15144;
var statearr_15219_15282 = state_15144__$1;
(statearr_15219_15282[(2)] = inst_15069);

(statearr_15219_15282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (42))){
var state_15144__$1 = state_15144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15144__$1,(45),dchan);
} else {
if((state_val_15145 === (37))){
var inst_15103 = (state_15144[(25)]);
var inst_15012 = (state_15144[(10)]);
var inst_15112 = (state_15144[(23)]);
var inst_15112__$1 = cljs.core.first.call(null,inst_15103);
var inst_15113 = cljs.core.async.put_BANG_.call(null,inst_15112__$1,inst_15012,done);
var state_15144__$1 = (function (){var statearr_15220 = state_15144;
(statearr_15220[(23)] = inst_15112__$1);

return statearr_15220;
})();
if(cljs.core.truth_(inst_15113)){
var statearr_15221_15283 = state_15144__$1;
(statearr_15221_15283[(1)] = (39));

} else {
var statearr_15222_15284 = state_15144__$1;
(statearr_15222_15284[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15145 === (8))){
var inst_15024 = (state_15144[(14)]);
var inst_15023 = (state_15144[(16)]);
var inst_15026 = (inst_15024 < inst_15023);
var inst_15027 = inst_15026;
var state_15144__$1 = state_15144;
if(cljs.core.truth_(inst_15027)){
var statearr_15223_15285 = state_15144__$1;
(statearr_15223_15285[(1)] = (10));

} else {
var statearr_15224_15286 = state_15144__$1;
(statearr_15224_15286[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___15232,cs,m,dchan,dctr,done))
;
return ((function (switch__13767__auto__,c__13879__auto___15232,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__13768__auto__ = null;
var cljs$core$async$mult_$_state_machine__13768__auto____0 = (function (){
var statearr_15228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15228[(0)] = cljs$core$async$mult_$_state_machine__13768__auto__);

(statearr_15228[(1)] = (1));

return statearr_15228;
});
var cljs$core$async$mult_$_state_machine__13768__auto____1 = (function (state_15144){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_15144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e15229){if((e15229 instanceof Object)){
var ex__13771__auto__ = e15229;
var statearr_15230_15287 = state_15144;
(statearr_15230_15287[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15144);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15288 = state_15144;
state_15144 = G__15288;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13768__auto__ = function(state_15144){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13768__auto____1.call(this,state_15144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13768__auto____0;
cljs$core$async$mult_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13768__auto____1;
return cljs$core$async$mult_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___15232,cs,m,dchan,dctr,done))
})();
var state__13881__auto__ = (function (){var statearr_15231 = f__13880__auto__.call(null);
(statearr_15231[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___15232);

return statearr_15231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___15232,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args15289 = [];
var len__7484__auto___15292 = arguments.length;
var i__7485__auto___15293 = (0);
while(true){
if((i__7485__auto___15293 < len__7484__auto___15292)){
args15289.push((arguments[i__7485__auto___15293]));

var G__15294 = (i__7485__auto___15293 + (1));
i__7485__auto___15293 = G__15294;
continue;
} else {
}
break;
}

var G__15291 = args15289.length;
switch (G__15291) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15289.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___15306 = arguments.length;
var i__7485__auto___15307 = (0);
while(true){
if((i__7485__auto___15307 < len__7484__auto___15306)){
args__7491__auto__.push((arguments[i__7485__auto___15307]));

var G__15308 = (i__7485__auto___15307 + (1));
i__7485__auto___15307 = G__15308;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15300){
var map__15301 = p__15300;
var map__15301__$1 = ((((!((map__15301 == null)))?((((map__15301.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15301.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15301):map__15301);
var opts = map__15301__$1;
var statearr_15303_15309 = state;
(statearr_15303_15309[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__15301,map__15301__$1,opts){
return (function (val){
var statearr_15304_15310 = state;
(statearr_15304_15310[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__15301,map__15301__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15305_15311 = state;
(statearr_15305_15311[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15296){
var G__15297 = cljs.core.first.call(null,seq15296);
var seq15296__$1 = cljs.core.next.call(null,seq15296);
var G__15298 = cljs.core.first.call(null,seq15296__$1);
var seq15296__$2 = cljs.core.next.call(null,seq15296__$1);
var G__15299 = cljs.core.first.call(null,seq15296__$2);
var seq15296__$3 = cljs.core.next.call(null,seq15296__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15297,G__15298,G__15299,seq15296__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15477 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15478){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15478 = meta15478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15479,meta15478__$1){
var self__ = this;
var _15479__$1 = this;
return (new cljs.core.async.t_cljs$core$async15477(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15478__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15479){
var self__ = this;
var _15479__$1 = this;
return self__.meta15478;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta15478","meta15478",273049759,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15477.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15477";

cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15477");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15477 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15477(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15478){
return (new cljs.core.async.t_cljs$core$async15477(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15478));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15477(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13879__auto___15642 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15579){
var state_val_15580 = (state_15579[(1)]);
if((state_val_15580 === (7))){
var inst_15495 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
var statearr_15581_15643 = state_15579__$1;
(statearr_15581_15643[(2)] = inst_15495);

(statearr_15581_15643[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (20))){
var inst_15507 = (state_15579[(7)]);
var state_15579__$1 = state_15579;
var statearr_15582_15644 = state_15579__$1;
(statearr_15582_15644[(2)] = inst_15507);

(statearr_15582_15644[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (27))){
var state_15579__$1 = state_15579;
var statearr_15583_15645 = state_15579__$1;
(statearr_15583_15645[(2)] = null);

(statearr_15583_15645[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (1))){
var inst_15483 = (state_15579[(8)]);
var inst_15483__$1 = calc_state.call(null);
var inst_15485 = (inst_15483__$1 == null);
var inst_15486 = cljs.core.not.call(null,inst_15485);
var state_15579__$1 = (function (){var statearr_15584 = state_15579;
(statearr_15584[(8)] = inst_15483__$1);

return statearr_15584;
})();
if(inst_15486){
var statearr_15585_15646 = state_15579__$1;
(statearr_15585_15646[(1)] = (2));

} else {
var statearr_15586_15647 = state_15579__$1;
(statearr_15586_15647[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (24))){
var inst_15530 = (state_15579[(9)]);
var inst_15553 = (state_15579[(10)]);
var inst_15539 = (state_15579[(11)]);
var inst_15553__$1 = inst_15530.call(null,inst_15539);
var state_15579__$1 = (function (){var statearr_15587 = state_15579;
(statearr_15587[(10)] = inst_15553__$1);

return statearr_15587;
})();
if(cljs.core.truth_(inst_15553__$1)){
var statearr_15588_15648 = state_15579__$1;
(statearr_15588_15648[(1)] = (29));

} else {
var statearr_15589_15649 = state_15579__$1;
(statearr_15589_15649[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (4))){
var inst_15498 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15498)){
var statearr_15590_15650 = state_15579__$1;
(statearr_15590_15650[(1)] = (8));

} else {
var statearr_15591_15651 = state_15579__$1;
(statearr_15591_15651[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (15))){
var inst_15524 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15524)){
var statearr_15592_15652 = state_15579__$1;
(statearr_15592_15652[(1)] = (19));

} else {
var statearr_15593_15653 = state_15579__$1;
(statearr_15593_15653[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (21))){
var inst_15529 = (state_15579[(12)]);
var inst_15529__$1 = (state_15579[(2)]);
var inst_15530 = cljs.core.get.call(null,inst_15529__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15531 = cljs.core.get.call(null,inst_15529__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15532 = cljs.core.get.call(null,inst_15529__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_15579__$1 = (function (){var statearr_15594 = state_15579;
(statearr_15594[(13)] = inst_15531);

(statearr_15594[(9)] = inst_15530);

(statearr_15594[(12)] = inst_15529__$1);

return statearr_15594;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_15579__$1,(22),inst_15532);
} else {
if((state_val_15580 === (31))){
var inst_15561 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15561)){
var statearr_15595_15654 = state_15579__$1;
(statearr_15595_15654[(1)] = (32));

} else {
var statearr_15596_15655 = state_15579__$1;
(statearr_15596_15655[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (32))){
var inst_15538 = (state_15579[(14)]);
var state_15579__$1 = state_15579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15579__$1,(35),out,inst_15538);
} else {
if((state_val_15580 === (33))){
var inst_15529 = (state_15579[(12)]);
var inst_15507 = inst_15529;
var state_15579__$1 = (function (){var statearr_15597 = state_15579;
(statearr_15597[(7)] = inst_15507);

return statearr_15597;
})();
var statearr_15598_15656 = state_15579__$1;
(statearr_15598_15656[(2)] = null);

(statearr_15598_15656[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (13))){
var inst_15507 = (state_15579[(7)]);
var inst_15514 = inst_15507.cljs$lang$protocol_mask$partition0$;
var inst_15515 = (inst_15514 & (64));
var inst_15516 = inst_15507.cljs$core$ISeq$;
var inst_15517 = (inst_15515) || (inst_15516);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15517)){
var statearr_15599_15657 = state_15579__$1;
(statearr_15599_15657[(1)] = (16));

} else {
var statearr_15600_15658 = state_15579__$1;
(statearr_15600_15658[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (22))){
var inst_15538 = (state_15579[(14)]);
var inst_15539 = (state_15579[(11)]);
var inst_15537 = (state_15579[(2)]);
var inst_15538__$1 = cljs.core.nth.call(null,inst_15537,(0),null);
var inst_15539__$1 = cljs.core.nth.call(null,inst_15537,(1),null);
var inst_15540 = (inst_15538__$1 == null);
var inst_15541 = cljs.core._EQ_.call(null,inst_15539__$1,change);
var inst_15542 = (inst_15540) || (inst_15541);
var state_15579__$1 = (function (){var statearr_15601 = state_15579;
(statearr_15601[(14)] = inst_15538__$1);

(statearr_15601[(11)] = inst_15539__$1);

return statearr_15601;
})();
if(cljs.core.truth_(inst_15542)){
var statearr_15602_15659 = state_15579__$1;
(statearr_15602_15659[(1)] = (23));

} else {
var statearr_15603_15660 = state_15579__$1;
(statearr_15603_15660[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (36))){
var inst_15529 = (state_15579[(12)]);
var inst_15507 = inst_15529;
var state_15579__$1 = (function (){var statearr_15604 = state_15579;
(statearr_15604[(7)] = inst_15507);

return statearr_15604;
})();
var statearr_15605_15661 = state_15579__$1;
(statearr_15605_15661[(2)] = null);

(statearr_15605_15661[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (29))){
var inst_15553 = (state_15579[(10)]);
var state_15579__$1 = state_15579;
var statearr_15606_15662 = state_15579__$1;
(statearr_15606_15662[(2)] = inst_15553);

(statearr_15606_15662[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (6))){
var state_15579__$1 = state_15579;
var statearr_15607_15663 = state_15579__$1;
(statearr_15607_15663[(2)] = false);

(statearr_15607_15663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (28))){
var inst_15549 = (state_15579[(2)]);
var inst_15550 = calc_state.call(null);
var inst_15507 = inst_15550;
var state_15579__$1 = (function (){var statearr_15608 = state_15579;
(statearr_15608[(15)] = inst_15549);

(statearr_15608[(7)] = inst_15507);

return statearr_15608;
})();
var statearr_15609_15664 = state_15579__$1;
(statearr_15609_15664[(2)] = null);

(statearr_15609_15664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (25))){
var inst_15575 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
var statearr_15610_15665 = state_15579__$1;
(statearr_15610_15665[(2)] = inst_15575);

(statearr_15610_15665[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (34))){
var inst_15573 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
var statearr_15611_15666 = state_15579__$1;
(statearr_15611_15666[(2)] = inst_15573);

(statearr_15611_15666[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (17))){
var state_15579__$1 = state_15579;
var statearr_15612_15667 = state_15579__$1;
(statearr_15612_15667[(2)] = false);

(statearr_15612_15667[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (3))){
var state_15579__$1 = state_15579;
var statearr_15613_15668 = state_15579__$1;
(statearr_15613_15668[(2)] = false);

(statearr_15613_15668[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (12))){
var inst_15577 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15579__$1,inst_15577);
} else {
if((state_val_15580 === (2))){
var inst_15483 = (state_15579[(8)]);
var inst_15488 = inst_15483.cljs$lang$protocol_mask$partition0$;
var inst_15489 = (inst_15488 & (64));
var inst_15490 = inst_15483.cljs$core$ISeq$;
var inst_15491 = (inst_15489) || (inst_15490);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15491)){
var statearr_15614_15669 = state_15579__$1;
(statearr_15614_15669[(1)] = (5));

} else {
var statearr_15615_15670 = state_15579__$1;
(statearr_15615_15670[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (23))){
var inst_15538 = (state_15579[(14)]);
var inst_15544 = (inst_15538 == null);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15544)){
var statearr_15616_15671 = state_15579__$1;
(statearr_15616_15671[(1)] = (26));

} else {
var statearr_15617_15672 = state_15579__$1;
(statearr_15617_15672[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (35))){
var inst_15564 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
if(cljs.core.truth_(inst_15564)){
var statearr_15618_15673 = state_15579__$1;
(statearr_15618_15673[(1)] = (36));

} else {
var statearr_15619_15674 = state_15579__$1;
(statearr_15619_15674[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (19))){
var inst_15507 = (state_15579[(7)]);
var inst_15526 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15507);
var state_15579__$1 = state_15579;
var statearr_15620_15675 = state_15579__$1;
(statearr_15620_15675[(2)] = inst_15526);

(statearr_15620_15675[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (11))){
var inst_15507 = (state_15579[(7)]);
var inst_15511 = (inst_15507 == null);
var inst_15512 = cljs.core.not.call(null,inst_15511);
var state_15579__$1 = state_15579;
if(inst_15512){
var statearr_15621_15676 = state_15579__$1;
(statearr_15621_15676[(1)] = (13));

} else {
var statearr_15622_15677 = state_15579__$1;
(statearr_15622_15677[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (9))){
var inst_15483 = (state_15579[(8)]);
var state_15579__$1 = state_15579;
var statearr_15623_15678 = state_15579__$1;
(statearr_15623_15678[(2)] = inst_15483);

(statearr_15623_15678[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (5))){
var state_15579__$1 = state_15579;
var statearr_15624_15679 = state_15579__$1;
(statearr_15624_15679[(2)] = true);

(statearr_15624_15679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (14))){
var state_15579__$1 = state_15579;
var statearr_15625_15680 = state_15579__$1;
(statearr_15625_15680[(2)] = false);

(statearr_15625_15680[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (26))){
var inst_15539 = (state_15579[(11)]);
var inst_15546 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_15539);
var state_15579__$1 = state_15579;
var statearr_15626_15681 = state_15579__$1;
(statearr_15626_15681[(2)] = inst_15546);

(statearr_15626_15681[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (16))){
var state_15579__$1 = state_15579;
var statearr_15627_15682 = state_15579__$1;
(statearr_15627_15682[(2)] = true);

(statearr_15627_15682[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (38))){
var inst_15569 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
var statearr_15628_15683 = state_15579__$1;
(statearr_15628_15683[(2)] = inst_15569);

(statearr_15628_15683[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (30))){
var inst_15531 = (state_15579[(13)]);
var inst_15530 = (state_15579[(9)]);
var inst_15539 = (state_15579[(11)]);
var inst_15556 = cljs.core.empty_QMARK_.call(null,inst_15530);
var inst_15557 = inst_15531.call(null,inst_15539);
var inst_15558 = cljs.core.not.call(null,inst_15557);
var inst_15559 = (inst_15556) && (inst_15558);
var state_15579__$1 = state_15579;
var statearr_15629_15684 = state_15579__$1;
(statearr_15629_15684[(2)] = inst_15559);

(statearr_15629_15684[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (10))){
var inst_15483 = (state_15579[(8)]);
var inst_15503 = (state_15579[(2)]);
var inst_15504 = cljs.core.get.call(null,inst_15503,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_15505 = cljs.core.get.call(null,inst_15503,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_15506 = cljs.core.get.call(null,inst_15503,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_15507 = inst_15483;
var state_15579__$1 = (function (){var statearr_15630 = state_15579;
(statearr_15630[(16)] = inst_15506);

(statearr_15630[(17)] = inst_15505);

(statearr_15630[(18)] = inst_15504);

(statearr_15630[(7)] = inst_15507);

return statearr_15630;
})();
var statearr_15631_15685 = state_15579__$1;
(statearr_15631_15685[(2)] = null);

(statearr_15631_15685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (18))){
var inst_15521 = (state_15579[(2)]);
var state_15579__$1 = state_15579;
var statearr_15632_15686 = state_15579__$1;
(statearr_15632_15686[(2)] = inst_15521);

(statearr_15632_15686[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (37))){
var state_15579__$1 = state_15579;
var statearr_15633_15687 = state_15579__$1;
(statearr_15633_15687[(2)] = null);

(statearr_15633_15687[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15580 === (8))){
var inst_15483 = (state_15579[(8)]);
var inst_15500 = cljs.core.apply.call(null,cljs.core.hash_map,inst_15483);
var state_15579__$1 = state_15579;
var statearr_15634_15688 = state_15579__$1;
(statearr_15634_15688[(2)] = inst_15500);

(statearr_15634_15688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__13767__auto__,c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__13768__auto__ = null;
var cljs$core$async$mix_$_state_machine__13768__auto____0 = (function (){
var statearr_15638 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15638[(0)] = cljs$core$async$mix_$_state_machine__13768__auto__);

(statearr_15638[(1)] = (1));

return statearr_15638;
});
var cljs$core$async$mix_$_state_machine__13768__auto____1 = (function (state_15579){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_15579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e15639){if((e15639 instanceof Object)){
var ex__13771__auto__ = e15639;
var statearr_15640_15689 = state_15579;
(statearr_15640_15689[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15690 = state_15579;
state_15579 = G__15690;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13768__auto__ = function(state_15579){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13768__auto____1.call(this,state_15579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13768__auto____0;
cljs$core$async$mix_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13768__auto____1;
return cljs$core$async$mix_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__13881__auto__ = (function (){var statearr_15641 = f__13880__auto__.call(null);
(statearr_15641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___15642);

return statearr_15641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___15642,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15691 = [];
var len__7484__auto___15694 = arguments.length;
var i__7485__auto___15695 = (0);
while(true){
if((i__7485__auto___15695 < len__7484__auto___15694)){
args15691.push((arguments[i__7485__auto___15695]));

var G__15696 = (i__7485__auto___15695 + (1));
i__7485__auto___15695 = G__15696;
continue;
} else {
}
break;
}

var G__15693 = args15691.length;
switch (G__15693) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15691.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15699 = [];
var len__7484__auto___15824 = arguments.length;
var i__7485__auto___15825 = (0);
while(true){
if((i__7485__auto___15825 < len__7484__auto___15824)){
args15699.push((arguments[i__7485__auto___15825]));

var G__15826 = (i__7485__auto___15825 + (1));
i__7485__auto___15825 = G__15826;
continue;
} else {
}
break;
}

var G__15701 = args15699.length;
switch (G__15701) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15699.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__15698_SHARP_){
if(cljs.core.truth_(p1__15698_SHARP_.call(null,topic))){
return p1__15698_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15698_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15702 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15702 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15703){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15703 = meta15703;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15704,meta15703__$1){
var self__ = this;
var _15704__$1 = this;
return (new cljs.core.async.t_cljs$core$async15702(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15703__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15704){
var self__ = this;
var _15704__$1 = this;
return self__.meta15703;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15703","meta15703",-183966086,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15702.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15702.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15702";

cljs.core.async.t_cljs$core$async15702.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15702");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15702 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15702(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15703){
return (new cljs.core.async.t_cljs$core$async15702(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15703));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15702(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13879__auto___15828 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___15828,mults,ensure_mult,p){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___15828,mults,ensure_mult,p){
return (function (state_15776){
var state_val_15777 = (state_15776[(1)]);
if((state_val_15777 === (7))){
var inst_15772 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15778_15829 = state_15776__$1;
(statearr_15778_15829[(2)] = inst_15772);

(statearr_15778_15829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (20))){
var state_15776__$1 = state_15776;
var statearr_15779_15830 = state_15776__$1;
(statearr_15779_15830[(2)] = null);

(statearr_15779_15830[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (1))){
var state_15776__$1 = state_15776;
var statearr_15780_15831 = state_15776__$1;
(statearr_15780_15831[(2)] = null);

(statearr_15780_15831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (24))){
var inst_15755 = (state_15776[(7)]);
var inst_15764 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15755);
var state_15776__$1 = state_15776;
var statearr_15781_15832 = state_15776__$1;
(statearr_15781_15832[(2)] = inst_15764);

(statearr_15781_15832[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (4))){
var inst_15707 = (state_15776[(8)]);
var inst_15707__$1 = (state_15776[(2)]);
var inst_15708 = (inst_15707__$1 == null);
var state_15776__$1 = (function (){var statearr_15782 = state_15776;
(statearr_15782[(8)] = inst_15707__$1);

return statearr_15782;
})();
if(cljs.core.truth_(inst_15708)){
var statearr_15783_15833 = state_15776__$1;
(statearr_15783_15833[(1)] = (5));

} else {
var statearr_15784_15834 = state_15776__$1;
(statearr_15784_15834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (15))){
var inst_15749 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15785_15835 = state_15776__$1;
(statearr_15785_15835[(2)] = inst_15749);

(statearr_15785_15835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (21))){
var inst_15769 = (state_15776[(2)]);
var state_15776__$1 = (function (){var statearr_15786 = state_15776;
(statearr_15786[(9)] = inst_15769);

return statearr_15786;
})();
var statearr_15787_15836 = state_15776__$1;
(statearr_15787_15836[(2)] = null);

(statearr_15787_15836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (13))){
var inst_15731 = (state_15776[(10)]);
var inst_15733 = cljs.core.chunked_seq_QMARK_.call(null,inst_15731);
var state_15776__$1 = state_15776;
if(inst_15733){
var statearr_15788_15837 = state_15776__$1;
(statearr_15788_15837[(1)] = (16));

} else {
var statearr_15789_15838 = state_15776__$1;
(statearr_15789_15838[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (22))){
var inst_15761 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15761)){
var statearr_15790_15839 = state_15776__$1;
(statearr_15790_15839[(1)] = (23));

} else {
var statearr_15791_15840 = state_15776__$1;
(statearr_15791_15840[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (6))){
var inst_15707 = (state_15776[(8)]);
var inst_15757 = (state_15776[(11)]);
var inst_15755 = (state_15776[(7)]);
var inst_15755__$1 = topic_fn.call(null,inst_15707);
var inst_15756 = cljs.core.deref.call(null,mults);
var inst_15757__$1 = cljs.core.get.call(null,inst_15756,inst_15755__$1);
var state_15776__$1 = (function (){var statearr_15792 = state_15776;
(statearr_15792[(11)] = inst_15757__$1);

(statearr_15792[(7)] = inst_15755__$1);

return statearr_15792;
})();
if(cljs.core.truth_(inst_15757__$1)){
var statearr_15793_15841 = state_15776__$1;
(statearr_15793_15841[(1)] = (19));

} else {
var statearr_15794_15842 = state_15776__$1;
(statearr_15794_15842[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (25))){
var inst_15766 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15795_15843 = state_15776__$1;
(statearr_15795_15843[(2)] = inst_15766);

(statearr_15795_15843[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (17))){
var inst_15731 = (state_15776[(10)]);
var inst_15740 = cljs.core.first.call(null,inst_15731);
var inst_15741 = cljs.core.async.muxch_STAR_.call(null,inst_15740);
var inst_15742 = cljs.core.async.close_BANG_.call(null,inst_15741);
var inst_15743 = cljs.core.next.call(null,inst_15731);
var inst_15717 = inst_15743;
var inst_15718 = null;
var inst_15719 = (0);
var inst_15720 = (0);
var state_15776__$1 = (function (){var statearr_15796 = state_15776;
(statearr_15796[(12)] = inst_15742);

(statearr_15796[(13)] = inst_15719);

(statearr_15796[(14)] = inst_15717);

(statearr_15796[(15)] = inst_15720);

(statearr_15796[(16)] = inst_15718);

return statearr_15796;
})();
var statearr_15797_15844 = state_15776__$1;
(statearr_15797_15844[(2)] = null);

(statearr_15797_15844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (3))){
var inst_15774 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15776__$1,inst_15774);
} else {
if((state_val_15777 === (12))){
var inst_15751 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15798_15845 = state_15776__$1;
(statearr_15798_15845[(2)] = inst_15751);

(statearr_15798_15845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (2))){
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15776__$1,(4),ch);
} else {
if((state_val_15777 === (23))){
var state_15776__$1 = state_15776;
var statearr_15799_15846 = state_15776__$1;
(statearr_15799_15846[(2)] = null);

(statearr_15799_15846[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (19))){
var inst_15707 = (state_15776[(8)]);
var inst_15757 = (state_15776[(11)]);
var inst_15759 = cljs.core.async.muxch_STAR_.call(null,inst_15757);
var state_15776__$1 = state_15776;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15776__$1,(22),inst_15759,inst_15707);
} else {
if((state_val_15777 === (11))){
var inst_15717 = (state_15776[(14)]);
var inst_15731 = (state_15776[(10)]);
var inst_15731__$1 = cljs.core.seq.call(null,inst_15717);
var state_15776__$1 = (function (){var statearr_15800 = state_15776;
(statearr_15800[(10)] = inst_15731__$1);

return statearr_15800;
})();
if(inst_15731__$1){
var statearr_15801_15847 = state_15776__$1;
(statearr_15801_15847[(1)] = (13));

} else {
var statearr_15802_15848 = state_15776__$1;
(statearr_15802_15848[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (9))){
var inst_15753 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15803_15849 = state_15776__$1;
(statearr_15803_15849[(2)] = inst_15753);

(statearr_15803_15849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (5))){
var inst_15714 = cljs.core.deref.call(null,mults);
var inst_15715 = cljs.core.vals.call(null,inst_15714);
var inst_15716 = cljs.core.seq.call(null,inst_15715);
var inst_15717 = inst_15716;
var inst_15718 = null;
var inst_15719 = (0);
var inst_15720 = (0);
var state_15776__$1 = (function (){var statearr_15804 = state_15776;
(statearr_15804[(13)] = inst_15719);

(statearr_15804[(14)] = inst_15717);

(statearr_15804[(15)] = inst_15720);

(statearr_15804[(16)] = inst_15718);

return statearr_15804;
})();
var statearr_15805_15850 = state_15776__$1;
(statearr_15805_15850[(2)] = null);

(statearr_15805_15850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (14))){
var state_15776__$1 = state_15776;
var statearr_15809_15851 = state_15776__$1;
(statearr_15809_15851[(2)] = null);

(statearr_15809_15851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (16))){
var inst_15731 = (state_15776[(10)]);
var inst_15735 = cljs.core.chunk_first.call(null,inst_15731);
var inst_15736 = cljs.core.chunk_rest.call(null,inst_15731);
var inst_15737 = cljs.core.count.call(null,inst_15735);
var inst_15717 = inst_15736;
var inst_15718 = inst_15735;
var inst_15719 = inst_15737;
var inst_15720 = (0);
var state_15776__$1 = (function (){var statearr_15810 = state_15776;
(statearr_15810[(13)] = inst_15719);

(statearr_15810[(14)] = inst_15717);

(statearr_15810[(15)] = inst_15720);

(statearr_15810[(16)] = inst_15718);

return statearr_15810;
})();
var statearr_15811_15852 = state_15776__$1;
(statearr_15811_15852[(2)] = null);

(statearr_15811_15852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (10))){
var inst_15719 = (state_15776[(13)]);
var inst_15717 = (state_15776[(14)]);
var inst_15720 = (state_15776[(15)]);
var inst_15718 = (state_15776[(16)]);
var inst_15725 = cljs.core._nth.call(null,inst_15718,inst_15720);
var inst_15726 = cljs.core.async.muxch_STAR_.call(null,inst_15725);
var inst_15727 = cljs.core.async.close_BANG_.call(null,inst_15726);
var inst_15728 = (inst_15720 + (1));
var tmp15806 = inst_15719;
var tmp15807 = inst_15717;
var tmp15808 = inst_15718;
var inst_15717__$1 = tmp15807;
var inst_15718__$1 = tmp15808;
var inst_15719__$1 = tmp15806;
var inst_15720__$1 = inst_15728;
var state_15776__$1 = (function (){var statearr_15812 = state_15776;
(statearr_15812[(13)] = inst_15719__$1);

(statearr_15812[(14)] = inst_15717__$1);

(statearr_15812[(15)] = inst_15720__$1);

(statearr_15812[(17)] = inst_15727);

(statearr_15812[(16)] = inst_15718__$1);

return statearr_15812;
})();
var statearr_15813_15853 = state_15776__$1;
(statearr_15813_15853[(2)] = null);

(statearr_15813_15853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (18))){
var inst_15746 = (state_15776[(2)]);
var state_15776__$1 = state_15776;
var statearr_15814_15854 = state_15776__$1;
(statearr_15814_15854[(2)] = inst_15746);

(statearr_15814_15854[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15777 === (8))){
var inst_15719 = (state_15776[(13)]);
var inst_15720 = (state_15776[(15)]);
var inst_15722 = (inst_15720 < inst_15719);
var inst_15723 = inst_15722;
var state_15776__$1 = state_15776;
if(cljs.core.truth_(inst_15723)){
var statearr_15815_15855 = state_15776__$1;
(statearr_15815_15855[(1)] = (10));

} else {
var statearr_15816_15856 = state_15776__$1;
(statearr_15816_15856[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___15828,mults,ensure_mult,p))
;
return ((function (switch__13767__auto__,c__13879__auto___15828,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_15820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15820[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_15820[(1)] = (1));

return statearr_15820;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_15776){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_15776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e15821){if((e15821 instanceof Object)){
var ex__13771__auto__ = e15821;
var statearr_15822_15857 = state_15776;
(statearr_15822_15857[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15858 = state_15776;
state_15776 = G__15858;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_15776){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_15776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___15828,mults,ensure_mult,p))
})();
var state__13881__auto__ = (function (){var statearr_15823 = f__13880__auto__.call(null);
(statearr_15823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___15828);

return statearr_15823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___15828,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15859 = [];
var len__7484__auto___15862 = arguments.length;
var i__7485__auto___15863 = (0);
while(true){
if((i__7485__auto___15863 < len__7484__auto___15862)){
args15859.push((arguments[i__7485__auto___15863]));

var G__15864 = (i__7485__auto___15863 + (1));
i__7485__auto___15863 = G__15864;
continue;
} else {
}
break;
}

var G__15861 = args15859.length;
switch (G__15861) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15859.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15866 = [];
var len__7484__auto___15869 = arguments.length;
var i__7485__auto___15870 = (0);
while(true){
if((i__7485__auto___15870 < len__7484__auto___15869)){
args15866.push((arguments[i__7485__auto___15870]));

var G__15871 = (i__7485__auto___15870 + (1));
i__7485__auto___15870 = G__15871;
continue;
} else {
}
break;
}

var G__15868 = args15866.length;
switch (G__15868) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15866.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15873 = [];
var len__7484__auto___15944 = arguments.length;
var i__7485__auto___15945 = (0);
while(true){
if((i__7485__auto___15945 < len__7484__auto___15944)){
args15873.push((arguments[i__7485__auto___15945]));

var G__15946 = (i__7485__auto___15945 + (1));
i__7485__auto___15945 = G__15946;
continue;
} else {
}
break;
}

var G__15875 = args15873.length;
switch (G__15875) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15873.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__13879__auto___15948 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15914){
var state_val_15915 = (state_15914[(1)]);
if((state_val_15915 === (7))){
var state_15914__$1 = state_15914;
var statearr_15916_15949 = state_15914__$1;
(statearr_15916_15949[(2)] = null);

(statearr_15916_15949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (1))){
var state_15914__$1 = state_15914;
var statearr_15917_15950 = state_15914__$1;
(statearr_15917_15950[(2)] = null);

(statearr_15917_15950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (4))){
var inst_15878 = (state_15914[(7)]);
var inst_15880 = (inst_15878 < cnt);
var state_15914__$1 = state_15914;
if(cljs.core.truth_(inst_15880)){
var statearr_15918_15951 = state_15914__$1;
(statearr_15918_15951[(1)] = (6));

} else {
var statearr_15919_15952 = state_15914__$1;
(statearr_15919_15952[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (15))){
var inst_15910 = (state_15914[(2)]);
var state_15914__$1 = state_15914;
var statearr_15920_15953 = state_15914__$1;
(statearr_15920_15953[(2)] = inst_15910);

(statearr_15920_15953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (13))){
var inst_15903 = cljs.core.async.close_BANG_.call(null,out);
var state_15914__$1 = state_15914;
var statearr_15921_15954 = state_15914__$1;
(statearr_15921_15954[(2)] = inst_15903);

(statearr_15921_15954[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (6))){
var state_15914__$1 = state_15914;
var statearr_15922_15955 = state_15914__$1;
(statearr_15922_15955[(2)] = null);

(statearr_15922_15955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (3))){
var inst_15912 = (state_15914[(2)]);
var state_15914__$1 = state_15914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15914__$1,inst_15912);
} else {
if((state_val_15915 === (12))){
var inst_15900 = (state_15914[(8)]);
var inst_15900__$1 = (state_15914[(2)]);
var inst_15901 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15900__$1);
var state_15914__$1 = (function (){var statearr_15923 = state_15914;
(statearr_15923[(8)] = inst_15900__$1);

return statearr_15923;
})();
if(cljs.core.truth_(inst_15901)){
var statearr_15924_15956 = state_15914__$1;
(statearr_15924_15956[(1)] = (13));

} else {
var statearr_15925_15957 = state_15914__$1;
(statearr_15925_15957[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (2))){
var inst_15877 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15878 = (0);
var state_15914__$1 = (function (){var statearr_15926 = state_15914;
(statearr_15926[(7)] = inst_15878);

(statearr_15926[(9)] = inst_15877);

return statearr_15926;
})();
var statearr_15927_15958 = state_15914__$1;
(statearr_15927_15958[(2)] = null);

(statearr_15927_15958[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (11))){
var inst_15878 = (state_15914[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15914,(10),Object,null,(9));
var inst_15887 = chs__$1.call(null,inst_15878);
var inst_15888 = done.call(null,inst_15878);
var inst_15889 = cljs.core.async.take_BANG_.call(null,inst_15887,inst_15888);
var state_15914__$1 = state_15914;
var statearr_15928_15959 = state_15914__$1;
(statearr_15928_15959[(2)] = inst_15889);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15914__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (9))){
var inst_15878 = (state_15914[(7)]);
var inst_15891 = (state_15914[(2)]);
var inst_15892 = (inst_15878 + (1));
var inst_15878__$1 = inst_15892;
var state_15914__$1 = (function (){var statearr_15929 = state_15914;
(statearr_15929[(7)] = inst_15878__$1);

(statearr_15929[(10)] = inst_15891);

return statearr_15929;
})();
var statearr_15930_15960 = state_15914__$1;
(statearr_15930_15960[(2)] = null);

(statearr_15930_15960[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (5))){
var inst_15898 = (state_15914[(2)]);
var state_15914__$1 = (function (){var statearr_15931 = state_15914;
(statearr_15931[(11)] = inst_15898);

return statearr_15931;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15914__$1,(12),dchan);
} else {
if((state_val_15915 === (14))){
var inst_15900 = (state_15914[(8)]);
var inst_15905 = cljs.core.apply.call(null,f,inst_15900);
var state_15914__$1 = state_15914;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15914__$1,(16),out,inst_15905);
} else {
if((state_val_15915 === (16))){
var inst_15907 = (state_15914[(2)]);
var state_15914__$1 = (function (){var statearr_15932 = state_15914;
(statearr_15932[(12)] = inst_15907);

return statearr_15932;
})();
var statearr_15933_15961 = state_15914__$1;
(statearr_15933_15961[(2)] = null);

(statearr_15933_15961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (10))){
var inst_15882 = (state_15914[(2)]);
var inst_15883 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15914__$1 = (function (){var statearr_15934 = state_15914;
(statearr_15934[(13)] = inst_15882);

return statearr_15934;
})();
var statearr_15935_15962 = state_15914__$1;
(statearr_15935_15962[(2)] = inst_15883);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15914__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15915 === (8))){
var inst_15896 = (state_15914[(2)]);
var state_15914__$1 = state_15914;
var statearr_15936_15963 = state_15914__$1;
(statearr_15936_15963[(2)] = inst_15896);

(statearr_15936_15963[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__13767__auto__,c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_15940 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15940[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_15940[(1)] = (1));

return statearr_15940;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_15914){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_15914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e15941){if((e15941 instanceof Object)){
var ex__13771__auto__ = e15941;
var statearr_15942_15964 = state_15914;
(statearr_15942_15964[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15914);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15941;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15965 = state_15914;
state_15914 = G__15965;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_15914){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_15914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__13881__auto__ = (function (){var statearr_15943 = f__13880__auto__.call(null);
(statearr_15943[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___15948);

return statearr_15943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___15948,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15967 = [];
var len__7484__auto___16025 = arguments.length;
var i__7485__auto___16026 = (0);
while(true){
if((i__7485__auto___16026 < len__7484__auto___16025)){
args15967.push((arguments[i__7485__auto___16026]));

var G__16027 = (i__7485__auto___16026 + (1));
i__7485__auto___16026 = G__16027;
continue;
} else {
}
break;
}

var G__15969 = args15967.length;
switch (G__15969) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15967.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16029 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16029,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16029,out){
return (function (state_16001){
var state_val_16002 = (state_16001[(1)]);
if((state_val_16002 === (7))){
var inst_15980 = (state_16001[(7)]);
var inst_15981 = (state_16001[(8)]);
var inst_15980__$1 = (state_16001[(2)]);
var inst_15981__$1 = cljs.core.nth.call(null,inst_15980__$1,(0),null);
var inst_15982 = cljs.core.nth.call(null,inst_15980__$1,(1),null);
var inst_15983 = (inst_15981__$1 == null);
var state_16001__$1 = (function (){var statearr_16003 = state_16001;
(statearr_16003[(7)] = inst_15980__$1);

(statearr_16003[(8)] = inst_15981__$1);

(statearr_16003[(9)] = inst_15982);

return statearr_16003;
})();
if(cljs.core.truth_(inst_15983)){
var statearr_16004_16030 = state_16001__$1;
(statearr_16004_16030[(1)] = (8));

} else {
var statearr_16005_16031 = state_16001__$1;
(statearr_16005_16031[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (1))){
var inst_15970 = cljs.core.vec.call(null,chs);
var inst_15971 = inst_15970;
var state_16001__$1 = (function (){var statearr_16006 = state_16001;
(statearr_16006[(10)] = inst_15971);

return statearr_16006;
})();
var statearr_16007_16032 = state_16001__$1;
(statearr_16007_16032[(2)] = null);

(statearr_16007_16032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (4))){
var inst_15971 = (state_16001[(10)]);
var state_16001__$1 = state_16001;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16001__$1,(7),inst_15971);
} else {
if((state_val_16002 === (6))){
var inst_15997 = (state_16001[(2)]);
var state_16001__$1 = state_16001;
var statearr_16008_16033 = state_16001__$1;
(statearr_16008_16033[(2)] = inst_15997);

(statearr_16008_16033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (3))){
var inst_15999 = (state_16001[(2)]);
var state_16001__$1 = state_16001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16001__$1,inst_15999);
} else {
if((state_val_16002 === (2))){
var inst_15971 = (state_16001[(10)]);
var inst_15973 = cljs.core.count.call(null,inst_15971);
var inst_15974 = (inst_15973 > (0));
var state_16001__$1 = state_16001;
if(cljs.core.truth_(inst_15974)){
var statearr_16010_16034 = state_16001__$1;
(statearr_16010_16034[(1)] = (4));

} else {
var statearr_16011_16035 = state_16001__$1;
(statearr_16011_16035[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (11))){
var inst_15971 = (state_16001[(10)]);
var inst_15990 = (state_16001[(2)]);
var tmp16009 = inst_15971;
var inst_15971__$1 = tmp16009;
var state_16001__$1 = (function (){var statearr_16012 = state_16001;
(statearr_16012[(11)] = inst_15990);

(statearr_16012[(10)] = inst_15971__$1);

return statearr_16012;
})();
var statearr_16013_16036 = state_16001__$1;
(statearr_16013_16036[(2)] = null);

(statearr_16013_16036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (9))){
var inst_15981 = (state_16001[(8)]);
var state_16001__$1 = state_16001;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16001__$1,(11),out,inst_15981);
} else {
if((state_val_16002 === (5))){
var inst_15995 = cljs.core.async.close_BANG_.call(null,out);
var state_16001__$1 = state_16001;
var statearr_16014_16037 = state_16001__$1;
(statearr_16014_16037[(2)] = inst_15995);

(statearr_16014_16037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (10))){
var inst_15993 = (state_16001[(2)]);
var state_16001__$1 = state_16001;
var statearr_16015_16038 = state_16001__$1;
(statearr_16015_16038[(2)] = inst_15993);

(statearr_16015_16038[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16002 === (8))){
var inst_15980 = (state_16001[(7)]);
var inst_15981 = (state_16001[(8)]);
var inst_15982 = (state_16001[(9)]);
var inst_15971 = (state_16001[(10)]);
var inst_15985 = (function (){var cs = inst_15971;
var vec__15976 = inst_15980;
var v = inst_15981;
var c = inst_15982;
return ((function (cs,vec__15976,v,c,inst_15980,inst_15981,inst_15982,inst_15971,state_val_16002,c__13879__auto___16029,out){
return (function (p1__15966_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15966_SHARP_);
});
;})(cs,vec__15976,v,c,inst_15980,inst_15981,inst_15982,inst_15971,state_val_16002,c__13879__auto___16029,out))
})();
var inst_15986 = cljs.core.filterv.call(null,inst_15985,inst_15971);
var inst_15971__$1 = inst_15986;
var state_16001__$1 = (function (){var statearr_16016 = state_16001;
(statearr_16016[(10)] = inst_15971__$1);

return statearr_16016;
})();
var statearr_16017_16039 = state_16001__$1;
(statearr_16017_16039[(2)] = null);

(statearr_16017_16039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16029,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16029,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16021 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16021[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16021[(1)] = (1));

return statearr_16021;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16001){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16022){if((e16022 instanceof Object)){
var ex__13771__auto__ = e16022;
var statearr_16023_16040 = state_16001;
(statearr_16023_16040[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16001);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16041 = state_16001;
state_16001 = G__16041;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16001){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16029,out))
})();
var state__13881__auto__ = (function (){var statearr_16024 = f__13880__auto__.call(null);
(statearr_16024[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16029);

return statearr_16024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16029,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args16042 = [];
var len__7484__auto___16091 = arguments.length;
var i__7485__auto___16092 = (0);
while(true){
if((i__7485__auto___16092 < len__7484__auto___16091)){
args16042.push((arguments[i__7485__auto___16092]));

var G__16093 = (i__7485__auto___16092 + (1));
i__7485__auto___16092 = G__16093;
continue;
} else {
}
break;
}

var G__16044 = args16042.length;
switch (G__16044) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16042.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16095 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16095,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16095,out){
return (function (state_16068){
var state_val_16069 = (state_16068[(1)]);
if((state_val_16069 === (7))){
var inst_16050 = (state_16068[(7)]);
var inst_16050__$1 = (state_16068[(2)]);
var inst_16051 = (inst_16050__$1 == null);
var inst_16052 = cljs.core.not.call(null,inst_16051);
var state_16068__$1 = (function (){var statearr_16070 = state_16068;
(statearr_16070[(7)] = inst_16050__$1);

return statearr_16070;
})();
if(inst_16052){
var statearr_16071_16096 = state_16068__$1;
(statearr_16071_16096[(1)] = (8));

} else {
var statearr_16072_16097 = state_16068__$1;
(statearr_16072_16097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (1))){
var inst_16045 = (0);
var state_16068__$1 = (function (){var statearr_16073 = state_16068;
(statearr_16073[(8)] = inst_16045);

return statearr_16073;
})();
var statearr_16074_16098 = state_16068__$1;
(statearr_16074_16098[(2)] = null);

(statearr_16074_16098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (4))){
var state_16068__$1 = state_16068;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16068__$1,(7),ch);
} else {
if((state_val_16069 === (6))){
var inst_16063 = (state_16068[(2)]);
var state_16068__$1 = state_16068;
var statearr_16075_16099 = state_16068__$1;
(statearr_16075_16099[(2)] = inst_16063);

(statearr_16075_16099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (3))){
var inst_16065 = (state_16068[(2)]);
var inst_16066 = cljs.core.async.close_BANG_.call(null,out);
var state_16068__$1 = (function (){var statearr_16076 = state_16068;
(statearr_16076[(9)] = inst_16065);

return statearr_16076;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16068__$1,inst_16066);
} else {
if((state_val_16069 === (2))){
var inst_16045 = (state_16068[(8)]);
var inst_16047 = (inst_16045 < n);
var state_16068__$1 = state_16068;
if(cljs.core.truth_(inst_16047)){
var statearr_16077_16100 = state_16068__$1;
(statearr_16077_16100[(1)] = (4));

} else {
var statearr_16078_16101 = state_16068__$1;
(statearr_16078_16101[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (11))){
var inst_16045 = (state_16068[(8)]);
var inst_16055 = (state_16068[(2)]);
var inst_16056 = (inst_16045 + (1));
var inst_16045__$1 = inst_16056;
var state_16068__$1 = (function (){var statearr_16079 = state_16068;
(statearr_16079[(10)] = inst_16055);

(statearr_16079[(8)] = inst_16045__$1);

return statearr_16079;
})();
var statearr_16080_16102 = state_16068__$1;
(statearr_16080_16102[(2)] = null);

(statearr_16080_16102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (9))){
var state_16068__$1 = state_16068;
var statearr_16081_16103 = state_16068__$1;
(statearr_16081_16103[(2)] = null);

(statearr_16081_16103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (5))){
var state_16068__$1 = state_16068;
var statearr_16082_16104 = state_16068__$1;
(statearr_16082_16104[(2)] = null);

(statearr_16082_16104[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (10))){
var inst_16060 = (state_16068[(2)]);
var state_16068__$1 = state_16068;
var statearr_16083_16105 = state_16068__$1;
(statearr_16083_16105[(2)] = inst_16060);

(statearr_16083_16105[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16069 === (8))){
var inst_16050 = (state_16068[(7)]);
var state_16068__$1 = state_16068;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16068__$1,(11),out,inst_16050);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16095,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16095,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16087 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16087[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16087[(1)] = (1));

return statearr_16087;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16068){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16068);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16088){if((e16088 instanceof Object)){
var ex__13771__auto__ = e16088;
var statearr_16089_16106 = state_16068;
(statearr_16089_16106[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16068);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16088;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16107 = state_16068;
state_16068 = G__16107;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16068){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16095,out))
})();
var state__13881__auto__ = (function (){var statearr_16090 = f__13880__auto__.call(null);
(statearr_16090[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16095);

return statearr_16090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16095,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16115 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16115 = (function (map_LT_,f,ch,meta16116){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16116 = meta16116;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16117,meta16116__$1){
var self__ = this;
var _16117__$1 = this;
return (new cljs.core.async.t_cljs$core$async16115(self__.map_LT_,self__.f,self__.ch,meta16116__$1));
});

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16117){
var self__ = this;
var _16117__$1 = this;
return self__.meta16116;
});

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16118 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16118 = (function (map_LT_,f,ch,meta16116,_,fn1,meta16119){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta16116 = meta16116;
this._ = _;
this.fn1 = fn1;
this.meta16119 = meta16119;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16120,meta16119__$1){
var self__ = this;
var _16120__$1 = this;
return (new cljs.core.async.t_cljs$core$async16118(self__.map_LT_,self__.f,self__.ch,self__.meta16116,self__._,self__.fn1,meta16119__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16120){
var self__ = this;
var _16120__$1 = this;
return self__.meta16119;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16108_SHARP_){
return f1.call(null,(((p1__16108_SHARP_ == null))?null:self__.f.call(null,p1__16108_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16116","meta16116",-1068649359,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async16115","cljs.core.async/t_cljs$core$async16115",1047741699,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta16119","meta16119",1480382016,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16118.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16118.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16118";

cljs.core.async.t_cljs$core$async16118.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async16118");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16118 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16118(map_LT___$1,f__$1,ch__$1,meta16116__$1,___$2,fn1__$1,meta16119){
return (new cljs.core.async.t_cljs$core$async16118(map_LT___$1,f__$1,ch__$1,meta16116__$1,___$2,fn1__$1,meta16119));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16118(self__.map_LT_,self__.f,self__.ch,self__.meta16116,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16115.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16115.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16116","meta16116",-1068649359,null)], null);
});

cljs.core.async.t_cljs$core$async16115.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16115.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16115";

cljs.core.async.t_cljs$core$async16115.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async16115");
});

cljs.core.async.__GT_t_cljs$core$async16115 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16115(map_LT___$1,f__$1,ch__$1,meta16116){
return (new cljs.core.async.t_cljs$core$async16115(map_LT___$1,f__$1,ch__$1,meta16116));
});

}

return (new cljs.core.async.t_cljs$core$async16115(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16124 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16124 = (function (map_GT_,f,ch,meta16125){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta16125 = meta16125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16126,meta16125__$1){
var self__ = this;
var _16126__$1 = this;
return (new cljs.core.async.t_cljs$core$async16124(self__.map_GT_,self__.f,self__.ch,meta16125__$1));
});

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16126){
var self__ = this;
var _16126__$1 = this;
return self__.meta16125;
});

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16124.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async16124.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16125","meta16125",519741344,null)], null);
});

cljs.core.async.t_cljs$core$async16124.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16124.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16124";

cljs.core.async.t_cljs$core$async16124.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async16124");
});

cljs.core.async.__GT_t_cljs$core$async16124 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16124(map_GT___$1,f__$1,ch__$1,meta16125){
return (new cljs.core.async.t_cljs$core$async16124(map_GT___$1,f__$1,ch__$1,meta16125));
});

}

return (new cljs.core.async.t_cljs$core$async16124(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16130 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16130 = (function (filter_GT_,p,ch,meta16131){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta16131 = meta16131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16132,meta16131__$1){
var self__ = this;
var _16132__$1 = this;
return (new cljs.core.async.t_cljs$core$async16130(self__.filter_GT_,self__.p,self__.ch,meta16131__$1));
});

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16132){
var self__ = this;
var _16132__$1 = this;
return self__.meta16131;
});

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async16130.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16130.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta16131","meta16131",-1630893665,null)], null);
});

cljs.core.async.t_cljs$core$async16130.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16130";

cljs.core.async.t_cljs$core$async16130.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async16130");
});

cljs.core.async.__GT_t_cljs$core$async16130 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16130(filter_GT___$1,p__$1,ch__$1,meta16131){
return (new cljs.core.async.t_cljs$core$async16130(filter_GT___$1,p__$1,ch__$1,meta16131));
});

}

return (new cljs.core.async.t_cljs$core$async16130(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args16133 = [];
var len__7484__auto___16177 = arguments.length;
var i__7485__auto___16178 = (0);
while(true){
if((i__7485__auto___16178 < len__7484__auto___16177)){
args16133.push((arguments[i__7485__auto___16178]));

var G__16179 = (i__7485__auto___16178 + (1));
i__7485__auto___16178 = G__16179;
continue;
} else {
}
break;
}

var G__16135 = args16133.length;
switch (G__16135) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16133.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16181 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16181,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16181,out){
return (function (state_16156){
var state_val_16157 = (state_16156[(1)]);
if((state_val_16157 === (7))){
var inst_16152 = (state_16156[(2)]);
var state_16156__$1 = state_16156;
var statearr_16158_16182 = state_16156__$1;
(statearr_16158_16182[(2)] = inst_16152);

(statearr_16158_16182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (1))){
var state_16156__$1 = state_16156;
var statearr_16159_16183 = state_16156__$1;
(statearr_16159_16183[(2)] = null);

(statearr_16159_16183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (4))){
var inst_16138 = (state_16156[(7)]);
var inst_16138__$1 = (state_16156[(2)]);
var inst_16139 = (inst_16138__$1 == null);
var state_16156__$1 = (function (){var statearr_16160 = state_16156;
(statearr_16160[(7)] = inst_16138__$1);

return statearr_16160;
})();
if(cljs.core.truth_(inst_16139)){
var statearr_16161_16184 = state_16156__$1;
(statearr_16161_16184[(1)] = (5));

} else {
var statearr_16162_16185 = state_16156__$1;
(statearr_16162_16185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (6))){
var inst_16138 = (state_16156[(7)]);
var inst_16143 = p.call(null,inst_16138);
var state_16156__$1 = state_16156;
if(cljs.core.truth_(inst_16143)){
var statearr_16163_16186 = state_16156__$1;
(statearr_16163_16186[(1)] = (8));

} else {
var statearr_16164_16187 = state_16156__$1;
(statearr_16164_16187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (3))){
var inst_16154 = (state_16156[(2)]);
var state_16156__$1 = state_16156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16156__$1,inst_16154);
} else {
if((state_val_16157 === (2))){
var state_16156__$1 = state_16156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16156__$1,(4),ch);
} else {
if((state_val_16157 === (11))){
var inst_16146 = (state_16156[(2)]);
var state_16156__$1 = state_16156;
var statearr_16165_16188 = state_16156__$1;
(statearr_16165_16188[(2)] = inst_16146);

(statearr_16165_16188[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (9))){
var state_16156__$1 = state_16156;
var statearr_16166_16189 = state_16156__$1;
(statearr_16166_16189[(2)] = null);

(statearr_16166_16189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (5))){
var inst_16141 = cljs.core.async.close_BANG_.call(null,out);
var state_16156__$1 = state_16156;
var statearr_16167_16190 = state_16156__$1;
(statearr_16167_16190[(2)] = inst_16141);

(statearr_16167_16190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (10))){
var inst_16149 = (state_16156[(2)]);
var state_16156__$1 = (function (){var statearr_16168 = state_16156;
(statearr_16168[(8)] = inst_16149);

return statearr_16168;
})();
var statearr_16169_16191 = state_16156__$1;
(statearr_16169_16191[(2)] = null);

(statearr_16169_16191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16157 === (8))){
var inst_16138 = (state_16156[(7)]);
var state_16156__$1 = state_16156;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16156__$1,(11),out,inst_16138);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16181,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16181,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16173 = [null,null,null,null,null,null,null,null,null];
(statearr_16173[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16173[(1)] = (1));

return statearr_16173;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16156){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16174){if((e16174 instanceof Object)){
var ex__13771__auto__ = e16174;
var statearr_16175_16192 = state_16156;
(statearr_16175_16192[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16174;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16193 = state_16156;
state_16156 = G__16193;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16156){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16181,out))
})();
var state__13881__auto__ = (function (){var statearr_16176 = f__13880__auto__.call(null);
(statearr_16176[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16181);

return statearr_16176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16181,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args16194 = [];
var len__7484__auto___16197 = arguments.length;
var i__7485__auto___16198 = (0);
while(true){
if((i__7485__auto___16198 < len__7484__auto___16197)){
args16194.push((arguments[i__7485__auto___16198]));

var G__16199 = (i__7485__auto___16198 + (1));
i__7485__auto___16198 = G__16199;
continue;
} else {
}
break;
}

var G__16196 = args16194.length;
switch (G__16196) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16194.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__){
return (function (state_16366){
var state_val_16367 = (state_16366[(1)]);
if((state_val_16367 === (7))){
var inst_16362 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
var statearr_16368_16409 = state_16366__$1;
(statearr_16368_16409[(2)] = inst_16362);

(statearr_16368_16409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (20))){
var inst_16332 = (state_16366[(7)]);
var inst_16343 = (state_16366[(2)]);
var inst_16344 = cljs.core.next.call(null,inst_16332);
var inst_16318 = inst_16344;
var inst_16319 = null;
var inst_16320 = (0);
var inst_16321 = (0);
var state_16366__$1 = (function (){var statearr_16369 = state_16366;
(statearr_16369[(8)] = inst_16343);

(statearr_16369[(9)] = inst_16321);

(statearr_16369[(10)] = inst_16318);

(statearr_16369[(11)] = inst_16319);

(statearr_16369[(12)] = inst_16320);

return statearr_16369;
})();
var statearr_16370_16410 = state_16366__$1;
(statearr_16370_16410[(2)] = null);

(statearr_16370_16410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (1))){
var state_16366__$1 = state_16366;
var statearr_16371_16411 = state_16366__$1;
(statearr_16371_16411[(2)] = null);

(statearr_16371_16411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (4))){
var inst_16307 = (state_16366[(13)]);
var inst_16307__$1 = (state_16366[(2)]);
var inst_16308 = (inst_16307__$1 == null);
var state_16366__$1 = (function (){var statearr_16372 = state_16366;
(statearr_16372[(13)] = inst_16307__$1);

return statearr_16372;
})();
if(cljs.core.truth_(inst_16308)){
var statearr_16373_16412 = state_16366__$1;
(statearr_16373_16412[(1)] = (5));

} else {
var statearr_16374_16413 = state_16366__$1;
(statearr_16374_16413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (15))){
var state_16366__$1 = state_16366;
var statearr_16378_16414 = state_16366__$1;
(statearr_16378_16414[(2)] = null);

(statearr_16378_16414[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (21))){
var state_16366__$1 = state_16366;
var statearr_16379_16415 = state_16366__$1;
(statearr_16379_16415[(2)] = null);

(statearr_16379_16415[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (13))){
var inst_16321 = (state_16366[(9)]);
var inst_16318 = (state_16366[(10)]);
var inst_16319 = (state_16366[(11)]);
var inst_16320 = (state_16366[(12)]);
var inst_16328 = (state_16366[(2)]);
var inst_16329 = (inst_16321 + (1));
var tmp16375 = inst_16318;
var tmp16376 = inst_16319;
var tmp16377 = inst_16320;
var inst_16318__$1 = tmp16375;
var inst_16319__$1 = tmp16376;
var inst_16320__$1 = tmp16377;
var inst_16321__$1 = inst_16329;
var state_16366__$1 = (function (){var statearr_16380 = state_16366;
(statearr_16380[(9)] = inst_16321__$1);

(statearr_16380[(14)] = inst_16328);

(statearr_16380[(10)] = inst_16318__$1);

(statearr_16380[(11)] = inst_16319__$1);

(statearr_16380[(12)] = inst_16320__$1);

return statearr_16380;
})();
var statearr_16381_16416 = state_16366__$1;
(statearr_16381_16416[(2)] = null);

(statearr_16381_16416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (22))){
var state_16366__$1 = state_16366;
var statearr_16382_16417 = state_16366__$1;
(statearr_16382_16417[(2)] = null);

(statearr_16382_16417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (6))){
var inst_16307 = (state_16366[(13)]);
var inst_16316 = f.call(null,inst_16307);
var inst_16317 = cljs.core.seq.call(null,inst_16316);
var inst_16318 = inst_16317;
var inst_16319 = null;
var inst_16320 = (0);
var inst_16321 = (0);
var state_16366__$1 = (function (){var statearr_16383 = state_16366;
(statearr_16383[(9)] = inst_16321);

(statearr_16383[(10)] = inst_16318);

(statearr_16383[(11)] = inst_16319);

(statearr_16383[(12)] = inst_16320);

return statearr_16383;
})();
var statearr_16384_16418 = state_16366__$1;
(statearr_16384_16418[(2)] = null);

(statearr_16384_16418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (17))){
var inst_16332 = (state_16366[(7)]);
var inst_16336 = cljs.core.chunk_first.call(null,inst_16332);
var inst_16337 = cljs.core.chunk_rest.call(null,inst_16332);
var inst_16338 = cljs.core.count.call(null,inst_16336);
var inst_16318 = inst_16337;
var inst_16319 = inst_16336;
var inst_16320 = inst_16338;
var inst_16321 = (0);
var state_16366__$1 = (function (){var statearr_16385 = state_16366;
(statearr_16385[(9)] = inst_16321);

(statearr_16385[(10)] = inst_16318);

(statearr_16385[(11)] = inst_16319);

(statearr_16385[(12)] = inst_16320);

return statearr_16385;
})();
var statearr_16386_16419 = state_16366__$1;
(statearr_16386_16419[(2)] = null);

(statearr_16386_16419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (3))){
var inst_16364 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16366__$1,inst_16364);
} else {
if((state_val_16367 === (12))){
var inst_16352 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
var statearr_16387_16420 = state_16366__$1;
(statearr_16387_16420[(2)] = inst_16352);

(statearr_16387_16420[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (2))){
var state_16366__$1 = state_16366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16366__$1,(4),in$);
} else {
if((state_val_16367 === (23))){
var inst_16360 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
var statearr_16388_16421 = state_16366__$1;
(statearr_16388_16421[(2)] = inst_16360);

(statearr_16388_16421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (19))){
var inst_16347 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
var statearr_16389_16422 = state_16366__$1;
(statearr_16389_16422[(2)] = inst_16347);

(statearr_16389_16422[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (11))){
var inst_16318 = (state_16366[(10)]);
var inst_16332 = (state_16366[(7)]);
var inst_16332__$1 = cljs.core.seq.call(null,inst_16318);
var state_16366__$1 = (function (){var statearr_16390 = state_16366;
(statearr_16390[(7)] = inst_16332__$1);

return statearr_16390;
})();
if(inst_16332__$1){
var statearr_16391_16423 = state_16366__$1;
(statearr_16391_16423[(1)] = (14));

} else {
var statearr_16392_16424 = state_16366__$1;
(statearr_16392_16424[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (9))){
var inst_16354 = (state_16366[(2)]);
var inst_16355 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_16366__$1 = (function (){var statearr_16393 = state_16366;
(statearr_16393[(15)] = inst_16354);

return statearr_16393;
})();
if(cljs.core.truth_(inst_16355)){
var statearr_16394_16425 = state_16366__$1;
(statearr_16394_16425[(1)] = (21));

} else {
var statearr_16395_16426 = state_16366__$1;
(statearr_16395_16426[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (5))){
var inst_16310 = cljs.core.async.close_BANG_.call(null,out);
var state_16366__$1 = state_16366;
var statearr_16396_16427 = state_16366__$1;
(statearr_16396_16427[(2)] = inst_16310);

(statearr_16396_16427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (14))){
var inst_16332 = (state_16366[(7)]);
var inst_16334 = cljs.core.chunked_seq_QMARK_.call(null,inst_16332);
var state_16366__$1 = state_16366;
if(inst_16334){
var statearr_16397_16428 = state_16366__$1;
(statearr_16397_16428[(1)] = (17));

} else {
var statearr_16398_16429 = state_16366__$1;
(statearr_16398_16429[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (16))){
var inst_16350 = (state_16366[(2)]);
var state_16366__$1 = state_16366;
var statearr_16399_16430 = state_16366__$1;
(statearr_16399_16430[(2)] = inst_16350);

(statearr_16399_16430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16367 === (10))){
var inst_16321 = (state_16366[(9)]);
var inst_16319 = (state_16366[(11)]);
var inst_16326 = cljs.core._nth.call(null,inst_16319,inst_16321);
var state_16366__$1 = state_16366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16366__$1,(13),out,inst_16326);
} else {
if((state_val_16367 === (18))){
var inst_16332 = (state_16366[(7)]);
var inst_16341 = cljs.core.first.call(null,inst_16332);
var state_16366__$1 = state_16366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16366__$1,(20),out,inst_16341);
} else {
if((state_val_16367 === (8))){
var inst_16321 = (state_16366[(9)]);
var inst_16320 = (state_16366[(12)]);
var inst_16323 = (inst_16321 < inst_16320);
var inst_16324 = inst_16323;
var state_16366__$1 = state_16366;
if(cljs.core.truth_(inst_16324)){
var statearr_16400_16431 = state_16366__$1;
(statearr_16400_16431[(1)] = (10));

} else {
var statearr_16401_16432 = state_16366__$1;
(statearr_16401_16432[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__))
;
return ((function (switch__13767__auto__,c__13879__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____0 = (function (){
var statearr_16405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16405[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__);

(statearr_16405[(1)] = (1));

return statearr_16405;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____1 = (function (state_16366){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16406){if((e16406 instanceof Object)){
var ex__13771__auto__ = e16406;
var statearr_16407_16433 = state_16366;
(statearr_16407_16433[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16434 = state_16366;
state_16366 = G__16434;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__ = function(state_16366){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____1.call(this,state_16366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13768__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__))
})();
var state__13881__auto__ = (function (){var statearr_16408 = f__13880__auto__.call(null);
(statearr_16408[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_16408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__))
);

return c__13879__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args16435 = [];
var len__7484__auto___16438 = arguments.length;
var i__7485__auto___16439 = (0);
while(true){
if((i__7485__auto___16439 < len__7484__auto___16438)){
args16435.push((arguments[i__7485__auto___16439]));

var G__16440 = (i__7485__auto___16439 + (1));
i__7485__auto___16439 = G__16440;
continue;
} else {
}
break;
}

var G__16437 = args16435.length;
switch (G__16437) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16435.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args16442 = [];
var len__7484__auto___16445 = arguments.length;
var i__7485__auto___16446 = (0);
while(true){
if((i__7485__auto___16446 < len__7484__auto___16445)){
args16442.push((arguments[i__7485__auto___16446]));

var G__16447 = (i__7485__auto___16446 + (1));
i__7485__auto___16446 = G__16447;
continue;
} else {
}
break;
}

var G__16444 = args16442.length;
switch (G__16444) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16442.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args16449 = [];
var len__7484__auto___16500 = arguments.length;
var i__7485__auto___16501 = (0);
while(true){
if((i__7485__auto___16501 < len__7484__auto___16500)){
args16449.push((arguments[i__7485__auto___16501]));

var G__16502 = (i__7485__auto___16501 + (1));
i__7485__auto___16501 = G__16502;
continue;
} else {
}
break;
}

var G__16451 = args16449.length;
switch (G__16451) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16449.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16504 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16504,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16504,out){
return (function (state_16475){
var state_val_16476 = (state_16475[(1)]);
if((state_val_16476 === (7))){
var inst_16470 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16477_16505 = state_16475__$1;
(statearr_16477_16505[(2)] = inst_16470);

(statearr_16477_16505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (1))){
var inst_16452 = null;
var state_16475__$1 = (function (){var statearr_16478 = state_16475;
(statearr_16478[(7)] = inst_16452);

return statearr_16478;
})();
var statearr_16479_16506 = state_16475__$1;
(statearr_16479_16506[(2)] = null);

(statearr_16479_16506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (4))){
var inst_16455 = (state_16475[(8)]);
var inst_16455__$1 = (state_16475[(2)]);
var inst_16456 = (inst_16455__$1 == null);
var inst_16457 = cljs.core.not.call(null,inst_16456);
var state_16475__$1 = (function (){var statearr_16480 = state_16475;
(statearr_16480[(8)] = inst_16455__$1);

return statearr_16480;
})();
if(inst_16457){
var statearr_16481_16507 = state_16475__$1;
(statearr_16481_16507[(1)] = (5));

} else {
var statearr_16482_16508 = state_16475__$1;
(statearr_16482_16508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (6))){
var state_16475__$1 = state_16475;
var statearr_16483_16509 = state_16475__$1;
(statearr_16483_16509[(2)] = null);

(statearr_16483_16509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (3))){
var inst_16472 = (state_16475[(2)]);
var inst_16473 = cljs.core.async.close_BANG_.call(null,out);
var state_16475__$1 = (function (){var statearr_16484 = state_16475;
(statearr_16484[(9)] = inst_16472);

return statearr_16484;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16475__$1,inst_16473);
} else {
if((state_val_16476 === (2))){
var state_16475__$1 = state_16475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16475__$1,(4),ch);
} else {
if((state_val_16476 === (11))){
var inst_16455 = (state_16475[(8)]);
var inst_16464 = (state_16475[(2)]);
var inst_16452 = inst_16455;
var state_16475__$1 = (function (){var statearr_16485 = state_16475;
(statearr_16485[(7)] = inst_16452);

(statearr_16485[(10)] = inst_16464);

return statearr_16485;
})();
var statearr_16486_16510 = state_16475__$1;
(statearr_16486_16510[(2)] = null);

(statearr_16486_16510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (9))){
var inst_16455 = (state_16475[(8)]);
var state_16475__$1 = state_16475;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16475__$1,(11),out,inst_16455);
} else {
if((state_val_16476 === (5))){
var inst_16452 = (state_16475[(7)]);
var inst_16455 = (state_16475[(8)]);
var inst_16459 = cljs.core._EQ_.call(null,inst_16455,inst_16452);
var state_16475__$1 = state_16475;
if(inst_16459){
var statearr_16488_16511 = state_16475__$1;
(statearr_16488_16511[(1)] = (8));

} else {
var statearr_16489_16512 = state_16475__$1;
(statearr_16489_16512[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (10))){
var inst_16467 = (state_16475[(2)]);
var state_16475__$1 = state_16475;
var statearr_16490_16513 = state_16475__$1;
(statearr_16490_16513[(2)] = inst_16467);

(statearr_16490_16513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16476 === (8))){
var inst_16452 = (state_16475[(7)]);
var tmp16487 = inst_16452;
var inst_16452__$1 = tmp16487;
var state_16475__$1 = (function (){var statearr_16491 = state_16475;
(statearr_16491[(7)] = inst_16452__$1);

return statearr_16491;
})();
var statearr_16492_16514 = state_16475__$1;
(statearr_16492_16514[(2)] = null);

(statearr_16492_16514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16504,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16504,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16496 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16496[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16496[(1)] = (1));

return statearr_16496;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16475){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16497){if((e16497 instanceof Object)){
var ex__13771__auto__ = e16497;
var statearr_16498_16515 = state_16475;
(statearr_16498_16515[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16475);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16497;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16516 = state_16475;
state_16475 = G__16516;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16475){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16504,out))
})();
var state__13881__auto__ = (function (){var statearr_16499 = f__13880__auto__.call(null);
(statearr_16499[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16504);

return statearr_16499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16504,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args16517 = [];
var len__7484__auto___16587 = arguments.length;
var i__7485__auto___16588 = (0);
while(true){
if((i__7485__auto___16588 < len__7484__auto___16587)){
args16517.push((arguments[i__7485__auto___16588]));

var G__16589 = (i__7485__auto___16588 + (1));
i__7485__auto___16588 = G__16589;
continue;
} else {
}
break;
}

var G__16519 = args16517.length;
switch (G__16519) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16517.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16591 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16591,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16591,out){
return (function (state_16557){
var state_val_16558 = (state_16557[(1)]);
if((state_val_16558 === (7))){
var inst_16553 = (state_16557[(2)]);
var state_16557__$1 = state_16557;
var statearr_16559_16592 = state_16557__$1;
(statearr_16559_16592[(2)] = inst_16553);

(statearr_16559_16592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (1))){
var inst_16520 = (new Array(n));
var inst_16521 = inst_16520;
var inst_16522 = (0);
var state_16557__$1 = (function (){var statearr_16560 = state_16557;
(statearr_16560[(7)] = inst_16521);

(statearr_16560[(8)] = inst_16522);

return statearr_16560;
})();
var statearr_16561_16593 = state_16557__$1;
(statearr_16561_16593[(2)] = null);

(statearr_16561_16593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (4))){
var inst_16525 = (state_16557[(9)]);
var inst_16525__$1 = (state_16557[(2)]);
var inst_16526 = (inst_16525__$1 == null);
var inst_16527 = cljs.core.not.call(null,inst_16526);
var state_16557__$1 = (function (){var statearr_16562 = state_16557;
(statearr_16562[(9)] = inst_16525__$1);

return statearr_16562;
})();
if(inst_16527){
var statearr_16563_16594 = state_16557__$1;
(statearr_16563_16594[(1)] = (5));

} else {
var statearr_16564_16595 = state_16557__$1;
(statearr_16564_16595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (15))){
var inst_16547 = (state_16557[(2)]);
var state_16557__$1 = state_16557;
var statearr_16565_16596 = state_16557__$1;
(statearr_16565_16596[(2)] = inst_16547);

(statearr_16565_16596[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (13))){
var state_16557__$1 = state_16557;
var statearr_16566_16597 = state_16557__$1;
(statearr_16566_16597[(2)] = null);

(statearr_16566_16597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (6))){
var inst_16522 = (state_16557[(8)]);
var inst_16543 = (inst_16522 > (0));
var state_16557__$1 = state_16557;
if(cljs.core.truth_(inst_16543)){
var statearr_16567_16598 = state_16557__$1;
(statearr_16567_16598[(1)] = (12));

} else {
var statearr_16568_16599 = state_16557__$1;
(statearr_16568_16599[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (3))){
var inst_16555 = (state_16557[(2)]);
var state_16557__$1 = state_16557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16557__$1,inst_16555);
} else {
if((state_val_16558 === (12))){
var inst_16521 = (state_16557[(7)]);
var inst_16545 = cljs.core.vec.call(null,inst_16521);
var state_16557__$1 = state_16557;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16557__$1,(15),out,inst_16545);
} else {
if((state_val_16558 === (2))){
var state_16557__$1 = state_16557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16557__$1,(4),ch);
} else {
if((state_val_16558 === (11))){
var inst_16537 = (state_16557[(2)]);
var inst_16538 = (new Array(n));
var inst_16521 = inst_16538;
var inst_16522 = (0);
var state_16557__$1 = (function (){var statearr_16569 = state_16557;
(statearr_16569[(7)] = inst_16521);

(statearr_16569[(10)] = inst_16537);

(statearr_16569[(8)] = inst_16522);

return statearr_16569;
})();
var statearr_16570_16600 = state_16557__$1;
(statearr_16570_16600[(2)] = null);

(statearr_16570_16600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (9))){
var inst_16521 = (state_16557[(7)]);
var inst_16535 = cljs.core.vec.call(null,inst_16521);
var state_16557__$1 = state_16557;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16557__$1,(11),out,inst_16535);
} else {
if((state_val_16558 === (5))){
var inst_16530 = (state_16557[(11)]);
var inst_16521 = (state_16557[(7)]);
var inst_16525 = (state_16557[(9)]);
var inst_16522 = (state_16557[(8)]);
var inst_16529 = (inst_16521[inst_16522] = inst_16525);
var inst_16530__$1 = (inst_16522 + (1));
var inst_16531 = (inst_16530__$1 < n);
var state_16557__$1 = (function (){var statearr_16571 = state_16557;
(statearr_16571[(12)] = inst_16529);

(statearr_16571[(11)] = inst_16530__$1);

return statearr_16571;
})();
if(cljs.core.truth_(inst_16531)){
var statearr_16572_16601 = state_16557__$1;
(statearr_16572_16601[(1)] = (8));

} else {
var statearr_16573_16602 = state_16557__$1;
(statearr_16573_16602[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (14))){
var inst_16550 = (state_16557[(2)]);
var inst_16551 = cljs.core.async.close_BANG_.call(null,out);
var state_16557__$1 = (function (){var statearr_16575 = state_16557;
(statearr_16575[(13)] = inst_16550);

return statearr_16575;
})();
var statearr_16576_16603 = state_16557__$1;
(statearr_16576_16603[(2)] = inst_16551);

(statearr_16576_16603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (10))){
var inst_16541 = (state_16557[(2)]);
var state_16557__$1 = state_16557;
var statearr_16577_16604 = state_16557__$1;
(statearr_16577_16604[(2)] = inst_16541);

(statearr_16577_16604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16558 === (8))){
var inst_16530 = (state_16557[(11)]);
var inst_16521 = (state_16557[(7)]);
var tmp16574 = inst_16521;
var inst_16521__$1 = tmp16574;
var inst_16522 = inst_16530;
var state_16557__$1 = (function (){var statearr_16578 = state_16557;
(statearr_16578[(7)] = inst_16521__$1);

(statearr_16578[(8)] = inst_16522);

return statearr_16578;
})();
var statearr_16579_16605 = state_16557__$1;
(statearr_16579_16605[(2)] = null);

(statearr_16579_16605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16591,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16591,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16583[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16583[(1)] = (1));

return statearr_16583;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16557){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16584){if((e16584 instanceof Object)){
var ex__13771__auto__ = e16584;
var statearr_16585_16606 = state_16557;
(statearr_16585_16606[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16557);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16584;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16607 = state_16557;
state_16557 = G__16607;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16557){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16591,out))
})();
var state__13881__auto__ = (function (){var statearr_16586 = f__13880__auto__.call(null);
(statearr_16586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16591);

return statearr_16586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16591,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args16608 = [];
var len__7484__auto___16682 = arguments.length;
var i__7485__auto___16683 = (0);
while(true){
if((i__7485__auto___16683 < len__7484__auto___16682)){
args16608.push((arguments[i__7485__auto___16683]));

var G__16684 = (i__7485__auto___16683 + (1));
i__7485__auto___16683 = G__16684;
continue;
} else {
}
break;
}

var G__16610 = args16608.length;
switch (G__16610) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16608.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13879__auto___16686 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto___16686,out){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto___16686,out){
return (function (state_16652){
var state_val_16653 = (state_16652[(1)]);
if((state_val_16653 === (7))){
var inst_16648 = (state_16652[(2)]);
var state_16652__$1 = state_16652;
var statearr_16654_16687 = state_16652__$1;
(statearr_16654_16687[(2)] = inst_16648);

(statearr_16654_16687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (1))){
var inst_16611 = [];
var inst_16612 = inst_16611;
var inst_16613 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_16652__$1 = (function (){var statearr_16655 = state_16652;
(statearr_16655[(7)] = inst_16613);

(statearr_16655[(8)] = inst_16612);

return statearr_16655;
})();
var statearr_16656_16688 = state_16652__$1;
(statearr_16656_16688[(2)] = null);

(statearr_16656_16688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (4))){
var inst_16616 = (state_16652[(9)]);
var inst_16616__$1 = (state_16652[(2)]);
var inst_16617 = (inst_16616__$1 == null);
var inst_16618 = cljs.core.not.call(null,inst_16617);
var state_16652__$1 = (function (){var statearr_16657 = state_16652;
(statearr_16657[(9)] = inst_16616__$1);

return statearr_16657;
})();
if(inst_16618){
var statearr_16658_16689 = state_16652__$1;
(statearr_16658_16689[(1)] = (5));

} else {
var statearr_16659_16690 = state_16652__$1;
(statearr_16659_16690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (15))){
var inst_16642 = (state_16652[(2)]);
var state_16652__$1 = state_16652;
var statearr_16660_16691 = state_16652__$1;
(statearr_16660_16691[(2)] = inst_16642);

(statearr_16660_16691[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (13))){
var state_16652__$1 = state_16652;
var statearr_16661_16692 = state_16652__$1;
(statearr_16661_16692[(2)] = null);

(statearr_16661_16692[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (6))){
var inst_16612 = (state_16652[(8)]);
var inst_16637 = inst_16612.length;
var inst_16638 = (inst_16637 > (0));
var state_16652__$1 = state_16652;
if(cljs.core.truth_(inst_16638)){
var statearr_16662_16693 = state_16652__$1;
(statearr_16662_16693[(1)] = (12));

} else {
var statearr_16663_16694 = state_16652__$1;
(statearr_16663_16694[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (3))){
var inst_16650 = (state_16652[(2)]);
var state_16652__$1 = state_16652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16652__$1,inst_16650);
} else {
if((state_val_16653 === (12))){
var inst_16612 = (state_16652[(8)]);
var inst_16640 = cljs.core.vec.call(null,inst_16612);
var state_16652__$1 = state_16652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16652__$1,(15),out,inst_16640);
} else {
if((state_val_16653 === (2))){
var state_16652__$1 = state_16652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16652__$1,(4),ch);
} else {
if((state_val_16653 === (11))){
var inst_16620 = (state_16652[(10)]);
var inst_16616 = (state_16652[(9)]);
var inst_16630 = (state_16652[(2)]);
var inst_16631 = [];
var inst_16632 = inst_16631.push(inst_16616);
var inst_16612 = inst_16631;
var inst_16613 = inst_16620;
var state_16652__$1 = (function (){var statearr_16664 = state_16652;
(statearr_16664[(7)] = inst_16613);

(statearr_16664[(8)] = inst_16612);

(statearr_16664[(11)] = inst_16632);

(statearr_16664[(12)] = inst_16630);

return statearr_16664;
})();
var statearr_16665_16695 = state_16652__$1;
(statearr_16665_16695[(2)] = null);

(statearr_16665_16695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (9))){
var inst_16612 = (state_16652[(8)]);
var inst_16628 = cljs.core.vec.call(null,inst_16612);
var state_16652__$1 = state_16652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16652__$1,(11),out,inst_16628);
} else {
if((state_val_16653 === (5))){
var inst_16613 = (state_16652[(7)]);
var inst_16620 = (state_16652[(10)]);
var inst_16616 = (state_16652[(9)]);
var inst_16620__$1 = f.call(null,inst_16616);
var inst_16621 = cljs.core._EQ_.call(null,inst_16620__$1,inst_16613);
var inst_16622 = cljs.core.keyword_identical_QMARK_.call(null,inst_16613,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_16623 = (inst_16621) || (inst_16622);
var state_16652__$1 = (function (){var statearr_16666 = state_16652;
(statearr_16666[(10)] = inst_16620__$1);

return statearr_16666;
})();
if(cljs.core.truth_(inst_16623)){
var statearr_16667_16696 = state_16652__$1;
(statearr_16667_16696[(1)] = (8));

} else {
var statearr_16668_16697 = state_16652__$1;
(statearr_16668_16697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (14))){
var inst_16645 = (state_16652[(2)]);
var inst_16646 = cljs.core.async.close_BANG_.call(null,out);
var state_16652__$1 = (function (){var statearr_16670 = state_16652;
(statearr_16670[(13)] = inst_16645);

return statearr_16670;
})();
var statearr_16671_16698 = state_16652__$1;
(statearr_16671_16698[(2)] = inst_16646);

(statearr_16671_16698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (10))){
var inst_16635 = (state_16652[(2)]);
var state_16652__$1 = state_16652;
var statearr_16672_16699 = state_16652__$1;
(statearr_16672_16699[(2)] = inst_16635);

(statearr_16672_16699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16653 === (8))){
var inst_16612 = (state_16652[(8)]);
var inst_16620 = (state_16652[(10)]);
var inst_16616 = (state_16652[(9)]);
var inst_16625 = inst_16612.push(inst_16616);
var tmp16669 = inst_16612;
var inst_16612__$1 = tmp16669;
var inst_16613 = inst_16620;
var state_16652__$1 = (function (){var statearr_16673 = state_16652;
(statearr_16673[(7)] = inst_16613);

(statearr_16673[(8)] = inst_16612__$1);

(statearr_16673[(14)] = inst_16625);

return statearr_16673;
})();
var statearr_16674_16700 = state_16652__$1;
(statearr_16674_16700[(2)] = null);

(statearr_16674_16700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto___16686,out))
;
return ((function (switch__13767__auto__,c__13879__auto___16686,out){
return (function() {
var cljs$core$async$state_machine__13768__auto__ = null;
var cljs$core$async$state_machine__13768__auto____0 = (function (){
var statearr_16678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16678[(0)] = cljs$core$async$state_machine__13768__auto__);

(statearr_16678[(1)] = (1));

return statearr_16678;
});
var cljs$core$async$state_machine__13768__auto____1 = (function (state_16652){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_16652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e16679){if((e16679 instanceof Object)){
var ex__13771__auto__ = e16679;
var statearr_16680_16701 = state_16652;
(statearr_16680_16701[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16702 = state_16652;
state_16652 = G__16702;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
cljs$core$async$state_machine__13768__auto__ = function(state_16652){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13768__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13768__auto____1.call(this,state_16652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13768__auto____0;
cljs$core$async$state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13768__auto____1;
return cljs$core$async$state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto___16686,out))
})();
var state__13881__auto__ = (function (){var statearr_16681 = f__13880__auto__.call(null);
(statearr_16681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto___16686);

return statearr_16681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto___16686,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

