// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_40805){
var state_val_40806 = (state_40805[(1)]);
if((state_val_40806 === (7))){
var inst_40762 = (state_40805[(7)]);
var inst_40762__$1 = (state_40805[(2)]);
var inst_40764 = (inst_40762__$1 == null);
var inst_40765 = cljs.core.not(inst_40764);
var state_40805__$1 = (function (){var statearr_40807 = state_40805;
(statearr_40807[(7)] = inst_40762__$1);

return statearr_40807;
})();
if(inst_40765){
var statearr_40808_40845 = state_40805__$1;
(statearr_40808_40845[(1)] = (8));

} else {
var statearr_40809_40846 = state_40805__$1;
(statearr_40809_40846[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (20))){
var inst_40784 = (state_40805[(8)]);
var inst_40792 = (state_40805[(2)]);
var state_40805__$1 = (function (){var statearr_40810 = state_40805;
(statearr_40810[(9)] = inst_40792);

return statearr_40810;
})();
if(cljs.core.truth_(inst_40784)){
var statearr_40811_40847 = state_40805__$1;
(statearr_40811_40847[(1)] = (21));

} else {
var statearr_40812_40848 = state_40805__$1;
(statearr_40812_40848[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (1))){
var state_40805__$1 = state_40805;
var statearr_40813_40849 = state_40805__$1;
(statearr_40813_40849[(2)] = null);

(statearr_40813_40849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (4))){
var state_40805__$1 = state_40805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40805__$1,(7),agg_data_channel);
} else {
if((state_val_40806 === (15))){
var inst_40762 = (state_40805[(7)]);
var state_40805__$1 = state_40805;
var statearr_40814_40850 = state_40805__$1;
(statearr_40814_40850[(2)] = inst_40762);

(statearr_40814_40850[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (21))){
var inst_40794 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40805__$1 = state_40805;
var statearr_40815_40851 = state_40805__$1;
(statearr_40815_40851[(2)] = inst_40794);

(statearr_40815_40851[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (13))){
var inst_40774 = (state_40805[(2)]);
var state_40805__$1 = state_40805;
var statearr_40816_40852 = state_40805__$1;
(statearr_40816_40852[(2)] = inst_40774);

(statearr_40816_40852[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (22))){
var state_40805__$1 = state_40805;
var statearr_40817_40853 = state_40805__$1;
(statearr_40817_40853[(2)] = null);

(statearr_40817_40853[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (6))){
var inst_40801 = (state_40805[(2)]);
var state_40805__$1 = state_40805;
var statearr_40818_40854 = state_40805__$1;
(statearr_40818_40854[(2)] = inst_40801);

(statearr_40818_40854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (17))){
var inst_40783 = (state_40805[(10)]);
var inst_40784 = (state_40805[(8)]);
var inst_40786 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40783,inst_40784) : callback.call(null,inst_40783,inst_40784));
var state_40805__$1 = state_40805;
var statearr_40819_40855 = state_40805__$1;
(statearr_40819_40855[(2)] = inst_40786);

(statearr_40819_40855[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (3))){
var inst_40803 = (state_40805[(2)]);
var state_40805__$1 = state_40805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40805__$1,inst_40803);
} else {
if((state_val_40806 === (12))){
var state_40805__$1 = state_40805;
var statearr_40820_40856 = state_40805__$1;
(statearr_40820_40856[(2)] = false);

(statearr_40820_40856[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (2))){
var state_40805__$1 = state_40805;
var statearr_40821_40857 = state_40805__$1;
(statearr_40821_40857[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (23))){
var inst_40797 = (state_40805[(2)]);
var state_40805__$1 = (function (){var statearr_40823 = state_40805;
(statearr_40823[(11)] = inst_40797);

return statearr_40823;
})();
var statearr_40824_40858 = state_40805__$1;
(statearr_40824_40858[(2)] = null);

(statearr_40824_40858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (19))){
var inst_40789 = (state_40805[(2)]);
var inst_40790 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40805__$1 = (function (){var statearr_40825 = state_40805;
(statearr_40825[(12)] = inst_40789);

return statearr_40825;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40805__$1,(20),inst_40790);
} else {
if((state_val_40806 === (11))){
var state_40805__$1 = state_40805;
var statearr_40826_40859 = state_40805__$1;
(statearr_40826_40859[(2)] = true);

(statearr_40826_40859[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (9))){
var state_40805__$1 = state_40805;
var statearr_40827_40860 = state_40805__$1;
(statearr_40827_40860[(2)] = false);

(statearr_40827_40860[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (5))){
var state_40805__$1 = state_40805;
var statearr_40828_40861 = state_40805__$1;
(statearr_40828_40861[(2)] = null);

(statearr_40828_40861[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (14))){
var inst_40762 = (state_40805[(7)]);
var inst_40779 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40762);
var state_40805__$1 = state_40805;
var statearr_40829_40862 = state_40805__$1;
(statearr_40829_40862[(2)] = inst_40779);

(statearr_40829_40862[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (16))){
var inst_40783 = (state_40805[(10)]);
var inst_40782 = (state_40805[(2)]);
var inst_40783__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40782,cljs.core.cst$kw$data);
var inst_40784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40782,cljs.core.cst$kw$completed_QMARK_);
var state_40805__$1 = (function (){var statearr_40830 = state_40805;
(statearr_40830[(10)] = inst_40783__$1);

(statearr_40830[(8)] = inst_40784);

return statearr_40830;
})();
if(cljs.core.truth_(inst_40783__$1)){
var statearr_40831_40863 = state_40805__$1;
(statearr_40831_40863[(1)] = (17));

} else {
var statearr_40832_40864 = state_40805__$1;
(statearr_40832_40864[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (10))){
var inst_40777 = (state_40805[(2)]);
var state_40805__$1 = state_40805;
if(cljs.core.truth_(inst_40777)){
var statearr_40833_40865 = state_40805__$1;
(statearr_40833_40865[(1)] = (14));

} else {
var statearr_40834_40866 = state_40805__$1;
(statearr_40834_40866[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (18))){
var state_40805__$1 = state_40805;
var statearr_40835_40867 = state_40805__$1;
(statearr_40835_40867[(2)] = null);

(statearr_40835_40867[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40806 === (8))){
var inst_40762 = (state_40805[(7)]);
var inst_40767 = inst_40762.cljs$lang$protocol_mask$partition0$;
var inst_40768 = (inst_40767 & (64));
var inst_40769 = inst_40762.cljs$core$ISeq$;
var inst_40770 = (inst_40768) || (inst_40769);
var state_40805__$1 = state_40805;
if(cljs.core.truth_(inst_40770)){
var statearr_40836_40868 = state_40805__$1;
(statearr_40836_40868[(1)] = (11));

} else {
var statearr_40837_40869 = state_40805__$1;
(statearr_40837_40869[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0 = (function (){
var statearr_40841 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40841[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__);

(statearr_40841[(1)] = (1));

return statearr_40841;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1 = (function (state_40805){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_40805);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e40842){if((e40842 instanceof Object)){
var ex__12175__auto__ = e40842;
var statearr_40843_40870 = state_40805;
(statearr_40843_40870[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40805);

return cljs.core.cst$kw$recur;
} else {
throw e40842;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__40871 = state_40805;
state_40805 = G__40871;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__ = function(state_40805){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1.call(this,state_40805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_40844 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_40844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_40844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40874_40876 = agg;
var G__40875_40877 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40874_40876,G__40875_40877) : cljs.core.reset_BANG_.call(null,G__40874_40876,G__40875_40877));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40885 = arguments.length;
var i__7485__auto___40886 = (0);
while(true){
if((i__7485__auto___40886 < len__7484__auto___40885)){
args__7491__auto__.push((arguments[i__7485__auto___40886]));

var G__40887 = (i__7485__auto___40886 + (1));
i__7485__auto___40886 = G__40887;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40881){
var map__40882 = p__40881;
var map__40882__$1 = ((((!((map__40882 == null)))?((((map__40882.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40882.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40882):map__40882);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40882__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40884 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40884) : cljs.core.atom.call(null,G__40884));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40882,map__40882__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40882,map__40882__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40882,map__40882__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40882,map__40882__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40878){
var G__40879 = cljs.core.first(seq40878);
var seq40878__$1 = cljs.core.next(seq40878);
var G__40880 = cljs.core.first(seq40878__$1);
var seq40878__$2 = cljs.core.next(seq40878__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40879,G__40880,seq40878__$2);
});

