// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__39208 = cljs.core._EQ_;
var expr__39209 = view;
if(cljs.core.truth_((function (){var G__39211 = cljs.core.cst$kw$map;
var G__39212 = expr__39209;
return (pred__39208.cljs$core$IFn$_invoke$arity$2 ? pred__39208.cljs$core$IFn$_invoke$arity$2(G__39211,G__39212) : pred__39208.call(null,G__39211,G__39212));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39213 = cljs.core.cst$kw$photos;
var G__39214 = expr__39209;
return (pred__39208.cljs$core$IFn$_invoke$arity$2 ? pred__39208.cljs$core$IFn$_invoke$arity$2(G__39213,G__39214) : pred__39208.call(null,G__39213,G__39214));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39215 = cljs.core.cst$kw$table;
var G__39216 = expr__39209;
return (pred__39208.cljs$core$IFn$_invoke$arity$2 ? pred__39208.cljs$core$IFn$_invoke$arity$2(G__39215,G__39216) : pred__39208.call(null,G__39215,G__39216));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39217 = cljs.core.cst$kw$chart;
var G__39218 = expr__39209;
return (pred__39208.cljs$core$IFn$_invoke$arity$2 ? pred__39208.cljs$core$IFn$_invoke$arity$2(G__39217,G__39218) : pred__39208.call(null,G__39217,G__39218));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39219 = cljs.core.cst$kw$saved_DASH_charts;
var G__39220 = expr__39209;
return (pred__39208.cljs$core$IFn$_invoke$arity$2 ? pred__39208.cljs$core$IFn$_invoke$arity$2(G__39219,G__39220) : pred__39208.call(null,G__39219,G__39220));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39221 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39221 = (function (cursor,owner,meta39222){
this.cursor = cursor;
this.owner = owner;
this.meta39222 = meta39222;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39221.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39223,meta39222__$1){
var self__ = this;
var _39223__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39221(self__.cursor,self__.owner,meta39222__$1));
});

hatti.views.dataview.t_hatti$views$dataview39221.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39223){
var self__ = this;
var _39223__$1 = this;
return self__.meta39222;
});

hatti.views.dataview.t_hatti$views$dataview39221.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39221.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39221.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39222], null);
});

hatti.views.dataview.t_hatti$views$dataview39221.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39221.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39221";

hatti.views.dataview.t_hatti$views$dataview39221.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39221");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39221 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39221(cursor__$1,owner__$1,meta39222){
return (new hatti.views.dataview.t_hatti$views$dataview39221(cursor__$1,owner__$1,meta39222));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39221(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39224,owner){
var map__39225 = p__39224;
var map__39225__$1 = ((((!((map__39225 == null)))?((((map__39225.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39225.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39225):map__39225);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39225__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39225__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39227 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39227 = (function (p__39224,owner,map__39225,dataset_info,status,meta39228){
this.p__39224 = p__39224;
this.owner = owner;
this.map__39225 = map__39225;
this.dataset_info = dataset_info;
this.status = status;
this.meta39228 = meta39228;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39227.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (_39229,meta39228__$1){
var self__ = this;
var _39229__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39227(self__.p__39224,self__.owner,self__.map__39225,self__.dataset_info,self__.status,meta39228__$1));
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39227.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (_39229){
var self__ = this;
var _39229__$1 = this;
return self__.meta39228;
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39227.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39227.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39227.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39227.prototype.om$core$IRender$render$arity$1 = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39230 = self__.dataset_info;
var map__39230__$1 = ((((!((map__39230 == null)))?((((map__39230.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39230.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39230):map__39230);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39230__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39230__$1,cljs.core.cst$kw$formid);
var map__39231 = self__.status;
var map__39231__$1 = ((((!((map__39231 == null)))?((((map__39231.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39231.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39231):map__39231);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39231__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39231__$1,cljs.core.cst$kw$total_DASH_records);
var G__39238 = ({"className": "right rec-summary rec-margin"});
var G__39239 = (function (){var attrs39234 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39234))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39234], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39234))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39234)], null))));
})();
var G__39240 = (function (){var G__39243 = ({"id": "data-status"});
var G__39244 = (function (){var attrs39235 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39235))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39235], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39235))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39235),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39243,G__39244);
})();
var G__39241 = (function (){var G__39245 = ({"className": "divider"});
return React.DOM.div(G__39245);
})();
var G__39242 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__39238,G__39239,G__39240,G__39241,G__39242);
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39227.getBasis = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39224,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39225,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39228], null);
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39227.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39227.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39227";

hatti.views.dataview.t_hatti$views$dataview39227.cljs$lang$ctorPrWriter = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39227");
});})(map__39225,map__39225__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39227 = ((function (map__39225,map__39225__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39227(p__39224__$1,owner__$1,map__39225__$2,dataset_info__$1,status__$1,meta39228){
return (new hatti.views.dataview.t_hatti$views$dataview39227(p__39224__$1,owner__$1,map__39225__$2,dataset_info__$1,status__$1,meta39228));
});})(map__39225,map__39225__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39227(p__39224,owner,map__39225__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39249 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39249 = (function (app_state,owner,opts,meta39250){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39250 = meta39250;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39249.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39251,meta39250__$1){
var self__ = this;
var _39251__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39249(self__.app_state,self__.owner,self__.opts,meta39250__$1));
});

hatti.views.dataview.t_hatti$views$dataview39249.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39251){
var self__ = this;
var _39251__$1 = this;
return self__.meta39250;
});

hatti.views.dataview.t_hatti$views$dataview39249.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39249.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__39252 = self__.app_state;
var map__39252__$1 = ((((!((map__39252 == null)))?((((map__39252.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39252.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39252):map__39252);
var map__39253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39252__$1,cljs.core.cst$kw$views);
var map__39253__$1 = ((((!((map__39253 == null)))?((((map__39253.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39253.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39253):map__39253);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39253__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39253__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39253__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39252__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39252__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__39246_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39246_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__39247_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39247_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__39256){
var map__39257 = p__39256;
var map__39257__$1 = ((((!((map__39257 == null)))?((((map__39257.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39257.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39257):map__39257);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39257__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39257__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__39257,map__39257__$1,view,label,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__39248_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39248_SHARP_);
});})(map__39257,map__39257__$1,view,label,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__39260 = ({"className": "tab-container dataset-tabs"});
var G__39261 = (function (){var attrs39259 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39259))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39259], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39259))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39259),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39262 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39260,G__39261,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__39263(s__39264){
return (new cljs.core.LazySeq(null,((function (G__39260,G__39261,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__39264__$1 = s__39264;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39264__$1);
if(temp__4657__auto__){
var s__39264__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39264__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39264__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39266 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39265 = (0);
while(true){
if((i__39265 < size__7188__auto__)){
var map__39277 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39265);
var map__39277__$1 = ((((!((map__39277 == null)))?((((map__39277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39277):map__39277);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39277__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39277__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__39266,(function (){var G__39279 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39280 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39279,G__39280);
})());

var G__39285 = (i__39265 + (1));
i__39265 = G__39285;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39266),hatti$views$dataview$iter__39263(cljs.core.chunk_rest(s__39264__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39266),null);
}
} else {
var map__39281 = cljs.core.first(s__39264__$2);
var map__39281__$1 = ((((!((map__39281 == null)))?((((map__39281.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39281.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39281):map__39281);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39281__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39281__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__39283 = ({"style": ({"height": cljs.core.cst$kw$table_DASH_view_DASH_height.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display(view), "overflowX": (cljs.core.truth_(cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$table_DASH_page.cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39284 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39283,G__39284);
})(),hatti$views$dataview$iter__39263(cljs.core.rest(s__39264__$2)));
}
} else {
return null;
}
break;
}
});})(G__39260,G__39261,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__39260,G__39261,map__39252,map__39252__$1,map__39253,map__39253__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39260,G__39261,G__39262);
});

hatti.views.dataview.t_hatti$views$dataview39249.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39250], null);
});

hatti.views.dataview.t_hatti$views$dataview39249.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39249.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39249";

hatti.views.dataview.t_hatti$views$dataview39249.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39249");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39249 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39249(app_state__$1,owner__$1,opts__$1,meta39250){
return (new hatti.views.dataview.t_hatti$views$dataview39249(app_state__$1,owner__$1,opts__$1,meta39250));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39249(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
