// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"map","map",1371690461)],[new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"label","label",1718410804),"User Guide",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"label","label",1718410804),"Table",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"label","label",1718410804),"Reports",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"label","label",1718410804),"Dashboard",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"label","label",1718410804),"Settings",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"label","label",1718410804),"Overview",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"label","label",1718410804),"Charts",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"label","label",1718410804),"Photos",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"label","label",1718410804),"Map",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return cljs.core.atom.call(null,hatti.views.dataview.dataview_map);
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews.call(null);
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.inactive","a.inactive",1325252702),[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tooltip","span.tooltip",-934616418),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.tooltip","span.tip-info.tooltip",498786549),(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__26113 = cljs.core._EQ_;
var expr__26114 = view;
if(cljs.core.truth_(pred__26113.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__26114))){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_(pred__26113.call(null,new cljs.core.Keyword(null,"photos","photos",11691538),expr__26114))){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_(pred__26113.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__26114))){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__26113.call(null,new cljs.core.Keyword(null,"chart","chart",1173225425),expr__26114))){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__26113.call(null,new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),expr__26114))){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-question","span.tip-question",1059090371),"?"], null)], null)], null);
});
cljs.core._add_method.call(null,hatti.views.dataview_actions,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview26116 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26116 = (function (cursor,owner,meta26117){
this.cursor = cursor;
this.owner = owner;
this.meta26117 = meta26117;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26116.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26118,meta26117__$1){
var self__ = this;
var _26118__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26116(self__.cursor,self__.owner,meta26117__$1));
});

hatti.views.dataview.t_hatti$views$dataview26116.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26118){
var self__ = this;
var _26118__$1 = this;
return self__.meta26117;
});

hatti.views.dataview.t_hatti$views$dataview26116.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26116.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview26116.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26117","meta26117",-1815756510,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview26116.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26116.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26116";

hatti.views.dataview.t_hatti$views$dataview26116.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26116");
});

hatti.views.dataview.__GT_t_hatti$views$dataview26116 = (function hatti$views$dataview$__GT_t_hatti$views$dataview26116(cursor__$1,owner__$1,meta26117){
return (new hatti.views.dataview.t_hatti$views$dataview26116(cursor__$1,owner__$1,meta26117));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview26116(cursor,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.dataview_infobar,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26119,owner){
var map__26120 = p__26119;
var map__26120__$1 = ((((!((map__26120 == null)))?((((map__26120.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26120.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26120):map__26120);
var dataset_info = cljs.core.get.call(null,map__26120__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var status = cljs.core.get.call(null,map__26120__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(typeof hatti.views.dataview.t_hatti$views$dataview26122 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26122 = (function (p__26119,owner,map__26120,dataset_info,status,meta26123){
this.p__26119 = p__26119;
this.owner = owner;
this.map__26120 = map__26120;
this.dataset_info = dataset_info;
this.status = status;
this.meta26123 = meta26123;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26122.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (_26124,meta26123__$1){
var self__ = this;
var _26124__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26122(self__.p__26119,self__.owner,self__.map__26120,self__.dataset_info,self__.status,meta26123__$1));
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26122.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (_26124){
var self__ = this;
var _26124__$1 = this;
return self__.meta26123;
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26122.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview26122.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_.call(null,om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)));
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26122.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26122.prototype.om$core$IRender$render$arity$1 = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var map__26125 = self__.dataset_info;
var map__26125__$1 = ((((!((map__26125 == null)))?((((map__26125.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26125.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26125):map__26125);
var num_of_submissions = cljs.core.get.call(null,map__26125__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var formid = cljs.core.get.call(null,map__26125__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var map__26126 = self__.status;
var map__26126__$1 = ((((!((map__26126 == null)))?((((map__26126.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26126.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26126):map__26126);
var loading_QMARK_ = cljs.core.get.call(null,map__26126__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var total_records = cljs.core.get.call(null,map__26126__$1,new cljs.core.Keyword(null,"total-records","total-records",-1940276645));
return React.DOM.div(({"className": "right rec-summary rec-margin"}),(function (){var attrs26129 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_.call(null,form))?om.core.build.call(null,hatti.shared.language_selector,null):null);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26129))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),"language-selector"], null),attrs26129)):({"id": "language-selector"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26129))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26129)], null))));
})(),React.DOM.div(({"id": "data-status"}),(function (){var attrs26130 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null):null);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs26130))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs26130)):({"className": "rec"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26130))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26130),sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null))));
})()),React.DOM.div(({"className": "divider"})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_actions,formid)));
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26122.getBasis = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__26119","p__26119",1568764934,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__26120","map__26120",-1030293825,null),new cljs.core.Symbol(null,"dataset-info","dataset-info",443531964,null),new cljs.core.Symbol(null,"status","status",-357266886,null),new cljs.core.Symbol(null,"meta26123","meta26123",1719101944,null)], null);
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview26122.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26122.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26122";

hatti.views.dataview.t_hatti$views$dataview26122.cljs$lang$ctorPrWriter = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26122");
});})(map__26120,map__26120__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview26122 = ((function (map__26120,map__26120__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview26122(p__26119__$1,owner__$1,map__26120__$2,dataset_info__$1,status__$1,meta26123){
return (new hatti.views.dataview.t_hatti$views$dataview26122(p__26119__$1,owner__$1,map__26120__$2,dataset_info__$1,status__$1,meta26123));
});})(map__26120,map__26120__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview26122(p__26119,owner,map__26120__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.call(null,(function (){var or__6409__auto__ = cljs.core.last.call(null,cljs.core.re_find.call(null,/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"active-tab","active-tab",1102432568),settings_section__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"selected","selected",574897764)], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"active-tab","active-tab",1102432568)], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.Keyword(null,"active-section","active-section",1090779410)], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.call(null,app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"add?","add?",1263018409),true], null));
} else {
}

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.tabbed_dataview,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview26136 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26136 = (function (app_state,owner,opts,meta26137){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta26137 = meta26137;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26136.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26138,meta26137__$1){
var self__ = this;
var _26138__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26136(self__.app_state,self__.owner,self__.opts,meta26137__$1));
});

hatti.views.dataview.t_hatti$views$dataview26136.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26138){
var self__ = this;
var _26138__$1 = this;
return self__.meta26137;
});

hatti.views.dataview.t_hatti$views$dataview26136.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26136.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__26139 = self__.app_state;
var map__26139__$1 = ((((!((map__26139 == null)))?((((map__26139.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26139.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26139):map__26139);
var map__26140 = cljs.core.get.call(null,map__26139__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26140__$1 = ((((!((map__26140 == null)))?((((map__26140.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26140.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26140):map__26140);
var active = cljs.core.get.call(null,map__26140__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var disabled = cljs.core.get.call(null,map__26140__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var selected = cljs.core.get.call(null,map__26140__$1,new cljs.core.Keyword(null,"selected","selected",574897764));
var is_encrypted_QMARK_ = cljs.core.get.call(null,map__26139__$1,new cljs.core.Keyword(null,"is-encrypted?","is-encrypted?",-1801018432));
var is_within_pricing_limits_QMARK_ = cljs.core.get.call(null,map__26139__$1,new cljs.core.Keyword(null,"is-within-pricing-limits?","is-within-pricing-limits?",1028371005));
var view__GT_display = ((function (map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__26133_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26133_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__26134_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26134_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,cljs.core.deref.call(null,hatti.views.dataview.view_state),new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__26143){
var map__26144 = p__26143;
var map__26144__$1 = ((((!((map__26144 == null)))?((((map__26144.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26144.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26144):map__26144);
var view = cljs.core.get.call(null,map__26144__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var label = cljs.core.get.call(null,map__26144__$1,new cljs.core.Keyword(null,"label","label",1718410804));
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some.call(null,((function (map__26144,map__26144__$1,view,label,map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__26135_SHARP_){
return cljs.core._EQ_.call(null,view,p1__26135_SHARP_);
});})(map__26144,map__26144__$1,view,label,map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not.call(null,chimera.seq.in_QMARK_.call(null,disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),view__GT_cls.call(null,view),new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("#/"),cljs.core.str(cljs.core.name.call(null,view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab.call(null,view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
return React.DOM.div(({"className": "tab-container dataset-tabs"}),(function (){var attrs26146 = cljs.core.map.call(null,dv__GT_link,dataviews);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26146))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs26146)):({"className": "tab-bar"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26146))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26146),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})(),cljs.core.into_array.call(null,(function (){var iter__7189__auto__ = ((function (map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__26147(s__26148){
return (new cljs.core.LazySeq(null,((function (map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__26148__$1 = s__26148;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__26148__$1);
if(temp__4657__auto__){
var s__26148__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26148__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__26148__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__26150 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__26149 = (0);
while(true){
if((i__26149 < size__7188__auto__)){
var map__26155 = cljs.core._nth.call(null,c__7187__auto__,i__26149);
var map__26155__$1 = ((((!((map__26155 == null)))?((((map__26155.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26155.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26155):map__26155);
var component = cljs.core.get.call(null,map__26155__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26155__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
cljs.core.chunk_append.call(null,b__26150,React.DOM.div(({"style": ({"height": new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display.call(null,view), "overflowX": (cljs.core.truth_(new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))));

var G__26159 = (i__26149 + (1));
i__26149 = G__26159;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26150),hatti$views$dataview$iter__26147.call(null,cljs.core.chunk_rest.call(null,s__26148__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26150),null);
}
} else {
var map__26157 = cljs.core.first.call(null,s__26148__$2);
var map__26157__$1 = ((((!((map__26157 == null)))?((((map__26157.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26157.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26157):map__26157);
var component = cljs.core.get.call(null,map__26157__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26157__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
return cljs.core.cons.call(null,React.DOM.div(({"style": ({"height": new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)), "display": view__GT_display.call(null,view), "overflowX": (cljs.core.truth_(new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"table-page","table-page",1974969102).cljs$core$IFn$_invoke$arity$1(self__.app_state)))?"hidden":"scroll")}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))),hatti$views$dataview$iter__26147.call(null,cljs.core.rest.call(null,s__26148__$2)));
}
} else {
return null;
}
break;
}
});})(map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(map__26139,map__26139__$1,map__26140,map__26140__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__.call(null,dataviews);
})()));
});

hatti.views.dataview.t_hatti$views$dataview26136.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26137","meta26137",1292214839,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview26136.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26136.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26136";

hatti.views.dataview.t_hatti$views$dataview26136.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26136");
});

hatti.views.dataview.__GT_t_hatti$views$dataview26136 = (function hatti$views$dataview$__GT_t_hatti$views$dataview26136(app_state__$1,owner__$1,opts__$1,meta26137){
return (new hatti.views.dataview.t_hatti$views$dataview26136(app_state__$1,owner__$1,opts__$1,meta26137));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview26136(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
