// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_40783){
var state_val_40784 = (state_40783[(1)]);
if((state_val_40784 === (7))){
var inst_40740 = (state_40783[(7)]);
var inst_40740__$1 = (state_40783[(2)]);
var inst_40742 = (inst_40740__$1 == null);
var inst_40743 = cljs.core.not(inst_40742);
var state_40783__$1 = (function (){var statearr_40785 = state_40783;
(statearr_40785[(7)] = inst_40740__$1);

return statearr_40785;
})();
if(inst_40743){
var statearr_40786_40823 = state_40783__$1;
(statearr_40786_40823[(1)] = (8));

} else {
var statearr_40787_40824 = state_40783__$1;
(statearr_40787_40824[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (20))){
var inst_40762 = (state_40783[(8)]);
var inst_40770 = (state_40783[(2)]);
var state_40783__$1 = (function (){var statearr_40788 = state_40783;
(statearr_40788[(9)] = inst_40770);

return statearr_40788;
})();
if(cljs.core.truth_(inst_40762)){
var statearr_40789_40825 = state_40783__$1;
(statearr_40789_40825[(1)] = (21));

} else {
var statearr_40790_40826 = state_40783__$1;
(statearr_40790_40826[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (1))){
var state_40783__$1 = state_40783;
var statearr_40791_40827 = state_40783__$1;
(statearr_40791_40827[(2)] = null);

(statearr_40791_40827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (4))){
var state_40783__$1 = state_40783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40783__$1,(7),agg_data_channel);
} else {
if((state_val_40784 === (15))){
var inst_40740 = (state_40783[(7)]);
var state_40783__$1 = state_40783;
var statearr_40792_40828 = state_40783__$1;
(statearr_40792_40828[(2)] = inst_40740);

(statearr_40792_40828[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (21))){
var inst_40772 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40783__$1 = state_40783;
var statearr_40793_40829 = state_40783__$1;
(statearr_40793_40829[(2)] = inst_40772);

(statearr_40793_40829[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (13))){
var inst_40752 = (state_40783[(2)]);
var state_40783__$1 = state_40783;
var statearr_40794_40830 = state_40783__$1;
(statearr_40794_40830[(2)] = inst_40752);

(statearr_40794_40830[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (22))){
var state_40783__$1 = state_40783;
var statearr_40795_40831 = state_40783__$1;
(statearr_40795_40831[(2)] = null);

(statearr_40795_40831[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (6))){
var inst_40779 = (state_40783[(2)]);
var state_40783__$1 = state_40783;
var statearr_40796_40832 = state_40783__$1;
(statearr_40796_40832[(2)] = inst_40779);

(statearr_40796_40832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (17))){
var inst_40762 = (state_40783[(8)]);
var inst_40761 = (state_40783[(10)]);
var inst_40764 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40761,inst_40762) : callback.call(null,inst_40761,inst_40762));
var state_40783__$1 = state_40783;
var statearr_40797_40833 = state_40783__$1;
(statearr_40797_40833[(2)] = inst_40764);

(statearr_40797_40833[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (3))){
var inst_40781 = (state_40783[(2)]);
var state_40783__$1 = state_40783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40783__$1,inst_40781);
} else {
if((state_val_40784 === (12))){
var state_40783__$1 = state_40783;
var statearr_40798_40834 = state_40783__$1;
(statearr_40798_40834[(2)] = false);

(statearr_40798_40834[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (2))){
var state_40783__$1 = state_40783;
var statearr_40799_40835 = state_40783__$1;
(statearr_40799_40835[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (23))){
var inst_40775 = (state_40783[(2)]);
var state_40783__$1 = (function (){var statearr_40801 = state_40783;
(statearr_40801[(11)] = inst_40775);

return statearr_40801;
})();
var statearr_40802_40836 = state_40783__$1;
(statearr_40802_40836[(2)] = null);

(statearr_40802_40836[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (19))){
var inst_40767 = (state_40783[(2)]);
var inst_40768 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40783__$1 = (function (){var statearr_40803 = state_40783;
(statearr_40803[(12)] = inst_40767);

return statearr_40803;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40783__$1,(20),inst_40768);
} else {
if((state_val_40784 === (11))){
var state_40783__$1 = state_40783;
var statearr_40804_40837 = state_40783__$1;
(statearr_40804_40837[(2)] = true);

(statearr_40804_40837[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (9))){
var state_40783__$1 = state_40783;
var statearr_40805_40838 = state_40783__$1;
(statearr_40805_40838[(2)] = false);

(statearr_40805_40838[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (5))){
var state_40783__$1 = state_40783;
var statearr_40806_40839 = state_40783__$1;
(statearr_40806_40839[(2)] = null);

(statearr_40806_40839[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (14))){
var inst_40740 = (state_40783[(7)]);
var inst_40757 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40740);
var state_40783__$1 = state_40783;
var statearr_40807_40840 = state_40783__$1;
(statearr_40807_40840[(2)] = inst_40757);

(statearr_40807_40840[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (16))){
var inst_40761 = (state_40783[(10)]);
var inst_40760 = (state_40783[(2)]);
var inst_40761__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40760,cljs.core.cst$kw$data);
var inst_40762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40760,cljs.core.cst$kw$completed_QMARK_);
var state_40783__$1 = (function (){var statearr_40808 = state_40783;
(statearr_40808[(8)] = inst_40762);

(statearr_40808[(10)] = inst_40761__$1);

return statearr_40808;
})();
if(cljs.core.truth_(inst_40761__$1)){
var statearr_40809_40841 = state_40783__$1;
(statearr_40809_40841[(1)] = (17));

} else {
var statearr_40810_40842 = state_40783__$1;
(statearr_40810_40842[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (10))){
var inst_40755 = (state_40783[(2)]);
var state_40783__$1 = state_40783;
if(cljs.core.truth_(inst_40755)){
var statearr_40811_40843 = state_40783__$1;
(statearr_40811_40843[(1)] = (14));

} else {
var statearr_40812_40844 = state_40783__$1;
(statearr_40812_40844[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (18))){
var state_40783__$1 = state_40783;
var statearr_40813_40845 = state_40783__$1;
(statearr_40813_40845[(2)] = null);

(statearr_40813_40845[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40784 === (8))){
var inst_40740 = (state_40783[(7)]);
var inst_40745 = inst_40740.cljs$lang$protocol_mask$partition0$;
var inst_40746 = (inst_40745 & (64));
var inst_40747 = inst_40740.cljs$core$ISeq$;
var inst_40748 = (inst_40746) || (inst_40747);
var state_40783__$1 = state_40783;
if(cljs.core.truth_(inst_40748)){
var statearr_40814_40846 = state_40783__$1;
(statearr_40814_40846[(1)] = (11));

} else {
var statearr_40815_40847 = state_40783__$1;
(statearr_40815_40847[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0 = (function (){
var statearr_40819 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40819[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__);

(statearr_40819[(1)] = (1));

return statearr_40819;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1 = (function (state_40783){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_40783);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e40820){if((e40820 instanceof Object)){
var ex__13108__auto__ = e40820;
var statearr_40821_40848 = state_40783;
(statearr_40821_40848[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40783);

return cljs.core.cst$kw$recur;
} else {
throw e40820;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__40849 = state_40783;
state_40783 = G__40849;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__ = function(state_40783){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1.call(this,state_40783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_40822 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_40822[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_40822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40852_40854 = agg;
var G__40853_40855 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40852_40854,G__40853_40855) : cljs.core.reset_BANG_.call(null,G__40852_40854,G__40853_40855));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40863 = arguments.length;
var i__7485__auto___40864 = (0);
while(true){
if((i__7485__auto___40864 < len__7484__auto___40863)){
args__7491__auto__.push((arguments[i__7485__auto___40864]));

var G__40865 = (i__7485__auto___40864 + (1));
i__7485__auto___40864 = G__40865;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40859){
var map__40860 = p__40859;
var map__40860__$1 = ((((!((map__40860 == null)))?((((map__40860.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40860.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40860):map__40860);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40860__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40862 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40862) : cljs.core.atom.call(null,G__40862));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40860,map__40860__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40860,map__40860__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40860,map__40860__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40860,map__40860__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40856){
var G__40857 = cljs.core.first(seq40856);
var seq40856__$1 = cljs.core.next(seq40856);
var G__40858 = cljs.core.first(seq40856__$1);
var seq40856__$2 = cljs.core.next(seq40856__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40857,G__40858,seq40856__$2);
});

