(ns ona.api.http
        (:require [ona.api.io :refer [parse-response http-request
                                      debug-api add-to-options ]]
                  [environ.core :refer [env]]
                  [ona.utils.seq :refer [in?]]
                  [slingshot.slingshot :refer [throw+ try+]])
                                                                   
                                                
                                               )

;;; PARSE HTTP ;;;;;

(defn parse-http
  "Send and parse an HTTP response as JSON.
   Options object has special keys that modify beavior of parse-http:
   In clj: `suppress-40x-exceptions?`, `as-map?`,`raw-response?`.
   In cljs: `raw-response?`, `no-cache?`."
  ([method url account]
   (parse-http method url account {}))
  ([method url account options]
   (parse-http method url account options nil))
  ([method url account options filename]
   (let [{:keys [suppress-40x-exceptions? raw-response? as-map?
                 no-cache?]} options]
     ;; CLJ: synchronous implementation, checks status before returning.
     ;; no-cache? has no meaning in clj a.t.m.
          
     (let [appended-options (add-to-options account options url)
           {:keys [body status]
            :as response} (http-request method url appended-options)
           parsed-response (parse-response body
                                           status
                                           filename
                                           raw-response?)]
       (when (env :debug-api?)
         (debug-api method url appended-options response))
       (when (and (in? [400 401 404] status) (not suppress-40x-exceptions?))
         (throw+ {:api-response-status status :parsed-api-response parsed-response}))
       (if as-map?
         (assoc response :body parsed-response)
         parsed-response))
     ;; CLJS: asynchronous implementation, returns a channel.
     ;; suppress-40x-exceptions?, as-map? have no meaning in cljs a.t.m.
           
                                                                                     
                                                                         
                                                                                 
                                                              
                                                                          
                                                                 
                                      
                                                               
                                    
                                       
                                              
                                            
                                         
                     
                                                                        
                                 )))

;;;;;;;;;;;; This file autogenerated from src/cljx/ona/api/http.cljx
