// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('goog.math.Long');
goog.require('com.cognitect.transit.eq');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv(other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__29711 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__29711) : com.cognitect.transit.eq.hashCode.call(null,G__29711));
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__29712 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__29712) : com.cognitect.transit.eq.hashCode.call(null,G__29712));
});

goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__29713 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__29713) : com.cognitect.transit.eq.hashCode.call(null,G__29713));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__29718_29722 = cljs.core.seq(cljs.core.js_keys(b));
var chunk__29719_29723 = null;
var count__29720_29724 = (0);
var i__29721_29725 = (0);
while(true){
if((i__29721_29725 < count__29720_29724)){
var k_29726 = chunk__29719_29723.cljs$core$IIndexed$_nth$arity$2(null,i__29721_29725);
var v_29727 = (b[k_29726]);
(a[k_29726] = v_29727);

var G__29728 = seq__29718_29722;
var G__29729 = chunk__29719_29723;
var G__29730 = count__29720_29724;
var G__29731 = (i__29721_29725 + (1));
seq__29718_29722 = G__29728;
chunk__29719_29723 = G__29729;
count__29720_29724 = G__29730;
i__29721_29725 = G__29731;
continue;
} else {
var temp__4126__auto___29732 = cljs.core.seq(seq__29718_29722);
if(temp__4126__auto___29732){
var seq__29718_29733__$1 = temp__4126__auto___29732;
if(cljs.core.chunked_seq_QMARK_(seq__29718_29733__$1)){
var c__5061__auto___29734 = cljs.core.chunk_first(seq__29718_29733__$1);
var G__29735 = cljs.core.chunk_rest(seq__29718_29733__$1);
var G__29736 = c__5061__auto___29734;
var G__29737 = cljs.core.count(c__5061__auto___29734);
var G__29738 = (0);
seq__29718_29722 = G__29735;
chunk__29719_29723 = G__29736;
count__29720_29724 = G__29737;
i__29721_29725 = G__29738;
continue;
} else {
var k_29739 = cljs.core.first(seq__29718_29733__$1);
var v_29740 = (b[k_29739]);
(a[k_29739] = v_29740);

var G__29741 = cljs.core.next(seq__29718_29733__$1);
var G__29742 = null;
var G__29743 = (0);
var G__29744 = (0);
seq__29718_29722 = G__29741;
chunk__29719_29723 = G__29742;
count__29720_29724 = G__29743;
i__29721_29725 = G__29744;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__29745 = arr;
var G__29746 = true;
var G__29747 = true;
return (cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3 ? cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3(G__29745,G__29746,G__29747) : cljs.core.PersistentArrayMap.fromArray.call(null,G__29745,G__29746,G__29747));
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__29748 = arr;
var G__29749 = true;
return (cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2 ? cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2(G__29748,G__29749) : cljs.core.PersistentVector.fromArray.call(null,G__29748,G__29749));
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var G__29751 = arguments.length;
switch (G__29751) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var G__29752 = cljs.core.name(type);
var G__29753 = cognitect.transit.opts_merge({"prefersStrings": false, "arrayBuilder": (new cognitect.transit.VectorBuilder()), "mapBuilder": (new cognitect.transit.MapBuilder()), "handlers": cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 5, ["$",((function (G__29752){
return (function (v){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(v);
});})(G__29752))
,":",((function (G__29752){
return (function (v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(G__29752))
,"set",((function (G__29752){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,v);
});})(G__29752))
,"list",((function (G__29752){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.List.EMPTY,v.reverse());
});})(G__29752))
,"cmap",((function (G__29752){
return (function (v){
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__29755 = (i + (2));
var G__29756 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,(v[i]),(v[(i + (1))]));
i = G__29755;
ret = G__29756;
continue;
} else {
return cljs.core.persistent_BANG_(ret);
}
break;
}
});})(G__29752))
], null),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0)))},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(G__29752,G__29753) : com.cognitect.transit.reader.call(null,G__29752,G__29753));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__29757_29763 = cljs.core.seq(v);
var chunk__29758_29764 = null;
var count__29759_29765 = (0);
var i__29760_29766 = (0);
while(true){
if((i__29760_29766 < count__29759_29765)){
var x_29767 = chunk__29758_29764.cljs$core$IIndexed$_nth$arity$2(null,i__29760_29766);
ret.push(x_29767);

var G__29768 = seq__29757_29763;
var G__29769 = chunk__29758_29764;
var G__29770 = count__29759_29765;
var G__29771 = (i__29760_29766 + (1));
seq__29757_29763 = G__29768;
chunk__29758_29764 = G__29769;
count__29759_29765 = G__29770;
i__29760_29766 = G__29771;
continue;
} else {
var temp__4126__auto___29772 = cljs.core.seq(seq__29757_29763);
if(temp__4126__auto___29772){
var seq__29757_29773__$1 = temp__4126__auto___29772;
if(cljs.core.chunked_seq_QMARK_(seq__29757_29773__$1)){
var c__5061__auto___29774 = cljs.core.chunk_first(seq__29757_29773__$1);
var G__29775 = cljs.core.chunk_rest(seq__29757_29773__$1);
var G__29776 = c__5061__auto___29774;
var G__29777 = cljs.core.count(c__5061__auto___29774);
var G__29778 = (0);
seq__29757_29763 = G__29775;
chunk__29758_29764 = G__29776;
count__29759_29765 = G__29777;
i__29760_29766 = G__29778;
continue;
} else {
var x_29779 = cljs.core.first(seq__29757_29773__$1);
ret.push(x_29779);

var G__29780 = cljs.core.next(seq__29757_29773__$1);
var G__29781 = null;
var G__29782 = (0);
var G__29783 = (0);
seq__29757_29763 = G__29780;
chunk__29758_29764 = G__29781;
count__29759_29765 = G__29782;
i__29760_29766 = G__29783;
continue;
}
} else {
}
}
break;
}

var G__29761 = "array";
var G__29762 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__29761,G__29762) : com.cognitect.transit.tagged.call(null,G__29761,G__29762));
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__29784_29790 = cljs.core.seq(v);
var chunk__29785_29791 = null;
var count__29786_29792 = (0);
var i__29787_29793 = (0);
while(true){
if((i__29787_29793 < count__29786_29792)){
var x_29794 = chunk__29785_29791.cljs$core$IIndexed$_nth$arity$2(null,i__29787_29793);
ret.push(x_29794);

var G__29795 = seq__29784_29790;
var G__29796 = chunk__29785_29791;
var G__29797 = count__29786_29792;
var G__29798 = (i__29787_29793 + (1));
seq__29784_29790 = G__29795;
chunk__29785_29791 = G__29796;
count__29786_29792 = G__29797;
i__29787_29793 = G__29798;
continue;
} else {
var temp__4126__auto___29799 = cljs.core.seq(seq__29784_29790);
if(temp__4126__auto___29799){
var seq__29784_29800__$1 = temp__4126__auto___29799;
if(cljs.core.chunked_seq_QMARK_(seq__29784_29800__$1)){
var c__5061__auto___29801 = cljs.core.chunk_first(seq__29784_29800__$1);
var G__29802 = cljs.core.chunk_rest(seq__29784_29800__$1);
var G__29803 = c__5061__auto___29801;
var G__29804 = cljs.core.count(c__5061__auto___29801);
var G__29805 = (0);
seq__29784_29790 = G__29802;
chunk__29785_29791 = G__29803;
count__29786_29792 = G__29804;
i__29787_29793 = G__29805;
continue;
} else {
var x_29806 = cljs.core.first(seq__29784_29800__$1);
ret.push(x_29806);

var G__29807 = cljs.core.next(seq__29784_29800__$1);
var G__29808 = null;
var G__29809 = (0);
var G__29810 = (0);
seq__29784_29790 = G__29807;
chunk__29785_29791 = G__29808;
count__29786_29792 = G__29809;
i__29787_29793 = G__29810;
continue;
}
} else {
}
}
break;
}

var G__29788 = "array";
var G__29789 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__29788,G__29789) : com.cognitect.transit.tagged.call(null,G__29788,G__29789));
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__29811_29815 = cljs.core.seq(v);
var chunk__29812_29816 = null;
var count__29813_29817 = (0);
var i__29814_29818 = (0);
while(true){
if((i__29814_29818 < count__29813_29817)){
var x_29819 = chunk__29812_29816.cljs$core$IIndexed$_nth$arity$2(null,i__29814_29818);
ret.push(x_29819);

var G__29820 = seq__29811_29815;
var G__29821 = chunk__29812_29816;
var G__29822 = count__29813_29817;
var G__29823 = (i__29814_29818 + (1));
seq__29811_29815 = G__29820;
chunk__29812_29816 = G__29821;
count__29813_29817 = G__29822;
i__29814_29818 = G__29823;
continue;
} else {
var temp__4126__auto___29824 = cljs.core.seq(seq__29811_29815);
if(temp__4126__auto___29824){
var seq__29811_29825__$1 = temp__4126__auto___29824;
if(cljs.core.chunked_seq_QMARK_(seq__29811_29825__$1)){
var c__5061__auto___29826 = cljs.core.chunk_first(seq__29811_29825__$1);
var G__29827 = cljs.core.chunk_rest(seq__29811_29825__$1);
var G__29828 = c__5061__auto___29826;
var G__29829 = cljs.core.count(c__5061__auto___29826);
var G__29830 = (0);
seq__29811_29815 = G__29827;
chunk__29812_29816 = G__29828;
count__29813_29817 = G__29829;
i__29814_29818 = G__29830;
continue;
} else {
var x_29831 = cljs.core.first(seq__29811_29825__$1);
ret.push(x_29831);

var G__29832 = cljs.core.next(seq__29811_29825__$1);
var G__29833 = null;
var G__29834 = (0);
var G__29835 = (0);
seq__29811_29815 = G__29832;
chunk__29812_29816 = G__29833;
count__29813_29817 = G__29834;
i__29814_29818 = G__29835;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a JavaScript
 * array of interleaved type constructors and handler instances for those
 * type constructors.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var G__29837 = arguments.length;
switch (G__29837) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0));
var G__29838 = cljs.core.name(type);
var G__29839 = cognitect.transit.opts_merge({"unpack": ((function (G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x29843 = cljs.core.clone(handlers);
x29843.forEach = ((function (x29843,G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__29844 = cljs.core.seq(coll);
var chunk__29845 = null;
var count__29846 = (0);
var i__29847 = (0);
while(true){
if((i__29847 < count__29846)){
var vec__29848 = chunk__29845.cljs$core$IIndexed$_nth$arity$2(null,i__29847);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29848,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29848,(1),null);
var G__29849_29855 = v;
var G__29850_29856 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29849_29855,G__29850_29856) : f.call(null,G__29849_29855,G__29850_29856));

var G__29857 = seq__29844;
var G__29858 = chunk__29845;
var G__29859 = count__29846;
var G__29860 = (i__29847 + (1));
seq__29844 = G__29857;
chunk__29845 = G__29858;
count__29846 = G__29859;
i__29847 = G__29860;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__29844);
if(temp__4126__auto__){
var seq__29844__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29844__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__29844__$1);
var G__29861 = cljs.core.chunk_rest(seq__29844__$1);
var G__29862 = c__5061__auto__;
var G__29863 = cljs.core.count(c__5061__auto__);
var G__29864 = (0);
seq__29844 = G__29861;
chunk__29845 = G__29862;
count__29846 = G__29863;
i__29847 = G__29864;
continue;
} else {
var vec__29851 = cljs.core.first(seq__29844__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29851,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29851,(1),null);
var G__29852_29865 = v;
var G__29853_29866 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__29852_29865,G__29853_29866) : f.call(null,G__29852_29865,G__29853_29866));

var G__29867 = cljs.core.next(seq__29844__$1);
var G__29868 = null;
var G__29869 = (0);
var G__29870 = (0);
seq__29844 = G__29867;
chunk__29845 = G__29868;
count__29846 = G__29869;
i__29847 = G__29870;
continue;
}
} else {
return null;
}
}
break;
}
});})(x29843,G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x29843;
})(), "objectBuilder": ((function (G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv(((function (G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__29840 = obj;
G__29840.push((function (){var G__29841 = k;
return (kfn.cljs$core$IFn$_invoke$arity$1 ? kfn.cljs$core$IFn$_invoke$arity$1(G__29841) : kfn.call(null,G__29841));
})(),(function (){var G__29842 = v;
return (vfn.cljs$core$IFn$_invoke$arity$1 ? vfn.cljs$core$IFn$_invoke$arity$1(G__29842) : vfn.call(null,G__29842));
})());

return G__29840;
});})(G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(G__29838,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(G__29838,G__29839) : com.cognitect.transit.writer.call(null,G__29838,G__29839));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var G__29872 = arguments.length;
switch (G__29872) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t29873 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t29873 = (function (verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,meta29874){
this.verbose_handler_fn = verbose_handler_fn;
this.str_rep_fn = str_rep_fn;
this.rep_fn = rep_fn;
this.tag_fn = tag_fn;
this.meta29874 = meta29874;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cognitect.transit.t29873.prototype.tag = (function (o){
var self__ = this;
var _ = this;
var G__29876 = o;
return (self__.tag_fn.cljs$core$IFn$_invoke$arity$1 ? self__.tag_fn.cljs$core$IFn$_invoke$arity$1(G__29876) : self__.tag_fn.call(null,G__29876));
});

cognitect.transit.t29873.prototype.rep = (function (o){
var self__ = this;
var _ = this;
var G__29877 = o;
return (self__.rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.rep_fn.cljs$core$IFn$_invoke$arity$1(G__29877) : self__.rep_fn.call(null,G__29877));
});

cognitect.transit.t29873.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
var G__29878 = o;
return (self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1(G__29878) : self__.str_rep_fn.call(null,G__29878));
} else {
return null;
}
});

cognitect.transit.t29873.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return (self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0 ? self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0() : self__.verbose_handler_fn.call(null));
} else {
return null;
}
});

cognitect.transit.t29873.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29875){
var self__ = this;
var _29875__$1 = this;
return self__.meta29874;
});

cognitect.transit.t29873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29875,meta29874__$1){
var self__ = this;
var _29875__$1 = this;
return (new cognitect.transit.t29873(self__.verbose_handler_fn,self__.str_rep_fn,self__.rep_fn,self__.tag_fn,meta29874__$1));
});

cognitect.transit.t29873.cljs$lang$type = true;

cognitect.transit.t29873.cljs$lang$ctorStr = "cognitect.transit/t29873";

cognitect.transit.t29873.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/t29873");
});

cognitect.transit.__GT_t29873 = (function cognitect$transit$__GT_t29873(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta29874){
return (new cognitect.transit.t29873(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta29874));
});

}

return (new cognitect.transit.t29873(verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
var G__29882 = tag;
var G__29883 = rep;
return (com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2(G__29882,G__29883) : com.cognitect.transit.types.taggedValue.call(null,G__29882,G__29883));
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
var G__29885 = x;
return (com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1(G__29885) : com.cognitect.transit.types.isTaggedValue.call(null,G__29885));
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
var G__29887 = s;
return (com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1(G__29887) : com.cognitect.transit.types.integer.call(null,G__29887));
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
var G__29889 = x;
return (com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1(G__29889) : com.cognitect.transit.types.isInteger.call(null,G__29889));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
var G__29891 = s;
return (com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1(G__29891) : com.cognitect.transit.types.bigInteger.call(null,G__29891));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
var G__29893 = x;
return (com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1(G__29893) : com.cognitect.transit.types.isBigInteger.call(null,G__29893));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
var G__29895 = s;
return (com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1(G__29895) : com.cognitect.transit.types.bigDecimalValue.call(null,G__29895));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
var G__29897 = x;
return (com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1(G__29897) : com.cognitect.transit.types.isBigDecimal.call(null,G__29897));
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
var G__29899 = s;
return (com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1(G__29899) : com.cognitect.transit.types.uri.call(null,G__29899));
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
var G__29901 = x;
return (com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1(G__29901) : com.cognitect.transit.types.isURI.call(null,G__29901));
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
var G__29903 = s;
return (com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1(G__29903) : com.cognitect.transit.types.uuid.call(null,G__29903));
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var G__29905 = x;
return (com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1(G__29905) : com.cognitect.transit.types.isUUID.call(null,G__29905));
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
var G__29907 = s;
return (com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1(G__29907) : com.cognitect.transit.types.binary.call(null,G__29907));
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
var G__29909 = x;
return (com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1(G__29909) : com.cognitect.transit.types.isBinary.call(null,G__29909));
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
var G__29911 = x;
return (com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1(G__29911) : com.cognitect.transit.types.quoted.call(null,G__29911));
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
var G__29913 = x;
return (com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1(G__29913) : com.cognitect.transit.types.isQuoted.call(null,G__29913));
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
var G__29915 = x;
return (com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1(G__29915) : com.cognitect.transit.types.link.call(null,G__29915));
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
var G__29917 = x;
return (com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1(G__29917) : com.cognitect.transit.types.isLink.call(null,G__29917));
});
