// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.template');
goog.require('cljs.core');
goog.require('dommy.attrs');
goog.require('clojure.string');
dommy.template._PLUS_svg_ns_PLUS_ = "http://www.w3.org/2000/svg";
dommy.template._PLUS_svg_tags_PLUS_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["svg",null,"line",null], null), null);

dommy.template.PElement = (function (){var obj29519 = {};
return obj29519;
})();

/**
 * return the element representation of this
 */
dommy.template._elem = (function dommy$template$_elem(this$){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.dommy$template$PElement$_elem$arity$1;
} else {
return and__4264__auto__;
}
})()){
return this$.dommy$template$PElement$_elem$arity$1(this$);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (dommy.template._elem[(function (){var G__29523 = x__4912__auto__;
return goog.typeOf(G__29523);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (dommy.template._elem["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("PElement.-elem",this$);
}
}
})().call(null,this$);
}
});

/**
 * index of css character (#,.) in base-element. bottleneck
 */
dommy.template.next_css_index = (function dommy$template$next_css_index(s,start_idx){
var id_idx = s.indexOf("#",start_idx);
var class_idx = s.indexOf(".",start_idx);
var idx = Math.min(id_idx,class_idx);
if((idx < (0))){
return Math.max(id_idx,class_idx);
} else {
return idx;
}
});
/**
 * dom element from css-style keyword like :a.class1 or :span#my-span.class
 */
dommy.template.base_element = (function dommy$template$base_element(node_key){
var node_str = cljs.core.name(node_key);
var base_idx = dommy.template.next_css_index(node_str,(0));
var tag = (((base_idx > (0)))?node_str.substring((0),base_idx):(((base_idx === (0)))?"div":node_str
));
var node = (cljs.core.truth_((function (){var G__29526 = tag;
return (dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1 ? dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1(G__29526) : dommy.template._PLUS_svg_tags_PLUS_.call(null,G__29526));
})())?document.createElementNS(dommy.template._PLUS_svg_ns_PLUS_,tag):document.createElement(tag));
if((base_idx >= (0))){
var str_29528 = node_str.substring(base_idx);
while(true){
var next_idx_29529 = dommy.template.next_css_index(str_29528,(1));
var frag_29530 = (((next_idx_29529 >= (0)))?str_29528.substring((0),next_idx_29529):str_29528);
var G__29527_29531 = frag_29530.charAt((0));
switch (G__29527_29531) {
case ".":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,frag_29530.substring((1)));

break;
case "#":
node.setAttribute("id",frag_29530.substring((1)));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(frag_29530.charAt((0)))].join('')));

}

if((next_idx_29529 >= (0))){
var G__29533 = str_29528.substring(next_idx_29529);
str_29528 = G__29533;
continue;
} else {
}
break;
}
} else {
}

return node;
});
dommy.template.throw_unable_to_make_node = (function dommy$template$throw_unable_to_make_node(node_data){
throw [cljs.core.str("Don't know how to make node from: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([node_data], 0)))].join('');
});
/**
 * take data and return a document fragment
 */
dommy.template.__GT_document_fragment = (function dommy$template$__GT_document_fragment(){
var G__29535 = arguments.length;
switch (G__29535) {
case 1:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1 = (function (data){
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(document.createDocumentFragment(),data);
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2 = (function (result_frag,data){
if((function (){var G__29536 = data;
if(G__29536){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29536.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29536.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29536);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29536);
}
})()){
result_frag.appendChild(dommy.template._elem(data));

return result_frag;
} else {
if(cljs.core.seq_QMARK_(data)){
var seq__29537_29542 = cljs.core.seq(data);
var chunk__29538_29543 = null;
var count__29539_29544 = (0);
var i__29540_29545 = (0);
while(true){
if((i__29540_29545 < count__29539_29544)){
var child_29546 = chunk__29538_29543.cljs$core$IIndexed$_nth$arity$2(null,i__29540_29545);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_29546);

var G__29547 = seq__29537_29542;
var G__29548 = chunk__29538_29543;
var G__29549 = count__29539_29544;
var G__29550 = (i__29540_29545 + (1));
seq__29537_29542 = G__29547;
chunk__29538_29543 = G__29548;
count__29539_29544 = G__29549;
i__29540_29545 = G__29550;
continue;
} else {
var temp__4126__auto___29551 = cljs.core.seq(seq__29537_29542);
if(temp__4126__auto___29551){
var seq__29537_29552__$1 = temp__4126__auto___29551;
if(cljs.core.chunked_seq_QMARK_(seq__29537_29552__$1)){
var c__5061__auto___29553 = cljs.core.chunk_first(seq__29537_29552__$1);
var G__29554 = cljs.core.chunk_rest(seq__29537_29552__$1);
var G__29555 = c__5061__auto___29553;
var G__29556 = cljs.core.count(c__5061__auto___29553);
var G__29557 = (0);
seq__29537_29542 = G__29554;
chunk__29538_29543 = G__29555;
count__29539_29544 = G__29556;
i__29540_29545 = G__29557;
continue;
} else {
var child_29558 = cljs.core.first(seq__29537_29552__$1);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_29558);

var G__29559 = cljs.core.next(seq__29537_29552__$1);
var G__29560 = null;
var G__29561 = (0);
var G__29562 = (0);
seq__29537_29542 = G__29559;
chunk__29538_29543 = G__29560;
count__29539_29544 = G__29561;
i__29540_29545 = G__29562;
continue;
}
} else {
}
}
break;
}

return result_frag;
} else {
if((data == null)){
return result_frag;
} else {
return dommy.template.throw_unable_to_make_node(data);

}
}
}
});

dommy.template.__GT_document_fragment.cljs$lang$maxFixedArity = 2;
/**
 * take data and return DOM node if it satisfies PElement and tries to
 * make a document fragment otherwise
 */
dommy.template.__GT_node_like = (function dommy$template$__GT_node_like(data){
if((function (){var G__29564 = data;
if(G__29564){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29564.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29564.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29564);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29564);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1(data);
}
});
/**
 * element with either attrs or nested children [:div [:span "Hello"]]
 */
dommy.template.compound_element = (function dommy$template$compound_element(p__29565){
var vec__29585 = p__29565;
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29585,(0),null);
var maybe_attrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29585,(1),null);
var children = cljs.core.nthnext(vec__29585,(2));
var n = dommy.template.base_element(tag_name);
var attrs = (((cljs.core.map_QMARK_(maybe_attrs)) && (!((function (){var G__29587 = maybe_attrs;
if(G__29587){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29587.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29587.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29587);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29587);
}
})())))?maybe_attrs:null);
var children__$1 = (cljs.core.truth_(attrs)?children:cljs.core.cons(maybe_attrs,children));
var seq__29588_29604 = cljs.core.seq(attrs);
var chunk__29589_29605 = null;
var count__29590_29606 = (0);
var i__29591_29607 = (0);
while(true){
if((i__29591_29607 < count__29590_29606)){
var vec__29592_29608 = chunk__29589_29605.cljs$core$IIndexed$_nth$arity$2(null,i__29591_29607);
var k_29609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29592_29608,(0),null);
var v_29610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29592_29608,(1),null);
var G__29593_29611 = (((k_29609 instanceof cljs.core.Keyword))?k_29609.fqn:null);
switch (G__29593_29611) {
case "classes":
var seq__29594_29613 = cljs.core.seq(v_29610);
var chunk__29595_29614 = null;
var count__29596_29615 = (0);
var i__29597_29616 = (0);
while(true){
if((i__29597_29616 < count__29596_29615)){
var c_29617 = chunk__29595_29614.cljs$core$IIndexed$_nth$arity$2(null,i__29597_29616);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29617);

var G__29618 = seq__29594_29613;
var G__29619 = chunk__29595_29614;
var G__29620 = count__29596_29615;
var G__29621 = (i__29597_29616 + (1));
seq__29594_29613 = G__29618;
chunk__29595_29614 = G__29619;
count__29596_29615 = G__29620;
i__29597_29616 = G__29621;
continue;
} else {
var temp__4126__auto___29622 = cljs.core.seq(seq__29594_29613);
if(temp__4126__auto___29622){
var seq__29594_29623__$1 = temp__4126__auto___29622;
if(cljs.core.chunked_seq_QMARK_(seq__29594_29623__$1)){
var c__5061__auto___29624 = cljs.core.chunk_first(seq__29594_29623__$1);
var G__29625 = cljs.core.chunk_rest(seq__29594_29623__$1);
var G__29626 = c__5061__auto___29624;
var G__29627 = cljs.core.count(c__5061__auto___29624);
var G__29628 = (0);
seq__29594_29613 = G__29625;
chunk__29595_29614 = G__29626;
count__29596_29615 = G__29627;
i__29597_29616 = G__29628;
continue;
} else {
var c_29629 = cljs.core.first(seq__29594_29623__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29629);

var G__29630 = cljs.core.next(seq__29594_29623__$1);
var G__29631 = null;
var G__29632 = (0);
var G__29633 = (0);
seq__29594_29613 = G__29630;
chunk__29595_29614 = G__29631;
count__29596_29615 = G__29632;
i__29597_29616 = G__29633;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_29610);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_29609,v_29610);

}

var G__29634 = seq__29588_29604;
var G__29635 = chunk__29589_29605;
var G__29636 = count__29590_29606;
var G__29637 = (i__29591_29607 + (1));
seq__29588_29604 = G__29634;
chunk__29589_29605 = G__29635;
count__29590_29606 = G__29636;
i__29591_29607 = G__29637;
continue;
} else {
var temp__4126__auto___29638 = cljs.core.seq(seq__29588_29604);
if(temp__4126__auto___29638){
var seq__29588_29639__$1 = temp__4126__auto___29638;
if(cljs.core.chunked_seq_QMARK_(seq__29588_29639__$1)){
var c__5061__auto___29640 = cljs.core.chunk_first(seq__29588_29639__$1);
var G__29641 = cljs.core.chunk_rest(seq__29588_29639__$1);
var G__29642 = c__5061__auto___29640;
var G__29643 = cljs.core.count(c__5061__auto___29640);
var G__29644 = (0);
seq__29588_29604 = G__29641;
chunk__29589_29605 = G__29642;
count__29590_29606 = G__29643;
i__29591_29607 = G__29644;
continue;
} else {
var vec__29598_29645 = cljs.core.first(seq__29588_29639__$1);
var k_29646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29598_29645,(0),null);
var v_29647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29598_29645,(1),null);
var G__29599_29648 = (((k_29646 instanceof cljs.core.Keyword))?k_29646.fqn:null);
switch (G__29599_29648) {
case "classes":
var seq__29600_29650 = cljs.core.seq(v_29647);
var chunk__29601_29651 = null;
var count__29602_29652 = (0);
var i__29603_29653 = (0);
while(true){
if((i__29603_29653 < count__29602_29652)){
var c_29654 = chunk__29601_29651.cljs$core$IIndexed$_nth$arity$2(null,i__29603_29653);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29654);

var G__29655 = seq__29600_29650;
var G__29656 = chunk__29601_29651;
var G__29657 = count__29602_29652;
var G__29658 = (i__29603_29653 + (1));
seq__29600_29650 = G__29655;
chunk__29601_29651 = G__29656;
count__29602_29652 = G__29657;
i__29603_29653 = G__29658;
continue;
} else {
var temp__4126__auto___29659__$1 = cljs.core.seq(seq__29600_29650);
if(temp__4126__auto___29659__$1){
var seq__29600_29660__$1 = temp__4126__auto___29659__$1;
if(cljs.core.chunked_seq_QMARK_(seq__29600_29660__$1)){
var c__5061__auto___29661 = cljs.core.chunk_first(seq__29600_29660__$1);
var G__29662 = cljs.core.chunk_rest(seq__29600_29660__$1);
var G__29663 = c__5061__auto___29661;
var G__29664 = cljs.core.count(c__5061__auto___29661);
var G__29665 = (0);
seq__29600_29650 = G__29662;
chunk__29601_29651 = G__29663;
count__29602_29652 = G__29664;
i__29603_29653 = G__29665;
continue;
} else {
var c_29666 = cljs.core.first(seq__29600_29660__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_29666);

var G__29667 = cljs.core.next(seq__29600_29660__$1);
var G__29668 = null;
var G__29669 = (0);
var G__29670 = (0);
seq__29600_29650 = G__29667;
chunk__29601_29651 = G__29668;
count__29602_29652 = G__29669;
i__29603_29653 = G__29670;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_29647);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_29646,v_29647);

}

var G__29671 = cljs.core.next(seq__29588_29639__$1);
var G__29672 = null;
var G__29673 = (0);
var G__29674 = (0);
seq__29588_29604 = G__29671;
chunk__29589_29605 = G__29672;
count__29590_29606 = G__29673;
i__29591_29607 = G__29674;
continue;
}
} else {
}
}
break;
}

n.appendChild(dommy.template.__GT_node_like(children__$1));

return n;
});
(dommy.template.PElement["string"] = true);

(dommy.template._elem["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return dommy.template.base_element(this$);
} else {
return document.createTextNode([cljs.core.str(this$)].join(''));
}
}));

(dommy.template.PElement["number"] = true);

(dommy.template._elem["number"] = (function (this$){
return document.createTextNode([cljs.core.str(this$)].join(''));
}));

cljs.core.PersistentVector.prototype.dommy$template$PElement$ = true;

cljs.core.PersistentVector.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return dommy.template.compound_element(this$__$1);
});

SVGElement.prototype.dommy$template$PElement$ = true;

SVGElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Document.prototype.dommy$template$PElement$ = true;

Document.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Text.prototype.dommy$template$PElement$ = true;

Text.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

DocumentFragment.prototype.dommy$template$PElement$ = true;

DocumentFragment.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

HTMLElement.prototype.dommy$template$PElement$ = true;

HTMLElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
try{Window.prototype.dommy$template$PElement$ = true;

Window.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
}catch (e29675){if((e29675 instanceof ReferenceError)){
var __29676 = e29675;
console.log("PElement: js/Window not defined by browser, skipping it... (running on phantomjs?)");
} else {
throw e29675;

}
}dommy.template.node = (function dommy$template$node(data){
if((function (){var G__29678 = data;
if(G__29678){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__29678.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__29678.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29678);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__29678);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.throw_unable_to_make_node(data);
}
});
dommy.template.html__GT_nodes = (function dommy$template$html__GT_nodes(html){
var parent = document.createElement("div");
parent.insertAdjacentHTML("beforeend",html);

return cljs.core.seq(Array.prototype.slice.call(parent.childNodes));
});
