// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('ona.api.http');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('ona.api.io');
/**
 * Send and parse an HTTP response as JSON.
 * Options object has special keys that modify beavior of parse-http:
 * In clj: `suppress-40x-exceptions?`, `as-map?`,`raw-response?`.
 * In cljs: `raw-response?`, `no-cache?`.
 */
ona.api.http.parse_http = (function ona$api$http$parse_http(){
var G__32526 = arguments.length;
switch (G__32526) {
case 3:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3 = (function (method,url,account){
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(method,url,account,cljs.core.PersistentArrayMap.EMPTY);
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4 = (function (method,url,account,options){
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(method,url,account,options,null);
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5 = (function (method,url,account,options,filename){
var map__32527 = options;
var map__32527__$1 = ((cljs.core.seq_QMARK_(map__32527))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32527):map__32527);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32527__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32527__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32527__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var suppress_40x_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32527__$1,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_);
var auth_token = account;
var http_request = (cljs.core.truth_(raw_response_QMARK_)?ona.api.io.raw_request:cljs_http.client.request);
var options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$put,null], null), null),method))?null:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(options,cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$form_DASH_params.cljs$core$IFn$_invoke$arity$1(options)));
var headers = ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(auth_token,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__32528 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32528) : cljs_hash.md5.md5.call(null,G__32528));
})()], null):null);
var all_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([options__$1,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$xhr,true,cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0));
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via js"));
} else {
}

var G__32529 = all_params;
return (http_request.cljs$core$IFn$_invoke$arity$1 ? http_request.cljs$core$IFn$_invoke$arity$1(G__32529) : http_request.call(null,G__32529));
});

ona.api.http.parse_http.cljs$lang$maxFixedArity = 5;
