// Compiled by ClojureScript 0.0-3196 {}
goog.provide('ona.api.http');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('ona.api.io');
/**
 * Send and parse an HTTP response as JSON.
 * Options object has special keys that modify beavior of parse-http:
 * In clj: `suppress-40x-exceptions?`, `as-map?`,`raw-response?`.
 * In cljs: `raw-response?`, `no-cache?`.
 */
ona.api.http.parse_http = (function ona$api$http$parse_http(){
var G__10954 = arguments.length;
switch (G__10954) {
case 3:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3 = (function (method,url,account){
return ona.api.http.parse_http.call(null,method,url,account,cljs.core.PersistentArrayMap.EMPTY);
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4 = (function (method,url,account,options){
return ona.api.http.parse_http.call(null,method,url,account,options,null);
});

ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5 = (function (method,url,account,options,filename){
var map__10955 = options;
var map__10955__$1 = ((cljs.core.seq_QMARK_.call(null,map__10955))?cljs.core.apply.call(null,cljs.core.hash_map,map__10955):map__10955);
var no_cache_QMARK_ = cljs.core.get.call(null,map__10955__$1,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981));
var as_map_QMARK_ = cljs.core.get.call(null,map__10955__$1,new cljs.core.Keyword(null,"as-map?","as-map?",1213586270));
var raw_response_QMARK_ = cljs.core.get.call(null,map__10955__$1,new cljs.core.Keyword(null,"raw-response?","raw-response?",557978228));
var suppress_40x_exceptions_QMARK_ = cljs.core.get.call(null,map__10955__$1,new cljs.core.Keyword(null,"suppress-40x-exceptions?","suppress-40x-exceptions?",1052218929));
var auth_token = account;
var http_request = (cljs.core.truth_(raw_response_QMARK_)?ona.api.io.raw_request:cljs_http.client.request);
var options__$1 = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null),method))?null:cljs.core.assoc.call(null,options,new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.Keyword(null,"form-params","form-params",1884296467).cljs$core$IFn$_invoke$arity$1(options)));
var headers = ona.api.io.token__GT_headers.call(null,auth_token,cljs.core._EQ_.call(null,method,new cljs.core.Keyword(null,"delete","delete",-1768633620)));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"t","t",-1397832519),cljs_hash.md5.md5.call(null,Date.now().toString())], null):null);
var all_params = cljs.core.merge.call(null,options__$1,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"xhr","xhr",-177710851),true,new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url], null));
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via js"));
} else {
}

return http_request.call(null,all_params);
});

ona.api.http.parse_http.cljs$lang$maxFixedArity = 5;
