// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('milia.utils.url');
goog.require('clojure.string');
milia.utils.remote.hosts = (function (){var G__29040 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$ui,"beta.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29040) : cljs.core.atom.call(null,G__29040));
})();
milia.utils.remote.protocol = cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol.cljs$core$IFn$_invoke$arity$1((function (){var G__29041 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__29041) : cljs.core.deref.call(null,G__29041));
})());
/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed_STAR_ = (function milia$utils$remote$protocol_prefixed_STAR_(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.protocol,"://",resources], null)));
});
milia.utils.remote.protocol_prefixed = cljs.core.memoize(milia.utils.remote.protocol_prefixed_STAR_);
milia.utils.remote.j2x_host = "j2x.ona.io";
milia.utils.remote.thumbor_host = "images.ona.io";
milia.utils.remote.forms_host = (function (){var G__29042 = (function (){var or__4276__auto__ = cljs.core.constant$keyword$forms.cljs$core$IFn$_invoke$arity$1((function (){var G__29044 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__29044) : cljs.core.deref.call(null,G__29044));
})());
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((function (){var G__29045 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__29045) : cljs.core.deref.call(null,G__29045));
})());
}
})();
return (milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__29042) : milia.utils.remote.protocol_prefixed.call(null,G__29042));
})();
milia.utils.remote.host_server = (function (){var G__29046 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((function (){var G__29047 = milia.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__29047) : cljs.core.deref.call(null,G__29047));
})()),"/"], null);
return (milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__29046) : milia.utils.remote.protocol_prefixed.call(null,G__29046));
})();
milia.utils.remote.j2x_host_server = (function (){var G__29048 = milia.utils.remote.j2x_host;
return (milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__29048) : milia.utils.remote.protocol_prefixed.call(null,G__29048));
})();
milia.utils.remote.thumbor_server = (function (){var G__29049 = milia.utils.remote.thumbor_host;
return (milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__29049) : milia.utils.remote.protocol_prefixed.call(null,G__29049));
})();
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.url.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.host_server),cljs.core.str("api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq29050){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29050));
});
/**
 * Build a Zebra url.
 */
milia.utils.remote.make_zebra_url = (function milia$utils$remote$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join((function (){var G__29052 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$ui.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts),"/"], null);
return (milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? milia.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__29052) : milia.utils.remote.protocol_prefixed.call(null,G__29052));
})(),postfix);
});

milia.utils.remote.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_zebra_url.cljs$lang$applyTo = (function (seq29051){
return milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29051));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.j2x_host_server,postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq29053){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29053));
});
milia.utils.remote.url_for_headers = (function milia$utils$remote$url_for_headers(headers,suffix){
return [cljs.core.str(milia.utils.remote.protocol),cljs.core.str("://"),cljs.core.str((function (){var G__29055 = "host";
return (headers.cljs$core$IFn$_invoke$arity$1 ? headers.cljs$core$IFn$_invoke$arity$1(G__29055) : headers.call(null,G__29055));
})()),cljs.core.str(suffix)].join('');
});
