// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t12339 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12339 = (function (f,fn_handler,meta12340){
this.f = f;
this.fn_handler = fn_handler;
this.meta12340 = meta12340;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12339.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12339.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t12339.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t12339.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12341){
var self__ = this;
var _12341__$1 = this;
return self__.meta12340;
});

cljs.core.async.t12339.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12341,meta12340__$1){
var self__ = this;
var _12341__$1 = this;
return (new cljs.core.async.t12339(self__.f,self__.fn_handler,meta12340__$1));
});

cljs.core.async.t12339.cljs$lang$type = true;

cljs.core.async.t12339.cljs$lang$ctorStr = "cljs.core.async/t12339";

cljs.core.async.t12339.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12339");
});

cljs.core.async.__GT_t12339 = (function cljs$core$async$fn_handler_$___GT_t12339(f__$1,fn_handler__$1,meta12340){
return (new cljs.core.async.t12339(f__$1,fn_handler__$1,meta12340));
});

}

return (new cljs.core.async.t12339(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__12343 = buff;
if(G__12343){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__12343.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__12343.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12343);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12343);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__12345 = arguments.length;
switch (G__12345) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__12348 = arguments.length;
switch (G__12348) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12350 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12350);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12350,ret){
return (function (){
return fn1.call(null,val_12350);
});})(val_12350,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__12352 = arguments.length;
switch (G__12352) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___12354 = n;
var x_12355 = (0);
while(true){
if((x_12355 < n__5161__auto___12354)){
(a[x_12355] = (0));

var G__12356 = (x_12355 + (1));
x_12355 = G__12356;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12357 = (i + (1));
i = G__12357;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t12361 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12361 = (function (flag,alt_flag,meta12362){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta12362 = meta12362;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12361.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12361.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t12361.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t12361.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12363){
var self__ = this;
var _12363__$1 = this;
return self__.meta12362;
});})(flag))
;

cljs.core.async.t12361.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12363,meta12362__$1){
var self__ = this;
var _12363__$1 = this;
return (new cljs.core.async.t12361(self__.flag,self__.alt_flag,meta12362__$1));
});})(flag))
;

cljs.core.async.t12361.cljs$lang$type = true;

cljs.core.async.t12361.cljs$lang$ctorStr = "cljs.core.async/t12361";

cljs.core.async.t12361.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12361");
});})(flag))
;

cljs.core.async.__GT_t12361 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t12361(flag__$1,alt_flag__$1,meta12362){
return (new cljs.core.async.t12361(flag__$1,alt_flag__$1,meta12362));
});})(flag))
;

}

return (new cljs.core.async.t12361(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t12367 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12367 = (function (cb,flag,alt_handler,meta12368){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta12368 = meta12368;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12367.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12367.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t12367.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t12367.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12369){
var self__ = this;
var _12369__$1 = this;
return self__.meta12368;
});

cljs.core.async.t12367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12369,meta12368__$1){
var self__ = this;
var _12369__$1 = this;
return (new cljs.core.async.t12367(self__.cb,self__.flag,self__.alt_handler,meta12368__$1));
});

cljs.core.async.t12367.cljs$lang$type = true;

cljs.core.async.t12367.cljs$lang$ctorStr = "cljs.core.async/t12367";

cljs.core.async.t12367.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12367");
});

cljs.core.async.__GT_t12367 = (function cljs$core$async$alt_handler_$___GT_t12367(cb__$1,flag__$1,alt_handler__$1,meta12368){
return (new cljs.core.async.t12367(cb__$1,flag__$1,alt_handler__$1,meta12368));
});

}

return (new cljs.core.async.t12367(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12370_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12370_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12371_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12371_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12372 = (i + (1));
i = G__12372;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12375){
var map__12376 = p__12375;
var map__12376__$1 = ((cljs.core.seq_QMARK_.call(null,map__12376))?cljs.core.apply.call(null,cljs.core.hash_map,map__12376):map__12376);
var opts = map__12376__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12373){
var G__12374 = cljs.core.first.call(null,seq12373);
var seq12373__$1 = cljs.core.next.call(null,seq12373);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12374,seq12373__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__12378 = arguments.length;
switch (G__12378) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___12427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12427){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12427){
return (function (state_12402){
var state_val_12403 = (state_12402[(1)]);
if((state_val_12403 === (7))){
var inst_12398 = (state_12402[(2)]);
var state_12402__$1 = state_12402;
var statearr_12404_12428 = state_12402__$1;
(statearr_12404_12428[(2)] = inst_12398);

(statearr_12404_12428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (1))){
var state_12402__$1 = state_12402;
var statearr_12405_12429 = state_12402__$1;
(statearr_12405_12429[(2)] = null);

(statearr_12405_12429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (4))){
var inst_12381 = (state_12402[(7)]);
var inst_12381__$1 = (state_12402[(2)]);
var inst_12382 = (inst_12381__$1 == null);
var state_12402__$1 = (function (){var statearr_12406 = state_12402;
(statearr_12406[(7)] = inst_12381__$1);

return statearr_12406;
})();
if(cljs.core.truth_(inst_12382)){
var statearr_12407_12430 = state_12402__$1;
(statearr_12407_12430[(1)] = (5));

} else {
var statearr_12408_12431 = state_12402__$1;
(statearr_12408_12431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (13))){
var state_12402__$1 = state_12402;
var statearr_12409_12432 = state_12402__$1;
(statearr_12409_12432[(2)] = null);

(statearr_12409_12432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (6))){
var inst_12381 = (state_12402[(7)]);
var state_12402__$1 = state_12402;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12402__$1,(11),to,inst_12381);
} else {
if((state_val_12403 === (3))){
var inst_12400 = (state_12402[(2)]);
var state_12402__$1 = state_12402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12402__$1,inst_12400);
} else {
if((state_val_12403 === (12))){
var state_12402__$1 = state_12402;
var statearr_12410_12433 = state_12402__$1;
(statearr_12410_12433[(2)] = null);

(statearr_12410_12433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (2))){
var state_12402__$1 = state_12402;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12402__$1,(4),from);
} else {
if((state_val_12403 === (11))){
var inst_12391 = (state_12402[(2)]);
var state_12402__$1 = state_12402;
if(cljs.core.truth_(inst_12391)){
var statearr_12411_12434 = state_12402__$1;
(statearr_12411_12434[(1)] = (12));

} else {
var statearr_12412_12435 = state_12402__$1;
(statearr_12412_12435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (9))){
var state_12402__$1 = state_12402;
var statearr_12413_12436 = state_12402__$1;
(statearr_12413_12436[(2)] = null);

(statearr_12413_12436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (5))){
var state_12402__$1 = state_12402;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12414_12437 = state_12402__$1;
(statearr_12414_12437[(1)] = (8));

} else {
var statearr_12415_12438 = state_12402__$1;
(statearr_12415_12438[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (14))){
var inst_12396 = (state_12402[(2)]);
var state_12402__$1 = state_12402;
var statearr_12416_12439 = state_12402__$1;
(statearr_12416_12439[(2)] = inst_12396);

(statearr_12416_12439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (10))){
var inst_12388 = (state_12402[(2)]);
var state_12402__$1 = state_12402;
var statearr_12417_12440 = state_12402__$1;
(statearr_12417_12440[(2)] = inst_12388);

(statearr_12417_12440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12403 === (8))){
var inst_12385 = cljs.core.async.close_BANG_.call(null,to);
var state_12402__$1 = state_12402;
var statearr_12418_12441 = state_12402__$1;
(statearr_12418_12441[(2)] = inst_12385);

(statearr_12418_12441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12427))
;
return ((function (switch__7647__auto__,c__7709__auto___12427){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12422 = [null,null,null,null,null,null,null,null];
(statearr_12422[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12422[(1)] = (1));

return statearr_12422;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12402){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12423){if((e12423 instanceof Object)){
var ex__7651__auto__ = e12423;
var statearr_12424_12442 = state_12402;
(statearr_12424_12442[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12402);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12443 = state_12402;
state_12402 = G__12443;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12402){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12427))
})();
var state__7711__auto__ = (function (){var statearr_12425 = f__7710__auto__.call(null);
(statearr_12425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12427);

return statearr_12425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12427))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12627){
var vec__12628 = p__12627;
var v = cljs.core.nth.call(null,vec__12628,(0),null);
var p = cljs.core.nth.call(null,vec__12628,(1),null);
var job = vec__12628;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7709__auto___12810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results){
return (function (state_12633){
var state_val_12634 = (state_12633[(1)]);
if((state_val_12634 === (2))){
var inst_12630 = (state_12633[(2)]);
var inst_12631 = cljs.core.async.close_BANG_.call(null,res);
var state_12633__$1 = (function (){var statearr_12635 = state_12633;
(statearr_12635[(7)] = inst_12630);

return statearr_12635;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12633__$1,inst_12631);
} else {
if((state_val_12634 === (1))){
var state_12633__$1 = state_12633;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12633__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12639 = [null,null,null,null,null,null,null,null];
(statearr_12639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12639[(1)] = (1));

return statearr_12639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12633){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12640){if((e12640 instanceof Object)){
var ex__7651__auto__ = e12640;
var statearr_12641_12811 = state_12633;
(statearr_12641_12811[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12633);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12812 = state_12633;
state_12633 = G__12812;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12633){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_12642 = f__7710__auto__.call(null);
(statearr_12642[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12810);

return statearr_12642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12810,res,vec__12628,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12643){
var vec__12644 = p__12643;
var v = cljs.core.nth.call(null,vec__12644,(0),null);
var p = cljs.core.nth.call(null,vec__12644,(1),null);
var job = vec__12644;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___12813 = n;
var __12814 = (0);
while(true){
if((__12814 < n__5161__auto___12813)){
var G__12645_12815 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12645_12815) {
case "async":
var c__7709__auto___12817 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12814,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12814,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function (state_12658){
var state_val_12659 = (state_12658[(1)]);
if((state_val_12659 === (7))){
var inst_12654 = (state_12658[(2)]);
var state_12658__$1 = state_12658;
var statearr_12660_12818 = state_12658__$1;
(statearr_12660_12818[(2)] = inst_12654);

(statearr_12660_12818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12659 === (6))){
var state_12658__$1 = state_12658;
var statearr_12661_12819 = state_12658__$1;
(statearr_12661_12819[(2)] = null);

(statearr_12661_12819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12659 === (5))){
var state_12658__$1 = state_12658;
var statearr_12662_12820 = state_12658__$1;
(statearr_12662_12820[(2)] = null);

(statearr_12662_12820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12659 === (4))){
var inst_12648 = (state_12658[(2)]);
var inst_12649 = async.call(null,inst_12648);
var state_12658__$1 = state_12658;
if(cljs.core.truth_(inst_12649)){
var statearr_12663_12821 = state_12658__$1;
(statearr_12663_12821[(1)] = (5));

} else {
var statearr_12664_12822 = state_12658__$1;
(statearr_12664_12822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12659 === (3))){
var inst_12656 = (state_12658[(2)]);
var state_12658__$1 = state_12658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12658__$1,inst_12656);
} else {
if((state_val_12659 === (2))){
var state_12658__$1 = state_12658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12658__$1,(4),jobs);
} else {
if((state_val_12659 === (1))){
var state_12658__$1 = state_12658;
var statearr_12665_12823 = state_12658__$1;
(statearr_12665_12823[(2)] = null);

(statearr_12665_12823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12814,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
;
return ((function (__12814,switch__7647__auto__,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12669 = [null,null,null,null,null,null,null];
(statearr_12669[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12669[(1)] = (1));

return statearr_12669;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12658){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12670){if((e12670 instanceof Object)){
var ex__7651__auto__ = e12670;
var statearr_12671_12824 = state_12658;
(statearr_12671_12824[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12658);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12670;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12825 = state_12658;
state_12658 = G__12825;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12658){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12814,switch__7647__auto__,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12672 = f__7710__auto__.call(null);
(statearr_12672[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12817);

return statearr_12672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12814,c__7709__auto___12817,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___12826 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12814,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12814,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function (state_12685){
var state_val_12686 = (state_12685[(1)]);
if((state_val_12686 === (7))){
var inst_12681 = (state_12685[(2)]);
var state_12685__$1 = state_12685;
var statearr_12687_12827 = state_12685__$1;
(statearr_12687_12827[(2)] = inst_12681);

(statearr_12687_12827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12686 === (6))){
var state_12685__$1 = state_12685;
var statearr_12688_12828 = state_12685__$1;
(statearr_12688_12828[(2)] = null);

(statearr_12688_12828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12686 === (5))){
var state_12685__$1 = state_12685;
var statearr_12689_12829 = state_12685__$1;
(statearr_12689_12829[(2)] = null);

(statearr_12689_12829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12686 === (4))){
var inst_12675 = (state_12685[(2)]);
var inst_12676 = process.call(null,inst_12675);
var state_12685__$1 = state_12685;
if(cljs.core.truth_(inst_12676)){
var statearr_12690_12830 = state_12685__$1;
(statearr_12690_12830[(1)] = (5));

} else {
var statearr_12691_12831 = state_12685__$1;
(statearr_12691_12831[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12686 === (3))){
var inst_12683 = (state_12685[(2)]);
var state_12685__$1 = state_12685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12685__$1,inst_12683);
} else {
if((state_val_12686 === (2))){
var state_12685__$1 = state_12685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12685__$1,(4),jobs);
} else {
if((state_val_12686 === (1))){
var state_12685__$1 = state_12685;
var statearr_12692_12832 = state_12685__$1;
(statearr_12692_12832[(2)] = null);

(statearr_12692_12832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12814,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
;
return ((function (__12814,switch__7647__auto__,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12696 = [null,null,null,null,null,null,null];
(statearr_12696[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12696[(1)] = (1));

return statearr_12696;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12685){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12697){if((e12697 instanceof Object)){
var ex__7651__auto__ = e12697;
var statearr_12698_12833 = state_12685;
(statearr_12698_12833[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12697;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12834 = state_12685;
state_12685 = G__12834;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12814,switch__7647__auto__,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12699 = f__7710__auto__.call(null);
(statearr_12699[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12826);

return statearr_12699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12814,c__7709__auto___12826,G__12645_12815,n__5161__auto___12813,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12835 = (__12814 + (1));
__12814 = G__12835;
continue;
} else {
}
break;
}

var c__7709__auto___12836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12836,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12836,jobs,results,process,async){
return (function (state_12721){
var state_val_12722 = (state_12721[(1)]);
if((state_val_12722 === (9))){
var inst_12714 = (state_12721[(2)]);
var state_12721__$1 = (function (){var statearr_12723 = state_12721;
(statearr_12723[(7)] = inst_12714);

return statearr_12723;
})();
var statearr_12724_12837 = state_12721__$1;
(statearr_12724_12837[(2)] = null);

(statearr_12724_12837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (8))){
var inst_12707 = (state_12721[(8)]);
var inst_12712 = (state_12721[(2)]);
var state_12721__$1 = (function (){var statearr_12725 = state_12721;
(statearr_12725[(9)] = inst_12712);

return statearr_12725;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12721__$1,(9),results,inst_12707);
} else {
if((state_val_12722 === (7))){
var inst_12717 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12726_12838 = state_12721__$1;
(statearr_12726_12838[(2)] = inst_12717);

(statearr_12726_12838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (6))){
var inst_12702 = (state_12721[(10)]);
var inst_12707 = (state_12721[(8)]);
var inst_12707__$1 = cljs.core.async.chan.call(null,(1));
var inst_12708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12709 = [inst_12702,inst_12707__$1];
var inst_12710 = (new cljs.core.PersistentVector(null,2,(5),inst_12708,inst_12709,null));
var state_12721__$1 = (function (){var statearr_12727 = state_12721;
(statearr_12727[(8)] = inst_12707__$1);

return statearr_12727;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12721__$1,(8),jobs,inst_12710);
} else {
if((state_val_12722 === (5))){
var inst_12705 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12721__$1 = state_12721;
var statearr_12728_12839 = state_12721__$1;
(statearr_12728_12839[(2)] = inst_12705);

(statearr_12728_12839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (4))){
var inst_12702 = (state_12721[(10)]);
var inst_12702__$1 = (state_12721[(2)]);
var inst_12703 = (inst_12702__$1 == null);
var state_12721__$1 = (function (){var statearr_12729 = state_12721;
(statearr_12729[(10)] = inst_12702__$1);

return statearr_12729;
})();
if(cljs.core.truth_(inst_12703)){
var statearr_12730_12840 = state_12721__$1;
(statearr_12730_12840[(1)] = (5));

} else {
var statearr_12731_12841 = state_12721__$1;
(statearr_12731_12841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (3))){
var inst_12719 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12721__$1,inst_12719);
} else {
if((state_val_12722 === (2))){
var state_12721__$1 = state_12721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12721__$1,(4),from);
} else {
if((state_val_12722 === (1))){
var state_12721__$1 = state_12721;
var statearr_12732_12842 = state_12721__$1;
(statearr_12732_12842[(2)] = null);

(statearr_12732_12842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12836,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___12836,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12736 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12736[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12736[(1)] = (1));

return statearr_12736;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12721){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12737){if((e12737 instanceof Object)){
var ex__7651__auto__ = e12737;
var statearr_12738_12843 = state_12721;
(statearr_12738_12843[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12721);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12844 = state_12721;
state_12721 = G__12844;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12721){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12836,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12739 = f__7710__auto__.call(null);
(statearr_12739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12836);

return statearr_12739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12836,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_12777){
var state_val_12778 = (state_12777[(1)]);
if((state_val_12778 === (7))){
var inst_12773 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
var statearr_12779_12845 = state_12777__$1;
(statearr_12779_12845[(2)] = inst_12773);

(statearr_12779_12845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (20))){
var state_12777__$1 = state_12777;
var statearr_12780_12846 = state_12777__$1;
(statearr_12780_12846[(2)] = null);

(statearr_12780_12846[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (1))){
var state_12777__$1 = state_12777;
var statearr_12781_12847 = state_12777__$1;
(statearr_12781_12847[(2)] = null);

(statearr_12781_12847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (4))){
var inst_12742 = (state_12777[(7)]);
var inst_12742__$1 = (state_12777[(2)]);
var inst_12743 = (inst_12742__$1 == null);
var state_12777__$1 = (function (){var statearr_12782 = state_12777;
(statearr_12782[(7)] = inst_12742__$1);

return statearr_12782;
})();
if(cljs.core.truth_(inst_12743)){
var statearr_12783_12848 = state_12777__$1;
(statearr_12783_12848[(1)] = (5));

} else {
var statearr_12784_12849 = state_12777__$1;
(statearr_12784_12849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (15))){
var inst_12755 = (state_12777[(8)]);
var state_12777__$1 = state_12777;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12777__$1,(18),to,inst_12755);
} else {
if((state_val_12778 === (21))){
var inst_12768 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
var statearr_12785_12850 = state_12777__$1;
(statearr_12785_12850[(2)] = inst_12768);

(statearr_12785_12850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (13))){
var inst_12770 = (state_12777[(2)]);
var state_12777__$1 = (function (){var statearr_12786 = state_12777;
(statearr_12786[(9)] = inst_12770);

return statearr_12786;
})();
var statearr_12787_12851 = state_12777__$1;
(statearr_12787_12851[(2)] = null);

(statearr_12787_12851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (6))){
var inst_12742 = (state_12777[(7)]);
var state_12777__$1 = state_12777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12777__$1,(11),inst_12742);
} else {
if((state_val_12778 === (17))){
var inst_12763 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
if(cljs.core.truth_(inst_12763)){
var statearr_12788_12852 = state_12777__$1;
(statearr_12788_12852[(1)] = (19));

} else {
var statearr_12789_12853 = state_12777__$1;
(statearr_12789_12853[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (3))){
var inst_12775 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12777__$1,inst_12775);
} else {
if((state_val_12778 === (12))){
var inst_12752 = (state_12777[(10)]);
var state_12777__$1 = state_12777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12777__$1,(14),inst_12752);
} else {
if((state_val_12778 === (2))){
var state_12777__$1 = state_12777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12777__$1,(4),results);
} else {
if((state_val_12778 === (19))){
var state_12777__$1 = state_12777;
var statearr_12790_12854 = state_12777__$1;
(statearr_12790_12854[(2)] = null);

(statearr_12790_12854[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (11))){
var inst_12752 = (state_12777[(2)]);
var state_12777__$1 = (function (){var statearr_12791 = state_12777;
(statearr_12791[(10)] = inst_12752);

return statearr_12791;
})();
var statearr_12792_12855 = state_12777__$1;
(statearr_12792_12855[(2)] = null);

(statearr_12792_12855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (9))){
var state_12777__$1 = state_12777;
var statearr_12793_12856 = state_12777__$1;
(statearr_12793_12856[(2)] = null);

(statearr_12793_12856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (5))){
var state_12777__$1 = state_12777;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12794_12857 = state_12777__$1;
(statearr_12794_12857[(1)] = (8));

} else {
var statearr_12795_12858 = state_12777__$1;
(statearr_12795_12858[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (14))){
var inst_12757 = (state_12777[(11)]);
var inst_12755 = (state_12777[(8)]);
var inst_12755__$1 = (state_12777[(2)]);
var inst_12756 = (inst_12755__$1 == null);
var inst_12757__$1 = cljs.core.not.call(null,inst_12756);
var state_12777__$1 = (function (){var statearr_12796 = state_12777;
(statearr_12796[(11)] = inst_12757__$1);

(statearr_12796[(8)] = inst_12755__$1);

return statearr_12796;
})();
if(inst_12757__$1){
var statearr_12797_12859 = state_12777__$1;
(statearr_12797_12859[(1)] = (15));

} else {
var statearr_12798_12860 = state_12777__$1;
(statearr_12798_12860[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (16))){
var inst_12757 = (state_12777[(11)]);
var state_12777__$1 = state_12777;
var statearr_12799_12861 = state_12777__$1;
(statearr_12799_12861[(2)] = inst_12757);

(statearr_12799_12861[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (10))){
var inst_12749 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
var statearr_12800_12862 = state_12777__$1;
(statearr_12800_12862[(2)] = inst_12749);

(statearr_12800_12862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (18))){
var inst_12760 = (state_12777[(2)]);
var state_12777__$1 = state_12777;
var statearr_12801_12863 = state_12777__$1;
(statearr_12801_12863[(2)] = inst_12760);

(statearr_12801_12863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12778 === (8))){
var inst_12746 = cljs.core.async.close_BANG_.call(null,to);
var state_12777__$1 = state_12777;
var statearr_12802_12864 = state_12777__$1;
(statearr_12802_12864[(2)] = inst_12746);

(statearr_12802_12864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12806 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12806[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12806[(1)] = (1));

return statearr_12806;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12777){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12807){if((e12807 instanceof Object)){
var ex__7651__auto__ = e12807;
var statearr_12808_12865 = state_12777;
(statearr_12808_12865[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12777);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12866 = state_12777;
state_12777 = G__12866;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12777){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12809 = f__7710__auto__.call(null);
(statearr_12809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_12809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__12868 = arguments.length;
switch (G__12868) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__12871 = arguments.length;
switch (G__12871) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__12874 = arguments.length;
switch (G__12874) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7709__auto___12926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12926,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12926,tc,fc){
return (function (state_12900){
var state_val_12901 = (state_12900[(1)]);
if((state_val_12901 === (7))){
var inst_12896 = (state_12900[(2)]);
var state_12900__$1 = state_12900;
var statearr_12902_12927 = state_12900__$1;
(statearr_12902_12927[(2)] = inst_12896);

(statearr_12902_12927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (1))){
var state_12900__$1 = state_12900;
var statearr_12903_12928 = state_12900__$1;
(statearr_12903_12928[(2)] = null);

(statearr_12903_12928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (4))){
var inst_12877 = (state_12900[(7)]);
var inst_12877__$1 = (state_12900[(2)]);
var inst_12878 = (inst_12877__$1 == null);
var state_12900__$1 = (function (){var statearr_12904 = state_12900;
(statearr_12904[(7)] = inst_12877__$1);

return statearr_12904;
})();
if(cljs.core.truth_(inst_12878)){
var statearr_12905_12929 = state_12900__$1;
(statearr_12905_12929[(1)] = (5));

} else {
var statearr_12906_12930 = state_12900__$1;
(statearr_12906_12930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (13))){
var state_12900__$1 = state_12900;
var statearr_12907_12931 = state_12900__$1;
(statearr_12907_12931[(2)] = null);

(statearr_12907_12931[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (6))){
var inst_12877 = (state_12900[(7)]);
var inst_12883 = p.call(null,inst_12877);
var state_12900__$1 = state_12900;
if(cljs.core.truth_(inst_12883)){
var statearr_12908_12932 = state_12900__$1;
(statearr_12908_12932[(1)] = (9));

} else {
var statearr_12909_12933 = state_12900__$1;
(statearr_12909_12933[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (3))){
var inst_12898 = (state_12900[(2)]);
var state_12900__$1 = state_12900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12900__$1,inst_12898);
} else {
if((state_val_12901 === (12))){
var state_12900__$1 = state_12900;
var statearr_12910_12934 = state_12900__$1;
(statearr_12910_12934[(2)] = null);

(statearr_12910_12934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (2))){
var state_12900__$1 = state_12900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12900__$1,(4),ch);
} else {
if((state_val_12901 === (11))){
var inst_12877 = (state_12900[(7)]);
var inst_12887 = (state_12900[(2)]);
var state_12900__$1 = state_12900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12900__$1,(8),inst_12887,inst_12877);
} else {
if((state_val_12901 === (9))){
var state_12900__$1 = state_12900;
var statearr_12911_12935 = state_12900__$1;
(statearr_12911_12935[(2)] = tc);

(statearr_12911_12935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (5))){
var inst_12880 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12881 = cljs.core.async.close_BANG_.call(null,fc);
var state_12900__$1 = (function (){var statearr_12912 = state_12900;
(statearr_12912[(8)] = inst_12880);

return statearr_12912;
})();
var statearr_12913_12936 = state_12900__$1;
(statearr_12913_12936[(2)] = inst_12881);

(statearr_12913_12936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (14))){
var inst_12894 = (state_12900[(2)]);
var state_12900__$1 = state_12900;
var statearr_12914_12937 = state_12900__$1;
(statearr_12914_12937[(2)] = inst_12894);

(statearr_12914_12937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (10))){
var state_12900__$1 = state_12900;
var statearr_12915_12938 = state_12900__$1;
(statearr_12915_12938[(2)] = fc);

(statearr_12915_12938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12901 === (8))){
var inst_12889 = (state_12900[(2)]);
var state_12900__$1 = state_12900;
if(cljs.core.truth_(inst_12889)){
var statearr_12916_12939 = state_12900__$1;
(statearr_12916_12939[(1)] = (12));

} else {
var statearr_12917_12940 = state_12900__$1;
(statearr_12917_12940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12926,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___12926,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12921 = [null,null,null,null,null,null,null,null,null];
(statearr_12921[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12921[(1)] = (1));

return statearr_12921;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12900){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12922){if((e12922 instanceof Object)){
var ex__7651__auto__ = e12922;
var statearr_12923_12941 = state_12900;
(statearr_12923_12941[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12942 = state_12900;
state_12900 = G__12942;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12900){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12926,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_12924 = f__7710__auto__.call(null);
(statearr_12924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12926);

return statearr_12924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12926,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_12989){
var state_val_12990 = (state_12989[(1)]);
if((state_val_12990 === (7))){
var inst_12985 = (state_12989[(2)]);
var state_12989__$1 = state_12989;
var statearr_12991_13007 = state_12989__$1;
(statearr_12991_13007[(2)] = inst_12985);

(statearr_12991_13007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12990 === (6))){
var inst_12975 = (state_12989[(7)]);
var inst_12978 = (state_12989[(8)]);
var inst_12982 = f.call(null,inst_12975,inst_12978);
var inst_12975__$1 = inst_12982;
var state_12989__$1 = (function (){var statearr_12992 = state_12989;
(statearr_12992[(7)] = inst_12975__$1);

return statearr_12992;
})();
var statearr_12993_13008 = state_12989__$1;
(statearr_12993_13008[(2)] = null);

(statearr_12993_13008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12990 === (5))){
var inst_12975 = (state_12989[(7)]);
var state_12989__$1 = state_12989;
var statearr_12994_13009 = state_12989__$1;
(statearr_12994_13009[(2)] = inst_12975);

(statearr_12994_13009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12990 === (4))){
var inst_12978 = (state_12989[(8)]);
var inst_12978__$1 = (state_12989[(2)]);
var inst_12979 = (inst_12978__$1 == null);
var state_12989__$1 = (function (){var statearr_12995 = state_12989;
(statearr_12995[(8)] = inst_12978__$1);

return statearr_12995;
})();
if(cljs.core.truth_(inst_12979)){
var statearr_12996_13010 = state_12989__$1;
(statearr_12996_13010[(1)] = (5));

} else {
var statearr_12997_13011 = state_12989__$1;
(statearr_12997_13011[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12990 === (3))){
var inst_12987 = (state_12989[(2)]);
var state_12989__$1 = state_12989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12989__$1,inst_12987);
} else {
if((state_val_12990 === (2))){
var state_12989__$1 = state_12989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12989__$1,(4),ch);
} else {
if((state_val_12990 === (1))){
var inst_12975 = init;
var state_12989__$1 = (function (){var statearr_12998 = state_12989;
(statearr_12998[(7)] = inst_12975);

return statearr_12998;
})();
var statearr_12999_13012 = state_12989__$1;
(statearr_12999_13012[(2)] = null);

(statearr_12999_13012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_13003 = [null,null,null,null,null,null,null,null,null];
(statearr_13003[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_13003[(1)] = (1));

return statearr_13003;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_12989){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13004){if((e13004 instanceof Object)){
var ex__7651__auto__ = e13004;
var statearr_13005_13013 = state_12989;
(statearr_13005_13013[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13004;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13014 = state_12989;
state_12989 = G__13014;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_12989){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_12989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13006 = f__7710__auto__.call(null);
(statearr_13006[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__13016 = arguments.length;
switch (G__13016) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13041){
var state_val_13042 = (state_13041[(1)]);
if((state_val_13042 === (7))){
var inst_13023 = (state_13041[(2)]);
var state_13041__$1 = state_13041;
var statearr_13043_13067 = state_13041__$1;
(statearr_13043_13067[(2)] = inst_13023);

(statearr_13043_13067[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (1))){
var inst_13017 = cljs.core.seq.call(null,coll);
var inst_13018 = inst_13017;
var state_13041__$1 = (function (){var statearr_13044 = state_13041;
(statearr_13044[(7)] = inst_13018);

return statearr_13044;
})();
var statearr_13045_13068 = state_13041__$1;
(statearr_13045_13068[(2)] = null);

(statearr_13045_13068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (4))){
var inst_13018 = (state_13041[(7)]);
var inst_13021 = cljs.core.first.call(null,inst_13018);
var state_13041__$1 = state_13041;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13041__$1,(7),ch,inst_13021);
} else {
if((state_val_13042 === (13))){
var inst_13035 = (state_13041[(2)]);
var state_13041__$1 = state_13041;
var statearr_13046_13069 = state_13041__$1;
(statearr_13046_13069[(2)] = inst_13035);

(statearr_13046_13069[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (6))){
var inst_13026 = (state_13041[(2)]);
var state_13041__$1 = state_13041;
if(cljs.core.truth_(inst_13026)){
var statearr_13047_13070 = state_13041__$1;
(statearr_13047_13070[(1)] = (8));

} else {
var statearr_13048_13071 = state_13041__$1;
(statearr_13048_13071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (3))){
var inst_13039 = (state_13041[(2)]);
var state_13041__$1 = state_13041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13041__$1,inst_13039);
} else {
if((state_val_13042 === (12))){
var state_13041__$1 = state_13041;
var statearr_13049_13072 = state_13041__$1;
(statearr_13049_13072[(2)] = null);

(statearr_13049_13072[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (2))){
var inst_13018 = (state_13041[(7)]);
var state_13041__$1 = state_13041;
if(cljs.core.truth_(inst_13018)){
var statearr_13050_13073 = state_13041__$1;
(statearr_13050_13073[(1)] = (4));

} else {
var statearr_13051_13074 = state_13041__$1;
(statearr_13051_13074[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (11))){
var inst_13032 = cljs.core.async.close_BANG_.call(null,ch);
var state_13041__$1 = state_13041;
var statearr_13052_13075 = state_13041__$1;
(statearr_13052_13075[(2)] = inst_13032);

(statearr_13052_13075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (9))){
var state_13041__$1 = state_13041;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13053_13076 = state_13041__$1;
(statearr_13053_13076[(1)] = (11));

} else {
var statearr_13054_13077 = state_13041__$1;
(statearr_13054_13077[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (5))){
var inst_13018 = (state_13041[(7)]);
var state_13041__$1 = state_13041;
var statearr_13055_13078 = state_13041__$1;
(statearr_13055_13078[(2)] = inst_13018);

(statearr_13055_13078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (10))){
var inst_13037 = (state_13041[(2)]);
var state_13041__$1 = state_13041;
var statearr_13056_13079 = state_13041__$1;
(statearr_13056_13079[(2)] = inst_13037);

(statearr_13056_13079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13042 === (8))){
var inst_13018 = (state_13041[(7)]);
var inst_13028 = cljs.core.next.call(null,inst_13018);
var inst_13018__$1 = inst_13028;
var state_13041__$1 = (function (){var statearr_13057 = state_13041;
(statearr_13057[(7)] = inst_13018__$1);

return statearr_13057;
})();
var statearr_13058_13080 = state_13041__$1;
(statearr_13058_13080[(2)] = null);

(statearr_13058_13080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_13062 = [null,null,null,null,null,null,null,null];
(statearr_13062[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_13062[(1)] = (1));

return statearr_13062;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13041){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13063){if((e13063 instanceof Object)){
var ex__7651__auto__ = e13063;
var statearr_13064_13081 = state_13041;
(statearr_13064_13081[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13063;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13082 = state_13041;
state_13041 = G__13082;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13065 = f__7710__auto__.call(null);
(statearr_13065[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj13084 = {};
return obj13084;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj13086 = {};
return obj13086;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t13308 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13308 = (function (cs,ch,mult,meta13309){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta13309 = meta13309;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13308.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t13308.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t13308.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t13308.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t13308.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13308.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t13308.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13310){
var self__ = this;
var _13310__$1 = this;
return self__.meta13309;
});})(cs))
;

cljs.core.async.t13308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13310,meta13309__$1){
var self__ = this;
var _13310__$1 = this;
return (new cljs.core.async.t13308(self__.cs,self__.ch,self__.mult,meta13309__$1));
});})(cs))
;

cljs.core.async.t13308.cljs$lang$type = true;

cljs.core.async.t13308.cljs$lang$ctorStr = "cljs.core.async/t13308";

cljs.core.async.t13308.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13308");
});})(cs))
;

cljs.core.async.__GT_t13308 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t13308(cs__$1,ch__$1,mult__$1,meta13309){
return (new cljs.core.async.t13308(cs__$1,ch__$1,mult__$1,meta13309));
});})(cs))
;

}

return (new cljs.core.async.t13308(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___13529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13529,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13529,cs,m,dchan,dctr,done){
return (function (state_13441){
var state_val_13442 = (state_13441[(1)]);
if((state_val_13442 === (7))){
var inst_13437 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13443_13530 = state_13441__$1;
(statearr_13443_13530[(2)] = inst_13437);

(statearr_13443_13530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (20))){
var inst_13342 = (state_13441[(7)]);
var inst_13352 = cljs.core.first.call(null,inst_13342);
var inst_13353 = cljs.core.nth.call(null,inst_13352,(0),null);
var inst_13354 = cljs.core.nth.call(null,inst_13352,(1),null);
var state_13441__$1 = (function (){var statearr_13444 = state_13441;
(statearr_13444[(8)] = inst_13353);

return statearr_13444;
})();
if(cljs.core.truth_(inst_13354)){
var statearr_13445_13531 = state_13441__$1;
(statearr_13445_13531[(1)] = (22));

} else {
var statearr_13446_13532 = state_13441__$1;
(statearr_13446_13532[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (27))){
var inst_13384 = (state_13441[(9)]);
var inst_13382 = (state_13441[(10)]);
var inst_13313 = (state_13441[(11)]);
var inst_13389 = (state_13441[(12)]);
var inst_13389__$1 = cljs.core._nth.call(null,inst_13382,inst_13384);
var inst_13390 = cljs.core.async.put_BANG_.call(null,inst_13389__$1,inst_13313,done);
var state_13441__$1 = (function (){var statearr_13447 = state_13441;
(statearr_13447[(12)] = inst_13389__$1);

return statearr_13447;
})();
if(cljs.core.truth_(inst_13390)){
var statearr_13448_13533 = state_13441__$1;
(statearr_13448_13533[(1)] = (30));

} else {
var statearr_13449_13534 = state_13441__$1;
(statearr_13449_13534[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (1))){
var state_13441__$1 = state_13441;
var statearr_13450_13535 = state_13441__$1;
(statearr_13450_13535[(2)] = null);

(statearr_13450_13535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (24))){
var inst_13342 = (state_13441[(7)]);
var inst_13359 = (state_13441[(2)]);
var inst_13360 = cljs.core.next.call(null,inst_13342);
var inst_13322 = inst_13360;
var inst_13323 = null;
var inst_13324 = (0);
var inst_13325 = (0);
var state_13441__$1 = (function (){var statearr_13451 = state_13441;
(statearr_13451[(13)] = inst_13325);

(statearr_13451[(14)] = inst_13359);

(statearr_13451[(15)] = inst_13322);

(statearr_13451[(16)] = inst_13324);

(statearr_13451[(17)] = inst_13323);

return statearr_13451;
})();
var statearr_13452_13536 = state_13441__$1;
(statearr_13452_13536[(2)] = null);

(statearr_13452_13536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (39))){
var state_13441__$1 = state_13441;
var statearr_13456_13537 = state_13441__$1;
(statearr_13456_13537[(2)] = null);

(statearr_13456_13537[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (4))){
var inst_13313 = (state_13441[(11)]);
var inst_13313__$1 = (state_13441[(2)]);
var inst_13314 = (inst_13313__$1 == null);
var state_13441__$1 = (function (){var statearr_13457 = state_13441;
(statearr_13457[(11)] = inst_13313__$1);

return statearr_13457;
})();
if(cljs.core.truth_(inst_13314)){
var statearr_13458_13538 = state_13441__$1;
(statearr_13458_13538[(1)] = (5));

} else {
var statearr_13459_13539 = state_13441__$1;
(statearr_13459_13539[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (15))){
var inst_13325 = (state_13441[(13)]);
var inst_13322 = (state_13441[(15)]);
var inst_13324 = (state_13441[(16)]);
var inst_13323 = (state_13441[(17)]);
var inst_13338 = (state_13441[(2)]);
var inst_13339 = (inst_13325 + (1));
var tmp13453 = inst_13322;
var tmp13454 = inst_13324;
var tmp13455 = inst_13323;
var inst_13322__$1 = tmp13453;
var inst_13323__$1 = tmp13455;
var inst_13324__$1 = tmp13454;
var inst_13325__$1 = inst_13339;
var state_13441__$1 = (function (){var statearr_13460 = state_13441;
(statearr_13460[(18)] = inst_13338);

(statearr_13460[(13)] = inst_13325__$1);

(statearr_13460[(15)] = inst_13322__$1);

(statearr_13460[(16)] = inst_13324__$1);

(statearr_13460[(17)] = inst_13323__$1);

return statearr_13460;
})();
var statearr_13461_13540 = state_13441__$1;
(statearr_13461_13540[(2)] = null);

(statearr_13461_13540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (21))){
var inst_13363 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13465_13541 = state_13441__$1;
(statearr_13465_13541[(2)] = inst_13363);

(statearr_13465_13541[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (31))){
var inst_13389 = (state_13441[(12)]);
var inst_13393 = done.call(null,null);
var inst_13394 = cljs.core.async.untap_STAR_.call(null,m,inst_13389);
var state_13441__$1 = (function (){var statearr_13466 = state_13441;
(statearr_13466[(19)] = inst_13393);

return statearr_13466;
})();
var statearr_13467_13542 = state_13441__$1;
(statearr_13467_13542[(2)] = inst_13394);

(statearr_13467_13542[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (32))){
var inst_13384 = (state_13441[(9)]);
var inst_13382 = (state_13441[(10)]);
var inst_13383 = (state_13441[(20)]);
var inst_13381 = (state_13441[(21)]);
var inst_13396 = (state_13441[(2)]);
var inst_13397 = (inst_13384 + (1));
var tmp13462 = inst_13382;
var tmp13463 = inst_13383;
var tmp13464 = inst_13381;
var inst_13381__$1 = tmp13464;
var inst_13382__$1 = tmp13462;
var inst_13383__$1 = tmp13463;
var inst_13384__$1 = inst_13397;
var state_13441__$1 = (function (){var statearr_13468 = state_13441;
(statearr_13468[(9)] = inst_13384__$1);

(statearr_13468[(10)] = inst_13382__$1);

(statearr_13468[(20)] = inst_13383__$1);

(statearr_13468[(22)] = inst_13396);

(statearr_13468[(21)] = inst_13381__$1);

return statearr_13468;
})();
var statearr_13469_13543 = state_13441__$1;
(statearr_13469_13543[(2)] = null);

(statearr_13469_13543[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (40))){
var inst_13409 = (state_13441[(23)]);
var inst_13413 = done.call(null,null);
var inst_13414 = cljs.core.async.untap_STAR_.call(null,m,inst_13409);
var state_13441__$1 = (function (){var statearr_13470 = state_13441;
(statearr_13470[(24)] = inst_13413);

return statearr_13470;
})();
var statearr_13471_13544 = state_13441__$1;
(statearr_13471_13544[(2)] = inst_13414);

(statearr_13471_13544[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (33))){
var inst_13400 = (state_13441[(25)]);
var inst_13402 = cljs.core.chunked_seq_QMARK_.call(null,inst_13400);
var state_13441__$1 = state_13441;
if(inst_13402){
var statearr_13472_13545 = state_13441__$1;
(statearr_13472_13545[(1)] = (36));

} else {
var statearr_13473_13546 = state_13441__$1;
(statearr_13473_13546[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (13))){
var inst_13332 = (state_13441[(26)]);
var inst_13335 = cljs.core.async.close_BANG_.call(null,inst_13332);
var state_13441__$1 = state_13441;
var statearr_13474_13547 = state_13441__$1;
(statearr_13474_13547[(2)] = inst_13335);

(statearr_13474_13547[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (22))){
var inst_13353 = (state_13441[(8)]);
var inst_13356 = cljs.core.async.close_BANG_.call(null,inst_13353);
var state_13441__$1 = state_13441;
var statearr_13475_13548 = state_13441__$1;
(statearr_13475_13548[(2)] = inst_13356);

(statearr_13475_13548[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (36))){
var inst_13400 = (state_13441[(25)]);
var inst_13404 = cljs.core.chunk_first.call(null,inst_13400);
var inst_13405 = cljs.core.chunk_rest.call(null,inst_13400);
var inst_13406 = cljs.core.count.call(null,inst_13404);
var inst_13381 = inst_13405;
var inst_13382 = inst_13404;
var inst_13383 = inst_13406;
var inst_13384 = (0);
var state_13441__$1 = (function (){var statearr_13476 = state_13441;
(statearr_13476[(9)] = inst_13384);

(statearr_13476[(10)] = inst_13382);

(statearr_13476[(20)] = inst_13383);

(statearr_13476[(21)] = inst_13381);

return statearr_13476;
})();
var statearr_13477_13549 = state_13441__$1;
(statearr_13477_13549[(2)] = null);

(statearr_13477_13549[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (41))){
var inst_13400 = (state_13441[(25)]);
var inst_13416 = (state_13441[(2)]);
var inst_13417 = cljs.core.next.call(null,inst_13400);
var inst_13381 = inst_13417;
var inst_13382 = null;
var inst_13383 = (0);
var inst_13384 = (0);
var state_13441__$1 = (function (){var statearr_13478 = state_13441;
(statearr_13478[(9)] = inst_13384);

(statearr_13478[(10)] = inst_13382);

(statearr_13478[(20)] = inst_13383);

(statearr_13478[(27)] = inst_13416);

(statearr_13478[(21)] = inst_13381);

return statearr_13478;
})();
var statearr_13479_13550 = state_13441__$1;
(statearr_13479_13550[(2)] = null);

(statearr_13479_13550[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (43))){
var state_13441__$1 = state_13441;
var statearr_13480_13551 = state_13441__$1;
(statearr_13480_13551[(2)] = null);

(statearr_13480_13551[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (29))){
var inst_13425 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13481_13552 = state_13441__$1;
(statearr_13481_13552[(2)] = inst_13425);

(statearr_13481_13552[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (44))){
var inst_13434 = (state_13441[(2)]);
var state_13441__$1 = (function (){var statearr_13482 = state_13441;
(statearr_13482[(28)] = inst_13434);

return statearr_13482;
})();
var statearr_13483_13553 = state_13441__$1;
(statearr_13483_13553[(2)] = null);

(statearr_13483_13553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (6))){
var inst_13373 = (state_13441[(29)]);
var inst_13372 = cljs.core.deref.call(null,cs);
var inst_13373__$1 = cljs.core.keys.call(null,inst_13372);
var inst_13374 = cljs.core.count.call(null,inst_13373__$1);
var inst_13375 = cljs.core.reset_BANG_.call(null,dctr,inst_13374);
var inst_13380 = cljs.core.seq.call(null,inst_13373__$1);
var inst_13381 = inst_13380;
var inst_13382 = null;
var inst_13383 = (0);
var inst_13384 = (0);
var state_13441__$1 = (function (){var statearr_13484 = state_13441;
(statearr_13484[(9)] = inst_13384);

(statearr_13484[(10)] = inst_13382);

(statearr_13484[(20)] = inst_13383);

(statearr_13484[(21)] = inst_13381);

(statearr_13484[(30)] = inst_13375);

(statearr_13484[(29)] = inst_13373__$1);

return statearr_13484;
})();
var statearr_13485_13554 = state_13441__$1;
(statearr_13485_13554[(2)] = null);

(statearr_13485_13554[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (28))){
var inst_13400 = (state_13441[(25)]);
var inst_13381 = (state_13441[(21)]);
var inst_13400__$1 = cljs.core.seq.call(null,inst_13381);
var state_13441__$1 = (function (){var statearr_13486 = state_13441;
(statearr_13486[(25)] = inst_13400__$1);

return statearr_13486;
})();
if(inst_13400__$1){
var statearr_13487_13555 = state_13441__$1;
(statearr_13487_13555[(1)] = (33));

} else {
var statearr_13488_13556 = state_13441__$1;
(statearr_13488_13556[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (25))){
var inst_13384 = (state_13441[(9)]);
var inst_13383 = (state_13441[(20)]);
var inst_13386 = (inst_13384 < inst_13383);
var inst_13387 = inst_13386;
var state_13441__$1 = state_13441;
if(cljs.core.truth_(inst_13387)){
var statearr_13489_13557 = state_13441__$1;
(statearr_13489_13557[(1)] = (27));

} else {
var statearr_13490_13558 = state_13441__$1;
(statearr_13490_13558[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (34))){
var state_13441__$1 = state_13441;
var statearr_13491_13559 = state_13441__$1;
(statearr_13491_13559[(2)] = null);

(statearr_13491_13559[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (17))){
var state_13441__$1 = state_13441;
var statearr_13492_13560 = state_13441__$1;
(statearr_13492_13560[(2)] = null);

(statearr_13492_13560[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (3))){
var inst_13439 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13441__$1,inst_13439);
} else {
if((state_val_13442 === (12))){
var inst_13368 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13493_13561 = state_13441__$1;
(statearr_13493_13561[(2)] = inst_13368);

(statearr_13493_13561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (2))){
var state_13441__$1 = state_13441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13441__$1,(4),ch);
} else {
if((state_val_13442 === (23))){
var state_13441__$1 = state_13441;
var statearr_13494_13562 = state_13441__$1;
(statearr_13494_13562[(2)] = null);

(statearr_13494_13562[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (35))){
var inst_13423 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13495_13563 = state_13441__$1;
(statearr_13495_13563[(2)] = inst_13423);

(statearr_13495_13563[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (19))){
var inst_13342 = (state_13441[(7)]);
var inst_13346 = cljs.core.chunk_first.call(null,inst_13342);
var inst_13347 = cljs.core.chunk_rest.call(null,inst_13342);
var inst_13348 = cljs.core.count.call(null,inst_13346);
var inst_13322 = inst_13347;
var inst_13323 = inst_13346;
var inst_13324 = inst_13348;
var inst_13325 = (0);
var state_13441__$1 = (function (){var statearr_13496 = state_13441;
(statearr_13496[(13)] = inst_13325);

(statearr_13496[(15)] = inst_13322);

(statearr_13496[(16)] = inst_13324);

(statearr_13496[(17)] = inst_13323);

return statearr_13496;
})();
var statearr_13497_13564 = state_13441__$1;
(statearr_13497_13564[(2)] = null);

(statearr_13497_13564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (11))){
var inst_13342 = (state_13441[(7)]);
var inst_13322 = (state_13441[(15)]);
var inst_13342__$1 = cljs.core.seq.call(null,inst_13322);
var state_13441__$1 = (function (){var statearr_13498 = state_13441;
(statearr_13498[(7)] = inst_13342__$1);

return statearr_13498;
})();
if(inst_13342__$1){
var statearr_13499_13565 = state_13441__$1;
(statearr_13499_13565[(1)] = (16));

} else {
var statearr_13500_13566 = state_13441__$1;
(statearr_13500_13566[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (9))){
var inst_13370 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13501_13567 = state_13441__$1;
(statearr_13501_13567[(2)] = inst_13370);

(statearr_13501_13567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (5))){
var inst_13320 = cljs.core.deref.call(null,cs);
var inst_13321 = cljs.core.seq.call(null,inst_13320);
var inst_13322 = inst_13321;
var inst_13323 = null;
var inst_13324 = (0);
var inst_13325 = (0);
var state_13441__$1 = (function (){var statearr_13502 = state_13441;
(statearr_13502[(13)] = inst_13325);

(statearr_13502[(15)] = inst_13322);

(statearr_13502[(16)] = inst_13324);

(statearr_13502[(17)] = inst_13323);

return statearr_13502;
})();
var statearr_13503_13568 = state_13441__$1;
(statearr_13503_13568[(2)] = null);

(statearr_13503_13568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (14))){
var state_13441__$1 = state_13441;
var statearr_13504_13569 = state_13441__$1;
(statearr_13504_13569[(2)] = null);

(statearr_13504_13569[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (45))){
var inst_13431 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13505_13570 = state_13441__$1;
(statearr_13505_13570[(2)] = inst_13431);

(statearr_13505_13570[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (26))){
var inst_13373 = (state_13441[(29)]);
var inst_13427 = (state_13441[(2)]);
var inst_13428 = cljs.core.seq.call(null,inst_13373);
var state_13441__$1 = (function (){var statearr_13506 = state_13441;
(statearr_13506[(31)] = inst_13427);

return statearr_13506;
})();
if(inst_13428){
var statearr_13507_13571 = state_13441__$1;
(statearr_13507_13571[(1)] = (42));

} else {
var statearr_13508_13572 = state_13441__$1;
(statearr_13508_13572[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (16))){
var inst_13342 = (state_13441[(7)]);
var inst_13344 = cljs.core.chunked_seq_QMARK_.call(null,inst_13342);
var state_13441__$1 = state_13441;
if(inst_13344){
var statearr_13509_13573 = state_13441__$1;
(statearr_13509_13573[(1)] = (19));

} else {
var statearr_13510_13574 = state_13441__$1;
(statearr_13510_13574[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (38))){
var inst_13420 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13511_13575 = state_13441__$1;
(statearr_13511_13575[(2)] = inst_13420);

(statearr_13511_13575[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (30))){
var state_13441__$1 = state_13441;
var statearr_13512_13576 = state_13441__$1;
(statearr_13512_13576[(2)] = null);

(statearr_13512_13576[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (10))){
var inst_13325 = (state_13441[(13)]);
var inst_13323 = (state_13441[(17)]);
var inst_13331 = cljs.core._nth.call(null,inst_13323,inst_13325);
var inst_13332 = cljs.core.nth.call(null,inst_13331,(0),null);
var inst_13333 = cljs.core.nth.call(null,inst_13331,(1),null);
var state_13441__$1 = (function (){var statearr_13513 = state_13441;
(statearr_13513[(26)] = inst_13332);

return statearr_13513;
})();
if(cljs.core.truth_(inst_13333)){
var statearr_13514_13577 = state_13441__$1;
(statearr_13514_13577[(1)] = (13));

} else {
var statearr_13515_13578 = state_13441__$1;
(statearr_13515_13578[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (18))){
var inst_13366 = (state_13441[(2)]);
var state_13441__$1 = state_13441;
var statearr_13516_13579 = state_13441__$1;
(statearr_13516_13579[(2)] = inst_13366);

(statearr_13516_13579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (42))){
var state_13441__$1 = state_13441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13441__$1,(45),dchan);
} else {
if((state_val_13442 === (37))){
var inst_13409 = (state_13441[(23)]);
var inst_13400 = (state_13441[(25)]);
var inst_13313 = (state_13441[(11)]);
var inst_13409__$1 = cljs.core.first.call(null,inst_13400);
var inst_13410 = cljs.core.async.put_BANG_.call(null,inst_13409__$1,inst_13313,done);
var state_13441__$1 = (function (){var statearr_13517 = state_13441;
(statearr_13517[(23)] = inst_13409__$1);

return statearr_13517;
})();
if(cljs.core.truth_(inst_13410)){
var statearr_13518_13580 = state_13441__$1;
(statearr_13518_13580[(1)] = (39));

} else {
var statearr_13519_13581 = state_13441__$1;
(statearr_13519_13581[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13442 === (8))){
var inst_13325 = (state_13441[(13)]);
var inst_13324 = (state_13441[(16)]);
var inst_13327 = (inst_13325 < inst_13324);
var inst_13328 = inst_13327;
var state_13441__$1 = state_13441;
if(cljs.core.truth_(inst_13328)){
var statearr_13520_13582 = state_13441__$1;
(statearr_13520_13582[(1)] = (10));

} else {
var statearr_13521_13583 = state_13441__$1;
(statearr_13521_13583[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13529,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___13529,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_13525 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13525[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_13525[(1)] = (1));

return statearr_13525;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_13441){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13526){if((e13526 instanceof Object)){
var ex__7651__auto__ = e13526;
var statearr_13527_13584 = state_13441;
(statearr_13527_13584[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13585 = state_13441;
state_13441 = G__13585;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_13441){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_13441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13529,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_13528 = f__7710__auto__.call(null);
(statearr_13528[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13529);

return statearr_13528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13529,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__13587 = arguments.length;
switch (G__13587) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj13590 = {};
return obj13590;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13595){
var map__13596 = p__13595;
var map__13596__$1 = ((cljs.core.seq_QMARK_.call(null,map__13596))?cljs.core.apply.call(null,cljs.core.hash_map,map__13596):map__13596);
var opts = map__13596__$1;
var statearr_13597_13600 = state;
(statearr_13597_13600[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__13596,map__13596__$1,opts){
return (function (val){
var statearr_13598_13601 = state;
(statearr_13598_13601[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13596,map__13596__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_13599_13602 = state;
(statearr_13599_13602[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13591){
var G__13592 = cljs.core.first.call(null,seq13591);
var seq13591__$1 = cljs.core.next.call(null,seq13591);
var G__13593 = cljs.core.first.call(null,seq13591__$1);
var seq13591__$2 = cljs.core.next.call(null,seq13591__$1);
var G__13594 = cljs.core.first.call(null,seq13591__$2);
var seq13591__$3 = cljs.core.next.call(null,seq13591__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13592,G__13593,G__13594,seq13591__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t13722 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13722 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13723){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13723 = meta13723;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13722.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t13722.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13722.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13724){
var self__ = this;
var _13724__$1 = this;
return self__.meta13723;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13724,meta13723__$1){
var self__ = this;
var _13724__$1 = this;
return (new cljs.core.async.t13722(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13723__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13722.cljs$lang$type = true;

cljs.core.async.t13722.cljs$lang$ctorStr = "cljs.core.async/t13722";

cljs.core.async.t13722.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13722");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t13722 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t13722(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13723){
return (new cljs.core.async.t13722(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13723));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t13722(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___13841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13794){
var state_val_13795 = (state_13794[(1)]);
if((state_val_13795 === (7))){
var inst_13738 = (state_13794[(7)]);
var inst_13743 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13738);
var state_13794__$1 = state_13794;
var statearr_13796_13842 = state_13794__$1;
(statearr_13796_13842[(2)] = inst_13743);

(statearr_13796_13842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (20))){
var inst_13753 = (state_13794[(8)]);
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13794__$1,(23),out,inst_13753);
} else {
if((state_val_13795 === (1))){
var inst_13728 = (state_13794[(9)]);
var inst_13728__$1 = calc_state.call(null);
var inst_13729 = cljs.core.seq_QMARK_.call(null,inst_13728__$1);
var state_13794__$1 = (function (){var statearr_13797 = state_13794;
(statearr_13797[(9)] = inst_13728__$1);

return statearr_13797;
})();
if(inst_13729){
var statearr_13798_13843 = state_13794__$1;
(statearr_13798_13843[(1)] = (2));

} else {
var statearr_13799_13844 = state_13794__$1;
(statearr_13799_13844[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (24))){
var inst_13746 = (state_13794[(10)]);
var inst_13738 = inst_13746;
var state_13794__$1 = (function (){var statearr_13800 = state_13794;
(statearr_13800[(7)] = inst_13738);

return statearr_13800;
})();
var statearr_13801_13845 = state_13794__$1;
(statearr_13801_13845[(2)] = null);

(statearr_13801_13845[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (4))){
var inst_13728 = (state_13794[(9)]);
var inst_13734 = (state_13794[(2)]);
var inst_13735 = cljs.core.get.call(null,inst_13734,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13736 = cljs.core.get.call(null,inst_13734,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13737 = cljs.core.get.call(null,inst_13734,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13738 = inst_13728;
var state_13794__$1 = (function (){var statearr_13802 = state_13794;
(statearr_13802[(11)] = inst_13737);

(statearr_13802[(12)] = inst_13736);

(statearr_13802[(7)] = inst_13738);

(statearr_13802[(13)] = inst_13735);

return statearr_13802;
})();
var statearr_13803_13846 = state_13794__$1;
(statearr_13803_13846[(2)] = null);

(statearr_13803_13846[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (15))){
var state_13794__$1 = state_13794;
var statearr_13804_13847 = state_13794__$1;
(statearr_13804_13847[(2)] = null);

(statearr_13804_13847[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (21))){
var inst_13746 = (state_13794[(10)]);
var inst_13738 = inst_13746;
var state_13794__$1 = (function (){var statearr_13805 = state_13794;
(statearr_13805[(7)] = inst_13738);

return statearr_13805;
})();
var statearr_13806_13848 = state_13794__$1;
(statearr_13806_13848[(2)] = null);

(statearr_13806_13848[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (13))){
var inst_13790 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13807_13849 = state_13794__$1;
(statearr_13807_13849[(2)] = inst_13790);

(statearr_13807_13849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (22))){
var inst_13788 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13808_13850 = state_13794__$1;
(statearr_13808_13850[(2)] = inst_13788);

(statearr_13808_13850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (6))){
var inst_13792 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13794__$1,inst_13792);
} else {
if((state_val_13795 === (25))){
var state_13794__$1 = state_13794;
var statearr_13809_13851 = state_13794__$1;
(statearr_13809_13851[(2)] = null);

(statearr_13809_13851[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (17))){
var inst_13768 = (state_13794[(14)]);
var state_13794__$1 = state_13794;
var statearr_13810_13852 = state_13794__$1;
(statearr_13810_13852[(2)] = inst_13768);

(statearr_13810_13852[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (3))){
var inst_13728 = (state_13794[(9)]);
var state_13794__$1 = state_13794;
var statearr_13811_13853 = state_13794__$1;
(statearr_13811_13853[(2)] = inst_13728);

(statearr_13811_13853[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (12))){
var inst_13749 = (state_13794[(15)]);
var inst_13754 = (state_13794[(16)]);
var inst_13768 = (state_13794[(14)]);
var inst_13768__$1 = inst_13749.call(null,inst_13754);
var state_13794__$1 = (function (){var statearr_13812 = state_13794;
(statearr_13812[(14)] = inst_13768__$1);

return statearr_13812;
})();
if(cljs.core.truth_(inst_13768__$1)){
var statearr_13813_13854 = state_13794__$1;
(statearr_13813_13854[(1)] = (17));

} else {
var statearr_13814_13855 = state_13794__$1;
(statearr_13814_13855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (2))){
var inst_13728 = (state_13794[(9)]);
var inst_13731 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13728);
var state_13794__$1 = state_13794;
var statearr_13815_13856 = state_13794__$1;
(statearr_13815_13856[(2)] = inst_13731);

(statearr_13815_13856[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (23))){
var inst_13779 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
if(cljs.core.truth_(inst_13779)){
var statearr_13816_13857 = state_13794__$1;
(statearr_13816_13857[(1)] = (24));

} else {
var statearr_13817_13858 = state_13794__$1;
(statearr_13817_13858[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (19))){
var inst_13776 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
if(cljs.core.truth_(inst_13776)){
var statearr_13818_13859 = state_13794__$1;
(statearr_13818_13859[(1)] = (20));

} else {
var statearr_13819_13860 = state_13794__$1;
(statearr_13819_13860[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (11))){
var inst_13753 = (state_13794[(8)]);
var inst_13759 = (inst_13753 == null);
var state_13794__$1 = state_13794;
if(cljs.core.truth_(inst_13759)){
var statearr_13820_13861 = state_13794__$1;
(statearr_13820_13861[(1)] = (14));

} else {
var statearr_13821_13862 = state_13794__$1;
(statearr_13821_13862[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (9))){
var inst_13746 = (state_13794[(10)]);
var inst_13746__$1 = (state_13794[(2)]);
var inst_13747 = cljs.core.get.call(null,inst_13746__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13748 = cljs.core.get.call(null,inst_13746__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13749 = cljs.core.get.call(null,inst_13746__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_13794__$1 = (function (){var statearr_13822 = state_13794;
(statearr_13822[(10)] = inst_13746__$1);

(statearr_13822[(17)] = inst_13748);

(statearr_13822[(15)] = inst_13749);

return statearr_13822;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13794__$1,(10),inst_13747);
} else {
if((state_val_13795 === (5))){
var inst_13738 = (state_13794[(7)]);
var inst_13741 = cljs.core.seq_QMARK_.call(null,inst_13738);
var state_13794__$1 = state_13794;
if(inst_13741){
var statearr_13823_13863 = state_13794__$1;
(statearr_13823_13863[(1)] = (7));

} else {
var statearr_13824_13864 = state_13794__$1;
(statearr_13824_13864[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (14))){
var inst_13754 = (state_13794[(16)]);
var inst_13761 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13754);
var state_13794__$1 = state_13794;
var statearr_13825_13865 = state_13794__$1;
(statearr_13825_13865[(2)] = inst_13761);

(statearr_13825_13865[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (26))){
var inst_13784 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13826_13866 = state_13794__$1;
(statearr_13826_13866[(2)] = inst_13784);

(statearr_13826_13866[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (16))){
var inst_13764 = (state_13794[(2)]);
var inst_13765 = calc_state.call(null);
var inst_13738 = inst_13765;
var state_13794__$1 = (function (){var statearr_13827 = state_13794;
(statearr_13827[(7)] = inst_13738);

(statearr_13827[(18)] = inst_13764);

return statearr_13827;
})();
var statearr_13828_13867 = state_13794__$1;
(statearr_13828_13867[(2)] = null);

(statearr_13828_13867[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (10))){
var inst_13753 = (state_13794[(8)]);
var inst_13754 = (state_13794[(16)]);
var inst_13752 = (state_13794[(2)]);
var inst_13753__$1 = cljs.core.nth.call(null,inst_13752,(0),null);
var inst_13754__$1 = cljs.core.nth.call(null,inst_13752,(1),null);
var inst_13755 = (inst_13753__$1 == null);
var inst_13756 = cljs.core._EQ_.call(null,inst_13754__$1,change);
var inst_13757 = (inst_13755) || (inst_13756);
var state_13794__$1 = (function (){var statearr_13829 = state_13794;
(statearr_13829[(8)] = inst_13753__$1);

(statearr_13829[(16)] = inst_13754__$1);

return statearr_13829;
})();
if(cljs.core.truth_(inst_13757)){
var statearr_13830_13868 = state_13794__$1;
(statearr_13830_13868[(1)] = (11));

} else {
var statearr_13831_13869 = state_13794__$1;
(statearr_13831_13869[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (18))){
var inst_13748 = (state_13794[(17)]);
var inst_13749 = (state_13794[(15)]);
var inst_13754 = (state_13794[(16)]);
var inst_13771 = cljs.core.empty_QMARK_.call(null,inst_13749);
var inst_13772 = inst_13748.call(null,inst_13754);
var inst_13773 = cljs.core.not.call(null,inst_13772);
var inst_13774 = (inst_13771) && (inst_13773);
var state_13794__$1 = state_13794;
var statearr_13832_13870 = state_13794__$1;
(statearr_13832_13870[(2)] = inst_13774);

(statearr_13832_13870[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (8))){
var inst_13738 = (state_13794[(7)]);
var state_13794__$1 = state_13794;
var statearr_13833_13871 = state_13794__$1;
(statearr_13833_13871[(2)] = inst_13738);

(statearr_13833_13871[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_13837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13837[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_13837[(1)] = (1));

return statearr_13837;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_13794){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13838){if((e13838 instanceof Object)){
var ex__7651__auto__ = e13838;
var statearr_13839_13872 = state_13794;
(statearr_13839_13872[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13873 = state_13794;
state_13794 = G__13873;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_13794){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_13794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_13840 = f__7710__auto__.call(null);
(statearr_13840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13841);

return statearr_13840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13841,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj13875 = {};
return obj13875;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__13877 = arguments.length;
switch (G__13877) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__13881 = arguments.length;
switch (G__13881) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4276__auto__,mults){
return (function (p1__13879_SHARP_){
if(cljs.core.truth_(p1__13879_SHARP_.call(null,topic))){
return p1__13879_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13879_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t13882 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13882 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta13883){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta13883 = meta13883;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13882.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t13882.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13882.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13884){
var self__ = this;
var _13884__$1 = this;
return self__.meta13883;
});})(mults,ensure_mult))
;

cljs.core.async.t13882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13884,meta13883__$1){
var self__ = this;
var _13884__$1 = this;
return (new cljs.core.async.t13882(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta13883__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t13882.cljs$lang$type = true;

cljs.core.async.t13882.cljs$lang$ctorStr = "cljs.core.async/t13882";

cljs.core.async.t13882.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13882");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t13882 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t13882(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13883){
return (new cljs.core.async.t13882(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13883));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t13882(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___14005 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14005,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14005,mults,ensure_mult,p){
return (function (state_13956){
var state_val_13957 = (state_13956[(1)]);
if((state_val_13957 === (7))){
var inst_13952 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13958_14006 = state_13956__$1;
(statearr_13958_14006[(2)] = inst_13952);

(statearr_13958_14006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (20))){
var state_13956__$1 = state_13956;
var statearr_13959_14007 = state_13956__$1;
(statearr_13959_14007[(2)] = null);

(statearr_13959_14007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (1))){
var state_13956__$1 = state_13956;
var statearr_13960_14008 = state_13956__$1;
(statearr_13960_14008[(2)] = null);

(statearr_13960_14008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (24))){
var inst_13935 = (state_13956[(7)]);
var inst_13944 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13935);
var state_13956__$1 = state_13956;
var statearr_13961_14009 = state_13956__$1;
(statearr_13961_14009[(2)] = inst_13944);

(statearr_13961_14009[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (4))){
var inst_13887 = (state_13956[(8)]);
var inst_13887__$1 = (state_13956[(2)]);
var inst_13888 = (inst_13887__$1 == null);
var state_13956__$1 = (function (){var statearr_13962 = state_13956;
(statearr_13962[(8)] = inst_13887__$1);

return statearr_13962;
})();
if(cljs.core.truth_(inst_13888)){
var statearr_13963_14010 = state_13956__$1;
(statearr_13963_14010[(1)] = (5));

} else {
var statearr_13964_14011 = state_13956__$1;
(statearr_13964_14011[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (15))){
var inst_13929 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13965_14012 = state_13956__$1;
(statearr_13965_14012[(2)] = inst_13929);

(statearr_13965_14012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (21))){
var inst_13949 = (state_13956[(2)]);
var state_13956__$1 = (function (){var statearr_13966 = state_13956;
(statearr_13966[(9)] = inst_13949);

return statearr_13966;
})();
var statearr_13967_14013 = state_13956__$1;
(statearr_13967_14013[(2)] = null);

(statearr_13967_14013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (13))){
var inst_13911 = (state_13956[(10)]);
var inst_13913 = cljs.core.chunked_seq_QMARK_.call(null,inst_13911);
var state_13956__$1 = state_13956;
if(inst_13913){
var statearr_13968_14014 = state_13956__$1;
(statearr_13968_14014[(1)] = (16));

} else {
var statearr_13969_14015 = state_13956__$1;
(statearr_13969_14015[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (22))){
var inst_13941 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
if(cljs.core.truth_(inst_13941)){
var statearr_13970_14016 = state_13956__$1;
(statearr_13970_14016[(1)] = (23));

} else {
var statearr_13971_14017 = state_13956__$1;
(statearr_13971_14017[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (6))){
var inst_13937 = (state_13956[(11)]);
var inst_13935 = (state_13956[(7)]);
var inst_13887 = (state_13956[(8)]);
var inst_13935__$1 = topic_fn.call(null,inst_13887);
var inst_13936 = cljs.core.deref.call(null,mults);
var inst_13937__$1 = cljs.core.get.call(null,inst_13936,inst_13935__$1);
var state_13956__$1 = (function (){var statearr_13972 = state_13956;
(statearr_13972[(11)] = inst_13937__$1);

(statearr_13972[(7)] = inst_13935__$1);

return statearr_13972;
})();
if(cljs.core.truth_(inst_13937__$1)){
var statearr_13973_14018 = state_13956__$1;
(statearr_13973_14018[(1)] = (19));

} else {
var statearr_13974_14019 = state_13956__$1;
(statearr_13974_14019[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (25))){
var inst_13946 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13975_14020 = state_13956__$1;
(statearr_13975_14020[(2)] = inst_13946);

(statearr_13975_14020[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (17))){
var inst_13911 = (state_13956[(10)]);
var inst_13920 = cljs.core.first.call(null,inst_13911);
var inst_13921 = cljs.core.async.muxch_STAR_.call(null,inst_13920);
var inst_13922 = cljs.core.async.close_BANG_.call(null,inst_13921);
var inst_13923 = cljs.core.next.call(null,inst_13911);
var inst_13897 = inst_13923;
var inst_13898 = null;
var inst_13899 = (0);
var inst_13900 = (0);
var state_13956__$1 = (function (){var statearr_13976 = state_13956;
(statearr_13976[(12)] = inst_13899);

(statearr_13976[(13)] = inst_13922);

(statearr_13976[(14)] = inst_13897);

(statearr_13976[(15)] = inst_13900);

(statearr_13976[(16)] = inst_13898);

return statearr_13976;
})();
var statearr_13977_14021 = state_13956__$1;
(statearr_13977_14021[(2)] = null);

(statearr_13977_14021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (3))){
var inst_13954 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13956__$1,inst_13954);
} else {
if((state_val_13957 === (12))){
var inst_13931 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13978_14022 = state_13956__$1;
(statearr_13978_14022[(2)] = inst_13931);

(statearr_13978_14022[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (2))){
var state_13956__$1 = state_13956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13956__$1,(4),ch);
} else {
if((state_val_13957 === (23))){
var state_13956__$1 = state_13956;
var statearr_13979_14023 = state_13956__$1;
(statearr_13979_14023[(2)] = null);

(statearr_13979_14023[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (19))){
var inst_13937 = (state_13956[(11)]);
var inst_13887 = (state_13956[(8)]);
var inst_13939 = cljs.core.async.muxch_STAR_.call(null,inst_13937);
var state_13956__$1 = state_13956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13956__$1,(22),inst_13939,inst_13887);
} else {
if((state_val_13957 === (11))){
var inst_13911 = (state_13956[(10)]);
var inst_13897 = (state_13956[(14)]);
var inst_13911__$1 = cljs.core.seq.call(null,inst_13897);
var state_13956__$1 = (function (){var statearr_13980 = state_13956;
(statearr_13980[(10)] = inst_13911__$1);

return statearr_13980;
})();
if(inst_13911__$1){
var statearr_13981_14024 = state_13956__$1;
(statearr_13981_14024[(1)] = (13));

} else {
var statearr_13982_14025 = state_13956__$1;
(statearr_13982_14025[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (9))){
var inst_13933 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13983_14026 = state_13956__$1;
(statearr_13983_14026[(2)] = inst_13933);

(statearr_13983_14026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (5))){
var inst_13894 = cljs.core.deref.call(null,mults);
var inst_13895 = cljs.core.vals.call(null,inst_13894);
var inst_13896 = cljs.core.seq.call(null,inst_13895);
var inst_13897 = inst_13896;
var inst_13898 = null;
var inst_13899 = (0);
var inst_13900 = (0);
var state_13956__$1 = (function (){var statearr_13984 = state_13956;
(statearr_13984[(12)] = inst_13899);

(statearr_13984[(14)] = inst_13897);

(statearr_13984[(15)] = inst_13900);

(statearr_13984[(16)] = inst_13898);

return statearr_13984;
})();
var statearr_13985_14027 = state_13956__$1;
(statearr_13985_14027[(2)] = null);

(statearr_13985_14027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (14))){
var state_13956__$1 = state_13956;
var statearr_13989_14028 = state_13956__$1;
(statearr_13989_14028[(2)] = null);

(statearr_13989_14028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (16))){
var inst_13911 = (state_13956[(10)]);
var inst_13915 = cljs.core.chunk_first.call(null,inst_13911);
var inst_13916 = cljs.core.chunk_rest.call(null,inst_13911);
var inst_13917 = cljs.core.count.call(null,inst_13915);
var inst_13897 = inst_13916;
var inst_13898 = inst_13915;
var inst_13899 = inst_13917;
var inst_13900 = (0);
var state_13956__$1 = (function (){var statearr_13990 = state_13956;
(statearr_13990[(12)] = inst_13899);

(statearr_13990[(14)] = inst_13897);

(statearr_13990[(15)] = inst_13900);

(statearr_13990[(16)] = inst_13898);

return statearr_13990;
})();
var statearr_13991_14029 = state_13956__$1;
(statearr_13991_14029[(2)] = null);

(statearr_13991_14029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (10))){
var inst_13899 = (state_13956[(12)]);
var inst_13897 = (state_13956[(14)]);
var inst_13900 = (state_13956[(15)]);
var inst_13898 = (state_13956[(16)]);
var inst_13905 = cljs.core._nth.call(null,inst_13898,inst_13900);
var inst_13906 = cljs.core.async.muxch_STAR_.call(null,inst_13905);
var inst_13907 = cljs.core.async.close_BANG_.call(null,inst_13906);
var inst_13908 = (inst_13900 + (1));
var tmp13986 = inst_13899;
var tmp13987 = inst_13897;
var tmp13988 = inst_13898;
var inst_13897__$1 = tmp13987;
var inst_13898__$1 = tmp13988;
var inst_13899__$1 = tmp13986;
var inst_13900__$1 = inst_13908;
var state_13956__$1 = (function (){var statearr_13992 = state_13956;
(statearr_13992[(12)] = inst_13899__$1);

(statearr_13992[(14)] = inst_13897__$1);

(statearr_13992[(15)] = inst_13900__$1);

(statearr_13992[(17)] = inst_13907);

(statearr_13992[(16)] = inst_13898__$1);

return statearr_13992;
})();
var statearr_13993_14030 = state_13956__$1;
(statearr_13993_14030[(2)] = null);

(statearr_13993_14030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (18))){
var inst_13926 = (state_13956[(2)]);
var state_13956__$1 = state_13956;
var statearr_13994_14031 = state_13956__$1;
(statearr_13994_14031[(2)] = inst_13926);

(statearr_13994_14031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13957 === (8))){
var inst_13899 = (state_13956[(12)]);
var inst_13900 = (state_13956[(15)]);
var inst_13902 = (inst_13900 < inst_13899);
var inst_13903 = inst_13902;
var state_13956__$1 = state_13956;
if(cljs.core.truth_(inst_13903)){
var statearr_13995_14032 = state_13956__$1;
(statearr_13995_14032[(1)] = (10));

} else {
var statearr_13996_14033 = state_13956__$1;
(statearr_13996_14033[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14005,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___14005,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14000[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14000[(1)] = (1));

return statearr_14000;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13956){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14001){if((e14001 instanceof Object)){
var ex__7651__auto__ = e14001;
var statearr_14002_14034 = state_13956;
(statearr_14002_14034[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14001;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14035 = state_13956;
state_13956 = G__14035;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14005,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_14003 = f__7710__auto__.call(null);
(statearr_14003[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14005);

return statearr_14003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14005,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__14037 = arguments.length;
switch (G__14037) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__14040 = arguments.length;
switch (G__14040) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__14043 = arguments.length;
switch (G__14043) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7709__auto___14113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14082){
var state_val_14083 = (state_14082[(1)]);
if((state_val_14083 === (7))){
var state_14082__$1 = state_14082;
var statearr_14084_14114 = state_14082__$1;
(statearr_14084_14114[(2)] = null);

(statearr_14084_14114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (1))){
var state_14082__$1 = state_14082;
var statearr_14085_14115 = state_14082__$1;
(statearr_14085_14115[(2)] = null);

(statearr_14085_14115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (4))){
var inst_14046 = (state_14082[(7)]);
var inst_14048 = (inst_14046 < cnt);
var state_14082__$1 = state_14082;
if(cljs.core.truth_(inst_14048)){
var statearr_14086_14116 = state_14082__$1;
(statearr_14086_14116[(1)] = (6));

} else {
var statearr_14087_14117 = state_14082__$1;
(statearr_14087_14117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (15))){
var inst_14078 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
var statearr_14088_14118 = state_14082__$1;
(statearr_14088_14118[(2)] = inst_14078);

(statearr_14088_14118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (13))){
var inst_14071 = cljs.core.async.close_BANG_.call(null,out);
var state_14082__$1 = state_14082;
var statearr_14089_14119 = state_14082__$1;
(statearr_14089_14119[(2)] = inst_14071);

(statearr_14089_14119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (6))){
var state_14082__$1 = state_14082;
var statearr_14090_14120 = state_14082__$1;
(statearr_14090_14120[(2)] = null);

(statearr_14090_14120[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (3))){
var inst_14080 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14082__$1,inst_14080);
} else {
if((state_val_14083 === (12))){
var inst_14068 = (state_14082[(8)]);
var inst_14068__$1 = (state_14082[(2)]);
var inst_14069 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14068__$1);
var state_14082__$1 = (function (){var statearr_14091 = state_14082;
(statearr_14091[(8)] = inst_14068__$1);

return statearr_14091;
})();
if(cljs.core.truth_(inst_14069)){
var statearr_14092_14121 = state_14082__$1;
(statearr_14092_14121[(1)] = (13));

} else {
var statearr_14093_14122 = state_14082__$1;
(statearr_14093_14122[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (2))){
var inst_14045 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14046 = (0);
var state_14082__$1 = (function (){var statearr_14094 = state_14082;
(statearr_14094[(9)] = inst_14045);

(statearr_14094[(7)] = inst_14046);

return statearr_14094;
})();
var statearr_14095_14123 = state_14082__$1;
(statearr_14095_14123[(2)] = null);

(statearr_14095_14123[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (11))){
var inst_14046 = (state_14082[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14082,(10),Object,null,(9));
var inst_14055 = chs__$1.call(null,inst_14046);
var inst_14056 = done.call(null,inst_14046);
var inst_14057 = cljs.core.async.take_BANG_.call(null,inst_14055,inst_14056);
var state_14082__$1 = state_14082;
var statearr_14096_14124 = state_14082__$1;
(statearr_14096_14124[(2)] = inst_14057);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14082__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (9))){
var inst_14046 = (state_14082[(7)]);
var inst_14059 = (state_14082[(2)]);
var inst_14060 = (inst_14046 + (1));
var inst_14046__$1 = inst_14060;
var state_14082__$1 = (function (){var statearr_14097 = state_14082;
(statearr_14097[(7)] = inst_14046__$1);

(statearr_14097[(10)] = inst_14059);

return statearr_14097;
})();
var statearr_14098_14125 = state_14082__$1;
(statearr_14098_14125[(2)] = null);

(statearr_14098_14125[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (5))){
var inst_14066 = (state_14082[(2)]);
var state_14082__$1 = (function (){var statearr_14099 = state_14082;
(statearr_14099[(11)] = inst_14066);

return statearr_14099;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14082__$1,(12),dchan);
} else {
if((state_val_14083 === (14))){
var inst_14068 = (state_14082[(8)]);
var inst_14073 = cljs.core.apply.call(null,f,inst_14068);
var state_14082__$1 = state_14082;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14082__$1,(16),out,inst_14073);
} else {
if((state_val_14083 === (16))){
var inst_14075 = (state_14082[(2)]);
var state_14082__$1 = (function (){var statearr_14100 = state_14082;
(statearr_14100[(12)] = inst_14075);

return statearr_14100;
})();
var statearr_14101_14126 = state_14082__$1;
(statearr_14101_14126[(2)] = null);

(statearr_14101_14126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (10))){
var inst_14050 = (state_14082[(2)]);
var inst_14051 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14082__$1 = (function (){var statearr_14102 = state_14082;
(statearr_14102[(13)] = inst_14050);

return statearr_14102;
})();
var statearr_14103_14127 = state_14082__$1;
(statearr_14103_14127[(2)] = inst_14051);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14082__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14083 === (8))){
var inst_14064 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
var statearr_14104_14128 = state_14082__$1;
(statearr_14104_14128[(2)] = inst_14064);

(statearr_14104_14128[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14108[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14108[(1)] = (1));

return statearr_14108;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14082){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14109){if((e14109 instanceof Object)){
var ex__7651__auto__ = e14109;
var statearr_14110_14129 = state_14082;
(statearr_14110_14129[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14109;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14130 = state_14082;
state_14082 = G__14130;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_14111 = f__7710__auto__.call(null);
(statearr_14111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14113);

return statearr_14111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14113,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__14133 = arguments.length;
switch (G__14133) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14188 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14188,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14188,out){
return (function (state_14163){
var state_val_14164 = (state_14163[(1)]);
if((state_val_14164 === (7))){
var inst_14142 = (state_14163[(7)]);
var inst_14143 = (state_14163[(8)]);
var inst_14142__$1 = (state_14163[(2)]);
var inst_14143__$1 = cljs.core.nth.call(null,inst_14142__$1,(0),null);
var inst_14144 = cljs.core.nth.call(null,inst_14142__$1,(1),null);
var inst_14145 = (inst_14143__$1 == null);
var state_14163__$1 = (function (){var statearr_14165 = state_14163;
(statearr_14165[(7)] = inst_14142__$1);

(statearr_14165[(8)] = inst_14143__$1);

(statearr_14165[(9)] = inst_14144);

return statearr_14165;
})();
if(cljs.core.truth_(inst_14145)){
var statearr_14166_14189 = state_14163__$1;
(statearr_14166_14189[(1)] = (8));

} else {
var statearr_14167_14190 = state_14163__$1;
(statearr_14167_14190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (1))){
var inst_14134 = cljs.core.vec.call(null,chs);
var inst_14135 = inst_14134;
var state_14163__$1 = (function (){var statearr_14168 = state_14163;
(statearr_14168[(10)] = inst_14135);

return statearr_14168;
})();
var statearr_14169_14191 = state_14163__$1;
(statearr_14169_14191[(2)] = null);

(statearr_14169_14191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (4))){
var inst_14135 = (state_14163[(10)]);
var state_14163__$1 = state_14163;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14163__$1,(7),inst_14135);
} else {
if((state_val_14164 === (6))){
var inst_14159 = (state_14163[(2)]);
var state_14163__$1 = state_14163;
var statearr_14170_14192 = state_14163__$1;
(statearr_14170_14192[(2)] = inst_14159);

(statearr_14170_14192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (3))){
var inst_14161 = (state_14163[(2)]);
var state_14163__$1 = state_14163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14163__$1,inst_14161);
} else {
if((state_val_14164 === (2))){
var inst_14135 = (state_14163[(10)]);
var inst_14137 = cljs.core.count.call(null,inst_14135);
var inst_14138 = (inst_14137 > (0));
var state_14163__$1 = state_14163;
if(cljs.core.truth_(inst_14138)){
var statearr_14172_14193 = state_14163__$1;
(statearr_14172_14193[(1)] = (4));

} else {
var statearr_14173_14194 = state_14163__$1;
(statearr_14173_14194[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (11))){
var inst_14135 = (state_14163[(10)]);
var inst_14152 = (state_14163[(2)]);
var tmp14171 = inst_14135;
var inst_14135__$1 = tmp14171;
var state_14163__$1 = (function (){var statearr_14174 = state_14163;
(statearr_14174[(11)] = inst_14152);

(statearr_14174[(10)] = inst_14135__$1);

return statearr_14174;
})();
var statearr_14175_14195 = state_14163__$1;
(statearr_14175_14195[(2)] = null);

(statearr_14175_14195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (9))){
var inst_14143 = (state_14163[(8)]);
var state_14163__$1 = state_14163;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14163__$1,(11),out,inst_14143);
} else {
if((state_val_14164 === (5))){
var inst_14157 = cljs.core.async.close_BANG_.call(null,out);
var state_14163__$1 = state_14163;
var statearr_14176_14196 = state_14163__$1;
(statearr_14176_14196[(2)] = inst_14157);

(statearr_14176_14196[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (10))){
var inst_14155 = (state_14163[(2)]);
var state_14163__$1 = state_14163;
var statearr_14177_14197 = state_14163__$1;
(statearr_14177_14197[(2)] = inst_14155);

(statearr_14177_14197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14164 === (8))){
var inst_14142 = (state_14163[(7)]);
var inst_14143 = (state_14163[(8)]);
var inst_14144 = (state_14163[(9)]);
var inst_14135 = (state_14163[(10)]);
var inst_14147 = (function (){var c = inst_14144;
var v = inst_14143;
var vec__14140 = inst_14142;
var cs = inst_14135;
return ((function (c,v,vec__14140,cs,inst_14142,inst_14143,inst_14144,inst_14135,state_val_14164,c__7709__auto___14188,out){
return (function (p1__14131_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14131_SHARP_);
});
;})(c,v,vec__14140,cs,inst_14142,inst_14143,inst_14144,inst_14135,state_val_14164,c__7709__auto___14188,out))
})();
var inst_14148 = cljs.core.filterv.call(null,inst_14147,inst_14135);
var inst_14135__$1 = inst_14148;
var state_14163__$1 = (function (){var statearr_14178 = state_14163;
(statearr_14178[(10)] = inst_14135__$1);

return statearr_14178;
})();
var statearr_14179_14198 = state_14163__$1;
(statearr_14179_14198[(2)] = null);

(statearr_14179_14198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14188,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14188,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14183 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14183[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14183[(1)] = (1));

return statearr_14183;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14163){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14184){if((e14184 instanceof Object)){
var ex__7651__auto__ = e14184;
var statearr_14185_14199 = state_14163;
(statearr_14185_14199[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14184;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14200 = state_14163;
state_14163 = G__14200;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14188,out))
})();
var state__7711__auto__ = (function (){var statearr_14186 = f__7710__auto__.call(null);
(statearr_14186[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14188);

return statearr_14186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14188,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__14202 = arguments.length;
switch (G__14202) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14250 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14250,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14250,out){
return (function (state_14226){
var state_val_14227 = (state_14226[(1)]);
if((state_val_14227 === (7))){
var inst_14208 = (state_14226[(7)]);
var inst_14208__$1 = (state_14226[(2)]);
var inst_14209 = (inst_14208__$1 == null);
var inst_14210 = cljs.core.not.call(null,inst_14209);
var state_14226__$1 = (function (){var statearr_14228 = state_14226;
(statearr_14228[(7)] = inst_14208__$1);

return statearr_14228;
})();
if(inst_14210){
var statearr_14229_14251 = state_14226__$1;
(statearr_14229_14251[(1)] = (8));

} else {
var statearr_14230_14252 = state_14226__$1;
(statearr_14230_14252[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (1))){
var inst_14203 = (0);
var state_14226__$1 = (function (){var statearr_14231 = state_14226;
(statearr_14231[(8)] = inst_14203);

return statearr_14231;
})();
var statearr_14232_14253 = state_14226__$1;
(statearr_14232_14253[(2)] = null);

(statearr_14232_14253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (4))){
var state_14226__$1 = state_14226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14226__$1,(7),ch);
} else {
if((state_val_14227 === (6))){
var inst_14221 = (state_14226[(2)]);
var state_14226__$1 = state_14226;
var statearr_14233_14254 = state_14226__$1;
(statearr_14233_14254[(2)] = inst_14221);

(statearr_14233_14254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (3))){
var inst_14223 = (state_14226[(2)]);
var inst_14224 = cljs.core.async.close_BANG_.call(null,out);
var state_14226__$1 = (function (){var statearr_14234 = state_14226;
(statearr_14234[(9)] = inst_14223);

return statearr_14234;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14226__$1,inst_14224);
} else {
if((state_val_14227 === (2))){
var inst_14203 = (state_14226[(8)]);
var inst_14205 = (inst_14203 < n);
var state_14226__$1 = state_14226;
if(cljs.core.truth_(inst_14205)){
var statearr_14235_14255 = state_14226__$1;
(statearr_14235_14255[(1)] = (4));

} else {
var statearr_14236_14256 = state_14226__$1;
(statearr_14236_14256[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (11))){
var inst_14203 = (state_14226[(8)]);
var inst_14213 = (state_14226[(2)]);
var inst_14214 = (inst_14203 + (1));
var inst_14203__$1 = inst_14214;
var state_14226__$1 = (function (){var statearr_14237 = state_14226;
(statearr_14237[(8)] = inst_14203__$1);

(statearr_14237[(10)] = inst_14213);

return statearr_14237;
})();
var statearr_14238_14257 = state_14226__$1;
(statearr_14238_14257[(2)] = null);

(statearr_14238_14257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (9))){
var state_14226__$1 = state_14226;
var statearr_14239_14258 = state_14226__$1;
(statearr_14239_14258[(2)] = null);

(statearr_14239_14258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (5))){
var state_14226__$1 = state_14226;
var statearr_14240_14259 = state_14226__$1;
(statearr_14240_14259[(2)] = null);

(statearr_14240_14259[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (10))){
var inst_14218 = (state_14226[(2)]);
var state_14226__$1 = state_14226;
var statearr_14241_14260 = state_14226__$1;
(statearr_14241_14260[(2)] = inst_14218);

(statearr_14241_14260[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14227 === (8))){
var inst_14208 = (state_14226[(7)]);
var state_14226__$1 = state_14226;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14226__$1,(11),out,inst_14208);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14250,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14250,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14245 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14245[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14245[(1)] = (1));

return statearr_14245;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14226){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14246){if((e14246 instanceof Object)){
var ex__7651__auto__ = e14246;
var statearr_14247_14261 = state_14226;
(statearr_14247_14261[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14226);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14262 = state_14226;
state_14226 = G__14262;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14226){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14250,out))
})();
var state__7711__auto__ = (function (){var statearr_14248 = f__7710__auto__.call(null);
(statearr_14248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14250);

return statearr_14248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14250,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t14270 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14270 = (function (ch,f,map_LT_,meta14271){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta14271 = meta14271;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t14273 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14273 = (function (fn1,_,meta14271,map_LT_,f,ch,meta14274){
this.fn1 = fn1;
this._ = _;
this.meta14271 = meta14271;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14274 = meta14274;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14273.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t14273.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t14273.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14263_SHARP_){
return f1.call(null,(((p1__14263_SHARP_ == null))?null:self__.f.call(null,p1__14263_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t14273.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14275){
var self__ = this;
var _14275__$1 = this;
return self__.meta14274;
});})(___$1))
;

cljs.core.async.t14273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14275,meta14274__$1){
var self__ = this;
var _14275__$1 = this;
return (new cljs.core.async.t14273(self__.fn1,self__._,self__.meta14271,self__.map_LT_,self__.f,self__.ch,meta14274__$1));
});})(___$1))
;

cljs.core.async.t14273.cljs$lang$type = true;

cljs.core.async.t14273.cljs$lang$ctorStr = "cljs.core.async/t14273";

cljs.core.async.t14273.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14273");
});})(___$1))
;

cljs.core.async.__GT_t14273 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t14273(fn1__$1,___$2,meta14271__$1,map_LT___$1,f__$1,ch__$1,meta14274){
return (new cljs.core.async.t14273(fn1__$1,___$2,meta14271__$1,map_LT___$1,f__$1,ch__$1,meta14274));
});})(___$1))
;

}

return (new cljs.core.async.t14273(fn1,___$1,self__.meta14271,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14270.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14270.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14272){
var self__ = this;
var _14272__$1 = this;
return self__.meta14271;
});

cljs.core.async.t14270.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14272,meta14271__$1){
var self__ = this;
var _14272__$1 = this;
return (new cljs.core.async.t14270(self__.ch,self__.f,self__.map_LT_,meta14271__$1));
});

cljs.core.async.t14270.cljs$lang$type = true;

cljs.core.async.t14270.cljs$lang$ctorStr = "cljs.core.async/t14270";

cljs.core.async.t14270.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14270");
});

cljs.core.async.__GT_t14270 = (function cljs$core$async$map_LT__$___GT_t14270(ch__$1,f__$1,map_LT___$1,meta14271){
return (new cljs.core.async.t14270(ch__$1,f__$1,map_LT___$1,meta14271));
});

}

return (new cljs.core.async.t14270(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t14279 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14279 = (function (ch,f,map_GT_,meta14280){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta14280 = meta14280;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14279.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14281){
var self__ = this;
var _14281__$1 = this;
return self__.meta14280;
});

cljs.core.async.t14279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14281,meta14280__$1){
var self__ = this;
var _14281__$1 = this;
return (new cljs.core.async.t14279(self__.ch,self__.f,self__.map_GT_,meta14280__$1));
});

cljs.core.async.t14279.cljs$lang$type = true;

cljs.core.async.t14279.cljs$lang$ctorStr = "cljs.core.async/t14279";

cljs.core.async.t14279.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14279");
});

cljs.core.async.__GT_t14279 = (function cljs$core$async$map_GT__$___GT_t14279(ch__$1,f__$1,map_GT___$1,meta14280){
return (new cljs.core.async.t14279(ch__$1,f__$1,map_GT___$1,meta14280));
});

}

return (new cljs.core.async.t14279(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t14285 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14285 = (function (ch,p,filter_GT_,meta14286){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta14286 = meta14286;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14285.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14285.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14287){
var self__ = this;
var _14287__$1 = this;
return self__.meta14286;
});

cljs.core.async.t14285.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14287,meta14286__$1){
var self__ = this;
var _14287__$1 = this;
return (new cljs.core.async.t14285(self__.ch,self__.p,self__.filter_GT_,meta14286__$1));
});

cljs.core.async.t14285.cljs$lang$type = true;

cljs.core.async.t14285.cljs$lang$ctorStr = "cljs.core.async/t14285";

cljs.core.async.t14285.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14285");
});

cljs.core.async.__GT_t14285 = (function cljs$core$async$filter_GT__$___GT_t14285(ch__$1,p__$1,filter_GT___$1,meta14286){
return (new cljs.core.async.t14285(ch__$1,p__$1,filter_GT___$1,meta14286));
});

}

return (new cljs.core.async.t14285(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__14289 = arguments.length;
switch (G__14289) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14332 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14332,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14332,out){
return (function (state_14310){
var state_val_14311 = (state_14310[(1)]);
if((state_val_14311 === (7))){
var inst_14306 = (state_14310[(2)]);
var state_14310__$1 = state_14310;
var statearr_14312_14333 = state_14310__$1;
(statearr_14312_14333[(2)] = inst_14306);

(statearr_14312_14333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (1))){
var state_14310__$1 = state_14310;
var statearr_14313_14334 = state_14310__$1;
(statearr_14313_14334[(2)] = null);

(statearr_14313_14334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (4))){
var inst_14292 = (state_14310[(7)]);
var inst_14292__$1 = (state_14310[(2)]);
var inst_14293 = (inst_14292__$1 == null);
var state_14310__$1 = (function (){var statearr_14314 = state_14310;
(statearr_14314[(7)] = inst_14292__$1);

return statearr_14314;
})();
if(cljs.core.truth_(inst_14293)){
var statearr_14315_14335 = state_14310__$1;
(statearr_14315_14335[(1)] = (5));

} else {
var statearr_14316_14336 = state_14310__$1;
(statearr_14316_14336[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (6))){
var inst_14292 = (state_14310[(7)]);
var inst_14297 = p.call(null,inst_14292);
var state_14310__$1 = state_14310;
if(cljs.core.truth_(inst_14297)){
var statearr_14317_14337 = state_14310__$1;
(statearr_14317_14337[(1)] = (8));

} else {
var statearr_14318_14338 = state_14310__$1;
(statearr_14318_14338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (3))){
var inst_14308 = (state_14310[(2)]);
var state_14310__$1 = state_14310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14310__$1,inst_14308);
} else {
if((state_val_14311 === (2))){
var state_14310__$1 = state_14310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14310__$1,(4),ch);
} else {
if((state_val_14311 === (11))){
var inst_14300 = (state_14310[(2)]);
var state_14310__$1 = state_14310;
var statearr_14319_14339 = state_14310__$1;
(statearr_14319_14339[(2)] = inst_14300);

(statearr_14319_14339[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (9))){
var state_14310__$1 = state_14310;
var statearr_14320_14340 = state_14310__$1;
(statearr_14320_14340[(2)] = null);

(statearr_14320_14340[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (5))){
var inst_14295 = cljs.core.async.close_BANG_.call(null,out);
var state_14310__$1 = state_14310;
var statearr_14321_14341 = state_14310__$1;
(statearr_14321_14341[(2)] = inst_14295);

(statearr_14321_14341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (10))){
var inst_14303 = (state_14310[(2)]);
var state_14310__$1 = (function (){var statearr_14322 = state_14310;
(statearr_14322[(8)] = inst_14303);

return statearr_14322;
})();
var statearr_14323_14342 = state_14310__$1;
(statearr_14323_14342[(2)] = null);

(statearr_14323_14342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14311 === (8))){
var inst_14292 = (state_14310[(7)]);
var state_14310__$1 = state_14310;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14310__$1,(11),out,inst_14292);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14332,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14332,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14327 = [null,null,null,null,null,null,null,null,null];
(statearr_14327[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14327[(1)] = (1));

return statearr_14327;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14310){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14328){if((e14328 instanceof Object)){
var ex__7651__auto__ = e14328;
var statearr_14329_14343 = state_14310;
(statearr_14329_14343[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14310);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14344 = state_14310;
state_14310 = G__14344;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14310){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14332,out))
})();
var state__7711__auto__ = (function (){var statearr_14330 = f__7710__auto__.call(null);
(statearr_14330[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14332);

return statearr_14330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14332,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__14346 = arguments.length;
switch (G__14346) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_14513){
var state_val_14514 = (state_14513[(1)]);
if((state_val_14514 === (7))){
var inst_14509 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
var statearr_14515_14556 = state_14513__$1;
(statearr_14515_14556[(2)] = inst_14509);

(statearr_14515_14556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (20))){
var inst_14479 = (state_14513[(7)]);
var inst_14490 = (state_14513[(2)]);
var inst_14491 = cljs.core.next.call(null,inst_14479);
var inst_14465 = inst_14491;
var inst_14466 = null;
var inst_14467 = (0);
var inst_14468 = (0);
var state_14513__$1 = (function (){var statearr_14516 = state_14513;
(statearr_14516[(8)] = inst_14466);

(statearr_14516[(9)] = inst_14490);

(statearr_14516[(10)] = inst_14467);

(statearr_14516[(11)] = inst_14468);

(statearr_14516[(12)] = inst_14465);

return statearr_14516;
})();
var statearr_14517_14557 = state_14513__$1;
(statearr_14517_14557[(2)] = null);

(statearr_14517_14557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (1))){
var state_14513__$1 = state_14513;
var statearr_14518_14558 = state_14513__$1;
(statearr_14518_14558[(2)] = null);

(statearr_14518_14558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (4))){
var inst_14454 = (state_14513[(13)]);
var inst_14454__$1 = (state_14513[(2)]);
var inst_14455 = (inst_14454__$1 == null);
var state_14513__$1 = (function (){var statearr_14519 = state_14513;
(statearr_14519[(13)] = inst_14454__$1);

return statearr_14519;
})();
if(cljs.core.truth_(inst_14455)){
var statearr_14520_14559 = state_14513__$1;
(statearr_14520_14559[(1)] = (5));

} else {
var statearr_14521_14560 = state_14513__$1;
(statearr_14521_14560[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (15))){
var state_14513__$1 = state_14513;
var statearr_14525_14561 = state_14513__$1;
(statearr_14525_14561[(2)] = null);

(statearr_14525_14561[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (21))){
var state_14513__$1 = state_14513;
var statearr_14526_14562 = state_14513__$1;
(statearr_14526_14562[(2)] = null);

(statearr_14526_14562[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (13))){
var inst_14466 = (state_14513[(8)]);
var inst_14467 = (state_14513[(10)]);
var inst_14468 = (state_14513[(11)]);
var inst_14465 = (state_14513[(12)]);
var inst_14475 = (state_14513[(2)]);
var inst_14476 = (inst_14468 + (1));
var tmp14522 = inst_14466;
var tmp14523 = inst_14467;
var tmp14524 = inst_14465;
var inst_14465__$1 = tmp14524;
var inst_14466__$1 = tmp14522;
var inst_14467__$1 = tmp14523;
var inst_14468__$1 = inst_14476;
var state_14513__$1 = (function (){var statearr_14527 = state_14513;
(statearr_14527[(8)] = inst_14466__$1);

(statearr_14527[(10)] = inst_14467__$1);

(statearr_14527[(14)] = inst_14475);

(statearr_14527[(11)] = inst_14468__$1);

(statearr_14527[(12)] = inst_14465__$1);

return statearr_14527;
})();
var statearr_14528_14563 = state_14513__$1;
(statearr_14528_14563[(2)] = null);

(statearr_14528_14563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (22))){
var state_14513__$1 = state_14513;
var statearr_14529_14564 = state_14513__$1;
(statearr_14529_14564[(2)] = null);

(statearr_14529_14564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (6))){
var inst_14454 = (state_14513[(13)]);
var inst_14463 = f.call(null,inst_14454);
var inst_14464 = cljs.core.seq.call(null,inst_14463);
var inst_14465 = inst_14464;
var inst_14466 = null;
var inst_14467 = (0);
var inst_14468 = (0);
var state_14513__$1 = (function (){var statearr_14530 = state_14513;
(statearr_14530[(8)] = inst_14466);

(statearr_14530[(10)] = inst_14467);

(statearr_14530[(11)] = inst_14468);

(statearr_14530[(12)] = inst_14465);

return statearr_14530;
})();
var statearr_14531_14565 = state_14513__$1;
(statearr_14531_14565[(2)] = null);

(statearr_14531_14565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (17))){
var inst_14479 = (state_14513[(7)]);
var inst_14483 = cljs.core.chunk_first.call(null,inst_14479);
var inst_14484 = cljs.core.chunk_rest.call(null,inst_14479);
var inst_14485 = cljs.core.count.call(null,inst_14483);
var inst_14465 = inst_14484;
var inst_14466 = inst_14483;
var inst_14467 = inst_14485;
var inst_14468 = (0);
var state_14513__$1 = (function (){var statearr_14532 = state_14513;
(statearr_14532[(8)] = inst_14466);

(statearr_14532[(10)] = inst_14467);

(statearr_14532[(11)] = inst_14468);

(statearr_14532[(12)] = inst_14465);

return statearr_14532;
})();
var statearr_14533_14566 = state_14513__$1;
(statearr_14533_14566[(2)] = null);

(statearr_14533_14566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (3))){
var inst_14511 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14513__$1,inst_14511);
} else {
if((state_val_14514 === (12))){
var inst_14499 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
var statearr_14534_14567 = state_14513__$1;
(statearr_14534_14567[(2)] = inst_14499);

(statearr_14534_14567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (2))){
var state_14513__$1 = state_14513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14513__$1,(4),in$);
} else {
if((state_val_14514 === (23))){
var inst_14507 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
var statearr_14535_14568 = state_14513__$1;
(statearr_14535_14568[(2)] = inst_14507);

(statearr_14535_14568[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (19))){
var inst_14494 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
var statearr_14536_14569 = state_14513__$1;
(statearr_14536_14569[(2)] = inst_14494);

(statearr_14536_14569[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (11))){
var inst_14479 = (state_14513[(7)]);
var inst_14465 = (state_14513[(12)]);
var inst_14479__$1 = cljs.core.seq.call(null,inst_14465);
var state_14513__$1 = (function (){var statearr_14537 = state_14513;
(statearr_14537[(7)] = inst_14479__$1);

return statearr_14537;
})();
if(inst_14479__$1){
var statearr_14538_14570 = state_14513__$1;
(statearr_14538_14570[(1)] = (14));

} else {
var statearr_14539_14571 = state_14513__$1;
(statearr_14539_14571[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (9))){
var inst_14501 = (state_14513[(2)]);
var inst_14502 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14513__$1 = (function (){var statearr_14540 = state_14513;
(statearr_14540[(15)] = inst_14501);

return statearr_14540;
})();
if(cljs.core.truth_(inst_14502)){
var statearr_14541_14572 = state_14513__$1;
(statearr_14541_14572[(1)] = (21));

} else {
var statearr_14542_14573 = state_14513__$1;
(statearr_14542_14573[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (5))){
var inst_14457 = cljs.core.async.close_BANG_.call(null,out);
var state_14513__$1 = state_14513;
var statearr_14543_14574 = state_14513__$1;
(statearr_14543_14574[(2)] = inst_14457);

(statearr_14543_14574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (14))){
var inst_14479 = (state_14513[(7)]);
var inst_14481 = cljs.core.chunked_seq_QMARK_.call(null,inst_14479);
var state_14513__$1 = state_14513;
if(inst_14481){
var statearr_14544_14575 = state_14513__$1;
(statearr_14544_14575[(1)] = (17));

} else {
var statearr_14545_14576 = state_14513__$1;
(statearr_14545_14576[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (16))){
var inst_14497 = (state_14513[(2)]);
var state_14513__$1 = state_14513;
var statearr_14546_14577 = state_14513__$1;
(statearr_14546_14577[(2)] = inst_14497);

(statearr_14546_14577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14514 === (10))){
var inst_14466 = (state_14513[(8)]);
var inst_14468 = (state_14513[(11)]);
var inst_14473 = cljs.core._nth.call(null,inst_14466,inst_14468);
var state_14513__$1 = state_14513;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14513__$1,(13),out,inst_14473);
} else {
if((state_val_14514 === (18))){
var inst_14479 = (state_14513[(7)]);
var inst_14488 = cljs.core.first.call(null,inst_14479);
var state_14513__$1 = state_14513;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14513__$1,(20),out,inst_14488);
} else {
if((state_val_14514 === (8))){
var inst_14467 = (state_14513[(10)]);
var inst_14468 = (state_14513[(11)]);
var inst_14470 = (inst_14468 < inst_14467);
var inst_14471 = inst_14470;
var state_14513__$1 = state_14513;
if(cljs.core.truth_(inst_14471)){
var statearr_14547_14578 = state_14513__$1;
(statearr_14547_14578[(1)] = (10));

} else {
var statearr_14548_14579 = state_14513__$1;
(statearr_14548_14579[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_14552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14552[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_14552[(1)] = (1));

return statearr_14552;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_14513){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14553){if((e14553 instanceof Object)){
var ex__7651__auto__ = e14553;
var statearr_14554_14580 = state_14513;
(statearr_14554_14580[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14581 = state_14513;
state_14513 = G__14581;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_14513){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_14513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_14555 = f__7710__auto__.call(null);
(statearr_14555[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_14555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__14583 = arguments.length;
switch (G__14583) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__14586 = arguments.length;
switch (G__14586) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__14589 = arguments.length;
switch (G__14589) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14639,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14639,out){
return (function (state_14613){
var state_val_14614 = (state_14613[(1)]);
if((state_val_14614 === (7))){
var inst_14608 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
var statearr_14615_14640 = state_14613__$1;
(statearr_14615_14640[(2)] = inst_14608);

(statearr_14615_14640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (1))){
var inst_14590 = null;
var state_14613__$1 = (function (){var statearr_14616 = state_14613;
(statearr_14616[(7)] = inst_14590);

return statearr_14616;
})();
var statearr_14617_14641 = state_14613__$1;
(statearr_14617_14641[(2)] = null);

(statearr_14617_14641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (4))){
var inst_14593 = (state_14613[(8)]);
var inst_14593__$1 = (state_14613[(2)]);
var inst_14594 = (inst_14593__$1 == null);
var inst_14595 = cljs.core.not.call(null,inst_14594);
var state_14613__$1 = (function (){var statearr_14618 = state_14613;
(statearr_14618[(8)] = inst_14593__$1);

return statearr_14618;
})();
if(inst_14595){
var statearr_14619_14642 = state_14613__$1;
(statearr_14619_14642[(1)] = (5));

} else {
var statearr_14620_14643 = state_14613__$1;
(statearr_14620_14643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (6))){
var state_14613__$1 = state_14613;
var statearr_14621_14644 = state_14613__$1;
(statearr_14621_14644[(2)] = null);

(statearr_14621_14644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (3))){
var inst_14610 = (state_14613[(2)]);
var inst_14611 = cljs.core.async.close_BANG_.call(null,out);
var state_14613__$1 = (function (){var statearr_14622 = state_14613;
(statearr_14622[(9)] = inst_14610);

return statearr_14622;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14613__$1,inst_14611);
} else {
if((state_val_14614 === (2))){
var state_14613__$1 = state_14613;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14613__$1,(4),ch);
} else {
if((state_val_14614 === (11))){
var inst_14593 = (state_14613[(8)]);
var inst_14602 = (state_14613[(2)]);
var inst_14590 = inst_14593;
var state_14613__$1 = (function (){var statearr_14623 = state_14613;
(statearr_14623[(10)] = inst_14602);

(statearr_14623[(7)] = inst_14590);

return statearr_14623;
})();
var statearr_14624_14645 = state_14613__$1;
(statearr_14624_14645[(2)] = null);

(statearr_14624_14645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (9))){
var inst_14593 = (state_14613[(8)]);
var state_14613__$1 = state_14613;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14613__$1,(11),out,inst_14593);
} else {
if((state_val_14614 === (5))){
var inst_14590 = (state_14613[(7)]);
var inst_14593 = (state_14613[(8)]);
var inst_14597 = cljs.core._EQ_.call(null,inst_14593,inst_14590);
var state_14613__$1 = state_14613;
if(inst_14597){
var statearr_14626_14646 = state_14613__$1;
(statearr_14626_14646[(1)] = (8));

} else {
var statearr_14627_14647 = state_14613__$1;
(statearr_14627_14647[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (10))){
var inst_14605 = (state_14613[(2)]);
var state_14613__$1 = state_14613;
var statearr_14628_14648 = state_14613__$1;
(statearr_14628_14648[(2)] = inst_14605);

(statearr_14628_14648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14614 === (8))){
var inst_14590 = (state_14613[(7)]);
var tmp14625 = inst_14590;
var inst_14590__$1 = tmp14625;
var state_14613__$1 = (function (){var statearr_14629 = state_14613;
(statearr_14629[(7)] = inst_14590__$1);

return statearr_14629;
})();
var statearr_14630_14649 = state_14613__$1;
(statearr_14630_14649[(2)] = null);

(statearr_14630_14649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14639,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14639,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14634 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14634[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14634[(1)] = (1));

return statearr_14634;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14613){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14613);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14635){if((e14635 instanceof Object)){
var ex__7651__auto__ = e14635;
var statearr_14636_14650 = state_14613;
(statearr_14636_14650[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14613);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14651 = state_14613;
state_14613 = G__14651;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14613){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14639,out))
})();
var state__7711__auto__ = (function (){var statearr_14637 = f__7710__auto__.call(null);
(statearr_14637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14639);

return statearr_14637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14639,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__14653 = arguments.length;
switch (G__14653) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14722,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14722,out){
return (function (state_14691){
var state_val_14692 = (state_14691[(1)]);
if((state_val_14692 === (7))){
var inst_14687 = (state_14691[(2)]);
var state_14691__$1 = state_14691;
var statearr_14693_14723 = state_14691__$1;
(statearr_14693_14723[(2)] = inst_14687);

(statearr_14693_14723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (1))){
var inst_14654 = (new Array(n));
var inst_14655 = inst_14654;
var inst_14656 = (0);
var state_14691__$1 = (function (){var statearr_14694 = state_14691;
(statearr_14694[(7)] = inst_14656);

(statearr_14694[(8)] = inst_14655);

return statearr_14694;
})();
var statearr_14695_14724 = state_14691__$1;
(statearr_14695_14724[(2)] = null);

(statearr_14695_14724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (4))){
var inst_14659 = (state_14691[(9)]);
var inst_14659__$1 = (state_14691[(2)]);
var inst_14660 = (inst_14659__$1 == null);
var inst_14661 = cljs.core.not.call(null,inst_14660);
var state_14691__$1 = (function (){var statearr_14696 = state_14691;
(statearr_14696[(9)] = inst_14659__$1);

return statearr_14696;
})();
if(inst_14661){
var statearr_14697_14725 = state_14691__$1;
(statearr_14697_14725[(1)] = (5));

} else {
var statearr_14698_14726 = state_14691__$1;
(statearr_14698_14726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (15))){
var inst_14681 = (state_14691[(2)]);
var state_14691__$1 = state_14691;
var statearr_14699_14727 = state_14691__$1;
(statearr_14699_14727[(2)] = inst_14681);

(statearr_14699_14727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (13))){
var state_14691__$1 = state_14691;
var statearr_14700_14728 = state_14691__$1;
(statearr_14700_14728[(2)] = null);

(statearr_14700_14728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (6))){
var inst_14656 = (state_14691[(7)]);
var inst_14677 = (inst_14656 > (0));
var state_14691__$1 = state_14691;
if(cljs.core.truth_(inst_14677)){
var statearr_14701_14729 = state_14691__$1;
(statearr_14701_14729[(1)] = (12));

} else {
var statearr_14702_14730 = state_14691__$1;
(statearr_14702_14730[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (3))){
var inst_14689 = (state_14691[(2)]);
var state_14691__$1 = state_14691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14691__$1,inst_14689);
} else {
if((state_val_14692 === (12))){
var inst_14655 = (state_14691[(8)]);
var inst_14679 = cljs.core.vec.call(null,inst_14655);
var state_14691__$1 = state_14691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14691__$1,(15),out,inst_14679);
} else {
if((state_val_14692 === (2))){
var state_14691__$1 = state_14691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14691__$1,(4),ch);
} else {
if((state_val_14692 === (11))){
var inst_14671 = (state_14691[(2)]);
var inst_14672 = (new Array(n));
var inst_14655 = inst_14672;
var inst_14656 = (0);
var state_14691__$1 = (function (){var statearr_14703 = state_14691;
(statearr_14703[(7)] = inst_14656);

(statearr_14703[(8)] = inst_14655);

(statearr_14703[(10)] = inst_14671);

return statearr_14703;
})();
var statearr_14704_14731 = state_14691__$1;
(statearr_14704_14731[(2)] = null);

(statearr_14704_14731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (9))){
var inst_14655 = (state_14691[(8)]);
var inst_14669 = cljs.core.vec.call(null,inst_14655);
var state_14691__$1 = state_14691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14691__$1,(11),out,inst_14669);
} else {
if((state_val_14692 === (5))){
var inst_14656 = (state_14691[(7)]);
var inst_14659 = (state_14691[(9)]);
var inst_14664 = (state_14691[(11)]);
var inst_14655 = (state_14691[(8)]);
var inst_14663 = (inst_14655[inst_14656] = inst_14659);
var inst_14664__$1 = (inst_14656 + (1));
var inst_14665 = (inst_14664__$1 < n);
var state_14691__$1 = (function (){var statearr_14705 = state_14691;
(statearr_14705[(12)] = inst_14663);

(statearr_14705[(11)] = inst_14664__$1);

return statearr_14705;
})();
if(cljs.core.truth_(inst_14665)){
var statearr_14706_14732 = state_14691__$1;
(statearr_14706_14732[(1)] = (8));

} else {
var statearr_14707_14733 = state_14691__$1;
(statearr_14707_14733[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (14))){
var inst_14684 = (state_14691[(2)]);
var inst_14685 = cljs.core.async.close_BANG_.call(null,out);
var state_14691__$1 = (function (){var statearr_14709 = state_14691;
(statearr_14709[(13)] = inst_14684);

return statearr_14709;
})();
var statearr_14710_14734 = state_14691__$1;
(statearr_14710_14734[(2)] = inst_14685);

(statearr_14710_14734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (10))){
var inst_14675 = (state_14691[(2)]);
var state_14691__$1 = state_14691;
var statearr_14711_14735 = state_14691__$1;
(statearr_14711_14735[(2)] = inst_14675);

(statearr_14711_14735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14692 === (8))){
var inst_14664 = (state_14691[(11)]);
var inst_14655 = (state_14691[(8)]);
var tmp14708 = inst_14655;
var inst_14655__$1 = tmp14708;
var inst_14656 = inst_14664;
var state_14691__$1 = (function (){var statearr_14712 = state_14691;
(statearr_14712[(7)] = inst_14656);

(statearr_14712[(8)] = inst_14655__$1);

return statearr_14712;
})();
var statearr_14713_14736 = state_14691__$1;
(statearr_14713_14736[(2)] = null);

(statearr_14713_14736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14722,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14722,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14717[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14717[(1)] = (1));

return statearr_14717;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14691){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14718){if((e14718 instanceof Object)){
var ex__7651__auto__ = e14718;
var statearr_14719_14737 = state_14691;
(statearr_14719_14737[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14738 = state_14691;
state_14691 = G__14738;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14691){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14722,out))
})();
var state__7711__auto__ = (function (){var statearr_14720 = f__7710__auto__.call(null);
(statearr_14720[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14722);

return statearr_14720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14722,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__14740 = arguments.length;
switch (G__14740) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14813 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14813,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14813,out){
return (function (state_14782){
var state_val_14783 = (state_14782[(1)]);
if((state_val_14783 === (7))){
var inst_14778 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
var statearr_14784_14814 = state_14782__$1;
(statearr_14784_14814[(2)] = inst_14778);

(statearr_14784_14814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (1))){
var inst_14741 = [];
var inst_14742 = inst_14741;
var inst_14743 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14782__$1 = (function (){var statearr_14785 = state_14782;
(statearr_14785[(7)] = inst_14742);

(statearr_14785[(8)] = inst_14743);

return statearr_14785;
})();
var statearr_14786_14815 = state_14782__$1;
(statearr_14786_14815[(2)] = null);

(statearr_14786_14815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (4))){
var inst_14746 = (state_14782[(9)]);
var inst_14746__$1 = (state_14782[(2)]);
var inst_14747 = (inst_14746__$1 == null);
var inst_14748 = cljs.core.not.call(null,inst_14747);
var state_14782__$1 = (function (){var statearr_14787 = state_14782;
(statearr_14787[(9)] = inst_14746__$1);

return statearr_14787;
})();
if(inst_14748){
var statearr_14788_14816 = state_14782__$1;
(statearr_14788_14816[(1)] = (5));

} else {
var statearr_14789_14817 = state_14782__$1;
(statearr_14789_14817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (15))){
var inst_14772 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
var statearr_14790_14818 = state_14782__$1;
(statearr_14790_14818[(2)] = inst_14772);

(statearr_14790_14818[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (13))){
var state_14782__$1 = state_14782;
var statearr_14791_14819 = state_14782__$1;
(statearr_14791_14819[(2)] = null);

(statearr_14791_14819[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (6))){
var inst_14742 = (state_14782[(7)]);
var inst_14767 = inst_14742.length;
var inst_14768 = (inst_14767 > (0));
var state_14782__$1 = state_14782;
if(cljs.core.truth_(inst_14768)){
var statearr_14792_14820 = state_14782__$1;
(statearr_14792_14820[(1)] = (12));

} else {
var statearr_14793_14821 = state_14782__$1;
(statearr_14793_14821[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (3))){
var inst_14780 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14782__$1,inst_14780);
} else {
if((state_val_14783 === (12))){
var inst_14742 = (state_14782[(7)]);
var inst_14770 = cljs.core.vec.call(null,inst_14742);
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14782__$1,(15),out,inst_14770);
} else {
if((state_val_14783 === (2))){
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14782__$1,(4),ch);
} else {
if((state_val_14783 === (11))){
var inst_14746 = (state_14782[(9)]);
var inst_14750 = (state_14782[(10)]);
var inst_14760 = (state_14782[(2)]);
var inst_14761 = [];
var inst_14762 = inst_14761.push(inst_14746);
var inst_14742 = inst_14761;
var inst_14743 = inst_14750;
var state_14782__$1 = (function (){var statearr_14794 = state_14782;
(statearr_14794[(11)] = inst_14762);

(statearr_14794[(12)] = inst_14760);

(statearr_14794[(7)] = inst_14742);

(statearr_14794[(8)] = inst_14743);

return statearr_14794;
})();
var statearr_14795_14822 = state_14782__$1;
(statearr_14795_14822[(2)] = null);

(statearr_14795_14822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (9))){
var inst_14742 = (state_14782[(7)]);
var inst_14758 = cljs.core.vec.call(null,inst_14742);
var state_14782__$1 = state_14782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14782__$1,(11),out,inst_14758);
} else {
if((state_val_14783 === (5))){
var inst_14746 = (state_14782[(9)]);
var inst_14750 = (state_14782[(10)]);
var inst_14743 = (state_14782[(8)]);
var inst_14750__$1 = f.call(null,inst_14746);
var inst_14751 = cljs.core._EQ_.call(null,inst_14750__$1,inst_14743);
var inst_14752 = cljs.core.keyword_identical_QMARK_.call(null,inst_14743,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14753 = (inst_14751) || (inst_14752);
var state_14782__$1 = (function (){var statearr_14796 = state_14782;
(statearr_14796[(10)] = inst_14750__$1);

return statearr_14796;
})();
if(cljs.core.truth_(inst_14753)){
var statearr_14797_14823 = state_14782__$1;
(statearr_14797_14823[(1)] = (8));

} else {
var statearr_14798_14824 = state_14782__$1;
(statearr_14798_14824[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (14))){
var inst_14775 = (state_14782[(2)]);
var inst_14776 = cljs.core.async.close_BANG_.call(null,out);
var state_14782__$1 = (function (){var statearr_14800 = state_14782;
(statearr_14800[(13)] = inst_14775);

return statearr_14800;
})();
var statearr_14801_14825 = state_14782__$1;
(statearr_14801_14825[(2)] = inst_14776);

(statearr_14801_14825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (10))){
var inst_14765 = (state_14782[(2)]);
var state_14782__$1 = state_14782;
var statearr_14802_14826 = state_14782__$1;
(statearr_14802_14826[(2)] = inst_14765);

(statearr_14802_14826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14783 === (8))){
var inst_14746 = (state_14782[(9)]);
var inst_14742 = (state_14782[(7)]);
var inst_14750 = (state_14782[(10)]);
var inst_14755 = inst_14742.push(inst_14746);
var tmp14799 = inst_14742;
var inst_14742__$1 = tmp14799;
var inst_14743 = inst_14750;
var state_14782__$1 = (function (){var statearr_14803 = state_14782;
(statearr_14803[(7)] = inst_14742__$1);

(statearr_14803[(14)] = inst_14755);

(statearr_14803[(8)] = inst_14743);

return statearr_14803;
})();
var statearr_14804_14827 = state_14782__$1;
(statearr_14804_14827[(2)] = null);

(statearr_14804_14827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14813,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14813,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14808 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14808[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14808[(1)] = (1));

return statearr_14808;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14782){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14809){if((e14809 instanceof Object)){
var ex__7651__auto__ = e14809;
var statearr_14810_14828 = state_14782;
(statearr_14810_14828[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14829 = state_14782;
state_14782 = G__14829;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14782){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14813,out))
})();
var state__7711__auto__ = (function (){var statearr_14811 = f__7710__auto__.call(null);
(statearr_14811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14813);

return statearr_14811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14813,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
