// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_.call(null,class_name,class$,i)){
return i;
} else {
var G__11377 = (i + class$.length);
start_from = G__11377;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index.call(null,class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__11382 = arguments.length;
switch (G__11382) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var classes__$1 = clojure.string.trim.call(null,cljs.core.name.call(null,classes));
if(cljs.core.seq.call(null,classes__$1)){
var temp__4124__auto___11396 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11396)){
var class_list_11397 = temp__4124__auto___11396;
var seq__11383_11398 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11384_11399 = null;
var count__11385_11400 = (0);
var i__11386_11401 = (0);
while(true){
if((i__11386_11401 < count__11385_11400)){
var class_11402 = cljs.core._nth.call(null,chunk__11384_11399,i__11386_11401);
class_list_11397.add(class_11402);

var G__11403 = seq__11383_11398;
var G__11404 = chunk__11384_11399;
var G__11405 = count__11385_11400;
var G__11406 = (i__11386_11401 + (1));
seq__11383_11398 = G__11403;
chunk__11384_11399 = G__11404;
count__11385_11400 = G__11405;
i__11386_11401 = G__11406;
continue;
} else {
var temp__4126__auto___11407 = cljs.core.seq.call(null,seq__11383_11398);
if(temp__4126__auto___11407){
var seq__11383_11408__$1 = temp__4126__auto___11407;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11383_11408__$1)){
var c__5061__auto___11409 = cljs.core.chunk_first.call(null,seq__11383_11408__$1);
var G__11410 = cljs.core.chunk_rest.call(null,seq__11383_11408__$1);
var G__11411 = c__5061__auto___11409;
var G__11412 = cljs.core.count.call(null,c__5061__auto___11409);
var G__11413 = (0);
seq__11383_11398 = G__11410;
chunk__11384_11399 = G__11411;
count__11385_11400 = G__11412;
i__11386_11401 = G__11413;
continue;
} else {
var class_11414 = cljs.core.first.call(null,seq__11383_11408__$1);
class_list_11397.add(class_11414);

var G__11415 = cljs.core.next.call(null,seq__11383_11408__$1);
var G__11416 = null;
var G__11417 = (0);
var G__11418 = (0);
seq__11383_11398 = G__11415;
chunk__11384_11399 = G__11416;
count__11385_11400 = G__11417;
i__11386_11401 = G__11418;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_11419 = elem__$1.className;
var seq__11387_11420 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11388_11421 = null;
var count__11389_11422 = (0);
var i__11390_11423 = (0);
while(true){
if((i__11390_11423 < count__11389_11422)){
var class_11424 = cljs.core._nth.call(null,chunk__11388_11421,i__11390_11423);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11419,class_11424))){
} else {
elem__$1.className = (((class_name_11419 === ""))?class_11424:[cljs.core.str(class_name_11419),cljs.core.str(" "),cljs.core.str(class_11424)].join(''));
}

var G__11425 = seq__11387_11420;
var G__11426 = chunk__11388_11421;
var G__11427 = count__11389_11422;
var G__11428 = (i__11390_11423 + (1));
seq__11387_11420 = G__11425;
chunk__11388_11421 = G__11426;
count__11389_11422 = G__11427;
i__11390_11423 = G__11428;
continue;
} else {
var temp__4126__auto___11429 = cljs.core.seq.call(null,seq__11387_11420);
if(temp__4126__auto___11429){
var seq__11387_11430__$1 = temp__4126__auto___11429;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11387_11430__$1)){
var c__5061__auto___11431 = cljs.core.chunk_first.call(null,seq__11387_11430__$1);
var G__11432 = cljs.core.chunk_rest.call(null,seq__11387_11430__$1);
var G__11433 = c__5061__auto___11431;
var G__11434 = cljs.core.count.call(null,c__5061__auto___11431);
var G__11435 = (0);
seq__11387_11420 = G__11432;
chunk__11388_11421 = G__11433;
count__11389_11422 = G__11434;
i__11390_11423 = G__11435;
continue;
} else {
var class_11436 = cljs.core.first.call(null,seq__11387_11430__$1);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11419,class_11436))){
} else {
elem__$1.className = (((class_name_11419 === ""))?class_11436:[cljs.core.str(class_name_11419),cljs.core.str(" "),cljs.core.str(class_11436)].join(''));
}

var G__11437 = cljs.core.next.call(null,seq__11387_11430__$1);
var G__11438 = null;
var G__11439 = (0);
var G__11440 = (0);
seq__11387_11420 = G__11437;
chunk__11388_11421 = G__11438;
count__11389_11422 = G__11439;
i__11390_11423 = G__11440;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11391_11441 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__11392_11442 = null;
var count__11393_11443 = (0);
var i__11394_11444 = (0);
while(true){
if((i__11394_11444 < count__11393_11443)){
var c_11445 = cljs.core._nth.call(null,chunk__11392_11442,i__11394_11444);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11445);

var G__11446 = seq__11391_11441;
var G__11447 = chunk__11392_11442;
var G__11448 = count__11393_11443;
var G__11449 = (i__11394_11444 + (1));
seq__11391_11441 = G__11446;
chunk__11392_11442 = G__11447;
count__11393_11443 = G__11448;
i__11394_11444 = G__11449;
continue;
} else {
var temp__4126__auto___11450 = cljs.core.seq.call(null,seq__11391_11441);
if(temp__4126__auto___11450){
var seq__11391_11451__$1 = temp__4126__auto___11450;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11391_11451__$1)){
var c__5061__auto___11452 = cljs.core.chunk_first.call(null,seq__11391_11451__$1);
var G__11453 = cljs.core.chunk_rest.call(null,seq__11391_11451__$1);
var G__11454 = c__5061__auto___11452;
var G__11455 = cljs.core.count.call(null,c__5061__auto___11452);
var G__11456 = (0);
seq__11391_11441 = G__11453;
chunk__11392_11442 = G__11454;
count__11393_11443 = G__11455;
i__11394_11444 = G__11456;
continue;
} else {
var c_11457 = cljs.core.first.call(null,seq__11391_11451__$1);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11457);

var G__11458 = cljs.core.next.call(null,seq__11391_11451__$1);
var G__11459 = null;
var G__11460 = (0);
var G__11461 = (0);
seq__11391_11441 = G__11458;
chunk__11392_11442 = G__11459;
count__11393_11443 = G__11460;
i__11394_11444 = G__11461;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq11378){
var G__11379 = cljs.core.first.call(null,seq11378);
var seq11378__$1 = cljs.core.next.call(null,seq11378);
var G__11380 = cljs.core.first.call(null,seq11378__$1);
var seq11378__$2 = cljs.core.next.call(null,seq11378__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11379,G__11380,seq11378__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index.call(null,class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__11462 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__11462;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__11467 = arguments.length;
switch (G__11467) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11473 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11473)){
var class_list_11474 = temp__4124__auto___11473;
class_list_11474.remove(class$__$1);
} else {
var class_name_11475 = elem__$1.className;
var new_class_name_11476 = dommy.attrs.remove_class_str.call(null,class_name_11475,class$__$1);
if((class_name_11475 === new_class_name_11476)){
} else {
elem__$1.className = new_class_name_11476;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11468 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__11469 = null;
var count__11470 = (0);
var i__11471 = (0);
while(true){
if((i__11471 < count__11470)){
var c = cljs.core._nth.call(null,chunk__11469,i__11471);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11477 = seq__11468;
var G__11478 = chunk__11469;
var G__11479 = count__11470;
var G__11480 = (i__11471 + (1));
seq__11468 = G__11477;
chunk__11469 = G__11478;
count__11470 = G__11479;
i__11471 = G__11480;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq.call(null,seq__11468);
if(temp__4126__auto__){
var seq__11468__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11468__$1)){
var c__5061__auto__ = cljs.core.chunk_first.call(null,seq__11468__$1);
var G__11481 = cljs.core.chunk_rest.call(null,seq__11468__$1);
var G__11482 = c__5061__auto__;
var G__11483 = cljs.core.count.call(null,c__5061__auto__);
var G__11484 = (0);
seq__11468 = G__11481;
chunk__11469 = G__11482;
count__11470 = G__11483;
i__11471 = G__11484;
continue;
} else {
var c = cljs.core.first.call(null,seq__11468__$1);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11485 = cljs.core.next.call(null,seq__11468__$1);
var G__11486 = null;
var G__11487 = (0);
var G__11488 = (0);
seq__11468 = G__11485;
chunk__11469 = G__11486;
count__11470 = G__11487;
i__11471 = G__11488;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq11463){
var G__11464 = cljs.core.first.call(null,seq11463);
var seq11463__$1 = cljs.core.next.call(null,seq11463);
var G__11465 = cljs.core.first.call(null,seq11463__$1);
var seq11463__$2 = cljs.core.next.call(null,seq11463__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11464,G__11465,seq11463__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__11490 = arguments.length;
switch (G__11490) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11492 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11492)){
var class_list_11493 = temp__4124__auto___11492;
class_list_11493.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.call(null,elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_.call(null,elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.call(null,elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.call(null,elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p__11496){
var vec__11497 = p__11496;
var k = cljs.core.nth.call(null,vec__11497,(0),null);
var v = cljs.core.nth.call(null,vec__11497,(1),null);
return [cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str(":"),cljs.core.str(cljs.core.name.call(null,v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var style = elem__$1.style;
var seq__11500_11506 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11501_11507 = null;
var count__11502_11508 = (0);
var i__11503_11509 = (0);
while(true){
if((i__11503_11509 < count__11502_11508)){
var vec__11504_11510 = cljs.core._nth.call(null,chunk__11501_11507,i__11503_11509);
var k_11511 = cljs.core.nth.call(null,vec__11504_11510,(0),null);
var v_11512 = cljs.core.nth.call(null,vec__11504_11510,(1),null);
(style[cljs.core.name.call(null,k_11511)] = v_11512);

var G__11513 = seq__11500_11506;
var G__11514 = chunk__11501_11507;
var G__11515 = count__11502_11508;
var G__11516 = (i__11503_11509 + (1));
seq__11500_11506 = G__11513;
chunk__11501_11507 = G__11514;
count__11502_11508 = G__11515;
i__11503_11509 = G__11516;
continue;
} else {
var temp__4126__auto___11517 = cljs.core.seq.call(null,seq__11500_11506);
if(temp__4126__auto___11517){
var seq__11500_11518__$1 = temp__4126__auto___11517;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11500_11518__$1)){
var c__5061__auto___11519 = cljs.core.chunk_first.call(null,seq__11500_11518__$1);
var G__11520 = cljs.core.chunk_rest.call(null,seq__11500_11518__$1);
var G__11521 = c__5061__auto___11519;
var G__11522 = cljs.core.count.call(null,c__5061__auto___11519);
var G__11523 = (0);
seq__11500_11506 = G__11520;
chunk__11501_11507 = G__11521;
count__11502_11508 = G__11522;
i__11503_11509 = G__11523;
continue;
} else {
var vec__11505_11524 = cljs.core.first.call(null,seq__11500_11518__$1);
var k_11525 = cljs.core.nth.call(null,vec__11505_11524,(0),null);
var v_11526 = cljs.core.nth.call(null,vec__11505_11524,(1),null);
(style[cljs.core.name.call(null,k_11525)] = v_11526);

var G__11527 = cljs.core.next.call(null,seq__11500_11518__$1);
var G__11528 = null;
var G__11529 = (0);
var G__11530 = (0);
seq__11500_11506 = G__11527;
chunk__11501_11507 = G__11528;
count__11502_11508 = G__11529;
i__11503_11509 = G__11530;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq11498){
var G__11499 = cljs.core.first.call(null,seq11498);
var seq11498__$1 = cljs.core.next.call(null,seq11498);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11499,seq11498__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"k","k",-505765866,null)))].join('')));
}

return (window.getComputedStyle(dommy.template.__GT_node_like.call(null,elem))[cljs.core.name.call(null,k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11533_11539 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11534_11540 = null;
var count__11535_11541 = (0);
var i__11536_11542 = (0);
while(true){
if((i__11536_11542 < count__11535_11541)){
var vec__11537_11543 = cljs.core._nth.call(null,chunk__11534_11540,i__11536_11542);
var k_11544 = cljs.core.nth.call(null,vec__11537_11543,(0),null);
var v_11545 = cljs.core.nth.call(null,vec__11537_11543,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11544,[cljs.core.str(v_11545),cljs.core.str("px")].join(''));

var G__11546 = seq__11533_11539;
var G__11547 = chunk__11534_11540;
var G__11548 = count__11535_11541;
var G__11549 = (i__11536_11542 + (1));
seq__11533_11539 = G__11546;
chunk__11534_11540 = G__11547;
count__11535_11541 = G__11548;
i__11536_11542 = G__11549;
continue;
} else {
var temp__4126__auto___11550 = cljs.core.seq.call(null,seq__11533_11539);
if(temp__4126__auto___11550){
var seq__11533_11551__$1 = temp__4126__auto___11550;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11533_11551__$1)){
var c__5061__auto___11552 = cljs.core.chunk_first.call(null,seq__11533_11551__$1);
var G__11553 = cljs.core.chunk_rest.call(null,seq__11533_11551__$1);
var G__11554 = c__5061__auto___11552;
var G__11555 = cljs.core.count.call(null,c__5061__auto___11552);
var G__11556 = (0);
seq__11533_11539 = G__11553;
chunk__11534_11540 = G__11554;
count__11535_11541 = G__11555;
i__11536_11542 = G__11556;
continue;
} else {
var vec__11538_11557 = cljs.core.first.call(null,seq__11533_11551__$1);
var k_11558 = cljs.core.nth.call(null,vec__11538_11557,(0),null);
var v_11559 = cljs.core.nth.call(null,vec__11538_11557,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11558,[cljs.core.str(v_11559),cljs.core.str("px")].join(''));

var G__11560 = cljs.core.next.call(null,seq__11533_11551__$1);
var G__11561 = null;
var G__11562 = (0);
var G__11563 = (0);
seq__11533_11539 = G__11560;
chunk__11534_11540 = G__11561;
count__11535_11541 = G__11562;
i__11536_11542 = G__11563;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq11531){
var G__11532 = cljs.core.first.call(null,seq11531);
var seq11531__$1 = cljs.core.next.call(null,seq11531);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11532,seq11531__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style.call(null,dommy.template.__GT_node_like.call(null,elem),k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__11569 = arguments.length;
switch (G__11569) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.call(null,dommy.template.__GT_node_like.call(null,elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__11570 = dommy.template.__GT_node_like.call(null,elem);
(G__11570[cljs.core.name.call(null,k)] = v);

return G__11570;
} else {
var G__11571 = dommy.template.__GT_node_like.call(null,elem);
G__11571.setAttribute(cljs.core.name.call(null,k),(((k === new cljs.core.Keyword(null,"style","style",-496642736)))?dommy.attrs.style_str.call(null,v):v));

return G__11571;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11572_11579 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__11573_11580 = null;
var count__11574_11581 = (0);
var i__11575_11582 = (0);
while(true){
if((i__11575_11582 < count__11574_11581)){
var vec__11576_11583 = cljs.core._nth.call(null,chunk__11573_11580,i__11575_11582);
var k_11584__$1 = cljs.core.nth.call(null,vec__11576_11583,(0),null);
var v_11585__$1 = cljs.core.nth.call(null,vec__11576_11583,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11584__$1,v_11585__$1);

var G__11586 = seq__11572_11579;
var G__11587 = chunk__11573_11580;
var G__11588 = count__11574_11581;
var G__11589 = (i__11575_11582 + (1));
seq__11572_11579 = G__11586;
chunk__11573_11580 = G__11587;
count__11574_11581 = G__11588;
i__11575_11582 = G__11589;
continue;
} else {
var temp__4126__auto___11590 = cljs.core.seq.call(null,seq__11572_11579);
if(temp__4126__auto___11590){
var seq__11572_11591__$1 = temp__4126__auto___11590;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11572_11591__$1)){
var c__5061__auto___11592 = cljs.core.chunk_first.call(null,seq__11572_11591__$1);
var G__11593 = cljs.core.chunk_rest.call(null,seq__11572_11591__$1);
var G__11594 = c__5061__auto___11592;
var G__11595 = cljs.core.count.call(null,c__5061__auto___11592);
var G__11596 = (0);
seq__11572_11579 = G__11593;
chunk__11573_11580 = G__11594;
count__11574_11581 = G__11595;
i__11575_11582 = G__11596;
continue;
} else {
var vec__11577_11597 = cljs.core.first.call(null,seq__11572_11591__$1);
var k_11598__$1 = cljs.core.nth.call(null,vec__11577_11597,(0),null);
var v_11599__$1 = cljs.core.nth.call(null,vec__11577_11597,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11598__$1,v_11599__$1);

var G__11600 = cljs.core.next.call(null,seq__11572_11591__$1);
var G__11601 = null;
var G__11602 = (0);
var G__11603 = (0);
seq__11572_11579 = G__11600;
chunk__11573_11580 = G__11601;
count__11574_11581 = G__11602;
i__11575_11582 = G__11603;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq11564){
var G__11565 = cljs.core.first.call(null,seq11564);
var seq11564__$1 = cljs.core.next.call(null,seq11564);
var G__11566 = cljs.core.first.call(null,seq11564__$1);
var seq11564__$2 = cljs.core.next.call(null,seq11564__$1);
var G__11567 = cljs.core.first.call(null,seq11564__$2);
var seq11564__$3 = cljs.core.next.call(null,seq11564__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11565,G__11566,G__11567,seq11564__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__11608 = arguments.length;
switch (G__11608) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),null,new cljs.core.Keyword(null,"classes","classes",2037804510),null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name.call(null,k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11609_11614 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__11610_11615 = null;
var count__11611_11616 = (0);
var i__11612_11617 = (0);
while(true){
if((i__11612_11617 < count__11611_11616)){
var k_11618__$1 = cljs.core._nth.call(null,chunk__11610_11615,i__11612_11617);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11618__$1);

var G__11619 = seq__11609_11614;
var G__11620 = chunk__11610_11615;
var G__11621 = count__11611_11616;
var G__11622 = (i__11612_11617 + (1));
seq__11609_11614 = G__11619;
chunk__11610_11615 = G__11620;
count__11611_11616 = G__11621;
i__11612_11617 = G__11622;
continue;
} else {
var temp__4126__auto___11623 = cljs.core.seq.call(null,seq__11609_11614);
if(temp__4126__auto___11623){
var seq__11609_11624__$1 = temp__4126__auto___11623;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11609_11624__$1)){
var c__5061__auto___11625 = cljs.core.chunk_first.call(null,seq__11609_11624__$1);
var G__11626 = cljs.core.chunk_rest.call(null,seq__11609_11624__$1);
var G__11627 = c__5061__auto___11625;
var G__11628 = cljs.core.count.call(null,c__5061__auto___11625);
var G__11629 = (0);
seq__11609_11614 = G__11626;
chunk__11610_11615 = G__11627;
count__11611_11616 = G__11628;
i__11612_11617 = G__11629;
continue;
} else {
var k_11630__$1 = cljs.core.first.call(null,seq__11609_11624__$1);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11630__$1);

var G__11631 = cljs.core.next.call(null,seq__11609_11624__$1);
var G__11632 = null;
var G__11633 = (0);
var G__11634 = (0);
seq__11609_11614 = G__11631;
chunk__11610_11615 = G__11632;
count__11611_11616 = G__11633;
i__11612_11617 = G__11634;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq11604){
var G__11605 = cljs.core.first.call(null,seq11604);
var seq11604__$1 = cljs.core.next.call(null,seq11604);
var G__11606 = cljs.core.first.call(null,seq11604__$1);
var seq11604__$2 = cljs.core.next.call(null,seq11604__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11605,G__11606,seq11604__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like.call(null,elem).getAttribute(cljs.core.name.call(null,k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__11636 = arguments.length;
switch (G__11636) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.attrs.attr.call(null,elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.call(null,elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like.call(null,elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__11639 = arguments.length;
switch (G__11639) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__11640 = dommy.template.__GT_node_like.call(null,elem);
G__11640.style.display = ((show_QMARK_)?"":"none");

return G__11640;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,elem__$1,dommy.attrs.hidden_QMARK_.call(null,elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__11643 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11643,false);

return G__11643;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__11645 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11645,true);

return G__11645;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.call(null,(function (){var G__11647 = dommy.template.__GT_node_like.call(null,elem).getBoundingClientRect();
(G__11647["constructor"] = Object);

return G__11647;
})(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect.call(null,elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
