// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq42529){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42529));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq42530){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42530));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__42533){
var vec__42534 = p__42533;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42534,(0),null);

var G__42535 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__42535) : milia.api.io.raw_request.call(null,G__42535));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq42531){
var G__42532 = cljs.core.first(seq42531);
var seq42531__$1 = cljs.core.next(seq42531);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__42532,seq42531__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__42538){
var vec__42539 = p__42538;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42539,(0),null);

var G__42540 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__42540) : milia.api.io.raw_request.call(null,G__42540));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq42536){
var G__42537 = cljs.core.first(seq42536);
var seq42536__$1 = cljs.core.next(seq42536);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__42537,seq42536__$1);
});
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var G__42542 = arguments.length;
switch (G__42542) {
case 1:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,false);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__42543 = "csrftoken";
return goog.net.cookies.get(G__42543);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__42557 = null;
var G__42557__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__42557__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__42557__4 = (function() { 
var G__42558__delegate = function (url,query_params,token,p__42552){
var map__42553 = p__42552;
var map__42553__$1 = ((cljs.core.seq_QMARK_(map__42553))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42553):map__42553);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42553__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,token),cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__42554 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__42554) : cljs_hash.md5.md5.call(null,G__42554));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__42555 = url;
var G__42556 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__42555,G__42556) : http_method.call(null,G__42555,G__42556));
};
var G__42558 = function (url,query_params,token,var_args){
var p__42552 = null;
if (arguments.length > 3) {
var G__42559__i = 0, G__42559__a = new Array(arguments.length -  3);
while (G__42559__i < G__42559__a.length) {G__42559__a[G__42559__i] = arguments[G__42559__i + 3]; ++G__42559__i;}
  p__42552 = new cljs.core.IndexedSeq(G__42559__a,0);
} 
return G__42558__delegate.call(this,url,query_params,token,p__42552);};
G__42558.cljs$lang$maxFixedArity = 3;
G__42558.cljs$lang$applyTo = (function (arglist__42560){
var url = cljs.core.first(arglist__42560);
arglist__42560 = cljs.core.next(arglist__42560);
var query_params = cljs.core.first(arglist__42560);
arglist__42560 = cljs.core.next(arglist__42560);
var token = cljs.core.first(arglist__42560);
var p__42552 = cljs.core.rest(arglist__42560);
return G__42558__delegate(url,query_params,token,p__42552);
});
G__42558.cljs$core$IFn$_invoke$arity$variadic = G__42558__delegate;
return G__42558;
})()
;
G__42557 = function(url,query_params,token,var_args){
var p__42552 = var_args;
switch(arguments.length){
case 1:
return G__42557__1.call(this,url);
case 2:
return G__42557__2.call(this,url,query_params);
default:
var G__42561 = null;
if (arguments.length > 3) {
var G__42562__i = 0, G__42562__a = new Array(arguments.length -  3);
while (G__42562__i < G__42562__a.length) {G__42562__a[G__42562__i] = arguments[G__42562__i + 3]; ++G__42562__i;}
G__42561 = new cljs.core.IndexedSeq(G__42562__a,0);
}
return G__42557__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__42561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__42557.cljs$lang$maxFixedArity = 3;
G__42557.cljs$lang$applyTo = G__42557__4.cljs$lang$applyTo;
G__42557.cljs$core$IFn$_invoke$arity$1 = G__42557__1;
G__42557.cljs$core$IFn$_invoke$arity$2 = G__42557__2;
G__42557.cljs$core$IFn$_invoke$arity$variadic = G__42557__4.cljs$core$IFn$_invoke$arity$variadic;
return G__42557;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__42570 = arguments.length;
switch (G__42570) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42581){
var state_val_42582 = (state_42581[(1)]);
if((state_val_42582 === (5))){
var inst_42579 = (state_42581[(2)]);
var state_42581__$1 = state_42581;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42581__$1,inst_42579);
} else {
if((state_val_42582 === (4))){
var state_42581__$1 = state_42581;
var statearr_42583_42601 = state_42581__$1;
(statearr_42583_42601[(2)] = null);

(statearr_42583_42601[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42582 === (3))){
var inst_42574 = (state_42581[(7)]);
var inst_42576 = (function (){var G__42584 = inst_42574;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__42584) : callback.call(null,G__42584));
})();
var state_42581__$1 = state_42581;
var statearr_42585_42602 = state_42581__$1;
(statearr_42585_42602[(2)] = inst_42576);

(statearr_42585_42602[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42582 === (2))){
var inst_42574 = (state_42581[(2)]);
var state_42581__$1 = (function (){var statearr_42586 = state_42581;
(statearr_42586[(7)] = inst_42574);

return statearr_42586;
})();
if(cljs.core.truth_(callback)){
var statearr_42587_42603 = state_42581__$1;
(statearr_42587_42603[(1)] = (3));

} else {
var statearr_42588_42604 = state_42581__$1;
(statearr_42588_42604[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42582 === (1))){
var inst_42571 = milia.api.io.query_helper(method);
var inst_42572 = (function (){var G__42589 = url;
var G__42590 = query_params;
var G__42591 = token;
var G__42592 = opts;
return (inst_42571.cljs$core$IFn$_invoke$arity$4 ? inst_42571.cljs$core$IFn$_invoke$arity$4(G__42589,G__42590,G__42591,G__42592) : inst_42571.call(null,G__42589,G__42590,G__42591,G__42592));
})();
var state_42581__$1 = state_42581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42581__$1,(2),inst_42572);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_42596 = [null,null,null,null,null,null,null,null];
(statearr_42596[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_42596[(1)] = (1));

return statearr_42596;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_42581){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42581);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42597){if((e42597 instanceof Object)){
var ex__7651__auto__ = e42597;
var statearr_42598_42605 = state_42581;
(statearr_42598_42605[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42581);

return cljs.core.constant$keyword$recur;
} else {
throw e42597;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42606 = state_42581;
state_42581 = G__42606;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_42581){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_42581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42599 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq42563){
var G__42564 = cljs.core.first(seq42563);
var seq42563__$1 = cljs.core.next(seq42563);
var G__42565 = cljs.core.first(seq42563__$1);
var seq42563__$2 = cljs.core.next(seq42563__$1);
var G__42566 = cljs.core.first(seq42563__$2);
var seq42563__$3 = cljs.core.next(seq42563__$2);
var G__42567 = cljs.core.first(seq42563__$3);
var seq42563__$4 = cljs.core.next(seq42563__$3);
var G__42568 = cljs.core.first(seq42563__$4);
var seq42563__$5 = cljs.core.next(seq42563__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42564,G__42565,G__42566,G__42567,G__42568,seq42563__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__42608 = arguments.length;
switch (G__42608) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42609 = event.target;
var G__42610 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42609,G__42610) : dommy.core.attr.call(null,G__42609,G__42610));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__42611 = event.target.form;
var G__42612 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42611,G__42612) : dommy.core.attr.call(null,G__42611,G__42612));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__42615 = arguments.length;
switch (G__42615) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__42616 = event.target;
var G__42617 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__42616,G__42617) : dommy.core.attr.call(null,G__42616,G__42617));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_42752){
var state_val_42753 = (state_42752[(1)]);
if((state_val_42753 === (7))){
var inst_42717 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
var statearr_42754_42799 = state_42752__$1;
(statearr_42754_42799[(2)] = inst_42717);

(statearr_42754_42799[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (20))){
var state_42752__$1 = state_42752;
var statearr_42755_42800 = state_42752__$1;
(statearr_42755_42800[(2)] = null);

(statearr_42755_42800[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (1))){
var inst_42709 = (state_42752[(7)]);
var inst_42709__$1 = (auth_token == null);
var state_42752__$1 = (function (){var statearr_42756 = state_42752;
(statearr_42756[(7)] = inst_42709__$1);

return statearr_42756;
})();
if(cljs.core.truth_(inst_42709__$1)){
var statearr_42757_42801 = state_42752__$1;
(statearr_42757_42801[(1)] = (2));

} else {
var statearr_42758_42802 = state_42752__$1;
(statearr_42758_42802[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (4))){
var inst_42719 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
if(cljs.core.truth_(inst_42719)){
var statearr_42759_42803 = state_42752__$1;
(statearr_42759_42803[(1)] = (8));

} else {
var statearr_42760_42804 = state_42752__$1;
(statearr_42760_42804[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (15))){
var inst_42732 = (state_42752[(8)]);
var inst_42732__$1 = (state_42752[(2)]);
var inst_42733 = cljs.core.seq_QMARK_(inst_42732__$1);
var state_42752__$1 = (function (){var statearr_42761 = state_42752;
(statearr_42761[(8)] = inst_42732__$1);

return statearr_42761;
})();
if(inst_42733){
var statearr_42762_42805 = state_42752__$1;
(statearr_42762_42805[(1)] = (16));

} else {
var statearr_42763_42806 = state_42752__$1;
(statearr_42763_42806[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (21))){
var inst_42745 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
var statearr_42764_42807 = state_42752__$1;
(statearr_42764_42807[(2)] = inst_42745);

(statearr_42764_42807[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (13))){
var state_42752__$1 = state_42752;
var statearr_42765_42808 = state_42752__$1;
(statearr_42765_42808[(2)] = auth_token);

(statearr_42765_42808[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (6))){
var inst_42715 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_42752__$1 = state_42752;
var statearr_42766_42809 = state_42752__$1;
(statearr_42766_42809[(2)] = inst_42715);

(statearr_42766_42809[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (17))){
var inst_42732 = (state_42752[(8)]);
var state_42752__$1 = state_42752;
var statearr_42767_42810 = state_42752__$1;
(statearr_42767_42810[(2)] = inst_42732);

(statearr_42767_42810[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (3))){
var inst_42712 = (state_42752[(9)]);
var inst_42712__$1 = clojure.string.blank_QMARK_(auth_token);
var state_42752__$1 = (function (){var statearr_42768 = state_42752;
(statearr_42768[(9)] = inst_42712__$1);

return statearr_42768;
})();
if(cljs.core.truth_(inst_42712__$1)){
var statearr_42769_42811 = state_42752__$1;
(statearr_42769_42811[(1)] = (5));

} else {
var statearr_42770_42812 = state_42752__$1;
(statearr_42770_42812[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (12))){
var inst_42729 = milia.api.io.refresh_token_url(username);
var inst_42730 = (function (){var G__42771 = inst_42729;
var G__42772 = null;
var G__42773 = null;
var G__42774 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42775 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42771,G__42772,G__42773,G__42774,G__42775) : milia.api.io.get_url.call(null,G__42771,G__42772,G__42773,G__42774,G__42775));
})();
var state_42752__$1 = state_42752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42752__$1,(15),inst_42730);
} else {
if((state_val_42753 === (2))){
var inst_42709 = (state_42752[(7)]);
var state_42752__$1 = state_42752;
var statearr_42776_42813 = state_42752__$1;
(statearr_42776_42813[(2)] = inst_42709);

(statearr_42776_42813[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (19))){
var inst_42739 = (state_42752[(10)]);
var state_42752__$1 = state_42752;
var statearr_42777_42814 = state_42752__$1;
(statearr_42777_42814[(2)] = inst_42739);

(statearr_42777_42814[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (11))){
var inst_42725 = (state_42752[(2)]);
var inst_42726 = milia.api.io.invalid_token_QMARK_(inst_42725);
var state_42752__$1 = state_42752;
if(cljs.core.truth_(inst_42726)){
var statearr_42778_42815 = state_42752__$1;
(statearr_42778_42815[(1)] = (12));

} else {
var statearr_42779_42816 = state_42752__$1;
(statearr_42779_42816[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (9))){
var inst_42722 = milia.api.io.validate_token_url(username);
var inst_42723 = (function (){var G__42780 = inst_42722;
var G__42781 = null;
var G__42782 = null;
var G__42783 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__42784 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__42780,G__42781,G__42782,G__42783,G__42784) : milia.api.io.get_url.call(null,G__42780,G__42781,G__42782,G__42783,G__42784));
})();
var state_42752__$1 = state_42752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42752__$1,(11),inst_42723);
} else {
if((state_val_42753 === (5))){
var inst_42712 = (state_42752[(9)]);
var state_42752__$1 = state_42752;
var statearr_42785_42817 = state_42752__$1;
(statearr_42785_42817[(2)] = inst_42712);

(statearr_42785_42817[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (14))){
var inst_42748 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
var statearr_42786_42818 = state_42752__$1;
(statearr_42786_42818[(2)] = inst_42748);

(statearr_42786_42818[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (16))){
var inst_42732 = (state_42752[(8)]);
var inst_42735 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42732);
var state_42752__$1 = state_42752;
var statearr_42787_42819 = state_42752__$1;
(statearr_42787_42819[(2)] = inst_42735);

(statearr_42787_42819[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (10))){
var inst_42750 = (state_42752[(2)]);
var state_42752__$1 = state_42752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42752__$1,inst_42750);
} else {
if((state_val_42753 === (18))){
var inst_42738 = (state_42752[(2)]);
var inst_42739 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42738,cljs.core.constant$keyword$body);
var inst_42740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42738,cljs.core.constant$keyword$status);
var inst_42741 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42740,(200));
var state_42752__$1 = (function (){var statearr_42788 = state_42752;
(statearr_42788[(10)] = inst_42739);

return statearr_42788;
})();
if(inst_42741){
var statearr_42789_42820 = state_42752__$1;
(statearr_42789_42820[(1)] = (19));

} else {
var statearr_42790_42821 = state_42752__$1;
(statearr_42790_42821[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_42753 === (8))){
var state_42752__$1 = state_42752;
var statearr_42791_42822 = state_42752__$1;
(statearr_42791_42822[(2)] = null);

(statearr_42791_42822[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_42795 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42795[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_42795[(1)] = (1));

return statearr_42795;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_42752){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_42752);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e42796){if((e42796 instanceof Object)){
var ex__7651__auto__ = e42796;
var statearr_42797_42823 = state_42752;
(statearr_42797_42823[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42752);

return cljs.core.constant$keyword$recur;
} else {
throw e42796;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__42824 = state_42752;
state_42752 = G__42824;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_42752){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_42752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_42798 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_42798[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_42798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__42831_42837 = io_obj;
var G__42832_42838 = goog.net.EventType.SUCCESS;
var G__42833_42839 = ((function (G__42831_42837,G__42832_42838,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42831_42837,G__42832_42838,io_obj,url))
;
goog.events.listen(G__42831_42837,G__42832_42838,G__42833_42839);

var G__42834_42840 = io_obj;
var G__42835_42841 = goog.net.EventType.ERROR;
var G__42836_42842 = ((function (G__42834_42840,G__42835_42841,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__42834_42840,G__42835_42841,io_obj,url))
;
goog.events.listen(G__42834_42840,G__42835_42841,G__42836_42842);

return io_obj.sendFromForm(form,url);
});
