// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like.call(null,elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__11035 = arguments.length;
switch (G__11035) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__11036 = dommy.template.__GT_node_like.call(null,parent);
G__11036.appendChild(dommy.template.__GT_node_like.call(null,child));

return G__11036;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11037_11042 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11038_11043 = null;
var count__11039_11044 = (0);
var i__11040_11045 = (0);
while(true){
if((i__11040_11045 < count__11039_11044)){
var c_11046 = cljs.core._nth.call(null,chunk__11038_11043,i__11040_11045);
dommy.core.append_BANG_.call(null,parent__$1,c_11046);

var G__11047 = seq__11037_11042;
var G__11048 = chunk__11038_11043;
var G__11049 = count__11039_11044;
var G__11050 = (i__11040_11045 + (1));
seq__11037_11042 = G__11047;
chunk__11038_11043 = G__11048;
count__11039_11044 = G__11049;
i__11040_11045 = G__11050;
continue;
} else {
var temp__4126__auto___11051 = cljs.core.seq.call(null,seq__11037_11042);
if(temp__4126__auto___11051){
var seq__11037_11052__$1 = temp__4126__auto___11051;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11037_11052__$1)){
var c__5061__auto___11053 = cljs.core.chunk_first.call(null,seq__11037_11052__$1);
var G__11054 = cljs.core.chunk_rest.call(null,seq__11037_11052__$1);
var G__11055 = c__5061__auto___11053;
var G__11056 = cljs.core.count.call(null,c__5061__auto___11053);
var G__11057 = (0);
seq__11037_11042 = G__11054;
chunk__11038_11043 = G__11055;
count__11039_11044 = G__11056;
i__11040_11045 = G__11057;
continue;
} else {
var c_11058 = cljs.core.first.call(null,seq__11037_11052__$1);
dommy.core.append_BANG_.call(null,parent__$1,c_11058);

var G__11059 = cljs.core.next.call(null,seq__11037_11052__$1);
var G__11060 = null;
var G__11061 = (0);
var G__11062 = (0);
seq__11037_11042 = G__11059;
chunk__11038_11043 = G__11060;
count__11039_11044 = G__11061;
i__11040_11045 = G__11062;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq11031){
var G__11032 = cljs.core.first.call(null,seq11031);
var seq11031__$1 = cljs.core.next.call(null,seq11031);
var G__11033 = cljs.core.first.call(null,seq11031__$1);
var seq11031__$2 = cljs.core.next.call(null,seq11031__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11032,G__11033,seq11031__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__11067 = arguments.length;
switch (G__11067) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like.call(null,child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11068_11073 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11069_11074 = null;
var count__11070_11075 = (0);
var i__11071_11076 = (0);
while(true){
if((i__11071_11076 < count__11070_11075)){
var c_11077 = cljs.core._nth.call(null,chunk__11069_11074,i__11071_11076);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11077);

var G__11078 = seq__11068_11073;
var G__11079 = chunk__11069_11074;
var G__11080 = count__11070_11075;
var G__11081 = (i__11071_11076 + (1));
seq__11068_11073 = G__11078;
chunk__11069_11074 = G__11079;
count__11070_11075 = G__11080;
i__11071_11076 = G__11081;
continue;
} else {
var temp__4126__auto___11082 = cljs.core.seq.call(null,seq__11068_11073);
if(temp__4126__auto___11082){
var seq__11068_11083__$1 = temp__4126__auto___11082;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11068_11083__$1)){
var c__5061__auto___11084 = cljs.core.chunk_first.call(null,seq__11068_11083__$1);
var G__11085 = cljs.core.chunk_rest.call(null,seq__11068_11083__$1);
var G__11086 = c__5061__auto___11084;
var G__11087 = cljs.core.count.call(null,c__5061__auto___11084);
var G__11088 = (0);
seq__11068_11073 = G__11085;
chunk__11069_11074 = G__11086;
count__11070_11075 = G__11087;
i__11071_11076 = G__11088;
continue;
} else {
var c_11089 = cljs.core.first.call(null,seq__11068_11083__$1);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11089);

var G__11090 = cljs.core.next.call(null,seq__11068_11083__$1);
var G__11091 = null;
var G__11092 = (0);
var G__11093 = (0);
seq__11068_11073 = G__11090;
chunk__11069_11074 = G__11091;
count__11070_11075 = G__11092;
i__11071_11076 = G__11093;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq11063){
var G__11064 = cljs.core.first.call(null,seq11063);
var seq11063__$1 = cljs.core.next.call(null,seq11063);
var G__11065 = cljs.core.first.call(null,seq11063__$1);
var seq11063__$2 = cljs.core.next.call(null,seq11063__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11064,G__11065,seq11063__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
var parent = other__$1.parentNode;
var temp__4124__auto___11094 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___11094)){
var next_11095 = temp__4124__auto___11094;
parent.insertBefore(actual_node,next_11095);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like.call(null,new$);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__11097 = dommy.template.__GT_node_like.call(null,parent);
G__11097.innerHTML = "";

dommy.core.append_BANG_.call(null,G__11097,node_like);

return G__11097;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var G__11099 = elem__$1.parentNode;
G__11099.removeChild(elem__$1);

return G__11099;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like.call(null,template);
if(!(cljs.core.contains_QMARK_.call(null,key_selectors_map,new cljs.core.Keyword(null,"container","container",-1736937707)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),new cljs.core.Keyword(null,"container","container",-1736937707)))))].join('')));
}

return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container","container",-1736937707),container], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (container){
return (function (p__11105){
var vec__11106 = p__11105;
var k = cljs.core.nth.call(null,vec__11106,(0),null);
var v = cljs.core.nth.call(null,vec__11106,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(new cljs.core.Keyword(null,"live","live",-1610148039).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))?(function (){
if(typeof dommy.core.t11107 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t11107 = (function (v,k,vec__11106,p__11105,container,key_selectors_map,template,selector_map,meta11108){
this.v = v;
this.k = k;
this.vec__11106 = vec__11106;
this.p__11105 = p__11105;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta11108 = meta11108;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t11107.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__11106,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,self__.container).querySelectorAll(dommy.core.selector.call(null,self__.v)));
});})(vec__11106,k,v,container))
;

dommy.core.t11107.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__11106,k,v,container){
return (function (_11109){
var self__ = this;
var _11109__$1 = this;
return self__.meta11108;
});})(vec__11106,k,v,container))
;

dommy.core.t11107.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__11106,k,v,container){
return (function (_11109,meta11108__$1){
var self__ = this;
var _11109__$1 = this;
return (new dommy.core.t11107(self__.v,self__.k,self__.vec__11106,self__.p__11105,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta11108__$1));
});})(vec__11106,k,v,container))
;

dommy.core.t11107.cljs$lang$type = true;

dommy.core.t11107.cljs$lang$ctorStr = "dommy.core/t11107";

dommy.core.t11107.cljs$lang$ctorPrWriter = ((function (vec__11106,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"dommy.core/t11107");
});})(vec__11106,k,v,container))
;

dommy.core.__GT_t11107 = ((function (vec__11106,k,v,container){
return (function dommy$core$selector_map_$___GT_t11107(v__$1,k__$1,vec__11106__$1,p__11105__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11108){
return (new dommy.core.t11107(v__$1,k__$1,vec__11106__$1,p__11105__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11108));
});})(vec__11106,k,v,container))
;

}

return (new dommy.core.t11107(v,k,vec__11106,p__11105,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like.call(null,container).querySelector(dommy.core.selector.call(null,v)))], null);
});})(container))
,key_selectors_map)));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,(function (p1__11110_SHARP_){
return p1__11110_SHARP_.parentNode;
}),dommy.template.__GT_node_like.call(null,elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__11112 = arguments.length;
switch (G__11112) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,dommy.template.__GT_node_like.call(null,base)).querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__11116 = arguments.length;
switch (G__11116) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like.call(null,base);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base__$1,selector),cljs.core.take_while.call(null,((function (base__$1,elem__$1){
return (function (p1__11114_SHARP_){
return !((p1__11114_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes.call(null,elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,selector),dommy.core.ancestor_nodes.call(null,dommy.template.__GT_node_like.call(null,elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like.call(null,descendant);
var ancestor__$1 = dommy.template.__GT_node_like.call(null,ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__11118){
var vec__11119 = p__11118;
var special_mouse_event = cljs.core.nth.call(null,vec__11119,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__11119,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__11119,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__11119,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__11119,special_mouse_event,real_mouse_event))
});})(vec__11119,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,dommy.template.__GT_node_like.call(null,elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like.call(null,elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq11120){
var G__11121 = cljs.core.first.call(null,seq11120);
var seq11120__$1 = cljs.core.next.call(null,seq11120);
var G__11122 = cljs.core.first.call(null,seq11120__$1);
var seq11120__$2 = cljs.core.next.call(null,seq11120__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11121,G__11122,seq11120__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,(function (p1__11123_SHARP_){
return dommy.template.__GT_node_like.call(null,cljs.core.first.call(null,p1__11123_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like.call(null,elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11126_11149 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11150 = cljs.core.nth.call(null,vec__11126_11149,(0),null);
var selector_11151 = cljs.core.nth.call(null,vec__11126_11149,(1),null);
var seq__11127_11152 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11134_11153 = null;
var count__11135_11154 = (0);
var i__11136_11155 = (0);
while(true){
if((i__11136_11155 < count__11135_11154)){
var vec__11143_11156 = cljs.core._nth.call(null,chunk__11134_11153,i__11136_11155);
var orig_type_11157 = cljs.core.nth.call(null,vec__11143_11156,(0),null);
var f_11158 = cljs.core.nth.call(null,vec__11143_11156,(1),null);
var seq__11137_11159 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11157,new cljs.core.PersistentArrayMap.fromArray([orig_type_11157,cljs.core.identity], true, false)));
var chunk__11139_11160 = null;
var count__11140_11161 = (0);
var i__11141_11162 = (0);
while(true){
if((i__11141_11162 < count__11140_11161)){
var vec__11144_11163 = cljs.core._nth.call(null,chunk__11139_11160,i__11141_11162);
var actual_type_11164 = cljs.core.nth.call(null,vec__11144_11163,(0),null);
var factory_11165 = cljs.core.nth.call(null,vec__11144_11163,(1),null);
var canonical_f_11166 = (cljs.core.truth_(selector_11151)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11150,selector_11151):cljs.core.identity).call(null,factory_11165.call(null,f_11158));
dommy.core.update_event_listeners_BANG_.call(null,elem_11150,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11151,actual_type_11164,f_11158], null),canonical_f_11166);

if(cljs.core.truth_(elem_11150.addEventListener)){
elem_11150.addEventListener(cljs.core.name.call(null,actual_type_11164),canonical_f_11166);
} else {
elem_11150.attachEvent(cljs.core.name.call(null,actual_type_11164),canonical_f_11166);
}

var G__11167 = seq__11137_11159;
var G__11168 = chunk__11139_11160;
var G__11169 = count__11140_11161;
var G__11170 = (i__11141_11162 + (1));
seq__11137_11159 = G__11167;
chunk__11139_11160 = G__11168;
count__11140_11161 = G__11169;
i__11141_11162 = G__11170;
continue;
} else {
var temp__4126__auto___11171 = cljs.core.seq.call(null,seq__11137_11159);
if(temp__4126__auto___11171){
var seq__11137_11172__$1 = temp__4126__auto___11171;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11137_11172__$1)){
var c__5061__auto___11173 = cljs.core.chunk_first.call(null,seq__11137_11172__$1);
var G__11174 = cljs.core.chunk_rest.call(null,seq__11137_11172__$1);
var G__11175 = c__5061__auto___11173;
var G__11176 = cljs.core.count.call(null,c__5061__auto___11173);
var G__11177 = (0);
seq__11137_11159 = G__11174;
chunk__11139_11160 = G__11175;
count__11140_11161 = G__11176;
i__11141_11162 = G__11177;
continue;
} else {
var vec__11145_11178 = cljs.core.first.call(null,seq__11137_11172__$1);
var actual_type_11179 = cljs.core.nth.call(null,vec__11145_11178,(0),null);
var factory_11180 = cljs.core.nth.call(null,vec__11145_11178,(1),null);
var canonical_f_11181 = (cljs.core.truth_(selector_11151)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11150,selector_11151):cljs.core.identity).call(null,factory_11180.call(null,f_11158));
dommy.core.update_event_listeners_BANG_.call(null,elem_11150,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11151,actual_type_11179,f_11158], null),canonical_f_11181);

if(cljs.core.truth_(elem_11150.addEventListener)){
elem_11150.addEventListener(cljs.core.name.call(null,actual_type_11179),canonical_f_11181);
} else {
elem_11150.attachEvent(cljs.core.name.call(null,actual_type_11179),canonical_f_11181);
}

var G__11182 = cljs.core.next.call(null,seq__11137_11172__$1);
var G__11183 = null;
var G__11184 = (0);
var G__11185 = (0);
seq__11137_11159 = G__11182;
chunk__11139_11160 = G__11183;
count__11140_11161 = G__11184;
i__11141_11162 = G__11185;
continue;
}
} else {
}
}
break;
}

var G__11186 = seq__11127_11152;
var G__11187 = chunk__11134_11153;
var G__11188 = count__11135_11154;
var G__11189 = (i__11136_11155 + (1));
seq__11127_11152 = G__11186;
chunk__11134_11153 = G__11187;
count__11135_11154 = G__11188;
i__11136_11155 = G__11189;
continue;
} else {
var temp__4126__auto___11190 = cljs.core.seq.call(null,seq__11127_11152);
if(temp__4126__auto___11190){
var seq__11127_11191__$1 = temp__4126__auto___11190;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11127_11191__$1)){
var c__5061__auto___11192 = cljs.core.chunk_first.call(null,seq__11127_11191__$1);
var G__11193 = cljs.core.chunk_rest.call(null,seq__11127_11191__$1);
var G__11194 = c__5061__auto___11192;
var G__11195 = cljs.core.count.call(null,c__5061__auto___11192);
var G__11196 = (0);
seq__11127_11152 = G__11193;
chunk__11134_11153 = G__11194;
count__11135_11154 = G__11195;
i__11136_11155 = G__11196;
continue;
} else {
var vec__11146_11197 = cljs.core.first.call(null,seq__11127_11191__$1);
var orig_type_11198 = cljs.core.nth.call(null,vec__11146_11197,(0),null);
var f_11199 = cljs.core.nth.call(null,vec__11146_11197,(1),null);
var seq__11128_11200 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11198,new cljs.core.PersistentArrayMap.fromArray([orig_type_11198,cljs.core.identity], true, false)));
var chunk__11130_11201 = null;
var count__11131_11202 = (0);
var i__11132_11203 = (0);
while(true){
if((i__11132_11203 < count__11131_11202)){
var vec__11147_11204 = cljs.core._nth.call(null,chunk__11130_11201,i__11132_11203);
var actual_type_11205 = cljs.core.nth.call(null,vec__11147_11204,(0),null);
var factory_11206 = cljs.core.nth.call(null,vec__11147_11204,(1),null);
var canonical_f_11207 = (cljs.core.truth_(selector_11151)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11150,selector_11151):cljs.core.identity).call(null,factory_11206.call(null,f_11199));
dommy.core.update_event_listeners_BANG_.call(null,elem_11150,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11151,actual_type_11205,f_11199], null),canonical_f_11207);

if(cljs.core.truth_(elem_11150.addEventListener)){
elem_11150.addEventListener(cljs.core.name.call(null,actual_type_11205),canonical_f_11207);
} else {
elem_11150.attachEvent(cljs.core.name.call(null,actual_type_11205),canonical_f_11207);
}

var G__11208 = seq__11128_11200;
var G__11209 = chunk__11130_11201;
var G__11210 = count__11131_11202;
var G__11211 = (i__11132_11203 + (1));
seq__11128_11200 = G__11208;
chunk__11130_11201 = G__11209;
count__11131_11202 = G__11210;
i__11132_11203 = G__11211;
continue;
} else {
var temp__4126__auto___11212__$1 = cljs.core.seq.call(null,seq__11128_11200);
if(temp__4126__auto___11212__$1){
var seq__11128_11213__$1 = temp__4126__auto___11212__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11128_11213__$1)){
var c__5061__auto___11214 = cljs.core.chunk_first.call(null,seq__11128_11213__$1);
var G__11215 = cljs.core.chunk_rest.call(null,seq__11128_11213__$1);
var G__11216 = c__5061__auto___11214;
var G__11217 = cljs.core.count.call(null,c__5061__auto___11214);
var G__11218 = (0);
seq__11128_11200 = G__11215;
chunk__11130_11201 = G__11216;
count__11131_11202 = G__11217;
i__11132_11203 = G__11218;
continue;
} else {
var vec__11148_11219 = cljs.core.first.call(null,seq__11128_11213__$1);
var actual_type_11220 = cljs.core.nth.call(null,vec__11148_11219,(0),null);
var factory_11221 = cljs.core.nth.call(null,vec__11148_11219,(1),null);
var canonical_f_11222 = (cljs.core.truth_(selector_11151)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11150,selector_11151):cljs.core.identity).call(null,factory_11221.call(null,f_11199));
dommy.core.update_event_listeners_BANG_.call(null,elem_11150,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11151,actual_type_11220,f_11199], null),canonical_f_11222);

if(cljs.core.truth_(elem_11150.addEventListener)){
elem_11150.addEventListener(cljs.core.name.call(null,actual_type_11220),canonical_f_11222);
} else {
elem_11150.attachEvent(cljs.core.name.call(null,actual_type_11220),canonical_f_11222);
}

var G__11223 = cljs.core.next.call(null,seq__11128_11213__$1);
var G__11224 = null;
var G__11225 = (0);
var G__11226 = (0);
seq__11128_11200 = G__11223;
chunk__11130_11201 = G__11224;
count__11131_11202 = G__11225;
i__11132_11203 = G__11226;
continue;
}
} else {
}
}
break;
}

var G__11227 = cljs.core.next.call(null,seq__11127_11191__$1);
var G__11228 = null;
var G__11229 = (0);
var G__11230 = (0);
seq__11127_11152 = G__11227;
chunk__11134_11153 = G__11228;
count__11135_11154 = G__11229;
i__11136_11155 = G__11230;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq11124){
var G__11125 = cljs.core.first.call(null,seq11124);
var seq11124__$1 = cljs.core.next.call(null,seq11124);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11125,seq11124__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11233_11256 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11257 = cljs.core.nth.call(null,vec__11233_11256,(0),null);
var selector_11258 = cljs.core.nth.call(null,vec__11233_11256,(1),null);
var seq__11234_11259 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11241_11260 = null;
var count__11242_11261 = (0);
var i__11243_11262 = (0);
while(true){
if((i__11243_11262 < count__11242_11261)){
var vec__11250_11263 = cljs.core._nth.call(null,chunk__11241_11260,i__11243_11262);
var orig_type_11264 = cljs.core.nth.call(null,vec__11250_11263,(0),null);
var f_11265 = cljs.core.nth.call(null,vec__11250_11263,(1),null);
var seq__11244_11266 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11264,new cljs.core.PersistentArrayMap.fromArray([orig_type_11264,cljs.core.identity], true, false)));
var chunk__11246_11267 = null;
var count__11247_11268 = (0);
var i__11248_11269 = (0);
while(true){
if((i__11248_11269 < count__11247_11268)){
var vec__11251_11270 = cljs.core._nth.call(null,chunk__11246_11267,i__11248_11269);
var actual_type_11271 = cljs.core.nth.call(null,vec__11251_11270,(0),null);
var __11272 = cljs.core.nth.call(null,vec__11251_11270,(1),null);
var keys_11273 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11258,actual_type_11271,f_11265], null);
var canonical_f_11274 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11257),keys_11273);
dommy.core.update_event_listeners_BANG_.call(null,elem_11257,dommy.utils.dissoc_in,keys_11273);

if(cljs.core.truth_(elem_11257.removeEventListener)){
elem_11257.removeEventListener(cljs.core.name.call(null,actual_type_11271),canonical_f_11274);
} else {
elem_11257.detachEvent(cljs.core.name.call(null,actual_type_11271),canonical_f_11274);
}

var G__11275 = seq__11244_11266;
var G__11276 = chunk__11246_11267;
var G__11277 = count__11247_11268;
var G__11278 = (i__11248_11269 + (1));
seq__11244_11266 = G__11275;
chunk__11246_11267 = G__11276;
count__11247_11268 = G__11277;
i__11248_11269 = G__11278;
continue;
} else {
var temp__4126__auto___11279 = cljs.core.seq.call(null,seq__11244_11266);
if(temp__4126__auto___11279){
var seq__11244_11280__$1 = temp__4126__auto___11279;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11244_11280__$1)){
var c__5061__auto___11281 = cljs.core.chunk_first.call(null,seq__11244_11280__$1);
var G__11282 = cljs.core.chunk_rest.call(null,seq__11244_11280__$1);
var G__11283 = c__5061__auto___11281;
var G__11284 = cljs.core.count.call(null,c__5061__auto___11281);
var G__11285 = (0);
seq__11244_11266 = G__11282;
chunk__11246_11267 = G__11283;
count__11247_11268 = G__11284;
i__11248_11269 = G__11285;
continue;
} else {
var vec__11252_11286 = cljs.core.first.call(null,seq__11244_11280__$1);
var actual_type_11287 = cljs.core.nth.call(null,vec__11252_11286,(0),null);
var __11288 = cljs.core.nth.call(null,vec__11252_11286,(1),null);
var keys_11289 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11258,actual_type_11287,f_11265], null);
var canonical_f_11290 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11257),keys_11289);
dommy.core.update_event_listeners_BANG_.call(null,elem_11257,dommy.utils.dissoc_in,keys_11289);

if(cljs.core.truth_(elem_11257.removeEventListener)){
elem_11257.removeEventListener(cljs.core.name.call(null,actual_type_11287),canonical_f_11290);
} else {
elem_11257.detachEvent(cljs.core.name.call(null,actual_type_11287),canonical_f_11290);
}

var G__11291 = cljs.core.next.call(null,seq__11244_11280__$1);
var G__11292 = null;
var G__11293 = (0);
var G__11294 = (0);
seq__11244_11266 = G__11291;
chunk__11246_11267 = G__11292;
count__11247_11268 = G__11293;
i__11248_11269 = G__11294;
continue;
}
} else {
}
}
break;
}

var G__11295 = seq__11234_11259;
var G__11296 = chunk__11241_11260;
var G__11297 = count__11242_11261;
var G__11298 = (i__11243_11262 + (1));
seq__11234_11259 = G__11295;
chunk__11241_11260 = G__11296;
count__11242_11261 = G__11297;
i__11243_11262 = G__11298;
continue;
} else {
var temp__4126__auto___11299 = cljs.core.seq.call(null,seq__11234_11259);
if(temp__4126__auto___11299){
var seq__11234_11300__$1 = temp__4126__auto___11299;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11234_11300__$1)){
var c__5061__auto___11301 = cljs.core.chunk_first.call(null,seq__11234_11300__$1);
var G__11302 = cljs.core.chunk_rest.call(null,seq__11234_11300__$1);
var G__11303 = c__5061__auto___11301;
var G__11304 = cljs.core.count.call(null,c__5061__auto___11301);
var G__11305 = (0);
seq__11234_11259 = G__11302;
chunk__11241_11260 = G__11303;
count__11242_11261 = G__11304;
i__11243_11262 = G__11305;
continue;
} else {
var vec__11253_11306 = cljs.core.first.call(null,seq__11234_11300__$1);
var orig_type_11307 = cljs.core.nth.call(null,vec__11253_11306,(0),null);
var f_11308 = cljs.core.nth.call(null,vec__11253_11306,(1),null);
var seq__11235_11309 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11307,new cljs.core.PersistentArrayMap.fromArray([orig_type_11307,cljs.core.identity], true, false)));
var chunk__11237_11310 = null;
var count__11238_11311 = (0);
var i__11239_11312 = (0);
while(true){
if((i__11239_11312 < count__11238_11311)){
var vec__11254_11313 = cljs.core._nth.call(null,chunk__11237_11310,i__11239_11312);
var actual_type_11314 = cljs.core.nth.call(null,vec__11254_11313,(0),null);
var __11315 = cljs.core.nth.call(null,vec__11254_11313,(1),null);
var keys_11316 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11258,actual_type_11314,f_11308], null);
var canonical_f_11317 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11257),keys_11316);
dommy.core.update_event_listeners_BANG_.call(null,elem_11257,dommy.utils.dissoc_in,keys_11316);

if(cljs.core.truth_(elem_11257.removeEventListener)){
elem_11257.removeEventListener(cljs.core.name.call(null,actual_type_11314),canonical_f_11317);
} else {
elem_11257.detachEvent(cljs.core.name.call(null,actual_type_11314),canonical_f_11317);
}

var G__11318 = seq__11235_11309;
var G__11319 = chunk__11237_11310;
var G__11320 = count__11238_11311;
var G__11321 = (i__11239_11312 + (1));
seq__11235_11309 = G__11318;
chunk__11237_11310 = G__11319;
count__11238_11311 = G__11320;
i__11239_11312 = G__11321;
continue;
} else {
var temp__4126__auto___11322__$1 = cljs.core.seq.call(null,seq__11235_11309);
if(temp__4126__auto___11322__$1){
var seq__11235_11323__$1 = temp__4126__auto___11322__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11235_11323__$1)){
var c__5061__auto___11324 = cljs.core.chunk_first.call(null,seq__11235_11323__$1);
var G__11325 = cljs.core.chunk_rest.call(null,seq__11235_11323__$1);
var G__11326 = c__5061__auto___11324;
var G__11327 = cljs.core.count.call(null,c__5061__auto___11324);
var G__11328 = (0);
seq__11235_11309 = G__11325;
chunk__11237_11310 = G__11326;
count__11238_11311 = G__11327;
i__11239_11312 = G__11328;
continue;
} else {
var vec__11255_11329 = cljs.core.first.call(null,seq__11235_11323__$1);
var actual_type_11330 = cljs.core.nth.call(null,vec__11255_11329,(0),null);
var __11331 = cljs.core.nth.call(null,vec__11255_11329,(1),null);
var keys_11332 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11258,actual_type_11330,f_11308], null);
var canonical_f_11333 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11257),keys_11332);
dommy.core.update_event_listeners_BANG_.call(null,elem_11257,dommy.utils.dissoc_in,keys_11332);

if(cljs.core.truth_(elem_11257.removeEventListener)){
elem_11257.removeEventListener(cljs.core.name.call(null,actual_type_11330),canonical_f_11333);
} else {
elem_11257.detachEvent(cljs.core.name.call(null,actual_type_11330),canonical_f_11333);
}

var G__11334 = cljs.core.next.call(null,seq__11235_11323__$1);
var G__11335 = null;
var G__11336 = (0);
var G__11337 = (0);
seq__11235_11309 = G__11334;
chunk__11237_11310 = G__11335;
count__11238_11311 = G__11336;
i__11239_11312 = G__11337;
continue;
}
} else {
}
}
break;
}

var G__11338 = cljs.core.next.call(null,seq__11234_11300__$1);
var G__11339 = null;
var G__11340 = (0);
var G__11341 = (0);
seq__11234_11259 = G__11338;
chunk__11241_11260 = G__11339;
count__11242_11261 = G__11340;
i__11243_11262 = G__11341;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq11231){
var G__11232 = cljs.core.first.call(null,seq11231);
var seq11231__$1 = cljs.core.next.call(null,seq11231);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11232,seq11231__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11344_11351 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11352 = cljs.core.nth.call(null,vec__11344_11351,(0),null);
var selector_11353 = cljs.core.nth.call(null,vec__11344_11351,(1),null);
var seq__11345_11354 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11346_11355 = null;
var count__11347_11356 = (0);
var i__11348_11357 = (0);
while(true){
if((i__11348_11357 < count__11347_11356)){
var vec__11349_11358 = cljs.core._nth.call(null,chunk__11346_11355,i__11348_11357);
var type_11359 = cljs.core.nth.call(null,vec__11349_11358,(0),null);
var f_11360 = cljs.core.nth.call(null,vec__11349_11358,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11359,((function (seq__11345_11354,chunk__11346_11355,count__11347_11356,i__11348_11357,vec__11349_11358,type_11359,f_11360,vec__11344_11351,elem_11352,selector_11353){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11359,dommy$core$this_fn);

return f_11360.call(null,e);
});})(seq__11345_11354,chunk__11346_11355,count__11347_11356,i__11348_11357,vec__11349_11358,type_11359,f_11360,vec__11344_11351,elem_11352,selector_11353))
);

var G__11361 = seq__11345_11354;
var G__11362 = chunk__11346_11355;
var G__11363 = count__11347_11356;
var G__11364 = (i__11348_11357 + (1));
seq__11345_11354 = G__11361;
chunk__11346_11355 = G__11362;
count__11347_11356 = G__11363;
i__11348_11357 = G__11364;
continue;
} else {
var temp__4126__auto___11365 = cljs.core.seq.call(null,seq__11345_11354);
if(temp__4126__auto___11365){
var seq__11345_11366__$1 = temp__4126__auto___11365;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11345_11366__$1)){
var c__5061__auto___11367 = cljs.core.chunk_first.call(null,seq__11345_11366__$1);
var G__11368 = cljs.core.chunk_rest.call(null,seq__11345_11366__$1);
var G__11369 = c__5061__auto___11367;
var G__11370 = cljs.core.count.call(null,c__5061__auto___11367);
var G__11371 = (0);
seq__11345_11354 = G__11368;
chunk__11346_11355 = G__11369;
count__11347_11356 = G__11370;
i__11348_11357 = G__11371;
continue;
} else {
var vec__11350_11372 = cljs.core.first.call(null,seq__11345_11366__$1);
var type_11373 = cljs.core.nth.call(null,vec__11350_11372,(0),null);
var f_11374 = cljs.core.nth.call(null,vec__11350_11372,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11373,((function (seq__11345_11354,chunk__11346_11355,count__11347_11356,i__11348_11357,vec__11350_11372,type_11373,f_11374,seq__11345_11366__$1,temp__4126__auto___11365,vec__11344_11351,elem_11352,selector_11353){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11373,dommy$core$this_fn);

return f_11374.call(null,e);
});})(seq__11345_11354,chunk__11346_11355,count__11347_11356,i__11348_11357,vec__11350_11372,type_11373,f_11374,seq__11345_11366__$1,temp__4126__auto___11365,vec__11344_11351,elem_11352,selector_11353))
);

var G__11375 = cljs.core.next.call(null,seq__11345_11366__$1);
var G__11376 = null;
var G__11377 = (0);
var G__11378 = (0);
seq__11345_11354 = G__11375;
chunk__11346_11355 = G__11376;
count__11347_11356 = G__11377;
i__11348_11357 = G__11378;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq11342){
var G__11343 = cljs.core.first.call(null,seq11342);
var seq11342__$1 = cljs.core.next.call(null,seq11342);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11343,seq11342__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__11382){
var vec__11383 = p__11382;
var update_event_BANG_ = cljs.core.nth.call(null,vec__11383,(0),null);
if(dommy.core.descendant_QMARK_.call(null,node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name.call(null,event_type),true,true);

return node.dispatchEvent(update_event_BANG___$1.call(null,event));
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name.call(null,event_type))].join(''),update_event_BANG___$1.call(null,document.createEventObject()));
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq11379){
var G__11380 = cljs.core.first.call(null,seq11379);
var seq11379__$1 = cljs.core.next.call(null,seq11379);
var G__11381 = cljs.core.first.call(null,seq11379__$1);
var seq11379__$2 = cljs.core.next.call(null,seq11379__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11380,G__11381,seq11379__$2);
});
