// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(account,params){
var url = (function (){var G__42441 = "dataviews";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42441) : milia.api.io.make_url.call(null,G__42441));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,options);
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.show = (function milia$api$dataview$show(account,dataview_id){
var url = (function (){var G__42444 = "dataviews";
var G__42445 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42444,G__42445) : milia.api.io.make_url.call(null,G__42444,G__42445));
})();
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Retrieves dataview data using dataview id
 */
milia.api.dataview.data = (function milia$api$dataview$data(account,dataview_id){
var url = (function (){var G__42449 = "dataviews";
var G__42450 = dataview_id;
var G__42451 = "data.json";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42449,G__42450,G__42451) : milia.api.io.make_url.call(null,G__42449,G__42450,G__42451));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$raw_DASH_response_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(account,dataview_id){
var url = (function (){var G__42455 = "dataviews";
var G__42456 = dataview_id;
var G__42457 = "data";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__42455,G__42456,G__42457) : milia.api.io.make_url.call(null,G__42455,G__42456,G__42457));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(account){
var url = (function (){var G__42459 = "dataviews";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__42459) : milia.api.io.make_url.call(null,G__42459));
})();
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,options);
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(account,dataview_id,params){
var url = (function (){var G__42462 = "dataviews";
var G__42463 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42462,G__42463) : milia.api.io.make_url.call(null,G__42462,G__42463));
})();
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params,cljs.core.constant$keyword$suppress_DASH_40x_DASH_exceptions_QMARK_,true], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,options);
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(account,dataview_id){
var url = (function (){var G__42466 = "dataviews";
var G__42467 = dataview_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__42466,G__42467) : milia.api.io.make_url.call(null,G__42466,G__42467));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$delete,url,account);
});
