// Compiled by ClojureScript 0.0-3196 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3196";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__14989__delegate = function (args){
return console.log.apply(console,(function (){var G__14988 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__14988) : cljs.core.into_array.call(null,G__14988));
})());
};
var G__14989 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__14990__i = 0, G__14990__a = new Array(arguments.length -  0);
while (G__14990__i < G__14990__a.length) {G__14990__a[G__14990__i] = arguments[G__14990__i + 0]; ++G__14990__i;}
  args = new cljs.core.IndexedSeq(G__14990__a,0);
} 
return G__14989__delegate.call(this,args);};
G__14989.cljs$lang$maxFixedArity = 0;
G__14989.cljs$lang$applyTo = (function (arglist__14991){
var args = cljs.core.seq(arglist__14991);
return G__14989__delegate(args);
});
G__14989.cljs$core$IFn$_invoke$arity$variadic = G__14989__delegate;
return G__14989;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__14993 = x;
return goog.isString(G__14993);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__14995 = x__$1;
return goog.typeOf(G__14995);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__4264__auto__ = ty;
if(cljs.core.truth_(and__4264__auto__)){
return ty.cljs$lang$type;
} else {
return and__4264__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__14997 = obj;
return goog.typeOf(G__14997);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__14999 = Symbol;
return goog.typeOf(G__14999);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function cljs$core$make_array(){
var G__15001 = arguments.length;
switch (G__15001) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$lang$maxFixedArity = 2;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__5161__auto___15003 = len;
var i_15004 = (0);
while(true){
if((i_15004 < n__5161__auto___15003)){
(new_arr[i_15004] = (arr[i_15004]));

var G__15005 = (i_15004 + (1));
i_15004 = G__15005;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__15006 = (i + (1));
i = G__15006;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(){
var G__15011 = arguments.length;
switch (G__15011) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__15012 = cljs.core.aget;
var G__15013 = (array[i]);
var G__15014 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__15012,G__15013,G__15014) : cljs.core.apply.call(null,G__15012,G__15013,G__15014));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq15007){
var G__15008 = cljs.core.first(seq15007);
var seq15007__$1 = cljs.core.next(seq15007);
var G__15009 = cljs.core.first(seq15007__$1);
var seq15007__$2 = cljs.core.next(seq15007__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__15008,G__15009,seq15007__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = 2;
/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(){
var G__15021 = arguments.length;
switch (G__15021) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__15022 = cljs.core.aset;
var G__15023 = (array[idx]);
var G__15024 = idx2;
var G__15025 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__15022,G__15023,G__15024,G__15025) : cljs.core.apply.call(null,G__15022,G__15023,G__15024,G__15025));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq15016){
var G__15017 = cljs.core.first(seq15016);
var seq15016__$1 = cljs.core.next(seq15016);
var G__15018 = cljs.core.first(seq15016__$1);
var seq15016__$2 = cljs.core.next(seq15016__$1);
var G__15019 = cljs.core.first(seq15016__$2);
var seq15016__$3 = cljs.core.next(seq15016__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__15017,G__15018,G__15019,seq15016__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = 3;
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(){
var G__15028 = arguments.length;
switch (G__15028) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__15029 = (function (a,x){
a.push(x);

return a;
});
var G__15030 = [];
var G__15031 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__15029,G__15030,G__15031) : cljs.core.reduce.call(null,G__15029,G__15030,G__15031));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq15033){
var G__15034 = cljs.core.first(seq15033);
var seq15033__$1 = cljs.core.next(seq15033);
var G__15035 = cljs.core.first(seq15033__$1);
var seq15033__$2 = cljs.core.next(seq15033__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__15034,G__15035,seq15033__$2);
});

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj15037 = {};
return obj15037;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj15039 = {};
return obj15039;
})();

cljs.core._invoke = (function cljs$core$_invoke(){
var G__15041 = arguments.length;
switch (G__15041) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15043 = x__4912__auto__;
return goog.typeOf(G__15043);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15045 = x__4912__auto__;
return goog.typeOf(G__15045);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15047 = x__4912__auto__;
return goog.typeOf(G__15047);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15049 = x__4912__auto__;
return goog.typeOf(G__15049);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15051 = x__4912__auto__;
return goog.typeOf(G__15051);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15053 = x__4912__auto__;
return goog.typeOf(G__15053);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15055 = x__4912__auto__;
return goog.typeOf(G__15055);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15057 = x__4912__auto__;
return goog.typeOf(G__15057);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15059 = x__4912__auto__;
return goog.typeOf(G__15059);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15061 = x__4912__auto__;
return goog.typeOf(G__15061);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15063 = x__4912__auto__;
return goog.typeOf(G__15063);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15065 = x__4912__auto__;
return goog.typeOf(G__15065);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15067 = x__4912__auto__;
return goog.typeOf(G__15067);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15069 = x__4912__auto__;
return goog.typeOf(G__15069);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15071 = x__4912__auto__;
return goog.typeOf(G__15071);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15073 = x__4912__auto__;
return goog.typeOf(G__15073);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15075 = x__4912__auto__;
return goog.typeOf(G__15075);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15077 = x__4912__auto__;
return goog.typeOf(G__15077);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15079 = x__4912__auto__;
return goog.typeOf(G__15079);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15081 = x__4912__auto__;
return goog.typeOf(G__15081);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15083 = x__4912__auto__;
return goog.typeOf(G__15083);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._invoke[(function (){var G__15085 = x__4912__auto__;
return goog.typeOf(G__15085);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._invoke["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj15088 = {};
return obj15088;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__4264__auto__ = value;
if(and__4264__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__4264__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4912__auto__ = (((value == null))?null:value);
return (function (){var or__4276__auto__ = (cljs.core._clone[(function (){var G__15092 = x__4912__auto__;
return goog.typeOf(G__15092);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._clone["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj15094 = {};
return obj15094;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._count[(function (){var G__15098 = x__4912__auto__;
return goog.typeOf(G__15098);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._count["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj15100 = {};
return obj15100;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._empty[(function (){var G__15104 = x__4912__auto__;
return goog.typeOf(G__15104);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._empty["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj15106 = {};
return obj15106;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._conj[(function (){var G__15110 = x__4912__auto__;
return goog.typeOf(G__15110);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._conj["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj15112 = {};
return obj15112;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(){
var G__15114 = arguments.length;
switch (G__15114) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._nth[(function (){var G__15116 = x__4912__auto__;
return goog.typeOf(G__15116);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._nth["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._nth[(function (){var G__15118 = x__4912__auto__;
return goog.typeOf(G__15118);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._nth["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj15121 = {};
return obj15121;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj15123 = {};
return obj15123;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._first[(function (){var G__15127 = x__4912__auto__;
return goog.typeOf(G__15127);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._first["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._rest[(function (){var G__15131 = x__4912__auto__;
return goog.typeOf(G__15131);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._rest["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj15133 = {};
return obj15133;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._next[(function (){var G__15137 = x__4912__auto__;
return goog.typeOf(G__15137);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._next["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj15139 = {};
return obj15139;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(){
var G__15141 = arguments.length;
switch (G__15141) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._lookup[(function (){var G__15143 = x__4912__auto__;
return goog.typeOf(G__15143);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._lookup["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._lookup[(function (){var G__15145 = x__4912__auto__;
return goog.typeOf(G__15145);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._lookup["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj15148 = {};
return obj15148;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__15152 = x__4912__auto__;
return goog.typeOf(G__15152);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._assoc[(function (){var G__15156 = x__4912__auto__;
return goog.typeOf(G__15156);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._assoc["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj15158 = {};
return obj15158;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._dissoc[(function (){var G__15162 = x__4912__auto__;
return goog.typeOf(G__15162);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._dissoc["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj15164 = {};
return obj15164;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._key[(function (){var G__15168 = x__4912__auto__;
return goog.typeOf(G__15168);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._key["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._val[(function (){var G__15172 = x__4912__auto__;
return goog.typeOf(G__15172);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._val["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj15174 = {};
return obj15174;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._disjoin[(function (){var G__15178 = x__4912__auto__;
return goog.typeOf(G__15178);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._disjoin["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj15180 = {};
return obj15180;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._peek[(function (){var G__15184 = x__4912__auto__;
return goog.typeOf(G__15184);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._peek["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._pop[(function (){var G__15188 = x__4912__auto__;
return goog.typeOf(G__15188);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._pop["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj15190 = {};
return obj15190;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._assoc_n[(function (){var G__15194 = x__4912__auto__;
return goog.typeOf(G__15194);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj15196 = {};
return obj15196;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._deref[(function (){var G__15200 = x__4912__auto__;
return goog.typeOf(G__15200);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._deref["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj15202 = {};
return obj15202;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._deref_with_timeout[(function (){var G__15206 = x__4912__auto__;
return goog.typeOf(G__15206);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj15208 = {};
return obj15208;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._meta[(function (){var G__15212 = x__4912__auto__;
return goog.typeOf(G__15212);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._meta["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj15214 = {};
return obj15214;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._with_meta[(function (){var G__15218 = x__4912__auto__;
return goog.typeOf(G__15218);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._with_meta["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj15220 = {};
return obj15220;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(){
var G__15222 = arguments.length;
switch (G__15222) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._reduce[(function (){var G__15224 = x__4912__auto__;
return goog.typeOf(G__15224);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._reduce["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._reduce[(function (){var G__15226 = x__4912__auto__;
return goog.typeOf(G__15226);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._reduce["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj15229 = {};
return obj15229;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._kv_reduce[(function (){var G__15233 = x__4912__auto__;
return goog.typeOf(G__15233);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj15235 = {};
return obj15235;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._equiv[(function (){var G__15239 = x__4912__auto__;
return goog.typeOf(G__15239);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._equiv["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj15241 = {};
return obj15241;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._hash[(function (){var G__15245 = x__4912__auto__;
return goog.typeOf(G__15245);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._hash["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj15247 = {};
return obj15247;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._seq[(function (){var G__15251 = x__4912__auto__;
return goog.typeOf(G__15251);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._seq["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj15253 = {};
return obj15253;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj15255 = {};
return obj15255;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj15257 = {};
return obj15257;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj15259 = {};
return obj15259;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._rseq[(function (){var G__15263 = x__4912__auto__;
return goog.typeOf(G__15263);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._rseq["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj15265 = {};
return obj15265;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._sorted_seq[(function (){var G__15269 = x__4912__auto__;
return goog.typeOf(G__15269);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._sorted_seq_from[(function (){var G__15273 = x__4912__auto__;
return goog.typeOf(G__15273);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._entry_key[(function (){var G__15277 = x__4912__auto__;
return goog.typeOf(G__15277);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._entry_key["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._comparator[(function (){var G__15281 = x__4912__auto__;
return goog.typeOf(G__15281);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._comparator["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj15283 = {};
return obj15283;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__4264__auto__ = writer;
if(and__4264__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__4264__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4912__auto__ = (((writer == null))?null:writer);
return (function (){var or__4276__auto__ = (cljs.core._write[(function (){var G__15287 = x__4912__auto__;
return goog.typeOf(G__15287);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._write["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__4264__auto__ = writer;
if(and__4264__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__4264__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4912__auto__ = (((writer == null))?null:writer);
return (function (){var or__4276__auto__ = (cljs.core._flush[(function (){var G__15291 = x__4912__auto__;
return goog.typeOf(G__15291);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._flush["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj15293 = {};
return obj15293;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._pr_writer[(function (){var G__15297 = x__4912__auto__;
return goog.typeOf(G__15297);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj15299 = {};
return obj15299;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__4264__auto__ = d;
if(and__4264__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4912__auto__ = (((d == null))?null:d);
return (function (){var or__4276__auto__ = (cljs.core._realized_QMARK_[(function (){var G__15303 = x__4912__auto__;
return goog.typeOf(G__15303);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj15305 = {};
return obj15305;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._notify_watches[(function (){var G__15309 = x__4912__auto__;
return goog.typeOf(G__15309);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._add_watch[(function (){var G__15313 = x__4912__auto__;
return goog.typeOf(G__15313);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._add_watch["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__4264__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (cljs.core._remove_watch[(function (){var G__15317 = x__4912__auto__;
return goog.typeOf(G__15317);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj15319 = {};
return obj15319;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._as_transient[(function (){var G__15323 = x__4912__auto__;
return goog.typeOf(G__15323);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._as_transient["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj15325 = {};
return obj15325;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._conj_BANG_[(function (){var G__15329 = x__4912__auto__;
return goog.typeOf(G__15329);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._persistent_BANG_[(function (){var G__15333 = x__4912__auto__;
return goog.typeOf(G__15333);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj15335 = {};
return obj15335;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._assoc_BANG_[(function (){var G__15339 = x__4912__auto__;
return goog.typeOf(G__15339);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj15341 = {};
return obj15341;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__15345 = x__4912__auto__;
return goog.typeOf(G__15345);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj15347 = {};
return obj15347;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__15351 = x__4912__auto__;
return goog.typeOf(G__15351);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._pop_BANG_[(function (){var G__15355 = x__4912__auto__;
return goog.typeOf(G__15355);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj15357 = {};
return obj15357;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__4264__auto__ = tcoll;
if(and__4264__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4912__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__4276__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__15361 = x__4912__auto__;
return goog.typeOf(G__15361);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj15363 = {};
return obj15363;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._compare[(function (){var G__15367 = x__4912__auto__;
return goog.typeOf(G__15367);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._compare["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj15369 = {};
return obj15369;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._drop_first[(function (){var G__15373 = x__4912__auto__;
return goog.typeOf(G__15373);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._drop_first["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj15375 = {};
return obj15375;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._chunked_first[(function (){var G__15379 = x__4912__auto__;
return goog.typeOf(G__15379);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._chunked_rest[(function (){var G__15383 = x__4912__auto__;
return goog.typeOf(G__15383);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj15385 = {};
return obj15385;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._chunked_next[(function (){var G__15389 = x__4912__auto__;
return goog.typeOf(G__15389);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj15391 = {};
return obj15391;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._name[(function (){var G__15395 = x__4912__auto__;
return goog.typeOf(G__15395);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._name["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._namespace[(function (){var G__15399 = x__4912__auto__;
return goog.typeOf(G__15399);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._namespace["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj15401 = {};
return obj15401;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj15403 = {};
return obj15403;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._reset_BANG_[(function (){var G__15407 = x__4912__auto__;
return goog.typeOf(G__15407);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj15409 = {};
return obj15409;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(){
var G__15411 = arguments.length;
switch (G__15411) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._swap_BANG_[(function (){var G__15413 = x__4912__auto__;
return goog.typeOf(G__15413);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._swap_BANG_[(function (){var G__15415 = x__4912__auto__;
return goog.typeOf(G__15415);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._swap_BANG_[(function (){var G__15417 = x__4912__auto__;
return goog.typeOf(G__15417);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._swap_BANG_[(function (){var G__15419 = x__4912__auto__;
return goog.typeOf(G__15419);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj15422 = {};
return obj15422;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__4264__auto__ = o;
if(and__4264__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4912__auto__ = (((o == null))?null:o);
return (function (){var or__4276__auto__ = (cljs.core._vreset_BANG_[(function (){var G__15426 = x__4912__auto__;
return goog.typeOf(G__15426);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj15428 = {};
return obj15428;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__4264__auto__ = coll;
if(and__4264__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__4264__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4912__auto__ = (((coll == null))?null:coll);
return (function (){var or__4276__auto__ = (cljs.core._iterator[(function (){var G__15432 = x__4912__auto__;
return goog.typeOf(G__15432);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._iterator["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__15435 = (4294967295);
var G__15436 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__15435,G__15436) : Math.imul.call(null,G__15435,G__15436));
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__15439 = a;
var G__15440 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__15439,G__15440) : Math.imul.call(null,G__15439,G__15440));
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__15441 = (i + (2));
var G__15442 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__15441;
h1 = G__15442;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj15444 = {};
return obj15444;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__15445 = (i + (1));
var G__15446 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__15445;
hash = G__15446;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj15450 = {};
return obj15450;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__15453 = o;
if(G__15453){
var bit__4943__auto__ = (G__15453.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4943__auto__) || (G__15453.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__15454 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__15454) : Math.floor.call(null,G__15454));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not(a.ns);
if(and__4264__auto__){
return b.ns;
} else {
return and__4264__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__15461 = a.ns;
var G__15462 = b.ns;
return goog.array.defaultCompare(G__15461,G__15462);
})();
if(((0) === nsc)){
var G__15463 = a.name;
var G__15464 = b.name;
return goog.array.defaultCompare(G__15463,G__15464);
} else {
return nsc;
}
}
} else {
var G__15465 = a.name;
var G__15466 = b.name;
return goog.array.defaultCompare(G__15465,G__15466);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4692__auto__ = self__._hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__15468 = null;
var G__15468__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__15468__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__15468 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__15468__2.call(this,self__,coll);
case 3:
return G__15468__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15468.cljs$core$IFn$_invoke$arity$2 = G__15468__2;
G__15468.cljs$core$IFn$_invoke$arity$3 = G__15468__3;
return G__15468;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args15467){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args15467)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function cljs$core$symbol(){
var G__15470 = arguments.length;
switch (G__15470) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__15517 = null;
var G__15517__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__15517__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__15517__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__15517__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__15517__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__15517__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__15517__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__15517__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__15517__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__15517__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__15517__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__15517__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__15517__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__15517__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__15517__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__15517__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__15517__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__15517__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__15517__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__15517__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__15517__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__15517__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15473 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__15474 = a;
var G__15475 = b;
var G__15476 = c;
var G__15477 = d;
var G__15478 = e;
var G__15479 = f;
var G__15480 = g;
var G__15481 = h;
var G__15482 = i;
var G__15483 = j;
var G__15484 = k;
var G__15485 = l;
var G__15486 = m;
var G__15487 = n;
var G__15488 = o;
var G__15489 = p;
var G__15490 = q;
var G__15491 = r;
var G__15492 = s;
var G__15493 = t;
var G__15494 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15473,G__15474,G__15475,G__15476,G__15477,G__15478,G__15479,G__15480,G__15481,G__15482,G__15483,G__15484,G__15485,G__15486,G__15487,G__15488,G__15489,G__15490,G__15491,G__15492,G__15493,G__15494) : cljs.core.apply.call(null,G__15473,G__15474,G__15475,G__15476,G__15477,G__15478,G__15479,G__15480,G__15481,G__15482,G__15483,G__15484,G__15485,G__15486,G__15487,G__15488,G__15489,G__15490,G__15491,G__15492,G__15493,G__15494));
});
G__15517 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__15517__1.call(this,self__);
case 2:
return G__15517__2.call(this,self__,a);
case 3:
return G__15517__3.call(this,self__,a,b);
case 4:
return G__15517__4.call(this,self__,a,b,c);
case 5:
return G__15517__5.call(this,self__,a,b,c,d);
case 6:
return G__15517__6.call(this,self__,a,b,c,d,e);
case 7:
return G__15517__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__15517__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__15517__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__15517__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__15517__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__15517__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__15517__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__15517__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__15517__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__15517__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__15517__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__15517__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__15517__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__15517__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__15517__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__15517__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15517.cljs$core$IFn$_invoke$arity$1 = G__15517__1;
G__15517.cljs$core$IFn$_invoke$arity$2 = G__15517__2;
G__15517.cljs$core$IFn$_invoke$arity$3 = G__15517__3;
G__15517.cljs$core$IFn$_invoke$arity$4 = G__15517__4;
G__15517.cljs$core$IFn$_invoke$arity$5 = G__15517__5;
G__15517.cljs$core$IFn$_invoke$arity$6 = G__15517__6;
G__15517.cljs$core$IFn$_invoke$arity$7 = G__15517__7;
G__15517.cljs$core$IFn$_invoke$arity$8 = G__15517__8;
G__15517.cljs$core$IFn$_invoke$arity$9 = G__15517__9;
G__15517.cljs$core$IFn$_invoke$arity$10 = G__15517__10;
G__15517.cljs$core$IFn$_invoke$arity$11 = G__15517__11;
G__15517.cljs$core$IFn$_invoke$arity$12 = G__15517__12;
G__15517.cljs$core$IFn$_invoke$arity$13 = G__15517__13;
G__15517.cljs$core$IFn$_invoke$arity$14 = G__15517__14;
G__15517.cljs$core$IFn$_invoke$arity$15 = G__15517__15;
G__15517.cljs$core$IFn$_invoke$arity$16 = G__15517__16;
G__15517.cljs$core$IFn$_invoke$arity$17 = G__15517__17;
G__15517.cljs$core$IFn$_invoke$arity$18 = G__15517__18;
G__15517.cljs$core$IFn$_invoke$arity$19 = G__15517__19;
G__15517.cljs$core$IFn$_invoke$arity$20 = G__15517__20;
G__15517.cljs$core$IFn$_invoke$arity$21 = G__15517__21;
G__15517.cljs$core$IFn$_invoke$arity$22 = G__15517__22;
return G__15517;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args15472){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args15472)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__15495 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__15496 = a;
var G__15497 = b;
var G__15498 = c;
var G__15499 = d;
var G__15500 = e;
var G__15501 = f;
var G__15502 = g;
var G__15503 = h;
var G__15504 = i;
var G__15505 = j;
var G__15506 = k;
var G__15507 = l;
var G__15508 = m;
var G__15509 = n;
var G__15510 = o;
var G__15511 = p;
var G__15512 = q;
var G__15513 = r;
var G__15514 = s;
var G__15515 = t;
var G__15516 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15495,G__15496,G__15497,G__15498,G__15499,G__15500,G__15501,G__15502,G__15503,G__15504,G__15505,G__15506,G__15507,G__15508,G__15509,G__15510,G__15511,G__15512,G__15513,G__15514,G__15515,G__15516) : cljs.core.apply.call(null,G__15495,G__15496,G__15497,G__15498,G__15499,G__15500,G__15501,G__15502,G__15503,G__15504,G__15505,G__15506,G__15507,G__15508,G__15509,G__15510,G__15511,G__15512,G__15513,G__15514,G__15515,G__15516));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__15519 = x;
if(G__15519){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__15519.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__15519.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__15519);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__15519);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__15521 = value;
if(G__15521){
var bit__4950__auto__ = (G__15521.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4950__auto__) || (G__15521.cljs$core$ICloneable$)){
return true;
} else {
if((!G__15521.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__15521);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__15521);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__15523 = coll;
if(G__15523){
var bit__4943__auto__ = (G__15523.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4943__auto__) || (G__15523.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__15525 = coll;
if(G__15525){
var bit__4943__auto__ = (G__15525.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4943__auto__) || (G__15525.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__15527 = coll;
if(G__15527){
var bit__4943__auto__ = (G__15527.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4943__auto__) || (G__15527.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__15529 = coll;
if(G__15529){
var bit__4943__auto__ = (G__15529.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4943__auto__) || (G__15529.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(){
var G__15534 = arguments.length;
switch (G__15534) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__15536 = y;
var G__15537 = cljs.core.first(more);
var G__15538 = cljs.core.next(more);
x = G__15536;
y = G__15537;
more = G__15538;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq15530){
var G__15531 = cljs.core.first(seq15530);
var seq15530__$1 = cljs.core.next(seq15530);
var G__15532 = cljs.core.first(seq15530__$1);
var seq15530__$2 = cljs.core.next(seq15530__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__15531,G__15532,seq15530__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__15539 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__15539) : cljs.core.es6_iterator_seq.call(null,G__15539));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__15540 = (n + (1));
var G__15541 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__15542 = cljs.core.next(coll__$1);
n = G__15540;
hash_code = G__15541;
coll__$1 = G__15542;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__15543 = (n + (1));
var G__15544 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__15545 = cljs.core.next(coll__$1);
n = G__15543;
hash_code = G__15544;
coll__$1 = G__15545;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
var G__15546 = this$__$1.valueOf();
var G__15547 = other.valueOf();
return goog.array.defaultCompare(G__15546,G__15547);
});

Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__15548 = o;
return goog.getUid(G__15548);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__15550 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__15550) : cljs.core.deref.call(null,G__15550));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(){
var G__15552 = arguments.length;
switch (G__15552) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__15553 = val;
var G__15554 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15553,G__15554) : f.call(null,G__15553,G__15554));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15560 = nval;
var G__15561 = (n + (1));
val = G__15560;
n = G__15561;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__15555 = val__$1;
var G__15556 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15555,G__15556) : f.call(null,G__15555,G__15556));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15562 = nval;
var G__15563 = (n + (1));
val__$1 = G__15562;
n = G__15563;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__15557 = val__$1;
var G__15558 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15557,G__15558) : f.call(null,G__15557,G__15558));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15564 = nval;
var G__15565 = (n + (1));
val__$1 = G__15564;
n = G__15565;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = (function cljs$core$array_reduce(){
var G__15567 = arguments.length;
switch (G__15567) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__15568 = val;
var G__15569 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15568,G__15569) : f.call(null,G__15568,G__15569));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15575 = nval;
var G__15576 = (n + (1));
val = G__15575;
n = G__15576;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__15570 = val__$1;
var G__15571 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15570,G__15571) : f.call(null,G__15570,G__15571));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15577 = nval;
var G__15578 = (n + (1));
val__$1 = G__15577;
n = G__15578;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__15572 = val__$1;
var G__15573 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15572,G__15573) : f.call(null,G__15572,G__15573));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__15579 = nval;
var G__15580 = (n + (1));
val__$1 = G__15579;
n = G__15580;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__15582 = x;
if(G__15582){
var bit__4950__auto__ = (G__15582.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4950__auto__) || (G__15582.cljs$core$ICounted$)){
return true;
} else {
if((!G__15582.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__15582);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__15582);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__15584 = x;
if(G__15584){
var bit__4950__auto__ = (G__15584.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4950__auto__) || (G__15584.cljs$core$IIndexed$)){
return true;
} else {
if((!G__15584.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__15584);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__15584);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__15585 = coll__$1;
var G__15586 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__15585,G__15586) : cljs.core.equiv_sequential.call(null,G__15585,G__15586));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__15587 = o;
var G__15588 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__15587,G__15588) : cljs.core.cons.call(null,G__15587,G__15588));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(){
var G__15590 = arguments.length;
switch (G__15590) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(){
var G__15593 = arguments.length;
switch (G__15593) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__15595 = coll__$1;
var G__15596 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__15595,G__15596) : cljs.core.equiv_sequential.call(null,G__15595,G__15596));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__15597 = cljs.core.List.EMPTY;
var G__15598 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__15597,G__15598) : cljs.core.with_meta.call(null,G__15597,G__15598));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__15599 = f;
var G__15600 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__15599,G__15600) : cljs.core.seq_reduce.call(null,G__15599,G__15600));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__15601 = f;
var G__15602 = start;
var G__15603 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__15601,G__15602,G__15603) : cljs.core.seq_reduce.call(null,G__15601,G__15602,G__15603));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__15604 = o;
var G__15605 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__15604,G__15605) : cljs.core.cons.call(null,G__15604,G__15605));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__15606 = sn;
s = G__15606;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(){
var G__15611 = arguments.length;
switch (G__15611) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__15613 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__15614 = cljs.core.first(xs);
var G__15615 = cljs.core.next(xs);
coll = G__15613;
x = G__15614;
xs = G__15615;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq15607){
var G__15608 = cljs.core.first(seq15607);
var seq15607__$1 = cljs.core.next(seq15607);
var G__15609 = cljs.core.first(seq15607__$1);
var seq15607__$2 = cljs.core.next(seq15607__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__15608,G__15609,seq15607__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = 2;
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__15616 = cljs.core.next(s);
var G__15617 = (acc + (1));
s = G__15616;
acc = G__15617;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__15619 = coll;
if(G__15619){
var bit__4943__auto__ = (G__15619.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4943__auto__) || (G__15619.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(){
var G__15621 = arguments.length;
switch (G__15621) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__15623 = cljs.core.next(coll);
var G__15624 = (n - (1));
coll = G__15623;
n = G__15624;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__15625 = cljs.core.next(coll);
var G__15626 = (n - (1));
var G__15627 = not_found;
coll = G__15625;
n = G__15626;
not_found = G__15627;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(){
var G__15629 = arguments.length;
switch (G__15629) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__15630 = coll;
if(G__15630){
var bit__4943__auto__ = (G__15630.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4943__auto__) || (G__15630.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__15631 = coll;
if(G__15631){
var bit__4950__auto__ = (G__15631.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4950__auto__) || (G__15631.cljs$core$ISeq$)){
return true;
} else {
if((!G__15631.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__15631);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__15631);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__15632 = coll;
if(G__15632){
var bit__4943__auto__ = (G__15632.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4943__auto__) || (G__15632.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__15633 = coll;
if(G__15633){
var bit__4950__auto__ = (G__15633.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4950__auto__) || (G__15633.cljs$core$ISeq$)){
return true;
} else {
if((!G__15633.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__15633);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__15633);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__15635 = (n__$1 - (1));
var G__15636 = cljs.core.rest(xs);
n__$1 = G__15635;
xs = G__15636;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(){
var G__15638 = arguments.length;
switch (G__15638) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__15639 = o;
if(G__15639){
var bit__4943__auto__ = (G__15639.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4943__auto__) || (G__15639.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__15640 = o;
if(G__15640){
var bit__4943__auto__ = (G__15640.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4943__auto__) || (G__15640.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(){
var G__15647 = arguments.length;
switch (G__15647) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__15649 = ret;
var G__15650 = cljs.core.first(kvs);
var G__15651 = cljs.core.second(kvs);
var G__15652 = cljs.core.nnext(kvs);
coll = G__15649;
k = G__15650;
v = G__15651;
kvs = G__15652;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq15642){
var G__15643 = cljs.core.first(seq15642);
var seq15642__$1 = cljs.core.next(seq15642);
var G__15644 = cljs.core.first(seq15642__$1);
var seq15642__$2 = cljs.core.next(seq15642__$1);
var G__15645 = cljs.core.first(seq15642__$2);
var seq15642__$3 = cljs.core.next(seq15642__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__15643,G__15644,G__15645,seq15642__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = 3;
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(){
var G__15657 = arguments.length;
switch (G__15657) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__15659 = ret;
var G__15660 = cljs.core.first(ks);
var G__15661 = cljs.core.next(ks);
coll = G__15659;
k = G__15660;
ks = G__15661;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq15653){
var G__15654 = cljs.core.first(seq15653);
var seq15653__$1 = cljs.core.next(seq15653);
var G__15655 = cljs.core.first(seq15653__$1);
var seq15653__$2 = cljs.core.next(seq15653__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__15654,G__15655,seq15653__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__4276__auto__ = (function (){var G__15666 = f;
return goog.isFunction(G__15666);
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var G__15667 = f;
if(G__15667){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto____$1 = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
return G__15667.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__15667.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__15667);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__15667);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__16133 = null;
var G__16133__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__16133__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15669 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__15669) : self__.afn.call(null,G__15669));
});
var G__16133__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15670 = a;
var G__15671 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__15670,G__15671) : self__.afn.call(null,G__15670,G__15671));
});
var G__16133__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15672 = a;
var G__15673 = b;
var G__15674 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__15672,G__15673,G__15674) : self__.afn.call(null,G__15672,G__15673,G__15674));
});
var G__16133__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15675 = a;
var G__15676 = b;
var G__15677 = c;
var G__15678 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__15675,G__15676,G__15677,G__15678) : self__.afn.call(null,G__15675,G__15676,G__15677,G__15678));
});
var G__16133__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15679 = a;
var G__15680 = b;
var G__15681 = c;
var G__15682 = d;
var G__15683 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__15679,G__15680,G__15681,G__15682,G__15683) : self__.afn.call(null,G__15679,G__15680,G__15681,G__15682,G__15683));
});
var G__16133__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15684 = a;
var G__15685 = b;
var G__15686 = c;
var G__15687 = d;
var G__15688 = e;
var G__15689 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__15684,G__15685,G__15686,G__15687,G__15688,G__15689) : self__.afn.call(null,G__15684,G__15685,G__15686,G__15687,G__15688,G__15689));
});
var G__16133__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15690 = a;
var G__15691 = b;
var G__15692 = c;
var G__15693 = d;
var G__15694 = e;
var G__15695 = f;
var G__15696 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__15690,G__15691,G__15692,G__15693,G__15694,G__15695,G__15696) : self__.afn.call(null,G__15690,G__15691,G__15692,G__15693,G__15694,G__15695,G__15696));
});
var G__16133__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15697 = a;
var G__15698 = b;
var G__15699 = c;
var G__15700 = d;
var G__15701 = e;
var G__15702 = f;
var G__15703 = g;
var G__15704 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__15697,G__15698,G__15699,G__15700,G__15701,G__15702,G__15703,G__15704) : self__.afn.call(null,G__15697,G__15698,G__15699,G__15700,G__15701,G__15702,G__15703,G__15704));
});
var G__16133__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15705 = a;
var G__15706 = b;
var G__15707 = c;
var G__15708 = d;
var G__15709 = e;
var G__15710 = f;
var G__15711 = g;
var G__15712 = h;
var G__15713 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__15705,G__15706,G__15707,G__15708,G__15709,G__15710,G__15711,G__15712,G__15713) : self__.afn.call(null,G__15705,G__15706,G__15707,G__15708,G__15709,G__15710,G__15711,G__15712,G__15713));
});
var G__16133__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15714 = a;
var G__15715 = b;
var G__15716 = c;
var G__15717 = d;
var G__15718 = e;
var G__15719 = f;
var G__15720 = g;
var G__15721 = h;
var G__15722 = i;
var G__15723 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__15714,G__15715,G__15716,G__15717,G__15718,G__15719,G__15720,G__15721,G__15722,G__15723) : self__.afn.call(null,G__15714,G__15715,G__15716,G__15717,G__15718,G__15719,G__15720,G__15721,G__15722,G__15723));
});
var G__16133__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15724 = a;
var G__15725 = b;
var G__15726 = c;
var G__15727 = d;
var G__15728 = e;
var G__15729 = f;
var G__15730 = g;
var G__15731 = h;
var G__15732 = i;
var G__15733 = j;
var G__15734 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__15724,G__15725,G__15726,G__15727,G__15728,G__15729,G__15730,G__15731,G__15732,G__15733,G__15734) : self__.afn.call(null,G__15724,G__15725,G__15726,G__15727,G__15728,G__15729,G__15730,G__15731,G__15732,G__15733,G__15734));
});
var G__16133__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15735 = a;
var G__15736 = b;
var G__15737 = c;
var G__15738 = d;
var G__15739 = e;
var G__15740 = f;
var G__15741 = g;
var G__15742 = h;
var G__15743 = i;
var G__15744 = j;
var G__15745 = k;
var G__15746 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__15735,G__15736,G__15737,G__15738,G__15739,G__15740,G__15741,G__15742,G__15743,G__15744,G__15745,G__15746) : self__.afn.call(null,G__15735,G__15736,G__15737,G__15738,G__15739,G__15740,G__15741,G__15742,G__15743,G__15744,G__15745,G__15746));
});
var G__16133__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15747 = a;
var G__15748 = b;
var G__15749 = c;
var G__15750 = d;
var G__15751 = e;
var G__15752 = f;
var G__15753 = g;
var G__15754 = h;
var G__15755 = i;
var G__15756 = j;
var G__15757 = k;
var G__15758 = l;
var G__15759 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__15747,G__15748,G__15749,G__15750,G__15751,G__15752,G__15753,G__15754,G__15755,G__15756,G__15757,G__15758,G__15759) : self__.afn.call(null,G__15747,G__15748,G__15749,G__15750,G__15751,G__15752,G__15753,G__15754,G__15755,G__15756,G__15757,G__15758,G__15759));
});
var G__16133__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15760 = a;
var G__15761 = b;
var G__15762 = c;
var G__15763 = d;
var G__15764 = e;
var G__15765 = f;
var G__15766 = g;
var G__15767 = h;
var G__15768 = i;
var G__15769 = j;
var G__15770 = k;
var G__15771 = l;
var G__15772 = m;
var G__15773 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__15760,G__15761,G__15762,G__15763,G__15764,G__15765,G__15766,G__15767,G__15768,G__15769,G__15770,G__15771,G__15772,G__15773) : self__.afn.call(null,G__15760,G__15761,G__15762,G__15763,G__15764,G__15765,G__15766,G__15767,G__15768,G__15769,G__15770,G__15771,G__15772,G__15773));
});
var G__16133__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15774 = a;
var G__15775 = b;
var G__15776 = c;
var G__15777 = d;
var G__15778 = e;
var G__15779 = f;
var G__15780 = g;
var G__15781 = h;
var G__15782 = i;
var G__15783 = j;
var G__15784 = k;
var G__15785 = l;
var G__15786 = m;
var G__15787 = n;
var G__15788 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__15774,G__15775,G__15776,G__15777,G__15778,G__15779,G__15780,G__15781,G__15782,G__15783,G__15784,G__15785,G__15786,G__15787,G__15788) : self__.afn.call(null,G__15774,G__15775,G__15776,G__15777,G__15778,G__15779,G__15780,G__15781,G__15782,G__15783,G__15784,G__15785,G__15786,G__15787,G__15788));
});
var G__16133__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15789 = a;
var G__15790 = b;
var G__15791 = c;
var G__15792 = d;
var G__15793 = e;
var G__15794 = f;
var G__15795 = g;
var G__15796 = h;
var G__15797 = i;
var G__15798 = j;
var G__15799 = k;
var G__15800 = l;
var G__15801 = m;
var G__15802 = n;
var G__15803 = o;
var G__15804 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__15789,G__15790,G__15791,G__15792,G__15793,G__15794,G__15795,G__15796,G__15797,G__15798,G__15799,G__15800,G__15801,G__15802,G__15803,G__15804) : self__.afn.call(null,G__15789,G__15790,G__15791,G__15792,G__15793,G__15794,G__15795,G__15796,G__15797,G__15798,G__15799,G__15800,G__15801,G__15802,G__15803,G__15804));
});
var G__16133__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15805 = a;
var G__15806 = b;
var G__15807 = c;
var G__15808 = d;
var G__15809 = e;
var G__15810 = f;
var G__15811 = g;
var G__15812 = h;
var G__15813 = i;
var G__15814 = j;
var G__15815 = k;
var G__15816 = l;
var G__15817 = m;
var G__15818 = n;
var G__15819 = o;
var G__15820 = p;
var G__15821 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__15805,G__15806,G__15807,G__15808,G__15809,G__15810,G__15811,G__15812,G__15813,G__15814,G__15815,G__15816,G__15817,G__15818,G__15819,G__15820,G__15821) : self__.afn.call(null,G__15805,G__15806,G__15807,G__15808,G__15809,G__15810,G__15811,G__15812,G__15813,G__15814,G__15815,G__15816,G__15817,G__15818,G__15819,G__15820,G__15821));
});
var G__16133__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15822 = a;
var G__15823 = b;
var G__15824 = c;
var G__15825 = d;
var G__15826 = e;
var G__15827 = f;
var G__15828 = g;
var G__15829 = h;
var G__15830 = i;
var G__15831 = j;
var G__15832 = k;
var G__15833 = l;
var G__15834 = m;
var G__15835 = n;
var G__15836 = o;
var G__15837 = p;
var G__15838 = q;
var G__15839 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__15822,G__15823,G__15824,G__15825,G__15826,G__15827,G__15828,G__15829,G__15830,G__15831,G__15832,G__15833,G__15834,G__15835,G__15836,G__15837,G__15838,G__15839) : self__.afn.call(null,G__15822,G__15823,G__15824,G__15825,G__15826,G__15827,G__15828,G__15829,G__15830,G__15831,G__15832,G__15833,G__15834,G__15835,G__15836,G__15837,G__15838,G__15839));
});
var G__16133__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15840 = a;
var G__15841 = b;
var G__15842 = c;
var G__15843 = d;
var G__15844 = e;
var G__15845 = f;
var G__15846 = g;
var G__15847 = h;
var G__15848 = i;
var G__15849 = j;
var G__15850 = k;
var G__15851 = l;
var G__15852 = m;
var G__15853 = n;
var G__15854 = o;
var G__15855 = p;
var G__15856 = q;
var G__15857 = r;
var G__15858 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__15840,G__15841,G__15842,G__15843,G__15844,G__15845,G__15846,G__15847,G__15848,G__15849,G__15850,G__15851,G__15852,G__15853,G__15854,G__15855,G__15856,G__15857,G__15858) : self__.afn.call(null,G__15840,G__15841,G__15842,G__15843,G__15844,G__15845,G__15846,G__15847,G__15848,G__15849,G__15850,G__15851,G__15852,G__15853,G__15854,G__15855,G__15856,G__15857,G__15858));
});
var G__16133__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15859 = a;
var G__15860 = b;
var G__15861 = c;
var G__15862 = d;
var G__15863 = e;
var G__15864 = f;
var G__15865 = g;
var G__15866 = h;
var G__15867 = i;
var G__15868 = j;
var G__15869 = k;
var G__15870 = l;
var G__15871 = m;
var G__15872 = n;
var G__15873 = o;
var G__15874 = p;
var G__15875 = q;
var G__15876 = r;
var G__15877 = s;
var G__15878 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__15859,G__15860,G__15861,G__15862,G__15863,G__15864,G__15865,G__15866,G__15867,G__15868,G__15869,G__15870,G__15871,G__15872,G__15873,G__15874,G__15875,G__15876,G__15877,G__15878) : self__.afn.call(null,G__15859,G__15860,G__15861,G__15862,G__15863,G__15864,G__15865,G__15866,G__15867,G__15868,G__15869,G__15870,G__15871,G__15872,G__15873,G__15874,G__15875,G__15876,G__15877,G__15878));
});
var G__16133__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__15879 = self__.afn;
var G__15880 = a;
var G__15881 = b;
var G__15882 = c;
var G__15883 = d;
var G__15884 = e;
var G__15885 = f;
var G__15886 = g;
var G__15887 = h;
var G__15888 = i;
var G__15889 = j;
var G__15890 = k;
var G__15891 = l;
var G__15892 = m;
var G__15893 = n;
var G__15894 = o;
var G__15895 = p;
var G__15896 = q;
var G__15897 = r;
var G__15898 = s;
var G__15899 = t;
var G__15900 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15879,G__15880,G__15881,G__15882,G__15883,G__15884,G__15885,G__15886,G__15887,G__15888,G__15889,G__15890,G__15891,G__15892,G__15893,G__15894,G__15895,G__15896,G__15897,G__15898,G__15899,G__15900) : cljs.core.apply.call(null,G__15879,G__15880,G__15881,G__15882,G__15883,G__15884,G__15885,G__15886,G__15887,G__15888,G__15889,G__15890,G__15891,G__15892,G__15893,G__15894,G__15895,G__15896,G__15897,G__15898,G__15899,G__15900));
});
G__16133 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__16133__1.call(this,self__);
case 2:
return G__16133__2.call(this,self__,a);
case 3:
return G__16133__3.call(this,self__,a,b);
case 4:
return G__16133__4.call(this,self__,a,b,c);
case 5:
return G__16133__5.call(this,self__,a,b,c,d);
case 6:
return G__16133__6.call(this,self__,a,b,c,d,e);
case 7:
return G__16133__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__16133__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__16133__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__16133__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__16133__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__16133__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__16133__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__16133__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__16133__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__16133__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__16133__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__16133__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__16133__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__16133__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__16133__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__16133__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16133.cljs$core$IFn$_invoke$arity$1 = G__16133__1;
G__16133.cljs$core$IFn$_invoke$arity$2 = G__16133__2;
G__16133.cljs$core$IFn$_invoke$arity$3 = G__16133__3;
G__16133.cljs$core$IFn$_invoke$arity$4 = G__16133__4;
G__16133.cljs$core$IFn$_invoke$arity$5 = G__16133__5;
G__16133.cljs$core$IFn$_invoke$arity$6 = G__16133__6;
G__16133.cljs$core$IFn$_invoke$arity$7 = G__16133__7;
G__16133.cljs$core$IFn$_invoke$arity$8 = G__16133__8;
G__16133.cljs$core$IFn$_invoke$arity$9 = G__16133__9;
G__16133.cljs$core$IFn$_invoke$arity$10 = G__16133__10;
G__16133.cljs$core$IFn$_invoke$arity$11 = G__16133__11;
G__16133.cljs$core$IFn$_invoke$arity$12 = G__16133__12;
G__16133.cljs$core$IFn$_invoke$arity$13 = G__16133__13;
G__16133.cljs$core$IFn$_invoke$arity$14 = G__16133__14;
G__16133.cljs$core$IFn$_invoke$arity$15 = G__16133__15;
G__16133.cljs$core$IFn$_invoke$arity$16 = G__16133__16;
G__16133.cljs$core$IFn$_invoke$arity$17 = G__16133__17;
G__16133.cljs$core$IFn$_invoke$arity$18 = G__16133__18;
G__16133.cljs$core$IFn$_invoke$arity$19 = G__16133__19;
G__16133.cljs$core$IFn$_invoke$arity$20 = G__16133__20;
G__16133.cljs$core$IFn$_invoke$arity$21 = G__16133__21;
G__16133.cljs$core$IFn$_invoke$arity$22 = G__16133__22;
return G__16133;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args15668){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args15668)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__15901 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__15901) : self__.afn.call(null,G__15901));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__15902 = a;
var G__15903 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__15902,G__15903) : self__.afn.call(null,G__15902,G__15903));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__15904 = a;
var G__15905 = b;
var G__15906 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__15904,G__15905,G__15906) : self__.afn.call(null,G__15904,G__15905,G__15906));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__15907 = a;
var G__15908 = b;
var G__15909 = c;
var G__15910 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__15907,G__15908,G__15909,G__15910) : self__.afn.call(null,G__15907,G__15908,G__15909,G__15910));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__15911 = a;
var G__15912 = b;
var G__15913 = c;
var G__15914 = d;
var G__15915 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__15911,G__15912,G__15913,G__15914,G__15915) : self__.afn.call(null,G__15911,G__15912,G__15913,G__15914,G__15915));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__15916 = a;
var G__15917 = b;
var G__15918 = c;
var G__15919 = d;
var G__15920 = e;
var G__15921 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__15916,G__15917,G__15918,G__15919,G__15920,G__15921) : self__.afn.call(null,G__15916,G__15917,G__15918,G__15919,G__15920,G__15921));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__15922 = a;
var G__15923 = b;
var G__15924 = c;
var G__15925 = d;
var G__15926 = e;
var G__15927 = f;
var G__15928 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__15922,G__15923,G__15924,G__15925,G__15926,G__15927,G__15928) : self__.afn.call(null,G__15922,G__15923,G__15924,G__15925,G__15926,G__15927,G__15928));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__15929 = a;
var G__15930 = b;
var G__15931 = c;
var G__15932 = d;
var G__15933 = e;
var G__15934 = f;
var G__15935 = g;
var G__15936 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__15929,G__15930,G__15931,G__15932,G__15933,G__15934,G__15935,G__15936) : self__.afn.call(null,G__15929,G__15930,G__15931,G__15932,G__15933,G__15934,G__15935,G__15936));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__15937 = a;
var G__15938 = b;
var G__15939 = c;
var G__15940 = d;
var G__15941 = e;
var G__15942 = f;
var G__15943 = g;
var G__15944 = h;
var G__15945 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__15937,G__15938,G__15939,G__15940,G__15941,G__15942,G__15943,G__15944,G__15945) : self__.afn.call(null,G__15937,G__15938,G__15939,G__15940,G__15941,G__15942,G__15943,G__15944,G__15945));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__15946 = a;
var G__15947 = b;
var G__15948 = c;
var G__15949 = d;
var G__15950 = e;
var G__15951 = f;
var G__15952 = g;
var G__15953 = h;
var G__15954 = i;
var G__15955 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__15946,G__15947,G__15948,G__15949,G__15950,G__15951,G__15952,G__15953,G__15954,G__15955) : self__.afn.call(null,G__15946,G__15947,G__15948,G__15949,G__15950,G__15951,G__15952,G__15953,G__15954,G__15955));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__15956 = a;
var G__15957 = b;
var G__15958 = c;
var G__15959 = d;
var G__15960 = e;
var G__15961 = f;
var G__15962 = g;
var G__15963 = h;
var G__15964 = i;
var G__15965 = j;
var G__15966 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__15956,G__15957,G__15958,G__15959,G__15960,G__15961,G__15962,G__15963,G__15964,G__15965,G__15966) : self__.afn.call(null,G__15956,G__15957,G__15958,G__15959,G__15960,G__15961,G__15962,G__15963,G__15964,G__15965,G__15966));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__15967 = a;
var G__15968 = b;
var G__15969 = c;
var G__15970 = d;
var G__15971 = e;
var G__15972 = f;
var G__15973 = g;
var G__15974 = h;
var G__15975 = i;
var G__15976 = j;
var G__15977 = k;
var G__15978 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__15967,G__15968,G__15969,G__15970,G__15971,G__15972,G__15973,G__15974,G__15975,G__15976,G__15977,G__15978) : self__.afn.call(null,G__15967,G__15968,G__15969,G__15970,G__15971,G__15972,G__15973,G__15974,G__15975,G__15976,G__15977,G__15978));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__15979 = a;
var G__15980 = b;
var G__15981 = c;
var G__15982 = d;
var G__15983 = e;
var G__15984 = f;
var G__15985 = g;
var G__15986 = h;
var G__15987 = i;
var G__15988 = j;
var G__15989 = k;
var G__15990 = l;
var G__15991 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__15979,G__15980,G__15981,G__15982,G__15983,G__15984,G__15985,G__15986,G__15987,G__15988,G__15989,G__15990,G__15991) : self__.afn.call(null,G__15979,G__15980,G__15981,G__15982,G__15983,G__15984,G__15985,G__15986,G__15987,G__15988,G__15989,G__15990,G__15991));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__15992 = a;
var G__15993 = b;
var G__15994 = c;
var G__15995 = d;
var G__15996 = e;
var G__15997 = f;
var G__15998 = g;
var G__15999 = h;
var G__16000 = i;
var G__16001 = j;
var G__16002 = k;
var G__16003 = l;
var G__16004 = m;
var G__16005 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__15992,G__15993,G__15994,G__15995,G__15996,G__15997,G__15998,G__15999,G__16000,G__16001,G__16002,G__16003,G__16004,G__16005) : self__.afn.call(null,G__15992,G__15993,G__15994,G__15995,G__15996,G__15997,G__15998,G__15999,G__16000,G__16001,G__16002,G__16003,G__16004,G__16005));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__16006 = a;
var G__16007 = b;
var G__16008 = c;
var G__16009 = d;
var G__16010 = e;
var G__16011 = f;
var G__16012 = g;
var G__16013 = h;
var G__16014 = i;
var G__16015 = j;
var G__16016 = k;
var G__16017 = l;
var G__16018 = m;
var G__16019 = n;
var G__16020 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__16006,G__16007,G__16008,G__16009,G__16010,G__16011,G__16012,G__16013,G__16014,G__16015,G__16016,G__16017,G__16018,G__16019,G__16020) : self__.afn.call(null,G__16006,G__16007,G__16008,G__16009,G__16010,G__16011,G__16012,G__16013,G__16014,G__16015,G__16016,G__16017,G__16018,G__16019,G__16020));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__16021 = a;
var G__16022 = b;
var G__16023 = c;
var G__16024 = d;
var G__16025 = e;
var G__16026 = f;
var G__16027 = g;
var G__16028 = h;
var G__16029 = i;
var G__16030 = j;
var G__16031 = k;
var G__16032 = l;
var G__16033 = m;
var G__16034 = n;
var G__16035 = o;
var G__16036 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__16021,G__16022,G__16023,G__16024,G__16025,G__16026,G__16027,G__16028,G__16029,G__16030,G__16031,G__16032,G__16033,G__16034,G__16035,G__16036) : self__.afn.call(null,G__16021,G__16022,G__16023,G__16024,G__16025,G__16026,G__16027,G__16028,G__16029,G__16030,G__16031,G__16032,G__16033,G__16034,G__16035,G__16036));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__16037 = a;
var G__16038 = b;
var G__16039 = c;
var G__16040 = d;
var G__16041 = e;
var G__16042 = f;
var G__16043 = g;
var G__16044 = h;
var G__16045 = i;
var G__16046 = j;
var G__16047 = k;
var G__16048 = l;
var G__16049 = m;
var G__16050 = n;
var G__16051 = o;
var G__16052 = p;
var G__16053 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__16037,G__16038,G__16039,G__16040,G__16041,G__16042,G__16043,G__16044,G__16045,G__16046,G__16047,G__16048,G__16049,G__16050,G__16051,G__16052,G__16053) : self__.afn.call(null,G__16037,G__16038,G__16039,G__16040,G__16041,G__16042,G__16043,G__16044,G__16045,G__16046,G__16047,G__16048,G__16049,G__16050,G__16051,G__16052,G__16053));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__16054 = a;
var G__16055 = b;
var G__16056 = c;
var G__16057 = d;
var G__16058 = e;
var G__16059 = f;
var G__16060 = g;
var G__16061 = h;
var G__16062 = i;
var G__16063 = j;
var G__16064 = k;
var G__16065 = l;
var G__16066 = m;
var G__16067 = n;
var G__16068 = o;
var G__16069 = p;
var G__16070 = q;
var G__16071 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__16054,G__16055,G__16056,G__16057,G__16058,G__16059,G__16060,G__16061,G__16062,G__16063,G__16064,G__16065,G__16066,G__16067,G__16068,G__16069,G__16070,G__16071) : self__.afn.call(null,G__16054,G__16055,G__16056,G__16057,G__16058,G__16059,G__16060,G__16061,G__16062,G__16063,G__16064,G__16065,G__16066,G__16067,G__16068,G__16069,G__16070,G__16071));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__16072 = a;
var G__16073 = b;
var G__16074 = c;
var G__16075 = d;
var G__16076 = e;
var G__16077 = f;
var G__16078 = g;
var G__16079 = h;
var G__16080 = i;
var G__16081 = j;
var G__16082 = k;
var G__16083 = l;
var G__16084 = m;
var G__16085 = n;
var G__16086 = o;
var G__16087 = p;
var G__16088 = q;
var G__16089 = r;
var G__16090 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__16072,G__16073,G__16074,G__16075,G__16076,G__16077,G__16078,G__16079,G__16080,G__16081,G__16082,G__16083,G__16084,G__16085,G__16086,G__16087,G__16088,G__16089,G__16090) : self__.afn.call(null,G__16072,G__16073,G__16074,G__16075,G__16076,G__16077,G__16078,G__16079,G__16080,G__16081,G__16082,G__16083,G__16084,G__16085,G__16086,G__16087,G__16088,G__16089,G__16090));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__16091 = a;
var G__16092 = b;
var G__16093 = c;
var G__16094 = d;
var G__16095 = e;
var G__16096 = f;
var G__16097 = g;
var G__16098 = h;
var G__16099 = i;
var G__16100 = j;
var G__16101 = k;
var G__16102 = l;
var G__16103 = m;
var G__16104 = n;
var G__16105 = o;
var G__16106 = p;
var G__16107 = q;
var G__16108 = r;
var G__16109 = s;
var G__16110 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__16091,G__16092,G__16093,G__16094,G__16095,G__16096,G__16097,G__16098,G__16099,G__16100,G__16101,G__16102,G__16103,G__16104,G__16105,G__16106,G__16107,G__16108,G__16109,G__16110) : self__.afn.call(null,G__16091,G__16092,G__16093,G__16094,G__16095,G__16096,G__16097,G__16098,G__16099,G__16100,G__16101,G__16102,G__16103,G__16104,G__16105,G__16106,G__16107,G__16108,G__16109,G__16110));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__16111 = self__.afn;
var G__16112 = a;
var G__16113 = b;
var G__16114 = c;
var G__16115 = d;
var G__16116 = e;
var G__16117 = f;
var G__16118 = g;
var G__16119 = h;
var G__16120 = i;
var G__16121 = j;
var G__16122 = k;
var G__16123 = l;
var G__16124 = m;
var G__16125 = n;
var G__16126 = o;
var G__16127 = p;
var G__16128 = q;
var G__16129 = r;
var G__16130 = s;
var G__16131 = t;
var G__16132 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16111,G__16112,G__16113,G__16114,G__16115,G__16116,G__16117,G__16118,G__16119,G__16120,G__16121,G__16122,G__16123,G__16124,G__16125,G__16126,G__16127,G__16128,G__16129,G__16130,G__16131,G__16132) : cljs.core.apply.call(null,G__16111,G__16112,G__16113,G__16114,G__16115,G__16116,G__16117,G__16118,G__16119,G__16120,G__16121,G__16122,G__16123,G__16124,G__16125,G__16126,G__16127,G__16128,G__16129,G__16130,G__16131,G__16132));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__16137 = o;
if(G__16137){
var bit__4950__auto__ = (G__16137.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4950__auto__) || (G__16137.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__16137.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__16137);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__16137);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__4264__auto__ = !((o == null));
if(and__4264__auto__){
var G__16141 = o;
if(G__16141){
var bit__4950__auto__ = (G__16141.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4950__auto__) || (G__16141.cljs$core$IMeta$)){
return true;
} else {
if((!G__16141.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__16141);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__16141);
}
} else {
return and__4264__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(){
var G__16146 = arguments.length;
switch (G__16146) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__16148 = ret;
var G__16149 = cljs.core.first(ks);
var G__16150 = cljs.core.next(ks);
coll = G__16148;
k = G__16149;
ks = G__16150;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq16142){
var G__16143 = cljs.core.first(seq16142);
var seq16142__$1 = cljs.core.next(seq16142);
var G__16144 = cljs.core.first(seq16142__$1);
var seq16142__$2 = cljs.core.next(seq16142__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__16143,G__16144,seq16142__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__16152 = x;
if(G__16152){
var bit__4950__auto__ = (G__16152.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4950__auto__) || (G__16152.cljs$core$ICollection$)){
return true;
} else {
if((!G__16152.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__16152);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__16152);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__16154 = x;
if(G__16154){
var bit__4950__auto__ = (G__16154.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4950__auto__) || (G__16154.cljs$core$ISet$)){
return true;
} else {
if((!G__16154.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__16154);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__16154);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__16156 = x;
if(G__16156){
var bit__4950__auto__ = (G__16156.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4950__auto__) || (G__16156.cljs$core$IAssociative$)){
return true;
} else {
if((!G__16156.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__16156);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__16156);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__16158 = x;
if(G__16158){
var bit__4950__auto__ = (G__16158.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4950__auto__) || (G__16158.cljs$core$ISequential$)){
return true;
} else {
if((!G__16158.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__16158);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__16158);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__16160 = x;
if(G__16160){
var bit__4950__auto__ = (G__16160.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4950__auto__) || (G__16160.cljs$core$ISorted$)){
return true;
} else {
if((!G__16160.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__16160);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__16160);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__16162 = x;
if(G__16162){
var bit__4950__auto__ = (G__16162.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4950__auto__) || (G__16162.cljs$core$IReduce$)){
return true;
} else {
if((!G__16162.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__16162);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__16162);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__16164 = x;
if(G__16164){
var bit__4950__auto__ = (G__16164.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4950__auto__) || (G__16164.cljs$core$IMap$)){
return true;
} else {
if((!G__16164.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__16164);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__16164);
}
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__16166 = x;
if(G__16166){
var bit__4950__auto__ = (G__16166.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4950__auto__) || (G__16166.cljs$core$IVector$)){
return true;
} else {
if((!G__16166.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__16166);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__16166);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__16168 = x;
if(G__16168){
var bit__4943__auto__ = (G__16168.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4943__auto__) || (G__16168.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(){
var G__16171 = arguments.length;
switch (G__16171) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,0),(0)));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5328__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
var obj16173 = {};
return obj16173;
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var G__16174 = goog.object.create;
var G__16175 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__16174,G__16175) : cljs.core.apply.call(null,G__16174,G__16175));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq16169){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16169));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__16179_16181 = obj;
var G__16180_16182 = ((function (G__16179_16181,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__16179_16181,keys))
;
goog.object.forEach(G__16179_16181,G__16180_16182);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__16183 = (i__$1 + (1));
var G__16184 = (j__$1 + (1));
var G__16185 = (len__$1 - (1));
i__$1 = G__16183;
j__$1 = G__16184;
len__$1 = G__16185;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__16186 = (i__$1 - (1));
var G__16187 = (j__$1 - (1));
var G__16188 = (len__$1 - (1));
i__$1 = G__16186;
j__$1 = G__16187;
len__$1 = G__16188;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj16190 = {};
return obj16190;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__16192 = s;
if(G__16192){
var bit__4950__auto__ = (G__16192.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4950__auto__) || (G__16192.cljs$core$ISeq$)){
return true;
} else {
if((!G__16192.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__16192);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__16192);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__16194 = s;
if(G__16194){
var bit__4950__auto__ = (G__16194.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4950__auto__) || (G__16194.cljs$core$ISeqable$)){
return true;
} else {
if((!G__16194.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__16194);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__16194);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__4276__auto__ = cljs.core.fn_QMARK_(f);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var G__16198 = f;
if(G__16198){
var bit__4950__auto__ = (G__16198.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4950__auto__) || (G__16198.cljs$core$IFn$)){
return true;
} else {
if((!G__16198.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__16198);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__16198);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__16211 = n;
return isNaN(G__16211);
})())) && (!((n === Infinity))) && (((function (){var G__16212 = n;
return parseFloat(G__16212);
})() === (function (){var G__16213 = n;
var G__16214 = (10);
return parseInt(G__16213,G__16214);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(){
var G__16219 = arguments.length;
switch (G__16219) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__16221 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__16222 = etc;
s = G__16221;
xs = G__16222;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq16215){
var G__16216 = cljs.core.first(seq16215);
var seq16215__$1 = cljs.core.next(seq16215);
var G__16217 = cljs.core.first(seq16215__$1);
var seq16215__$2 = cljs.core.next(seq16215__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__16216,G__16217,seq16215__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__16226 = x;
if(G__16226){
var bit__4943__auto__ = (G__16226.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4943__auto__) || (G__16226.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__16227 = x;
var G__16228 = y;
return goog.array.defaultCompare(G__16227,G__16228);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(){
var G__16230 = arguments.length;
switch (G__16230) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__16232 = xs;
var G__16233 = ys;
var G__16234 = len;
var G__16235 = (n + (1));
xs = G__16232;
ys = G__16233;
len = G__16234;
n = G__16235;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__16240 = x;
var G__16241 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16240,G__16241) : f.call(null,G__16240,G__16241));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__16242 = y;
var G__16243 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16242,G__16243) : f.call(null,G__16242,G__16243));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(){
var G__16245 = arguments.length;
switch (G__16245) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__16246 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__16246) : cljs.core.to_array.call(null,G__16246));
})();
var G__16247_16250 = a;
var G__16248_16251 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__16247_16250,G__16248_16251);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(){
var G__16253 = arguments.length;
switch (G__16253) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__16254 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__16254) : keyfn.call(null,G__16254));
})(),(function (){var G__16255 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__16255) : keyfn.call(null,G__16255));
})());
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = (function cljs$core$seq_reduce(){
var G__16258 = arguments.length;
switch (G__16258) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__16259 = f;
var G__16260 = cljs.core.first(s);
var G__16261 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__16259,G__16260,G__16261) : cljs.core.reduce.call(null,G__16259,G__16260,G__16261));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__16262 = val__$1;
var G__16263 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16262,G__16263) : f.call(null,G__16262,G__16263));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16265 = nval;
var G__16266 = cljs.core.next(coll__$1);
val__$1 = G__16265;
coll__$1 = G__16266;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__16270 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__16270) : cljs.core.to_array.call(null,G__16270));
})();
var G__16271_16273 = a;
goog.array.shuffle(G__16271_16273);

var G__16272 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__16272) : cljs.core.vec.call(null,G__16272));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(){
var G__16275 = arguments.length;
switch (G__16275) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((function (){var G__16276 = coll;
if(G__16276){
var bit__4943__auto__ = (G__16276.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4943__auto__) || (G__16276.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((function (){var G__16277 = coll;
if(G__16277){
var bit__4943__auto__ = (G__16277.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4943__auto__) || (G__16277.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(){
var G__16280 = arguments.length;
switch (G__16280) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__16285 = null;
var G__16285__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__16285__1 = (function (x){
var G__16281 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__16281) : cf.call(null,G__16281));
});
var G__16285__2 = (function (x,y){
var G__16282 = x;
var G__16283 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16282,G__16283) : f.call(null,G__16282,G__16283));
});
G__16285 = function(x,y){
switch(arguments.length){
case 0:
return G__16285__0.call(this);
case 1:
return G__16285__1.call(this,x);
case 2:
return G__16285__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16285.cljs$core$IFn$_invoke$arity$0 = G__16285__0;
G__16285.cljs$core$IFn$_invoke$arity$1 = G__16285__1;
G__16285.cljs$core$IFn$_invoke$arity$2 = G__16285__2;
return G__16285;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(){
var G__16287 = arguments.length;
switch (G__16287) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__16288 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__16288) : xform.call(null,G__16288));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__16289 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__16289) : f__$1.call(null,G__16289));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(){
var G__16295 = arguments.length;
switch (G__16295) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq16291){
var G__16292 = cljs.core.first(seq16291);
var seq16291__$1 = cljs.core.next(seq16291);
var G__16293 = cljs.core.first(seq16291__$1);
var seq16291__$2 = cljs.core.next(seq16291__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__16292,G__16293,seq16291__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(){
var G__16301 = arguments.length;
switch (G__16301) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq16297){
var G__16298 = cljs.core.first(seq16297);
var seq16297__$1 = cljs.core.next(seq16297);
var G__16299 = cljs.core.first(seq16297__$1);
var seq16297__$2 = cljs.core.next(seq16297__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__16298,G__16299,seq16297__$2);
});

cljs.core._.cljs$lang$maxFixedArity = 2;
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(){
var G__16307 = arguments.length;
switch (G__16307) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq16303){
var G__16304 = cljs.core.first(seq16303);
var seq16303__$1 = cljs.core.next(seq16303);
var G__16305 = cljs.core.first(seq16303__$1);
var seq16303__$2 = cljs.core.next(seq16303__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16304,G__16305,seq16303__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(){
var G__16313 = arguments.length;
switch (G__16313) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq16309){
var G__16310 = cljs.core.first(seq16309);
var seq16309__$1 = cljs.core.next(seq16309);
var G__16311 = cljs.core.first(seq16309__$1);
var seq16309__$2 = cljs.core.next(seq16309__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__16310,G__16311,seq16309__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(){
var G__16319 = arguments.length;
switch (G__16319) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__16321 = y;
var G__16322 = cljs.core.first(more);
var G__16323 = cljs.core.next(more);
x = G__16321;
y = G__16322;
more = G__16323;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq16315){
var G__16316 = cljs.core.first(seq16315);
var seq16315__$1 = cljs.core.next(seq16315);
var G__16317 = cljs.core.first(seq16315__$1);
var seq16315__$2 = cljs.core.next(seq16315__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__16316,G__16317,seq16315__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(){
var G__16328 = arguments.length;
switch (G__16328) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__16330 = y;
var G__16331 = cljs.core.first(more);
var G__16332 = cljs.core.next(more);
x = G__16330;
y = G__16331;
more = G__16332;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq16324){
var G__16325 = cljs.core.first(seq16324);
var seq16324__$1 = cljs.core.next(seq16324);
var G__16326 = cljs.core.first(seq16324__$1);
var seq16324__$2 = cljs.core.next(seq16324__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16325,G__16326,seq16324__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(){
var G__16337 = arguments.length;
switch (G__16337) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__16339 = y;
var G__16340 = cljs.core.first(more);
var G__16341 = cljs.core.next(more);
x = G__16339;
y = G__16340;
more = G__16341;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq16333){
var G__16334 = cljs.core.first(seq16333);
var seq16333__$1 = cljs.core.next(seq16333);
var G__16335 = cljs.core.first(seq16333__$1);
var seq16333__$2 = cljs.core.next(seq16333__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__16334,G__16335,seq16333__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(){
var G__16346 = arguments.length;
switch (G__16346) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__16348 = y;
var G__16349 = cljs.core.first(more);
var G__16350 = cljs.core.next(more);
x = G__16348;
y = G__16349;
more = G__16350;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq16342){
var G__16343 = cljs.core.first(seq16342);
var seq16342__$1 = cljs.core.next(seq16342);
var G__16344 = cljs.core.first(seq16342__$1);
var seq16342__$2 = cljs.core.next(seq16342__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16343,G__16344,seq16342__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(){
var G__16355 = arguments.length;
switch (G__16355) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4588__auto__ = x;
var y__4589__auto__ = y;
return ((x__4588__auto__ > y__4589__auto__) ? x__4588__auto__ : y__4589__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4588__auto__ = x;
var y__4589__auto__ = y;
return ((x__4588__auto__ > y__4589__auto__) ? x__4588__auto__ : y__4589__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq16351){
var G__16352 = cljs.core.first(seq16351);
var seq16351__$1 = cljs.core.next(seq16351);
var G__16353 = cljs.core.first(seq16351__$1);
var seq16351__$2 = cljs.core.next(seq16351__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__16352,G__16353,seq16351__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = 2;
/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(){
var G__16361 = arguments.length;
switch (G__16361) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4595__auto__ = x;
var y__4596__auto__ = y;
return ((x__4595__auto__ < y__4596__auto__) ? x__4595__auto__ : y__4596__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4595__auto__ = x;
var y__4596__auto__ = y;
return ((x__4595__auto__ < y__4596__auto__) ? x__4595__auto__ : y__4596__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq16357){
var G__16358 = cljs.core.first(seq16357);
var seq16357__$1 = cljs.core.next(seq16357);
var G__16359 = cljs.core.first(seq16357__$1);
var seq16357__$2 = cljs.core.next(seq16357__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__16358,G__16359,seq16357__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(){
var G__16367 = arguments.length;
switch (G__16367) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq16363){
var G__16364 = cljs.core.first(seq16363);
var seq16363__$1 = cljs.core.next(seq16363);
var G__16365 = cljs.core.first(seq16363__$1);
var seq16363__$2 = cljs.core.next(seq16363__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__16364,G__16365,seq16363__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(){
var G__16373 = arguments.length;
switch (G__16373) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq16369){
var G__16370 = cljs.core.first(seq16369);
var seq16369__$1 = cljs.core.next(seq16369);
var G__16371 = cljs.core.first(seq16369__$1);
var seq16369__$2 = cljs.core.next(seq16369__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__16370,G__16371,seq16369__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(){
var G__16379 = arguments.length;
switch (G__16379) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq16375){
var G__16376 = cljs.core.first(seq16375);
var seq16375__$1 = cljs.core.next(seq16375);
var G__16377 = cljs.core.first(seq16375__$1);
var seq16375__$2 = cljs.core.next(seq16375__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__16376,G__16377,seq16375__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(){
var G__16385 = arguments.length;
switch (G__16385) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq16381){
var G__16382 = cljs.core.first(seq16381);
var seq16381__$1 = cljs.core.next(seq16381);
var G__16383 = cljs.core.first(seq16381__$1);
var seq16381__$2 = cljs.core.next(seq16381__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__16382,G__16383,seq16381__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(){
var G__16391 = arguments.length;
switch (G__16391) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq16387){
var G__16388 = cljs.core.first(seq16387);
var seq16387__$1 = cljs.core.next(seq16387);
var G__16389 = cljs.core.first(seq16387__$1);
var seq16387__$2 = cljs.core.next(seq16387__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__16388,G__16389,seq16387__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__16395 = x;
var G__16396 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__16395,G__16396) : cljs.core.mod.call(null,G__16395,G__16396));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(){
var G__16401 = arguments.length;
switch (G__16401) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq16397){
var G__16398 = cljs.core.first(seq16397);
var seq16397__$1 = cljs.core.next(seq16397);
var G__16399 = cljs.core.first(seq16397__$1);
var seq16397__$2 = cljs.core.next(seq16397__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__16398,G__16399,seq16397__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(){
var G__16407 = arguments.length;
switch (G__16407) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq16403){
var G__16404 = cljs.core.first(seq16403);
var seq16403__$1 = cljs.core.next(seq16403);
var G__16405 = cljs.core.first(seq16403__$1);
var seq16403__$2 = cljs.core.next(seq16403__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__16404,G__16405,seq16403__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__16411 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__16411) : Math.floor.call(null,G__16411));
} else {
var G__16412 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__16412) : Math.ceil.call(null,G__16412));
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(){
var G__16417 = arguments.length;
switch (G__16417) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq16413){
var G__16414 = cljs.core.first(seq16413);
var seq16413__$1 = cljs.core.next(seq16413);
var G__16415 = cljs.core.first(seq16413__$1);
var seq16413__$2 = cljs.core.next(seq16413__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__16414,G__16415,seq16413__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(){
var G__16423 = arguments.length;
switch (G__16423) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq16419){
var G__16420 = cljs.core.first(seq16419);
var seq16419__$1 = cljs.core.next(seq16419);
var G__16421 = cljs.core.first(seq16419__$1);
var seq16419__$2 = cljs.core.next(seq16419__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__16420,G__16421,seq16419__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(){
var G__16429 = arguments.length;
switch (G__16429) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq16425){
var G__16426 = cljs.core.first(seq16425);
var seq16425__$1 = cljs.core.next(seq16425);
var G__16427 = cljs.core.first(seq16425__$1);
var seq16425__$2 = cljs.core.next(seq16425__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__16426,G__16427,seq16425__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise and
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(){
var G__16435 = arguments.length;
switch (G__16435) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq16431){
var G__16432 = cljs.core.first(seq16431);
var seq16431__$1 = cljs.core.next(seq16431);
var G__16433 = cljs.core.first(seq16431__$1);
var seq16431__$2 = cljs.core.next(seq16431__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__16432,G__16433,seq16431__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(){
var G__16441 = arguments.length;
switch (G__16441) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__16443 = y;
var G__16444 = cljs.core.first(more);
var G__16445 = cljs.core.next(more);
x = G__16443;
y = G__16444;
more = G__16445;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq16437){
var G__16438 = cljs.core.first(seq16437);
var seq16437__$1 = cljs.core.next(seq16437);
var G__16439 = cljs.core.first(seq16437__$1);
var seq16437__$2 = cljs.core.next(seq16437__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16438,G__16439,seq16437__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__16446 = (n__$1 - (1));
var G__16447 = cljs.core.next(xs);
n__$1 = G__16446;
xs = G__16447;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(){
var G__16451 = arguments.length;
switch (G__16451) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5328__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
var G__16452 = x;
return goog.string.buildString(G__16452);
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__16454 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__16455 = cljs.core.next(more);
sb = G__16454;
more = G__16455;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq16448){
var G__16449 = cljs.core.first(seq16448);
var seq16448__$1 = cljs.core.next(seq16448);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__16449,seq16448__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = 1;
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(){
var G__16457 = arguments.length;
switch (G__16457) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__16459 = cljs.core.next(xs);
var G__16460 = cljs.core.next(ys);
xs = G__16459;
ys = G__16460;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__16461 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__16462 = cljs.core.next(s);
res = G__16461;
s = G__16462;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__16467 = ((h + (cljs.core.hash((function (){var G__16465 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__16465) : cljs.core.key.call(null,G__16465));
})()) ^ cljs.core.hash((function (){var G__16466 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__16466) : cljs.core.val.call(null,G__16466));
})()))) % (4503599627370496));
var G__16468 = cljs.core.next(s);
h = G__16467;
s = G__16468;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__16469 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__16470 = cljs.core.next(s__$1);
h = G__16469;
s__$1 = G__16470;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__16481_16491 = cljs.core.seq(fn_map);
var chunk__16482_16492 = null;
var count__16483_16493 = (0);
var i__16484_16494 = (0);
while(true){
if((i__16484_16494 < count__16483_16493)){
var vec__16485_16495 = chunk__16482_16492.cljs$core$IIndexed$_nth$arity$2(null,i__16484_16494);
var key_name_16496 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16485_16495,(0),null);
var f_16497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16485_16495,(1),null);
var str_name_16498 = (function (){var G__16486 = key_name_16496;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16486) : cljs.core.name.call(null,G__16486));
})();
(obj[str_name_16498] = f_16497);

var G__16499 = seq__16481_16491;
var G__16500 = chunk__16482_16492;
var G__16501 = count__16483_16493;
var G__16502 = (i__16484_16494 + (1));
seq__16481_16491 = G__16499;
chunk__16482_16492 = G__16500;
count__16483_16493 = G__16501;
i__16484_16494 = G__16502;
continue;
} else {
var temp__4126__auto___16503 = cljs.core.seq(seq__16481_16491);
if(temp__4126__auto___16503){
var seq__16481_16504__$1 = temp__4126__auto___16503;
if(cljs.core.chunked_seq_QMARK_(seq__16481_16504__$1)){
var c__5061__auto___16505 = (function (){var G__16487 = seq__16481_16504__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__16487) : cljs.core.chunk_first.call(null,G__16487));
})();
var G__16506 = (function (){var G__16488 = seq__16481_16504__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__16488) : cljs.core.chunk_rest.call(null,G__16488));
})();
var G__16507 = c__5061__auto___16505;
var G__16508 = cljs.core.count(c__5061__auto___16505);
var G__16509 = (0);
seq__16481_16491 = G__16506;
chunk__16482_16492 = G__16507;
count__16483_16493 = G__16508;
i__16484_16494 = G__16509;
continue;
} else {
var vec__16489_16510 = cljs.core.first(seq__16481_16504__$1);
var key_name_16511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16489_16510,(0),null);
var f_16512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16489_16510,(1),null);
var str_name_16513 = (function (){var G__16490 = key_name_16511;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16490) : cljs.core.name.call(null,G__16490));
})();
(obj[str_name_16513] = f_16512);

var G__16514 = cljs.core.next(seq__16481_16504__$1);
var G__16515 = null;
var G__16516 = (0);
var G__16517 = (0);
seq__16481_16491 = G__16514;
chunk__16482_16492 = G__16515;
count__16483_16493 = G__16516;
i__16484_16494 = G__16517;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__16519 = coll;
if(G__16519){
var bit__4950__auto__ = (G__16519.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4950__auto__) || (G__16519.cljs$core$IReversible$)){
return true;
} else {
if((!G__16519.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__16519);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__16519);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__16521 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__16521;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__16522 = (i - (1));
var G__16523 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__16522;
r = G__16523;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq16520){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16520));
});

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__4276__auto__ = (coll == null);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var G__16527 = coll;
if(G__16527){
var bit__4943__auto__ = (G__16527.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4943__auto__) || (G__16527.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__16529 = x;
if(G__16529){
var bit__4950__auto__ = (G__16529.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4950__auto__) || (G__16529.cljs$core$IList$)){
return true;
} else {
if((!G__16529.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__16529);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__16529);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not(a.ns);
if(and__4264__auto__){
return b.ns;
} else {
return and__4264__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__16536 = a.ns;
var G__16537 = b.ns;
return goog.array.defaultCompare(G__16536,G__16537);
})();
if(((0) === nsc)){
var G__16538 = a.name;
var G__16539 = b.name;
return goog.array.defaultCompare(G__16538,G__16539);
} else {
return nsc;
}
}
} else {
var G__16540 = a.name;
var G__16541 = b.name;
return goog.array.defaultCompare(G__16540,G__16541);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4692__auto__ = self__._hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__16543 = null;
var G__16543__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__16543__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__16543 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__16543__2.call(this,self__,coll);
case 3:
return G__16543__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16543.cljs$core$IFn$_invoke$arity$2 = G__16543__2;
G__16543.cljs$core$IFn$_invoke$arity$3 = G__16543__3;
return G__16543;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args16542){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args16542)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__16545 = x;
if(G__16545){
var bit__4943__auto__ = (G__16545.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4943__auto__) || (G__16545.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(){
var G__16547 = arguments.length;
switch (G__16547) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__16548 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16548) : cljs.core.name.call(null,G__16548));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__16550 = ls.sval();
ls = G__16550;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(){
var G__16552 = arguments.length;
switch (G__16552) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__16555 = s;
if(G__16555){
var bit__4943__auto__ = (G__16555.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4943__auto__) || (G__16555.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__16556 = cljs.core.next(s__$1);
s__$1 = G__16556;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_16557 = (0);
var xs_16558 = cljs.core.seq(coll);
while(true){
if(xs_16558){
(ret[i_16557] = cljs.core.to_array(cljs.core.first(xs_16558)));

var G__16559 = (i_16557 + (1));
var G__16560 = cljs.core.next(xs_16558);
i_16557 = G__16559;
xs_16558 = G__16560;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(){
var G__16562 = arguments.length;
switch (G__16562) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__16564 = (i + (1));
var G__16565 = cljs.core.next(s__$1);
i = G__16564;
s__$1 = G__16565;
continue;
} else {
return a;
}
break;
}
} else {
var n__5161__auto___16566 = size;
var i_16567 = (0);
while(true){
if((i_16567 < n__5161__auto___16566)){
(a[i_16567] = init_val_or_seq);

var G__16568 = (i_16567 + (1));
i_16567 = G__16568;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(){
var G__16570 = arguments.length;
switch (G__16570) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__16572 = (i + (1));
var G__16573 = cljs.core.next(s__$1);
i = G__16572;
s__$1 = G__16573;
continue;
} else {
return a;
}
break;
}
} else {
var n__5161__auto___16574 = size;
var i_16575 = (0);
while(true){
if((i_16575 < n__5161__auto___16574)){
(a[i_16575] = init_val_or_seq);

var G__16576 = (i_16575 + (1));
i_16575 = G__16576;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(){
var G__16578 = arguments.length;
switch (G__16578) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__16580 = (i + (1));
var G__16581 = cljs.core.next(s__$1);
i = G__16580;
s__$1 = G__16581;
continue;
} else {
return a;
}
break;
}
} else {
var n__5161__auto___16582 = size;
var i_16583 = (0);
while(true){
if((i_16583 < n__5161__auto___16582)){
(a[i_16583] = init_val_or_seq);

var G__16584 = (i_16583 + (1));
i_16583 = G__16584;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(){
var G__16586 = arguments.length;
switch (G__16586) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__16588 = (i + (1));
var G__16589 = cljs.core.next(s__$1);
i = G__16588;
s__$1 = G__16589;
continue;
} else {
return a;
}
break;
}
} else {
var n__5161__auto___16590 = size;
var i_16591 = (0);
while(true){
if((i_16591 < n__5161__auto___16590)){
(a[i_16591] = init_val_or_seq);

var G__16592 = (i_16591 + (1));
i_16591 = G__16592;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__16593 = cljs.core.next(s__$1);
var G__16594 = (i - (1));
var G__16595 = (sum + (1));
s__$1 = G__16593;
i = G__16594;
sum = G__16595;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(){
var G__16601 = arguments.length;
switch (G__16601) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq16597){
var G__16598 = cljs.core.first(seq16597);
var seq16597__$1 = cljs.core.next(seq16597);
var G__16599 = cljs.core.first(seq16597__$1);
var seq16597__$2 = cljs.core.next(seq16597__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__16598,G__16599,seq16597__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = 2;
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(){
var G__16615 = arguments.length;
switch (G__16615) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq16609){
var G__16610 = cljs.core.first(seq16609);
var seq16609__$1 = cljs.core.next(seq16609);
var G__16611 = cljs.core.first(seq16609__$1);
var seq16609__$2 = cljs.core.next(seq16609__$1);
var G__16612 = cljs.core.first(seq16609__$2);
var seq16609__$3 = cljs.core.next(seq16609__$2);
var G__16613 = cljs.core.first(seq16609__$3);
var seq16609__$4 = cljs.core.next(seq16609__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16610,G__16611,G__16612,G__16613,seq16609__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(){
var G__16621 = arguments.length;
switch (G__16621) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__16623 = ntcoll;
var G__16624 = cljs.core.first(vals);
var G__16625 = cljs.core.next(vals);
tcoll = G__16623;
val = G__16624;
vals = G__16625;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq16617){
var G__16618 = cljs.core.first(seq16617);
var seq16617__$1 = cljs.core.next(seq16617);
var G__16619 = cljs.core.first(seq16617__$1);
var seq16617__$2 = cljs.core.next(seq16617__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16618,G__16619,seq16617__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(){
var G__16631 = arguments.length;
switch (G__16631) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__16633 = ntcoll;
var G__16634 = cljs.core.first(kvs);
var G__16635 = cljs.core.second(kvs);
var G__16636 = cljs.core.nnext(kvs);
tcoll = G__16633;
key = G__16634;
val = G__16635;
kvs = G__16636;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq16626){
var G__16627 = cljs.core.first(seq16626);
var seq16626__$1 = cljs.core.next(seq16626);
var G__16628 = cljs.core.first(seq16626__$1);
var seq16626__$2 = cljs.core.next(seq16626__$1);
var G__16629 = cljs.core.first(seq16626__$2);
var seq16626__$3 = cljs.core.next(seq16626__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16627,G__16628,G__16629,seq16626__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(){
var G__16641 = arguments.length;
switch (G__16641) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__16643 = ntcoll;
var G__16644 = cljs.core.first(ks);
var G__16645 = cljs.core.next(ks);
tcoll = G__16643;
key = G__16644;
ks = G__16645;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq16637){
var G__16638 = cljs.core.first(seq16637);
var seq16637__$1 = cljs.core.next(seq16637);
var G__16639 = cljs.core.first(seq16637__$1);
var seq16637__$2 = cljs.core.next(seq16637__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16638,G__16639,seq16637__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(){
var G__16650 = arguments.length;
switch (G__16650) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__16652 = ntcoll;
var G__16653 = cljs.core.first(vals);
var G__16654 = cljs.core.next(vals);
tcoll = G__16652;
val = G__16653;
vals = G__16654;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq16646){
var G__16647 = cljs.core.first(seq16646);
var seq16646__$1 = cljs.core.next(seq16646);
var G__16648 = cljs.core.first(seq16646__$1);
var seq16646__$2 = cljs.core.next(seq16646__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16647,G__16648,seq16646__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a5205 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a5205);
} else {
var G__16865 = a5205;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16865) : f.call(null,G__16865));
}
} else {
var b5206 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a5205,b5206);
} else {
var G__16866 = a5205;
var G__16867 = b5206;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16866,G__16867) : f.call(null,G__16866,G__16867));
}
} else {
var c5207 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a5205,b5206,c5207);
} else {
var G__16868 = a5205;
var G__16869 = b5206;
var G__16870 = c5207;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16868,G__16869,G__16870) : f.call(null,G__16868,G__16869,G__16870));
}
} else {
var d5208 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a5205,b5206,c5207,d5208);
} else {
var G__16871 = a5205;
var G__16872 = b5206;
var G__16873 = c5207;
var G__16874 = d5208;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16871,G__16872,G__16873,G__16874) : f.call(null,G__16871,G__16872,G__16873,G__16874));
}
} else {
var e5209 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a5205,b5206,c5207,d5208,e5209);
} else {
var G__16875 = a5205;
var G__16876 = b5206;
var G__16877 = c5207;
var G__16878 = d5208;
var G__16879 = e5209;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__16875,G__16876,G__16877,G__16878,G__16879) : f.call(null,G__16875,G__16876,G__16877,G__16878,G__16879));
}
} else {
var f5210 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a5205,b5206,c5207,d5208,e5209,f5210);
} else {
var G__16880 = a5205;
var G__16881 = b5206;
var G__16882 = c5207;
var G__16883 = d5208;
var G__16884 = e5209;
var G__16885 = f5210;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__16880,G__16881,G__16882,G__16883,G__16884,G__16885) : f.call(null,G__16880,G__16881,G__16882,G__16883,G__16884,G__16885));
}
} else {
var g5211 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a5205,b5206,c5207,d5208,e5209,f5210,g5211);
} else {
var G__16886 = a5205;
var G__16887 = b5206;
var G__16888 = c5207;
var G__16889 = d5208;
var G__16890 = e5209;
var G__16891 = f5210;
var G__16892 = g5211;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__16886,G__16887,G__16888,G__16889,G__16890,G__16891,G__16892) : f.call(null,G__16886,G__16887,G__16888,G__16889,G__16890,G__16891,G__16892));
}
} else {
var h5212 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212);
} else {
var G__16893 = a5205;
var G__16894 = b5206;
var G__16895 = c5207;
var G__16896 = d5208;
var G__16897 = e5209;
var G__16898 = f5210;
var G__16899 = g5211;
var G__16900 = h5212;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__16893,G__16894,G__16895,G__16896,G__16897,G__16898,G__16899,G__16900) : f.call(null,G__16893,G__16894,G__16895,G__16896,G__16897,G__16898,G__16899,G__16900));
}
} else {
var i5213 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213);
} else {
var G__16901 = a5205;
var G__16902 = b5206;
var G__16903 = c5207;
var G__16904 = d5208;
var G__16905 = e5209;
var G__16906 = f5210;
var G__16907 = g5211;
var G__16908 = h5212;
var G__16909 = i5213;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__16901,G__16902,G__16903,G__16904,G__16905,G__16906,G__16907,G__16908,G__16909) : f.call(null,G__16901,G__16902,G__16903,G__16904,G__16905,G__16906,G__16907,G__16908,G__16909));
}
} else {
var j5214 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214);
} else {
var G__16910 = a5205;
var G__16911 = b5206;
var G__16912 = c5207;
var G__16913 = d5208;
var G__16914 = e5209;
var G__16915 = f5210;
var G__16916 = g5211;
var G__16917 = h5212;
var G__16918 = i5213;
var G__16919 = j5214;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__16910,G__16911,G__16912,G__16913,G__16914,G__16915,G__16916,G__16917,G__16918,G__16919) : f.call(null,G__16910,G__16911,G__16912,G__16913,G__16914,G__16915,G__16916,G__16917,G__16918,G__16919));
}
} else {
var k5215 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215);
} else {
var G__16920 = a5205;
var G__16921 = b5206;
var G__16922 = c5207;
var G__16923 = d5208;
var G__16924 = e5209;
var G__16925 = f5210;
var G__16926 = g5211;
var G__16927 = h5212;
var G__16928 = i5213;
var G__16929 = j5214;
var G__16930 = k5215;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__16920,G__16921,G__16922,G__16923,G__16924,G__16925,G__16926,G__16927,G__16928,G__16929,G__16930) : f.call(null,G__16920,G__16921,G__16922,G__16923,G__16924,G__16925,G__16926,G__16927,G__16928,G__16929,G__16930));
}
} else {
var l5216 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216);
} else {
var G__16931 = a5205;
var G__16932 = b5206;
var G__16933 = c5207;
var G__16934 = d5208;
var G__16935 = e5209;
var G__16936 = f5210;
var G__16937 = g5211;
var G__16938 = h5212;
var G__16939 = i5213;
var G__16940 = j5214;
var G__16941 = k5215;
var G__16942 = l5216;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__16931,G__16932,G__16933,G__16934,G__16935,G__16936,G__16937,G__16938,G__16939,G__16940,G__16941,G__16942) : f.call(null,G__16931,G__16932,G__16933,G__16934,G__16935,G__16936,G__16937,G__16938,G__16939,G__16940,G__16941,G__16942));
}
} else {
var m5217 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217);
} else {
var G__16943 = a5205;
var G__16944 = b5206;
var G__16945 = c5207;
var G__16946 = d5208;
var G__16947 = e5209;
var G__16948 = f5210;
var G__16949 = g5211;
var G__16950 = h5212;
var G__16951 = i5213;
var G__16952 = j5214;
var G__16953 = k5215;
var G__16954 = l5216;
var G__16955 = m5217;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__16943,G__16944,G__16945,G__16946,G__16947,G__16948,G__16949,G__16950,G__16951,G__16952,G__16953,G__16954,G__16955) : f.call(null,G__16943,G__16944,G__16945,G__16946,G__16947,G__16948,G__16949,G__16950,G__16951,G__16952,G__16953,G__16954,G__16955));
}
} else {
var n5218 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218);
} else {
var G__16956 = a5205;
var G__16957 = b5206;
var G__16958 = c5207;
var G__16959 = d5208;
var G__16960 = e5209;
var G__16961 = f5210;
var G__16962 = g5211;
var G__16963 = h5212;
var G__16964 = i5213;
var G__16965 = j5214;
var G__16966 = k5215;
var G__16967 = l5216;
var G__16968 = m5217;
var G__16969 = n5218;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__16956,G__16957,G__16958,G__16959,G__16960,G__16961,G__16962,G__16963,G__16964,G__16965,G__16966,G__16967,G__16968,G__16969) : f.call(null,G__16956,G__16957,G__16958,G__16959,G__16960,G__16961,G__16962,G__16963,G__16964,G__16965,G__16966,G__16967,G__16968,G__16969));
}
} else {
var o5219 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219);
} else {
var G__16970 = a5205;
var G__16971 = b5206;
var G__16972 = c5207;
var G__16973 = d5208;
var G__16974 = e5209;
var G__16975 = f5210;
var G__16976 = g5211;
var G__16977 = h5212;
var G__16978 = i5213;
var G__16979 = j5214;
var G__16980 = k5215;
var G__16981 = l5216;
var G__16982 = m5217;
var G__16983 = n5218;
var G__16984 = o5219;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__16970,G__16971,G__16972,G__16973,G__16974,G__16975,G__16976,G__16977,G__16978,G__16979,G__16980,G__16981,G__16982,G__16983,G__16984) : f.call(null,G__16970,G__16971,G__16972,G__16973,G__16974,G__16975,G__16976,G__16977,G__16978,G__16979,G__16980,G__16981,G__16982,G__16983,G__16984));
}
} else {
var p5220 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219,p5220);
} else {
var G__16985 = a5205;
var G__16986 = b5206;
var G__16987 = c5207;
var G__16988 = d5208;
var G__16989 = e5209;
var G__16990 = f5210;
var G__16991 = g5211;
var G__16992 = h5212;
var G__16993 = i5213;
var G__16994 = j5214;
var G__16995 = k5215;
var G__16996 = l5216;
var G__16997 = m5217;
var G__16998 = n5218;
var G__16999 = o5219;
var G__17000 = p5220;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__16985,G__16986,G__16987,G__16988,G__16989,G__16990,G__16991,G__16992,G__16993,G__16994,G__16995,G__16996,G__16997,G__16998,G__16999,G__17000) : f.call(null,G__16985,G__16986,G__16987,G__16988,G__16989,G__16990,G__16991,G__16992,G__16993,G__16994,G__16995,G__16996,G__16997,G__16998,G__16999,G__17000));
}
} else {
var q5221 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219,p5220,q5221);
} else {
var G__17001 = a5205;
var G__17002 = b5206;
var G__17003 = c5207;
var G__17004 = d5208;
var G__17005 = e5209;
var G__17006 = f5210;
var G__17007 = g5211;
var G__17008 = h5212;
var G__17009 = i5213;
var G__17010 = j5214;
var G__17011 = k5215;
var G__17012 = l5216;
var G__17013 = m5217;
var G__17014 = n5218;
var G__17015 = o5219;
var G__17016 = p5220;
var G__17017 = q5221;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__17001,G__17002,G__17003,G__17004,G__17005,G__17006,G__17007,G__17008,G__17009,G__17010,G__17011,G__17012,G__17013,G__17014,G__17015,G__17016,G__17017) : f.call(null,G__17001,G__17002,G__17003,G__17004,G__17005,G__17006,G__17007,G__17008,G__17009,G__17010,G__17011,G__17012,G__17013,G__17014,G__17015,G__17016,G__17017));
}
} else {
var r5222 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219,p5220,q5221,r5222);
} else {
var G__17018 = a5205;
var G__17019 = b5206;
var G__17020 = c5207;
var G__17021 = d5208;
var G__17022 = e5209;
var G__17023 = f5210;
var G__17024 = g5211;
var G__17025 = h5212;
var G__17026 = i5213;
var G__17027 = j5214;
var G__17028 = k5215;
var G__17029 = l5216;
var G__17030 = m5217;
var G__17031 = n5218;
var G__17032 = o5219;
var G__17033 = p5220;
var G__17034 = q5221;
var G__17035 = r5222;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__17018,G__17019,G__17020,G__17021,G__17022,G__17023,G__17024,G__17025,G__17026,G__17027,G__17028,G__17029,G__17030,G__17031,G__17032,G__17033,G__17034,G__17035) : f.call(null,G__17018,G__17019,G__17020,G__17021,G__17022,G__17023,G__17024,G__17025,G__17026,G__17027,G__17028,G__17029,G__17030,G__17031,G__17032,G__17033,G__17034,G__17035));
}
} else {
var s5223 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219,p5220,q5221,r5222,s5223);
} else {
var G__17036 = a5205;
var G__17037 = b5206;
var G__17038 = c5207;
var G__17039 = d5208;
var G__17040 = e5209;
var G__17041 = f5210;
var G__17042 = g5211;
var G__17043 = h5212;
var G__17044 = i5213;
var G__17045 = j5214;
var G__17046 = k5215;
var G__17047 = l5216;
var G__17048 = m5217;
var G__17049 = n5218;
var G__17050 = o5219;
var G__17051 = p5220;
var G__17052 = q5221;
var G__17053 = r5222;
var G__17054 = s5223;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__17036,G__17037,G__17038,G__17039,G__17040,G__17041,G__17042,G__17043,G__17044,G__17045,G__17046,G__17047,G__17048,G__17049,G__17050,G__17051,G__17052,G__17053,G__17054) : f.call(null,G__17036,G__17037,G__17038,G__17039,G__17040,G__17041,G__17042,G__17043,G__17044,G__17045,G__17046,G__17047,G__17048,G__17049,G__17050,G__17051,G__17052,G__17053,G__17054));
}
} else {
var t5224 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a5205,b5206,c5207,d5208,e5209,f5210,g5211,h5212,i5213,j5214,k5215,l5216,m5217,n5218,o5219,p5220,q5221,r5222,s5223,t5224);
} else {
var G__17055 = a5205;
var G__17056 = b5206;
var G__17057 = c5207;
var G__17058 = d5208;
var G__17059 = e5209;
var G__17060 = f5210;
var G__17061 = g5211;
var G__17062 = h5212;
var G__17063 = i5213;
var G__17064 = j5214;
var G__17065 = k5215;
var G__17066 = l5216;
var G__17067 = m5217;
var G__17068 = n5218;
var G__17069 = o5219;
var G__17070 = p5220;
var G__17071 = q5221;
var G__17072 = r5222;
var G__17073 = s5223;
var G__17074 = t5224;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__17055,G__17056,G__17057,G__17058,G__17059,G__17060,G__17061,G__17062,G__17063,G__17064,G__17065,G__17066,G__17067,G__17068,G__17069,G__17070,G__17071,G__17072,G__17073,G__17074) : f.call(null,G__17055,G__17056,G__17057,G__17058,G__17059,G__17060,G__17061,G__17062,G__17063,G__17064,G__17065,G__17066,G__17067,G__17068,G__17069,G__17070,G__17071,G__17072,G__17073,G__17074));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(){
var G__17082 = arguments.length;
switch (G__17082) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,5),(0)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5328__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq17075){
var G__17076 = cljs.core.first(seq17075);
var seq17075__$1 = cljs.core.next(seq17075);
var G__17077 = cljs.core.first(seq17075__$1);
var seq17075__$2 = cljs.core.next(seq17075__$1);
var G__17078 = cljs.core.first(seq17075__$2);
var seq17075__$3 = cljs.core.next(seq17075__$2);
var G__17079 = cljs.core.first(seq17075__$3);
var seq17075__$4 = cljs.core.next(seq17075__$3);
var G__17080 = cljs.core.first(seq17075__$4);
var seq17075__$5 = cljs.core.next(seq17075__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__17076,G__17077,G__17078,G__17079,G__17080,seq17075__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = 5;
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(){
var G__17092 = arguments.length;
switch (G__17092) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5328__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__17093 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17093) : f.call(null,G__17093));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__17094 = cljs.core.meta(obj);
var G__17095 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17094,G__17095) : f.call(null,G__17094,G__17095));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__17096 = cljs.core.meta(obj);
var G__17097 = a;
var G__17098 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17096,G__17097,G__17098) : f.call(null,G__17096,G__17097,G__17098));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__17099 = cljs.core.meta(obj);
var G__17100 = a;
var G__17101 = b;
var G__17102 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17099,G__17100,G__17101,G__17102) : f.call(null,G__17099,G__17100,G__17101,G__17102));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__17103 = cljs.core.meta(obj);
var G__17104 = a;
var G__17105 = b;
var G__17106 = c;
var G__17107 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17103,G__17104,G__17105,G__17106,G__17107) : f.call(null,G__17103,G__17104,G__17105,G__17106,G__17107));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq17084){
var G__17085 = cljs.core.first(seq17084);
var seq17084__$1 = cljs.core.next(seq17084);
var G__17086 = cljs.core.first(seq17084__$1);
var seq17084__$2 = cljs.core.next(seq17084__$1);
var G__17087 = cljs.core.first(seq17084__$2);
var seq17084__$3 = cljs.core.next(seq17084__$2);
var G__17088 = cljs.core.first(seq17084__$3);
var seq17084__$4 = cljs.core.next(seq17084__$3);
var G__17089 = cljs.core.first(seq17084__$4);
var seq17084__$5 = cljs.core.next(seq17084__$4);
var G__17090 = cljs.core.first(seq17084__$5);
var seq17084__$6 = cljs.core.next(seq17084__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__17085,G__17086,G__17087,G__17088,G__17089,G__17090,seq17084__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(){
var G__17113 = arguments.length;
switch (G__17113) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq17109){
var G__17110 = cljs.core.first(seq17109);
var seq17109__$1 = cljs.core.next(seq17109);
var G__17111 = cljs.core.first(seq17109__$1);
var seq17109__$2 = cljs.core.next(seq17109__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17110,G__17111,seq17109__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t17118 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t17118 = (function (nil_iter,meta17119){
this.nil_iter = nil_iter;
this.meta17119 = meta17119;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t17118.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t17118.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t17118.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t17118.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17120){
var self__ = this;
var _17120__$1 = this;
return self__.meta17119;
});

cljs.core.t17118.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17120,meta17119__$1){
var self__ = this;
var _17120__$1 = this;
return (new cljs.core.t17118(self__.nil_iter,meta17119__$1));
});

cljs.core.t17118.cljs$lang$type = true;

cljs.core.t17118.cljs$lang$ctorStr = "cljs.core/t17118";

cljs.core.t17118.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/t17118");
});

cljs.core.__GT_t17118 = (function cljs$core$nil_iter_$___GT_t17118(nil_iter__$1,meta17119){
return (new cljs.core.t17118(nil_iter__$1,meta17119));
});

}

return (new cljs.core.t17118(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.truth_(cljs.core.iterable_QMARK_(coll))){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__4264__auto__ = !((lt.stepper == null));
if(and__4264__auto__){
return self__.iter.hasNext();
} else {
return and__4264__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__17121 = lt;
var G__17122 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__17121,G__17122) : self__.xform.call(null,G__17121,G__17122));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__17123 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__17123) : self__.xform.call(null,G__17123));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__17125 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__17125) : xform.call(null,G__17125));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__17127 = cljs.core.next(iters__$1);
iters__$1 = G__17127;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__5161__auto___17128 = self__.iters.length;
var i_17129 = (0);
while(true){
if((i_17129 < n__5161__auto___17128)){
(self__.nexts[i_17129] = (self__.iters[i_17129]).next());

var G__17130 = (i_17129 + (1));
i_17129 = G__17130;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__4264__auto__ = !((lt.stepper == null));
if(and__4264__auto__){
return this$.hasNext();
} else {
return and__4264__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__17126 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__17126) : self__.xform.call(null,G__17126));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(){
var G__17132 = arguments.length;
switch (G__17132) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__17133 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__17133) : xform.call(null,G__17133));
})(),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__17135_17139 = cljs.core.seq(colls);
var chunk__17136_17140 = null;
var count__17137_17141 = (0);
var i__17138_17142 = (0);
while(true){
if((i__17138_17142 < count__17137_17141)){
var coll_17143 = chunk__17136_17140.cljs$core$IIndexed$_nth$arity$2(null,i__17138_17142);
iters.push(cljs.core.iter(coll_17143));

var G__17144 = seq__17135_17139;
var G__17145 = chunk__17136_17140;
var G__17146 = count__17137_17141;
var G__17147 = (i__17138_17142 + (1));
seq__17135_17139 = G__17144;
chunk__17136_17140 = G__17145;
count__17137_17141 = G__17146;
i__17138_17142 = G__17147;
continue;
} else {
var temp__4126__auto___17148 = cljs.core.seq(seq__17135_17139);
if(temp__4126__auto___17148){
var seq__17135_17149__$1 = temp__4126__auto___17148;
if(cljs.core.chunked_seq_QMARK_(seq__17135_17149__$1)){
var c__5061__auto___17150 = cljs.core.chunk_first(seq__17135_17149__$1);
var G__17151 = cljs.core.chunk_rest(seq__17135_17149__$1);
var G__17152 = c__5061__auto___17150;
var G__17153 = cljs.core.count(c__5061__auto___17150);
var G__17154 = (0);
seq__17135_17139 = G__17151;
chunk__17136_17140 = G__17152;
count__17137_17141 = G__17153;
i__17138_17142 = G__17154;
continue;
} else {
var coll_17155 = cljs.core.first(seq__17135_17149__$1);
iters.push(cljs.core.iter(coll_17155));

var G__17156 = cljs.core.next(seq__17135_17149__$1);
var G__17157 = null;
var G__17158 = (0);
var G__17159 = (0);
seq__17135_17139 = G__17156;
chunk__17136_17140 = G__17157;
count__17137_17141 = G__17158;
i__17138_17142 = G__17159;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(){
var G__17164 = arguments.length;
switch (G__17164) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__4276__auto__ = cljs.core.seq(coll);
if(or__4276__auto__){
return or__4276__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq17160){
var G__17161 = cljs.core.first(seq17160);
var seq17160__$1 = cljs.core.next(seq17160);
var G__17162 = cljs.core.first(seq17160__$1);
var seq17160__$2 = cljs.core.next(seq17160__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__17161,G__17162,seq17160__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__17167 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17167) : pred.call(null,G__17167));
})())){
var G__17168 = pred;
var G__17169 = cljs.core.next(coll);
pred = G__17168;
coll = G__17169;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__4276__auto__ = (function (){var G__17173 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17173) : pred.call(null,G__17173));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var G__17174 = pred;
var G__17175 = cljs.core.next(coll);
pred = G__17174;
coll = G__17175;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__17182 = null;
var G__17182__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__17182__1 = (function (x){
return cljs.core.not((function (){var G__17179 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17179) : f.call(null,G__17179));
})());
});
var G__17182__2 = (function (x,y){
return cljs.core.not((function (){var G__17180 = x;
var G__17181 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17180,G__17181) : f.call(null,G__17180,G__17181));
})());
});
var G__17182__3 = (function() { 
var G__17183__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__17183 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__17184__i = 0, G__17184__a = new Array(arguments.length -  2);
while (G__17184__i < G__17184__a.length) {G__17184__a[G__17184__i] = arguments[G__17184__i + 2]; ++G__17184__i;}
  zs = new cljs.core.IndexedSeq(G__17184__a,0);
} 
return G__17183__delegate.call(this,x,y,zs);};
G__17183.cljs$lang$maxFixedArity = 2;
G__17183.cljs$lang$applyTo = (function (arglist__17185){
var x = cljs.core.first(arglist__17185);
arglist__17185 = cljs.core.next(arglist__17185);
var y = cljs.core.first(arglist__17185);
var zs = cljs.core.rest(arglist__17185);
return G__17183__delegate(x,y,zs);
});
G__17183.cljs$core$IFn$_invoke$arity$variadic = G__17183__delegate;
return G__17183;
})()
;
G__17182 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__17182__0.call(this);
case 1:
return G__17182__1.call(this,x);
case 2:
return G__17182__2.call(this,x,y);
default:
var G__17186 = null;
if (arguments.length > 2) {
var G__17187__i = 0, G__17187__a = new Array(arguments.length -  2);
while (G__17187__i < G__17187__a.length) {G__17187__a[G__17187__i] = arguments[G__17187__i + 2]; ++G__17187__i;}
G__17186 = new cljs.core.IndexedSeq(G__17187__a,0);
}
return G__17182__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__17186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17182.cljs$lang$maxFixedArity = 2;
G__17182.cljs$lang$applyTo = G__17182__3.cljs$lang$applyTo;
G__17182.cljs$core$IFn$_invoke$arity$0 = G__17182__0;
G__17182.cljs$core$IFn$_invoke$arity$1 = G__17182__1;
G__17182.cljs$core$IFn$_invoke$arity$2 = G__17182__2;
G__17182.cljs$core$IFn$_invoke$arity$variadic = G__17182__3.cljs$core$IFn$_invoke$arity$variadic;
return G__17182;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__17188__delegate = function (args){
return x;
};
var G__17188 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17189__i = 0, G__17189__a = new Array(arguments.length -  0);
while (G__17189__i < G__17189__a.length) {G__17189__a[G__17189__i] = arguments[G__17189__i + 0]; ++G__17189__i;}
  args = new cljs.core.IndexedSeq(G__17189__a,0);
} 
return G__17188__delegate.call(this,args);};
G__17188.cljs$lang$maxFixedArity = 0;
G__17188.cljs$lang$applyTo = (function (arglist__17190){
var args = cljs.core.seq(arglist__17190);
return G__17188__delegate(args);
});
G__17188.cljs$core$IFn$_invoke$arity$variadic = G__17188__delegate;
return G__17188;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(){
var G__17196 = arguments.length;
switch (G__17196) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__17225 = null;
var G__17225__0 = (function (){
var G__17197 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17197) : f.call(null,G__17197));
});
var G__17225__1 = (function (x){
var G__17198 = (function (){var G__17199 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17199) : g.call(null,G__17199));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17198) : f.call(null,G__17198));
});
var G__17225__2 = (function (x,y){
var G__17200 = (function (){var G__17201 = x;
var G__17202 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__17201,G__17202) : g.call(null,G__17201,G__17202));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17200) : f.call(null,G__17200));
});
var G__17225__3 = (function (x,y,z){
var G__17203 = (function (){var G__17204 = x;
var G__17205 = y;
var G__17206 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__17204,G__17205,G__17206) : g.call(null,G__17204,G__17205,G__17206));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17203) : f.call(null,G__17203));
});
var G__17225__4 = (function() { 
var G__17226__delegate = function (x,y,z,args){
var G__17207 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17207) : f.call(null,G__17207));
};
var G__17226 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17227__i = 0, G__17227__a = new Array(arguments.length -  3);
while (G__17227__i < G__17227__a.length) {G__17227__a[G__17227__i] = arguments[G__17227__i + 3]; ++G__17227__i;}
  args = new cljs.core.IndexedSeq(G__17227__a,0);
} 
return G__17226__delegate.call(this,x,y,z,args);};
G__17226.cljs$lang$maxFixedArity = 3;
G__17226.cljs$lang$applyTo = (function (arglist__17228){
var x = cljs.core.first(arglist__17228);
arglist__17228 = cljs.core.next(arglist__17228);
var y = cljs.core.first(arglist__17228);
arglist__17228 = cljs.core.next(arglist__17228);
var z = cljs.core.first(arglist__17228);
var args = cljs.core.rest(arglist__17228);
return G__17226__delegate(x,y,z,args);
});
G__17226.cljs$core$IFn$_invoke$arity$variadic = G__17226__delegate;
return G__17226;
})()
;
G__17225 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17225__0.call(this);
case 1:
return G__17225__1.call(this,x);
case 2:
return G__17225__2.call(this,x,y);
case 3:
return G__17225__3.call(this,x,y,z);
default:
var G__17229 = null;
if (arguments.length > 3) {
var G__17230__i = 0, G__17230__a = new Array(arguments.length -  3);
while (G__17230__i < G__17230__a.length) {G__17230__a[G__17230__i] = arguments[G__17230__i + 3]; ++G__17230__i;}
G__17229 = new cljs.core.IndexedSeq(G__17230__a,0);
}
return G__17225__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17225.cljs$lang$maxFixedArity = 3;
G__17225.cljs$lang$applyTo = G__17225__4.cljs$lang$applyTo;
G__17225.cljs$core$IFn$_invoke$arity$0 = G__17225__0;
G__17225.cljs$core$IFn$_invoke$arity$1 = G__17225__1;
G__17225.cljs$core$IFn$_invoke$arity$2 = G__17225__2;
G__17225.cljs$core$IFn$_invoke$arity$3 = G__17225__3;
G__17225.cljs$core$IFn$_invoke$arity$variadic = G__17225__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17225;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__17231 = null;
var G__17231__0 = (function (){
var G__17208 = (function (){var G__17209 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17209) : g.call(null,G__17209));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17208) : f.call(null,G__17208));
});
var G__17231__1 = (function (x){
var G__17210 = (function (){var G__17211 = (function (){var G__17212 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__17212) : h.call(null,G__17212));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17211) : g.call(null,G__17211));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17210) : f.call(null,G__17210));
});
var G__17231__2 = (function (x,y){
var G__17213 = (function (){var G__17214 = (function (){var G__17215 = x;
var G__17216 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__17215,G__17216) : h.call(null,G__17215,G__17216));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17214) : g.call(null,G__17214));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17213) : f.call(null,G__17213));
});
var G__17231__3 = (function (x,y,z){
var G__17217 = (function (){var G__17218 = (function (){var G__17219 = x;
var G__17220 = y;
var G__17221 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__17219,G__17220,G__17221) : h.call(null,G__17219,G__17220,G__17221));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17218) : g.call(null,G__17218));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17217) : f.call(null,G__17217));
});
var G__17231__4 = (function() { 
var G__17232__delegate = function (x,y,z,args){
var G__17222 = (function (){var G__17223 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17223) : g.call(null,G__17223));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17222) : f.call(null,G__17222));
};
var G__17232 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17233__i = 0, G__17233__a = new Array(arguments.length -  3);
while (G__17233__i < G__17233__a.length) {G__17233__a[G__17233__i] = arguments[G__17233__i + 3]; ++G__17233__i;}
  args = new cljs.core.IndexedSeq(G__17233__a,0);
} 
return G__17232__delegate.call(this,x,y,z,args);};
G__17232.cljs$lang$maxFixedArity = 3;
G__17232.cljs$lang$applyTo = (function (arglist__17234){
var x = cljs.core.first(arglist__17234);
arglist__17234 = cljs.core.next(arglist__17234);
var y = cljs.core.first(arglist__17234);
arglist__17234 = cljs.core.next(arglist__17234);
var z = cljs.core.first(arglist__17234);
var args = cljs.core.rest(arglist__17234);
return G__17232__delegate(x,y,z,args);
});
G__17232.cljs$core$IFn$_invoke$arity$variadic = G__17232__delegate;
return G__17232;
})()
;
G__17231 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17231__0.call(this);
case 1:
return G__17231__1.call(this,x);
case 2:
return G__17231__2.call(this,x,y);
case 3:
return G__17231__3.call(this,x,y,z);
default:
var G__17235 = null;
if (arguments.length > 3) {
var G__17236__i = 0, G__17236__a = new Array(arguments.length -  3);
while (G__17236__i < G__17236__a.length) {G__17236__a[G__17236__i] = arguments[G__17236__i + 3]; ++G__17236__i;}
G__17235 = new cljs.core.IndexedSeq(G__17236__a,0);
}
return G__17231__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17231.cljs$lang$maxFixedArity = 3;
G__17231.cljs$lang$applyTo = G__17231__4.cljs$lang$applyTo;
G__17231.cljs$core$IFn$_invoke$arity$0 = G__17231__0;
G__17231.cljs$core$IFn$_invoke$arity$1 = G__17231__1;
G__17231.cljs$core$IFn$_invoke$arity$2 = G__17231__2;
G__17231.cljs$core$IFn$_invoke$arity$3 = G__17231__3;
G__17231.cljs$core$IFn$_invoke$arity$variadic = G__17231__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17231;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__17237__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__17238 = cljs.core.first(fs__$2).call(null,ret);
var G__17239 = cljs.core.next(fs__$2);
ret = G__17238;
fs__$2 = G__17239;
continue;
} else {
return ret;
}
break;
}
};
var G__17237 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17240__i = 0, G__17240__a = new Array(arguments.length -  0);
while (G__17240__i < G__17240__a.length) {G__17240__a[G__17240__i] = arguments[G__17240__i + 0]; ++G__17240__i;}
  args = new cljs.core.IndexedSeq(G__17240__a,0);
} 
return G__17237__delegate.call(this,args);};
G__17237.cljs$lang$maxFixedArity = 0;
G__17237.cljs$lang$applyTo = (function (arglist__17241){
var args = cljs.core.seq(arglist__17241);
return G__17237__delegate(args);
});
G__17237.cljs$core$IFn$_invoke$arity$variadic = G__17237__delegate;
return G__17237;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq17191){
var G__17192 = cljs.core.first(seq17191);
var seq17191__$1 = cljs.core.next(seq17191);
var G__17193 = cljs.core.first(seq17191__$1);
var seq17191__$2 = cljs.core.next(seq17191__$1);
var G__17194 = cljs.core.first(seq17191__$2);
var seq17191__$3 = cljs.core.next(seq17191__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__17192,G__17193,G__17194,seq17191__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = 3;
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(){
var G__17248 = arguments.length;
switch (G__17248) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__17292 = null;
var G__17292__0 = (function (){
var G__17249 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17249) : f.call(null,G__17249));
});
var G__17292__1 = (function (x){
var G__17250 = arg1;
var G__17251 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17250,G__17251) : f.call(null,G__17250,G__17251));
});
var G__17292__2 = (function (x,y){
var G__17252 = arg1;
var G__17253 = x;
var G__17254 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17252,G__17253,G__17254) : f.call(null,G__17252,G__17253,G__17254));
});
var G__17292__3 = (function (x,y,z){
var G__17255 = arg1;
var G__17256 = x;
var G__17257 = y;
var G__17258 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17255,G__17256,G__17257,G__17258) : f.call(null,G__17255,G__17256,G__17257,G__17258));
});
var G__17292__4 = (function() { 
var G__17293__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__17293 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17294__i = 0, G__17294__a = new Array(arguments.length -  3);
while (G__17294__i < G__17294__a.length) {G__17294__a[G__17294__i] = arguments[G__17294__i + 3]; ++G__17294__i;}
  args = new cljs.core.IndexedSeq(G__17294__a,0);
} 
return G__17293__delegate.call(this,x,y,z,args);};
G__17293.cljs$lang$maxFixedArity = 3;
G__17293.cljs$lang$applyTo = (function (arglist__17295){
var x = cljs.core.first(arglist__17295);
arglist__17295 = cljs.core.next(arglist__17295);
var y = cljs.core.first(arglist__17295);
arglist__17295 = cljs.core.next(arglist__17295);
var z = cljs.core.first(arglist__17295);
var args = cljs.core.rest(arglist__17295);
return G__17293__delegate(x,y,z,args);
});
G__17293.cljs$core$IFn$_invoke$arity$variadic = G__17293__delegate;
return G__17293;
})()
;
G__17292 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17292__0.call(this);
case 1:
return G__17292__1.call(this,x);
case 2:
return G__17292__2.call(this,x,y);
case 3:
return G__17292__3.call(this,x,y,z);
default:
var G__17296 = null;
if (arguments.length > 3) {
var G__17297__i = 0, G__17297__a = new Array(arguments.length -  3);
while (G__17297__i < G__17297__a.length) {G__17297__a[G__17297__i] = arguments[G__17297__i + 3]; ++G__17297__i;}
G__17296 = new cljs.core.IndexedSeq(G__17297__a,0);
}
return G__17292__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17292.cljs$lang$maxFixedArity = 3;
G__17292.cljs$lang$applyTo = G__17292__4.cljs$lang$applyTo;
G__17292.cljs$core$IFn$_invoke$arity$0 = G__17292__0;
G__17292.cljs$core$IFn$_invoke$arity$1 = G__17292__1;
G__17292.cljs$core$IFn$_invoke$arity$2 = G__17292__2;
G__17292.cljs$core$IFn$_invoke$arity$3 = G__17292__3;
G__17292.cljs$core$IFn$_invoke$arity$variadic = G__17292__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17292;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__17298 = null;
var G__17298__0 = (function (){
var G__17259 = arg1;
var G__17260 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17259,G__17260) : f.call(null,G__17259,G__17260));
});
var G__17298__1 = (function (x){
var G__17261 = arg1;
var G__17262 = arg2;
var G__17263 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17261,G__17262,G__17263) : f.call(null,G__17261,G__17262,G__17263));
});
var G__17298__2 = (function (x,y){
var G__17264 = arg1;
var G__17265 = arg2;
var G__17266 = x;
var G__17267 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17264,G__17265,G__17266,G__17267) : f.call(null,G__17264,G__17265,G__17266,G__17267));
});
var G__17298__3 = (function (x,y,z){
var G__17268 = arg1;
var G__17269 = arg2;
var G__17270 = x;
var G__17271 = y;
var G__17272 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17268,G__17269,G__17270,G__17271,G__17272) : f.call(null,G__17268,G__17269,G__17270,G__17271,G__17272));
});
var G__17298__4 = (function() { 
var G__17299__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__17299 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17300__i = 0, G__17300__a = new Array(arguments.length -  3);
while (G__17300__i < G__17300__a.length) {G__17300__a[G__17300__i] = arguments[G__17300__i + 3]; ++G__17300__i;}
  args = new cljs.core.IndexedSeq(G__17300__a,0);
} 
return G__17299__delegate.call(this,x,y,z,args);};
G__17299.cljs$lang$maxFixedArity = 3;
G__17299.cljs$lang$applyTo = (function (arglist__17301){
var x = cljs.core.first(arglist__17301);
arglist__17301 = cljs.core.next(arglist__17301);
var y = cljs.core.first(arglist__17301);
arglist__17301 = cljs.core.next(arglist__17301);
var z = cljs.core.first(arglist__17301);
var args = cljs.core.rest(arglist__17301);
return G__17299__delegate(x,y,z,args);
});
G__17299.cljs$core$IFn$_invoke$arity$variadic = G__17299__delegate;
return G__17299;
})()
;
G__17298 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17298__0.call(this);
case 1:
return G__17298__1.call(this,x);
case 2:
return G__17298__2.call(this,x,y);
case 3:
return G__17298__3.call(this,x,y,z);
default:
var G__17302 = null;
if (arguments.length > 3) {
var G__17303__i = 0, G__17303__a = new Array(arguments.length -  3);
while (G__17303__i < G__17303__a.length) {G__17303__a[G__17303__i] = arguments[G__17303__i + 3]; ++G__17303__i;}
G__17302 = new cljs.core.IndexedSeq(G__17303__a,0);
}
return G__17298__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17298.cljs$lang$maxFixedArity = 3;
G__17298.cljs$lang$applyTo = G__17298__4.cljs$lang$applyTo;
G__17298.cljs$core$IFn$_invoke$arity$0 = G__17298__0;
G__17298.cljs$core$IFn$_invoke$arity$1 = G__17298__1;
G__17298.cljs$core$IFn$_invoke$arity$2 = G__17298__2;
G__17298.cljs$core$IFn$_invoke$arity$3 = G__17298__3;
G__17298.cljs$core$IFn$_invoke$arity$variadic = G__17298__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17298;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__17304 = null;
var G__17304__0 = (function (){
var G__17273 = arg1;
var G__17274 = arg2;
var G__17275 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17273,G__17274,G__17275) : f.call(null,G__17273,G__17274,G__17275));
});
var G__17304__1 = (function (x){
var G__17276 = arg1;
var G__17277 = arg2;
var G__17278 = arg3;
var G__17279 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17276,G__17277,G__17278,G__17279) : f.call(null,G__17276,G__17277,G__17278,G__17279));
});
var G__17304__2 = (function (x,y){
var G__17280 = arg1;
var G__17281 = arg2;
var G__17282 = arg3;
var G__17283 = x;
var G__17284 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17280,G__17281,G__17282,G__17283,G__17284) : f.call(null,G__17280,G__17281,G__17282,G__17283,G__17284));
});
var G__17304__3 = (function (x,y,z){
var G__17285 = arg1;
var G__17286 = arg2;
var G__17287 = arg3;
var G__17288 = x;
var G__17289 = y;
var G__17290 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__17285,G__17286,G__17287,G__17288,G__17289,G__17290) : f.call(null,G__17285,G__17286,G__17287,G__17288,G__17289,G__17290));
});
var G__17304__4 = (function() { 
var G__17305__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__17305 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17306__i = 0, G__17306__a = new Array(arguments.length -  3);
while (G__17306__i < G__17306__a.length) {G__17306__a[G__17306__i] = arguments[G__17306__i + 3]; ++G__17306__i;}
  args = new cljs.core.IndexedSeq(G__17306__a,0);
} 
return G__17305__delegate.call(this,x,y,z,args);};
G__17305.cljs$lang$maxFixedArity = 3;
G__17305.cljs$lang$applyTo = (function (arglist__17307){
var x = cljs.core.first(arglist__17307);
arglist__17307 = cljs.core.next(arglist__17307);
var y = cljs.core.first(arglist__17307);
arglist__17307 = cljs.core.next(arglist__17307);
var z = cljs.core.first(arglist__17307);
var args = cljs.core.rest(arglist__17307);
return G__17305__delegate(x,y,z,args);
});
G__17305.cljs$core$IFn$_invoke$arity$variadic = G__17305__delegate;
return G__17305;
})()
;
G__17304 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17304__0.call(this);
case 1:
return G__17304__1.call(this,x);
case 2:
return G__17304__2.call(this,x,y);
case 3:
return G__17304__3.call(this,x,y,z);
default:
var G__17308 = null;
if (arguments.length > 3) {
var G__17309__i = 0, G__17309__a = new Array(arguments.length -  3);
while (G__17309__i < G__17309__a.length) {G__17309__a[G__17309__i] = arguments[G__17309__i + 3]; ++G__17309__i;}
G__17308 = new cljs.core.IndexedSeq(G__17309__a,0);
}
return G__17304__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17304.cljs$lang$maxFixedArity = 3;
G__17304.cljs$lang$applyTo = G__17304__4.cljs$lang$applyTo;
G__17304.cljs$core$IFn$_invoke$arity$0 = G__17304__0;
G__17304.cljs$core$IFn$_invoke$arity$1 = G__17304__1;
G__17304.cljs$core$IFn$_invoke$arity$2 = G__17304__2;
G__17304.cljs$core$IFn$_invoke$arity$3 = G__17304__3;
G__17304.cljs$core$IFn$_invoke$arity$variadic = G__17304__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17304;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__17310__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__17310 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17311__i = 0, G__17311__a = new Array(arguments.length -  0);
while (G__17311__i < G__17311__a.length) {G__17311__a[G__17311__i] = arguments[G__17311__i + 0]; ++G__17311__i;}
  args = new cljs.core.IndexedSeq(G__17311__a,0);
} 
return G__17310__delegate.call(this,args);};
G__17310.cljs$lang$maxFixedArity = 0;
G__17310.cljs$lang$applyTo = (function (arglist__17312){
var args = cljs.core.seq(arglist__17312);
return G__17310__delegate(args);
});
G__17310.cljs$core$IFn$_invoke$arity$variadic = G__17310__delegate;
return G__17310;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq17242){
var G__17243 = cljs.core.first(seq17242);
var seq17242__$1 = cljs.core.next(seq17242);
var G__17244 = cljs.core.first(seq17242__$1);
var seq17242__$2 = cljs.core.next(seq17242__$1);
var G__17245 = cljs.core.first(seq17242__$2);
var seq17242__$3 = cljs.core.next(seq17242__$2);
var G__17246 = cljs.core.first(seq17242__$3);
var seq17242__$4 = cljs.core.next(seq17242__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__17243,G__17244,G__17245,G__17246,seq17242__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = 4;
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(){
var G__17314 = arguments.length;
switch (G__17314) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__17332 = null;
var G__17332__1 = (function (a){
var G__17315 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17315) : f.call(null,G__17315));
});
var G__17332__2 = (function (a,b){
var G__17316 = (((a == null))?x:a);
var G__17317 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17316,G__17317) : f.call(null,G__17316,G__17317));
});
var G__17332__3 = (function (a,b,c){
var G__17318 = (((a == null))?x:a);
var G__17319 = b;
var G__17320 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17318,G__17319,G__17320) : f.call(null,G__17318,G__17319,G__17320));
});
var G__17332__4 = (function() { 
var G__17333__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__17333 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17334__i = 0, G__17334__a = new Array(arguments.length -  3);
while (G__17334__i < G__17334__a.length) {G__17334__a[G__17334__i] = arguments[G__17334__i + 3]; ++G__17334__i;}
  ds = new cljs.core.IndexedSeq(G__17334__a,0);
} 
return G__17333__delegate.call(this,a,b,c,ds);};
G__17333.cljs$lang$maxFixedArity = 3;
G__17333.cljs$lang$applyTo = (function (arglist__17335){
var a = cljs.core.first(arglist__17335);
arglist__17335 = cljs.core.next(arglist__17335);
var b = cljs.core.first(arglist__17335);
arglist__17335 = cljs.core.next(arglist__17335);
var c = cljs.core.first(arglist__17335);
var ds = cljs.core.rest(arglist__17335);
return G__17333__delegate(a,b,c,ds);
});
G__17333.cljs$core$IFn$_invoke$arity$variadic = G__17333__delegate;
return G__17333;
})()
;
G__17332 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__17332__1.call(this,a);
case 2:
return G__17332__2.call(this,a,b);
case 3:
return G__17332__3.call(this,a,b,c);
default:
var G__17336 = null;
if (arguments.length > 3) {
var G__17337__i = 0, G__17337__a = new Array(arguments.length -  3);
while (G__17337__i < G__17337__a.length) {G__17337__a[G__17337__i] = arguments[G__17337__i + 3]; ++G__17337__i;}
G__17336 = new cljs.core.IndexedSeq(G__17337__a,0);
}
return G__17332__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17332.cljs$lang$maxFixedArity = 3;
G__17332.cljs$lang$applyTo = G__17332__4.cljs$lang$applyTo;
G__17332.cljs$core$IFn$_invoke$arity$1 = G__17332__1;
G__17332.cljs$core$IFn$_invoke$arity$2 = G__17332__2;
G__17332.cljs$core$IFn$_invoke$arity$3 = G__17332__3;
G__17332.cljs$core$IFn$_invoke$arity$variadic = G__17332__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17332;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__17338 = null;
var G__17338__2 = (function (a,b){
var G__17321 = (((a == null))?x:a);
var G__17322 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17321,G__17322) : f.call(null,G__17321,G__17322));
});
var G__17338__3 = (function (a,b,c){
var G__17323 = (((a == null))?x:a);
var G__17324 = (((b == null))?y:b);
var G__17325 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17323,G__17324,G__17325) : f.call(null,G__17323,G__17324,G__17325));
});
var G__17338__4 = (function() { 
var G__17339__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__17339 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17340__i = 0, G__17340__a = new Array(arguments.length -  3);
while (G__17340__i < G__17340__a.length) {G__17340__a[G__17340__i] = arguments[G__17340__i + 3]; ++G__17340__i;}
  ds = new cljs.core.IndexedSeq(G__17340__a,0);
} 
return G__17339__delegate.call(this,a,b,c,ds);};
G__17339.cljs$lang$maxFixedArity = 3;
G__17339.cljs$lang$applyTo = (function (arglist__17341){
var a = cljs.core.first(arglist__17341);
arglist__17341 = cljs.core.next(arglist__17341);
var b = cljs.core.first(arglist__17341);
arglist__17341 = cljs.core.next(arglist__17341);
var c = cljs.core.first(arglist__17341);
var ds = cljs.core.rest(arglist__17341);
return G__17339__delegate(a,b,c,ds);
});
G__17339.cljs$core$IFn$_invoke$arity$variadic = G__17339__delegate;
return G__17339;
})()
;
G__17338 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__17338__2.call(this,a,b);
case 3:
return G__17338__3.call(this,a,b,c);
default:
var G__17342 = null;
if (arguments.length > 3) {
var G__17343__i = 0, G__17343__a = new Array(arguments.length -  3);
while (G__17343__i < G__17343__a.length) {G__17343__a[G__17343__i] = arguments[G__17343__i + 3]; ++G__17343__i;}
G__17342 = new cljs.core.IndexedSeq(G__17343__a,0);
}
return G__17338__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17338.cljs$lang$maxFixedArity = 3;
G__17338.cljs$lang$applyTo = G__17338__4.cljs$lang$applyTo;
G__17338.cljs$core$IFn$_invoke$arity$2 = G__17338__2;
G__17338.cljs$core$IFn$_invoke$arity$3 = G__17338__3;
G__17338.cljs$core$IFn$_invoke$arity$variadic = G__17338__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17338;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__17344 = null;
var G__17344__2 = (function (a,b){
var G__17326 = (((a == null))?x:a);
var G__17327 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17326,G__17327) : f.call(null,G__17326,G__17327));
});
var G__17344__3 = (function (a,b,c){
var G__17328 = (((a == null))?x:a);
var G__17329 = (((b == null))?y:b);
var G__17330 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17328,G__17329,G__17330) : f.call(null,G__17328,G__17329,G__17330));
});
var G__17344__4 = (function() { 
var G__17345__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__17345 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17346__i = 0, G__17346__a = new Array(arguments.length -  3);
while (G__17346__i < G__17346__a.length) {G__17346__a[G__17346__i] = arguments[G__17346__i + 3]; ++G__17346__i;}
  ds = new cljs.core.IndexedSeq(G__17346__a,0);
} 
return G__17345__delegate.call(this,a,b,c,ds);};
G__17345.cljs$lang$maxFixedArity = 3;
G__17345.cljs$lang$applyTo = (function (arglist__17347){
var a = cljs.core.first(arglist__17347);
arglist__17347 = cljs.core.next(arglist__17347);
var b = cljs.core.first(arglist__17347);
arglist__17347 = cljs.core.next(arglist__17347);
var c = cljs.core.first(arglist__17347);
var ds = cljs.core.rest(arglist__17347);
return G__17345__delegate(a,b,c,ds);
});
G__17345.cljs$core$IFn$_invoke$arity$variadic = G__17345__delegate;
return G__17345;
})()
;
G__17344 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__17344__2.call(this,a,b);
case 3:
return G__17344__3.call(this,a,b,c);
default:
var G__17348 = null;
if (arguments.length > 3) {
var G__17349__i = 0, G__17349__a = new Array(arguments.length -  3);
while (G__17349__i < G__17349__a.length) {G__17349__a[G__17349__i] = arguments[G__17349__i + 3]; ++G__17349__i;}
G__17348 = new cljs.core.IndexedSeq(G__17349__a,0);
}
return G__17344__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17344.cljs$lang$maxFixedArity = 3;
G__17344.cljs$lang$applyTo = G__17344__4.cljs$lang$applyTo;
G__17344.cljs$core$IFn$_invoke$arity$2 = G__17344__2;
G__17344.cljs$core$IFn$_invoke$arity$3 = G__17344__3;
G__17344.cljs$core$IFn$_invoke$arity$variadic = G__17344__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17344;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(){
var G__17351 = arguments.length;
switch (G__17351) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (function (){var G__17352 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__17352) : cljs.core.volatile_BANG_.call(null,G__17352));
})();
return ((function (i){
return (function() {
var G__17383 = null;
var G__17383__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17383__1 = (function (result){
var G__17353 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17353) : rf.call(null,G__17353));
});
var G__17383__2 = (function (result,input){
var G__17354 = result;
var G__17355 = (function (){var G__17356 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__17357 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17356,G__17357) : f.call(null,G__17356,G__17357));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17354,G__17355) : rf.call(null,G__17354,G__17355));
});
G__17383 = function(result,input){
switch(arguments.length){
case 0:
return G__17383__0.call(this);
case 1:
return G__17383__1.call(this,result);
case 2:
return G__17383__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17383.cljs$core$IFn$_invoke$arity$0 = G__17383__0;
G__17383.cljs$core$IFn$_invoke$arity$1 = G__17383__1;
G__17383.cljs$core$IFn$_invoke$arity$2 = G__17383__2;
return G__17383;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5161__auto___17384 = size;
var i_17385 = (0);
while(true){
if((i_17385 < n__5161__auto___17384)){
cljs.core.chunk_append(b,(function (){var G__17378 = (idx + i_17385);
var G__17379 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17385);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17378,G__17379) : f.call(null,G__17378,G__17379));
})());

var G__17386 = (i_17385 + (1));
i_17385 = G__17386;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__17380 = idx;
var G__17381 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17380,G__17381) : f.call(null,G__17380,G__17381));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(){
var G__17388 = arguments.length;
switch (G__17388) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__17396 = null;
var G__17396__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17396__1 = (function (result){
var G__17389 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17389) : rf.call(null,G__17389));
});
var G__17396__2 = (function (result,input){
var v = (function (){var G__17390 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17390) : f.call(null,G__17390));
})();
if((v == null)){
return result;
} else {
var G__17391 = result;
var G__17392 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17391,G__17392) : rf.call(null,G__17391,G__17392));
}
});
G__17396 = function(result,input){
switch(arguments.length){
case 0:
return G__17396__0.call(this);
case 1:
return G__17396__1.call(this,result);
case 2:
return G__17396__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17396.cljs$core$IFn$_invoke$arity$0 = G__17396__0;
G__17396.cljs$core$IFn$_invoke$arity$1 = G__17396__1;
G__17396.cljs$core$IFn$_invoke$arity$2 = G__17396__2;
return G__17396;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5161__auto___17397 = size;
var i_17398 = (0);
while(true){
if((i_17398 < n__5161__auto___17397)){
var x_17399 = (function (){var G__17393 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17398);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17393) : f.call(null,G__17393));
})();
if((x_17399 == null)){
} else {
cljs.core.chunk_append(b,x_17399);
}

var G__17400 = (i_17398 + (1));
i_17398 = G__17400;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__17394 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17394) : f.call(null,G__17394));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__17401 = this$__$1;
return goog.getUid(G__17401);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__17402 = cljs.core.seq(self__.watches);
var chunk__17403 = null;
var count__17404 = (0);
var i__17405 = (0);
while(true){
if((i__17405 < count__17404)){
var vec__17406 = chunk__17403.cljs$core$IIndexed$_nth$arity$2(null,i__17405);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17406,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17406,(1),null);
var G__17407_17416 = key;
var G__17408_17417 = this$__$1;
var G__17409_17418 = oldval;
var G__17410_17419 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17407_17416,G__17408_17417,G__17409_17418,G__17410_17419) : f.call(null,G__17407_17416,G__17408_17417,G__17409_17418,G__17410_17419));

var G__17420 = seq__17402;
var G__17421 = chunk__17403;
var G__17422 = count__17404;
var G__17423 = (i__17405 + (1));
seq__17402 = G__17420;
chunk__17403 = G__17421;
count__17404 = G__17422;
i__17405 = G__17423;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__17402);
if(temp__4126__auto__){
var seq__17402__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17402__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__17402__$1);
var G__17424 = cljs.core.chunk_rest(seq__17402__$1);
var G__17425 = c__5061__auto__;
var G__17426 = cljs.core.count(c__5061__auto__);
var G__17427 = (0);
seq__17402 = G__17424;
chunk__17403 = G__17425;
count__17404 = G__17426;
i__17405 = G__17427;
continue;
} else {
var vec__17411 = cljs.core.first(seq__17402__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17411,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17411,(1),null);
var G__17412_17428 = key;
var G__17413_17429 = this$__$1;
var G__17414_17430 = oldval;
var G__17415_17431 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17412_17428,G__17413_17429,G__17414_17430,G__17415_17431) : f.call(null,G__17412_17428,G__17413_17429,G__17414_17430,G__17415_17431));

var G__17432 = cljs.core.next(seq__17402__$1);
var G__17433 = null;
var G__17434 = (0);
var G__17435 = (0);
seq__17402 = G__17432;
chunk__17403 = G__17433;
count__17404 = G__17434;
i__17405 = G__17435;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(){
var G__17439 = arguments.length;
switch (G__17439) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5328__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__17440){
var map__17441 = p__17440;
var map__17441__$1 = ((cljs.core.seq_QMARK_(map__17441))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17441):map__17441);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17441__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17441__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq17436){
var G__17437 = cljs.core.first(seq17436);
var seq17436__$1 = cljs.core.next(seq17436);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__17437,seq17436__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = 1;
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__17445 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__17445) : validate.call(null,G__17445));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__17446 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17446) : cljs.core.pr_str.call(null,G__17446));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(){
var G__17453 = arguments.length;
switch (G__17453) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17454 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17454) : f.call(null,G__17454));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17455 = a.state;
var G__17456 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17455,G__17456) : f.call(null,G__17455,G__17456));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17457 = a.state;
var G__17458 = x;
var G__17459 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17457,G__17458,G__17459) : f.call(null,G__17457,G__17458,G__17459));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq17447){
var G__17448 = cljs.core.first(seq17447);
var seq17447__$1 = cljs.core.next(seq17447);
var G__17449 = cljs.core.first(seq17447__$1);
var seq17447__$2 = cljs.core.next(seq17447__$1);
var G__17450 = cljs.core.first(seq17447__$2);
var seq17447__$3 = cljs.core.next(seq17447__$2);
var G__17451 = cljs.core.first(seq17447__$3);
var seq17447__$4 = cljs.core.next(seq17447__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17448,G__17449,G__17450,G__17451,seq17447__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(){
var G__17462 = arguments.length;
switch (G__17462) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__17497 = null;
var G__17497__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17497__1 = (function (result){
var G__17463 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17463) : rf.call(null,G__17463));
});
var G__17497__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (function (){var G__17464 = i;
var G__17465 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17464,G__17465) : f.call(null,G__17464,G__17465));
})();
if((v == null)){
return result;
} else {
var G__17466 = result;
var G__17467 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17466,G__17467) : rf.call(null,G__17466,G__17467));
}
});
G__17497 = function(result,input){
switch(arguments.length){
case 0:
return G__17497__0.call(this);
case 1:
return G__17497__1.call(this,result);
case 2:
return G__17497__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17497.cljs$core$IFn$_invoke$arity$0 = G__17497__0;
G__17497.cljs$core$IFn$_invoke$arity$1 = G__17497__1;
G__17497.cljs$core$IFn$_invoke$arity$2 = G__17497__2;
return G__17497;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5161__auto___17498 = size;
var i_17499 = (0);
while(true){
if((i_17499 < n__5161__auto___17498)){
var x_17500 = (function (){var G__17492 = (idx + i_17499);
var G__17493 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17499);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17492,G__17493) : f.call(null,G__17492,G__17493));
})();
if((x_17500 == null)){
} else {
cljs.core.chunk_append(b,x_17500);
}

var G__17501 = (i_17499 + (1));
i_17499 = G__17501;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__17494 = idx;
var G__17495 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17494,G__17495) : f.call(null,G__17494,G__17495));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(){
var G__17513 = arguments.length;
switch (G__17513) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__17529 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17529) : p.call(null,G__17529));
})());
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17531 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17531) : p.call(null,G__17531));
})();
if(cljs.core.truth_(and__4264__auto__)){
var G__17532 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17532) : p.call(null,G__17532));
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17534 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17534) : p.call(null,G__17534));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17536 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17536) : p.call(null,G__17536));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var G__17537 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17537) : p.call(null,G__17537));
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__17699__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4264__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__4264__auto__;
}
})());
};
var G__17699 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17700__i = 0, G__17700__a = new Array(arguments.length -  3);
while (G__17700__i < G__17700__a.length) {G__17700__a[G__17700__i] = arguments[G__17700__i + 3]; ++G__17700__i;}
  args = new cljs.core.IndexedSeq(G__17700__a,0);
} 
return G__17699__delegate.call(this,x,y,z,args);};
G__17699.cljs$lang$maxFixedArity = 3;
G__17699.cljs$lang$applyTo = (function (arglist__17701){
var x = cljs.core.first(arglist__17701);
arglist__17701 = cljs.core.next(arglist__17701);
var y = cljs.core.first(arglist__17701);
arglist__17701 = cljs.core.next(arglist__17701);
var z = cljs.core.first(arglist__17701);
var args = cljs.core.rest(arglist__17701);
return G__17699__delegate(x,y,z,args);
});
G__17699.cljs$core$IFn$_invoke$arity$variadic = G__17699__delegate;
return G__17699;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__17702 = null;
if (arguments.length > 3) {
var G__17703__i = 0, G__17703__a = new Array(arguments.length -  3);
while (G__17703__i < G__17703__a.length) {G__17703__a[G__17703__i] = arguments[G__17703__i + 3]; ++G__17703__i;}
G__17702 = new cljs.core.IndexedSeq(G__17703__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17569 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17569) : p1.call(null,G__17569));
})();
if(cljs.core.truth_(and__4264__auto__)){
var G__17570 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17570) : p2.call(null,G__17570));
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17572 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17572) : p1.call(null,G__17572));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17574 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17574) : p1.call(null,G__17574));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var and__4264__auto____$2 = (function (){var G__17576 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17576) : p2.call(null,G__17576));
})();
if(cljs.core.truth_(and__4264__auto____$2)){
var G__17577 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17577) : p2.call(null,G__17577));
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17579 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17579) : p1.call(null,G__17579));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17581 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17581) : p1.call(null,G__17581));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var and__4264__auto____$2 = (function (){var G__17583 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17583) : p1.call(null,G__17583));
})();
if(cljs.core.truth_(and__4264__auto____$2)){
var and__4264__auto____$3 = (function (){var G__17585 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17585) : p2.call(null,G__17585));
})();
if(cljs.core.truth_(and__4264__auto____$3)){
var and__4264__auto____$4 = (function (){var G__17587 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17587) : p2.call(null,G__17587));
})();
if(cljs.core.truth_(and__4264__auto____$4)){
var G__17588 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17588) : p2.call(null,G__17588));
} else {
return and__4264__auto____$4;
}
} else {
return and__4264__auto____$3;
}
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__17704__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4264__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.every_QMARK_(((function (and__4264__auto__){
return (function (p1__17502_SHARP_){
var and__4264__auto____$1 = (function (){var G__17590 = p1__17502_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17590) : p1.call(null,G__17590));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var G__17591 = p1__17502_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17591) : p2.call(null,G__17591));
} else {
return and__4264__auto____$1;
}
});})(and__4264__auto__))
,args);
} else {
return and__4264__auto__;
}
})());
};
var G__17704 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17705__i = 0, G__17705__a = new Array(arguments.length -  3);
while (G__17705__i < G__17705__a.length) {G__17705__a[G__17705__i] = arguments[G__17705__i + 3]; ++G__17705__i;}
  args = new cljs.core.IndexedSeq(G__17705__a,0);
} 
return G__17704__delegate.call(this,x,y,z,args);};
G__17704.cljs$lang$maxFixedArity = 3;
G__17704.cljs$lang$applyTo = (function (arglist__17706){
var x = cljs.core.first(arglist__17706);
arglist__17706 = cljs.core.next(arglist__17706);
var y = cljs.core.first(arglist__17706);
arglist__17706 = cljs.core.next(arglist__17706);
var z = cljs.core.first(arglist__17706);
var args = cljs.core.rest(arglist__17706);
return G__17704__delegate(x,y,z,args);
});
G__17704.cljs$core$IFn$_invoke$arity$variadic = G__17704__delegate;
return G__17704;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__17707 = null;
if (arguments.length > 3) {
var G__17708__i = 0, G__17708__a = new Array(arguments.length -  3);
while (G__17708__i < G__17708__a.length) {G__17708__a[G__17708__i] = arguments[G__17708__i + 3]; ++G__17708__i;}
G__17707 = new cljs.core.IndexedSeq(G__17708__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17637 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17637) : p1.call(null,G__17637));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17639 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17639) : p2.call(null,G__17639));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var G__17640 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17640) : p3.call(null,G__17640));
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17642 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17642) : p1.call(null,G__17642));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17644 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17644) : p2.call(null,G__17644));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var and__4264__auto____$2 = (function (){var G__17646 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17646) : p3.call(null,G__17646));
})();
if(cljs.core.truth_(and__4264__auto____$2)){
var and__4264__auto____$3 = (function (){var G__17648 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17648) : p1.call(null,G__17648));
})();
if(cljs.core.truth_(and__4264__auto____$3)){
var and__4264__auto____$4 = (function (){var G__17650 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17650) : p2.call(null,G__17650));
})();
if(cljs.core.truth_(and__4264__auto____$4)){
var G__17651 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17651) : p3.call(null,G__17651));
} else {
return and__4264__auto____$4;
}
} else {
return and__4264__auto____$3;
}
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4264__auto__ = (function (){var G__17653 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17653) : p1.call(null,G__17653));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17655 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17655) : p2.call(null,G__17655));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var and__4264__auto____$2 = (function (){var G__17657 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17657) : p3.call(null,G__17657));
})();
if(cljs.core.truth_(and__4264__auto____$2)){
var and__4264__auto____$3 = (function (){var G__17659 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17659) : p1.call(null,G__17659));
})();
if(cljs.core.truth_(and__4264__auto____$3)){
var and__4264__auto____$4 = (function (){var G__17661 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17661) : p2.call(null,G__17661));
})();
if(cljs.core.truth_(and__4264__auto____$4)){
var and__4264__auto____$5 = (function (){var G__17663 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17663) : p3.call(null,G__17663));
})();
if(cljs.core.truth_(and__4264__auto____$5)){
var and__4264__auto____$6 = (function (){var G__17665 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17665) : p1.call(null,G__17665));
})();
if(cljs.core.truth_(and__4264__auto____$6)){
var and__4264__auto____$7 = (function (){var G__17667 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17667) : p2.call(null,G__17667));
})();
if(cljs.core.truth_(and__4264__auto____$7)){
var G__17668 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17668) : p3.call(null,G__17668));
} else {
return and__4264__auto____$7;
}
} else {
return and__4264__auto____$6;
}
} else {
return and__4264__auto____$5;
}
} else {
return and__4264__auto____$4;
}
} else {
return and__4264__auto____$3;
}
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__17709__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4264__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.every_QMARK_(((function (and__4264__auto__){
return (function (p1__17503_SHARP_){
var and__4264__auto____$1 = (function (){var G__17670 = p1__17503_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17670) : p1.call(null,G__17670));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var and__4264__auto____$2 = (function (){var G__17672 = p1__17503_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17672) : p2.call(null,G__17672));
})();
if(cljs.core.truth_(and__4264__auto____$2)){
var G__17673 = p1__17503_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17673) : p3.call(null,G__17673));
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
});})(and__4264__auto__))
,args);
} else {
return and__4264__auto__;
}
})());
};
var G__17709 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17710__i = 0, G__17710__a = new Array(arguments.length -  3);
while (G__17710__i < G__17710__a.length) {G__17710__a[G__17710__i] = arguments[G__17710__i + 3]; ++G__17710__i;}
  args = new cljs.core.IndexedSeq(G__17710__a,0);
} 
return G__17709__delegate.call(this,x,y,z,args);};
G__17709.cljs$lang$maxFixedArity = 3;
G__17709.cljs$lang$applyTo = (function (arglist__17711){
var x = cljs.core.first(arglist__17711);
arglist__17711 = cljs.core.next(arglist__17711);
var y = cljs.core.first(arglist__17711);
arglist__17711 = cljs.core.next(arglist__17711);
var z = cljs.core.first(arglist__17711);
var args = cljs.core.rest(arglist__17711);
return G__17709__delegate(x,y,z,args);
});
G__17709.cljs$core$IFn$_invoke$arity$variadic = G__17709__delegate;
return G__17709;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__17712 = null;
if (arguments.length > 3) {
var G__17713__i = 0, G__17713__a = new Array(arguments.length -  3);
while (G__17713__i < G__17713__a.length) {G__17713__a[G__17713__i] = arguments[G__17713__i + 3]; ++G__17713__i;}
G__17712 = new cljs.core.IndexedSeq(G__17713__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__17504_SHARP_){
var G__17689 = x;
return (p1__17504_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17504_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17689) : p1__17504_SHARP_.call(null,G__17689));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__17505_SHARP_){
var and__4264__auto__ = (function (){var G__17691 = x;
return (p1__17505_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17505_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17691) : p1__17505_SHARP_.call(null,G__17691));
})();
if(cljs.core.truth_(and__4264__auto__)){
var G__17692 = y;
return (p1__17505_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17505_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17692) : p1__17505_SHARP_.call(null,G__17692));
} else {
return and__4264__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__17506_SHARP_){
var and__4264__auto__ = (function (){var G__17694 = x;
return (p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17694) : p1__17506_SHARP_.call(null,G__17694));
})();
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__17696 = y;
return (p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17696) : p1__17506_SHARP_.call(null,G__17696));
})();
if(cljs.core.truth_(and__4264__auto____$1)){
var G__17697 = z;
return (p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17506_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17697) : p1__17506_SHARP_.call(null,G__17697));
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__17714__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4264__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.every_QMARK_(((function (and__4264__auto__,ps__$1){
return (function (p1__17507_SHARP_){
return cljs.core.every_QMARK_(p1__17507_SHARP_,args);
});})(and__4264__auto__,ps__$1))
,ps__$1);
} else {
return and__4264__auto__;
}
})());
};
var G__17714 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17715__i = 0, G__17715__a = new Array(arguments.length -  3);
while (G__17715__i < G__17715__a.length) {G__17715__a[G__17715__i] = arguments[G__17715__i + 3]; ++G__17715__i;}
  args = new cljs.core.IndexedSeq(G__17715__a,0);
} 
return G__17714__delegate.call(this,x,y,z,args);};
G__17714.cljs$lang$maxFixedArity = 3;
G__17714.cljs$lang$applyTo = (function (arglist__17716){
var x = cljs.core.first(arglist__17716);
arglist__17716 = cljs.core.next(arglist__17716);
var y = cljs.core.first(arglist__17716);
arglist__17716 = cljs.core.next(arglist__17716);
var z = cljs.core.first(arglist__17716);
var args = cljs.core.rest(arglist__17716);
return G__17714__delegate(x,y,z,args);
});
G__17714.cljs$core$IFn$_invoke$arity$variadic = G__17714__delegate;
return G__17714;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__17717 = null;
if (arguments.length > 3) {
var G__17718__i = 0, G__17718__a = new Array(arguments.length -  3);
while (G__17718__i < G__17718__a.length) {G__17718__a[G__17718__i] = arguments[G__17718__i + 3]; ++G__17718__i;}
G__17717 = new cljs.core.IndexedSeq(G__17718__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq17508){
var G__17509 = cljs.core.first(seq17508);
var seq17508__$1 = cljs.core.next(seq17508);
var G__17510 = cljs.core.first(seq17508__$1);
var seq17508__$2 = cljs.core.next(seq17508__$1);
var G__17511 = cljs.core.first(seq17508__$2);
var seq17508__$3 = cljs.core.next(seq17508__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__17509,G__17510,G__17511,seq17508__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(){
var G__17730 = arguments.length;
switch (G__17730) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
var G__17746 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17746) : p.call(null,G__17746));
});
var cljs$core$sp1__2 = (function (x,y){
var or__4276__auto__ = (function (){var G__17748 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17748) : p.call(null,G__17748));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var G__17749 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17749) : p.call(null,G__17749));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__4276__auto__ = (function (){var G__17751 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17751) : p.call(null,G__17751));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17753 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17753) : p.call(null,G__17753));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var G__17754 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17754) : p.call(null,G__17754));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__17916__delegate = function (x,y,z,args){
var or__4276__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__17916 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17917__i = 0, G__17917__a = new Array(arguments.length -  3);
while (G__17917__i < G__17917__a.length) {G__17917__a[G__17917__i] = arguments[G__17917__i + 3]; ++G__17917__i;}
  args = new cljs.core.IndexedSeq(G__17917__a,0);
} 
return G__17916__delegate.call(this,x,y,z,args);};
G__17916.cljs$lang$maxFixedArity = 3;
G__17916.cljs$lang$applyTo = (function (arglist__17918){
var x = cljs.core.first(arglist__17918);
arglist__17918 = cljs.core.next(arglist__17918);
var y = cljs.core.first(arglist__17918);
arglist__17918 = cljs.core.next(arglist__17918);
var z = cljs.core.first(arglist__17918);
var args = cljs.core.rest(arglist__17918);
return G__17916__delegate(x,y,z,args);
});
G__17916.cljs$core$IFn$_invoke$arity$variadic = G__17916__delegate;
return G__17916;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__17919 = null;
if (arguments.length > 3) {
var G__17920__i = 0, G__17920__a = new Array(arguments.length -  3);
while (G__17920__i < G__17920__a.length) {G__17920__a[G__17920__i] = arguments[G__17920__i + 3]; ++G__17920__i;}
G__17919 = new cljs.core.IndexedSeq(G__17920__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__4276__auto__ = (function (){var G__17786 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17786) : p1.call(null,G__17786));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var G__17787 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17787) : p2.call(null,G__17787));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__4276__auto__ = (function (){var G__17789 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17789) : p1.call(null,G__17789));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17791 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17791) : p1.call(null,G__17791));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var G__17793 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17793) : p2.call(null,G__17793));
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
var G__17794 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17794) : p2.call(null,G__17794));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__4276__auto__ = (function (){var G__17796 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17796) : p1.call(null,G__17796));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17798 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17798) : p1.call(null,G__17798));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var G__17800 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17800) : p1.call(null,G__17800));
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
var or__4276__auto____$3 = (function (){var G__17802 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17802) : p2.call(null,G__17802));
})();
if(cljs.core.truth_(or__4276__auto____$3)){
return or__4276__auto____$3;
} else {
var or__4276__auto____$4 = (function (){var G__17804 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17804) : p2.call(null,G__17804));
})();
if(cljs.core.truth_(or__4276__auto____$4)){
return or__4276__auto____$4;
} else {
var G__17805 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17805) : p2.call(null,G__17805));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__17921__delegate = function (x,y,z,args){
var or__4276__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.some(((function (or__4276__auto__){
return (function (p1__17719_SHARP_){
var or__4276__auto____$1 = (function (){var G__17807 = p1__17719_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17807) : p1.call(null,G__17807));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var G__17808 = p1__17719_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17808) : p2.call(null,G__17808));
}
});})(or__4276__auto__))
,args);
}
};
var G__17921 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17922__i = 0, G__17922__a = new Array(arguments.length -  3);
while (G__17922__i < G__17922__a.length) {G__17922__a[G__17922__i] = arguments[G__17922__i + 3]; ++G__17922__i;}
  args = new cljs.core.IndexedSeq(G__17922__a,0);
} 
return G__17921__delegate.call(this,x,y,z,args);};
G__17921.cljs$lang$maxFixedArity = 3;
G__17921.cljs$lang$applyTo = (function (arglist__17923){
var x = cljs.core.first(arglist__17923);
arglist__17923 = cljs.core.next(arglist__17923);
var y = cljs.core.first(arglist__17923);
arglist__17923 = cljs.core.next(arglist__17923);
var z = cljs.core.first(arglist__17923);
var args = cljs.core.rest(arglist__17923);
return G__17921__delegate(x,y,z,args);
});
G__17921.cljs$core$IFn$_invoke$arity$variadic = G__17921__delegate;
return G__17921;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__17924 = null;
if (arguments.length > 3) {
var G__17925__i = 0, G__17925__a = new Array(arguments.length -  3);
while (G__17925__i < G__17925__a.length) {G__17925__a[G__17925__i] = arguments[G__17925__i + 3]; ++G__17925__i;}
G__17924 = new cljs.core.IndexedSeq(G__17925__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__4276__auto__ = (function (){var G__17854 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17854) : p1.call(null,G__17854));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17856 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17856) : p2.call(null,G__17856));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var G__17857 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17857) : p3.call(null,G__17857));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__4276__auto__ = (function (){var G__17859 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17859) : p1.call(null,G__17859));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17861 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17861) : p2.call(null,G__17861));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var G__17863 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17863) : p3.call(null,G__17863));
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
var or__4276__auto____$3 = (function (){var G__17865 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17865) : p1.call(null,G__17865));
})();
if(cljs.core.truth_(or__4276__auto____$3)){
return or__4276__auto____$3;
} else {
var or__4276__auto____$4 = (function (){var G__17867 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17867) : p2.call(null,G__17867));
})();
if(cljs.core.truth_(or__4276__auto____$4)){
return or__4276__auto____$4;
} else {
var G__17868 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17868) : p3.call(null,G__17868));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__4276__auto__ = (function (){var G__17870 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17870) : p1.call(null,G__17870));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17872 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17872) : p2.call(null,G__17872));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var G__17874 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17874) : p3.call(null,G__17874));
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
var or__4276__auto____$3 = (function (){var G__17876 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17876) : p1.call(null,G__17876));
})();
if(cljs.core.truth_(or__4276__auto____$3)){
return or__4276__auto____$3;
} else {
var or__4276__auto____$4 = (function (){var G__17878 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17878) : p2.call(null,G__17878));
})();
if(cljs.core.truth_(or__4276__auto____$4)){
return or__4276__auto____$4;
} else {
var or__4276__auto____$5 = (function (){var G__17880 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17880) : p3.call(null,G__17880));
})();
if(cljs.core.truth_(or__4276__auto____$5)){
return or__4276__auto____$5;
} else {
var or__4276__auto____$6 = (function (){var G__17882 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17882) : p1.call(null,G__17882));
})();
if(cljs.core.truth_(or__4276__auto____$6)){
return or__4276__auto____$6;
} else {
var or__4276__auto____$7 = (function (){var G__17884 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17884) : p2.call(null,G__17884));
})();
if(cljs.core.truth_(or__4276__auto____$7)){
return or__4276__auto____$7;
} else {
var G__17885 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17885) : p3.call(null,G__17885));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__17926__delegate = function (x,y,z,args){
var or__4276__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.some(((function (or__4276__auto__){
return (function (p1__17720_SHARP_){
var or__4276__auto____$1 = (function (){var G__17887 = p1__17720_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17887) : p1.call(null,G__17887));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var G__17889 = p1__17720_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17889) : p2.call(null,G__17889));
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
var G__17890 = p1__17720_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17890) : p3.call(null,G__17890));
}
}
});})(or__4276__auto__))
,args);
}
};
var G__17926 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17927__i = 0, G__17927__a = new Array(arguments.length -  3);
while (G__17927__i < G__17927__a.length) {G__17927__a[G__17927__i] = arguments[G__17927__i + 3]; ++G__17927__i;}
  args = new cljs.core.IndexedSeq(G__17927__a,0);
} 
return G__17926__delegate.call(this,x,y,z,args);};
G__17926.cljs$lang$maxFixedArity = 3;
G__17926.cljs$lang$applyTo = (function (arglist__17928){
var x = cljs.core.first(arglist__17928);
arglist__17928 = cljs.core.next(arglist__17928);
var y = cljs.core.first(arglist__17928);
arglist__17928 = cljs.core.next(arglist__17928);
var z = cljs.core.first(arglist__17928);
var args = cljs.core.rest(arglist__17928);
return G__17926__delegate(x,y,z,args);
});
G__17926.cljs$core$IFn$_invoke$arity$variadic = G__17926__delegate;
return G__17926;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__17929 = null;
if (arguments.length > 3) {
var G__17930__i = 0, G__17930__a = new Array(arguments.length -  3);
while (G__17930__i < G__17930__a.length) {G__17930__a[G__17930__i] = arguments[G__17930__i + 3]; ++G__17930__i;}
G__17929 = new cljs.core.IndexedSeq(G__17930__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__17721_SHARP_){
var G__17906 = x;
return (p1__17721_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17721_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17906) : p1__17721_SHARP_.call(null,G__17906));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__17722_SHARP_){
var or__4276__auto__ = (function (){var G__17908 = x;
return (p1__17722_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17722_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17908) : p1__17722_SHARP_.call(null,G__17908));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var G__17909 = y;
return (p1__17722_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17722_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17909) : p1__17722_SHARP_.call(null,G__17909));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__17723_SHARP_){
var or__4276__auto__ = (function (){var G__17911 = x;
return (p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17911) : p1__17723_SHARP_.call(null,G__17911));
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var G__17913 = y;
return (p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17913) : p1__17723_SHARP_.call(null,G__17913));
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var G__17914 = z;
return (p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17723_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17914) : p1__17723_SHARP_.call(null,G__17914));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__17931__delegate = function (x,y,z,args){
var or__4276__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.some(((function (or__4276__auto__,ps__$1){
return (function (p1__17724_SHARP_){
return cljs.core.some(p1__17724_SHARP_,args);
});})(or__4276__auto__,ps__$1))
,ps__$1);
}
};
var G__17931 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17932__i = 0, G__17932__a = new Array(arguments.length -  3);
while (G__17932__i < G__17932__a.length) {G__17932__a[G__17932__i] = arguments[G__17932__i + 3]; ++G__17932__i;}
  args = new cljs.core.IndexedSeq(G__17932__a,0);
} 
return G__17931__delegate.call(this,x,y,z,args);};
G__17931.cljs$lang$maxFixedArity = 3;
G__17931.cljs$lang$applyTo = (function (arglist__17933){
var x = cljs.core.first(arglist__17933);
arglist__17933 = cljs.core.next(arglist__17933);
var y = cljs.core.first(arglist__17933);
arglist__17933 = cljs.core.next(arglist__17933);
var z = cljs.core.first(arglist__17933);
var args = cljs.core.rest(arglist__17933);
return G__17931__delegate(x,y,z,args);
});
G__17931.cljs$core$IFn$_invoke$arity$variadic = G__17931__delegate;
return G__17931;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__17934 = null;
if (arguments.length > 3) {
var G__17935__i = 0, G__17935__a = new Array(arguments.length -  3);
while (G__17935__i < G__17935__a.length) {G__17935__a[G__17935__i] = arguments[G__17935__i + 3]; ++G__17935__i;}
G__17934 = new cljs.core.IndexedSeq(G__17935__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq17725){
var G__17726 = cljs.core.first(seq17725);
var seq17725__$1 = cljs.core.next(seq17725);
var G__17727 = cljs.core.first(seq17725__$1);
var seq17725__$2 = cljs.core.next(seq17725__$1);
var G__17728 = cljs.core.first(seq17725__$2);
var seq17725__$3 = cljs.core.next(seq17725__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__17726,G__17727,G__17728,seq17725__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 */
cljs.core.map = (function cljs$core$map(){
var G__17943 = arguments.length;
switch (G__17943) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__17959 = null;
var G__17959__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17959__1 = (function (result){
var G__17944 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17944) : rf.call(null,G__17944));
});
var G__17959__2 = (function (result,input){
var G__17945 = result;
var G__17946 = (function (){var G__17947 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17947) : f.call(null,G__17947));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17945,G__17946) : rf.call(null,G__17945,G__17946));
});
var G__17959__3 = (function() { 
var G__17960__delegate = function (result,input,inputs){
var G__17948 = result;
var G__17949 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17948,G__17949) : rf.call(null,G__17948,G__17949));
};
var G__17960 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__17961__i = 0, G__17961__a = new Array(arguments.length -  2);
while (G__17961__i < G__17961__a.length) {G__17961__a[G__17961__i] = arguments[G__17961__i + 2]; ++G__17961__i;}
  inputs = new cljs.core.IndexedSeq(G__17961__a,0);
} 
return G__17960__delegate.call(this,result,input,inputs);};
G__17960.cljs$lang$maxFixedArity = 2;
G__17960.cljs$lang$applyTo = (function (arglist__17962){
var result = cljs.core.first(arglist__17962);
arglist__17962 = cljs.core.next(arglist__17962);
var input = cljs.core.first(arglist__17962);
var inputs = cljs.core.rest(arglist__17962);
return G__17960__delegate(result,input,inputs);
});
G__17960.cljs$core$IFn$_invoke$arity$variadic = G__17960__delegate;
return G__17960;
})()
;
G__17959 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__17959__0.call(this);
case 1:
return G__17959__1.call(this,result);
case 2:
return G__17959__2.call(this,result,input);
default:
var G__17963 = null;
if (arguments.length > 2) {
var G__17964__i = 0, G__17964__a = new Array(arguments.length -  2);
while (G__17964__i < G__17964__a.length) {G__17964__a[G__17964__i] = arguments[G__17964__i + 2]; ++G__17964__i;}
G__17963 = new cljs.core.IndexedSeq(G__17964__a,0);
}
return G__17959__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__17963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17959.cljs$lang$maxFixedArity = 2;
G__17959.cljs$lang$applyTo = G__17959__3.cljs$lang$applyTo;
G__17959.cljs$core$IFn$_invoke$arity$0 = G__17959__0;
G__17959.cljs$core$IFn$_invoke$arity$1 = G__17959__1;
G__17959.cljs$core$IFn$_invoke$arity$2 = G__17959__2;
G__17959.cljs$core$IFn$_invoke$arity$variadic = G__17959__3.cljs$core$IFn$_invoke$arity$variadic;
return G__17959;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5161__auto___17965 = size;
var i_17966 = (0);
while(true){
if((i_17966 < n__5161__auto___17965)){
cljs.core.chunk_append(b,(function (){var G__17950 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17966);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17950) : f.call(null,G__17950));
})());

var G__17967 = (i_17966 + (1));
i_17966 = G__17967;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__17951 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17951) : f.call(null,G__17951));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__17952 = cljs.core.first(s1);
var G__17953 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17952,G__17953) : f.call(null,G__17952,G__17953));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__17954 = cljs.core.first(s1);
var G__17955 = cljs.core.first(s2);
var G__17956 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17954,G__17955,G__17956) : f.call(null,G__17954,G__17955,G__17956));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__17936_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__17936_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq17937){
var G__17938 = cljs.core.first(seq17937);
var seq17937__$1 = cljs.core.next(seq17937);
var G__17939 = cljs.core.first(seq17937__$1);
var seq17937__$2 = cljs.core.next(seq17937__$1);
var G__17940 = cljs.core.first(seq17937__$2);
var seq17937__$3 = cljs.core.next(seq17937__$2);
var G__17941 = cljs.core.first(seq17937__$3);
var seq17937__$4 = cljs.core.next(seq17937__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__17938,G__17939,G__17940,G__17941,seq17937__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function cljs$core$take(){
var G__17969 = arguments.length;
switch (G__17969) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__17974 = null;
var G__17974__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17974__1 = (function (result){
var G__17970 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17970) : rf.call(null,G__17970));
});
var G__17974__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__17971 = result;
var G__17972 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17971,G__17972) : rf.call(null,G__17971,G__17972));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__17974 = function(result,input){
switch(arguments.length){
case 0:
return G__17974__0.call(this);
case 1:
return G__17974__1.call(this,result);
case 2:
return G__17974__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17974.cljs$core$IFn$_invoke$arity$0 = G__17974__0;
G__17974.cljs$core$IFn$_invoke$arity$1 = G__17974__1;
G__17974.cljs$core$IFn$_invoke$arity$2 = G__17974__2;
return G__17974;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(){
var G__17976 = arguments.length;
switch (G__17976) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__17981 = null;
var G__17981__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17981__1 = (function (result){
var G__17977 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17977) : rf.call(null,G__17977));
});
var G__17981__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__17978 = result;
var G__17979 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17978,G__17979) : rf.call(null,G__17978,G__17979));
}
});
G__17981 = function(result,input){
switch(arguments.length){
case 0:
return G__17981__0.call(this);
case 1:
return G__17981__1.call(this,result);
case 2:
return G__17981__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17981.cljs$core$IFn$_invoke$arity$0 = G__17981__0;
G__17981.cljs$core$IFn$_invoke$arity$1 = G__17981__1;
G__17981.cljs$core$IFn$_invoke$arity$2 = G__17981__2;
return G__17981;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__17982 = (n__$1 - (1));
var G__17983 = cljs.core.rest(s);
n__$1 = G__17982;
coll__$1 = G__17983;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(){
var G__17985 = arguments.length;
switch (G__17985) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__17987 = cljs.core.next(s);
var G__17988 = cljs.core.next(lead);
s = G__17987;
lead = G__17988;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(){
var G__17990 = arguments.length;
switch (G__17990) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__17998 = null;
var G__17998__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17998__1 = (function (result){
var G__17991 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17991) : rf.call(null,G__17991));
});
var G__17998__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__4264__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__17992 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17992) : pred.call(null,G__17992));
} else {
return and__4264__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__17993 = result;
var G__17994 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17993,G__17994) : rf.call(null,G__17993,G__17994));
}
});
G__17998 = function(result,input){
switch(arguments.length){
case 0:
return G__17998__0.call(this);
case 1:
return G__17998__1.call(this,result);
case 2:
return G__17998__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17998.cljs$core$IFn$_invoke$arity$0 = G__17998__0;
G__17998.cljs$core$IFn$_invoke$arity$1 = G__17998__1;
G__17998.cljs$core$IFn$_invoke$arity$2 = G__17998__2;
return G__17998;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__4264__auto__ = s;
if(and__4264__auto__){
var G__17996 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__17996) : pred__$1.call(null,G__17996));
} else {
return and__4264__auto__;
}
})())){
var G__17999 = pred__$1;
var G__18000 = cljs.core.rest(s);
pred__$1 = G__17999;
coll__$1 = G__18000;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(){
var G__18003 = arguments.length;
switch (G__18003) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(){
var G__18006 = arguments.length;
switch (G__18006) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__18011 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18011) : f.call(null,G__18011));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(){
var G__18016 = arguments.length;
switch (G__18016) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq18012){
var G__18013 = cljs.core.first(seq18012);
var seq18012__$1 = cljs.core.next(seq18012);
var G__18014 = cljs.core.first(seq18012__$1);
var seq18012__$2 = cljs.core.next(seq18012__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__18013,G__18014,seq18012__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function cljs$core$interpose(){
var G__18019 = arguments.length;
switch (G__18019) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__18028 = null;
var G__18028__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18028__1 = (function (result){
var G__18020 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18020) : rf.call(null,G__18020));
});
var G__18028__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__18021 = result;
var G__18022 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18021,G__18022) : rf.call(null,G__18021,G__18022));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__18023 = sepr;
var G__18024 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18023,G__18024) : rf.call(null,G__18023,G__18024));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__18025 = result;
var G__18026 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18025,G__18026) : rf.call(null,G__18025,G__18026));
}
});
G__18028 = function(result,input){
switch(arguments.length){
case 0:
return G__18028__0.call(this);
case 1:
return G__18028__1.call(this,result);
case 2:
return G__18028__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18028.cljs$core$IFn$_invoke$arity$0 = G__18028__0;
G__18028.cljs$core$IFn$_invoke$arity$1 = G__18028__1;
G__18028.cljs$core$IFn$_invoke$arity$2 = G__18028__2;
return G__18028;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(){
var G__18040 = arguments.length;
switch (G__18040) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5328__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq18037){
var G__18038 = cljs.core.first(seq18037);
var seq18037__$1 = cljs.core.next(seq18037);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__18038,seq18037__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(){
var G__18043 = arguments.length;
switch (G__18043) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__18051 = null;
var G__18051__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18051__1 = (function (result){
var G__18044 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18044) : rf.call(null,G__18044));
});
var G__18051__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__18045 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18045) : pred.call(null,G__18045));
})())){
var G__18046 = result;
var G__18047 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18046,G__18047) : rf.call(null,G__18046,G__18047));
} else {
return result;
}
});
G__18051 = function(result,input){
switch(arguments.length){
case 0:
return G__18051__0.call(this);
case 1:
return G__18051__1.call(this,result);
case 2:
return G__18051__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18051.cljs$core$IFn$_invoke$arity$0 = G__18051__0;
G__18051.cljs$core$IFn$_invoke$arity$1 = G__18051__1;
G__18051.cljs$core$IFn$_invoke$arity$2 = G__18051__2;
return G__18051;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5161__auto___18052 = size;
var i_18053 = (0);
while(true){
if((i_18053 < n__5161__auto___18052)){
if(cljs.core.truth_((function (){var G__18048 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18053);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18048) : pred.call(null,G__18048));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18053));
} else {
}

var G__18054 = (i_18053 + (1));
i_18053 = G__18054;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__18049 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18049) : pred.call(null,G__18049));
})())){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(){
var G__18056 = arguments.length;
switch (G__18056) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__18064 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__18064) : branch_QMARK_.call(null,G__18064));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__18065 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__18065) : children.call(null,G__18065));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18066_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__18066_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(){
var G__18068 = arguments.length;
switch (G__18068) {
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if((function (){var G__18069 = to;
if(G__18069){
var bit__4943__auto__ = (G__18069.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4943__auto__) || (G__18069.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((function (){var G__18070 = to;
if(G__18070){
var bit__4943__auto__ = (G__18070.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4943__auto__) || (G__18070.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(){
var G__18078 = arguments.length;
switch (G__18078) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__18079 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18079) : f.call(null,G__18079));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq18072){
var G__18073 = cljs.core.first(seq18072);
var seq18072__$1 = cljs.core.next(seq18072);
var G__18074 = cljs.core.first(seq18072__$1);
var seq18072__$2 = cljs.core.next(seq18072__$1);
var G__18075 = cljs.core.first(seq18072__$2);
var seq18072__$3 = cljs.core.next(seq18072__$2);
var G__18076 = cljs.core.first(seq18072__$3);
var seq18072__$4 = cljs.core.next(seq18072__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__18073,G__18074,G__18075,G__18076,seq18072__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = 4;
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__18082 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18082) : pred.call(null,G__18082));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(){
var G__18084 = arguments.length;
switch (G__18084) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(){
var G__18087 = arguments.length;
switch (G__18087) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__18088 = m__$1;
if(G__18088){
var bit__4950__auto__ = (G__18088.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4950__auto__) || (G__18088.cljs$core$ILookup$)){
return true;
} else {
if((!G__18088.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__18088);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__18088);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__18090 = sentinel;
var G__18091 = m__$2;
var G__18092 = cljs.core.next(ks__$1);
sentinel = G__18090;
m__$1 = G__18091;
ks__$1 = G__18092;
continue;
}
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__18093,v){
var vec__18098 = p__18093;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18098,(0),null);
var ks = cljs.core.nthnext(vec__18098,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 */
cljs.core.update_in = (function cljs$core$update_in(){
var G__18107 = arguments.length;
switch (G__18107) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5328__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__18108,f){
var vec__18109 = p__18108;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18109,(0),null);
var ks = cljs.core.nthnext(vec__18109,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18110) : f.call(null,G__18110));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__18111,f,a){
var vec__18112 = p__18111;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18112,(0),null);
var ks = cljs.core.nthnext(vec__18112,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18114 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18113,G__18114) : f.call(null,G__18113,G__18114));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__18115,f,a,b){
var vec__18116 = p__18115;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18116,(0),null);
var ks = cljs.core.nthnext(vec__18116,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18118 = a;
var G__18119 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18117,G__18118,G__18119) : f.call(null,G__18117,G__18118,G__18119));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__18120,f,a,b,c){
var vec__18121 = p__18120;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18121,(0),null);
var ks = cljs.core.nthnext(vec__18121,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18123 = a;
var G__18124 = b;
var G__18125 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18122,G__18123,G__18124,G__18125) : f.call(null,G__18122,G__18123,G__18124,G__18125));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__18126,f,a,b,c,args){
var vec__18127 = p__18126;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18127,(0),null);
var ks = cljs.core.nthnext(vec__18127,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq18099){
var G__18100 = cljs.core.first(seq18099);
var seq18099__$1 = cljs.core.next(seq18099);
var G__18101 = cljs.core.first(seq18099__$1);
var seq18099__$2 = cljs.core.next(seq18099__$1);
var G__18102 = cljs.core.first(seq18099__$2);
var seq18099__$3 = cljs.core.next(seq18099__$2);
var G__18103 = cljs.core.first(seq18099__$3);
var seq18099__$4 = cljs.core.next(seq18099__$3);
var G__18104 = cljs.core.first(seq18099__$4);
var seq18099__$5 = cljs.core.next(seq18099__$4);
var G__18105 = cljs.core.first(seq18099__$5);
var seq18099__$6 = cljs.core.next(seq18099__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__18100,G__18101,G__18102,G__18103,G__18104,G__18105,seq18099__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = 6;
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(){
var G__18137 = arguments.length;
switch (G__18137) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5328__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18138) : f.call(null,G__18138));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18140 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18139,G__18140) : f.call(null,G__18139,G__18140));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18142 = x;
var G__18143 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18141,G__18142,G__18143) : f.call(null,G__18141,G__18142,G__18143));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18145 = x;
var G__18146 = y;
var G__18147 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18144,G__18145,G__18146,G__18147) : f.call(null,G__18144,G__18145,G__18146,G__18147));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq18129){
var G__18130 = cljs.core.first(seq18129);
var seq18129__$1 = cljs.core.next(seq18129);
var G__18131 = cljs.core.first(seq18129__$1);
var seq18129__$2 = cljs.core.next(seq18129__$1);
var G__18132 = cljs.core.first(seq18129__$2);
var seq18129__$3 = cljs.core.next(seq18129__$2);
var G__18133 = cljs.core.first(seq18129__$3);
var seq18129__$4 = cljs.core.next(seq18129__$3);
var G__18134 = cljs.core.first(seq18129__$4);
var seq18129__$5 = cljs.core.next(seq18129__$4);
var G__18135 = cljs.core.first(seq18129__$5);
var seq18129__$6 = cljs.core.next(seq18129__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__18130,G__18131,G__18132,G__18133,G__18134,G__18135,seq18129__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = 6;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__18149 = (ll - (5));
var G__18150 = r;
ll = G__18149;
ret = G__18150;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__18155 = cljs.core.pv_aget(node,(0));
var G__18156 = (level - (5));
node = G__18155;
level = G__18156;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__18157 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__18158 = (level - (5));
node = G__18157;
level = G__18158;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__18168 = init__$2;
var G__18169 = (j + i);
var G__18170 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18168,G__18169,G__18170) : f.call(null,G__18168,G__18169,G__18170));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__18181 = (j + (1));
var G__18182 = init__$3;
j = G__18181;
init__$2 = G__18182;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18171 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18171) : cljs.core.deref.call(null,G__18171));
} else {
var G__18183 = (i + len);
var G__18184 = init__$2;
i = G__18183;
init__$1 = G__18184;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__18172 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__18172) : cljs.core.tv_editable_root.call(null,G__18172));
})(),(function (){var G__18173 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__18173) : cljs.core.tv_editable_tail.call(null,G__18173));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__18174 = init__$2;
var G__18175 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18174,G__18175) : f.call(null,G__18174,G__18175));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__18185 = (j + (1));
var G__18186 = init__$3;
j = G__18185;
init__$2 = G__18186;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18176 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18176) : cljs.core.deref.call(null,G__18176));
} else {
var G__18187 = (i + len);
var G__18188 = init__$2;
i = G__18187;
init__$1 = G__18188;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__18177 = coll__$1;
var G__18178 = cljs.core.first_array_for_longvec(coll__$1);
var G__18179 = (0);
var G__18180 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18177,G__18178,G__18179,G__18180) : cljs.core.chunked_seq.call(null,G__18177,G__18178,G__18179,G__18180));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__5161__auto___18189 = len;
var i_18190 = (0);
while(true){
if((i_18190 < n__5161__auto___18189)){
(new_tail[i_18190] = (self__.tail[i_18190]));

var G__18191 = (i_18190 + (1));
i_18190 = G__18191;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__18192 = null;
var G__18192__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__18192__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__18192 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18192__2.call(this,self__,k);
case 3:
return G__18192__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18192.cljs$core$IFn$_invoke$arity$2 = G__18192__2;
G__18192.cljs$core$IFn$_invoke$arity$3 = G__18192__3;
return G__18192;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args18167){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18167)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__18193 = (i + (1));
var G__18194 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__18193;
out = G__18194;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq18195){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18195));
});

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__18196 = self__.vec;
var G__18197 = self__.node;
var G__18198 = self__.i;
var G__18199 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18196,G__18197,G__18198,G__18199) : cljs.core.chunked_seq.call(null,G__18196,G__18197,G__18198,G__18199));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__18200 = self__.vec;
var G__18201 = (self__.i + self__.off);
var G__18202 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18200,G__18201,G__18202) : cljs.core.subvec.call(null,G__18200,G__18201,G__18202));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__18203 = self__.vec;
var G__18204 = (self__.i + self__.off);
var G__18205 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18203,G__18204,G__18205) : cljs.core.subvec.call(null,G__18203,G__18204,G__18205));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__18206 = self__.vec;
var G__18207 = self__.node;
var G__18208 = self__.i;
var G__18209 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18206,G__18207,G__18208,G__18209) : cljs.core.chunked_seq.call(null,G__18206,G__18207,G__18208,G__18209));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__18210 = self__.vec;
var G__18211 = cljs.core.unchecked_array_for(self__.vec,end);
var G__18212 = end;
var G__18213 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18210,G__18211,G__18212,G__18213) : cljs.core.chunked_seq.call(null,G__18210,G__18211,G__18212,G__18213));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__18214 = self__.vec;
var G__18215 = self__.node;
var G__18216 = self__.i;
var G__18217 = self__.off;
var G__18218 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__18214,G__18215,G__18216,G__18217,G__18218) : cljs.core.chunked_seq.call(null,G__18214,G__18215,G__18216,G__18217,G__18218));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__18219 = self__.vec;
var G__18220 = cljs.core.unchecked_array_for(self__.vec,end);
var G__18221 = end;
var G__18222 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18219,G__18220,G__18221,G__18222) : cljs.core.chunked_seq.call(null,G__18219,G__18220,G__18221,G__18222));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(){
var G__18224 = arguments.length;
switch (G__18224) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__18227 = init__$1;
var G__18228 = j;
var G__18229 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18227,G__18228,G__18229) : f.call(null,G__18227,G__18228,G__18229));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18230 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18230) : cljs.core.deref.call(null,G__18230));
} else {
var G__18252 = (i + (1));
var G__18253 = (j + (1));
var G__18254 = init__$2;
i = G__18252;
j = G__18253;
init__$1 = G__18254;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__18231 = self__.meta;
var G__18232 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__18233 = self__.start;
var G__18234 = (function (){var x__4588__auto__ = self__.end;
var y__4589__auto__ = (v_pos + (1));
return ((x__4588__auto__ > y__4589__auto__) ? x__4588__auto__ : y__4589__auto__);
})();
var G__18235 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18231,G__18232,G__18233,G__18234,G__18235) : cljs.core.build_subvec.call(null,G__18231,G__18232,G__18233,G__18234,G__18235));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__18236 = self__.meta;
var G__18237 = self__.v;
var G__18238 = self__.start;
var G__18239 = (self__.end - (1));
var G__18240 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18236,G__18237,G__18238,G__18239,G__18240) : cljs.core.build_subvec.call(null,G__18236,G__18237,G__18238,G__18239,G__18240));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__18242 = meta__$1;
var G__18243 = self__.v;
var G__18244 = self__.start;
var G__18245 = self__.end;
var G__18246 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18242,G__18243,G__18244,G__18245,G__18246) : cljs.core.build_subvec.call(null,G__18242,G__18243,G__18244,G__18245,G__18246));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__18247 = self__.meta;
var G__18248 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__18249 = self__.start;
var G__18250 = (self__.end + (1));
var G__18251 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18247,G__18248,G__18249,G__18250,G__18251) : cljs.core.build_subvec.call(null,G__18247,G__18248,G__18249,G__18250,G__18251));
});

cljs.core.Subvec.prototype.call = (function() {
var G__18255 = null;
var G__18255__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__18255__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__18255 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18255__2.call(this,self__,k);
case 3:
return G__18255__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18255.cljs$core$IFn$_invoke$arity$2 = G__18255__2;
G__18255.cljs$core$IFn$_invoke$arity$3 = G__18255__3;
return G__18255;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args18226){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18226)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__18256 = meta;
var G__18257 = v.v;
var G__18258 = (v.start + start);
var G__18259 = (v.start + end);
var G__18260 = __hash;
meta = G__18256;
v = G__18257;
start = G__18258;
end = G__18259;
__hash = G__18260;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(){
var G__18262 = arguments.length;
switch (G__18262) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj18267 = {};
return obj18267;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__18275 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__18276 = (level - (5));
node = G__18275;
level = G__18276;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__18280 = null;
var G__18280__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18280__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18280 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18280__2.call(this,self__,k);
case 3:
return G__18280__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18280.cljs$core$IFn$_invoke$arity$2 = G__18280__2;
G__18280.cljs$core$IFn$_invoke$arity$3 = G__18280__3;
return G__18280;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args18277){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18277)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__4276__auto__ = self__.front;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4276__auto__ = self__.rear;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__18281 = (i + incr);
i = G__18281;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__18282 = (i + (1));
var G__18283 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__18282;
out = G__18283;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj18287 = {};
return obj18287;
})();
var l = ks.length;
var i_18288 = (0);
while(true){
if((i_18288 < l)){
var k_18289 = (ks[i_18288]);
(new_obj[k_18289] = (obj[k_18289]));

var G__18290 = (i_18288 + (1));
i_18288 = G__18290;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__4264__auto__ = (function (){var G__18294 = k;
return goog.isString(G__18294);
})();
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__4264__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__18295 = init__$1;
var G__18296 = k;
var G__18297 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18295,G__18296,G__18297) : f.call(null,G__18295,G__18296,G__18297));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18298 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18298) : cljs.core.deref.call(null,G__18298));
} else {
var G__18304 = cljs.core.rest(keys__$1);
var G__18305 = init__$2;
keys__$1 = G__18304;
init__$1 = G__18305;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__4264__auto__ = (function (){var G__18300 = k;
return goog.isString(G__18300);
})();
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__4264__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__18301 = k;
return goog.isString(G__18301);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__4264__auto__ = (function (){var G__18303 = k;
return goog.isString(G__18303);
})();
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__4264__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__18291_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__18291_SHARP_,(self__.strobj[p1__18291_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__18306 = null;
var G__18306__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18306__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18306 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18306__2.call(this,self__,k);
case 3:
return G__18306__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18306.cljs$core$IFn$_invoke$arity$2 = G__18306__2;
G__18306.cljs$core$IFn$_invoke$arity$3 = G__18306__3;
return G__18306;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args18292){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18292)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj18308 = {};
return obj18308;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__18309 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18309,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18309,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__18310 = (i + (2));
i = G__18310;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__18311 = (i + (2));
i = G__18311;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__18312 = (i + (2));
i = G__18312;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__18313 = (i + (2));
i = G__18313;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__18314 = (i + (2));
i = G__18314;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(cljs.core.truth_((function (){var or__4276__auto__ = (function (){var G__18318 = k;
return goog.isString(G__18318);
})();
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_18319 = (0);
while(true){
if((i_18319 < l)){
(narr[i_18319] = (arr[i_18319]));

var G__18320 = (i_18319 + (1));
i_18319 = G__18320;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18322 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18322) : cljs.core.keys.call(null,G__18322));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18323 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18323) : cljs.core.vals.call(null,G__18323));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18324 = cljs.core.seq(coll);
var chunk__18325 = null;
var count__18326 = (0);
var i__18327 = (0);
while(true){
if((i__18327 < count__18326)){
var vec__18328 = chunk__18325.cljs$core$IIndexed$_nth$arity$2(null,i__18327);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18328,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18328,(1),null);
var G__18329_18342 = v;
var G__18330_18343 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18329_18342,G__18330_18343) : f.call(null,G__18329_18342,G__18330_18343));

var G__18344 = seq__18324;
var G__18345 = chunk__18325;
var G__18346 = count__18326;
var G__18347 = (i__18327 + (1));
seq__18324 = G__18344;
chunk__18325 = G__18345;
count__18326 = G__18346;
i__18327 = G__18347;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18324);
if(temp__4126__auto__){
var seq__18324__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18324__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18324__$1);
var G__18348 = cljs.core.chunk_rest(seq__18324__$1);
var G__18349 = c__5061__auto__;
var G__18350 = cljs.core.count(c__5061__auto__);
var G__18351 = (0);
seq__18324 = G__18348;
chunk__18325 = G__18349;
count__18326 = G__18350;
i__18327 = G__18351;
continue;
} else {
var vec__18331 = cljs.core.first(seq__18324__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18331,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18331,(1),null);
var G__18332_18352 = v;
var G__18333_18353 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18332_18352,G__18333_18353) : f.call(null,G__18332_18352,G__18333_18353));

var G__18354 = cljs.core.next(seq__18324__$1);
var G__18355 = null;
var G__18356 = (0);
var G__18357 = (0);
seq__18324 = G__18354;
chunk__18325 = G__18355;
count__18326 = G__18356;
i__18327 = G__18357;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__18334 = init__$1;
var G__18335 = (self__.arr[i]);
var G__18336 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18334,G__18335,G__18336) : f.call(null,G__18334,G__18335,G__18336));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18337 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18337) : cljs.core.deref.call(null,G__18337));
} else {
var G__18358 = (i + (2));
var G__18359 = init__$2;
i = G__18358;
init__$1 = G__18359;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__18338 = other;
if(G__18338){
var bit__4943__auto__ = (G__18338.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4943__auto__) || (G__18338.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__18360 = (i + (2));
i = G__18360;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj18340 = {};
return obj18340;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__18361 = (s + (2));
var G__18362 = d;
s = G__18361;
d = G__18362;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__18363 = (s + (2));
var G__18364 = (d + (2));
s = G__18363;
d = G__18364;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__18341 = cljs.core.aclone(self__.arr);
(G__18341[(idx + (1))] = v);

return G__18341;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18365 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18366 = cljs.core.next(es);
ret = G__18365;
es = G__18366;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__18367 = null;
var G__18367__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18367__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18367 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18367__2.call(this,self__,k);
case 3:
return G__18367__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18367.cljs$core$IFn$_invoke$arity$2 = G__18367__2;
G__18367.cljs$core$IFn$_invoke$arity$3 = G__18367__3;
return G__18367;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args18321){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18321)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_18368 = (0);
while(true){
if((i_18368 < arr__$1.length)){
var k_18369 = (arr__$1[i_18368]);
var v_18370 = (arr__$1[(i_18368 + (1))]);
var idx_18371 = cljs.core.array_index_of(ret,k_18369);
if((idx_18371 === (-1))){
ret.push(k_18369);

ret.push(v_18370);
} else {
}

var G__18372 = (i_18368 + (2));
i_18368 = G__18372;
continue;
} else {
}
break;
}

return ret;
})());
var arr__$3 = (function (){var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
})();
return arr__$3;
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__18373_18381 = self__.arr;
G__18373_18381.pop();

G__18373_18381.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__18374 = self__.len;
var G__18375 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__18374,G__18375) : cljs.core.array__GT_transient_hash_map.call(null,G__18374,G__18375));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__18376 = o;
if(G__18376){
var bit__4950__auto__ = (G__18376.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4950__auto__) || (G__18376.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__18376.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__18376);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__18376);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__18377 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18377) : cljs.core.key.call(null,G__18377));
})(),(function (){var G__18378 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18378) : cljs.core.val.call(null,G__18378));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__18382 = cljs.core.next(es);
var G__18383 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__18379 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18379) : cljs.core.key.call(null,G__18379));
})(),(function (){var G__18380 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18380) : cljs.core.val.call(null,G__18380));
})());
es = G__18382;
tcoll__$2 = G__18383;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__18384 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__18385 = (i + (2));
out = G__18384;
i = G__18385;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(){
var G__18387 = arguments.length;
switch (G__18387) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__18388 = cljs.core.aclone(arr);
(G__18388[i] = a);

return G__18388;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__18389 = cljs.core.aclone(arr);
(G__18389[i] = a);

(G__18389[j] = b);

return G__18389;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(){
var G__18392 = arguments.length;
switch (G__18392) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__18398 = init__$1;
var G__18399 = k;
var G__18400 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18398,G__18399,G__18400) : f.call(null,G__18398,G__18399,G__18400));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18401 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18401) : cljs.core.deref.call(null,G__18401));
} else {
var G__18402 = (i + (2));
var G__18403 = init__$2;
i = G__18402;
init__$1 = G__18403;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__18404 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__18404) : cljs.core.create_inode_seq.call(null,G__18404));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_18418 = (0);
var j_18419 = (0);
while(true){
if((i_18418 < (32))){
if((((self__.bitmap >>> i_18418) & (1)) === (0))){
var G__18420 = (i_18418 + (1));
var G__18421 = j_18419;
i_18418 = G__18420;
j_18419 = G__18421;
continue;
} else {
(nodes[i_18418] = ((!(((self__.arr[j_18419]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_18419])),(self__.arr[j_18419]),(self__.arr[(j_18419 + (1))]),added_leaf_QMARK_):(self__.arr[(j_18419 + (1))])));

var G__18422 = (i_18418 + (1));
var G__18423 = (j_18419 + (2));
i_18418 = G__18422;
j_18419 = G__18423;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__18405 = edit__$1;
var G__18406 = (shift + (5));
var G__18407 = key_or_nil;
var G__18408 = val_or_node;
var G__18409 = hash;
var G__18410 = key;
var G__18411 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__18405,G__18406,G__18407,G__18408,G__18409,G__18410,G__18411) : cljs.core.create_node.call(null,G__18405,G__18406,G__18407,G__18408,G__18409,G__18410,G__18411));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_18424 = (0);
var j_18425 = (0);
while(true){
if((i_18424 < (32))){
if((((self__.bitmap >>> i_18424) & (1)) === (0))){
var G__18426 = (i_18424 + (1));
var G__18427 = j_18425;
i_18424 = G__18426;
j_18425 = G__18427;
continue;
} else {
(nodes[i_18424] = ((!(((self__.arr[j_18425]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_18425])),(self__.arr[j_18425]),(self__.arr[(j_18425 + (1))]),added_leaf_QMARK_):(self__.arr[(j_18425 + (1))])));

var G__18428 = (i_18424 + (1));
var G__18429 = (j_18425 + (2));
i_18424 = G__18428;
j_18425 = G__18429;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__18412 = (shift + (5));
var G__18413 = key_or_nil;
var G__18414 = val_or_node;
var G__18415 = hash;
var G__18416 = key;
var G__18417 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__18412,G__18413,G__18414,G__18415,G__18416,G__18417) : cljs.core.create_node.call(null,G__18412,G__18413,G__18414,G__18415,G__18416,G__18417));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__18430 = (i + (1));
var G__18431 = (j + (2));
var G__18432 = (bitmap | ((1) << i));
i = G__18430;
j = G__18431;
bitmap = G__18432;
continue;
} else {
var G__18433 = (i + (1));
var G__18434 = j;
var G__18435 = bitmap;
i = G__18433;
j = G__18434;
bitmap = G__18435;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__18436 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__18436) : cljs.core.create_array_node_seq.call(null,G__18436));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18437 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18437) : cljs.core.deref.call(null,G__18437));
} else {
var G__18438 = (i + (1));
var G__18439 = init__$2;
i = G__18438;
init__$1 = G__18439;
continue;
}
} else {
var G__18440 = (i + (1));
var G__18441 = init__$1;
i = G__18440;
init__$1 = G__18441;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__18442 = (i + (2));
i = G__18442;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__18443 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__18443) : cljs.core.create_inode_seq.call(null,G__18443));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(){
var G__18445 = arguments.length;
switch (G__18445) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__18447 = self__.nodes;
var G__18448 = (self__.i + (2));
var G__18449 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18447,G__18448,G__18449) : cljs.core.create_inode_seq.call(null,G__18447,G__18448,G__18449));
} else {
var G__18450 = self__.nodes;
var G__18451 = self__.i;
var G__18452 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18450,G__18451,G__18452) : cljs.core.create_inode_seq.call(null,G__18450,G__18451,G__18452));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(){
var G__18454 = arguments.length;
switch (G__18454) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__18456 = (j + (2));
j = G__18456;
continue;
}
} else {
var G__18457 = (j + (2));
j = G__18457;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__18458 = null;
var G__18459 = self__.nodes;
var G__18460 = self__.i;
var G__18461 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__18458,G__18459,G__18460,G__18461) : cljs.core.create_array_node_seq.call(null,G__18458,G__18459,G__18460,G__18461));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(){
var G__18463 = arguments.length;
switch (G__18463) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__18465 = (j + (1));
j = G__18465;
continue;
}
} else {
var G__18466 = (j + (1));
j = G__18466;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18468 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18468) : cljs.core.keys.call(null,G__18468));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18469 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18469) : cljs.core.vals.call(null,G__18469));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18470 = cljs.core.seq(coll);
var chunk__18471 = null;
var count__18472 = (0);
var i__18473 = (0);
while(true){
if((i__18473 < count__18472)){
var vec__18474 = chunk__18471.cljs$core$IIndexed$_nth$arity$2(null,i__18473);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18474,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18474,(1),null);
var G__18475_18486 = v;
var G__18476_18487 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18475_18486,G__18476_18487) : f.call(null,G__18475_18486,G__18476_18487));

var G__18488 = seq__18470;
var G__18489 = chunk__18471;
var G__18490 = count__18472;
var G__18491 = (i__18473 + (1));
seq__18470 = G__18488;
chunk__18471 = G__18489;
count__18472 = G__18490;
i__18473 = G__18491;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18470);
if(temp__4126__auto__){
var seq__18470__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18470__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18470__$1);
var G__18492 = cljs.core.chunk_rest(seq__18470__$1);
var G__18493 = c__5061__auto__;
var G__18494 = cljs.core.count(c__5061__auto__);
var G__18495 = (0);
seq__18470 = G__18492;
chunk__18471 = G__18493;
count__18472 = G__18494;
i__18473 = G__18495;
continue;
} else {
var vec__18477 = cljs.core.first(seq__18470__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18477,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18477,(1),null);
var G__18478_18496 = v;
var G__18479_18497 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18478_18496,G__18479_18497) : f.call(null,G__18478_18496,G__18479_18497));

var G__18498 = cljs.core.next(seq__18470__$1);
var G__18499 = null;
var G__18500 = (0);
var G__18501 = (0);
seq__18470 = G__18498;
chunk__18471 = G__18499;
count__18472 = G__18500;
i__18473 = G__18501;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__18480 = init;
var G__18481 = null;
var G__18482 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18480,G__18481,G__18482) : f.call(null,G__18480,G__18481,G__18482));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__18483 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18483) : cljs.core.deref.call(null,G__18483));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj18485 = {};
return obj18485;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18502 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18503 = cljs.core.next(es);
ret = G__18502;
es = G__18503;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__18504 = null;
var G__18504__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18504__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18504 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18504__2.call(this,self__,k);
case 3:
return G__18504__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18504.cljs$core$IFn$_invoke$arity$2 = G__18504__2;
G__18504.cljs$core$IFn$_invoke$arity$3 = G__18504__3;
return G__18504;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args18467){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18467)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__18505 = (i + (2));
var G__18506 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__18505;
ret = G__18506;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__18507 = (i + (1));
var G__18508 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__18507;
out = G__18508;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__18509 = o;
if(G__18509){
var bit__4950__auto__ = (G__18509.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4950__auto__) || (G__18509.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__18509.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__18509);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__18509);
}
})()){
return tcoll.assoc_BANG_((function (){var G__18510 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18510) : cljs.core.key.call(null,G__18510));
})(),(function (){var G__18511 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18511) : cljs.core.val.call(null,G__18511));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__18514 = cljs.core.next(es);
var G__18515 = tcoll__$1.assoc_BANG_((function (){var G__18512 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18512) : cljs.core.key.call(null,G__18512));
})(),(function (){var G__18513 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18513) : cljs.core.val.call(null,G__18513));
})());
es = G__18514;
tcoll__$1 = G__18515;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__18516 = ((ascending_QMARK_)?t.left:t.right);
var G__18517 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__18516;
stack__$1 = G__18517;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__18530 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18530) : cljs.core.deref.call(null,G__18530));
} else {
var init__$2 = (function (){var G__18531 = init__$1;
var G__18532 = node.key;
var G__18533 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18531,G__18532,G__18533) : f.call(null,G__18531,G__18532,G__18533));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__18534 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18534) : cljs.core.deref.call(null,G__18534));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__18535 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18535) : cljs.core.deref.call(null,G__18535));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__18537 = null;
var G__18537__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18537__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18537 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18537__2.call(this,self__,k);
case 3:
return G__18537__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18537.cljs$core$IFn$_invoke$arity$2 = G__18537__2;
G__18537.cljs$core$IFn$_invoke$arity$3 = G__18537__3;
return G__18537;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args18536){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18536)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__18539 = null;
var G__18539__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18539__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18539 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18539__2.call(this,self__,k);
case 3:
return G__18539__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18539.cljs$core$IFn$_invoke$arity$2 = G__18539__2;
G__18539.cljs$core$IFn$_invoke$arity$3 = G__18539__3;
return G__18539;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args18538){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18538)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__18552 = k;
var G__18553 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18552,G__18553) : comp.call(null,G__18552,G__18553));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__18572 = k;
var G__18573 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18572,G__18573) : comp.call(null,G__18572,G__18573));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__18584 = k;
var G__18585 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18584,G__18585) : comp.call(null,G__18584,G__18585));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18587 = cljs.core.seq(coll);
var chunk__18588 = null;
var count__18589 = (0);
var i__18590 = (0);
while(true){
if((i__18590 < count__18589)){
var vec__18591 = chunk__18588.cljs$core$IIndexed$_nth$arity$2(null,i__18590);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18591,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18591,(1),null);
var G__18592_18604 = v;
var G__18593_18605 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18592_18604,G__18593_18605) : f.call(null,G__18592_18604,G__18593_18605));

var G__18606 = seq__18587;
var G__18607 = chunk__18588;
var G__18608 = count__18589;
var G__18609 = (i__18590 + (1));
seq__18587 = G__18606;
chunk__18588 = G__18607;
count__18589 = G__18608;
i__18590 = G__18609;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18587);
if(temp__4126__auto__){
var seq__18587__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18587__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18587__$1);
var G__18610 = cljs.core.chunk_rest(seq__18587__$1);
var G__18611 = c__5061__auto__;
var G__18612 = cljs.core.count(c__5061__auto__);
var G__18613 = (0);
seq__18587 = G__18610;
chunk__18588 = G__18611;
count__18589 = G__18612;
i__18590 = G__18613;
continue;
} else {
var vec__18594 = cljs.core.first(seq__18587__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18594,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18594,(1),null);
var G__18595_18614 = v;
var G__18596_18615 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18595_18614,G__18596_18615) : f.call(null,G__18595_18614,G__18596_18615));

var G__18616 = cljs.core.next(seq__18587__$1);
var G__18617 = null;
var G__18618 = (0);
var G__18619 = (0);
seq__18587 = G__18616;
chunk__18588 = G__18617;
count__18589 = G__18618;
i__18590 = G__18619;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18597 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18597) : cljs.core.keys.call(null,G__18597));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__18598 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18598) : cljs.core.vals.call(null,G__18598));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__18599 = k;
var G__18600 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18599,G__18600) : self__.comp.call(null,G__18599,G__18600));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__18620 = t.left;
t = G__18620;
continue;
} else {
var G__18621 = t.right;
t = G__18621;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18622 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18623 = cljs.core.next(es);
ret = G__18622;
es = G__18623;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__18624 = null;
var G__18624__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18624__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18624 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18624__2.call(this,self__,k);
case 3:
return G__18624__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18624.cljs$core$IFn$_invoke$arity$2 = G__18624__2;
G__18624.cljs$core$IFn$_invoke$arity$3 = G__18624__3;
return G__18624;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args18586){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18586)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__18601 = k;
var G__18602 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18601,G__18602) : self__.comp.call(null,G__18601,G__18602));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__18625 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__18626 = t.left;
stack = G__18625;
t = G__18626;
continue;
} else {
var G__18627 = stack;
var G__18628 = t.right;
stack = G__18627;
t = G__18628;
continue;
}
} else {
if((c > (0))){
var G__18629 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__18630 = t.right;
stack = G__18629;
t = G__18630;
continue;
} else {
var G__18631 = stack;
var G__18632 = t.left;
stack = G__18631;
t = G__18632;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__18603 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18603) : cljs.core.key.call(null,G__18603));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__18634 = cljs.core.nnext(in$);
var G__18635 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18634;
out = G__18635;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq18633){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18633));
});
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((keyvals instanceof cljs.core.IndexedSeq))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq18636){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18636));
});
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = (function (){var obj18639 = {};
return obj18639;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__18640 = cljs.core.nnext(kvs);
kvs = G__18640;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq18637){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18637));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__18642 = cljs.core.nnext(in$);
var G__18643 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18642;
out = G__18643;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq18641){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18641));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__18646 = cljs.core.nnext(in$);
var G__18647 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18646;
out = G__18647;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq18644){
var G__18645 = cljs.core.first(seq18644);
var seq18644__$1 = cljs.core.next(seq18644);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__18645,seq18644__$1);
});

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__18648 = self__.mseq;
if(G__18648){
var bit__4950__auto__ = (G__18648.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4950__auto__) || (G__18648.cljs$core$INext$)){
return true;
} else {
if((!G__18648.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18648);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18648);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__18649 = self__.mseq;
if(G__18649){
var bit__4950__auto__ = (G__18649.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4950__auto__) || (G__18649.cljs$core$INext$)){
return true;
} else {
if((!G__18649.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18649);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18649);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__18650 = self__.mseq;
if(G__18650){
var bit__4950__auto__ = (G__18650.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4950__auto__) || (G__18650.cljs$core$INext$)){
return true;
} else {
if((!G__18650.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18650);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18650);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__18651 = self__.mseq;
if(G__18651){
var bit__4950__auto__ = (G__18651.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4950__auto__) || (G__18651.cljs$core$INext$)){
return true;
} else {
if((!G__18651.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18651);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__18651);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__18652_SHARP_,p2__18653_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4276__auto__ = p1__18652_SHARP_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__18653_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq18654){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18654));
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18658 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18657,G__18658) : f.call(null,G__18657,G__18658));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__4276__auto__ = m1;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq18655){
var G__18656 = cljs.core.first(seq18655);
var seq18655__$1 = cljs.core.next(seq18655);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__18656,seq18655__$1);
});
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__18659 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__18660 = cljs.core.next(keys);
ret = G__18659;
keys = G__18660;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18663 = cljs.core.seq(coll);
var chunk__18664 = null;
var count__18665 = (0);
var i__18666 = (0);
while(true){
if((i__18666 < count__18665)){
var vec__18667 = chunk__18664.cljs$core$IIndexed$_nth$arity$2(null,i__18666);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18667,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18667,(1),null);
var G__18668_18673 = v;
var G__18669_18674 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18668_18673,G__18669_18674) : f.call(null,G__18668_18673,G__18669_18674));

var G__18675 = seq__18663;
var G__18676 = chunk__18664;
var G__18677 = count__18665;
var G__18678 = (i__18666 + (1));
seq__18663 = G__18675;
chunk__18664 = G__18676;
count__18665 = G__18677;
i__18666 = G__18678;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18663);
if(temp__4126__auto__){
var seq__18663__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18663__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18663__$1);
var G__18679 = cljs.core.chunk_rest(seq__18663__$1);
var G__18680 = c__5061__auto__;
var G__18681 = cljs.core.count(c__5061__auto__);
var G__18682 = (0);
seq__18663 = G__18679;
chunk__18664 = G__18680;
count__18665 = G__18681;
i__18666 = G__18682;
continue;
} else {
var vec__18670 = cljs.core.first(seq__18663__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18670,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18670,(1),null);
var G__18671_18683 = v;
var G__18672_18684 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18671_18683,G__18672_18684) : f.call(null,G__18671_18683,G__18672_18684));

var G__18685 = cljs.core.next(seq__18663__$1);
var G__18686 = null;
var G__18687 = (0);
var G__18688 = (0);
seq__18663 = G__18685;
chunk__18664 = G__18686;
count__18665 = G__18687;
i__18666 = G__18688;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__18661_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__18661_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__18689 = null;
var G__18689__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18689__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18689 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18689__2.call(this,self__,k);
case 3:
return G__18689__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18689.cljs$core$IFn$_invoke$arity$2 = G__18689__2;
G__18689.cljs$core$IFn$_invoke$arity$3 = G__18689__3;
return G__18689;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args18662){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18662)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__18690 = (i + (1));
var G__18691 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__18690;
out = G__18691;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__18692 = (i + (1));
var G__18693 = cljs.core._conj_BANG_(out,(items[i]));
i = G__18692;
out = G__18693;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__18695 = null;
var G__18695__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__18695__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__18695 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18695__2.call(this,self__,k);
case 3:
return G__18695__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18695.cljs$core$IFn$_invoke$arity$2 = G__18695__2;
G__18695.cljs$core$IFn$_invoke$arity$3 = G__18695__3;
return G__18695;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args18694){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18694)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18698 = cljs.core.seq(coll);
var chunk__18699 = null;
var count__18700 = (0);
var i__18701 = (0);
while(true){
if((i__18701 < count__18700)){
var vec__18702 = chunk__18699.cljs$core$IIndexed$_nth$arity$2(null,i__18701);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18702,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18702,(1),null);
var G__18703_18708 = v;
var G__18704_18709 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18703_18708,G__18704_18709) : f.call(null,G__18703_18708,G__18704_18709));

var G__18710 = seq__18698;
var G__18711 = chunk__18699;
var G__18712 = count__18700;
var G__18713 = (i__18701 + (1));
seq__18698 = G__18710;
chunk__18699 = G__18711;
count__18700 = G__18712;
i__18701 = G__18713;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18698);
if(temp__4126__auto__){
var seq__18698__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18698__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18698__$1);
var G__18714 = cljs.core.chunk_rest(seq__18698__$1);
var G__18715 = c__5061__auto__;
var G__18716 = cljs.core.count(c__5061__auto__);
var G__18717 = (0);
seq__18698 = G__18714;
chunk__18699 = G__18715;
count__18700 = G__18716;
i__18701 = G__18717;
continue;
} else {
var vec__18705 = cljs.core.first(seq__18698__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18705,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18705,(1),null);
var G__18706_18718 = v;
var G__18707_18719 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18706_18718,G__18707_18719) : f.call(null,G__18706_18718,G__18707_18719));

var G__18720 = cljs.core.next(seq__18698__$1);
var G__18721 = null;
var G__18722 = (0);
var G__18723 = (0);
seq__18698 = G__18720;
chunk__18699 = G__18721;
count__18700 = G__18722;
i__18701 = G__18723;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__18696_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__18696_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__18724 = null;
var G__18724__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18724__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18724 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18724__2.call(this,self__,k);
case 3:
return G__18724__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18724.cljs$core$IFn$_invoke$arity$2 = G__18724__2;
G__18724.cljs$core$IFn$_invoke$arity$3 = G__18724__3;
return G__18724;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args18697){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18697)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__5155__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__5155__auto__.length)){
var G__18725 = (i + (1));
var G__18726 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__18725;
res = G__18726;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__18727 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__18728 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__18727;
out = G__18728;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(){
var G__18731 = arguments.length;
switch (G__18731) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,0),(0)));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5328__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq18729){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18729));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq18733){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18733));
});
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq18734){
var G__18735 = cljs.core.first(seq18734);
var seq18734__$1 = cljs.core.next(seq18734);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__18735,seq18734__$1);
});
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function cljs$core$replace(){
var G__18739 = arguments.length;
switch (G__18739) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__18736_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__18736_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__18736_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18737_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__18737_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__18737_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function cljs$core$distinct(){
var G__18742 = arguments.length;
switch (G__18742) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__18754 = null;
var G__18754__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18754__1 = (function (result){
var G__18743 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18743) : rf.call(null,G__18743));
});
var G__18754__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__18744 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18744) : cljs.core.deref.call(null,G__18744));
})(),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

var G__18745 = result;
var G__18746 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18745,G__18746) : rf.call(null,G__18745,G__18746));
}
});
G__18754 = function(result,input){
switch(arguments.length){
case 0:
return G__18754__0.call(this);
case 1:
return G__18754__1.call(this,result);
case 2:
return G__18754__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18754.cljs$core$IFn$_invoke$arity$0 = G__18754__0;
G__18754.cljs$core$IFn$_invoke$arity$1 = G__18754__1;
G__18754.cljs$core$IFn$_invoke$arity$2 = G__18754__2;
return G__18754;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__18751,seen__$1){
while(true){
var vec__18752 = p__18751;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18752,(0),null);
var xs__$1 = vec__18752;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__18755 = cljs.core.rest(s);
var G__18756 = seen__$1;
p__18751 = G__18755;
seen__$1 = G__18756;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__18757 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__18758 = cljs.core.next(s__$1);
ret = G__18757;
s__$1 = G__18758;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__18760 = x;
if(G__18760){
var bit__4943__auto__ = (G__18760.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4943__auto__) || (G__18760.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__18761 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__18762 = cljs.core.next(ks);
var G__18763 = cljs.core.next(vs);
map = G__18761;
ks = G__18762;
vs = G__18763;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(){
var G__18771 = arguments.length;
switch (G__18771) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__18772 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18772) : k.call(null,G__18772));
})() > (function (){var G__18773 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18773) : k.call(null,G__18773));
})())){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18764_SHARP_,p2__18765_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__18764_SHARP_,p2__18765_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq18766){
var G__18767 = cljs.core.first(seq18766);
var seq18766__$1 = cljs.core.next(seq18766);
var G__18768 = cljs.core.first(seq18766__$1);
var seq18766__$2 = cljs.core.next(seq18766__$1);
var G__18769 = cljs.core.first(seq18766__$2);
var seq18766__$3 = cljs.core.next(seq18766__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__18767,G__18768,G__18769,seq18766__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = 3;
/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(){
var G__18782 = arguments.length;
switch (G__18782) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__18783 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18783) : k.call(null,G__18783));
})() < (function (){var G__18784 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18784) : k.call(null,G__18784));
})())){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18775_SHARP_,p2__18776_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__18775_SHARP_,p2__18776_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq18777){
var G__18778 = cljs.core.first(seq18777);
var seq18777__$1 = cljs.core.next(seq18777);
var G__18779 = cljs.core.first(seq18777__$1);
var seq18777__$2 = cljs.core.next(seq18777__$1);
var G__18780 = cljs.core.first(seq18777__$2);
var seq18777__$3 = cljs.core.next(seq18777__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__18778,G__18779,G__18780,seq18777__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(){
var G__18787 = arguments.length;
switch (G__18787) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__18794 = null;
var G__18794__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18794__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__18788 = result;
var G__18789 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18788,G__18789) : rf.call(null,G__18788,G__18789));
})());
})());
var G__18790 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18790) : rf.call(null,G__18790));
});
var G__18794__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__18791 = result;
var G__18792 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18791,G__18792) : rf.call(null,G__18791,G__18792));
} else {
return result;
}
});
G__18794 = function(result,input){
switch(arguments.length){
case 0:
return G__18794__0.call(this);
case 1:
return G__18794__1.call(this,result);
case 2:
return G__18794__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18794.cljs$core$IFn$_invoke$arity$0 = G__18794__0;
G__18794.cljs$core$IFn$_invoke$arity$1 = G__18794__1;
G__18794.cljs$core$IFn$_invoke$arity$2 = G__18794__2;
return G__18794;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(){
var G__18796 = arguments.length;
switch (G__18796) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__18803 = null;
var G__18803__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18803__1 = (function (result){
var G__18797 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18797) : rf.call(null,G__18797));
});
var G__18803__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__18798 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18798) : pred.call(null,G__18798));
})())){
var G__18799 = result;
var G__18800 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18799,G__18800) : rf.call(null,G__18799,G__18800));
} else {
return cljs.core.reduced(result);
}
});
G__18803 = function(result,input){
switch(arguments.length){
case 0:
return G__18803__0.call(this);
case 1:
return G__18803__1.call(this,result);
case 2:
return G__18803__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18803.cljs$core$IFn$_invoke$arity$0 = G__18803__0;
G__18803.cljs$core$IFn$_invoke$arity$1 = G__18803__1;
G__18803.cljs$core$IFn$_invoke$arity$2 = G__18803__2;
return G__18803;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__18801 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18801) : pred.call(null,G__18801));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__18808 = (function (){var G__18810 = cljs.core._entry_key(sc,e);
var G__18811 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18810,G__18811) : comp.call(null,G__18810,G__18811));
})();
var G__18809 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__18808,G__18809) : test.call(null,G__18808,G__18809));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(){
var G__18813 = arguments.length;
switch (G__18813) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__18814 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18814,(0),null);
var s = vec__18814;
if(cljs.core.truth_((function (){var G__18815 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__18815) : include.call(null,G__18815));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__18816 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18816,(0),null);
var s = vec__18816;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(){
var G__18819 = arguments.length;
switch (G__18819) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__18820 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18820,(0),null);
var s = vec__18820;
if(cljs.core.truth_((function (){var G__18821 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__18821) : include.call(null,G__18821));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__18822 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18822,(0),null);
var s = vec__18822;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__18824 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__18824) : Math.ceil.call(null,G__18824));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__18825 = ret;
var G__18826 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18825,G__18826) : f.call(null,G__18825,G__18826));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__18827 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18827) : cljs.core.deref.call(null,G__18827));
} else {
var G__18828 = (i + self__.step);
var G__18829 = ret__$1;
i = G__18828;
ret = G__18829;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(){
var G__18831 = arguments.length;
switch (G__18831) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(){
var G__18834 = arguments.length;
switch (G__18834) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__18839 = null;
var G__18839__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18839__1 = (function (result){
var G__18835 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18835) : rf.call(null,G__18835));
});
var G__18839__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__18836 = result;
var G__18837 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18836,G__18837) : rf.call(null,G__18836,G__18837));
} else {
return result;
}
});
G__18839 = function(result,input){
switch(arguments.length){
case 0:
return G__18839__0.call(this);
case 1:
return G__18839__1.call(this,result);
case 2:
return G__18839__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18839.cljs$core$IFn$_invoke$arity$0 = G__18839__0;
G__18839.cljs$core$IFn$_invoke$arity$1 = G__18839__1;
G__18839.cljs$core$IFn$_invoke$arity$2 = G__18839__2;
return G__18839;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(){
var G__18842 = arguments.length;
switch (G__18842) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__18853 = null;
var G__18853__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18853__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__18843 = result;
var G__18844 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18843,G__18844) : rf.call(null,G__18843,G__18844));
})());
})());
var G__18845 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18845) : rf.call(null,G__18845));
});
var G__18853__2 = (function (result,input){
var pval = (function (){var G__18846 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18846) : cljs.core.deref.call(null,G__18846));
})();
var val = (function (){var G__18847 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18847) : f.call(null,G__18847));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__18848 = result;
var G__18849 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18848,G__18849) : rf.call(null,G__18848,G__18849));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__18853 = function(result,input){
switch(arguments.length){
case 0:
return G__18853__0.call(this);
case 1:
return G__18853__1.call(this,result);
case 2:
return G__18853__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18853.cljs$core$IFn$_invoke$arity$0 = G__18853__0;
G__18853.cljs$core$IFn$_invoke$arity$1 = G__18853__1;
G__18853.cljs$core$IFn$_invoke$arity$2 = G__18853__2;
return G__18853;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__18850 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18850) : f.call(null,G__18850));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__18840_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__18851 = p1__18840_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18851) : f.call(null,G__18851));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(){
var G__18855 = arguments.length;
switch (G__18855) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__18856 = init;
var G__18857 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18856,G__18857) : f.call(null,G__18856,G__18857));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(){
var G__18874 = arguments.length;
switch (G__18874) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__18918 = null;
var G__18918__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__18918__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18875 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18875) : f.call(null,G__18875));
})()],null));
});
var G__18918__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18876 = x;
var G__18877 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18876,G__18877) : f.call(null,G__18876,G__18877));
})()],null));
});
var G__18918__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18878 = x;
var G__18879 = y;
var G__18880 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18878,G__18879,G__18880) : f.call(null,G__18878,G__18879,G__18880));
})()],null));
});
var G__18918__4 = (function() { 
var G__18919__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__18919 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18920__i = 0, G__18920__a = new Array(arguments.length -  3);
while (G__18920__i < G__18920__a.length) {G__18920__a[G__18920__i] = arguments[G__18920__i + 3]; ++G__18920__i;}
  args = new cljs.core.IndexedSeq(G__18920__a,0);
} 
return G__18919__delegate.call(this,x,y,z,args);};
G__18919.cljs$lang$maxFixedArity = 3;
G__18919.cljs$lang$applyTo = (function (arglist__18921){
var x = cljs.core.first(arglist__18921);
arglist__18921 = cljs.core.next(arglist__18921);
var y = cljs.core.first(arglist__18921);
arglist__18921 = cljs.core.next(arglist__18921);
var z = cljs.core.first(arglist__18921);
var args = cljs.core.rest(arglist__18921);
return G__18919__delegate(x,y,z,args);
});
G__18919.cljs$core$IFn$_invoke$arity$variadic = G__18919__delegate;
return G__18919;
})()
;
G__18918 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__18918__0.call(this);
case 1:
return G__18918__1.call(this,x);
case 2:
return G__18918__2.call(this,x,y);
case 3:
return G__18918__3.call(this,x,y,z);
default:
var G__18922 = null;
if (arguments.length > 3) {
var G__18923__i = 0, G__18923__a = new Array(arguments.length -  3);
while (G__18923__i < G__18923__a.length) {G__18923__a[G__18923__i] = arguments[G__18923__i + 3]; ++G__18923__i;}
G__18922 = new cljs.core.IndexedSeq(G__18923__a,0);
}
return G__18918__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18918.cljs$lang$maxFixedArity = 3;
G__18918.cljs$lang$applyTo = G__18918__4.cljs$lang$applyTo;
G__18918.cljs$core$IFn$_invoke$arity$0 = G__18918__0;
G__18918.cljs$core$IFn$_invoke$arity$1 = G__18918__1;
G__18918.cljs$core$IFn$_invoke$arity$2 = G__18918__2;
G__18918.cljs$core$IFn$_invoke$arity$3 = G__18918__3;
G__18918.cljs$core$IFn$_invoke$arity$variadic = G__18918__4.cljs$core$IFn$_invoke$arity$variadic;
return G__18918;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__18924 = null;
var G__18924__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__18924__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18881 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18881) : f.call(null,G__18881));
})(),(function (){var G__18882 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18882) : g.call(null,G__18882));
})()],null));
});
var G__18924__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18883 = x;
var G__18884 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18883,G__18884) : f.call(null,G__18883,G__18884));
})(),(function (){var G__18885 = x;
var G__18886 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__18885,G__18886) : g.call(null,G__18885,G__18886));
})()],null));
});
var G__18924__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18887 = x;
var G__18888 = y;
var G__18889 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18887,G__18888,G__18889) : f.call(null,G__18887,G__18888,G__18889));
})(),(function (){var G__18890 = x;
var G__18891 = y;
var G__18892 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__18890,G__18891,G__18892) : g.call(null,G__18890,G__18891,G__18892));
})()],null));
});
var G__18924__4 = (function() { 
var G__18925__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__18925 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18926__i = 0, G__18926__a = new Array(arguments.length -  3);
while (G__18926__i < G__18926__a.length) {G__18926__a[G__18926__i] = arguments[G__18926__i + 3]; ++G__18926__i;}
  args = new cljs.core.IndexedSeq(G__18926__a,0);
} 
return G__18925__delegate.call(this,x,y,z,args);};
G__18925.cljs$lang$maxFixedArity = 3;
G__18925.cljs$lang$applyTo = (function (arglist__18927){
var x = cljs.core.first(arglist__18927);
arglist__18927 = cljs.core.next(arglist__18927);
var y = cljs.core.first(arglist__18927);
arglist__18927 = cljs.core.next(arglist__18927);
var z = cljs.core.first(arglist__18927);
var args = cljs.core.rest(arglist__18927);
return G__18925__delegate(x,y,z,args);
});
G__18925.cljs$core$IFn$_invoke$arity$variadic = G__18925__delegate;
return G__18925;
})()
;
G__18924 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__18924__0.call(this);
case 1:
return G__18924__1.call(this,x);
case 2:
return G__18924__2.call(this,x,y);
case 3:
return G__18924__3.call(this,x,y,z);
default:
var G__18928 = null;
if (arguments.length > 3) {
var G__18929__i = 0, G__18929__a = new Array(arguments.length -  3);
while (G__18929__i < G__18929__a.length) {G__18929__a[G__18929__i] = arguments[G__18929__i + 3]; ++G__18929__i;}
G__18928 = new cljs.core.IndexedSeq(G__18929__a,0);
}
return G__18924__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18924.cljs$lang$maxFixedArity = 3;
G__18924.cljs$lang$applyTo = G__18924__4.cljs$lang$applyTo;
G__18924.cljs$core$IFn$_invoke$arity$0 = G__18924__0;
G__18924.cljs$core$IFn$_invoke$arity$1 = G__18924__1;
G__18924.cljs$core$IFn$_invoke$arity$2 = G__18924__2;
G__18924.cljs$core$IFn$_invoke$arity$3 = G__18924__3;
G__18924.cljs$core$IFn$_invoke$arity$variadic = G__18924__4.cljs$core$IFn$_invoke$arity$variadic;
return G__18924;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__18930 = null;
var G__18930__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__18930__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18893 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18893) : f.call(null,G__18893));
})(),(function (){var G__18894 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18894) : g.call(null,G__18894));
})(),(function (){var G__18895 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__18895) : h.call(null,G__18895));
})()],null));
});
var G__18930__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18896 = x;
var G__18897 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18896,G__18897) : f.call(null,G__18896,G__18897));
})(),(function (){var G__18898 = x;
var G__18899 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__18898,G__18899) : g.call(null,G__18898,G__18899));
})(),(function (){var G__18900 = x;
var G__18901 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__18900,G__18901) : h.call(null,G__18900,G__18901));
})()],null));
});
var G__18930__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__18902 = x;
var G__18903 = y;
var G__18904 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18902,G__18903,G__18904) : f.call(null,G__18902,G__18903,G__18904));
})(),(function (){var G__18905 = x;
var G__18906 = y;
var G__18907 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__18905,G__18906,G__18907) : g.call(null,G__18905,G__18906,G__18907));
})(),(function (){var G__18908 = x;
var G__18909 = y;
var G__18910 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__18908,G__18909,G__18910) : h.call(null,G__18908,G__18909,G__18910));
})()],null));
});
var G__18930__4 = (function() { 
var G__18931__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__18931 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18932__i = 0, G__18932__a = new Array(arguments.length -  3);
while (G__18932__i < G__18932__a.length) {G__18932__a[G__18932__i] = arguments[G__18932__i + 3]; ++G__18932__i;}
  args = new cljs.core.IndexedSeq(G__18932__a,0);
} 
return G__18931__delegate.call(this,x,y,z,args);};
G__18931.cljs$lang$maxFixedArity = 3;
G__18931.cljs$lang$applyTo = (function (arglist__18933){
var x = cljs.core.first(arglist__18933);
arglist__18933 = cljs.core.next(arglist__18933);
var y = cljs.core.first(arglist__18933);
arglist__18933 = cljs.core.next(arglist__18933);
var z = cljs.core.first(arglist__18933);
var args = cljs.core.rest(arglist__18933);
return G__18931__delegate(x,y,z,args);
});
G__18931.cljs$core$IFn$_invoke$arity$variadic = G__18931__delegate;
return G__18931;
})()
;
G__18930 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__18930__0.call(this);
case 1:
return G__18930__1.call(this,x);
case 2:
return G__18930__2.call(this,x,y);
case 3:
return G__18930__3.call(this,x,y,z);
default:
var G__18934 = null;
if (arguments.length > 3) {
var G__18935__i = 0, G__18935__a = new Array(arguments.length -  3);
while (G__18935__i < G__18935__a.length) {G__18935__a[G__18935__i] = arguments[G__18935__i + 3]; ++G__18935__i;}
G__18934 = new cljs.core.IndexedSeq(G__18935__a,0);
}
return G__18930__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18930.cljs$lang$maxFixedArity = 3;
G__18930.cljs$lang$applyTo = G__18930__4.cljs$lang$applyTo;
G__18930.cljs$core$IFn$_invoke$arity$0 = G__18930__0;
G__18930.cljs$core$IFn$_invoke$arity$1 = G__18930__1;
G__18930.cljs$core$IFn$_invoke$arity$2 = G__18930__2;
G__18930.cljs$core$IFn$_invoke$arity$3 = G__18930__3;
G__18930.cljs$core$IFn$_invoke$arity$variadic = G__18930__4.cljs$core$IFn$_invoke$arity$variadic;
return G__18930;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__18936 = null;
var G__18936__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__18859_SHARP_,p2__18860_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18859_SHARP_,(function (){return (p2__18860_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__18860_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__18860_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__18936__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__18861_SHARP_,p2__18862_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18861_SHARP_,(function (){var G__18911 = x;
return (p2__18862_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__18862_SHARP_.cljs$core$IFn$_invoke$arity$1(G__18911) : p2__18862_SHARP_.call(null,G__18911));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__18936__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__18863_SHARP_,p2__18864_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18863_SHARP_,(function (){var G__18912 = x;
var G__18913 = y;
return (p2__18864_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__18864_SHARP_.cljs$core$IFn$_invoke$arity$2(G__18912,G__18913) : p2__18864_SHARP_.call(null,G__18912,G__18913));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__18936__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__18865_SHARP_,p2__18866_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18865_SHARP_,(function (){var G__18914 = x;
var G__18915 = y;
var G__18916 = z;
return (p2__18866_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__18866_SHARP_.cljs$core$IFn$_invoke$arity$3(G__18914,G__18915,G__18916) : p2__18866_SHARP_.call(null,G__18914,G__18915,G__18916));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__18936__4 = (function() { 
var G__18937__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__18867_SHARP_,p2__18868_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18867_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__18868_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__18937 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18938__i = 0, G__18938__a = new Array(arguments.length -  3);
while (G__18938__i < G__18938__a.length) {G__18938__a[G__18938__i] = arguments[G__18938__i + 3]; ++G__18938__i;}
  args = new cljs.core.IndexedSeq(G__18938__a,0);
} 
return G__18937__delegate.call(this,x,y,z,args);};
G__18937.cljs$lang$maxFixedArity = 3;
G__18937.cljs$lang$applyTo = (function (arglist__18939){
var x = cljs.core.first(arglist__18939);
arglist__18939 = cljs.core.next(arglist__18939);
var y = cljs.core.first(arglist__18939);
arglist__18939 = cljs.core.next(arglist__18939);
var z = cljs.core.first(arglist__18939);
var args = cljs.core.rest(arglist__18939);
return G__18937__delegate(x,y,z,args);
});
G__18937.cljs$core$IFn$_invoke$arity$variadic = G__18937__delegate;
return G__18937;
})()
;
G__18936 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__18936__0.call(this);
case 1:
return G__18936__1.call(this,x);
case 2:
return G__18936__2.call(this,x,y);
case 3:
return G__18936__3.call(this,x,y,z);
default:
var G__18940 = null;
if (arguments.length > 3) {
var G__18941__i = 0, G__18941__a = new Array(arguments.length -  3);
while (G__18941__i < G__18941__a.length) {G__18941__a[G__18941__i] = arguments[G__18941__i + 3]; ++G__18941__i;}
G__18940 = new cljs.core.IndexedSeq(G__18941__a,0);
}
return G__18936__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18936.cljs$lang$maxFixedArity = 3;
G__18936.cljs$lang$applyTo = G__18936__4.cljs$lang$applyTo;
G__18936.cljs$core$IFn$_invoke$arity$0 = G__18936__0;
G__18936.cljs$core$IFn$_invoke$arity$1 = G__18936__1;
G__18936.cljs$core$IFn$_invoke$arity$2 = G__18936__2;
G__18936.cljs$core$IFn$_invoke$arity$3 = G__18936__3;
G__18936.cljs$core$IFn$_invoke$arity$variadic = G__18936__4.cljs$core$IFn$_invoke$arity$variadic;
return G__18936;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq18869){
var G__18870 = cljs.core.first(seq18869);
var seq18869__$1 = cljs.core.next(seq18869);
var G__18871 = cljs.core.first(seq18869__$1);
var seq18869__$2 = cljs.core.next(seq18869__$1);
var G__18872 = cljs.core.first(seq18869__$2);
var seq18869__$3 = cljs.core.next(seq18869__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__18870,G__18871,G__18872,seq18869__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = 3;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(){
var G__18943 = arguments.length;
switch (G__18943) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__18945 = cljs.core.next(coll);
coll = G__18945;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__18946 = (n - (1));
var G__18947 = cljs.core.next(coll);
n = G__18946;
coll = G__18947;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(){
var G__18949 = arguments.length;
switch (G__18949) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__18954 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18954,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18954,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__4276__auto__ = flags;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_18962 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__4276__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__18963_18969 = cljs.core.first(coll);
var G__18964_18970 = writer;
var G__18965_18971 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__18963_18969,G__18964_18970,G__18965_18971) : print_one.call(null,G__18963_18969,G__18964_18970,G__18965_18971));
} else {
}

var coll_18972__$1 = cljs.core.next(coll);
var n_18973 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_18972__$1) && (((n_18973 == null)) || (!((n_18973 === (0)))))){
cljs.core._write(writer,sep);

var G__18966_18974 = cljs.core.first(coll_18972__$1);
var G__18967_18975 = writer;
var G__18968_18976 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__18966_18974,G__18967_18975,G__18968_18976) : print_one.call(null,G__18966_18974,G__18967_18975,G__18968_18976));

var G__18977 = cljs.core.next(coll_18972__$1);
var G__18978 = (n_18973 - (1));
coll_18972__$1 = G__18977;
n_18973 = G__18978;
continue;
} else {
if((cljs.core.seq(coll_18972__$1)) && ((n_18973 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__4276__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_18962;
}});
cljs.core.write_all = (function cljs$core$write_all(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__18981 = cljs.core.seq(ss);
var chunk__18982 = null;
var count__18983 = (0);
var i__18984 = (0);
while(true){
if((i__18984 < count__18983)){
var s = chunk__18982.cljs$core$IIndexed$_nth$arity$2(null,i__18984);
cljs.core._write(writer,s);

var G__18985 = seq__18981;
var G__18986 = chunk__18982;
var G__18987 = count__18983;
var G__18988 = (i__18984 + (1));
seq__18981 = G__18985;
chunk__18982 = G__18986;
count__18983 = G__18987;
i__18984 = G__18988;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__18981);
if(temp__4126__auto__){
var seq__18981__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18981__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__18981__$1);
var G__18989 = cljs.core.chunk_rest(seq__18981__$1);
var G__18990 = c__5061__auto__;
var G__18991 = cljs.core.count(c__5061__auto__);
var G__18992 = (0);
seq__18981 = G__18989;
chunk__18982 = G__18990;
count__18983 = G__18991;
i__18984 = G__18992;
continue;
} else {
var s = cljs.core.first(seq__18981__$1);
cljs.core._write(writer,s);

var G__18993 = cljs.core.next(seq__18981__$1);
var G__18994 = null;
var G__18995 = (0);
var G__18996 = (0);
seq__18981 = G__18993;
chunk__18982 = G__18994;
count__18983 = G__18995;
i__18984 = G__18996;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.write_all.cljs$lang$maxFixedArity = (1);

cljs.core.write_all.cljs$lang$applyTo = (function (seq18979){
var G__18980 = cljs.core.first(seq18979);
var seq18979__$1 = cljs.core.next(seq18979);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(G__18980,seq18979__$1);
});
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj18998 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj18998;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__19001 = "[\\\\\"\b\f\n\r\t]";
var G__19002 = "g";
return RegExp(G__19001,G__19002);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (function (){var G__19016 = obj;
if(G__19016){
var bit__4950__auto__ = (G__19016.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4950__auto__) || (G__19016.cljs$core$IMeta$)){
return true;
} else {
if((!G__19016.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__19016);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__19016);
}
})();
if(and__4264__auto____$1){
return cljs.core.meta(obj);
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__19017_19027 = cljs.core.meta(obj);
var G__19018_19028 = writer;
var G__19019_19029 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__19017_19027,G__19018_19028,G__19019_19029) : cljs.core.pr_writer.call(null,G__19017_19027,G__19018_19028,G__19019_19029));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__19020 = obj;
if(G__19020){
var bit__4943__auto__ = (G__19020.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4943__auto__) || (G__19020.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__19021 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__19022 = cljs.core.pr_writer;
var G__19023 = writer;
var G__19024 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__19021,G__19022,G__19023,G__19024) : cljs.core.print_map.call(null,G__19021,G__19022,G__19023,G__19024));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__19025 = obj;
return goog.isString(G__19025);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__19030 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__19030;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.truth_(cljs.core.regexp_QMARK_(obj))){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__19026 = obj;
if(G__19026){
var bit__4950__auto__ = (G__19026.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4950__auto__) || (G__19026.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__19026.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__19026);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__19026);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4124__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4124__auto__)){
var alt_impl = temp__4124__auto__;
var G__19034 = obj;
var G__19035 = writer;
var G__19036 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__19034,G__19035,G__19036) : alt_impl.call(null,G__19034,G__19035,G__19036));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__19041 = cljs.core.seq(cljs.core.next(objs));
var chunk__19042 = null;
var count__19043 = (0);
var i__19044 = (0);
while(true){
if((i__19044 < count__19043)){
var obj = chunk__19042.cljs$core$IIndexed$_nth$arity$2(null,i__19044);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__19045 = seq__19041;
var G__19046 = chunk__19042;
var G__19047 = count__19043;
var G__19048 = (i__19044 + (1));
seq__19041 = G__19045;
chunk__19042 = G__19046;
count__19043 = G__19047;
i__19044 = G__19048;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__19041);
if(temp__4126__auto__){
var seq__19041__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19041__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__19041__$1);
var G__19049 = cljs.core.chunk_rest(seq__19041__$1);
var G__19050 = c__5061__auto__;
var G__19051 = cljs.core.count(c__5061__auto__);
var G__19052 = (0);
seq__19041 = G__19049;
chunk__19042 = G__19050;
count__19043 = G__19051;
i__19044 = G__19052;
continue;
} else {
var obj = cljs.core.first(seq__19041__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__19053 = cljs.core.next(seq__19041__$1);
var G__19054 = null;
var G__19055 = (0);
var G__19056 = (0);
seq__19041 = G__19053;
chunk__19042 = G__19054;
count__19043 = G__19055;
i__19044 = G__19056;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 */
cljs.core.pr_str = (function cljs$core$pr_str(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr_str.cljs$lang$maxFixedArity = (0);

cljs.core.pr_str.cljs$lang$applyTo = (function (seq19057){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19057));
});
/**
 * Same as pr-str followed by (newline)
 */
cljs.core.prn_str = (function cljs$core$prn_str(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.prn_str.cljs$lang$maxFixedArity = (0);

cljs.core.prn_str.cljs$lang$applyTo = (function (seq19058){
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19058));
});
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 */
cljs.core.pr = (function cljs$core$pr(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr.cljs$lang$maxFixedArity = (0);

cljs.core.pr.cljs$lang$applyTo = (function (seq19059){
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19059));
});
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__19060__i = 0, G__19060__a = new Array(arguments.length -  0);
while (G__19060__i < G__19060__a.length) {G__19060__a[G__19060__i] = arguments[G__19060__i + 0]; ++G__19060__i;}
  objs = new cljs.core.IndexedSeq(G__19060__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__19061){
var objs = cljs.core.seq(arglist__19061);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 */
cljs.core.print_str = (function cljs$core$print_str(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.print_str.cljs$lang$maxFixedArity = (0);

cljs.core.print_str.cljs$lang$applyTo = (function (seq19062){
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19062));
});
/**
 * Same as print followed by (newline)
 */
cljs.core.println = (function cljs$core$println(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.println.cljs$lang$maxFixedArity = (0);

cljs.core.println.cljs$lang$applyTo = (function (seq19063){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19063));
});
/**
 * println to a string, returning it
 */
cljs.core.println_str = (function cljs$core$println_str(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.println_str.cljs$lang$maxFixedArity = (0);

cljs.core.println_str.cljs$lang$applyTo = (function (seq19064){
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19064));
});
/**
 * Same as pr followed by (newline).
 */
cljs.core.prn = (function cljs$core$prn(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.prn.cljs$lang$maxFixedArity = (0);

cljs.core.prn.cljs$lang$applyTo = (function (seq19065){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19065));
});
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__19072_19078 = cljs.core.key(e);
var G__19073_19079 = w;
var G__19074_19080 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19072_19078,G__19073_19079,G__19074_19080) : print_one.call(null,G__19072_19078,G__19073_19079,G__19074_19080));

cljs.core._write(w," ");

var G__19075 = cljs.core.val(e);
var G__19076 = w;
var G__19077 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19075,G__19076,G__19077) : print_one.call(null,G__19075,G__19076,G__19077));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 */
cljs.core.alter_meta_BANG_ = (function cljs$core$alter_meta_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
});

cljs.core.alter_meta_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.alter_meta_BANG_.cljs$lang$applyTo = (function (seq19081){
var G__19082 = cljs.core.first(seq19081);
var seq19081__$1 = cljs.core.next(seq19081);
var G__19083 = cljs.core.first(seq19081__$1);
var seq19081__$2 = cljs.core.next(seq19081__$1);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19082,G__19083,seq19081__$2);
});
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function cljs$core$gensym(){
var G__19085 = arguments.length;
switch (G__19085) {
case 0:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("G__");
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__19086 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19086) : cljs.core.atom.call(null,G__19086));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});

cljs.core.gensym.cljs$lang$maxFixedArity = 1;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__19089 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19089) : cljs.core.deref.call(null,G__19089));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a promise, delay, future or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__19090_SHARP_,p2__19091_SHARP_){
var ret = (function (){var G__19094 = p1__19090_SHARP_;
var G__19095 = p2__19091_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__19094,G__19095) : rf.call(null,G__19094,G__19095));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__19098 = null;
var G__19098__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19098__1 = (function (result){
var G__19097 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__19097) : rf.call(null,G__19097));
});
var G__19098__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__19098 = function(result,input){
switch(arguments.length){
case 0:
return G__19098__0.call(this);
case 1:
return G__19098__1.call(this,result);
case 2:
return G__19098__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19098.cljs$core$IFn$_invoke$arity$0 = G__19098__0;
G__19098.cljs$core$IFn$_invoke$arity$1 = G__19098__1;
G__19098.cljs$core$IFn$_invoke$arity$2 = G__19098__2;
return G__19098;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function cljs$core$dedupe(){
var G__19100 = arguments.length;
switch (G__19100) {
case 0:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__19106 = null;
var G__19106__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19106__1 = (function (result){
var G__19101 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__19101) : rf.call(null,G__19101));
});
var G__19106__2 = (function (result,input){
var prior = (function (){var G__19102 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19102) : cljs.core.deref.call(null,G__19102));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__19103 = result;
var G__19104 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__19103,G__19104) : rf.call(null,G__19103,G__19104));
}
});
G__19106 = function(result,input){
switch(arguments.length){
case 0:
return G__19106__0.call(this);
case 1:
return G__19106__1.call(this,result);
case 2:
return G__19106__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19106.cljs$core$IFn$_invoke$arity$0 = G__19106__0;
G__19106.cljs$core$IFn$_invoke$arity$1 = G__19106__1;
G__19106.cljs$core$IFn$_invoke$arity$2 = G__19106__2;
return G__19106;
})()
;})(pa))
});
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});

cljs.core.dedupe.cljs$lang$maxFixedArity = 1;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function cljs$core$random_sample(){
var G__19108 = arguments.length;
switch (G__19108) {
case 1:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});

cljs.core.random_sample.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5252__auto__ = this;
return cljs.core.es6_iterator(this__5252__auto__);
}));
/**
 * Returns a reducible/iterable/seqable application of
 * the transducer to the items in coll. Note that these applications
 * will be performed every time iterator/seq/reduce is called.
 */
cljs.core.eduction = (function cljs$core$eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__19111_SHARP_,p2__19110_SHARP_){
var G__19113 = p2__19110_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__19113) : proc.call(null,G__19113));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj19115 = {};
return obj19115;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._clj__GT_js[(function (){var G__19119 = x__4912__auto__;
return goog.typeOf(G__19119);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._key__GT_js[(function (){var G__19123 = x__4912__auto__;
return goog.typeOf(G__19123);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__19126 = k;
if(G__19126){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__19126.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__19126.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__19126);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__19126);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__19127 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__19127) : cljs.core.clj__GT_js.call(null,G__19127));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__19143 = x;
if(G__19143){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__19143.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__19143.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__19143);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__19143);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj19145 = {};
return obj19145;
})();
var seq__19146_19156 = cljs.core.seq(x);
var chunk__19147_19157 = null;
var count__19148_19158 = (0);
var i__19149_19159 = (0);
while(true){
if((i__19149_19159 < count__19148_19158)){
var vec__19150_19160 = chunk__19147_19157.cljs$core$IIndexed$_nth$arity$2(null,i__19149_19159);
var k_19161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19150_19160,(0),null);
var v_19162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19150_19160,(1),null);
(m[cljs.core.key__GT_js(k_19161)] = cljs$core$clj__GT_js(v_19162));

var G__19163 = seq__19146_19156;
var G__19164 = chunk__19147_19157;
var G__19165 = count__19148_19158;
var G__19166 = (i__19149_19159 + (1));
seq__19146_19156 = G__19163;
chunk__19147_19157 = G__19164;
count__19148_19158 = G__19165;
i__19149_19159 = G__19166;
continue;
} else {
var temp__4126__auto___19167 = cljs.core.seq(seq__19146_19156);
if(temp__4126__auto___19167){
var seq__19146_19168__$1 = temp__4126__auto___19167;
if(cljs.core.chunked_seq_QMARK_(seq__19146_19168__$1)){
var c__5061__auto___19169 = cljs.core.chunk_first(seq__19146_19168__$1);
var G__19170 = cljs.core.chunk_rest(seq__19146_19168__$1);
var G__19171 = c__5061__auto___19169;
var G__19172 = cljs.core.count(c__5061__auto___19169);
var G__19173 = (0);
seq__19146_19156 = G__19170;
chunk__19147_19157 = G__19171;
count__19148_19158 = G__19172;
i__19149_19159 = G__19173;
continue;
} else {
var vec__19151_19174 = cljs.core.first(seq__19146_19168__$1);
var k_19175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19151_19174,(0),null);
var v_19176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19151_19174,(1),null);
(m[cljs.core.key__GT_js(k_19175)] = cljs$core$clj__GT_js(v_19176));

var G__19177 = cljs.core.next(seq__19146_19168__$1);
var G__19178 = null;
var G__19179 = (0);
var G__19180 = (0);
seq__19146_19156 = G__19177;
chunk__19147_19157 = G__19178;
count__19148_19158 = G__19179;
i__19149_19159 = G__19180;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__19152_19181 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__19153_19182 = null;
var count__19154_19183 = (0);
var i__19155_19184 = (0);
while(true){
if((i__19155_19184 < count__19154_19183)){
var x_19185__$1 = chunk__19153_19182.cljs$core$IIndexed$_nth$arity$2(null,i__19155_19184);
arr.push(x_19185__$1);

var G__19186 = seq__19152_19181;
var G__19187 = chunk__19153_19182;
var G__19188 = count__19154_19183;
var G__19189 = (i__19155_19184 + (1));
seq__19152_19181 = G__19186;
chunk__19153_19182 = G__19187;
count__19154_19183 = G__19188;
i__19155_19184 = G__19189;
continue;
} else {
var temp__4126__auto___19190 = cljs.core.seq(seq__19152_19181);
if(temp__4126__auto___19190){
var seq__19152_19191__$1 = temp__4126__auto___19190;
if(cljs.core.chunked_seq_QMARK_(seq__19152_19191__$1)){
var c__5061__auto___19192 = cljs.core.chunk_first(seq__19152_19191__$1);
var G__19193 = cljs.core.chunk_rest(seq__19152_19191__$1);
var G__19194 = c__5061__auto___19192;
var G__19195 = cljs.core.count(c__5061__auto___19192);
var G__19196 = (0);
seq__19152_19181 = G__19193;
chunk__19153_19182 = G__19194;
count__19154_19183 = G__19195;
i__19155_19184 = G__19196;
continue;
} else {
var x_19197__$1 = cljs.core.first(seq__19152_19191__$1);
arr.push(x_19197__$1);

var G__19198 = cljs.core.next(seq__19152_19191__$1);
var G__19199 = null;
var G__19200 = (0);
var G__19201 = (0);
seq__19152_19181 = G__19198;
chunk__19153_19182 = G__19199;
count__19154_19183 = G__19200;
i__19155_19184 = G__19201;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj19203 = {};
return obj19203;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__4264__auto__ = x;
if(and__4264__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__4264__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4912__auto__ = (((x == null))?null:x);
return (function (){var or__4276__auto__ = (cljs.core._js__GT_clj[(function (){var G__19207 = x__4912__auto__;
return goog.typeOf(G__19207);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 */
cljs.core.js__GT_clj = (function cljs$core$js__GT_clj(){
var G__19211 = arguments.length;
switch (G__19211) {
case 1:
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5328__auto__);

}
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1 = (function (x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = (function (x,opts){
var map__19212 = opts;
var map__19212__$1 = ((cljs.core.seq_QMARK_(map__19212))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19212):map__19212);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19212__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__19212,map__19212__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn(x__$1){
if((function (){var G__19228 = x__$1;
if(G__19228){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__19228.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__19228.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__19228);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__19228);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5030__auto__ = ((function (map__19212,map__19212__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn_$_iter__19229(s__19230){
return (new cljs.core.LazySeq(null,((function (map__19212,map__19212__$1,keywordize_keys,keyfn){
return (function (){
var s__19230__$1 = s__19230;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__19230__$1);
if(temp__4126__auto__){
var s__19230__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19230__$2)){
var c__5028__auto__ = cljs.core.chunk_first(s__19230__$2);
var size__5029__auto__ = cljs.core.count(c__5028__auto__);
var b__19232 = cljs.core.chunk_buffer(size__5029__auto__);
if((function (){var i__19231 = (0);
while(true){
if((i__19231 < size__5029__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5028__auto__,i__19231);
cljs.core.chunk_append(b__19232,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__19237 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__19237) : keyfn.call(null,G__19237));
})(),cljs$core$thisfn((x__$1[k]))], null));

var G__19240 = (i__19231 + (1));
i__19231 = G__19240;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19232),cljs$core$thisfn_$_iter__19229(cljs.core.chunk_rest(s__19230__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19232),null);
}
} else {
var k = cljs.core.first(s__19230__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__19238 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__19238) : keyfn.call(null,G__19238));
})(),cljs$core$thisfn((x__$1[k]))], null),cljs$core$thisfn_$_iter__19229(cljs.core.rest(s__19230__$2)));
}
} else {
return null;
}
break;
}
});})(map__19212,map__19212__$1,keywordize_keys,keyfn))
,null,null));
});})(map__19212,map__19212__$1,keywordize_keys,keyfn))
;
return iter__5030__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__19212,map__19212__$1,keywordize_keys,keyfn))
;
return f(x);
});

cljs.core.js__GT_clj.cljs$lang$applyTo = (function (seq19208){
var G__19209 = cljs.core.first(seq19208);
var seq19208__$1 = cljs.core.next(seq19208);
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(G__19209,seq19208__$1);
});

cljs.core.js__GT_clj.cljs$lang$maxFixedArity = 1;
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__19243 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19243) : cljs.core.atom.call(null,G__19243));
})();
return ((function (mem){
return (function() { 
var G__19245__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__19244 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19244) : cljs.core.deref.call(null,G__19244));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__19245 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19246__i = 0, G__19246__a = new Array(arguments.length -  0);
while (G__19246__i < G__19246__a.length) {G__19246__a[G__19246__i] = arguments[G__19246__i + 0]; ++G__19246__i;}
  args = new cljs.core.IndexedSeq(G__19246__a,0);
} 
return G__19245__delegate.call(this,args);};
G__19245.cljs$lang$maxFixedArity = 0;
G__19245.cljs$lang$applyTo = (function (arglist__19247){
var args = cljs.core.seq(arglist__19247);
return G__19245__delegate(args);
});
G__19245.cljs$core$IFn$_invoke$arity$variadic = G__19245__delegate;
return G__19245;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 */
cljs.core.trampoline = (function cljs$core$trampoline(){
var G__19251 = arguments.length;
switch (G__19251) {
case 1:
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5328__auto__);

}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__19253 = ret;
f = G__19253;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
});

cljs.core.trampoline.cljs$lang$applyTo = (function (seq19248){
var G__19249 = cljs.core.first(seq19248);
var seq19248__$1 = cljs.core.next(seq19248);
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic(G__19249,seq19248__$1);
});

cljs.core.trampoline.cljs$lang$maxFixedArity = 1;
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function cljs$core$rand(){
var G__19255 = arguments.length;
switch (G__19255) {
case 0:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((1));
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});

cljs.core.rand.cljs$lang$maxFixedArity = 1;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__19258 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__19258) : Math.floor.call(null,G__19258));
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__19260 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__19260) : f.call(null,G__19260));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__19262 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19262) : cljs.core.atom.call(null,G__19262));
})();
} else {
}

return cljs.core._global_hierarchy;
});
cljs.core.swap_global_hierarchy_BANG_ = (function cljs$core$swap_global_hierarchy_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (seq19263){
var G__19264 = cljs.core.first(seq19263);
var seq19263__$1 = cljs.core.next(seq19263);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19264,seq19263__$1);
});
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function cljs$core$isa_QMARK_(){
var G__19266 = arguments.length;
switch (G__19266) {
case 2:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (child,parent){
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__19267 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19267) : cljs.core.deref.call(null,G__19267));
})(),child,parent);
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (h,child,parent){
var or__4276__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
var and__4264__auto__ = cljs.core.vector_QMARK_(parent);
if(and__4264__auto__){
var and__4264__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__4264__auto____$1){
var and__4264__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__4264__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__19293 = cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__19290 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__19290) : child.call(null,G__19290));
})(),(function (){var G__19291 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__19291) : parent.call(null,G__19291));
})());
var G__19294 = (i + (1));
ret = G__19293;
i = G__19294;
continue;
}
break;
}
} else {
return and__4264__auto____$2;
}
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
}
}
});

cljs.core.isa_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function cljs$core$parents(){
var G__19296 = arguments.length;
switch (G__19296) {
case 1:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((function (){var G__19297 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19297) : cljs.core.deref.call(null,G__19297));
})(),tag);
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.parents.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function cljs$core$ancestors(){
var G__19300 = arguments.length;
switch (G__19300) {
case 1:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__19301 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19301) : cljs.core.deref.call(null,G__19301));
})(),tag);
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.ancestors.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function cljs$core$descendants(){
var G__19304 = arguments.length;
switch (G__19304) {
case 1:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__19305 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19305) : cljs.core.deref.call(null,G__19305));
})(),tag);
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.descendants.cljs$lang$maxFixedArity = 2;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function cljs$core$derive(){
var G__19308 = arguments.length;
switch (G__19308) {
case 2:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.derive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__19309 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__19309) : targets.call(null,G__19309));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__19310 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__19310) : sources.call(null,G__19310));
})()));
});})(tp,td,ta))
;
var or__4276__auto__ = ((cljs.core.contains_QMARK_((function (){var G__19314 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__19314) : tp.call(null,G__19314));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__19315 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__19315) : ta.call(null,G__19315));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__19316 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__19316) : ta.call(null,G__19316));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return h;
}
});

cljs.core.derive.cljs$lang$maxFixedArity = 3;
/**
 * Removes a parent/child relationship between parent and
 * tag. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.underive = (function cljs$core$underive(){
var G__19322 = arguments.length;
switch (G__19322) {
case 2:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.underive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__19323 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__19323) : parentMap.call(null,G__19323));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__19324 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__19324) : parentMap.call(null,G__19324));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__19318_SHARP_){
return cljs.core.cons(cljs.core.first(p1__19318_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__19318_SHARP_),cljs.core.second(p1__19318_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__19325 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__19325) : parentMap.call(null,G__19325));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__19319_SHARP_,p2__19320_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__19319_SHARP_,p2__19320_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});

cljs.core.underive.cljs$lang$maxFixedArity = 3;
cljs.core.reset_cache = (function cljs$core$reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__19329 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19329) : cljs.core.deref.call(null,G__19329));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__19330 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19330) : cljs.core.deref.call(null,G__19330));
}));
});
cljs.core.prefers_STAR_ = (function cljs$core$prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__19346 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19346) : cljs.core.deref.call(null,G__19346));
})().call(null,x);
var or__4276__auto__ = (cljs.core.truth_((function (){var and__4264__auto__ = xprefs;
if(cljs.core.truth_(and__4264__auto__)){
var G__19348 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__19348) : xprefs.call(null,G__19348));
} else {
return and__4264__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__19349 = cljs.core.rest(ps);
ps = G__19349;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__4276__auto____$1)){
return or__4276__auto____$1;
} else {
var or__4276__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__19350 = cljs.core.rest(ps);
ps = G__19350;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__4276__auto____$2)){
return or__4276__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function cljs$core$dominates(x,y,prefer_table){
var or__4276__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__19364){
var vec__19365 = p__19364;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19365,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19365,(1),null);
var e = vec__19365;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__19366 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19366) : cljs.core.deref.call(null,G__19366));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__4276__auto__ = (be == null);
if(or__4276__auto__){
return or__4276__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__19367 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19367) : cljs.core.deref.call(null,G__19367));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__19368 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19368) : cljs.core.deref.call(null,G__19368));
})(),(function (){var G__19369 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19369) : cljs.core.deref.call(null,G__19369));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj19371 = {};
return obj19371;
})();

cljs.core._reset = (function cljs$core$_reset(mf){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._reset[(function (){var G__19375 = x__4912__auto__;
return goog.typeOf(G__19375);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._reset["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function cljs$core$_add_method(mf,dispatch_val,method){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._add_method[(function (){var G__19379 = x__4912__auto__;
return goog.typeOf(G__19379);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._add_method["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function cljs$core$_remove_method(mf,dispatch_val){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._remove_method[(function (){var G__19383 = x__4912__auto__;
return goog.typeOf(G__19383);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._remove_method["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function cljs$core$_prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._prefer_method[(function (){var G__19387 = x__4912__auto__;
return goog.typeOf(G__19387);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function cljs$core$_get_method(mf,dispatch_val){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._get_method[(function (){var G__19391 = x__4912__auto__;
return goog.typeOf(G__19391);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._get_method["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function cljs$core$_methods(mf){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._methods[(function (){var G__19395 = x__4912__auto__;
return goog.typeOf(G__19395);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._methods["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function cljs$core$_prefers(mf){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._prefers[(function (){var G__19399 = x__4912__auto__;
return goog.typeOf(G__19399);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._prefers["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core._default_dispatch_val = (function cljs$core$_default_dispatch_val(mf){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1(mf);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._default_dispatch_val[(function (){var G__19403 = x__4912__auto__;
return goog.typeOf(G__19403);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._default_dispatch_val["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-default-dispatch-val",mf);
}
}
})().call(null,mf);
}
});

cljs.core._dispatch_fn = (function cljs$core$_dispatch_fn(mf){
if((function (){var and__4264__auto__ = mf;
if(and__4264__auto__){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1;
} else {
return and__4264__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1(mf);
} else {
var x__4912__auto__ = (((mf == null))?null:mf);
return (function (){var or__4276__auto__ = (cljs.core._dispatch_fn[(function (){var G__19407 = x__4912__auto__;
return goog.typeOf(G__19407);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core._dispatch_fn["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-dispatch-fn",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function cljs$core$throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__19409 = this$__$1;
return goog.getUid(G__19409);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_name$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._name(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$INamed$_namespace$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._namespace(self__.name);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = (function (mf,dispatch_val_x,dispatch_val_y){
var self__ = this;
var mf__$1 = this;
if(cljs.core.truth_(cljs.core.prefers_STAR_(dispatch_val_x,dispatch_val_y,self__.prefer_table))){
throw (new Error([cljs.core.str("Preference conflict in multimethod '"),cljs.core.str(self__.name),cljs.core.str("': "),cljs.core.str(dispatch_val_y),cljs.core.str(" is already preferred to "),cljs.core.str(dispatch_val_x)].join('')));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (old){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(old,dispatch_val_x,cljs.core.PersistentHashSet.EMPTY),dispatch_val_y));
});})(mf__$1))
);

return cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_default_dispatch_val$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
return self__.default_dispatch_val;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.method_table,cljs.core.dissoc,dispatch_val);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__19410 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19410) : cljs.core.deref.call(null,G__19410));
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
var G__19411 = self__.prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19411) : cljs.core.deref.call(null,G__19411));
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch_fn$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
return self__.dispatch_fn;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = (function (mf,dispatch_val,method){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.method_table,cljs.core.assoc,dispatch_val,method);

cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = (function (mf){
var self__ = this;
var mf__$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.method_cache,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.prefer_table,((function (mf__$1){
return (function (mf__$2){
return cljs.core.PersistentArrayMap.EMPTY;
});})(mf__$1))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.cached_hierarchy,((function (mf__$1){
return (function (mf__$2){
return null;
});})(mf__$1))
);

return mf__$1;
});

cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = (function (mf,dispatch_val){
var self__ = this;
var mf__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__19412 = self__.cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19412) : cljs.core.deref.call(null,G__19412));
})(),(function (){var G__19413 = self__.hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19413) : cljs.core.deref.call(null,G__19413));
})())){
} else {
cljs.core.reset_cache(self__.method_cache,self__.method_table,self__.cached_hierarchy,self__.hierarchy);
}

var temp__4124__auto__ = (function (){var G__19414 = self__.method_cache;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19414) : cljs.core.deref.call(null,G__19414));
})().call(null,dispatch_val);
if(cljs.core.truth_(temp__4124__auto__)){
var target_fn = temp__4124__auto__;
return target_fn;
} else {
var temp__4124__auto____$1 = cljs.core.find_and_cache_best_method(self__.name,dispatch_val,self__.hierarchy,self__.method_table,self__.prefer_table,self__.method_cache,self__.cached_hierarchy);
if(cljs.core.truth_(temp__4124__auto____$1)){
var target_fn = temp__4124__auto____$1;
return target_fn;
} else {
return (function (){var G__19415 = self__.method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__19415) : cljs.core.deref.call(null,G__19415));
})().call(null,self__.default_dispatch_val);
}
}
});

cljs.core.MultiFn.prototype.call = (function() {
var G__20256 = null;
var G__20256__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__20256__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19416 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__19416) : self__.dispatch_fn.call(null,G__19416));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19417 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__19417) : target_fn.call(null,G__19417));
});
var G__20256__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19418 = a;
var G__19419 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__19418,G__19419) : self__.dispatch_fn.call(null,G__19418,G__19419));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19420 = a;
var G__19421 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__19420,G__19421) : target_fn.call(null,G__19420,G__19421));
});
var G__20256__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19422 = a;
var G__19423 = b;
var G__19424 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__19422,G__19423,G__19424) : self__.dispatch_fn.call(null,G__19422,G__19423,G__19424));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19425 = a;
var G__19426 = b;
var G__19427 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__19425,G__19426,G__19427) : target_fn.call(null,G__19425,G__19426,G__19427));
});
var G__20256__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19428 = a;
var G__19429 = b;
var G__19430 = c;
var G__19431 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__19428,G__19429,G__19430,G__19431) : self__.dispatch_fn.call(null,G__19428,G__19429,G__19430,G__19431));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19432 = a;
var G__19433 = b;
var G__19434 = c;
var G__19435 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__19432,G__19433,G__19434,G__19435) : target_fn.call(null,G__19432,G__19433,G__19434,G__19435));
});
var G__20256__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19436 = a;
var G__19437 = b;
var G__19438 = c;
var G__19439 = d;
var G__19440 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__19436,G__19437,G__19438,G__19439,G__19440) : self__.dispatch_fn.call(null,G__19436,G__19437,G__19438,G__19439,G__19440));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19441 = a;
var G__19442 = b;
var G__19443 = c;
var G__19444 = d;
var G__19445 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__19441,G__19442,G__19443,G__19444,G__19445) : target_fn.call(null,G__19441,G__19442,G__19443,G__19444,G__19445));
});
var G__20256__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19446 = a;
var G__19447 = b;
var G__19448 = c;
var G__19449 = d;
var G__19450 = e;
var G__19451 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__19446,G__19447,G__19448,G__19449,G__19450,G__19451) : self__.dispatch_fn.call(null,G__19446,G__19447,G__19448,G__19449,G__19450,G__19451));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19452 = a;
var G__19453 = b;
var G__19454 = c;
var G__19455 = d;
var G__19456 = e;
var G__19457 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__19452,G__19453,G__19454,G__19455,G__19456,G__19457) : target_fn.call(null,G__19452,G__19453,G__19454,G__19455,G__19456,G__19457));
});
var G__20256__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19458 = a;
var G__19459 = b;
var G__19460 = c;
var G__19461 = d;
var G__19462 = e;
var G__19463 = f;
var G__19464 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__19458,G__19459,G__19460,G__19461,G__19462,G__19463,G__19464) : self__.dispatch_fn.call(null,G__19458,G__19459,G__19460,G__19461,G__19462,G__19463,G__19464));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19465 = a;
var G__19466 = b;
var G__19467 = c;
var G__19468 = d;
var G__19469 = e;
var G__19470 = f;
var G__19471 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__19465,G__19466,G__19467,G__19468,G__19469,G__19470,G__19471) : target_fn.call(null,G__19465,G__19466,G__19467,G__19468,G__19469,G__19470,G__19471));
});
var G__20256__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19472 = a;
var G__19473 = b;
var G__19474 = c;
var G__19475 = d;
var G__19476 = e;
var G__19477 = f;
var G__19478 = g;
var G__19479 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__19472,G__19473,G__19474,G__19475,G__19476,G__19477,G__19478,G__19479) : self__.dispatch_fn.call(null,G__19472,G__19473,G__19474,G__19475,G__19476,G__19477,G__19478,G__19479));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19480 = a;
var G__19481 = b;
var G__19482 = c;
var G__19483 = d;
var G__19484 = e;
var G__19485 = f;
var G__19486 = g;
var G__19487 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__19480,G__19481,G__19482,G__19483,G__19484,G__19485,G__19486,G__19487) : target_fn.call(null,G__19480,G__19481,G__19482,G__19483,G__19484,G__19485,G__19486,G__19487));
});
var G__20256__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19488 = a;
var G__19489 = b;
var G__19490 = c;
var G__19491 = d;
var G__19492 = e;
var G__19493 = f;
var G__19494 = g;
var G__19495 = h;
var G__19496 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__19488,G__19489,G__19490,G__19491,G__19492,G__19493,G__19494,G__19495,G__19496) : self__.dispatch_fn.call(null,G__19488,G__19489,G__19490,G__19491,G__19492,G__19493,G__19494,G__19495,G__19496));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19497 = a;
var G__19498 = b;
var G__19499 = c;
var G__19500 = d;
var G__19501 = e;
var G__19502 = f;
var G__19503 = g;
var G__19504 = h;
var G__19505 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__19497,G__19498,G__19499,G__19500,G__19501,G__19502,G__19503,G__19504,G__19505) : target_fn.call(null,G__19497,G__19498,G__19499,G__19500,G__19501,G__19502,G__19503,G__19504,G__19505));
});
var G__20256__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19506 = a;
var G__19507 = b;
var G__19508 = c;
var G__19509 = d;
var G__19510 = e;
var G__19511 = f;
var G__19512 = g;
var G__19513 = h;
var G__19514 = i;
var G__19515 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__19506,G__19507,G__19508,G__19509,G__19510,G__19511,G__19512,G__19513,G__19514,G__19515) : self__.dispatch_fn.call(null,G__19506,G__19507,G__19508,G__19509,G__19510,G__19511,G__19512,G__19513,G__19514,G__19515));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19516 = a;
var G__19517 = b;
var G__19518 = c;
var G__19519 = d;
var G__19520 = e;
var G__19521 = f;
var G__19522 = g;
var G__19523 = h;
var G__19524 = i;
var G__19525 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__19516,G__19517,G__19518,G__19519,G__19520,G__19521,G__19522,G__19523,G__19524,G__19525) : target_fn.call(null,G__19516,G__19517,G__19518,G__19519,G__19520,G__19521,G__19522,G__19523,G__19524,G__19525));
});
var G__20256__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19526 = a;
var G__19527 = b;
var G__19528 = c;
var G__19529 = d;
var G__19530 = e;
var G__19531 = f;
var G__19532 = g;
var G__19533 = h;
var G__19534 = i;
var G__19535 = j;
var G__19536 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__19526,G__19527,G__19528,G__19529,G__19530,G__19531,G__19532,G__19533,G__19534,G__19535,G__19536) : self__.dispatch_fn.call(null,G__19526,G__19527,G__19528,G__19529,G__19530,G__19531,G__19532,G__19533,G__19534,G__19535,G__19536));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19537 = a;
var G__19538 = b;
var G__19539 = c;
var G__19540 = d;
var G__19541 = e;
var G__19542 = f;
var G__19543 = g;
var G__19544 = h;
var G__19545 = i;
var G__19546 = j;
var G__19547 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__19537,G__19538,G__19539,G__19540,G__19541,G__19542,G__19543,G__19544,G__19545,G__19546,G__19547) : target_fn.call(null,G__19537,G__19538,G__19539,G__19540,G__19541,G__19542,G__19543,G__19544,G__19545,G__19546,G__19547));
});
var G__20256__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19548 = a;
var G__19549 = b;
var G__19550 = c;
var G__19551 = d;
var G__19552 = e;
var G__19553 = f;
var G__19554 = g;
var G__19555 = h;
var G__19556 = i;
var G__19557 = j;
var G__19558 = k;
var G__19559 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__19548,G__19549,G__19550,G__19551,G__19552,G__19553,G__19554,G__19555,G__19556,G__19557,G__19558,G__19559) : self__.dispatch_fn.call(null,G__19548,G__19549,G__19550,G__19551,G__19552,G__19553,G__19554,G__19555,G__19556,G__19557,G__19558,G__19559));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19560 = a;
var G__19561 = b;
var G__19562 = c;
var G__19563 = d;
var G__19564 = e;
var G__19565 = f;
var G__19566 = g;
var G__19567 = h;
var G__19568 = i;
var G__19569 = j;
var G__19570 = k;
var G__19571 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__19560,G__19561,G__19562,G__19563,G__19564,G__19565,G__19566,G__19567,G__19568,G__19569,G__19570,G__19571) : target_fn.call(null,G__19560,G__19561,G__19562,G__19563,G__19564,G__19565,G__19566,G__19567,G__19568,G__19569,G__19570,G__19571));
});
var G__20256__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19572 = a;
var G__19573 = b;
var G__19574 = c;
var G__19575 = d;
var G__19576 = e;
var G__19577 = f;
var G__19578 = g;
var G__19579 = h;
var G__19580 = i;
var G__19581 = j;
var G__19582 = k;
var G__19583 = l;
var G__19584 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__19572,G__19573,G__19574,G__19575,G__19576,G__19577,G__19578,G__19579,G__19580,G__19581,G__19582,G__19583,G__19584) : self__.dispatch_fn.call(null,G__19572,G__19573,G__19574,G__19575,G__19576,G__19577,G__19578,G__19579,G__19580,G__19581,G__19582,G__19583,G__19584));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19585 = a;
var G__19586 = b;
var G__19587 = c;
var G__19588 = d;
var G__19589 = e;
var G__19590 = f;
var G__19591 = g;
var G__19592 = h;
var G__19593 = i;
var G__19594 = j;
var G__19595 = k;
var G__19596 = l;
var G__19597 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__19585,G__19586,G__19587,G__19588,G__19589,G__19590,G__19591,G__19592,G__19593,G__19594,G__19595,G__19596,G__19597) : target_fn.call(null,G__19585,G__19586,G__19587,G__19588,G__19589,G__19590,G__19591,G__19592,G__19593,G__19594,G__19595,G__19596,G__19597));
});
var G__20256__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19598 = a;
var G__19599 = b;
var G__19600 = c;
var G__19601 = d;
var G__19602 = e;
var G__19603 = f;
var G__19604 = g;
var G__19605 = h;
var G__19606 = i;
var G__19607 = j;
var G__19608 = k;
var G__19609 = l;
var G__19610 = m;
var G__19611 = n;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14(G__19598,G__19599,G__19600,G__19601,G__19602,G__19603,G__19604,G__19605,G__19606,G__19607,G__19608,G__19609,G__19610,G__19611) : self__.dispatch_fn.call(null,G__19598,G__19599,G__19600,G__19601,G__19602,G__19603,G__19604,G__19605,G__19606,G__19607,G__19608,G__19609,G__19610,G__19611));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19612 = a;
var G__19613 = b;
var G__19614 = c;
var G__19615 = d;
var G__19616 = e;
var G__19617 = f;
var G__19618 = g;
var G__19619 = h;
var G__19620 = i;
var G__19621 = j;
var G__19622 = k;
var G__19623 = l;
var G__19624 = m;
var G__19625 = n;
return (target_fn.cljs$core$IFn$_invoke$arity$14 ? target_fn.cljs$core$IFn$_invoke$arity$14(G__19612,G__19613,G__19614,G__19615,G__19616,G__19617,G__19618,G__19619,G__19620,G__19621,G__19622,G__19623,G__19624,G__19625) : target_fn.call(null,G__19612,G__19613,G__19614,G__19615,G__19616,G__19617,G__19618,G__19619,G__19620,G__19621,G__19622,G__19623,G__19624,G__19625));
});
var G__20256__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19626 = a;
var G__19627 = b;
var G__19628 = c;
var G__19629 = d;
var G__19630 = e;
var G__19631 = f;
var G__19632 = g;
var G__19633 = h;
var G__19634 = i;
var G__19635 = j;
var G__19636 = k;
var G__19637 = l;
var G__19638 = m;
var G__19639 = n;
var G__19640 = o;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15(G__19626,G__19627,G__19628,G__19629,G__19630,G__19631,G__19632,G__19633,G__19634,G__19635,G__19636,G__19637,G__19638,G__19639,G__19640) : self__.dispatch_fn.call(null,G__19626,G__19627,G__19628,G__19629,G__19630,G__19631,G__19632,G__19633,G__19634,G__19635,G__19636,G__19637,G__19638,G__19639,G__19640));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19641 = a;
var G__19642 = b;
var G__19643 = c;
var G__19644 = d;
var G__19645 = e;
var G__19646 = f;
var G__19647 = g;
var G__19648 = h;
var G__19649 = i;
var G__19650 = j;
var G__19651 = k;
var G__19652 = l;
var G__19653 = m;
var G__19654 = n;
var G__19655 = o;
return (target_fn.cljs$core$IFn$_invoke$arity$15 ? target_fn.cljs$core$IFn$_invoke$arity$15(G__19641,G__19642,G__19643,G__19644,G__19645,G__19646,G__19647,G__19648,G__19649,G__19650,G__19651,G__19652,G__19653,G__19654,G__19655) : target_fn.call(null,G__19641,G__19642,G__19643,G__19644,G__19645,G__19646,G__19647,G__19648,G__19649,G__19650,G__19651,G__19652,G__19653,G__19654,G__19655));
});
var G__20256__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19656 = a;
var G__19657 = b;
var G__19658 = c;
var G__19659 = d;
var G__19660 = e;
var G__19661 = f;
var G__19662 = g;
var G__19663 = h;
var G__19664 = i;
var G__19665 = j;
var G__19666 = k;
var G__19667 = l;
var G__19668 = m;
var G__19669 = n;
var G__19670 = o;
var G__19671 = p;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16(G__19656,G__19657,G__19658,G__19659,G__19660,G__19661,G__19662,G__19663,G__19664,G__19665,G__19666,G__19667,G__19668,G__19669,G__19670,G__19671) : self__.dispatch_fn.call(null,G__19656,G__19657,G__19658,G__19659,G__19660,G__19661,G__19662,G__19663,G__19664,G__19665,G__19666,G__19667,G__19668,G__19669,G__19670,G__19671));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19672 = a;
var G__19673 = b;
var G__19674 = c;
var G__19675 = d;
var G__19676 = e;
var G__19677 = f;
var G__19678 = g;
var G__19679 = h;
var G__19680 = i;
var G__19681 = j;
var G__19682 = k;
var G__19683 = l;
var G__19684 = m;
var G__19685 = n;
var G__19686 = o;
var G__19687 = p;
return (target_fn.cljs$core$IFn$_invoke$arity$16 ? target_fn.cljs$core$IFn$_invoke$arity$16(G__19672,G__19673,G__19674,G__19675,G__19676,G__19677,G__19678,G__19679,G__19680,G__19681,G__19682,G__19683,G__19684,G__19685,G__19686,G__19687) : target_fn.call(null,G__19672,G__19673,G__19674,G__19675,G__19676,G__19677,G__19678,G__19679,G__19680,G__19681,G__19682,G__19683,G__19684,G__19685,G__19686,G__19687));
});
var G__20256__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19688 = a;
var G__19689 = b;
var G__19690 = c;
var G__19691 = d;
var G__19692 = e;
var G__19693 = f;
var G__19694 = g;
var G__19695 = h;
var G__19696 = i;
var G__19697 = j;
var G__19698 = k;
var G__19699 = l;
var G__19700 = m;
var G__19701 = n;
var G__19702 = o;
var G__19703 = p;
var G__19704 = q;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17(G__19688,G__19689,G__19690,G__19691,G__19692,G__19693,G__19694,G__19695,G__19696,G__19697,G__19698,G__19699,G__19700,G__19701,G__19702,G__19703,G__19704) : self__.dispatch_fn.call(null,G__19688,G__19689,G__19690,G__19691,G__19692,G__19693,G__19694,G__19695,G__19696,G__19697,G__19698,G__19699,G__19700,G__19701,G__19702,G__19703,G__19704));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19705 = a;
var G__19706 = b;
var G__19707 = c;
var G__19708 = d;
var G__19709 = e;
var G__19710 = f;
var G__19711 = g;
var G__19712 = h;
var G__19713 = i;
var G__19714 = j;
var G__19715 = k;
var G__19716 = l;
var G__19717 = m;
var G__19718 = n;
var G__19719 = o;
var G__19720 = p;
var G__19721 = q;
return (target_fn.cljs$core$IFn$_invoke$arity$17 ? target_fn.cljs$core$IFn$_invoke$arity$17(G__19705,G__19706,G__19707,G__19708,G__19709,G__19710,G__19711,G__19712,G__19713,G__19714,G__19715,G__19716,G__19717,G__19718,G__19719,G__19720,G__19721) : target_fn.call(null,G__19705,G__19706,G__19707,G__19708,G__19709,G__19710,G__19711,G__19712,G__19713,G__19714,G__19715,G__19716,G__19717,G__19718,G__19719,G__19720,G__19721));
});
var G__20256__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19722 = a;
var G__19723 = b;
var G__19724 = c;
var G__19725 = d;
var G__19726 = e;
var G__19727 = f;
var G__19728 = g;
var G__19729 = h;
var G__19730 = i;
var G__19731 = j;
var G__19732 = k;
var G__19733 = l;
var G__19734 = m;
var G__19735 = n;
var G__19736 = o;
var G__19737 = p;
var G__19738 = q;
var G__19739 = r;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18(G__19722,G__19723,G__19724,G__19725,G__19726,G__19727,G__19728,G__19729,G__19730,G__19731,G__19732,G__19733,G__19734,G__19735,G__19736,G__19737,G__19738,G__19739) : self__.dispatch_fn.call(null,G__19722,G__19723,G__19724,G__19725,G__19726,G__19727,G__19728,G__19729,G__19730,G__19731,G__19732,G__19733,G__19734,G__19735,G__19736,G__19737,G__19738,G__19739));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__19740 = a;
var G__19741 = b;
var G__19742 = c;
var G__19743 = d;
var G__19744 = e;
var G__19745 = f;
var G__19746 = g;
var G__19747 = h;
var G__19748 = i;
var G__19749 = j;
var G__19750 = k;
var G__19751 = l;
var G__19752 = m;
var G__19753 = n;
var G__19754 = o;
var G__19755 = p;
var G__19756 = q;
var G__19757 = r;
return (target_fn.cljs$core$IFn$_invoke$arity$18 ? target_fn.cljs$core$IFn$_invoke$arity$18(G__19740,G__19741,G__19742,G__19743,G__19744,G__19745,G__19746,G__19747,G__19748,G__19749,G__19750,G__19751,G__19752,G__19753,G__19754,G__19755,G__19756,G__19757) : target_fn.call(null,G__19740,G__19741,G__19742,G__19743,G__19744,G__19745,G__19746,G__19747,G__19748,G__19749,G__19750,G__19751,G__19752,G__19753,G__19754,G__19755,G__19756,G__19757));
});
var G__20256__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__19758 = a;
var G__19759 = b;
var G__19760 = c;
var G__19761 = d;
var G__19762 = e;
var G__19763 = f;
var G__19764 = g;
var G__19765 = h;
var G__19766 = i;
var G__19767 = j;
var G__19768 = k;
var G__19769 = l;
var G__19770 = m;
var G__19771 = n;
var G__19772 = o;
var G__19773 = p;
var G__19774 = q;
var G__19775 = r;
var G__19776 = s;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19(G__19758,G__19759,G__19760,G__19761,G__19762,G__19763,G__19764,G__19765,G__19766,G__19767,G__19768,G__19769,G__19770,G__19771,G__19772,G__19773,G__19774,G__19775,G__19776) : self__.dispatch_fn.call(null,G__19758,G__19759,G__19760,G__19761,G__19762,G__19