// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t12358 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12358 = (function (f,fn_handler,meta12359){
this.f = f;
this.fn_handler = fn_handler;
this.meta12359 = meta12359;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12358.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12358.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t12358.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t12358.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12360){
var self__ = this;
var _12360__$1 = this;
return self__.meta12359;
});

cljs.core.async.t12358.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12360,meta12359__$1){
var self__ = this;
var _12360__$1 = this;
return (new cljs.core.async.t12358(self__.f,self__.fn_handler,meta12359__$1));
});

cljs.core.async.t12358.cljs$lang$type = true;

cljs.core.async.t12358.cljs$lang$ctorStr = "cljs.core.async/t12358";

cljs.core.async.t12358.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12358");
});

cljs.core.async.__GT_t12358 = (function cljs$core$async$fn_handler_$___GT_t12358(f__$1,fn_handler__$1,meta12359){
return (new cljs.core.async.t12358(f__$1,fn_handler__$1,meta12359));
});

}

return (new cljs.core.async.t12358(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__12362 = buff;
if(G__12362){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__12362.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__12362.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12362);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,G__12362);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__12364 = arguments.length;
switch (G__12364) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__12367 = arguments.length;
switch (G__12367) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12369 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12369);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12369,ret){
return (function (){
return fn1.call(null,val_12369);
});})(val_12369,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__12371 = arguments.length;
switch (G__12371) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4124__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___12373 = n;
var x_12374 = (0);
while(true){
if((x_12374 < n__5161__auto___12373)){
(a[x_12374] = (0));

var G__12375 = (x_12374 + (1));
x_12374 = G__12375;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12376 = (i + (1));
i = G__12376;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t12380 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12380 = (function (flag,alt_flag,meta12381){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta12381 = meta12381;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12380.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12380.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t12380.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t12380.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12382){
var self__ = this;
var _12382__$1 = this;
return self__.meta12381;
});})(flag))
;

cljs.core.async.t12380.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12382,meta12381__$1){
var self__ = this;
var _12382__$1 = this;
return (new cljs.core.async.t12380(self__.flag,self__.alt_flag,meta12381__$1));
});})(flag))
;

cljs.core.async.t12380.cljs$lang$type = true;

cljs.core.async.t12380.cljs$lang$ctorStr = "cljs.core.async/t12380";

cljs.core.async.t12380.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12380");
});})(flag))
;

cljs.core.async.__GT_t12380 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t12380(flag__$1,alt_flag__$1,meta12381){
return (new cljs.core.async.t12380(flag__$1,alt_flag__$1,meta12381));
});})(flag))
;

}

return (new cljs.core.async.t12380(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t12386 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t12386 = (function (cb,flag,alt_handler,meta12387){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta12387 = meta12387;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t12386.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t12386.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t12386.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t12386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12388){
var self__ = this;
var _12388__$1 = this;
return self__.meta12387;
});

cljs.core.async.t12386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12388,meta12387__$1){
var self__ = this;
var _12388__$1 = this;
return (new cljs.core.async.t12386(self__.cb,self__.flag,self__.alt_handler,meta12387__$1));
});

cljs.core.async.t12386.cljs$lang$type = true;

cljs.core.async.t12386.cljs$lang$ctorStr = "cljs.core.async/t12386";

cljs.core.async.t12386.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t12386");
});

cljs.core.async.__GT_t12386 = (function cljs$core$async$alt_handler_$___GT_t12386(cb__$1,flag__$1,alt_handler__$1,meta12387){
return (new cljs.core.async.t12386(cb__$1,flag__$1,alt_handler__$1,meta12387));
});

}

return (new cljs.core.async.t12386(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12389_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12389_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12390_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12390_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12391 = (i + (1));
i = G__12391;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12394){
var map__12395 = p__12394;
var map__12395__$1 = ((cljs.core.seq_QMARK_.call(null,map__12395))?cljs.core.apply.call(null,cljs.core.hash_map,map__12395):map__12395);
var opts = map__12395__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12392){
var G__12393 = cljs.core.first.call(null,seq12392);
var seq12392__$1 = cljs.core.next.call(null,seq12392);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12393,seq12392__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__12397 = arguments.length;
switch (G__12397) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___12446 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12446){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12446){
return (function (state_12421){
var state_val_12422 = (state_12421[(1)]);
if((state_val_12422 === (7))){
var inst_12417 = (state_12421[(2)]);
var state_12421__$1 = state_12421;
var statearr_12423_12447 = state_12421__$1;
(statearr_12423_12447[(2)] = inst_12417);

(statearr_12423_12447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (1))){
var state_12421__$1 = state_12421;
var statearr_12424_12448 = state_12421__$1;
(statearr_12424_12448[(2)] = null);

(statearr_12424_12448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (4))){
var inst_12400 = (state_12421[(7)]);
var inst_12400__$1 = (state_12421[(2)]);
var inst_12401 = (inst_12400__$1 == null);
var state_12421__$1 = (function (){var statearr_12425 = state_12421;
(statearr_12425[(7)] = inst_12400__$1);

return statearr_12425;
})();
if(cljs.core.truth_(inst_12401)){
var statearr_12426_12449 = state_12421__$1;
(statearr_12426_12449[(1)] = (5));

} else {
var statearr_12427_12450 = state_12421__$1;
(statearr_12427_12450[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (13))){
var state_12421__$1 = state_12421;
var statearr_12428_12451 = state_12421__$1;
(statearr_12428_12451[(2)] = null);

(statearr_12428_12451[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (6))){
var inst_12400 = (state_12421[(7)]);
var state_12421__$1 = state_12421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12421__$1,(11),to,inst_12400);
} else {
if((state_val_12422 === (3))){
var inst_12419 = (state_12421[(2)]);
var state_12421__$1 = state_12421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12421__$1,inst_12419);
} else {
if((state_val_12422 === (12))){
var state_12421__$1 = state_12421;
var statearr_12429_12452 = state_12421__$1;
(statearr_12429_12452[(2)] = null);

(statearr_12429_12452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (2))){
var state_12421__$1 = state_12421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12421__$1,(4),from);
} else {
if((state_val_12422 === (11))){
var inst_12410 = (state_12421[(2)]);
var state_12421__$1 = state_12421;
if(cljs.core.truth_(inst_12410)){
var statearr_12430_12453 = state_12421__$1;
(statearr_12430_12453[(1)] = (12));

} else {
var statearr_12431_12454 = state_12421__$1;
(statearr_12431_12454[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (9))){
var state_12421__$1 = state_12421;
var statearr_12432_12455 = state_12421__$1;
(statearr_12432_12455[(2)] = null);

(statearr_12432_12455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (5))){
var state_12421__$1 = state_12421;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12433_12456 = state_12421__$1;
(statearr_12433_12456[(1)] = (8));

} else {
var statearr_12434_12457 = state_12421__$1;
(statearr_12434_12457[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (14))){
var inst_12415 = (state_12421[(2)]);
var state_12421__$1 = state_12421;
var statearr_12435_12458 = state_12421__$1;
(statearr_12435_12458[(2)] = inst_12415);

(statearr_12435_12458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (10))){
var inst_12407 = (state_12421[(2)]);
var state_12421__$1 = state_12421;
var statearr_12436_12459 = state_12421__$1;
(statearr_12436_12459[(2)] = inst_12407);

(statearr_12436_12459[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12422 === (8))){
var inst_12404 = cljs.core.async.close_BANG_.call(null,to);
var state_12421__$1 = state_12421;
var statearr_12437_12460 = state_12421__$1;
(statearr_12437_12460[(2)] = inst_12404);

(statearr_12437_12460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12446))
;
return ((function (switch__7647__auto__,c__7709__auto___12446){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12441 = [null,null,null,null,null,null,null,null];
(statearr_12441[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12441[(1)] = (1));

return statearr_12441;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12421){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12442){if((e12442 instanceof Object)){
var ex__7651__auto__ = e12442;
var statearr_12443_12461 = state_12421;
(statearr_12443_12461[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12442;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12462 = state_12421;
state_12421 = G__12462;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12421){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12446))
})();
var state__7711__auto__ = (function (){var statearr_12444 = f__7710__auto__.call(null);
(statearr_12444[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12446);

return statearr_12444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12446))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12646){
var vec__12647 = p__12646;
var v = cljs.core.nth.call(null,vec__12647,(0),null);
var p = cljs.core.nth.call(null,vec__12647,(1),null);
var job = vec__12647;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__7709__auto___12829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results){
return (function (state_12652){
var state_val_12653 = (state_12652[(1)]);
if((state_val_12653 === (2))){
var inst_12649 = (state_12652[(2)]);
var inst_12650 = cljs.core.async.close_BANG_.call(null,res);
var state_12652__$1 = (function (){var statearr_12654 = state_12652;
(statearr_12654[(7)] = inst_12649);

return statearr_12654;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12652__$1,inst_12650);
} else {
if((state_val_12653 === (1))){
var state_12652__$1 = state_12652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12652__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12658 = [null,null,null,null,null,null,null,null];
(statearr_12658[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12658[(1)] = (1));

return statearr_12658;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12652){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12659){if((e12659 instanceof Object)){
var ex__7651__auto__ = e12659;
var statearr_12660_12830 = state_12652;
(statearr_12660_12830[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12831 = state_12652;
state_12652 = G__12831;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12652){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_12661 = f__7710__auto__.call(null);
(statearr_12661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12829);

return statearr_12661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12829,res,vec__12647,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12662){
var vec__12663 = p__12662;
var v = cljs.core.nth.call(null,vec__12663,(0),null);
var p = cljs.core.nth.call(null,vec__12663,(1),null);
var job = vec__12663;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___12832 = n;
var __12833 = (0);
while(true){
if((__12833 < n__5161__auto___12832)){
var G__12664_12834 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12664_12834) {
case "async":
var c__7709__auto___12836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12833,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12833,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function (state_12677){
var state_val_12678 = (state_12677[(1)]);
if((state_val_12678 === (7))){
var inst_12673 = (state_12677[(2)]);
var state_12677__$1 = state_12677;
var statearr_12679_12837 = state_12677__$1;
(statearr_12679_12837[(2)] = inst_12673);

(statearr_12679_12837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12678 === (6))){
var state_12677__$1 = state_12677;
var statearr_12680_12838 = state_12677__$1;
(statearr_12680_12838[(2)] = null);

(statearr_12680_12838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12678 === (5))){
var state_12677__$1 = state_12677;
var statearr_12681_12839 = state_12677__$1;
(statearr_12681_12839[(2)] = null);

(statearr_12681_12839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12678 === (4))){
var inst_12667 = (state_12677[(2)]);
var inst_12668 = async.call(null,inst_12667);
var state_12677__$1 = state_12677;
if(cljs.core.truth_(inst_12668)){
var statearr_12682_12840 = state_12677__$1;
(statearr_12682_12840[(1)] = (5));

} else {
var statearr_12683_12841 = state_12677__$1;
(statearr_12683_12841[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12678 === (3))){
var inst_12675 = (state_12677[(2)]);
var state_12677__$1 = state_12677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12677__$1,inst_12675);
} else {
if((state_val_12678 === (2))){
var state_12677__$1 = state_12677;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12677__$1,(4),jobs);
} else {
if((state_val_12678 === (1))){
var state_12677__$1 = state_12677;
var statearr_12684_12842 = state_12677__$1;
(statearr_12684_12842[(2)] = null);

(statearr_12684_12842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12833,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
;
return ((function (__12833,switch__7647__auto__,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12688 = [null,null,null,null,null,null,null];
(statearr_12688[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12688[(1)] = (1));

return statearr_12688;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12677){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12689){if((e12689 instanceof Object)){
var ex__7651__auto__ = e12689;
var statearr_12690_12843 = state_12677;
(statearr_12690_12843[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12689;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12844 = state_12677;
state_12677 = G__12844;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12677){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12833,switch__7647__auto__,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12691 = f__7710__auto__.call(null);
(statearr_12691[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12836);

return statearr_12691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12833,c__7709__auto___12836,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___12845 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12833,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__12833,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function (state_12704){
var state_val_12705 = (state_12704[(1)]);
if((state_val_12705 === (7))){
var inst_12700 = (state_12704[(2)]);
var state_12704__$1 = state_12704;
var statearr_12706_12846 = state_12704__$1;
(statearr_12706_12846[(2)] = inst_12700);

(statearr_12706_12846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12705 === (6))){
var state_12704__$1 = state_12704;
var statearr_12707_12847 = state_12704__$1;
(statearr_12707_12847[(2)] = null);

(statearr_12707_12847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12705 === (5))){
var state_12704__$1 = state_12704;
var statearr_12708_12848 = state_12704__$1;
(statearr_12708_12848[(2)] = null);

(statearr_12708_12848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12705 === (4))){
var inst_12694 = (state_12704[(2)]);
var inst_12695 = process.call(null,inst_12694);
var state_12704__$1 = state_12704;
if(cljs.core.truth_(inst_12695)){
var statearr_12709_12849 = state_12704__$1;
(statearr_12709_12849[(1)] = (5));

} else {
var statearr_12710_12850 = state_12704__$1;
(statearr_12710_12850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12705 === (3))){
var inst_12702 = (state_12704[(2)]);
var state_12704__$1 = state_12704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12704__$1,inst_12702);
} else {
if((state_val_12705 === (2))){
var state_12704__$1 = state_12704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12704__$1,(4),jobs);
} else {
if((state_val_12705 === (1))){
var state_12704__$1 = state_12704;
var statearr_12711_12851 = state_12704__$1;
(statearr_12711_12851[(2)] = null);

(statearr_12711_12851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12833,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
;
return ((function (__12833,switch__7647__auto__,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12715 = [null,null,null,null,null,null,null];
(statearr_12715[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12715[(1)] = (1));

return statearr_12715;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12704){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12716){if((e12716 instanceof Object)){
var ex__7651__auto__ = e12716;
var statearr_12717_12852 = state_12704;
(statearr_12717_12852[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12716;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12853 = state_12704;
state_12704 = G__12853;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12704){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__12833,switch__7647__auto__,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12718 = f__7710__auto__.call(null);
(statearr_12718[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12845);

return statearr_12718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(__12833,c__7709__auto___12845,G__12664_12834,n__5161__auto___12832,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12854 = (__12833 + (1));
__12833 = G__12854;
continue;
} else {
}
break;
}

var c__7709__auto___12855 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12855,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12855,jobs,results,process,async){
return (function (state_12740){
var state_val_12741 = (state_12740[(1)]);
if((state_val_12741 === (9))){
var inst_12733 = (state_12740[(2)]);
var state_12740__$1 = (function (){var statearr_12742 = state_12740;
(statearr_12742[(7)] = inst_12733);

return statearr_12742;
})();
var statearr_12743_12856 = state_12740__$1;
(statearr_12743_12856[(2)] = null);

(statearr_12743_12856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12741 === (8))){
var inst_12726 = (state_12740[(8)]);
var inst_12731 = (state_12740[(2)]);
var state_12740__$1 = (function (){var statearr_12744 = state_12740;
(statearr_12744[(9)] = inst_12731);

return statearr_12744;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12740__$1,(9),results,inst_12726);
} else {
if((state_val_12741 === (7))){
var inst_12736 = (state_12740[(2)]);
var state_12740__$1 = state_12740;
var statearr_12745_12857 = state_12740__$1;
(statearr_12745_12857[(2)] = inst_12736);

(statearr_12745_12857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12741 === (6))){
var inst_12721 = (state_12740[(10)]);
var inst_12726 = (state_12740[(8)]);
var inst_12726__$1 = cljs.core.async.chan.call(null,(1));
var inst_12727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12728 = [inst_12721,inst_12726__$1];
var inst_12729 = (new cljs.core.PersistentVector(null,2,(5),inst_12727,inst_12728,null));
var state_12740__$1 = (function (){var statearr_12746 = state_12740;
(statearr_12746[(8)] = inst_12726__$1);

return statearr_12746;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12740__$1,(8),jobs,inst_12729);
} else {
if((state_val_12741 === (5))){
var inst_12724 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12740__$1 = state_12740;
var statearr_12747_12858 = state_12740__$1;
(statearr_12747_12858[(2)] = inst_12724);

(statearr_12747_12858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12741 === (4))){
var inst_12721 = (state_12740[(10)]);
var inst_12721__$1 = (state_12740[(2)]);
var inst_12722 = (inst_12721__$1 == null);
var state_12740__$1 = (function (){var statearr_12748 = state_12740;
(statearr_12748[(10)] = inst_12721__$1);

return statearr_12748;
})();
if(cljs.core.truth_(inst_12722)){
var statearr_12749_12859 = state_12740__$1;
(statearr_12749_12859[(1)] = (5));

} else {
var statearr_12750_12860 = state_12740__$1;
(statearr_12750_12860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12741 === (3))){
var inst_12738 = (state_12740[(2)]);
var state_12740__$1 = state_12740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12740__$1,inst_12738);
} else {
if((state_val_12741 === (2))){
var state_12740__$1 = state_12740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12740__$1,(4),from);
} else {
if((state_val_12741 === (1))){
var state_12740__$1 = state_12740;
var statearr_12751_12861 = state_12740__$1;
(statearr_12751_12861[(2)] = null);

(statearr_12751_12861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12855,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___12855,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12755 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12755[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12755[(1)] = (1));

return statearr_12755;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12740){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12756){if((e12756 instanceof Object)){
var ex__7651__auto__ = e12756;
var statearr_12757_12862 = state_12740;
(statearr_12757_12862[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12863 = state_12740;
state_12740 = G__12863;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12740){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12855,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12758 = f__7710__auto__.call(null);
(statearr_12758[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12855);

return statearr_12758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12855,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_12796){
var state_val_12797 = (state_12796[(1)]);
if((state_val_12797 === (7))){
var inst_12792 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12798_12864 = state_12796__$1;
(statearr_12798_12864[(2)] = inst_12792);

(statearr_12798_12864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (20))){
var state_12796__$1 = state_12796;
var statearr_12799_12865 = state_12796__$1;
(statearr_12799_12865[(2)] = null);

(statearr_12799_12865[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (1))){
var state_12796__$1 = state_12796;
var statearr_12800_12866 = state_12796__$1;
(statearr_12800_12866[(2)] = null);

(statearr_12800_12866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (4))){
var inst_12761 = (state_12796[(7)]);
var inst_12761__$1 = (state_12796[(2)]);
var inst_12762 = (inst_12761__$1 == null);
var state_12796__$1 = (function (){var statearr_12801 = state_12796;
(statearr_12801[(7)] = inst_12761__$1);

return statearr_12801;
})();
if(cljs.core.truth_(inst_12762)){
var statearr_12802_12867 = state_12796__$1;
(statearr_12802_12867[(1)] = (5));

} else {
var statearr_12803_12868 = state_12796__$1;
(statearr_12803_12868[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (15))){
var inst_12774 = (state_12796[(8)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12796__$1,(18),to,inst_12774);
} else {
if((state_val_12797 === (21))){
var inst_12787 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12804_12869 = state_12796__$1;
(statearr_12804_12869[(2)] = inst_12787);

(statearr_12804_12869[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (13))){
var inst_12789 = (state_12796[(2)]);
var state_12796__$1 = (function (){var statearr_12805 = state_12796;
(statearr_12805[(9)] = inst_12789);

return statearr_12805;
})();
var statearr_12806_12870 = state_12796__$1;
(statearr_12806_12870[(2)] = null);

(statearr_12806_12870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (6))){
var inst_12761 = (state_12796[(7)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12796__$1,(11),inst_12761);
} else {
if((state_val_12797 === (17))){
var inst_12782 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
if(cljs.core.truth_(inst_12782)){
var statearr_12807_12871 = state_12796__$1;
(statearr_12807_12871[(1)] = (19));

} else {
var statearr_12808_12872 = state_12796__$1;
(statearr_12808_12872[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (3))){
var inst_12794 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12796__$1,inst_12794);
} else {
if((state_val_12797 === (12))){
var inst_12771 = (state_12796[(10)]);
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12796__$1,(14),inst_12771);
} else {
if((state_val_12797 === (2))){
var state_12796__$1 = state_12796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12796__$1,(4),results);
} else {
if((state_val_12797 === (19))){
var state_12796__$1 = state_12796;
var statearr_12809_12873 = state_12796__$1;
(statearr_12809_12873[(2)] = null);

(statearr_12809_12873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (11))){
var inst_12771 = (state_12796[(2)]);
var state_12796__$1 = (function (){var statearr_12810 = state_12796;
(statearr_12810[(10)] = inst_12771);

return statearr_12810;
})();
var statearr_12811_12874 = state_12796__$1;
(statearr_12811_12874[(2)] = null);

(statearr_12811_12874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (9))){
var state_12796__$1 = state_12796;
var statearr_12812_12875 = state_12796__$1;
(statearr_12812_12875[(2)] = null);

(statearr_12812_12875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (5))){
var state_12796__$1 = state_12796;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12813_12876 = state_12796__$1;
(statearr_12813_12876[(1)] = (8));

} else {
var statearr_12814_12877 = state_12796__$1;
(statearr_12814_12877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (14))){
var inst_12776 = (state_12796[(11)]);
var inst_12774 = (state_12796[(8)]);
var inst_12774__$1 = (state_12796[(2)]);
var inst_12775 = (inst_12774__$1 == null);
var inst_12776__$1 = cljs.core.not.call(null,inst_12775);
var state_12796__$1 = (function (){var statearr_12815 = state_12796;
(statearr_12815[(11)] = inst_12776__$1);

(statearr_12815[(8)] = inst_12774__$1);

return statearr_12815;
})();
if(inst_12776__$1){
var statearr_12816_12878 = state_12796__$1;
(statearr_12816_12878[(1)] = (15));

} else {
var statearr_12817_12879 = state_12796__$1;
(statearr_12817_12879[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (16))){
var inst_12776 = (state_12796[(11)]);
var state_12796__$1 = state_12796;
var statearr_12818_12880 = state_12796__$1;
(statearr_12818_12880[(2)] = inst_12776);

(statearr_12818_12880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (10))){
var inst_12768 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12819_12881 = state_12796__$1;
(statearr_12819_12881[(2)] = inst_12768);

(statearr_12819_12881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (18))){
var inst_12779 = (state_12796[(2)]);
var state_12796__$1 = state_12796;
var statearr_12820_12882 = state_12796__$1;
(statearr_12820_12882[(2)] = inst_12779);

(statearr_12820_12882[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12797 === (8))){
var inst_12765 = cljs.core.async.close_BANG_.call(null,to);
var state_12796__$1 = state_12796;
var statearr_12821_12883 = state_12796__$1;
(statearr_12821_12883[(2)] = inst_12765);

(statearr_12821_12883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_12825 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12825[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_12825[(1)] = (1));

return statearr_12825;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_12796){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12826){if((e12826 instanceof Object)){
var ex__7651__auto__ = e12826;
var statearr_12827_12884 = state_12796;
(statearr_12827_12884[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12885 = state_12796;
state_12796 = G__12885;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_12796){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_12796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_12828 = f__7710__auto__.call(null);
(statearr_12828[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_12828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__12887 = arguments.length;
switch (G__12887) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__12890 = arguments.length;
switch (G__12890) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__12893 = arguments.length;
switch (G__12893) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__7709__auto___12945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12945,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12945,tc,fc){
return (function (state_12919){
var state_val_12920 = (state_12919[(1)]);
if((state_val_12920 === (7))){
var inst_12915 = (state_12919[(2)]);
var state_12919__$1 = state_12919;
var statearr_12921_12946 = state_12919__$1;
(statearr_12921_12946[(2)] = inst_12915);

(statearr_12921_12946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (1))){
var state_12919__$1 = state_12919;
var statearr_12922_12947 = state_12919__$1;
(statearr_12922_12947[(2)] = null);

(statearr_12922_12947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (4))){
var inst_12896 = (state_12919[(7)]);
var inst_12896__$1 = (state_12919[(2)]);
var inst_12897 = (inst_12896__$1 == null);
var state_12919__$1 = (function (){var statearr_12923 = state_12919;
(statearr_12923[(7)] = inst_12896__$1);

return statearr_12923;
})();
if(cljs.core.truth_(inst_12897)){
var statearr_12924_12948 = state_12919__$1;
(statearr_12924_12948[(1)] = (5));

} else {
var statearr_12925_12949 = state_12919__$1;
(statearr_12925_12949[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (13))){
var state_12919__$1 = state_12919;
var statearr_12926_12950 = state_12919__$1;
(statearr_12926_12950[(2)] = null);

(statearr_12926_12950[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (6))){
var inst_12896 = (state_12919[(7)]);
var inst_12902 = p.call(null,inst_12896);
var state_12919__$1 = state_12919;
if(cljs.core.truth_(inst_12902)){
var statearr_12927_12951 = state_12919__$1;
(statearr_12927_12951[(1)] = (9));

} else {
var statearr_12928_12952 = state_12919__$1;
(statearr_12928_12952[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (3))){
var inst_12917 = (state_12919[(2)]);
var state_12919__$1 = state_12919;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12919__$1,inst_12917);
} else {
if((state_val_12920 === (12))){
var state_12919__$1 = state_12919;
var statearr_12929_12953 = state_12919__$1;
(statearr_12929_12953[(2)] = null);

(statearr_12929_12953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (2))){
var state_12919__$1 = state_12919;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12919__$1,(4),ch);
} else {
if((state_val_12920 === (11))){
var inst_12896 = (state_12919[(7)]);
var inst_12906 = (state_12919[(2)]);
var state_12919__$1 = state_12919;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12919__$1,(8),inst_12906,inst_12896);
} else {
if((state_val_12920 === (9))){
var state_12919__$1 = state_12919;
var statearr_12930_12954 = state_12919__$1;
(statearr_12930_12954[(2)] = tc);

(statearr_12930_12954[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (5))){
var inst_12899 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12900 = cljs.core.async.close_BANG_.call(null,fc);
var state_12919__$1 = (function (){var statearr_12931 = state_12919;
(statearr_12931[(8)] = inst_12899);

return statearr_12931;
})();
var statearr_12932_12955 = state_12919__$1;
(statearr_12932_12955[(2)] = inst_12900);

(statearr_12932_12955[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (14))){
var inst_12913 = (state_12919[(2)]);
var state_12919__$1 = state_12919;
var statearr_12933_12956 = state_12919__$1;
(statearr_12933_12956[(2)] = inst_12913);

(statearr_12933_12956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (10))){
var state_12919__$1 = state_12919;
var statearr_12934_12957 = state_12919__$1;
(statearr_12934_12957[(2)] = fc);

(statearr_12934_12957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12920 === (8))){
var inst_12908 = (state_12919[(2)]);
var state_12919__$1 = state_12919;
if(cljs.core.truth_(inst_12908)){
var statearr_12935_12958 = state_12919__$1;
(statearr_12935_12958[(1)] = (12));

} else {
var statearr_12936_12959 = state_12919__$1;
(statearr_12936_12959[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___12945,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___12945,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_12940 = [null,null,null,null,null,null,null,null,null];
(statearr_12940[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_12940[(1)] = (1));

return statearr_12940;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_12919){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12919);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12941){if((e12941 instanceof Object)){
var ex__7651__auto__ = e12941;
var statearr_12942_12960 = state_12919;
(statearr_12942_12960[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12941;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12961 = state_12919;
state_12919 = G__12961;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_12919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_12919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12945,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_12943 = f__7710__auto__.call(null);
(statearr_12943[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12945);

return statearr_12943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12945,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13008){
var state_val_13009 = (state_13008[(1)]);
if((state_val_13009 === (7))){
var inst_13004 = (state_13008[(2)]);
var state_13008__$1 = state_13008;
var statearr_13010_13026 = state_13008__$1;
(statearr_13010_13026[(2)] = inst_13004);

(statearr_13010_13026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13009 === (6))){
var inst_12994 = (state_13008[(7)]);
var inst_12997 = (state_13008[(8)]);
var inst_13001 = f.call(null,inst_12994,inst_12997);
var inst_12994__$1 = inst_13001;
var state_13008__$1 = (function (){var statearr_13011 = state_13008;
(statearr_13011[(7)] = inst_12994__$1);

return statearr_13011;
})();
var statearr_13012_13027 = state_13008__$1;
(statearr_13012_13027[(2)] = null);

(statearr_13012_13027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13009 === (5))){
var inst_12994 = (state_13008[(7)]);
var state_13008__$1 = state_13008;
var statearr_13013_13028 = state_13008__$1;
(statearr_13013_13028[(2)] = inst_12994);

(statearr_13013_13028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13009 === (4))){
var inst_12997 = (state_13008[(8)]);
var inst_12997__$1 = (state_13008[(2)]);
var inst_12998 = (inst_12997__$1 == null);
var state_13008__$1 = (function (){var statearr_13014 = state_13008;
(statearr_13014[(8)] = inst_12997__$1);

return statearr_13014;
})();
if(cljs.core.truth_(inst_12998)){
var statearr_13015_13029 = state_13008__$1;
(statearr_13015_13029[(1)] = (5));

} else {
var statearr_13016_13030 = state_13008__$1;
(statearr_13016_13030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13009 === (3))){
var inst_13006 = (state_13008[(2)]);
var state_13008__$1 = state_13008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13008__$1,inst_13006);
} else {
if((state_val_13009 === (2))){
var state_13008__$1 = state_13008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13008__$1,(4),ch);
} else {
if((state_val_13009 === (1))){
var inst_12994 = init;
var state_13008__$1 = (function (){var statearr_13017 = state_13008;
(statearr_13017[(7)] = inst_12994);

return statearr_13017;
})();
var statearr_13018_13031 = state_13008__$1;
(statearr_13018_13031[(2)] = null);

(statearr_13018_13031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_13022 = [null,null,null,null,null,null,null,null,null];
(statearr_13022[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_13022[(1)] = (1));

return statearr_13022;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_13008){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13023){if((e13023 instanceof Object)){
var ex__7651__auto__ = e13023;
var statearr_13024_13032 = state_13008;
(statearr_13024_13032[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13008);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13033 = state_13008;
state_13008 = G__13033;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_13008){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_13008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13025 = f__7710__auto__.call(null);
(statearr_13025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__13035 = arguments.length;
switch (G__13035) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_13060){
var state_val_13061 = (state_13060[(1)]);
if((state_val_13061 === (7))){
var inst_13042 = (state_13060[(2)]);
var state_13060__$1 = state_13060;
var statearr_13062_13086 = state_13060__$1;
(statearr_13062_13086[(2)] = inst_13042);

(statearr_13062_13086[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (1))){
var inst_13036 = cljs.core.seq.call(null,coll);
var inst_13037 = inst_13036;
var state_13060__$1 = (function (){var statearr_13063 = state_13060;
(statearr_13063[(7)] = inst_13037);

return statearr_13063;
})();
var statearr_13064_13087 = state_13060__$1;
(statearr_13064_13087[(2)] = null);

(statearr_13064_13087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (4))){
var inst_13037 = (state_13060[(7)]);
var inst_13040 = cljs.core.first.call(null,inst_13037);
var state_13060__$1 = state_13060;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13060__$1,(7),ch,inst_13040);
} else {
if((state_val_13061 === (13))){
var inst_13054 = (state_13060[(2)]);
var state_13060__$1 = state_13060;
var statearr_13065_13088 = state_13060__$1;
(statearr_13065_13088[(2)] = inst_13054);

(statearr_13065_13088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (6))){
var inst_13045 = (state_13060[(2)]);
var state_13060__$1 = state_13060;
if(cljs.core.truth_(inst_13045)){
var statearr_13066_13089 = state_13060__$1;
(statearr_13066_13089[(1)] = (8));

} else {
var statearr_13067_13090 = state_13060__$1;
(statearr_13067_13090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (3))){
var inst_13058 = (state_13060[(2)]);
var state_13060__$1 = state_13060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13060__$1,inst_13058);
} else {
if((state_val_13061 === (12))){
var state_13060__$1 = state_13060;
var statearr_13068_13091 = state_13060__$1;
(statearr_13068_13091[(2)] = null);

(statearr_13068_13091[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (2))){
var inst_13037 = (state_13060[(7)]);
var state_13060__$1 = state_13060;
if(cljs.core.truth_(inst_13037)){
var statearr_13069_13092 = state_13060__$1;
(statearr_13069_13092[(1)] = (4));

} else {
var statearr_13070_13093 = state_13060__$1;
(statearr_13070_13093[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (11))){
var inst_13051 = cljs.core.async.close_BANG_.call(null,ch);
var state_13060__$1 = state_13060;
var statearr_13071_13094 = state_13060__$1;
(statearr_13071_13094[(2)] = inst_13051);

(statearr_13071_13094[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (9))){
var state_13060__$1 = state_13060;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13072_13095 = state_13060__$1;
(statearr_13072_13095[(1)] = (11));

} else {
var statearr_13073_13096 = state_13060__$1;
(statearr_13073_13096[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (5))){
var inst_13037 = (state_13060[(7)]);
var state_13060__$1 = state_13060;
var statearr_13074_13097 = state_13060__$1;
(statearr_13074_13097[(2)] = inst_13037);

(statearr_13074_13097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (10))){
var inst_13056 = (state_13060[(2)]);
var state_13060__$1 = state_13060;
var statearr_13075_13098 = state_13060__$1;
(statearr_13075_13098[(2)] = inst_13056);

(statearr_13075_13098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13061 === (8))){
var inst_13037 = (state_13060[(7)]);
var inst_13047 = cljs.core.next.call(null,inst_13037);
var inst_13037__$1 = inst_13047;
var state_13060__$1 = (function (){var statearr_13076 = state_13060;
(statearr_13076[(7)] = inst_13037__$1);

return statearr_13076;
})();
var statearr_13077_13099 = state_13060__$1;
(statearr_13077_13099[(2)] = null);

(statearr_13077_13099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_13081 = [null,null,null,null,null,null,null,null];
(statearr_13081[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_13081[(1)] = (1));

return statearr_13081;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13060){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13082){if((e13082 instanceof Object)){
var ex__7651__auto__ = e13082;
var statearr_13083_13100 = state_13060;
(statearr_13083_13100[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13082;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13101 = state_13060;
state_13060 = G__13101;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13060){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_13084 = f__7710__auto__.call(null);
(statearr_13084[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_13084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj13103 = {};
return obj13103;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj13105 = {};
return obj13105;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t13327 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13327 = (function (cs,ch,mult,meta13328){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta13328 = meta13328;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13327.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t13327.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t13327.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t13327.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t13327.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13327.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t13327.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13329){
var self__ = this;
var _13329__$1 = this;
return self__.meta13328;
});})(cs))
;

cljs.core.async.t13327.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13329,meta13328__$1){
var self__ = this;
var _13329__$1 = this;
return (new cljs.core.async.t13327(self__.cs,self__.ch,self__.mult,meta13328__$1));
});})(cs))
;

cljs.core.async.t13327.cljs$lang$type = true;

cljs.core.async.t13327.cljs$lang$ctorStr = "cljs.core.async/t13327";

cljs.core.async.t13327.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13327");
});})(cs))
;

cljs.core.async.__GT_t13327 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t13327(cs__$1,ch__$1,mult__$1,meta13328){
return (new cljs.core.async.t13327(cs__$1,ch__$1,mult__$1,meta13328));
});})(cs))
;

}

return (new cljs.core.async.t13327(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___13548 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13548,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13548,cs,m,dchan,dctr,done){
return (function (state_13460){
var state_val_13461 = (state_13460[(1)]);
if((state_val_13461 === (7))){
var inst_13456 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13462_13549 = state_13460__$1;
(statearr_13462_13549[(2)] = inst_13456);

(statearr_13462_13549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (20))){
var inst_13361 = (state_13460[(7)]);
var inst_13371 = cljs.core.first.call(null,inst_13361);
var inst_13372 = cljs.core.nth.call(null,inst_13371,(0),null);
var inst_13373 = cljs.core.nth.call(null,inst_13371,(1),null);
var state_13460__$1 = (function (){var statearr_13463 = state_13460;
(statearr_13463[(8)] = inst_13372);

return statearr_13463;
})();
if(cljs.core.truth_(inst_13373)){
var statearr_13464_13550 = state_13460__$1;
(statearr_13464_13550[(1)] = (22));

} else {
var statearr_13465_13551 = state_13460__$1;
(statearr_13465_13551[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (27))){
var inst_13408 = (state_13460[(9)]);
var inst_13332 = (state_13460[(10)]);
var inst_13403 = (state_13460[(11)]);
var inst_13401 = (state_13460[(12)]);
var inst_13408__$1 = cljs.core._nth.call(null,inst_13401,inst_13403);
var inst_13409 = cljs.core.async.put_BANG_.call(null,inst_13408__$1,inst_13332,done);
var state_13460__$1 = (function (){var statearr_13466 = state_13460;
(statearr_13466[(9)] = inst_13408__$1);

return statearr_13466;
})();
if(cljs.core.truth_(inst_13409)){
var statearr_13467_13552 = state_13460__$1;
(statearr_13467_13552[(1)] = (30));

} else {
var statearr_13468_13553 = state_13460__$1;
(statearr_13468_13553[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (1))){
var state_13460__$1 = state_13460;
var statearr_13469_13554 = state_13460__$1;
(statearr_13469_13554[(2)] = null);

(statearr_13469_13554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (24))){
var inst_13361 = (state_13460[(7)]);
var inst_13378 = (state_13460[(2)]);
var inst_13379 = cljs.core.next.call(null,inst_13361);
var inst_13341 = inst_13379;
var inst_13342 = null;
var inst_13343 = (0);
var inst_13344 = (0);
var state_13460__$1 = (function (){var statearr_13470 = state_13460;
(statearr_13470[(13)] = inst_13342);

(statearr_13470[(14)] = inst_13341);

(statearr_13470[(15)] = inst_13343);

(statearr_13470[(16)] = inst_13344);

(statearr_13470[(17)] = inst_13378);

return statearr_13470;
})();
var statearr_13471_13555 = state_13460__$1;
(statearr_13471_13555[(2)] = null);

(statearr_13471_13555[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (39))){
var state_13460__$1 = state_13460;
var statearr_13475_13556 = state_13460__$1;
(statearr_13475_13556[(2)] = null);

(statearr_13475_13556[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (4))){
var inst_13332 = (state_13460[(10)]);
var inst_13332__$1 = (state_13460[(2)]);
var inst_13333 = (inst_13332__$1 == null);
var state_13460__$1 = (function (){var statearr_13476 = state_13460;
(statearr_13476[(10)] = inst_13332__$1);

return statearr_13476;
})();
if(cljs.core.truth_(inst_13333)){
var statearr_13477_13557 = state_13460__$1;
(statearr_13477_13557[(1)] = (5));

} else {
var statearr_13478_13558 = state_13460__$1;
(statearr_13478_13558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (15))){
var inst_13342 = (state_13460[(13)]);
var inst_13341 = (state_13460[(14)]);
var inst_13343 = (state_13460[(15)]);
var inst_13344 = (state_13460[(16)]);
var inst_13357 = (state_13460[(2)]);
var inst_13358 = (inst_13344 + (1));
var tmp13472 = inst_13342;
var tmp13473 = inst_13341;
var tmp13474 = inst_13343;
var inst_13341__$1 = tmp13473;
var inst_13342__$1 = tmp13472;
var inst_13343__$1 = tmp13474;
var inst_13344__$1 = inst_13358;
var state_13460__$1 = (function (){var statearr_13479 = state_13460;
(statearr_13479[(13)] = inst_13342__$1);

(statearr_13479[(14)] = inst_13341__$1);

(statearr_13479[(15)] = inst_13343__$1);

(statearr_13479[(16)] = inst_13344__$1);

(statearr_13479[(18)] = inst_13357);

return statearr_13479;
})();
var statearr_13480_13559 = state_13460__$1;
(statearr_13480_13559[(2)] = null);

(statearr_13480_13559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (21))){
var inst_13382 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13484_13560 = state_13460__$1;
(statearr_13484_13560[(2)] = inst_13382);

(statearr_13484_13560[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (31))){
var inst_13408 = (state_13460[(9)]);
var inst_13412 = done.call(null,null);
var inst_13413 = cljs.core.async.untap_STAR_.call(null,m,inst_13408);
var state_13460__$1 = (function (){var statearr_13485 = state_13460;
(statearr_13485[(19)] = inst_13412);

return statearr_13485;
})();
var statearr_13486_13561 = state_13460__$1;
(statearr_13486_13561[(2)] = inst_13413);

(statearr_13486_13561[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (32))){
var inst_13402 = (state_13460[(20)]);
var inst_13400 = (state_13460[(21)]);
var inst_13403 = (state_13460[(11)]);
var inst_13401 = (state_13460[(12)]);
var inst_13415 = (state_13460[(2)]);
var inst_13416 = (inst_13403 + (1));
var tmp13481 = inst_13402;
var tmp13482 = inst_13400;
var tmp13483 = inst_13401;
var inst_13400__$1 = tmp13482;
var inst_13401__$1 = tmp13483;
var inst_13402__$1 = tmp13481;
var inst_13403__$1 = inst_13416;
var state_13460__$1 = (function (){var statearr_13487 = state_13460;
(statearr_13487[(20)] = inst_13402__$1);

(statearr_13487[(22)] = inst_13415);

(statearr_13487[(21)] = inst_13400__$1);

(statearr_13487[(11)] = inst_13403__$1);

(statearr_13487[(12)] = inst_13401__$1);

return statearr_13487;
})();
var statearr_13488_13562 = state_13460__$1;
(statearr_13488_13562[(2)] = null);

(statearr_13488_13562[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (40))){
var inst_13428 = (state_13460[(23)]);
var inst_13432 = done.call(null,null);
var inst_13433 = cljs.core.async.untap_STAR_.call(null,m,inst_13428);
var state_13460__$1 = (function (){var statearr_13489 = state_13460;
(statearr_13489[(24)] = inst_13432);

return statearr_13489;
})();
var statearr_13490_13563 = state_13460__$1;
(statearr_13490_13563[(2)] = inst_13433);

(statearr_13490_13563[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (33))){
var inst_13419 = (state_13460[(25)]);
var inst_13421 = cljs.core.chunked_seq_QMARK_.call(null,inst_13419);
var state_13460__$1 = state_13460;
if(inst_13421){
var statearr_13491_13564 = state_13460__$1;
(statearr_13491_13564[(1)] = (36));

} else {
var statearr_13492_13565 = state_13460__$1;
(statearr_13492_13565[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (13))){
var inst_13351 = (state_13460[(26)]);
var inst_13354 = cljs.core.async.close_BANG_.call(null,inst_13351);
var state_13460__$1 = state_13460;
var statearr_13493_13566 = state_13460__$1;
(statearr_13493_13566[(2)] = inst_13354);

(statearr_13493_13566[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (22))){
var inst_13372 = (state_13460[(8)]);
var inst_13375 = cljs.core.async.close_BANG_.call(null,inst_13372);
var state_13460__$1 = state_13460;
var statearr_13494_13567 = state_13460__$1;
(statearr_13494_13567[(2)] = inst_13375);

(statearr_13494_13567[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (36))){
var inst_13419 = (state_13460[(25)]);
var inst_13423 = cljs.core.chunk_first.call(null,inst_13419);
var inst_13424 = cljs.core.chunk_rest.call(null,inst_13419);
var inst_13425 = cljs.core.count.call(null,inst_13423);
var inst_13400 = inst_13424;
var inst_13401 = inst_13423;
var inst_13402 = inst_13425;
var inst_13403 = (0);
var state_13460__$1 = (function (){var statearr_13495 = state_13460;
(statearr_13495[(20)] = inst_13402);

(statearr_13495[(21)] = inst_13400);

(statearr_13495[(11)] = inst_13403);

(statearr_13495[(12)] = inst_13401);

return statearr_13495;
})();
var statearr_13496_13568 = state_13460__$1;
(statearr_13496_13568[(2)] = null);

(statearr_13496_13568[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (41))){
var inst_13419 = (state_13460[(25)]);
var inst_13435 = (state_13460[(2)]);
var inst_13436 = cljs.core.next.call(null,inst_13419);
var inst_13400 = inst_13436;
var inst_13401 = null;
var inst_13402 = (0);
var inst_13403 = (0);
var state_13460__$1 = (function (){var statearr_13497 = state_13460;
(statearr_13497[(20)] = inst_13402);

(statearr_13497[(21)] = inst_13400);

(statearr_13497[(11)] = inst_13403);

(statearr_13497[(12)] = inst_13401);

(statearr_13497[(27)] = inst_13435);

return statearr_13497;
})();
var statearr_13498_13569 = state_13460__$1;
(statearr_13498_13569[(2)] = null);

(statearr_13498_13569[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (43))){
var state_13460__$1 = state_13460;
var statearr_13499_13570 = state_13460__$1;
(statearr_13499_13570[(2)] = null);

(statearr_13499_13570[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (29))){
var inst_13444 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13500_13571 = state_13460__$1;
(statearr_13500_13571[(2)] = inst_13444);

(statearr_13500_13571[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (44))){
var inst_13453 = (state_13460[(2)]);
var state_13460__$1 = (function (){var statearr_13501 = state_13460;
(statearr_13501[(28)] = inst_13453);

return statearr_13501;
})();
var statearr_13502_13572 = state_13460__$1;
(statearr_13502_13572[(2)] = null);

(statearr_13502_13572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (6))){
var inst_13392 = (state_13460[(29)]);
var inst_13391 = cljs.core.deref.call(null,cs);
var inst_13392__$1 = cljs.core.keys.call(null,inst_13391);
var inst_13393 = cljs.core.count.call(null,inst_13392__$1);
var inst_13394 = cljs.core.reset_BANG_.call(null,dctr,inst_13393);
var inst_13399 = cljs.core.seq.call(null,inst_13392__$1);
var inst_13400 = inst_13399;
var inst_13401 = null;
var inst_13402 = (0);
var inst_13403 = (0);
var state_13460__$1 = (function (){var statearr_13503 = state_13460;
(statearr_13503[(30)] = inst_13394);

(statearr_13503[(20)] = inst_13402);

(statearr_13503[(21)] = inst_13400);

(statearr_13503[(11)] = inst_13403);

(statearr_13503[(12)] = inst_13401);

(statearr_13503[(29)] = inst_13392__$1);

return statearr_13503;
})();
var statearr_13504_13573 = state_13460__$1;
(statearr_13504_13573[(2)] = null);

(statearr_13504_13573[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (28))){
var inst_13419 = (state_13460[(25)]);
var inst_13400 = (state_13460[(21)]);
var inst_13419__$1 = cljs.core.seq.call(null,inst_13400);
var state_13460__$1 = (function (){var statearr_13505 = state_13460;
(statearr_13505[(25)] = inst_13419__$1);

return statearr_13505;
})();
if(inst_13419__$1){
var statearr_13506_13574 = state_13460__$1;
(statearr_13506_13574[(1)] = (33));

} else {
var statearr_13507_13575 = state_13460__$1;
(statearr_13507_13575[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (25))){
var inst_13402 = (state_13460[(20)]);
var inst_13403 = (state_13460[(11)]);
var inst_13405 = (inst_13403 < inst_13402);
var inst_13406 = inst_13405;
var state_13460__$1 = state_13460;
if(cljs.core.truth_(inst_13406)){
var statearr_13508_13576 = state_13460__$1;
(statearr_13508_13576[(1)] = (27));

} else {
var statearr_13509_13577 = state_13460__$1;
(statearr_13509_13577[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (34))){
var state_13460__$1 = state_13460;
var statearr_13510_13578 = state_13460__$1;
(statearr_13510_13578[(2)] = null);

(statearr_13510_13578[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (17))){
var state_13460__$1 = state_13460;
var statearr_13511_13579 = state_13460__$1;
(statearr_13511_13579[(2)] = null);

(statearr_13511_13579[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (3))){
var inst_13458 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13460__$1,inst_13458);
} else {
if((state_val_13461 === (12))){
var inst_13387 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13512_13580 = state_13460__$1;
(statearr_13512_13580[(2)] = inst_13387);

(statearr_13512_13580[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (2))){
var state_13460__$1 = state_13460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13460__$1,(4),ch);
} else {
if((state_val_13461 === (23))){
var state_13460__$1 = state_13460;
var statearr_13513_13581 = state_13460__$1;
(statearr_13513_13581[(2)] = null);

(statearr_13513_13581[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (35))){
var inst_13442 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13514_13582 = state_13460__$1;
(statearr_13514_13582[(2)] = inst_13442);

(statearr_13514_13582[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (19))){
var inst_13361 = (state_13460[(7)]);
var inst_13365 = cljs.core.chunk_first.call(null,inst_13361);
var inst_13366 = cljs.core.chunk_rest.call(null,inst_13361);
var inst_13367 = cljs.core.count.call(null,inst_13365);
var inst_13341 = inst_13366;
var inst_13342 = inst_13365;
var inst_13343 = inst_13367;
var inst_13344 = (0);
var state_13460__$1 = (function (){var statearr_13515 = state_13460;
(statearr_13515[(13)] = inst_13342);

(statearr_13515[(14)] = inst_13341);

(statearr_13515[(15)] = inst_13343);

(statearr_13515[(16)] = inst_13344);

return statearr_13515;
})();
var statearr_13516_13583 = state_13460__$1;
(statearr_13516_13583[(2)] = null);

(statearr_13516_13583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (11))){
var inst_13341 = (state_13460[(14)]);
var inst_13361 = (state_13460[(7)]);
var inst_13361__$1 = cljs.core.seq.call(null,inst_13341);
var state_13460__$1 = (function (){var statearr_13517 = state_13460;
(statearr_13517[(7)] = inst_13361__$1);

return statearr_13517;
})();
if(inst_13361__$1){
var statearr_13518_13584 = state_13460__$1;
(statearr_13518_13584[(1)] = (16));

} else {
var statearr_13519_13585 = state_13460__$1;
(statearr_13519_13585[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (9))){
var inst_13389 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13520_13586 = state_13460__$1;
(statearr_13520_13586[(2)] = inst_13389);

(statearr_13520_13586[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (5))){
var inst_13339 = cljs.core.deref.call(null,cs);
var inst_13340 = cljs.core.seq.call(null,inst_13339);
var inst_13341 = inst_13340;
var inst_13342 = null;
var inst_13343 = (0);
var inst_13344 = (0);
var state_13460__$1 = (function (){var statearr_13521 = state_13460;
(statearr_13521[(13)] = inst_13342);

(statearr_13521[(14)] = inst_13341);

(statearr_13521[(15)] = inst_13343);

(statearr_13521[(16)] = inst_13344);

return statearr_13521;
})();
var statearr_13522_13587 = state_13460__$1;
(statearr_13522_13587[(2)] = null);

(statearr_13522_13587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (14))){
var state_13460__$1 = state_13460;
var statearr_13523_13588 = state_13460__$1;
(statearr_13523_13588[(2)] = null);

(statearr_13523_13588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (45))){
var inst_13450 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13524_13589 = state_13460__$1;
(statearr_13524_13589[(2)] = inst_13450);

(statearr_13524_13589[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (26))){
var inst_13392 = (state_13460[(29)]);
var inst_13446 = (state_13460[(2)]);
var inst_13447 = cljs.core.seq.call(null,inst_13392);
var state_13460__$1 = (function (){var statearr_13525 = state_13460;
(statearr_13525[(31)] = inst_13446);

return statearr_13525;
})();
if(inst_13447){
var statearr_13526_13590 = state_13460__$1;
(statearr_13526_13590[(1)] = (42));

} else {
var statearr_13527_13591 = state_13460__$1;
(statearr_13527_13591[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (16))){
var inst_13361 = (state_13460[(7)]);
var inst_13363 = cljs.core.chunked_seq_QMARK_.call(null,inst_13361);
var state_13460__$1 = state_13460;
if(inst_13363){
var statearr_13528_13592 = state_13460__$1;
(statearr_13528_13592[(1)] = (19));

} else {
var statearr_13529_13593 = state_13460__$1;
(statearr_13529_13593[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (38))){
var inst_13439 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13530_13594 = state_13460__$1;
(statearr_13530_13594[(2)] = inst_13439);

(statearr_13530_13594[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (30))){
var state_13460__$1 = state_13460;
var statearr_13531_13595 = state_13460__$1;
(statearr_13531_13595[(2)] = null);

(statearr_13531_13595[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (10))){
var inst_13342 = (state_13460[(13)]);
var inst_13344 = (state_13460[(16)]);
var inst_13350 = cljs.core._nth.call(null,inst_13342,inst_13344);
var inst_13351 = cljs.core.nth.call(null,inst_13350,(0),null);
var inst_13352 = cljs.core.nth.call(null,inst_13350,(1),null);
var state_13460__$1 = (function (){var statearr_13532 = state_13460;
(statearr_13532[(26)] = inst_13351);

return statearr_13532;
})();
if(cljs.core.truth_(inst_13352)){
var statearr_13533_13596 = state_13460__$1;
(statearr_13533_13596[(1)] = (13));

} else {
var statearr_13534_13597 = state_13460__$1;
(statearr_13534_13597[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (18))){
var inst_13385 = (state_13460[(2)]);
var state_13460__$1 = state_13460;
var statearr_13535_13598 = state_13460__$1;
(statearr_13535_13598[(2)] = inst_13385);

(statearr_13535_13598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (42))){
var state_13460__$1 = state_13460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13460__$1,(45),dchan);
} else {
if((state_val_13461 === (37))){
var inst_13419 = (state_13460[(25)]);
var inst_13332 = (state_13460[(10)]);
var inst_13428 = (state_13460[(23)]);
var inst_13428__$1 = cljs.core.first.call(null,inst_13419);
var inst_13429 = cljs.core.async.put_BANG_.call(null,inst_13428__$1,inst_13332,done);
var state_13460__$1 = (function (){var statearr_13536 = state_13460;
(statearr_13536[(23)] = inst_13428__$1);

return statearr_13536;
})();
if(cljs.core.truth_(inst_13429)){
var statearr_13537_13599 = state_13460__$1;
(statearr_13537_13599[(1)] = (39));

} else {
var statearr_13538_13600 = state_13460__$1;
(statearr_13538_13600[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13461 === (8))){
var inst_13343 = (state_13460[(15)]);
var inst_13344 = (state_13460[(16)]);
var inst_13346 = (inst_13344 < inst_13343);
var inst_13347 = inst_13346;
var state_13460__$1 = state_13460;
if(cljs.core.truth_(inst_13347)){
var statearr_13539_13601 = state_13460__$1;
(statearr_13539_13601[(1)] = (10));

} else {
var statearr_13540_13602 = state_13460__$1;
(statearr_13540_13602[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13548,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___13548,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_13544 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13544[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_13544[(1)] = (1));

return statearr_13544;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_13460){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13545){if((e13545 instanceof Object)){
var ex__7651__auto__ = e13545;
var statearr_13546_13603 = state_13460;
(statearr_13546_13603[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13545;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13604 = state_13460;
state_13460 = G__13604;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_13460){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_13460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13548,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_13547 = f__7710__auto__.call(null);
(statearr_13547[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13548);

return statearr_13547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13548,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__13606 = arguments.length;
switch (G__13606) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

cljs.core.async.Mix = (function (){var obj13609 = {};
return obj13609;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13614){
var map__13615 = p__13614;
var map__13615__$1 = ((cljs.core.seq_QMARK_.call(null,map__13615))?cljs.core.apply.call(null,cljs.core.hash_map,map__13615):map__13615);
var opts = map__13615__$1;
var statearr_13616_13619 = state;
(statearr_13616_13619[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts.call(null,((function (map__13615,map__13615__$1,opts){
return (function (val){
var statearr_13617_13620 = state;
(statearr_13617_13620[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13615,map__13615__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_13618_13621 = state;
(statearr_13618_13621[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13610){
var G__13611 = cljs.core.first.call(null,seq13610);
var seq13610__$1 = cljs.core.next.call(null,seq13610);
var G__13612 = cljs.core.first.call(null,seq13610__$1);
var seq13610__$2 = cljs.core.next.call(null,seq13610__$1);
var G__13613 = cljs.core.first.call(null,seq13610__$2);
var seq13610__$3 = cljs.core.next.call(null,seq13610__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13611,G__13612,G__13613,seq13610__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t13741 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13741 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13742){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13742 = meta13742;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13741.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t13741.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13741.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13743){
var self__ = this;
var _13743__$1 = this;
return self__.meta13742;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13743,meta13742__$1){
var self__ = this;
var _13743__$1 = this;
return (new cljs.core.async.t13741(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13742__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t13741.cljs$lang$type = true;

cljs.core.async.t13741.cljs$lang$ctorStr = "cljs.core.async/t13741";

cljs.core.async.t13741.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13741");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t13741 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t13741(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13742){
return (new cljs.core.async.t13741(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13742));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t13741(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___13860 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13813){
var state_val_13814 = (state_13813[(1)]);
if((state_val_13814 === (7))){
var inst_13757 = (state_13813[(7)]);
var inst_13762 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13757);
var state_13813__$1 = state_13813;
var statearr_13815_13861 = state_13813__$1;
(statearr_13815_13861[(2)] = inst_13762);

(statearr_13815_13861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (20))){
var inst_13772 = (state_13813[(8)]);
var state_13813__$1 = state_13813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13813__$1,(23),out,inst_13772);
} else {
if((state_val_13814 === (1))){
var inst_13747 = (state_13813[(9)]);
var inst_13747__$1 = calc_state.call(null);
var inst_13748 = cljs.core.seq_QMARK_.call(null,inst_13747__$1);
var state_13813__$1 = (function (){var statearr_13816 = state_13813;
(statearr_13816[(9)] = inst_13747__$1);

return statearr_13816;
})();
if(inst_13748){
var statearr_13817_13862 = state_13813__$1;
(statearr_13817_13862[(1)] = (2));

} else {
var statearr_13818_13863 = state_13813__$1;
(statearr_13818_13863[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (24))){
var inst_13765 = (state_13813[(10)]);
var inst_13757 = inst_13765;
var state_13813__$1 = (function (){var statearr_13819 = state_13813;
(statearr_13819[(7)] = inst_13757);

return statearr_13819;
})();
var statearr_13820_13864 = state_13813__$1;
(statearr_13820_13864[(2)] = null);

(statearr_13820_13864[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (4))){
var inst_13747 = (state_13813[(9)]);
var inst_13753 = (state_13813[(2)]);
var inst_13754 = cljs.core.get.call(null,inst_13753,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13755 = cljs.core.get.call(null,inst_13753,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13756 = cljs.core.get.call(null,inst_13753,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13757 = inst_13747;
var state_13813__$1 = (function (){var statearr_13821 = state_13813;
(statearr_13821[(7)] = inst_13757);

(statearr_13821[(11)] = inst_13755);

(statearr_13821[(12)] = inst_13756);

(statearr_13821[(13)] = inst_13754);

return statearr_13821;
})();
var statearr_13822_13865 = state_13813__$1;
(statearr_13822_13865[(2)] = null);

(statearr_13822_13865[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (15))){
var state_13813__$1 = state_13813;
var statearr_13823_13866 = state_13813__$1;
(statearr_13823_13866[(2)] = null);

(statearr_13823_13866[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (21))){
var inst_13765 = (state_13813[(10)]);
var inst_13757 = inst_13765;
var state_13813__$1 = (function (){var statearr_13824 = state_13813;
(statearr_13824[(7)] = inst_13757);

return statearr_13824;
})();
var statearr_13825_13867 = state_13813__$1;
(statearr_13825_13867[(2)] = null);

(statearr_13825_13867[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (13))){
var inst_13809 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
var statearr_13826_13868 = state_13813__$1;
(statearr_13826_13868[(2)] = inst_13809);

(statearr_13826_13868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (22))){
var inst_13807 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
var statearr_13827_13869 = state_13813__$1;
(statearr_13827_13869[(2)] = inst_13807);

(statearr_13827_13869[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (6))){
var inst_13811 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13813__$1,inst_13811);
} else {
if((state_val_13814 === (25))){
var state_13813__$1 = state_13813;
var statearr_13828_13870 = state_13813__$1;
(statearr_13828_13870[(2)] = null);

(statearr_13828_13870[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (17))){
var inst_13787 = (state_13813[(14)]);
var state_13813__$1 = state_13813;
var statearr_13829_13871 = state_13813__$1;
(statearr_13829_13871[(2)] = inst_13787);

(statearr_13829_13871[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (3))){
var inst_13747 = (state_13813[(9)]);
var state_13813__$1 = state_13813;
var statearr_13830_13872 = state_13813__$1;
(statearr_13830_13872[(2)] = inst_13747);

(statearr_13830_13872[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (12))){
var inst_13773 = (state_13813[(15)]);
var inst_13787 = (state_13813[(14)]);
var inst_13768 = (state_13813[(16)]);
var inst_13787__$1 = inst_13768.call(null,inst_13773);
var state_13813__$1 = (function (){var statearr_13831 = state_13813;
(statearr_13831[(14)] = inst_13787__$1);

return statearr_13831;
})();
if(cljs.core.truth_(inst_13787__$1)){
var statearr_13832_13873 = state_13813__$1;
(statearr_13832_13873[(1)] = (17));

} else {
var statearr_13833_13874 = state_13813__$1;
(statearr_13833_13874[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (2))){
var inst_13747 = (state_13813[(9)]);
var inst_13750 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13747);
var state_13813__$1 = state_13813;
var statearr_13834_13875 = state_13813__$1;
(statearr_13834_13875[(2)] = inst_13750);

(statearr_13834_13875[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (23))){
var inst_13798 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
if(cljs.core.truth_(inst_13798)){
var statearr_13835_13876 = state_13813__$1;
(statearr_13835_13876[(1)] = (24));

} else {
var statearr_13836_13877 = state_13813__$1;
(statearr_13836_13877[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (19))){
var inst_13795 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
if(cljs.core.truth_(inst_13795)){
var statearr_13837_13878 = state_13813__$1;
(statearr_13837_13878[(1)] = (20));

} else {
var statearr_13838_13879 = state_13813__$1;
(statearr_13838_13879[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (11))){
var inst_13772 = (state_13813[(8)]);
var inst_13778 = (inst_13772 == null);
var state_13813__$1 = state_13813;
if(cljs.core.truth_(inst_13778)){
var statearr_13839_13880 = state_13813__$1;
(statearr_13839_13880[(1)] = (14));

} else {
var statearr_13840_13881 = state_13813__$1;
(statearr_13840_13881[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (9))){
var inst_13765 = (state_13813[(10)]);
var inst_13765__$1 = (state_13813[(2)]);
var inst_13766 = cljs.core.get.call(null,inst_13765__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13767 = cljs.core.get.call(null,inst_13765__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13768 = cljs.core.get.call(null,inst_13765__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var state_13813__$1 = (function (){var statearr_13841 = state_13813;
(statearr_13841[(10)] = inst_13765__$1);

(statearr_13841[(17)] = inst_13767);

(statearr_13841[(16)] = inst_13768);

return statearr_13841;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13813__$1,(10),inst_13766);
} else {
if((state_val_13814 === (5))){
var inst_13757 = (state_13813[(7)]);
var inst_13760 = cljs.core.seq_QMARK_.call(null,inst_13757);
var state_13813__$1 = state_13813;
if(inst_13760){
var statearr_13842_13882 = state_13813__$1;
(statearr_13842_13882[(1)] = (7));

} else {
var statearr_13843_13883 = state_13813__$1;
(statearr_13843_13883[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (14))){
var inst_13773 = (state_13813[(15)]);
var inst_13780 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13773);
var state_13813__$1 = state_13813;
var statearr_13844_13884 = state_13813__$1;
(statearr_13844_13884[(2)] = inst_13780);

(statearr_13844_13884[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (26))){
var inst_13803 = (state_13813[(2)]);
var state_13813__$1 = state_13813;
var statearr_13845_13885 = state_13813__$1;
(statearr_13845_13885[(2)] = inst_13803);

(statearr_13845_13885[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (16))){
var inst_13783 = (state_13813[(2)]);
var inst_13784 = calc_state.call(null);
var inst_13757 = inst_13784;
var state_13813__$1 = (function (){var statearr_13846 = state_13813;
(statearr_13846[(7)] = inst_13757);

(statearr_13846[(18)] = inst_13783);

return statearr_13846;
})();
var statearr_13847_13886 = state_13813__$1;
(statearr_13847_13886[(2)] = null);

(statearr_13847_13886[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (10))){
var inst_13773 = (state_13813[(15)]);
var inst_13772 = (state_13813[(8)]);
var inst_13771 = (state_13813[(2)]);
var inst_13772__$1 = cljs.core.nth.call(null,inst_13771,(0),null);
var inst_13773__$1 = cljs.core.nth.call(null,inst_13771,(1),null);
var inst_13774 = (inst_13772__$1 == null);
var inst_13775 = cljs.core._EQ_.call(null,inst_13773__$1,change);
var inst_13776 = (inst_13774) || (inst_13775);
var state_13813__$1 = (function (){var statearr_13848 = state_13813;
(statearr_13848[(15)] = inst_13773__$1);

(statearr_13848[(8)] = inst_13772__$1);

return statearr_13848;
})();
if(cljs.core.truth_(inst_13776)){
var statearr_13849_13887 = state_13813__$1;
(statearr_13849_13887[(1)] = (11));

} else {
var statearr_13850_13888 = state_13813__$1;
(statearr_13850_13888[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (18))){
var inst_13773 = (state_13813[(15)]);
var inst_13767 = (state_13813[(17)]);
var inst_13768 = (state_13813[(16)]);
var inst_13790 = cljs.core.empty_QMARK_.call(null,inst_13768);
var inst_13791 = inst_13767.call(null,inst_13773);
var inst_13792 = cljs.core.not.call(null,inst_13791);
var inst_13793 = (inst_13790) && (inst_13792);
var state_13813__$1 = state_13813;
var statearr_13851_13889 = state_13813__$1;
(statearr_13851_13889[(2)] = inst_13793);

(statearr_13851_13889[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13814 === (8))){
var inst_13757 = (state_13813[(7)]);
var state_13813__$1 = state_13813;
var statearr_13852_13890 = state_13813__$1;
(statearr_13852_13890[(2)] = inst_13757);

(statearr_13852_13890[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_13856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13856[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_13856[(1)] = (1));

return statearr_13856;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_13813){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e13857){if((e13857 instanceof Object)){
var ex__7651__auto__ = e13857;
var statearr_13858_13891 = state_13813;
(statearr_13858_13891[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13857;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13892 = state_13813;
state_13813 = G__13892;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_13813){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_13813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_13859 = f__7710__auto__.call(null);
(statearr_13859[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___13860);

return statearr_13859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___13860,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

cljs.core.async.Pub = (function (){var obj13894 = {};
return obj13894;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__13896 = arguments.length;
switch (G__13896) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4912__auto__)]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__13900 = arguments.length;
switch (G__13900) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4276__auto__,mults){
return (function (p1__13898_SHARP_){
if(cljs.core.truth_(p1__13898_SHARP_.call(null,topic))){
return p1__13898_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13898_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t13901 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t13901 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta13902){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta13902 = meta13902;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t13901.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t13901.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t13901.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13903){
var self__ = this;
var _13903__$1 = this;
return self__.meta13902;
});})(mults,ensure_mult))
;

cljs.core.async.t13901.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13903,meta13902__$1){
var self__ = this;
var _13903__$1 = this;
return (new cljs.core.async.t13901(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta13902__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t13901.cljs$lang$type = true;

cljs.core.async.t13901.cljs$lang$ctorStr = "cljs.core.async/t13901";

cljs.core.async.t13901.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t13901");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t13901 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t13901(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13902){
return (new cljs.core.async.t13901(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta13902));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t13901(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___14024 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14024,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14024,mults,ensure_mult,p){
return (function (state_13975){
var state_val_13976 = (state_13975[(1)]);
if((state_val_13976 === (7))){
var inst_13971 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_13977_14025 = state_13975__$1;
(statearr_13977_14025[(2)] = inst_13971);

(statearr_13977_14025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (20))){
var state_13975__$1 = state_13975;
var statearr_13978_14026 = state_13975__$1;
(statearr_13978_14026[(2)] = null);

(statearr_13978_14026[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (1))){
var state_13975__$1 = state_13975;
var statearr_13979_14027 = state_13975__$1;
(statearr_13979_14027[(2)] = null);

(statearr_13979_14027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (24))){
var inst_13954 = (state_13975[(7)]);
var inst_13963 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13954);
var state_13975__$1 = state_13975;
var statearr_13980_14028 = state_13975__$1;
(statearr_13980_14028[(2)] = inst_13963);

(statearr_13980_14028[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (4))){
var inst_13906 = (state_13975[(8)]);
var inst_13906__$1 = (state_13975[(2)]);
var inst_13907 = (inst_13906__$1 == null);
var state_13975__$1 = (function (){var statearr_13981 = state_13975;
(statearr_13981[(8)] = inst_13906__$1);

return statearr_13981;
})();
if(cljs.core.truth_(inst_13907)){
var statearr_13982_14029 = state_13975__$1;
(statearr_13982_14029[(1)] = (5));

} else {
var statearr_13983_14030 = state_13975__$1;
(statearr_13983_14030[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (15))){
var inst_13948 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_13984_14031 = state_13975__$1;
(statearr_13984_14031[(2)] = inst_13948);

(statearr_13984_14031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (21))){
var inst_13968 = (state_13975[(2)]);
var state_13975__$1 = (function (){var statearr_13985 = state_13975;
(statearr_13985[(9)] = inst_13968);

return statearr_13985;
})();
var statearr_13986_14032 = state_13975__$1;
(statearr_13986_14032[(2)] = null);

(statearr_13986_14032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (13))){
var inst_13930 = (state_13975[(10)]);
var inst_13932 = cljs.core.chunked_seq_QMARK_.call(null,inst_13930);
var state_13975__$1 = state_13975;
if(inst_13932){
var statearr_13987_14033 = state_13975__$1;
(statearr_13987_14033[(1)] = (16));

} else {
var statearr_13988_14034 = state_13975__$1;
(statearr_13988_14034[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (22))){
var inst_13960 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
if(cljs.core.truth_(inst_13960)){
var statearr_13989_14035 = state_13975__$1;
(statearr_13989_14035[(1)] = (23));

} else {
var statearr_13990_14036 = state_13975__$1;
(statearr_13990_14036[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (6))){
var inst_13906 = (state_13975[(8)]);
var inst_13954 = (state_13975[(7)]);
var inst_13956 = (state_13975[(11)]);
var inst_13954__$1 = topic_fn.call(null,inst_13906);
var inst_13955 = cljs.core.deref.call(null,mults);
var inst_13956__$1 = cljs.core.get.call(null,inst_13955,inst_13954__$1);
var state_13975__$1 = (function (){var statearr_13991 = state_13975;
(statearr_13991[(7)] = inst_13954__$1);

(statearr_13991[(11)] = inst_13956__$1);

return statearr_13991;
})();
if(cljs.core.truth_(inst_13956__$1)){
var statearr_13992_14037 = state_13975__$1;
(statearr_13992_14037[(1)] = (19));

} else {
var statearr_13993_14038 = state_13975__$1;
(statearr_13993_14038[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (25))){
var inst_13965 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_13994_14039 = state_13975__$1;
(statearr_13994_14039[(2)] = inst_13965);

(statearr_13994_14039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (17))){
var inst_13930 = (state_13975[(10)]);
var inst_13939 = cljs.core.first.call(null,inst_13930);
var inst_13940 = cljs.core.async.muxch_STAR_.call(null,inst_13939);
var inst_13941 = cljs.core.async.close_BANG_.call(null,inst_13940);
var inst_13942 = cljs.core.next.call(null,inst_13930);
var inst_13916 = inst_13942;
var inst_13917 = null;
var inst_13918 = (0);
var inst_13919 = (0);
var state_13975__$1 = (function (){var statearr_13995 = state_13975;
(statearr_13995[(12)] = inst_13941);

(statearr_13995[(13)] = inst_13917);

(statearr_13995[(14)] = inst_13919);

(statearr_13995[(15)] = inst_13918);

(statearr_13995[(16)] = inst_13916);

return statearr_13995;
})();
var statearr_13996_14040 = state_13975__$1;
(statearr_13996_14040[(2)] = null);

(statearr_13996_14040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (3))){
var inst_13973 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13975__$1,inst_13973);
} else {
if((state_val_13976 === (12))){
var inst_13950 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_13997_14041 = state_13975__$1;
(statearr_13997_14041[(2)] = inst_13950);

(statearr_13997_14041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (2))){
var state_13975__$1 = state_13975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13975__$1,(4),ch);
} else {
if((state_val_13976 === (23))){
var state_13975__$1 = state_13975;
var statearr_13998_14042 = state_13975__$1;
(statearr_13998_14042[(2)] = null);

(statearr_13998_14042[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (19))){
var inst_13906 = (state_13975[(8)]);
var inst_13956 = (state_13975[(11)]);
var inst_13958 = cljs.core.async.muxch_STAR_.call(null,inst_13956);
var state_13975__$1 = state_13975;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13975__$1,(22),inst_13958,inst_13906);
} else {
if((state_val_13976 === (11))){
var inst_13930 = (state_13975[(10)]);
var inst_13916 = (state_13975[(16)]);
var inst_13930__$1 = cljs.core.seq.call(null,inst_13916);
var state_13975__$1 = (function (){var statearr_13999 = state_13975;
(statearr_13999[(10)] = inst_13930__$1);

return statearr_13999;
})();
if(inst_13930__$1){
var statearr_14000_14043 = state_13975__$1;
(statearr_14000_14043[(1)] = (13));

} else {
var statearr_14001_14044 = state_13975__$1;
(statearr_14001_14044[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (9))){
var inst_13952 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_14002_14045 = state_13975__$1;
(statearr_14002_14045[(2)] = inst_13952);

(statearr_14002_14045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (5))){
var inst_13913 = cljs.core.deref.call(null,mults);
var inst_13914 = cljs.core.vals.call(null,inst_13913);
var inst_13915 = cljs.core.seq.call(null,inst_13914);
var inst_13916 = inst_13915;
var inst_13917 = null;
var inst_13918 = (0);
var inst_13919 = (0);
var state_13975__$1 = (function (){var statearr_14003 = state_13975;
(statearr_14003[(13)] = inst_13917);

(statearr_14003[(14)] = inst_13919);

(statearr_14003[(15)] = inst_13918);

(statearr_14003[(16)] = inst_13916);

return statearr_14003;
})();
var statearr_14004_14046 = state_13975__$1;
(statearr_14004_14046[(2)] = null);

(statearr_14004_14046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (14))){
var state_13975__$1 = state_13975;
var statearr_14008_14047 = state_13975__$1;
(statearr_14008_14047[(2)] = null);

(statearr_14008_14047[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (16))){
var inst_13930 = (state_13975[(10)]);
var inst_13934 = cljs.core.chunk_first.call(null,inst_13930);
var inst_13935 = cljs.core.chunk_rest.call(null,inst_13930);
var inst_13936 = cljs.core.count.call(null,inst_13934);
var inst_13916 = inst_13935;
var inst_13917 = inst_13934;
var inst_13918 = inst_13936;
var inst_13919 = (0);
var state_13975__$1 = (function (){var statearr_14009 = state_13975;
(statearr_14009[(13)] = inst_13917);

(statearr_14009[(14)] = inst_13919);

(statearr_14009[(15)] = inst_13918);

(statearr_14009[(16)] = inst_13916);

return statearr_14009;
})();
var statearr_14010_14048 = state_13975__$1;
(statearr_14010_14048[(2)] = null);

(statearr_14010_14048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (10))){
var inst_13917 = (state_13975[(13)]);
var inst_13919 = (state_13975[(14)]);
var inst_13918 = (state_13975[(15)]);
var inst_13916 = (state_13975[(16)]);
var inst_13924 = cljs.core._nth.call(null,inst_13917,inst_13919);
var inst_13925 = cljs.core.async.muxch_STAR_.call(null,inst_13924);
var inst_13926 = cljs.core.async.close_BANG_.call(null,inst_13925);
var inst_13927 = (inst_13919 + (1));
var tmp14005 = inst_13917;
var tmp14006 = inst_13918;
var tmp14007 = inst_13916;
var inst_13916__$1 = tmp14007;
var inst_13917__$1 = tmp14005;
var inst_13918__$1 = tmp14006;
var inst_13919__$1 = inst_13927;
var state_13975__$1 = (function (){var statearr_14011 = state_13975;
(statearr_14011[(17)] = inst_13926);

(statearr_14011[(13)] = inst_13917__$1);

(statearr_14011[(14)] = inst_13919__$1);

(statearr_14011[(15)] = inst_13918__$1);

(statearr_14011[(16)] = inst_13916__$1);

return statearr_14011;
})();
var statearr_14012_14049 = state_13975__$1;
(statearr_14012_14049[(2)] = null);

(statearr_14012_14049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (18))){
var inst_13945 = (state_13975[(2)]);
var state_13975__$1 = state_13975;
var statearr_14013_14050 = state_13975__$1;
(statearr_14013_14050[(2)] = inst_13945);

(statearr_14013_14050[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13976 === (8))){
var inst_13919 = (state_13975[(14)]);
var inst_13918 = (state_13975[(15)]);
var inst_13921 = (inst_13919 < inst_13918);
var inst_13922 = inst_13921;
var state_13975__$1 = state_13975;
if(cljs.core.truth_(inst_13922)){
var statearr_14014_14051 = state_13975__$1;
(statearr_14014_14051[(1)] = (10));

} else {
var statearr_14015_14052 = state_13975__$1;
(statearr_14015_14052[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14024,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___14024,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14019[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14019[(1)] = (1));

return statearr_14019;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_13975){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_13975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14020){if((e14020 instanceof Object)){
var ex__7651__auto__ = e14020;
var statearr_14021_14053 = state_13975;
(statearr_14021_14053[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14020;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14054 = state_13975;
state_13975 = G__14054;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_13975){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_13975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14024,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_14022 = f__7710__auto__.call(null);
(statearr_14022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14024);

return statearr_14022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14024,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__14056 = arguments.length;
switch (G__14056) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__14059 = arguments.length;
switch (G__14059) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__14062 = arguments.length;
switch (G__14062) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__7709__auto___14132 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14101){
var state_val_14102 = (state_14101[(1)]);
if((state_val_14102 === (7))){
var state_14101__$1 = state_14101;
var statearr_14103_14133 = state_14101__$1;
(statearr_14103_14133[(2)] = null);

(statearr_14103_14133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (1))){
var state_14101__$1 = state_14101;
var statearr_14104_14134 = state_14101__$1;
(statearr_14104_14134[(2)] = null);

(statearr_14104_14134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (4))){
var inst_14065 = (state_14101[(7)]);
var inst_14067 = (inst_14065 < cnt);
var state_14101__$1 = state_14101;
if(cljs.core.truth_(inst_14067)){
var statearr_14105_14135 = state_14101__$1;
(statearr_14105_14135[(1)] = (6));

} else {
var statearr_14106_14136 = state_14101__$1;
(statearr_14106_14136[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (15))){
var inst_14097 = (state_14101[(2)]);
var state_14101__$1 = state_14101;
var statearr_14107_14137 = state_14101__$1;
(statearr_14107_14137[(2)] = inst_14097);

(statearr_14107_14137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (13))){
var inst_14090 = cljs.core.async.close_BANG_.call(null,out);
var state_14101__$1 = state_14101;
var statearr_14108_14138 = state_14101__$1;
(statearr_14108_14138[(2)] = inst_14090);

(statearr_14108_14138[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (6))){
var state_14101__$1 = state_14101;
var statearr_14109_14139 = state_14101__$1;
(statearr_14109_14139[(2)] = null);

(statearr_14109_14139[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (3))){
var inst_14099 = (state_14101[(2)]);
var state_14101__$1 = state_14101;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14101__$1,inst_14099);
} else {
if((state_val_14102 === (12))){
var inst_14087 = (state_14101[(8)]);
var inst_14087__$1 = (state_14101[(2)]);
var inst_14088 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14087__$1);
var state_14101__$1 = (function (){var statearr_14110 = state_14101;
(statearr_14110[(8)] = inst_14087__$1);

return statearr_14110;
})();
if(cljs.core.truth_(inst_14088)){
var statearr_14111_14140 = state_14101__$1;
(statearr_14111_14140[(1)] = (13));

} else {
var statearr_14112_14141 = state_14101__$1;
(statearr_14112_14141[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (2))){
var inst_14064 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14065 = (0);
var state_14101__$1 = (function (){var statearr_14113 = state_14101;
(statearr_14113[(7)] = inst_14065);

(statearr_14113[(9)] = inst_14064);

return statearr_14113;
})();
var statearr_14114_14142 = state_14101__$1;
(statearr_14114_14142[(2)] = null);

(statearr_14114_14142[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (11))){
var inst_14065 = (state_14101[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14101,(10),Object,null,(9));
var inst_14074 = chs__$1.call(null,inst_14065);
var inst_14075 = done.call(null,inst_14065);
var inst_14076 = cljs.core.async.take_BANG_.call(null,inst_14074,inst_14075);
var state_14101__$1 = state_14101;
var statearr_14115_14143 = state_14101__$1;
(statearr_14115_14143[(2)] = inst_14076);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14101__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (9))){
var inst_14065 = (state_14101[(7)]);
var inst_14078 = (state_14101[(2)]);
var inst_14079 = (inst_14065 + (1));
var inst_14065__$1 = inst_14079;
var state_14101__$1 = (function (){var statearr_14116 = state_14101;
(statearr_14116[(10)] = inst_14078);

(statearr_14116[(7)] = inst_14065__$1);

return statearr_14116;
})();
var statearr_14117_14144 = state_14101__$1;
(statearr_14117_14144[(2)] = null);

(statearr_14117_14144[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (5))){
var inst_14085 = (state_14101[(2)]);
var state_14101__$1 = (function (){var statearr_14118 = state_14101;
(statearr_14118[(11)] = inst_14085);

return statearr_14118;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14101__$1,(12),dchan);
} else {
if((state_val_14102 === (14))){
var inst_14087 = (state_14101[(8)]);
var inst_14092 = cljs.core.apply.call(null,f,inst_14087);
var state_14101__$1 = state_14101;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14101__$1,(16),out,inst_14092);
} else {
if((state_val_14102 === (16))){
var inst_14094 = (state_14101[(2)]);
var state_14101__$1 = (function (){var statearr_14119 = state_14101;
(statearr_14119[(12)] = inst_14094);

return statearr_14119;
})();
var statearr_14120_14145 = state_14101__$1;
(statearr_14120_14145[(2)] = null);

(statearr_14120_14145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (10))){
var inst_14069 = (state_14101[(2)]);
var inst_14070 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14101__$1 = (function (){var statearr_14121 = state_14101;
(statearr_14121[(13)] = inst_14069);

return statearr_14121;
})();
var statearr_14122_14146 = state_14101__$1;
(statearr_14122_14146[(2)] = inst_14070);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14101__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14102 === (8))){
var inst_14083 = (state_14101[(2)]);
var state_14101__$1 = state_14101;
var statearr_14123_14147 = state_14101__$1;
(statearr_14123_14147[(2)] = inst_14083);

(statearr_14123_14147[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14127[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14127[(1)] = (1));

return statearr_14127;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14101){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14101);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14128){if((e14128 instanceof Object)){
var ex__7651__auto__ = e14128;
var statearr_14129_14148 = state_14101;
(statearr_14129_14148[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14101);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14128;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14149 = state_14101;
state_14101 = G__14149;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14101){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_14130 = f__7710__auto__.call(null);
(statearr_14130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14132);

return statearr_14130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14132,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__14152 = arguments.length;
switch (G__14152) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14207,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14207,out){
return (function (state_14182){
var state_val_14183 = (state_14182[(1)]);
if((state_val_14183 === (7))){
var inst_14161 = (state_14182[(7)]);
var inst_14162 = (state_14182[(8)]);
var inst_14161__$1 = (state_14182[(2)]);
var inst_14162__$1 = cljs.core.nth.call(null,inst_14161__$1,(0),null);
var inst_14163 = cljs.core.nth.call(null,inst_14161__$1,(1),null);
var inst_14164 = (inst_14162__$1 == null);
var state_14182__$1 = (function (){var statearr_14184 = state_14182;
(statearr_14184[(7)] = inst_14161__$1);

(statearr_14184[(9)] = inst_14163);

(statearr_14184[(8)] = inst_14162__$1);

return statearr_14184;
})();
if(cljs.core.truth_(inst_14164)){
var statearr_14185_14208 = state_14182__$1;
(statearr_14185_14208[(1)] = (8));

} else {
var statearr_14186_14209 = state_14182__$1;
(statearr_14186_14209[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (1))){
var inst_14153 = cljs.core.vec.call(null,chs);
var inst_14154 = inst_14153;
var state_14182__$1 = (function (){var statearr_14187 = state_14182;
(statearr_14187[(10)] = inst_14154);

return statearr_14187;
})();
var statearr_14188_14210 = state_14182__$1;
(statearr_14188_14210[(2)] = null);

(statearr_14188_14210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (4))){
var inst_14154 = (state_14182[(10)]);
var state_14182__$1 = state_14182;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14182__$1,(7),inst_14154);
} else {
if((state_val_14183 === (6))){
var inst_14178 = (state_14182[(2)]);
var state_14182__$1 = state_14182;
var statearr_14189_14211 = state_14182__$1;
(statearr_14189_14211[(2)] = inst_14178);

(statearr_14189_14211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (3))){
var inst_14180 = (state_14182[(2)]);
var state_14182__$1 = state_14182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14182__$1,inst_14180);
} else {
if((state_val_14183 === (2))){
var inst_14154 = (state_14182[(10)]);
var inst_14156 = cljs.core.count.call(null,inst_14154);
var inst_14157 = (inst_14156 > (0));
var state_14182__$1 = state_14182;
if(cljs.core.truth_(inst_14157)){
var statearr_14191_14212 = state_14182__$1;
(statearr_14191_14212[(1)] = (4));

} else {
var statearr_14192_14213 = state_14182__$1;
(statearr_14192_14213[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (11))){
var inst_14154 = (state_14182[(10)]);
var inst_14171 = (state_14182[(2)]);
var tmp14190 = inst_14154;
var inst_14154__$1 = tmp14190;
var state_14182__$1 = (function (){var statearr_14193 = state_14182;
(statearr_14193[(11)] = inst_14171);

(statearr_14193[(10)] = inst_14154__$1);

return statearr_14193;
})();
var statearr_14194_14214 = state_14182__$1;
(statearr_14194_14214[(2)] = null);

(statearr_14194_14214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (9))){
var inst_14162 = (state_14182[(8)]);
var state_14182__$1 = state_14182;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14182__$1,(11),out,inst_14162);
} else {
if((state_val_14183 === (5))){
var inst_14176 = cljs.core.async.close_BANG_.call(null,out);
var state_14182__$1 = state_14182;
var statearr_14195_14215 = state_14182__$1;
(statearr_14195_14215[(2)] = inst_14176);

(statearr_14195_14215[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (10))){
var inst_14174 = (state_14182[(2)]);
var state_14182__$1 = state_14182;
var statearr_14196_14216 = state_14182__$1;
(statearr_14196_14216[(2)] = inst_14174);

(statearr_14196_14216[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14183 === (8))){
var inst_14161 = (state_14182[(7)]);
var inst_14154 = (state_14182[(10)]);
var inst_14163 = (state_14182[(9)]);
var inst_14162 = (state_14182[(8)]);
var inst_14166 = (function (){var c = inst_14163;
var v = inst_14162;
var vec__14159 = inst_14161;
var cs = inst_14154;
return ((function (c,v,vec__14159,cs,inst_14161,inst_14154,inst_14163,inst_14162,state_val_14183,c__7709__auto___14207,out){
return (function (p1__14150_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14150_SHARP_);
});
;})(c,v,vec__14159,cs,inst_14161,inst_14154,inst_14163,inst_14162,state_val_14183,c__7709__auto___14207,out))
})();
var inst_14167 = cljs.core.filterv.call(null,inst_14166,inst_14154);
var inst_14154__$1 = inst_14167;
var state_14182__$1 = (function (){var statearr_14197 = state_14182;
(statearr_14197[(10)] = inst_14154__$1);

return statearr_14197;
})();
var statearr_14198_14217 = state_14182__$1;
(statearr_14198_14217[(2)] = null);

(statearr_14198_14217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14207,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14207,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14202 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14202[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14202[(1)] = (1));

return statearr_14202;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14182){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14203){if((e14203 instanceof Object)){
var ex__7651__auto__ = e14203;
var statearr_14204_14218 = state_14182;
(statearr_14204_14218[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14182);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14203;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14219 = state_14182;
state_14182 = G__14219;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14182){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14207,out))
})();
var state__7711__auto__ = (function (){var statearr_14205 = f__7710__auto__.call(null);
(statearr_14205[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14207);

return statearr_14205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14207,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__14221 = arguments.length;
switch (G__14221) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14269 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14269,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14269,out){
return (function (state_14245){
var state_val_14246 = (state_14245[(1)]);
if((state_val_14246 === (7))){
var inst_14227 = (state_14245[(7)]);
var inst_14227__$1 = (state_14245[(2)]);
var inst_14228 = (inst_14227__$1 == null);
var inst_14229 = cljs.core.not.call(null,inst_14228);
var state_14245__$1 = (function (){var statearr_14247 = state_14245;
(statearr_14247[(7)] = inst_14227__$1);

return statearr_14247;
})();
if(inst_14229){
var statearr_14248_14270 = state_14245__$1;
(statearr_14248_14270[(1)] = (8));

} else {
var statearr_14249_14271 = state_14245__$1;
(statearr_14249_14271[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (1))){
var inst_14222 = (0);
var state_14245__$1 = (function (){var statearr_14250 = state_14245;
(statearr_14250[(8)] = inst_14222);

return statearr_14250;
})();
var statearr_14251_14272 = state_14245__$1;
(statearr_14251_14272[(2)] = null);

(statearr_14251_14272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (4))){
var state_14245__$1 = state_14245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14245__$1,(7),ch);
} else {
if((state_val_14246 === (6))){
var inst_14240 = (state_14245[(2)]);
var state_14245__$1 = state_14245;
var statearr_14252_14273 = state_14245__$1;
(statearr_14252_14273[(2)] = inst_14240);

(statearr_14252_14273[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (3))){
var inst_14242 = (state_14245[(2)]);
var inst_14243 = cljs.core.async.close_BANG_.call(null,out);
var state_14245__$1 = (function (){var statearr_14253 = state_14245;
(statearr_14253[(9)] = inst_14242);

return statearr_14253;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14245__$1,inst_14243);
} else {
if((state_val_14246 === (2))){
var inst_14222 = (state_14245[(8)]);
var inst_14224 = (inst_14222 < n);
var state_14245__$1 = state_14245;
if(cljs.core.truth_(inst_14224)){
var statearr_14254_14274 = state_14245__$1;
(statearr_14254_14274[(1)] = (4));

} else {
var statearr_14255_14275 = state_14245__$1;
(statearr_14255_14275[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (11))){
var inst_14222 = (state_14245[(8)]);
var inst_14232 = (state_14245[(2)]);
var inst_14233 = (inst_14222 + (1));
var inst_14222__$1 = inst_14233;
var state_14245__$1 = (function (){var statearr_14256 = state_14245;
(statearr_14256[(10)] = inst_14232);

(statearr_14256[(8)] = inst_14222__$1);

return statearr_14256;
})();
var statearr_14257_14276 = state_14245__$1;
(statearr_14257_14276[(2)] = null);

(statearr_14257_14276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (9))){
var state_14245__$1 = state_14245;
var statearr_14258_14277 = state_14245__$1;
(statearr_14258_14277[(2)] = null);

(statearr_14258_14277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (5))){
var state_14245__$1 = state_14245;
var statearr_14259_14278 = state_14245__$1;
(statearr_14259_14278[(2)] = null);

(statearr_14259_14278[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (10))){
var inst_14237 = (state_14245[(2)]);
var state_14245__$1 = state_14245;
var statearr_14260_14279 = state_14245__$1;
(statearr_14260_14279[(2)] = inst_14237);

(statearr_14260_14279[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14246 === (8))){
var inst_14227 = (state_14245[(7)]);
var state_14245__$1 = state_14245;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14245__$1,(11),out,inst_14227);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14269,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14269,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14264 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14264[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14264[(1)] = (1));

return statearr_14264;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14245){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14265){if((e14265 instanceof Object)){
var ex__7651__auto__ = e14265;
var statearr_14266_14280 = state_14245;
(statearr_14266_14280[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14245);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14281 = state_14245;
state_14245 = G__14281;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14269,out))
})();
var state__7711__auto__ = (function (){var statearr_14267 = f__7710__auto__.call(null);
(statearr_14267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14269);

return statearr_14267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14269,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t14289 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14289 = (function (ch,f,map_LT_,meta14290){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta14290 = meta14290;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t14292 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14292 = (function (fn1,_,meta14290,map_LT_,f,ch,meta14293){
this.fn1 = fn1;
this._ = _;
this.meta14290 = meta14290;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14293 = meta14293;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14292.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t14292.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t14292.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14282_SHARP_){
return f1.call(null,(((p1__14282_SHARP_ == null))?null:self__.f.call(null,p1__14282_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t14292.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14294){
var self__ = this;
var _14294__$1 = this;
return self__.meta14293;
});})(___$1))
;

cljs.core.async.t14292.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14294,meta14293__$1){
var self__ = this;
var _14294__$1 = this;
return (new cljs.core.async.t14292(self__.fn1,self__._,self__.meta14290,self__.map_LT_,self__.f,self__.ch,meta14293__$1));
});})(___$1))
;

cljs.core.async.t14292.cljs$lang$type = true;

cljs.core.async.t14292.cljs$lang$ctorStr = "cljs.core.async/t14292";

cljs.core.async.t14292.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14292");
});})(___$1))
;

cljs.core.async.__GT_t14292 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t14292(fn1__$1,___$2,meta14290__$1,map_LT___$1,f__$1,ch__$1,meta14293){
return (new cljs.core.async.t14292(fn1__$1,___$2,meta14290__$1,map_LT___$1,f__$1,ch__$1,meta14293));
});})(___$1))
;

}

return (new cljs.core.async.t14292(fn1,___$1,self__.meta14290,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14289.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14289.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14291){
var self__ = this;
var _14291__$1 = this;
return self__.meta14290;
});

cljs.core.async.t14289.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14291,meta14290__$1){
var self__ = this;
var _14291__$1 = this;
return (new cljs.core.async.t14289(self__.ch,self__.f,self__.map_LT_,meta14290__$1));
});

cljs.core.async.t14289.cljs$lang$type = true;

cljs.core.async.t14289.cljs$lang$ctorStr = "cljs.core.async/t14289";

cljs.core.async.t14289.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14289");
});

cljs.core.async.__GT_t14289 = (function cljs$core$async$map_LT__$___GT_t14289(ch__$1,f__$1,map_LT___$1,meta14290){
return (new cljs.core.async.t14289(ch__$1,f__$1,map_LT___$1,meta14290));
});

}

return (new cljs.core.async.t14289(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t14298 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14298 = (function (ch,f,map_GT_,meta14299){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta14299 = meta14299;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14298.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14298.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14300){
var self__ = this;
var _14300__$1 = this;
return self__.meta14299;
});

cljs.core.async.t14298.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14300,meta14299__$1){
var self__ = this;
var _14300__$1 = this;
return (new cljs.core.async.t14298(self__.ch,self__.f,self__.map_GT_,meta14299__$1));
});

cljs.core.async.t14298.cljs$lang$type = true;

cljs.core.async.t14298.cljs$lang$ctorStr = "cljs.core.async/t14298";

cljs.core.async.t14298.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14298");
});

cljs.core.async.__GT_t14298 = (function cljs$core$async$map_GT__$___GT_t14298(ch__$1,f__$1,map_GT___$1,meta14299){
return (new cljs.core.async.t14298(ch__$1,f__$1,map_GT___$1,meta14299));
});

}

return (new cljs.core.async.t14298(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t14304 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t14304 = (function (ch,p,filter_GT_,meta14305){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta14305 = meta14305;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t14304.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t14304.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14306){
var self__ = this;
var _14306__$1 = this;
return self__.meta14305;
});

cljs.core.async.t14304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14306,meta14305__$1){
var self__ = this;
var _14306__$1 = this;
return (new cljs.core.async.t14304(self__.ch,self__.p,self__.filter_GT_,meta14305__$1));
});

cljs.core.async.t14304.cljs$lang$type = true;

cljs.core.async.t14304.cljs$lang$ctorStr = "cljs.core.async/t14304";

cljs.core.async.t14304.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cljs.core.async/t14304");
});

cljs.core.async.__GT_t14304 = (function cljs$core$async$filter_GT__$___GT_t14304(ch__$1,p__$1,filter_GT___$1,meta14305){
return (new cljs.core.async.t14304(ch__$1,p__$1,filter_GT___$1,meta14305));
});

}

return (new cljs.core.async.t14304(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__14308 = arguments.length;
switch (G__14308) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14351 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14351,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14351,out){
return (function (state_14329){
var state_val_14330 = (state_14329[(1)]);
if((state_val_14330 === (7))){
var inst_14325 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14331_14352 = state_14329__$1;
(statearr_14331_14352[(2)] = inst_14325);

(statearr_14331_14352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (1))){
var state_14329__$1 = state_14329;
var statearr_14332_14353 = state_14329__$1;
(statearr_14332_14353[(2)] = null);

(statearr_14332_14353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (4))){
var inst_14311 = (state_14329[(7)]);
var inst_14311__$1 = (state_14329[(2)]);
var inst_14312 = (inst_14311__$1 == null);
var state_14329__$1 = (function (){var statearr_14333 = state_14329;
(statearr_14333[(7)] = inst_14311__$1);

return statearr_14333;
})();
if(cljs.core.truth_(inst_14312)){
var statearr_14334_14354 = state_14329__$1;
(statearr_14334_14354[(1)] = (5));

} else {
var statearr_14335_14355 = state_14329__$1;
(statearr_14335_14355[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (6))){
var inst_14311 = (state_14329[(7)]);
var inst_14316 = p.call(null,inst_14311);
var state_14329__$1 = state_14329;
if(cljs.core.truth_(inst_14316)){
var statearr_14336_14356 = state_14329__$1;
(statearr_14336_14356[(1)] = (8));

} else {
var statearr_14337_14357 = state_14329__$1;
(statearr_14337_14357[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (3))){
var inst_14327 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14329__$1,inst_14327);
} else {
if((state_val_14330 === (2))){
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14329__$1,(4),ch);
} else {
if((state_val_14330 === (11))){
var inst_14319 = (state_14329[(2)]);
var state_14329__$1 = state_14329;
var statearr_14338_14358 = state_14329__$1;
(statearr_14338_14358[(2)] = inst_14319);

(statearr_14338_14358[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (9))){
var state_14329__$1 = state_14329;
var statearr_14339_14359 = state_14329__$1;
(statearr_14339_14359[(2)] = null);

(statearr_14339_14359[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (5))){
var inst_14314 = cljs.core.async.close_BANG_.call(null,out);
var state_14329__$1 = state_14329;
var statearr_14340_14360 = state_14329__$1;
(statearr_14340_14360[(2)] = inst_14314);

(statearr_14340_14360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (10))){
var inst_14322 = (state_14329[(2)]);
var state_14329__$1 = (function (){var statearr_14341 = state_14329;
(statearr_14341[(8)] = inst_14322);

return statearr_14341;
})();
var statearr_14342_14361 = state_14329__$1;
(statearr_14342_14361[(2)] = null);

(statearr_14342_14361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14330 === (8))){
var inst_14311 = (state_14329[(7)]);
var state_14329__$1 = state_14329;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14329__$1,(11),out,inst_14311);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14351,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14351,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14346 = [null,null,null,null,null,null,null,null,null];
(statearr_14346[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14346[(1)] = (1));

return statearr_14346;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14329){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14347){if((e14347 instanceof Object)){
var ex__7651__auto__ = e14347;
var statearr_14348_14362 = state_14329;
(statearr_14348_14362[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14363 = state_14329;
state_14329 = G__14363;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14329){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14351,out))
})();
var state__7711__auto__ = (function (){var statearr_14349 = f__7710__auto__.call(null);
(statearr_14349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14351);

return statearr_14349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14351,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__14365 = arguments.length;
switch (G__14365) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_14532){
var state_val_14533 = (state_14532[(1)]);
if((state_val_14533 === (7))){
var inst_14528 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
var statearr_14534_14575 = state_14532__$1;
(statearr_14534_14575[(2)] = inst_14528);

(statearr_14534_14575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (20))){
var inst_14498 = (state_14532[(7)]);
var inst_14509 = (state_14532[(2)]);
var inst_14510 = cljs.core.next.call(null,inst_14498);
var inst_14484 = inst_14510;
var inst_14485 = null;
var inst_14486 = (0);
var inst_14487 = (0);
var state_14532__$1 = (function (){var statearr_14535 = state_14532;
(statearr_14535[(8)] = inst_14487);

(statearr_14535[(9)] = inst_14484);

(statearr_14535[(10)] = inst_14486);

(statearr_14535[(11)] = inst_14485);

(statearr_14535[(12)] = inst_14509);

return statearr_14535;
})();
var statearr_14536_14576 = state_14532__$1;
(statearr_14536_14576[(2)] = null);

(statearr_14536_14576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (1))){
var state_14532__$1 = state_14532;
var statearr_14537_14577 = state_14532__$1;
(statearr_14537_14577[(2)] = null);

(statearr_14537_14577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (4))){
var inst_14473 = (state_14532[(13)]);
var inst_14473__$1 = (state_14532[(2)]);
var inst_14474 = (inst_14473__$1 == null);
var state_14532__$1 = (function (){var statearr_14538 = state_14532;
(statearr_14538[(13)] = inst_14473__$1);

return statearr_14538;
})();
if(cljs.core.truth_(inst_14474)){
var statearr_14539_14578 = state_14532__$1;
(statearr_14539_14578[(1)] = (5));

} else {
var statearr_14540_14579 = state_14532__$1;
(statearr_14540_14579[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (15))){
var state_14532__$1 = state_14532;
var statearr_14544_14580 = state_14532__$1;
(statearr_14544_14580[(2)] = null);

(statearr_14544_14580[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (21))){
var state_14532__$1 = state_14532;
var statearr_14545_14581 = state_14532__$1;
(statearr_14545_14581[(2)] = null);

(statearr_14545_14581[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (13))){
var inst_14487 = (state_14532[(8)]);
var inst_14484 = (state_14532[(9)]);
var inst_14486 = (state_14532[(10)]);
var inst_14485 = (state_14532[(11)]);
var inst_14494 = (state_14532[(2)]);
var inst_14495 = (inst_14487 + (1));
var tmp14541 = inst_14484;
var tmp14542 = inst_14486;
var tmp14543 = inst_14485;
var inst_14484__$1 = tmp14541;
var inst_14485__$1 = tmp14543;
var inst_14486__$1 = tmp14542;
var inst_14487__$1 = inst_14495;
var state_14532__$1 = (function (){var statearr_14546 = state_14532;
(statearr_14546[(14)] = inst_14494);

(statearr_14546[(8)] = inst_14487__$1);

(statearr_14546[(9)] = inst_14484__$1);

(statearr_14546[(10)] = inst_14486__$1);

(statearr_14546[(11)] = inst_14485__$1);

return statearr_14546;
})();
var statearr_14547_14582 = state_14532__$1;
(statearr_14547_14582[(2)] = null);

(statearr_14547_14582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (22))){
var state_14532__$1 = state_14532;
var statearr_14548_14583 = state_14532__$1;
(statearr_14548_14583[(2)] = null);

(statearr_14548_14583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (6))){
var inst_14473 = (state_14532[(13)]);
var inst_14482 = f.call(null,inst_14473);
var inst_14483 = cljs.core.seq.call(null,inst_14482);
var inst_14484 = inst_14483;
var inst_14485 = null;
var inst_14486 = (0);
var inst_14487 = (0);
var state_14532__$1 = (function (){var statearr_14549 = state_14532;
(statearr_14549[(8)] = inst_14487);

(statearr_14549[(9)] = inst_14484);

(statearr_14549[(10)] = inst_14486);

(statearr_14549[(11)] = inst_14485);

return statearr_14549;
})();
var statearr_14550_14584 = state_14532__$1;
(statearr_14550_14584[(2)] = null);

(statearr_14550_14584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (17))){
var inst_14498 = (state_14532[(7)]);
var inst_14502 = cljs.core.chunk_first.call(null,inst_14498);
var inst_14503 = cljs.core.chunk_rest.call(null,inst_14498);
var inst_14504 = cljs.core.count.call(null,inst_14502);
var inst_14484 = inst_14503;
var inst_14485 = inst_14502;
var inst_14486 = inst_14504;
var inst_14487 = (0);
var state_14532__$1 = (function (){var statearr_14551 = state_14532;
(statearr_14551[(8)] = inst_14487);

(statearr_14551[(9)] = inst_14484);

(statearr_14551[(10)] = inst_14486);

(statearr_14551[(11)] = inst_14485);

return statearr_14551;
})();
var statearr_14552_14585 = state_14532__$1;
(statearr_14552_14585[(2)] = null);

(statearr_14552_14585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (3))){
var inst_14530 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14532__$1,inst_14530);
} else {
if((state_val_14533 === (12))){
var inst_14518 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
var statearr_14553_14586 = state_14532__$1;
(statearr_14553_14586[(2)] = inst_14518);

(statearr_14553_14586[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (2))){
var state_14532__$1 = state_14532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14532__$1,(4),in$);
} else {
if((state_val_14533 === (23))){
var inst_14526 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
var statearr_14554_14587 = state_14532__$1;
(statearr_14554_14587[(2)] = inst_14526);

(statearr_14554_14587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (19))){
var inst_14513 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
var statearr_14555_14588 = state_14532__$1;
(statearr_14555_14588[(2)] = inst_14513);

(statearr_14555_14588[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (11))){
var inst_14484 = (state_14532[(9)]);
var inst_14498 = (state_14532[(7)]);
var inst_14498__$1 = cljs.core.seq.call(null,inst_14484);
var state_14532__$1 = (function (){var statearr_14556 = state_14532;
(statearr_14556[(7)] = inst_14498__$1);

return statearr_14556;
})();
if(inst_14498__$1){
var statearr_14557_14589 = state_14532__$1;
(statearr_14557_14589[(1)] = (14));

} else {
var statearr_14558_14590 = state_14532__$1;
(statearr_14558_14590[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (9))){
var inst_14520 = (state_14532[(2)]);
var inst_14521 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14532__$1 = (function (){var statearr_14559 = state_14532;
(statearr_14559[(15)] = inst_14520);

return statearr_14559;
})();
if(cljs.core.truth_(inst_14521)){
var statearr_14560_14591 = state_14532__$1;
(statearr_14560_14591[(1)] = (21));

} else {
var statearr_14561_14592 = state_14532__$1;
(statearr_14561_14592[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (5))){
var inst_14476 = cljs.core.async.close_BANG_.call(null,out);
var state_14532__$1 = state_14532;
var statearr_14562_14593 = state_14532__$1;
(statearr_14562_14593[(2)] = inst_14476);

(statearr_14562_14593[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (14))){
var inst_14498 = (state_14532[(7)]);
var inst_14500 = cljs.core.chunked_seq_QMARK_.call(null,inst_14498);
var state_14532__$1 = state_14532;
if(inst_14500){
var statearr_14563_14594 = state_14532__$1;
(statearr_14563_14594[(1)] = (17));

} else {
var statearr_14564_14595 = state_14532__$1;
(statearr_14564_14595[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (16))){
var inst_14516 = (state_14532[(2)]);
var state_14532__$1 = state_14532;
var statearr_14565_14596 = state_14532__$1;
(statearr_14565_14596[(2)] = inst_14516);

(statearr_14565_14596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14533 === (10))){
var inst_14487 = (state_14532[(8)]);
var inst_14485 = (state_14532[(11)]);
var inst_14492 = cljs.core._nth.call(null,inst_14485,inst_14487);
var state_14532__$1 = state_14532;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14532__$1,(13),out,inst_14492);
} else {
if((state_val_14533 === (18))){
var inst_14498 = (state_14532[(7)]);
var inst_14507 = cljs.core.first.call(null,inst_14498);
var state_14532__$1 = state_14532;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14532__$1,(20),out,inst_14507);
} else {
if((state_val_14533 === (8))){
var inst_14487 = (state_14532[(8)]);
var inst_14486 = (state_14532[(10)]);
var inst_14489 = (inst_14487 < inst_14486);
var inst_14490 = inst_14489;
var state_14532__$1 = state_14532;
if(cljs.core.truth_(inst_14490)){
var statearr_14566_14597 = state_14532__$1;
(statearr_14566_14597[(1)] = (10));

} else {
var statearr_14567_14598 = state_14532__$1;
(statearr_14567_14598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_14571 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14571[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_14571[(1)] = (1));

return statearr_14571;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_14532){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14572){if((e14572 instanceof Object)){
var ex__7651__auto__ = e14572;
var statearr_14573_14599 = state_14532;
(statearr_14573_14599[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14532);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14600 = state_14532;
state_14532 = G__14600;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_14532){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_14532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_14574 = f__7710__auto__.call(null);
(statearr_14574[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_14574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__14602 = arguments.length;
switch (G__14602) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__14605 = arguments.length;
switch (G__14605) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__14608 = arguments.length;
switch (G__14608) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14658 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14658,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14658,out){
return (function (state_14632){
var state_val_14633 = (state_14632[(1)]);
if((state_val_14633 === (7))){
var inst_14627 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
var statearr_14634_14659 = state_14632__$1;
(statearr_14634_14659[(2)] = inst_14627);

(statearr_14634_14659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (1))){
var inst_14609 = null;
var state_14632__$1 = (function (){var statearr_14635 = state_14632;
(statearr_14635[(7)] = inst_14609);

return statearr_14635;
})();
var statearr_14636_14660 = state_14632__$1;
(statearr_14636_14660[(2)] = null);

(statearr_14636_14660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (4))){
var inst_14612 = (state_14632[(8)]);
var inst_14612__$1 = (state_14632[(2)]);
var inst_14613 = (inst_14612__$1 == null);
var inst_14614 = cljs.core.not.call(null,inst_14613);
var state_14632__$1 = (function (){var statearr_14637 = state_14632;
(statearr_14637[(8)] = inst_14612__$1);

return statearr_14637;
})();
if(inst_14614){
var statearr_14638_14661 = state_14632__$1;
(statearr_14638_14661[(1)] = (5));

} else {
var statearr_14639_14662 = state_14632__$1;
(statearr_14639_14662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (6))){
var state_14632__$1 = state_14632;
var statearr_14640_14663 = state_14632__$1;
(statearr_14640_14663[(2)] = null);

(statearr_14640_14663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (3))){
var inst_14629 = (state_14632[(2)]);
var inst_14630 = cljs.core.async.close_BANG_.call(null,out);
var state_14632__$1 = (function (){var statearr_14641 = state_14632;
(statearr_14641[(9)] = inst_14629);

return statearr_14641;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14632__$1,inst_14630);
} else {
if((state_val_14633 === (2))){
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14632__$1,(4),ch);
} else {
if((state_val_14633 === (11))){
var inst_14612 = (state_14632[(8)]);
var inst_14621 = (state_14632[(2)]);
var inst_14609 = inst_14612;
var state_14632__$1 = (function (){var statearr_14642 = state_14632;
(statearr_14642[(7)] = inst_14609);

(statearr_14642[(10)] = inst_14621);

return statearr_14642;
})();
var statearr_14643_14664 = state_14632__$1;
(statearr_14643_14664[(2)] = null);

(statearr_14643_14664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (9))){
var inst_14612 = (state_14632[(8)]);
var state_14632__$1 = state_14632;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14632__$1,(11),out,inst_14612);
} else {
if((state_val_14633 === (5))){
var inst_14609 = (state_14632[(7)]);
var inst_14612 = (state_14632[(8)]);
var inst_14616 = cljs.core._EQ_.call(null,inst_14612,inst_14609);
var state_14632__$1 = state_14632;
if(inst_14616){
var statearr_14645_14665 = state_14632__$1;
(statearr_14645_14665[(1)] = (8));

} else {
var statearr_14646_14666 = state_14632__$1;
(statearr_14646_14666[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (10))){
var inst_14624 = (state_14632[(2)]);
var state_14632__$1 = state_14632;
var statearr_14647_14667 = state_14632__$1;
(statearr_14647_14667[(2)] = inst_14624);

(statearr_14647_14667[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14633 === (8))){
var inst_14609 = (state_14632[(7)]);
var tmp14644 = inst_14609;
var inst_14609__$1 = tmp14644;
var state_14632__$1 = (function (){var statearr_14648 = state_14632;
(statearr_14648[(7)] = inst_14609__$1);

return statearr_14648;
})();
var statearr_14649_14668 = state_14632__$1;
(statearr_14649_14668[(2)] = null);

(statearr_14649_14668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14658,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14658,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14653 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14653[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14653[(1)] = (1));

return statearr_14653;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14632){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14654){if((e14654 instanceof Object)){
var ex__7651__auto__ = e14654;
var statearr_14655_14669 = state_14632;
(statearr_14655_14669[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14654;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14670 = state_14632;
state_14632 = G__14670;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14632){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14658,out))
})();
var state__7711__auto__ = (function (){var statearr_14656 = f__7710__auto__.call(null);
(statearr_14656[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14658);

return statearr_14656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14658,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__14672 = arguments.length;
switch (G__14672) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14741,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14741,out){
return (function (state_14710){
var state_val_14711 = (state_14710[(1)]);
if((state_val_14711 === (7))){
var inst_14706 = (state_14710[(2)]);
var state_14710__$1 = state_14710;
var statearr_14712_14742 = state_14710__$1;
(statearr_14712_14742[(2)] = inst_14706);

(statearr_14712_14742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (1))){
var inst_14673 = (new Array(n));
var inst_14674 = inst_14673;
var inst_14675 = (0);
var state_14710__$1 = (function (){var statearr_14713 = state_14710;
(statearr_14713[(7)] = inst_14674);

(statearr_14713[(8)] = inst_14675);

return statearr_14713;
})();
var statearr_14714_14743 = state_14710__$1;
(statearr_14714_14743[(2)] = null);

(statearr_14714_14743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (4))){
var inst_14678 = (state_14710[(9)]);
var inst_14678__$1 = (state_14710[(2)]);
var inst_14679 = (inst_14678__$1 == null);
var inst_14680 = cljs.core.not.call(null,inst_14679);
var state_14710__$1 = (function (){var statearr_14715 = state_14710;
(statearr_14715[(9)] = inst_14678__$1);

return statearr_14715;
})();
if(inst_14680){
var statearr_14716_14744 = state_14710__$1;
(statearr_14716_14744[(1)] = (5));

} else {
var statearr_14717_14745 = state_14710__$1;
(statearr_14717_14745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (15))){
var inst_14700 = (state_14710[(2)]);
var state_14710__$1 = state_14710;
var statearr_14718_14746 = state_14710__$1;
(statearr_14718_14746[(2)] = inst_14700);

(statearr_14718_14746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (13))){
var state_14710__$1 = state_14710;
var statearr_14719_14747 = state_14710__$1;
(statearr_14719_14747[(2)] = null);

(statearr_14719_14747[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (6))){
var inst_14675 = (state_14710[(8)]);
var inst_14696 = (inst_14675 > (0));
var state_14710__$1 = state_14710;
if(cljs.core.truth_(inst_14696)){
var statearr_14720_14748 = state_14710__$1;
(statearr_14720_14748[(1)] = (12));

} else {
var statearr_14721_14749 = state_14710__$1;
(statearr_14721_14749[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (3))){
var inst_14708 = (state_14710[(2)]);
var state_14710__$1 = state_14710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14710__$1,inst_14708);
} else {
if((state_val_14711 === (12))){
var inst_14674 = (state_14710[(7)]);
var inst_14698 = cljs.core.vec.call(null,inst_14674);
var state_14710__$1 = state_14710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14710__$1,(15),out,inst_14698);
} else {
if((state_val_14711 === (2))){
var state_14710__$1 = state_14710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14710__$1,(4),ch);
} else {
if((state_val_14711 === (11))){
var inst_14690 = (state_14710[(2)]);
var inst_14691 = (new Array(n));
var inst_14674 = inst_14691;
var inst_14675 = (0);
var state_14710__$1 = (function (){var statearr_14722 = state_14710;
(statearr_14722[(7)] = inst_14674);

(statearr_14722[(8)] = inst_14675);

(statearr_14722[(10)] = inst_14690);

return statearr_14722;
})();
var statearr_14723_14750 = state_14710__$1;
(statearr_14723_14750[(2)] = null);

(statearr_14723_14750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (9))){
var inst_14674 = (state_14710[(7)]);
var inst_14688 = cljs.core.vec.call(null,inst_14674);
var state_14710__$1 = state_14710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14710__$1,(11),out,inst_14688);
} else {
if((state_val_14711 === (5))){
var inst_14674 = (state_14710[(7)]);
var inst_14683 = (state_14710[(11)]);
var inst_14675 = (state_14710[(8)]);
var inst_14678 = (state_14710[(9)]);
var inst_14682 = (inst_14674[inst_14675] = inst_14678);
var inst_14683__$1 = (inst_14675 + (1));
var inst_14684 = (inst_14683__$1 < n);
var state_14710__$1 = (function (){var statearr_14724 = state_14710;
(statearr_14724[(11)] = inst_14683__$1);

(statearr_14724[(12)] = inst_14682);

return statearr_14724;
})();
if(cljs.core.truth_(inst_14684)){
var statearr_14725_14751 = state_14710__$1;
(statearr_14725_14751[(1)] = (8));

} else {
var statearr_14726_14752 = state_14710__$1;
(statearr_14726_14752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (14))){
var inst_14703 = (state_14710[(2)]);
var inst_14704 = cljs.core.async.close_BANG_.call(null,out);
var state_14710__$1 = (function (){var statearr_14728 = state_14710;
(statearr_14728[(13)] = inst_14703);

return statearr_14728;
})();
var statearr_14729_14753 = state_14710__$1;
(statearr_14729_14753[(2)] = inst_14704);

(statearr_14729_14753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (10))){
var inst_14694 = (state_14710[(2)]);
var state_14710__$1 = state_14710;
var statearr_14730_14754 = state_14710__$1;
(statearr_14730_14754[(2)] = inst_14694);

(statearr_14730_14754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14711 === (8))){
var inst_14674 = (state_14710[(7)]);
var inst_14683 = (state_14710[(11)]);
var tmp14727 = inst_14674;
var inst_14674__$1 = tmp14727;
var inst_14675 = inst_14683;
var state_14710__$1 = (function (){var statearr_14731 = state_14710;
(statearr_14731[(7)] = inst_14674__$1);

(statearr_14731[(8)] = inst_14675);

return statearr_14731;
})();
var statearr_14732_14755 = state_14710__$1;
(statearr_14732_14755[(2)] = null);

(statearr_14732_14755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14741,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14741,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14736[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14736[(1)] = (1));

return statearr_14736;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14710){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14737){if((e14737 instanceof Object)){
var ex__7651__auto__ = e14737;
var statearr_14738_14756 = state_14710;
(statearr_14738_14756[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14757 = state_14710;
state_14710 = G__14757;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14710){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14741,out))
})();
var state__7711__auto__ = (function (){var statearr_14739 = f__7710__auto__.call(null);
(statearr_14739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14741);

return statearr_14739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14741,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__14759 = arguments.length;
switch (G__14759) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__7709__auto___14832 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___14832,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___14832,out){
return (function (state_14801){
var state_val_14802 = (state_14801[(1)]);
if((state_val_14802 === (7))){
var inst_14797 = (state_14801[(2)]);
var state_14801__$1 = state_14801;
var statearr_14803_14833 = state_14801__$1;
(statearr_14803_14833[(2)] = inst_14797);

(statearr_14803_14833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (1))){
var inst_14760 = [];
var inst_14761 = inst_14760;
var inst_14762 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14801__$1 = (function (){var statearr_14804 = state_14801;
(statearr_14804[(7)] = inst_14762);

(statearr_14804[(8)] = inst_14761);

return statearr_14804;
})();
var statearr_14805_14834 = state_14801__$1;
(statearr_14805_14834[(2)] = null);

(statearr_14805_14834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (4))){
var inst_14765 = (state_14801[(9)]);
var inst_14765__$1 = (state_14801[(2)]);
var inst_14766 = (inst_14765__$1 == null);
var inst_14767 = cljs.core.not.call(null,inst_14766);
var state_14801__$1 = (function (){var statearr_14806 = state_14801;
(statearr_14806[(9)] = inst_14765__$1);

return statearr_14806;
})();
if(inst_14767){
var statearr_14807_14835 = state_14801__$1;
(statearr_14807_14835[(1)] = (5));

} else {
var statearr_14808_14836 = state_14801__$1;
(statearr_14808_14836[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (15))){
var inst_14791 = (state_14801[(2)]);
var state_14801__$1 = state_14801;
var statearr_14809_14837 = state_14801__$1;
(statearr_14809_14837[(2)] = inst_14791);

(statearr_14809_14837[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (13))){
var state_14801__$1 = state_14801;
var statearr_14810_14838 = state_14801__$1;
(statearr_14810_14838[(2)] = null);

(statearr_14810_14838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (6))){
var inst_14761 = (state_14801[(8)]);
var inst_14786 = inst_14761.length;
var inst_14787 = (inst_14786 > (0));
var state_14801__$1 = state_14801;
if(cljs.core.truth_(inst_14787)){
var statearr_14811_14839 = state_14801__$1;
(statearr_14811_14839[(1)] = (12));

} else {
var statearr_14812_14840 = state_14801__$1;
(statearr_14812_14840[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (3))){
var inst_14799 = (state_14801[(2)]);
var state_14801__$1 = state_14801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14801__$1,inst_14799);
} else {
if((state_val_14802 === (12))){
var inst_14761 = (state_14801[(8)]);
var inst_14789 = cljs.core.vec.call(null,inst_14761);
var state_14801__$1 = state_14801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14801__$1,(15),out,inst_14789);
} else {
if((state_val_14802 === (2))){
var state_14801__$1 = state_14801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14801__$1,(4),ch);
} else {
if((state_val_14802 === (11))){
var inst_14769 = (state_14801[(10)]);
var inst_14765 = (state_14801[(9)]);
var inst_14779 = (state_14801[(2)]);
var inst_14780 = [];
var inst_14781 = inst_14780.push(inst_14765);
var inst_14761 = inst_14780;
var inst_14762 = inst_14769;
var state_14801__$1 = (function (){var statearr_14813 = state_14801;
(statearr_14813[(11)] = inst_14781);

(statearr_14813[(7)] = inst_14762);

(statearr_14813[(8)] = inst_14761);

(statearr_14813[(12)] = inst_14779);

return statearr_14813;
})();
var statearr_14814_14841 = state_14801__$1;
(statearr_14814_14841[(2)] = null);

(statearr_14814_14841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (9))){
var inst_14761 = (state_14801[(8)]);
var inst_14777 = cljs.core.vec.call(null,inst_14761);
var state_14801__$1 = state_14801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14801__$1,(11),out,inst_14777);
} else {
if((state_val_14802 === (5))){
var inst_14769 = (state_14801[(10)]);
var inst_14762 = (state_14801[(7)]);
var inst_14765 = (state_14801[(9)]);
var inst_14769__$1 = f.call(null,inst_14765);
var inst_14770 = cljs.core._EQ_.call(null,inst_14769__$1,inst_14762);
var inst_14771 = cljs.core.keyword_identical_QMARK_.call(null,inst_14762,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14772 = (inst_14770) || (inst_14771);
var state_14801__$1 = (function (){var statearr_14815 = state_14801;
(statearr_14815[(10)] = inst_14769__$1);

return statearr_14815;
})();
if(cljs.core.truth_(inst_14772)){
var statearr_14816_14842 = state_14801__$1;
(statearr_14816_14842[(1)] = (8));

} else {
var statearr_14817_14843 = state_14801__$1;
(statearr_14817_14843[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (14))){
var inst_14794 = (state_14801[(2)]);
var inst_14795 = cljs.core.async.close_BANG_.call(null,out);
var state_14801__$1 = (function (){var statearr_14819 = state_14801;
(statearr_14819[(13)] = inst_14794);

return statearr_14819;
})();
var statearr_14820_14844 = state_14801__$1;
(statearr_14820_14844[(2)] = inst_14795);

(statearr_14820_14844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (10))){
var inst_14784 = (state_14801[(2)]);
var state_14801__$1 = state_14801;
var statearr_14821_14845 = state_14801__$1;
(statearr_14821_14845[(2)] = inst_14784);

(statearr_14821_14845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14802 === (8))){
var inst_14769 = (state_14801[(10)]);
var inst_14761 = (state_14801[(8)]);
var inst_14765 = (state_14801[(9)]);
var inst_14774 = inst_14761.push(inst_14765);
var tmp14818 = inst_14761;
var inst_14761__$1 = tmp14818;
var inst_14762 = inst_14769;
var state_14801__$1 = (function (){var statearr_14822 = state_14801;
(statearr_14822[(7)] = inst_14762);

(statearr_14822[(14)] = inst_14774);

(statearr_14822[(8)] = inst_14761__$1);

return statearr_14822;
})();
var statearr_14823_14846 = state_14801__$1;
(statearr_14823_14846[(2)] = null);

(statearr_14823_14846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___14832,out))
;
return ((function (switch__7647__auto__,c__7709__auto___14832,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_14827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14827[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_14827[(1)] = (1));

return statearr_14827;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_14801){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_14801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e14828){if((e14828 instanceof Object)){
var ex__7651__auto__ = e14828;
var statearr_14829_14847 = state_14801;
(statearr_14829_14847[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14848 = state_14801;
state_14801 = G__14848;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_14801){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_14801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___14832,out))
})();
var state__7711__auto__ = (function (){var statearr_14830 = f__7710__auto__.call(null);
(statearr_14830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___14832);

return statearr_14830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___14832,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
