// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__4264__auto__ = v;
if(cljs.core.truth_(and__4264__auto__)){
return (v > (0));
} else {
return and__4264__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__12163_SHARP_,p2__12162_SHARP_){
var vec__12165 = clojure.string.split.call(null,p2__12162_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__12165,(0),null);
var v = cljs.core.nth.call(null,vec__12165,(1),null);
return cljs.core.assoc.call(null,p1__12163_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__12166_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__12166_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__12167){
var vec__12169 = p__12167;
var k = cljs.core.nth.call(null,vec__12169,(0),null);
var v = cljs.core.nth.call(null,vec__12169,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__12170_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__12170_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__4264__auto__){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/edn"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var c__7709__auto___12207 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12207,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12207,channel){
return (function (state_12197){
var state_val_12198 = (state_12197[(1)]);
if((state_val_12198 === (2))){
var inst_12191 = (state_12197[(2)]);
var inst_12192 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12193 = cljs_http.client.decode_body.call(null,inst_12191,cljs.reader.read_string,"application/edn",inst_12192);
var inst_12194 = cljs.core.async.put_BANG_.call(null,channel,inst_12193);
var inst_12195 = cljs.core.async.close_BANG_.call(null,channel);
var state_12197__$1 = (function (){var statearr_12199 = state_12197;
(statearr_12199[(7)] = inst_12194);

return statearr_12199;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12197__$1,inst_12195);
} else {
if((state_val_12198 === (1))){
var inst_12189 = client.call(null,request);
var state_12197__$1 = state_12197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12197__$1,(2),inst_12189);
} else {
return null;
}
}
});})(c__7709__auto___12207,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___12207,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12203 = [null,null,null,null,null,null,null,null];
(statearr_12203[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__);

(statearr_12203[(1)] = (1));

return statearr_12203;
});
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1 = (function (state_12197){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12204){if((e12204 instanceof Object)){
var ex__7651__auto__ = e12204;
var statearr_12205_12208 = state_12197;
(statearr_12205_12208[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12197);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12209 = state_12197;
state_12197 = G__12209;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = function(state_12197){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1.call(this,state_12197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12207,channel))
})();
var state__7711__auto__ = (function (){var statearr_12206 = f__7710__auto__.call(null);
(statearr_12206[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12207);

return statearr_12206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12207,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12212){
var vec__12213 = p__12212;
var accept = cljs.core.nth.call(null,vec__12213,(0),null);
return ((function (vec__12213,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__12213,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq12210){
var G__12211 = cljs.core.first.call(null,seq12210);
var seq12210__$1 = cljs.core.next.call(null,seq12210);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__12211,seq12210__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12216){
var vec__12217 = p__12216;
var content_type = cljs.core.nth.call(null,vec__12217,(0),null);
return ((function (vec__12217,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__12217,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq12214){
var G__12215 = cljs.core.first.call(null,seq12214);
var seq12214__$1 = cljs.core.next.call(null,seq12214);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__12215,seq12214__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__12219 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__12219__$1 = ((cljs.core.seq_QMARK_.call(null,map__12219))?cljs.core.apply.call(null,cljs.core.hash_map,map__12219):map__12219);
var encoding_opts = cljs.core.get.call(null,map__12219__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var encoding = cljs.core.get.call(null,map__12219__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/transit+json"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var map__12241 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__12241__$1 = ((cljs.core.seq_QMARK_.call(null,map__12241))?cljs.core.apply.call(null,cljs.core.hash_map,map__12241):map__12241);
var decoding_opts = cljs.core.get.call(null,map__12241__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var decoding = cljs.core.get.call(null,map__12241__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var c__7709__auto___12261 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding){
return (function (state_12251){
var state_val_12252 = (state_12251[(1)]);
if((state_val_12252 === (2))){
var inst_12244 = (state_12251[(2)]);
var inst_12245 = (function (){var response = inst_12244;
return ((function (response,inst_12244,state_val_12252,c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding){
return (function (p1__12220_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__12220_SHARP_,decoding,decoding_opts);
});
;})(response,inst_12244,state_val_12252,c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding))
})();
var inst_12246 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12247 = cljs_http.client.decode_body.call(null,inst_12244,inst_12245,"application/transit+json",inst_12246);
var inst_12248 = cljs.core.async.put_BANG_.call(null,channel,inst_12247);
var inst_12249 = cljs.core.async.close_BANG_.call(null,channel);
var state_12251__$1 = (function (){var statearr_12253 = state_12251;
(statearr_12253[(7)] = inst_12248);

return statearr_12253;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12251__$1,inst_12249);
} else {
if((state_val_12252 === (1))){
var inst_12242 = client.call(null,request);
var state_12251__$1 = state_12251;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12251__$1,(2),inst_12242);
} else {
return null;
}
}
});})(c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding))
;
return ((function (switch__7647__auto__,c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12257 = [null,null,null,null,null,null,null,null];
(statearr_12257[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__);

(statearr_12257[(1)] = (1));

return statearr_12257;
});
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1 = (function (state_12251){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12258){if((e12258 instanceof Object)){
var ex__7651__auto__ = e12258;
var statearr_12259_12262 = state_12251;
(statearr_12259_12262[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12251);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12258;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12263 = state_12251;
state_12251 = G__12263;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = function(state_12251){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1.call(this,state_12251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding))
})();
var state__7711__auto__ = (function (){var statearr_12260 = f__7710__auto__.call(null);
(statearr_12260[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12261);

return statearr_12260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12261,channel,map__12241,map__12241__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/json"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var c__7709__auto___12300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12300,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12300,channel){
return (function (state_12290){
var state_val_12291 = (state_12290[(1)]);
if((state_val_12291 === (2))){
var inst_12284 = (state_12290[(2)]);
var inst_12285 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12286 = cljs_http.client.decode_body.call(null,inst_12284,cljs_http.util.json_decode,"application/json",inst_12285);
var inst_12287 = cljs.core.async.put_BANG_.call(null,channel,inst_12286);
var inst_12288 = cljs.core.async.close_BANG_.call(null,channel);
var state_12290__$1 = (function (){var statearr_12292 = state_12290;
(statearr_12292[(7)] = inst_12287);

return statearr_12292;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12290__$1,inst_12288);
} else {
if((state_val_12291 === (1))){
var inst_12282 = client.call(null,request);
var state_12290__$1 = state_12290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12290__$1,(2),inst_12282);
} else {
return null;
}
}
});})(c__7709__auto___12300,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___12300,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12296 = [null,null,null,null,null,null,null,null];
(statearr_12296[(0)] = cljs_http$client$wrap_json_response_$_state_machine__7648__auto__);

(statearr_12296[(1)] = (1));

return statearr_12296;
});
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1 = (function (state_12290){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12297){if((e12297 instanceof Object)){
var ex__7651__auto__ = e12297;
var statearr_12298_12301 = state_12290;
(statearr_12298_12301[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12302 = state_12290;
state_12290 = G__12302;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = function(state_12290){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1.call(this,state_12290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12300,channel))
})();
var state__7711__auto__ = (function (){var statearr_12299 = f__7710__auto__.call(null);
(statearr_12299[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12300);

return statearr_12299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12300,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__12305){
var map__12306 = p__12305;
var map__12306__$1 = ((cljs.core.seq_QMARK_.call(null,map__12306))?cljs.core.apply.call(null,cljs.core.hash_map,map__12306):map__12306);
var req = map__12306__$1;
var query_params = cljs.core.get.call(null,map__12306__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__12309){
var map__12310 = p__12309;
var map__12310__$1 = ((cljs.core.seq_QMARK_.call(null,map__12310))?cljs.core.apply.call(null,cljs.core.hash_map,map__12310):map__12310);
var request = map__12310__$1;
var request_method = cljs.core.get.call(null,map__12310__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var form_params = cljs.core.get.call(null,map__12310__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
if(cljs.core.truth_((function (){var and__4264__auto__ = form_params;
if(cljs.core.truth_(and__4264__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__4264__auto__;
}
})())){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/x-www-form-urlencoded"));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
return client.call(null,(cljs.core.truth_(cljs_http.util.android_QMARK_.call(null))?cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.Keyword(null,"android","android",-2084094573)], null),Math.random.call(null)):request));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__12311_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__12311_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__12315){
var map__12316 = p__12315;
var map__12316__$1 = ((cljs.core.seq_QMARK_.call(null,map__12316))?cljs.core.apply.call(null,cljs.core.hash_map,map__12316):map__12316);
var req = map__12316__$1;
var query_params = cljs.core.get.call(null,map__12316__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4124__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4124__auto__,map__12316,map__12316__$1,req,query_params){
return (function (p1__12312_SHARP_){
return cljs.core.merge.call(null,p1__12312_SHARP_,query_params);
});})(spec,temp__4124__auto__,map__12316,map__12316__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12319){
var vec__12320 = p__12319;
var credentials = cljs.core.nth.call(null,vec__12320,(0),null);
return ((function (vec__12320,credentials){
return (function (req){
var credentials__$1 = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__12320,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq12317){
var G__12318 = cljs.core.first.call(null,seq12317);
var seq12317__$1 = cljs.core.next.call(null,seq12317);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__12318,seq12317__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_android_cors_bugfix.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12323){
var vec__12324 = p__12323;
var req = cljs.core.nth.call(null,vec__12324,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq12321){
var G__12322 = cljs.core.first.call(null,seq12321);
var seq12321__$1 = cljs.core.next.call(null,seq12321);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__12322,seq12321__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12327){
var vec__12328 = p__12327;
var req = cljs.core.nth.call(null,vec__12328,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq12325){
var G__12326 = cljs.core.first.call(null,seq12325);
var seq12325__$1 = cljs.core.next.call(null,seq12325);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__12326,seq12325__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12331){
var vec__12332 = p__12331;
var req = cljs.core.nth.call(null,vec__12332,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq12329){
var G__12330 = cljs.core.first.call(null,seq12329);
var seq12329__$1 = cljs.core.next.call(null,seq12329);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__12330,seq12329__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12335){
var vec__12336 = p__12335;
var req = cljs.core.nth.call(null,vec__12336,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq12333){
var G__12334 = cljs.core.first.call(null,seq12333);
var seq12333__$1 = cljs.core.next.call(null,seq12333);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__12334,seq12333__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12339){
var vec__12340 = p__12339;
var req = cljs.core.nth.call(null,vec__12340,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq12337){
var G__12338 = cljs.core.first.call(null,seq12337);
var seq12337__$1 = cljs.core.next.call(null,seq12337);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__12338,seq12337__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12343){
var vec__12344 = p__12343;
var req = cljs.core.nth.call(null,vec__12344,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq12341){
var G__12342 = cljs.core.first.call(null,seq12341);
var seq12341__$1 = cljs.core.next.call(null,seq12341);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__12342,seq12341__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12347){
var vec__12348 = p__12347;
var req = cljs.core.nth.call(null,vec__12348,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq12345){
var G__12346 = cljs.core.first.call(null,seq12345);
var seq12345__$1 = cljs.core.next.call(null,seq12345);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__12346,seq12345__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12351){
var vec__12352 = p__12351;
var req = cljs.core.nth.call(null,vec__12352,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq12349){
var G__12350 = cljs.core.first.call(null,seq12349);
var seq12349__$1 = cljs.core.next.call(null,seq12349);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__12350,seq12349__$1);
});
