// Compiled by ClojureScript 0.0-3196 {}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.call(null,milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq10450){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10450));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join.call(null,zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq10451){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10451));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_android_cors_bugfix.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__10454){
var vec__10455 = p__10454;
var req = cljs.core.nth.call(null,vec__10455,(0),null);

return milia.api.io.raw_request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq10452){
var G__10453 = cljs.core.first.call(null,seq10452);
var seq10452__$1 = cljs.core.next.call(null,seq10452);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__10453,seq10452__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__10458){
var vec__10459 = p__10458;
var req = cljs.core.nth.call(null,vec__10459,(0),null);

return milia.api.io.raw_request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq10456){
var G__10457 = cljs.core.first.call(null,seq10456);
var seq10456__$1 = cljs.core.next.call(null,seq10456);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__10457,seq10456__$1);
});
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__10464){
var map__10465 = p__10464;
var map__10465__$1 = ((cljs.core.seq_QMARK_.call(null,map__10465))?cljs.core.apply.call(null,cljs.core.hash_map,map__10465):map__10465);
var must_revalidate_QMARK_ = cljs.core.get.call(null,map__10465__$1,new cljs.core.Keyword(null,"must-revalidate?","must-revalidate?",615367201));
var get_crsftoken_QMARK_ = cljs.core.get.call(null,map__10465__$1,new cljs.core.Keyword(null,"get-crsftoken?","get-crsftoken?",-2106616465));
var token = cljs.core.get.call(null,map__10465__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var Authorization = ((function (map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__10460_SHARP_){
if(cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,token));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.assoc.call(null,p1__10460_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join(''));
} else {
return null;
}
});})(map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
var Cache_control = ((function (Authorization,map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__10461_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.call(null,p1__10461_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(Authorization,map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
var X_CSRFToken = ((function (Authorization,Cache_control,map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token){
return (function (p1__10462_SHARP_){
var temp__4126__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var crsf_token = temp__4126__auto__;
return cljs.core.assoc.call(null,p1__10462_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(Authorization,Cache_control,map__10465,map__10465__$1,must_revalidate_QMARK_,get_crsftoken_QMARK_,token))
;
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.juxt.call(null,Authorization,Cache_control,X_CSRFToken).call(null),cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq10463){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10463));
});
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__10470 = null;
var G__10470__1 = (function (url){
return milia$api$io$query_helper.call(null,method).call(null,url,null,null);
});
var G__10470__2 = (function (url,query_params){
return milia$api$io$query_helper.call(null,method).call(null,url,query_params,null);
});
var G__10470__4 = (function() { 
var G__10471__delegate = function (url,query_params,token,p__10468){
var map__10469 = p__10468;
var map__10469__$1 = ((cljs.core.seq_QMARK_.call(null,map__10469))?cljs.core.apply.call(null,cljs.core.hash_map,map__10469):map__10469);
var no_cache_QMARK_ = cljs.core.get.call(null,map__10469__$1,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981));
var http_method = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"get","get",1683182755),cljs_http.client.get,new cljs.core.Keyword(null,"raw-get","raw-get",524046152),milia.api.io.raw_get,new cljs.core.Keyword(null,"post","post",269697687),cljs_http.client.post,new cljs.core.Keyword(null,"raw-post","raw-post",-555212647),milia.api.io.raw_post,new cljs.core.Keyword(null,"delete","delete",-1768633620),cljs_http.client.delete$,new cljs.core.Keyword(null,"put","put",1299772570),cljs_http.client.put,new cljs.core.Keyword(null,"patch","patch",380775109),cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null),method))?new cljs.core.Keyword(null,"form-params","form-params",1884296467):new cljs.core.Keyword(null,"query-params","query-params",900640534));
var headers = milia.api.io.token__GT_headers.call(null,new cljs.core.Keyword(null,"token","token",-1211463215),cljs.core.apply.call(null,cljs.core.str,token),new cljs.core.Keyword(null,"get-crsftoken?","get-crsftoken?",-2106616465),cljs.core._EQ_.call(null,http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"t","t",-1397832519),cljs_hash.md5.md5.call(null,Date.now().toString())], null):null);
var query_params__$1 = cljs.core.merge.call(null,query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xhr","xhr",-177710851),true], null));
return http_method.call(null,url,new cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"headers","headers",-835030129),headers,param_key,query_params__$1], true, false));
};
var G__10471 = function (url,query_params,token,var_args){
var p__10468 = null;
if (arguments.length > 3) {
var G__10472__i = 0, G__10472__a = new Array(arguments.length -  3);
while (G__10472__i < G__10472__a.length) {G__10472__a[G__10472__i] = arguments[G__10472__i + 3]; ++G__10472__i;}
  p__10468 = new cljs.core.IndexedSeq(G__10472__a,0);
} 
return G__10471__delegate.call(this,url,query_params,token,p__10468);};
G__10471.cljs$lang$maxFixedArity = 3;
G__10471.cljs$lang$applyTo = (function (arglist__10473){
var url = cljs.core.first(arglist__10473);
arglist__10473 = cljs.core.next(arglist__10473);
var query_params = cljs.core.first(arglist__10473);
arglist__10473 = cljs.core.next(arglist__10473);
var token = cljs.core.first(arglist__10473);
var p__10468 = cljs.core.rest(arglist__10473);
return G__10471__delegate(url,query_params,token,p__10468);
});
G__10471.cljs$core$IFn$_invoke$arity$variadic = G__10471__delegate;
return G__10471;
})()
;
G__10470 = function(url,query_params,token,var_args){
var p__10468 = var_args;
switch(arguments.length){
case 1:
return G__10470__1.call(this,url);
case 2:
return G__10470__2.call(this,url,query_params);
default:
var G__10474 = null;
if (arguments.length > 3) {
var G__10475__i = 0, G__10475__a = new Array(arguments.length -  3);
while (G__10475__i < G__10475__a.length) {G__10475__a[G__10475__i] = arguments[G__10475__i + 3]; ++G__10475__i;}
G__10474 = new cljs.core.IndexedSeq(G__10475__a,0);
}
return G__10470__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__10474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10470.cljs$lang$maxFixedArity = 3;
G__10470.cljs$lang$applyTo = G__10470__4.cljs$lang$applyTo;
G__10470.cljs$core$IFn$_invoke$arity$1 = G__10470__1;
G__10470.cljs$core$IFn$_invoke$arity$2 = G__10470__2;
G__10470.cljs$core$IFn$_invoke$arity$variadic = G__10470__4.cljs$core$IFn$_invoke$arity$variadic;
return G__10470;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"raw-get","raw-get",524046152));
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"get","get",1683182755));
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620));
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"patch","patch",380775109));
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"raw-post","raw-post",-555212647));
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"post","post",269697687));
milia.api.io.put_url = milia.api.io.query_helper.call(null,new cljs.core.Keyword(null,"put","put",1299772570));
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__10483 = arguments.length;
switch (G__10483) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.call(null,url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.call(null,method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.call(null,method,url,callback,query_params,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_10494){
var state_val_10495 = (state_10494[(1)]);
if((state_val_10495 === (5))){
var inst_10492 = (state_10494[(2)]);
var state_10494__$1 = state_10494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10494__$1,inst_10492);
} else {
if((state_val_10495 === (4))){
var state_10494__$1 = state_10494;
var statearr_10496_10509 = state_10494__$1;
(statearr_10496_10509[(2)] = null);

(statearr_10496_10509[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10495 === (3))){
var inst_10487 = (state_10494[(7)]);
var inst_10489 = callback.call(null,inst_10487);
var state_10494__$1 = state_10494;
var statearr_10497_10510 = state_10494__$1;
(statearr_10497_10510[(2)] = inst_10489);

(statearr_10497_10510[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10495 === (2))){
var inst_10487 = (state_10494[(2)]);
var state_10494__$1 = (function (){var statearr_10498 = state_10494;
(statearr_10498[(7)] = inst_10487);

return statearr_10498;
})();
if(cljs.core.truth_(callback)){
var statearr_10499_10511 = state_10494__$1;
(statearr_10499_10511[(1)] = (3));

} else {
var statearr_10500_10512 = state_10494__$1;
(statearr_10500_10512[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10495 === (1))){
var inst_10484 = milia.api.io.query_helper.call(null,method);
var inst_10485 = inst_10484.call(null,url,query_params,token,opts);
var state_10494__$1 = state_10494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10494__$1,(2),inst_10485);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$state_machine__7648__auto__ = null;
var milia$api$io$state_machine__7648__auto____0 = (function (){
var statearr_10504 = [null,null,null,null,null,null,null,null];
(statearr_10504[(0)] = milia$api$io$state_machine__7648__auto__);

(statearr_10504[(1)] = (1));

return statearr_10504;
});
var milia$api$io$state_machine__7648__auto____1 = (function (state_10494){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_10494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e10505){if((e10505 instanceof Object)){
var ex__7651__auto__ = e10505;
var statearr_10506_10513 = state_10494;
(statearr_10506_10513[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10505;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10514 = state_10494;
state_10494 = G__10514;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$state_machine__7648__auto__ = function(state_10494){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7648__auto____1.call(this,state_10494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7648__auto____0;
milia$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7648__auto____1;
return milia$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_10507 = f__7710__auto__.call(null);
(statearr_10507[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_10507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq10476){
var G__10477 = cljs.core.first.call(null,seq10476);
var seq10476__$1 = cljs.core.next.call(null,seq10476);
var G__10478 = cljs.core.first.call(null,seq10476__$1);
var seq10476__$2 = cljs.core.next.call(null,seq10476__$1);
var G__10479 = cljs.core.first.call(null,seq10476__$2);
var seq10476__$3 = cljs.core.next.call(null,seq10476__$2);
var G__10480 = cljs.core.first.call(null,seq10476__$3);
var seq10476__$4 = cljs.core.next.call(null,seq10476__$3);
var G__10481 = cljs.core.first.call(null,seq10476__$4);
var seq10476__$5 = cljs.core.next.call(null,seq10476__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10477,G__10478,G__10479,G__10480,G__10481,seq10476__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__10516 = arguments.length;
switch (G__10516) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.call(null,event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = dommy.core.attr.call(null,event.target,new cljs.core.Keyword(null,"href","href",-793805698));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = dommy.core.attr.call(null,event.target.form,new cljs.core.Keyword(null,"action","action",-811238024));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__10519 = arguments.length;
switch (G__10519) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.call(null,event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = dommy.core.attr.call(null,event.target,new cljs.core.Keyword(null,"href","href",-793805698));
return milia.api.io.query_helper_BANG_.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_10644){
var state_val_10645 = (state_10644[(1)]);
if((state_val_10645 === (7))){
var inst_10609 = (state_10644[(2)]);
var state_10644__$1 = state_10644;
var statearr_10646_10681 = state_10644__$1;
(statearr_10646_10681[(2)] = inst_10609);

(statearr_10646_10681[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (20))){
var state_10644__$1 = state_10644;
var statearr_10647_10682 = state_10644__$1;
(statearr_10647_10682[(2)] = null);

(statearr_10647_10682[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (1))){
var inst_10601 = (state_10644[(7)]);
var inst_10601__$1 = (auth_token == null);
var state_10644__$1 = (function (){var statearr_10648 = state_10644;
(statearr_10648[(7)] = inst_10601__$1);

return statearr_10648;
})();
if(cljs.core.truth_(inst_10601__$1)){
var statearr_10649_10683 = state_10644__$1;
(statearr_10649_10683[(1)] = (2));

} else {
var statearr_10650_10684 = state_10644__$1;
(statearr_10650_10684[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (4))){
var inst_10611 = (state_10644[(2)]);
var state_10644__$1 = state_10644;
if(cljs.core.truth_(inst_10611)){
var statearr_10651_10685 = state_10644__$1;
(statearr_10651_10685[(1)] = (8));

} else {
var statearr_10652_10686 = state_10644__$1;
(statearr_10652_10686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (15))){
var inst_10624 = (state_10644[(8)]);
var inst_10624__$1 = (state_10644[(2)]);
var inst_10625 = cljs.core.seq_QMARK_.call(null,inst_10624__$1);
var state_10644__$1 = (function (){var statearr_10653 = state_10644;
(statearr_10653[(8)] = inst_10624__$1);

return statearr_10653;
})();
if(inst_10625){
var statearr_10654_10687 = state_10644__$1;
(statearr_10654_10687[(1)] = (16));

} else {
var statearr_10655_10688 = state_10644__$1;
(statearr_10655_10688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (21))){
var inst_10637 = (state_10644[(2)]);
var state_10644__$1 = state_10644;
var statearr_10656_10689 = state_10644__$1;
(statearr_10656_10689[(2)] = inst_10637);

(statearr_10656_10689[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (13))){
var state_10644__$1 = state_10644;
var statearr_10657_10690 = state_10644__$1;
(statearr_10657_10690[(2)] = auth_token);

(statearr_10657_10690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (6))){
var inst_10607 = cljs.core._EQ_.call(null,"null",auth_token);
var state_10644__$1 = state_10644;
var statearr_10658_10691 = state_10644__$1;
(statearr_10658_10691[(2)] = inst_10607);

(statearr_10658_10691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (17))){
var inst_10624 = (state_10644[(8)]);
var state_10644__$1 = state_10644;
var statearr_10659_10692 = state_10644__$1;
(statearr_10659_10692[(2)] = inst_10624);

(statearr_10659_10692[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (3))){
var inst_10604 = (state_10644[(9)]);
var inst_10604__$1 = clojure.string.blank_QMARK_.call(null,auth_token);
var state_10644__$1 = (function (){var statearr_10660 = state_10644;
(statearr_10660[(9)] = inst_10604__$1);

return statearr_10660;
})();
if(cljs.core.truth_(inst_10604__$1)){
var statearr_10661_10693 = state_10644__$1;
(statearr_10661_10693[(1)] = (5));

} else {
var statearr_10662_10694 = state_10644__$1;
(statearr_10662_10694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (12))){
var inst_10621 = milia.api.io.refresh_token_url.call(null,username);
var inst_10622 = milia.api.io.get_url.call(null,inst_10621,null,null,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981),true);
var state_10644__$1 = state_10644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10644__$1,(15),inst_10622);
} else {
if((state_val_10645 === (2))){
var inst_10601 = (state_10644[(7)]);
var state_10644__$1 = state_10644;
var statearr_10663_10695 = state_10644__$1;
(statearr_10663_10695[(2)] = inst_10601);

(statearr_10663_10695[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (19))){
var inst_10631 = (state_10644[(10)]);
var state_10644__$1 = state_10644;
var statearr_10664_10696 = state_10644__$1;
(statearr_10664_10696[(2)] = inst_10631);

(statearr_10664_10696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (11))){
var inst_10617 = (state_10644[(2)]);
var inst_10618 = milia.api.io.invalid_token_QMARK_.call(null,inst_10617);
var state_10644__$1 = state_10644;
if(cljs.core.truth_(inst_10618)){
var statearr_10665_10697 = state_10644__$1;
(statearr_10665_10697[(1)] = (12));

} else {
var statearr_10666_10698 = state_10644__$1;
(statearr_10666_10698[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (9))){
var inst_10614 = milia.api.io.validate_token_url.call(null,username);
var inst_10615 = milia.api.io.get_url.call(null,inst_10614,null,null,new cljs.core.Keyword(null,"no-cache?","no-cache?",-1868220981),true);
var state_10644__$1 = state_10644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10644__$1,(11),inst_10615);
} else {
if((state_val_10645 === (5))){
var inst_10604 = (state_10644[(9)]);
var state_10644__$1 = state_10644;
var statearr_10667_10699 = state_10644__$1;
(statearr_10667_10699[(2)] = inst_10604);

(statearr_10667_10699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (14))){
var inst_10640 = (state_10644[(2)]);
var state_10644__$1 = state_10644;
var statearr_10668_10700 = state_10644__$1;
(statearr_10668_10700[(2)] = inst_10640);

(statearr_10668_10700[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (16))){
var inst_10624 = (state_10644[(8)]);
var inst_10627 = cljs.core.apply.call(null,cljs.core.hash_map,inst_10624);
var state_10644__$1 = state_10644;
var statearr_10669_10701 = state_10644__$1;
(statearr_10669_10701[(2)] = inst_10627);

(statearr_10669_10701[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (10))){
var inst_10642 = (state_10644[(2)]);
var state_10644__$1 = state_10644;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10644__$1,inst_10642);
} else {
if((state_val_10645 === (18))){
var inst_10630 = (state_10644[(2)]);
var inst_10631 = cljs.core.get.call(null,inst_10630,new cljs.core.Keyword(null,"body","body",-2049205669));
var inst_10632 = cljs.core.get.call(null,inst_10630,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_10633 = cljs.core._EQ_.call(null,inst_10632,(200));
var state_10644__$1 = (function (){var statearr_10670 = state_10644;
(statearr_10670[(10)] = inst_10631);

return statearr_10670;
})();
if(inst_10633){
var statearr_10671_10702 = state_10644__$1;
(statearr_10671_10702[(1)] = (19));

} else {
var statearr_10672_10703 = state_10644__$1;
(statearr_10672_10703[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10645 === (8))){
var state_10644__$1 = state_10644;
var statearr_10673_10704 = state_10644__$1;
(statearr_10673_10704[(2)] = null);

(statearr_10673_10704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7648__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_10677 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10677[(0)] = milia$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_10677[(1)] = (1));

return statearr_10677;
});
var milia$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_10644){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_10644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e10678){if((e10678 instanceof Object)){
var ex__7651__auto__ = e10678;
var statearr_10679_10705 = state_10644;
(statearr_10679_10705[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10644);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10678;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10706 = state_10644;
state_10644 = G__10706;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7648__auto__ = function(state_10644){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_10644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7648__auto____0;
milia$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7648__auto____1;
return milia$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_10680 = f__7710__auto__.call(null);
(statearr_10680[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_10680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
goog.events.listen(io_obj,goog.net.EventType.SUCCESS,((function (io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"success?","success?",-122854052),true,new cljs.core.Keyword(null,"io-obj","io-obj",2062337291),io_obj], null));
});})(io_obj,url))
);

goog.events.listen(io_obj,goog.net.EventType.ERROR,((function (io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.call(null,chan,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"success?","success?",-122854052),false,new cljs.core.Keyword(null,"io-obj","io-obj",2062337291),io_obj], null));
});})(io_obj,url))
);

return io_obj.sendFromForm(form,url);
});
