// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__4264__auto__ = v;
if(cljs.core.truth_(and__4264__auto__)){
return (v > (0));
} else {
return and__4264__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__12160_SHARP_,p2__12159_SHARP_){
var vec__12162 = clojure.string.split.call(null,p2__12159_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__12162,(0),null);
var v = cljs.core.nth.call(null,vec__12162,(1),null);
return cljs.core.assoc.call(null,p1__12160_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not.call(null,clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__12163_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__12163_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__12164){
var vec__12166 = p__12164;
var k = cljs.core.nth.call(null,vec__12166,(0),null);
var v = cljs.core.nth.call(null,vec__12166,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__12167_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__12167_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__4264__auto__){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/edn"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var c__7709__auto___12204 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12204,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12204,channel){
return (function (state_12194){
var state_val_12195 = (state_12194[(1)]);
if((state_val_12195 === (2))){
var inst_12188 = (state_12194[(2)]);
var inst_12189 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12190 = cljs_http.client.decode_body.call(null,inst_12188,cljs.reader.read_string,"application/edn",inst_12189);
var inst_12191 = cljs.core.async.put_BANG_.call(null,channel,inst_12190);
var inst_12192 = cljs.core.async.close_BANG_.call(null,channel);
var state_12194__$1 = (function (){var statearr_12196 = state_12194;
(statearr_12196[(7)] = inst_12191);

return statearr_12196;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12194__$1,inst_12192);
} else {
if((state_val_12195 === (1))){
var inst_12186 = client.call(null,request);
var state_12194__$1 = state_12194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12194__$1,(2),inst_12186);
} else {
return null;
}
}
});})(c__7709__auto___12204,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___12204,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12200 = [null,null,null,null,null,null,null,null];
(statearr_12200[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__);

(statearr_12200[(1)] = (1));

return statearr_12200;
});
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1 = (function (state_12194){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12201){if((e12201 instanceof Object)){
var ex__7651__auto__ = e12201;
var statearr_12202_12205 = state_12194;
(statearr_12202_12205[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12194);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12201;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12206 = state_12194;
state_12194 = G__12206;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = function(state_12194){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1.call(this,state_12194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12204,channel))
})();
var state__7711__auto__ = (function (){var statearr_12203 = f__7710__auto__.call(null);
(statearr_12203[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12204);

return statearr_12203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12204,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12209){
var vec__12210 = p__12209;
var accept = cljs.core.nth.call(null,vec__12210,(0),null);
return ((function (vec__12210,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__12210,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq12207){
var G__12208 = cljs.core.first.call(null,seq12207);
var seq12207__$1 = cljs.core.next.call(null,seq12207);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__12208,seq12207__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12213){
var vec__12214 = p__12213;
var content_type = cljs.core.nth.call(null,vec__12214,(0),null);
return ((function (vec__12214,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__12214,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq12211){
var G__12212 = cljs.core.first.call(null,seq12211);
var seq12211__$1 = cljs.core.next.call(null,seq12211);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__12212,seq12211__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__12216 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__12216__$1 = ((cljs.core.seq_QMARK_.call(null,map__12216))?cljs.core.apply.call(null,cljs.core.hash_map,map__12216):map__12216);
var encoding_opts = cljs.core.get.call(null,map__12216__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var encoding = cljs.core.get.call(null,map__12216__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/transit+json"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var map__12238 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__12238__$1 = ((cljs.core.seq_QMARK_.call(null,map__12238))?cljs.core.apply.call(null,cljs.core.hash_map,map__12238):map__12238);
var decoding_opts = cljs.core.get.call(null,map__12238__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var decoding = cljs.core.get.call(null,map__12238__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var c__7709__auto___12258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding){
return (function (state_12248){
var state_val_12249 = (state_12248[(1)]);
if((state_val_12249 === (2))){
var inst_12241 = (state_12248[(2)]);
var inst_12242 = (function (){var response = inst_12241;
return ((function (response,inst_12241,state_val_12249,c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding){
return (function (p1__12217_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__12217_SHARP_,decoding,decoding_opts);
});
;})(response,inst_12241,state_val_12249,c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding))
})();
var inst_12243 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12244 = cljs_http.client.decode_body.call(null,inst_12241,inst_12242,"application/transit+json",inst_12243);
var inst_12245 = cljs.core.async.put_BANG_.call(null,channel,inst_12244);
var inst_12246 = cljs.core.async.close_BANG_.call(null,channel);
var state_12248__$1 = (function (){var statearr_12250 = state_12248;
(statearr_12250[(7)] = inst_12245);

return statearr_12250;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12248__$1,inst_12246);
} else {
if((state_val_12249 === (1))){
var inst_12239 = client.call(null,request);
var state_12248__$1 = state_12248;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12248__$1,(2),inst_12239);
} else {
return null;
}
}
});})(c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding))
;
return ((function (switch__7647__auto__,c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12254 = [null,null,null,null,null,null,null,null];
(statearr_12254[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__);

(statearr_12254[(1)] = (1));

return statearr_12254;
});
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1 = (function (state_12248){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12255){if((e12255 instanceof Object)){
var ex__7651__auto__ = e12255;
var statearr_12256_12259 = state_12248;
(statearr_12256_12259[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12255;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12260 = state_12248;
state_12248 = G__12260;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = function(state_12248){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1.call(this,state_12248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding))
})();
var state__7711__auto__ = (function (){var statearr_12257 = f__7710__auto__.call(null);
(statearr_12257[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12258);

return statearr_12257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12258,channel,map__12238,map__12238__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/json"));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request.call(null,request);
var c__7709__auto___12297 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__7709__auto___12297,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___12297,channel){
return (function (state_12287){
var state_val_12288 = (state_12287[(1)]);
if((state_val_12288 === (2))){
var inst_12281 = (state_12287[(2)]);
var inst_12282 = new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request);
var inst_12283 = cljs_http.client.decode_body.call(null,inst_12281,cljs_http.util.json_decode,"application/json",inst_12282);
var inst_12284 = cljs.core.async.put_BANG_.call(null,channel,inst_12283);
var inst_12285 = cljs.core.async.close_BANG_.call(null,channel);
var state_12287__$1 = (function (){var statearr_12289 = state_12287;
(statearr_12289[(7)] = inst_12284);

return statearr_12289;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12287__$1,inst_12285);
} else {
if((state_val_12288 === (1))){
var inst_12279 = client.call(null,request);
var state_12287__$1 = state_12287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12287__$1,(2),inst_12279);
} else {
return null;
}
}
});})(c__7709__auto___12297,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___12297,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0 = (function (){
var statearr_12293 = [null,null,null,null,null,null,null,null];
(statearr_12293[(0)] = cljs_http$client$wrap_json_response_$_state_machine__7648__auto__);

(statearr_12293[(1)] = (1));

return statearr_12293;
});
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1 = (function (state_12287){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__.call(null,state_12287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__7650__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e12294){if((e12294 instanceof Object)){
var ex__7651__auto__ = e12294;
var statearr_12295_12298 = state_12287;
(statearr_12295_12298[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12287);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12294;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__7649__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12299 = state_12287;
state_12287 = G__12299;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = function(state_12287){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1.call(this,state_12287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___12297,channel))
})();
var state__7711__auto__ = (function (){var statearr_12296 = f__7710__auto__.call(null);
(statearr_12296[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___12297);

return statearr_12296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__7711__auto__);
});})(c__7709__auto___12297,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__12302){
var map__12303 = p__12302;
var map__12303__$1 = ((cljs.core.seq_QMARK_.call(null,map__12303))?cljs.core.apply.call(null,cljs.core.hash_map,map__12303):map__12303);
var req = map__12303__$1;
var query_params = cljs.core.get.call(null,map__12303__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__12306){
var map__12307 = p__12306;
var map__12307__$1 = ((cljs.core.seq_QMARK_.call(null,map__12307))?cljs.core.apply.call(null,cljs.core.hash_map,map__12307):map__12307);
var request = map__12307__$1;
var request_method = cljs.core.get.call(null,map__12307__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var form_params = cljs.core.get.call(null,map__12307__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
if(cljs.core.truth_((function (){var and__4264__auto__ = form_params;
if(cljs.core.truth_(and__4264__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__4264__auto__;
}
})())){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),"application/x-www-form-urlencoded"));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
return client.call(null,(cljs.core.truth_(cljs_http.util.android_QMARK_.call(null))?cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.Keyword(null,"android","android",-2084094573)], null),Math.random.call(null)):request));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__12308_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__12308_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__12312){
var map__12313 = p__12312;
var map__12313__$1 = ((cljs.core.seq_QMARK_.call(null,map__12313))?cljs.core.apply.call(null,cljs.core.hash_map,map__12313):map__12313);
var req = map__12313__$1;
var query_params = cljs.core.get.call(null,map__12313__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4124__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4124__auto__,map__12313,map__12313__$1,req,query_params){
return (function (p1__12309_SHARP_){
return cljs.core.merge.call(null,p1__12309_SHARP_,query_params);
});})(spec,temp__4124__auto__,map__12313,map__12313__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__12316){
var vec__12317 = p__12316;
var credentials = cljs.core.nth.call(null,vec__12317,(0),null);
return ((function (vec__12317,credentials){
return (function (req){
var credentials__$1 = (function (){var or__4276__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__12317,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq12314){
var G__12315 = cljs.core.first.call(null,seq12314);
var seq12314__$1 = cljs.core.next.call(null,seq12314);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__12315,seq12314__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_android_cors_bugfix.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12320){
var vec__12321 = p__12320;
var req = cljs.core.nth.call(null,vec__12321,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq12318){
var G__12319 = cljs.core.first.call(null,seq12318);
var seq12318__$1 = cljs.core.next.call(null,seq12318);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__12319,seq12318__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12324){
var vec__12325 = p__12324;
var req = cljs.core.nth.call(null,vec__12325,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq12322){
var G__12323 = cljs.core.first.call(null,seq12322);
var seq12322__$1 = cljs.core.next.call(null,seq12322);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__12323,seq12322__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12328){
var vec__12329 = p__12328;
var req = cljs.core.nth.call(null,vec__12329,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq12326){
var G__12327 = cljs.core.first.call(null,seq12326);
var seq12326__$1 = cljs.core.next.call(null,seq12326);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__12327,seq12326__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12332){
var vec__12333 = p__12332;
var req = cljs.core.nth.call(null,vec__12333,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq12330){
var G__12331 = cljs.core.first.call(null,seq12330);
var seq12330__$1 = cljs.core.next.call(null,seq12330);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__12331,seq12330__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12336){
var vec__12337 = p__12336;
var req = cljs.core.nth.call(null,vec__12337,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq12334){
var G__12335 = cljs.core.first.call(null,seq12334);
var seq12334__$1 = cljs.core.next.call(null,seq12334);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__12335,seq12334__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12340){
var vec__12341 = p__12340;
var req = cljs.core.nth.call(null,vec__12341,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq12338){
var G__12339 = cljs.core.first.call(null,seq12338);
var seq12338__$1 = cljs.core.next.call(null,seq12338);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__12339,seq12338__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12344){
var vec__12345 = p__12344;
var req = cljs.core.nth.call(null,vec__12345,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq12342){
var G__12343 = cljs.core.first.call(null,seq12342);
var seq12342__$1 = cljs.core.next.call(null,seq12342);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__12343,seq12342__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__12348){
var vec__12349 = p__12348;
var req = cljs.core.nth.call(null,vec__12349,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq12346){
var G__12347 = cljs.core.first.call(null,seq12346);
var seq12346__$1 = cljs.core.next.call(null,seq12346);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__12347,seq12346__$1);
});
