// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
cljs.core.async.impl.ioc_helpers.FN_IDX = (0);
cljs.core.async.impl.ioc_helpers.STATE_IDX = (1);
cljs.core.async.impl.ioc_helpers.VALUE_IDX = (2);
cljs.core.async.impl.ioc_helpers.BINDINGS_IDX = (3);
cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES = (4);
cljs.core.async.impl.ioc_helpers.CURRENT_EXCEPTION = (5);
cljs.core.async.impl.ioc_helpers.USER_START_IDX = (6);
cljs.core.async.impl.ioc_helpers.aset_object = (function cljs$core$async$impl$ioc_helpers$aset_object(arr,idx,o){
return (arr[idx][o]);
});
cljs.core.async.impl.ioc_helpers.aget_object = (function cljs$core$async$impl$ioc_helpers$aget_object(arr,idx){
return (arr[idx]);
});
/**
 * Returns true if the machine is in a finished state
 */
cljs.core.async.impl.ioc_helpers.finished_QMARK_ = (function cljs$core$async$impl$ioc_helpers$finished_QMARK_(state_array){
return cljs.core.keyword_identical_QMARK_((state_array[cljs.core.async.impl.ioc_helpers.STATE_IDX]),cljs.core.constant$keyword$finished);
});
cljs.core.async.impl.ioc_helpers.fn_handler = (function cljs$core$async$impl$ioc_helpers$fn_handler(f){
if(typeof cljs.core.async.impl.ioc_helpers.t47067 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.impl.ioc_helpers.t47067 = (function (f,fn_handler,meta47068){
this.f = f;
this.fn_handler = fn_handler;
this.meta47068 = meta47068;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.impl.ioc_helpers.t47067.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.impl.ioc_helpers.t47067.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.impl.ioc_helpers.t47067.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.impl.ioc_helpers.t47067.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47069){
var self__ = this;
var _47069__$1 = this;
return self__.meta47068;
});

cljs.core.async.impl.ioc_helpers.t47067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47069,meta47068__$1){
var self__ = this;
var _47069__$1 = this;
return (new cljs.core.async.impl.ioc_helpers.t47067(self__.f,self__.fn_handler,meta47068__$1));
});

cljs.core.async.impl.ioc_helpers.t47067.cljs$lang$type = true;

cljs.core.async.impl.ioc_helpers.t47067.cljs$lang$ctorStr = "cljs.core.async.impl.ioc-helpers/t47067";

cljs.core.async.impl.ioc_helpers.t47067.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async.impl.ioc-helpers/t47067");
});

cljs.core.async.impl.ioc_helpers.__GT_t47067 = (function cljs$core$async$impl$ioc_helpers$fn_handler_$___GT_t47067(f__$1,fn_handler__$1,meta47068){
return (new cljs.core.async.impl.ioc_helpers.t47067(f__$1,fn_handler__$1,meta47068));
});

}

return (new cljs.core.async.impl.ioc_helpers.t47067(f,cljs$core$async$impl$ioc_helpers$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.impl.ioc_helpers.run_state_machine = (function cljs$core$async$impl$ioc_helpers$run_state_machine(state){
return cljs.core.async.impl.ioc_helpers.aget_object(state,cljs.core.async.impl.ioc_helpers.FN_IDX).call(null,state);
});
cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped = (function cljs$core$async$impl$ioc_helpers$run_state_machine_wrapped(state){
try{return cljs.core.async.impl.ioc_helpers.run_state_machine(state);
}catch (e47071){if((e47071 instanceof Object)){
var ex = e47071;
cljs.core.async.impl.ioc_helpers.aget_object(state,cljs.core.async.impl.ioc_helpers.USER_START_IDX).cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1(null);

throw ex;
} else {
throw e47071;

}
}});
cljs.core.async.impl.ioc_helpers.take_BANG_ = (function cljs$core$async$impl$ioc_helpers$take_BANG_(state,blk,c){
var temp__4124__auto__ = c.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2(null,cljs.core.async.impl.ioc_helpers.fn_handler((function (x){
var statearr_47075_47078 = state;
(statearr_47075_47078[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = x);

(statearr_47075_47078[cljs.core.async.impl.ioc_helpers.STATE_IDX] = blk);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
})));
if(cljs.core.truth_(temp__4124__auto__)){
var cb = temp__4124__auto__;
var statearr_47076_47079 = state;
(statearr_47076_47079[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__47077 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__47077) : cljs.core.deref.call(null,G__47077));
})());

(statearr_47076_47079[cljs.core.async.impl.ioc_helpers.STATE_IDX] = blk);


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});
cljs.core.async.impl.ioc_helpers.put_BANG_ = (function cljs$core$async$impl$ioc_helpers$put_BANG_(state,blk,c,val){
var temp__4124__auto__ = c.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3(null,val,cljs.core.async.impl.ioc_helpers.fn_handler((function (ret_val){
var statearr_47083_47086 = state;
(statearr_47083_47086[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = ret_val);

(statearr_47083_47086[cljs.core.async.impl.ioc_helpers.STATE_IDX] = blk);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
})));
if(cljs.core.truth_(temp__4124__auto__)){
var cb = temp__4124__auto__;
var statearr_47084_47087 = state;
(statearr_47084_47087[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__47085 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__47085) : cljs.core.deref.call(null,G__47085));
})());

(statearr_47084_47087[cljs.core.async.impl.ioc_helpers.STATE_IDX] = blk);


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});
cljs.core.async.impl.ioc_helpers.return_chan = (function cljs$core$async$impl$ioc_helpers$return_chan(state,value){
var c = (state[cljs.core.async.impl.ioc_helpers.USER_START_IDX]);
if((value == null)){
} else {
c.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3(null,value,cljs.core.async.impl.ioc_helpers.fn_handler(((function (c){
return (function (){
return null;
});})(c))
));
}

c.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1(null);

return c;
});

/**
* @constructor
* @param {*} catch_block
* @param {*} catch_exception
* @param {*} finally_block
* @param {*} continue_block
* @param {*} prev
* @param {*} __meta
* @param {*} __extmap
* @param {*} __hash
* @param {*=} __meta 
* @param {*=} __extmap
* @param {number|null} __hash
*/
cljs.core.async.impl.ioc_helpers.ExceptionFrame = (function (catch_block,catch_exception,finally_block,continue_block,prev,__meta,__extmap,__hash){
this.catch_block = catch_block;
this.catch_exception = catch_exception;
this.finally_block = finally_block;
this.continue_block = continue_block;
this.prev = prev;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4871__auto__,k__4872__auto__){
var self__ = this;
var this__4871__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__4871__auto____$1,k__4872__auto__,null);
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4873__auto__,k47089,else__4874__auto__){
var self__ = this;
var this__4873__auto____$1 = this;
var G__47091 = (((k47089 instanceof cljs.core.Keyword))?k47089.fqn:null);
switch (G__47091) {
case "prev":
return self__.prev;

break;
case "continue-block":
return self__.continue_block;

break;
case "finally-block":
return self__.finally_block;

break;
case "catch-exception":
return self__.catch_exception;

break;
case "catch-block":
return self__.catch_block;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47089,else__4874__auto__);

}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4885__auto__,writer__4886__auto__,opts__4887__auto__){
var self__ = this;
var this__4885__auto____$1 = this;
var pr_pair__4888__auto__ = ((function (this__4885__auto____$1){
return (function (keyval__4889__auto__){
return cljs.core.pr_sequential_writer(writer__4886__auto__,cljs.core.pr_writer,""," ","",opts__4887__auto__,keyval__4889__auto__);
});})(this__4885__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4886__auto__,pr_pair__4888__auto__,"#cljs.core.async.impl.ioc-helpers.ExceptionFrame{",", ","}",opts__4887__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$catch_DASH_block,self__.catch_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$catch_DASH_exception,self__.catch_exception],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$finally_DASH_block,self__.finally_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$continue_DASH_block,self__.continue_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$prev,self__.prev],null))], null),self__.__extmap));
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4869__auto__){
var self__ = this;
var this__4869__auto____$1 = this;
return self__.__meta;
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4865__auto__){
var self__ = this;
var this__4865__auto____$1 = this;
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,self__.continue_block,self__.prev,self__.__meta,self__.__extmap,self__.__hash));
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4875__auto__){
var self__ = this;
var this__4875__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4866__auto__){
var self__ = this;
var this__4866__auto____$1 = this;
var h__4692__auto__ = self__.__hash;
if(!((h__4692__auto__ == null))){
return h__4692__auto__;
} else {
var h__4692__auto____$1 = cljs.core.hash_imap(this__4866__auto____$1);
self__.__hash = h__4692__auto____$1;

return h__4692__auto____$1;
}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__4867__auto__,other__4868__auto__){
var self__ = this;
var this__4867__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4264__auto__ = other__4868__auto__;
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = (this__4867__auto____$1.constructor === other__4868__auto__.constructor);
if(and__4264__auto____$1){
return cljs.core.equiv_map(this__4867__auto____$1,other__4868__auto__);
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4880__auto__,k__4881__auto__){
var self__ = this;
var this__4880__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.constant$keyword$finally_DASH_block,null,cljs.core.constant$keyword$catch_DASH_block,null,cljs.core.constant$keyword$catch_DASH_exception,null,cljs.core.constant$keyword$prev,null,cljs.core.constant$keyword$continue_DASH_block,null], null), null),k__4881__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4880__auto____$1),self__.__meta),k__4881__auto__);
} else {
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,self__.continue_block,self__.prev,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4881__auto__)),null));
}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4878__auto__,k__4879__auto__,G__47088){
var self__ = this;
var this__4878__auto____$1 = this;
var pred__47092 = cljs.core.keyword_identical_QMARK_;
var expr__47093 = k__4879__auto__;
if(cljs.core.truth_((function (){var G__47095 = cljs.core.constant$keyword$catch_DASH_block;
var G__47096 = expr__47093;
return (pred__47092.cljs$core$IFn$_invoke$arity$2 ? pred__47092.cljs$core$IFn$_invoke$arity$2(G__47095,G__47096) : pred__47092.call(null,G__47095,G__47096));
})())){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(G__47088,self__.catch_exception,self__.finally_block,self__.continue_block,self__.prev,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47097 = cljs.core.constant$keyword$catch_DASH_exception;
var G__47098 = expr__47093;
return (pred__47092.cljs$core$IFn$_invoke$arity$2 ? pred__47092.cljs$core$IFn$_invoke$arity$2(G__47097,G__47098) : pred__47092.call(null,G__47097,G__47098));
})())){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,G__47088,self__.finally_block,self__.continue_block,self__.prev,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47099 = cljs.core.constant$keyword$finally_DASH_block;
var G__47100 = expr__47093;
return (pred__47092.cljs$core$IFn$_invoke$arity$2 ? pred__47092.cljs$core$IFn$_invoke$arity$2(G__47099,G__47100) : pred__47092.call(null,G__47099,G__47100));
})())){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,G__47088,self__.continue_block,self__.prev,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47101 = cljs.core.constant$keyword$continue_DASH_block;
var G__47102 = expr__47093;
return (pred__47092.cljs$core$IFn$_invoke$arity$2 ? pred__47092.cljs$core$IFn$_invoke$arity$2(G__47101,G__47102) : pred__47092.call(null,G__47101,G__47102));
})())){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,G__47088,self__.prev,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47103 = cljs.core.constant$keyword$prev;
var G__47104 = expr__47093;
return (pred__47092.cljs$core$IFn$_invoke$arity$2 ? pred__47092.cljs$core$IFn$_invoke$arity$2(G__47103,G__47104) : pred__47092.call(null,G__47103,G__47104));
})())){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,self__.continue_block,G__47088,self__.__meta,self__.__extmap,null));
} else {
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,self__.continue_block,self__.prev,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4879__auto__,G__47088),null));
}
}
}
}
}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4883__auto__){
var self__ = this;
var this__4883__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$catch_DASH_block,self__.catch_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$catch_DASH_exception,self__.catch_exception],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$finally_DASH_block,self__.finally_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$continue_DASH_block,self__.continue_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.constant$keyword$prev,self__.prev],null))], null),self__.__extmap));
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4870__auto__,G__47088){
var self__ = this;
var this__4870__auto____$1 = this;
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(self__.catch_block,self__.catch_exception,self__.finally_block,self__.continue_block,self__.prev,G__47088,self__.__extmap,self__.__hash));
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4876__auto__,entry__4877__auto__){
var self__ = this;
var this__4876__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4877__auto__)){
return cljs.core._assoc(this__4876__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4877__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4877__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4876__auto____$1,entry__4877__auto__);
}
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.cljs$lang$type = true;

cljs.core.async.impl.ioc_helpers.ExceptionFrame.cljs$lang$ctorPrSeq = (function (this__4905__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"cljs.core.async.impl.ioc-helpers/ExceptionFrame");
});

cljs.core.async.impl.ioc_helpers.ExceptionFrame.cljs$lang$ctorPrWriter = (function (this__4905__auto__,writer__4906__auto__){
return cljs.core._write(writer__4906__auto__,"cljs.core.async.impl.ioc-helpers/ExceptionFrame");
});

cljs.core.async.impl.ioc_helpers.__GT_ExceptionFrame = (function cljs$core$async$impl$ioc_helpers$__GT_ExceptionFrame(catch_block,catch_exception,finally_block,continue_block,prev){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(catch_block,catch_exception,finally_block,continue_block,prev,null,null,null));
});

cljs.core.async.impl.ioc_helpers.map__GT_ExceptionFrame = (function cljs$core$async$impl$ioc_helpers$map__GT_ExceptionFrame(G__47090){
return (new cljs.core.async.impl.ioc_helpers.ExceptionFrame(cljs.core.constant$keyword$catch_DASH_block.cljs$core$IFn$_invoke$arity$1(G__47090),cljs.core.constant$keyword$catch_DASH_exception.cljs$core$IFn$_invoke$arity$1(G__47090),cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(G__47090),cljs.core.constant$keyword$continue_DASH_block.cljs$core$IFn$_invoke$arity$1(G__47090),cljs.core.constant$keyword$prev.cljs$core$IFn$_invoke$arity$1(G__47090),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47090,cljs.core.constant$keyword$catch_DASH_block,cljs.core.array_seq([cljs.core.constant$keyword$catch_DASH_exception,cljs.core.constant$keyword$finally_DASH_block,cljs.core.constant$keyword$continue_DASH_block,cljs.core.constant$keyword$prev], 0)),null));
});

cljs.core.async.impl.ioc_helpers.add_exception_frame = (function cljs$core$async$impl$ioc_helpers$add_exception_frame(state,catch_block,catch_exception,finally_block,continue_block){
var statearr_47107 = state;
(statearr_47107[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.async.impl.ioc_helpers.__GT_ExceptionFrame(catch_block,catch_exception,finally_block,continue_block,cljs.core.async.impl.ioc_helpers.aget_object(state,cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES)));

return statearr_47107;
});
cljs.core.async.impl.ioc_helpers.process_exception = (function cljs$core$async$impl$ioc_helpers$process_exception(state){
while(true){
var exception_frame = cljs.core.async.impl.ioc_helpers.aget_object(state,cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES);
var catch_block = cljs.core.constant$keyword$catch_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame);
var catch_exception = cljs.core.constant$keyword$catch_DASH_exception.cljs$core$IFn$_invoke$arity$1(exception_frame);
var exception = cljs.core.async.impl.ioc_helpers.aget_object(state,cljs.core.async.impl.ioc_helpers.CURRENT_EXCEPTION);
if(cljs.core.truth_((function (){var and__4264__auto__ = exception;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(exception_frame);
} else {
return and__4264__auto__;
}
})())){
throw exception;
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = exception;
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = catch_block;
if(cljs.core.truth_(and__4264__auto____$1)){
return (exception instanceof catch_exception);
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})())){
var statearr_47113 = state;
(statearr_47113[cljs.core.async.impl.ioc_helpers.STATE_IDX] = catch_block);

(statearr_47113[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = exception);

(statearr_47113[cljs.core.async.impl.ioc_helpers.CURRENT_EXCEPTION] = null);

(statearr_47113[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(exception_frame,cljs.core.constant$keyword$catch_DASH_block,null,cljs.core.array_seq([cljs.core.constant$keyword$catch_DASH_exception,null], 0)));

return statearr_47113;
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = exception;
if(cljs.core.truth_(and__4264__auto__)){
return (cljs.core.not(catch_block)) && (cljs.core.not(cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame)));
} else {
return and__4264__auto__;
}
})())){
var statearr_47114_47118 = state;
(statearr_47114_47118[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.constant$keyword$prev.cljs$core$IFn$_invoke$arity$1(exception_frame));


var G__47119 = state;
state = G__47119;
continue;
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = exception;
if(cljs.core.truth_(and__4264__auto__)){
var and__4264__auto____$1 = cljs.core.not(catch_block);
if(and__4264__auto____$1){
return cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame);
} else {
return and__4264__auto____$1;
}
} else {
return and__4264__auto__;
}
})())){
var statearr_47115 = state;
(statearr_47115[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame));

(statearr_47115[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(exception_frame,cljs.core.constant$keyword$finally_DASH_block,null));

return statearr_47115;
} else {
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not(exception);
if(and__4264__auto__){
return cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame);
} else {
return and__4264__auto__;
}
})())){
var statearr_47116 = state;
(statearr_47116[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame));

(statearr_47116[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(exception_frame,cljs.core.constant$keyword$finally_DASH_block,null));

return statearr_47116;
} else {
if((cljs.core.not(exception)) && (cljs.core.not(cljs.core.constant$keyword$finally_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame)))){
var statearr_47117 = state;
(statearr_47117[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cljs.core.constant$keyword$continue_DASH_block.cljs$core$IFn$_invoke$arity$1(exception_frame));

(statearr_47117[cljs.core.async.impl.ioc_helpers.EXCEPTION_FRAMES] = cljs.core.constant$keyword$prev.cljs$core$IFn$_invoke$arity$1(exception_frame));

return statearr_47117;
} else {
throw (new Error("No matching clause"));

}
}
}
}
}
}
break;
}
});
