// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var http_options__$1 = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?http_options:(function (){var G__32805 = http_options;
var G__32806 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,cljs.core.constant$keyword$query_DASH_params], null);
return (milia.api.io.rename_keys.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.rename_keys.cljs$core$IFn$_invoke$arity$2(G__32805,G__32806) : milia.api.io.rename_keys.call(null,G__32805,G__32806));
})());
if(cljs.core.truth_(no_cache_QMARK_)){
return cljs.core.assoc_in(http_options__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$t], null),(function (){var G__32807 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32807) : cljs_hash.md5.md5.call(null,G__32807));
})());
} else {
return http_options__$1;
}
});
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__9222__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9222__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq32808){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32808));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_client_url = (function milia$api$io$make_client_url(){
var argseq__9222__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__9222__auto__);
});

milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_client_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_client_url.cljs$lang$applyTo = (function (seq32809){
return milia.api.io.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32809));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32812){
var vec__32813 = p__32812;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32813,(0),null);

var G__32814 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32814) : milia.api.io.raw_request.call(null,G__32814));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq32810){
var G__32811 = cljs.core.first(seq32810);
var seq32810__$1 = cljs.core.next(seq32810);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__32811,seq32810__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32817){
var vec__32818 = p__32817;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32818,(0),null);

var G__32819 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32819) : milia.api.io.raw_request.call(null,G__32819));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq32815){
var G__32816 = cljs.core.first(seq32815);
var seq32815__$1 = cljs.core.next(seq32815);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__32816,seq32815__$1);
});
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var argseq__9222__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__9222__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__32824){
var map__32825 = p__32824;
var map__32825__$1 = ((cljs.core.seq_QMARK_(map__32825))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32825):map__32825);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32825__$1,cljs.core.constant$keyword$token);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32825__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32825__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var Authorization = ((function (map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32820_SHARP_){
if(cljs.core.truth_(clojure.string.blank_QMARK_(token))){
return null;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32820_SHARP_,"Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join(''));
}
});})(map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var Cache_control = ((function (Authorization,map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32821_SHARP_){
if(cljs.core.truth_(must_revalidate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32821_SHARP_,"Cache-control","must-revalidate");
} else {
return null;
}
});})(Authorization,map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
var X_CSRFToken = ((function (Authorization,Cache_control,map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_){
return (function (p1__32822_SHARP_){
var temp__4425__auto__ = (function (){var and__8170__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__8170__auto__)){
var G__32826 = "csrftoken";
return goog.net.cookies.get(G__32826);
} else {
return and__8170__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32822_SHARP_,"X-CSRFToken",crsf_token);
} else {
return null;
}
});})(Authorization,Cache_control,map__32825,map__32825__$1,token,get_crsftoken_QMARK_,must_revalidate_QMARK_))
;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(Authorization,Cache_control,X_CSRFToken).call(null,cljs.core.PersistentArrayMap.EMPTY));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq32823){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32823));
});
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__32839 = null;
var G__32839__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__32839__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__32839__4 = (function() { 
var G__32840__delegate = function (url,query_params,token,p__32834){
var map__32835 = p__32834;
var map__32835__$1 = ((cljs.core.seq_QMARK_(map__32835))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32835):map__32835);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32835__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$token,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,token),cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$)], 0));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__32836 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32836) : cljs_hash.md5.md5.call(null,G__32836));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__32837 = url;
var G__32838 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__32837,G__32838) : http_method.call(null,G__32837,G__32838));
};
var G__32840 = function (url,query_params,token,var_args){
var p__32834 = null;
if (arguments.length > 3) {
var G__32841__i = 0, G__32841__a = new Array(arguments.length -  3);
while (G__32841__i < G__32841__a.length) {G__32841__a[G__32841__i] = arguments[G__32841__i + 3]; ++G__32841__i;}
  p__32834 = new cljs.core.IndexedSeq(G__32841__a,0);
} 
return G__32840__delegate.call(this,url,query_params,token,p__32834);};
G__32840.cljs$lang$maxFixedArity = 3;
G__32840.cljs$lang$applyTo = (function (arglist__32842){
var url = cljs.core.first(arglist__32842);
arglist__32842 = cljs.core.next(arglist__32842);
var query_params = cljs.core.first(arglist__32842);
arglist__32842 = cljs.core.next(arglist__32842);
var token = cljs.core.first(arglist__32842);
var p__32834 = cljs.core.rest(arglist__32842);
return G__32840__delegate(url,query_params,token,p__32834);
});
G__32840.cljs$core$IFn$_invoke$arity$variadic = G__32840__delegate;
return G__32840;
})()
;
G__32839 = function(url,query_params,token,var_args){
var p__32834 = var_args;
switch(arguments.length){
case 1:
return G__32839__1.call(this,url);
case 2:
return G__32839__2.call(this,url,query_params);
default:
var G__32843 = null;
if (arguments.length > 3) {
var G__32844__i = 0, G__32844__a = new Array(arguments.length -  3);
while (G__32844__i < G__32844__a.length) {G__32844__a[G__32844__i] = arguments[G__32844__i + 3]; ++G__32844__i;}
G__32843 = new cljs.core.IndexedSeq(G__32844__a,0);
}
return G__32839__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__32843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32839.cljs$lang$maxFixedArity = 3;
G__32839.cljs$lang$applyTo = G__32839__4.cljs$lang$applyTo;
G__32839.cljs$core$IFn$_invoke$arity$1 = G__32839__1;
G__32839.cljs$core$IFn$_invoke$arity$2 = G__32839__2;
G__32839.cljs$core$IFn$_invoke$arity$variadic = G__32839__4.cljs$core$IFn$_invoke$arity$variadic;
return G__32839;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__32852 = arguments.length;
switch (G__32852) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(5)),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9233__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_(method,url,callback,query_params,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__){
return (function (state_32863){
var state_val_32864 = (state_32863[(1)]);
if((state_val_32864 === (1))){
var inst_32853 = milia.api.io.query_helper(method);
var inst_32854 = (function (){var G__32865 = url;
var G__32866 = query_params;
var G__32867 = token;
var G__32868 = opts;
return (inst_32853.cljs$core$IFn$_invoke$arity$4 ? inst_32853.cljs$core$IFn$_invoke$arity$4(G__32865,G__32866,G__32867,G__32868) : inst_32853.call(null,G__32865,G__32866,G__32867,G__32868));
})();
var state_32863__$1 = state_32863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32863__$1,(2),inst_32854);
} else {
if((state_val_32864 === (2))){
var inst_32856 = (state_32863[(2)]);
var state_32863__$1 = (function (){var statearr_32869 = state_32863;
(statearr_32869[(7)] = inst_32856);

return statearr_32869;
})();
if(cljs.core.truth_(callback)){
var statearr_32870_32883 = state_32863__$1;
(statearr_32870_32883[(1)] = (3));

} else {
var statearr_32871_32884 = state_32863__$1;
(statearr_32871_32884[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32864 === (3))){
var inst_32856 = (state_32863[(7)]);
var inst_32858 = (function (){var G__32872 = inst_32856;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__32872) : callback.call(null,G__32872));
})();
var state_32863__$1 = state_32863;
var statearr_32873_32885 = state_32863__$1;
(statearr_32873_32885[(2)] = inst_32858);

(statearr_32873_32885[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32864 === (4))){
var state_32863__$1 = state_32863;
var statearr_32874_32886 = state_32863__$1;
(statearr_32874_32886[(2)] = null);

(statearr_32874_32886[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32864 === (5))){
var inst_32861 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32863__$1,inst_32861);
} else {
return null;
}
}
}
}
}
});})(c__11622__auto__))
;
return ((function (switch__11560__auto__,c__11622__auto__){
return (function() {
var milia$api$io$state_machine__11561__auto__ = null;
var milia$api$io$state_machine__11561__auto____0 = (function (){
var statearr_32878 = [null,null,null,null,null,null,null,null];
(statearr_32878[(0)] = milia$api$io$state_machine__11561__auto__);

(statearr_32878[(1)] = (1));

return statearr_32878;
});
var milia$api$io$state_machine__11561__auto____1 = (function (state_32863){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_32863);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e32879){if((e32879 instanceof Object)){
var ex__11564__auto__ = e32879;
var statearr_32880_32887 = state_32863;
(statearr_32880_32887[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32863);

return cljs.core.constant$keyword$recur;
} else {
throw e32879;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__32888 = state_32863;
state_32863 = G__32888;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$io$state_machine__11561__auto__ = function(state_32863){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11561__auto____1.call(this,state_32863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11561__auto____0;
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11561__auto____1;
return milia$api$io$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__))
})();
var state__11624__auto__ = (function (){var statearr_32881 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_32881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_32881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__))
);

return c__11622__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq32845){
var G__32846 = cljs.core.first(seq32845);
var seq32845__$1 = cljs.core.next(seq32845);
var G__32847 = cljs.core.first(seq32845__$1);
var seq32845__$2 = cljs.core.next(seq32845__$1);
var G__32848 = cljs.core.first(seq32845__$2);
var seq32845__$3 = cljs.core.next(seq32845__$2);
var G__32849 = cljs.core.first(seq32845__$3);
var seq32845__$4 = cljs.core.next(seq32845__$3);
var G__32850 = cljs.core.first(seq32845__$4);
var seq32845__$5 = cljs.core.next(seq32845__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32846,G__32847,G__32848,G__32849,G__32850,seq32845__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = (5);
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__32890 = arguments.length;
switch (G__32890) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32891 = event.target;
var G__32892 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32891,G__32892) : dommy.core.attr.call(null,G__32891,G__32892));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__32893 = event.target.form;
var G__32894 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32893,G__32894) : dommy.core.attr.call(null,G__32893,G__32894));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__32897 = arguments.length;
switch (G__32897) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32898 = event.target;
var G__32899 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32898,G__32899) : dommy.core.attr.call(null,G__32898,G__32899));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__11622__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11622__auto__){
return (function (){
var f__11623__auto__ = (function (){var switch__11560__auto__ = ((function (c__11622__auto__){
return (function (state_33034){
var state_val_33035 = (state_33034[(1)]);
if((state_val_33035 === (7))){
var inst_32999 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
var statearr_33036_33081 = state_33034__$1;
(statearr_33036_33081[(2)] = inst_32999);

(statearr_33036_33081[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (20))){
var state_33034__$1 = state_33034;
var statearr_33037_33082 = state_33034__$1;
(statearr_33037_33082[(2)] = null);

(statearr_33037_33082[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (1))){
var inst_32991 = (state_33034[(7)]);
var inst_32991__$1 = (auth_token == null);
var state_33034__$1 = (function (){var statearr_33038 = state_33034;
(statearr_33038[(7)] = inst_32991__$1);

return statearr_33038;
})();
if(cljs.core.truth_(inst_32991__$1)){
var statearr_33039_33083 = state_33034__$1;
(statearr_33039_33083[(1)] = (2));

} else {
var statearr_33040_33084 = state_33034__$1;
(statearr_33040_33084[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (4))){
var inst_33001 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
if(cljs.core.truth_(inst_33001)){
var statearr_33041_33085 = state_33034__$1;
(statearr_33041_33085[(1)] = (8));

} else {
var statearr_33042_33086 = state_33034__$1;
(statearr_33042_33086[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (15))){
var inst_33014 = (state_33034[(8)]);
var inst_33014__$1 = (state_33034[(2)]);
var inst_33015 = cljs.core.seq_QMARK_(inst_33014__$1);
var state_33034__$1 = (function (){var statearr_33043 = state_33034;
(statearr_33043[(8)] = inst_33014__$1);

return statearr_33043;
})();
if(inst_33015){
var statearr_33044_33087 = state_33034__$1;
(statearr_33044_33087[(1)] = (16));

} else {
var statearr_33045_33088 = state_33034__$1;
(statearr_33045_33088[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (21))){
var inst_33027 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
var statearr_33046_33089 = state_33034__$1;
(statearr_33046_33089[(2)] = inst_33027);

(statearr_33046_33089[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (13))){
var state_33034__$1 = state_33034;
var statearr_33047_33090 = state_33034__$1;
(statearr_33047_33090[(2)] = auth_token);

(statearr_33047_33090[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (6))){
var inst_32997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_33034__$1 = state_33034;
var statearr_33048_33091 = state_33034__$1;
(statearr_33048_33091[(2)] = inst_32997);

(statearr_33048_33091[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (17))){
var inst_33014 = (state_33034[(8)]);
var state_33034__$1 = state_33034;
var statearr_33049_33092 = state_33034__$1;
(statearr_33049_33092[(2)] = inst_33014);

(statearr_33049_33092[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (3))){
var inst_32994 = (state_33034[(9)]);
var inst_32994__$1 = clojure.string.blank_QMARK_(auth_token);
var state_33034__$1 = (function (){var statearr_33050 = state_33034;
(statearr_33050[(9)] = inst_32994__$1);

return statearr_33050;
})();
if(cljs.core.truth_(inst_32994__$1)){
var statearr_33051_33093 = state_33034__$1;
(statearr_33051_33093[(1)] = (5));

} else {
var statearr_33052_33094 = state_33034__$1;
(statearr_33052_33094[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (12))){
var inst_33011 = milia.api.io.refresh_token_url(username);
var inst_33012 = (function (){var G__33053 = inst_33011;
var G__33054 = null;
var G__33055 = null;
var G__33056 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__33057 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__33053,G__33054,G__33055,G__33056,G__33057) : milia.api.io.get_url.call(null,G__33053,G__33054,G__33055,G__33056,G__33057));
})();
var state_33034__$1 = state_33034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33034__$1,(15),inst_33012);
} else {
if((state_val_33035 === (2))){
var inst_32991 = (state_33034[(7)]);
var state_33034__$1 = state_33034;
var statearr_33058_33095 = state_33034__$1;
(statearr_33058_33095[(2)] = inst_32991);

(statearr_33058_33095[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (19))){
var inst_33022 = (state_33034[(10)]);
var state_33034__$1 = state_33034;
var statearr_33059_33096 = state_33034__$1;
(statearr_33059_33096[(2)] = inst_33022);

(statearr_33059_33096[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (11))){
var inst_33007 = (state_33034[(2)]);
var inst_33008 = milia.api.io.invalid_token_QMARK_(inst_33007);
var state_33034__$1 = state_33034;
if(cljs.core.truth_(inst_33008)){
var statearr_33060_33097 = state_33034__$1;
(statearr_33060_33097[(1)] = (12));

} else {
var statearr_33061_33098 = state_33034__$1;
(statearr_33061_33098[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (9))){
var inst_33004 = milia.api.io.validate_token_url(username);
var inst_33005 = (function (){var G__33062 = inst_33004;
var G__33063 = null;
var G__33064 = null;
var G__33065 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__33066 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__33062,G__33063,G__33064,G__33065,G__33066) : milia.api.io.get_url.call(null,G__33062,G__33063,G__33064,G__33065,G__33066));
})();
var state_33034__$1 = state_33034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33034__$1,(11),inst_33005);
} else {
if((state_val_33035 === (5))){
var inst_32994 = (state_33034[(9)]);
var state_33034__$1 = state_33034;
var statearr_33067_33099 = state_33034__$1;
(statearr_33067_33099[(2)] = inst_32994);

(statearr_33067_33099[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (14))){
var inst_33030 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
var statearr_33068_33100 = state_33034__$1;
(statearr_33068_33100[(2)] = inst_33030);

(statearr_33068_33100[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (16))){
var inst_33014 = (state_33034[(8)]);
var inst_33017 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33014);
var state_33034__$1 = state_33034;
var statearr_33069_33101 = state_33034__$1;
(statearr_33069_33101[(2)] = inst_33017);

(statearr_33069_33101[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (10))){
var inst_33032 = (state_33034[(2)]);
var state_33034__$1 = state_33034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33034__$1,inst_33032);
} else {
if((state_val_33035 === (18))){
var inst_33020 = (state_33034[(2)]);
var inst_33021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33020,cljs.core.constant$keyword$status);
var inst_33022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33020,cljs.core.constant$keyword$body);
var inst_33023 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33021,(200));
var state_33034__$1 = (function (){var statearr_33070 = state_33034;
(statearr_33070[(10)] = inst_33022);

return statearr_33070;
})();
if(inst_33023){
var statearr_33071_33102 = state_33034__$1;
(statearr_33071_33102[(1)] = (19));

} else {
var statearr_33072_33103 = state_33034__$1;
(statearr_33072_33103[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33035 === (8))){
var state_33034__$1 = state_33034;
var statearr_33073_33104 = state_33034__$1;
(statearr_33073_33104[(2)] = null);

(statearr_33073_33104[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11622__auto__))
;
return ((function (switch__11560__auto__,c__11622__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__11561__auto__ = null;
var milia$api$io$validate_token_$_state_machine__11561__auto____0 = (function (){
var statearr_33077 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33077[(0)] = milia$api$io$validate_token_$_state_machine__11561__auto__);

(statearr_33077[(1)] = (1));

return statearr_33077;
});
var milia$api$io$validate_token_$_state_machine__11561__auto____1 = (function (state_33034){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_33034);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e33078){if((e33078 instanceof Object)){
var ex__11564__auto__ = e33078;
var statearr_33079_33105 = state_33034;
(statearr_33079_33105[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33034);

return cljs.core.constant$keyword$recur;
} else {
throw e33078;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__33106 = state_33034;
state_33034 = G__33106;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__11561__auto__ = function(state_33034){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__11561__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__11561__auto____1.call(this,state_33034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__11561__auto____0;
milia$api$io$validate_token_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__11561__auto____1;
return milia$api$io$validate_token_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11622__auto__))
})();
var state__11624__auto__ = (function (){var statearr_33080 = (function (){return (f__11623__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11623__auto__.cljs$core$IFn$_invoke$arity$0() : f__11623__auto__.call(null));
})();
(statearr_33080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11622__auto__);

return statearr_33080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11624__auto__);
});})(c__11622__auto__))
);

return c__11622__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__33113_33119 = io_obj;
var G__33114_33120 = goog.net.EventType.SUCCESS;
var G__33115_33121 = ((function (G__33113_33119,G__33114_33120,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__33113_33119,G__33114_33120,io_obj,url))
;
goog.events.listen(G__33113_33119,G__33114_33120,G__33115_33121);

var G__33116_33122 = io_obj;
var G__33117_33123 = goog.net.EventType.ERROR;
var G__33118_33124 = ((function (G__33116_33122,G__33117_33123,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__33116_33122,G__33117_33123,io_obj,url))
;
goog.events.listen(G__33116_33122,G__33117_33123,G__33118_33124);

return io_obj.sendFromForm(form,url);
});
