// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('goog.math.Long');
goog.require('com.cognitect.transit.eq');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv(other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__30055 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__30055) : com.cognitect.transit.eq.hashCode.call(null,G__30055));
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__30056 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__30056) : com.cognitect.transit.eq.hashCode.call(null,G__30056));
});

goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__30057 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__30057) : com.cognitect.transit.eq.hashCode.call(null,G__30057));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__30062_30066 = cljs.core.seq(cljs.core.js_keys(b));
var chunk__30063_30067 = null;
var count__30064_30068 = (0);
var i__30065_30069 = (0);
while(true){
if((i__30065_30069 < count__30064_30068)){
var k_30070 = chunk__30063_30067.cljs$core$IIndexed$_nth$arity$2(null,i__30065_30069);
var v_30071 = (b[k_30070]);
(a[k_30070] = v_30071);

var G__30072 = seq__30062_30066;
var G__30073 = chunk__30063_30067;
var G__30074 = count__30064_30068;
var G__30075 = (i__30065_30069 + (1));
seq__30062_30066 = G__30072;
chunk__30063_30067 = G__30073;
count__30064_30068 = G__30074;
i__30065_30069 = G__30075;
continue;
} else {
var temp__4126__auto___30076 = cljs.core.seq(seq__30062_30066);
if(temp__4126__auto___30076){
var seq__30062_30077__$1 = temp__4126__auto___30076;
if(cljs.core.chunked_seq_QMARK_(seq__30062_30077__$1)){
var c__5061__auto___30078 = cljs.core.chunk_first(seq__30062_30077__$1);
var G__30079 = cljs.core.chunk_rest(seq__30062_30077__$1);
var G__30080 = c__5061__auto___30078;
var G__30081 = cljs.core.count(c__5061__auto___30078);
var G__30082 = (0);
seq__30062_30066 = G__30079;
chunk__30063_30067 = G__30080;
count__30064_30068 = G__30081;
i__30065_30069 = G__30082;
continue;
} else {
var k_30083 = cljs.core.first(seq__30062_30077__$1);
var v_30084 = (b[k_30083]);
(a[k_30083] = v_30084);

var G__30085 = cljs.core.next(seq__30062_30077__$1);
var G__30086 = null;
var G__30087 = (0);
var G__30088 = (0);
seq__30062_30066 = G__30085;
chunk__30063_30067 = G__30086;
count__30064_30068 = G__30087;
i__30065_30069 = G__30088;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__30089 = arr;
var G__30090 = true;
var G__30091 = true;
return (cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3 ? cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3(G__30089,G__30090,G__30091) : cljs.core.PersistentArrayMap.fromArray.call(null,G__30089,G__30090,G__30091));
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__30092 = arr;
var G__30093 = true;
return (cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2 ? cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2(G__30092,G__30093) : cljs.core.PersistentVector.fromArray.call(null,G__30092,G__30093));
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var G__30095 = arguments.length;
switch (G__30095) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var G__30096 = cljs.core.name(type);
var G__30097 = cognitect.transit.opts_merge({"prefersStrings": false, "arrayBuilder": (new cognitect.transit.VectorBuilder()), "mapBuilder": (new cognitect.transit.MapBuilder()), "handlers": cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 5, ["$",((function (G__30096){
return (function (v){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(v);
});})(G__30096))
,":",((function (G__30096){
return (function (v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(G__30096))
,"set",((function (G__30096){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,v);
});})(G__30096))
,"list",((function (G__30096){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.List.EMPTY,v.reverse());
});})(G__30096))
,"cmap",((function (G__30096){
return (function (v){
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__30099 = (i + (2));
var G__30100 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,(v[i]),(v[(i + (1))]));
i = G__30099;
ret = G__30100;
continue;
} else {
return cljs.core.persistent_BANG_(ret);
}
break;
}
});})(G__30096))
], null),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0)))},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(G__30096,G__30097) : com.cognitect.transit.reader.call(null,G__30096,G__30097));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30101_30107 = cljs.core.seq(v);
var chunk__30102_30108 = null;
var count__30103_30109 = (0);
var i__30104_30110 = (0);
while(true){
if((i__30104_30110 < count__30103_30109)){
var x_30111 = chunk__30102_30108.cljs$core$IIndexed$_nth$arity$2(null,i__30104_30110);
ret.push(x_30111);

var G__30112 = seq__30101_30107;
var G__30113 = chunk__30102_30108;
var G__30114 = count__30103_30109;
var G__30115 = (i__30104_30110 + (1));
seq__30101_30107 = G__30112;
chunk__30102_30108 = G__30113;
count__30103_30109 = G__30114;
i__30104_30110 = G__30115;
continue;
} else {
var temp__4126__auto___30116 = cljs.core.seq(seq__30101_30107);
if(temp__4126__auto___30116){
var seq__30101_30117__$1 = temp__4126__auto___30116;
if(cljs.core.chunked_seq_QMARK_(seq__30101_30117__$1)){
var c__5061__auto___30118 = cljs.core.chunk_first(seq__30101_30117__$1);
var G__30119 = cljs.core.chunk_rest(seq__30101_30117__$1);
var G__30120 = c__5061__auto___30118;
var G__30121 = cljs.core.count(c__5061__auto___30118);
var G__30122 = (0);
seq__30101_30107 = G__30119;
chunk__30102_30108 = G__30120;
count__30103_30109 = G__30121;
i__30104_30110 = G__30122;
continue;
} else {
var x_30123 = cljs.core.first(seq__30101_30117__$1);
ret.push(x_30123);

var G__30124 = cljs.core.next(seq__30101_30117__$1);
var G__30125 = null;
var G__30126 = (0);
var G__30127 = (0);
seq__30101_30107 = G__30124;
chunk__30102_30108 = G__30125;
count__30103_30109 = G__30126;
i__30104_30110 = G__30127;
continue;
}
} else {
}
}
break;
}

var G__30105 = "array";
var G__30106 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__30105,G__30106) : com.cognitect.transit.tagged.call(null,G__30105,G__30106));
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30128_30134 = cljs.core.seq(v);
var chunk__30129_30135 = null;
var count__30130_30136 = (0);
var i__30131_30137 = (0);
while(true){
if((i__30131_30137 < count__30130_30136)){
var x_30138 = chunk__30129_30135.cljs$core$IIndexed$_nth$arity$2(null,i__30131_30137);
ret.push(x_30138);

var G__30139 = seq__30128_30134;
var G__30140 = chunk__30129_30135;
var G__30141 = count__30130_30136;
var G__30142 = (i__30131_30137 + (1));
seq__30128_30134 = G__30139;
chunk__30129_30135 = G__30140;
count__30130_30136 = G__30141;
i__30131_30137 = G__30142;
continue;
} else {
var temp__4126__auto___30143 = cljs.core.seq(seq__30128_30134);
if(temp__4126__auto___30143){
var seq__30128_30144__$1 = temp__4126__auto___30143;
if(cljs.core.chunked_seq_QMARK_(seq__30128_30144__$1)){
var c__5061__auto___30145 = cljs.core.chunk_first(seq__30128_30144__$1);
var G__30146 = cljs.core.chunk_rest(seq__30128_30144__$1);
var G__30147 = c__5061__auto___30145;
var G__30148 = cljs.core.count(c__5061__auto___30145);
var G__30149 = (0);
seq__30128_30134 = G__30146;
chunk__30129_30135 = G__30147;
count__30130_30136 = G__30148;
i__30131_30137 = G__30149;
continue;
} else {
var x_30150 = cljs.core.first(seq__30128_30144__$1);
ret.push(x_30150);

var G__30151 = cljs.core.next(seq__30128_30144__$1);
var G__30152 = null;
var G__30153 = (0);
var G__30154 = (0);
seq__30128_30134 = G__30151;
chunk__30129_30135 = G__30152;
count__30130_30136 = G__30153;
i__30131_30137 = G__30154;
continue;
}
} else {
}
}
break;
}

var G__30132 = "array";
var G__30133 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__30132,G__30133) : com.cognitect.transit.tagged.call(null,G__30132,G__30133));
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__30155_30159 = cljs.core.seq(v);
var chunk__30156_30160 = null;
var count__30157_30161 = (0);
var i__30158_30162 = (0);
while(true){
if((i__30158_30162 < count__30157_30161)){
var x_30163 = chunk__30156_30160.cljs$core$IIndexed$_nth$arity$2(null,i__30158_30162);
ret.push(x_30163);

var G__30164 = seq__30155_30159;
var G__30165 = chunk__30156_30160;
var G__30166 = count__30157_30161;
var G__30167 = (i__30158_30162 + (1));
seq__30155_30159 = G__30164;
chunk__30156_30160 = G__30165;
count__30157_30161 = G__30166;
i__30158_30162 = G__30167;
continue;
} else {
var temp__4126__auto___30168 = cljs.core.seq(seq__30155_30159);
if(temp__4126__auto___30168){
var seq__30155_30169__$1 = temp__4126__auto___30168;
if(cljs.core.chunked_seq_QMARK_(seq__30155_30169__$1)){
var c__5061__auto___30170 = cljs.core.chunk_first(seq__30155_30169__$1);
var G__30171 = cljs.core.chunk_rest(seq__30155_30169__$1);
var G__30172 = c__5061__auto___30170;
var G__30173 = cljs.core.count(c__5061__auto___30170);
var G__30174 = (0);
seq__30155_30159 = G__30171;
chunk__30156_30160 = G__30172;
count__30157_30161 = G__30173;
i__30158_30162 = G__30174;
continue;
} else {
var x_30175 = cljs.core.first(seq__30155_30169__$1);
ret.push(x_30175);

var G__30176 = cljs.core.next(seq__30155_30169__$1);
var G__30177 = null;
var G__30178 = (0);
var G__30179 = (0);
seq__30155_30159 = G__30176;
chunk__30156_30160 = G__30177;
count__30157_30161 = G__30178;
i__30158_30162 = G__30179;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a JavaScript
 * array of interleaved type constructors and handler instances for those
 * type constructors.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var G__30181 = arguments.length;
switch (G__30181) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0));
var G__30182 = cljs.core.name(type);
var G__30183 = cognitect.transit.opts_merge({"unpack": ((function (G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x30187 = cljs.core.clone(handlers);
x30187.forEach = ((function (x30187,G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__30188 = cljs.core.seq(coll);
var chunk__30189 = null;
var count__30190 = (0);
var i__30191 = (0);
while(true){
if((i__30191 < count__30190)){
var vec__30192 = chunk__30189.cljs$core$IIndexed$_nth$arity$2(null,i__30191);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30192,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30192,(1),null);
var G__30193_30199 = v;
var G__30194_30200 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__30193_30199,G__30194_30200) : f.call(null,G__30193_30199,G__30194_30200));

var G__30201 = seq__30188;
var G__30202 = chunk__30189;
var G__30203 = count__30190;
var G__30204 = (i__30191 + (1));
seq__30188 = G__30201;
chunk__30189 = G__30202;
count__30190 = G__30203;
i__30191 = G__30204;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__30188);
if(temp__4126__auto__){
var seq__30188__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30188__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__30188__$1);
var G__30205 = cljs.core.chunk_rest(seq__30188__$1);
var G__30206 = c__5061__auto__;
var G__30207 = cljs.core.count(c__5061__auto__);
var G__30208 = (0);
seq__30188 = G__30205;
chunk__30189 = G__30206;
count__30190 = G__30207;
i__30191 = G__30208;
continue;
} else {
var vec__30195 = cljs.core.first(seq__30188__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30195,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30195,(1),null);
var G__30196_30209 = v;
var G__30197_30210 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__30196_30209,G__30197_30210) : f.call(null,G__30196_30209,G__30197_30210));

var G__30211 = cljs.core.next(seq__30188__$1);
var G__30212 = null;
var G__30213 = (0);
var G__30214 = (0);
seq__30188 = G__30211;
chunk__30189 = G__30212;
count__30190 = G__30213;
i__30191 = G__30214;
continue;
}
} else {
return null;
}
}
break;
}
});})(x30187,G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x30187;
})(), "objectBuilder": ((function (G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv(((function (G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__30184 = obj;
G__30184.push((function (){var G__30185 = k;
return (kfn.cljs$core$IFn$_invoke$arity$1 ? kfn.cljs$core$IFn$_invoke$arity$1(G__30185) : kfn.call(null,G__30185));
})(),(function (){var G__30186 = v;
return (vfn.cljs$core$IFn$_invoke$arity$1 ? vfn.cljs$core$IFn$_invoke$arity$1(G__30186) : vfn.call(null,G__30186));
})());

return G__30184;
});})(G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(G__30182,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(G__30182,G__30183) : com.cognitect.transit.writer.call(null,G__30182,G__30183));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var G__30216 = arguments.length;
switch (G__30216) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t30217 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t30217 = (function (verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,meta30218){
this.verbose_handler_fn = verbose_handler_fn;
this.str_rep_fn = str_rep_fn;
this.rep_fn = rep_fn;
this.tag_fn = tag_fn;
this.meta30218 = meta30218;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cognitect.transit.t30217.prototype.tag = (function (o){
var self__ = this;
var _ = this;
var G__30220 = o;
return (self__.tag_fn.cljs$core$IFn$_invoke$arity$1 ? self__.tag_fn.cljs$core$IFn$_invoke$arity$1(G__30220) : self__.tag_fn.call(null,G__30220));
});

cognitect.transit.t30217.prototype.rep = (function (o){
var self__ = this;
var _ = this;
var G__30221 = o;
return (self__.rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.rep_fn.cljs$core$IFn$_invoke$arity$1(G__30221) : self__.rep_fn.call(null,G__30221));
});

cognitect.transit.t30217.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
var G__30222 = o;
return (self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1(G__30222) : self__.str_rep_fn.call(null,G__30222));
} else {
return null;
}
});

cognitect.transit.t30217.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return (self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0 ? self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0() : self__.verbose_handler_fn.call(null));
} else {
return null;
}
});

cognitect.transit.t30217.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30219){
var self__ = this;
var _30219__$1 = this;
return self__.meta30218;
});

cognitect.transit.t30217.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30219,meta30218__$1){
var self__ = this;
var _30219__$1 = this;
return (new cognitect.transit.t30217(self__.verbose_handler_fn,self__.str_rep_fn,self__.rep_fn,self__.tag_fn,meta30218__$1));
});

cognitect.transit.t30217.cljs$lang$type = true;

cognitect.transit.t30217.cljs$lang$ctorStr = "cognitect.transit/t30217";

cognitect.transit.t30217.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cognitect.transit/t30217");
});

cognitect.transit.__GT_t30217 = (function cognitect$transit$__GT_t30217(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta30218){
return (new cognitect.transit.t30217(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta30218));
});

}

return (new cognitect.transit.t30217(verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
var G__30226 = tag;
var G__30227 = rep;
return (com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2(G__30226,G__30227) : com.cognitect.transit.types.taggedValue.call(null,G__30226,G__30227));
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
var G__30229 = x;
return (com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1(G__30229) : com.cognitect.transit.types.isTaggedValue.call(null,G__30229));
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
var G__30231 = s;
return (com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1(G__30231) : com.cognitect.transit.types.integer.call(null,G__30231));
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
var G__30233 = x;
return (com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1(G__30233) : com.cognitect.transit.types.isInteger.call(null,G__30233));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
var G__30235 = s;
return (com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1(G__30235) : com.cognitect.transit.types.bigInteger.call(null,G__30235));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
var G__30237 = x;
return (com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1(G__30237) : com.cognitect.transit.types.isBigInteger.call(null,G__30237));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
var G__30239 = s;
return (com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1(G__30239) : com.cognitect.transit.types.bigDecimalValue.call(null,G__30239));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
var G__30241 = x;
return (com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1(G__30241) : com.cognitect.transit.types.isBigDecimal.call(null,G__30241));
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
var G__30243 = s;
return (com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1(G__30243) : com.cognitect.transit.types.uri.call(null,G__30243));
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
var G__30245 = x;
return (com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1(G__30245) : com.cognitect.transit.types.isURI.call(null,G__30245));
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
var G__30247 = s;
return (com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1(G__30247) : com.cognitect.transit.types.uuid.call(null,G__30247));
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var G__30249 = x;
return (com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1(G__30249) : com.cognitect.transit.types.isUUID.call(null,G__30249));
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
var G__30251 = s;
return (com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1(G__30251) : com.cognitect.transit.types.binary.call(null,G__30251));
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
var G__30253 = x;
return (com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1(G__30253) : com.cognitect.transit.types.isBinary.call(null,G__30253));
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
var G__30255 = x;
return (com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1(G__30255) : com.cognitect.transit.types.quoted.call(null,G__30255));
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
var G__30257 = x;
return (com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1(G__30257) : com.cognitect.transit.types.isQuoted.call(null,G__30257));
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
var G__30259 = x;
return (com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1(G__30259) : com.cognitect.transit.types.link.call(null,G__30259));
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
var G__30261 = x;
return (com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1(G__30261) : com.cognitect.transit.types.isLink.call(null,G__30261));
});
