// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(account){
var url = (function (){var G__29069 = [cljs.core.str("forms?owner="),cljs.core.str(cljs.core.constant$keyword$username.cljs$core$IFn$_invoke$arity$1(account))].join('');
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__29069) : milia.api.io.make_url.call(null,G__29069));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(account,username){
var url = (function (){var G__29072 = "forms";
var G__29073 = username;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29072,G__29073) : milia.api.io.make_url.call(null,G__29072,G__29073));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(account,dataset_id,params){
if(cljs.core.truth_(milia.utils.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null))], 0)))].join('')));
}

var url = (function (){var G__29076 = "forms";
var G__29077 = dataset_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29076,G__29077) : milia.api.io.make_url.call(null,G__29076,G__29077));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(account,dataset_id,params){
var url = (function (){var G__29080 = "forms";
var G__29081 = dataset_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29080,G__29081) : milia.api.io.make_url.call(null,G__29080,G__29081));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (account,dataset_id,p__29085){
var map__29086 = p__29085;
var map__29086__$1 = ((cljs.core.seq_QMARK_(map__29086))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29086):map__29086);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29086__$1,cljs.core.constant$keyword$raw_QMARK_);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29086__$1,cljs.core.constant$keyword$format,"json");
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = (function (){var G__29087 = "data";
var G__29088 = dataset_suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29087,G__29088) : milia.api.io.make_url.call(null,G__29087,G__29088));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$raw_DASH_response_QMARK_,raw_QMARK_], null));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (2);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq29082){
var G__29083 = cljs.core.first(seq29082);
var seq29082__$1 = cljs.core.next(seq29082);
var G__29084 = cljs.core.first(seq29082__$1);
var seq29082__$2 = cljs.core.next(seq29082__$1);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__29083,G__29084,seq29082__$2);
});
/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(account,dataset_id,record_id){
var url = (function (){var G__29092 = "data";
var G__29093 = dataset_id;
var G__29094 = record_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29092,G__29093,G__29094) : milia.api.io.make_url.call(null,G__29092,G__29093,G__29094));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(account,dataset_id){
var url = (function (){var G__29098 = "forms";
var G__29099 = dataset_id;
var G__29100 = "labels";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29098,G__29099,G__29100) : milia.api.io.make_url.call(null,G__29098,G__29099,G__29100));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(account,dataset_id,tags){
var url = (function (){var G__29104 = "forms";
var G__29105 = dataset_id;
var G__29106 = "labels";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29104,G__29105,G__29106) : milia.api.io.make_url.call(null,G__29104,G__29105,G__29106));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,tags], null));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(){
var G__29108 = arguments.length;
switch (G__29108) {
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (account,dataset_id){
var url = (function (){var G__29109 = "forms";
var G__29110 = dataset_id;
var G__29111 = "form.json";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29109,G__29110,G__29111) : milia.api.io.make_url.call(null,G__29109,G__29110,G__29111));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3 = (function (account,dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = (function (){var G__29112 = "forms";
var G__29113 = dataset_id;
var G__29114 = suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29112,G__29113,G__29114) : milia.api.io.make_url.call(null,G__29112,G__29113,G__29114));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,options,[cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join(''));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 3;
/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(account,dataset_id){
var url = (function (){var G__29118 = "forms";
var G__29119 = dataset_id;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29118,G__29119) : milia.api.io.make_url.call(null,G__29118,G__29119));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(account,dataset_id,instance_id){
var zebra_blank = milia.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["blank"], 0));
var url = (function (){var G__29124 = "data";
var G__29125 = dataset_id;
var G__29126 = instance_id;
var G__29127 = [cljs.core.str("enketo?return_url="),cljs.core.str(zebra_blank)].join('');
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$4 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$4(G__29124,G__29125,G__29126,G__29127) : milia.api.io.make_url.call(null,G__29124,G__29125,G__29126,G__29127));
})();
return cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(account,dataset_id){
var url = (function (){var G__29131 = "forms";
var G__29132 = dataset_id;
var G__29133 = "delete_async";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29131,G__29132,G__29133) : milia.api.io.make_url.call(null,G__29131,G__29132,G__29133));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$delete,url,account);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(account,dataset_id,project_id){
var url = (function (){var G__29137 = "projects";
var G__29138 = project_id;
var G__29139 = "forms";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29137,G__29138,G__29139) : milia.api.io.make_url.call(null,G__29137,G__29138,G__29139));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$formid,dataset_id], null)], null));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(account,dataset_id,username,role){
var url = (function (){var G__29143 = "forms";
var G__29144 = dataset_id;
var G__29145 = "share";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__29143,G__29144,G__29145) : milia.api.io.make_url.call(null,G__29143,G__29144,G__29145));
})();
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(account,dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = (function (){var G__29147 = "metadata";
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__29147) : milia.api.io.make_url.call(null,G__29147));
})();
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$xform,dataset_id,cljs.core.constant$keyword$data_type,"external_export",cljs.core.constant$keyword$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(){
var G__29149 = arguments.length;
switch (G__29149) {
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (account,dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5(account,dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5 = (function (account,dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = (function (){var G__29150 = "forms";
var G__29151 = suffix;
return (milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? milia.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__29150,G__29151) : milia.api.io.make_url.call(null,G__29150,G__29151));
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], null),filename);
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 5;
