// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv(other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__34402 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__34402) : com.cognitect.transit.eq.hashCode.call(null,G__34402));
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__34403 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__34403) : com.cognitect.transit.eq.hashCode.call(null,G__34403));
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
var G__34404 = this$__$1;
return (com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.eq.hashCode.cljs$core$IFn$_invoke$arity$1(G__34404) : com.cognitect.transit.eq.hashCode.call(null,G__34404));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__34409_34413 = cljs.core.seq(cljs.core.js_keys(b));
var chunk__34410_34414 = null;
var count__34411_34415 = (0);
var i__34412_34416 = (0);
while(true){
if((i__34412_34416 < count__34411_34415)){
var k_34417 = chunk__34410_34414.cljs$core$IIndexed$_nth$arity$2(null,i__34412_34416);
var v_34418 = (b[k_34417]);
(a[k_34417] = v_34418);

var G__34419 = seq__34409_34413;
var G__34420 = chunk__34410_34414;
var G__34421 = count__34411_34415;
var G__34422 = (i__34412_34416 + (1));
seq__34409_34413 = G__34419;
chunk__34410_34414 = G__34420;
count__34411_34415 = G__34421;
i__34412_34416 = G__34422;
continue;
} else {
var temp__4425__auto___34423 = cljs.core.seq(seq__34409_34413);
if(temp__4425__auto___34423){
var seq__34409_34424__$1 = temp__4425__auto___34423;
if(cljs.core.chunked_seq_QMARK_(seq__34409_34424__$1)){
var c__8967__auto___34425 = cljs.core.chunk_first(seq__34409_34424__$1);
var G__34426 = cljs.core.chunk_rest(seq__34409_34424__$1);
var G__34427 = c__8967__auto___34425;
var G__34428 = cljs.core.count(c__8967__auto___34425);
var G__34429 = (0);
seq__34409_34413 = G__34426;
chunk__34410_34414 = G__34427;
count__34411_34415 = G__34428;
i__34412_34416 = G__34429;
continue;
} else {
var k_34430 = cljs.core.first(seq__34409_34424__$1);
var v_34431 = (b[k_34430]);
(a[k_34430] = v_34431);

var G__34432 = cljs.core.next(seq__34409_34424__$1);
var G__34433 = null;
var G__34434 = (0);
var G__34435 = (0);
seq__34409_34413 = G__34432;
chunk__34410_34414 = G__34433;
count__34411_34415 = G__34434;
i__34412_34416 = G__34435;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__34436 = arr;
var G__34437 = true;
var G__34438 = true;
return (cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3 ? cljs.core.PersistentArrayMap.fromArray.cljs$core$IFn$_invoke$arity$3(G__34436,G__34437,G__34438) : cljs.core.PersistentArrayMap.fromArray.call(null,G__34436,G__34437,G__34438));
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_(v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
var G__34439 = arr;
var G__34440 = true;
return (cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2 ? cljs.core.PersistentVector.fromArray.cljs$core$IFn$_invoke$arity$2(G__34439,G__34440) : cljs.core.PersistentVector.fromArray.call(null,G__34439,G__34440));
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var G__34442 = arguments.length;
switch (G__34442) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var G__34443 = cljs.core.name(type);
var G__34444 = cognitect.transit.opts_merge({"handlers": cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 5, ["$",((function (G__34443){
return (function (v){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(v);
});})(G__34443))
,":",((function (G__34443){
return (function (v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(G__34443))
,"set",((function (G__34443){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,v);
});})(G__34443))
,"list",((function (G__34443){
return (function (v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.List.EMPTY,v.reverse());
});})(G__34443))
,"cmap",((function (G__34443){
return (function (v){
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__34446 = (i + (2));
var G__34447 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,(v[i]),(v[(i + (1))]));
i = G__34446;
ret = G__34447;
continue;
} else {
return cljs.core.persistent_BANG_(ret);
}
break;
}
});})(G__34443))
], null),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2(G__34443,G__34444) : com.cognitect.transit.reader.call(null,G__34443,G__34444));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34448_34454 = cljs.core.seq(v);
var chunk__34449_34455 = null;
var count__34450_34456 = (0);
var i__34451_34457 = (0);
while(true){
if((i__34451_34457 < count__34450_34456)){
var x_34458 = chunk__34449_34455.cljs$core$IIndexed$_nth$arity$2(null,i__34451_34457);
ret.push(x_34458);

var G__34459 = seq__34448_34454;
var G__34460 = chunk__34449_34455;
var G__34461 = count__34450_34456;
var G__34462 = (i__34451_34457 + (1));
seq__34448_34454 = G__34459;
chunk__34449_34455 = G__34460;
count__34450_34456 = G__34461;
i__34451_34457 = G__34462;
continue;
} else {
var temp__4425__auto___34463 = cljs.core.seq(seq__34448_34454);
if(temp__4425__auto___34463){
var seq__34448_34464__$1 = temp__4425__auto___34463;
if(cljs.core.chunked_seq_QMARK_(seq__34448_34464__$1)){
var c__8967__auto___34465 = cljs.core.chunk_first(seq__34448_34464__$1);
var G__34466 = cljs.core.chunk_rest(seq__34448_34464__$1);
var G__34467 = c__8967__auto___34465;
var G__34468 = cljs.core.count(c__8967__auto___34465);
var G__34469 = (0);
seq__34448_34454 = G__34466;
chunk__34449_34455 = G__34467;
count__34450_34456 = G__34468;
i__34451_34457 = G__34469;
continue;
} else {
var x_34470 = cljs.core.first(seq__34448_34464__$1);
ret.push(x_34470);

var G__34471 = cljs.core.next(seq__34448_34464__$1);
var G__34472 = null;
var G__34473 = (0);
var G__34474 = (0);
seq__34448_34454 = G__34471;
chunk__34449_34455 = G__34472;
count__34450_34456 = G__34473;
i__34451_34457 = G__34474;
continue;
}
} else {
}
}
break;
}

var G__34452 = "array";
var G__34453 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__34452,G__34453) : com.cognitect.transit.tagged.call(null,G__34452,G__34453));
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34475_34481 = cljs.core.seq(v);
var chunk__34476_34482 = null;
var count__34477_34483 = (0);
var i__34478_34484 = (0);
while(true){
if((i__34478_34484 < count__34477_34483)){
var x_34485 = chunk__34476_34482.cljs$core$IIndexed$_nth$arity$2(null,i__34478_34484);
ret.push(x_34485);

var G__34486 = seq__34475_34481;
var G__34487 = chunk__34476_34482;
var G__34488 = count__34477_34483;
var G__34489 = (i__34478_34484 + (1));
seq__34475_34481 = G__34486;
chunk__34476_34482 = G__34487;
count__34477_34483 = G__34488;
i__34478_34484 = G__34489;
continue;
} else {
var temp__4425__auto___34490 = cljs.core.seq(seq__34475_34481);
if(temp__4425__auto___34490){
var seq__34475_34491__$1 = temp__4425__auto___34490;
if(cljs.core.chunked_seq_QMARK_(seq__34475_34491__$1)){
var c__8967__auto___34492 = cljs.core.chunk_first(seq__34475_34491__$1);
var G__34493 = cljs.core.chunk_rest(seq__34475_34491__$1);
var G__34494 = c__8967__auto___34492;
var G__34495 = cljs.core.count(c__8967__auto___34492);
var G__34496 = (0);
seq__34475_34481 = G__34493;
chunk__34476_34482 = G__34494;
count__34477_34483 = G__34495;
i__34478_34484 = G__34496;
continue;
} else {
var x_34497 = cljs.core.first(seq__34475_34491__$1);
ret.push(x_34497);

var G__34498 = cljs.core.next(seq__34475_34491__$1);
var G__34499 = null;
var G__34500 = (0);
var G__34501 = (0);
seq__34475_34481 = G__34498;
chunk__34476_34482 = G__34499;
count__34477_34483 = G__34500;
i__34478_34484 = G__34501;
continue;
}
} else {
}
}
break;
}

var G__34479 = "array";
var G__34480 = ret;
return (com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.tagged.cljs$core$IFn$_invoke$arity$2(G__34479,G__34480) : com.cognitect.transit.tagged.call(null,G__34479,G__34480));
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__34502_34506 = cljs.core.seq(v);
var chunk__34503_34507 = null;
var count__34504_34508 = (0);
var i__34505_34509 = (0);
while(true){
if((i__34505_34509 < count__34504_34508)){
var x_34510 = chunk__34503_34507.cljs$core$IIndexed$_nth$arity$2(null,i__34505_34509);
ret.push(x_34510);

var G__34511 = seq__34502_34506;
var G__34512 = chunk__34503_34507;
var G__34513 = count__34504_34508;
var G__34514 = (i__34505_34509 + (1));
seq__34502_34506 = G__34511;
chunk__34503_34507 = G__34512;
count__34504_34508 = G__34513;
i__34505_34509 = G__34514;
continue;
} else {
var temp__4425__auto___34515 = cljs.core.seq(seq__34502_34506);
if(temp__4425__auto___34515){
var seq__34502_34516__$1 = temp__4425__auto___34515;
if(cljs.core.chunked_seq_QMARK_(seq__34502_34516__$1)){
var c__8967__auto___34517 = cljs.core.chunk_first(seq__34502_34516__$1);
var G__34518 = cljs.core.chunk_rest(seq__34502_34516__$1);
var G__34519 = c__8967__auto___34517;
var G__34520 = cljs.core.count(c__8967__auto___34517);
var G__34521 = (0);
seq__34502_34506 = G__34518;
chunk__34503_34507 = G__34519;
count__34504_34508 = G__34520;
i__34505_34509 = G__34521;
continue;
} else {
var x_34522 = cljs.core.first(seq__34502_34516__$1);
ret.push(x_34522);

var G__34523 = cljs.core.next(seq__34502_34516__$1);
var G__34524 = null;
var G__34525 = (0);
var G__34526 = (0);
seq__34502_34506 = G__34523;
chunk__34503_34507 = G__34524;
count__34504_34508 = G__34525;
i__34505_34509 = G__34526;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a JavaScript
 * array of interleaved type constructors and handler instances for those
 * type constructors.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var G__34528 = arguments.length;
switch (G__34528) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),cljs.core.constant$keyword$handlers.cljs$core$IFn$_invoke$arity$1(opts)], 0));
var G__34529 = cljs.core.name(type);
var G__34530 = cognitect.transit.opts_merge({"objectBuilder": ((function (G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv(((function (G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__34531 = obj;
G__34531.push((function (){var G__34532 = k;
return (kfn.cljs$core$IFn$_invoke$arity$1 ? kfn.cljs$core$IFn$_invoke$arity$1(G__34532) : kfn.call(null,G__34532));
})(),(function (){var G__34533 = v;
return (vfn.cljs$core$IFn$_invoke$arity$1 ? vfn.cljs$core$IFn$_invoke$arity$1(G__34533) : vfn.call(null,G__34533));
})());

return G__34531;
});})(G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x34534 = cljs.core.clone(handlers);
x34534.forEach = ((function (x34534,G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__34535 = cljs.core.seq(coll);
var chunk__34536 = null;
var count__34537 = (0);
var i__34538 = (0);
while(true){
if((i__34538 < count__34537)){
var vec__34539 = chunk__34536.cljs$core$IIndexed$_nth$arity$2(null,i__34538);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34539,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34539,(1),null);
var G__34540_34546 = v;
var G__34541_34547 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34540_34546,G__34541_34547) : f.call(null,G__34540_34546,G__34541_34547));

var G__34548 = seq__34535;
var G__34549 = chunk__34536;
var G__34550 = count__34537;
var G__34551 = (i__34538 + (1));
seq__34535 = G__34548;
chunk__34536 = G__34549;
count__34537 = G__34550;
i__34538 = G__34551;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__34535);
if(temp__4425__auto__){
var seq__34535__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34535__$1)){
var c__8967__auto__ = cljs.core.chunk_first(seq__34535__$1);
var G__34552 = cljs.core.chunk_rest(seq__34535__$1);
var G__34553 = c__8967__auto__;
var G__34554 = cljs.core.count(c__8967__auto__);
var G__34555 = (0);
seq__34535 = G__34552;
chunk__34536 = G__34553;
count__34537 = G__34554;
i__34538 = G__34555;
continue;
} else {
var vec__34542 = cljs.core.first(seq__34535__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34542,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34542,(1),null);
var G__34543_34556 = v;
var G__34544_34557 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34543_34556,G__34544_34557) : f.call(null,G__34543_34556,G__34544_34557));

var G__34558 = cljs.core.next(seq__34535__$1);
var G__34559 = null;
var G__34560 = (0);
var G__34561 = (0);
seq__34535 = G__34558;
chunk__34536 = G__34559;
count__34537 = G__34560;
i__34538 = G__34561;
continue;
}
} else {
return null;
}
}
break;
}
});})(x34534,G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x34534;
})(), "unpack": ((function (G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(G__34529,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.constant$keyword$handlers)));
return (com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2(G__34529,G__34530) : com.cognitect.transit.writer.call(null,G__34529,G__34530));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var G__34563 = arguments.length;
switch (G__34563) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4(tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t34564 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t34564 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta34565){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta34565 = meta34565;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t34564.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34566,meta34565__$1){
var self__ = this;
var _34566__$1 = this;
return (new cognitect.transit.t34564(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta34565__$1));
});

cognitect.transit.t34564.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34566){
var self__ = this;
var _34566__$1 = this;
return self__.meta34565;
});

cognitect.transit.t34564.prototype.tag = (function (o){
var self__ = this;
var _ = this;
var G__34567 = o;
return (self__.tag_fn.cljs$core$IFn$_invoke$arity$1 ? self__.tag_fn.cljs$core$IFn$_invoke$arity$1(G__34567) : self__.tag_fn.call(null,G__34567));
});

cognitect.transit.t34564.prototype.rep = (function (o){
var self__ = this;
var _ = this;
var G__34568 = o;
return (self__.rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.rep_fn.cljs$core$IFn$_invoke$arity$1(G__34568) : self__.rep_fn.call(null,G__34568));
});

cognitect.transit.t34564.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
var G__34569 = o;
return (self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1 ? self__.str_rep_fn.cljs$core$IFn$_invoke$arity$1(G__34569) : self__.str_rep_fn.call(null,G__34569));
} else {
return null;
}
});

cognitect.transit.t34564.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return (self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0 ? self__.verbose_handler_fn.cljs$core$IFn$_invoke$arity$0() : self__.verbose_handler_fn.call(null));
} else {
return null;
}
});

cognitect.transit.t34564.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta34565","meta34565",83515094,null)], null);
});

cognitect.transit.t34564.cljs$lang$type = true;

cognitect.transit.t34564.cljs$lang$ctorStr = "cognitect.transit/t34564";

cognitect.transit.t34564.cljs$lang$ctorPrWriter = (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"cognitect.transit/t34564");
});

cognitect.transit.__GT_t34564 = (function cognitect$transit$__GT_t34564(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta34565){
return (new cognitect.transit.t34564(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta34565));
});

}

return (new cognitect.transit.t34564(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
var G__34573 = tag;
var G__34574 = rep;
return (com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2 ? com.cognitect.transit.types.taggedValue.cljs$core$IFn$_invoke$arity$2(G__34573,G__34574) : com.cognitect.transit.types.taggedValue.call(null,G__34573,G__34574));
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
var G__34576 = x;
return (com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isTaggedValue.cljs$core$IFn$_invoke$arity$1(G__34576) : com.cognitect.transit.types.isTaggedValue.call(null,G__34576));
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
var G__34578 = s;
return (com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.integer.cljs$core$IFn$_invoke$arity$1(G__34578) : com.cognitect.transit.types.integer.call(null,G__34578));
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
var G__34580 = x;
return (com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isInteger.cljs$core$IFn$_invoke$arity$1(G__34580) : com.cognitect.transit.types.isInteger.call(null,G__34580));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
var G__34582 = s;
return (com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigInteger.cljs$core$IFn$_invoke$arity$1(G__34582) : com.cognitect.transit.types.bigInteger.call(null,G__34582));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
var G__34584 = x;
return (com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigInteger.cljs$core$IFn$_invoke$arity$1(G__34584) : com.cognitect.transit.types.isBigInteger.call(null,G__34584));
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
var G__34586 = s;
return (com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.bigDecimalValue.cljs$core$IFn$_invoke$arity$1(G__34586) : com.cognitect.transit.types.bigDecimalValue.call(null,G__34586));
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
var G__34588 = x;
return (com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBigDecimal.cljs$core$IFn$_invoke$arity$1(G__34588) : com.cognitect.transit.types.isBigDecimal.call(null,G__34588));
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
var G__34590 = s;
return (com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uri.cljs$core$IFn$_invoke$arity$1(G__34590) : com.cognitect.transit.types.uri.call(null,G__34590));
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
var G__34592 = x;
return (com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isURI.cljs$core$IFn$_invoke$arity$1(G__34592) : com.cognitect.transit.types.isURI.call(null,G__34592));
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
var G__34594 = s;
return (com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.uuid.cljs$core$IFn$_invoke$arity$1(G__34594) : com.cognitect.transit.types.uuid.call(null,G__34594));
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var G__34596 = x;
return (com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isUUID.cljs$core$IFn$_invoke$arity$1(G__34596) : com.cognitect.transit.types.isUUID.call(null,G__34596));
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
var G__34598 = s;
return (com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.binary.cljs$core$IFn$_invoke$arity$1(G__34598) : com.cognitect.transit.types.binary.call(null,G__34598));
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
var G__34600 = x;
return (com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isBinary.cljs$core$IFn$_invoke$arity$1(G__34600) : com.cognitect.transit.types.isBinary.call(null,G__34600));
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
var G__34602 = x;
return (com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.quoted.cljs$core$IFn$_invoke$arity$1(G__34602) : com.cognitect.transit.types.quoted.call(null,G__34602));
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
var G__34604 = x;
return (com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isQuoted.cljs$core$IFn$_invoke$arity$1(G__34604) : com.cognitect.transit.types.isQuoted.call(null,G__34604));
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
var G__34606 = x;
return (com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.link.cljs$core$IFn$_invoke$arity$1(G__34606) : com.cognitect.transit.types.link.call(null,G__34606));
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
var G__34608 = x;
return (com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1 ? com.cognitect.transit.types.isLink.cljs$core$IFn$_invoke$arity$1(G__34608) : com.cognitect.transit.types.isLink.call(null,G__34608));
});
