// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `callback`, `no-cache?`.
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var argseq__9254__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9254__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31018){
var map__31019 = p__31018;
var map__31019__$1 = ((cljs.core.seq_QMARK_(map__31019))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31019):map__31019);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$callback);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$http_DASH_options);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31019__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete),cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$xhr,true,cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__11700__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (){
var f__11701__auto__ = (function (){var switch__11638__auto__ = ((function (c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (state_31024){
var state_val_31025 = (state_31024[(1)]);
if((state_val_31025 === (1))){
var state_31024__$1 = state_31024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31024__$1,(2),ch);
} else {
if((state_val_31025 === (2))){
var inst_31021 = (state_31024[(2)]);
var inst_31022 = (function (){var G__31026 = inst_31021;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__31026) : callback.call(null,G__31026));
})();
var state_31024__$1 = state_31024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31024__$1,inst_31022);
} else {
return null;
}
}
});})(c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
;
return ((function (switch__11638__auto__,c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function() {
var milia$api$http$state_machine__11639__auto__ = null;
var milia$api$http$state_machine__11639__auto____0 = (function (){
var statearr_31030 = [null,null,null,null,null,null,null];
(statearr_31030[(0)] = milia$api$http$state_machine__11639__auto__);

(statearr_31030[(1)] = (1));

return statearr_31030;
});
var milia$api$http$state_machine__11639__auto____1 = (function (state_31024){
while(true){
var ret_value__11640__auto__ = (function (){try{while(true){
var result__11641__auto__ = switch__11638__auto__(state_31024);
if(cljs.core.keyword_identical_QMARK_(result__11641__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11641__auto__;
}
break;
}
}catch (e31031){if((e31031 instanceof Object)){
var ex__11642__auto__ = e31031;
var statearr_31032_31034 = state_31024;
(statearr_31032_31034[(5)] = ex__11642__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31024);

return cljs.core.constant$keyword$recur;
} else {
throw e31031;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11640__auto__,cljs.core.constant$keyword$recur)){
var G__31035 = state_31024;
state_31024 = G__31035;
continue;
} else {
return ret_value__11640__auto__;
}
break;
}
});
milia$api$http$state_machine__11639__auto__ = function(state_31024){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__11639__auto____0.call(this);
case 1:
return milia$api$http$state_machine__11639__auto____1.call(this,state_31024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__11639__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__11639__auto____0;
milia$api$http$state_machine__11639__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__11639__auto____1;
return milia$api$http$state_machine__11639__auto__;
})()
;})(switch__11638__auto__,c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
})();
var state__11702__auto__ = (function (){var statearr_31033 = (function (){return (f__11701__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11701__auto__.cljs$core$IFn$_invoke$arity$0() : f__11701__auto__.call(null));
})();
(statearr_31033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11700__auto__);

return statearr_31033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11702__auto__);
});})(c__11700__auto__,request_fn,headers,ch,map__31019,map__31019__$1,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
);

return c__11700__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq31015){
var G__31016 = cljs.core.first(seq31015);
var seq31015__$1 = cljs.core.next(seq31015);
var G__31017 = cljs.core.first(seq31015__$1);
var seq31015__$2 = cljs.core.next(seq31015__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31016,G__31017,seq31015__$2);
});
