// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.url');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,milia.utils.url.last_url_param(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(){
var G__31063 = arguments.length;
switch (G__31063) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all.cljs$core$IFn$_invoke$arity$1(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$1 = (function (owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((!((owner == null)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$owner,owner], null)], null):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options], 0));
});

milia.api.project.all.cljs$lang$maxFixedArity = 1;
/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$form_DASH_params,form_params], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,data,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(){
var G__31066 = arguments.length;
switch (G__31066) {
case 3:
return milia.api.project.share.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.project.share.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$3 = (function (project_id,username,role){
return milia.api.project.share.cljs$core$IFn$_invoke$arity$4(project_id,username,role,false);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$4 = (function (project_id,username,role,remove_QMARK_){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = 4;
/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$post,url);
});
/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,form_params,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Update the project
 */
milia.api.project.update_project = (function milia$api$project$update_project(projectid,owner,params){
var url = [cljs.core.str("/"),cljs.core.str(owner),cljs.core.str("/"),cljs.core.str(projectid),cljs.core.str("/project-settings")].join('');
var query_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$project_DASH_id,projectid,cljs.core.constant$keyword$patch,true], null),params], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,query_params], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,owner,public$){
return milia.api.project.update_project(projectid,owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$public,public$], null));
});
