// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__8170__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__8170__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__8170__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_(class_name,class$,i)){
return i;
} else {
var G__33932 = (i + class$.length);
start_from = G__33932;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4423__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4423__auto__)){
var class_list = temp__4423__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4425__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4425__auto__)){
var class_name = temp__4425__auto__;
var temp__4425__auto____$1 = dommy.attrs.class_index(class_name,class$__$1);
if(cljs.core.truth_(temp__4425__auto____$1)){
var i = temp__4425__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__33937 = arguments.length;
switch (G__33937) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9233__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var classes__$1 = clojure.string.trim(cljs.core.name(classes));
if(cljs.core.seq(classes__$1)){
var temp__4423__auto___33951 = elem__$1.classList;
if(cljs.core.truth_(temp__4423__auto___33951)){
var class_list_33952 = temp__4423__auto___33951;
var seq__33938_33953 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__33939_33954 = null;
var count__33940_33955 = (0);
var i__33941_33956 = (0);
while(true){
if((i__33941_33956 < count__33940_33955)){
var class_33957 = chunk__33939_33954.cljs$core$IIndexed$_nth$arity$2(null,i__33941_33956);
class_list_33952.add(class_33957);

var G__33958 = seq__33938_33953;
var G__33959 = chunk__33939_33954;
var G__33960 = count__33940_33955;
var G__33961 = (i__33941_33956 + (1));
seq__33938_33953 = G__33958;
chunk__33939_33954 = G__33959;
count__33940_33955 = G__33960;
i__33941_33956 = G__33961;
continue;
} else {
var temp__4425__auto___33962 = cljs.core.seq(seq__33938_33953);
if(temp__4425__auto___33962){
var seq__33938_33963__$1 = temp__4425__auto___33962;
if(cljs.core.chunked_seq_QMARK_(seq__33938_33963__$1)){
var c__8967__auto___33964 = cljs.core.chunk_first(seq__33938_33963__$1);
var G__33965 = cljs.core.chunk_rest(seq__33938_33963__$1);
var G__33966 = c__8967__auto___33964;
var G__33967 = cljs.core.count(c__8967__auto___33964);
var G__33968 = (0);
seq__33938_33953 = G__33965;
chunk__33939_33954 = G__33966;
count__33940_33955 = G__33967;
i__33941_33956 = G__33968;
continue;
} else {
var class_33969 = cljs.core.first(seq__33938_33963__$1);
class_list_33952.add(class_33969);

var G__33970 = cljs.core.next(seq__33938_33963__$1);
var G__33971 = null;
var G__33972 = (0);
var G__33973 = (0);
seq__33938_33953 = G__33970;
chunk__33939_33954 = G__33971;
count__33940_33955 = G__33972;
i__33941_33956 = G__33973;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_33974 = elem__$1.className;
var seq__33942_33975 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__33943_33976 = null;
var count__33944_33977 = (0);
var i__33945_33978 = (0);
while(true){
if((i__33945_33978 < count__33944_33977)){
var class_33979 = chunk__33943_33976.cljs$core$IIndexed$_nth$arity$2(null,i__33945_33978);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_33974,class_33979))){
} else {
elem__$1.className = (((class_name_33974 === ""))?class_33979:[cljs.core.str(class_name_33974),cljs.core.str(" "),cljs.core.str(class_33979)].join(''));
}

var G__33980 = seq__33942_33975;
var G__33981 = chunk__33943_33976;
var G__33982 = count__33944_33977;
var G__33983 = (i__33945_33978 + (1));
seq__33942_33975 = G__33980;
chunk__33943_33976 = G__33981;
count__33944_33977 = G__33982;
i__33945_33978 = G__33983;
continue;
} else {
var temp__4425__auto___33984 = cljs.core.seq(seq__33942_33975);
if(temp__4425__auto___33984){
var seq__33942_33985__$1 = temp__4425__auto___33984;
if(cljs.core.chunked_seq_QMARK_(seq__33942_33985__$1)){
var c__8967__auto___33986 = cljs.core.chunk_first(seq__33942_33985__$1);
var G__33987 = cljs.core.chunk_rest(seq__33942_33985__$1);
var G__33988 = c__8967__auto___33986;
var G__33989 = cljs.core.count(c__8967__auto___33986);
var G__33990 = (0);
seq__33942_33975 = G__33987;
chunk__33943_33976 = G__33988;
count__33944_33977 = G__33989;
i__33945_33978 = G__33990;
continue;
} else {
var class_33991 = cljs.core.first(seq__33942_33985__$1);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_33974,class_33991))){
} else {
elem__$1.className = (((class_name_33974 === ""))?class_33991:[cljs.core.str(class_name_33974),cljs.core.str(" "),cljs.core.str(class_33991)].join(''));
}

var G__33992 = cljs.core.next(seq__33942_33985__$1);
var G__33993 = null;
var G__33994 = (0);
var G__33995 = (0);
seq__33942_33975 = G__33992;
chunk__33943_33976 = G__33993;
count__33944_33977 = G__33994;
i__33945_33978 = G__33995;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__33946_33996 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__33947_33997 = null;
var count__33948_33998 = (0);
var i__33949_33999 = (0);
while(true){
if((i__33949_33999 < count__33948_33998)){
var c_34000 = chunk__33947_33997.cljs$core$IIndexed$_nth$arity$2(null,i__33949_33999);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_34000);

var G__34001 = seq__33946_33996;
var G__34002 = chunk__33947_33997;
var G__34003 = count__33948_33998;
var G__34004 = (i__33949_33999 + (1));
seq__33946_33996 = G__34001;
chunk__33947_33997 = G__34002;
count__33948_33998 = G__34003;
i__33949_33999 = G__34004;
continue;
} else {
var temp__4425__auto___34005 = cljs.core.seq(seq__33946_33996);
if(temp__4425__auto___34005){
var seq__33946_34006__$1 = temp__4425__auto___34005;
if(cljs.core.chunked_seq_QMARK_(seq__33946_34006__$1)){
var c__8967__auto___34007 = cljs.core.chunk_first(seq__33946_34006__$1);
var G__34008 = cljs.core.chunk_rest(seq__33946_34006__$1);
var G__34009 = c__8967__auto___34007;
var G__34010 = cljs.core.count(c__8967__auto___34007);
var G__34011 = (0);
seq__33946_33996 = G__34008;
chunk__33947_33997 = G__34009;
count__33948_33998 = G__34010;
i__33949_33999 = G__34011;
continue;
} else {
var c_34012 = cljs.core.first(seq__33946_34006__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_34012);

var G__34013 = cljs.core.next(seq__33946_34006__$1);
var G__34014 = null;
var G__34015 = (0);
var G__34016 = (0);
seq__33946_33996 = G__34013;
chunk__33947_33997 = G__34014;
count__33948_33998 = G__34015;
i__33949_33999 = G__34016;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq33933){
var G__33934 = cljs.core.first(seq33933);
var seq33933__$1 = cljs.core.next(seq33933);
var G__33935 = cljs.core.first(seq33933__$1);
var seq33933__$2 = cljs.core.next(seq33933__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33934,G__33935,seq33933__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = (2);
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4423__auto__ = dommy.attrs.class_index(class_name,class$);
if(cljs.core.truth_(temp__4423__auto__)){
var i = temp__4423__auto__;
var G__34017 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__34017;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__34022 = arguments.length;
switch (G__34022) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9233__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4423__auto___34028 = elem__$1.classList;
if(cljs.core.truth_(temp__4423__auto___34028)){
var class_list_34029 = temp__4423__auto___34028;
class_list_34029.remove(class$__$1);
} else {
var class_name_34030 = elem__$1.className;
var new_class_name_34031 = dommy.attrs.remove_class_str(class_name_34030,class$__$1);
if((class_name_34030 === new_class_name_34031)){
} else {
elem__$1.className = new_class_name_34031;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__34023 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__34024 = null;
var count__34025 = (0);
var i__34026 = (0);
while(true){
if((i__34026 < count__34025)){
var c = chunk__34024.cljs$core$IIndexed$_nth$arity$2(null,i__34026);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__34032 = seq__34023;
var G__34033 = chunk__34024;
var G__34034 = count__34025;
var G__34035 = (i__34026 + (1));
seq__34023 = G__34032;
chunk__34024 = G__34033;
count__34025 = G__34034;
i__34026 = G__34035;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__34023);
if(temp__4425__auto__){
var seq__34023__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34023__$1)){
var c__8967__auto__ = cljs.core.chunk_first(seq__34023__$1);
var G__34036 = cljs.core.chunk_rest(seq__34023__$1);
var G__34037 = c__8967__auto__;
var G__34038 = cljs.core.count(c__8967__auto__);
var G__34039 = (0);
seq__34023 = G__34036;
chunk__34024 = G__34037;
count__34025 = G__34038;
i__34026 = G__34039;
continue;
} else {
var c = cljs.core.first(seq__34023__$1);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__34040 = cljs.core.next(seq__34023__$1);
var G__34041 = null;
var G__34042 = (0);
var G__34043 = (0);
seq__34023 = G__34040;
chunk__34024 = G__34041;
count__34025 = G__34042;
i__34026 = G__34043;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq34018){
var G__34019 = cljs.core.first(seq34018);
var seq34018__$1 = cljs.core.next(seq34018);
var G__34020 = cljs.core.first(seq34018__$1);
var seq34018__$2 = cljs.core.next(seq34018__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34019,G__34020,seq34018__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__34045 = arguments.length;
switch (G__34045) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4423__auto___34047 = elem__$1.classList;
if(cljs.core.truth_(temp__4423__auto___34047)){
var class_list_34048 = temp__4423__auto___34047;
class_list_34048.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_(elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34051){
var vec__34052 = p__34051;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34052,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34052,(1),null);
return [cljs.core.str(cljs.core.name(k)),cljs.core.str(":"),cljs.core.str(cljs.core.name(v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var style = elem__$1.style;
var seq__34055_34061 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__34056_34062 = null;
var count__34057_34063 = (0);
var i__34058_34064 = (0);
while(true){
if((i__34058_34064 < count__34057_34063)){
var vec__34059_34065 = chunk__34056_34062.cljs$core$IIndexed$_nth$arity$2(null,i__34058_34064);
var k_34066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34059_34065,(0),null);
var v_34067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34059_34065,(1),null);
(style[cljs.core.name(k_34066)] = v_34067);

var G__34068 = seq__34055_34061;
var G__34069 = chunk__34056_34062;
var G__34070 = count__34057_34063;
var G__34071 = (i__34058_34064 + (1));
seq__34055_34061 = G__34068;
chunk__34056_34062 = G__34069;
count__34057_34063 = G__34070;
i__34058_34064 = G__34071;
continue;
} else {
var temp__4425__auto___34072 = cljs.core.seq(seq__34055_34061);
if(temp__4425__auto___34072){
var seq__34055_34073__$1 = temp__4425__auto___34072;
if(cljs.core.chunked_seq_QMARK_(seq__34055_34073__$1)){
var c__8967__auto___34074 = cljs.core.chunk_first(seq__34055_34073__$1);
var G__34075 = cljs.core.chunk_rest(seq__34055_34073__$1);
var G__34076 = c__8967__auto___34074;
var G__34077 = cljs.core.count(c__8967__auto___34074);
var G__34078 = (0);
seq__34055_34061 = G__34075;
chunk__34056_34062 = G__34076;
count__34057_34063 = G__34077;
i__34058_34064 = G__34078;
continue;
} else {
var vec__34060_34079 = cljs.core.first(seq__34055_34073__$1);
var k_34080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34060_34079,(0),null);
var v_34081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34060_34079,(1),null);
(style[cljs.core.name(k_34080)] = v_34081);

var G__34082 = cljs.core.next(seq__34055_34073__$1);
var G__34083 = null;
var G__34084 = (0);
var G__34085 = (0);
seq__34055_34061 = G__34082;
chunk__34056_34062 = G__34083;
count__34057_34063 = G__34084;
i__34058_34064 = G__34085;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq34053){
var G__34054 = cljs.core.first(seq34053);
var seq34053__$1 = cljs.core.next(seq34053);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34054,seq34053__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"k","k",-505765866,null)], 0)))].join('')));
}

return ((function (){var G__34087 = dommy.template.__GT_node_like(elem);
return window.getComputedStyle(G__34087);
})()[cljs.core.name(k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__34090_34096 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__34091_34097 = null;
var count__34092_34098 = (0);
var i__34093_34099 = (0);
while(true){
if((i__34093_34099 < count__34092_34098)){
var vec__34094_34100 = chunk__34091_34097.cljs$core$IIndexed$_nth$arity$2(null,i__34093_34099);
var k_34101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34094_34100,(0),null);
var v_34102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34094_34100,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_34101,[cljs.core.str(v_34102),cljs.core.str("px")].join('')], 0));

var G__34103 = seq__34090_34096;
var G__34104 = chunk__34091_34097;
var G__34105 = count__34092_34098;
var G__34106 = (i__34093_34099 + (1));
seq__34090_34096 = G__34103;
chunk__34091_34097 = G__34104;
count__34092_34098 = G__34105;
i__34093_34099 = G__34106;
continue;
} else {
var temp__4425__auto___34107 = cljs.core.seq(seq__34090_34096);
if(temp__4425__auto___34107){
var seq__34090_34108__$1 = temp__4425__auto___34107;
if(cljs.core.chunked_seq_QMARK_(seq__34090_34108__$1)){
var c__8967__auto___34109 = cljs.core.chunk_first(seq__34090_34108__$1);
var G__34110 = cljs.core.chunk_rest(seq__34090_34108__$1);
var G__34111 = c__8967__auto___34109;
var G__34112 = cljs.core.count(c__8967__auto___34109);
var G__34113 = (0);
seq__34090_34096 = G__34110;
chunk__34091_34097 = G__34111;
count__34092_34098 = G__34112;
i__34093_34099 = G__34113;
continue;
} else {
var vec__34095_34114 = cljs.core.first(seq__34090_34108__$1);
var k_34115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34095_34114,(0),null);
var v_34116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34095_34114,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_34115,[cljs.core.str(v_34116),cljs.core.str("px")].join('')], 0));

var G__34117 = cljs.core.next(seq__34090_34108__$1);
var G__34118 = null;
var G__34119 = (0);
var G__34120 = (0);
seq__34090_34096 = G__34117;
chunk__34091_34097 = G__34118;
count__34092_34098 = G__34119;
i__34093_34099 = G__34120;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq34088){
var G__34089 = cljs.core.first(seq34088);
var seq34088__$1 = cljs.core.next(seq34088);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34089,seq34088__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style(dommy.template.__GT_node_like(elem),k);
if(cljs.core.seq(pixels)){
var G__34122 = pixels;
return parseInt(G__34122);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__34128 = arguments.length;
switch (G__34128) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9233__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__34129 = dommy.template.__GT_node_like(elem);
(G__34129[cljs.core.name(k)] = v);

return G__34129;
} else {
var G__34130 = dommy.template.__GT_node_like(elem);
G__34130.setAttribute(cljs.core.name(k),(((k === cljs.core.constant$keyword$style))?dommy.attrs.style_str(v):v));

return G__34130;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__34131_34138 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__34132_34139 = null;
var count__34133_34140 = (0);
var i__34134_34141 = (0);
while(true){
if((i__34134_34141 < count__34133_34140)){
var vec__34135_34142 = chunk__34132_34139.cljs$core$IIndexed$_nth$arity$2(null,i__34134_34141);
var k_34143__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34135_34142,(0),null);
var v_34144__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34135_34142,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_34143__$1,v_34144__$1);

var G__34145 = seq__34131_34138;
var G__34146 = chunk__34132_34139;
var G__34147 = count__34133_34140;
var G__34148 = (i__34134_34141 + (1));
seq__34131_34138 = G__34145;
chunk__34132_34139 = G__34146;
count__34133_34140 = G__34147;
i__34134_34141 = G__34148;
continue;
} else {
var temp__4425__auto___34149 = cljs.core.seq(seq__34131_34138);
if(temp__4425__auto___34149){
var seq__34131_34150__$1 = temp__4425__auto___34149;
if(cljs.core.chunked_seq_QMARK_(seq__34131_34150__$1)){
var c__8967__auto___34151 = cljs.core.chunk_first(seq__34131_34150__$1);
var G__34152 = cljs.core.chunk_rest(seq__34131_34150__$1);
var G__34153 = c__8967__auto___34151;
var G__34154 = cljs.core.count(c__8967__auto___34151);
var G__34155 = (0);
seq__34131_34138 = G__34152;
chunk__34132_34139 = G__34153;
count__34133_34140 = G__34154;
i__34134_34141 = G__34155;
continue;
} else {
var vec__34136_34156 = cljs.core.first(seq__34131_34150__$1);
var k_34157__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34136_34156,(0),null);
var v_34158__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34136_34156,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_34157__$1,v_34158__$1);

var G__34159 = cljs.core.next(seq__34131_34150__$1);
var G__34160 = null;
var G__34161 = (0);
var G__34162 = (0);
seq__34131_34138 = G__34159;
chunk__34132_34139 = G__34160;
count__34133_34140 = G__34161;
i__34134_34141 = G__34162;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq34123){
var G__34124 = cljs.core.first(seq34123);
var seq34123__$1 = cljs.core.next(seq34123);
var G__34125 = cljs.core.first(seq34123__$1);
var seq34123__$2 = cljs.core.next(seq34123__$1);
var G__34126 = cljs.core.first(seq34123__$2);
var seq34123__$3 = cljs.core.next(seq34123__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34124,G__34125,G__34126,seq34123__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = (3);
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__34167 = arguments.length;
switch (G__34167) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9233__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$class,null,cljs.core.constant$keyword$classes,null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name(k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__34168_34173 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__34169_34174 = null;
var count__34170_34175 = (0);
var i__34171_34176 = (0);
while(true){
if((i__34171_34176 < count__34170_34175)){
var k_34177__$1 = chunk__34169_34174.cljs$core$IIndexed$_nth$arity$2(null,i__34171_34176);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_34177__$1);

var G__34178 = seq__34168_34173;
var G__34179 = chunk__34169_34174;
var G__34180 = count__34170_34175;
var G__34181 = (i__34171_34176 + (1));
seq__34168_34173 = G__34178;
chunk__34169_34174 = G__34179;
count__34170_34175 = G__34180;
i__34171_34176 = G__34181;
continue;
} else {
var temp__4425__auto___34182 = cljs.core.seq(seq__34168_34173);
if(temp__4425__auto___34182){
var seq__34168_34183__$1 = temp__4425__auto___34182;
if(cljs.core.chunked_seq_QMARK_(seq__34168_34183__$1)){
var c__8967__auto___34184 = cljs.core.chunk_first(seq__34168_34183__$1);
var G__34185 = cljs.core.chunk_rest(seq__34168_34183__$1);
var G__34186 = c__8967__auto___34184;
var G__34187 = cljs.core.count(c__8967__auto___34184);
var G__34188 = (0);
seq__34168_34173 = G__34185;
chunk__34169_34174 = G__34186;
count__34170_34175 = G__34187;
i__34171_34176 = G__34188;
continue;
} else {
var k_34189__$1 = cljs.core.first(seq__34168_34183__$1);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_34189__$1);

var G__34190 = cljs.core.next(seq__34168_34183__$1);
var G__34191 = null;
var G__34192 = (0);
var G__34193 = (0);
seq__34168_34173 = G__34190;
chunk__34169_34174 = G__34191;
count__34170_34175 = G__34192;
i__34171_34176 = G__34193;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq34163){
var G__34164 = cljs.core.first(seq34163);
var seq34163__$1 = cljs.core.next(seq34163);
var G__34165 = cljs.core.first(seq34163__$1);
var seq34163__$2 = cljs.core.next(seq34163__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34164,G__34165,seq34163__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like(elem).getAttribute(cljs.core.name(k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__34195 = arguments.length;
switch (G__34195) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.attrs.attr(elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like(elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__34198 = arguments.length;
switch (G__34198) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__34199 = dommy.template.__GT_node_like(elem);
G__34199.style.display = ((show_QMARK_)?"":"none");

return G__34199;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,dommy.attrs.hidden_QMARK_(elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__34202 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__34202,false);

return G__34202;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__34204 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__34204,true);

return G__34204;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__34206 = dommy.template.__GT_node_like(elem).getBoundingClientRect();
(G__34206["constructor"] = Object);

return G__34206;
})(),cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0));
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
var top = cljs.core.constant$keyword$top.cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect(elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
