// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataview');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create new dataview from existing dataset
 */
milia.api.dataview.create = (function milia$api$dataview$create(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves dataview object using dataview id
 */
milia.api.dataview.get = (function milia$api$dataview$get(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves dataview data using dataview id
 */
milia.api.dataview.data = (function milia$api$dataview$data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$raw_DASH_response_QMARK_,true], 0));
});
/**
 * Counts data instances returned by dataview object
 */
milia.api.dataview.count_data = (function milia$api$dataview$count_data(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id,"data"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$count,true], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Retrieves all dataview objects
 */
milia.api.dataview.all = (function milia$api$dataview$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Updates dataview object
 */
milia.api.dataview.update = (function milia$api$dataview$update(dataview_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Deletes dataview object
 */
milia.api.dataview.delete$ = (function milia$api$dataview$delete(dataview_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataview_id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
