// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__7925__auto__ = v;
if(cljs.core.truth_(and__7925__auto__)){
return (v > (0));
} else {
return and__7925__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__29250_SHARP_,p2__29249_SHARP_){
var vec__29252 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__29249_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29252,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29252,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29250_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29253_SHARP_){
return cljs_http.client.encode_val(k,p1__29253_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__29254){
var vec__29256 = p__29254;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29256,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29256,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__29257_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__29257_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__7925__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__7925__auto__){
var and__7925__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__7925__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__7925__auto____$1;
}
} else {
return and__7925__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29259 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29259) : client.call(null,G__29259));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29260_SHARP_){
return cljs_http.client.decode_body(p1__29260_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(){
var args__8983__auto__ = [];
var len__8976__auto___29266 = arguments.length;
var i__8977__auto___29267 = (0);
while(true){
if((i__8977__auto___29267 < len__8976__auto___29266)){
args__8983__auto__.push((arguments[i__8977__auto___29267]));

var G__29268 = (i__8977__auto___29267 + (1));
i__8977__auto___29267 = G__29268;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29263){
var vec__29264 = p__29263;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29264,(0),null);
return ((function (vec__29264,default_headers){
return (function (request){
var temp__4423__auto__ = (function (){var or__7937__auto__ = cljs.core.constant$keyword$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var default_headers__$1 = temp__4423__auto__;
var G__29265 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.constant$keyword$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29265) : client.call(null,G__29265));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29264,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq29261){
var G__29262 = cljs.core.first(seq29261);
var seq29261__$1 = cljs.core.next(seq29261);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__29262,seq29261__$1);
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var args__8983__auto__ = [];
var len__8976__auto___29274 = arguments.length;
var i__8977__auto___29275 = (0);
while(true){
if((i__8977__auto___29275 < len__8976__auto___29274)){
args__8983__auto__.push((arguments[i__8977__auto___29275]));

var G__29276 = (i__8977__auto___29275 + (1));
i__8977__auto___29275 = G__29276;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29271){
var vec__29272 = p__29271;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29272,(0),null);
return ((function (vec__29272,accept){
return (function (request){
var temp__4423__auto__ = (function (){var or__7937__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var accept__$1 = temp__4423__auto__;
var G__29273 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29273) : client.call(null,G__29273));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29272,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq29269){
var G__29270 = cljs.core.first(seq29269);
var seq29269__$1 = cljs.core.next(seq29269);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__29270,seq29269__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var args__8983__auto__ = [];
var len__8976__auto___29282 = arguments.length;
var i__8977__auto___29283 = (0);
while(true){
if((i__8977__auto___29283 < len__8976__auto___29282)){
args__8983__auto__.push((arguments[i__8977__auto___29283]));

var G__29284 = (i__8977__auto___29283 + (1));
i__8977__auto___29283 = G__29284;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29279){
var vec__29280 = p__29279;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29280,(0),null);
return ((function (vec__29280,content_type){
return (function (request){
var temp__4423__auto__ = (function (){var or__7937__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var content_type__$1 = temp__4423__auto__;
var G__29281 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29281) : client.call(null,G__29281));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29280,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq29277){
var G__29278 = cljs.core.first(seq29277);
var seq29277__$1 = cljs.core.next(seq29277);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__29278,seq29277__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var map__29288 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29288__$1 = ((((!((map__29288 == null)))?((((map__29288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29288):map__29288);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29288__$1,cljs.core.constant$keyword$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29288__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var G__29290 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29290) : client.call(null,G__29290));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__29295 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29295__$1 = ((((!((map__29295 == null)))?((((map__29295.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29295.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29295):map__29295);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29295__$1,cljs.core.constant$keyword$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29295__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var transit_decode = ((function (map__29295,map__29295__$1,decoding,decoding_opts){
return (function (p1__29291_SHARP_){
return cljs_http.util.transit_decode(p1__29291_SHARP_,decoding,decoding_opts);
});})(map__29295,map__29295__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__29295,map__29295__$1,decoding,decoding_opts,transit_decode){
return (function (p1__29292_SHARP_){
return cljs_http.client.decode_body(p1__29292_SHARP_,transit_decode,"application/transit+json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__29295,map__29295__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29298 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29298) : client.call(null,G__29298));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29299_SHARP_){
return cljs_http.client.decode_body(p1__29299_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__29304){
var map__29305 = p__29304;
var map__29305__$1 = ((((!((map__29305 == null)))?((((map__29305.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29305.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29305):map__29305);
var req = map__29305__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29305__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__29307 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29307) : client.call(null,G__29307));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__29312){
var map__29313 = p__29312;
var map__29313__$1 = ((((!((map__29313 == null)))?((((map__29313.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29313.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29313):map__29313);
var request = map__29313__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29313__$1,cljs.core.constant$keyword$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29313__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__7925__auto__ = form_params;
if(cljs.core.truth_(and__7925__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__7925__auto__;
}
})())){
var G__29315 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29315) : client.call(null,G__29315));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__29322_29328 = cljs.core.seq(params);
var chunk__29323_29329 = null;
var count__29324_29330 = (0);
var i__29325_29331 = (0);
while(true){
if((i__29325_29331 < count__29324_29330)){
var vec__29326_29332 = chunk__29323_29329.cljs$core$IIndexed$_nth$arity$2(null,i__29325_29331);
var k_29333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29326_29332,(0),null);
var v_29334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29326_29332,(1),null);
form_data.append(cljs.core.name(k_29333),v_29334);

var G__29335 = seq__29322_29328;
var G__29336 = chunk__29323_29329;
var G__29337 = count__29324_29330;
var G__29338 = (i__29325_29331 + (1));
seq__29322_29328 = G__29335;
chunk__29323_29329 = G__29336;
count__29324_29330 = G__29337;
i__29325_29331 = G__29338;
continue;
} else {
var temp__4425__auto___29339 = cljs.core.seq(seq__29322_29328);
if(temp__4425__auto___29339){
var seq__29322_29340__$1 = temp__4425__auto___29339;
if(cljs.core.chunked_seq_QMARK_(seq__29322_29340__$1)){
var c__8721__auto___29341 = cljs.core.chunk_first(seq__29322_29340__$1);
var G__29342 = cljs.core.chunk_rest(seq__29322_29340__$1);
var G__29343 = c__8721__auto___29341;
var G__29344 = cljs.core.count(c__8721__auto___29341);
var G__29345 = (0);
seq__29322_29328 = G__29342;
chunk__29323_29329 = G__29343;
count__29324_29330 = G__29344;
i__29325_29331 = G__29345;
continue;
} else {
var vec__29327_29346 = cljs.core.first(seq__29322_29340__$1);
var k_29347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29327_29346,(0),null);
var v_29348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29327_29346,(1),null);
form_data.append(cljs.core.name(k_29347),v_29348);

var G__29349 = cljs.core.next(seq__29322_29340__$1);
var G__29350 = null;
var G__29351 = (0);
var G__29352 = (0);
seq__29322_29328 = G__29349;
chunk__29323_29329 = G__29350;
count__29324_29330 = G__29351;
i__29325_29331 = G__29352;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__29357){
var map__29358 = p__29357;
var map__29358__$1 = ((((!((map__29358 == null)))?((((map__29358.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29358.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29358):map__29358);
var request = map__29358__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29358__$1,cljs.core.constant$keyword$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29358__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__7925__auto__ = multipart_params;
if(cljs.core.truth_(and__7925__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__7925__auto__;
}
})())){
var G__29360 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$multipart_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29360) : client.call(null,G__29360));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var m = temp__4423__auto__;
var G__29362 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29362) : client.call(null,G__29362));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__29363_SHARP_){
var G__29365 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29363_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29365) : client.call(null,G__29365));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__29371){
var map__29372 = p__29371;
var map__29372__$1 = ((((!((map__29372 == null)))?((((map__29372.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29372.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29372):map__29372);
var req = map__29372__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29372__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4423__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4423__auto__)){
var spec = temp__4423__auto__;
var G__29374 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4423__auto__,map__29372,map__29372__$1,req,query_params){
return (function (p1__29366_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29366_SHARP_,query_params], 0));
});})(spec,temp__4423__auto__,map__29372,map__29372__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29374) : client.call(null,G__29374));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var args__8983__auto__ = [];
var len__8976__auto___29380 = arguments.length;
var i__8977__auto___29381 = (0);
while(true){
if((i__8977__auto___29381 < len__8976__auto___29380)){
args__8983__auto__.push((arguments[i__8977__auto___29381]));

var G__29382 = (i__8977__auto___29381 + (1));
i__8977__auto___29381 = G__29382;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29377){
var vec__29378 = p__29377;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29378,(0),null);
return ((function (vec__29378,credentials){
return (function (req){
var credentials__$1 = (function (){var or__7937__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__29379 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29379) : client.call(null,G__29379));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__29378,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq29375){
var G__29376 = cljs.core.first(seq29375);
var seq29375__$1 = cljs.core.next(seq29375);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__29376,seq29375__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var oauth_token = temp__4423__auto__;
var G__29384 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29384) : client.call(null,G__29384));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var custom_channel = temp__4423__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var args__8983__auto__ = [];
var len__8976__auto___29390 = arguments.length;
var i__8977__auto___29391 = (0);
while(true){
if((i__8977__auto___29391 < len__8976__auto___29390)){
args__8983__auto__.push((arguments[i__8977__auto___29391]));

var G__29392 = (i__8977__auto___29391 + (1));
i__8977__auto___29391 = G__29392;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29387){
var vec__29388 = p__29387;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29388,(0),null);
var G__29389 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29389) : cljs_http.client.request.call(null,G__29389));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq29385){
var G__29386 = cljs.core.first(seq29385);
var seq29385__$1 = cljs.core.next(seq29385);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__29386,seq29385__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var args__8983__auto__ = [];
var len__8976__auto___29398 = arguments.length;
var i__8977__auto___29399 = (0);
while(true){
if((i__8977__auto___29399 < len__8976__auto___29398)){
args__8983__auto__.push((arguments[i__8977__auto___29399]));

var G__29400 = (i__8977__auto___29399 + (1));
i__8977__auto___29399 = G__29400;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29395){
var vec__29396 = p__29395;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29396,(0),null);
var G__29397 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29397) : cljs_http.client.request.call(null,G__29397));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq29393){
var G__29394 = cljs.core.first(seq29393);
var seq29393__$1 = cljs.core.next(seq29393);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__29394,seq29393__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var args__8983__auto__ = [];
var len__8976__auto___29406 = arguments.length;
var i__8977__auto___29407 = (0);
while(true){
if((i__8977__auto___29407 < len__8976__auto___29406)){
args__8983__auto__.push((arguments[i__8977__auto___29407]));

var G__29408 = (i__8977__auto___29407 + (1));
i__8977__auto___29407 = G__29408;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29403){
var vec__29404 = p__29403;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29404,(0),null);
var G__29405 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29405) : cljs_http.client.request.call(null,G__29405));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq29401){
var G__29402 = cljs.core.first(seq29401);
var seq29401__$1 = cljs.core.next(seq29401);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__29402,seq29401__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(){
var args__8983__auto__ = [];
var len__8976__auto___29414 = arguments.length;
var i__8977__auto___29415 = (0);
while(true){
if((i__8977__auto___29415 < len__8976__auto___29414)){
args__8983__auto__.push((arguments[i__8977__auto___29415]));

var G__29416 = (i__8977__auto___29415 + (1));
i__8977__auto___29415 = G__29416;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29411){
var vec__29412 = p__29411;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29412,(0),null);
var G__29413 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$jsonp,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29413) : cljs_http.client.request.call(null,G__29413));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq29409){
var G__29410 = cljs.core.first(seq29409);
var seq29409__$1 = cljs.core.next(seq29409);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__29410,seq29409__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var args__8983__auto__ = [];
var len__8976__auto___29422 = arguments.length;
var i__8977__auto___29423 = (0);
while(true){
if((i__8977__auto___29423 < len__8976__auto___29422)){
args__8983__auto__.push((arguments[i__8977__auto___29423]));

var G__29424 = (i__8977__auto___29423 + (1));
i__8977__auto___29423 = G__29424;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29419){
var vec__29420 = p__29419;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29420,(0),null);
var G__29421 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29421) : cljs_http.client.request.call(null,G__29421));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq29417){
var G__29418 = cljs.core.first(seq29417);
var seq29417__$1 = cljs.core.next(seq29417);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__29418,seq29417__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var args__8983__auto__ = [];
var len__8976__auto___29430 = arguments.length;
var i__8977__auto___29431 = (0);
while(true){
if((i__8977__auto___29431 < len__8976__auto___29430)){
args__8983__auto__.push((arguments[i__8977__auto___29431]));

var G__29432 = (i__8977__auto___29431 + (1));
i__8977__auto___29431 = G__29432;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29427){
var vec__29428 = p__29427;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29428,(0),null);
var G__29429 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29429) : cljs_http.client.request.call(null,G__29429));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq29425){
var G__29426 = cljs.core.first(seq29425);
var seq29425__$1 = cljs.core.next(seq29425);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__29426,seq29425__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var args__8983__auto__ = [];
var len__8976__auto___29438 = arguments.length;
var i__8977__auto___29439 = (0);
while(true){
if((i__8977__auto___29439 < len__8976__auto___29438)){
args__8983__auto__.push((arguments[i__8977__auto___29439]));

var G__29440 = (i__8977__auto___29439 + (1));
i__8977__auto___29439 = G__29440;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29435){
var vec__29436 = p__29435;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29436,(0),null);
var G__29437 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29437) : cljs_http.client.request.call(null,G__29437));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq29433){
var G__29434 = cljs.core.first(seq29433);
var seq29433__$1 = cljs.core.next(seq29433);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__29434,seq29433__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var args__8983__auto__ = [];
var len__8976__auto___29446 = arguments.length;
var i__8977__auto___29447 = (0);
while(true){
if((i__8977__auto___29447 < len__8976__auto___29446)){
args__8983__auto__.push((arguments[i__8977__auto___29447]));

var G__29448 = (i__8977__auto___29447 + (1));
i__8977__auto___29447 = G__29448;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29443){
var vec__29444 = p__29443;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29444,(0),null);
var G__29445 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29445) : cljs_http.client.request.call(null,G__29445));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq29441){
var G__29442 = cljs.core.first(seq29441);
var seq29441__$1 = cljs.core.next(seq29441);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__29442,seq29441__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var args__8983__auto__ = [];
var len__8976__auto___29454 = arguments.length;
var i__8977__auto___29455 = (0);
while(true){
if((i__8977__auto___29455 < len__8976__auto___29454)){
args__8983__auto__.push((arguments[i__8977__auto___29455]));

var G__29456 = (i__8977__auto___29455 + (1));
i__8977__auto___29455 = G__29456;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29451){
var vec__29452 = p__29451;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29452,(0),null);
var G__29453 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29453) : cljs_http.client.request.call(null,G__29453));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq29449){
var G__29450 = cljs.core.first(seq29449);
var seq29449__$1 = cljs.core.next(seq29449);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__29450,seq29449__$1);
});
