// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29462 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29462 = (function (fn_handler,f,meta29463){
this.fn_handler = fn_handler;
this.f = f;
this.meta29463 = meta29463;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29462.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29464,meta29463__$1){
var self__ = this;
var _29464__$1 = this;
return (new cljs.core.async.t29462(self__.fn_handler,self__.f,meta29463__$1));
});

cljs.core.async.t29462.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29464){
var self__ = this;
var _29464__$1 = this;
return self__.meta29463;
});

cljs.core.async.t29462.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29462.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29462.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29462.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29463","meta29463",1367979442,null)], null);
});

cljs.core.async.t29462.cljs$lang$type = true;

cljs.core.async.t29462.cljs$lang$ctorStr = "cljs.core.async/t29462";

cljs.core.async.t29462.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29462");
});

cljs.core.async.__GT_t29462 = (function cljs$core$async$fn_handler_$___GT_t29462(fn_handler__$1,f__$1,meta29463){
return (new cljs.core.async.t29462(fn_handler__$1,f__$1,meta29463));
});

}

return (new cljs.core.async.t29462(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29467 = [];
var len__8976__auto___29470 = arguments.length;
var i__8977__auto___29471 = (0);
while(true){
if((i__8977__auto___29471 < len__8976__auto___29470)){
args29467.push((arguments[i__8977__auto___29471]));

var G__29472 = (i__8977__auto___29471 + (1));
i__8977__auto___29471 = G__29472;
continue;
} else {
}
break;
}

var G__29469 = args29467.length;
switch (G__29469) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29467.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29474 = [];
var len__8976__auto___29477 = arguments.length;
var i__8977__auto___29478 = (0);
while(true){
if((i__8977__auto___29478 < len__8976__auto___29477)){
args29474.push((arguments[i__8977__auto___29478]));

var G__29479 = (i__8977__auto___29478 + (1));
i__8977__auto___29478 = G__29479;
continue;
} else {
}
break;
}

var G__29476 = args29474.length;
switch (G__29476) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29474.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_29481 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29481) : fn1.call(null,val_29481));
} else {
cljs.core.async.impl.dispatch.run(((function (val_29481,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29481) : fn1.call(null,val_29481));
});})(val_29481,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29482 = [];
var len__8976__auto___29485 = arguments.length;
var i__8977__auto___29486 = (0);
while(true){
if((i__8977__auto___29486 < len__8976__auto___29485)){
args29482.push((arguments[i__8977__auto___29486]));

var G__29487 = (i__8977__auto___29486 + (1));
i__8977__auto___29486 = G__29487;
continue;
} else {
}
break;
}

var G__29484 = args29482.length;
switch (G__29484) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29482.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8821__auto___29489 = n;
var x_29490 = (0);
while(true){
if((x_29490 < n__8821__auto___29489)){
(a[x_29490] = (0));

var G__29491 = (x_29490 + (1));
x_29490 = G__29491;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__29492 = (i + (1));
i = G__29492;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t29496 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29496 = (function (alt_flag,flag,meta29497){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29497 = meta29497;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29496.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29498,meta29497__$1){
var self__ = this;
var _29498__$1 = this;
return (new cljs.core.async.t29496(self__.alt_flag,self__.flag,meta29497__$1));
});})(flag))
;

cljs.core.async.t29496.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29498){
var self__ = this;
var _29498__$1 = this;
return self__.meta29497;
});})(flag))
;

cljs.core.async.t29496.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29496.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t29496.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t29496.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29497","meta29497",-276847681,null)], null);
});})(flag))
;

cljs.core.async.t29496.cljs$lang$type = true;

cljs.core.async.t29496.cljs$lang$ctorStr = "cljs.core.async/t29496";

cljs.core.async.t29496.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29496");
});})(flag))
;

cljs.core.async.__GT_t29496 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29496(alt_flag__$1,flag__$1,meta29497){
return (new cljs.core.async.t29496(alt_flag__$1,flag__$1,meta29497));
});})(flag))
;

}

return (new cljs.core.async.t29496(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29502 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29502 = (function (alt_handler,flag,cb,meta29503){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29503 = meta29503;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29502.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29504,meta29503__$1){
var self__ = this;
var _29504__$1 = this;
return (new cljs.core.async.t29502(self__.alt_handler,self__.flag,self__.cb,meta29503__$1));
});

cljs.core.async.t29502.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29504){
var self__ = this;
var _29504__$1 = this;
return self__.meta29503;
});

cljs.core.async.t29502.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29502.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t29502.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t29502.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29503","meta29503",214712746,null)], null);
});

cljs.core.async.t29502.cljs$lang$type = true;

cljs.core.async.t29502.cljs$lang$ctorStr = "cljs.core.async/t29502";

cljs.core.async.t29502.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29502");
});

cljs.core.async.__GT_t29502 = (function cljs$core$async$alt_handler_$___GT_t29502(alt_handler__$1,flag__$1,cb__$1,meta29503){
return (new cljs.core.async.t29502(alt_handler__$1,flag__$1,cb__$1,meta29503));
});

}

return (new cljs.core.async.t29502(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29505_SHARP_){
var G__29509 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29505_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29509) : fret.call(null,G__29509));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29506_SHARP_){
var G__29510 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29506_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29510) : fret.call(null,G__29510));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7937__auto__ = wport;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29511 = (i + (1));
i = G__29511;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7937__auto__ = ret;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__7925__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7925__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7925__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___29517 = arguments.length;
var i__8977__auto___29518 = (0);
while(true){
if((i__8977__auto___29518 < len__8976__auto___29517)){
args__8983__auto__.push((arguments[i__8977__auto___29518]));

var G__29519 = (i__8977__auto___29518 + (1));
i__8977__auto___29518 = G__29519;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29514){
var map__29515 = p__29514;
var map__29515__$1 = ((((!((map__29515 == null)))?((((map__29515.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29515.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29515):map__29515);
var opts = map__29515__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29512){
var G__29513 = cljs.core.first(seq29512);
var seq29512__$1 = cljs.core.next(seq29512);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29513,seq29512__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29520 = [];
var len__8976__auto___29570 = arguments.length;
var i__8977__auto___29571 = (0);
while(true){
if((i__8977__auto___29571 < len__8976__auto___29570)){
args29520.push((arguments[i__8977__auto___29571]));

var G__29572 = (i__8977__auto___29571 + (1));
i__8977__auto___29571 = G__29572;
continue;
} else {
}
break;
}

var G__29522 = args29520.length;
switch (G__29522) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29520.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11626__auto___29574 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___29574){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___29574){
return (function (state_29546){
var state_val_29547 = (state_29546[(1)]);
if((state_val_29547 === (7))){
var inst_29542 = (state_29546[(2)]);
var state_29546__$1 = state_29546;
var statearr_29548_29575 = state_29546__$1;
(statearr_29548_29575[(2)] = inst_29542);

(statearr_29548_29575[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (1))){
var state_29546__$1 = state_29546;
var statearr_29549_29576 = state_29546__$1;
(statearr_29549_29576[(2)] = null);

(statearr_29549_29576[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (4))){
var inst_29525 = (state_29546[(7)]);
var inst_29525__$1 = (state_29546[(2)]);
var inst_29526 = (inst_29525__$1 == null);
var state_29546__$1 = (function (){var statearr_29550 = state_29546;
(statearr_29550[(7)] = inst_29525__$1);

return statearr_29550;
})();
if(cljs.core.truth_(inst_29526)){
var statearr_29551_29577 = state_29546__$1;
(statearr_29551_29577[(1)] = (5));

} else {
var statearr_29552_29578 = state_29546__$1;
(statearr_29552_29578[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (13))){
var state_29546__$1 = state_29546;
var statearr_29553_29579 = state_29546__$1;
(statearr_29553_29579[(2)] = null);

(statearr_29553_29579[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (6))){
var inst_29525 = (state_29546[(7)]);
var state_29546__$1 = state_29546;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29546__$1,(11),to,inst_29525);
} else {
if((state_val_29547 === (3))){
var inst_29544 = (state_29546[(2)]);
var state_29546__$1 = state_29546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29546__$1,inst_29544);
} else {
if((state_val_29547 === (12))){
var state_29546__$1 = state_29546;
var statearr_29554_29580 = state_29546__$1;
(statearr_29554_29580[(2)] = null);

(statearr_29554_29580[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (2))){
var state_29546__$1 = state_29546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29546__$1,(4),from);
} else {
if((state_val_29547 === (11))){
var inst_29535 = (state_29546[(2)]);
var state_29546__$1 = state_29546;
if(cljs.core.truth_(inst_29535)){
var statearr_29555_29581 = state_29546__$1;
(statearr_29555_29581[(1)] = (12));

} else {
var statearr_29556_29582 = state_29546__$1;
(statearr_29556_29582[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (9))){
var state_29546__$1 = state_29546;
var statearr_29557_29583 = state_29546__$1;
(statearr_29557_29583[(2)] = null);

(statearr_29557_29583[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (5))){
var state_29546__$1 = state_29546;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29558_29584 = state_29546__$1;
(statearr_29558_29584[(1)] = (8));

} else {
var statearr_29559_29585 = state_29546__$1;
(statearr_29559_29585[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (14))){
var inst_29540 = (state_29546[(2)]);
var state_29546__$1 = state_29546;
var statearr_29560_29586 = state_29546__$1;
(statearr_29560_29586[(2)] = inst_29540);

(statearr_29560_29586[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (10))){
var inst_29532 = (state_29546[(2)]);
var state_29546__$1 = state_29546;
var statearr_29561_29587 = state_29546__$1;
(statearr_29561_29587[(2)] = inst_29532);

(statearr_29561_29587[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29547 === (8))){
var inst_29529 = cljs.core.async.close_BANG_(to);
var state_29546__$1 = state_29546;
var statearr_29562_29588 = state_29546__$1;
(statearr_29562_29588[(2)] = inst_29529);

(statearr_29562_29588[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___29574))
;
return ((function (switch__11561__auto__,c__11626__auto___29574){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_29566 = [null,null,null,null,null,null,null,null];
(statearr_29566[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_29566[(1)] = (1));

return statearr_29566;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_29546){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29546);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29567){if((e29567 instanceof Object)){
var ex__11565__auto__ = e29567;
var statearr_29568_29589 = state_29546;
(statearr_29568_29589[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29546);

return cljs.core.constant$keyword$recur;
} else {
throw e29567;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__29590 = state_29546;
state_29546 = G__29590;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_29546){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_29546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___29574))
})();
var state__11628__auto__ = (function (){var statearr_29569 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29569[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___29574);

return statearr_29569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___29574))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29774){
var vec__29775 = p__29774;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29775,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29775,(1),null);
var job = vec__29775;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11626__auto___29957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results){
return (function (state_29780){
var state_val_29781 = (state_29780[(1)]);
if((state_val_29781 === (1))){
var state_29780__$1 = state_29780;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29780__$1,(2),res,v);
} else {
if((state_val_29781 === (2))){
var inst_29777 = (state_29780[(2)]);
var inst_29778 = cljs.core.async.close_BANG_(res);
var state_29780__$1 = (function (){var statearr_29782 = state_29780;
(statearr_29782[(7)] = inst_29777);

return statearr_29782;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29780__$1,inst_29778);
} else {
return null;
}
}
});})(c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results))
;
return ((function (switch__11561__auto__,c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_29786 = [null,null,null,null,null,null,null,null];
(statearr_29786[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__);

(statearr_29786[(1)] = (1));

return statearr_29786;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1 = (function (state_29780){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29780);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29787){if((e29787 instanceof Object)){
var ex__11565__auto__ = e29787;
var statearr_29788_29958 = state_29780;
(statearr_29788_29958[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29780);

return cljs.core.constant$keyword$recur;
} else {
throw e29787;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__29959 = state_29780;
state_29780 = G__29959;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = function(state_29780){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1.call(this,state_29780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results))
})();
var state__11628__auto__ = (function (){var statearr_29789 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29789[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___29957);

return statearr_29789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___29957,res,vec__29775,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29790){
var vec__29791 = p__29790;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29791,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29791,(1),null);
var job = vec__29791;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8821__auto___29960 = n;
var __29961 = (0);
while(true){
if((__29961 < n__8821__auto___29960)){
var G__29792_29962 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29792_29962) {
case "compute":
var c__11626__auto___29964 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29961,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (__29961,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function (state_29805){
var state_val_29806 = (state_29805[(1)]);
if((state_val_29806 === (1))){
var state_29805__$1 = state_29805;
var statearr_29807_29965 = state_29805__$1;
(statearr_29807_29965[(2)] = null);

(statearr_29807_29965[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29806 === (2))){
var state_29805__$1 = state_29805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29805__$1,(4),jobs);
} else {
if((state_val_29806 === (3))){
var inst_29803 = (state_29805[(2)]);
var state_29805__$1 = state_29805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29805__$1,inst_29803);
} else {
if((state_val_29806 === (4))){
var inst_29795 = (state_29805[(2)]);
var inst_29796 = process(inst_29795);
var state_29805__$1 = state_29805;
if(cljs.core.truth_(inst_29796)){
var statearr_29808_29966 = state_29805__$1;
(statearr_29808_29966[(1)] = (5));

} else {
var statearr_29809_29967 = state_29805__$1;
(statearr_29809_29967[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29806 === (5))){
var state_29805__$1 = state_29805;
var statearr_29810_29968 = state_29805__$1;
(statearr_29810_29968[(2)] = null);

(statearr_29810_29968[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29806 === (6))){
var state_29805__$1 = state_29805;
var statearr_29811_29969 = state_29805__$1;
(statearr_29811_29969[(2)] = null);

(statearr_29811_29969[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29806 === (7))){
var inst_29801 = (state_29805[(2)]);
var state_29805__$1 = state_29805;
var statearr_29812_29970 = state_29805__$1;
(statearr_29812_29970[(2)] = inst_29801);

(statearr_29812_29970[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29961,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
;
return ((function (__29961,switch__11561__auto__,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_29816 = [null,null,null,null,null,null,null];
(statearr_29816[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__);

(statearr_29816[(1)] = (1));

return statearr_29816;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1 = (function (state_29805){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29805);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29817){if((e29817 instanceof Object)){
var ex__11565__auto__ = e29817;
var statearr_29818_29971 = state_29805;
(statearr_29818_29971[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29805);

return cljs.core.constant$keyword$recur;
} else {
throw e29817;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__29972 = state_29805;
state_29805 = G__29972;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = function(state_29805){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1.call(this,state_29805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__;
})()
;})(__29961,switch__11561__auto__,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
})();
var state__11628__auto__ = (function (){var statearr_29819 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29819[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___29964);

return statearr_29819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(__29961,c__11626__auto___29964,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
);


break;
case "async":
var c__11626__auto___29973 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29961,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (__29961,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function (state_29832){
var state_val_29833 = (state_29832[(1)]);
if((state_val_29833 === (1))){
var state_29832__$1 = state_29832;
var statearr_29834_29974 = state_29832__$1;
(statearr_29834_29974[(2)] = null);

(statearr_29834_29974[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29833 === (2))){
var state_29832__$1 = state_29832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29832__$1,(4),jobs);
} else {
if((state_val_29833 === (3))){
var inst_29830 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29832__$1,inst_29830);
} else {
if((state_val_29833 === (4))){
var inst_29822 = (state_29832[(2)]);
var inst_29823 = async(inst_29822);
var state_29832__$1 = state_29832;
if(cljs.core.truth_(inst_29823)){
var statearr_29835_29975 = state_29832__$1;
(statearr_29835_29975[(1)] = (5));

} else {
var statearr_29836_29976 = state_29832__$1;
(statearr_29836_29976[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29833 === (5))){
var state_29832__$1 = state_29832;
var statearr_29837_29977 = state_29832__$1;
(statearr_29837_29977[(2)] = null);

(statearr_29837_29977[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29833 === (6))){
var state_29832__$1 = state_29832;
var statearr_29838_29978 = state_29832__$1;
(statearr_29838_29978[(2)] = null);

(statearr_29838_29978[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29833 === (7))){
var inst_29828 = (state_29832[(2)]);
var state_29832__$1 = state_29832;
var statearr_29839_29979 = state_29832__$1;
(statearr_29839_29979[(2)] = inst_29828);

(statearr_29839_29979[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29961,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
;
return ((function (__29961,switch__11561__auto__,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_29843 = [null,null,null,null,null,null,null];
(statearr_29843[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__);

(statearr_29843[(1)] = (1));

return statearr_29843;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1 = (function (state_29832){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29832);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29844){if((e29844 instanceof Object)){
var ex__11565__auto__ = e29844;
var statearr_29845_29980 = state_29832;
(statearr_29845_29980[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29832);

return cljs.core.constant$keyword$recur;
} else {
throw e29844;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__29981 = state_29832;
state_29832 = G__29981;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = function(state_29832){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1.call(this,state_29832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__;
})()
;})(__29961,switch__11561__auto__,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
})();
var state__11628__auto__ = (function (){var statearr_29846 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___29973);

return statearr_29846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(__29961,c__11626__auto___29973,G__29792_29962,n__8821__auto___29960,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29982 = (__29961 + (1));
__29961 = G__29982;
continue;
} else {
}
break;
}

var c__11626__auto___29983 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___29983,jobs,results,process,async){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___29983,jobs,results,process,async){
return (function (state_29868){
var state_val_29869 = (state_29868[(1)]);
if((state_val_29869 === (1))){
var state_29868__$1 = state_29868;
var statearr_29870_29984 = state_29868__$1;
(statearr_29870_29984[(2)] = null);

(statearr_29870_29984[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29869 === (2))){
var state_29868__$1 = state_29868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29868__$1,(4),from);
} else {
if((state_val_29869 === (3))){
var inst_29866 = (state_29868[(2)]);
var state_29868__$1 = state_29868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29868__$1,inst_29866);
} else {
if((state_val_29869 === (4))){
var inst_29849 = (state_29868[(7)]);
var inst_29849__$1 = (state_29868[(2)]);
var inst_29850 = (inst_29849__$1 == null);
var state_29868__$1 = (function (){var statearr_29871 = state_29868;
(statearr_29871[(7)] = inst_29849__$1);

return statearr_29871;
})();
if(cljs.core.truth_(inst_29850)){
var statearr_29872_29985 = state_29868__$1;
(statearr_29872_29985[(1)] = (5));

} else {
var statearr_29873_29986 = state_29868__$1;
(statearr_29873_29986[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29869 === (5))){
var inst_29852 = cljs.core.async.close_BANG_(jobs);
var state_29868__$1 = state_29868;
var statearr_29874_29987 = state_29868__$1;
(statearr_29874_29987[(2)] = inst_29852);

(statearr_29874_29987[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29869 === (6))){
var inst_29854 = (state_29868[(8)]);
var inst_29849 = (state_29868[(7)]);
var inst_29854__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29856 = [inst_29849,inst_29854__$1];
var inst_29857 = (new cljs.core.PersistentVector(null,2,(5),inst_29855,inst_29856,null));
var state_29868__$1 = (function (){var statearr_29875 = state_29868;
(statearr_29875[(8)] = inst_29854__$1);

return statearr_29875;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29868__$1,(8),jobs,inst_29857);
} else {
if((state_val_29869 === (7))){
var inst_29864 = (state_29868[(2)]);
var state_29868__$1 = state_29868;
var statearr_29876_29988 = state_29868__$1;
(statearr_29876_29988[(2)] = inst_29864);

(statearr_29876_29988[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29869 === (8))){
var inst_29854 = (state_29868[(8)]);
var inst_29859 = (state_29868[(2)]);
var state_29868__$1 = (function (){var statearr_29877 = state_29868;
(statearr_29877[(9)] = inst_29859);

return statearr_29877;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29868__$1,(9),results,inst_29854);
} else {
if((state_val_29869 === (9))){
var inst_29861 = (state_29868[(2)]);
var state_29868__$1 = (function (){var statearr_29878 = state_29868;
(statearr_29878[(10)] = inst_29861);

return statearr_29878;
})();
var statearr_29879_29989 = state_29868__$1;
(statearr_29879_29989[(2)] = null);

(statearr_29879_29989[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___29983,jobs,results,process,async))
;
return ((function (switch__11561__auto__,c__11626__auto___29983,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_29883 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29883[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__);

(statearr_29883[(1)] = (1));

return statearr_29883;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1 = (function (state_29868){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29868);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29884){if((e29884 instanceof Object)){
var ex__11565__auto__ = e29884;
var statearr_29885_29990 = state_29868;
(statearr_29885_29990[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29868);

return cljs.core.constant$keyword$recur;
} else {
throw e29884;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__29991 = state_29868;
state_29868 = G__29991;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = function(state_29868){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1.call(this,state_29868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___29983,jobs,results,process,async))
})();
var state__11628__auto__ = (function (){var statearr_29886 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___29983);

return statearr_29886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___29983,jobs,results,process,async))
);


var c__11626__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto__,jobs,results,process,async){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto__,jobs,results,process,async){
return (function (state_29924){
var state_val_29925 = (state_29924[(1)]);
if((state_val_29925 === (7))){
var inst_29920 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
var statearr_29926_29992 = state_29924__$1;
(statearr_29926_29992[(2)] = inst_29920);

(statearr_29926_29992[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (20))){
var state_29924__$1 = state_29924;
var statearr_29927_29993 = state_29924__$1;
(statearr_29927_29993[(2)] = null);

(statearr_29927_29993[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (1))){
var state_29924__$1 = state_29924;
var statearr_29928_29994 = state_29924__$1;
(statearr_29928_29994[(2)] = null);

(statearr_29928_29994[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (4))){
var inst_29889 = (state_29924[(7)]);
var inst_29889__$1 = (state_29924[(2)]);
var inst_29890 = (inst_29889__$1 == null);
var state_29924__$1 = (function (){var statearr_29929 = state_29924;
(statearr_29929[(7)] = inst_29889__$1);

return statearr_29929;
})();
if(cljs.core.truth_(inst_29890)){
var statearr_29930_29995 = state_29924__$1;
(statearr_29930_29995[(1)] = (5));

} else {
var statearr_29931_29996 = state_29924__$1;
(statearr_29931_29996[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (15))){
var inst_29902 = (state_29924[(8)]);
var state_29924__$1 = state_29924;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29924__$1,(18),to,inst_29902);
} else {
if((state_val_29925 === (21))){
var inst_29915 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
var statearr_29932_29997 = state_29924__$1;
(statearr_29932_29997[(2)] = inst_29915);

(statearr_29932_29997[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (13))){
var inst_29917 = (state_29924[(2)]);
var state_29924__$1 = (function (){var statearr_29933 = state_29924;
(statearr_29933[(9)] = inst_29917);

return statearr_29933;
})();
var statearr_29934_29998 = state_29924__$1;
(statearr_29934_29998[(2)] = null);

(statearr_29934_29998[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (6))){
var inst_29889 = (state_29924[(7)]);
var state_29924__$1 = state_29924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29924__$1,(11),inst_29889);
} else {
if((state_val_29925 === (17))){
var inst_29910 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
if(cljs.core.truth_(inst_29910)){
var statearr_29935_29999 = state_29924__$1;
(statearr_29935_29999[(1)] = (19));

} else {
var statearr_29936_30000 = state_29924__$1;
(statearr_29936_30000[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (3))){
var inst_29922 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29924__$1,inst_29922);
} else {
if((state_val_29925 === (12))){
var inst_29899 = (state_29924[(10)]);
var state_29924__$1 = state_29924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29924__$1,(14),inst_29899);
} else {
if((state_val_29925 === (2))){
var state_29924__$1 = state_29924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29924__$1,(4),results);
} else {
if((state_val_29925 === (19))){
var state_29924__$1 = state_29924;
var statearr_29937_30001 = state_29924__$1;
(statearr_29937_30001[(2)] = null);

(statearr_29937_30001[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (11))){
var inst_29899 = (state_29924[(2)]);
var state_29924__$1 = (function (){var statearr_29938 = state_29924;
(statearr_29938[(10)] = inst_29899);

return statearr_29938;
})();
var statearr_29939_30002 = state_29924__$1;
(statearr_29939_30002[(2)] = null);

(statearr_29939_30002[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (9))){
var state_29924__$1 = state_29924;
var statearr_29940_30003 = state_29924__$1;
(statearr_29940_30003[(2)] = null);

(statearr_29940_30003[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (5))){
var state_29924__$1 = state_29924;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29941_30004 = state_29924__$1;
(statearr_29941_30004[(1)] = (8));

} else {
var statearr_29942_30005 = state_29924__$1;
(statearr_29942_30005[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (14))){
var inst_29904 = (state_29924[(11)]);
var inst_29902 = (state_29924[(8)]);
var inst_29902__$1 = (state_29924[(2)]);
var inst_29903 = (inst_29902__$1 == null);
var inst_29904__$1 = cljs.core.not(inst_29903);
var state_29924__$1 = (function (){var statearr_29943 = state_29924;
(statearr_29943[(11)] = inst_29904__$1);

(statearr_29943[(8)] = inst_29902__$1);

return statearr_29943;
})();
if(inst_29904__$1){
var statearr_29944_30006 = state_29924__$1;
(statearr_29944_30006[(1)] = (15));

} else {
var statearr_29945_30007 = state_29924__$1;
(statearr_29945_30007[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (16))){
var inst_29904 = (state_29924[(11)]);
var state_29924__$1 = state_29924;
var statearr_29946_30008 = state_29924__$1;
(statearr_29946_30008[(2)] = inst_29904);

(statearr_29946_30008[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (10))){
var inst_29896 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
var statearr_29947_30009 = state_29924__$1;
(statearr_29947_30009[(2)] = inst_29896);

(statearr_29947_30009[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (18))){
var inst_29907 = (state_29924[(2)]);
var state_29924__$1 = state_29924;
var statearr_29948_30010 = state_29924__$1;
(statearr_29948_30010[(2)] = inst_29907);

(statearr_29948_30010[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29925 === (8))){
var inst_29893 = cljs.core.async.close_BANG_(to);
var state_29924__$1 = state_29924;
var statearr_29949_30011 = state_29924__$1;
(statearr_29949_30011[(2)] = inst_29893);

(statearr_29949_30011[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto__,jobs,results,process,async))
;
return ((function (switch__11561__auto__,c__11626__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_29953 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29953[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__);

(statearr_29953[(1)] = (1));

return statearr_29953;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1 = (function (state_29924){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_29924);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e29954){if((e29954 instanceof Object)){
var ex__11565__auto__ = e29954;
var statearr_29955_30012 = state_29924;
(statearr_29955_30012[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29924);

return cljs.core.constant$keyword$recur;
} else {
throw e29954;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__30013 = state_29924;
state_29924 = G__30013;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__ = function(state_29924){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1.call(this,state_29924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto__,jobs,results,process,async))
})();
var state__11628__auto__ = (function (){var statearr_29956 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_29956[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto__);

return statearr_29956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto__,jobs,results,process,async))
);

return c__11626__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args30014 = [];
var len__8976__auto___30017 = arguments.length;
var i__8977__auto___30018 = (0);
while(true){
if((i__8977__auto___30018 < len__8976__auto___30017)){
args30014.push((arguments[i__8977__auto___30018]));

var G__30019 = (i__8977__auto___30018 + (1));
i__8977__auto___30018 = G__30019;
continue;
} else {
}
break;
}

var G__30016 = args30014.length;
switch (G__30016) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30014.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args30021 = [];
var len__8976__auto___30024 = arguments.length;
var i__8977__auto___30025 = (0);
while(true){
if((i__8977__auto___30025 < len__8976__auto___30024)){
args30021.push((arguments[i__8977__auto___30025]));

var G__30026 = (i__8977__auto___30025 + (1));
i__8977__auto___30025 = G__30026;
continue;
} else {
}
break;
}

var G__30023 = args30021.length;
switch (G__30023) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30021.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args30028 = [];
var len__8976__auto___30081 = arguments.length;
var i__8977__auto___30082 = (0);
while(true){
if((i__8977__auto___30082 < len__8976__auto___30081)){
args30028.push((arguments[i__8977__auto___30082]));

var G__30083 = (i__8977__auto___30082 + (1));
i__8977__auto___30082 = G__30083;
continue;
} else {
}
break;
}

var G__30030 = args30028.length;
switch (G__30030) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30028.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11626__auto___30085 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___30085,tc,fc){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___30085,tc,fc){
return (function (state_30056){
var state_val_30057 = (state_30056[(1)]);
if((state_val_30057 === (7))){
var inst_30052 = (state_30056[(2)]);
var state_30056__$1 = state_30056;
var statearr_30058_30086 = state_30056__$1;
(statearr_30058_30086[(2)] = inst_30052);

(statearr_30058_30086[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (1))){
var state_30056__$1 = state_30056;
var statearr_30059_30087 = state_30056__$1;
(statearr_30059_30087[(2)] = null);

(statearr_30059_30087[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (4))){
var inst_30033 = (state_30056[(7)]);
var inst_30033__$1 = (state_30056[(2)]);
var inst_30034 = (inst_30033__$1 == null);
var state_30056__$1 = (function (){var statearr_30060 = state_30056;
(statearr_30060[(7)] = inst_30033__$1);

return statearr_30060;
})();
if(cljs.core.truth_(inst_30034)){
var statearr_30061_30088 = state_30056__$1;
(statearr_30061_30088[(1)] = (5));

} else {
var statearr_30062_30089 = state_30056__$1;
(statearr_30062_30089[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (13))){
var state_30056__$1 = state_30056;
var statearr_30063_30090 = state_30056__$1;
(statearr_30063_30090[(2)] = null);

(statearr_30063_30090[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (6))){
var inst_30033 = (state_30056[(7)]);
var inst_30039 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30033) : p.call(null,inst_30033));
var state_30056__$1 = state_30056;
if(cljs.core.truth_(inst_30039)){
var statearr_30064_30091 = state_30056__$1;
(statearr_30064_30091[(1)] = (9));

} else {
var statearr_30065_30092 = state_30056__$1;
(statearr_30065_30092[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (3))){
var inst_30054 = (state_30056[(2)]);
var state_30056__$1 = state_30056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30056__$1,inst_30054);
} else {
if((state_val_30057 === (12))){
var state_30056__$1 = state_30056;
var statearr_30066_30093 = state_30056__$1;
(statearr_30066_30093[(2)] = null);

(statearr_30066_30093[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (2))){
var state_30056__$1 = state_30056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30056__$1,(4),ch);
} else {
if((state_val_30057 === (11))){
var inst_30033 = (state_30056[(7)]);
var inst_30043 = (state_30056[(2)]);
var state_30056__$1 = state_30056;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30056__$1,(8),inst_30043,inst_30033);
} else {
if((state_val_30057 === (9))){
var state_30056__$1 = state_30056;
var statearr_30067_30094 = state_30056__$1;
(statearr_30067_30094[(2)] = tc);

(statearr_30067_30094[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (5))){
var inst_30036 = cljs.core.async.close_BANG_(tc);
var inst_30037 = cljs.core.async.close_BANG_(fc);
var state_30056__$1 = (function (){var statearr_30068 = state_30056;
(statearr_30068[(8)] = inst_30036);

return statearr_30068;
})();
var statearr_30069_30095 = state_30056__$1;
(statearr_30069_30095[(2)] = inst_30037);

(statearr_30069_30095[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (14))){
var inst_30050 = (state_30056[(2)]);
var state_30056__$1 = state_30056;
var statearr_30070_30096 = state_30056__$1;
(statearr_30070_30096[(2)] = inst_30050);

(statearr_30070_30096[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (10))){
var state_30056__$1 = state_30056;
var statearr_30071_30097 = state_30056__$1;
(statearr_30071_30097[(2)] = fc);

(statearr_30071_30097[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30057 === (8))){
var inst_30045 = (state_30056[(2)]);
var state_30056__$1 = state_30056;
if(cljs.core.truth_(inst_30045)){
var statearr_30072_30098 = state_30056__$1;
(statearr_30072_30098[(1)] = (12));

} else {
var statearr_30073_30099 = state_30056__$1;
(statearr_30073_30099[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___30085,tc,fc))
;
return ((function (switch__11561__auto__,c__11626__auto___30085,tc,fc){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_30077 = [null,null,null,null,null,null,null,null,null];
(statearr_30077[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_30077[(1)] = (1));

return statearr_30077;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_30056){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_30056);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e30078){if((e30078 instanceof Object)){
var ex__11565__auto__ = e30078;
var statearr_30079_30100 = state_30056;
(statearr_30079_30100[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30056);

return cljs.core.constant$keyword$recur;
} else {
throw e30078;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__30101 = state_30056;
state_30056 = G__30101;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_30056){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_30056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___30085,tc,fc))
})();
var state__11628__auto__ = (function (){var statearr_30080 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_30080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___30085);

return statearr_30080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___30085,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11626__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto__){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto__){
return (function (state_30148){
var state_val_30149 = (state_30148[(1)]);
if((state_val_30149 === (1))){
var inst_30134 = init;
var state_30148__$1 = (function (){var statearr_30150 = state_30148;
(statearr_30150[(7)] = inst_30134);

return statearr_30150;
})();
var statearr_30151_30166 = state_30148__$1;
(statearr_30151_30166[(2)] = null);

(statearr_30151_30166[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30149 === (2))){
var state_30148__$1 = state_30148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30148__$1,(4),ch);
} else {
if((state_val_30149 === (3))){
var inst_30146 = (state_30148[(2)]);
var state_30148__$1 = state_30148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30148__$1,inst_30146);
} else {
if((state_val_30149 === (4))){
var inst_30137 = (state_30148[(8)]);
var inst_30137__$1 = (state_30148[(2)]);
var inst_30138 = (inst_30137__$1 == null);
var state_30148__$1 = (function (){var statearr_30152 = state_30148;
(statearr_30152[(8)] = inst_30137__$1);

return statearr_30152;
})();
if(cljs.core.truth_(inst_30138)){
var statearr_30153_30167 = state_30148__$1;
(statearr_30153_30167[(1)] = (5));

} else {
var statearr_30154_30168 = state_30148__$1;
(statearr_30154_30168[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30149 === (5))){
var inst_30134 = (state_30148[(7)]);
var state_30148__$1 = state_30148;
var statearr_30155_30169 = state_30148__$1;
(statearr_30155_30169[(2)] = inst_30134);

(statearr_30155_30169[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30149 === (6))){
var inst_30134 = (state_30148[(7)]);
var inst_30137 = (state_30148[(8)]);
var inst_30141 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30134,inst_30137) : f.call(null,inst_30134,inst_30137));
var inst_30134__$1 = inst_30141;
var state_30148__$1 = (function (){var statearr_30156 = state_30148;
(statearr_30156[(7)] = inst_30134__$1);

return statearr_30156;
})();
var statearr_30157_30170 = state_30148__$1;
(statearr_30157_30170[(2)] = null);

(statearr_30157_30170[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30149 === (7))){
var inst_30144 = (state_30148[(2)]);
var state_30148__$1 = state_30148;
var statearr_30158_30171 = state_30148__$1;
(statearr_30158_30171[(2)] = inst_30144);

(statearr_30158_30171[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11626__auto__))
;
return ((function (switch__11561__auto__,c__11626__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11562__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11562__auto____0 = (function (){
var statearr_30162 = [null,null,null,null,null,null,null,null,null];
(statearr_30162[(0)] = cljs$core$async$reduce_$_state_machine__11562__auto__);

(statearr_30162[(1)] = (1));

return statearr_30162;
});
var cljs$core$async$reduce_$_state_machine__11562__auto____1 = (function (state_30148){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_30148);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e30163){if((e30163 instanceof Object)){
var ex__11565__auto__ = e30163;
var statearr_30164_30172 = state_30148;
(statearr_30164_30172[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30148);

return cljs.core.constant$keyword$recur;
} else {
throw e30163;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__30173 = state_30148;
state_30148 = G__30173;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11562__auto__ = function(state_30148){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11562__auto____1.call(this,state_30148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11562__auto____0;
cljs$core$async$reduce_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11562__auto____1;
return cljs$core$async$reduce_$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto__))
})();
var state__11628__auto__ = (function (){var statearr_30165 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_30165[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto__);

return statearr_30165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto__))
);

return c__11626__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args30174 = [];
var len__8976__auto___30226 = arguments.length;
var i__8977__auto___30227 = (0);
while(true){
if((i__8977__auto___30227 < len__8976__auto___30226)){
args30174.push((arguments[i__8977__auto___30227]));

var G__30228 = (i__8977__auto___30227 + (1));
i__8977__auto___30227 = G__30228;
continue;
} else {
}
break;
}

var G__30176 = args30174.length;
switch (G__30176) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30174.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11626__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto__){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto__){
return (function (state_30201){
var state_val_30202 = (state_30201[(1)]);
if((state_val_30202 === (7))){
var inst_30183 = (state_30201[(2)]);
var state_30201__$1 = state_30201;
var statearr_30203_30230 = state_30201__$1;
(statearr_30203_30230[(2)] = inst_30183);

(statearr_30203_30230[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (1))){
var inst_30177 = cljs.core.seq(coll);
var inst_30178 = inst_30177;
var state_30201__$1 = (function (){var statearr_30204 = state_30201;
(statearr_30204[(7)] = inst_30178);

return statearr_30204;
})();
var statearr_30205_30231 = state_30201__$1;
(statearr_30205_30231[(2)] = null);

(statearr_30205_30231[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (4))){
var inst_30178 = (state_30201[(7)]);
var inst_30181 = cljs.core.first(inst_30178);
var state_30201__$1 = state_30201;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30201__$1,(7),ch,inst_30181);
} else {
if((state_val_30202 === (13))){
var inst_30195 = (state_30201[(2)]);
var state_30201__$1 = state_30201;
var statearr_30206_30232 = state_30201__$1;
(statearr_30206_30232[(2)] = inst_30195);

(statearr_30206_30232[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (6))){
var inst_30186 = (state_30201[(2)]);
var state_30201__$1 = state_30201;
if(cljs.core.truth_(inst_30186)){
var statearr_30207_30233 = state_30201__$1;
(statearr_30207_30233[(1)] = (8));

} else {
var statearr_30208_30234 = state_30201__$1;
(statearr_30208_30234[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (3))){
var inst_30199 = (state_30201[(2)]);
var state_30201__$1 = state_30201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30201__$1,inst_30199);
} else {
if((state_val_30202 === (12))){
var state_30201__$1 = state_30201;
var statearr_30209_30235 = state_30201__$1;
(statearr_30209_30235[(2)] = null);

(statearr_30209_30235[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (2))){
var inst_30178 = (state_30201[(7)]);
var state_30201__$1 = state_30201;
if(cljs.core.truth_(inst_30178)){
var statearr_30210_30236 = state_30201__$1;
(statearr_30210_30236[(1)] = (4));

} else {
var statearr_30211_30237 = state_30201__$1;
(statearr_30211_30237[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (11))){
var inst_30192 = cljs.core.async.close_BANG_(ch);
var state_30201__$1 = state_30201;
var statearr_30212_30238 = state_30201__$1;
(statearr_30212_30238[(2)] = inst_30192);

(statearr_30212_30238[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (9))){
var state_30201__$1 = state_30201;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30213_30239 = state_30201__$1;
(statearr_30213_30239[(1)] = (11));

} else {
var statearr_30214_30240 = state_30201__$1;
(statearr_30214_30240[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (5))){
var inst_30178 = (state_30201[(7)]);
var state_30201__$1 = state_30201;
var statearr_30215_30241 = state_30201__$1;
(statearr_30215_30241[(2)] = inst_30178);

(statearr_30215_30241[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (10))){
var inst_30197 = (state_30201[(2)]);
var state_30201__$1 = state_30201;
var statearr_30216_30242 = state_30201__$1;
(statearr_30216_30242[(2)] = inst_30197);

(statearr_30216_30242[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30202 === (8))){
var inst_30178 = (state_30201[(7)]);
var inst_30188 = cljs.core.next(inst_30178);
var inst_30178__$1 = inst_30188;
var state_30201__$1 = (function (){var statearr_30217 = state_30201;
(statearr_30217[(7)] = inst_30178__$1);

return statearr_30217;
})();
var statearr_30218_30243 = state_30201__$1;
(statearr_30218_30243[(2)] = null);

(statearr_30218_30243[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto__))
;
return ((function (switch__11561__auto__,c__11626__auto__){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_30222 = [null,null,null,null,null,null,null,null];
(statearr_30222[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_30222[(1)] = (1));

return statearr_30222;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_30201){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_30201);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e30223){if((e30223 instanceof Object)){
var ex__11565__auto__ = e30223;
var statearr_30224_30244 = state_30201;
(statearr_30224_30244[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30201);

return cljs.core.constant$keyword$recur;
} else {
throw e30223;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__30245 = state_30201;
state_30201 = G__30245;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_30201){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_30201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto__))
})();
var state__11628__auto__ = (function (){var statearr_30225 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_30225[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto__);

return statearr_30225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto__))
);

return c__11626__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8573__auto__ = (((_ == null))?null:_);
var m__8574__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto__.call(null,_));
} else {
var m__8574__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__30474 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30474) : cljs.core.atom.call(null,G__30474));
})();
var m = (function (){
if(typeof cljs.core.async.t30475 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30475 = (function (mult,ch,cs,meta30476){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30476 = meta30476;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30475.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30477,meta30476__$1){
var self__ = this;
var _30477__$1 = this;
return (new cljs.core.async.t30475(self__.mult,self__.ch,self__.cs,meta30476__$1));
});})(cs))
;

cljs.core.async.t30475.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30477){
var self__ = this;
var _30477__$1 = this;
return self__.meta30476;
});})(cs))
;

cljs.core.async.t30475.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30475.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30475.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30475.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30475.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30475.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30478_30698 = self__.cs;
var G__30479_30699 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30478_30698,G__30479_30699) : cljs.core.reset_BANG_.call(null,G__30478_30698,G__30479_30699));

return null;
});})(cs))
;

cljs.core.async.t30475.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30476","meta30476",-1035770962,null)], null);
});})(cs))
;

cljs.core.async.t30475.cljs$lang$type = true;

cljs.core.async.t30475.cljs$lang$ctorStr = "cljs.core.async/t30475";

cljs.core.async.t30475.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30475");
});})(cs))
;

cljs.core.async.__GT_t30475 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30475(mult__$1,ch__$1,cs__$1,meta30476){
return (new cljs.core.async.t30475(mult__$1,ch__$1,cs__$1,meta30476));
});})(cs))
;

}

return (new cljs.core.async.t30475(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11626__auto___30700 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___30700,cs,m,dchan,dctr,done){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___30700,cs,m,dchan,dctr,done){
return (function (state_30610){
var state_val_30611 = (state_30610[(1)]);
if((state_val_30611 === (7))){
var inst_30606 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30612_30701 = state_30610__$1;
(statearr_30612_30701[(2)] = inst_30606);

(statearr_30612_30701[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (20))){
var inst_30511 = (state_30610[(7)]);
var inst_30521 = cljs.core.first(inst_30511);
var inst_30522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30521,(0),null);
var inst_30523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30521,(1),null);
var state_30610__$1 = (function (){var statearr_30613 = state_30610;
(statearr_30613[(8)] = inst_30522);

return statearr_30613;
})();
if(cljs.core.truth_(inst_30523)){
var statearr_30614_30702 = state_30610__$1;
(statearr_30614_30702[(1)] = (22));

} else {
var statearr_30615_30703 = state_30610__$1;
(statearr_30615_30703[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (27))){
var inst_30551 = (state_30610[(9)]);
var inst_30553 = (state_30610[(10)]);
var inst_30558 = (state_30610[(11)]);
var inst_30482 = (state_30610[(12)]);
var inst_30558__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30551,inst_30553);
var inst_30559 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30558__$1,inst_30482,done);
var state_30610__$1 = (function (){var statearr_30616 = state_30610;
(statearr_30616[(11)] = inst_30558__$1);

return statearr_30616;
})();
if(cljs.core.truth_(inst_30559)){
var statearr_30617_30704 = state_30610__$1;
(statearr_30617_30704[(1)] = (30));

} else {
var statearr_30618_30705 = state_30610__$1;
(statearr_30618_30705[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (1))){
var state_30610__$1 = state_30610;
var statearr_30619_30706 = state_30610__$1;
(statearr_30619_30706[(2)] = null);

(statearr_30619_30706[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (24))){
var inst_30511 = (state_30610[(7)]);
var inst_30528 = (state_30610[(2)]);
var inst_30529 = cljs.core.next(inst_30511);
var inst_30491 = inst_30529;
var inst_30492 = null;
var inst_30493 = (0);
var inst_30494 = (0);
var state_30610__$1 = (function (){var statearr_30620 = state_30610;
(statearr_30620[(13)] = inst_30528);

(statearr_30620[(14)] = inst_30491);

(statearr_30620[(15)] = inst_30492);

(statearr_30620[(16)] = inst_30494);

(statearr_30620[(17)] = inst_30493);

return statearr_30620;
})();
var statearr_30621_30707 = state_30610__$1;
(statearr_30621_30707[(2)] = null);

(statearr_30621_30707[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (39))){
var state_30610__$1 = state_30610;
var statearr_30625_30708 = state_30610__$1;
(statearr_30625_30708[(2)] = null);

(statearr_30625_30708[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (4))){
var inst_30482 = (state_30610[(12)]);
var inst_30482__$1 = (state_30610[(2)]);
var inst_30483 = (inst_30482__$1 == null);
var state_30610__$1 = (function (){var statearr_30626 = state_30610;
(statearr_30626[(12)] = inst_30482__$1);

return statearr_30626;
})();
if(cljs.core.truth_(inst_30483)){
var statearr_30627_30709 = state_30610__$1;
(statearr_30627_30709[(1)] = (5));

} else {
var statearr_30628_30710 = state_30610__$1;
(statearr_30628_30710[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (15))){
var inst_30491 = (state_30610[(14)]);
var inst_30492 = (state_30610[(15)]);
var inst_30494 = (state_30610[(16)]);
var inst_30493 = (state_30610[(17)]);
var inst_30507 = (state_30610[(2)]);
var inst_30508 = (inst_30494 + (1));
var tmp30622 = inst_30491;
var tmp30623 = inst_30492;
var tmp30624 = inst_30493;
var inst_30491__$1 = tmp30622;
var inst_30492__$1 = tmp30623;
var inst_30493__$1 = tmp30624;
var inst_30494__$1 = inst_30508;
var state_30610__$1 = (function (){var statearr_30629 = state_30610;
(statearr_30629[(14)] = inst_30491__$1);

(statearr_30629[(15)] = inst_30492__$1);

(statearr_30629[(16)] = inst_30494__$1);

(statearr_30629[(18)] = inst_30507);

(statearr_30629[(17)] = inst_30493__$1);

return statearr_30629;
})();
var statearr_30630_30711 = state_30610__$1;
(statearr_30630_30711[(2)] = null);

(statearr_30630_30711[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (21))){
var inst_30532 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30634_30712 = state_30610__$1;
(statearr_30634_30712[(2)] = inst_30532);

(statearr_30634_30712[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (31))){
var inst_30558 = (state_30610[(11)]);
var inst_30562 = done(null);
var inst_30563 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30558);
var state_30610__$1 = (function (){var statearr_30635 = state_30610;
(statearr_30635[(19)] = inst_30562);

return statearr_30635;
})();
var statearr_30636_30713 = state_30610__$1;
(statearr_30636_30713[(2)] = inst_30563);

(statearr_30636_30713[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (32))){
var inst_30551 = (state_30610[(9)]);
var inst_30550 = (state_30610[(20)]);
var inst_30553 = (state_30610[(10)]);
var inst_30552 = (state_30610[(21)]);
var inst_30565 = (state_30610[(2)]);
var inst_30566 = (inst_30553 + (1));
var tmp30631 = inst_30551;
var tmp30632 = inst_30550;
var tmp30633 = inst_30552;
var inst_30550__$1 = tmp30632;
var inst_30551__$1 = tmp30631;
var inst_30552__$1 = tmp30633;
var inst_30553__$1 = inst_30566;
var state_30610__$1 = (function (){var statearr_30637 = state_30610;
(statearr_30637[(9)] = inst_30551__$1);

(statearr_30637[(22)] = inst_30565);

(statearr_30637[(20)] = inst_30550__$1);

(statearr_30637[(10)] = inst_30553__$1);

(statearr_30637[(21)] = inst_30552__$1);

return statearr_30637;
})();
var statearr_30638_30714 = state_30610__$1;
(statearr_30638_30714[(2)] = null);

(statearr_30638_30714[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (40))){
var inst_30578 = (state_30610[(23)]);
var inst_30582 = done(null);
var inst_30583 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30578);
var state_30610__$1 = (function (){var statearr_30639 = state_30610;
(statearr_30639[(24)] = inst_30582);

return statearr_30639;
})();
var statearr_30640_30715 = state_30610__$1;
(statearr_30640_30715[(2)] = inst_30583);

(statearr_30640_30715[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (33))){
var inst_30569 = (state_30610[(25)]);
var inst_30571 = cljs.core.chunked_seq_QMARK_(inst_30569);
var state_30610__$1 = state_30610;
if(inst_30571){
var statearr_30641_30716 = state_30610__$1;
(statearr_30641_30716[(1)] = (36));

} else {
var statearr_30642_30717 = state_30610__$1;
(statearr_30642_30717[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (13))){
var inst_30501 = (state_30610[(26)]);
var inst_30504 = cljs.core.async.close_BANG_(inst_30501);
var state_30610__$1 = state_30610;
var statearr_30643_30718 = state_30610__$1;
(statearr_30643_30718[(2)] = inst_30504);

(statearr_30643_30718[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (22))){
var inst_30522 = (state_30610[(8)]);
var inst_30525 = cljs.core.async.close_BANG_(inst_30522);
var state_30610__$1 = state_30610;
var statearr_30644_30719 = state_30610__$1;
(statearr_30644_30719[(2)] = inst_30525);

(statearr_30644_30719[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (36))){
var inst_30569 = (state_30610[(25)]);
var inst_30573 = cljs.core.chunk_first(inst_30569);
var inst_30574 = cljs.core.chunk_rest(inst_30569);
var inst_30575 = cljs.core.count(inst_30573);
var inst_30550 = inst_30574;
var inst_30551 = inst_30573;
var inst_30552 = inst_30575;
var inst_30553 = (0);
var state_30610__$1 = (function (){var statearr_30645 = state_30610;
(statearr_30645[(9)] = inst_30551);

(statearr_30645[(20)] = inst_30550);

(statearr_30645[(10)] = inst_30553);

(statearr_30645[(21)] = inst_30552);

return statearr_30645;
})();
var statearr_30646_30720 = state_30610__$1;
(statearr_30646_30720[(2)] = null);

(statearr_30646_30720[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (41))){
var inst_30569 = (state_30610[(25)]);
var inst_30585 = (state_30610[(2)]);
var inst_30586 = cljs.core.next(inst_30569);
var inst_30550 = inst_30586;
var inst_30551 = null;
var inst_30552 = (0);
var inst_30553 = (0);
var state_30610__$1 = (function (){var statearr_30647 = state_30610;
(statearr_30647[(9)] = inst_30551);

(statearr_30647[(20)] = inst_30550);

(statearr_30647[(10)] = inst_30553);

(statearr_30647[(27)] = inst_30585);

(statearr_30647[(21)] = inst_30552);

return statearr_30647;
})();
var statearr_30648_30721 = state_30610__$1;
(statearr_30648_30721[(2)] = null);

(statearr_30648_30721[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (43))){
var state_30610__$1 = state_30610;
var statearr_30649_30722 = state_30610__$1;
(statearr_30649_30722[(2)] = null);

(statearr_30649_30722[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (29))){
var inst_30594 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30650_30723 = state_30610__$1;
(statearr_30650_30723[(2)] = inst_30594);

(statearr_30650_30723[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (44))){
var inst_30603 = (state_30610[(2)]);
var state_30610__$1 = (function (){var statearr_30651 = state_30610;
(statearr_30651[(28)] = inst_30603);

return statearr_30651;
})();
var statearr_30652_30724 = state_30610__$1;
(statearr_30652_30724[(2)] = null);

(statearr_30652_30724[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (6))){
var inst_30542 = (state_30610[(29)]);
var inst_30541 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30542__$1 = cljs.core.keys(inst_30541);
var inst_30543 = cljs.core.count(inst_30542__$1);
var inst_30544 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30543) : cljs.core.reset_BANG_.call(null,dctr,inst_30543));
var inst_30549 = cljs.core.seq(inst_30542__$1);
var inst_30550 = inst_30549;
var inst_30551 = null;
var inst_30552 = (0);
var inst_30553 = (0);
var state_30610__$1 = (function (){var statearr_30653 = state_30610;
(statearr_30653[(9)] = inst_30551);

(statearr_30653[(30)] = inst_30544);

(statearr_30653[(29)] = inst_30542__$1);

(statearr_30653[(20)] = inst_30550);

(statearr_30653[(10)] = inst_30553);

(statearr_30653[(21)] = inst_30552);

return statearr_30653;
})();
var statearr_30654_30725 = state_30610__$1;
(statearr_30654_30725[(2)] = null);

(statearr_30654_30725[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (28))){
var inst_30550 = (state_30610[(20)]);
var inst_30569 = (state_30610[(25)]);
var inst_30569__$1 = cljs.core.seq(inst_30550);
var state_30610__$1 = (function (){var statearr_30655 = state_30610;
(statearr_30655[(25)] = inst_30569__$1);

return statearr_30655;
})();
if(inst_30569__$1){
var statearr_30656_30726 = state_30610__$1;
(statearr_30656_30726[(1)] = (33));

} else {
var statearr_30657_30727 = state_30610__$1;
(statearr_30657_30727[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (25))){
var inst_30553 = (state_30610[(10)]);
var inst_30552 = (state_30610[(21)]);
var inst_30555 = (inst_30553 < inst_30552);
var inst_30556 = inst_30555;
var state_30610__$1 = state_30610;
if(cljs.core.truth_(inst_30556)){
var statearr_30658_30728 = state_30610__$1;
(statearr_30658_30728[(1)] = (27));

} else {
var statearr_30659_30729 = state_30610__$1;
(statearr_30659_30729[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (34))){
var state_30610__$1 = state_30610;
var statearr_30660_30730 = state_30610__$1;
(statearr_30660_30730[(2)] = null);

(statearr_30660_30730[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (17))){
var state_30610__$1 = state_30610;
var statearr_30661_30731 = state_30610__$1;
(statearr_30661_30731[(2)] = null);

(statearr_30661_30731[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (3))){
var inst_30608 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30610__$1,inst_30608);
} else {
if((state_val_30611 === (12))){
var inst_30537 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30662_30732 = state_30610__$1;
(statearr_30662_30732[(2)] = inst_30537);

(statearr_30662_30732[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (2))){
var state_30610__$1 = state_30610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30610__$1,(4),ch);
} else {
if((state_val_30611 === (23))){
var state_30610__$1 = state_30610;
var statearr_30663_30733 = state_30610__$1;
(statearr_30663_30733[(2)] = null);

(statearr_30663_30733[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (35))){
var inst_30592 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30664_30734 = state_30610__$1;
(statearr_30664_30734[(2)] = inst_30592);

(statearr_30664_30734[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (19))){
var inst_30511 = (state_30610[(7)]);
var inst_30515 = cljs.core.chunk_first(inst_30511);
var inst_30516 = cljs.core.chunk_rest(inst_30511);
var inst_30517 = cljs.core.count(inst_30515);
var inst_30491 = inst_30516;
var inst_30492 = inst_30515;
var inst_30493 = inst_30517;
var inst_30494 = (0);
var state_30610__$1 = (function (){var statearr_30665 = state_30610;
(statearr_30665[(14)] = inst_30491);

(statearr_30665[(15)] = inst_30492);

(statearr_30665[(16)] = inst_30494);

(statearr_30665[(17)] = inst_30493);

return statearr_30665;
})();
var statearr_30666_30735 = state_30610__$1;
(statearr_30666_30735[(2)] = null);

(statearr_30666_30735[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (11))){
var inst_30491 = (state_30610[(14)]);
var inst_30511 = (state_30610[(7)]);
var inst_30511__$1 = cljs.core.seq(inst_30491);
var state_30610__$1 = (function (){var statearr_30667 = state_30610;
(statearr_30667[(7)] = inst_30511__$1);

return statearr_30667;
})();
if(inst_30511__$1){
var statearr_30668_30736 = state_30610__$1;
(statearr_30668_30736[(1)] = (16));

} else {
var statearr_30669_30737 = state_30610__$1;
(statearr_30669_30737[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (9))){
var inst_30539 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30670_30738 = state_30610__$1;
(statearr_30670_30738[(2)] = inst_30539);

(statearr_30670_30738[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (5))){
var inst_30489 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30490 = cljs.core.seq(inst_30489);
var inst_30491 = inst_30490;
var inst_30492 = null;
var inst_30493 = (0);
var inst_30494 = (0);
var state_30610__$1 = (function (){var statearr_30671 = state_30610;
(statearr_30671[(14)] = inst_30491);

(statearr_30671[(15)] = inst_30492);

(statearr_30671[(16)] = inst_30494);

(statearr_30671[(17)] = inst_30493);

return statearr_30671;
})();
var statearr_30672_30739 = state_30610__$1;
(statearr_30672_30739[(2)] = null);

(statearr_30672_30739[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (14))){
var state_30610__$1 = state_30610;
var statearr_30673_30740 = state_30610__$1;
(statearr_30673_30740[(2)] = null);

(statearr_30673_30740[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (45))){
var inst_30600 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30674_30741 = state_30610__$1;
(statearr_30674_30741[(2)] = inst_30600);

(statearr_30674_30741[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (26))){
var inst_30542 = (state_30610[(29)]);
var inst_30596 = (state_30610[(2)]);
var inst_30597 = cljs.core.seq(inst_30542);
var state_30610__$1 = (function (){var statearr_30675 = state_30610;
(statearr_30675[(31)] = inst_30596);

return statearr_30675;
})();
if(inst_30597){
var statearr_30676_30742 = state_30610__$1;
(statearr_30676_30742[(1)] = (42));

} else {
var statearr_30677_30743 = state_30610__$1;
(statearr_30677_30743[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (16))){
var inst_30511 = (state_30610[(7)]);
var inst_30513 = cljs.core.chunked_seq_QMARK_(inst_30511);
var state_30610__$1 = state_30610;
if(inst_30513){
var statearr_30678_30744 = state_30610__$1;
(statearr_30678_30744[(1)] = (19));

} else {
var statearr_30679_30745 = state_30610__$1;
(statearr_30679_30745[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (38))){
var inst_30589 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30680_30746 = state_30610__$1;
(statearr_30680_30746[(2)] = inst_30589);

(statearr_30680_30746[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (30))){
var state_30610__$1 = state_30610;
var statearr_30681_30747 = state_30610__$1;
(statearr_30681_30747[(2)] = null);

(statearr_30681_30747[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (10))){
var inst_30492 = (state_30610[(15)]);
var inst_30494 = (state_30610[(16)]);
var inst_30500 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30492,inst_30494);
var inst_30501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30500,(0),null);
var inst_30502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30500,(1),null);
var state_30610__$1 = (function (){var statearr_30682 = state_30610;
(statearr_30682[(26)] = inst_30501);

return statearr_30682;
})();
if(cljs.core.truth_(inst_30502)){
var statearr_30683_30748 = state_30610__$1;
(statearr_30683_30748[(1)] = (13));

} else {
var statearr_30684_30749 = state_30610__$1;
(statearr_30684_30749[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (18))){
var inst_30535 = (state_30610[(2)]);
var state_30610__$1 = state_30610;
var statearr_30685_30750 = state_30610__$1;
(statearr_30685_30750[(2)] = inst_30535);

(statearr_30685_30750[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (42))){
var state_30610__$1 = state_30610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30610__$1,(45),dchan);
} else {
if((state_val_30611 === (37))){
var inst_30569 = (state_30610[(25)]);
var inst_30578 = (state_30610[(23)]);
var inst_30482 = (state_30610[(12)]);
var inst_30578__$1 = cljs.core.first(inst_30569);
var inst_30579 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30578__$1,inst_30482,done);
var state_30610__$1 = (function (){var statearr_30686 = state_30610;
(statearr_30686[(23)] = inst_30578__$1);

return statearr_30686;
})();
if(cljs.core.truth_(inst_30579)){
var statearr_30687_30751 = state_30610__$1;
(statearr_30687_30751[(1)] = (39));

} else {
var statearr_30688_30752 = state_30610__$1;
(statearr_30688_30752[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30611 === (8))){
var inst_30494 = (state_30610[(16)]);
var inst_30493 = (state_30610[(17)]);
var inst_30496 = (inst_30494 < inst_30493);
var inst_30497 = inst_30496;
var state_30610__$1 = state_30610;
if(cljs.core.truth_(inst_30497)){
var statearr_30689_30753 = state_30610__$1;
(statearr_30689_30753[(1)] = (10));

} else {
var statearr_30690_30754 = state_30610__$1;
(statearr_30690_30754[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___30700,cs,m,dchan,dctr,done))
;
return ((function (switch__11561__auto__,c__11626__auto___30700,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11562__auto__ = null;
var cljs$core$async$mult_$_state_machine__11562__auto____0 = (function (){
var statearr_30694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30694[(0)] = cljs$core$async$mult_$_state_machine__11562__auto__);

(statearr_30694[(1)] = (1));

return statearr_30694;
});
var cljs$core$async$mult_$_state_machine__11562__auto____1 = (function (state_30610){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_30610);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e30695){if((e30695 instanceof Object)){
var ex__11565__auto__ = e30695;
var statearr_30696_30755 = state_30610;
(statearr_30696_30755[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30610);

return cljs.core.constant$keyword$recur;
} else {
throw e30695;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__30756 = state_30610;
state_30610 = G__30756;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11562__auto__ = function(state_30610){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11562__auto____1.call(this,state_30610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11562__auto____0;
cljs$core$async$mult_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11562__auto____1;
return cljs$core$async$mult_$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___30700,cs,m,dchan,dctr,done))
})();
var state__11628__auto__ = (function (){var statearr_30697 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_30697[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___30700);

return statearr_30697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___30700,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30757 = [];
var len__8976__auto___30760 = arguments.length;
var i__8977__auto___30761 = (0);
while(true){
if((i__8977__auto___30761 < len__8976__auto___30760)){
args30757.push((arguments[i__8977__auto___30761]));

var G__30762 = (i__8977__auto___30761 + (1));
i__8977__auto___30761 = G__30762;
continue;
} else {
}
break;
}

var G__30759 = args30757.length;
switch (G__30759) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30757.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto__.call(null,m,state_map));
} else {
var m__8574__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto__.call(null,m,mode));
} else {
var m__8574__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___30776 = arguments.length;
var i__8977__auto___30777 = (0);
while(true){
if((i__8977__auto___30777 < len__8976__auto___30776)){
args__8983__auto__.push((arguments[i__8977__auto___30777]));

var G__30778 = (i__8977__auto___30777 + (1));
i__8977__auto___30777 = G__30778;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((3) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8984__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30770){
var map__30771 = p__30770;
var map__30771__$1 = ((((!((map__30771 == null)))?((((map__30771.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30771.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30771):map__30771);
var opts = map__30771__$1;
var statearr_30773_30779 = state;
(statearr_30773_30779[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__30771,map__30771__$1,opts){
return (function (val){
var statearr_30774_30780 = state;
(statearr_30774_30780[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30771,map__30771__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30775_30781 = state;
(statearr_30775_30781[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30766){
var G__30767 = cljs.core.first(seq30766);
var seq30766__$1 = cljs.core.next(seq30766);
var G__30768 = cljs.core.first(seq30766__$1);
var seq30766__$2 = cljs.core.next(seq30766__$1);
var G__30769 = cljs.core.first(seq30766__$2);
var seq30766__$3 = cljs.core.next(seq30766__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30767,G__30768,G__30769,seq30766__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30948 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30948) : cljs.core.atom.call(null,G__30948));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.constant$keyword$mute) : cljs.core.atom.call(null,cljs.core.constant$keyword$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t30949 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30949 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30950){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30950 = meta30950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30951,meta30950__$1){
var self__ = this;
var _30951__$1 = this;
return (new cljs.core.async.t30949(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30950__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30951){
var self__ = this;
var _30951__$1 = this;
return self__.meta30950;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30949.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30952_31114 = self__.cs;
var G__30953_31115 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30952_31114,G__30953_31115) : cljs.core.reset_BANG_.call(null,G__30952_31114,G__30953_31115));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30950","meta30950",2077422788,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30949.cljs$lang$type = true;

cljs.core.async.t30949.cljs$lang$ctorStr = "cljs.core.async/t30949";

cljs.core.async.t30949.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30949");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t30949 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t30949(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30950){
return (new cljs.core.async.t30949(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30950));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t30949(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11626__auto___31116 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31051){
var state_val_31052 = (state_31051[(1)]);
if((state_val_31052 === (7))){
var inst_30969 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
var statearr_31053_31117 = state_31051__$1;
(statearr_31053_31117[(2)] = inst_30969);

(statearr_31053_31117[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (20))){
var inst_30981 = (state_31051[(7)]);
var state_31051__$1 = state_31051;
var statearr_31054_31118 = state_31051__$1;
(statearr_31054_31118[(2)] = inst_30981);

(statearr_31054_31118[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (27))){
var state_31051__$1 = state_31051;
var statearr_31055_31119 = state_31051__$1;
(statearr_31055_31119[(2)] = null);

(statearr_31055_31119[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (1))){
var inst_30957 = (state_31051[(8)]);
var inst_30957__$1 = calc_state();
var inst_30959 = (inst_30957__$1 == null);
var inst_30960 = cljs.core.not(inst_30959);
var state_31051__$1 = (function (){var statearr_31056 = state_31051;
(statearr_31056[(8)] = inst_30957__$1);

return statearr_31056;
})();
if(inst_30960){
var statearr_31057_31120 = state_31051__$1;
(statearr_31057_31120[(1)] = (2));

} else {
var statearr_31058_31121 = state_31051__$1;
(statearr_31058_31121[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (24))){
var inst_31004 = (state_31051[(9)]);
var inst_31025 = (state_31051[(10)]);
var inst_31011 = (state_31051[(11)]);
var inst_31025__$1 = (inst_31004.cljs$core$IFn$_invoke$arity$1 ? inst_31004.cljs$core$IFn$_invoke$arity$1(inst_31011) : inst_31004.call(null,inst_31011));
var state_31051__$1 = (function (){var statearr_31059 = state_31051;
(statearr_31059[(10)] = inst_31025__$1);

return statearr_31059;
})();
if(cljs.core.truth_(inst_31025__$1)){
var statearr_31060_31122 = state_31051__$1;
(statearr_31060_31122[(1)] = (29));

} else {
var statearr_31061_31123 = state_31051__$1;
(statearr_31061_31123[(1)] = (30));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (4))){
var inst_30972 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_30972)){
var statearr_31062_31124 = state_31051__$1;
(statearr_31062_31124[(1)] = (8));

} else {
var statearr_31063_31125 = state_31051__$1;
(statearr_31063_31125[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (15))){
var inst_30998 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_30998)){
var statearr_31064_31126 = state_31051__$1;
(statearr_31064_31126[(1)] = (19));

} else {
var statearr_31065_31127 = state_31051__$1;
(statearr_31065_31127[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (21))){
var inst_31003 = (state_31051[(12)]);
var inst_31003__$1 = (state_31051[(2)]);
var inst_31004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31003__$1,cljs.core.constant$keyword$solos);
var inst_31005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31003__$1,cljs.core.constant$keyword$mutes);
var inst_31006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31003__$1,cljs.core.constant$keyword$reads);
var state_31051__$1 = (function (){var statearr_31066 = state_31051;
(statearr_31066[(9)] = inst_31004);

(statearr_31066[(13)] = inst_31005);

(statearr_31066[(12)] = inst_31003__$1);

return statearr_31066;
})();
return cljs.core.async.ioc_alts_BANG_(state_31051__$1,(22),inst_31006);
} else {
if((state_val_31052 === (31))){
var inst_31033 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_31033)){
var statearr_31067_31128 = state_31051__$1;
(statearr_31067_31128[(1)] = (32));

} else {
var statearr_31068_31129 = state_31051__$1;
(statearr_31068_31129[(1)] = (33));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (32))){
var inst_31010 = (state_31051[(14)]);
var state_31051__$1 = state_31051;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31051__$1,(35),out,inst_31010);
} else {
if((state_val_31052 === (33))){
var inst_31003 = (state_31051[(12)]);
var inst_30981 = inst_31003;
var state_31051__$1 = (function (){var statearr_31069 = state_31051;
(statearr_31069[(7)] = inst_30981);

return statearr_31069;
})();
var statearr_31070_31130 = state_31051__$1;
(statearr_31070_31130[(2)] = null);

(statearr_31070_31130[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (13))){
var inst_30981 = (state_31051[(7)]);
var inst_30988 = inst_30981.cljs$lang$protocol_mask$partition0$;
var inst_30989 = (inst_30988 & (64));
var inst_30990 = inst_30981.cljs$core$ISeq$;
var inst_30991 = (inst_30989) || (inst_30990);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_30991)){
var statearr_31071_31131 = state_31051__$1;
(statearr_31071_31131[(1)] = (16));

} else {
var statearr_31072_31132 = state_31051__$1;
(statearr_31072_31132[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (22))){
var inst_31010 = (state_31051[(14)]);
var inst_31011 = (state_31051[(11)]);
var inst_31009 = (state_31051[(2)]);
var inst_31010__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31009,(0),null);
var inst_31011__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31009,(1),null);
var inst_31012 = (inst_31010__$1 == null);
var inst_31013 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31011__$1,change);
var inst_31014 = (inst_31012) || (inst_31013);
var state_31051__$1 = (function (){var statearr_31073 = state_31051;
(statearr_31073[(14)] = inst_31010__$1);

(statearr_31073[(11)] = inst_31011__$1);

return statearr_31073;
})();
if(cljs.core.truth_(inst_31014)){
var statearr_31074_31133 = state_31051__$1;
(statearr_31074_31133[(1)] = (23));

} else {
var statearr_31075_31134 = state_31051__$1;
(statearr_31075_31134[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (36))){
var inst_31003 = (state_31051[(12)]);
var inst_30981 = inst_31003;
var state_31051__$1 = (function (){var statearr_31076 = state_31051;
(statearr_31076[(7)] = inst_30981);

return statearr_31076;
})();
var statearr_31077_31135 = state_31051__$1;
(statearr_31077_31135[(2)] = null);

(statearr_31077_31135[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (29))){
var inst_31025 = (state_31051[(10)]);
var state_31051__$1 = state_31051;
var statearr_31078_31136 = state_31051__$1;
(statearr_31078_31136[(2)] = inst_31025);

(statearr_31078_31136[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (6))){
var state_31051__$1 = state_31051;
var statearr_31079_31137 = state_31051__$1;
(statearr_31079_31137[(2)] = false);

(statearr_31079_31137[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (28))){
var inst_31021 = (state_31051[(2)]);
var inst_31022 = calc_state();
var inst_30981 = inst_31022;
var state_31051__$1 = (function (){var statearr_31080 = state_31051;
(statearr_31080[(7)] = inst_30981);

(statearr_31080[(15)] = inst_31021);

return statearr_31080;
})();
var statearr_31081_31138 = state_31051__$1;
(statearr_31081_31138[(2)] = null);

(statearr_31081_31138[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (25))){
var inst_31047 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
var statearr_31082_31139 = state_31051__$1;
(statearr_31082_31139[(2)] = inst_31047);

(statearr_31082_31139[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (34))){
var inst_31045 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
var statearr_31083_31140 = state_31051__$1;
(statearr_31083_31140[(2)] = inst_31045);

(statearr_31083_31140[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (17))){
var state_31051__$1 = state_31051;
var statearr_31084_31141 = state_31051__$1;
(statearr_31084_31141[(2)] = false);

(statearr_31084_31141[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (3))){
var state_31051__$1 = state_31051;
var statearr_31085_31142 = state_31051__$1;
(statearr_31085_31142[(2)] = false);

(statearr_31085_31142[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (12))){
var inst_31049 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31051__$1,inst_31049);
} else {
if((state_val_31052 === (2))){
var inst_30957 = (state_31051[(8)]);
var inst_30962 = inst_30957.cljs$lang$protocol_mask$partition0$;
var inst_30963 = (inst_30962 & (64));
var inst_30964 = inst_30957.cljs$core$ISeq$;
var inst_30965 = (inst_30963) || (inst_30964);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_30965)){
var statearr_31086_31143 = state_31051__$1;
(statearr_31086_31143[(1)] = (5));

} else {
var statearr_31087_31144 = state_31051__$1;
(statearr_31087_31144[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (23))){
var inst_31010 = (state_31051[(14)]);
var inst_31016 = (inst_31010 == null);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_31016)){
var statearr_31088_31145 = state_31051__$1;
(statearr_31088_31145[(1)] = (26));

} else {
var statearr_31089_31146 = state_31051__$1;
(statearr_31089_31146[(1)] = (27));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (35))){
var inst_31036 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
if(cljs.core.truth_(inst_31036)){
var statearr_31090_31147 = state_31051__$1;
(statearr_31090_31147[(1)] = (36));

} else {
var statearr_31091_31148 = state_31051__$1;
(statearr_31091_31148[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (19))){
var inst_30981 = (state_31051[(7)]);
var inst_31000 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30981);
var state_31051__$1 = state_31051;
var statearr_31092_31149 = state_31051__$1;
(statearr_31092_31149[(2)] = inst_31000);

(statearr_31092_31149[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (11))){
var inst_30981 = (state_31051[(7)]);
var inst_30985 = (inst_30981 == null);
var inst_30986 = cljs.core.not(inst_30985);
var state_31051__$1 = state_31051;
if(inst_30986){
var statearr_31093_31150 = state_31051__$1;
(statearr_31093_31150[(1)] = (13));

} else {
var statearr_31094_31151 = state_31051__$1;
(statearr_31094_31151[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (9))){
var inst_30957 = (state_31051[(8)]);
var state_31051__$1 = state_31051;
var statearr_31095_31152 = state_31051__$1;
(statearr_31095_31152[(2)] = inst_30957);

(statearr_31095_31152[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (5))){
var state_31051__$1 = state_31051;
var statearr_31096_31153 = state_31051__$1;
(statearr_31096_31153[(2)] = true);

(statearr_31096_31153[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (14))){
var state_31051__$1 = state_31051;
var statearr_31097_31154 = state_31051__$1;
(statearr_31097_31154[(2)] = false);

(statearr_31097_31154[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (26))){
var inst_31011 = (state_31051[(11)]);
var inst_31018 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31011);
var state_31051__$1 = state_31051;
var statearr_31098_31155 = state_31051__$1;
(statearr_31098_31155[(2)] = inst_31018);

(statearr_31098_31155[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (16))){
var state_31051__$1 = state_31051;
var statearr_31099_31156 = state_31051__$1;
(statearr_31099_31156[(2)] = true);

(statearr_31099_31156[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (38))){
var inst_31041 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
var statearr_31100_31157 = state_31051__$1;
(statearr_31100_31157[(2)] = inst_31041);

(statearr_31100_31157[(1)] = (34));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (30))){
var inst_31004 = (state_31051[(9)]);
var inst_31005 = (state_31051[(13)]);
var inst_31011 = (state_31051[(11)]);
var inst_31028 = cljs.core.empty_QMARK_(inst_31004);
var inst_31029 = (inst_31005.cljs$core$IFn$_invoke$arity$1 ? inst_31005.cljs$core$IFn$_invoke$arity$1(inst_31011) : inst_31005.call(null,inst_31011));
var inst_31030 = cljs.core.not(inst_31029);
var inst_31031 = (inst_31028) && (inst_31030);
var state_31051__$1 = state_31051;
var statearr_31101_31158 = state_31051__$1;
(statearr_31101_31158[(2)] = inst_31031);

(statearr_31101_31158[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (10))){
var inst_30957 = (state_31051[(8)]);
var inst_30977 = (state_31051[(2)]);
var inst_30978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30977,cljs.core.constant$keyword$solos);
var inst_30979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30977,cljs.core.constant$keyword$mutes);
var inst_30980 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30977,cljs.core.constant$keyword$reads);
var inst_30981 = inst_30957;
var state_31051__$1 = (function (){var statearr_31102 = state_31051;
(statearr_31102[(16)] = inst_30978);

(statearr_31102[(7)] = inst_30981);

(statearr_31102[(17)] = inst_30980);

(statearr_31102[(18)] = inst_30979);

return statearr_31102;
})();
var statearr_31103_31159 = state_31051__$1;
(statearr_31103_31159[(2)] = null);

(statearr_31103_31159[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (18))){
var inst_30995 = (state_31051[(2)]);
var state_31051__$1 = state_31051;
var statearr_31104_31160 = state_31051__$1;
(statearr_31104_31160[(2)] = inst_30995);

(statearr_31104_31160[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (37))){
var state_31051__$1 = state_31051;
var statearr_31105_31161 = state_31051__$1;
(statearr_31105_31161[(2)] = null);

(statearr_31105_31161[(1)] = (38));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31052 === (8))){
var inst_30957 = (state_31051[(8)]);
var inst_30974 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30957);
var state_31051__$1 = state_31051;
var statearr_31106_31162 = state_31051__$1;
(statearr_31106_31162[(2)] = inst_30974);

(statearr_31106_31162[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11561__auto__,c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11562__auto__ = null;
var cljs$core$async$mix_$_state_machine__11562__auto____0 = (function (){
var statearr_31110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31110[(0)] = cljs$core$async$mix_$_state_machine__11562__auto__);

(statearr_31110[(1)] = (1));

return statearr_31110;
});
var cljs$core$async$mix_$_state_machine__11562__auto____1 = (function (state_31051){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31051);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31111){if((e31111 instanceof Object)){
var ex__11565__auto__ = e31111;
var statearr_31112_31163 = state_31051;
(statearr_31112_31163[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31051);

return cljs.core.constant$keyword$recur;
} else {
throw e31111;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31164 = state_31051;
state_31051 = G__31164;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11562__auto__ = function(state_31051){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11562__auto____1.call(this,state_31051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11562__auto____0;
cljs$core$async$mix_$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11562__auto____1;
return cljs$core$async$mix_$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11628__auto__ = (function (){var statearr_31113 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31113[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31116);

return statearr_31113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31116,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto__.call(null,p,v,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args31167 = [];
var len__8976__auto___31170 = arguments.length;
var i__8977__auto___31171 = (0);
while(true){
if((i__8977__auto___31171 < len__8976__auto___31170)){
args31167.push((arguments[i__8977__auto___31171]));

var G__31172 = (i__8977__auto___31171 + (1));
i__8977__auto___31171 = G__31172;
continue;
} else {
}
break;
}

var G__31169 = args31167.length;
switch (G__31169) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31167.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto__.call(null,p));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto__.call(null,p,v));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args31175 = [];
var len__8976__auto___31303 = arguments.length;
var i__8977__auto___31304 = (0);
while(true){
if((i__8977__auto___31304 < len__8976__auto___31303)){
args31175.push((arguments[i__8977__auto___31304]));

var G__31305 = (i__8977__auto___31304 + (1));
i__8977__auto___31304 = G__31305;
continue;
} else {
}
break;
}

var G__31177 = args31175.length;
switch (G__31177) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31175.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__31178 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31178) : cljs.core.atom.call(null,G__31178));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7937__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7937__auto__,mults){
return (function (p1__31174_SHARP_){
if(cljs.core.truth_((p1__31174_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31174_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31174_SHARP_.call(null,topic)))){
return p1__31174_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31174_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7937__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t31179 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31179 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31180){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31180 = meta31180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31181,meta31180__$1){
var self__ = this;
var _31181__$1 = this;
return (new cljs.core.async.t31179(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31180__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31181){
var self__ = this;
var _31181__$1 = this;
return self__.meta31180;
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31179.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t31179.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31182 = self__.mults;
var G__31183 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31182,G__31183) : cljs.core.reset_BANG_.call(null,G__31182,G__31183));
});})(mults,ensure_mult))
;

cljs.core.async.t31179.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t31179.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31180","meta31180",-378171813,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t31179.cljs$lang$type = true;

cljs.core.async.t31179.cljs$lang$ctorStr = "cljs.core.async/t31179";

cljs.core.async.t31179.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31179");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t31179 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t31179(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31180){
return (new cljs.core.async.t31179(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31180));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t31179(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11626__auto___31307 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31307,mults,ensure_mult,p){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31307,mults,ensure_mult,p){
return (function (state_31255){
var state_val_31256 = (state_31255[(1)]);
if((state_val_31256 === (7))){
var inst_31251 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31257_31308 = state_31255__$1;
(statearr_31257_31308[(2)] = inst_31251);

(statearr_31257_31308[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (20))){
var state_31255__$1 = state_31255;
var statearr_31258_31309 = state_31255__$1;
(statearr_31258_31309[(2)] = null);

(statearr_31258_31309[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (1))){
var state_31255__$1 = state_31255;
var statearr_31259_31310 = state_31255__$1;
(statearr_31259_31310[(2)] = null);

(statearr_31259_31310[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (24))){
var inst_31234 = (state_31255[(7)]);
var inst_31243 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31234);
var state_31255__$1 = state_31255;
var statearr_31260_31311 = state_31255__$1;
(statearr_31260_31311[(2)] = inst_31243);

(statearr_31260_31311[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (4))){
var inst_31186 = (state_31255[(8)]);
var inst_31186__$1 = (state_31255[(2)]);
var inst_31187 = (inst_31186__$1 == null);
var state_31255__$1 = (function (){var statearr_31261 = state_31255;
(statearr_31261[(8)] = inst_31186__$1);

return statearr_31261;
})();
if(cljs.core.truth_(inst_31187)){
var statearr_31262_31312 = state_31255__$1;
(statearr_31262_31312[(1)] = (5));

} else {
var statearr_31263_31313 = state_31255__$1;
(statearr_31263_31313[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (15))){
var inst_31228 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31264_31314 = state_31255__$1;
(statearr_31264_31314[(2)] = inst_31228);

(statearr_31264_31314[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (21))){
var inst_31248 = (state_31255[(2)]);
var state_31255__$1 = (function (){var statearr_31265 = state_31255;
(statearr_31265[(9)] = inst_31248);

return statearr_31265;
})();
var statearr_31266_31315 = state_31255__$1;
(statearr_31266_31315[(2)] = null);

(statearr_31266_31315[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (13))){
var inst_31210 = (state_31255[(10)]);
var inst_31212 = cljs.core.chunked_seq_QMARK_(inst_31210);
var state_31255__$1 = state_31255;
if(inst_31212){
var statearr_31267_31316 = state_31255__$1;
(statearr_31267_31316[(1)] = (16));

} else {
var statearr_31268_31317 = state_31255__$1;
(statearr_31268_31317[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (22))){
var inst_31240 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
if(cljs.core.truth_(inst_31240)){
var statearr_31269_31318 = state_31255__$1;
(statearr_31269_31318[(1)] = (23));

} else {
var statearr_31270_31319 = state_31255__$1;
(statearr_31270_31319[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (6))){
var inst_31236 = (state_31255[(11)]);
var inst_31186 = (state_31255[(8)]);
var inst_31234 = (state_31255[(7)]);
var inst_31234__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31186) : topic_fn.call(null,inst_31186));
var inst_31235 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31236__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31235,inst_31234__$1);
var state_31255__$1 = (function (){var statearr_31271 = state_31255;
(statearr_31271[(11)] = inst_31236__$1);

(statearr_31271[(7)] = inst_31234__$1);

return statearr_31271;
})();
if(cljs.core.truth_(inst_31236__$1)){
var statearr_31272_31320 = state_31255__$1;
(statearr_31272_31320[(1)] = (19));

} else {
var statearr_31273_31321 = state_31255__$1;
(statearr_31273_31321[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (25))){
var inst_31245 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31274_31322 = state_31255__$1;
(statearr_31274_31322[(2)] = inst_31245);

(statearr_31274_31322[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (17))){
var inst_31210 = (state_31255[(10)]);
var inst_31219 = cljs.core.first(inst_31210);
var inst_31220 = cljs.core.async.muxch_STAR_(inst_31219);
var inst_31221 = cljs.core.async.close_BANG_(inst_31220);
var inst_31222 = cljs.core.next(inst_31210);
var inst_31196 = inst_31222;
var inst_31197 = null;
var inst_31198 = (0);
var inst_31199 = (0);
var state_31255__$1 = (function (){var statearr_31275 = state_31255;
(statearr_31275[(12)] = inst_31198);

(statearr_31275[(13)] = inst_31197);

(statearr_31275[(14)] = inst_31221);

(statearr_31275[(15)] = inst_31199);

(statearr_31275[(16)] = inst_31196);

return statearr_31275;
})();
var statearr_31276_31323 = state_31255__$1;
(statearr_31276_31323[(2)] = null);

(statearr_31276_31323[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (3))){
var inst_31253 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31255__$1,inst_31253);
} else {
if((state_val_31256 === (12))){
var inst_31230 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31277_31324 = state_31255__$1;
(statearr_31277_31324[(2)] = inst_31230);

(statearr_31277_31324[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (2))){
var state_31255__$1 = state_31255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31255__$1,(4),ch);
} else {
if((state_val_31256 === (23))){
var state_31255__$1 = state_31255;
var statearr_31278_31325 = state_31255__$1;
(statearr_31278_31325[(2)] = null);

(statearr_31278_31325[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (19))){
var inst_31236 = (state_31255[(11)]);
var inst_31186 = (state_31255[(8)]);
var inst_31238 = cljs.core.async.muxch_STAR_(inst_31236);
var state_31255__$1 = state_31255;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31255__$1,(22),inst_31238,inst_31186);
} else {
if((state_val_31256 === (11))){
var inst_31210 = (state_31255[(10)]);
var inst_31196 = (state_31255[(16)]);
var inst_31210__$1 = cljs.core.seq(inst_31196);
var state_31255__$1 = (function (){var statearr_31279 = state_31255;
(statearr_31279[(10)] = inst_31210__$1);

return statearr_31279;
})();
if(inst_31210__$1){
var statearr_31280_31326 = state_31255__$1;
(statearr_31280_31326[(1)] = (13));

} else {
var statearr_31281_31327 = state_31255__$1;
(statearr_31281_31327[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (9))){
var inst_31232 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31282_31328 = state_31255__$1;
(statearr_31282_31328[(2)] = inst_31232);

(statearr_31282_31328[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (5))){
var inst_31193 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31194 = cljs.core.vals(inst_31193);
var inst_31195 = cljs.core.seq(inst_31194);
var inst_31196 = inst_31195;
var inst_31197 = null;
var inst_31198 = (0);
var inst_31199 = (0);
var state_31255__$1 = (function (){var statearr_31283 = state_31255;
(statearr_31283[(12)] = inst_31198);

(statearr_31283[(13)] = inst_31197);

(statearr_31283[(15)] = inst_31199);

(statearr_31283[(16)] = inst_31196);

return statearr_31283;
})();
var statearr_31284_31329 = state_31255__$1;
(statearr_31284_31329[(2)] = null);

(statearr_31284_31329[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (14))){
var state_31255__$1 = state_31255;
var statearr_31288_31330 = state_31255__$1;
(statearr_31288_31330[(2)] = null);

(statearr_31288_31330[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (16))){
var inst_31210 = (state_31255[(10)]);
var inst_31214 = cljs.core.chunk_first(inst_31210);
var inst_31215 = cljs.core.chunk_rest(inst_31210);
var inst_31216 = cljs.core.count(inst_31214);
var inst_31196 = inst_31215;
var inst_31197 = inst_31214;
var inst_31198 = inst_31216;
var inst_31199 = (0);
var state_31255__$1 = (function (){var statearr_31289 = state_31255;
(statearr_31289[(12)] = inst_31198);

(statearr_31289[(13)] = inst_31197);

(statearr_31289[(15)] = inst_31199);

(statearr_31289[(16)] = inst_31196);

return statearr_31289;
})();
var statearr_31290_31331 = state_31255__$1;
(statearr_31290_31331[(2)] = null);

(statearr_31290_31331[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (10))){
var inst_31198 = (state_31255[(12)]);
var inst_31197 = (state_31255[(13)]);
var inst_31199 = (state_31255[(15)]);
var inst_31196 = (state_31255[(16)]);
var inst_31204 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31197,inst_31199);
var inst_31205 = cljs.core.async.muxch_STAR_(inst_31204);
var inst_31206 = cljs.core.async.close_BANG_(inst_31205);
var inst_31207 = (inst_31199 + (1));
var tmp31285 = inst_31198;
var tmp31286 = inst_31197;
var tmp31287 = inst_31196;
var inst_31196__$1 = tmp31287;
var inst_31197__$1 = tmp31286;
var inst_31198__$1 = tmp31285;
var inst_31199__$1 = inst_31207;
var state_31255__$1 = (function (){var statearr_31291 = state_31255;
(statearr_31291[(12)] = inst_31198__$1);

(statearr_31291[(13)] = inst_31197__$1);

(statearr_31291[(17)] = inst_31206);

(statearr_31291[(15)] = inst_31199__$1);

(statearr_31291[(16)] = inst_31196__$1);

return statearr_31291;
})();
var statearr_31292_31332 = state_31255__$1;
(statearr_31292_31332[(2)] = null);

(statearr_31292_31332[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (18))){
var inst_31225 = (state_31255[(2)]);
var state_31255__$1 = state_31255;
var statearr_31293_31333 = state_31255__$1;
(statearr_31293_31333[(2)] = inst_31225);

(statearr_31293_31333[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31256 === (8))){
var inst_31198 = (state_31255[(12)]);
var inst_31199 = (state_31255[(15)]);
var inst_31201 = (inst_31199 < inst_31198);
var inst_31202 = inst_31201;
var state_31255__$1 = state_31255;
if(cljs.core.truth_(inst_31202)){
var statearr_31294_31334 = state_31255__$1;
(statearr_31294_31334[(1)] = (10));

} else {
var statearr_31295_31335 = state_31255__$1;
(statearr_31295_31335[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31307,mults,ensure_mult,p))
;
return ((function (switch__11561__auto__,c__11626__auto___31307,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31299[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31299[(1)] = (1));

return statearr_31299;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31255){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31255);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31300){if((e31300 instanceof Object)){
var ex__11565__auto__ = e31300;
var statearr_31301_31336 = state_31255;
(statearr_31301_31336[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31255);

return cljs.core.constant$keyword$recur;
} else {
throw e31300;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31337 = state_31255;
state_31255 = G__31337;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31255){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31307,mults,ensure_mult,p))
})();
var state__11628__auto__ = (function (){var statearr_31302 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31302[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31307);

return statearr_31302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31307,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31338 = [];
var len__8976__auto___31341 = arguments.length;
var i__8977__auto___31342 = (0);
while(true){
if((i__8977__auto___31342 < len__8976__auto___31341)){
args31338.push((arguments[i__8977__auto___31342]));

var G__31343 = (i__8977__auto___31342 + (1));
i__8977__auto___31342 = G__31343;
continue;
} else {
}
break;
}

var G__31340 = args31338.length;
switch (G__31340) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31338.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31345 = [];
var len__8976__auto___31348 = arguments.length;
var i__8977__auto___31349 = (0);
while(true){
if((i__8977__auto___31349 < len__8976__auto___31348)){
args31345.push((arguments[i__8977__auto___31349]));

var G__31350 = (i__8977__auto___31349 + (1));
i__8977__auto___31349 = G__31350;
continue;
} else {
}
break;
}

var G__31347 = args31345.length;
switch (G__31347) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31345.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31352 = [];
var len__8976__auto___31423 = arguments.length;
var i__8977__auto___31424 = (0);
while(true){
if((i__8977__auto___31424 < len__8976__auto___31423)){
args31352.push((arguments[i__8977__auto___31424]));

var G__31425 = (i__8977__auto___31424 + (1));
i__8977__auto___31424 = G__31425;
continue;
} else {
}
break;
}

var G__31354 = args31352.length;
switch (G__31354) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31352.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11626__auto___31427 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31393){
var state_val_31394 = (state_31393[(1)]);
if((state_val_31394 === (7))){
var state_31393__$1 = state_31393;
var statearr_31395_31428 = state_31393__$1;
(statearr_31395_31428[(2)] = null);

(statearr_31395_31428[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (1))){
var state_31393__$1 = state_31393;
var statearr_31396_31429 = state_31393__$1;
(statearr_31396_31429[(2)] = null);

(statearr_31396_31429[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (4))){
var inst_31357 = (state_31393[(7)]);
var inst_31359 = (inst_31357 < cnt);
var state_31393__$1 = state_31393;
if(cljs.core.truth_(inst_31359)){
var statearr_31397_31430 = state_31393__$1;
(statearr_31397_31430[(1)] = (6));

} else {
var statearr_31398_31431 = state_31393__$1;
(statearr_31398_31431[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (15))){
var inst_31389 = (state_31393[(2)]);
var state_31393__$1 = state_31393;
var statearr_31399_31432 = state_31393__$1;
(statearr_31399_31432[(2)] = inst_31389);

(statearr_31399_31432[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (13))){
var inst_31382 = cljs.core.async.close_BANG_(out);
var state_31393__$1 = state_31393;
var statearr_31400_31433 = state_31393__$1;
(statearr_31400_31433[(2)] = inst_31382);

(statearr_31400_31433[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (6))){
var state_31393__$1 = state_31393;
var statearr_31401_31434 = state_31393__$1;
(statearr_31401_31434[(2)] = null);

(statearr_31401_31434[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (3))){
var inst_31391 = (state_31393[(2)]);
var state_31393__$1 = state_31393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31393__$1,inst_31391);
} else {
if((state_val_31394 === (12))){
var inst_31379 = (state_31393[(8)]);
var inst_31379__$1 = (state_31393[(2)]);
var inst_31380 = cljs.core.some(cljs.core.nil_QMARK_,inst_31379__$1);
var state_31393__$1 = (function (){var statearr_31402 = state_31393;
(statearr_31402[(8)] = inst_31379__$1);

return statearr_31402;
})();
if(cljs.core.truth_(inst_31380)){
var statearr_31403_31435 = state_31393__$1;
(statearr_31403_31435[(1)] = (13));

} else {
var statearr_31404_31436 = state_31393__$1;
(statearr_31404_31436[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (2))){
var inst_31356 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_31357 = (0);
var state_31393__$1 = (function (){var statearr_31405 = state_31393;
(statearr_31405[(9)] = inst_31356);

(statearr_31405[(7)] = inst_31357);

return statearr_31405;
})();
var statearr_31406_31437 = state_31393__$1;
(statearr_31406_31437[(2)] = null);

(statearr_31406_31437[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (11))){
var inst_31357 = (state_31393[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_31393,(10),Object,null,(9));
var inst_31366 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31357) : chs__$1.call(null,inst_31357));
var inst_31367 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31357) : done.call(null,inst_31357));
var inst_31368 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31366,inst_31367);
var state_31393__$1 = state_31393;
var statearr_31407_31438 = state_31393__$1;
(statearr_31407_31438[(2)] = inst_31368);


cljs.core.async.impl.ioc_helpers.process_exception(state_31393__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (9))){
var inst_31357 = (state_31393[(7)]);
var inst_31370 = (state_31393[(2)]);
var inst_31371 = (inst_31357 + (1));
var inst_31357__$1 = inst_31371;
var state_31393__$1 = (function (){var statearr_31408 = state_31393;
(statearr_31408[(10)] = inst_31370);

(statearr_31408[(7)] = inst_31357__$1);

return statearr_31408;
})();
var statearr_31409_31439 = state_31393__$1;
(statearr_31409_31439[(2)] = null);

(statearr_31409_31439[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (5))){
var inst_31377 = (state_31393[(2)]);
var state_31393__$1 = (function (){var statearr_31410 = state_31393;
(statearr_31410[(11)] = inst_31377);

return statearr_31410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31393__$1,(12),dchan);
} else {
if((state_val_31394 === (14))){
var inst_31379 = (state_31393[(8)]);
var inst_31384 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31379);
var state_31393__$1 = state_31393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31393__$1,(16),out,inst_31384);
} else {
if((state_val_31394 === (16))){
var inst_31386 = (state_31393[(2)]);
var state_31393__$1 = (function (){var statearr_31411 = state_31393;
(statearr_31411[(12)] = inst_31386);

return statearr_31411;
})();
var statearr_31412_31440 = state_31393__$1;
(statearr_31412_31440[(2)] = null);

(statearr_31412_31440[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (10))){
var inst_31361 = (state_31393[(2)]);
var inst_31362 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31393__$1 = (function (){var statearr_31413 = state_31393;
(statearr_31413[(13)] = inst_31361);

return statearr_31413;
})();
var statearr_31414_31441 = state_31393__$1;
(statearr_31414_31441[(2)] = inst_31362);


cljs.core.async.impl.ioc_helpers.process_exception(state_31393__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31394 === (8))){
var inst_31375 = (state_31393[(2)]);
var state_31393__$1 = state_31393;
var statearr_31415_31442 = state_31393__$1;
(statearr_31415_31442[(2)] = inst_31375);

(statearr_31415_31442[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11561__auto__,c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31419[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31419[(1)] = (1));

return statearr_31419;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31393){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31393);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31420){if((e31420 instanceof Object)){
var ex__11565__auto__ = e31420;
var statearr_31421_31443 = state_31393;
(statearr_31421_31443[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31393);

return cljs.core.constant$keyword$recur;
} else {
throw e31420;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31444 = state_31393;
state_31393 = G__31444;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11628__auto__ = (function (){var statearr_31422 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31422[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31427);

return statearr_31422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31427,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31446 = [];
var len__8976__auto___31502 = arguments.length;
var i__8977__auto___31503 = (0);
while(true){
if((i__8977__auto___31503 < len__8976__auto___31502)){
args31446.push((arguments[i__8977__auto___31503]));

var G__31504 = (i__8977__auto___31503 + (1));
i__8977__auto___31503 = G__31504;
continue;
} else {
}
break;
}

var G__31448 = args31446.length;
switch (G__31448) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31446.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___31506 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31506,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31506,out){
return (function (state_31478){
var state_val_31479 = (state_31478[(1)]);
if((state_val_31479 === (7))){
var inst_31458 = (state_31478[(7)]);
var inst_31457 = (state_31478[(8)]);
var inst_31457__$1 = (state_31478[(2)]);
var inst_31458__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31457__$1,(0),null);
var inst_31459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31457__$1,(1),null);
var inst_31460 = (inst_31458__$1 == null);
var state_31478__$1 = (function (){var statearr_31480 = state_31478;
(statearr_31480[(7)] = inst_31458__$1);

(statearr_31480[(9)] = inst_31459);

(statearr_31480[(8)] = inst_31457__$1);

return statearr_31480;
})();
if(cljs.core.truth_(inst_31460)){
var statearr_31481_31507 = state_31478__$1;
(statearr_31481_31507[(1)] = (8));

} else {
var statearr_31482_31508 = state_31478__$1;
(statearr_31482_31508[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (1))){
var inst_31449 = cljs.core.vec(chs);
var inst_31450 = inst_31449;
var state_31478__$1 = (function (){var statearr_31483 = state_31478;
(statearr_31483[(10)] = inst_31450);

return statearr_31483;
})();
var statearr_31484_31509 = state_31478__$1;
(statearr_31484_31509[(2)] = null);

(statearr_31484_31509[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (4))){
var inst_31450 = (state_31478[(10)]);
var state_31478__$1 = state_31478;
return cljs.core.async.ioc_alts_BANG_(state_31478__$1,(7),inst_31450);
} else {
if((state_val_31479 === (6))){
var inst_31474 = (state_31478[(2)]);
var state_31478__$1 = state_31478;
var statearr_31485_31510 = state_31478__$1;
(statearr_31485_31510[(2)] = inst_31474);

(statearr_31485_31510[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (3))){
var inst_31476 = (state_31478[(2)]);
var state_31478__$1 = state_31478;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31478__$1,inst_31476);
} else {
if((state_val_31479 === (2))){
var inst_31450 = (state_31478[(10)]);
var inst_31452 = cljs.core.count(inst_31450);
var inst_31453 = (inst_31452 > (0));
var state_31478__$1 = state_31478;
if(cljs.core.truth_(inst_31453)){
var statearr_31487_31511 = state_31478__$1;
(statearr_31487_31511[(1)] = (4));

} else {
var statearr_31488_31512 = state_31478__$1;
(statearr_31488_31512[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (11))){
var inst_31450 = (state_31478[(10)]);
var inst_31467 = (state_31478[(2)]);
var tmp31486 = inst_31450;
var inst_31450__$1 = tmp31486;
var state_31478__$1 = (function (){var statearr_31489 = state_31478;
(statearr_31489[(10)] = inst_31450__$1);

(statearr_31489[(11)] = inst_31467);

return statearr_31489;
})();
var statearr_31490_31513 = state_31478__$1;
(statearr_31490_31513[(2)] = null);

(statearr_31490_31513[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (9))){
var inst_31458 = (state_31478[(7)]);
var state_31478__$1 = state_31478;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31478__$1,(11),out,inst_31458);
} else {
if((state_val_31479 === (5))){
var inst_31472 = cljs.core.async.close_BANG_(out);
var state_31478__$1 = state_31478;
var statearr_31491_31514 = state_31478__$1;
(statearr_31491_31514[(2)] = inst_31472);

(statearr_31491_31514[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (10))){
var inst_31470 = (state_31478[(2)]);
var state_31478__$1 = state_31478;
var statearr_31492_31515 = state_31478__$1;
(statearr_31492_31515[(2)] = inst_31470);

(statearr_31492_31515[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31479 === (8))){
var inst_31450 = (state_31478[(10)]);
var inst_31458 = (state_31478[(7)]);
var inst_31459 = (state_31478[(9)]);
var inst_31457 = (state_31478[(8)]);
var inst_31462 = (function (){var cs = inst_31450;
var vec__31455 = inst_31457;
var v = inst_31458;
var c = inst_31459;
return ((function (cs,vec__31455,v,c,inst_31450,inst_31458,inst_31459,inst_31457,state_val_31479,c__11626__auto___31506,out){
return (function (p1__31445_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31445_SHARP_);
});
;})(cs,vec__31455,v,c,inst_31450,inst_31458,inst_31459,inst_31457,state_val_31479,c__11626__auto___31506,out))
})();
var inst_31463 = cljs.core.filterv(inst_31462,inst_31450);
var inst_31450__$1 = inst_31463;
var state_31478__$1 = (function (){var statearr_31493 = state_31478;
(statearr_31493[(10)] = inst_31450__$1);

return statearr_31493;
})();
var statearr_31494_31516 = state_31478__$1;
(statearr_31494_31516[(2)] = null);

(statearr_31494_31516[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31506,out))
;
return ((function (switch__11561__auto__,c__11626__auto___31506,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31498 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31498[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31498[(1)] = (1));

return statearr_31498;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31478){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31478);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31499){if((e31499 instanceof Object)){
var ex__11565__auto__ = e31499;
var statearr_31500_31517 = state_31478;
(statearr_31500_31517[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31478);

return cljs.core.constant$keyword$recur;
} else {
throw e31499;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31518 = state_31478;
state_31478 = G__31518;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31478){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31506,out))
})();
var state__11628__auto__ = (function (){var statearr_31501 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31501[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31506);

return statearr_31501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31506,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31519 = [];
var len__8976__auto___31568 = arguments.length;
var i__8977__auto___31569 = (0);
while(true){
if((i__8977__auto___31569 < len__8976__auto___31568)){
args31519.push((arguments[i__8977__auto___31569]));

var G__31570 = (i__8977__auto___31569 + (1));
i__8977__auto___31569 = G__31570;
continue;
} else {
}
break;
}

var G__31521 = args31519.length;
switch (G__31521) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31519.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___31572 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31572,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31572,out){
return (function (state_31545){
var state_val_31546 = (state_31545[(1)]);
if((state_val_31546 === (7))){
var inst_31527 = (state_31545[(7)]);
var inst_31527__$1 = (state_31545[(2)]);
var inst_31528 = (inst_31527__$1 == null);
var inst_31529 = cljs.core.not(inst_31528);
var state_31545__$1 = (function (){var statearr_31547 = state_31545;
(statearr_31547[(7)] = inst_31527__$1);

return statearr_31547;
})();
if(inst_31529){
var statearr_31548_31573 = state_31545__$1;
(statearr_31548_31573[(1)] = (8));

} else {
var statearr_31549_31574 = state_31545__$1;
(statearr_31549_31574[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (1))){
var inst_31522 = (0);
var state_31545__$1 = (function (){var statearr_31550 = state_31545;
(statearr_31550[(8)] = inst_31522);

return statearr_31550;
})();
var statearr_31551_31575 = state_31545__$1;
(statearr_31551_31575[(2)] = null);

(statearr_31551_31575[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (4))){
var state_31545__$1 = state_31545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31545__$1,(7),ch);
} else {
if((state_val_31546 === (6))){
var inst_31540 = (state_31545[(2)]);
var state_31545__$1 = state_31545;
var statearr_31552_31576 = state_31545__$1;
(statearr_31552_31576[(2)] = inst_31540);

(statearr_31552_31576[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (3))){
var inst_31542 = (state_31545[(2)]);
var inst_31543 = cljs.core.async.close_BANG_(out);
var state_31545__$1 = (function (){var statearr_31553 = state_31545;
(statearr_31553[(9)] = inst_31542);

return statearr_31553;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31545__$1,inst_31543);
} else {
if((state_val_31546 === (2))){
var inst_31522 = (state_31545[(8)]);
var inst_31524 = (inst_31522 < n);
var state_31545__$1 = state_31545;
if(cljs.core.truth_(inst_31524)){
var statearr_31554_31577 = state_31545__$1;
(statearr_31554_31577[(1)] = (4));

} else {
var statearr_31555_31578 = state_31545__$1;
(statearr_31555_31578[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (11))){
var inst_31522 = (state_31545[(8)]);
var inst_31532 = (state_31545[(2)]);
var inst_31533 = (inst_31522 + (1));
var inst_31522__$1 = inst_31533;
var state_31545__$1 = (function (){var statearr_31556 = state_31545;
(statearr_31556[(10)] = inst_31532);

(statearr_31556[(8)] = inst_31522__$1);

return statearr_31556;
})();
var statearr_31557_31579 = state_31545__$1;
(statearr_31557_31579[(2)] = null);

(statearr_31557_31579[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (9))){
var state_31545__$1 = state_31545;
var statearr_31558_31580 = state_31545__$1;
(statearr_31558_31580[(2)] = null);

(statearr_31558_31580[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (5))){
var state_31545__$1 = state_31545;
var statearr_31559_31581 = state_31545__$1;
(statearr_31559_31581[(2)] = null);

(statearr_31559_31581[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (10))){
var inst_31537 = (state_31545[(2)]);
var state_31545__$1 = state_31545;
var statearr_31560_31582 = state_31545__$1;
(statearr_31560_31582[(2)] = inst_31537);

(statearr_31560_31582[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31546 === (8))){
var inst_31527 = (state_31545[(7)]);
var state_31545__$1 = state_31545;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31545__$1,(11),out,inst_31527);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31572,out))
;
return ((function (switch__11561__auto__,c__11626__auto___31572,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31564 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31564[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31564[(1)] = (1));

return statearr_31564;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31545){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31545);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31565){if((e31565 instanceof Object)){
var ex__11565__auto__ = e31565;
var statearr_31566_31583 = state_31545;
(statearr_31566_31583[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31545);

return cljs.core.constant$keyword$recur;
} else {
throw e31565;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31584 = state_31545;
state_31545 = G__31584;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31545){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31572,out))
})();
var state__11628__auto__ = (function (){var statearr_31567 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31572);

return statearr_31567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31572,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31594 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31594 = (function (map_LT_,f,ch,meta31595){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31595 = meta31595;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31596,meta31595__$1){
var self__ = this;
var _31596__$1 = this;
return (new cljs.core.async.t31594(self__.map_LT_,self__.f,self__.ch,meta31595__$1));
});

cljs.core.async.t31594.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31596){
var self__ = this;
var _31596__$1 = this;
return self__.meta31595;
});

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t31597 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31597 = (function (map_LT_,f,ch,meta31595,_,fn1,meta31598){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31595 = meta31595;
this._ = _;
this.fn1 = fn1;
this.meta31598 = meta31598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31599,meta31598__$1){
var self__ = this;
var _31599__$1 = this;
return (new cljs.core.async.t31597(self__.map_LT_,self__.f,self__.ch,self__.meta31595,self__._,self__.fn1,meta31598__$1));
});})(___$1))
;

cljs.core.async.t31597.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31599){
var self__ = this;
var _31599__$1 = this;
return self__.meta31598;
});})(___$1))
;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t31597.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31585_SHARP_){
var G__31600 = (((p1__31585_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31585_SHARP_) : self__.f.call(null,p1__31585_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31600) : f1.call(null,G__31600));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31597.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31595","meta31595",1792547427,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tag,new cljs.core.Symbol("cljs.core.async","t31594","cljs.core.async/t31594",-1749669232,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31598","meta31598",825837995,null)], null);
});})(___$1))
;

cljs.core.async.t31597.cljs$lang$type = true;

cljs.core.async.t31597.cljs$lang$ctorStr = "cljs.core.async/t31597";

cljs.core.async.t31597.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31597");
});})(___$1))
;

cljs.core.async.__GT_t31597 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31597(map_LT___$1,f__$1,ch__$1,meta31595__$1,___$2,fn1__$1,meta31598){
return (new cljs.core.async.t31597(map_LT___$1,f__$1,ch__$1,meta31595__$1,___$2,fn1__$1,meta31598));
});})(___$1))
;

}

return (new cljs.core.async.t31597(self__.map_LT_,self__.f,self__.ch,self__.meta31595,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7925__auto__ = ret;
if(cljs.core.truth_(and__7925__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7925__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31601 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31601) : self__.f.call(null,G__31601));
})());
} else {
return ret;
}
});

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31594.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t31594.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31595","meta31595",1792547427,null)], null);
});

cljs.core.async.t31594.cljs$lang$type = true;

cljs.core.async.t31594.cljs$lang$ctorStr = "cljs.core.async/t31594";

cljs.core.async.t31594.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31594");
});

cljs.core.async.__GT_t31594 = (function cljs$core$async$map_LT__$___GT_t31594(map_LT___$1,f__$1,ch__$1,meta31595){
return (new cljs.core.async.t31594(map_LT___$1,f__$1,ch__$1,meta31595));
});

}

return (new cljs.core.async.t31594(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31605 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31605 = (function (map_GT_,f,ch,meta31606){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31606 = meta31606;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31605.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31607,meta31606__$1){
var self__ = this;
var _31607__$1 = this;
return (new cljs.core.async.t31605(self__.map_GT_,self__.f,self__.ch,meta31606__$1));
});

cljs.core.async.t31605.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31607){
var self__ = this;
var _31607__$1 = this;
return self__.meta31606;
});

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31605.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t31605.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31606","meta31606",51141772,null)], null);
});

cljs.core.async.t31605.cljs$lang$type = true;

cljs.core.async.t31605.cljs$lang$ctorStr = "cljs.core.async/t31605";

cljs.core.async.t31605.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31605");
});

cljs.core.async.__GT_t31605 = (function cljs$core$async$map_GT__$___GT_t31605(map_GT___$1,f__$1,ch__$1,meta31606){
return (new cljs.core.async.t31605(map_GT___$1,f__$1,ch__$1,meta31606));
});

}

return (new cljs.core.async.t31605(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31611 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31611 = (function (filter_GT_,p,ch,meta31612){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31612 = meta31612;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31613,meta31612__$1){
var self__ = this;
var _31613__$1 = this;
return (new cljs.core.async.t31611(self__.filter_GT_,self__.p,self__.ch,meta31612__$1));
});

cljs.core.async.t31611.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31613){
var self__ = this;
var _31613__$1 = this;
return self__.meta31612;
});

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31611.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t31611.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31612","meta31612",1741113697,null)], null);
});

cljs.core.async.t31611.cljs$lang$type = true;

cljs.core.async.t31611.cljs$lang$ctorStr = "cljs.core.async/t31611";

cljs.core.async.t31611.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31611");
});

cljs.core.async.__GT_t31611 = (function cljs$core$async$filter_GT__$___GT_t31611(filter_GT___$1,p__$1,ch__$1,meta31612){
return (new cljs.core.async.t31611(filter_GT___$1,p__$1,ch__$1,meta31612));
});

}

return (new cljs.core.async.t31611(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31614 = [];
var len__8976__auto___31658 = arguments.length;
var i__8977__auto___31659 = (0);
while(true){
if((i__8977__auto___31659 < len__8976__auto___31658)){
args31614.push((arguments[i__8977__auto___31659]));

var G__31660 = (i__8977__auto___31659 + (1));
i__8977__auto___31659 = G__31660;
continue;
} else {
}
break;
}

var G__31616 = args31614.length;
switch (G__31616) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31614.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___31662 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31662,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31662,out){
return (function (state_31637){
var state_val_31638 = (state_31637[(1)]);
if((state_val_31638 === (7))){
var inst_31633 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
var statearr_31639_31663 = state_31637__$1;
(statearr_31639_31663[(2)] = inst_31633);

(statearr_31639_31663[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (1))){
var state_31637__$1 = state_31637;
var statearr_31640_31664 = state_31637__$1;
(statearr_31640_31664[(2)] = null);

(statearr_31640_31664[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (4))){
var inst_31619 = (state_31637[(7)]);
var inst_31619__$1 = (state_31637[(2)]);
var inst_31620 = (inst_31619__$1 == null);
var state_31637__$1 = (function (){var statearr_31641 = state_31637;
(statearr_31641[(7)] = inst_31619__$1);

return statearr_31641;
})();
if(cljs.core.truth_(inst_31620)){
var statearr_31642_31665 = state_31637__$1;
(statearr_31642_31665[(1)] = (5));

} else {
var statearr_31643_31666 = state_31637__$1;
(statearr_31643_31666[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (6))){
var inst_31619 = (state_31637[(7)]);
var inst_31624 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31619) : p.call(null,inst_31619));
var state_31637__$1 = state_31637;
if(cljs.core.truth_(inst_31624)){
var statearr_31644_31667 = state_31637__$1;
(statearr_31644_31667[(1)] = (8));

} else {
var statearr_31645_31668 = state_31637__$1;
(statearr_31645_31668[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (3))){
var inst_31635 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31637__$1,inst_31635);
} else {
if((state_val_31638 === (2))){
var state_31637__$1 = state_31637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31637__$1,(4),ch);
} else {
if((state_val_31638 === (11))){
var inst_31627 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
var statearr_31646_31669 = state_31637__$1;
(statearr_31646_31669[(2)] = inst_31627);

(statearr_31646_31669[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (9))){
var state_31637__$1 = state_31637;
var statearr_31647_31670 = state_31637__$1;
(statearr_31647_31670[(2)] = null);

(statearr_31647_31670[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (5))){
var inst_31622 = cljs.core.async.close_BANG_(out);
var state_31637__$1 = state_31637;
var statearr_31648_31671 = state_31637__$1;
(statearr_31648_31671[(2)] = inst_31622);

(statearr_31648_31671[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (10))){
var inst_31630 = (state_31637[(2)]);
var state_31637__$1 = (function (){var statearr_31649 = state_31637;
(statearr_31649[(8)] = inst_31630);

return statearr_31649;
})();
var statearr_31650_31672 = state_31637__$1;
(statearr_31650_31672[(2)] = null);

(statearr_31650_31672[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (8))){
var inst_31619 = (state_31637[(7)]);
var state_31637__$1 = state_31637;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31637__$1,(11),out,inst_31619);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31662,out))
;
return ((function (switch__11561__auto__,c__11626__auto___31662,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31654 = [null,null,null,null,null,null,null,null,null];
(statearr_31654[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31654[(1)] = (1));

return statearr_31654;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31637){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31637);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31655){if((e31655 instanceof Object)){
var ex__11565__auto__ = e31655;
var statearr_31656_31673 = state_31637;
(statearr_31656_31673[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31637);

return cljs.core.constant$keyword$recur;
} else {
throw e31655;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31674 = state_31637;
state_31637 = G__31674;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31637){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31662,out))
})();
var state__11628__auto__ = (function (){var statearr_31657 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31662);

return statearr_31657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31662,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31675 = [];
var len__8976__auto___31678 = arguments.length;
var i__8977__auto___31679 = (0);
while(true){
if((i__8977__auto___31679 < len__8976__auto___31678)){
args31675.push((arguments[i__8977__auto___31679]));

var G__31680 = (i__8977__auto___31679 + (1));
i__8977__auto___31679 = G__31680;
continue;
} else {
}
break;
}

var G__31677 = args31675.length;
switch (G__31677) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31675.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11626__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto__){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto__){
return (function (state_31847){
var state_val_31848 = (state_31847[(1)]);
if((state_val_31848 === (7))){
var inst_31843 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31849_31890 = state_31847__$1;
(statearr_31849_31890[(2)] = inst_31843);

(statearr_31849_31890[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (20))){
var inst_31813 = (state_31847[(7)]);
var inst_31824 = (state_31847[(2)]);
var inst_31825 = cljs.core.next(inst_31813);
var inst_31799 = inst_31825;
var inst_31800 = null;
var inst_31801 = (0);
var inst_31802 = (0);
var state_31847__$1 = (function (){var statearr_31850 = state_31847;
(statearr_31850[(8)] = inst_31802);

(statearr_31850[(9)] = inst_31801);

(statearr_31850[(10)] = inst_31824);

(statearr_31850[(11)] = inst_31800);

(statearr_31850[(12)] = inst_31799);

return statearr_31850;
})();
var statearr_31851_31891 = state_31847__$1;
(statearr_31851_31891[(2)] = null);

(statearr_31851_31891[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (1))){
var state_31847__$1 = state_31847;
var statearr_31852_31892 = state_31847__$1;
(statearr_31852_31892[(2)] = null);

(statearr_31852_31892[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (4))){
var inst_31788 = (state_31847[(13)]);
var inst_31788__$1 = (state_31847[(2)]);
var inst_31789 = (inst_31788__$1 == null);
var state_31847__$1 = (function (){var statearr_31853 = state_31847;
(statearr_31853[(13)] = inst_31788__$1);

return statearr_31853;
})();
if(cljs.core.truth_(inst_31789)){
var statearr_31854_31893 = state_31847__$1;
(statearr_31854_31893[(1)] = (5));

} else {
var statearr_31855_31894 = state_31847__$1;
(statearr_31855_31894[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (15))){
var state_31847__$1 = state_31847;
var statearr_31859_31895 = state_31847__$1;
(statearr_31859_31895[(2)] = null);

(statearr_31859_31895[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (21))){
var state_31847__$1 = state_31847;
var statearr_31860_31896 = state_31847__$1;
(statearr_31860_31896[(2)] = null);

(statearr_31860_31896[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (13))){
var inst_31802 = (state_31847[(8)]);
var inst_31801 = (state_31847[(9)]);
var inst_31800 = (state_31847[(11)]);
var inst_31799 = (state_31847[(12)]);
var inst_31809 = (state_31847[(2)]);
var inst_31810 = (inst_31802 + (1));
var tmp31856 = inst_31801;
var tmp31857 = inst_31800;
var tmp31858 = inst_31799;
var inst_31799__$1 = tmp31858;
var inst_31800__$1 = tmp31857;
var inst_31801__$1 = tmp31856;
var inst_31802__$1 = inst_31810;
var state_31847__$1 = (function (){var statearr_31861 = state_31847;
(statearr_31861[(8)] = inst_31802__$1);

(statearr_31861[(9)] = inst_31801__$1);

(statearr_31861[(14)] = inst_31809);

(statearr_31861[(11)] = inst_31800__$1);

(statearr_31861[(12)] = inst_31799__$1);

return statearr_31861;
})();
var statearr_31862_31897 = state_31847__$1;
(statearr_31862_31897[(2)] = null);

(statearr_31862_31897[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (22))){
var state_31847__$1 = state_31847;
var statearr_31863_31898 = state_31847__$1;
(statearr_31863_31898[(2)] = null);

(statearr_31863_31898[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (6))){
var inst_31788 = (state_31847[(13)]);
var inst_31797 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31788) : f.call(null,inst_31788));
var inst_31798 = cljs.core.seq(inst_31797);
var inst_31799 = inst_31798;
var inst_31800 = null;
var inst_31801 = (0);
var inst_31802 = (0);
var state_31847__$1 = (function (){var statearr_31864 = state_31847;
(statearr_31864[(8)] = inst_31802);

(statearr_31864[(9)] = inst_31801);

(statearr_31864[(11)] = inst_31800);

(statearr_31864[(12)] = inst_31799);

return statearr_31864;
})();
var statearr_31865_31899 = state_31847__$1;
(statearr_31865_31899[(2)] = null);

(statearr_31865_31899[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (17))){
var inst_31813 = (state_31847[(7)]);
var inst_31817 = cljs.core.chunk_first(inst_31813);
var inst_31818 = cljs.core.chunk_rest(inst_31813);
var inst_31819 = cljs.core.count(inst_31817);
var inst_31799 = inst_31818;
var inst_31800 = inst_31817;
var inst_31801 = inst_31819;
var inst_31802 = (0);
var state_31847__$1 = (function (){var statearr_31866 = state_31847;
(statearr_31866[(8)] = inst_31802);

(statearr_31866[(9)] = inst_31801);

(statearr_31866[(11)] = inst_31800);

(statearr_31866[(12)] = inst_31799);

return statearr_31866;
})();
var statearr_31867_31900 = state_31847__$1;
(statearr_31867_31900[(2)] = null);

(statearr_31867_31900[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (3))){
var inst_31845 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31847__$1,inst_31845);
} else {
if((state_val_31848 === (12))){
var inst_31833 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31868_31901 = state_31847__$1;
(statearr_31868_31901[(2)] = inst_31833);

(statearr_31868_31901[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (2))){
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31847__$1,(4),in$);
} else {
if((state_val_31848 === (23))){
var inst_31841 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31869_31902 = state_31847__$1;
(statearr_31869_31902[(2)] = inst_31841);

(statearr_31869_31902[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (19))){
var inst_31828 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31870_31903 = state_31847__$1;
(statearr_31870_31903[(2)] = inst_31828);

(statearr_31870_31903[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (11))){
var inst_31813 = (state_31847[(7)]);
var inst_31799 = (state_31847[(12)]);
var inst_31813__$1 = cljs.core.seq(inst_31799);
var state_31847__$1 = (function (){var statearr_31871 = state_31847;
(statearr_31871[(7)] = inst_31813__$1);

return statearr_31871;
})();
if(inst_31813__$1){
var statearr_31872_31904 = state_31847__$1;
(statearr_31872_31904[(1)] = (14));

} else {
var statearr_31873_31905 = state_31847__$1;
(statearr_31873_31905[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (9))){
var inst_31835 = (state_31847[(2)]);
var inst_31836 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31847__$1 = (function (){var statearr_31874 = state_31847;
(statearr_31874[(15)] = inst_31835);

return statearr_31874;
})();
if(cljs.core.truth_(inst_31836)){
var statearr_31875_31906 = state_31847__$1;
(statearr_31875_31906[(1)] = (21));

} else {
var statearr_31876_31907 = state_31847__$1;
(statearr_31876_31907[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (5))){
var inst_31791 = cljs.core.async.close_BANG_(out);
var state_31847__$1 = state_31847;
var statearr_31877_31908 = state_31847__$1;
(statearr_31877_31908[(2)] = inst_31791);

(statearr_31877_31908[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (14))){
var inst_31813 = (state_31847[(7)]);
var inst_31815 = cljs.core.chunked_seq_QMARK_(inst_31813);
var state_31847__$1 = state_31847;
if(inst_31815){
var statearr_31878_31909 = state_31847__$1;
(statearr_31878_31909[(1)] = (17));

} else {
var statearr_31879_31910 = state_31847__$1;
(statearr_31879_31910[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (16))){
var inst_31831 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31880_31911 = state_31847__$1;
(statearr_31880_31911[(2)] = inst_31831);

(statearr_31880_31911[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31848 === (10))){
var inst_31802 = (state_31847[(8)]);
var inst_31800 = (state_31847[(11)]);
var inst_31807 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31800,inst_31802);
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31847__$1,(13),out,inst_31807);
} else {
if((state_val_31848 === (18))){
var inst_31813 = (state_31847[(7)]);
var inst_31822 = cljs.core.first(inst_31813);
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31847__$1,(20),out,inst_31822);
} else {
if((state_val_31848 === (8))){
var inst_31802 = (state_31847[(8)]);
var inst_31801 = (state_31847[(9)]);
var inst_31804 = (inst_31802 < inst_31801);
var inst_31805 = inst_31804;
var state_31847__$1 = state_31847;
if(cljs.core.truth_(inst_31805)){
var statearr_31881_31912 = state_31847__$1;
(statearr_31881_31912[(1)] = (10));

} else {
var statearr_31882_31913 = state_31847__$1;
(statearr_31882_31913[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto__))
;
return ((function (switch__11561__auto__,c__11626__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____0 = (function (){
var statearr_31886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31886[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__);

(statearr_31886[(1)] = (1));

return statearr_31886;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____1 = (function (state_31847){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31847);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31887){if((e31887 instanceof Object)){
var ex__11565__auto__ = e31887;
var statearr_31888_31914 = state_31847;
(statearr_31888_31914[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31847);

return cljs.core.constant$keyword$recur;
} else {
throw e31887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31915 = state_31847;
state_31847 = G__31915;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__ = function(state_31847){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____1.call(this,state_31847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11562__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto__))
})();
var state__11628__auto__ = (function (){var statearr_31889 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto__);

return statearr_31889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto__))
);

return c__11626__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args31916 = [];
var len__8976__auto___31919 = arguments.length;
var i__8977__auto___31920 = (0);
while(true){
if((i__8977__auto___31920 < len__8976__auto___31919)){
args31916.push((arguments[i__8977__auto___31920]));

var G__31921 = (i__8977__auto___31920 + (1));
i__8977__auto___31920 = G__31921;
continue;
} else {
}
break;
}

var G__31918 = args31916.length;
switch (G__31918) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31916.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args31923 = [];
var len__8976__auto___31926 = arguments.length;
var i__8977__auto___31927 = (0);
while(true){
if((i__8977__auto___31927 < len__8976__auto___31926)){
args31923.push((arguments[i__8977__auto___31927]));

var G__31928 = (i__8977__auto___31927 + (1));
i__8977__auto___31927 = G__31928;
continue;
} else {
}
break;
}

var G__31925 = args31923.length;
switch (G__31925) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31923.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args31930 = [];
var len__8976__auto___31981 = arguments.length;
var i__8977__auto___31982 = (0);
while(true){
if((i__8977__auto___31982 < len__8976__auto___31981)){
args31930.push((arguments[i__8977__auto___31982]));

var G__31983 = (i__8977__auto___31982 + (1));
i__8977__auto___31982 = G__31983;
continue;
} else {
}
break;
}

var G__31932 = args31930.length;
switch (G__31932) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31930.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___31985 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___31985,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___31985,out){
return (function (state_31956){
var state_val_31957 = (state_31956[(1)]);
if((state_val_31957 === (7))){
var inst_31951 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31958_31986 = state_31956__$1;
(statearr_31958_31986[(2)] = inst_31951);

(statearr_31958_31986[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (1))){
var inst_31933 = null;
var state_31956__$1 = (function (){var statearr_31959 = state_31956;
(statearr_31959[(7)] = inst_31933);

return statearr_31959;
})();
var statearr_31960_31987 = state_31956__$1;
(statearr_31960_31987[(2)] = null);

(statearr_31960_31987[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (4))){
var inst_31936 = (state_31956[(8)]);
var inst_31936__$1 = (state_31956[(2)]);
var inst_31937 = (inst_31936__$1 == null);
var inst_31938 = cljs.core.not(inst_31937);
var state_31956__$1 = (function (){var statearr_31961 = state_31956;
(statearr_31961[(8)] = inst_31936__$1);

return statearr_31961;
})();
if(inst_31938){
var statearr_31962_31988 = state_31956__$1;
(statearr_31962_31988[(1)] = (5));

} else {
var statearr_31963_31989 = state_31956__$1;
(statearr_31963_31989[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (6))){
var state_31956__$1 = state_31956;
var statearr_31964_31990 = state_31956__$1;
(statearr_31964_31990[(2)] = null);

(statearr_31964_31990[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (3))){
var inst_31953 = (state_31956[(2)]);
var inst_31954 = cljs.core.async.close_BANG_(out);
var state_31956__$1 = (function (){var statearr_31965 = state_31956;
(statearr_31965[(9)] = inst_31953);

return statearr_31965;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31956__$1,inst_31954);
} else {
if((state_val_31957 === (2))){
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31956__$1,(4),ch);
} else {
if((state_val_31957 === (11))){
var inst_31936 = (state_31956[(8)]);
var inst_31945 = (state_31956[(2)]);
var inst_31933 = inst_31936;
var state_31956__$1 = (function (){var statearr_31966 = state_31956;
(statearr_31966[(10)] = inst_31945);

(statearr_31966[(7)] = inst_31933);

return statearr_31966;
})();
var statearr_31967_31991 = state_31956__$1;
(statearr_31967_31991[(2)] = null);

(statearr_31967_31991[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (9))){
var inst_31936 = (state_31956[(8)]);
var state_31956__$1 = state_31956;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31956__$1,(11),out,inst_31936);
} else {
if((state_val_31957 === (5))){
var inst_31936 = (state_31956[(8)]);
var inst_31933 = (state_31956[(7)]);
var inst_31940 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31936,inst_31933);
var state_31956__$1 = state_31956;
if(inst_31940){
var statearr_31969_31992 = state_31956__$1;
(statearr_31969_31992[(1)] = (8));

} else {
var statearr_31970_31993 = state_31956__$1;
(statearr_31970_31993[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (10))){
var inst_31948 = (state_31956[(2)]);
var state_31956__$1 = state_31956;
var statearr_31971_31994 = state_31956__$1;
(statearr_31971_31994[(2)] = inst_31948);

(statearr_31971_31994[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31957 === (8))){
var inst_31933 = (state_31956[(7)]);
var tmp31968 = inst_31933;
var inst_31933__$1 = tmp31968;
var state_31956__$1 = (function (){var statearr_31972 = state_31956;
(statearr_31972[(7)] = inst_31933__$1);

return statearr_31972;
})();
var statearr_31973_31995 = state_31956__$1;
(statearr_31973_31995[(2)] = null);

(statearr_31973_31995[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___31985,out))
;
return ((function (switch__11561__auto__,c__11626__auto___31985,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_31977 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31977[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_31977[(1)] = (1));

return statearr_31977;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_31956){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_31956);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e31978){if((e31978 instanceof Object)){
var ex__11565__auto__ = e31978;
var statearr_31979_31996 = state_31956;
(statearr_31979_31996[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31956);

return cljs.core.constant$keyword$recur;
} else {
throw e31978;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__31997 = state_31956;
state_31956 = G__31997;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_31956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_31956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___31985,out))
})();
var state__11628__auto__ = (function (){var statearr_31980 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_31980[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___31985);

return statearr_31980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___31985,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args31998 = [];
var len__8976__auto___32068 = arguments.length;
var i__8977__auto___32069 = (0);
while(true){
if((i__8977__auto___32069 < len__8976__auto___32068)){
args31998.push((arguments[i__8977__auto___32069]));

var G__32070 = (i__8977__auto___32069 + (1));
i__8977__auto___32069 = G__32070;
continue;
} else {
}
break;
}

var G__32000 = args31998.length;
switch (G__32000) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31998.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___32072 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___32072,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___32072,out){
return (function (state_32038){
var state_val_32039 = (state_32038[(1)]);
if((state_val_32039 === (7))){
var inst_32034 = (state_32038[(2)]);
var state_32038__$1 = state_32038;
var statearr_32040_32073 = state_32038__$1;
(statearr_32040_32073[(2)] = inst_32034);

(statearr_32040_32073[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (1))){
var inst_32001 = (new Array(n));
var inst_32002 = inst_32001;
var inst_32003 = (0);
var state_32038__$1 = (function (){var statearr_32041 = state_32038;
(statearr_32041[(7)] = inst_32003);

(statearr_32041[(8)] = inst_32002);

return statearr_32041;
})();
var statearr_32042_32074 = state_32038__$1;
(statearr_32042_32074[(2)] = null);

(statearr_32042_32074[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (4))){
var inst_32006 = (state_32038[(9)]);
var inst_32006__$1 = (state_32038[(2)]);
var inst_32007 = (inst_32006__$1 == null);
var inst_32008 = cljs.core.not(inst_32007);
var state_32038__$1 = (function (){var statearr_32043 = state_32038;
(statearr_32043[(9)] = inst_32006__$1);

return statearr_32043;
})();
if(inst_32008){
var statearr_32044_32075 = state_32038__$1;
(statearr_32044_32075[(1)] = (5));

} else {
var statearr_32045_32076 = state_32038__$1;
(statearr_32045_32076[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (15))){
var inst_32028 = (state_32038[(2)]);
var state_32038__$1 = state_32038;
var statearr_32046_32077 = state_32038__$1;
(statearr_32046_32077[(2)] = inst_32028);

(statearr_32046_32077[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (13))){
var state_32038__$1 = state_32038;
var statearr_32047_32078 = state_32038__$1;
(statearr_32047_32078[(2)] = null);

(statearr_32047_32078[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (6))){
var inst_32003 = (state_32038[(7)]);
var inst_32024 = (inst_32003 > (0));
var state_32038__$1 = state_32038;
if(cljs.core.truth_(inst_32024)){
var statearr_32048_32079 = state_32038__$1;
(statearr_32048_32079[(1)] = (12));

} else {
var statearr_32049_32080 = state_32038__$1;
(statearr_32049_32080[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (3))){
var inst_32036 = (state_32038[(2)]);
var state_32038__$1 = state_32038;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32038__$1,inst_32036);
} else {
if((state_val_32039 === (12))){
var inst_32002 = (state_32038[(8)]);
var inst_32026 = cljs.core.vec(inst_32002);
var state_32038__$1 = state_32038;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32038__$1,(15),out,inst_32026);
} else {
if((state_val_32039 === (2))){
var state_32038__$1 = state_32038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32038__$1,(4),ch);
} else {
if((state_val_32039 === (11))){
var inst_32018 = (state_32038[(2)]);
var inst_32019 = (new Array(n));
var inst_32002 = inst_32019;
var inst_32003 = (0);
var state_32038__$1 = (function (){var statearr_32050 = state_32038;
(statearr_32050[(7)] = inst_32003);

(statearr_32050[(10)] = inst_32018);

(statearr_32050[(8)] = inst_32002);

return statearr_32050;
})();
var statearr_32051_32081 = state_32038__$1;
(statearr_32051_32081[(2)] = null);

(statearr_32051_32081[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (9))){
var inst_32002 = (state_32038[(8)]);
var inst_32016 = cljs.core.vec(inst_32002);
var state_32038__$1 = state_32038;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32038__$1,(11),out,inst_32016);
} else {
if((state_val_32039 === (5))){
var inst_32003 = (state_32038[(7)]);
var inst_32011 = (state_32038[(11)]);
var inst_32002 = (state_32038[(8)]);
var inst_32006 = (state_32038[(9)]);
var inst_32010 = (inst_32002[inst_32003] = inst_32006);
var inst_32011__$1 = (inst_32003 + (1));
var inst_32012 = (inst_32011__$1 < n);
var state_32038__$1 = (function (){var statearr_32052 = state_32038;
(statearr_32052[(11)] = inst_32011__$1);

(statearr_32052[(12)] = inst_32010);

return statearr_32052;
})();
if(cljs.core.truth_(inst_32012)){
var statearr_32053_32082 = state_32038__$1;
(statearr_32053_32082[(1)] = (8));

} else {
var statearr_32054_32083 = state_32038__$1;
(statearr_32054_32083[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (14))){
var inst_32031 = (state_32038[(2)]);
var inst_32032 = cljs.core.async.close_BANG_(out);
var state_32038__$1 = (function (){var statearr_32056 = state_32038;
(statearr_32056[(13)] = inst_32031);

return statearr_32056;
})();
var statearr_32057_32084 = state_32038__$1;
(statearr_32057_32084[(2)] = inst_32032);

(statearr_32057_32084[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (10))){
var inst_32022 = (state_32038[(2)]);
var state_32038__$1 = state_32038;
var statearr_32058_32085 = state_32038__$1;
(statearr_32058_32085[(2)] = inst_32022);

(statearr_32058_32085[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32039 === (8))){
var inst_32011 = (state_32038[(11)]);
var inst_32002 = (state_32038[(8)]);
var tmp32055 = inst_32002;
var inst_32002__$1 = tmp32055;
var inst_32003 = inst_32011;
var state_32038__$1 = (function (){var statearr_32059 = state_32038;
(statearr_32059[(7)] = inst_32003);

(statearr_32059[(8)] = inst_32002__$1);

return statearr_32059;
})();
var statearr_32060_32086 = state_32038__$1;
(statearr_32060_32086[(2)] = null);

(statearr_32060_32086[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___32072,out))
;
return ((function (switch__11561__auto__,c__11626__auto___32072,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_32064 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32064[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_32064[(1)] = (1));

return statearr_32064;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_32038){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_32038);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e32065){if((e32065 instanceof Object)){
var ex__11565__auto__ = e32065;
var statearr_32066_32087 = state_32038;
(statearr_32066_32087[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32038);

return cljs.core.constant$keyword$recur;
} else {
throw e32065;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__32088 = state_32038;
state_32038 = G__32088;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_32038){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_32038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___32072,out))
})();
var state__11628__auto__ = (function (){var statearr_32067 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_32067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___32072);

return statearr_32067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___32072,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args32089 = [];
var len__8976__auto___32163 = arguments.length;
var i__8977__auto___32164 = (0);
while(true){
if((i__8977__auto___32164 < len__8976__auto___32163)){
args32089.push((arguments[i__8977__auto___32164]));

var G__32165 = (i__8977__auto___32164 + (1));
i__8977__auto___32164 = G__32165;
continue;
} else {
}
break;
}

var G__32091 = args32089.length;
switch (G__32091) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32089.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11626__auto___32167 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11626__auto___32167,out){
return (function (){
var f__11627__auto__ = (function (){var switch__11561__auto__ = ((function (c__11626__auto___32167,out){
return (function (state_32133){
var state_val_32134 = (state_32133[(1)]);
if((state_val_32134 === (7))){
var inst_32129 = (state_32133[(2)]);
var state_32133__$1 = state_32133;
var statearr_32135_32168 = state_32133__$1;
(statearr_32135_32168[(2)] = inst_32129);

(statearr_32135_32168[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (1))){
var inst_32092 = [];
var inst_32093 = inst_32092;
var inst_32094 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_32133__$1 = (function (){var statearr_32136 = state_32133;
(statearr_32136[(7)] = inst_32094);

(statearr_32136[(8)] = inst_32093);

return statearr_32136;
})();
var statearr_32137_32169 = state_32133__$1;
(statearr_32137_32169[(2)] = null);

(statearr_32137_32169[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (4))){
var inst_32097 = (state_32133[(9)]);
var inst_32097__$1 = (state_32133[(2)]);
var inst_32098 = (inst_32097__$1 == null);
var inst_32099 = cljs.core.not(inst_32098);
var state_32133__$1 = (function (){var statearr_32138 = state_32133;
(statearr_32138[(9)] = inst_32097__$1);

return statearr_32138;
})();
if(inst_32099){
var statearr_32139_32170 = state_32133__$1;
(statearr_32139_32170[(1)] = (5));

} else {
var statearr_32140_32171 = state_32133__$1;
(statearr_32140_32171[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (15))){
var inst_32123 = (state_32133[(2)]);
var state_32133__$1 = state_32133;
var statearr_32141_32172 = state_32133__$1;
(statearr_32141_32172[(2)] = inst_32123);

(statearr_32141_32172[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (13))){
var state_32133__$1 = state_32133;
var statearr_32142_32173 = state_32133__$1;
(statearr_32142_32173[(2)] = null);

(statearr_32142_32173[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (6))){
var inst_32093 = (state_32133[(8)]);
var inst_32118 = inst_32093.length;
var inst_32119 = (inst_32118 > (0));
var state_32133__$1 = state_32133;
if(cljs.core.truth_(inst_32119)){
var statearr_32143_32174 = state_32133__$1;
(statearr_32143_32174[(1)] = (12));

} else {
var statearr_32144_32175 = state_32133__$1;
(statearr_32144_32175[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (3))){
var inst_32131 = (state_32133[(2)]);
var state_32133__$1 = state_32133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32133__$1,inst_32131);
} else {
if((state_val_32134 === (12))){
var inst_32093 = (state_32133[(8)]);
var inst_32121 = cljs.core.vec(inst_32093);
var state_32133__$1 = state_32133;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32133__$1,(15),out,inst_32121);
} else {
if((state_val_32134 === (2))){
var state_32133__$1 = state_32133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32133__$1,(4),ch);
} else {
if((state_val_32134 === (11))){
var inst_32097 = (state_32133[(9)]);
var inst_32101 = (state_32133[(10)]);
var inst_32111 = (state_32133[(2)]);
var inst_32112 = [];
var inst_32113 = inst_32112.push(inst_32097);
var inst_32093 = inst_32112;
var inst_32094 = inst_32101;
var state_32133__$1 = (function (){var statearr_32145 = state_32133;
(statearr_32145[(7)] = inst_32094);

(statearr_32145[(11)] = inst_32113);

(statearr_32145[(12)] = inst_32111);

(statearr_32145[(8)] = inst_32093);

return statearr_32145;
})();
var statearr_32146_32176 = state_32133__$1;
(statearr_32146_32176[(2)] = null);

(statearr_32146_32176[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (9))){
var inst_32093 = (state_32133[(8)]);
var inst_32109 = cljs.core.vec(inst_32093);
var state_32133__$1 = state_32133;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32133__$1,(11),out,inst_32109);
} else {
if((state_val_32134 === (5))){
var inst_32097 = (state_32133[(9)]);
var inst_32094 = (state_32133[(7)]);
var inst_32101 = (state_32133[(10)]);
var inst_32101__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32097) : f.call(null,inst_32097));
var inst_32102 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32101__$1,inst_32094);
var inst_32103 = cljs.core.keyword_identical_QMARK_(inst_32094,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_32104 = (inst_32102) || (inst_32103);
var state_32133__$1 = (function (){var statearr_32147 = state_32133;
(statearr_32147[(10)] = inst_32101__$1);

return statearr_32147;
})();
if(cljs.core.truth_(inst_32104)){
var statearr_32148_32177 = state_32133__$1;
(statearr_32148_32177[(1)] = (8));

} else {
var statearr_32149_32178 = state_32133__$1;
(statearr_32149_32178[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (14))){
var inst_32126 = (state_32133[(2)]);
var inst_32127 = cljs.core.async.close_BANG_(out);
var state_32133__$1 = (function (){var statearr_32151 = state_32133;
(statearr_32151[(13)] = inst_32126);

return statearr_32151;
})();
var statearr_32152_32179 = state_32133__$1;
(statearr_32152_32179[(2)] = inst_32127);

(statearr_32152_32179[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (10))){
var inst_32116 = (state_32133[(2)]);
var state_32133__$1 = state_32133;
var statearr_32153_32180 = state_32133__$1;
(statearr_32153_32180[(2)] = inst_32116);

(statearr_32153_32180[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32134 === (8))){
var inst_32097 = (state_32133[(9)]);
var inst_32101 = (state_32133[(10)]);
var inst_32093 = (state_32133[(8)]);
var inst_32106 = inst_32093.push(inst_32097);
var tmp32150 = inst_32093;
var inst_32093__$1 = tmp32150;
var inst_32094 = inst_32101;
var state_32133__$1 = (function (){var statearr_32154 = state_32133;
(statearr_32154[(14)] = inst_32106);

(statearr_32154[(7)] = inst_32094);

(statearr_32154[(8)] = inst_32093__$1);

return statearr_32154;
})();
var statearr_32155_32181 = state_32133__$1;
(statearr_32155_32181[(2)] = null);

(statearr_32155_32181[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11626__auto___32167,out))
;
return ((function (switch__11561__auto__,c__11626__auto___32167,out){
return (function() {
var cljs$core$async$state_machine__11562__auto__ = null;
var cljs$core$async$state_machine__11562__auto____0 = (function (){
var statearr_32159 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32159[(0)] = cljs$core$async$state_machine__11562__auto__);

(statearr_32159[(1)] = (1));

return statearr_32159;
});
var cljs$core$async$state_machine__11562__auto____1 = (function (state_32133){
while(true){
var ret_value__11563__auto__ = (function (){try{while(true){
var result__11564__auto__ = switch__11561__auto__(state_32133);
if(cljs.core.keyword_identical_QMARK_(result__11564__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11564__auto__;
}
break;
}
}catch (e32160){if((e32160 instanceof Object)){
var ex__11565__auto__ = e32160;
var statearr_32161_32182 = state_32133;
(statearr_32161_32182[(5)] = ex__11565__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32133);

return cljs.core.constant$keyword$recur;
} else {
throw e32160;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11563__auto__,cljs.core.constant$keyword$recur)){
var G__32183 = state_32133;
state_32133 = G__32183;
continue;
} else {
return ret_value__11563__auto__;
}
break;
}
});
cljs$core$async$state_machine__11562__auto__ = function(state_32133){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11562__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11562__auto____1.call(this,state_32133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11562__auto____0;
cljs$core$async$state_machine__11562__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11562__auto____1;
return cljs$core$async$state_machine__11562__auto__;
})()
;})(switch__11561__auto__,c__11626__auto___32167,out))
})();
var state__11628__auto__ = (function (){var statearr_32162 = (f__11627__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11627__auto__.cljs$core$IFn$_invoke$arity$0() : f__11627__auto__.call(null));
(statearr_32162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11626__auto___32167);

return statearr_32162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11628__auto__);
});})(c__11626__auto___32167,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
