// Compiled by ClojureScript 0.0-3308 {:static-fns true, :optimize-constants true}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
goog.require('dommy.attrs');
goog.require('dommy.template');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like(elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like(elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__8182__auto__ = elem.textContent;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like(elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__33555 = arguments.length;
switch (G__33555) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9233__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__33556 = dommy.template.__GT_node_like(parent);
G__33556.appendChild(dommy.template.__GT_node_like(child));

return G__33556;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__33557_33562 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__33558_33563 = null;
var count__33559_33564 = (0);
var i__33560_33565 = (0);
while(true){
if((i__33560_33565 < count__33559_33564)){
var c_33566 = chunk__33558_33563.cljs$core$IIndexed$_nth$arity$2(null,i__33560_33565);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_33566);

var G__33567 = seq__33557_33562;
var G__33568 = chunk__33558_33563;
var G__33569 = count__33559_33564;
var G__33570 = (i__33560_33565 + (1));
seq__33557_33562 = G__33567;
chunk__33558_33563 = G__33568;
count__33559_33564 = G__33569;
i__33560_33565 = G__33570;
continue;
} else {
var temp__4425__auto___33571 = cljs.core.seq(seq__33557_33562);
if(temp__4425__auto___33571){
var seq__33557_33572__$1 = temp__4425__auto___33571;
if(cljs.core.chunked_seq_QMARK_(seq__33557_33572__$1)){
var c__8967__auto___33573 = cljs.core.chunk_first(seq__33557_33572__$1);
var G__33574 = cljs.core.chunk_rest(seq__33557_33572__$1);
var G__33575 = c__8967__auto___33573;
var G__33576 = cljs.core.count(c__8967__auto___33573);
var G__33577 = (0);
seq__33557_33562 = G__33574;
chunk__33558_33563 = G__33575;
count__33559_33564 = G__33576;
i__33560_33565 = G__33577;
continue;
} else {
var c_33578 = cljs.core.first(seq__33557_33572__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_33578);

var G__33579 = cljs.core.next(seq__33557_33572__$1);
var G__33580 = null;
var G__33581 = (0);
var G__33582 = (0);
seq__33557_33562 = G__33579;
chunk__33558_33563 = G__33580;
count__33559_33564 = G__33581;
i__33560_33565 = G__33582;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq33551){
var G__33552 = cljs.core.first(seq33551);
var seq33551__$1 = cljs.core.next(seq33551);
var G__33553 = cljs.core.first(seq33551__$1);
var seq33551__$2 = cljs.core.next(seq33551__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33552,G__33553,seq33551__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__33587 = arguments.length;
switch (G__33587) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9233__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9233__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like(parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like(child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__33588_33593 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__33589_33594 = null;
var count__33590_33595 = (0);
var i__33591_33596 = (0);
while(true){
if((i__33591_33596 < count__33590_33595)){
var c_33597 = chunk__33589_33594.cljs$core$IIndexed$_nth$arity$2(null,i__33591_33596);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_33597);

var G__33598 = seq__33588_33593;
var G__33599 = chunk__33589_33594;
var G__33600 = count__33590_33595;
var G__33601 = (i__33591_33596 + (1));
seq__33588_33593 = G__33598;
chunk__33589_33594 = G__33599;
count__33590_33595 = G__33600;
i__33591_33596 = G__33601;
continue;
} else {
var temp__4425__auto___33602 = cljs.core.seq(seq__33588_33593);
if(temp__4425__auto___33602){
var seq__33588_33603__$1 = temp__4425__auto___33602;
if(cljs.core.chunked_seq_QMARK_(seq__33588_33603__$1)){
var c__8967__auto___33604 = cljs.core.chunk_first(seq__33588_33603__$1);
var G__33605 = cljs.core.chunk_rest(seq__33588_33603__$1);
var G__33606 = c__8967__auto___33604;
var G__33607 = cljs.core.count(c__8967__auto___33604);
var G__33608 = (0);
seq__33588_33593 = G__33605;
chunk__33589_33594 = G__33606;
count__33590_33595 = G__33607;
i__33591_33596 = G__33608;
continue;
} else {
var c_33609 = cljs.core.first(seq__33588_33603__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_33609);

var G__33610 = cljs.core.next(seq__33588_33603__$1);
var G__33611 = null;
var G__33612 = (0);
var G__33613 = (0);
seq__33588_33593 = G__33610;
chunk__33589_33594 = G__33611;
count__33590_33595 = G__33612;
i__33591_33596 = G__33613;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq33583){
var G__33584 = cljs.core.first(seq33583);
var seq33583__$1 = cljs.core.next(seq33583);
var G__33585 = cljs.core.first(seq33583__$1);
var seq33583__$2 = cljs.core.next(seq33583__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33584,G__33585,seq33583__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))], 0)))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
var parent = other__$1.parentNode;
var temp__4423__auto___33614 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4423__auto___33614)){
var next_33615 = temp__4423__auto___33614;
parent.insertBefore(actual_node,next_33615);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like(new$);
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))], 0)))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__33617 = dommy.template.__GT_node_like(parent);
G__33617.innerHTML = "";

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(G__33617,node_like);

return G__33617;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
var G__33619 = elem__$1.parentNode;
G__33619.removeChild(elem__$1);

return G__33619;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like(elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like(template);
if(!(cljs.core.contains_QMARK_(key_selectors_map,cljs.core.constant$keyword$container))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),cljs.core.constant$keyword$container))], 0)))].join('')));
}

return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$container,container], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (container){
return (function (p__33625){
var vec__33626 = p__33625;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33626,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33626,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(cljs.core.constant$keyword$live.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))?(function (){
if(typeof dommy.core.t33627 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t33627 = (function (selector_map,template,key_selectors_map,container,p__33625,vec__33626,k,v,meta33628){
this.selector_map = selector_map;
this.template = template;
this.key_selectors_map = key_selectors_map;
this.container = container;
this.p__33625 = p__33625;
this.vec__33626 = vec__33626;
this.k = k;
this.v = v;
this.meta33628 = meta33628;
this.cljs$lang$protocol_mask$partition0$ = 425984;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
dommy.core.t33627.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__33626,k,v,container){
return (function (_33629,meta33628__$1){
var self__ = this;
var _33629__$1 = this;
return (new dommy.core.t33627(self__.selector_map,self__.template,self__.key_selectors_map,self__.container,self__.p__33625,self__.vec__33626,self__.k,self__.v,meta33628__$1));
});})(vec__33626,k,v,container))
;

dommy.core.t33627.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__33626,k,v,container){
return (function (_33629){
var self__ = this;
var _33629__$1 = this;
return self__.meta33628;
});})(vec__33626,k,v,container))
;

dommy.core.t33627.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__33626,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array(dommy.template.__GT_node_like(self__.container).querySelectorAll(dommy.core.selector(self__.v)));
});})(vec__33626,k,v,container))
;

dommy.core.t33627.getBasis = ((function (vec__33626,k,v,container){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"selector-map","selector-map",808601327,null),new cljs.core.Symbol(null,"template","template",938125843,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),new cljs.core.Symbol(null,"container","container",-96406180,null),new cljs.core.Symbol(null,"p__33625","p__33625",1705084749,null),new cljs.core.Symbol(null,"vec__33626","vec__33626",-1855278008,null),new cljs.core.Symbol(null,"k","k",-505765866,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta33628","meta33628",-1004542663,null)], null);
});})(vec__33626,k,v,container))
;

dommy.core.t33627.cljs$lang$type = true;

dommy.core.t33627.cljs$lang$ctorStr = "dommy.core/t33627";

dommy.core.t33627.cljs$lang$ctorPrWriter = ((function (vec__33626,k,v,container){
return (function (this__8761__auto__,writer__8762__auto__,opt__8763__auto__){
return cljs.core._write(writer__8762__auto__,"dommy.core/t33627");
});})(vec__33626,k,v,container))
;

dommy.core.__GT_t33627 = ((function (vec__33626,k,v,container){
return (function dommy$core$selector_map_$___GT_t33627(selector_map__$1,template__$1,key_selectors_map__$1,container__$1,p__33625__$1,vec__33626__$1,k__$1,v__$1,meta33628){
return (new dommy.core.t33627(selector_map__$1,template__$1,key_selectors_map__$1,container__$1,p__33625__$1,vec__33626__$1,k__$1,v__$1,meta33628));
});})(vec__33626,k,v,container))
;

}

return (new dommy.core.t33627(dommy$core$selector_map,template,key_selectors_map,container,p__33625,vec__33626,k,v,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like(container).querySelector(dommy.core.selector(v)))], null);
});})(container))
,key_selectors_map))], 0));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate((function (p1__33630_SHARP_){
return p1__33630_SHARP_.parentNode;
}),dommy.template.__GT_node_like(elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__33632 = arguments.length;
switch (G__33632) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(dommy.template.__GT_node_like(dommy.template.__GT_node_like(base)).querySelectorAll(dommy.core.selector(selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__33636 = arguments.length;
switch (G__33636) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like(base);
var elem__$1 = dommy.template.__GT_node_like(elem);
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base__$1,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (base__$1,elem__$1){
return (function (p1__33634_SHARP_){
return !((p1__33634_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes(elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1(selector),dommy.core.ancestor_nodes(dommy.template.__GT_node_like(elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like(descendant);
var ancestor__$1 = dommy.template.__GT_node_like(ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__33638){
var vec__33639 = p__33638;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33639,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33639,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__33639,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__33639,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__8182__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__8170__auto__ = related_target;
if(cljs.core.truth_(and__8170__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__8170__auto__;
}
})())){
return null;
} else {
var G__33640 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33640) : f.call(null,G__33640));
}
});
;})(vec__33639,special_mouse_event,real_mouse_event))
});})(vec__33639,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$mouseenter,cljs.core.constant$keyword$mouseover,cljs.core.constant$keyword$mouseleave,cljs.core.constant$keyword$mouseout], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),event.target,selector);
if(cljs.core.truth_((function (){var and__8170__auto__ = selected_target;
if(cljs.core.truth_(and__8170__auto__)){
return cljs.core.not((function (){var G__33644 = selected_target;
var G__33645 = cljs.core.constant$keyword$disabled;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__33644,G__33645) : dommy.core.attr.call(null,G__33644,G__33645));
})());
} else {
return and__8170__auto__;
}
})())){
event.selectedTarget = selected_target;

var G__33646 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33646) : f.call(null,G__33646));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__8182__auto__ = dommy.template.__GT_node_like(elem).dommyEventListeners;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__9222__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9222__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like(elem);
return elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq33647){
var G__33648 = cljs.core.first(seq33647);
var seq33647__$1 = cljs.core.next(seq33647);
var G__33649 = cljs.core.first(seq33647__$1);
var seq33647__$2 = cljs.core.next(seq33647__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33648,G__33649,seq33647__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((function (p1__33650_SHARP_){
return dommy.template.__GT_node_like(cljs.core.first(p1__33650_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like(elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__33653_33680 = dommy.core.elem_and_selector(elem_sel);
var elem_33681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33653_33680,(0),null);
var selector_33682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33653_33680,(1),null);
var seq__33654_33683 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__33661_33684 = null;
var count__33662_33685 = (0);
var i__33663_33686 = (0);
while(true){
if((i__33663_33686 < count__33662_33685)){
var vec__33670_33687 = chunk__33661_33684.cljs$core$IIndexed$_nth$arity$2(null,i__33663_33686);
var orig_type_33688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33670_33687,(0),null);
var f_33689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33670_33687,(1),null);
var seq__33664_33690 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_33688,new cljs.core.PersistentArrayMap.fromArray([orig_type_33688,cljs.core.identity], true, false)));
var chunk__33666_33691 = null;
var count__33667_33692 = (0);
var i__33668_33693 = (0);
while(true){
if((i__33668_33693 < count__33667_33692)){
var vec__33671_33694 = chunk__33666_33691.cljs$core$IIndexed$_nth$arity$2(null,i__33668_33693);
var actual_type_33695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33671_33694,(0),null);
var factory_33696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33671_33694,(1),null);
var canonical_f_33697 = (cljs.core.truth_(selector_33682)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_33681,selector_33682):cljs.core.identity).call(null,(function (){var G__33672 = f_33689;
return (factory_33696.cljs$core$IFn$_invoke$arity$1 ? factory_33696.cljs$core$IFn$_invoke$arity$1(G__33672) : factory_33696.call(null,G__33672));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33681,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33682,actual_type_33695,f_33689], null),canonical_f_33697], 0));

if(cljs.core.truth_(elem_33681.addEventListener)){
elem_33681.addEventListener(cljs.core.name(actual_type_33695),canonical_f_33697);
} else {
elem_33681.attachEvent(cljs.core.name(actual_type_33695),canonical_f_33697);
}

var G__33698 = seq__33664_33690;
var G__33699 = chunk__33666_33691;
var G__33700 = count__33667_33692;
var G__33701 = (i__33668_33693 + (1));
seq__33664_33690 = G__33698;
chunk__33666_33691 = G__33699;
count__33667_33692 = G__33700;
i__33668_33693 = G__33701;
continue;
} else {
var temp__4425__auto___33702 = cljs.core.seq(seq__33664_33690);
if(temp__4425__auto___33702){
var seq__33664_33703__$1 = temp__4425__auto___33702;
if(cljs.core.chunked_seq_QMARK_(seq__33664_33703__$1)){
var c__8967__auto___33704 = cljs.core.chunk_first(seq__33664_33703__$1);
var G__33705 = cljs.core.chunk_rest(seq__33664_33703__$1);
var G__33706 = c__8967__auto___33704;
var G__33707 = cljs.core.count(c__8967__auto___33704);
var G__33708 = (0);
seq__33664_33690 = G__33705;
chunk__33666_33691 = G__33706;
count__33667_33692 = G__33707;
i__33668_33693 = G__33708;
continue;
} else {
var vec__33673_33709 = cljs.core.first(seq__33664_33703__$1);
var actual_type_33710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33673_33709,(0),null);
var factory_33711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33673_33709,(1),null);
var canonical_f_33712 = (cljs.core.truth_(selector_33682)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_33681,selector_33682):cljs.core.identity).call(null,(function (){var G__33674 = f_33689;
return (factory_33711.cljs$core$IFn$_invoke$arity$1 ? factory_33711.cljs$core$IFn$_invoke$arity$1(G__33674) : factory_33711.call(null,G__33674));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33681,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33682,actual_type_33710,f_33689], null),canonical_f_33712], 0));

if(cljs.core.truth_(elem_33681.addEventListener)){
elem_33681.addEventListener(cljs.core.name(actual_type_33710),canonical_f_33712);
} else {
elem_33681.attachEvent(cljs.core.name(actual_type_33710),canonical_f_33712);
}

var G__33713 = cljs.core.next(seq__33664_33703__$1);
var G__33714 = null;
var G__33715 = (0);
var G__33716 = (0);
seq__33664_33690 = G__33713;
chunk__33666_33691 = G__33714;
count__33667_33692 = G__33715;
i__33668_33693 = G__33716;
continue;
}
} else {
}
}
break;
}

var G__33717 = seq__33654_33683;
var G__33718 = chunk__33661_33684;
var G__33719 = count__33662_33685;
var G__33720 = (i__33663_33686 + (1));
seq__33654_33683 = G__33717;
chunk__33661_33684 = G__33718;
count__33662_33685 = G__33719;
i__33663_33686 = G__33720;
continue;
} else {
var temp__4425__auto___33721 = cljs.core.seq(seq__33654_33683);
if(temp__4425__auto___33721){
var seq__33654_33722__$1 = temp__4425__auto___33721;
if(cljs.core.chunked_seq_QMARK_(seq__33654_33722__$1)){
var c__8967__auto___33723 = cljs.core.chunk_first(seq__33654_33722__$1);
var G__33724 = cljs.core.chunk_rest(seq__33654_33722__$1);
var G__33725 = c__8967__auto___33723;
var G__33726 = cljs.core.count(c__8967__auto___33723);
var G__33727 = (0);
seq__33654_33683 = G__33724;
chunk__33661_33684 = G__33725;
count__33662_33685 = G__33726;
i__33663_33686 = G__33727;
continue;
} else {
var vec__33675_33728 = cljs.core.first(seq__33654_33722__$1);
var orig_type_33729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33675_33728,(0),null);
var f_33730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33675_33728,(1),null);
var seq__33655_33731 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_33729,new cljs.core.PersistentArrayMap.fromArray([orig_type_33729,cljs.core.identity], true, false)));
var chunk__33657_33732 = null;
var count__33658_33733 = (0);
var i__33659_33734 = (0);
while(true){
if((i__33659_33734 < count__33658_33733)){
var vec__33676_33735 = chunk__33657_33732.cljs$core$IIndexed$_nth$arity$2(null,i__33659_33734);
var actual_type_33736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33676_33735,(0),null);
var factory_33737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33676_33735,(1),null);
var canonical_f_33738 = (cljs.core.truth_(selector_33682)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_33681,selector_33682):cljs.core.identity).call(null,(function (){var G__33677 = f_33730;
return (factory_33737.cljs$core$IFn$_invoke$arity$1 ? factory_33737.cljs$core$IFn$_invoke$arity$1(G__33677) : factory_33737.call(null,G__33677));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33681,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33682,actual_type_33736,f_33730], null),canonical_f_33738], 0));

if(cljs.core.truth_(elem_33681.addEventListener)){
elem_33681.addEventListener(cljs.core.name(actual_type_33736),canonical_f_33738);
} else {
elem_33681.attachEvent(cljs.core.name(actual_type_33736),canonical_f_33738);
}

var G__33739 = seq__33655_33731;
var G__33740 = chunk__33657_33732;
var G__33741 = count__33658_33733;
var G__33742 = (i__33659_33734 + (1));
seq__33655_33731 = G__33739;
chunk__33657_33732 = G__33740;
count__33658_33733 = G__33741;
i__33659_33734 = G__33742;
continue;
} else {
var temp__4425__auto___33743__$1 = cljs.core.seq(seq__33655_33731);
if(temp__4425__auto___33743__$1){
var seq__33655_33744__$1 = temp__4425__auto___33743__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33655_33744__$1)){
var c__8967__auto___33745 = cljs.core.chunk_first(seq__33655_33744__$1);
var G__33746 = cljs.core.chunk_rest(seq__33655_33744__$1);
var G__33747 = c__8967__auto___33745;
var G__33748 = cljs.core.count(c__8967__auto___33745);
var G__33749 = (0);
seq__33655_33731 = G__33746;
chunk__33657_33732 = G__33747;
count__33658_33733 = G__33748;
i__33659_33734 = G__33749;
continue;
} else {
var vec__33678_33750 = cljs.core.first(seq__33655_33744__$1);
var actual_type_33751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33678_33750,(0),null);
var factory_33752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33678_33750,(1),null);
var canonical_f_33753 = (cljs.core.truth_(selector_33682)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_33681,selector_33682):cljs.core.identity).call(null,(function (){var G__33679 = f_33730;
return (factory_33752.cljs$core$IFn$_invoke$arity$1 ? factory_33752.cljs$core$IFn$_invoke$arity$1(G__33679) : factory_33752.call(null,G__33679));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33681,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33682,actual_type_33751,f_33730], null),canonical_f_33753], 0));

if(cljs.core.truth_(elem_33681.addEventListener)){
elem_33681.addEventListener(cljs.core.name(actual_type_33751),canonical_f_33753);
} else {
elem_33681.attachEvent(cljs.core.name(actual_type_33751),canonical_f_33753);
}

var G__33754 = cljs.core.next(seq__33655_33744__$1);
var G__33755 = null;
var G__33756 = (0);
var G__33757 = (0);
seq__33655_33731 = G__33754;
chunk__33657_33732 = G__33755;
count__33658_33733 = G__33756;
i__33659_33734 = G__33757;
continue;
}
} else {
}
}
break;
}

var G__33758 = cljs.core.next(seq__33654_33722__$1);
var G__33759 = null;
var G__33760 = (0);
var G__33761 = (0);
seq__33654_33683 = G__33758;
chunk__33661_33684 = G__33759;
count__33662_33685 = G__33760;
i__33663_33686 = G__33761;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq33651){
var G__33652 = cljs.core.first(seq33651);
var seq33651__$1 = cljs.core.next(seq33651);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33652,seq33651__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__33764_33787 = dommy.core.elem_and_selector(elem_sel);
var elem_33788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33764_33787,(0),null);
var selector_33789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33764_33787,(1),null);
var seq__33765_33790 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__33772_33791 = null;
var count__33773_33792 = (0);
var i__33774_33793 = (0);
while(true){
if((i__33774_33793 < count__33773_33792)){
var vec__33781_33794 = chunk__33772_33791.cljs$core$IIndexed$_nth$arity$2(null,i__33774_33793);
var orig_type_33795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33781_33794,(0),null);
var f_33796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33781_33794,(1),null);
var seq__33775_33797 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_33795,new cljs.core.PersistentArrayMap.fromArray([orig_type_33795,cljs.core.identity], true, false)));
var chunk__33777_33798 = null;
var count__33778_33799 = (0);
var i__33779_33800 = (0);
while(true){
if((i__33779_33800 < count__33778_33799)){
var vec__33782_33801 = chunk__33777_33798.cljs$core$IIndexed$_nth$arity$2(null,i__33779_33800);
var actual_type_33802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33782_33801,(0),null);
var __33803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33782_33801,(1),null);
var keys_33804 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33789,actual_type_33802,f_33796], null);
var canonical_f_33805 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_33788),keys_33804);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33788,dommy.utils.dissoc_in,cljs.core.array_seq([keys_33804], 0));

if(cljs.core.truth_(elem_33788.removeEventListener)){
elem_33788.removeEventListener(cljs.core.name(actual_type_33802),canonical_f_33805);
} else {
elem_33788.detachEvent(cljs.core.name(actual_type_33802),canonical_f_33805);
}

var G__33806 = seq__33775_33797;
var G__33807 = chunk__33777_33798;
var G__33808 = count__33778_33799;
var G__33809 = (i__33779_33800 + (1));
seq__33775_33797 = G__33806;
chunk__33777_33798 = G__33807;
count__33778_33799 = G__33808;
i__33779_33800 = G__33809;
continue;
} else {
var temp__4425__auto___33810 = cljs.core.seq(seq__33775_33797);
if(temp__4425__auto___33810){
var seq__33775_33811__$1 = temp__4425__auto___33810;
if(cljs.core.chunked_seq_QMARK_(seq__33775_33811__$1)){
var c__8967__auto___33812 = cljs.core.chunk_first(seq__33775_33811__$1);
var G__33813 = cljs.core.chunk_rest(seq__33775_33811__$1);
var G__33814 = c__8967__auto___33812;
var G__33815 = cljs.core.count(c__8967__auto___33812);
var G__33816 = (0);
seq__33775_33797 = G__33813;
chunk__33777_33798 = G__33814;
count__33778_33799 = G__33815;
i__33779_33800 = G__33816;
continue;
} else {
var vec__33783_33817 = cljs.core.first(seq__33775_33811__$1);
var actual_type_33818 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33783_33817,(0),null);
var __33819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33783_33817,(1),null);
var keys_33820 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33789,actual_type_33818,f_33796], null);
var canonical_f_33821 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_33788),keys_33820);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33788,dommy.utils.dissoc_in,cljs.core.array_seq([keys_33820], 0));

if(cljs.core.truth_(elem_33788.removeEventListener)){
elem_33788.removeEventListener(cljs.core.name(actual_type_33818),canonical_f_33821);
} else {
elem_33788.detachEvent(cljs.core.name(actual_type_33818),canonical_f_33821);
}

var G__33822 = cljs.core.next(seq__33775_33811__$1);
var G__33823 = null;
var G__33824 = (0);
var G__33825 = (0);
seq__33775_33797 = G__33822;
chunk__33777_33798 = G__33823;
count__33778_33799 = G__33824;
i__33779_33800 = G__33825;
continue;
}
} else {
}
}
break;
}

var G__33826 = seq__33765_33790;
var G__33827 = chunk__33772_33791;
var G__33828 = count__33773_33792;
var G__33829 = (i__33774_33793 + (1));
seq__33765_33790 = G__33826;
chunk__33772_33791 = G__33827;
count__33773_33792 = G__33828;
i__33774_33793 = G__33829;
continue;
} else {
var temp__4425__auto___33830 = cljs.core.seq(seq__33765_33790);
if(temp__4425__auto___33830){
var seq__33765_33831__$1 = temp__4425__auto___33830;
if(cljs.core.chunked_seq_QMARK_(seq__33765_33831__$1)){
var c__8967__auto___33832 = cljs.core.chunk_first(seq__33765_33831__$1);
var G__33833 = cljs.core.chunk_rest(seq__33765_33831__$1);
var G__33834 = c__8967__auto___33832;
var G__33835 = cljs.core.count(c__8967__auto___33832);
var G__33836 = (0);
seq__33765_33790 = G__33833;
chunk__33772_33791 = G__33834;
count__33773_33792 = G__33835;
i__33774_33793 = G__33836;
continue;
} else {
var vec__33784_33837 = cljs.core.first(seq__33765_33831__$1);
var orig_type_33838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33784_33837,(0),null);
var f_33839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33784_33837,(1),null);
var seq__33766_33840 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_33838,new cljs.core.PersistentArrayMap.fromArray([orig_type_33838,cljs.core.identity], true, false)));
var chunk__33768_33841 = null;
var count__33769_33842 = (0);
var i__33770_33843 = (0);
while(true){
if((i__33770_33843 < count__33769_33842)){
var vec__33785_33844 = chunk__33768_33841.cljs$core$IIndexed$_nth$arity$2(null,i__33770_33843);
var actual_type_33845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33785_33844,(0),null);
var __33846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33785_33844,(1),null);
var keys_33847 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33789,actual_type_33845,f_33839], null);
var canonical_f_33848 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_33788),keys_33847);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33788,dommy.utils.dissoc_in,cljs.core.array_seq([keys_33847], 0));

if(cljs.core.truth_(elem_33788.removeEventListener)){
elem_33788.removeEventListener(cljs.core.name(actual_type_33845),canonical_f_33848);
} else {
elem_33788.detachEvent(cljs.core.name(actual_type_33845),canonical_f_33848);
}

var G__33849 = seq__33766_33840;
var G__33850 = chunk__33768_33841;
var G__33851 = count__33769_33842;
var G__33852 = (i__33770_33843 + (1));
seq__33766_33840 = G__33849;
chunk__33768_33841 = G__33850;
count__33769_33842 = G__33851;
i__33770_33843 = G__33852;
continue;
} else {
var temp__4425__auto___33853__$1 = cljs.core.seq(seq__33766_33840);
if(temp__4425__auto___33853__$1){
var seq__33766_33854__$1 = temp__4425__auto___33853__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33766_33854__$1)){
var c__8967__auto___33855 = cljs.core.chunk_first(seq__33766_33854__$1);
var G__33856 = cljs.core.chunk_rest(seq__33766_33854__$1);
var G__33857 = c__8967__auto___33855;
var G__33858 = cljs.core.count(c__8967__auto___33855);
var G__33859 = (0);
seq__33766_33840 = G__33856;
chunk__33768_33841 = G__33857;
count__33769_33842 = G__33858;
i__33770_33843 = G__33859;
continue;
} else {
var vec__33786_33860 = cljs.core.first(seq__33766_33854__$1);
var actual_type_33861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33786_33860,(0),null);
var __33862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33786_33860,(1),null);
var keys_33863 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_33789,actual_type_33861,f_33839], null);
var canonical_f_33864 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_33788),keys_33863);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_33788,dommy.utils.dissoc_in,cljs.core.array_seq([keys_33863], 0));

if(cljs.core.truth_(elem_33788.removeEventListener)){
elem_33788.removeEventListener(cljs.core.name(actual_type_33861),canonical_f_33864);
} else {
elem_33788.detachEvent(cljs.core.name(actual_type_33861),canonical_f_33864);
}

var G__33865 = cljs.core.next(seq__33766_33854__$1);
var G__33866 = null;
var G__33867 = (0);
var G__33868 = (0);
seq__33766_33840 = G__33865;
chunk__33768_33841 = G__33866;
count__33769_33842 = G__33867;
i__33770_33843 = G__33868;
continue;
}
} else {
}
}
break;
}

var G__33869 = cljs.core.next(seq__33765_33831__$1);
var G__33870 = null;
var G__33871 = (0);
var G__33872 = (0);
seq__33765_33790 = G__33869;
chunk__33772_33791 = G__33870;
count__33773_33792 = G__33871;
i__33774_33793 = G__33872;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq33762){
var G__33763 = cljs.core.first(seq33762);
var seq33762__$1 = cljs.core.next(seq33762);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33763,seq33762__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__9222__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9222__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__33875_33886 = dommy.core.elem_and_selector(elem_sel);
var elem_33887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33875_33886,(0),null);
var selector_33888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33875_33886,(1),null);
var seq__33876_33889 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__33877_33890 = null;
var count__33878_33891 = (0);
var i__33879_33892 = (0);
while(true){
if((i__33879_33892 < count__33878_33891)){
var vec__33880_33893 = chunk__33877_33890.cljs$core$IIndexed$_nth$arity$2(null,i__33879_33892);
var type_33894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33880_33893,(0),null);
var f_33895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33880_33893,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_33894,((function (seq__33876_33889,chunk__33877_33890,count__33878_33891,i__33879_33892,vec__33880_33893,type_33894,f_33895,vec__33875_33886,elem_33887,selector_33888){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_33894,dommy$core$this_fn], 0));

var G__33882 = e;
return (f_33895.cljs$core$IFn$_invoke$arity$1 ? f_33895.cljs$core$IFn$_invoke$arity$1(G__33882) : f_33895.call(null,G__33882));
});})(seq__33876_33889,chunk__33877_33890,count__33878_33891,i__33879_33892,vec__33880_33893,type_33894,f_33895,vec__33875_33886,elem_33887,selector_33888))
], 0));

var G__33896 = seq__33876_33889;
var G__33897 = chunk__33877_33890;
var G__33898 = count__33878_33891;
var G__33899 = (i__33879_33892 + (1));
seq__33876_33889 = G__33896;
chunk__33877_33890 = G__33897;
count__33878_33891 = G__33898;
i__33879_33892 = G__33899;
continue;
} else {
var temp__4425__auto___33900 = cljs.core.seq(seq__33876_33889);
if(temp__4425__auto___33900){
var seq__33876_33901__$1 = temp__4425__auto___33900;
if(cljs.core.chunked_seq_QMARK_(seq__33876_33901__$1)){
var c__8967__auto___33902 = cljs.core.chunk_first(seq__33876_33901__$1);
var G__33903 = cljs.core.chunk_rest(seq__33876_33901__$1);
var G__33904 = c__8967__auto___33902;
var G__33905 = cljs.core.count(c__8967__auto___33902);
var G__33906 = (0);
seq__33876_33889 = G__33903;
chunk__33877_33890 = G__33904;
count__33878_33891 = G__33905;
i__33879_33892 = G__33906;
continue;
} else {
var vec__33883_33907 = cljs.core.first(seq__33876_33901__$1);
var type_33908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33883_33907,(0),null);
var f_33909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33883_33907,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_33908,((function (seq__33876_33889,chunk__33877_33890,count__33878_33891,i__33879_33892,vec__33883_33907,type_33908,f_33909,seq__33876_33901__$1,temp__4425__auto___33900,vec__33875_33886,elem_33887,selector_33888){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_33908,dommy$core$this_fn], 0));

var G__33885 = e;
return (f_33909.cljs$core$IFn$_invoke$arity$1 ? f_33909.cljs$core$IFn$_invoke$arity$1(G__33885) : f_33909.call(null,G__33885));
});})(seq__33876_33889,chunk__33877_33890,count__33878_33891,i__33879_33892,vec__33883_33907,type_33908,f_33909,seq__33876_33901__$1,temp__4425__auto___33900,vec__33875_33886,elem_33887,selector_33888))
], 0));

var G__33910 = cljs.core.next(seq__33876_33901__$1);
var G__33911 = null;
var G__33912 = (0);
var G__33913 = (0);
seq__33876_33889 = G__33910;
chunk__33877_33890 = G__33911;
count__33878_33891 = G__33912;
i__33879_33892 = G__33913;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq33873){
var G__33874 = cljs.core.first(seq33873);
var seq33873__$1 = cljs.core.next(seq33873);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33874,seq33873__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__9222__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9222__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__33917){
var vec__33918 = p__33917;
var update_event_BANG_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33918,(0),null);
if(dommy.core.descendant_QMARK_(node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))], 0)))].join('')));
}

var update_event_BANG___$1 = (function (){var or__8182__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__8182__auto__)){
return or__8182__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name(event_type),true,true);

return node.dispatchEvent((function (){var G__33919 = event;
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__33919) : update_event_BANG___$1.call(null,G__33919));
})());
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name(event_type))].join(''),(function (){var G__33920 = document.createEventObject();
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__33920) : update_event_BANG___$1.call(null,G__33920));
})());
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq33914){
var G__33915 = cljs.core.first(seq33914);
var seq33914__$1 = cljs.core.next(seq33914);
var G__33916 = cljs.core.first(seq33914__$1);
var seq33914__$2 = cljs.core.next(seq33914__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33915,G__33916,seq33914__$2);
});
