// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29569 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29569 = (function (fn_handler,f,meta29570){
this.fn_handler = fn_handler;
this.f = f;
this.meta29570 = meta29570;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29569.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29571,meta29570__$1){
var self__ = this;
var _29571__$1 = this;
return (new cljs.core.async.t29569(self__.fn_handler,self__.f,meta29570__$1));
});

cljs.core.async.t29569.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29571){
var self__ = this;
var _29571__$1 = this;
return self__.meta29570;
});

cljs.core.async.t29569.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29569.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29569.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29569.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29570","meta29570",-411959432,null)], null);
});

cljs.core.async.t29569.cljs$lang$type = true;

cljs.core.async.t29569.cljs$lang$ctorStr = "cljs.core.async/t29569";

cljs.core.async.t29569.cljs$lang$ctorPrWriter = (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t29569");
});

cljs.core.async.__GT_t29569 = (function cljs$core$async$fn_handler_$___GT_t29569(fn_handler__$1,f__$1,meta29570){
return (new cljs.core.async.t29569(fn_handler__$1,f__$1,meta29570));
});

}

return (new cljs.core.async.t29569(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29574 = [];
var len__9081__auto___29577 = arguments.length;
var i__9082__auto___29578 = (0);
while(true){
if((i__9082__auto___29578 < len__9081__auto___29577)){
args29574.push((arguments[i__9082__auto___29578]));

var G__29579 = (i__9082__auto___29578 + (1));
i__9082__auto___29578 = G__29579;
continue;
} else {
}
break;
}

var G__29576 = args29574.length;
switch (G__29576) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29574.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29581 = [];
var len__9081__auto___29584 = arguments.length;
var i__9082__auto___29585 = (0);
while(true){
if((i__9082__auto___29585 < len__9081__auto___29584)){
args29581.push((arguments[i__9082__auto___29585]));

var G__29586 = (i__9082__auto___29585 + (1));
i__9082__auto___29585 = G__29586;
continue;
} else {
}
break;
}

var G__29583 = args29581.length;
switch (G__29583) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29581.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_29588 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29588) : fn1.call(null,val_29588));
} else {
cljs.core.async.impl.dispatch.run(((function (val_29588,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29588) : fn1.call(null,val_29588));
});})(val_29588,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29589 = [];
var len__9081__auto___29592 = arguments.length;
var i__9082__auto___29593 = (0);
while(true){
if((i__9082__auto___29593 < len__9081__auto___29592)){
args29589.push((arguments[i__9082__auto___29593]));

var G__29594 = (i__9082__auto___29593 + (1));
i__9082__auto___29593 = G__29594;
continue;
} else {
}
break;
}

var G__29591 = args29589.length;
switch (G__29591) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29589.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8926__auto___29596 = n;
var x_29597 = (0);
while(true){
if((x_29597 < n__8926__auto___29596)){
(a[x_29597] = (0));

var G__29598 = (x_29597 + (1));
x_29597 = G__29598;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__29599 = (i + (1));
i = G__29599;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t29603 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29603 = (function (alt_flag,flag,meta29604){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29604 = meta29604;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29603.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29605,meta29604__$1){
var self__ = this;
var _29605__$1 = this;
return (new cljs.core.async.t29603(self__.alt_flag,self__.flag,meta29604__$1));
});})(flag))
;

cljs.core.async.t29603.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29605){
var self__ = this;
var _29605__$1 = this;
return self__.meta29604;
});})(flag))
;

cljs.core.async.t29603.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29603.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t29603.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t29603.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29604","meta29604",553503717,null)], null);
});})(flag))
;

cljs.core.async.t29603.cljs$lang$type = true;

cljs.core.async.t29603.cljs$lang$ctorStr = "cljs.core.async/t29603";

cljs.core.async.t29603.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t29603");
});})(flag))
;

cljs.core.async.__GT_t29603 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29603(alt_flag__$1,flag__$1,meta29604){
return (new cljs.core.async.t29603(alt_flag__$1,flag__$1,meta29604));
});})(flag))
;

}

return (new cljs.core.async.t29603(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29609 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29609 = (function (alt_handler,flag,cb,meta29610){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29610 = meta29610;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29609.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29611,meta29610__$1){
var self__ = this;
var _29611__$1 = this;
return (new cljs.core.async.t29609(self__.alt_handler,self__.flag,self__.cb,meta29610__$1));
});

cljs.core.async.t29609.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29611){
var self__ = this;
var _29611__$1 = this;
return self__.meta29610;
});

cljs.core.async.t29609.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29609.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t29609.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t29609.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29610","meta29610",770183168,null)], null);
});

cljs.core.async.t29609.cljs$lang$type = true;

cljs.core.async.t29609.cljs$lang$ctorStr = "cljs.core.async/t29609";

cljs.core.async.t29609.cljs$lang$ctorPrWriter = (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t29609");
});

cljs.core.async.__GT_t29609 = (function cljs$core$async$alt_handler_$___GT_t29609(alt_handler__$1,flag__$1,cb__$1,meta29610){
return (new cljs.core.async.t29609(alt_handler__$1,flag__$1,cb__$1,meta29610));
});

}

return (new cljs.core.async.t29609(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29612_SHARP_){
var G__29616 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29612_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29616) : fret.call(null,G__29616));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29613_SHARP_){
var G__29617 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29613_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29617) : fret.call(null,G__29617));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__8042__auto__ = wport;
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29618 = (i + (1));
i = G__29618;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8042__auto__ = ret;
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__8030__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8030__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8030__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__9088__auto__ = [];
var len__9081__auto___29624 = arguments.length;
var i__9082__auto___29625 = (0);
while(true){
if((i__9082__auto___29625 < len__9081__auto___29624)){
args__9088__auto__.push((arguments[i__9082__auto___29625]));

var G__29626 = (i__9082__auto___29625 + (1));
i__9082__auto___29625 = G__29626;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29621){
var map__29622 = p__29621;
var map__29622__$1 = ((((!((map__29622 == null)))?((((map__29622.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29622.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29622):map__29622);
var opts = map__29622__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29619){
var G__29620 = cljs.core.first(seq29619);
var seq29619__$1 = cljs.core.next(seq29619);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29620,seq29619__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29627 = [];
var len__9081__auto___29677 = arguments.length;
var i__9082__auto___29678 = (0);
while(true){
if((i__9082__auto___29678 < len__9081__auto___29677)){
args29627.push((arguments[i__9082__auto___29678]));

var G__29679 = (i__9082__auto___29678 + (1));
i__9082__auto___29678 = G__29679;
continue;
} else {
}
break;
}

var G__29629 = args29627.length;
switch (G__29629) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29627.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11731__auto___29681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___29681){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___29681){
return (function (state_29653){
var state_val_29654 = (state_29653[(1)]);
if((state_val_29654 === (7))){
var inst_29649 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
var statearr_29655_29682 = state_29653__$1;
(statearr_29655_29682[(2)] = inst_29649);

(statearr_29655_29682[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (1))){
var state_29653__$1 = state_29653;
var statearr_29656_29683 = state_29653__$1;
(statearr_29656_29683[(2)] = null);

(statearr_29656_29683[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (4))){
var inst_29632 = (state_29653[(7)]);
var inst_29632__$1 = (state_29653[(2)]);
var inst_29633 = (inst_29632__$1 == null);
var state_29653__$1 = (function (){var statearr_29657 = state_29653;
(statearr_29657[(7)] = inst_29632__$1);

return statearr_29657;
})();
if(cljs.core.truth_(inst_29633)){
var statearr_29658_29684 = state_29653__$1;
(statearr_29658_29684[(1)] = (5));

} else {
var statearr_29659_29685 = state_29653__$1;
(statearr_29659_29685[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (13))){
var state_29653__$1 = state_29653;
var statearr_29660_29686 = state_29653__$1;
(statearr_29660_29686[(2)] = null);

(statearr_29660_29686[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (6))){
var inst_29632 = (state_29653[(7)]);
var state_29653__$1 = state_29653;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29653__$1,(11),to,inst_29632);
} else {
if((state_val_29654 === (3))){
var inst_29651 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29653__$1,inst_29651);
} else {
if((state_val_29654 === (12))){
var state_29653__$1 = state_29653;
var statearr_29661_29687 = state_29653__$1;
(statearr_29661_29687[(2)] = null);

(statearr_29661_29687[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (2))){
var state_29653__$1 = state_29653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29653__$1,(4),from);
} else {
if((state_val_29654 === (11))){
var inst_29642 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
if(cljs.core.truth_(inst_29642)){
var statearr_29662_29688 = state_29653__$1;
(statearr_29662_29688[(1)] = (12));

} else {
var statearr_29663_29689 = state_29653__$1;
(statearr_29663_29689[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (9))){
var state_29653__$1 = state_29653;
var statearr_29664_29690 = state_29653__$1;
(statearr_29664_29690[(2)] = null);

(statearr_29664_29690[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (5))){
var state_29653__$1 = state_29653;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29665_29691 = state_29653__$1;
(statearr_29665_29691[(1)] = (8));

} else {
var statearr_29666_29692 = state_29653__$1;
(statearr_29666_29692[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (14))){
var inst_29647 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
var statearr_29667_29693 = state_29653__$1;
(statearr_29667_29693[(2)] = inst_29647);

(statearr_29667_29693[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (10))){
var inst_29639 = (state_29653[(2)]);
var state_29653__$1 = state_29653;
var statearr_29668_29694 = state_29653__$1;
(statearr_29668_29694[(2)] = inst_29639);

(statearr_29668_29694[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29654 === (8))){
var inst_29636 = cljs.core.async.close_BANG_(to);
var state_29653__$1 = state_29653;
var statearr_29669_29695 = state_29653__$1;
(statearr_29669_29695[(2)] = inst_29636);

(statearr_29669_29695[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___29681))
;
return ((function (switch__11666__auto__,c__11731__auto___29681){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_29673 = [null,null,null,null,null,null,null,null];
(statearr_29673[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_29673[(1)] = (1));

return statearr_29673;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_29653){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_29653);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e29674){if((e29674 instanceof Object)){
var ex__11670__auto__ = e29674;
var statearr_29675_29696 = state_29653;
(statearr_29675_29696[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29653);

return cljs.core.constant$keyword$recur;
} else {
throw e29674;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__29697 = state_29653;
state_29653 = G__29697;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_29653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_29653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___29681))
})();
var state__11733__auto__ = (function (){var statearr_29676 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_29676[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___29681);

return statearr_29676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___29681))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29881){
var vec__29882 = p__29881;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29882,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29882,(1),null);
var job = vec__29882;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11731__auto___30064 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results){
return (function (state_29887){
var state_val_29888 = (state_29887[(1)]);
if((state_val_29888 === (1))){
var state_29887__$1 = state_29887;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29887__$1,(2),res,v);
} else {
if((state_val_29888 === (2))){
var inst_29884 = (state_29887[(2)]);
var inst_29885 = cljs.core.async.close_BANG_(res);
var state_29887__$1 = (function (){var statearr_29889 = state_29887;
(statearr_29889[(7)] = inst_29884);

return statearr_29889;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29887__$1,inst_29885);
} else {
return null;
}
}
});})(c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results))
;
return ((function (switch__11666__auto__,c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_29893 = [null,null,null,null,null,null,null,null];
(statearr_29893[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__);

(statearr_29893[(1)] = (1));

return statearr_29893;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1 = (function (state_29887){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_29887);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e29894){if((e29894 instanceof Object)){
var ex__11670__auto__ = e29894;
var statearr_29895_30065 = state_29887;
(statearr_29895_30065[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29887);

return cljs.core.constant$keyword$recur;
} else {
throw e29894;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30066 = state_29887;
state_29887 = G__30066;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = function(state_29887){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1.call(this,state_29887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results))
})();
var state__11733__auto__ = (function (){var statearr_29896 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_29896[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30064);

return statearr_29896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___30064,res,vec__29882,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29897){
var vec__29898 = p__29897;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29898,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29898,(1),null);
var job = vec__29898;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8926__auto___30067 = n;
var __30068 = (0);
while(true){
if((__30068 < n__8926__auto___30067)){
var G__29899_30069 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29899_30069) {
case "compute":
var c__11731__auto___30071 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30068,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (__30068,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function (state_29912){
var state_val_29913 = (state_29912[(1)]);
if((state_val_29913 === (1))){
var state_29912__$1 = state_29912;
var statearr_29914_30072 = state_29912__$1;
(statearr_29914_30072[(2)] = null);

(statearr_29914_30072[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29913 === (2))){
var state_29912__$1 = state_29912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29912__$1,(4),jobs);
} else {
if((state_val_29913 === (3))){
var inst_29910 = (state_29912[(2)]);
var state_29912__$1 = state_29912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29912__$1,inst_29910);
} else {
if((state_val_29913 === (4))){
var inst_29902 = (state_29912[(2)]);
var inst_29903 = process(inst_29902);
var state_29912__$1 = state_29912;
if(cljs.core.truth_(inst_29903)){
var statearr_29915_30073 = state_29912__$1;
(statearr_29915_30073[(1)] = (5));

} else {
var statearr_29916_30074 = state_29912__$1;
(statearr_29916_30074[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29913 === (5))){
var state_29912__$1 = state_29912;
var statearr_29917_30075 = state_29912__$1;
(statearr_29917_30075[(2)] = null);

(statearr_29917_30075[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29913 === (6))){
var state_29912__$1 = state_29912;
var statearr_29918_30076 = state_29912__$1;
(statearr_29918_30076[(2)] = null);

(statearr_29918_30076[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29913 === (7))){
var inst_29908 = (state_29912[(2)]);
var state_29912__$1 = state_29912;
var statearr_29919_30077 = state_29912__$1;
(statearr_29919_30077[(2)] = inst_29908);

(statearr_29919_30077[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__30068,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
;
return ((function (__30068,switch__11666__auto__,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_29923 = [null,null,null,null,null,null,null];
(statearr_29923[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__);

(statearr_29923[(1)] = (1));

return statearr_29923;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1 = (function (state_29912){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_29912);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e29924){if((e29924 instanceof Object)){
var ex__11670__auto__ = e29924;
var statearr_29925_30078 = state_29912;
(statearr_29925_30078[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29912);

return cljs.core.constant$keyword$recur;
} else {
throw e29924;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30079 = state_29912;
state_29912 = G__30079;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = function(state_29912){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1.call(this,state_29912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__;
})()
;})(__30068,switch__11666__auto__,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
})();
var state__11733__auto__ = (function (){var statearr_29926 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_29926[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30071);

return statearr_29926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(__30068,c__11731__auto___30071,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
);


break;
case "async":
var c__11731__auto___30080 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30068,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (__30068,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function (state_29939){
var state_val_29940 = (state_29939[(1)]);
if((state_val_29940 === (1))){
var state_29939__$1 = state_29939;
var statearr_29941_30081 = state_29939__$1;
(statearr_29941_30081[(2)] = null);

(statearr_29941_30081[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29940 === (2))){
var state_29939__$1 = state_29939;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29939__$1,(4),jobs);
} else {
if((state_val_29940 === (3))){
var inst_29937 = (state_29939[(2)]);
var state_29939__$1 = state_29939;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29939__$1,inst_29937);
} else {
if((state_val_29940 === (4))){
var inst_29929 = (state_29939[(2)]);
var inst_29930 = async(inst_29929);
var state_29939__$1 = state_29939;
if(cljs.core.truth_(inst_29930)){
var statearr_29942_30082 = state_29939__$1;
(statearr_29942_30082[(1)] = (5));

} else {
var statearr_29943_30083 = state_29939__$1;
(statearr_29943_30083[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29940 === (5))){
var state_29939__$1 = state_29939;
var statearr_29944_30084 = state_29939__$1;
(statearr_29944_30084[(2)] = null);

(statearr_29944_30084[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29940 === (6))){
var state_29939__$1 = state_29939;
var statearr_29945_30085 = state_29939__$1;
(statearr_29945_30085[(2)] = null);

(statearr_29945_30085[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29940 === (7))){
var inst_29935 = (state_29939[(2)]);
var state_29939__$1 = state_29939;
var statearr_29946_30086 = state_29939__$1;
(statearr_29946_30086[(2)] = inst_29935);

(statearr_29946_30086[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__30068,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
;
return ((function (__30068,switch__11666__auto__,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_29950 = [null,null,null,null,null,null,null];
(statearr_29950[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__);

(statearr_29950[(1)] = (1));

return statearr_29950;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1 = (function (state_29939){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_29939);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e29951){if((e29951 instanceof Object)){
var ex__11670__auto__ = e29951;
var statearr_29952_30087 = state_29939;
(statearr_29952_30087[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29939);

return cljs.core.constant$keyword$recur;
} else {
throw e29951;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30088 = state_29939;
state_29939 = G__30088;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = function(state_29939){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1.call(this,state_29939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__;
})()
;})(__30068,switch__11666__auto__,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
})();
var state__11733__auto__ = (function (){var statearr_29953 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_29953[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30080);

return statearr_29953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(__30068,c__11731__auto___30080,G__29899_30069,n__8926__auto___30067,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30089 = (__30068 + (1));
__30068 = G__30089;
continue;
} else {
}
break;
}

var c__11731__auto___30090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___30090,jobs,results,process,async){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___30090,jobs,results,process,async){
return (function (state_29975){
var state_val_29976 = (state_29975[(1)]);
if((state_val_29976 === (1))){
var state_29975__$1 = state_29975;
var statearr_29977_30091 = state_29975__$1;
(statearr_29977_30091[(2)] = null);

(statearr_29977_30091[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29976 === (2))){
var state_29975__$1 = state_29975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29975__$1,(4),from);
} else {
if((state_val_29976 === (3))){
var inst_29973 = (state_29975[(2)]);
var state_29975__$1 = state_29975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29975__$1,inst_29973);
} else {
if((state_val_29976 === (4))){
var inst_29956 = (state_29975[(7)]);
var inst_29956__$1 = (state_29975[(2)]);
var inst_29957 = (inst_29956__$1 == null);
var state_29975__$1 = (function (){var statearr_29978 = state_29975;
(statearr_29978[(7)] = inst_29956__$1);

return statearr_29978;
})();
if(cljs.core.truth_(inst_29957)){
var statearr_29979_30092 = state_29975__$1;
(statearr_29979_30092[(1)] = (5));

} else {
var statearr_29980_30093 = state_29975__$1;
(statearr_29980_30093[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29976 === (5))){
var inst_29959 = cljs.core.async.close_BANG_(jobs);
var state_29975__$1 = state_29975;
var statearr_29981_30094 = state_29975__$1;
(statearr_29981_30094[(2)] = inst_29959);

(statearr_29981_30094[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29976 === (6))){
var inst_29956 = (state_29975[(7)]);
var inst_29961 = (state_29975[(8)]);
var inst_29961__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29963 = [inst_29956,inst_29961__$1];
var inst_29964 = (new cljs.core.PersistentVector(null,2,(5),inst_29962,inst_29963,null));
var state_29975__$1 = (function (){var statearr_29982 = state_29975;
(statearr_29982[(8)] = inst_29961__$1);

return statearr_29982;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29975__$1,(8),jobs,inst_29964);
} else {
if((state_val_29976 === (7))){
var inst_29971 = (state_29975[(2)]);
var state_29975__$1 = state_29975;
var statearr_29983_30095 = state_29975__$1;
(statearr_29983_30095[(2)] = inst_29971);

(statearr_29983_30095[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29976 === (8))){
var inst_29961 = (state_29975[(8)]);
var inst_29966 = (state_29975[(2)]);
var state_29975__$1 = (function (){var statearr_29984 = state_29975;
(statearr_29984[(9)] = inst_29966);

return statearr_29984;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29975__$1,(9),results,inst_29961);
} else {
if((state_val_29976 === (9))){
var inst_29968 = (state_29975[(2)]);
var state_29975__$1 = (function (){var statearr_29985 = state_29975;
(statearr_29985[(10)] = inst_29968);

return statearr_29985;
})();
var statearr_29986_30096 = state_29975__$1;
(statearr_29986_30096[(2)] = null);

(statearr_29986_30096[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___30090,jobs,results,process,async))
;
return ((function (switch__11666__auto__,c__11731__auto___30090,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_29990 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29990[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__);

(statearr_29990[(1)] = (1));

return statearr_29990;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1 = (function (state_29975){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_29975);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e29991){if((e29991 instanceof Object)){
var ex__11670__auto__ = e29991;
var statearr_29992_30097 = state_29975;
(statearr_29992_30097[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29975);

return cljs.core.constant$keyword$recur;
} else {
throw e29991;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30098 = state_29975;
state_29975 = G__30098;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = function(state_29975){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1.call(this,state_29975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___30090,jobs,results,process,async))
})();
var state__11733__auto__ = (function (){var statearr_29993 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_29993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30090);

return statearr_29993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___30090,jobs,results,process,async))
);


var c__11731__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto__,jobs,results,process,async){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto__,jobs,results,process,async){
return (function (state_30031){
var state_val_30032 = (state_30031[(1)]);
if((state_val_30032 === (7))){
var inst_30027 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
var statearr_30033_30099 = state_30031__$1;
(statearr_30033_30099[(2)] = inst_30027);

(statearr_30033_30099[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (20))){
var state_30031__$1 = state_30031;
var statearr_30034_30100 = state_30031__$1;
(statearr_30034_30100[(2)] = null);

(statearr_30034_30100[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (1))){
var state_30031__$1 = state_30031;
var statearr_30035_30101 = state_30031__$1;
(statearr_30035_30101[(2)] = null);

(statearr_30035_30101[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (4))){
var inst_29996 = (state_30031[(7)]);
var inst_29996__$1 = (state_30031[(2)]);
var inst_29997 = (inst_29996__$1 == null);
var state_30031__$1 = (function (){var statearr_30036 = state_30031;
(statearr_30036[(7)] = inst_29996__$1);

return statearr_30036;
})();
if(cljs.core.truth_(inst_29997)){
var statearr_30037_30102 = state_30031__$1;
(statearr_30037_30102[(1)] = (5));

} else {
var statearr_30038_30103 = state_30031__$1;
(statearr_30038_30103[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (15))){
var inst_30009 = (state_30031[(8)]);
var state_30031__$1 = state_30031;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30031__$1,(18),to,inst_30009);
} else {
if((state_val_30032 === (21))){
var inst_30022 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
var statearr_30039_30104 = state_30031__$1;
(statearr_30039_30104[(2)] = inst_30022);

(statearr_30039_30104[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (13))){
var inst_30024 = (state_30031[(2)]);
var state_30031__$1 = (function (){var statearr_30040 = state_30031;
(statearr_30040[(9)] = inst_30024);

return statearr_30040;
})();
var statearr_30041_30105 = state_30031__$1;
(statearr_30041_30105[(2)] = null);

(statearr_30041_30105[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (6))){
var inst_29996 = (state_30031[(7)]);
var state_30031__$1 = state_30031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30031__$1,(11),inst_29996);
} else {
if((state_val_30032 === (17))){
var inst_30017 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
if(cljs.core.truth_(inst_30017)){
var statearr_30042_30106 = state_30031__$1;
(statearr_30042_30106[(1)] = (19));

} else {
var statearr_30043_30107 = state_30031__$1;
(statearr_30043_30107[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (3))){
var inst_30029 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30031__$1,inst_30029);
} else {
if((state_val_30032 === (12))){
var inst_30006 = (state_30031[(10)]);
var state_30031__$1 = state_30031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30031__$1,(14),inst_30006);
} else {
if((state_val_30032 === (2))){
var state_30031__$1 = state_30031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30031__$1,(4),results);
} else {
if((state_val_30032 === (19))){
var state_30031__$1 = state_30031;
var statearr_30044_30108 = state_30031__$1;
(statearr_30044_30108[(2)] = null);

(statearr_30044_30108[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (11))){
var inst_30006 = (state_30031[(2)]);
var state_30031__$1 = (function (){var statearr_30045 = state_30031;
(statearr_30045[(10)] = inst_30006);

return statearr_30045;
})();
var statearr_30046_30109 = state_30031__$1;
(statearr_30046_30109[(2)] = null);

(statearr_30046_30109[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (9))){
var state_30031__$1 = state_30031;
var statearr_30047_30110 = state_30031__$1;
(statearr_30047_30110[(2)] = null);

(statearr_30047_30110[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (5))){
var state_30031__$1 = state_30031;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30048_30111 = state_30031__$1;
(statearr_30048_30111[(1)] = (8));

} else {
var statearr_30049_30112 = state_30031__$1;
(statearr_30049_30112[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (14))){
var inst_30011 = (state_30031[(11)]);
var inst_30009 = (state_30031[(8)]);
var inst_30009__$1 = (state_30031[(2)]);
var inst_30010 = (inst_30009__$1 == null);
var inst_30011__$1 = cljs.core.not(inst_30010);
var state_30031__$1 = (function (){var statearr_30050 = state_30031;
(statearr_30050[(11)] = inst_30011__$1);

(statearr_30050[(8)] = inst_30009__$1);

return statearr_30050;
})();
if(inst_30011__$1){
var statearr_30051_30113 = state_30031__$1;
(statearr_30051_30113[(1)] = (15));

} else {
var statearr_30052_30114 = state_30031__$1;
(statearr_30052_30114[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (16))){
var inst_30011 = (state_30031[(11)]);
var state_30031__$1 = state_30031;
var statearr_30053_30115 = state_30031__$1;
(statearr_30053_30115[(2)] = inst_30011);

(statearr_30053_30115[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (10))){
var inst_30003 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
var statearr_30054_30116 = state_30031__$1;
(statearr_30054_30116[(2)] = inst_30003);

(statearr_30054_30116[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (18))){
var inst_30014 = (state_30031[(2)]);
var state_30031__$1 = state_30031;
var statearr_30055_30117 = state_30031__$1;
(statearr_30055_30117[(2)] = inst_30014);

(statearr_30055_30117[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30032 === (8))){
var inst_30000 = cljs.core.async.close_BANG_(to);
var state_30031__$1 = state_30031;
var statearr_30056_30118 = state_30031__$1;
(statearr_30056_30118[(2)] = inst_30000);

(statearr_30056_30118[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto__,jobs,results,process,async))
;
return ((function (switch__11666__auto__,c__11731__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_30060 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30060[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__);

(statearr_30060[(1)] = (1));

return statearr_30060;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1 = (function (state_30031){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_30031);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e30061){if((e30061 instanceof Object)){
var ex__11670__auto__ = e30061;
var statearr_30062_30119 = state_30031;
(statearr_30062_30119[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30031);

return cljs.core.constant$keyword$recur;
} else {
throw e30061;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30120 = state_30031;
state_30031 = G__30120;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__ = function(state_30031){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1.call(this,state_30031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto__,jobs,results,process,async))
})();
var state__11733__auto__ = (function (){var statearr_30063 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_30063[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto__);

return statearr_30063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto__,jobs,results,process,async))
);

return c__11731__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args30121 = [];
var len__9081__auto___30124 = arguments.length;
var i__9082__auto___30125 = (0);
while(true){
if((i__9082__auto___30125 < len__9081__auto___30124)){
args30121.push((arguments[i__9082__auto___30125]));

var G__30126 = (i__9082__auto___30125 + (1));
i__9082__auto___30125 = G__30126;
continue;
} else {
}
break;
}

var G__30123 = args30121.length;
switch (G__30123) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30121.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args30128 = [];
var len__9081__auto___30131 = arguments.length;
var i__9082__auto___30132 = (0);
while(true){
if((i__9082__auto___30132 < len__9081__auto___30131)){
args30128.push((arguments[i__9082__auto___30132]));

var G__30133 = (i__9082__auto___30132 + (1));
i__9082__auto___30132 = G__30133;
continue;
} else {
}
break;
}

var G__30130 = args30128.length;
switch (G__30130) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30128.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args30135 = [];
var len__9081__auto___30188 = arguments.length;
var i__9082__auto___30189 = (0);
while(true){
if((i__9082__auto___30189 < len__9081__auto___30188)){
args30135.push((arguments[i__9082__auto___30189]));

var G__30190 = (i__9082__auto___30189 + (1));
i__9082__auto___30189 = G__30190;
continue;
} else {
}
break;
}

var G__30137 = args30135.length;
switch (G__30137) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30135.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11731__auto___30192 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___30192,tc,fc){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___30192,tc,fc){
return (function (state_30163){
var state_val_30164 = (state_30163[(1)]);
if((state_val_30164 === (7))){
var inst_30159 = (state_30163[(2)]);
var state_30163__$1 = state_30163;
var statearr_30165_30193 = state_30163__$1;
(statearr_30165_30193[(2)] = inst_30159);

(statearr_30165_30193[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (1))){
var state_30163__$1 = state_30163;
var statearr_30166_30194 = state_30163__$1;
(statearr_30166_30194[(2)] = null);

(statearr_30166_30194[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (4))){
var inst_30140 = (state_30163[(7)]);
var inst_30140__$1 = (state_30163[(2)]);
var inst_30141 = (inst_30140__$1 == null);
var state_30163__$1 = (function (){var statearr_30167 = state_30163;
(statearr_30167[(7)] = inst_30140__$1);

return statearr_30167;
})();
if(cljs.core.truth_(inst_30141)){
var statearr_30168_30195 = state_30163__$1;
(statearr_30168_30195[(1)] = (5));

} else {
var statearr_30169_30196 = state_30163__$1;
(statearr_30169_30196[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (13))){
var state_30163__$1 = state_30163;
var statearr_30170_30197 = state_30163__$1;
(statearr_30170_30197[(2)] = null);

(statearr_30170_30197[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (6))){
var inst_30140 = (state_30163[(7)]);
var inst_30146 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30140) : p.call(null,inst_30140));
var state_30163__$1 = state_30163;
if(cljs.core.truth_(inst_30146)){
var statearr_30171_30198 = state_30163__$1;
(statearr_30171_30198[(1)] = (9));

} else {
var statearr_30172_30199 = state_30163__$1;
(statearr_30172_30199[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (3))){
var inst_30161 = (state_30163[(2)]);
var state_30163__$1 = state_30163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30163__$1,inst_30161);
} else {
if((state_val_30164 === (12))){
var state_30163__$1 = state_30163;
var statearr_30173_30200 = state_30163__$1;
(statearr_30173_30200[(2)] = null);

(statearr_30173_30200[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (2))){
var state_30163__$1 = state_30163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30163__$1,(4),ch);
} else {
if((state_val_30164 === (11))){
var inst_30140 = (state_30163[(7)]);
var inst_30150 = (state_30163[(2)]);
var state_30163__$1 = state_30163;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30163__$1,(8),inst_30150,inst_30140);
} else {
if((state_val_30164 === (9))){
var state_30163__$1 = state_30163;
var statearr_30174_30201 = state_30163__$1;
(statearr_30174_30201[(2)] = tc);

(statearr_30174_30201[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (5))){
var inst_30143 = cljs.core.async.close_BANG_(tc);
var inst_30144 = cljs.core.async.close_BANG_(fc);
var state_30163__$1 = (function (){var statearr_30175 = state_30163;
(statearr_30175[(8)] = inst_30143);

return statearr_30175;
})();
var statearr_30176_30202 = state_30163__$1;
(statearr_30176_30202[(2)] = inst_30144);

(statearr_30176_30202[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (14))){
var inst_30157 = (state_30163[(2)]);
var state_30163__$1 = state_30163;
var statearr_30177_30203 = state_30163__$1;
(statearr_30177_30203[(2)] = inst_30157);

(statearr_30177_30203[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (10))){
var state_30163__$1 = state_30163;
var statearr_30178_30204 = state_30163__$1;
(statearr_30178_30204[(2)] = fc);

(statearr_30178_30204[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30164 === (8))){
var inst_30152 = (state_30163[(2)]);
var state_30163__$1 = state_30163;
if(cljs.core.truth_(inst_30152)){
var statearr_30179_30205 = state_30163__$1;
(statearr_30179_30205[(1)] = (12));

} else {
var statearr_30180_30206 = state_30163__$1;
(statearr_30180_30206[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___30192,tc,fc))
;
return ((function (switch__11666__auto__,c__11731__auto___30192,tc,fc){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_30184 = [null,null,null,null,null,null,null,null,null];
(statearr_30184[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_30184[(1)] = (1));

return statearr_30184;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_30163){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_30163);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e30185){if((e30185 instanceof Object)){
var ex__11670__auto__ = e30185;
var statearr_30186_30207 = state_30163;
(statearr_30186_30207[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30163);

return cljs.core.constant$keyword$recur;
} else {
throw e30185;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30208 = state_30163;
state_30163 = G__30208;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_30163){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_30163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___30192,tc,fc))
})();
var state__11733__auto__ = (function (){var statearr_30187 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_30187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30192);

return statearr_30187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___30192,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11731__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto__){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto__){
return (function (state_30255){
var state_val_30256 = (state_30255[(1)]);
if((state_val_30256 === (1))){
var inst_30241 = init;
var state_30255__$1 = (function (){var statearr_30257 = state_30255;
(statearr_30257[(7)] = inst_30241);

return statearr_30257;
})();
var statearr_30258_30273 = state_30255__$1;
(statearr_30258_30273[(2)] = null);

(statearr_30258_30273[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30256 === (2))){
var state_30255__$1 = state_30255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30255__$1,(4),ch);
} else {
if((state_val_30256 === (3))){
var inst_30253 = (state_30255[(2)]);
var state_30255__$1 = state_30255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30255__$1,inst_30253);
} else {
if((state_val_30256 === (4))){
var inst_30244 = (state_30255[(8)]);
var inst_30244__$1 = (state_30255[(2)]);
var inst_30245 = (inst_30244__$1 == null);
var state_30255__$1 = (function (){var statearr_30259 = state_30255;
(statearr_30259[(8)] = inst_30244__$1);

return statearr_30259;
})();
if(cljs.core.truth_(inst_30245)){
var statearr_30260_30274 = state_30255__$1;
(statearr_30260_30274[(1)] = (5));

} else {
var statearr_30261_30275 = state_30255__$1;
(statearr_30261_30275[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30256 === (5))){
var inst_30241 = (state_30255[(7)]);
var state_30255__$1 = state_30255;
var statearr_30262_30276 = state_30255__$1;
(statearr_30262_30276[(2)] = inst_30241);

(statearr_30262_30276[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30256 === (6))){
var inst_30244 = (state_30255[(8)]);
var inst_30241 = (state_30255[(7)]);
var inst_30248 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30241,inst_30244) : f.call(null,inst_30241,inst_30244));
var inst_30241__$1 = inst_30248;
var state_30255__$1 = (function (){var statearr_30263 = state_30255;
(statearr_30263[(7)] = inst_30241__$1);

return statearr_30263;
})();
var statearr_30264_30277 = state_30255__$1;
(statearr_30264_30277[(2)] = null);

(statearr_30264_30277[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30256 === (7))){
var inst_30251 = (state_30255[(2)]);
var state_30255__$1 = state_30255;
var statearr_30265_30278 = state_30255__$1;
(statearr_30265_30278[(2)] = inst_30251);

(statearr_30265_30278[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11731__auto__))
;
return ((function (switch__11666__auto__,c__11731__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11667__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11667__auto____0 = (function (){
var statearr_30269 = [null,null,null,null,null,null,null,null,null];
(statearr_30269[(0)] = cljs$core$async$reduce_$_state_machine__11667__auto__);

(statearr_30269[(1)] = (1));

return statearr_30269;
});
var cljs$core$async$reduce_$_state_machine__11667__auto____1 = (function (state_30255){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_30255);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e30270){if((e30270 instanceof Object)){
var ex__11670__auto__ = e30270;
var statearr_30271_30279 = state_30255;
(statearr_30271_30279[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30255);

return cljs.core.constant$keyword$recur;
} else {
throw e30270;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30280 = state_30255;
state_30255 = G__30280;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11667__auto__ = function(state_30255){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11667__auto____1.call(this,state_30255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11667__auto____0;
cljs$core$async$reduce_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11667__auto____1;
return cljs$core$async$reduce_$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto__))
})();
var state__11733__auto__ = (function (){var statearr_30272 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_30272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto__);

return statearr_30272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto__))
);

return c__11731__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args30281 = [];
var len__9081__auto___30333 = arguments.length;
var i__9082__auto___30334 = (0);
while(true){
if((i__9082__auto___30334 < len__9081__auto___30333)){
args30281.push((arguments[i__9082__auto___30334]));

var G__30335 = (i__9082__auto___30334 + (1));
i__9082__auto___30334 = G__30335;
continue;
} else {
}
break;
}

var G__30283 = args30281.length;
switch (G__30283) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30281.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11731__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto__){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto__){
return (function (state_30308){
var state_val_30309 = (state_30308[(1)]);
if((state_val_30309 === (7))){
var inst_30290 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
var statearr_30310_30337 = state_30308__$1;
(statearr_30310_30337[(2)] = inst_30290);

(statearr_30310_30337[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (1))){
var inst_30284 = cljs.core.seq(coll);
var inst_30285 = inst_30284;
var state_30308__$1 = (function (){var statearr_30311 = state_30308;
(statearr_30311[(7)] = inst_30285);

return statearr_30311;
})();
var statearr_30312_30338 = state_30308__$1;
(statearr_30312_30338[(2)] = null);

(statearr_30312_30338[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (4))){
var inst_30285 = (state_30308[(7)]);
var inst_30288 = cljs.core.first(inst_30285);
var state_30308__$1 = state_30308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30308__$1,(7),ch,inst_30288);
} else {
if((state_val_30309 === (13))){
var inst_30302 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
var statearr_30313_30339 = state_30308__$1;
(statearr_30313_30339[(2)] = inst_30302);

(statearr_30313_30339[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (6))){
var inst_30293 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
if(cljs.core.truth_(inst_30293)){
var statearr_30314_30340 = state_30308__$1;
(statearr_30314_30340[(1)] = (8));

} else {
var statearr_30315_30341 = state_30308__$1;
(statearr_30315_30341[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (3))){
var inst_30306 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30308__$1,inst_30306);
} else {
if((state_val_30309 === (12))){
var state_30308__$1 = state_30308;
var statearr_30316_30342 = state_30308__$1;
(statearr_30316_30342[(2)] = null);

(statearr_30316_30342[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (2))){
var inst_30285 = (state_30308[(7)]);
var state_30308__$1 = state_30308;
if(cljs.core.truth_(inst_30285)){
var statearr_30317_30343 = state_30308__$1;
(statearr_30317_30343[(1)] = (4));

} else {
var statearr_30318_30344 = state_30308__$1;
(statearr_30318_30344[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (11))){
var inst_30299 = cljs.core.async.close_BANG_(ch);
var state_30308__$1 = state_30308;
var statearr_30319_30345 = state_30308__$1;
(statearr_30319_30345[(2)] = inst_30299);

(statearr_30319_30345[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (9))){
var state_30308__$1 = state_30308;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30320_30346 = state_30308__$1;
(statearr_30320_30346[(1)] = (11));

} else {
var statearr_30321_30347 = state_30308__$1;
(statearr_30321_30347[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (5))){
var inst_30285 = (state_30308[(7)]);
var state_30308__$1 = state_30308;
var statearr_30322_30348 = state_30308__$1;
(statearr_30322_30348[(2)] = inst_30285);

(statearr_30322_30348[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (10))){
var inst_30304 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
var statearr_30323_30349 = state_30308__$1;
(statearr_30323_30349[(2)] = inst_30304);

(statearr_30323_30349[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30309 === (8))){
var inst_30285 = (state_30308[(7)]);
var inst_30295 = cljs.core.next(inst_30285);
var inst_30285__$1 = inst_30295;
var state_30308__$1 = (function (){var statearr_30324 = state_30308;
(statearr_30324[(7)] = inst_30285__$1);

return statearr_30324;
})();
var statearr_30325_30350 = state_30308__$1;
(statearr_30325_30350[(2)] = null);

(statearr_30325_30350[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto__))
;
return ((function (switch__11666__auto__,c__11731__auto__){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_30329 = [null,null,null,null,null,null,null,null];
(statearr_30329[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_30329[(1)] = (1));

return statearr_30329;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_30308){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_30308);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e30330){if((e30330 instanceof Object)){
var ex__11670__auto__ = e30330;
var statearr_30331_30351 = state_30308;
(statearr_30331_30351[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30308);

return cljs.core.constant$keyword$recur;
} else {
throw e30330;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30352 = state_30308;
state_30308 = G__30352;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_30308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_30308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto__))
})();
var state__11733__auto__ = (function (){var statearr_30332 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_30332[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto__);

return statearr_30332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto__))
);

return c__11731__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8678__auto__ = (((_ == null))?null:_);
var m__8679__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8679__auto__.call(null,_));
} else {
var m__8679__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8679__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8679__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8679__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8679__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto__.call(null,m));
} else {
var m__8679__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__30581 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30581) : cljs.core.atom.call(null,G__30581));
})();
var m = (function (){
if(typeof cljs.core.async.t30582 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30582 = (function (mult,ch,cs,meta30583){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30583 = meta30583;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30582.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30584,meta30583__$1){
var self__ = this;
var _30584__$1 = this;
return (new cljs.core.async.t30582(self__.mult,self__.ch,self__.cs,meta30583__$1));
});})(cs))
;

cljs.core.async.t30582.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30584){
var self__ = this;
var _30584__$1 = this;
return self__.meta30583;
});})(cs))
;

cljs.core.async.t30582.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30582.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30582.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30582.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30582.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30582.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30585_30805 = self__.cs;
var G__30586_30806 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30585_30805,G__30586_30806) : cljs.core.reset_BANG_.call(null,G__30585_30805,G__30586_30806));

return null;
});})(cs))
;

cljs.core.async.t30582.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30583","meta30583",-889671235,null)], null);
});})(cs))
;

cljs.core.async.t30582.cljs$lang$type = true;

cljs.core.async.t30582.cljs$lang$ctorStr = "cljs.core.async/t30582";

cljs.core.async.t30582.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t30582");
});})(cs))
;

cljs.core.async.__GT_t30582 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30582(mult__$1,ch__$1,cs__$1,meta30583){
return (new cljs.core.async.t30582(mult__$1,ch__$1,cs__$1,meta30583));
});})(cs))
;

}

return (new cljs.core.async.t30582(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11731__auto___30807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___30807,cs,m,dchan,dctr,done){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___30807,cs,m,dchan,dctr,done){
return (function (state_30717){
var state_val_30718 = (state_30717[(1)]);
if((state_val_30718 === (7))){
var inst_30713 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30719_30808 = state_30717__$1;
(statearr_30719_30808[(2)] = inst_30713);

(statearr_30719_30808[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (20))){
var inst_30618 = (state_30717[(7)]);
var inst_30628 = cljs.core.first(inst_30618);
var inst_30629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30628,(0),null);
var inst_30630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30628,(1),null);
var state_30717__$1 = (function (){var statearr_30720 = state_30717;
(statearr_30720[(8)] = inst_30629);

return statearr_30720;
})();
if(cljs.core.truth_(inst_30630)){
var statearr_30721_30809 = state_30717__$1;
(statearr_30721_30809[(1)] = (22));

} else {
var statearr_30722_30810 = state_30717__$1;
(statearr_30722_30810[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (27))){
var inst_30658 = (state_30717[(9)]);
var inst_30665 = (state_30717[(10)]);
var inst_30660 = (state_30717[(11)]);
var inst_30589 = (state_30717[(12)]);
var inst_30665__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30658,inst_30660);
var inst_30666 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30665__$1,inst_30589,done);
var state_30717__$1 = (function (){var statearr_30723 = state_30717;
(statearr_30723[(10)] = inst_30665__$1);

return statearr_30723;
})();
if(cljs.core.truth_(inst_30666)){
var statearr_30724_30811 = state_30717__$1;
(statearr_30724_30811[(1)] = (30));

} else {
var statearr_30725_30812 = state_30717__$1;
(statearr_30725_30812[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (1))){
var state_30717__$1 = state_30717;
var statearr_30726_30813 = state_30717__$1;
(statearr_30726_30813[(2)] = null);

(statearr_30726_30813[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (24))){
var inst_30618 = (state_30717[(7)]);
var inst_30635 = (state_30717[(2)]);
var inst_30636 = cljs.core.next(inst_30618);
var inst_30598 = inst_30636;
var inst_30599 = null;
var inst_30600 = (0);
var inst_30601 = (0);
var state_30717__$1 = (function (){var statearr_30727 = state_30717;
(statearr_30727[(13)] = inst_30598);

(statearr_30727[(14)] = inst_30601);

(statearr_30727[(15)] = inst_30635);

(statearr_30727[(16)] = inst_30599);

(statearr_30727[(17)] = inst_30600);

return statearr_30727;
})();
var statearr_30728_30814 = state_30717__$1;
(statearr_30728_30814[(2)] = null);

(statearr_30728_30814[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (39))){
var state_30717__$1 = state_30717;
var statearr_30732_30815 = state_30717__$1;
(statearr_30732_30815[(2)] = null);

(statearr_30732_30815[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (4))){
var inst_30589 = (state_30717[(12)]);
var inst_30589__$1 = (state_30717[(2)]);
var inst_30590 = (inst_30589__$1 == null);
var state_30717__$1 = (function (){var statearr_30733 = state_30717;
(statearr_30733[(12)] = inst_30589__$1);

return statearr_30733;
})();
if(cljs.core.truth_(inst_30590)){
var statearr_30734_30816 = state_30717__$1;
(statearr_30734_30816[(1)] = (5));

} else {
var statearr_30735_30817 = state_30717__$1;
(statearr_30735_30817[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (15))){
var inst_30598 = (state_30717[(13)]);
var inst_30601 = (state_30717[(14)]);
var inst_30599 = (state_30717[(16)]);
var inst_30600 = (state_30717[(17)]);
var inst_30614 = (state_30717[(2)]);
var inst_30615 = (inst_30601 + (1));
var tmp30729 = inst_30598;
var tmp30730 = inst_30599;
var tmp30731 = inst_30600;
var inst_30598__$1 = tmp30729;
var inst_30599__$1 = tmp30730;
var inst_30600__$1 = tmp30731;
var inst_30601__$1 = inst_30615;
var state_30717__$1 = (function (){var statearr_30736 = state_30717;
(statearr_30736[(13)] = inst_30598__$1);

(statearr_30736[(18)] = inst_30614);

(statearr_30736[(14)] = inst_30601__$1);

(statearr_30736[(16)] = inst_30599__$1);

(statearr_30736[(17)] = inst_30600__$1);

return statearr_30736;
})();
var statearr_30737_30818 = state_30717__$1;
(statearr_30737_30818[(2)] = null);

(statearr_30737_30818[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (21))){
var inst_30639 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30741_30819 = state_30717__$1;
(statearr_30741_30819[(2)] = inst_30639);

(statearr_30741_30819[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (31))){
var inst_30665 = (state_30717[(10)]);
var inst_30669 = done(null);
var inst_30670 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30665);
var state_30717__$1 = (function (){var statearr_30742 = state_30717;
(statearr_30742[(19)] = inst_30669);

return statearr_30742;
})();
var statearr_30743_30820 = state_30717__$1;
(statearr_30743_30820[(2)] = inst_30670);

(statearr_30743_30820[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (32))){
var inst_30659 = (state_30717[(20)]);
var inst_30658 = (state_30717[(9)]);
var inst_30657 = (state_30717[(21)]);
var inst_30660 = (state_30717[(11)]);
var inst_30672 = (state_30717[(2)]);
var inst_30673 = (inst_30660 + (1));
var tmp30738 = inst_30659;
var tmp30739 = inst_30658;
var tmp30740 = inst_30657;
var inst_30657__$1 = tmp30740;
var inst_30658__$1 = tmp30739;
var inst_30659__$1 = tmp30738;
var inst_30660__$1 = inst_30673;
var state_30717__$1 = (function (){var statearr_30744 = state_30717;
(statearr_30744[(20)] = inst_30659__$1);

(statearr_30744[(9)] = inst_30658__$1);

(statearr_30744[(21)] = inst_30657__$1);

(statearr_30744[(11)] = inst_30660__$1);

(statearr_30744[(22)] = inst_30672);

return statearr_30744;
})();
var statearr_30745_30821 = state_30717__$1;
(statearr_30745_30821[(2)] = null);

(statearr_30745_30821[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (40))){
var inst_30685 = (state_30717[(23)]);
var inst_30689 = done(null);
var inst_30690 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30685);
var state_30717__$1 = (function (){var statearr_30746 = state_30717;
(statearr_30746[(24)] = inst_30689);

return statearr_30746;
})();
var statearr_30747_30822 = state_30717__$1;
(statearr_30747_30822[(2)] = inst_30690);

(statearr_30747_30822[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (33))){
var inst_30676 = (state_30717[(25)]);
var inst_30678 = cljs.core.chunked_seq_QMARK_(inst_30676);
var state_30717__$1 = state_30717;
if(inst_30678){
var statearr_30748_30823 = state_30717__$1;
(statearr_30748_30823[(1)] = (36));

} else {
var statearr_30749_30824 = state_30717__$1;
(statearr_30749_30824[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (13))){
var inst_30608 = (state_30717[(26)]);
var inst_30611 = cljs.core.async.close_BANG_(inst_30608);
var state_30717__$1 = state_30717;
var statearr_30750_30825 = state_30717__$1;
(statearr_30750_30825[(2)] = inst_30611);

(statearr_30750_30825[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (22))){
var inst_30629 = (state_30717[(8)]);
var inst_30632 = cljs.core.async.close_BANG_(inst_30629);
var state_30717__$1 = state_30717;
var statearr_30751_30826 = state_30717__$1;
(statearr_30751_30826[(2)] = inst_30632);

(statearr_30751_30826[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (36))){
var inst_30676 = (state_30717[(25)]);
var inst_30680 = cljs.core.chunk_first(inst_30676);
var inst_30681 = cljs.core.chunk_rest(inst_30676);
var inst_30682 = cljs.core.count(inst_30680);
var inst_30657 = inst_30681;
var inst_30658 = inst_30680;
var inst_30659 = inst_30682;
var inst_30660 = (0);
var state_30717__$1 = (function (){var statearr_30752 = state_30717;
(statearr_30752[(20)] = inst_30659);

(statearr_30752[(9)] = inst_30658);

(statearr_30752[(21)] = inst_30657);

(statearr_30752[(11)] = inst_30660);

return statearr_30752;
})();
var statearr_30753_30827 = state_30717__$1;
(statearr_30753_30827[(2)] = null);

(statearr_30753_30827[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (41))){
var inst_30676 = (state_30717[(25)]);
var inst_30692 = (state_30717[(2)]);
var inst_30693 = cljs.core.next(inst_30676);
var inst_30657 = inst_30693;
var inst_30658 = null;
var inst_30659 = (0);
var inst_30660 = (0);
var state_30717__$1 = (function (){var statearr_30754 = state_30717;
(statearr_30754[(27)] = inst_30692);

(statearr_30754[(20)] = inst_30659);

(statearr_30754[(9)] = inst_30658);

(statearr_30754[(21)] = inst_30657);

(statearr_30754[(11)] = inst_30660);

return statearr_30754;
})();
var statearr_30755_30828 = state_30717__$1;
(statearr_30755_30828[(2)] = null);

(statearr_30755_30828[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (43))){
var state_30717__$1 = state_30717;
var statearr_30756_30829 = state_30717__$1;
(statearr_30756_30829[(2)] = null);

(statearr_30756_30829[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (29))){
var inst_30701 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30757_30830 = state_30717__$1;
(statearr_30757_30830[(2)] = inst_30701);

(statearr_30757_30830[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (44))){
var inst_30710 = (state_30717[(2)]);
var state_30717__$1 = (function (){var statearr_30758 = state_30717;
(statearr_30758[(28)] = inst_30710);

return statearr_30758;
})();
var statearr_30759_30831 = state_30717__$1;
(statearr_30759_30831[(2)] = null);

(statearr_30759_30831[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (6))){
var inst_30649 = (state_30717[(29)]);
var inst_30648 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30649__$1 = cljs.core.keys(inst_30648);
var inst_30650 = cljs.core.count(inst_30649__$1);
var inst_30651 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30650) : cljs.core.reset_BANG_.call(null,dctr,inst_30650));
var inst_30656 = cljs.core.seq(inst_30649__$1);
var inst_30657 = inst_30656;
var inst_30658 = null;
var inst_30659 = (0);
var inst_30660 = (0);
var state_30717__$1 = (function (){var statearr_30760 = state_30717;
(statearr_30760[(30)] = inst_30651);

(statearr_30760[(20)] = inst_30659);

(statearr_30760[(9)] = inst_30658);

(statearr_30760[(21)] = inst_30657);

(statearr_30760[(29)] = inst_30649__$1);

(statearr_30760[(11)] = inst_30660);

return statearr_30760;
})();
var statearr_30761_30832 = state_30717__$1;
(statearr_30761_30832[(2)] = null);

(statearr_30761_30832[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (28))){
var inst_30676 = (state_30717[(25)]);
var inst_30657 = (state_30717[(21)]);
var inst_30676__$1 = cljs.core.seq(inst_30657);
var state_30717__$1 = (function (){var statearr_30762 = state_30717;
(statearr_30762[(25)] = inst_30676__$1);

return statearr_30762;
})();
if(inst_30676__$1){
var statearr_30763_30833 = state_30717__$1;
(statearr_30763_30833[(1)] = (33));

} else {
var statearr_30764_30834 = state_30717__$1;
(statearr_30764_30834[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (25))){
var inst_30659 = (state_30717[(20)]);
var inst_30660 = (state_30717[(11)]);
var inst_30662 = (inst_30660 < inst_30659);
var inst_30663 = inst_30662;
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30663)){
var statearr_30765_30835 = state_30717__$1;
(statearr_30765_30835[(1)] = (27));

} else {
var statearr_30766_30836 = state_30717__$1;
(statearr_30766_30836[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (34))){
var state_30717__$1 = state_30717;
var statearr_30767_30837 = state_30717__$1;
(statearr_30767_30837[(2)] = null);

(statearr_30767_30837[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (17))){
var state_30717__$1 = state_30717;
var statearr_30768_30838 = state_30717__$1;
(statearr_30768_30838[(2)] = null);

(statearr_30768_30838[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (3))){
var inst_30715 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30717__$1,inst_30715);
} else {
if((state_val_30718 === (12))){
var inst_30644 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30769_30839 = state_30717__$1;
(statearr_30769_30839[(2)] = inst_30644);

(statearr_30769_30839[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (2))){
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30717__$1,(4),ch);
} else {
if((state_val_30718 === (23))){
var state_30717__$1 = state_30717;
var statearr_30770_30840 = state_30717__$1;
(statearr_30770_30840[(2)] = null);

(statearr_30770_30840[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (35))){
var inst_30699 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30771_30841 = state_30717__$1;
(statearr_30771_30841[(2)] = inst_30699);

(statearr_30771_30841[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (19))){
var inst_30618 = (state_30717[(7)]);
var inst_30622 = cljs.core.chunk_first(inst_30618);
var inst_30623 = cljs.core.chunk_rest(inst_30618);
var inst_30624 = cljs.core.count(inst_30622);
var inst_30598 = inst_30623;
var inst_30599 = inst_30622;
var inst_30600 = inst_30624;
var inst_30601 = (0);
var state_30717__$1 = (function (){var statearr_30772 = state_30717;
(statearr_30772[(13)] = inst_30598);

(statearr_30772[(14)] = inst_30601);

(statearr_30772[(16)] = inst_30599);

(statearr_30772[(17)] = inst_30600);

return statearr_30772;
})();
var statearr_30773_30842 = state_30717__$1;
(statearr_30773_30842[(2)] = null);

(statearr_30773_30842[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (11))){
var inst_30598 = (state_30717[(13)]);
var inst_30618 = (state_30717[(7)]);
var inst_30618__$1 = cljs.core.seq(inst_30598);
var state_30717__$1 = (function (){var statearr_30774 = state_30717;
(statearr_30774[(7)] = inst_30618__$1);

return statearr_30774;
})();
if(inst_30618__$1){
var statearr_30775_30843 = state_30717__$1;
(statearr_30775_30843[(1)] = (16));

} else {
var statearr_30776_30844 = state_30717__$1;
(statearr_30776_30844[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (9))){
var inst_30646 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30777_30845 = state_30717__$1;
(statearr_30777_30845[(2)] = inst_30646);

(statearr_30777_30845[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (5))){
var inst_30596 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30597 = cljs.core.seq(inst_30596);
var inst_30598 = inst_30597;
var inst_30599 = null;
var inst_30600 = (0);
var inst_30601 = (0);
var state_30717__$1 = (function (){var statearr_30778 = state_30717;
(statearr_30778[(13)] = inst_30598);

(statearr_30778[(14)] = inst_30601);

(statearr_30778[(16)] = inst_30599);

(statearr_30778[(17)] = inst_30600);

return statearr_30778;
})();
var statearr_30779_30846 = state_30717__$1;
(statearr_30779_30846[(2)] = null);

(statearr_30779_30846[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (14))){
var state_30717__$1 = state_30717;
var statearr_30780_30847 = state_30717__$1;
(statearr_30780_30847[(2)] = null);

(statearr_30780_30847[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (45))){
var inst_30707 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30781_30848 = state_30717__$1;
(statearr_30781_30848[(2)] = inst_30707);

(statearr_30781_30848[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (26))){
var inst_30649 = (state_30717[(29)]);
var inst_30703 = (state_30717[(2)]);
var inst_30704 = cljs.core.seq(inst_30649);
var state_30717__$1 = (function (){var statearr_30782 = state_30717;
(statearr_30782[(31)] = inst_30703);

return statearr_30782;
})();
if(inst_30704){
var statearr_30783_30849 = state_30717__$1;
(statearr_30783_30849[(1)] = (42));

} else {
var statearr_30784_30850 = state_30717__$1;
(statearr_30784_30850[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (16))){
var inst_30618 = (state_30717[(7)]);
var inst_30620 = cljs.core.chunked_seq_QMARK_(inst_30618);
var state_30717__$1 = state_30717;
if(inst_30620){
var statearr_30785_30851 = state_30717__$1;
(statearr_30785_30851[(1)] = (19));

} else {
var statearr_30786_30852 = state_30717__$1;
(statearr_30786_30852[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (38))){
var inst_30696 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30787_30853 = state_30717__$1;
(statearr_30787_30853[(2)] = inst_30696);

(statearr_30787_30853[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (30))){
var state_30717__$1 = state_30717;
var statearr_30788_30854 = state_30717__$1;
(statearr_30788_30854[(2)] = null);

(statearr_30788_30854[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (10))){
var inst_30601 = (state_30717[(14)]);
var inst_30599 = (state_30717[(16)]);
var inst_30607 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30599,inst_30601);
var inst_30608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30607,(0),null);
var inst_30609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30607,(1),null);
var state_30717__$1 = (function (){var statearr_30789 = state_30717;
(statearr_30789[(26)] = inst_30608);

return statearr_30789;
})();
if(cljs.core.truth_(inst_30609)){
var statearr_30790_30855 = state_30717__$1;
(statearr_30790_30855[(1)] = (13));

} else {
var statearr_30791_30856 = state_30717__$1;
(statearr_30791_30856[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (18))){
var inst_30642 = (state_30717[(2)]);
var state_30717__$1 = state_30717;
var statearr_30792_30857 = state_30717__$1;
(statearr_30792_30857[(2)] = inst_30642);

(statearr_30792_30857[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (42))){
var state_30717__$1 = state_30717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30717__$1,(45),dchan);
} else {
if((state_val_30718 === (37))){
var inst_30685 = (state_30717[(23)]);
var inst_30676 = (state_30717[(25)]);
var inst_30589 = (state_30717[(12)]);
var inst_30685__$1 = cljs.core.first(inst_30676);
var inst_30686 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30685__$1,inst_30589,done);
var state_30717__$1 = (function (){var statearr_30793 = state_30717;
(statearr_30793[(23)] = inst_30685__$1);

return statearr_30793;
})();
if(cljs.core.truth_(inst_30686)){
var statearr_30794_30858 = state_30717__$1;
(statearr_30794_30858[(1)] = (39));

} else {
var statearr_30795_30859 = state_30717__$1;
(statearr_30795_30859[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30718 === (8))){
var inst_30601 = (state_30717[(14)]);
var inst_30600 = (state_30717[(17)]);
var inst_30603 = (inst_30601 < inst_30600);
var inst_30604 = inst_30603;
var state_30717__$1 = state_30717;
if(cljs.core.truth_(inst_30604)){
var statearr_30796_30860 = state_30717__$1;
(statearr_30796_30860[(1)] = (10));

} else {
var statearr_30797_30861 = state_30717__$1;
(statearr_30797_30861[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___30807,cs,m,dchan,dctr,done))
;
return ((function (switch__11666__auto__,c__11731__auto___30807,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11667__auto__ = null;
var cljs$core$async$mult_$_state_machine__11667__auto____0 = (function (){
var statearr_30801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30801[(0)] = cljs$core$async$mult_$_state_machine__11667__auto__);

(statearr_30801[(1)] = (1));

return statearr_30801;
});
var cljs$core$async$mult_$_state_machine__11667__auto____1 = (function (state_30717){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_30717);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e30802){if((e30802 instanceof Object)){
var ex__11670__auto__ = e30802;
var statearr_30803_30862 = state_30717;
(statearr_30803_30862[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30717);

return cljs.core.constant$keyword$recur;
} else {
throw e30802;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__30863 = state_30717;
state_30717 = G__30863;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11667__auto__ = function(state_30717){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11667__auto____1.call(this,state_30717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11667__auto____0;
cljs$core$async$mult_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11667__auto____1;
return cljs$core$async$mult_$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___30807,cs,m,dchan,dctr,done))
})();
var state__11733__auto__ = (function (){var statearr_30804 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_30804[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___30807);

return statearr_30804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___30807,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30864 = [];
var len__9081__auto___30867 = arguments.length;
var i__9082__auto___30868 = (0);
while(true){
if((i__9082__auto___30868 < len__9081__auto___30867)){
args30864.push((arguments[i__9082__auto___30868]));

var G__30869 = (i__9082__auto___30868 + (1));
i__9082__auto___30868 = G__30869;
continue;
} else {
}
break;
}

var G__30866 = args30864.length;
switch (G__30866) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30864.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto__.call(null,m,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8679__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto__.call(null,m));
} else {
var m__8679__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8679__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8679__auto__.call(null,m,state_map));
} else {
var m__8679__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8679__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8678__auto__ = (((m == null))?null:m);
var m__8679__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8679__auto__.call(null,m,mode));
} else {
var m__8679__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8679__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__9088__auto__ = [];
var len__9081__auto___30883 = arguments.length;
var i__9082__auto___30884 = (0);
while(true){
if((i__9082__auto___30884 < len__9081__auto___30883)){
args__9088__auto__.push((arguments[i__9082__auto___30884]));

var G__30885 = (i__9082__auto___30884 + (1));
i__9082__auto___30884 = G__30885;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((3) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9089__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30877){
var map__30878 = p__30877;
var map__30878__$1 = ((((!((map__30878 == null)))?((((map__30878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30878):map__30878);
var opts = map__30878__$1;
var statearr_30880_30886 = state;
(statearr_30880_30886[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__30878,map__30878__$1,opts){
return (function (val){
var statearr_30881_30887 = state;
(statearr_30881_30887[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30878,map__30878__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30882_30888 = state;
(statearr_30882_30888[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30873){
var G__30874 = cljs.core.first(seq30873);
var seq30873__$1 = cljs.core.next(seq30873);
var G__30875 = cljs.core.first(seq30873__$1);
var seq30873__$2 = cljs.core.next(seq30873__$1);
var G__30876 = cljs.core.first(seq30873__$2);
var seq30873__$3 = cljs.core.next(seq30873__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30874,G__30875,G__30876,seq30873__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__31055 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31055) : cljs.core.atom.call(null,G__31055));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.constant$keyword$mute) : cljs.core.atom.call(null,cljs.core.constant$keyword$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t31056 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31056 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31057){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31057 = meta31057;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31056.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31058,meta31057__$1){
var self__ = this;
var _31058__$1 = this;
return (new cljs.core.async.t31056(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31057__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31058){
var self__ = this;
var _31058__$1 = this;
return self__.meta31057;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31056.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31059_31221 = self__.cs;
var G__31060_31222 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31059_31221,G__31060_31222) : cljs.core.reset_BANG_.call(null,G__31059_31221,G__31060_31222));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31057","meta31057",1649658001,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t31056.cljs$lang$type = true;

cljs.core.async.t31056.cljs$lang$ctorStr = "cljs.core.async/t31056";

cljs.core.async.t31056.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31056");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t31056 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t31056(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31057){
return (new cljs.core.async.t31056(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31057));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t31056(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11731__auto___31223 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31158){
var state_val_31159 = (state_31158[(1)]);
if((state_val_31159 === (7))){
var inst_31076 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
var statearr_31160_31224 = state_31158__$1;
(statearr_31160_31224[(2)] = inst_31076);

(statearr_31160_31224[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (20))){
var inst_31088 = (state_31158[(7)]);
var state_31158__$1 = state_31158;
var statearr_31161_31225 = state_31158__$1;
(statearr_31161_31225[(2)] = inst_31088);

(statearr_31161_31225[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (27))){
var state_31158__$1 = state_31158;
var statearr_31162_31226 = state_31158__$1;
(statearr_31162_31226[(2)] = null);

(statearr_31162_31226[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (1))){
var inst_31064 = (state_31158[(8)]);
var inst_31064__$1 = calc_state();
var inst_31066 = (inst_31064__$1 == null);
var inst_31067 = cljs.core.not(inst_31066);
var state_31158__$1 = (function (){var statearr_31163 = state_31158;
(statearr_31163[(8)] = inst_31064__$1);

return statearr_31163;
})();
if(inst_31067){
var statearr_31164_31227 = state_31158__$1;
(statearr_31164_31227[(1)] = (2));

} else {
var statearr_31165_31228 = state_31158__$1;
(statearr_31165_31228[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (24))){
var inst_31118 = (state_31158[(9)]);
var inst_31132 = (state_31158[(10)]);
var inst_31111 = (state_31158[(11)]);
var inst_31132__$1 = (inst_31111.cljs$core$IFn$_invoke$arity$1 ? inst_31111.cljs$core$IFn$_invoke$arity$1(inst_31118) : inst_31111.call(null,inst_31118));
var state_31158__$1 = (function (){var statearr_31166 = state_31158;
(statearr_31166[(10)] = inst_31132__$1);

return statearr_31166;
})();
if(cljs.core.truth_(inst_31132__$1)){
var statearr_31167_31229 = state_31158__$1;
(statearr_31167_31229[(1)] = (29));

} else {
var statearr_31168_31230 = state_31158__$1;
(statearr_31168_31230[(1)] = (30));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (4))){
var inst_31079 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31079)){
var statearr_31169_31231 = state_31158__$1;
(statearr_31169_31231[(1)] = (8));

} else {
var statearr_31170_31232 = state_31158__$1;
(statearr_31170_31232[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (15))){
var inst_31105 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31105)){
var statearr_31171_31233 = state_31158__$1;
(statearr_31171_31233[(1)] = (19));

} else {
var statearr_31172_31234 = state_31158__$1;
(statearr_31172_31234[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (21))){
var inst_31110 = (state_31158[(12)]);
var inst_31110__$1 = (state_31158[(2)]);
var inst_31111 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31110__$1,cljs.core.constant$keyword$solos);
var inst_31112 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31110__$1,cljs.core.constant$keyword$mutes);
var inst_31113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31110__$1,cljs.core.constant$keyword$reads);
var state_31158__$1 = (function (){var statearr_31173 = state_31158;
(statearr_31173[(11)] = inst_31111);

(statearr_31173[(13)] = inst_31112);

(statearr_31173[(12)] = inst_31110__$1);

return statearr_31173;
})();
return cljs.core.async.ioc_alts_BANG_(state_31158__$1,(22),inst_31113);
} else {
if((state_val_31159 === (31))){
var inst_31140 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31140)){
var statearr_31174_31235 = state_31158__$1;
(statearr_31174_31235[(1)] = (32));

} else {
var statearr_31175_31236 = state_31158__$1;
(statearr_31175_31236[(1)] = (33));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (32))){
var inst_31117 = (state_31158[(14)]);
var state_31158__$1 = state_31158;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31158__$1,(35),out,inst_31117);
} else {
if((state_val_31159 === (33))){
var inst_31110 = (state_31158[(12)]);
var inst_31088 = inst_31110;
var state_31158__$1 = (function (){var statearr_31176 = state_31158;
(statearr_31176[(7)] = inst_31088);

return statearr_31176;
})();
var statearr_31177_31237 = state_31158__$1;
(statearr_31177_31237[(2)] = null);

(statearr_31177_31237[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (13))){
var inst_31088 = (state_31158[(7)]);
var inst_31095 = inst_31088.cljs$lang$protocol_mask$partition0$;
var inst_31096 = (inst_31095 & (64));
var inst_31097 = inst_31088.cljs$core$ISeq$;
var inst_31098 = (inst_31096) || (inst_31097);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31098)){
var statearr_31178_31238 = state_31158__$1;
(statearr_31178_31238[(1)] = (16));

} else {
var statearr_31179_31239 = state_31158__$1;
(statearr_31179_31239[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (22))){
var inst_31118 = (state_31158[(9)]);
var inst_31117 = (state_31158[(14)]);
var inst_31116 = (state_31158[(2)]);
var inst_31117__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31116,(0),null);
var inst_31118__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31116,(1),null);
var inst_31119 = (inst_31117__$1 == null);
var inst_31120 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31118__$1,change);
var inst_31121 = (inst_31119) || (inst_31120);
var state_31158__$1 = (function (){var statearr_31180 = state_31158;
(statearr_31180[(9)] = inst_31118__$1);

(statearr_31180[(14)] = inst_31117__$1);

return statearr_31180;
})();
if(cljs.core.truth_(inst_31121)){
var statearr_31181_31240 = state_31158__$1;
(statearr_31181_31240[(1)] = (23));

} else {
var statearr_31182_31241 = state_31158__$1;
(statearr_31182_31241[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (36))){
var inst_31110 = (state_31158[(12)]);
var inst_31088 = inst_31110;
var state_31158__$1 = (function (){var statearr_31183 = state_31158;
(statearr_31183[(7)] = inst_31088);

return statearr_31183;
})();
var statearr_31184_31242 = state_31158__$1;
(statearr_31184_31242[(2)] = null);

(statearr_31184_31242[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (29))){
var inst_31132 = (state_31158[(10)]);
var state_31158__$1 = state_31158;
var statearr_31185_31243 = state_31158__$1;
(statearr_31185_31243[(2)] = inst_31132);

(statearr_31185_31243[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (6))){
var state_31158__$1 = state_31158;
var statearr_31186_31244 = state_31158__$1;
(statearr_31186_31244[(2)] = false);

(statearr_31186_31244[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (28))){
var inst_31128 = (state_31158[(2)]);
var inst_31129 = calc_state();
var inst_31088 = inst_31129;
var state_31158__$1 = (function (){var statearr_31187 = state_31158;
(statearr_31187[(15)] = inst_31128);

(statearr_31187[(7)] = inst_31088);

return statearr_31187;
})();
var statearr_31188_31245 = state_31158__$1;
(statearr_31188_31245[(2)] = null);

(statearr_31188_31245[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (25))){
var inst_31154 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
var statearr_31189_31246 = state_31158__$1;
(statearr_31189_31246[(2)] = inst_31154);

(statearr_31189_31246[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (34))){
var inst_31152 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
var statearr_31190_31247 = state_31158__$1;
(statearr_31190_31247[(2)] = inst_31152);

(statearr_31190_31247[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (17))){
var state_31158__$1 = state_31158;
var statearr_31191_31248 = state_31158__$1;
(statearr_31191_31248[(2)] = false);

(statearr_31191_31248[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (3))){
var state_31158__$1 = state_31158;
var statearr_31192_31249 = state_31158__$1;
(statearr_31192_31249[(2)] = false);

(statearr_31192_31249[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (12))){
var inst_31156 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31158__$1,inst_31156);
} else {
if((state_val_31159 === (2))){
var inst_31064 = (state_31158[(8)]);
var inst_31069 = inst_31064.cljs$lang$protocol_mask$partition0$;
var inst_31070 = (inst_31069 & (64));
var inst_31071 = inst_31064.cljs$core$ISeq$;
var inst_31072 = (inst_31070) || (inst_31071);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31072)){
var statearr_31193_31250 = state_31158__$1;
(statearr_31193_31250[(1)] = (5));

} else {
var statearr_31194_31251 = state_31158__$1;
(statearr_31194_31251[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (23))){
var inst_31117 = (state_31158[(14)]);
var inst_31123 = (inst_31117 == null);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31123)){
var statearr_31195_31252 = state_31158__$1;
(statearr_31195_31252[(1)] = (26));

} else {
var statearr_31196_31253 = state_31158__$1;
(statearr_31196_31253[(1)] = (27));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (35))){
var inst_31143 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
if(cljs.core.truth_(inst_31143)){
var statearr_31197_31254 = state_31158__$1;
(statearr_31197_31254[(1)] = (36));

} else {
var statearr_31198_31255 = state_31158__$1;
(statearr_31198_31255[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (19))){
var inst_31088 = (state_31158[(7)]);
var inst_31107 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31088);
var state_31158__$1 = state_31158;
var statearr_31199_31256 = state_31158__$1;
(statearr_31199_31256[(2)] = inst_31107);

(statearr_31199_31256[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (11))){
var inst_31088 = (state_31158[(7)]);
var inst_31092 = (inst_31088 == null);
var inst_31093 = cljs.core.not(inst_31092);
var state_31158__$1 = state_31158;
if(inst_31093){
var statearr_31200_31257 = state_31158__$1;
(statearr_31200_31257[(1)] = (13));

} else {
var statearr_31201_31258 = state_31158__$1;
(statearr_31201_31258[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (9))){
var inst_31064 = (state_31158[(8)]);
var state_31158__$1 = state_31158;
var statearr_31202_31259 = state_31158__$1;
(statearr_31202_31259[(2)] = inst_31064);

(statearr_31202_31259[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (5))){
var state_31158__$1 = state_31158;
var statearr_31203_31260 = state_31158__$1;
(statearr_31203_31260[(2)] = true);

(statearr_31203_31260[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (14))){
var state_31158__$1 = state_31158;
var statearr_31204_31261 = state_31158__$1;
(statearr_31204_31261[(2)] = false);

(statearr_31204_31261[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (26))){
var inst_31118 = (state_31158[(9)]);
var inst_31125 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31118);
var state_31158__$1 = state_31158;
var statearr_31205_31262 = state_31158__$1;
(statearr_31205_31262[(2)] = inst_31125);

(statearr_31205_31262[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (16))){
var state_31158__$1 = state_31158;
var statearr_31206_31263 = state_31158__$1;
(statearr_31206_31263[(2)] = true);

(statearr_31206_31263[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (38))){
var inst_31148 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
var statearr_31207_31264 = state_31158__$1;
(statearr_31207_31264[(2)] = inst_31148);

(statearr_31207_31264[(1)] = (34));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (30))){
var inst_31118 = (state_31158[(9)]);
var inst_31111 = (state_31158[(11)]);
var inst_31112 = (state_31158[(13)]);
var inst_31135 = cljs.core.empty_QMARK_(inst_31111);
var inst_31136 = (inst_31112.cljs$core$IFn$_invoke$arity$1 ? inst_31112.cljs$core$IFn$_invoke$arity$1(inst_31118) : inst_31112.call(null,inst_31118));
var inst_31137 = cljs.core.not(inst_31136);
var inst_31138 = (inst_31135) && (inst_31137);
var state_31158__$1 = state_31158;
var statearr_31208_31265 = state_31158__$1;
(statearr_31208_31265[(2)] = inst_31138);

(statearr_31208_31265[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (10))){
var inst_31064 = (state_31158[(8)]);
var inst_31084 = (state_31158[(2)]);
var inst_31085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31084,cljs.core.constant$keyword$solos);
var inst_31086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31084,cljs.core.constant$keyword$mutes);
var inst_31087 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31084,cljs.core.constant$keyword$reads);
var inst_31088 = inst_31064;
var state_31158__$1 = (function (){var statearr_31209 = state_31158;
(statearr_31209[(16)] = inst_31086);

(statearr_31209[(17)] = inst_31087);

(statearr_31209[(7)] = inst_31088);

(statearr_31209[(18)] = inst_31085);

return statearr_31209;
})();
var statearr_31210_31266 = state_31158__$1;
(statearr_31210_31266[(2)] = null);

(statearr_31210_31266[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (18))){
var inst_31102 = (state_31158[(2)]);
var state_31158__$1 = state_31158;
var statearr_31211_31267 = state_31158__$1;
(statearr_31211_31267[(2)] = inst_31102);

(statearr_31211_31267[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (37))){
var state_31158__$1 = state_31158;
var statearr_31212_31268 = state_31158__$1;
(statearr_31212_31268[(2)] = null);

(statearr_31212_31268[(1)] = (38));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31159 === (8))){
var inst_31064 = (state_31158[(8)]);
var inst_31081 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31064);
var state_31158__$1 = state_31158;
var statearr_31213_31269 = state_31158__$1;
(statearr_31213_31269[(2)] = inst_31081);

(statearr_31213_31269[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11666__auto__,c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11667__auto__ = null;
var cljs$core$async$mix_$_state_machine__11667__auto____0 = (function (){
var statearr_31217 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31217[(0)] = cljs$core$async$mix_$_state_machine__11667__auto__);

(statearr_31217[(1)] = (1));

return statearr_31217;
});
var cljs$core$async$mix_$_state_machine__11667__auto____1 = (function (state_31158){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31158);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31218){if((e31218 instanceof Object)){
var ex__11670__auto__ = e31218;
var statearr_31219_31270 = state_31158;
(statearr_31219_31270[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31158);

return cljs.core.constant$keyword$recur;
} else {
throw e31218;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31271 = state_31158;
state_31158 = G__31271;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11667__auto__ = function(state_31158){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11667__auto____1.call(this,state_31158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11667__auto____0;
cljs$core$async$mix_$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11667__auto____1;
return cljs$core$async$mix_$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11733__auto__ = (function (){var statearr_31220 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31220[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31223);

return statearr_31220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31223,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8679__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8679__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8679__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8679__auto__.call(null,p,v,ch));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8679__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args31274 = [];
var len__9081__auto___31277 = arguments.length;
var i__9082__auto___31278 = (0);
while(true){
if((i__9082__auto___31278 < len__9081__auto___31277)){
args31274.push((arguments[i__9082__auto___31278]));

var G__31279 = (i__9082__auto___31278 + (1));
i__9082__auto___31278 = G__31279;
continue;
} else {
}
break;
}

var G__31276 = args31274.length;
switch (G__31276) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31274.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8679__auto__.call(null,p));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8679__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8678__auto__ = (((p == null))?null:p);
var m__8679__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8679__auto__.call(null,p,v));
} else {
var m__8679__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8679__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args31282 = [];
var len__9081__auto___31410 = arguments.length;
var i__9082__auto___31411 = (0);
while(true){
if((i__9082__auto___31411 < len__9081__auto___31410)){
args31282.push((arguments[i__9082__auto___31411]));

var G__31412 = (i__9082__auto___31411 + (1));
i__9082__auto___31411 = G__31412;
continue;
} else {
}
break;
}

var G__31284 = args31282.length;
switch (G__31284) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31282.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__31285 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31285) : cljs.core.atom.call(null,G__31285));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__8042__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8042__auto__,mults){
return (function (p1__31281_SHARP_){
if(cljs.core.truth_((p1__31281_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31281_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31281_SHARP_.call(null,topic)))){
return p1__31281_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31281_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8042__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t31286 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31286 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31287){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31287 = meta31287;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31286.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31288,meta31287__$1){
var self__ = this;
var _31288__$1 = this;
return (new cljs.core.async.t31286(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31287__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31288){
var self__ = this;
var _31288__$1 = this;
return self__.meta31287;
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31286.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t31286.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31289 = self__.mults;
var G__31290 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31289,G__31290) : cljs.core.reset_BANG_.call(null,G__31289,G__31290));
});})(mults,ensure_mult))
;

cljs.core.async.t31286.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t31286.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31287","meta31287",-482560313,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t31286.cljs$lang$type = true;

cljs.core.async.t31286.cljs$lang$ctorStr = "cljs.core.async/t31286";

cljs.core.async.t31286.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31286");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t31286 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t31286(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31287){
return (new cljs.core.async.t31286(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31287));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t31286(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11731__auto___31414 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31414,mults,ensure_mult,p){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31414,mults,ensure_mult,p){
return (function (state_31362){
var state_val_31363 = (state_31362[(1)]);
if((state_val_31363 === (7))){
var inst_31358 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31364_31415 = state_31362__$1;
(statearr_31364_31415[(2)] = inst_31358);

(statearr_31364_31415[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (20))){
var state_31362__$1 = state_31362;
var statearr_31365_31416 = state_31362__$1;
(statearr_31365_31416[(2)] = null);

(statearr_31365_31416[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (1))){
var state_31362__$1 = state_31362;
var statearr_31366_31417 = state_31362__$1;
(statearr_31366_31417[(2)] = null);

(statearr_31366_31417[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (24))){
var inst_31341 = (state_31362[(7)]);
var inst_31350 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31341);
var state_31362__$1 = state_31362;
var statearr_31367_31418 = state_31362__$1;
(statearr_31367_31418[(2)] = inst_31350);

(statearr_31367_31418[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (4))){
var inst_31293 = (state_31362[(8)]);
var inst_31293__$1 = (state_31362[(2)]);
var inst_31294 = (inst_31293__$1 == null);
var state_31362__$1 = (function (){var statearr_31368 = state_31362;
(statearr_31368[(8)] = inst_31293__$1);

return statearr_31368;
})();
if(cljs.core.truth_(inst_31294)){
var statearr_31369_31419 = state_31362__$1;
(statearr_31369_31419[(1)] = (5));

} else {
var statearr_31370_31420 = state_31362__$1;
(statearr_31370_31420[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (15))){
var inst_31335 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31371_31421 = state_31362__$1;
(statearr_31371_31421[(2)] = inst_31335);

(statearr_31371_31421[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (21))){
var inst_31355 = (state_31362[(2)]);
var state_31362__$1 = (function (){var statearr_31372 = state_31362;
(statearr_31372[(9)] = inst_31355);

return statearr_31372;
})();
var statearr_31373_31422 = state_31362__$1;
(statearr_31373_31422[(2)] = null);

(statearr_31373_31422[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (13))){
var inst_31317 = (state_31362[(10)]);
var inst_31319 = cljs.core.chunked_seq_QMARK_(inst_31317);
var state_31362__$1 = state_31362;
if(inst_31319){
var statearr_31374_31423 = state_31362__$1;
(statearr_31374_31423[(1)] = (16));

} else {
var statearr_31375_31424 = state_31362__$1;
(statearr_31375_31424[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (22))){
var inst_31347 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
if(cljs.core.truth_(inst_31347)){
var statearr_31376_31425 = state_31362__$1;
(statearr_31376_31425[(1)] = (23));

} else {
var statearr_31377_31426 = state_31362__$1;
(statearr_31377_31426[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (6))){
var inst_31341 = (state_31362[(7)]);
var inst_31343 = (state_31362[(11)]);
var inst_31293 = (state_31362[(8)]);
var inst_31341__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31293) : topic_fn.call(null,inst_31293));
var inst_31342 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31343__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31342,inst_31341__$1);
var state_31362__$1 = (function (){var statearr_31378 = state_31362;
(statearr_31378[(7)] = inst_31341__$1);

(statearr_31378[(11)] = inst_31343__$1);

return statearr_31378;
})();
if(cljs.core.truth_(inst_31343__$1)){
var statearr_31379_31427 = state_31362__$1;
(statearr_31379_31427[(1)] = (19));

} else {
var statearr_31380_31428 = state_31362__$1;
(statearr_31380_31428[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (25))){
var inst_31352 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31381_31429 = state_31362__$1;
(statearr_31381_31429[(2)] = inst_31352);

(statearr_31381_31429[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (17))){
var inst_31317 = (state_31362[(10)]);
var inst_31326 = cljs.core.first(inst_31317);
var inst_31327 = cljs.core.async.muxch_STAR_(inst_31326);
var inst_31328 = cljs.core.async.close_BANG_(inst_31327);
var inst_31329 = cljs.core.next(inst_31317);
var inst_31303 = inst_31329;
var inst_31304 = null;
var inst_31305 = (0);
var inst_31306 = (0);
var state_31362__$1 = (function (){var statearr_31382 = state_31362;
(statearr_31382[(12)] = inst_31306);

(statearr_31382[(13)] = inst_31328);

(statearr_31382[(14)] = inst_31303);

(statearr_31382[(15)] = inst_31304);

(statearr_31382[(16)] = inst_31305);

return statearr_31382;
})();
var statearr_31383_31430 = state_31362__$1;
(statearr_31383_31430[(2)] = null);

(statearr_31383_31430[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (3))){
var inst_31360 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31362__$1,inst_31360);
} else {
if((state_val_31363 === (12))){
var inst_31337 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31384_31431 = state_31362__$1;
(statearr_31384_31431[(2)] = inst_31337);

(statearr_31384_31431[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (2))){
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31362__$1,(4),ch);
} else {
if((state_val_31363 === (23))){
var state_31362__$1 = state_31362;
var statearr_31385_31432 = state_31362__$1;
(statearr_31385_31432[(2)] = null);

(statearr_31385_31432[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (19))){
var inst_31343 = (state_31362[(11)]);
var inst_31293 = (state_31362[(8)]);
var inst_31345 = cljs.core.async.muxch_STAR_(inst_31343);
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31362__$1,(22),inst_31345,inst_31293);
} else {
if((state_val_31363 === (11))){
var inst_31303 = (state_31362[(14)]);
var inst_31317 = (state_31362[(10)]);
var inst_31317__$1 = cljs.core.seq(inst_31303);
var state_31362__$1 = (function (){var statearr_31386 = state_31362;
(statearr_31386[(10)] = inst_31317__$1);

return statearr_31386;
})();
if(inst_31317__$1){
var statearr_31387_31433 = state_31362__$1;
(statearr_31387_31433[(1)] = (13));

} else {
var statearr_31388_31434 = state_31362__$1;
(statearr_31388_31434[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (9))){
var inst_31339 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31389_31435 = state_31362__$1;
(statearr_31389_31435[(2)] = inst_31339);

(statearr_31389_31435[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (5))){
var inst_31300 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31301 = cljs.core.vals(inst_31300);
var inst_31302 = cljs.core.seq(inst_31301);
var inst_31303 = inst_31302;
var inst_31304 = null;
var inst_31305 = (0);
var inst_31306 = (0);
var state_31362__$1 = (function (){var statearr_31390 = state_31362;
(statearr_31390[(12)] = inst_31306);

(statearr_31390[(14)] = inst_31303);

(statearr_31390[(15)] = inst_31304);

(statearr_31390[(16)] = inst_31305);

return statearr_31390;
})();
var statearr_31391_31436 = state_31362__$1;
(statearr_31391_31436[(2)] = null);

(statearr_31391_31436[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (14))){
var state_31362__$1 = state_31362;
var statearr_31395_31437 = state_31362__$1;
(statearr_31395_31437[(2)] = null);

(statearr_31395_31437[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (16))){
var inst_31317 = (state_31362[(10)]);
var inst_31321 = cljs.core.chunk_first(inst_31317);
var inst_31322 = cljs.core.chunk_rest(inst_31317);
var inst_31323 = cljs.core.count(inst_31321);
var inst_31303 = inst_31322;
var inst_31304 = inst_31321;
var inst_31305 = inst_31323;
var inst_31306 = (0);
var state_31362__$1 = (function (){var statearr_31396 = state_31362;
(statearr_31396[(12)] = inst_31306);

(statearr_31396[(14)] = inst_31303);

(statearr_31396[(15)] = inst_31304);

(statearr_31396[(16)] = inst_31305);

return statearr_31396;
})();
var statearr_31397_31438 = state_31362__$1;
(statearr_31397_31438[(2)] = null);

(statearr_31397_31438[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (10))){
var inst_31306 = (state_31362[(12)]);
var inst_31303 = (state_31362[(14)]);
var inst_31304 = (state_31362[(15)]);
var inst_31305 = (state_31362[(16)]);
var inst_31311 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31304,inst_31306);
var inst_31312 = cljs.core.async.muxch_STAR_(inst_31311);
var inst_31313 = cljs.core.async.close_BANG_(inst_31312);
var inst_31314 = (inst_31306 + (1));
var tmp31392 = inst_31303;
var tmp31393 = inst_31304;
var tmp31394 = inst_31305;
var inst_31303__$1 = tmp31392;
var inst_31304__$1 = tmp31393;
var inst_31305__$1 = tmp31394;
var inst_31306__$1 = inst_31314;
var state_31362__$1 = (function (){var statearr_31398 = state_31362;
(statearr_31398[(12)] = inst_31306__$1);

(statearr_31398[(14)] = inst_31303__$1);

(statearr_31398[(15)] = inst_31304__$1);

(statearr_31398[(16)] = inst_31305__$1);

(statearr_31398[(17)] = inst_31313);

return statearr_31398;
})();
var statearr_31399_31439 = state_31362__$1;
(statearr_31399_31439[(2)] = null);

(statearr_31399_31439[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (18))){
var inst_31332 = (state_31362[(2)]);
var state_31362__$1 = state_31362;
var statearr_31400_31440 = state_31362__$1;
(statearr_31400_31440[(2)] = inst_31332);

(statearr_31400_31440[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31363 === (8))){
var inst_31306 = (state_31362[(12)]);
var inst_31305 = (state_31362[(16)]);
var inst_31308 = (inst_31306 < inst_31305);
var inst_31309 = inst_31308;
var state_31362__$1 = state_31362;
if(cljs.core.truth_(inst_31309)){
var statearr_31401_31441 = state_31362__$1;
(statearr_31401_31441[(1)] = (10));

} else {
var statearr_31402_31442 = state_31362__$1;
(statearr_31402_31442[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31414,mults,ensure_mult,p))
;
return ((function (switch__11666__auto__,c__11731__auto___31414,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_31406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31406[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_31406[(1)] = (1));

return statearr_31406;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_31362){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31362);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31407){if((e31407 instanceof Object)){
var ex__11670__auto__ = e31407;
var statearr_31408_31443 = state_31362;
(statearr_31408_31443[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31362);

return cljs.core.constant$keyword$recur;
} else {
throw e31407;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31444 = state_31362;
state_31362 = G__31444;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_31362){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_31362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31414,mults,ensure_mult,p))
})();
var state__11733__auto__ = (function (){var statearr_31409 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31414);

return statearr_31409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31414,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31445 = [];
var len__9081__auto___31448 = arguments.length;
var i__9082__auto___31449 = (0);
while(true){
if((i__9082__auto___31449 < len__9081__auto___31448)){
args31445.push((arguments[i__9082__auto___31449]));

var G__31450 = (i__9082__auto___31449 + (1));
i__9082__auto___31449 = G__31450;
continue;
} else {
}
break;
}

var G__31447 = args31445.length;
switch (G__31447) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31445.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31452 = [];
var len__9081__auto___31455 = arguments.length;
var i__9082__auto___31456 = (0);
while(true){
if((i__9082__auto___31456 < len__9081__auto___31455)){
args31452.push((arguments[i__9082__auto___31456]));

var G__31457 = (i__9082__auto___31456 + (1));
i__9082__auto___31456 = G__31457;
continue;
} else {
}
break;
}

var G__31454 = args31452.length;
switch (G__31454) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31452.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31459 = [];
var len__9081__auto___31530 = arguments.length;
var i__9082__auto___31531 = (0);
while(true){
if((i__9082__auto___31531 < len__9081__auto___31530)){
args31459.push((arguments[i__9082__auto___31531]));

var G__31532 = (i__9082__auto___31531 + (1));
i__9082__auto___31531 = G__31532;
continue;
} else {
}
break;
}

var G__31461 = args31459.length;
switch (G__31461) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31459.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11731__auto___31534 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31500){
var state_val_31501 = (state_31500[(1)]);
if((state_val_31501 === (7))){
var state_31500__$1 = state_31500;
var statearr_31502_31535 = state_31500__$1;
(statearr_31502_31535[(2)] = null);

(statearr_31502_31535[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (1))){
var state_31500__$1 = state_31500;
var statearr_31503_31536 = state_31500__$1;
(statearr_31503_31536[(2)] = null);

(statearr_31503_31536[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (4))){
var inst_31464 = (state_31500[(7)]);
var inst_31466 = (inst_31464 < cnt);
var state_31500__$1 = state_31500;
if(cljs.core.truth_(inst_31466)){
var statearr_31504_31537 = state_31500__$1;
(statearr_31504_31537[(1)] = (6));

} else {
var statearr_31505_31538 = state_31500__$1;
(statearr_31505_31538[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (15))){
var inst_31496 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31506_31539 = state_31500__$1;
(statearr_31506_31539[(2)] = inst_31496);

(statearr_31506_31539[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (13))){
var inst_31489 = cljs.core.async.close_BANG_(out);
var state_31500__$1 = state_31500;
var statearr_31507_31540 = state_31500__$1;
(statearr_31507_31540[(2)] = inst_31489);

(statearr_31507_31540[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (6))){
var state_31500__$1 = state_31500;
var statearr_31508_31541 = state_31500__$1;
(statearr_31508_31541[(2)] = null);

(statearr_31508_31541[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (3))){
var inst_31498 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31500__$1,inst_31498);
} else {
if((state_val_31501 === (12))){
var inst_31486 = (state_31500[(8)]);
var inst_31486__$1 = (state_31500[(2)]);
var inst_31487 = cljs.core.some(cljs.core.nil_QMARK_,inst_31486__$1);
var state_31500__$1 = (function (){var statearr_31509 = state_31500;
(statearr_31509[(8)] = inst_31486__$1);

return statearr_31509;
})();
if(cljs.core.truth_(inst_31487)){
var statearr_31510_31542 = state_31500__$1;
(statearr_31510_31542[(1)] = (13));

} else {
var statearr_31511_31543 = state_31500__$1;
(statearr_31511_31543[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (2))){
var inst_31463 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_31464 = (0);
var state_31500__$1 = (function (){var statearr_31512 = state_31500;
(statearr_31512[(7)] = inst_31464);

(statearr_31512[(9)] = inst_31463);

return statearr_31512;
})();
var statearr_31513_31544 = state_31500__$1;
(statearr_31513_31544[(2)] = null);

(statearr_31513_31544[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (11))){
var inst_31464 = (state_31500[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_31500,(10),Object,null,(9));
var inst_31473 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31464) : chs__$1.call(null,inst_31464));
var inst_31474 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31464) : done.call(null,inst_31464));
var inst_31475 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31473,inst_31474);
var state_31500__$1 = state_31500;
var statearr_31514_31545 = state_31500__$1;
(statearr_31514_31545[(2)] = inst_31475);


cljs.core.async.impl.ioc_helpers.process_exception(state_31500__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (9))){
var inst_31464 = (state_31500[(7)]);
var inst_31477 = (state_31500[(2)]);
var inst_31478 = (inst_31464 + (1));
var inst_31464__$1 = inst_31478;
var state_31500__$1 = (function (){var statearr_31515 = state_31500;
(statearr_31515[(7)] = inst_31464__$1);

(statearr_31515[(10)] = inst_31477);

return statearr_31515;
})();
var statearr_31516_31546 = state_31500__$1;
(statearr_31516_31546[(2)] = null);

(statearr_31516_31546[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (5))){
var inst_31484 = (state_31500[(2)]);
var state_31500__$1 = (function (){var statearr_31517 = state_31500;
(statearr_31517[(11)] = inst_31484);

return statearr_31517;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31500__$1,(12),dchan);
} else {
if((state_val_31501 === (14))){
var inst_31486 = (state_31500[(8)]);
var inst_31491 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31486);
var state_31500__$1 = state_31500;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31500__$1,(16),out,inst_31491);
} else {
if((state_val_31501 === (16))){
var inst_31493 = (state_31500[(2)]);
var state_31500__$1 = (function (){var statearr_31518 = state_31500;
(statearr_31518[(12)] = inst_31493);

return statearr_31518;
})();
var statearr_31519_31547 = state_31500__$1;
(statearr_31519_31547[(2)] = null);

(statearr_31519_31547[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (10))){
var inst_31468 = (state_31500[(2)]);
var inst_31469 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31500__$1 = (function (){var statearr_31520 = state_31500;
(statearr_31520[(13)] = inst_31468);

return statearr_31520;
})();
var statearr_31521_31548 = state_31500__$1;
(statearr_31521_31548[(2)] = inst_31469);


cljs.core.async.impl.ioc_helpers.process_exception(state_31500__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31501 === (8))){
var inst_31482 = (state_31500[(2)]);
var state_31500__$1 = state_31500;
var statearr_31522_31549 = state_31500__$1;
(statearr_31522_31549[(2)] = inst_31482);

(statearr_31522_31549[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11666__auto__,c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_31526 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31526[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_31526[(1)] = (1));

return statearr_31526;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_31500){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31500);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31527){if((e31527 instanceof Object)){
var ex__11670__auto__ = e31527;
var statearr_31528_31550 = state_31500;
(statearr_31528_31550[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31500);

return cljs.core.constant$keyword$recur;
} else {
throw e31527;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31551 = state_31500;
state_31500 = G__31551;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_31500){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_31500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11733__auto__ = (function (){var statearr_31529 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31534);

return statearr_31529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31534,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31553 = [];
var len__9081__auto___31609 = arguments.length;
var i__9082__auto___31610 = (0);
while(true){
if((i__9082__auto___31610 < len__9081__auto___31609)){
args31553.push((arguments[i__9082__auto___31610]));

var G__31611 = (i__9082__auto___31610 + (1));
i__9082__auto___31610 = G__31611;
continue;
} else {
}
break;
}

var G__31555 = args31553.length;
switch (G__31555) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31553.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___31613 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31613,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31613,out){
return (function (state_31585){
var state_val_31586 = (state_31585[(1)]);
if((state_val_31586 === (7))){
var inst_31565 = (state_31585[(7)]);
var inst_31564 = (state_31585[(8)]);
var inst_31564__$1 = (state_31585[(2)]);
var inst_31565__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31564__$1,(0),null);
var inst_31566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31564__$1,(1),null);
var inst_31567 = (inst_31565__$1 == null);
var state_31585__$1 = (function (){var statearr_31587 = state_31585;
(statearr_31587[(7)] = inst_31565__$1);

(statearr_31587[(9)] = inst_31566);

(statearr_31587[(8)] = inst_31564__$1);

return statearr_31587;
})();
if(cljs.core.truth_(inst_31567)){
var statearr_31588_31614 = state_31585__$1;
(statearr_31588_31614[(1)] = (8));

} else {
var statearr_31589_31615 = state_31585__$1;
(statearr_31589_31615[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (1))){
var inst_31556 = cljs.core.vec(chs);
var inst_31557 = inst_31556;
var state_31585__$1 = (function (){var statearr_31590 = state_31585;
(statearr_31590[(10)] = inst_31557);

return statearr_31590;
})();
var statearr_31591_31616 = state_31585__$1;
(statearr_31591_31616[(2)] = null);

(statearr_31591_31616[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (4))){
var inst_31557 = (state_31585[(10)]);
var state_31585__$1 = state_31585;
return cljs.core.async.ioc_alts_BANG_(state_31585__$1,(7),inst_31557);
} else {
if((state_val_31586 === (6))){
var inst_31581 = (state_31585[(2)]);
var state_31585__$1 = state_31585;
var statearr_31592_31617 = state_31585__$1;
(statearr_31592_31617[(2)] = inst_31581);

(statearr_31592_31617[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (3))){
var inst_31583 = (state_31585[(2)]);
var state_31585__$1 = state_31585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31585__$1,inst_31583);
} else {
if((state_val_31586 === (2))){
var inst_31557 = (state_31585[(10)]);
var inst_31559 = cljs.core.count(inst_31557);
var inst_31560 = (inst_31559 > (0));
var state_31585__$1 = state_31585;
if(cljs.core.truth_(inst_31560)){
var statearr_31594_31618 = state_31585__$1;
(statearr_31594_31618[(1)] = (4));

} else {
var statearr_31595_31619 = state_31585__$1;
(statearr_31595_31619[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (11))){
var inst_31557 = (state_31585[(10)]);
var inst_31574 = (state_31585[(2)]);
var tmp31593 = inst_31557;
var inst_31557__$1 = tmp31593;
var state_31585__$1 = (function (){var statearr_31596 = state_31585;
(statearr_31596[(10)] = inst_31557__$1);

(statearr_31596[(11)] = inst_31574);

return statearr_31596;
})();
var statearr_31597_31620 = state_31585__$1;
(statearr_31597_31620[(2)] = null);

(statearr_31597_31620[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (9))){
var inst_31565 = (state_31585[(7)]);
var state_31585__$1 = state_31585;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31585__$1,(11),out,inst_31565);
} else {
if((state_val_31586 === (5))){
var inst_31579 = cljs.core.async.close_BANG_(out);
var state_31585__$1 = state_31585;
var statearr_31598_31621 = state_31585__$1;
(statearr_31598_31621[(2)] = inst_31579);

(statearr_31598_31621[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (10))){
var inst_31577 = (state_31585[(2)]);
var state_31585__$1 = state_31585;
var statearr_31599_31622 = state_31585__$1;
(statearr_31599_31622[(2)] = inst_31577);

(statearr_31599_31622[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31586 === (8))){
var inst_31557 = (state_31585[(10)]);
var inst_31565 = (state_31585[(7)]);
var inst_31566 = (state_31585[(9)]);
var inst_31564 = (state_31585[(8)]);
var inst_31569 = (function (){var cs = inst_31557;
var vec__31562 = inst_31564;
var v = inst_31565;
var c = inst_31566;
return ((function (cs,vec__31562,v,c,inst_31557,inst_31565,inst_31566,inst_31564,state_val_31586,c__11731__auto___31613,out){
return (function (p1__31552_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31552_SHARP_);
});
;})(cs,vec__31562,v,c,inst_31557,inst_31565,inst_31566,inst_31564,state_val_31586,c__11731__auto___31613,out))
})();
var inst_31570 = cljs.core.filterv(inst_31569,inst_31557);
var inst_31557__$1 = inst_31570;
var state_31585__$1 = (function (){var statearr_31600 = state_31585;
(statearr_31600[(10)] = inst_31557__$1);

return statearr_31600;
})();
var statearr_31601_31623 = state_31585__$1;
(statearr_31601_31623[(2)] = null);

(statearr_31601_31623[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31613,out))
;
return ((function (switch__11666__auto__,c__11731__auto___31613,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_31605 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31605[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_31605[(1)] = (1));

return statearr_31605;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_31585){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31585);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31606){if((e31606 instanceof Object)){
var ex__11670__auto__ = e31606;
var statearr_31607_31624 = state_31585;
(statearr_31607_31624[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31585);

return cljs.core.constant$keyword$recur;
} else {
throw e31606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31625 = state_31585;
state_31585 = G__31625;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_31585){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_31585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31613,out))
})();
var state__11733__auto__ = (function (){var statearr_31608 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31608[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31613);

return statearr_31608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31613,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31626 = [];
var len__9081__auto___31675 = arguments.length;
var i__9082__auto___31676 = (0);
while(true){
if((i__9082__auto___31676 < len__9081__auto___31675)){
args31626.push((arguments[i__9082__auto___31676]));

var G__31677 = (i__9082__auto___31676 + (1));
i__9082__auto___31676 = G__31677;
continue;
} else {
}
break;
}

var G__31628 = args31626.length;
switch (G__31628) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31626.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___31679 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31679,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31679,out){
return (function (state_31652){
var state_val_31653 = (state_31652[(1)]);
if((state_val_31653 === (7))){
var inst_31634 = (state_31652[(7)]);
var inst_31634__$1 = (state_31652[(2)]);
var inst_31635 = (inst_31634__$1 == null);
var inst_31636 = cljs.core.not(inst_31635);
var state_31652__$1 = (function (){var statearr_31654 = state_31652;
(statearr_31654[(7)] = inst_31634__$1);

return statearr_31654;
})();
if(inst_31636){
var statearr_31655_31680 = state_31652__$1;
(statearr_31655_31680[(1)] = (8));

} else {
var statearr_31656_31681 = state_31652__$1;
(statearr_31656_31681[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (1))){
var inst_31629 = (0);
var state_31652__$1 = (function (){var statearr_31657 = state_31652;
(statearr_31657[(8)] = inst_31629);

return statearr_31657;
})();
var statearr_31658_31682 = state_31652__$1;
(statearr_31658_31682[(2)] = null);

(statearr_31658_31682[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (4))){
var state_31652__$1 = state_31652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31652__$1,(7),ch);
} else {
if((state_val_31653 === (6))){
var inst_31647 = (state_31652[(2)]);
var state_31652__$1 = state_31652;
var statearr_31659_31683 = state_31652__$1;
(statearr_31659_31683[(2)] = inst_31647);

(statearr_31659_31683[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (3))){
var inst_31649 = (state_31652[(2)]);
var inst_31650 = cljs.core.async.close_BANG_(out);
var state_31652__$1 = (function (){var statearr_31660 = state_31652;
(statearr_31660[(9)] = inst_31649);

return statearr_31660;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31652__$1,inst_31650);
} else {
if((state_val_31653 === (2))){
var inst_31629 = (state_31652[(8)]);
var inst_31631 = (inst_31629 < n);
var state_31652__$1 = state_31652;
if(cljs.core.truth_(inst_31631)){
var statearr_31661_31684 = state_31652__$1;
(statearr_31661_31684[(1)] = (4));

} else {
var statearr_31662_31685 = state_31652__$1;
(statearr_31662_31685[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (11))){
var inst_31629 = (state_31652[(8)]);
var inst_31639 = (state_31652[(2)]);
var inst_31640 = (inst_31629 + (1));
var inst_31629__$1 = inst_31640;
var state_31652__$1 = (function (){var statearr_31663 = state_31652;
(statearr_31663[(8)] = inst_31629__$1);

(statearr_31663[(10)] = inst_31639);

return statearr_31663;
})();
var statearr_31664_31686 = state_31652__$1;
(statearr_31664_31686[(2)] = null);

(statearr_31664_31686[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (9))){
var state_31652__$1 = state_31652;
var statearr_31665_31687 = state_31652__$1;
(statearr_31665_31687[(2)] = null);

(statearr_31665_31687[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (5))){
var state_31652__$1 = state_31652;
var statearr_31666_31688 = state_31652__$1;
(statearr_31666_31688[(2)] = null);

(statearr_31666_31688[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (10))){
var inst_31644 = (state_31652[(2)]);
var state_31652__$1 = state_31652;
var statearr_31667_31689 = state_31652__$1;
(statearr_31667_31689[(2)] = inst_31644);

(statearr_31667_31689[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31653 === (8))){
var inst_31634 = (state_31652[(7)]);
var state_31652__$1 = state_31652;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31652__$1,(11),out,inst_31634);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31679,out))
;
return ((function (switch__11666__auto__,c__11731__auto___31679,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_31671 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31671[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_31671[(1)] = (1));

return statearr_31671;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_31652){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31652);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31672){if((e31672 instanceof Object)){
var ex__11670__auto__ = e31672;
var statearr_31673_31690 = state_31652;
(statearr_31673_31690[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31652);

return cljs.core.constant$keyword$recur;
} else {
throw e31672;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31691 = state_31652;
state_31652 = G__31691;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_31652){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_31652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31679,out))
})();
var state__11733__auto__ = (function (){var statearr_31674 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31679);

return statearr_31674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31679,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31701 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31701 = (function (map_LT_,f,ch,meta31702){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31702 = meta31702;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31701.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31703,meta31702__$1){
var self__ = this;
var _31703__$1 = this;
return (new cljs.core.async.t31701(self__.map_LT_,self__.f,self__.ch,meta31702__$1));
});

cljs.core.async.t31701.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31703){
var self__ = this;
var _31703__$1 = this;
return self__.meta31702;
});

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t31704 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31704 = (function (map_LT_,f,ch,meta31702,_,fn1,meta31705){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31702 = meta31702;
this._ = _;
this.fn1 = fn1;
this.meta31705 = meta31705;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31704.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31706,meta31705__$1){
var self__ = this;
var _31706__$1 = this;
return (new cljs.core.async.t31704(self__.map_LT_,self__.f,self__.ch,self__.meta31702,self__._,self__.fn1,meta31705__$1));
});})(___$1))
;

cljs.core.async.t31704.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31706){
var self__ = this;
var _31706__$1 = this;
return self__.meta31705;
});})(___$1))
;

cljs.core.async.t31704.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31704.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t31704.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31692_SHARP_){
var G__31707 = (((p1__31692_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31692_SHARP_) : self__.f.call(null,p1__31692_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31707) : f1.call(null,G__31707));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31704.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31702","meta31702",-2123662931,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tag,new cljs.core.Symbol("cljs.core.async","t31701","cljs.core.async/t31701",-1567303260,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31705","meta31705",-1119320541,null)], null);
});})(___$1))
;

cljs.core.async.t31704.cljs$lang$type = true;

cljs.core.async.t31704.cljs$lang$ctorStr = "cljs.core.async/t31704";

cljs.core.async.t31704.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31704");
});})(___$1))
;

cljs.core.async.__GT_t31704 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31704(map_LT___$1,f__$1,ch__$1,meta31702__$1,___$2,fn1__$1,meta31705){
return (new cljs.core.async.t31704(map_LT___$1,f__$1,ch__$1,meta31702__$1,___$2,fn1__$1,meta31705));
});})(___$1))
;

}

return (new cljs.core.async.t31704(self__.map_LT_,self__.f,self__.ch,self__.meta31702,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8030__auto__ = ret;
if(cljs.core.truth_(and__8030__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__8030__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31708 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31708) : self__.f.call(null,G__31708));
})());
} else {
return ret;
}
});

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31701.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t31701.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31702","meta31702",-2123662931,null)], null);
});

cljs.core.async.t31701.cljs$lang$type = true;

cljs.core.async.t31701.cljs$lang$ctorStr = "cljs.core.async/t31701";

cljs.core.async.t31701.cljs$lang$ctorPrWriter = (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31701");
});

cljs.core.async.__GT_t31701 = (function cljs$core$async$map_LT__$___GT_t31701(map_LT___$1,f__$1,ch__$1,meta31702){
return (new cljs.core.async.t31701(map_LT___$1,f__$1,ch__$1,meta31702));
});

}

return (new cljs.core.async.t31701(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31712 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31712 = (function (map_GT_,f,ch,meta31713){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31713 = meta31713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31714,meta31713__$1){
var self__ = this;
var _31714__$1 = this;
return (new cljs.core.async.t31712(self__.map_GT_,self__.f,self__.ch,meta31713__$1));
});

cljs.core.async.t31712.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31714){
var self__ = this;
var _31714__$1 = this;
return self__.meta31713;
});

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31712.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t31712.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31713","meta31713",-726402632,null)], null);
});

cljs.core.async.t31712.cljs$lang$type = true;

cljs.core.async.t31712.cljs$lang$ctorStr = "cljs.core.async/t31712";

cljs.core.async.t31712.cljs$lang$ctorPrWriter = (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31712");
});

cljs.core.async.__GT_t31712 = (function cljs$core$async$map_GT__$___GT_t31712(map_GT___$1,f__$1,ch__$1,meta31713){
return (new cljs.core.async.t31712(map_GT___$1,f__$1,ch__$1,meta31713));
});

}

return (new cljs.core.async.t31712(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31718 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31718 = (function (filter_GT_,p,ch,meta31719){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31719 = meta31719;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31718.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31720,meta31719__$1){
var self__ = this;
var _31720__$1 = this;
return (new cljs.core.async.t31718(self__.filter_GT_,self__.p,self__.ch,meta31719__$1));
});

cljs.core.async.t31718.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31720){
var self__ = this;
var _31720__$1 = this;
return self__.meta31719;
});

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31718.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t31718.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31719","meta31719",1433970470,null)], null);
});

cljs.core.async.t31718.cljs$lang$type = true;

cljs.core.async.t31718.cljs$lang$ctorStr = "cljs.core.async/t31718";

cljs.core.async.t31718.cljs$lang$ctorPrWriter = (function (this__8621__auto__,writer__8622__auto__,opt__8623__auto__){
return cljs.core._write(writer__8622__auto__,"cljs.core.async/t31718");
});

cljs.core.async.__GT_t31718 = (function cljs$core$async$filter_GT__$___GT_t31718(filter_GT___$1,p__$1,ch__$1,meta31719){
return (new cljs.core.async.t31718(filter_GT___$1,p__$1,ch__$1,meta31719));
});

}

return (new cljs.core.async.t31718(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31721 = [];
var len__9081__auto___31765 = arguments.length;
var i__9082__auto___31766 = (0);
while(true){
if((i__9082__auto___31766 < len__9081__auto___31765)){
args31721.push((arguments[i__9082__auto___31766]));

var G__31767 = (i__9082__auto___31766 + (1));
i__9082__auto___31766 = G__31767;
continue;
} else {
}
break;
}

var G__31723 = args31721.length;
switch (G__31723) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31721.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___31769 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___31769,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___31769,out){
return (function (state_31744){
var state_val_31745 = (state_31744[(1)]);
if((state_val_31745 === (7))){
var inst_31740 = (state_31744[(2)]);
var state_31744__$1 = state_31744;
var statearr_31746_31770 = state_31744__$1;
(statearr_31746_31770[(2)] = inst_31740);

(statearr_31746_31770[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (1))){
var state_31744__$1 = state_31744;
var statearr_31747_31771 = state_31744__$1;
(statearr_31747_31771[(2)] = null);

(statearr_31747_31771[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (4))){
var inst_31726 = (state_31744[(7)]);
var inst_31726__$1 = (state_31744[(2)]);
var inst_31727 = (inst_31726__$1 == null);
var state_31744__$1 = (function (){var statearr_31748 = state_31744;
(statearr_31748[(7)] = inst_31726__$1);

return statearr_31748;
})();
if(cljs.core.truth_(inst_31727)){
var statearr_31749_31772 = state_31744__$1;
(statearr_31749_31772[(1)] = (5));

} else {
var statearr_31750_31773 = state_31744__$1;
(statearr_31750_31773[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (6))){
var inst_31726 = (state_31744[(7)]);
var inst_31731 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31726) : p.call(null,inst_31726));
var state_31744__$1 = state_31744;
if(cljs.core.truth_(inst_31731)){
var statearr_31751_31774 = state_31744__$1;
(statearr_31751_31774[(1)] = (8));

} else {
var statearr_31752_31775 = state_31744__$1;
(statearr_31752_31775[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (3))){
var inst_31742 = (state_31744[(2)]);
var state_31744__$1 = state_31744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31744__$1,inst_31742);
} else {
if((state_val_31745 === (2))){
var state_31744__$1 = state_31744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31744__$1,(4),ch);
} else {
if((state_val_31745 === (11))){
var inst_31734 = (state_31744[(2)]);
var state_31744__$1 = state_31744;
var statearr_31753_31776 = state_31744__$1;
(statearr_31753_31776[(2)] = inst_31734);

(statearr_31753_31776[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (9))){
var state_31744__$1 = state_31744;
var statearr_31754_31777 = state_31744__$1;
(statearr_31754_31777[(2)] = null);

(statearr_31754_31777[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (5))){
var inst_31729 = cljs.core.async.close_BANG_(out);
var state_31744__$1 = state_31744;
var statearr_31755_31778 = state_31744__$1;
(statearr_31755_31778[(2)] = inst_31729);

(statearr_31755_31778[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (10))){
var inst_31737 = (state_31744[(2)]);
var state_31744__$1 = (function (){var statearr_31756 = state_31744;
(statearr_31756[(8)] = inst_31737);

return statearr_31756;
})();
var statearr_31757_31779 = state_31744__$1;
(statearr_31757_31779[(2)] = null);

(statearr_31757_31779[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31745 === (8))){
var inst_31726 = (state_31744[(7)]);
var state_31744__$1 = state_31744;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31744__$1,(11),out,inst_31726);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___31769,out))
;
return ((function (switch__11666__auto__,c__11731__auto___31769,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_31761 = [null,null,null,null,null,null,null,null,null];
(statearr_31761[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_31761[(1)] = (1));

return statearr_31761;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_31744){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31744);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31762){if((e31762 instanceof Object)){
var ex__11670__auto__ = e31762;
var statearr_31763_31780 = state_31744;
(statearr_31763_31780[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31744);

return cljs.core.constant$keyword$recur;
} else {
throw e31762;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__31781 = state_31744;
state_31744 = G__31781;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_31744){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_31744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___31769,out))
})();
var state__11733__auto__ = (function (){var statearr_31764 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___31769);

return statearr_31764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___31769,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31782 = [];
var len__9081__auto___31785 = arguments.length;
var i__9082__auto___31786 = (0);
while(true){
if((i__9082__auto___31786 < len__9081__auto___31785)){
args31782.push((arguments[i__9082__auto___31786]));

var G__31787 = (i__9082__auto___31786 + (1));
i__9082__auto___31786 = G__31787;
continue;
} else {
}
break;
}

var G__31784 = args31782.length;
switch (G__31784) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31782.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11731__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto__){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto__){
return (function (state_31954){
var state_val_31955 = (state_31954[(1)]);
if((state_val_31955 === (7))){
var inst_31950 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
var statearr_31956_31997 = state_31954__$1;
(statearr_31956_31997[(2)] = inst_31950);

(statearr_31956_31997[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (20))){
var inst_31920 = (state_31954[(7)]);
var inst_31931 = (state_31954[(2)]);
var inst_31932 = cljs.core.next(inst_31920);
var inst_31906 = inst_31932;
var inst_31907 = null;
var inst_31908 = (0);
var inst_31909 = (0);
var state_31954__$1 = (function (){var statearr_31957 = state_31954;
(statearr_31957[(8)] = inst_31907);

(statearr_31957[(9)] = inst_31908);

(statearr_31957[(10)] = inst_31931);

(statearr_31957[(11)] = inst_31906);

(statearr_31957[(12)] = inst_31909);

return statearr_31957;
})();
var statearr_31958_31998 = state_31954__$1;
(statearr_31958_31998[(2)] = null);

(statearr_31958_31998[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (1))){
var state_31954__$1 = state_31954;
var statearr_31959_31999 = state_31954__$1;
(statearr_31959_31999[(2)] = null);

(statearr_31959_31999[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (4))){
var inst_31895 = (state_31954[(13)]);
var inst_31895__$1 = (state_31954[(2)]);
var inst_31896 = (inst_31895__$1 == null);
var state_31954__$1 = (function (){var statearr_31960 = state_31954;
(statearr_31960[(13)] = inst_31895__$1);

return statearr_31960;
})();
if(cljs.core.truth_(inst_31896)){
var statearr_31961_32000 = state_31954__$1;
(statearr_31961_32000[(1)] = (5));

} else {
var statearr_31962_32001 = state_31954__$1;
(statearr_31962_32001[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (15))){
var state_31954__$1 = state_31954;
var statearr_31966_32002 = state_31954__$1;
(statearr_31966_32002[(2)] = null);

(statearr_31966_32002[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (21))){
var state_31954__$1 = state_31954;
var statearr_31967_32003 = state_31954__$1;
(statearr_31967_32003[(2)] = null);

(statearr_31967_32003[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (13))){
var inst_31907 = (state_31954[(8)]);
var inst_31908 = (state_31954[(9)]);
var inst_31906 = (state_31954[(11)]);
var inst_31909 = (state_31954[(12)]);
var inst_31916 = (state_31954[(2)]);
var inst_31917 = (inst_31909 + (1));
var tmp31963 = inst_31907;
var tmp31964 = inst_31908;
var tmp31965 = inst_31906;
var inst_31906__$1 = tmp31965;
var inst_31907__$1 = tmp31963;
var inst_31908__$1 = tmp31964;
var inst_31909__$1 = inst_31917;
var state_31954__$1 = (function (){var statearr_31968 = state_31954;
(statearr_31968[(14)] = inst_31916);

(statearr_31968[(8)] = inst_31907__$1);

(statearr_31968[(9)] = inst_31908__$1);

(statearr_31968[(11)] = inst_31906__$1);

(statearr_31968[(12)] = inst_31909__$1);

return statearr_31968;
})();
var statearr_31969_32004 = state_31954__$1;
(statearr_31969_32004[(2)] = null);

(statearr_31969_32004[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (22))){
var state_31954__$1 = state_31954;
var statearr_31970_32005 = state_31954__$1;
(statearr_31970_32005[(2)] = null);

(statearr_31970_32005[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (6))){
var inst_31895 = (state_31954[(13)]);
var inst_31904 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31895) : f.call(null,inst_31895));
var inst_31905 = cljs.core.seq(inst_31904);
var inst_31906 = inst_31905;
var inst_31907 = null;
var inst_31908 = (0);
var inst_31909 = (0);
var state_31954__$1 = (function (){var statearr_31971 = state_31954;
(statearr_31971[(8)] = inst_31907);

(statearr_31971[(9)] = inst_31908);

(statearr_31971[(11)] = inst_31906);

(statearr_31971[(12)] = inst_31909);

return statearr_31971;
})();
var statearr_31972_32006 = state_31954__$1;
(statearr_31972_32006[(2)] = null);

(statearr_31972_32006[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (17))){
var inst_31920 = (state_31954[(7)]);
var inst_31924 = cljs.core.chunk_first(inst_31920);
var inst_31925 = cljs.core.chunk_rest(inst_31920);
var inst_31926 = cljs.core.count(inst_31924);
var inst_31906 = inst_31925;
var inst_31907 = inst_31924;
var inst_31908 = inst_31926;
var inst_31909 = (0);
var state_31954__$1 = (function (){var statearr_31973 = state_31954;
(statearr_31973[(8)] = inst_31907);

(statearr_31973[(9)] = inst_31908);

(statearr_31973[(11)] = inst_31906);

(statearr_31973[(12)] = inst_31909);

return statearr_31973;
})();
var statearr_31974_32007 = state_31954__$1;
(statearr_31974_32007[(2)] = null);

(statearr_31974_32007[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (3))){
var inst_31952 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31954__$1,inst_31952);
} else {
if((state_val_31955 === (12))){
var inst_31940 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
var statearr_31975_32008 = state_31954__$1;
(statearr_31975_32008[(2)] = inst_31940);

(statearr_31975_32008[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (2))){
var state_31954__$1 = state_31954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31954__$1,(4),in$);
} else {
if((state_val_31955 === (23))){
var inst_31948 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
var statearr_31976_32009 = state_31954__$1;
(statearr_31976_32009[(2)] = inst_31948);

(statearr_31976_32009[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (19))){
var inst_31935 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
var statearr_31977_32010 = state_31954__$1;
(statearr_31977_32010[(2)] = inst_31935);

(statearr_31977_32010[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (11))){
var inst_31906 = (state_31954[(11)]);
var inst_31920 = (state_31954[(7)]);
var inst_31920__$1 = cljs.core.seq(inst_31906);
var state_31954__$1 = (function (){var statearr_31978 = state_31954;
(statearr_31978[(7)] = inst_31920__$1);

return statearr_31978;
})();
if(inst_31920__$1){
var statearr_31979_32011 = state_31954__$1;
(statearr_31979_32011[(1)] = (14));

} else {
var statearr_31980_32012 = state_31954__$1;
(statearr_31980_32012[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (9))){
var inst_31942 = (state_31954[(2)]);
var inst_31943 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31954__$1 = (function (){var statearr_31981 = state_31954;
(statearr_31981[(15)] = inst_31942);

return statearr_31981;
})();
if(cljs.core.truth_(inst_31943)){
var statearr_31982_32013 = state_31954__$1;
(statearr_31982_32013[(1)] = (21));

} else {
var statearr_31983_32014 = state_31954__$1;
(statearr_31983_32014[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (5))){
var inst_31898 = cljs.core.async.close_BANG_(out);
var state_31954__$1 = state_31954;
var statearr_31984_32015 = state_31954__$1;
(statearr_31984_32015[(2)] = inst_31898);

(statearr_31984_32015[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (14))){
var inst_31920 = (state_31954[(7)]);
var inst_31922 = cljs.core.chunked_seq_QMARK_(inst_31920);
var state_31954__$1 = state_31954;
if(inst_31922){
var statearr_31985_32016 = state_31954__$1;
(statearr_31985_32016[(1)] = (17));

} else {
var statearr_31986_32017 = state_31954__$1;
(statearr_31986_32017[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (16))){
var inst_31938 = (state_31954[(2)]);
var state_31954__$1 = state_31954;
var statearr_31987_32018 = state_31954__$1;
(statearr_31987_32018[(2)] = inst_31938);

(statearr_31987_32018[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31955 === (10))){
var inst_31907 = (state_31954[(8)]);
var inst_31909 = (state_31954[(12)]);
var inst_31914 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31907,inst_31909);
var state_31954__$1 = state_31954;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31954__$1,(13),out,inst_31914);
} else {
if((state_val_31955 === (18))){
var inst_31920 = (state_31954[(7)]);
var inst_31929 = cljs.core.first(inst_31920);
var state_31954__$1 = state_31954;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31954__$1,(20),out,inst_31929);
} else {
if((state_val_31955 === (8))){
var inst_31908 = (state_31954[(9)]);
var inst_31909 = (state_31954[(12)]);
var inst_31911 = (inst_31909 < inst_31908);
var inst_31912 = inst_31911;
var state_31954__$1 = state_31954;
if(cljs.core.truth_(inst_31912)){
var statearr_31988_32019 = state_31954__$1;
(statearr_31988_32019[(1)] = (10));

} else {
var statearr_31989_32020 = state_31954__$1;
(statearr_31989_32020[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto__))
;
return ((function (switch__11666__auto__,c__11731__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____0 = (function (){
var statearr_31993 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31993[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__);

(statearr_31993[(1)] = (1));

return statearr_31993;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____1 = (function (state_31954){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_31954);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e31994){if((e31994 instanceof Object)){
var ex__11670__auto__ = e31994;
var statearr_31995_32021 = state_31954;
(statearr_31995_32021[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31954);

return cljs.core.constant$keyword$recur;
} else {
throw e31994;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__32022 = state_31954;
state_31954 = G__32022;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__ = function(state_31954){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____1.call(this,state_31954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11667__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto__))
})();
var state__11733__auto__ = (function (){var statearr_31996 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_31996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto__);

return statearr_31996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto__))
);

return c__11731__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args32023 = [];
var len__9081__auto___32026 = arguments.length;
var i__9082__auto___32027 = (0);
while(true){
if((i__9082__auto___32027 < len__9081__auto___32026)){
args32023.push((arguments[i__9082__auto___32027]));

var G__32028 = (i__9082__auto___32027 + (1));
i__9082__auto___32027 = G__32028;
continue;
} else {
}
break;
}

var G__32025 = args32023.length;
switch (G__32025) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32023.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args32030 = [];
var len__9081__auto___32033 = arguments.length;
var i__9082__auto___32034 = (0);
while(true){
if((i__9082__auto___32034 < len__9081__auto___32033)){
args32030.push((arguments[i__9082__auto___32034]));

var G__32035 = (i__9082__auto___32034 + (1));
i__9082__auto___32034 = G__32035;
continue;
} else {
}
break;
}

var G__32032 = args32030.length;
switch (G__32032) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32030.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args32037 = [];
var len__9081__auto___32088 = arguments.length;
var i__9082__auto___32089 = (0);
while(true){
if((i__9082__auto___32089 < len__9081__auto___32088)){
args32037.push((arguments[i__9082__auto___32089]));

var G__32090 = (i__9082__auto___32089 + (1));
i__9082__auto___32089 = G__32090;
continue;
} else {
}
break;
}

var G__32039 = args32037.length;
switch (G__32039) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32037.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___32092 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___32092,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___32092,out){
return (function (state_32063){
var state_val_32064 = (state_32063[(1)]);
if((state_val_32064 === (7))){
var inst_32058 = (state_32063[(2)]);
var state_32063__$1 = state_32063;
var statearr_32065_32093 = state_32063__$1;
(statearr_32065_32093[(2)] = inst_32058);

(statearr_32065_32093[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (1))){
var inst_32040 = null;
var state_32063__$1 = (function (){var statearr_32066 = state_32063;
(statearr_32066[(7)] = inst_32040);

return statearr_32066;
})();
var statearr_32067_32094 = state_32063__$1;
(statearr_32067_32094[(2)] = null);

(statearr_32067_32094[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (4))){
var inst_32043 = (state_32063[(8)]);
var inst_32043__$1 = (state_32063[(2)]);
var inst_32044 = (inst_32043__$1 == null);
var inst_32045 = cljs.core.not(inst_32044);
var state_32063__$1 = (function (){var statearr_32068 = state_32063;
(statearr_32068[(8)] = inst_32043__$1);

return statearr_32068;
})();
if(inst_32045){
var statearr_32069_32095 = state_32063__$1;
(statearr_32069_32095[(1)] = (5));

} else {
var statearr_32070_32096 = state_32063__$1;
(statearr_32070_32096[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (6))){
var state_32063__$1 = state_32063;
var statearr_32071_32097 = state_32063__$1;
(statearr_32071_32097[(2)] = null);

(statearr_32071_32097[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (3))){
var inst_32060 = (state_32063[(2)]);
var inst_32061 = cljs.core.async.close_BANG_(out);
var state_32063__$1 = (function (){var statearr_32072 = state_32063;
(statearr_32072[(9)] = inst_32060);

return statearr_32072;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32063__$1,inst_32061);
} else {
if((state_val_32064 === (2))){
var state_32063__$1 = state_32063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32063__$1,(4),ch);
} else {
if((state_val_32064 === (11))){
var inst_32043 = (state_32063[(8)]);
var inst_32052 = (state_32063[(2)]);
var inst_32040 = inst_32043;
var state_32063__$1 = (function (){var statearr_32073 = state_32063;
(statearr_32073[(10)] = inst_32052);

(statearr_32073[(7)] = inst_32040);

return statearr_32073;
})();
var statearr_32074_32098 = state_32063__$1;
(statearr_32074_32098[(2)] = null);

(statearr_32074_32098[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (9))){
var inst_32043 = (state_32063[(8)]);
var state_32063__$1 = state_32063;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32063__$1,(11),out,inst_32043);
} else {
if((state_val_32064 === (5))){
var inst_32043 = (state_32063[(8)]);
var inst_32040 = (state_32063[(7)]);
var inst_32047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32043,inst_32040);
var state_32063__$1 = state_32063;
if(inst_32047){
var statearr_32076_32099 = state_32063__$1;
(statearr_32076_32099[(1)] = (8));

} else {
var statearr_32077_32100 = state_32063__$1;
(statearr_32077_32100[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (10))){
var inst_32055 = (state_32063[(2)]);
var state_32063__$1 = state_32063;
var statearr_32078_32101 = state_32063__$1;
(statearr_32078_32101[(2)] = inst_32055);

(statearr_32078_32101[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32064 === (8))){
var inst_32040 = (state_32063[(7)]);
var tmp32075 = inst_32040;
var inst_32040__$1 = tmp32075;
var state_32063__$1 = (function (){var statearr_32079 = state_32063;
(statearr_32079[(7)] = inst_32040__$1);

return statearr_32079;
})();
var statearr_32080_32102 = state_32063__$1;
(statearr_32080_32102[(2)] = null);

(statearr_32080_32102[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___32092,out))
;
return ((function (switch__11666__auto__,c__11731__auto___32092,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_32084 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32084[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_32084[(1)] = (1));

return statearr_32084;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_32063){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_32063);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e32085){if((e32085 instanceof Object)){
var ex__11670__auto__ = e32085;
var statearr_32086_32103 = state_32063;
(statearr_32086_32103[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32063);

return cljs.core.constant$keyword$recur;
} else {
throw e32085;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__32104 = state_32063;
state_32063 = G__32104;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_32063){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_32063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___32092,out))
})();
var state__11733__auto__ = (function (){var statearr_32087 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_32087[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___32092);

return statearr_32087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___32092,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args32105 = [];
var len__9081__auto___32175 = arguments.length;
var i__9082__auto___32176 = (0);
while(true){
if((i__9082__auto___32176 < len__9081__auto___32175)){
args32105.push((arguments[i__9082__auto___32176]));

var G__32177 = (i__9082__auto___32176 + (1));
i__9082__auto___32176 = G__32177;
continue;
} else {
}
break;
}

var G__32107 = args32105.length;
switch (G__32107) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32105.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___32179 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___32179,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___32179,out){
return (function (state_32145){
var state_val_32146 = (state_32145[(1)]);
if((state_val_32146 === (7))){
var inst_32141 = (state_32145[(2)]);
var state_32145__$1 = state_32145;
var statearr_32147_32180 = state_32145__$1;
(statearr_32147_32180[(2)] = inst_32141);

(statearr_32147_32180[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (1))){
var inst_32108 = (new Array(n));
var inst_32109 = inst_32108;
var inst_32110 = (0);
var state_32145__$1 = (function (){var statearr_32148 = state_32145;
(statearr_32148[(7)] = inst_32109);

(statearr_32148[(8)] = inst_32110);

return statearr_32148;
})();
var statearr_32149_32181 = state_32145__$1;
(statearr_32149_32181[(2)] = null);

(statearr_32149_32181[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (4))){
var inst_32113 = (state_32145[(9)]);
var inst_32113__$1 = (state_32145[(2)]);
var inst_32114 = (inst_32113__$1 == null);
var inst_32115 = cljs.core.not(inst_32114);
var state_32145__$1 = (function (){var statearr_32150 = state_32145;
(statearr_32150[(9)] = inst_32113__$1);

return statearr_32150;
})();
if(inst_32115){
var statearr_32151_32182 = state_32145__$1;
(statearr_32151_32182[(1)] = (5));

} else {
var statearr_32152_32183 = state_32145__$1;
(statearr_32152_32183[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (15))){
var inst_32135 = (state_32145[(2)]);
var state_32145__$1 = state_32145;
var statearr_32153_32184 = state_32145__$1;
(statearr_32153_32184[(2)] = inst_32135);

(statearr_32153_32184[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (13))){
var state_32145__$1 = state_32145;
var statearr_32154_32185 = state_32145__$1;
(statearr_32154_32185[(2)] = null);

(statearr_32154_32185[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (6))){
var inst_32110 = (state_32145[(8)]);
var inst_32131 = (inst_32110 > (0));
var state_32145__$1 = state_32145;
if(cljs.core.truth_(inst_32131)){
var statearr_32155_32186 = state_32145__$1;
(statearr_32155_32186[(1)] = (12));

} else {
var statearr_32156_32187 = state_32145__$1;
(statearr_32156_32187[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (3))){
var inst_32143 = (state_32145[(2)]);
var state_32145__$1 = state_32145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32145__$1,inst_32143);
} else {
if((state_val_32146 === (12))){
var inst_32109 = (state_32145[(7)]);
var inst_32133 = cljs.core.vec(inst_32109);
var state_32145__$1 = state_32145;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32145__$1,(15),out,inst_32133);
} else {
if((state_val_32146 === (2))){
var state_32145__$1 = state_32145;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32145__$1,(4),ch);
} else {
if((state_val_32146 === (11))){
var inst_32125 = (state_32145[(2)]);
var inst_32126 = (new Array(n));
var inst_32109 = inst_32126;
var inst_32110 = (0);
var state_32145__$1 = (function (){var statearr_32157 = state_32145;
(statearr_32157[(7)] = inst_32109);

(statearr_32157[(8)] = inst_32110);

(statearr_32157[(10)] = inst_32125);

return statearr_32157;
})();
var statearr_32158_32188 = state_32145__$1;
(statearr_32158_32188[(2)] = null);

(statearr_32158_32188[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (9))){
var inst_32109 = (state_32145[(7)]);
var inst_32123 = cljs.core.vec(inst_32109);
var state_32145__$1 = state_32145;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32145__$1,(11),out,inst_32123);
} else {
if((state_val_32146 === (5))){
var inst_32113 = (state_32145[(9)]);
var inst_32109 = (state_32145[(7)]);
var inst_32110 = (state_32145[(8)]);
var inst_32118 = (state_32145[(11)]);
var inst_32117 = (inst_32109[inst_32110] = inst_32113);
var inst_32118__$1 = (inst_32110 + (1));
var inst_32119 = (inst_32118__$1 < n);
var state_32145__$1 = (function (){var statearr_32159 = state_32145;
(statearr_32159[(12)] = inst_32117);

(statearr_32159[(11)] = inst_32118__$1);

return statearr_32159;
})();
if(cljs.core.truth_(inst_32119)){
var statearr_32160_32189 = state_32145__$1;
(statearr_32160_32189[(1)] = (8));

} else {
var statearr_32161_32190 = state_32145__$1;
(statearr_32161_32190[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (14))){
var inst_32138 = (state_32145[(2)]);
var inst_32139 = cljs.core.async.close_BANG_(out);
var state_32145__$1 = (function (){var statearr_32163 = state_32145;
(statearr_32163[(13)] = inst_32138);

return statearr_32163;
})();
var statearr_32164_32191 = state_32145__$1;
(statearr_32164_32191[(2)] = inst_32139);

(statearr_32164_32191[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (10))){
var inst_32129 = (state_32145[(2)]);
var state_32145__$1 = state_32145;
var statearr_32165_32192 = state_32145__$1;
(statearr_32165_32192[(2)] = inst_32129);

(statearr_32165_32192[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32146 === (8))){
var inst_32109 = (state_32145[(7)]);
var inst_32118 = (state_32145[(11)]);
var tmp32162 = inst_32109;
var inst_32109__$1 = tmp32162;
var inst_32110 = inst_32118;
var state_32145__$1 = (function (){var statearr_32166 = state_32145;
(statearr_32166[(7)] = inst_32109__$1);

(statearr_32166[(8)] = inst_32110);

return statearr_32166;
})();
var statearr_32167_32193 = state_32145__$1;
(statearr_32167_32193[(2)] = null);

(statearr_32167_32193[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___32179,out))
;
return ((function (switch__11666__auto__,c__11731__auto___32179,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_32171 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32171[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_32171[(1)] = (1));

return statearr_32171;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_32145){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_32145);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e32172){if((e32172 instanceof Object)){
var ex__11670__auto__ = e32172;
var statearr_32173_32194 = state_32145;
(statearr_32173_32194[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32145);

return cljs.core.constant$keyword$recur;
} else {
throw e32172;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__32195 = state_32145;
state_32145 = G__32195;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_32145){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_32145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___32179,out))
})();
var state__11733__auto__ = (function (){var statearr_32174 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_32174[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___32179);

return statearr_32174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___32179,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args32196 = [];
var len__9081__auto___32270 = arguments.length;
var i__9082__auto___32271 = (0);
while(true){
if((i__9082__auto___32271 < len__9081__auto___32270)){
args32196.push((arguments[i__9082__auto___32271]));

var G__32272 = (i__9082__auto___32271 + (1));
i__9082__auto___32271 = G__32272;
continue;
} else {
}
break;
}

var G__32198 = args32196.length;
switch (G__32198) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32196.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11731__auto___32274 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___32274,out){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___32274,out){
return (function (state_32240){
var state_val_32241 = (state_32240[(1)]);
if((state_val_32241 === (7))){
var inst_32236 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32242_32275 = state_32240__$1;
(statearr_32242_32275[(2)] = inst_32236);

(statearr_32242_32275[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (1))){
var inst_32199 = [];
var inst_32200 = inst_32199;
var inst_32201 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_32240__$1 = (function (){var statearr_32243 = state_32240;
(statearr_32243[(7)] = inst_32201);

(statearr_32243[(8)] = inst_32200);

return statearr_32243;
})();
var statearr_32244_32276 = state_32240__$1;
(statearr_32244_32276[(2)] = null);

(statearr_32244_32276[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (4))){
var inst_32204 = (state_32240[(9)]);
var inst_32204__$1 = (state_32240[(2)]);
var inst_32205 = (inst_32204__$1 == null);
var inst_32206 = cljs.core.not(inst_32205);
var state_32240__$1 = (function (){var statearr_32245 = state_32240;
(statearr_32245[(9)] = inst_32204__$1);

return statearr_32245;
})();
if(inst_32206){
var statearr_32246_32277 = state_32240__$1;
(statearr_32246_32277[(1)] = (5));

} else {
var statearr_32247_32278 = state_32240__$1;
(statearr_32247_32278[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (15))){
var inst_32230 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32248_32279 = state_32240__$1;
(statearr_32248_32279[(2)] = inst_32230);

(statearr_32248_32279[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (13))){
var state_32240__$1 = state_32240;
var statearr_32249_32280 = state_32240__$1;
(statearr_32249_32280[(2)] = null);

(statearr_32249_32280[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (6))){
var inst_32200 = (state_32240[(8)]);
var inst_32225 = inst_32200.length;
var inst_32226 = (inst_32225 > (0));
var state_32240__$1 = state_32240;
if(cljs.core.truth_(inst_32226)){
var statearr_32250_32281 = state_32240__$1;
(statearr_32250_32281[(1)] = (12));

} else {
var statearr_32251_32282 = state_32240__$1;
(statearr_32251_32282[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (3))){
var inst_32238 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32240__$1,inst_32238);
} else {
if((state_val_32241 === (12))){
var inst_32200 = (state_32240[(8)]);
var inst_32228 = cljs.core.vec(inst_32200);
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32240__$1,(15),out,inst_32228);
} else {
if((state_val_32241 === (2))){
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32240__$1,(4),ch);
} else {
if((state_val_32241 === (11))){
var inst_32208 = (state_32240[(10)]);
var inst_32204 = (state_32240[(9)]);
var inst_32218 = (state_32240[(2)]);
var inst_32219 = [];
var inst_32220 = inst_32219.push(inst_32204);
var inst_32200 = inst_32219;
var inst_32201 = inst_32208;
var state_32240__$1 = (function (){var statearr_32252 = state_32240;
(statearr_32252[(7)] = inst_32201);

(statearr_32252[(11)] = inst_32218);

(statearr_32252[(8)] = inst_32200);

(statearr_32252[(12)] = inst_32220);

return statearr_32252;
})();
var statearr_32253_32283 = state_32240__$1;
(statearr_32253_32283[(2)] = null);

(statearr_32253_32283[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (9))){
var inst_32200 = (state_32240[(8)]);
var inst_32216 = cljs.core.vec(inst_32200);
var state_32240__$1 = state_32240;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32240__$1,(11),out,inst_32216);
} else {
if((state_val_32241 === (5))){
var inst_32208 = (state_32240[(10)]);
var inst_32204 = (state_32240[(9)]);
var inst_32201 = (state_32240[(7)]);
var inst_32208__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32204) : f.call(null,inst_32204));
var inst_32209 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32208__$1,inst_32201);
var inst_32210 = cljs.core.keyword_identical_QMARK_(inst_32201,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_32211 = (inst_32209) || (inst_32210);
var state_32240__$1 = (function (){var statearr_32254 = state_32240;
(statearr_32254[(10)] = inst_32208__$1);

return statearr_32254;
})();
if(cljs.core.truth_(inst_32211)){
var statearr_32255_32284 = state_32240__$1;
(statearr_32255_32284[(1)] = (8));

} else {
var statearr_32256_32285 = state_32240__$1;
(statearr_32256_32285[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (14))){
var inst_32233 = (state_32240[(2)]);
var inst_32234 = cljs.core.async.close_BANG_(out);
var state_32240__$1 = (function (){var statearr_32258 = state_32240;
(statearr_32258[(13)] = inst_32233);

return statearr_32258;
})();
var statearr_32259_32286 = state_32240__$1;
(statearr_32259_32286[(2)] = inst_32234);

(statearr_32259_32286[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (10))){
var inst_32223 = (state_32240[(2)]);
var state_32240__$1 = state_32240;
var statearr_32260_32287 = state_32240__$1;
(statearr_32260_32287[(2)] = inst_32223);

(statearr_32260_32287[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32241 === (8))){
var inst_32208 = (state_32240[(10)]);
var inst_32204 = (state_32240[(9)]);
var inst_32200 = (state_32240[(8)]);
var inst_32213 = inst_32200.push(inst_32204);
var tmp32257 = inst_32200;
var inst_32200__$1 = tmp32257;
var inst_32201 = inst_32208;
var state_32240__$1 = (function (){var statearr_32261 = state_32240;
(statearr_32261[(7)] = inst_32201);

(statearr_32261[(14)] = inst_32213);

(statearr_32261[(8)] = inst_32200__$1);

return statearr_32261;
})();
var statearr_32262_32288 = state_32240__$1;
(statearr_32262_32288[(2)] = null);

(statearr_32262_32288[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___32274,out))
;
return ((function (switch__11666__auto__,c__11731__auto___32274,out){
return (function() {
var cljs$core$async$state_machine__11667__auto__ = null;
var cljs$core$async$state_machine__11667__auto____0 = (function (){
var statearr_32266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32266[(0)] = cljs$core$async$state_machine__11667__auto__);

(statearr_32266[(1)] = (1));

return statearr_32266;
});
var cljs$core$async$state_machine__11667__auto____1 = (function (state_32240){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_32240);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e32267){if((e32267 instanceof Object)){
var ex__11670__auto__ = e32267;
var statearr_32268_32289 = state_32240;
(statearr_32268_32289[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32240);

return cljs.core.constant$keyword$recur;
} else {
throw e32267;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__32290 = state_32240;
state_32240 = G__32290;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
cljs$core$async$state_machine__11667__auto__ = function(state_32240){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11667__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11667__auto____1.call(this,state_32240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11667__auto____0;
cljs$core$async$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11667__auto____1;
return cljs$core$async$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___32274,out))
})();
var state__11733__auto__ = (function (){var statearr_32269 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_32269[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___32274);

return statearr_32269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___32274,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
