// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 * 1. No response: {:reason :no-http-response}
 * 2. 4xx response: {:reason :http-client-error
 * :detail {:status-code <status-code>
 * :response <parsed-json-from-server>}
 * 3. 5xx response: {:reason :http-server-error
 * :detail {:response <raw-response>
 * :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(){
var args__9088__auto__ = [];
var len__9081__auto___28333 = arguments.length;
var i__9082__auto___28334 = (0);
while(true){
if((i__9082__auto___28334 < len__9081__auto___28333)){
args__9088__auto__.push((arguments[i__9082__auto___28334]));

var G__28335 = (i__9082__auto___28334 + (1));
i__9082__auto___28334 = G__28335;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((2) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((2)),(0))):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9089__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__28317){
var map__28318 = p__28317;
var map__28318__$1 = ((((!((map__28318 == null)))?((((map__28318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28318):map__28318);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$callback);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$filename);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$http_DASH_options);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$raw_DASH_response_QMARK_);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$as_DASH_map_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28318__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.constant$keyword$delete),cljs.core.constant$keyword$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.constant$keyword$accept_DASH_header,accept_header], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$headers,headers,cljs.core.constant$keyword$method,method,cljs.core.constant$keyword$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__11731__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function (state_28324){
var state_val_28325 = (state_28324[(1)]);
if((state_val_28325 === (1))){
var state_28324__$1 = state_28324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28324__$1,(2),ch);
} else {
if((state_val_28325 === (2))){
var inst_28321 = (state_28324[(2)]);
var inst_28322 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_28321) : callback.call(null,inst_28321));
var state_28324__$1 = state_28324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28324__$1,inst_28322);
} else {
return null;
}
}
});})(c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
;
return ((function (switch__11666__auto__,c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_){
return (function() {
var milia$api$http$state_machine__11667__auto__ = null;
var milia$api$http$state_machine__11667__auto____0 = (function (){
var statearr_28329 = [null,null,null,null,null,null,null];
(statearr_28329[(0)] = milia$api$http$state_machine__11667__auto__);

(statearr_28329[(1)] = (1));

return statearr_28329;
});
var milia$api$http$state_machine__11667__auto____1 = (function (state_28324){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_28324);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e28330){if((e28330 instanceof Object)){
var ex__11670__auto__ = e28330;
var statearr_28331_28336 = state_28324;
(statearr_28331_28336[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28324);

return cljs.core.constant$keyword$recur;
} else {
throw e28330;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__28337 = state_28324;
state_28324 = G__28337;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
milia$api$http$state_machine__11667__auto__ = function(state_28324){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__11667__auto____0.call(this);
case 1:
return milia$api$http$state_machine__11667__auto____1.call(this,state_28324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__11667__auto____0;
milia$api$http$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__11667__auto____1;
return milia$api$http$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
})();
var state__11733__auto__ = (function (){var statearr_28332 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_28332[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto__);

return statearr_28332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto__,request_fn,headers,ch,map__28318,map__28318__$1,accept_header,callback,filename,http_options,suppress_4xx_exceptions_QMARK_,raw_response_QMARK_,as_map_QMARK_,no_cache_QMARK_,must_revalidate_QMARK_))
);

return c__11731__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq28314){
var G__28315 = cljs.core.first(seq28314);
var seq28314__$1 = cljs.core.next(seq28314);
var G__28316 = cljs.core.first(seq28314__$1);
var seq28314__$2 = cljs.core.next(seq28314__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__28315,G__28316,seq28314__$2);
});
