// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__8030__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__8030__auto__)){
return stateful_method_QMARK_;
} else {
return and__8030__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__8030__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__8030__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__8030__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__28202 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28202) : cljs_hash.md5.md5.call(null,G__28202));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__9088__auto__ = [];
var len__9081__auto___28207 = arguments.length;
var i__9082__auto___28208 = (0);
while(true){
if((i__9082__auto___28208 < len__9081__auto___28207)){
args__9088__auto__.push((arguments[i__9082__auto___28208]));

var G__28209 = (i__9082__auto___28208 + (1));
i__9082__auto___28208 = G__28209;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((0) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__9089__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28204){
var map__28205 = p__28204;
var map__28205__$1 = ((((!((map__28205 == null)))?((((map__28205.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28205.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28205):map__28205);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28205__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28205__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28205__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_) : cljs.core.deref.call(null,milia.utils.remote._STAR_credentials_STAR_)));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__8030__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__8030__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__8030__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__8030__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__8030__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__8030__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__8042__auto__ = accept_header;
if(cljs.core.truth_(or__8042__auto__)){
return or__8042__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28203){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28203));
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__28216_28222 = io_obj;
var G__28217_28223 = goog.net.EventType.SUCCESS;
var G__28218_28224 = ((function (G__28216_28222,G__28217_28223,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28216_28222,G__28217_28223,io_obj,url))
;
goog.events.listen(G__28216_28222,G__28217_28223,G__28218_28224);

var G__28219_28225 = io_obj;
var G__28220_28226 = goog.net.EventType.ERROR;
var G__28221_28227 = ((function (G__28219_28225,G__28220_28226,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28219_28225,G__28220_28226,io_obj,url))
;
goog.events.listen(G__28219_28225,G__28220_28226,G__28221_28227);

return io_obj.sendFromForm(form,url);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__9088__auto__ = [];
var len__9081__auto___28290 = arguments.length;
var i__9082__auto___28291 = (0);
while(true){
if((i__9082__auto___28291 < len__9081__auto___28290)){
args__9088__auto__.push((arguments[i__9082__auto___28291]));

var G__28292 = (i__9082__auto___28291 + (1));
i__9082__auto___28291 = G__28292;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11731__auto___28293 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11731__auto___28293,response_channel){
return (function (){
var f__11732__auto__ = (function (){var switch__11666__auto__ = ((function (c__11731__auto___28293,response_channel){
return (function (state_28263){
var state_val_28264 = (state_28263[(1)]);
if((state_val_28264 === (7))){
var state_28263__$1 = state_28263;
var statearr_28265_28294 = state_28263__$1;
(statearr_28265_28294[(2)] = false);

(statearr_28265_28294[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (1))){
var inst_28231 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28263__$1 = state_28263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28263__$1,(2),inst_28231);
} else {
if((state_val_28264 === (4))){
var state_28263__$1 = state_28263;
var statearr_28266_28295 = state_28263__$1;
(statearr_28266_28295[(2)] = false);

(statearr_28266_28295[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (13))){
var inst_28253 = (state_28263[(7)]);
var inst_28259 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28253);
var state_28263__$1 = state_28263;
var statearr_28267_28296 = state_28263__$1;
(statearr_28267_28296[(2)] = inst_28259);

(statearr_28267_28296[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (6))){
var state_28263__$1 = state_28263;
var statearr_28268_28297 = state_28263__$1;
(statearr_28268_28297[(2)] = true);

(statearr_28268_28297[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (3))){
var inst_28233 = (state_28263[(8)]);
var inst_28238 = inst_28233.cljs$lang$protocol_mask$partition0$;
var inst_28239 = (inst_28238 & (64));
var inst_28240 = inst_28233.cljs$core$ISeq$;
var inst_28241 = (inst_28239) || (inst_28240);
var state_28263__$1 = state_28263;
if(cljs.core.truth_(inst_28241)){
var statearr_28269_28298 = state_28263__$1;
(statearr_28269_28298[(1)] = (6));

} else {
var statearr_28270_28299 = state_28263__$1;
(statearr_28270_28299[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (12))){
var inst_28257 = window.location = window.location;
var state_28263__$1 = state_28263;
var statearr_28271_28300 = state_28263__$1;
(statearr_28271_28300[(2)] = inst_28257);

(statearr_28271_28300[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (2))){
var inst_28233 = (state_28263[(8)]);
var inst_28233__$1 = (state_28263[(2)]);
var inst_28235 = (inst_28233__$1 == null);
var inst_28236 = cljs.core.not(inst_28235);
var state_28263__$1 = (function (){var statearr_28272 = state_28263;
(statearr_28272[(8)] = inst_28233__$1);

return statearr_28272;
})();
if(inst_28236){
var statearr_28273_28301 = state_28263__$1;
(statearr_28273_28301[(1)] = (3));

} else {
var statearr_28274_28302 = state_28263__$1;
(statearr_28274_28302[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (11))){
var inst_28253 = (state_28263[(7)]);
var inst_28253__$1 = (state_28263[(2)]);
var inst_28254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28253__$1,cljs.core.constant$keyword$status);
var inst_28255 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28254,(401));
var state_28263__$1 = (function (){var statearr_28275 = state_28263;
(statearr_28275[(7)] = inst_28253__$1);

return statearr_28275;
})();
if(inst_28255){
var statearr_28276_28303 = state_28263__$1;
(statearr_28276_28303[(1)] = (12));

} else {
var statearr_28277_28304 = state_28263__$1;
(statearr_28277_28304[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (9))){
var inst_28233 = (state_28263[(8)]);
var inst_28250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28233);
var state_28263__$1 = state_28263;
var statearr_28278_28305 = state_28263__$1;
(statearr_28278_28305[(2)] = inst_28250);

(statearr_28278_28305[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (5))){
var inst_28248 = (state_28263[(2)]);
var state_28263__$1 = state_28263;
if(cljs.core.truth_(inst_28248)){
var statearr_28279_28306 = state_28263__$1;
(statearr_28279_28306[(1)] = (9));

} else {
var statearr_28280_28307 = state_28263__$1;
(statearr_28280_28307[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (14))){
var inst_28261 = (state_28263[(2)]);
var state_28263__$1 = state_28263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28263__$1,inst_28261);
} else {
if((state_val_28264 === (10))){
var inst_28233 = (state_28263[(8)]);
var state_28263__$1 = state_28263;
var statearr_28281_28308 = state_28263__$1;
(statearr_28281_28308[(2)] = inst_28233);

(statearr_28281_28308[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28264 === (8))){
var inst_28245 = (state_28263[(2)]);
var state_28263__$1 = state_28263;
var statearr_28282_28309 = state_28263__$1;
(statearr_28282_28309[(2)] = inst_28245);

(statearr_28282_28309[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11731__auto___28293,response_channel))
;
return ((function (switch__11666__auto__,c__11731__auto___28293,response_channel){
return (function() {
var milia$api$io$state_machine__11667__auto__ = null;
var milia$api$io$state_machine__11667__auto____0 = (function (){
var statearr_28286 = [null,null,null,null,null,null,null,null,null];
(statearr_28286[(0)] = milia$api$io$state_machine__11667__auto__);

(statearr_28286[(1)] = (1));

return statearr_28286;
});
var milia$api$io$state_machine__11667__auto____1 = (function (state_28263){
while(true){
var ret_value__11668__auto__ = (function (){try{while(true){
var result__11669__auto__ = switch__11666__auto__(state_28263);
if(cljs.core.keyword_identical_QMARK_(result__11669__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11669__auto__;
}
break;
}
}catch (e28287){if((e28287 instanceof Object)){
var ex__11670__auto__ = e28287;
var statearr_28288_28310 = state_28263;
(statearr_28288_28310[(5)] = ex__11670__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28263);

return cljs.core.constant$keyword$recur;
} else {
throw e28287;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11668__auto__,cljs.core.constant$keyword$recur)){
var G__28311 = state_28263;
state_28263 = G__28311;
continue;
} else {
return ret_value__11668__auto__;
}
break;
}
});
milia$api$io$state_machine__11667__auto__ = function(state_28263){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11667__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11667__auto____1.call(this,state_28263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11667__auto____0;
milia$api$io$state_machine__11667__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11667__auto____1;
return milia$api$io$state_machine__11667__auto__;
})()
;})(switch__11666__auto__,c__11731__auto___28293,response_channel))
})();
var state__11733__auto__ = (function (){var statearr_28289 = (f__11732__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11732__auto__.cljs$core$IFn$_invoke$arity$0() : f__11732__auto__.call(null));
(statearr_28289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11731__auto___28293);

return statearr_28289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11733__auto__);
});})(c__11731__auto___28293,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq28228){
var G__28229 = cljs.core.first(seq28228);
var seq28228__$1 = cljs.core.next(seq28228);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__28229,seq28228__$1);
});
