// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_.call(null,class_name,class$,i)){
return i;
} else {
var G__11393 = (i + class$.length);
start_from = G__11393;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index.call(null,class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__11398 = arguments.length;
switch (G__11398) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var classes__$1 = clojure.string.trim.call(null,cljs.core.name.call(null,classes));
if(cljs.core.seq.call(null,classes__$1)){
var temp__4124__auto___11412 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11412)){
var class_list_11413 = temp__4124__auto___11412;
var seq__11399_11414 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11400_11415 = null;
var count__11401_11416 = (0);
var i__11402_11417 = (0);
while(true){
if((i__11402_11417 < count__11401_11416)){
var class_11418 = cljs.core._nth.call(null,chunk__11400_11415,i__11402_11417);
class_list_11413.add(class_11418);

var G__11419 = seq__11399_11414;
var G__11420 = chunk__11400_11415;
var G__11421 = count__11401_11416;
var G__11422 = (i__11402_11417 + (1));
seq__11399_11414 = G__11419;
chunk__11400_11415 = G__11420;
count__11401_11416 = G__11421;
i__11402_11417 = G__11422;
continue;
} else {
var temp__4126__auto___11423 = cljs.core.seq.call(null,seq__11399_11414);
if(temp__4126__auto___11423){
var seq__11399_11424__$1 = temp__4126__auto___11423;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11399_11424__$1)){
var c__5061__auto___11425 = cljs.core.chunk_first.call(null,seq__11399_11424__$1);
var G__11426 = cljs.core.chunk_rest.call(null,seq__11399_11424__$1);
var G__11427 = c__5061__auto___11425;
var G__11428 = cljs.core.count.call(null,c__5061__auto___11425);
var G__11429 = (0);
seq__11399_11414 = G__11426;
chunk__11400_11415 = G__11427;
count__11401_11416 = G__11428;
i__11402_11417 = G__11429;
continue;
} else {
var class_11430 = cljs.core.first.call(null,seq__11399_11424__$1);
class_list_11413.add(class_11430);

var G__11431 = cljs.core.next.call(null,seq__11399_11424__$1);
var G__11432 = null;
var G__11433 = (0);
var G__11434 = (0);
seq__11399_11414 = G__11431;
chunk__11400_11415 = G__11432;
count__11401_11416 = G__11433;
i__11402_11417 = G__11434;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_11435 = elem__$1.className;
var seq__11403_11436 = cljs.core.seq.call(null,classes__$1.split(/\s+/));
var chunk__11404_11437 = null;
var count__11405_11438 = (0);
var i__11406_11439 = (0);
while(true){
if((i__11406_11439 < count__11405_11438)){
var class_11440 = cljs.core._nth.call(null,chunk__11404_11437,i__11406_11439);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11435,class_11440))){
} else {
elem__$1.className = (((class_name_11435 === ""))?class_11440:[cljs.core.str(class_name_11435),cljs.core.str(" "),cljs.core.str(class_11440)].join(''));
}

var G__11441 = seq__11403_11436;
var G__11442 = chunk__11404_11437;
var G__11443 = count__11405_11438;
var G__11444 = (i__11406_11439 + (1));
seq__11403_11436 = G__11441;
chunk__11404_11437 = G__11442;
count__11405_11438 = G__11443;
i__11406_11439 = G__11444;
continue;
} else {
var temp__4126__auto___11445 = cljs.core.seq.call(null,seq__11403_11436);
if(temp__4126__auto___11445){
var seq__11403_11446__$1 = temp__4126__auto___11445;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11403_11446__$1)){
var c__5061__auto___11447 = cljs.core.chunk_first.call(null,seq__11403_11446__$1);
var G__11448 = cljs.core.chunk_rest.call(null,seq__11403_11446__$1);
var G__11449 = c__5061__auto___11447;
var G__11450 = cljs.core.count.call(null,c__5061__auto___11447);
var G__11451 = (0);
seq__11403_11436 = G__11448;
chunk__11404_11437 = G__11449;
count__11405_11438 = G__11450;
i__11406_11439 = G__11451;
continue;
} else {
var class_11452 = cljs.core.first.call(null,seq__11403_11446__$1);
if(cljs.core.truth_(dommy.attrs.class_index.call(null,class_name_11435,class_11452))){
} else {
elem__$1.className = (((class_name_11435 === ""))?class_11452:[cljs.core.str(class_name_11435),cljs.core.str(" "),cljs.core.str(class_11452)].join(''));
}

var G__11453 = cljs.core.next.call(null,seq__11403_11446__$1);
var G__11454 = null;
var G__11455 = (0);
var G__11456 = (0);
seq__11403_11436 = G__11453;
chunk__11404_11437 = G__11454;
count__11405_11438 = G__11455;
i__11406_11439 = G__11456;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11407_11457 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__11408_11458 = null;
var count__11409_11459 = (0);
var i__11410_11460 = (0);
while(true){
if((i__11410_11460 < count__11409_11459)){
var c_11461 = cljs.core._nth.call(null,chunk__11408_11458,i__11410_11460);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11461);

var G__11462 = seq__11407_11457;
var G__11463 = chunk__11408_11458;
var G__11464 = count__11409_11459;
var G__11465 = (i__11410_11460 + (1));
seq__11407_11457 = G__11462;
chunk__11408_11458 = G__11463;
count__11409_11459 = G__11464;
i__11410_11460 = G__11465;
continue;
} else {
var temp__4126__auto___11466 = cljs.core.seq.call(null,seq__11407_11457);
if(temp__4126__auto___11466){
var seq__11407_11467__$1 = temp__4126__auto___11466;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11407_11467__$1)){
var c__5061__auto___11468 = cljs.core.chunk_first.call(null,seq__11407_11467__$1);
var G__11469 = cljs.core.chunk_rest.call(null,seq__11407_11467__$1);
var G__11470 = c__5061__auto___11468;
var G__11471 = cljs.core.count.call(null,c__5061__auto___11468);
var G__11472 = (0);
seq__11407_11457 = G__11469;
chunk__11408_11458 = G__11470;
count__11409_11459 = G__11471;
i__11410_11460 = G__11472;
continue;
} else {
var c_11473 = cljs.core.first.call(null,seq__11407_11467__$1);
dommy.attrs.add_class_BANG_.call(null,elem__$1,c_11473);

var G__11474 = cljs.core.next.call(null,seq__11407_11467__$1);
var G__11475 = null;
var G__11476 = (0);
var G__11477 = (0);
seq__11407_11457 = G__11474;
chunk__11408_11458 = G__11475;
count__11409_11459 = G__11476;
i__11410_11460 = G__11477;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq11394){
var G__11395 = cljs.core.first.call(null,seq11394);
var seq11394__$1 = cljs.core.next.call(null,seq11394);
var G__11396 = cljs.core.first.call(null,seq11394__$1);
var seq11394__$2 = cljs.core.next.call(null,seq11394__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11395,G__11396,seq11394__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index.call(null,class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__11478 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__11478;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__11483 = arguments.length;
switch (G__11483) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11489 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11489)){
var class_list_11490 = temp__4124__auto___11489;
class_list_11490.remove(class$__$1);
} else {
var class_name_11491 = elem__$1.className;
var new_class_name_11492 = dommy.attrs.remove_class_str.call(null,class_name_11491,class$__$1);
if((class_name_11491 === new_class_name_11492)){
} else {
elem__$1.className = new_class_name_11492;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11484 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__11485 = null;
var count__11486 = (0);
var i__11487 = (0);
while(true){
if((i__11487 < count__11486)){
var c = cljs.core._nth.call(null,chunk__11485,i__11487);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11493 = seq__11484;
var G__11494 = chunk__11485;
var G__11495 = count__11486;
var G__11496 = (i__11487 + (1));
seq__11484 = G__11493;
chunk__11485 = G__11494;
count__11486 = G__11495;
i__11487 = G__11496;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq.call(null,seq__11484);
if(temp__4126__auto__){
var seq__11484__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11484__$1)){
var c__5061__auto__ = cljs.core.chunk_first.call(null,seq__11484__$1);
var G__11497 = cljs.core.chunk_rest.call(null,seq__11484__$1);
var G__11498 = c__5061__auto__;
var G__11499 = cljs.core.count.call(null,c__5061__auto__);
var G__11500 = (0);
seq__11484 = G__11497;
chunk__11485 = G__11498;
count__11486 = G__11499;
i__11487 = G__11500;
continue;
} else {
var c = cljs.core.first.call(null,seq__11484__$1);
dommy.attrs.remove_class_BANG_.call(null,elem__$1,c);

var G__11501 = cljs.core.next.call(null,seq__11484__$1);
var G__11502 = null;
var G__11503 = (0);
var G__11504 = (0);
seq__11484 = G__11501;
chunk__11485 = G__11502;
count__11486 = G__11503;
i__11487 = G__11504;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq11479){
var G__11480 = cljs.core.first.call(null,seq11479);
var seq11479__$1 = cljs.core.next.call(null,seq11479);
var G__11481 = cljs.core.first.call(null,seq11479__$1);
var seq11479__$2 = cljs.core.next.call(null,seq11479__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11480,G__11481,seq11479__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__11506 = arguments.length;
switch (G__11506) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var class$__$1 = cljs.core.name.call(null,class$);
var temp__4124__auto___11508 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___11508)){
var class_list_11509 = temp__4124__auto___11508;
class_list_11509.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.call(null,elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_.call(null,elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.call(null,elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.call(null,elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p__11512){
var vec__11513 = p__11512;
var k = cljs.core.nth.call(null,vec__11513,(0),null);
var v = cljs.core.nth.call(null,vec__11513,(1),null);
return [cljs.core.str(cljs.core.name.call(null,k)),cljs.core.str(":"),cljs.core.str(cljs.core.name.call(null,v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var style = elem__$1.style;
var seq__11516_11522 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11517_11523 = null;
var count__11518_11524 = (0);
var i__11519_11525 = (0);
while(true){
if((i__11519_11525 < count__11518_11524)){
var vec__11520_11526 = cljs.core._nth.call(null,chunk__11517_11523,i__11519_11525);
var k_11527 = cljs.core.nth.call(null,vec__11520_11526,(0),null);
var v_11528 = cljs.core.nth.call(null,vec__11520_11526,(1),null);
(style[cljs.core.name.call(null,k_11527)] = v_11528);

var G__11529 = seq__11516_11522;
var G__11530 = chunk__11517_11523;
var G__11531 = count__11518_11524;
var G__11532 = (i__11519_11525 + (1));
seq__11516_11522 = G__11529;
chunk__11517_11523 = G__11530;
count__11518_11524 = G__11531;
i__11519_11525 = G__11532;
continue;
} else {
var temp__4126__auto___11533 = cljs.core.seq.call(null,seq__11516_11522);
if(temp__4126__auto___11533){
var seq__11516_11534__$1 = temp__4126__auto___11533;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11516_11534__$1)){
var c__5061__auto___11535 = cljs.core.chunk_first.call(null,seq__11516_11534__$1);
var G__11536 = cljs.core.chunk_rest.call(null,seq__11516_11534__$1);
var G__11537 = c__5061__auto___11535;
var G__11538 = cljs.core.count.call(null,c__5061__auto___11535);
var G__11539 = (0);
seq__11516_11522 = G__11536;
chunk__11517_11523 = G__11537;
count__11518_11524 = G__11538;
i__11519_11525 = G__11539;
continue;
} else {
var vec__11521_11540 = cljs.core.first.call(null,seq__11516_11534__$1);
var k_11541 = cljs.core.nth.call(null,vec__11521_11540,(0),null);
var v_11542 = cljs.core.nth.call(null,vec__11521_11540,(1),null);
(style[cljs.core.name.call(null,k_11541)] = v_11542);

var G__11543 = cljs.core.next.call(null,seq__11516_11534__$1);
var G__11544 = null;
var G__11545 = (0);
var G__11546 = (0);
seq__11516_11522 = G__11543;
chunk__11517_11523 = G__11544;
count__11518_11524 = G__11545;
i__11519_11525 = G__11546;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq11514){
var G__11515 = cljs.core.first.call(null,seq11514);
var seq11514__$1 = cljs.core.next.call(null,seq11514);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11515,seq11514__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"k","k",-505765866,null)))].join('')));
}

return (window.getComputedStyle(dommy.template.__GT_node_like.call(null,elem))[cljs.core.name.call(null,k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11549_11555 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__11550_11556 = null;
var count__11551_11557 = (0);
var i__11552_11558 = (0);
while(true){
if((i__11552_11558 < count__11551_11557)){
var vec__11553_11559 = cljs.core._nth.call(null,chunk__11550_11556,i__11552_11558);
var k_11560 = cljs.core.nth.call(null,vec__11553_11559,(0),null);
var v_11561 = cljs.core.nth.call(null,vec__11553_11559,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11560,[cljs.core.str(v_11561),cljs.core.str("px")].join(''));

var G__11562 = seq__11549_11555;
var G__11563 = chunk__11550_11556;
var G__11564 = count__11551_11557;
var G__11565 = (i__11552_11558 + (1));
seq__11549_11555 = G__11562;
chunk__11550_11556 = G__11563;
count__11551_11557 = G__11564;
i__11552_11558 = G__11565;
continue;
} else {
var temp__4126__auto___11566 = cljs.core.seq.call(null,seq__11549_11555);
if(temp__4126__auto___11566){
var seq__11549_11567__$1 = temp__4126__auto___11566;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11549_11567__$1)){
var c__5061__auto___11568 = cljs.core.chunk_first.call(null,seq__11549_11567__$1);
var G__11569 = cljs.core.chunk_rest.call(null,seq__11549_11567__$1);
var G__11570 = c__5061__auto___11568;
var G__11571 = cljs.core.count.call(null,c__5061__auto___11568);
var G__11572 = (0);
seq__11549_11555 = G__11569;
chunk__11550_11556 = G__11570;
count__11551_11557 = G__11571;
i__11552_11558 = G__11572;
continue;
} else {
var vec__11554_11573 = cljs.core.first.call(null,seq__11549_11567__$1);
var k_11574 = cljs.core.nth.call(null,vec__11554_11573,(0),null);
var v_11575 = cljs.core.nth.call(null,vec__11554_11573,(1),null);
dommy.attrs.set_style_BANG_.call(null,elem__$1,k_11574,[cljs.core.str(v_11575),cljs.core.str("px")].join(''));

var G__11576 = cljs.core.next.call(null,seq__11549_11567__$1);
var G__11577 = null;
var G__11578 = (0);
var G__11579 = (0);
seq__11549_11555 = G__11576;
chunk__11550_11556 = G__11577;
count__11551_11557 = G__11578;
i__11552_11558 = G__11579;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq11547){
var G__11548 = cljs.core.first.call(null,seq11547);
var seq11547__$1 = cljs.core.next.call(null,seq11547);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11548,seq11547__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style.call(null,dommy.template.__GT_node_like.call(null,elem),k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__11585 = arguments.length;
switch (G__11585) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.call(null,dommy.template.__GT_node_like.call(null,elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__11586 = dommy.template.__GT_node_like.call(null,elem);
(G__11586[cljs.core.name.call(null,k)] = v);

return G__11586;
} else {
var G__11587 = dommy.template.__GT_node_like.call(null,elem);
G__11587.setAttribute(cljs.core.name.call(null,k),(((k === new cljs.core.Keyword(null,"style","style",-496642736)))?dommy.attrs.style_str.call(null,v):v));

return G__11587;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11588_11595 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__11589_11596 = null;
var count__11590_11597 = (0);
var i__11591_11598 = (0);
while(true){
if((i__11591_11598 < count__11590_11597)){
var vec__11592_11599 = cljs.core._nth.call(null,chunk__11589_11596,i__11591_11598);
var k_11600__$1 = cljs.core.nth.call(null,vec__11592_11599,(0),null);
var v_11601__$1 = cljs.core.nth.call(null,vec__11592_11599,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11600__$1,v_11601__$1);

var G__11602 = seq__11588_11595;
var G__11603 = chunk__11589_11596;
var G__11604 = count__11590_11597;
var G__11605 = (i__11591_11598 + (1));
seq__11588_11595 = G__11602;
chunk__11589_11596 = G__11603;
count__11590_11597 = G__11604;
i__11591_11598 = G__11605;
continue;
} else {
var temp__4126__auto___11606 = cljs.core.seq.call(null,seq__11588_11595);
if(temp__4126__auto___11606){
var seq__11588_11607__$1 = temp__4126__auto___11606;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11588_11607__$1)){
var c__5061__auto___11608 = cljs.core.chunk_first.call(null,seq__11588_11607__$1);
var G__11609 = cljs.core.chunk_rest.call(null,seq__11588_11607__$1);
var G__11610 = c__5061__auto___11608;
var G__11611 = cljs.core.count.call(null,c__5061__auto___11608);
var G__11612 = (0);
seq__11588_11595 = G__11609;
chunk__11589_11596 = G__11610;
count__11590_11597 = G__11611;
i__11591_11598 = G__11612;
continue;
} else {
var vec__11593_11613 = cljs.core.first.call(null,seq__11588_11607__$1);
var k_11614__$1 = cljs.core.nth.call(null,vec__11593_11613,(0),null);
var v_11615__$1 = cljs.core.nth.call(null,vec__11593_11613,(1),null);
dommy.attrs.set_attr_BANG_.call(null,elem__$1,k_11614__$1,v_11615__$1);

var G__11616 = cljs.core.next.call(null,seq__11588_11607__$1);
var G__11617 = null;
var G__11618 = (0);
var G__11619 = (0);
seq__11588_11595 = G__11616;
chunk__11589_11596 = G__11617;
count__11590_11597 = G__11618;
i__11591_11598 = G__11619;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq11580){
var G__11581 = cljs.core.first.call(null,seq11580);
var seq11580__$1 = cljs.core.next.call(null,seq11580);
var G__11582 = cljs.core.first.call(null,seq11580__$1);
var seq11580__$2 = cljs.core.next.call(null,seq11580__$1);
var G__11583 = cljs.core.first.call(null,seq11580__$2);
var seq11580__$3 = cljs.core.next.call(null,seq11580__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11581,G__11582,G__11583,seq11580__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__11624 = arguments.length;
switch (G__11624) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),null,new cljs.core.Keyword(null,"classes","classes",2037804510),null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name.call(null,k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var seq__11625_11630 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__11626_11631 = null;
var count__11627_11632 = (0);
var i__11628_11633 = (0);
while(true){
if((i__11628_11633 < count__11627_11632)){
var k_11634__$1 = cljs.core._nth.call(null,chunk__11626_11631,i__11628_11633);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11634__$1);

var G__11635 = seq__11625_11630;
var G__11636 = chunk__11626_11631;
var G__11637 = count__11627_11632;
var G__11638 = (i__11628_11633 + (1));
seq__11625_11630 = G__11635;
chunk__11626_11631 = G__11636;
count__11627_11632 = G__11637;
i__11628_11633 = G__11638;
continue;
} else {
var temp__4126__auto___11639 = cljs.core.seq.call(null,seq__11625_11630);
if(temp__4126__auto___11639){
var seq__11625_11640__$1 = temp__4126__auto___11639;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11625_11640__$1)){
var c__5061__auto___11641 = cljs.core.chunk_first.call(null,seq__11625_11640__$1);
var G__11642 = cljs.core.chunk_rest.call(null,seq__11625_11640__$1);
var G__11643 = c__5061__auto___11641;
var G__11644 = cljs.core.count.call(null,c__5061__auto___11641);
var G__11645 = (0);
seq__11625_11630 = G__11642;
chunk__11626_11631 = G__11643;
count__11627_11632 = G__11644;
i__11628_11633 = G__11645;
continue;
} else {
var k_11646__$1 = cljs.core.first.call(null,seq__11625_11640__$1);
dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k_11646__$1);

var G__11647 = cljs.core.next.call(null,seq__11625_11640__$1);
var G__11648 = null;
var G__11649 = (0);
var G__11650 = (0);
seq__11625_11630 = G__11647;
chunk__11626_11631 = G__11648;
count__11627_11632 = G__11649;
i__11628_11633 = G__11650;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq11620){
var G__11621 = cljs.core.first.call(null,seq11620);
var seq11620__$1 = cljs.core.next.call(null,seq11620);
var G__11622 = cljs.core.first.call(null,seq11620__$1);
var seq11620__$2 = cljs.core.next.call(null,seq11620__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11621,G__11622,seq11620__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like.call(null,elem).getAttribute(cljs.core.name.call(null,k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__11652 = arguments.length;
switch (G__11652) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.attrs.attr.call(null,elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.call(null,elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.call(null,elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like.call(null,elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__11655 = arguments.length;
switch (G__11655) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__11656 = dommy.template.__GT_node_like.call(null,elem);
G__11656.style.display = ((show_QMARK_)?"":"none");

return G__11656;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,elem__$1,dommy.attrs.hidden_QMARK_.call(null,elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__11659 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11659,false);

return G__11659;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__11661 = dommy.template.__GT_node_like.call(null,elem);
dommy.attrs.toggle_BANG_.call(null,G__11661,true);

return G__11661;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.call(null,(function (){var G__11663 = dommy.template.__GT_node_like.call(null,elem).getBoundingClientRect();
(G__11663["constructor"] = Object);

return G__11663;
})(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect.call(null,elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
