// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__28664 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28664) : cljs.core.atom.call(null,G__28664));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4425__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4425__auto__)){
var req = temp__4425__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.constant$keyword$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.constant$keyword$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__28677 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)));
var chunk__28682 = null;
var count__28683 = (0);
var i__28684 = (0);
while(true){
if((i__28684 < count__28683)){
var h_name = chunk__28682.cljs$core$IIndexed$_nth$arity$2(null,i__28684);
var seq__28685_28689 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28686_28690 = null;
var count__28687_28691 = (0);
var i__28688_28692 = (0);
while(true){
if((i__28688_28692 < count__28687_28691)){
var h_val_28693 = chunk__28686_28690.cljs$core$IIndexed$_nth$arity$2(null,i__28688_28692);
xhr.headers.set(h_name,h_val_28693);

var G__28694 = seq__28685_28689;
var G__28695 = chunk__28686_28690;
var G__28696 = count__28687_28691;
var G__28697 = (i__28688_28692 + (1));
seq__28685_28689 = G__28694;
chunk__28686_28690 = G__28695;
count__28687_28691 = G__28696;
i__28688_28692 = G__28697;
continue;
} else {
var temp__4425__auto___28698 = cljs.core.seq(seq__28685_28689);
if(temp__4425__auto___28698){
var seq__28685_28699__$1 = temp__4425__auto___28698;
if(cljs.core.chunked_seq_QMARK_(seq__28685_28699__$1)){
var c__8721__auto___28700 = cljs.core.chunk_first(seq__28685_28699__$1);
var G__28701 = cljs.core.chunk_rest(seq__28685_28699__$1);
var G__28702 = c__8721__auto___28700;
var G__28703 = cljs.core.count(c__8721__auto___28700);
var G__28704 = (0);
seq__28685_28689 = G__28701;
chunk__28686_28690 = G__28702;
count__28687_28691 = G__28703;
i__28688_28692 = G__28704;
continue;
} else {
var h_val_28705 = cljs.core.first(seq__28685_28699__$1);
xhr.headers.set(h_name,h_val_28705);

var G__28706 = cljs.core.next(seq__28685_28699__$1);
var G__28707 = null;
var G__28708 = (0);
var G__28709 = (0);
seq__28685_28689 = G__28706;
chunk__28686_28690 = G__28707;
count__28687_28691 = G__28708;
i__28688_28692 = G__28709;
continue;
}
} else {
}
}
break;
}

var G__28710 = seq__28677;
var G__28711 = chunk__28682;
var G__28712 = count__28683;
var G__28713 = (i__28684 + (1));
seq__28677 = G__28710;
chunk__28682 = G__28711;
count__28683 = G__28712;
i__28684 = G__28713;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28677);
if(temp__4425__auto__){
var seq__28677__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28677__$1)){
var c__8721__auto__ = cljs.core.chunk_first(seq__28677__$1);
var G__28714 = cljs.core.chunk_rest(seq__28677__$1);
var G__28715 = c__8721__auto__;
var G__28716 = cljs.core.count(c__8721__auto__);
var G__28717 = (0);
seq__28677 = G__28714;
chunk__28682 = G__28715;
count__28683 = G__28716;
i__28684 = G__28717;
continue;
} else {
var h_name = cljs.core.first(seq__28677__$1);
var seq__28678_28718 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28679_28719 = null;
var count__28680_28720 = (0);
var i__28681_28721 = (0);
while(true){
if((i__28681_28721 < count__28680_28720)){
var h_val_28722 = chunk__28679_28719.cljs$core$IIndexed$_nth$arity$2(null,i__28681_28721);
xhr.headers.set(h_name,h_val_28722);

var G__28723 = seq__28678_28718;
var G__28724 = chunk__28679_28719;
var G__28725 = count__28680_28720;
var G__28726 = (i__28681_28721 + (1));
seq__28678_28718 = G__28723;
chunk__28679_28719 = G__28724;
count__28680_28720 = G__28725;
i__28681_28721 = G__28726;
continue;
} else {
var temp__4425__auto___28727__$1 = cljs.core.seq(seq__28678_28718);
if(temp__4425__auto___28727__$1){
var seq__28678_28728__$1 = temp__4425__auto___28727__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28678_28728__$1)){
var c__8721__auto___28729 = cljs.core.chunk_first(seq__28678_28728__$1);
var G__28730 = cljs.core.chunk_rest(seq__28678_28728__$1);
var G__28731 = c__8721__auto___28729;
var G__28732 = cljs.core.count(c__8721__auto___28729);
var G__28733 = (0);
seq__28678_28718 = G__28730;
chunk__28679_28719 = G__28731;
count__28680_28720 = G__28732;
i__28681_28721 = G__28733;
continue;
} else {
var h_val_28734 = cljs.core.first(seq__28678_28728__$1);
xhr.headers.set(h_name,h_val_28734);

var G__28735 = cljs.core.next(seq__28678_28728__$1);
var G__28736 = null;
var G__28737 = (0);
var G__28738 = (0);
seq__28678_28718 = G__28735;
chunk__28679_28719 = G__28736;
count__28680_28720 = G__28737;
i__28681_28721 = G__28738;
continue;
}
} else {
}
}
break;
}

var G__28739 = cljs.core.next(seq__28677__$1);
var G__28740 = null;
var G__28741 = (0);
var G__28742 = (0);
seq__28677 = G__28739;
chunk__28682 = G__28740;
count__28683 = G__28741;
i__28684 = G__28742;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__28744 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$array_DASH_buffer,G__28744)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$blob,G__28744)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$document,G__28744)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$text,G__28744)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$default,G__28744)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__28744)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__28745){
var map__28749 = p__28745;
var map__28749__$1 = ((((!((map__28749 == null)))?((((map__28749.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28749.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28749):map__28749);
var request = map__28749__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28749__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28749__$1,cljs.core.constant$keyword$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28749__$1,cljs.core.constant$keyword$response_DASH_type);
var timeout = (function (){var or__7937__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__28751 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__28751,default_headers);

cljs_http.core.apply_response_type_BANG_(G__28751,response_type);

G__28751.setTimeoutInterval(timeout);

G__28751.setWithCredentials(send_credentials);

return G__28751;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.constant$keyword$no_DASH_error,cljs.core.constant$keyword$abort,cljs.core.constant$keyword$access_DASH_denied,cljs.core.constant$keyword$custom_DASH_error,cljs.core.constant$keyword$http_DASH_error,cljs.core.constant$keyword$ff_DASH_silent_DASH_error,cljs.core.constant$keyword$file_DASH_not_DASH_found,cljs.core.constant$keyword$offline,cljs.core.constant$keyword$exception,cljs.core.constant$keyword$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__28752){
var map__28780 = p__28752;
var map__28780__$1 = ((((!((map__28780 == null)))?((((map__28780.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28780.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28780):map__28780);
var request = map__28780__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28780__$1,cljs.core.constant$keyword$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28780__$1,cljs.core.constant$keyword$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28780__$1,cljs.core.constant$keyword$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28780__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28780__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__7937__auto__ = request_method;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponse(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.constant$keyword$error_DASH_code,(function (){var G__28782 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__28782) : cljs_http.core.error_kw.call(null,G__28782));
})(),cljs.core.constant$keyword$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__11624__auto___28807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_28793){
var state_val_28794 = (state_28793[(1)]);
if((state_val_28794 === (1))){
var state_28793__$1 = state_28793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28793__$1,(2),cancel);
} else {
if((state_val_28794 === (2))){
var inst_28784 = (state_28793[(2)]);
var inst_28785 = xhr__$1.isComplete();
var inst_28786 = cljs.core.not(inst_28785);
var state_28793__$1 = (function (){var statearr_28795 = state_28793;
(statearr_28795[(7)] = inst_28784);

return statearr_28795;
})();
if(inst_28786){
var statearr_28796_28808 = state_28793__$1;
(statearr_28796_28808[(1)] = (3));

} else {
var statearr_28797_28809 = state_28793__$1;
(statearr_28797_28809[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28794 === (3))){
var inst_28788 = xhr__$1.abort();
var state_28793__$1 = state_28793;
var statearr_28798_28810 = state_28793__$1;
(statearr_28798_28810[(2)] = inst_28788);

(statearr_28798_28810[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28794 === (4))){
var state_28793__$1 = state_28793;
var statearr_28799_28811 = state_28793__$1;
(statearr_28799_28811[(2)] = null);

(statearr_28799_28811[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28794 === (5))){
var inst_28791 = (state_28793[(2)]);
var state_28793__$1 = state_28793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28793__$1,inst_28791);
} else {
return null;
}
}
}
}
}
});})(c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__11559__auto__,c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__11560__auto__ = null;
var cljs_http$core$xhr_$_state_machine__11560__auto____0 = (function (){
var statearr_28803 = [null,null,null,null,null,null,null,null];
(statearr_28803[(0)] = cljs_http$core$xhr_$_state_machine__11560__auto__);

(statearr_28803[(1)] = (1));

return statearr_28803;
});
var cljs_http$core$xhr_$_state_machine__11560__auto____1 = (function (state_28793){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_28793);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e28804){if((e28804 instanceof Object)){
var ex__11563__auto__ = e28804;
var statearr_28805_28812 = state_28793;
(statearr_28805_28812[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28793);

return cljs.core.constant$keyword$recur;
} else {
throw e28804;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__28813 = state_28793;
state_28793 = G__28813;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__11560__auto__ = function(state_28793){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__11560__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__11560__auto____1.call(this,state_28793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__11560__auto____0;
cljs_http$core$xhr_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__11560__auto____1;
return cljs_http$core$xhr_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__11626__auto__ = (function (){var statearr_28806 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_28806[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___28807);

return statearr_28806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___28807,channel,request_url,method,headers__$1,xhr__$1,map__28780,map__28780__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__28814){
var map__28831 = p__28814;
var map__28831__$1 = ((((!((map__28831 == null)))?((((map__28831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28831):map__28831);
var request = map__28831__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28831__$1,cljs.core.constant$keyword$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28831__$1,cljs.core.constant$keyword$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28831__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_28847 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$status,(200),cljs.core.constant$keyword$success,true,cljs.core.constant$keyword$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$jsonp,jsonp__$1,cljs.core.constant$keyword$request,req_28847], null));

if(cljs.core.truth_(cancel)){
var c__11624__auto___28848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel){
return (function (){
var f__11625__auto__ = (function (){var switch__11559__auto__ = ((function (c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel){
return (function (state_28837){
var state_val_28838 = (state_28837[(1)]);
if((state_val_28838 === (1))){
var state_28837__$1 = state_28837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28837__$1,(2),cancel);
} else {
if((state_val_28838 === (2))){
var inst_28834 = (state_28837[(2)]);
var inst_28835 = jsonp__$1.cancel(req_28847);
var state_28837__$1 = (function (){var statearr_28839 = state_28837;
(statearr_28839[(7)] = inst_28834);

return statearr_28839;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28837__$1,inst_28835);
} else {
return null;
}
}
});})(c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__11559__auto__,c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__11560__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__11560__auto____0 = (function (){
var statearr_28843 = [null,null,null,null,null,null,null,null];
(statearr_28843[(0)] = cljs_http$core$jsonp_$_state_machine__11560__auto__);

(statearr_28843[(1)] = (1));

return statearr_28843;
});
var cljs_http$core$jsonp_$_state_machine__11560__auto____1 = (function (state_28837){
while(true){
var ret_value__11561__auto__ = (function (){try{while(true){
var result__11562__auto__ = switch__11559__auto__(state_28837);
if(cljs.core.keyword_identical_QMARK_(result__11562__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11562__auto__;
}
break;
}
}catch (e28844){if((e28844 instanceof Object)){
var ex__11563__auto__ = e28844;
var statearr_28845_28849 = state_28837;
(statearr_28845_28849[(5)] = ex__11563__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28837);

return cljs.core.constant$keyword$recur;
} else {
throw e28844;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11561__auto__,cljs.core.constant$keyword$recur)){
var G__28850 = state_28837;
state_28837 = G__28850;
continue;
} else {
return ret_value__11561__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__11560__auto__ = function(state_28837){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__11560__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__11560__auto____1.call(this,state_28837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__11560__auto____0;
cljs_http$core$jsonp_$_state_machine__11560__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__11560__auto____1;
return cljs_http$core$jsonp_$_state_machine__11560__auto__;
})()
;})(switch__11559__auto__,c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel))
})();
var state__11626__auto__ = (function (){var statearr_28846 = (f__11625__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11625__auto__.cljs$core$IFn$_invoke$arity$0() : f__11625__auto__.call(null));
(statearr_28846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11624__auto___28848);

return statearr_28846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11626__auto__);
});})(c__11624__auto___28848,req_28847,channel,jsonp__$1,map__28831,map__28831__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__28851){
var map__28854 = p__28851;
var map__28854__$1 = ((((!((map__28854 == null)))?((((map__28854.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28854.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28854):map__28854);
var request__$1 = map__28854__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28854__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.constant$keyword$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
