// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.organization');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.organization.internal_members_team_name = "members";
milia.api.organization.owners_team_name = "Owners";
milia.api.organization.editor_role = "editor";
/**
 * List all the organizations belonging to the account making the request.
 * When a username is provided, return only those organizations shared by both
 * the account making the request and the user associated with the username.
 */
milia.api.organization.all = (function milia$api$organization$all(){
var args28352 = [];
var len__9081__auto___28355 = arguments.length;
var i__9082__auto___28356 = (0);
while(true){
if((i__9082__auto___28356 < len__9081__auto___28355)){
args28352.push((arguments[i__9082__auto___28356]));

var G__28357 = (i__9082__auto___28356 + (1));
i__9082__auto___28356 = G__28357;
continue;
} else {
}
break;
}

var G__28354 = args28352.length;
switch (G__28354) {
case 0:
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28352.length)].join('')));

}
});

milia.api.organization.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$1(null);
});

milia.api.organization.all.cljs$core$IFn$_invoke$arity$1 = (function (username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(username)?[cljs.core.str("orgs?shared_with="),cljs.core.str(username)].join(''):"orgs")], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});

milia.api.organization.all.cljs$lang$maxFixedArity = 1;
milia.api.organization.create = (function milia$api$organization$create(data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null),cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], 0));
});
milia.api.organization.profile = (function milia$api$organization$profile(){
var args__9088__auto__ = [];
var len__9081__auto___28364 = arguments.length;
var i__9082__auto___28365 = (0);
while(true){
if((i__9082__auto___28365 < len__9081__auto___28364)){
args__9088__auto__.push((arguments[i__9082__auto___28365]));

var G__28366 = (i__9082__auto___28365 + (1));
i__9082__auto___28365 = G__28366;
continue;
} else {
}
break;
}

var argseq__9089__auto__ = ((((1) < args__9088__auto__.length))?(new cljs.core.IndexedSeq(args__9088__auto__.slice((1)),(0))):null);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9089__auto__);
});

milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic = (function (org_name,p__28361){
var map__28362 = p__28361;
var map__28362__$1 = ((((!((map__28362 == null)))?((((map__28362.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28362.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28362):map__28362);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28362__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.organization.profile.cljs$lang$maxFixedArity = (1);

milia.api.organization.profile.cljs$lang$applyTo = (function (seq28359){
var G__28360 = cljs.core.first(seq28359);
var seq28359__$1 = cljs.core.next(seq28359);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic(G__28360,seq28359__$1);
});
/**
 * Return all the teams for an organization.
 */
milia.api.organization.teams_all = (function milia$api$organization$teams_all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Return the teams for an organization, removing 'members' team that is used
 * internall by the API to store non-team based org members.
 */
milia.api.organization.teams = (function milia$api$organization$teams(org_name){
var teams__$1 = milia.api.organization.teams_all();
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (teams__$1){
return (function (p1__28367_SHARP_){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.internal_members_team_name,cljs.core.constant$keyword$name.cljs$core$IFn$_invoke$arity$1(p1__28367_SHARP_))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(org_name,cljs.core.constant$keyword$organization.cljs$core$IFn$_invoke$arity$1(p1__28367_SHARP_)));
});})(teams__$1))
,teams__$1);
});
milia.api.organization.team_info = (function milia$api$organization$team_info(org_name,team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
milia.api.organization.team_members = (function milia$api$organization$team_members(team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"members"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Add a team to an organization
 */
milia.api.organization.create_team = (function milia$api$organization$create_team(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null)], 0));
});
/**
 * Add a user to a team
 */
milia.api.organization.add_team_member = (function milia$api$organization$add_team_member(org_name,team_id,user){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,user], null)], 0));
});
milia.api.organization.members = (function milia$api$organization$members(org_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Add a user to an organization
 */
milia.api.organization.add_member = (function milia$api$organization$add_member(){
var args28368 = [];
var len__9081__auto___28371 = arguments.length;
var i__9082__auto___28372 = (0);
while(true){
if((i__9082__auto___28372 < len__9081__auto___28371)){
args28368.push((arguments[i__9082__auto___28372]));

var G__28373 = (i__9082__auto___28372 + (1));
i__9082__auto___28372 = G__28373;
continue;
} else {
}
break;
}

var G__28370 = args28368.length;
switch (G__28370) {
case 2:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28368.length)].join('')));

}
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
var assigned_role = (cljs.core.truth_(role)?role:milia.api.organization.editor_role);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,member,cljs.core.constant$keyword$role,assigned_role], null)], null),cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], 0));
});

milia.api.organization.add_member.cljs$lang$maxFixedArity = 3;
/**
 * Remove a user from an organization or organization team
 */
milia.api.organization.remove_member = (function milia$api$organization$remove_member(){
var args28375 = [];
var len__9081__auto___28378 = arguments.length;
var i__9082__auto___28379 = (0);
while(true){
if((i__9082__auto___28379 < len__9081__auto___28378)){
args28375.push((arguments[i__9082__auto___28379]));

var G__28380 = (i__9082__auto___28379 + (1));
i__9082__auto___28379 = G__28380;
continue;
} else {
}
break;
}

var G__28377 = args28375.length;
switch (G__28377) {
case 2:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28375.length)].join('')));

}
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,team_id){
var url = (cljs.core.truth_(team_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$delete,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$username,member], null)], null)], 0));
});

milia.api.organization.remove_member.cljs$lang$maxFixedArity = 3;
/**
 * Is the user the only member of the Owners team.
 */
milia.api.organization.single_owner_QMARK_ = (function milia$api$organization$single_owner_QMARK_(team,members){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.owners_team_name,cljs.core.constant$keyword$name.cljs$core$IFn$_invoke$arity$1(team))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(members)));
});
/**
 * Is user only members in org with owner role?
 */
milia.api.organization.single_owner_member_QMARK_ = (function milia$api$organization$single_owner_member_QMARK_(org_name){
var org = milia.api.organization.profile(org_name);
var users = cljs.core.constant$keyword$users.cljs$core$IFn$_invoke$arity$1(org);
var owner_roles = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (org,users){
return (function (p1__28382_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("owner",p1__28382_SHARP_);
});})(org,users))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$role,users));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(owner_roles),(1));
});
/**
 * update organization profile
 */
milia.api.organization.update = (function milia$api$organization$update(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",cljs.core.constant$keyword$org.cljs$core$IFn$_invoke$arity$1(params)], 0));
var params__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(params,cljs.core.constant$keyword$org);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,params__$1,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null),cljs.core.constant$keyword$raw_DASH_response_QMARK_,true,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], 0));
});
/**
 * Returns an Organizaion team given the team name.
 */
milia.api.organization.get_team = (function milia$api$organization$get_team(org_name,team_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("teams?org="),cljs.core.str(org_name)].join('')], 0));
var teams = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (url,teams){
return (function (p1__28383_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(team_name,cljs.core.constant$keyword$name.cljs$core$IFn$_invoke$arity$1(p1__28383_SHARP_));
});})(url,teams))
,teams));
});
milia.api.organization.share_team = (function milia$api$organization$share_team(team_id,data){

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"share"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null)], 0));
});
