// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t29446 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29446 = (function (fn_handler,f,meta29447){
this.fn_handler = fn_handler;
this.f = f;
this.meta29447 = meta29447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29448,meta29447__$1){
var self__ = this;
var _29448__$1 = this;
return (new cljs.core.async.t29446(self__.fn_handler,self__.f,meta29447__$1));
});

cljs.core.async.t29446.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29448){
var self__ = this;
var _29448__$1 = this;
return self__.meta29447;
});

cljs.core.async.t29446.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29446.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t29446.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t29446.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fn-handler","fn-handler",648785851,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)))], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"meta29447","meta29447",-1063470986,null)], null);
});

cljs.core.async.t29446.cljs$lang$type = true;

cljs.core.async.t29446.cljs$lang$ctorStr = "cljs.core.async/t29446";

cljs.core.async.t29446.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29446");
});

cljs.core.async.__GT_t29446 = (function cljs$core$async$fn_handler_$___GT_t29446(fn_handler__$1,f__$1,meta29447){
return (new cljs.core.async.t29446(fn_handler__$1,f__$1,meta29447));
});

}

return (new cljs.core.async.t29446(cljs$core$async$fn_handler,f,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var args29451 = [];
var len__8976__auto___29454 = arguments.length;
var i__8977__auto___29455 = (0);
while(true){
if((i__8977__auto___29455 < len__8976__auto___29454)){
args29451.push((arguments[i__8977__auto___29455]));

var G__29456 = (i__8977__auto___29455 + (1));
i__8977__auto___29455 = G__29456;
continue;
} else {
}
break;
}

var G__29453 = args29451.length;
switch (G__29453) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29451.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var args29458 = [];
var len__8976__auto___29461 = arguments.length;
var i__8977__auto___29462 = (0);
while(true){
if((i__8977__auto___29462 < len__8976__auto___29461)){
args29458.push((arguments[i__8977__auto___29462]));

var G__29463 = (i__8977__auto___29462 + (1));
i__8977__auto___29462 = G__29463;
continue;
} else {
}
break;
}

var G__29460 = args29458.length;
switch (G__29460) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29458.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_29465 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29465) : fn1.call(null,val_29465));
} else {
cljs.core.async.impl.dispatch.run(((function (val_29465,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_29465) : fn1.call(null,val_29465));
});})(val_29465,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var args29466 = [];
var len__8976__auto___29469 = arguments.length;
var i__8977__auto___29470 = (0);
while(true){
if((i__8977__auto___29470 < len__8976__auto___29469)){
args29466.push((arguments[i__8977__auto___29470]));

var G__29471 = (i__8977__auto___29470 + (1));
i__8977__auto___29470 = G__29471;
continue;
} else {
}
break;
}

var G__29468 = args29466.length;
switch (G__29468) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29466.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4423__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8821__auto___29473 = n;
var x_29474 = (0);
while(true){
if((x_29474 < n__8821__auto___29473)){
(a[x_29474] = (0));

var G__29475 = (x_29474 + (1));
x_29474 = G__29475;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__29476 = (i + (1));
i = G__29476;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t29480 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29480 = (function (alt_flag,flag,meta29481){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29481 = meta29481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29482,meta29481__$1){
var self__ = this;
var _29482__$1 = this;
return (new cljs.core.async.t29480(self__.alt_flag,self__.flag,meta29481__$1));
});})(flag))
;

cljs.core.async.t29480.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29482){
var self__ = this;
var _29482__$1 = this;
return self__.meta29481;
});})(flag))
;

cljs.core.async.t29480.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29480.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t29480.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t29480.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29481","meta29481",-1611547607,null)], null);
});})(flag))
;

cljs.core.async.t29480.cljs$lang$type = true;

cljs.core.async.t29480.cljs$lang$ctorStr = "cljs.core.async/t29480";

cljs.core.async.t29480.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29480");
});})(flag))
;

cljs.core.async.__GT_t29480 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t29480(alt_flag__$1,flag__$1,meta29481){
return (new cljs.core.async.t29480(alt_flag__$1,flag__$1,meta29481));
});})(flag))
;

}

return (new cljs.core.async.t29480(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t29486 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t29486 = (function (alt_handler,flag,cb,meta29487){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29487 = meta29487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t29486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29488,meta29487__$1){
var self__ = this;
var _29488__$1 = this;
return (new cljs.core.async.t29486(self__.alt_handler,self__.flag,self__.cb,meta29487__$1));
});

cljs.core.async.t29486.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29488){
var self__ = this;
var _29488__$1 = this;
return self__.meta29487;
});

cljs.core.async.t29486.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t29486.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t29486.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t29486.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$private,true,cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29487","meta29487",1684984506,null)], null);
});

cljs.core.async.t29486.cljs$lang$type = true;

cljs.core.async.t29486.cljs$lang$ctorStr = "cljs.core.async/t29486";

cljs.core.async.t29486.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t29486");
});

cljs.core.async.__GT_t29486 = (function cljs$core$async$alt_handler_$___GT_t29486(alt_handler__$1,flag__$1,cb__$1,meta29487){
return (new cljs.core.async.t29486(alt_handler__$1,flag__$1,cb__$1,meta29487));
});

}

return (new cljs.core.async.t29486(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29489_SHARP_){
var G__29493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29489_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29493) : fret.call(null,G__29493));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29490_SHARP_){
var G__29494 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29490_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__29494) : fret.call(null,G__29494));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7937__auto__ = wport;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29495 = (i + (1));
i = G__29495;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7937__auto__ = ret;
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4425__auto__ = (function (){var and__7925__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7925__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7925__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___29501 = arguments.length;
var i__8977__auto___29502 = (0);
while(true){
if((i__8977__auto___29502 < len__8976__auto___29501)){
args__8983__auto__.push((arguments[i__8977__auto___29502]));

var G__29503 = (i__8977__auto___29502 + (1));
i__8977__auto___29502 = G__29503;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((1) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8984__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29498){
var map__29499 = p__29498;
var map__29499__$1 = ((((!((map__29499 == null)))?((((map__29499.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29499.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29499):map__29499);
var opts = map__29499__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29496){
var G__29497 = cljs.core.first(seq29496);
var seq29496__$1 = cljs.core.next(seq29496);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29497,seq29496__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var args29504 = [];
var len__8976__auto___29554 = arguments.length;
var i__8977__auto___29555 = (0);
while(true){
if((i__8977__auto___29555 < len__8976__auto___29554)){
args29504.push((arguments[i__8977__auto___29555]));

var G__29556 = (i__8977__auto___29555 + (1));
i__8977__auto___29555 = G__29556;
continue;
} else {
}
break;
}

var G__29506 = args29504.length;
switch (G__29506) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29504.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11556__auto___29558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___29558){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___29558){
return (function (state_29530){
var state_val_29531 = (state_29530[(1)]);
if((state_val_29531 === (7))){
var inst_29526 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29532_29559 = state_29530__$1;
(statearr_29532_29559[(2)] = inst_29526);

(statearr_29532_29559[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (1))){
var state_29530__$1 = state_29530;
var statearr_29533_29560 = state_29530__$1;
(statearr_29533_29560[(2)] = null);

(statearr_29533_29560[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (4))){
var inst_29509 = (state_29530[(7)]);
var inst_29509__$1 = (state_29530[(2)]);
var inst_29510 = (inst_29509__$1 == null);
var state_29530__$1 = (function (){var statearr_29534 = state_29530;
(statearr_29534[(7)] = inst_29509__$1);

return statearr_29534;
})();
if(cljs.core.truth_(inst_29510)){
var statearr_29535_29561 = state_29530__$1;
(statearr_29535_29561[(1)] = (5));

} else {
var statearr_29536_29562 = state_29530__$1;
(statearr_29536_29562[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (13))){
var state_29530__$1 = state_29530;
var statearr_29537_29563 = state_29530__$1;
(statearr_29537_29563[(2)] = null);

(statearr_29537_29563[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (6))){
var inst_29509 = (state_29530[(7)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29530__$1,(11),to,inst_29509);
} else {
if((state_val_29531 === (3))){
var inst_29528 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29530__$1,inst_29528);
} else {
if((state_val_29531 === (12))){
var state_29530__$1 = state_29530;
var statearr_29538_29564 = state_29530__$1;
(statearr_29538_29564[(2)] = null);

(statearr_29538_29564[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (2))){
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29530__$1,(4),from);
} else {
if((state_val_29531 === (11))){
var inst_29519 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
if(cljs.core.truth_(inst_29519)){
var statearr_29539_29565 = state_29530__$1;
(statearr_29539_29565[(1)] = (12));

} else {
var statearr_29540_29566 = state_29530__$1;
(statearr_29540_29566[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (9))){
var state_29530__$1 = state_29530;
var statearr_29541_29567 = state_29530__$1;
(statearr_29541_29567[(2)] = null);

(statearr_29541_29567[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (5))){
var state_29530__$1 = state_29530;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29542_29568 = state_29530__$1;
(statearr_29542_29568[(1)] = (8));

} else {
var statearr_29543_29569 = state_29530__$1;
(statearr_29543_29569[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (14))){
var inst_29524 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29544_29570 = state_29530__$1;
(statearr_29544_29570[(2)] = inst_29524);

(statearr_29544_29570[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (10))){
var inst_29516 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29545_29571 = state_29530__$1;
(statearr_29545_29571[(2)] = inst_29516);

(statearr_29545_29571[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29531 === (8))){
var inst_29513 = cljs.core.async.close_BANG_(to);
var state_29530__$1 = state_29530;
var statearr_29546_29572 = state_29530__$1;
(statearr_29546_29572[(2)] = inst_29513);

(statearr_29546_29572[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___29558))
;
return ((function (switch__11491__auto__,c__11556__auto___29558){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_29550 = [null,null,null,null,null,null,null,null];
(statearr_29550[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_29550[(1)] = (1));

return statearr_29550;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_29530){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29530);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29551){if((e29551 instanceof Object)){
var ex__11495__auto__ = e29551;
var statearr_29552_29573 = state_29530;
(statearr_29552_29573[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29530);

return cljs.core.constant$keyword$recur;
} else {
throw e29551;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29574 = state_29530;
state_29530 = G__29574;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_29530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_29530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___29558))
})();
var state__11558__auto__ = (function (){var statearr_29553 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___29558);

return statearr_29553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___29558))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__29758){
var vec__29759 = p__29758;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29759,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29759,(1),null);
var job = vec__29759;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__11556__auto___29941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results){
return (function (state_29764){
var state_val_29765 = (state_29764[(1)]);
if((state_val_29765 === (1))){
var state_29764__$1 = state_29764;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29764__$1,(2),res,v);
} else {
if((state_val_29765 === (2))){
var inst_29761 = (state_29764[(2)]);
var inst_29762 = cljs.core.async.close_BANG_(res);
var state_29764__$1 = (function (){var statearr_29766 = state_29764;
(statearr_29766[(7)] = inst_29761);

return statearr_29766;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29764__$1,inst_29762);
} else {
return null;
}
}
});})(c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results))
;
return ((function (switch__11491__auto__,c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_29770 = [null,null,null,null,null,null,null,null];
(statearr_29770[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__);

(statearr_29770[(1)] = (1));

return statearr_29770;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1 = (function (state_29764){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29764);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29771){if((e29771 instanceof Object)){
var ex__11495__auto__ = e29771;
var statearr_29772_29942 = state_29764;
(statearr_29772_29942[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29764);

return cljs.core.constant$keyword$recur;
} else {
throw e29771;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29943 = state_29764;
state_29764 = G__29943;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = function(state_29764){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1.call(this,state_29764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results))
})();
var state__11558__auto__ = (function (){var statearr_29773 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___29941);

return statearr_29773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___29941,res,vec__29759,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29774){
var vec__29775 = p__29774;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29775,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29775,(1),null);
var job = vec__29775;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8821__auto___29944 = n;
var __29945 = (0);
while(true){
if((__29945 < n__8821__auto___29944)){
var G__29776_29946 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29776_29946) {
case "compute":
var c__11556__auto___29948 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29945,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (__29945,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function (state_29789){
var state_val_29790 = (state_29789[(1)]);
if((state_val_29790 === (1))){
var state_29789__$1 = state_29789;
var statearr_29791_29949 = state_29789__$1;
(statearr_29791_29949[(2)] = null);

(statearr_29791_29949[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (2))){
var state_29789__$1 = state_29789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29789__$1,(4),jobs);
} else {
if((state_val_29790 === (3))){
var inst_29787 = (state_29789[(2)]);
var state_29789__$1 = state_29789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29789__$1,inst_29787);
} else {
if((state_val_29790 === (4))){
var inst_29779 = (state_29789[(2)]);
var inst_29780 = process(inst_29779);
var state_29789__$1 = state_29789;
if(cljs.core.truth_(inst_29780)){
var statearr_29792_29950 = state_29789__$1;
(statearr_29792_29950[(1)] = (5));

} else {
var statearr_29793_29951 = state_29789__$1;
(statearr_29793_29951[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (5))){
var state_29789__$1 = state_29789;
var statearr_29794_29952 = state_29789__$1;
(statearr_29794_29952[(2)] = null);

(statearr_29794_29952[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (6))){
var state_29789__$1 = state_29789;
var statearr_29795_29953 = state_29789__$1;
(statearr_29795_29953[(2)] = null);

(statearr_29795_29953[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29790 === (7))){
var inst_29785 = (state_29789[(2)]);
var state_29789__$1 = state_29789;
var statearr_29796_29954 = state_29789__$1;
(statearr_29796_29954[(2)] = inst_29785);

(statearr_29796_29954[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29945,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
;
return ((function (__29945,switch__11491__auto__,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_29800 = [null,null,null,null,null,null,null];
(statearr_29800[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__);

(statearr_29800[(1)] = (1));

return statearr_29800;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1 = (function (state_29789){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29789);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29801){if((e29801 instanceof Object)){
var ex__11495__auto__ = e29801;
var statearr_29802_29955 = state_29789;
(statearr_29802_29955[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29789);

return cljs.core.constant$keyword$recur;
} else {
throw e29801;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29956 = state_29789;
state_29789 = G__29956;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = function(state_29789){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1.call(this,state_29789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__;
})()
;})(__29945,switch__11491__auto__,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
})();
var state__11558__auto__ = (function (){var statearr_29803 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___29948);

return statearr_29803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(__29945,c__11556__auto___29948,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
);


break;
case "async":
var c__11556__auto___29957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29945,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (__29945,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function (state_29816){
var state_val_29817 = (state_29816[(1)]);
if((state_val_29817 === (1))){
var state_29816__$1 = state_29816;
var statearr_29818_29958 = state_29816__$1;
(statearr_29818_29958[(2)] = null);

(statearr_29818_29958[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29817 === (2))){
var state_29816__$1 = state_29816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29816__$1,(4),jobs);
} else {
if((state_val_29817 === (3))){
var inst_29814 = (state_29816[(2)]);
var state_29816__$1 = state_29816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29816__$1,inst_29814);
} else {
if((state_val_29817 === (4))){
var inst_29806 = (state_29816[(2)]);
var inst_29807 = async(inst_29806);
var state_29816__$1 = state_29816;
if(cljs.core.truth_(inst_29807)){
var statearr_29819_29959 = state_29816__$1;
(statearr_29819_29959[(1)] = (5));

} else {
var statearr_29820_29960 = state_29816__$1;
(statearr_29820_29960[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29817 === (5))){
var state_29816__$1 = state_29816;
var statearr_29821_29961 = state_29816__$1;
(statearr_29821_29961[(2)] = null);

(statearr_29821_29961[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29817 === (6))){
var state_29816__$1 = state_29816;
var statearr_29822_29962 = state_29816__$1;
(statearr_29822_29962[(2)] = null);

(statearr_29822_29962[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29817 === (7))){
var inst_29812 = (state_29816[(2)]);
var state_29816__$1 = state_29816;
var statearr_29823_29963 = state_29816__$1;
(statearr_29823_29963[(2)] = inst_29812);

(statearr_29823_29963[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29945,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
;
return ((function (__29945,switch__11491__auto__,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_29827 = [null,null,null,null,null,null,null];
(statearr_29827[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__);

(statearr_29827[(1)] = (1));

return statearr_29827;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1 = (function (state_29816){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29816);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29828){if((e29828 instanceof Object)){
var ex__11495__auto__ = e29828;
var statearr_29829_29964 = state_29816;
(statearr_29829_29964[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29816);

return cljs.core.constant$keyword$recur;
} else {
throw e29828;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29965 = state_29816;
state_29816 = G__29965;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = function(state_29816){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1.call(this,state_29816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__;
})()
;})(__29945,switch__11491__auto__,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
})();
var state__11558__auto__ = (function (){var statearr_29830 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___29957);

return statearr_29830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(__29945,c__11556__auto___29957,G__29776_29946,n__8821__auto___29944,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29966 = (__29945 + (1));
__29945 = G__29966;
continue;
} else {
}
break;
}

var c__11556__auto___29967 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___29967,jobs,results,process,async){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___29967,jobs,results,process,async){
return (function (state_29852){
var state_val_29853 = (state_29852[(1)]);
if((state_val_29853 === (1))){
var state_29852__$1 = state_29852;
var statearr_29854_29968 = state_29852__$1;
(statearr_29854_29968[(2)] = null);

(statearr_29854_29968[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29853 === (2))){
var state_29852__$1 = state_29852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29852__$1,(4),from);
} else {
if((state_val_29853 === (3))){
var inst_29850 = (state_29852[(2)]);
var state_29852__$1 = state_29852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29852__$1,inst_29850);
} else {
if((state_val_29853 === (4))){
var inst_29833 = (state_29852[(7)]);
var inst_29833__$1 = (state_29852[(2)]);
var inst_29834 = (inst_29833__$1 == null);
var state_29852__$1 = (function (){var statearr_29855 = state_29852;
(statearr_29855[(7)] = inst_29833__$1);

return statearr_29855;
})();
if(cljs.core.truth_(inst_29834)){
var statearr_29856_29969 = state_29852__$1;
(statearr_29856_29969[(1)] = (5));

} else {
var statearr_29857_29970 = state_29852__$1;
(statearr_29857_29970[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29853 === (5))){
var inst_29836 = cljs.core.async.close_BANG_(jobs);
var state_29852__$1 = state_29852;
var statearr_29858_29971 = state_29852__$1;
(statearr_29858_29971[(2)] = inst_29836);

(statearr_29858_29971[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29853 === (6))){
var inst_29838 = (state_29852[(8)]);
var inst_29833 = (state_29852[(7)]);
var inst_29838__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29840 = [inst_29833,inst_29838__$1];
var inst_29841 = (new cljs.core.PersistentVector(null,2,(5),inst_29839,inst_29840,null));
var state_29852__$1 = (function (){var statearr_29859 = state_29852;
(statearr_29859[(8)] = inst_29838__$1);

return statearr_29859;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29852__$1,(8),jobs,inst_29841);
} else {
if((state_val_29853 === (7))){
var inst_29848 = (state_29852[(2)]);
var state_29852__$1 = state_29852;
var statearr_29860_29972 = state_29852__$1;
(statearr_29860_29972[(2)] = inst_29848);

(statearr_29860_29972[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29853 === (8))){
var inst_29838 = (state_29852[(8)]);
var inst_29843 = (state_29852[(2)]);
var state_29852__$1 = (function (){var statearr_29861 = state_29852;
(statearr_29861[(9)] = inst_29843);

return statearr_29861;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29852__$1,(9),results,inst_29838);
} else {
if((state_val_29853 === (9))){
var inst_29845 = (state_29852[(2)]);
var state_29852__$1 = (function (){var statearr_29862 = state_29852;
(statearr_29862[(10)] = inst_29845);

return statearr_29862;
})();
var statearr_29863_29973 = state_29852__$1;
(statearr_29863_29973[(2)] = null);

(statearr_29863_29973[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___29967,jobs,results,process,async))
;
return ((function (switch__11491__auto__,c__11556__auto___29967,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_29867 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29867[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__);

(statearr_29867[(1)] = (1));

return statearr_29867;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1 = (function (state_29852){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29852);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29868){if((e29868 instanceof Object)){
var ex__11495__auto__ = e29868;
var statearr_29869_29974 = state_29852;
(statearr_29869_29974[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29852);

return cljs.core.constant$keyword$recur;
} else {
throw e29868;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29975 = state_29852;
state_29852 = G__29975;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = function(state_29852){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1.call(this,state_29852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___29967,jobs,results,process,async))
})();
var state__11558__auto__ = (function (){var statearr_29870 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29870[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___29967);

return statearr_29870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___29967,jobs,results,process,async))
);


var c__11556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto__,jobs,results,process,async){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto__,jobs,results,process,async){
return (function (state_29908){
var state_val_29909 = (state_29908[(1)]);
if((state_val_29909 === (7))){
var inst_29904 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
var statearr_29910_29976 = state_29908__$1;
(statearr_29910_29976[(2)] = inst_29904);

(statearr_29910_29976[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (20))){
var state_29908__$1 = state_29908;
var statearr_29911_29977 = state_29908__$1;
(statearr_29911_29977[(2)] = null);

(statearr_29911_29977[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (1))){
var state_29908__$1 = state_29908;
var statearr_29912_29978 = state_29908__$1;
(statearr_29912_29978[(2)] = null);

(statearr_29912_29978[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (4))){
var inst_29873 = (state_29908[(7)]);
var inst_29873__$1 = (state_29908[(2)]);
var inst_29874 = (inst_29873__$1 == null);
var state_29908__$1 = (function (){var statearr_29913 = state_29908;
(statearr_29913[(7)] = inst_29873__$1);

return statearr_29913;
})();
if(cljs.core.truth_(inst_29874)){
var statearr_29914_29979 = state_29908__$1;
(statearr_29914_29979[(1)] = (5));

} else {
var statearr_29915_29980 = state_29908__$1;
(statearr_29915_29980[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (15))){
var inst_29886 = (state_29908[(8)]);
var state_29908__$1 = state_29908;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29908__$1,(18),to,inst_29886);
} else {
if((state_val_29909 === (21))){
var inst_29899 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
var statearr_29916_29981 = state_29908__$1;
(statearr_29916_29981[(2)] = inst_29899);

(statearr_29916_29981[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (13))){
var inst_29901 = (state_29908[(2)]);
var state_29908__$1 = (function (){var statearr_29917 = state_29908;
(statearr_29917[(9)] = inst_29901);

return statearr_29917;
})();
var statearr_29918_29982 = state_29908__$1;
(statearr_29918_29982[(2)] = null);

(statearr_29918_29982[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (6))){
var inst_29873 = (state_29908[(7)]);
var state_29908__$1 = state_29908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29908__$1,(11),inst_29873);
} else {
if((state_val_29909 === (17))){
var inst_29894 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
if(cljs.core.truth_(inst_29894)){
var statearr_29919_29983 = state_29908__$1;
(statearr_29919_29983[(1)] = (19));

} else {
var statearr_29920_29984 = state_29908__$1;
(statearr_29920_29984[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (3))){
var inst_29906 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29908__$1,inst_29906);
} else {
if((state_val_29909 === (12))){
var inst_29883 = (state_29908[(10)]);
var state_29908__$1 = state_29908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29908__$1,(14),inst_29883);
} else {
if((state_val_29909 === (2))){
var state_29908__$1 = state_29908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29908__$1,(4),results);
} else {
if((state_val_29909 === (19))){
var state_29908__$1 = state_29908;
var statearr_29921_29985 = state_29908__$1;
(statearr_29921_29985[(2)] = null);

(statearr_29921_29985[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (11))){
var inst_29883 = (state_29908[(2)]);
var state_29908__$1 = (function (){var statearr_29922 = state_29908;
(statearr_29922[(10)] = inst_29883);

return statearr_29922;
})();
var statearr_29923_29986 = state_29908__$1;
(statearr_29923_29986[(2)] = null);

(statearr_29923_29986[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (9))){
var state_29908__$1 = state_29908;
var statearr_29924_29987 = state_29908__$1;
(statearr_29924_29987[(2)] = null);

(statearr_29924_29987[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (5))){
var state_29908__$1 = state_29908;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29925_29988 = state_29908__$1;
(statearr_29925_29988[(1)] = (8));

} else {
var statearr_29926_29989 = state_29908__$1;
(statearr_29926_29989[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (14))){
var inst_29888 = (state_29908[(11)]);
var inst_29886 = (state_29908[(8)]);
var inst_29886__$1 = (state_29908[(2)]);
var inst_29887 = (inst_29886__$1 == null);
var inst_29888__$1 = cljs.core.not(inst_29887);
var state_29908__$1 = (function (){var statearr_29927 = state_29908;
(statearr_29927[(11)] = inst_29888__$1);

(statearr_29927[(8)] = inst_29886__$1);

return statearr_29927;
})();
if(inst_29888__$1){
var statearr_29928_29990 = state_29908__$1;
(statearr_29928_29990[(1)] = (15));

} else {
var statearr_29929_29991 = state_29908__$1;
(statearr_29929_29991[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (16))){
var inst_29888 = (state_29908[(11)]);
var state_29908__$1 = state_29908;
var statearr_29930_29992 = state_29908__$1;
(statearr_29930_29992[(2)] = inst_29888);

(statearr_29930_29992[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (10))){
var inst_29880 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
var statearr_29931_29993 = state_29908__$1;
(statearr_29931_29993[(2)] = inst_29880);

(statearr_29931_29993[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (18))){
var inst_29891 = (state_29908[(2)]);
var state_29908__$1 = state_29908;
var statearr_29932_29994 = state_29908__$1;
(statearr_29932_29994[(2)] = inst_29891);

(statearr_29932_29994[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_29909 === (8))){
var inst_29877 = cljs.core.async.close_BANG_(to);
var state_29908__$1 = state_29908;
var statearr_29933_29995 = state_29908__$1;
(statearr_29933_29995[(2)] = inst_29877);

(statearr_29933_29995[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto__,jobs,results,process,async))
;
return ((function (switch__11491__auto__,c__11556__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_29937 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29937[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__);

(statearr_29937[(1)] = (1));

return statearr_29937;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1 = (function (state_29908){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_29908);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e29938){if((e29938 instanceof Object)){
var ex__11495__auto__ = e29938;
var statearr_29939_29996 = state_29908;
(statearr_29939_29996[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29908);

return cljs.core.constant$keyword$recur;
} else {
throw e29938;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__29997 = state_29908;
state_29908 = G__29997;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__ = function(state_29908){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1.call(this,state_29908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto__,jobs,results,process,async))
})();
var state__11558__auto__ = (function (){var statearr_29940 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_29940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto__);

return statearr_29940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto__,jobs,results,process,async))
);

return c__11556__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var args29998 = [];
var len__8976__auto___30001 = arguments.length;
var i__8977__auto___30002 = (0);
while(true){
if((i__8977__auto___30002 < len__8976__auto___30001)){
args29998.push((arguments[i__8977__auto___30002]));

var G__30003 = (i__8977__auto___30002 + (1));
i__8977__auto___30002 = G__30003;
continue;
} else {
}
break;
}

var G__30000 = args29998.length;
switch (G__30000) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29998.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var args30005 = [];
var len__8976__auto___30008 = arguments.length;
var i__8977__auto___30009 = (0);
while(true){
if((i__8977__auto___30009 < len__8976__auto___30008)){
args30005.push((arguments[i__8977__auto___30009]));

var G__30010 = (i__8977__auto___30009 + (1));
i__8977__auto___30009 = G__30010;
continue;
} else {
}
break;
}

var G__30007 = args30005.length;
switch (G__30007) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30005.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var args30012 = [];
var len__8976__auto___30065 = arguments.length;
var i__8977__auto___30066 = (0);
while(true){
if((i__8977__auto___30066 < len__8976__auto___30065)){
args30012.push((arguments[i__8977__auto___30066]));

var G__30067 = (i__8977__auto___30066 + (1));
i__8977__auto___30066 = G__30067;
continue;
} else {
}
break;
}

var G__30014 = args30012.length;
switch (G__30014) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30012.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__11556__auto___30069 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___30069,tc,fc){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___30069,tc,fc){
return (function (state_30040){
var state_val_30041 = (state_30040[(1)]);
if((state_val_30041 === (7))){
var inst_30036 = (state_30040[(2)]);
var state_30040__$1 = state_30040;
var statearr_30042_30070 = state_30040__$1;
(statearr_30042_30070[(2)] = inst_30036);

(statearr_30042_30070[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (1))){
var state_30040__$1 = state_30040;
var statearr_30043_30071 = state_30040__$1;
(statearr_30043_30071[(2)] = null);

(statearr_30043_30071[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (4))){
var inst_30017 = (state_30040[(7)]);
var inst_30017__$1 = (state_30040[(2)]);
var inst_30018 = (inst_30017__$1 == null);
var state_30040__$1 = (function (){var statearr_30044 = state_30040;
(statearr_30044[(7)] = inst_30017__$1);

return statearr_30044;
})();
if(cljs.core.truth_(inst_30018)){
var statearr_30045_30072 = state_30040__$1;
(statearr_30045_30072[(1)] = (5));

} else {
var statearr_30046_30073 = state_30040__$1;
(statearr_30046_30073[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (13))){
var state_30040__$1 = state_30040;
var statearr_30047_30074 = state_30040__$1;
(statearr_30047_30074[(2)] = null);

(statearr_30047_30074[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (6))){
var inst_30017 = (state_30040[(7)]);
var inst_30023 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30017) : p.call(null,inst_30017));
var state_30040__$1 = state_30040;
if(cljs.core.truth_(inst_30023)){
var statearr_30048_30075 = state_30040__$1;
(statearr_30048_30075[(1)] = (9));

} else {
var statearr_30049_30076 = state_30040__$1;
(statearr_30049_30076[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (3))){
var inst_30038 = (state_30040[(2)]);
var state_30040__$1 = state_30040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30040__$1,inst_30038);
} else {
if((state_val_30041 === (12))){
var state_30040__$1 = state_30040;
var statearr_30050_30077 = state_30040__$1;
(statearr_30050_30077[(2)] = null);

(statearr_30050_30077[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (2))){
var state_30040__$1 = state_30040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30040__$1,(4),ch);
} else {
if((state_val_30041 === (11))){
var inst_30017 = (state_30040[(7)]);
var inst_30027 = (state_30040[(2)]);
var state_30040__$1 = state_30040;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30040__$1,(8),inst_30027,inst_30017);
} else {
if((state_val_30041 === (9))){
var state_30040__$1 = state_30040;
var statearr_30051_30078 = state_30040__$1;
(statearr_30051_30078[(2)] = tc);

(statearr_30051_30078[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (5))){
var inst_30020 = cljs.core.async.close_BANG_(tc);
var inst_30021 = cljs.core.async.close_BANG_(fc);
var state_30040__$1 = (function (){var statearr_30052 = state_30040;
(statearr_30052[(8)] = inst_30020);

return statearr_30052;
})();
var statearr_30053_30079 = state_30040__$1;
(statearr_30053_30079[(2)] = inst_30021);

(statearr_30053_30079[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (14))){
var inst_30034 = (state_30040[(2)]);
var state_30040__$1 = state_30040;
var statearr_30054_30080 = state_30040__$1;
(statearr_30054_30080[(2)] = inst_30034);

(statearr_30054_30080[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (10))){
var state_30040__$1 = state_30040;
var statearr_30055_30081 = state_30040__$1;
(statearr_30055_30081[(2)] = fc);

(statearr_30055_30081[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30041 === (8))){
var inst_30029 = (state_30040[(2)]);
var state_30040__$1 = state_30040;
if(cljs.core.truth_(inst_30029)){
var statearr_30056_30082 = state_30040__$1;
(statearr_30056_30082[(1)] = (12));

} else {
var statearr_30057_30083 = state_30040__$1;
(statearr_30057_30083[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___30069,tc,fc))
;
return ((function (switch__11491__auto__,c__11556__auto___30069,tc,fc){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_30061 = [null,null,null,null,null,null,null,null,null];
(statearr_30061[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_30061[(1)] = (1));

return statearr_30061;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_30040){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_30040);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e30062){if((e30062 instanceof Object)){
var ex__11495__auto__ = e30062;
var statearr_30063_30084 = state_30040;
(statearr_30063_30084[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30040);

return cljs.core.constant$keyword$recur;
} else {
throw e30062;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__30085 = state_30040;
state_30040 = G__30085;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_30040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_30040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___30069,tc,fc))
})();
var state__11558__auto__ = (function (){var statearr_30064 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_30064[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___30069);

return statearr_30064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___30069,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto__){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto__){
return (function (state_30132){
var state_val_30133 = (state_30132[(1)]);
if((state_val_30133 === (1))){
var inst_30118 = init;
var state_30132__$1 = (function (){var statearr_30134 = state_30132;
(statearr_30134[(7)] = inst_30118);

return statearr_30134;
})();
var statearr_30135_30150 = state_30132__$1;
(statearr_30135_30150[(2)] = null);

(statearr_30135_30150[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30133 === (2))){
var state_30132__$1 = state_30132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30132__$1,(4),ch);
} else {
if((state_val_30133 === (3))){
var inst_30130 = (state_30132[(2)]);
var state_30132__$1 = state_30132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30132__$1,inst_30130);
} else {
if((state_val_30133 === (4))){
var inst_30121 = (state_30132[(8)]);
var inst_30121__$1 = (state_30132[(2)]);
var inst_30122 = (inst_30121__$1 == null);
var state_30132__$1 = (function (){var statearr_30136 = state_30132;
(statearr_30136[(8)] = inst_30121__$1);

return statearr_30136;
})();
if(cljs.core.truth_(inst_30122)){
var statearr_30137_30151 = state_30132__$1;
(statearr_30137_30151[(1)] = (5));

} else {
var statearr_30138_30152 = state_30132__$1;
(statearr_30138_30152[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30133 === (5))){
var inst_30118 = (state_30132[(7)]);
var state_30132__$1 = state_30132;
var statearr_30139_30153 = state_30132__$1;
(statearr_30139_30153[(2)] = inst_30118);

(statearr_30139_30153[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30133 === (6))){
var inst_30121 = (state_30132[(8)]);
var inst_30118 = (state_30132[(7)]);
var inst_30125 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30118,inst_30121) : f.call(null,inst_30118,inst_30121));
var inst_30118__$1 = inst_30125;
var state_30132__$1 = (function (){var statearr_30140 = state_30132;
(statearr_30140[(7)] = inst_30118__$1);

return statearr_30140;
})();
var statearr_30141_30154 = state_30132__$1;
(statearr_30141_30154[(2)] = null);

(statearr_30141_30154[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30133 === (7))){
var inst_30128 = (state_30132[(2)]);
var state_30132__$1 = state_30132;
var statearr_30142_30155 = state_30132__$1;
(statearr_30142_30155[(2)] = inst_30128);

(statearr_30142_30155[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__11556__auto__))
;
return ((function (switch__11491__auto__,c__11556__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11492__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11492__auto____0 = (function (){
var statearr_30146 = [null,null,null,null,null,null,null,null,null];
(statearr_30146[(0)] = cljs$core$async$reduce_$_state_machine__11492__auto__);

(statearr_30146[(1)] = (1));

return statearr_30146;
});
var cljs$core$async$reduce_$_state_machine__11492__auto____1 = (function (state_30132){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_30132);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e30147){if((e30147 instanceof Object)){
var ex__11495__auto__ = e30147;
var statearr_30148_30156 = state_30132;
(statearr_30148_30156[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30132);

return cljs.core.constant$keyword$recur;
} else {
throw e30147;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__30157 = state_30132;
state_30132 = G__30157;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11492__auto__ = function(state_30132){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11492__auto____1.call(this,state_30132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11492__auto____0;
cljs$core$async$reduce_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11492__auto____1;
return cljs$core$async$reduce_$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto__))
})();
var state__11558__auto__ = (function (){var statearr_30149 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_30149[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto__);

return statearr_30149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto__))
);

return c__11556__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var args30158 = [];
var len__8976__auto___30210 = arguments.length;
var i__8977__auto___30211 = (0);
while(true){
if((i__8977__auto___30211 < len__8976__auto___30210)){
args30158.push((arguments[i__8977__auto___30211]));

var G__30212 = (i__8977__auto___30211 + (1));
i__8977__auto___30211 = G__30212;
continue;
} else {
}
break;
}

var G__30160 = args30158.length;
switch (G__30160) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30158.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto__){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto__){
return (function (state_30185){
var state_val_30186 = (state_30185[(1)]);
if((state_val_30186 === (7))){
var inst_30167 = (state_30185[(2)]);
var state_30185__$1 = state_30185;
var statearr_30187_30214 = state_30185__$1;
(statearr_30187_30214[(2)] = inst_30167);

(statearr_30187_30214[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (1))){
var inst_30161 = cljs.core.seq(coll);
var inst_30162 = inst_30161;
var state_30185__$1 = (function (){var statearr_30188 = state_30185;
(statearr_30188[(7)] = inst_30162);

return statearr_30188;
})();
var statearr_30189_30215 = state_30185__$1;
(statearr_30189_30215[(2)] = null);

(statearr_30189_30215[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (4))){
var inst_30162 = (state_30185[(7)]);
var inst_30165 = cljs.core.first(inst_30162);
var state_30185__$1 = state_30185;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30185__$1,(7),ch,inst_30165);
} else {
if((state_val_30186 === (13))){
var inst_30179 = (state_30185[(2)]);
var state_30185__$1 = state_30185;
var statearr_30190_30216 = state_30185__$1;
(statearr_30190_30216[(2)] = inst_30179);

(statearr_30190_30216[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (6))){
var inst_30170 = (state_30185[(2)]);
var state_30185__$1 = state_30185;
if(cljs.core.truth_(inst_30170)){
var statearr_30191_30217 = state_30185__$1;
(statearr_30191_30217[(1)] = (8));

} else {
var statearr_30192_30218 = state_30185__$1;
(statearr_30192_30218[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (3))){
var inst_30183 = (state_30185[(2)]);
var state_30185__$1 = state_30185;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30185__$1,inst_30183);
} else {
if((state_val_30186 === (12))){
var state_30185__$1 = state_30185;
var statearr_30193_30219 = state_30185__$1;
(statearr_30193_30219[(2)] = null);

(statearr_30193_30219[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (2))){
var inst_30162 = (state_30185[(7)]);
var state_30185__$1 = state_30185;
if(cljs.core.truth_(inst_30162)){
var statearr_30194_30220 = state_30185__$1;
(statearr_30194_30220[(1)] = (4));

} else {
var statearr_30195_30221 = state_30185__$1;
(statearr_30195_30221[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (11))){
var inst_30176 = cljs.core.async.close_BANG_(ch);
var state_30185__$1 = state_30185;
var statearr_30196_30222 = state_30185__$1;
(statearr_30196_30222[(2)] = inst_30176);

(statearr_30196_30222[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (9))){
var state_30185__$1 = state_30185;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30197_30223 = state_30185__$1;
(statearr_30197_30223[(1)] = (11));

} else {
var statearr_30198_30224 = state_30185__$1;
(statearr_30198_30224[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (5))){
var inst_30162 = (state_30185[(7)]);
var state_30185__$1 = state_30185;
var statearr_30199_30225 = state_30185__$1;
(statearr_30199_30225[(2)] = inst_30162);

(statearr_30199_30225[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (10))){
var inst_30181 = (state_30185[(2)]);
var state_30185__$1 = state_30185;
var statearr_30200_30226 = state_30185__$1;
(statearr_30200_30226[(2)] = inst_30181);

(statearr_30200_30226[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30186 === (8))){
var inst_30162 = (state_30185[(7)]);
var inst_30172 = cljs.core.next(inst_30162);
var inst_30162__$1 = inst_30172;
var state_30185__$1 = (function (){var statearr_30201 = state_30185;
(statearr_30201[(7)] = inst_30162__$1);

return statearr_30201;
})();
var statearr_30202_30227 = state_30185__$1;
(statearr_30202_30227[(2)] = null);

(statearr_30202_30227[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto__))
;
return ((function (switch__11491__auto__,c__11556__auto__){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_30206 = [null,null,null,null,null,null,null,null];
(statearr_30206[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_30206[(1)] = (1));

return statearr_30206;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_30185){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_30185);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e30207){if((e30207 instanceof Object)){
var ex__11495__auto__ = e30207;
var statearr_30208_30228 = state_30185;
(statearr_30208_30228[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30185);

return cljs.core.constant$keyword$recur;
} else {
throw e30207;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__30229 = state_30185;
state_30185 = G__30229;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_30185){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_30185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto__))
})();
var state__11558__auto__ = (function (){var statearr_30209 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_30209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto__);

return statearr_30209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto__))
);

return c__11556__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = {};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8573__auto__ = (((_ == null))?null:_);
var m__8574__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto__.call(null,_));
} else {
var m__8574__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__8574__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


cljs.core.async.Mult = {};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__8574__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__30458 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30458) : cljs.core.atom.call(null,G__30458));
})();
var m = (function (){
if(typeof cljs.core.async.t30459 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30459 = (function (mult,ch,cs,meta30460){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30460 = meta30460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30461,meta30460__$1){
var self__ = this;
var _30461__$1 = this;
return (new cljs.core.async.t30459(self__.mult,self__.ch,self__.cs,meta30460__$1));
});})(cs))
;

cljs.core.async.t30459.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30461){
var self__ = this;
var _30461__$1 = this;
return self__.meta30460;
});})(cs))
;

cljs.core.async.t30459.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30459.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t30459.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t30459.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t30459.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t30459.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30462_30682 = self__.cs;
var G__30463_30683 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30462_30682,G__30463_30683) : cljs.core.reset_BANG_.call(null,G__30462_30682,G__30463_30683));

return null;
});})(cs))
;

cljs.core.async.t30459.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30460","meta30460",-1903964414,null)], null);
});})(cs))
;

cljs.core.async.t30459.cljs$lang$type = true;

cljs.core.async.t30459.cljs$lang$ctorStr = "cljs.core.async/t30459";

cljs.core.async.t30459.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30459");
});})(cs))
;

cljs.core.async.__GT_t30459 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t30459(mult__$1,ch__$1,cs__$1,meta30460){
return (new cljs.core.async.t30459(mult__$1,ch__$1,cs__$1,meta30460));
});})(cs))
;

}

return (new cljs.core.async.t30459(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11556__auto___30684 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___30684,cs,m,dchan,dctr,done){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___30684,cs,m,dchan,dctr,done){
return (function (state_30594){
var state_val_30595 = (state_30594[(1)]);
if((state_val_30595 === (7))){
var inst_30590 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30596_30685 = state_30594__$1;
(statearr_30596_30685[(2)] = inst_30590);

(statearr_30596_30685[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (20))){
var inst_30495 = (state_30594[(7)]);
var inst_30505 = cljs.core.first(inst_30495);
var inst_30506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30505,(0),null);
var inst_30507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30505,(1),null);
var state_30594__$1 = (function (){var statearr_30597 = state_30594;
(statearr_30597[(8)] = inst_30506);

return statearr_30597;
})();
if(cljs.core.truth_(inst_30507)){
var statearr_30598_30686 = state_30594__$1;
(statearr_30598_30686[(1)] = (22));

} else {
var statearr_30599_30687 = state_30594__$1;
(statearr_30599_30687[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (27))){
var inst_30535 = (state_30594[(9)]);
var inst_30537 = (state_30594[(10)]);
var inst_30542 = (state_30594[(11)]);
var inst_30466 = (state_30594[(12)]);
var inst_30542__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30535,inst_30537);
var inst_30543 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30542__$1,inst_30466,done);
var state_30594__$1 = (function (){var statearr_30600 = state_30594;
(statearr_30600[(11)] = inst_30542__$1);

return statearr_30600;
})();
if(cljs.core.truth_(inst_30543)){
var statearr_30601_30688 = state_30594__$1;
(statearr_30601_30688[(1)] = (30));

} else {
var statearr_30602_30689 = state_30594__$1;
(statearr_30602_30689[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (1))){
var state_30594__$1 = state_30594;
var statearr_30603_30690 = state_30594__$1;
(statearr_30603_30690[(2)] = null);

(statearr_30603_30690[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (24))){
var inst_30495 = (state_30594[(7)]);
var inst_30512 = (state_30594[(2)]);
var inst_30513 = cljs.core.next(inst_30495);
var inst_30475 = inst_30513;
var inst_30476 = null;
var inst_30477 = (0);
var inst_30478 = (0);
var state_30594__$1 = (function (){var statearr_30604 = state_30594;
(statearr_30604[(13)] = inst_30478);

(statearr_30604[(14)] = inst_30476);

(statearr_30604[(15)] = inst_30475);

(statearr_30604[(16)] = inst_30477);

(statearr_30604[(17)] = inst_30512);

return statearr_30604;
})();
var statearr_30605_30691 = state_30594__$1;
(statearr_30605_30691[(2)] = null);

(statearr_30605_30691[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (39))){
var state_30594__$1 = state_30594;
var statearr_30609_30692 = state_30594__$1;
(statearr_30609_30692[(2)] = null);

(statearr_30609_30692[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (4))){
var inst_30466 = (state_30594[(12)]);
var inst_30466__$1 = (state_30594[(2)]);
var inst_30467 = (inst_30466__$1 == null);
var state_30594__$1 = (function (){var statearr_30610 = state_30594;
(statearr_30610[(12)] = inst_30466__$1);

return statearr_30610;
})();
if(cljs.core.truth_(inst_30467)){
var statearr_30611_30693 = state_30594__$1;
(statearr_30611_30693[(1)] = (5));

} else {
var statearr_30612_30694 = state_30594__$1;
(statearr_30612_30694[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (15))){
var inst_30478 = (state_30594[(13)]);
var inst_30476 = (state_30594[(14)]);
var inst_30475 = (state_30594[(15)]);
var inst_30477 = (state_30594[(16)]);
var inst_30491 = (state_30594[(2)]);
var inst_30492 = (inst_30478 + (1));
var tmp30606 = inst_30476;
var tmp30607 = inst_30475;
var tmp30608 = inst_30477;
var inst_30475__$1 = tmp30607;
var inst_30476__$1 = tmp30606;
var inst_30477__$1 = tmp30608;
var inst_30478__$1 = inst_30492;
var state_30594__$1 = (function (){var statearr_30613 = state_30594;
(statearr_30613[(13)] = inst_30478__$1);

(statearr_30613[(14)] = inst_30476__$1);

(statearr_30613[(15)] = inst_30475__$1);

(statearr_30613[(18)] = inst_30491);

(statearr_30613[(16)] = inst_30477__$1);

return statearr_30613;
})();
var statearr_30614_30695 = state_30594__$1;
(statearr_30614_30695[(2)] = null);

(statearr_30614_30695[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (21))){
var inst_30516 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30618_30696 = state_30594__$1;
(statearr_30618_30696[(2)] = inst_30516);

(statearr_30618_30696[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (31))){
var inst_30542 = (state_30594[(11)]);
var inst_30546 = done(null);
var inst_30547 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30542);
var state_30594__$1 = (function (){var statearr_30619 = state_30594;
(statearr_30619[(19)] = inst_30546);

return statearr_30619;
})();
var statearr_30620_30697 = state_30594__$1;
(statearr_30620_30697[(2)] = inst_30547);

(statearr_30620_30697[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (32))){
var inst_30535 = (state_30594[(9)]);
var inst_30537 = (state_30594[(10)]);
var inst_30534 = (state_30594[(20)]);
var inst_30536 = (state_30594[(21)]);
var inst_30549 = (state_30594[(2)]);
var inst_30550 = (inst_30537 + (1));
var tmp30615 = inst_30535;
var tmp30616 = inst_30534;
var tmp30617 = inst_30536;
var inst_30534__$1 = tmp30616;
var inst_30535__$1 = tmp30615;
var inst_30536__$1 = tmp30617;
var inst_30537__$1 = inst_30550;
var state_30594__$1 = (function (){var statearr_30621 = state_30594;
(statearr_30621[(9)] = inst_30535__$1);

(statearr_30621[(10)] = inst_30537__$1);

(statearr_30621[(20)] = inst_30534__$1);

(statearr_30621[(21)] = inst_30536__$1);

(statearr_30621[(22)] = inst_30549);

return statearr_30621;
})();
var statearr_30622_30698 = state_30594__$1;
(statearr_30622_30698[(2)] = null);

(statearr_30622_30698[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (40))){
var inst_30562 = (state_30594[(23)]);
var inst_30566 = done(null);
var inst_30567 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_30562);
var state_30594__$1 = (function (){var statearr_30623 = state_30594;
(statearr_30623[(24)] = inst_30566);

return statearr_30623;
})();
var statearr_30624_30699 = state_30594__$1;
(statearr_30624_30699[(2)] = inst_30567);

(statearr_30624_30699[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (33))){
var inst_30553 = (state_30594[(25)]);
var inst_30555 = cljs.core.chunked_seq_QMARK_(inst_30553);
var state_30594__$1 = state_30594;
if(inst_30555){
var statearr_30625_30700 = state_30594__$1;
(statearr_30625_30700[(1)] = (36));

} else {
var statearr_30626_30701 = state_30594__$1;
(statearr_30626_30701[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (13))){
var inst_30485 = (state_30594[(26)]);
var inst_30488 = cljs.core.async.close_BANG_(inst_30485);
var state_30594__$1 = state_30594;
var statearr_30627_30702 = state_30594__$1;
(statearr_30627_30702[(2)] = inst_30488);

(statearr_30627_30702[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (22))){
var inst_30506 = (state_30594[(8)]);
var inst_30509 = cljs.core.async.close_BANG_(inst_30506);
var state_30594__$1 = state_30594;
var statearr_30628_30703 = state_30594__$1;
(statearr_30628_30703[(2)] = inst_30509);

(statearr_30628_30703[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (36))){
var inst_30553 = (state_30594[(25)]);
var inst_30557 = cljs.core.chunk_first(inst_30553);
var inst_30558 = cljs.core.chunk_rest(inst_30553);
var inst_30559 = cljs.core.count(inst_30557);
var inst_30534 = inst_30558;
var inst_30535 = inst_30557;
var inst_30536 = inst_30559;
var inst_30537 = (0);
var state_30594__$1 = (function (){var statearr_30629 = state_30594;
(statearr_30629[(9)] = inst_30535);

(statearr_30629[(10)] = inst_30537);

(statearr_30629[(20)] = inst_30534);

(statearr_30629[(21)] = inst_30536);

return statearr_30629;
})();
var statearr_30630_30704 = state_30594__$1;
(statearr_30630_30704[(2)] = null);

(statearr_30630_30704[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (41))){
var inst_30553 = (state_30594[(25)]);
var inst_30569 = (state_30594[(2)]);
var inst_30570 = cljs.core.next(inst_30553);
var inst_30534 = inst_30570;
var inst_30535 = null;
var inst_30536 = (0);
var inst_30537 = (0);
var state_30594__$1 = (function (){var statearr_30631 = state_30594;
(statearr_30631[(9)] = inst_30535);

(statearr_30631[(10)] = inst_30537);

(statearr_30631[(20)] = inst_30534);

(statearr_30631[(27)] = inst_30569);

(statearr_30631[(21)] = inst_30536);

return statearr_30631;
})();
var statearr_30632_30705 = state_30594__$1;
(statearr_30632_30705[(2)] = null);

(statearr_30632_30705[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (43))){
var state_30594__$1 = state_30594;
var statearr_30633_30706 = state_30594__$1;
(statearr_30633_30706[(2)] = null);

(statearr_30633_30706[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (29))){
var inst_30578 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30634_30707 = state_30594__$1;
(statearr_30634_30707[(2)] = inst_30578);

(statearr_30634_30707[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (44))){
var inst_30587 = (state_30594[(2)]);
var state_30594__$1 = (function (){var statearr_30635 = state_30594;
(statearr_30635[(28)] = inst_30587);

return statearr_30635;
})();
var statearr_30636_30708 = state_30594__$1;
(statearr_30636_30708[(2)] = null);

(statearr_30636_30708[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (6))){
var inst_30526 = (state_30594[(29)]);
var inst_30525 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30526__$1 = cljs.core.keys(inst_30525);
var inst_30527 = cljs.core.count(inst_30526__$1);
var inst_30528 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_30527) : cljs.core.reset_BANG_.call(null,dctr,inst_30527));
var inst_30533 = cljs.core.seq(inst_30526__$1);
var inst_30534 = inst_30533;
var inst_30535 = null;
var inst_30536 = (0);
var inst_30537 = (0);
var state_30594__$1 = (function (){var statearr_30637 = state_30594;
(statearr_30637[(9)] = inst_30535);

(statearr_30637[(10)] = inst_30537);

(statearr_30637[(30)] = inst_30528);

(statearr_30637[(20)] = inst_30534);

(statearr_30637[(29)] = inst_30526__$1);

(statearr_30637[(21)] = inst_30536);

return statearr_30637;
})();
var statearr_30638_30709 = state_30594__$1;
(statearr_30638_30709[(2)] = null);

(statearr_30638_30709[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (28))){
var inst_30534 = (state_30594[(20)]);
var inst_30553 = (state_30594[(25)]);
var inst_30553__$1 = cljs.core.seq(inst_30534);
var state_30594__$1 = (function (){var statearr_30639 = state_30594;
(statearr_30639[(25)] = inst_30553__$1);

return statearr_30639;
})();
if(inst_30553__$1){
var statearr_30640_30710 = state_30594__$1;
(statearr_30640_30710[(1)] = (33));

} else {
var statearr_30641_30711 = state_30594__$1;
(statearr_30641_30711[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (25))){
var inst_30537 = (state_30594[(10)]);
var inst_30536 = (state_30594[(21)]);
var inst_30539 = (inst_30537 < inst_30536);
var inst_30540 = inst_30539;
var state_30594__$1 = state_30594;
if(cljs.core.truth_(inst_30540)){
var statearr_30642_30712 = state_30594__$1;
(statearr_30642_30712[(1)] = (27));

} else {
var statearr_30643_30713 = state_30594__$1;
(statearr_30643_30713[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (34))){
var state_30594__$1 = state_30594;
var statearr_30644_30714 = state_30594__$1;
(statearr_30644_30714[(2)] = null);

(statearr_30644_30714[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (17))){
var state_30594__$1 = state_30594;
var statearr_30645_30715 = state_30594__$1;
(statearr_30645_30715[(2)] = null);

(statearr_30645_30715[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (3))){
var inst_30592 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30594__$1,inst_30592);
} else {
if((state_val_30595 === (12))){
var inst_30521 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30646_30716 = state_30594__$1;
(statearr_30646_30716[(2)] = inst_30521);

(statearr_30646_30716[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (2))){
var state_30594__$1 = state_30594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30594__$1,(4),ch);
} else {
if((state_val_30595 === (23))){
var state_30594__$1 = state_30594;
var statearr_30647_30717 = state_30594__$1;
(statearr_30647_30717[(2)] = null);

(statearr_30647_30717[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (35))){
var inst_30576 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30648_30718 = state_30594__$1;
(statearr_30648_30718[(2)] = inst_30576);

(statearr_30648_30718[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (19))){
var inst_30495 = (state_30594[(7)]);
var inst_30499 = cljs.core.chunk_first(inst_30495);
var inst_30500 = cljs.core.chunk_rest(inst_30495);
var inst_30501 = cljs.core.count(inst_30499);
var inst_30475 = inst_30500;
var inst_30476 = inst_30499;
var inst_30477 = inst_30501;
var inst_30478 = (0);
var state_30594__$1 = (function (){var statearr_30649 = state_30594;
(statearr_30649[(13)] = inst_30478);

(statearr_30649[(14)] = inst_30476);

(statearr_30649[(15)] = inst_30475);

(statearr_30649[(16)] = inst_30477);

return statearr_30649;
})();
var statearr_30650_30719 = state_30594__$1;
(statearr_30650_30719[(2)] = null);

(statearr_30650_30719[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (11))){
var inst_30475 = (state_30594[(15)]);
var inst_30495 = (state_30594[(7)]);
var inst_30495__$1 = cljs.core.seq(inst_30475);
var state_30594__$1 = (function (){var statearr_30651 = state_30594;
(statearr_30651[(7)] = inst_30495__$1);

return statearr_30651;
})();
if(inst_30495__$1){
var statearr_30652_30720 = state_30594__$1;
(statearr_30652_30720[(1)] = (16));

} else {
var statearr_30653_30721 = state_30594__$1;
(statearr_30653_30721[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (9))){
var inst_30523 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30654_30722 = state_30594__$1;
(statearr_30654_30722[(2)] = inst_30523);

(statearr_30654_30722[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (5))){
var inst_30473 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_30474 = cljs.core.seq(inst_30473);
var inst_30475 = inst_30474;
var inst_30476 = null;
var inst_30477 = (0);
var inst_30478 = (0);
var state_30594__$1 = (function (){var statearr_30655 = state_30594;
(statearr_30655[(13)] = inst_30478);

(statearr_30655[(14)] = inst_30476);

(statearr_30655[(15)] = inst_30475);

(statearr_30655[(16)] = inst_30477);

return statearr_30655;
})();
var statearr_30656_30723 = state_30594__$1;
(statearr_30656_30723[(2)] = null);

(statearr_30656_30723[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (14))){
var state_30594__$1 = state_30594;
var statearr_30657_30724 = state_30594__$1;
(statearr_30657_30724[(2)] = null);

(statearr_30657_30724[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (45))){
var inst_30584 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30658_30725 = state_30594__$1;
(statearr_30658_30725[(2)] = inst_30584);

(statearr_30658_30725[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (26))){
var inst_30526 = (state_30594[(29)]);
var inst_30580 = (state_30594[(2)]);
var inst_30581 = cljs.core.seq(inst_30526);
var state_30594__$1 = (function (){var statearr_30659 = state_30594;
(statearr_30659[(31)] = inst_30580);

return statearr_30659;
})();
if(inst_30581){
var statearr_30660_30726 = state_30594__$1;
(statearr_30660_30726[(1)] = (42));

} else {
var statearr_30661_30727 = state_30594__$1;
(statearr_30661_30727[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (16))){
var inst_30495 = (state_30594[(7)]);
var inst_30497 = cljs.core.chunked_seq_QMARK_(inst_30495);
var state_30594__$1 = state_30594;
if(inst_30497){
var statearr_30662_30728 = state_30594__$1;
(statearr_30662_30728[(1)] = (19));

} else {
var statearr_30663_30729 = state_30594__$1;
(statearr_30663_30729[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (38))){
var inst_30573 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30664_30730 = state_30594__$1;
(statearr_30664_30730[(2)] = inst_30573);

(statearr_30664_30730[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (30))){
var state_30594__$1 = state_30594;
var statearr_30665_30731 = state_30594__$1;
(statearr_30665_30731[(2)] = null);

(statearr_30665_30731[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (10))){
var inst_30478 = (state_30594[(13)]);
var inst_30476 = (state_30594[(14)]);
var inst_30484 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30476,inst_30478);
var inst_30485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30484,(0),null);
var inst_30486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30484,(1),null);
var state_30594__$1 = (function (){var statearr_30666 = state_30594;
(statearr_30666[(26)] = inst_30485);

return statearr_30666;
})();
if(cljs.core.truth_(inst_30486)){
var statearr_30667_30732 = state_30594__$1;
(statearr_30667_30732[(1)] = (13));

} else {
var statearr_30668_30733 = state_30594__$1;
(statearr_30668_30733[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (18))){
var inst_30519 = (state_30594[(2)]);
var state_30594__$1 = state_30594;
var statearr_30669_30734 = state_30594__$1;
(statearr_30669_30734[(2)] = inst_30519);

(statearr_30669_30734[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (42))){
var state_30594__$1 = state_30594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30594__$1,(45),dchan);
} else {
if((state_val_30595 === (37))){
var inst_30562 = (state_30594[(23)]);
var inst_30553 = (state_30594[(25)]);
var inst_30466 = (state_30594[(12)]);
var inst_30562__$1 = cljs.core.first(inst_30553);
var inst_30563 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_30562__$1,inst_30466,done);
var state_30594__$1 = (function (){var statearr_30670 = state_30594;
(statearr_30670[(23)] = inst_30562__$1);

return statearr_30670;
})();
if(cljs.core.truth_(inst_30563)){
var statearr_30671_30735 = state_30594__$1;
(statearr_30671_30735[(1)] = (39));

} else {
var statearr_30672_30736 = state_30594__$1;
(statearr_30672_30736[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30595 === (8))){
var inst_30478 = (state_30594[(13)]);
var inst_30477 = (state_30594[(16)]);
var inst_30480 = (inst_30478 < inst_30477);
var inst_30481 = inst_30480;
var state_30594__$1 = state_30594;
if(cljs.core.truth_(inst_30481)){
var statearr_30673_30737 = state_30594__$1;
(statearr_30673_30737[(1)] = (10));

} else {
var statearr_30674_30738 = state_30594__$1;
(statearr_30674_30738[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___30684,cs,m,dchan,dctr,done))
;
return ((function (switch__11491__auto__,c__11556__auto___30684,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11492__auto__ = null;
var cljs$core$async$mult_$_state_machine__11492__auto____0 = (function (){
var statearr_30678 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30678[(0)] = cljs$core$async$mult_$_state_machine__11492__auto__);

(statearr_30678[(1)] = (1));

return statearr_30678;
});
var cljs$core$async$mult_$_state_machine__11492__auto____1 = (function (state_30594){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_30594);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e30679){if((e30679 instanceof Object)){
var ex__11495__auto__ = e30679;
var statearr_30680_30739 = state_30594;
(statearr_30680_30739[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30594);

return cljs.core.constant$keyword$recur;
} else {
throw e30679;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__30740 = state_30594;
state_30594 = G__30740;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11492__auto__ = function(state_30594){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11492__auto____1.call(this,state_30594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11492__auto____0;
cljs$core$async$mult_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11492__auto____1;
return cljs$core$async$mult_$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___30684,cs,m,dchan,dctr,done))
})();
var state__11558__auto__ = (function (){var statearr_30681 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_30681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___30684);

return statearr_30681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___30684,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var args30741 = [];
var len__8976__auto___30744 = arguments.length;
var i__8977__auto___30745 = (0);
while(true){
if((i__8977__auto___30745 < len__8976__auto___30744)){
args30741.push((arguments[i__8977__auto___30745]));

var G__30746 = (i__8977__auto___30745 + (1));
i__8977__auto___30745 = G__30746;
continue;
} else {
}
break;
}

var G__30743 = args30741.length;
switch (G__30743) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30741.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = {};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto__.call(null,m,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__8574__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto__.call(null,m));
} else {
var m__8574__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__8574__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto__.call(null,m,state_map));
} else {
var m__8574__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__8574__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8573__auto__ = (((m == null))?null:m);
var m__8574__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto__.call(null,m,mode));
} else {
var m__8574__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__8574__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var args__8983__auto__ = [];
var len__8976__auto___30760 = arguments.length;
var i__8977__auto___30761 = (0);
while(true){
if((i__8977__auto___30761 < len__8976__auto___30760)){
args__8983__auto__.push((arguments[i__8977__auto___30761]));

var G__30762 = (i__8977__auto___30761 + (1));
i__8977__auto___30761 = G__30762;
continue;
} else {
}
break;
}

var argseq__8984__auto__ = ((((3) < args__8983__auto__.length))?(new cljs.core.IndexedSeq(args__8983__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8984__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30754){
var map__30755 = p__30754;
var map__30755__$1 = ((((!((map__30755 == null)))?((((map__30755.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30755.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30755):map__30755);
var opts = map__30755__$1;
var statearr_30757_30763 = state;
(statearr_30757_30763[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts(((function (map__30755,map__30755__$1,opts){
return (function (val){
var statearr_30758_30764 = state;
(statearr_30758_30764[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__30755,map__30755__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_30759_30765 = state;
(statearr_30759_30765[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30750){
var G__30751 = cljs.core.first(seq30750);
var seq30750__$1 = cljs.core.next(seq30750);
var G__30752 = cljs.core.first(seq30750__$1);
var seq30750__$2 = cljs.core.next(seq30750__$1);
var G__30753 = cljs.core.first(seq30750__$2);
var seq30750__$3 = cljs.core.next(seq30750__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30751,G__30752,G__30753,seq30750__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30932 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30932) : cljs.core.atom.call(null,G__30932));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.constant$keyword$mute) : cljs.core.atom.call(null,cljs.core.constant$keyword$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t30933 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30933 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30934){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30934 = meta30934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t30933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30935,meta30934__$1){
var self__ = this;
var _30935__$1 = this;
return (new cljs.core.async.t30933(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30934__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30935){
var self__ = this;
var _30935__$1 = this;
return self__.meta30934;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t30933.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30936_31098 = self__.cs;
var G__30937_31099 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30936_31098,G__30937_31099) : cljs.core.reset_BANG_.call(null,G__30936_31098,G__30937_31099));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),cljs.core.constant$keyword$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30934","meta30934",64471930,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t30933.cljs$lang$type = true;

cljs.core.async.t30933.cljs$lang$ctorStr = "cljs.core.async/t30933";

cljs.core.async.t30933.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t30933");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t30933 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t30933(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30934){
return (new cljs.core.async.t30933(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30934));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t30933(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11556__auto___31100 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31035){
var state_val_31036 = (state_31035[(1)]);
if((state_val_31036 === (7))){
var inst_30953 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
var statearr_31037_31101 = state_31035__$1;
(statearr_31037_31101[(2)] = inst_30953);

(statearr_31037_31101[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (20))){
var inst_30965 = (state_31035[(7)]);
var state_31035__$1 = state_31035;
var statearr_31038_31102 = state_31035__$1;
(statearr_31038_31102[(2)] = inst_30965);

(statearr_31038_31102[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (27))){
var state_31035__$1 = state_31035;
var statearr_31039_31103 = state_31035__$1;
(statearr_31039_31103[(2)] = null);

(statearr_31039_31103[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (1))){
var inst_30941 = (state_31035[(8)]);
var inst_30941__$1 = calc_state();
var inst_30943 = (inst_30941__$1 == null);
var inst_30944 = cljs.core.not(inst_30943);
var state_31035__$1 = (function (){var statearr_31040 = state_31035;
(statearr_31040[(8)] = inst_30941__$1);

return statearr_31040;
})();
if(inst_30944){
var statearr_31041_31104 = state_31035__$1;
(statearr_31041_31104[(1)] = (2));

} else {
var statearr_31042_31105 = state_31035__$1;
(statearr_31042_31105[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (24))){
var inst_30995 = (state_31035[(9)]);
var inst_30988 = (state_31035[(10)]);
var inst_31009 = (state_31035[(11)]);
var inst_31009__$1 = (inst_30988.cljs$core$IFn$_invoke$arity$1 ? inst_30988.cljs$core$IFn$_invoke$arity$1(inst_30995) : inst_30988.call(null,inst_30995));
var state_31035__$1 = (function (){var statearr_31043 = state_31035;
(statearr_31043[(11)] = inst_31009__$1);

return statearr_31043;
})();
if(cljs.core.truth_(inst_31009__$1)){
var statearr_31044_31106 = state_31035__$1;
(statearr_31044_31106[(1)] = (29));

} else {
var statearr_31045_31107 = state_31035__$1;
(statearr_31045_31107[(1)] = (30));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (4))){
var inst_30956 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_30956)){
var statearr_31046_31108 = state_31035__$1;
(statearr_31046_31108[(1)] = (8));

} else {
var statearr_31047_31109 = state_31035__$1;
(statearr_31047_31109[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (15))){
var inst_30982 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_30982)){
var statearr_31048_31110 = state_31035__$1;
(statearr_31048_31110[(1)] = (19));

} else {
var statearr_31049_31111 = state_31035__$1;
(statearr_31049_31111[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (21))){
var inst_30987 = (state_31035[(12)]);
var inst_30987__$1 = (state_31035[(2)]);
var inst_30988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30987__$1,cljs.core.constant$keyword$solos);
var inst_30989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30987__$1,cljs.core.constant$keyword$mutes);
var inst_30990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30987__$1,cljs.core.constant$keyword$reads);
var state_31035__$1 = (function (){var statearr_31050 = state_31035;
(statearr_31050[(13)] = inst_30989);

(statearr_31050[(12)] = inst_30987__$1);

(statearr_31050[(10)] = inst_30988);

return statearr_31050;
})();
return cljs.core.async.ioc_alts_BANG_(state_31035__$1,(22),inst_30990);
} else {
if((state_val_31036 === (31))){
var inst_31017 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_31017)){
var statearr_31051_31112 = state_31035__$1;
(statearr_31051_31112[(1)] = (32));

} else {
var statearr_31052_31113 = state_31035__$1;
(statearr_31052_31113[(1)] = (33));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (32))){
var inst_30994 = (state_31035[(14)]);
var state_31035__$1 = state_31035;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31035__$1,(35),out,inst_30994);
} else {
if((state_val_31036 === (33))){
var inst_30987 = (state_31035[(12)]);
var inst_30965 = inst_30987;
var state_31035__$1 = (function (){var statearr_31053 = state_31035;
(statearr_31053[(7)] = inst_30965);

return statearr_31053;
})();
var statearr_31054_31114 = state_31035__$1;
(statearr_31054_31114[(2)] = null);

(statearr_31054_31114[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (13))){
var inst_30965 = (state_31035[(7)]);
var inst_30972 = inst_30965.cljs$lang$protocol_mask$partition0$;
var inst_30973 = (inst_30972 & (64));
var inst_30974 = inst_30965.cljs$core$ISeq$;
var inst_30975 = (inst_30973) || (inst_30974);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_30975)){
var statearr_31055_31115 = state_31035__$1;
(statearr_31055_31115[(1)] = (16));

} else {
var statearr_31056_31116 = state_31035__$1;
(statearr_31056_31116[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (22))){
var inst_30994 = (state_31035[(14)]);
var inst_30995 = (state_31035[(9)]);
var inst_30993 = (state_31035[(2)]);
var inst_30994__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30993,(0),null);
var inst_30995__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30993,(1),null);
var inst_30996 = (inst_30994__$1 == null);
var inst_30997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30995__$1,change);
var inst_30998 = (inst_30996) || (inst_30997);
var state_31035__$1 = (function (){var statearr_31057 = state_31035;
(statearr_31057[(14)] = inst_30994__$1);

(statearr_31057[(9)] = inst_30995__$1);

return statearr_31057;
})();
if(cljs.core.truth_(inst_30998)){
var statearr_31058_31117 = state_31035__$1;
(statearr_31058_31117[(1)] = (23));

} else {
var statearr_31059_31118 = state_31035__$1;
(statearr_31059_31118[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (36))){
var inst_30987 = (state_31035[(12)]);
var inst_30965 = inst_30987;
var state_31035__$1 = (function (){var statearr_31060 = state_31035;
(statearr_31060[(7)] = inst_30965);

return statearr_31060;
})();
var statearr_31061_31119 = state_31035__$1;
(statearr_31061_31119[(2)] = null);

(statearr_31061_31119[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (29))){
var inst_31009 = (state_31035[(11)]);
var state_31035__$1 = state_31035;
var statearr_31062_31120 = state_31035__$1;
(statearr_31062_31120[(2)] = inst_31009);

(statearr_31062_31120[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (6))){
var state_31035__$1 = state_31035;
var statearr_31063_31121 = state_31035__$1;
(statearr_31063_31121[(2)] = false);

(statearr_31063_31121[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (28))){
var inst_31005 = (state_31035[(2)]);
var inst_31006 = calc_state();
var inst_30965 = inst_31006;
var state_31035__$1 = (function (){var statearr_31064 = state_31035;
(statearr_31064[(7)] = inst_30965);

(statearr_31064[(15)] = inst_31005);

return statearr_31064;
})();
var statearr_31065_31122 = state_31035__$1;
(statearr_31065_31122[(2)] = null);

(statearr_31065_31122[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (25))){
var inst_31031 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
var statearr_31066_31123 = state_31035__$1;
(statearr_31066_31123[(2)] = inst_31031);

(statearr_31066_31123[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (34))){
var inst_31029 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
var statearr_31067_31124 = state_31035__$1;
(statearr_31067_31124[(2)] = inst_31029);

(statearr_31067_31124[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (17))){
var state_31035__$1 = state_31035;
var statearr_31068_31125 = state_31035__$1;
(statearr_31068_31125[(2)] = false);

(statearr_31068_31125[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (3))){
var state_31035__$1 = state_31035;
var statearr_31069_31126 = state_31035__$1;
(statearr_31069_31126[(2)] = false);

(statearr_31069_31126[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (12))){
var inst_31033 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31035__$1,inst_31033);
} else {
if((state_val_31036 === (2))){
var inst_30941 = (state_31035[(8)]);
var inst_30946 = inst_30941.cljs$lang$protocol_mask$partition0$;
var inst_30947 = (inst_30946 & (64));
var inst_30948 = inst_30941.cljs$core$ISeq$;
var inst_30949 = (inst_30947) || (inst_30948);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_30949)){
var statearr_31070_31127 = state_31035__$1;
(statearr_31070_31127[(1)] = (5));

} else {
var statearr_31071_31128 = state_31035__$1;
(statearr_31071_31128[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (23))){
var inst_30994 = (state_31035[(14)]);
var inst_31000 = (inst_30994 == null);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_31000)){
var statearr_31072_31129 = state_31035__$1;
(statearr_31072_31129[(1)] = (26));

} else {
var statearr_31073_31130 = state_31035__$1;
(statearr_31073_31130[(1)] = (27));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (35))){
var inst_31020 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
if(cljs.core.truth_(inst_31020)){
var statearr_31074_31131 = state_31035__$1;
(statearr_31074_31131[(1)] = (36));

} else {
var statearr_31075_31132 = state_31035__$1;
(statearr_31075_31132[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (19))){
var inst_30965 = (state_31035[(7)]);
var inst_30984 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30965);
var state_31035__$1 = state_31035;
var statearr_31076_31133 = state_31035__$1;
(statearr_31076_31133[(2)] = inst_30984);

(statearr_31076_31133[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (11))){
var inst_30965 = (state_31035[(7)]);
var inst_30969 = (inst_30965 == null);
var inst_30970 = cljs.core.not(inst_30969);
var state_31035__$1 = state_31035;
if(inst_30970){
var statearr_31077_31134 = state_31035__$1;
(statearr_31077_31134[(1)] = (13));

} else {
var statearr_31078_31135 = state_31035__$1;
(statearr_31078_31135[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (9))){
var inst_30941 = (state_31035[(8)]);
var state_31035__$1 = state_31035;
var statearr_31079_31136 = state_31035__$1;
(statearr_31079_31136[(2)] = inst_30941);

(statearr_31079_31136[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (5))){
var state_31035__$1 = state_31035;
var statearr_31080_31137 = state_31035__$1;
(statearr_31080_31137[(2)] = true);

(statearr_31080_31137[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (14))){
var state_31035__$1 = state_31035;
var statearr_31081_31138 = state_31035__$1;
(statearr_31081_31138[(2)] = false);

(statearr_31081_31138[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (26))){
var inst_30995 = (state_31035[(9)]);
var inst_31002 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_30995);
var state_31035__$1 = state_31035;
var statearr_31082_31139 = state_31035__$1;
(statearr_31082_31139[(2)] = inst_31002);

(statearr_31082_31139[(1)] = (28));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (16))){
var state_31035__$1 = state_31035;
var statearr_31083_31140 = state_31035__$1;
(statearr_31083_31140[(2)] = true);

(statearr_31083_31140[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (38))){
var inst_31025 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
var statearr_31084_31141 = state_31035__$1;
(statearr_31084_31141[(2)] = inst_31025);

(statearr_31084_31141[(1)] = (34));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (30))){
var inst_30989 = (state_31035[(13)]);
var inst_30995 = (state_31035[(9)]);
var inst_30988 = (state_31035[(10)]);
var inst_31012 = cljs.core.empty_QMARK_(inst_30988);
var inst_31013 = (inst_30989.cljs$core$IFn$_invoke$arity$1 ? inst_30989.cljs$core$IFn$_invoke$arity$1(inst_30995) : inst_30989.call(null,inst_30995));
var inst_31014 = cljs.core.not(inst_31013);
var inst_31015 = (inst_31012) && (inst_31014);
var state_31035__$1 = state_31035;
var statearr_31085_31142 = state_31035__$1;
(statearr_31085_31142[(2)] = inst_31015);

(statearr_31085_31142[(1)] = (31));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (10))){
var inst_30941 = (state_31035[(8)]);
var inst_30961 = (state_31035[(2)]);
var inst_30962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30961,cljs.core.constant$keyword$solos);
var inst_30963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30961,cljs.core.constant$keyword$mutes);
var inst_30964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30961,cljs.core.constant$keyword$reads);
var inst_30965 = inst_30941;
var state_31035__$1 = (function (){var statearr_31086 = state_31035;
(statearr_31086[(16)] = inst_30962);

(statearr_31086[(17)] = inst_30963);

(statearr_31086[(18)] = inst_30964);

(statearr_31086[(7)] = inst_30965);

return statearr_31086;
})();
var statearr_31087_31143 = state_31035__$1;
(statearr_31087_31143[(2)] = null);

(statearr_31087_31143[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (18))){
var inst_30979 = (state_31035[(2)]);
var state_31035__$1 = state_31035;
var statearr_31088_31144 = state_31035__$1;
(statearr_31088_31144[(2)] = inst_30979);

(statearr_31088_31144[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (37))){
var state_31035__$1 = state_31035;
var statearr_31089_31145 = state_31035__$1;
(statearr_31089_31145[(2)] = null);

(statearr_31089_31145[(1)] = (38));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31036 === (8))){
var inst_30941 = (state_31035[(8)]);
var inst_30958 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30941);
var state_31035__$1 = state_31035;
var statearr_31090_31146 = state_31035__$1;
(statearr_31090_31146[(2)] = inst_30958);

(statearr_31090_31146[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11491__auto__,c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11492__auto__ = null;
var cljs$core$async$mix_$_state_machine__11492__auto____0 = (function (){
var statearr_31094 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31094[(0)] = cljs$core$async$mix_$_state_machine__11492__auto__);

(statearr_31094[(1)] = (1));

return statearr_31094;
});
var cljs$core$async$mix_$_state_machine__11492__auto____1 = (function (state_31035){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31035);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31095){if((e31095 instanceof Object)){
var ex__11495__auto__ = e31095;
var statearr_31096_31147 = state_31035;
(statearr_31096_31147[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31035);

return cljs.core.constant$keyword$recur;
} else {
throw e31095;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31148 = state_31035;
state_31035 = G__31148;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11492__auto__ = function(state_31035){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11492__auto____1.call(this,state_31035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11492__auto____0;
cljs$core$async$mix_$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11492__auto____1;
return cljs$core$async$mix_$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11558__auto__ = (function (){var statearr_31097 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31100);

return statearr_31097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31100,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = {};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__8574__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__8574__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto__.call(null,p,v,ch));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__8574__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var args31151 = [];
var len__8976__auto___31154 = arguments.length;
var i__8977__auto___31155 = (0);
while(true){
if((i__8977__auto___31155 < len__8976__auto___31154)){
args31151.push((arguments[i__8977__auto___31155]));

var G__31156 = (i__8977__auto___31155 + (1));
i__8977__auto___31155 = G__31156;
continue;
} else {
}
break;
}

var G__31153 = args31151.length;
switch (G__31153) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31151.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto__.call(null,p));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__8574__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8573__auto__ = (((p == null))?null:p);
var m__8574__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8573__auto__)]);
if(!((m__8574__auto__ == null))){
return (m__8574__auto__.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto__.call(null,p,v));
} else {
var m__8574__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8574__auto____$1 == null))){
return (m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__8574__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__8574__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var args31159 = [];
var len__8976__auto___31287 = arguments.length;
var i__8977__auto___31288 = (0);
while(true){
if((i__8977__auto___31288 < len__8976__auto___31287)){
args31159.push((arguments[i__8977__auto___31288]));

var G__31289 = (i__8977__auto___31288 + (1));
i__8977__auto___31288 = G__31289;
continue;
} else {
}
break;
}

var G__31161 = args31159.length;
switch (G__31161) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31159.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__31162 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31162) : cljs.core.atom.call(null,G__31162));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7937__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7937__auto__)){
return or__7937__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7937__auto__,mults){
return (function (p1__31158_SHARP_){
if(cljs.core.truth_((p1__31158_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31158_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31158_SHARP_.call(null,topic)))){
return p1__31158_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31158_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7937__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t31163 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31163 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31164){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31164 = meta31164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31165,meta31164__$1){
var self__ = this;
var _31165__$1 = this;
return (new cljs.core.async.t31163(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31164__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31165){
var self__ = this;
var _31165__$1 = this;
return self__.meta31164;
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31163.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t31163.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31166 = self__.mults;
var G__31167 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31166,G__31167) : cljs.core.reset_BANG_.call(null,G__31166,G__31167));
});})(mults,ensure_mult))
;

cljs.core.async.t31163.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t31163.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31164","meta31164",946014714,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t31163.cljs$lang$type = true;

cljs.core.async.t31163.cljs$lang$ctorStr = "cljs.core.async/t31163";

cljs.core.async.t31163.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31163");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t31163 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t31163(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31164){
return (new cljs.core.async.t31163(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31164));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t31163(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11556__auto___31291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31291,mults,ensure_mult,p){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31291,mults,ensure_mult,p){
return (function (state_31239){
var state_val_31240 = (state_31239[(1)]);
if((state_val_31240 === (7))){
var inst_31235 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31241_31292 = state_31239__$1;
(statearr_31241_31292[(2)] = inst_31235);

(statearr_31241_31292[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (20))){
var state_31239__$1 = state_31239;
var statearr_31242_31293 = state_31239__$1;
(statearr_31242_31293[(2)] = null);

(statearr_31242_31293[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (1))){
var state_31239__$1 = state_31239;
var statearr_31243_31294 = state_31239__$1;
(statearr_31243_31294[(2)] = null);

(statearr_31243_31294[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (24))){
var inst_31218 = (state_31239[(7)]);
var inst_31227 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31218);
var state_31239__$1 = state_31239;
var statearr_31244_31295 = state_31239__$1;
(statearr_31244_31295[(2)] = inst_31227);

(statearr_31244_31295[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (4))){
var inst_31170 = (state_31239[(8)]);
var inst_31170__$1 = (state_31239[(2)]);
var inst_31171 = (inst_31170__$1 == null);
var state_31239__$1 = (function (){var statearr_31245 = state_31239;
(statearr_31245[(8)] = inst_31170__$1);

return statearr_31245;
})();
if(cljs.core.truth_(inst_31171)){
var statearr_31246_31296 = state_31239__$1;
(statearr_31246_31296[(1)] = (5));

} else {
var statearr_31247_31297 = state_31239__$1;
(statearr_31247_31297[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (15))){
var inst_31212 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31248_31298 = state_31239__$1;
(statearr_31248_31298[(2)] = inst_31212);

(statearr_31248_31298[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (21))){
var inst_31232 = (state_31239[(2)]);
var state_31239__$1 = (function (){var statearr_31249 = state_31239;
(statearr_31249[(9)] = inst_31232);

return statearr_31249;
})();
var statearr_31250_31299 = state_31239__$1;
(statearr_31250_31299[(2)] = null);

(statearr_31250_31299[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (13))){
var inst_31194 = (state_31239[(10)]);
var inst_31196 = cljs.core.chunked_seq_QMARK_(inst_31194);
var state_31239__$1 = state_31239;
if(inst_31196){
var statearr_31251_31300 = state_31239__$1;
(statearr_31251_31300[(1)] = (16));

} else {
var statearr_31252_31301 = state_31239__$1;
(statearr_31252_31301[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (22))){
var inst_31224 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
if(cljs.core.truth_(inst_31224)){
var statearr_31253_31302 = state_31239__$1;
(statearr_31253_31302[(1)] = (23));

} else {
var statearr_31254_31303 = state_31239__$1;
(statearr_31254_31303[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (6))){
var inst_31220 = (state_31239[(11)]);
var inst_31218 = (state_31239[(7)]);
var inst_31170 = (state_31239[(8)]);
var inst_31218__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31170) : topic_fn.call(null,inst_31170));
var inst_31219 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31220__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31219,inst_31218__$1);
var state_31239__$1 = (function (){var statearr_31255 = state_31239;
(statearr_31255[(11)] = inst_31220__$1);

(statearr_31255[(7)] = inst_31218__$1);

return statearr_31255;
})();
if(cljs.core.truth_(inst_31220__$1)){
var statearr_31256_31304 = state_31239__$1;
(statearr_31256_31304[(1)] = (19));

} else {
var statearr_31257_31305 = state_31239__$1;
(statearr_31257_31305[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (25))){
var inst_31229 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31258_31306 = state_31239__$1;
(statearr_31258_31306[(2)] = inst_31229);

(statearr_31258_31306[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (17))){
var inst_31194 = (state_31239[(10)]);
var inst_31203 = cljs.core.first(inst_31194);
var inst_31204 = cljs.core.async.muxch_STAR_(inst_31203);
var inst_31205 = cljs.core.async.close_BANG_(inst_31204);
var inst_31206 = cljs.core.next(inst_31194);
var inst_31180 = inst_31206;
var inst_31181 = null;
var inst_31182 = (0);
var inst_31183 = (0);
var state_31239__$1 = (function (){var statearr_31259 = state_31239;
(statearr_31259[(12)] = inst_31181);

(statearr_31259[(13)] = inst_31183);

(statearr_31259[(14)] = inst_31182);

(statearr_31259[(15)] = inst_31205);

(statearr_31259[(16)] = inst_31180);

return statearr_31259;
})();
var statearr_31260_31307 = state_31239__$1;
(statearr_31260_31307[(2)] = null);

(statearr_31260_31307[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (3))){
var inst_31237 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31239__$1,inst_31237);
} else {
if((state_val_31240 === (12))){
var inst_31214 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31261_31308 = state_31239__$1;
(statearr_31261_31308[(2)] = inst_31214);

(statearr_31261_31308[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (2))){
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31239__$1,(4),ch);
} else {
if((state_val_31240 === (23))){
var state_31239__$1 = state_31239;
var statearr_31262_31309 = state_31239__$1;
(statearr_31262_31309[(2)] = null);

(statearr_31262_31309[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (19))){
var inst_31220 = (state_31239[(11)]);
var inst_31170 = (state_31239[(8)]);
var inst_31222 = cljs.core.async.muxch_STAR_(inst_31220);
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31239__$1,(22),inst_31222,inst_31170);
} else {
if((state_val_31240 === (11))){
var inst_31194 = (state_31239[(10)]);
var inst_31180 = (state_31239[(16)]);
var inst_31194__$1 = cljs.core.seq(inst_31180);
var state_31239__$1 = (function (){var statearr_31263 = state_31239;
(statearr_31263[(10)] = inst_31194__$1);

return statearr_31263;
})();
if(inst_31194__$1){
var statearr_31264_31310 = state_31239__$1;
(statearr_31264_31310[(1)] = (13));

} else {
var statearr_31265_31311 = state_31239__$1;
(statearr_31265_31311[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (9))){
var inst_31216 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31266_31312 = state_31239__$1;
(statearr_31266_31312[(2)] = inst_31216);

(statearr_31266_31312[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (5))){
var inst_31177 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_31178 = cljs.core.vals(inst_31177);
var inst_31179 = cljs.core.seq(inst_31178);
var inst_31180 = inst_31179;
var inst_31181 = null;
var inst_31182 = (0);
var inst_31183 = (0);
var state_31239__$1 = (function (){var statearr_31267 = state_31239;
(statearr_31267[(12)] = inst_31181);

(statearr_31267[(13)] = inst_31183);

(statearr_31267[(14)] = inst_31182);

(statearr_31267[(16)] = inst_31180);

return statearr_31267;
})();
var statearr_31268_31313 = state_31239__$1;
(statearr_31268_31313[(2)] = null);

(statearr_31268_31313[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (14))){
var state_31239__$1 = state_31239;
var statearr_31272_31314 = state_31239__$1;
(statearr_31272_31314[(2)] = null);

(statearr_31272_31314[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (16))){
var inst_31194 = (state_31239[(10)]);
var inst_31198 = cljs.core.chunk_first(inst_31194);
var inst_31199 = cljs.core.chunk_rest(inst_31194);
var inst_31200 = cljs.core.count(inst_31198);
var inst_31180 = inst_31199;
var inst_31181 = inst_31198;
var inst_31182 = inst_31200;
var inst_31183 = (0);
var state_31239__$1 = (function (){var statearr_31273 = state_31239;
(statearr_31273[(12)] = inst_31181);

(statearr_31273[(13)] = inst_31183);

(statearr_31273[(14)] = inst_31182);

(statearr_31273[(16)] = inst_31180);

return statearr_31273;
})();
var statearr_31274_31315 = state_31239__$1;
(statearr_31274_31315[(2)] = null);

(statearr_31274_31315[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (10))){
var inst_31181 = (state_31239[(12)]);
var inst_31183 = (state_31239[(13)]);
var inst_31182 = (state_31239[(14)]);
var inst_31180 = (state_31239[(16)]);
var inst_31188 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31181,inst_31183);
var inst_31189 = cljs.core.async.muxch_STAR_(inst_31188);
var inst_31190 = cljs.core.async.close_BANG_(inst_31189);
var inst_31191 = (inst_31183 + (1));
var tmp31269 = inst_31181;
var tmp31270 = inst_31182;
var tmp31271 = inst_31180;
var inst_31180__$1 = tmp31271;
var inst_31181__$1 = tmp31269;
var inst_31182__$1 = tmp31270;
var inst_31183__$1 = inst_31191;
var state_31239__$1 = (function (){var statearr_31275 = state_31239;
(statearr_31275[(12)] = inst_31181__$1);

(statearr_31275[(13)] = inst_31183__$1);

(statearr_31275[(14)] = inst_31182__$1);

(statearr_31275[(17)] = inst_31190);

(statearr_31275[(16)] = inst_31180__$1);

return statearr_31275;
})();
var statearr_31276_31316 = state_31239__$1;
(statearr_31276_31316[(2)] = null);

(statearr_31276_31316[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (18))){
var inst_31209 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31277_31317 = state_31239__$1;
(statearr_31277_31317[(2)] = inst_31209);

(statearr_31277_31317[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (8))){
var inst_31183 = (state_31239[(13)]);
var inst_31182 = (state_31239[(14)]);
var inst_31185 = (inst_31183 < inst_31182);
var inst_31186 = inst_31185;
var state_31239__$1 = state_31239;
if(cljs.core.truth_(inst_31186)){
var statearr_31278_31318 = state_31239__$1;
(statearr_31278_31318[(1)] = (10));

} else {
var statearr_31279_31319 = state_31239__$1;
(statearr_31279_31319[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31291,mults,ensure_mult,p))
;
return ((function (switch__11491__auto__,c__11556__auto___31291,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31283[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31283[(1)] = (1));

return statearr_31283;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31239){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31239);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31284){if((e31284 instanceof Object)){
var ex__11495__auto__ = e31284;
var statearr_31285_31320 = state_31239;
(statearr_31285_31320[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31239);

return cljs.core.constant$keyword$recur;
} else {
throw e31284;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31321 = state_31239;
state_31239 = G__31321;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31239){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31291,mults,ensure_mult,p))
})();
var state__11558__auto__ = (function (){var statearr_31286 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31291);

return statearr_31286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31291,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var args31322 = [];
var len__8976__auto___31325 = arguments.length;
var i__8977__auto___31326 = (0);
while(true){
if((i__8977__auto___31326 < len__8976__auto___31325)){
args31322.push((arguments[i__8977__auto___31326]));

var G__31327 = (i__8977__auto___31326 + (1));
i__8977__auto___31326 = G__31327;
continue;
} else {
}
break;
}

var G__31324 = args31322.length;
switch (G__31324) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31322.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var args31329 = [];
var len__8976__auto___31332 = arguments.length;
var i__8977__auto___31333 = (0);
while(true){
if((i__8977__auto___31333 < len__8976__auto___31332)){
args31329.push((arguments[i__8977__auto___31333]));

var G__31334 = (i__8977__auto___31333 + (1));
i__8977__auto___31333 = G__31334;
continue;
} else {
}
break;
}

var G__31331 = args31329.length;
switch (G__31331) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31329.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var args31336 = [];
var len__8976__auto___31407 = arguments.length;
var i__8977__auto___31408 = (0);
while(true){
if((i__8977__auto___31408 < len__8976__auto___31407)){
args31336.push((arguments[i__8977__auto___31408]));

var G__31409 = (i__8977__auto___31408 + (1));
i__8977__auto___31408 = G__31409;
continue;
} else {
}
break;
}

var G__31338 = args31336.length;
switch (G__31338) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31336.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__11556__auto___31411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31377){
var state_val_31378 = (state_31377[(1)]);
if((state_val_31378 === (7))){
var state_31377__$1 = state_31377;
var statearr_31379_31412 = state_31377__$1;
(statearr_31379_31412[(2)] = null);

(statearr_31379_31412[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (1))){
var state_31377__$1 = state_31377;
var statearr_31380_31413 = state_31377__$1;
(statearr_31380_31413[(2)] = null);

(statearr_31380_31413[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (4))){
var inst_31341 = (state_31377[(7)]);
var inst_31343 = (inst_31341 < cnt);
var state_31377__$1 = state_31377;
if(cljs.core.truth_(inst_31343)){
var statearr_31381_31414 = state_31377__$1;
(statearr_31381_31414[(1)] = (6));

} else {
var statearr_31382_31415 = state_31377__$1;
(statearr_31382_31415[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (15))){
var inst_31373 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31383_31416 = state_31377__$1;
(statearr_31383_31416[(2)] = inst_31373);

(statearr_31383_31416[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (13))){
var inst_31366 = cljs.core.async.close_BANG_(out);
var state_31377__$1 = state_31377;
var statearr_31384_31417 = state_31377__$1;
(statearr_31384_31417[(2)] = inst_31366);

(statearr_31384_31417[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (6))){
var state_31377__$1 = state_31377;
var statearr_31385_31418 = state_31377__$1;
(statearr_31385_31418[(2)] = null);

(statearr_31385_31418[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (3))){
var inst_31375 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31377__$1,inst_31375);
} else {
if((state_val_31378 === (12))){
var inst_31363 = (state_31377[(8)]);
var inst_31363__$1 = (state_31377[(2)]);
var inst_31364 = cljs.core.some(cljs.core.nil_QMARK_,inst_31363__$1);
var state_31377__$1 = (function (){var statearr_31386 = state_31377;
(statearr_31386[(8)] = inst_31363__$1);

return statearr_31386;
})();
if(cljs.core.truth_(inst_31364)){
var statearr_31387_31419 = state_31377__$1;
(statearr_31387_31419[(1)] = (13));

} else {
var statearr_31388_31420 = state_31377__$1;
(statearr_31388_31420[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (2))){
var inst_31340 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_31341 = (0);
var state_31377__$1 = (function (){var statearr_31389 = state_31377;
(statearr_31389[(7)] = inst_31341);

(statearr_31389[(9)] = inst_31340);

return statearr_31389;
})();
var statearr_31390_31421 = state_31377__$1;
(statearr_31390_31421[(2)] = null);

(statearr_31390_31421[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (11))){
var inst_31341 = (state_31377[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_31377,(10),Object,null,(9));
var inst_31350 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31341) : chs__$1.call(null,inst_31341));
var inst_31351 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31341) : done.call(null,inst_31341));
var inst_31352 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31350,inst_31351);
var state_31377__$1 = state_31377;
var statearr_31391_31422 = state_31377__$1;
(statearr_31391_31422[(2)] = inst_31352);


cljs.core.async.impl.ioc_helpers.process_exception(state_31377__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (9))){
var inst_31341 = (state_31377[(7)]);
var inst_31354 = (state_31377[(2)]);
var inst_31355 = (inst_31341 + (1));
var inst_31341__$1 = inst_31355;
var state_31377__$1 = (function (){var statearr_31392 = state_31377;
(statearr_31392[(10)] = inst_31354);

(statearr_31392[(7)] = inst_31341__$1);

return statearr_31392;
})();
var statearr_31393_31423 = state_31377__$1;
(statearr_31393_31423[(2)] = null);

(statearr_31393_31423[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (5))){
var inst_31361 = (state_31377[(2)]);
var state_31377__$1 = (function (){var statearr_31394 = state_31377;
(statearr_31394[(11)] = inst_31361);

return statearr_31394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31377__$1,(12),dchan);
} else {
if((state_val_31378 === (14))){
var inst_31363 = (state_31377[(8)]);
var inst_31368 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_31363);
var state_31377__$1 = state_31377;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31377__$1,(16),out,inst_31368);
} else {
if((state_val_31378 === (16))){
var inst_31370 = (state_31377[(2)]);
var state_31377__$1 = (function (){var statearr_31395 = state_31377;
(statearr_31395[(12)] = inst_31370);

return statearr_31395;
})();
var statearr_31396_31424 = state_31377__$1;
(statearr_31396_31424[(2)] = null);

(statearr_31396_31424[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (10))){
var inst_31345 = (state_31377[(2)]);
var inst_31346 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_31377__$1 = (function (){var statearr_31397 = state_31377;
(statearr_31397[(13)] = inst_31345);

return statearr_31397;
})();
var statearr_31398_31425 = state_31377__$1;
(statearr_31398_31425[(2)] = inst_31346);


cljs.core.async.impl.ioc_helpers.process_exception(state_31377__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31378 === (8))){
var inst_31359 = (state_31377[(2)]);
var state_31377__$1 = state_31377;
var statearr_31399_31426 = state_31377__$1;
(statearr_31399_31426[(2)] = inst_31359);

(statearr_31399_31426[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11491__auto__,c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31403[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31403[(1)] = (1));

return statearr_31403;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31377){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31377);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31404){if((e31404 instanceof Object)){
var ex__11495__auto__ = e31404;
var statearr_31405_31427 = state_31377;
(statearr_31405_31427[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31377);

return cljs.core.constant$keyword$recur;
} else {
throw e31404;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31428 = state_31377;
state_31377 = G__31428;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31377){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11558__auto__ = (function (){var statearr_31406 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31406[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31411);

return statearr_31406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31411,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var args31430 = [];
var len__8976__auto___31486 = arguments.length;
var i__8977__auto___31487 = (0);
while(true){
if((i__8977__auto___31487 < len__8976__auto___31486)){
args31430.push((arguments[i__8977__auto___31487]));

var G__31488 = (i__8977__auto___31487 + (1));
i__8977__auto___31487 = G__31488;
continue;
} else {
}
break;
}

var G__31432 = args31430.length;
switch (G__31432) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31430.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___31490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31490,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31490,out){
return (function (state_31462){
var state_val_31463 = (state_31462[(1)]);
if((state_val_31463 === (7))){
var inst_31442 = (state_31462[(7)]);
var inst_31441 = (state_31462[(8)]);
var inst_31441__$1 = (state_31462[(2)]);
var inst_31442__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31441__$1,(0),null);
var inst_31443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31441__$1,(1),null);
var inst_31444 = (inst_31442__$1 == null);
var state_31462__$1 = (function (){var statearr_31464 = state_31462;
(statearr_31464[(7)] = inst_31442__$1);

(statearr_31464[(8)] = inst_31441__$1);

(statearr_31464[(9)] = inst_31443);

return statearr_31464;
})();
if(cljs.core.truth_(inst_31444)){
var statearr_31465_31491 = state_31462__$1;
(statearr_31465_31491[(1)] = (8));

} else {
var statearr_31466_31492 = state_31462__$1;
(statearr_31466_31492[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (1))){
var inst_31433 = cljs.core.vec(chs);
var inst_31434 = inst_31433;
var state_31462__$1 = (function (){var statearr_31467 = state_31462;
(statearr_31467[(10)] = inst_31434);

return statearr_31467;
})();
var statearr_31468_31493 = state_31462__$1;
(statearr_31468_31493[(2)] = null);

(statearr_31468_31493[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (4))){
var inst_31434 = (state_31462[(10)]);
var state_31462__$1 = state_31462;
return cljs.core.async.ioc_alts_BANG_(state_31462__$1,(7),inst_31434);
} else {
if((state_val_31463 === (6))){
var inst_31458 = (state_31462[(2)]);
var state_31462__$1 = state_31462;
var statearr_31469_31494 = state_31462__$1;
(statearr_31469_31494[(2)] = inst_31458);

(statearr_31469_31494[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (3))){
var inst_31460 = (state_31462[(2)]);
var state_31462__$1 = state_31462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31462__$1,inst_31460);
} else {
if((state_val_31463 === (2))){
var inst_31434 = (state_31462[(10)]);
var inst_31436 = cljs.core.count(inst_31434);
var inst_31437 = (inst_31436 > (0));
var state_31462__$1 = state_31462;
if(cljs.core.truth_(inst_31437)){
var statearr_31471_31495 = state_31462__$1;
(statearr_31471_31495[(1)] = (4));

} else {
var statearr_31472_31496 = state_31462__$1;
(statearr_31472_31496[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (11))){
var inst_31434 = (state_31462[(10)]);
var inst_31451 = (state_31462[(2)]);
var tmp31470 = inst_31434;
var inst_31434__$1 = tmp31470;
var state_31462__$1 = (function (){var statearr_31473 = state_31462;
(statearr_31473[(10)] = inst_31434__$1);

(statearr_31473[(11)] = inst_31451);

return statearr_31473;
})();
var statearr_31474_31497 = state_31462__$1;
(statearr_31474_31497[(2)] = null);

(statearr_31474_31497[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (9))){
var inst_31442 = (state_31462[(7)]);
var state_31462__$1 = state_31462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31462__$1,(11),out,inst_31442);
} else {
if((state_val_31463 === (5))){
var inst_31456 = cljs.core.async.close_BANG_(out);
var state_31462__$1 = state_31462;
var statearr_31475_31498 = state_31462__$1;
(statearr_31475_31498[(2)] = inst_31456);

(statearr_31475_31498[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (10))){
var inst_31454 = (state_31462[(2)]);
var state_31462__$1 = state_31462;
var statearr_31476_31499 = state_31462__$1;
(statearr_31476_31499[(2)] = inst_31454);

(statearr_31476_31499[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31463 === (8))){
var inst_31434 = (state_31462[(10)]);
var inst_31442 = (state_31462[(7)]);
var inst_31441 = (state_31462[(8)]);
var inst_31443 = (state_31462[(9)]);
var inst_31446 = (function (){var cs = inst_31434;
var vec__31439 = inst_31441;
var v = inst_31442;
var c = inst_31443;
return ((function (cs,vec__31439,v,c,inst_31434,inst_31442,inst_31441,inst_31443,state_val_31463,c__11556__auto___31490,out){
return (function (p1__31429_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__31429_SHARP_);
});
;})(cs,vec__31439,v,c,inst_31434,inst_31442,inst_31441,inst_31443,state_val_31463,c__11556__auto___31490,out))
})();
var inst_31447 = cljs.core.filterv(inst_31446,inst_31434);
var inst_31434__$1 = inst_31447;
var state_31462__$1 = (function (){var statearr_31477 = state_31462;
(statearr_31477[(10)] = inst_31434__$1);

return statearr_31477;
})();
var statearr_31478_31500 = state_31462__$1;
(statearr_31478_31500[(2)] = null);

(statearr_31478_31500[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31490,out))
;
return ((function (switch__11491__auto__,c__11556__auto___31490,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31482 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31482[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31482[(1)] = (1));

return statearr_31482;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31462){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31462);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31483){if((e31483 instanceof Object)){
var ex__11495__auto__ = e31483;
var statearr_31484_31501 = state_31462;
(statearr_31484_31501[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31462);

return cljs.core.constant$keyword$recur;
} else {
throw e31483;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31502 = state_31462;
state_31462 = G__31502;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31490,out))
})();
var state__11558__auto__ = (function (){var statearr_31485 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31485[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31490);

return statearr_31485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31490,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var args31503 = [];
var len__8976__auto___31552 = arguments.length;
var i__8977__auto___31553 = (0);
while(true){
if((i__8977__auto___31553 < len__8976__auto___31552)){
args31503.push((arguments[i__8977__auto___31553]));

var G__31554 = (i__8977__auto___31553 + (1));
i__8977__auto___31553 = G__31554;
continue;
} else {
}
break;
}

var G__31505 = args31503.length;
switch (G__31505) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31503.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___31556 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31556,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31556,out){
return (function (state_31529){
var state_val_31530 = (state_31529[(1)]);
if((state_val_31530 === (7))){
var inst_31511 = (state_31529[(7)]);
var inst_31511__$1 = (state_31529[(2)]);
var inst_31512 = (inst_31511__$1 == null);
var inst_31513 = cljs.core.not(inst_31512);
var state_31529__$1 = (function (){var statearr_31531 = state_31529;
(statearr_31531[(7)] = inst_31511__$1);

return statearr_31531;
})();
if(inst_31513){
var statearr_31532_31557 = state_31529__$1;
(statearr_31532_31557[(1)] = (8));

} else {
var statearr_31533_31558 = state_31529__$1;
(statearr_31533_31558[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (1))){
var inst_31506 = (0);
var state_31529__$1 = (function (){var statearr_31534 = state_31529;
(statearr_31534[(8)] = inst_31506);

return statearr_31534;
})();
var statearr_31535_31559 = state_31529__$1;
(statearr_31535_31559[(2)] = null);

(statearr_31535_31559[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (4))){
var state_31529__$1 = state_31529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31529__$1,(7),ch);
} else {
if((state_val_31530 === (6))){
var inst_31524 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
var statearr_31536_31560 = state_31529__$1;
(statearr_31536_31560[(2)] = inst_31524);

(statearr_31536_31560[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (3))){
var inst_31526 = (state_31529[(2)]);
var inst_31527 = cljs.core.async.close_BANG_(out);
var state_31529__$1 = (function (){var statearr_31537 = state_31529;
(statearr_31537[(9)] = inst_31526);

return statearr_31537;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31529__$1,inst_31527);
} else {
if((state_val_31530 === (2))){
var inst_31506 = (state_31529[(8)]);
var inst_31508 = (inst_31506 < n);
var state_31529__$1 = state_31529;
if(cljs.core.truth_(inst_31508)){
var statearr_31538_31561 = state_31529__$1;
(statearr_31538_31561[(1)] = (4));

} else {
var statearr_31539_31562 = state_31529__$1;
(statearr_31539_31562[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (11))){
var inst_31506 = (state_31529[(8)]);
var inst_31516 = (state_31529[(2)]);
var inst_31517 = (inst_31506 + (1));
var inst_31506__$1 = inst_31517;
var state_31529__$1 = (function (){var statearr_31540 = state_31529;
(statearr_31540[(10)] = inst_31516);

(statearr_31540[(8)] = inst_31506__$1);

return statearr_31540;
})();
var statearr_31541_31563 = state_31529__$1;
(statearr_31541_31563[(2)] = null);

(statearr_31541_31563[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (9))){
var state_31529__$1 = state_31529;
var statearr_31542_31564 = state_31529__$1;
(statearr_31542_31564[(2)] = null);

(statearr_31542_31564[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (5))){
var state_31529__$1 = state_31529;
var statearr_31543_31565 = state_31529__$1;
(statearr_31543_31565[(2)] = null);

(statearr_31543_31565[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (10))){
var inst_31521 = (state_31529[(2)]);
var state_31529__$1 = state_31529;
var statearr_31544_31566 = state_31529__$1;
(statearr_31544_31566[(2)] = inst_31521);

(statearr_31544_31566[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31530 === (8))){
var inst_31511 = (state_31529[(7)]);
var state_31529__$1 = state_31529;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31529__$1,(11),out,inst_31511);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31556,out))
;
return ((function (switch__11491__auto__,c__11556__auto___31556,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31548 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31548[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31548[(1)] = (1));

return statearr_31548;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31529){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31529);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31549){if((e31549 instanceof Object)){
var ex__11495__auto__ = e31549;
var statearr_31550_31567 = state_31529;
(statearr_31550_31567[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31529);

return cljs.core.constant$keyword$recur;
} else {
throw e31549;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31568 = state_31529;
state_31529 = G__31568;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31556,out))
})();
var state__11558__auto__ = (function (){var statearr_31551 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31551[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31556);

return statearr_31551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31556,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t31578 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31578 = (function (map_LT_,f,ch,meta31579){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31579 = meta31579;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31578.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31580,meta31579__$1){
var self__ = this;
var _31580__$1 = this;
return (new cljs.core.async.t31578(self__.map_LT_,self__.f,self__.ch,meta31579__$1));
});

cljs.core.async.t31578.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31580){
var self__ = this;
var _31580__$1 = this;
return self__.meta31579;
});

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t31581 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31581 = (function (map_LT_,f,ch,meta31579,_,fn1,meta31582){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31579 = meta31579;
this._ = _;
this.fn1 = fn1;
this.meta31582 = meta31582;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31581.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31583,meta31582__$1){
var self__ = this;
var _31583__$1 = this;
return (new cljs.core.async.t31581(self__.map_LT_,self__.f,self__.ch,self__.meta31579,self__._,self__.fn1,meta31582__$1));
});})(___$1))
;

cljs.core.async.t31581.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31583){
var self__ = this;
var _31583__$1 = this;
return self__.meta31582;
});})(___$1))
;

cljs.core.async.t31581.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t31581.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t31581.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31569_SHARP_){
var G__31584 = (((p1__31569_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__31569_SHARP_) : self__.f.call(null,p1__31569_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__31584) : f1.call(null,G__31584));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t31581.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31579","meta31579",1370404953,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tag,new cljs.core.Symbol("cljs.core.async","t31578","cljs.core.async/t31578",621306360,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31582","meta31582",-1174191442,null)], null);
});})(___$1))
;

cljs.core.async.t31581.cljs$lang$type = true;

cljs.core.async.t31581.cljs$lang$ctorStr = "cljs.core.async/t31581";

cljs.core.async.t31581.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31581");
});})(___$1))
;

cljs.core.async.__GT_t31581 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t31581(map_LT___$1,f__$1,ch__$1,meta31579__$1,___$2,fn1__$1,meta31582){
return (new cljs.core.async.t31581(map_LT___$1,f__$1,ch__$1,meta31579__$1,___$2,fn1__$1,meta31582));
});})(___$1))
;

}

return (new cljs.core.async.t31581(self__.map_LT_,self__.f,self__.ch,self__.meta31579,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7925__auto__ = ret;
if(cljs.core.truth_(and__7925__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7925__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__31585 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__31585) : self__.f.call(null,G__31585));
})());
} else {
return ret;
}
});

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31578.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t31578.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31579","meta31579",1370404953,null)], null);
});

cljs.core.async.t31578.cljs$lang$type = true;

cljs.core.async.t31578.cljs$lang$ctorStr = "cljs.core.async/t31578";

cljs.core.async.t31578.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31578");
});

cljs.core.async.__GT_t31578 = (function cljs$core$async$map_LT__$___GT_t31578(map_LT___$1,f__$1,ch__$1,meta31579){
return (new cljs.core.async.t31578(map_LT___$1,f__$1,ch__$1,meta31579));
});

}

return (new cljs.core.async.t31578(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t31589 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31589 = (function (map_GT_,f,ch,meta31590){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31590 = meta31590;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31589.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31591,meta31590__$1){
var self__ = this;
var _31591__$1 = this;
return (new cljs.core.async.t31589(self__.map_GT_,self__.f,self__.ch,meta31590__$1));
});

cljs.core.async.t31589.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31591){
var self__ = this;
var _31591__$1 = this;
return self__.meta31590;
});

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31589.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t31589.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31590","meta31590",-398177588,null)], null);
});

cljs.core.async.t31589.cljs$lang$type = true;

cljs.core.async.t31589.cljs$lang$ctorStr = "cljs.core.async/t31589";

cljs.core.async.t31589.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31589");
});

cljs.core.async.__GT_t31589 = (function cljs$core$async$map_GT__$___GT_t31589(map_GT___$1,f__$1,ch__$1,meta31590){
return (new cljs.core.async.t31589(map_GT___$1,f__$1,ch__$1,meta31590));
});

}

return (new cljs.core.async.t31589(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t31595 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31595 = (function (filter_GT_,p,ch,meta31596){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31596 = meta31596;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t31595.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31597,meta31596__$1){
var self__ = this;
var _31597__$1 = this;
return (new cljs.core.async.t31595(self__.filter_GT_,self__.p,self__.ch,meta31596__$1));
});

cljs.core.async.t31595.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31597){
var self__ = this;
var _31597__$1 = this;
return self__.meta31596;
});

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t31595.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t31595.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$arglists,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),cljs.core.constant$keyword$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31596","meta31596",558703382,null)], null);
});

cljs.core.async.t31595.cljs$lang$type = true;

cljs.core.async.t31595.cljs$lang$ctorStr = "cljs.core.async/t31595";

cljs.core.async.t31595.cljs$lang$ctorPrWriter = (function (this__8516__auto__,writer__8517__auto__,opt__8518__auto__){
return cljs.core._write(writer__8517__auto__,"cljs.core.async/t31595");
});

cljs.core.async.__GT_t31595 = (function cljs$core$async$filter_GT__$___GT_t31595(filter_GT___$1,p__$1,ch__$1,meta31596){
return (new cljs.core.async.t31595(filter_GT___$1,p__$1,ch__$1,meta31596));
});

}

return (new cljs.core.async.t31595(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var args31598 = [];
var len__8976__auto___31642 = arguments.length;
var i__8977__auto___31643 = (0);
while(true){
if((i__8977__auto___31643 < len__8976__auto___31642)){
args31598.push((arguments[i__8977__auto___31643]));

var G__31644 = (i__8977__auto___31643 + (1));
i__8977__auto___31643 = G__31644;
continue;
} else {
}
break;
}

var G__31600 = args31598.length;
switch (G__31600) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31598.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___31646 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31646,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31646,out){
return (function (state_31621){
var state_val_31622 = (state_31621[(1)]);
if((state_val_31622 === (7))){
var inst_31617 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31623_31647 = state_31621__$1;
(statearr_31623_31647[(2)] = inst_31617);

(statearr_31623_31647[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (1))){
var state_31621__$1 = state_31621;
var statearr_31624_31648 = state_31621__$1;
(statearr_31624_31648[(2)] = null);

(statearr_31624_31648[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (4))){
var inst_31603 = (state_31621[(7)]);
var inst_31603__$1 = (state_31621[(2)]);
var inst_31604 = (inst_31603__$1 == null);
var state_31621__$1 = (function (){var statearr_31625 = state_31621;
(statearr_31625[(7)] = inst_31603__$1);

return statearr_31625;
})();
if(cljs.core.truth_(inst_31604)){
var statearr_31626_31649 = state_31621__$1;
(statearr_31626_31649[(1)] = (5));

} else {
var statearr_31627_31650 = state_31621__$1;
(statearr_31627_31650[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (6))){
var inst_31603 = (state_31621[(7)]);
var inst_31608 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31603) : p.call(null,inst_31603));
var state_31621__$1 = state_31621;
if(cljs.core.truth_(inst_31608)){
var statearr_31628_31651 = state_31621__$1;
(statearr_31628_31651[(1)] = (8));

} else {
var statearr_31629_31652 = state_31621__$1;
(statearr_31629_31652[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (3))){
var inst_31619 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31621__$1,inst_31619);
} else {
if((state_val_31622 === (2))){
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31621__$1,(4),ch);
} else {
if((state_val_31622 === (11))){
var inst_31611 = (state_31621[(2)]);
var state_31621__$1 = state_31621;
var statearr_31630_31653 = state_31621__$1;
(statearr_31630_31653[(2)] = inst_31611);

(statearr_31630_31653[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (9))){
var state_31621__$1 = state_31621;
var statearr_31631_31654 = state_31621__$1;
(statearr_31631_31654[(2)] = null);

(statearr_31631_31654[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (5))){
var inst_31606 = cljs.core.async.close_BANG_(out);
var state_31621__$1 = state_31621;
var statearr_31632_31655 = state_31621__$1;
(statearr_31632_31655[(2)] = inst_31606);

(statearr_31632_31655[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (10))){
var inst_31614 = (state_31621[(2)]);
var state_31621__$1 = (function (){var statearr_31633 = state_31621;
(statearr_31633[(8)] = inst_31614);

return statearr_31633;
})();
var statearr_31634_31656 = state_31621__$1;
(statearr_31634_31656[(2)] = null);

(statearr_31634_31656[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31622 === (8))){
var inst_31603 = (state_31621[(7)]);
var state_31621__$1 = state_31621;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31621__$1,(11),out,inst_31603);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31646,out))
;
return ((function (switch__11491__auto__,c__11556__auto___31646,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31638 = [null,null,null,null,null,null,null,null,null];
(statearr_31638[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31638[(1)] = (1));

return statearr_31638;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31621){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31621);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31639){if((e31639 instanceof Object)){
var ex__11495__auto__ = e31639;
var statearr_31640_31657 = state_31621;
(statearr_31640_31657[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31621);

return cljs.core.constant$keyword$recur;
} else {
throw e31639;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31658 = state_31621;
state_31621 = G__31658;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31621){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31646,out))
})();
var state__11558__auto__ = (function (){var statearr_31641 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31646);

return statearr_31641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31646,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var args31659 = [];
var len__8976__auto___31662 = arguments.length;
var i__8977__auto___31663 = (0);
while(true){
if((i__8977__auto___31663 < len__8976__auto___31662)){
args31659.push((arguments[i__8977__auto___31663]));

var G__31664 = (i__8977__auto___31663 + (1));
i__8977__auto___31663 = G__31664;
continue;
} else {
}
break;
}

var G__31661 = args31659.length;
switch (G__31661) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31659.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11556__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto__){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto__){
return (function (state_31831){
var state_val_31832 = (state_31831[(1)]);
if((state_val_31832 === (7))){
var inst_31827 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31833_31874 = state_31831__$1;
(statearr_31833_31874[(2)] = inst_31827);

(statearr_31833_31874[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (20))){
var inst_31797 = (state_31831[(7)]);
var inst_31808 = (state_31831[(2)]);
var inst_31809 = cljs.core.next(inst_31797);
var inst_31783 = inst_31809;
var inst_31784 = null;
var inst_31785 = (0);
var inst_31786 = (0);
var state_31831__$1 = (function (){var statearr_31834 = state_31831;
(statearr_31834[(8)] = inst_31786);

(statearr_31834[(9)] = inst_31808);

(statearr_31834[(10)] = inst_31785);

(statearr_31834[(11)] = inst_31784);

(statearr_31834[(12)] = inst_31783);

return statearr_31834;
})();
var statearr_31835_31875 = state_31831__$1;
(statearr_31835_31875[(2)] = null);

(statearr_31835_31875[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (1))){
var state_31831__$1 = state_31831;
var statearr_31836_31876 = state_31831__$1;
(statearr_31836_31876[(2)] = null);

(statearr_31836_31876[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (4))){
var inst_31772 = (state_31831[(13)]);
var inst_31772__$1 = (state_31831[(2)]);
var inst_31773 = (inst_31772__$1 == null);
var state_31831__$1 = (function (){var statearr_31837 = state_31831;
(statearr_31837[(13)] = inst_31772__$1);

return statearr_31837;
})();
if(cljs.core.truth_(inst_31773)){
var statearr_31838_31877 = state_31831__$1;
(statearr_31838_31877[(1)] = (5));

} else {
var statearr_31839_31878 = state_31831__$1;
(statearr_31839_31878[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (15))){
var state_31831__$1 = state_31831;
var statearr_31843_31879 = state_31831__$1;
(statearr_31843_31879[(2)] = null);

(statearr_31843_31879[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (21))){
var state_31831__$1 = state_31831;
var statearr_31844_31880 = state_31831__$1;
(statearr_31844_31880[(2)] = null);

(statearr_31844_31880[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (13))){
var inst_31786 = (state_31831[(8)]);
var inst_31785 = (state_31831[(10)]);
var inst_31784 = (state_31831[(11)]);
var inst_31783 = (state_31831[(12)]);
var inst_31793 = (state_31831[(2)]);
var inst_31794 = (inst_31786 + (1));
var tmp31840 = inst_31785;
var tmp31841 = inst_31784;
var tmp31842 = inst_31783;
var inst_31783__$1 = tmp31842;
var inst_31784__$1 = tmp31841;
var inst_31785__$1 = tmp31840;
var inst_31786__$1 = inst_31794;
var state_31831__$1 = (function (){var statearr_31845 = state_31831;
(statearr_31845[(8)] = inst_31786__$1);

(statearr_31845[(10)] = inst_31785__$1);

(statearr_31845[(11)] = inst_31784__$1);

(statearr_31845[(14)] = inst_31793);

(statearr_31845[(12)] = inst_31783__$1);

return statearr_31845;
})();
var statearr_31846_31881 = state_31831__$1;
(statearr_31846_31881[(2)] = null);

(statearr_31846_31881[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (22))){
var state_31831__$1 = state_31831;
var statearr_31847_31882 = state_31831__$1;
(statearr_31847_31882[(2)] = null);

(statearr_31847_31882[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (6))){
var inst_31772 = (state_31831[(13)]);
var inst_31781 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31772) : f.call(null,inst_31772));
var inst_31782 = cljs.core.seq(inst_31781);
var inst_31783 = inst_31782;
var inst_31784 = null;
var inst_31785 = (0);
var inst_31786 = (0);
var state_31831__$1 = (function (){var statearr_31848 = state_31831;
(statearr_31848[(8)] = inst_31786);

(statearr_31848[(10)] = inst_31785);

(statearr_31848[(11)] = inst_31784);

(statearr_31848[(12)] = inst_31783);

return statearr_31848;
})();
var statearr_31849_31883 = state_31831__$1;
(statearr_31849_31883[(2)] = null);

(statearr_31849_31883[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (17))){
var inst_31797 = (state_31831[(7)]);
var inst_31801 = cljs.core.chunk_first(inst_31797);
var inst_31802 = cljs.core.chunk_rest(inst_31797);
var inst_31803 = cljs.core.count(inst_31801);
var inst_31783 = inst_31802;
var inst_31784 = inst_31801;
var inst_31785 = inst_31803;
var inst_31786 = (0);
var state_31831__$1 = (function (){var statearr_31850 = state_31831;
(statearr_31850[(8)] = inst_31786);

(statearr_31850[(10)] = inst_31785);

(statearr_31850[(11)] = inst_31784);

(statearr_31850[(12)] = inst_31783);

return statearr_31850;
})();
var statearr_31851_31884 = state_31831__$1;
(statearr_31851_31884[(2)] = null);

(statearr_31851_31884[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (3))){
var inst_31829 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31831__$1,inst_31829);
} else {
if((state_val_31832 === (12))){
var inst_31817 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31852_31885 = state_31831__$1;
(statearr_31852_31885[(2)] = inst_31817);

(statearr_31852_31885[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (2))){
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31831__$1,(4),in$);
} else {
if((state_val_31832 === (23))){
var inst_31825 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31853_31886 = state_31831__$1;
(statearr_31853_31886[(2)] = inst_31825);

(statearr_31853_31886[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (19))){
var inst_31812 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31854_31887 = state_31831__$1;
(statearr_31854_31887[(2)] = inst_31812);

(statearr_31854_31887[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (11))){
var inst_31797 = (state_31831[(7)]);
var inst_31783 = (state_31831[(12)]);
var inst_31797__$1 = cljs.core.seq(inst_31783);
var state_31831__$1 = (function (){var statearr_31855 = state_31831;
(statearr_31855[(7)] = inst_31797__$1);

return statearr_31855;
})();
if(inst_31797__$1){
var statearr_31856_31888 = state_31831__$1;
(statearr_31856_31888[(1)] = (14));

} else {
var statearr_31857_31889 = state_31831__$1;
(statearr_31857_31889[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (9))){
var inst_31819 = (state_31831[(2)]);
var inst_31820 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31831__$1 = (function (){var statearr_31858 = state_31831;
(statearr_31858[(15)] = inst_31819);

return statearr_31858;
})();
if(cljs.core.truth_(inst_31820)){
var statearr_31859_31890 = state_31831__$1;
(statearr_31859_31890[(1)] = (21));

} else {
var statearr_31860_31891 = state_31831__$1;
(statearr_31860_31891[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (5))){
var inst_31775 = cljs.core.async.close_BANG_(out);
var state_31831__$1 = state_31831;
var statearr_31861_31892 = state_31831__$1;
(statearr_31861_31892[(2)] = inst_31775);

(statearr_31861_31892[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (14))){
var inst_31797 = (state_31831[(7)]);
var inst_31799 = cljs.core.chunked_seq_QMARK_(inst_31797);
var state_31831__$1 = state_31831;
if(inst_31799){
var statearr_31862_31893 = state_31831__$1;
(statearr_31862_31893[(1)] = (17));

} else {
var statearr_31863_31894 = state_31831__$1;
(statearr_31863_31894[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (16))){
var inst_31815 = (state_31831[(2)]);
var state_31831__$1 = state_31831;
var statearr_31864_31895 = state_31831__$1;
(statearr_31864_31895[(2)] = inst_31815);

(statearr_31864_31895[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31832 === (10))){
var inst_31786 = (state_31831[(8)]);
var inst_31784 = (state_31831[(11)]);
var inst_31791 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31784,inst_31786);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31831__$1,(13),out,inst_31791);
} else {
if((state_val_31832 === (18))){
var inst_31797 = (state_31831[(7)]);
var inst_31806 = cljs.core.first(inst_31797);
var state_31831__$1 = state_31831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31831__$1,(20),out,inst_31806);
} else {
if((state_val_31832 === (8))){
var inst_31786 = (state_31831[(8)]);
var inst_31785 = (state_31831[(10)]);
var inst_31788 = (inst_31786 < inst_31785);
var inst_31789 = inst_31788;
var state_31831__$1 = state_31831;
if(cljs.core.truth_(inst_31789)){
var statearr_31865_31896 = state_31831__$1;
(statearr_31865_31896[(1)] = (10));

} else {
var statearr_31866_31897 = state_31831__$1;
(statearr_31866_31897[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto__))
;
return ((function (switch__11491__auto__,c__11556__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____0 = (function (){
var statearr_31870 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31870[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__);

(statearr_31870[(1)] = (1));

return statearr_31870;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____1 = (function (state_31831){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31831);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31871){if((e31871 instanceof Object)){
var ex__11495__auto__ = e31871;
var statearr_31872_31898 = state_31831;
(statearr_31872_31898[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31831);

return cljs.core.constant$keyword$recur;
} else {
throw e31871;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31899 = state_31831;
state_31831 = G__31899;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__ = function(state_31831){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____1.call(this,state_31831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11492__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto__))
})();
var state__11558__auto__ = (function (){var statearr_31873 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31873[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto__);

return statearr_31873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto__))
);

return c__11556__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var args31900 = [];
var len__8976__auto___31903 = arguments.length;
var i__8977__auto___31904 = (0);
while(true){
if((i__8977__auto___31904 < len__8976__auto___31903)){
args31900.push((arguments[i__8977__auto___31904]));

var G__31905 = (i__8977__auto___31904 + (1));
i__8977__auto___31904 = G__31905;
continue;
} else {
}
break;
}

var G__31902 = args31900.length;
switch (G__31902) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31900.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var args31907 = [];
var len__8976__auto___31910 = arguments.length;
var i__8977__auto___31911 = (0);
while(true){
if((i__8977__auto___31911 < len__8976__auto___31910)){
args31907.push((arguments[i__8977__auto___31911]));

var G__31912 = (i__8977__auto___31911 + (1));
i__8977__auto___31911 = G__31912;
continue;
} else {
}
break;
}

var G__31909 = args31907.length;
switch (G__31909) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31907.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var args31914 = [];
var len__8976__auto___31965 = arguments.length;
var i__8977__auto___31966 = (0);
while(true){
if((i__8977__auto___31966 < len__8976__auto___31965)){
args31914.push((arguments[i__8977__auto___31966]));

var G__31967 = (i__8977__auto___31966 + (1));
i__8977__auto___31966 = G__31967;
continue;
} else {
}
break;
}

var G__31916 = args31914.length;
switch (G__31916) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31914.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___31969 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___31969,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___31969,out){
return (function (state_31940){
var state_val_31941 = (state_31940[(1)]);
if((state_val_31941 === (7))){
var inst_31935 = (state_31940[(2)]);
var state_31940__$1 = state_31940;
var statearr_31942_31970 = state_31940__$1;
(statearr_31942_31970[(2)] = inst_31935);

(statearr_31942_31970[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (1))){
var inst_31917 = null;
var state_31940__$1 = (function (){var statearr_31943 = state_31940;
(statearr_31943[(7)] = inst_31917);

return statearr_31943;
})();
var statearr_31944_31971 = state_31940__$1;
(statearr_31944_31971[(2)] = null);

(statearr_31944_31971[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (4))){
var inst_31920 = (state_31940[(8)]);
var inst_31920__$1 = (state_31940[(2)]);
var inst_31921 = (inst_31920__$1 == null);
var inst_31922 = cljs.core.not(inst_31921);
var state_31940__$1 = (function (){var statearr_31945 = state_31940;
(statearr_31945[(8)] = inst_31920__$1);

return statearr_31945;
})();
if(inst_31922){
var statearr_31946_31972 = state_31940__$1;
(statearr_31946_31972[(1)] = (5));

} else {
var statearr_31947_31973 = state_31940__$1;
(statearr_31947_31973[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (6))){
var state_31940__$1 = state_31940;
var statearr_31948_31974 = state_31940__$1;
(statearr_31948_31974[(2)] = null);

(statearr_31948_31974[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (3))){
var inst_31937 = (state_31940[(2)]);
var inst_31938 = cljs.core.async.close_BANG_(out);
var state_31940__$1 = (function (){var statearr_31949 = state_31940;
(statearr_31949[(9)] = inst_31937);

return statearr_31949;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31940__$1,inst_31938);
} else {
if((state_val_31941 === (2))){
var state_31940__$1 = state_31940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31940__$1,(4),ch);
} else {
if((state_val_31941 === (11))){
var inst_31920 = (state_31940[(8)]);
var inst_31929 = (state_31940[(2)]);
var inst_31917 = inst_31920;
var state_31940__$1 = (function (){var statearr_31950 = state_31940;
(statearr_31950[(10)] = inst_31929);

(statearr_31950[(7)] = inst_31917);

return statearr_31950;
})();
var statearr_31951_31975 = state_31940__$1;
(statearr_31951_31975[(2)] = null);

(statearr_31951_31975[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (9))){
var inst_31920 = (state_31940[(8)]);
var state_31940__$1 = state_31940;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31940__$1,(11),out,inst_31920);
} else {
if((state_val_31941 === (5))){
var inst_31920 = (state_31940[(8)]);
var inst_31917 = (state_31940[(7)]);
var inst_31924 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31920,inst_31917);
var state_31940__$1 = state_31940;
if(inst_31924){
var statearr_31953_31976 = state_31940__$1;
(statearr_31953_31976[(1)] = (8));

} else {
var statearr_31954_31977 = state_31940__$1;
(statearr_31954_31977[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (10))){
var inst_31932 = (state_31940[(2)]);
var state_31940__$1 = state_31940;
var statearr_31955_31978 = state_31940__$1;
(statearr_31955_31978[(2)] = inst_31932);

(statearr_31955_31978[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31941 === (8))){
var inst_31917 = (state_31940[(7)]);
var tmp31952 = inst_31917;
var inst_31917__$1 = tmp31952;
var state_31940__$1 = (function (){var statearr_31956 = state_31940;
(statearr_31956[(7)] = inst_31917__$1);

return statearr_31956;
})();
var statearr_31957_31979 = state_31940__$1;
(statearr_31957_31979[(2)] = null);

(statearr_31957_31979[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___31969,out))
;
return ((function (switch__11491__auto__,c__11556__auto___31969,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_31961 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31961[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_31961[(1)] = (1));

return statearr_31961;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_31940){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_31940);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e31962){if((e31962 instanceof Object)){
var ex__11495__auto__ = e31962;
var statearr_31963_31980 = state_31940;
(statearr_31963_31980[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31940);

return cljs.core.constant$keyword$recur;
} else {
throw e31962;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__31981 = state_31940;
state_31940 = G__31981;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_31940){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_31940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___31969,out))
})();
var state__11558__auto__ = (function (){var statearr_31964 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_31964[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___31969);

return statearr_31964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___31969,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var args31982 = [];
var len__8976__auto___32052 = arguments.length;
var i__8977__auto___32053 = (0);
while(true){
if((i__8977__auto___32053 < len__8976__auto___32052)){
args31982.push((arguments[i__8977__auto___32053]));

var G__32054 = (i__8977__auto___32053 + (1));
i__8977__auto___32053 = G__32054;
continue;
} else {
}
break;
}

var G__31984 = args31982.length;
switch (G__31984) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31982.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___32056 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___32056,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___32056,out){
return (function (state_32022){
var state_val_32023 = (state_32022[(1)]);
if((state_val_32023 === (7))){
var inst_32018 = (state_32022[(2)]);
var state_32022__$1 = state_32022;
var statearr_32024_32057 = state_32022__$1;
(statearr_32024_32057[(2)] = inst_32018);

(statearr_32024_32057[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (1))){
var inst_31985 = (new Array(n));
var inst_31986 = inst_31985;
var inst_31987 = (0);
var state_32022__$1 = (function (){var statearr_32025 = state_32022;
(statearr_32025[(7)] = inst_31986);

(statearr_32025[(8)] = inst_31987);

return statearr_32025;
})();
var statearr_32026_32058 = state_32022__$1;
(statearr_32026_32058[(2)] = null);

(statearr_32026_32058[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (4))){
var inst_31990 = (state_32022[(9)]);
var inst_31990__$1 = (state_32022[(2)]);
var inst_31991 = (inst_31990__$1 == null);
var inst_31992 = cljs.core.not(inst_31991);
var state_32022__$1 = (function (){var statearr_32027 = state_32022;
(statearr_32027[(9)] = inst_31990__$1);

return statearr_32027;
})();
if(inst_31992){
var statearr_32028_32059 = state_32022__$1;
(statearr_32028_32059[(1)] = (5));

} else {
var statearr_32029_32060 = state_32022__$1;
(statearr_32029_32060[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (15))){
var inst_32012 = (state_32022[(2)]);
var state_32022__$1 = state_32022;
var statearr_32030_32061 = state_32022__$1;
(statearr_32030_32061[(2)] = inst_32012);

(statearr_32030_32061[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (13))){
var state_32022__$1 = state_32022;
var statearr_32031_32062 = state_32022__$1;
(statearr_32031_32062[(2)] = null);

(statearr_32031_32062[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (6))){
var inst_31987 = (state_32022[(8)]);
var inst_32008 = (inst_31987 > (0));
var state_32022__$1 = state_32022;
if(cljs.core.truth_(inst_32008)){
var statearr_32032_32063 = state_32022__$1;
(statearr_32032_32063[(1)] = (12));

} else {
var statearr_32033_32064 = state_32022__$1;
(statearr_32033_32064[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (3))){
var inst_32020 = (state_32022[(2)]);
var state_32022__$1 = state_32022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32022__$1,inst_32020);
} else {
if((state_val_32023 === (12))){
var inst_31986 = (state_32022[(7)]);
var inst_32010 = cljs.core.vec(inst_31986);
var state_32022__$1 = state_32022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32022__$1,(15),out,inst_32010);
} else {
if((state_val_32023 === (2))){
var state_32022__$1 = state_32022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32022__$1,(4),ch);
} else {
if((state_val_32023 === (11))){
var inst_32002 = (state_32022[(2)]);
var inst_32003 = (new Array(n));
var inst_31986 = inst_32003;
var inst_31987 = (0);
var state_32022__$1 = (function (){var statearr_32034 = state_32022;
(statearr_32034[(7)] = inst_31986);

(statearr_32034[(10)] = inst_32002);

(statearr_32034[(8)] = inst_31987);

return statearr_32034;
})();
var statearr_32035_32065 = state_32022__$1;
(statearr_32035_32065[(2)] = null);

(statearr_32035_32065[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (9))){
var inst_31986 = (state_32022[(7)]);
var inst_32000 = cljs.core.vec(inst_31986);
var state_32022__$1 = state_32022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32022__$1,(11),out,inst_32000);
} else {
if((state_val_32023 === (5))){
var inst_31986 = (state_32022[(7)]);
var inst_31987 = (state_32022[(8)]);
var inst_31995 = (state_32022[(11)]);
var inst_31990 = (state_32022[(9)]);
var inst_31994 = (inst_31986[inst_31987] = inst_31990);
var inst_31995__$1 = (inst_31987 + (1));
var inst_31996 = (inst_31995__$1 < n);
var state_32022__$1 = (function (){var statearr_32036 = state_32022;
(statearr_32036[(11)] = inst_31995__$1);

(statearr_32036[(12)] = inst_31994);

return statearr_32036;
})();
if(cljs.core.truth_(inst_31996)){
var statearr_32037_32066 = state_32022__$1;
(statearr_32037_32066[(1)] = (8));

} else {
var statearr_32038_32067 = state_32022__$1;
(statearr_32038_32067[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (14))){
var inst_32015 = (state_32022[(2)]);
var inst_32016 = cljs.core.async.close_BANG_(out);
var state_32022__$1 = (function (){var statearr_32040 = state_32022;
(statearr_32040[(13)] = inst_32015);

return statearr_32040;
})();
var statearr_32041_32068 = state_32022__$1;
(statearr_32041_32068[(2)] = inst_32016);

(statearr_32041_32068[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (10))){
var inst_32006 = (state_32022[(2)]);
var state_32022__$1 = state_32022;
var statearr_32042_32069 = state_32022__$1;
(statearr_32042_32069[(2)] = inst_32006);

(statearr_32042_32069[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32023 === (8))){
var inst_31986 = (state_32022[(7)]);
var inst_31995 = (state_32022[(11)]);
var tmp32039 = inst_31986;
var inst_31986__$1 = tmp32039;
var inst_31987 = inst_31995;
var state_32022__$1 = (function (){var statearr_32043 = state_32022;
(statearr_32043[(7)] = inst_31986__$1);

(statearr_32043[(8)] = inst_31987);

return statearr_32043;
})();
var statearr_32044_32070 = state_32022__$1;
(statearr_32044_32070[(2)] = null);

(statearr_32044_32070[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___32056,out))
;
return ((function (switch__11491__auto__,c__11556__auto___32056,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_32048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32048[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_32048[(1)] = (1));

return statearr_32048;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_32022){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_32022);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e32049){if((e32049 instanceof Object)){
var ex__11495__auto__ = e32049;
var statearr_32050_32071 = state_32022;
(statearr_32050_32071[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32022);

return cljs.core.constant$keyword$recur;
} else {
throw e32049;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__32072 = state_32022;
state_32022 = G__32072;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_32022){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_32022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___32056,out))
})();
var state__11558__auto__ = (function (){var statearr_32051 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_32051[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___32056);

return statearr_32051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___32056,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var args32073 = [];
var len__8976__auto___32147 = arguments.length;
var i__8977__auto___32148 = (0);
while(true){
if((i__8977__auto___32148 < len__8976__auto___32147)){
args32073.push((arguments[i__8977__auto___32148]));

var G__32149 = (i__8977__auto___32148 + (1));
i__8977__auto___32148 = G__32149;
continue;
} else {
}
break;
}

var G__32075 = args32073.length;
switch (G__32075) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32073.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__11556__auto___32151 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11556__auto___32151,out){
return (function (){
var f__11557__auto__ = (function (){var switch__11491__auto__ = ((function (c__11556__auto___32151,out){
return (function (state_32117){
var state_val_32118 = (state_32117[(1)]);
if((state_val_32118 === (7))){
var inst_32113 = (state_32117[(2)]);
var state_32117__$1 = state_32117;
var statearr_32119_32152 = state_32117__$1;
(statearr_32119_32152[(2)] = inst_32113);

(statearr_32119_32152[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (1))){
var inst_32076 = [];
var inst_32077 = inst_32076;
var inst_32078 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_32117__$1 = (function (){var statearr_32120 = state_32117;
(statearr_32120[(7)] = inst_32078);

(statearr_32120[(8)] = inst_32077);

return statearr_32120;
})();
var statearr_32121_32153 = state_32117__$1;
(statearr_32121_32153[(2)] = null);

(statearr_32121_32153[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (4))){
var inst_32081 = (state_32117[(9)]);
var inst_32081__$1 = (state_32117[(2)]);
var inst_32082 = (inst_32081__$1 == null);
var inst_32083 = cljs.core.not(inst_32082);
var state_32117__$1 = (function (){var statearr_32122 = state_32117;
(statearr_32122[(9)] = inst_32081__$1);

return statearr_32122;
})();
if(inst_32083){
var statearr_32123_32154 = state_32117__$1;
(statearr_32123_32154[(1)] = (5));

} else {
var statearr_32124_32155 = state_32117__$1;
(statearr_32124_32155[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (15))){
var inst_32107 = (state_32117[(2)]);
var state_32117__$1 = state_32117;
var statearr_32125_32156 = state_32117__$1;
(statearr_32125_32156[(2)] = inst_32107);

(statearr_32125_32156[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (13))){
var state_32117__$1 = state_32117;
var statearr_32126_32157 = state_32117__$1;
(statearr_32126_32157[(2)] = null);

(statearr_32126_32157[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (6))){
var inst_32077 = (state_32117[(8)]);
var inst_32102 = inst_32077.length;
var inst_32103 = (inst_32102 > (0));
var state_32117__$1 = state_32117;
if(cljs.core.truth_(inst_32103)){
var statearr_32127_32158 = state_32117__$1;
(statearr_32127_32158[(1)] = (12));

} else {
var statearr_32128_32159 = state_32117__$1;
(statearr_32128_32159[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (3))){
var inst_32115 = (state_32117[(2)]);
var state_32117__$1 = state_32117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32117__$1,inst_32115);
} else {
if((state_val_32118 === (12))){
var inst_32077 = (state_32117[(8)]);
var inst_32105 = cljs.core.vec(inst_32077);
var state_32117__$1 = state_32117;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32117__$1,(15),out,inst_32105);
} else {
if((state_val_32118 === (2))){
var state_32117__$1 = state_32117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32117__$1,(4),ch);
} else {
if((state_val_32118 === (11))){
var inst_32081 = (state_32117[(9)]);
var inst_32085 = (state_32117[(10)]);
var inst_32095 = (state_32117[(2)]);
var inst_32096 = [];
var inst_32097 = inst_32096.push(inst_32081);
var inst_32077 = inst_32096;
var inst_32078 = inst_32085;
var state_32117__$1 = (function (){var statearr_32129 = state_32117;
(statearr_32129[(11)] = inst_32097);

(statearr_32129[(7)] = inst_32078);

(statearr_32129[(8)] = inst_32077);

(statearr_32129[(12)] = inst_32095);

return statearr_32129;
})();
var statearr_32130_32160 = state_32117__$1;
(statearr_32130_32160[(2)] = null);

(statearr_32130_32160[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (9))){
var inst_32077 = (state_32117[(8)]);
var inst_32093 = cljs.core.vec(inst_32077);
var state_32117__$1 = state_32117;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32117__$1,(11),out,inst_32093);
} else {
if((state_val_32118 === (5))){
var inst_32078 = (state_32117[(7)]);
var inst_32081 = (state_32117[(9)]);
var inst_32085 = (state_32117[(10)]);
var inst_32085__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32081) : f.call(null,inst_32081));
var inst_32086 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32085__$1,inst_32078);
var inst_32087 = cljs.core.keyword_identical_QMARK_(inst_32078,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_32088 = (inst_32086) || (inst_32087);
var state_32117__$1 = (function (){var statearr_32131 = state_32117;
(statearr_32131[(10)] = inst_32085__$1);

return statearr_32131;
})();
if(cljs.core.truth_(inst_32088)){
var statearr_32132_32161 = state_32117__$1;
(statearr_32132_32161[(1)] = (8));

} else {
var statearr_32133_32162 = state_32117__$1;
(statearr_32133_32162[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (14))){
var inst_32110 = (state_32117[(2)]);
var inst_32111 = cljs.core.async.close_BANG_(out);
var state_32117__$1 = (function (){var statearr_32135 = state_32117;
(statearr_32135[(13)] = inst_32110);

return statearr_32135;
})();
var statearr_32136_32163 = state_32117__$1;
(statearr_32136_32163[(2)] = inst_32111);

(statearr_32136_32163[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (10))){
var inst_32100 = (state_32117[(2)]);
var state_32117__$1 = state_32117;
var statearr_32137_32164 = state_32117__$1;
(statearr_32137_32164[(2)] = inst_32100);

(statearr_32137_32164[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32118 === (8))){
var inst_32081 = (state_32117[(9)]);
var inst_32085 = (state_32117[(10)]);
var inst_32077 = (state_32117[(8)]);
var inst_32090 = inst_32077.push(inst_32081);
var tmp32134 = inst_32077;
var inst_32077__$1 = tmp32134;
var inst_32078 = inst_32085;
var state_32117__$1 = (function (){var statearr_32138 = state_32117;
(statearr_32138[(7)] = inst_32078);

(statearr_32138[(14)] = inst_32090);

(statearr_32138[(8)] = inst_32077__$1);

return statearr_32138;
})();
var statearr_32139_32165 = state_32117__$1;
(statearr_32139_32165[(2)] = null);

(statearr_32139_32165[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11556__auto___32151,out))
;
return ((function (switch__11491__auto__,c__11556__auto___32151,out){
return (function() {
var cljs$core$async$state_machine__11492__auto__ = null;
var cljs$core$async$state_machine__11492__auto____0 = (function (){
var statearr_32143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32143[(0)] = cljs$core$async$state_machine__11492__auto__);

(statearr_32143[(1)] = (1));

return statearr_32143;
});
var cljs$core$async$state_machine__11492__auto____1 = (function (state_32117){
while(true){
var ret_value__11493__auto__ = (function (){try{while(true){
var result__11494__auto__ = switch__11491__auto__(state_32117);
if(cljs.core.keyword_identical_QMARK_(result__11494__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11494__auto__;
}
break;
}
}catch (e32144){if((e32144 instanceof Object)){
var ex__11495__auto__ = e32144;
var statearr_32145_32166 = state_32117;
(statearr_32145_32166[(5)] = ex__11495__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32117);

return cljs.core.constant$keyword$recur;
} else {
throw e32144;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11493__auto__,cljs.core.constant$keyword$recur)){
var G__32167 = state_32117;
state_32117 = G__32167;
continue;
} else {
return ret_value__11493__auto__;
}
break;
}
});
cljs$core$async$state_machine__11492__auto__ = function(state_32117){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11492__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11492__auto____1.call(this,state_32117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11492__auto____0;
cljs$core$async$state_machine__11492__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11492__auto____1;
return cljs$core$async$state_machine__11492__auto__;
})()
;})(switch__11491__auto__,c__11556__auto___32151,out))
})();
var state__11558__auto__ = (function (){var statearr_32146 = (f__11557__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11557__auto__.cljs$core$IFn$_invoke$arity$0() : f__11557__auto__.call(null));
(statearr_32146[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11556__auto___32151);

return statearr_32146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11558__auto__);
});})(c__11556__auto___32151,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
