// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_(class_name,class$,i)){
return i;
} else {
var G__29585 = (i + class$.length);
start_from = G__29585;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index(class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__29590 = arguments.length;
switch (G__29590) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var classes__$1 = clojure.string.trim(cljs.core.name(classes));
if(cljs.core.seq(classes__$1)){
var temp__4124__auto___29604 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29604)){
var class_list_29605 = temp__4124__auto___29604;
var seq__29591_29606 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__29592_29607 = null;
var count__29593_29608 = (0);
var i__29594_29609 = (0);
while(true){
if((i__29594_29609 < count__29593_29608)){
var class_29610 = chunk__29592_29607.cljs$core$IIndexed$_nth$arity$2(null,i__29594_29609);
class_list_29605.add(class_29610);

var G__29611 = seq__29591_29606;
var G__29612 = chunk__29592_29607;
var G__29613 = count__29593_29608;
var G__29614 = (i__29594_29609 + (1));
seq__29591_29606 = G__29611;
chunk__29592_29607 = G__29612;
count__29593_29608 = G__29613;
i__29594_29609 = G__29614;
continue;
} else {
var temp__4126__auto___29615 = cljs.core.seq(seq__29591_29606);
if(temp__4126__auto___29615){
var seq__29591_29616__$1 = temp__4126__auto___29615;
if(cljs.core.chunked_seq_QMARK_(seq__29591_29616__$1)){
var c__5061__auto___29617 = cljs.core.chunk_first(seq__29591_29616__$1);
var G__29618 = cljs.core.chunk_rest(seq__29591_29616__$1);
var G__29619 = c__5061__auto___29617;
var G__29620 = cljs.core.count(c__5061__auto___29617);
var G__29621 = (0);
seq__29591_29606 = G__29618;
chunk__29592_29607 = G__29619;
count__29593_29608 = G__29620;
i__29594_29609 = G__29621;
continue;
} else {
var class_29622 = cljs.core.first(seq__29591_29616__$1);
class_list_29605.add(class_29622);

var G__29623 = cljs.core.next(seq__29591_29616__$1);
var G__29624 = null;
var G__29625 = (0);
var G__29626 = (0);
seq__29591_29606 = G__29623;
chunk__29592_29607 = G__29624;
count__29593_29608 = G__29625;
i__29594_29609 = G__29626;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_29627 = elem__$1.className;
var seq__29595_29628 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__29596_29629 = null;
var count__29597_29630 = (0);
var i__29598_29631 = (0);
while(true){
if((i__29598_29631 < count__29597_29630)){
var class_29632 = chunk__29596_29629.cljs$core$IIndexed$_nth$arity$2(null,i__29598_29631);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_29627,class_29632))){
} else {
elem__$1.className = (((class_name_29627 === ""))?class_29632:[cljs.core.str(class_name_29627),cljs.core.str(" "),cljs.core.str(class_29632)].join(''));
}

var G__29633 = seq__29595_29628;
var G__29634 = chunk__29596_29629;
var G__29635 = count__29597_29630;
var G__29636 = (i__29598_29631 + (1));
seq__29595_29628 = G__29633;
chunk__29596_29629 = G__29634;
count__29597_29630 = G__29635;
i__29598_29631 = G__29636;
continue;
} else {
var temp__4126__auto___29637 = cljs.core.seq(seq__29595_29628);
if(temp__4126__auto___29637){
var seq__29595_29638__$1 = temp__4126__auto___29637;
if(cljs.core.chunked_seq_QMARK_(seq__29595_29638__$1)){
var c__5061__auto___29639 = cljs.core.chunk_first(seq__29595_29638__$1);
var G__29640 = cljs.core.chunk_rest(seq__29595_29638__$1);
var G__29641 = c__5061__auto___29639;
var G__29642 = cljs.core.count(c__5061__auto___29639);
var G__29643 = (0);
seq__29595_29628 = G__29640;
chunk__29596_29629 = G__29641;
count__29597_29630 = G__29642;
i__29598_29631 = G__29643;
continue;
} else {
var class_29644 = cljs.core.first(seq__29595_29638__$1);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_29627,class_29644))){
} else {
elem__$1.className = (((class_name_29627 === ""))?class_29644:[cljs.core.str(class_name_29627),cljs.core.str(" "),cljs.core.str(class_29644)].join(''));
}

var G__29645 = cljs.core.next(seq__29595_29638__$1);
var G__29646 = null;
var G__29647 = (0);
var G__29648 = (0);
seq__29595_29628 = G__29645;
chunk__29596_29629 = G__29646;
count__29597_29630 = G__29647;
i__29598_29631 = G__29648;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29599_29649 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__29600_29650 = null;
var count__29601_29651 = (0);
var i__29602_29652 = (0);
while(true){
if((i__29602_29652 < count__29601_29651)){
var c_29653 = chunk__29600_29650.cljs$core$IIndexed$_nth$arity$2(null,i__29602_29652);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_29653);

var G__29654 = seq__29599_29649;
var G__29655 = chunk__29600_29650;
var G__29656 = count__29601_29651;
var G__29657 = (i__29602_29652 + (1));
seq__29599_29649 = G__29654;
chunk__29600_29650 = G__29655;
count__29601_29651 = G__29656;
i__29602_29652 = G__29657;
continue;
} else {
var temp__4126__auto___29658 = cljs.core.seq(seq__29599_29649);
if(temp__4126__auto___29658){
var seq__29599_29659__$1 = temp__4126__auto___29658;
if(cljs.core.chunked_seq_QMARK_(seq__29599_29659__$1)){
var c__5061__auto___29660 = cljs.core.chunk_first(seq__29599_29659__$1);
var G__29661 = cljs.core.chunk_rest(seq__29599_29659__$1);
var G__29662 = c__5061__auto___29660;
var G__29663 = cljs.core.count(c__5061__auto___29660);
var G__29664 = (0);
seq__29599_29649 = G__29661;
chunk__29600_29650 = G__29662;
count__29601_29651 = G__29663;
i__29602_29652 = G__29664;
continue;
} else {
var c_29665 = cljs.core.first(seq__29599_29659__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_29665);

var G__29666 = cljs.core.next(seq__29599_29659__$1);
var G__29667 = null;
var G__29668 = (0);
var G__29669 = (0);
seq__29599_29649 = G__29666;
chunk__29600_29650 = G__29667;
count__29601_29651 = G__29668;
i__29602_29652 = G__29669;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq29586){
var G__29587 = cljs.core.first(seq29586);
var seq29586__$1 = cljs.core.next(seq29586);
var G__29588 = cljs.core.first(seq29586__$1);
var seq29586__$2 = cljs.core.next(seq29586__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29587,G__29588,seq29586__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index(class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__29670 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__29670;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__29675 = arguments.length;
switch (G__29675) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___29681 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29681)){
var class_list_29682 = temp__4124__auto___29681;
class_list_29682.remove(class$__$1);
} else {
var class_name_29683 = elem__$1.className;
var new_class_name_29684 = dommy.attrs.remove_class_str(class_name_29683,class$__$1);
if((class_name_29683 === new_class_name_29684)){
} else {
elem__$1.className = new_class_name_29684;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29676 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__29677 = null;
var count__29678 = (0);
var i__29679 = (0);
while(true){
if((i__29679 < count__29678)){
var c = chunk__29677.cljs$core$IIndexed$_nth$arity$2(null,i__29679);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__29685 = seq__29676;
var G__29686 = chunk__29677;
var G__29687 = count__29678;
var G__29688 = (i__29679 + (1));
seq__29676 = G__29685;
chunk__29677 = G__29686;
count__29678 = G__29687;
i__29679 = G__29688;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__29676);
if(temp__4126__auto__){
var seq__29676__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29676__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__29676__$1);
var G__29689 = cljs.core.chunk_rest(seq__29676__$1);
var G__29690 = c__5061__auto__;
var G__29691 = cljs.core.count(c__5061__auto__);
var G__29692 = (0);
seq__29676 = G__29689;
chunk__29677 = G__29690;
count__29678 = G__29691;
i__29679 = G__29692;
continue;
} else {
var c = cljs.core.first(seq__29676__$1);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__29693 = cljs.core.next(seq__29676__$1);
var G__29694 = null;
var G__29695 = (0);
var G__29696 = (0);
seq__29676 = G__29693;
chunk__29677 = G__29694;
count__29678 = G__29695;
i__29679 = G__29696;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq29671){
var G__29672 = cljs.core.first(seq29671);
var seq29671__$1 = cljs.core.next(seq29671);
var G__29673 = cljs.core.first(seq29671__$1);
var seq29671__$2 = cljs.core.next(seq29671__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29672,G__29673,seq29671__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__29698 = arguments.length;
switch (G__29698) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___29700 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29700)){
var class_list_29701 = temp__4124__auto___29700;
class_list_29701.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_(elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__29704){
var vec__29705 = p__29704;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29705,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29705,(1),null);
return [cljs.core.str(cljs.core.name(k)),cljs.core.str(":"),cljs.core.str(cljs.core.name(v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var style = elem__$1.style;
var seq__29708_29714 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__29709_29715 = null;
var count__29710_29716 = (0);
var i__29711_29717 = (0);
while(true){
if((i__29711_29717 < count__29710_29716)){
var vec__29712_29718 = chunk__29709_29715.cljs$core$IIndexed$_nth$arity$2(null,i__29711_29717);
var k_29719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29712_29718,(0),null);
var v_29720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29712_29718,(1),null);
(style[cljs.core.name(k_29719)] = v_29720);

var G__29721 = seq__29708_29714;
var G__29722 = chunk__29709_29715;
var G__29723 = count__29710_29716;
var G__29724 = (i__29711_29717 + (1));
seq__29708_29714 = G__29721;
chunk__29709_29715 = G__29722;
count__29710_29716 = G__29723;
i__29711_29717 = G__29724;
continue;
} else {
var temp__4126__auto___29725 = cljs.core.seq(seq__29708_29714);
if(temp__4126__auto___29725){
var seq__29708_29726__$1 = temp__4126__auto___29725;
if(cljs.core.chunked_seq_QMARK_(seq__29708_29726__$1)){
var c__5061__auto___29727 = cljs.core.chunk_first(seq__29708_29726__$1);
var G__29728 = cljs.core.chunk_rest(seq__29708_29726__$1);
var G__29729 = c__5061__auto___29727;
var G__29730 = cljs.core.count(c__5061__auto___29727);
var G__29731 = (0);
seq__29708_29714 = G__29728;
chunk__29709_29715 = G__29729;
count__29710_29716 = G__29730;
i__29711_29717 = G__29731;
continue;
} else {
var vec__29713_29732 = cljs.core.first(seq__29708_29726__$1);
var k_29733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29713_29732,(0),null);
var v_29734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29713_29732,(1),null);
(style[cljs.core.name(k_29733)] = v_29734);

var G__29735 = cljs.core.next(seq__29708_29726__$1);
var G__29736 = null;
var G__29737 = (0);
var G__29738 = (0);
seq__29708_29714 = G__29735;
chunk__29709_29715 = G__29736;
count__29710_29716 = G__29737;
i__29711_29717 = G__29738;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq29706){
var G__29707 = cljs.core.first(seq29706);
var seq29706__$1 = cljs.core.next(seq29706);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29707,seq29706__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"k","k",-505765866,null)], 0)))].join('')));
}

return ((function (){var G__29740 = dommy.template.__GT_node_like(elem);
return window.getComputedStyle(G__29740);
})()[cljs.core.name(k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29743_29749 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__29744_29750 = null;
var count__29745_29751 = (0);
var i__29746_29752 = (0);
while(true){
if((i__29746_29752 < count__29745_29751)){
var vec__29747_29753 = chunk__29744_29750.cljs$core$IIndexed$_nth$arity$2(null,i__29746_29752);
var k_29754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29747_29753,(0),null);
var v_29755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29747_29753,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_29754,[cljs.core.str(v_29755),cljs.core.str("px")].join('')], 0));

var G__29756 = seq__29743_29749;
var G__29757 = chunk__29744_29750;
var G__29758 = count__29745_29751;
var G__29759 = (i__29746_29752 + (1));
seq__29743_29749 = G__29756;
chunk__29744_29750 = G__29757;
count__29745_29751 = G__29758;
i__29746_29752 = G__29759;
continue;
} else {
var temp__4126__auto___29760 = cljs.core.seq(seq__29743_29749);
if(temp__4126__auto___29760){
var seq__29743_29761__$1 = temp__4126__auto___29760;
if(cljs.core.chunked_seq_QMARK_(seq__29743_29761__$1)){
var c__5061__auto___29762 = cljs.core.chunk_first(seq__29743_29761__$1);
var G__29763 = cljs.core.chunk_rest(seq__29743_29761__$1);
var G__29764 = c__5061__auto___29762;
var G__29765 = cljs.core.count(c__5061__auto___29762);
var G__29766 = (0);
seq__29743_29749 = G__29763;
chunk__29744_29750 = G__29764;
count__29745_29751 = G__29765;
i__29746_29752 = G__29766;
continue;
} else {
var vec__29748_29767 = cljs.core.first(seq__29743_29761__$1);
var k_29768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29748_29767,(0),null);
var v_29769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29748_29767,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_29768,[cljs.core.str(v_29769),cljs.core.str("px")].join('')], 0));

var G__29770 = cljs.core.next(seq__29743_29761__$1);
var G__29771 = null;
var G__29772 = (0);
var G__29773 = (0);
seq__29743_29749 = G__29770;
chunk__29744_29750 = G__29771;
count__29745_29751 = G__29772;
i__29746_29752 = G__29773;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq29741){
var G__29742 = cljs.core.first(seq29741);
var seq29741__$1 = cljs.core.next(seq29741);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29742,seq29741__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style(dommy.template.__GT_node_like(elem),k);
if(cljs.core.seq(pixels)){
var G__29775 = pixels;
return parseInt(G__29775);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__29781 = arguments.length;
switch (G__29781) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__29782 = dommy.template.__GT_node_like(elem);
(G__29782[cljs.core.name(k)] = v);

return G__29782;
} else {
var G__29783 = dommy.template.__GT_node_like(elem);
G__29783.setAttribute(cljs.core.name(k),(((k === cljs.core.constant$keyword$style))?dommy.attrs.style_str(v):v));

return G__29783;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29784_29791 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__29785_29792 = null;
var count__29786_29793 = (0);
var i__29787_29794 = (0);
while(true){
if((i__29787_29794 < count__29786_29793)){
var vec__29788_29795 = chunk__29785_29792.cljs$core$IIndexed$_nth$arity$2(null,i__29787_29794);
var k_29796__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29788_29795,(0),null);
var v_29797__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29788_29795,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_29796__$1,v_29797__$1);

var G__29798 = seq__29784_29791;
var G__29799 = chunk__29785_29792;
var G__29800 = count__29786_29793;
var G__29801 = (i__29787_29794 + (1));
seq__29784_29791 = G__29798;
chunk__29785_29792 = G__29799;
count__29786_29793 = G__29800;
i__29787_29794 = G__29801;
continue;
} else {
var temp__4126__auto___29802 = cljs.core.seq(seq__29784_29791);
if(temp__4126__auto___29802){
var seq__29784_29803__$1 = temp__4126__auto___29802;
if(cljs.core.chunked_seq_QMARK_(seq__29784_29803__$1)){
var c__5061__auto___29804 = cljs.core.chunk_first(seq__29784_29803__$1);
var G__29805 = cljs.core.chunk_rest(seq__29784_29803__$1);
var G__29806 = c__5061__auto___29804;
var G__29807 = cljs.core.count(c__5061__auto___29804);
var G__29808 = (0);
seq__29784_29791 = G__29805;
chunk__29785_29792 = G__29806;
count__29786_29793 = G__29807;
i__29787_29794 = G__29808;
continue;
} else {
var vec__29789_29809 = cljs.core.first(seq__29784_29803__$1);
var k_29810__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29789_29809,(0),null);
var v_29811__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29789_29809,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_29810__$1,v_29811__$1);

var G__29812 = cljs.core.next(seq__29784_29803__$1);
var G__29813 = null;
var G__29814 = (0);
var G__29815 = (0);
seq__29784_29791 = G__29812;
chunk__29785_29792 = G__29813;
count__29786_29793 = G__29814;
i__29787_29794 = G__29815;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq29776){
var G__29777 = cljs.core.first(seq29776);
var seq29776__$1 = cljs.core.next(seq29776);
var G__29778 = cljs.core.first(seq29776__$1);
var seq29776__$2 = cljs.core.next(seq29776__$1);
var G__29779 = cljs.core.first(seq29776__$2);
var seq29776__$3 = cljs.core.next(seq29776__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29777,G__29778,G__29779,seq29776__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__29820 = arguments.length;
switch (G__29820) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$class,null,cljs.core.constant$keyword$classes,null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name(k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29821_29826 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__29822_29827 = null;
var count__29823_29828 = (0);
var i__29824_29829 = (0);
while(true){
if((i__29824_29829 < count__29823_29828)){
var k_29830__$1 = chunk__29822_29827.cljs$core$IIndexed$_nth$arity$2(null,i__29824_29829);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_29830__$1);

var G__29831 = seq__29821_29826;
var G__29832 = chunk__29822_29827;
var G__29833 = count__29823_29828;
var G__29834 = (i__29824_29829 + (1));
seq__29821_29826 = G__29831;
chunk__29822_29827 = G__29832;
count__29823_29828 = G__29833;
i__29824_29829 = G__29834;
continue;
} else {
var temp__4126__auto___29835 = cljs.core.seq(seq__29821_29826);
if(temp__4126__auto___29835){
var seq__29821_29836__$1 = temp__4126__auto___29835;
if(cljs.core.chunked_seq_QMARK_(seq__29821_29836__$1)){
var c__5061__auto___29837 = cljs.core.chunk_first(seq__29821_29836__$1);
var G__29838 = cljs.core.chunk_rest(seq__29821_29836__$1);
var G__29839 = c__5061__auto___29837;
var G__29840 = cljs.core.count(c__5061__auto___29837);
var G__29841 = (0);
seq__29821_29826 = G__29838;
chunk__29822_29827 = G__29839;
count__29823_29828 = G__29840;
i__29824_29829 = G__29841;
continue;
} else {
var k_29842__$1 = cljs.core.first(seq__29821_29836__$1);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_29842__$1);

var G__29843 = cljs.core.next(seq__29821_29836__$1);
var G__29844 = null;
var G__29845 = (0);
var G__29846 = (0);
seq__29821_29826 = G__29843;
chunk__29822_29827 = G__29844;
count__29823_29828 = G__29845;
i__29824_29829 = G__29846;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq29816){
var G__29817 = cljs.core.first(seq29816);
var seq29816__$1 = cljs.core.next(seq29816);
var G__29818 = cljs.core.first(seq29816__$1);
var seq29816__$2 = cljs.core.next(seq29816__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29817,G__29818,seq29816__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like(elem).getAttribute(cljs.core.name(k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__29848 = arguments.length;
switch (G__29848) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.attrs.attr(elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like(elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__29851 = arguments.length;
switch (G__29851) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__29852 = dommy.template.__GT_node_like(elem);
G__29852.style.display = ((show_QMARK_)?"":"none");

return G__29852;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,dommy.attrs.hidden_QMARK_(elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__29855 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__29855,false);

return G__29855;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__29857 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__29857,true);

return G__29857;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__29859 = dommy.template.__GT_node_like(elem).getBoundingClientRect();
(G__29859["constructor"] = Object);

return G__29859;
})(),cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0));
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
var top = cljs.core.constant$keyword$top.cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect(elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
