// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
/**
 * Handles API server's response and acts according to given
 * callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__16652,p__16653){
var map__16660 = p__16652;
var map__16660__$1 = ((((!((map__16660 == null)))?((((map__16660.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16660.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16660):map__16660);
var response = map__16660__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16660__$1,cljs.core.constant$keyword$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16660__$1,cljs.core.constant$keyword$body);
var map__16661 = p__16653;
var map__16661__$1 = ((((!((map__16661 == null)))?((((map__16661.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16661.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16661):map__16661);
var callbacks = map__16661__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16661__$1,cljs.core.constant$keyword$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16661__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16661__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16661__$1,cljs.core.constant$keyword$on_DASH_stop,cljs.core.constantly(null));
var map__16664 = body;
var map__16664__$1 = ((((!((map__16664 == null)))?((((map__16664.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16664.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16664):map__16664);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16664__$1,cljs.core.constant$keyword$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16664__$1,cljs.core.constant$keyword$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16664__$1,cljs.core.constant$keyword$job_uuid);
var is_failed_status_QMARK_ = ((function (map__16664,map__16664__$1,export_url,job_status,job_id,map__16660,map__16660__$1,response,status,body,map__16661,map__16661__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__16664,map__16664__$1,export_url,job_status,job_id,map__16660,map__16660__$1,response,status,body,map__16661,map__16661__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__4495__auto__ = cljs.core.constant$keyword$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4495__auto__)){
return or__4495__auto__;
} else {
var or__4495__auto____$1 = cljs.core.constant$keyword$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__4495__auto____$1)){
return or__4495__auto____$1;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}
} else {
}

if(cljs.core.truth_((function (){var or__4495__auto__ = (status >= (400));
if(or__4495__auto__){
return or__4495__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 * `millis` is the number of milliseconds after which to poll again.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(){
var args__5541__auto__ = [];
var len__5534__auto___16724 = arguments.length;
var i__5535__auto___16725 = (0);
while(true){
if((i__5535__auto___16725 < len__5534__auto___16724)){
args__5541__auto__.push((arguments[i__5535__auto___16725]));

var G__16726 = (i__5535__auto___16725 + (1));
i__5535__auto___16725 = G__16726;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((2) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((2)),(0))):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5542__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__16669){
var vec__16670 = p__16669;
var map__16671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16670,(0),null);
var map__16671__$1 = ((((!((map__16671 == null)))?((((map__16671.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16671.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16671):map__16671);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16671__$1,cljs.core.constant$keyword$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16671__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16671__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16671__$1,cljs.core.constant$keyword$millis);
var done_polling_QMARK_ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (state_16701){
var state_val_16702 = (state_16701[(1)]);
if((state_val_16702 === (7))){
var state_16701__$1 = state_16701;
var statearr_16703_16727 = state_16701__$1;
(statearr_16703_16727[(2)] = "dataviews");

(statearr_16703_16727[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (1))){
var state_16701__$1 = state_16701;
var statearr_16704_16728 = state_16701__$1;
(statearr_16704_16728[(2)] = null);

(statearr_16704_16728[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (4))){
var inst_16677 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_16701__$1 = (function (){var statearr_16705 = state_16701;
(statearr_16705[(7)] = inst_16677);

return statearr_16705;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_16706_16729 = state_16701__$1;
(statearr_16706_16729[(1)] = (7));

} else {
var statearr_16707_16730 = state_16701__$1;
(statearr_16707_16730[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (6))){
var inst_16697 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
var statearr_16708_16731 = state_16701__$1;
(statearr_16708_16731[(2)] = inst_16697);

(statearr_16708_16731[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (3))){
var inst_16699 = (state_16701[(2)]);
var state_16701__$1 = state_16701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16701__$1,inst_16699);
} else {
if((state_val_16702 === (2))){
var inst_16674 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(done_polling_QMARK_) : cljs.core.deref.call(null,done_polling_QMARK_));
var inst_16675 = cljs.core.not(inst_16674);
var state_16701__$1 = state_16701;
if(inst_16675){
var statearr_16709_16732 = state_16701__$1;
(statearr_16709_16732[(1)] = (4));

} else {
var statearr_16710_16733 = state_16701__$1;
(statearr_16710_16733[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (11))){
var inst_16693 = (state_16701[(2)]);
var state_16701__$1 = (function (){var statearr_16711 = state_16701;
(statearr_16711[(8)] = inst_16693);

return statearr_16711;
})();
var statearr_16712_16734 = state_16701__$1;
(statearr_16712_16734[(2)] = null);

(statearr_16712_16734[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (9))){
var inst_16682 = (state_16701[(9)]);
var inst_16677 = (state_16701[(7)]);
var inst_16681 = (state_16701[(2)]);
var inst_16682__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16681,dataset_id,inst_16677], 0));
var inst_16683 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_16682__$1);
var state_16701__$1 = (function (){var statearr_16713 = state_16701;
(statearr_16713[(9)] = inst_16682__$1);

return statearr_16713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16701__$1,(10),inst_16683);
} else {
if((state_val_16702 === (5))){
var state_16701__$1 = state_16701;
var statearr_16714_16735 = state_16701__$1;
(statearr_16714_16735[(2)] = null);

(statearr_16714_16735[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16702 === (10))){
var inst_16682 = (state_16701[(9)]);
var inst_16677 = (state_16701[(7)]);
var inst_16685 = (state_16701[(2)]);
var inst_16686 = [cljs.core.constant$keyword$on_DASH_stop,cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_16687 = (function (){var job_suffix = inst_16677;
var job_url = inst_16682;
var response = inst_16685;
return ((function (job_suffix,job_url,response,inst_16682,inst_16677,inst_16685,inst_16686,state_val_16702,c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(done_polling_QMARK_,true) : cljs.core.reset_BANG_.call(null,done_polling_QMARK_,true));
});
;})(job_suffix,job_url,response,inst_16682,inst_16677,inst_16685,inst_16686,state_val_16702,c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var inst_16688 = [inst_16687,on_error,on_export_url];
var inst_16689 = cljs.core.PersistentHashMap.fromArrays(inst_16686,inst_16688);
var inst_16690 = milia.api.async_export.handle_response(inst_16685,inst_16689);
var inst_16691 = cljs.core.async.timeout(millis);
var state_16701__$1 = (function (){var statearr_16715 = state_16701;
(statearr_16715[(10)] = inst_16690);

return statearr_16715;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16701__$1,(11),inst_16691);
} else {
if((state_val_16702 === (8))){
var state_16701__$1 = state_16701;
var statearr_16716_16736 = state_16701__$1;
(statearr_16716_16736[(2)] = "forms");

(statearr_16716_16736[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
;
return ((function (switch__7918__auto__,c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16720 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16720[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16720[(1)] = (1));

return statearr_16720;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16701){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16701);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16721){if((e16721 instanceof Object)){
var ex__7922__auto__ = e16721;
var statearr_16722_16737 = state_16701;
(statearr_16722_16737[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16701);

return cljs.core.constant$keyword$recur;
} else {
throw e16721;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16738 = state_16701;
state_16701 = G__16738;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16701){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
})();
var state__7985__auto__ = (function (){var statearr_16723 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16723[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__,done_polling_QMARK_,vec__16670,map__16671,map__16671__$1,on_error,on_export_url,is_filtered_dataview_QMARK_,millis))
);

return c__7983__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq16666){
var G__16667 = cljs.core.first(seq16666);
var seq16666__$1 = cljs.core.next(seq16666);
var G__16668 = cljs.core.first(seq16666__$1);
var seq16666__$2 = cljs.core.next(seq16666__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16667,G__16668,seq16666__$2);
});
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","remove_group_name","_version","query"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$meta_DASH_id,cljs.core.constant$keyword$data_DASH_id,cljs.core.constant$keyword$group_DASH_delimiter,cljs.core.constant$keyword$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.constant$keyword$remove_DASH_group_DASH_name_QMARK_,cljs.core.constant$keyword$version,cljs.core.constant$keyword$query], null);
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_(value)){
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(){
var args__5541__auto__ = [];
var len__5534__auto___16744 = arguments.length;
var i__5535__auto___16745 = (0);
while(true){
if((i__5535__auto___16745 < len__5534__auto___16744)){
args__5541__auto__.push((arguments[i__5535__auto___16745]));

var G__16746 = (i__5535__auto___16745 + (1));
i__5535__auto___16745 = G__16746;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((2) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((2)),(0))):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5542__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__16742){
var vec__16743 = p__16742;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16743,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq16739){
var G__16740 = cljs.core.first(seq16739);
var seq16739__$1 = cljs.core.next(seq16739);
var G__16741 = cljs.core.first(seq16739__$1);
var seq16739__$2 = cljs.core.next(seq16739__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__16740,G__16741,seq16739__$2);
});
/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(){
var args__5541__auto__ = [];
var len__5534__auto___16783 = arguments.length;
var i__5535__auto___16784 = (0);
while(true){
if((i__5535__auto___16784 < len__5534__auto___16783)){
args__5541__auto__.push((arguments[i__5535__auto___16784]));

var G__16785 = (i__5535__auto___16784 + (1));
i__5535__auto___16784 = G__16785;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((1) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((1)),(0))):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5542__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__16749){
var vec__16750 = p__16749;
var map__16751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16750,(0),null);
var map__16751__$1 = ((((!((map__16751 == null)))?((((map__16751.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16751.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16751):map__16751);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16751__$1,cljs.core.constant$keyword$on_DASH_error);
var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_16768){
var state_val_16769 = (state_16768[(1)]);
if((state_val_16769 === (1))){
var inst_16753 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_16768__$1 = (function (){var statearr_16770 = state_16768;
(statearr_16770[(7)] = inst_16753);

return statearr_16770;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_16771_16786 = state_16768__$1;
(statearr_16771_16786[(1)] = (2));

} else {
var statearr_16772_16787 = state_16768__$1;
(statearr_16772_16787[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_16769 === (2))){
var state_16768__$1 = state_16768;
var statearr_16773_16788 = state_16768__$1;
(statearr_16773_16788[(2)] = "dataviews");

(statearr_16773_16788[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16769 === (3))){
var state_16768__$1 = state_16768;
var statearr_16774_16789 = state_16768__$1;
(statearr_16774_16789[(2)] = "forms");

(statearr_16774_16789[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_16769 === (4))){
var inst_16758 = (state_16768[(8)]);
var inst_16753 = (state_16768[(7)]);
var inst_16757 = (state_16768[(9)]);
var inst_16757__$1 = (state_16768[(2)]);
var inst_16758__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16757__$1,dataset_id,inst_16753], 0));
var inst_16759 = milia.api.http.parse_http(cljs.core.constant$keyword$get,inst_16758__$1);
var state_16768__$1 = (function (){var statearr_16775 = state_16768;
(statearr_16775[(8)] = inst_16758__$1);

(statearr_16775[(9)] = inst_16757__$1);

return statearr_16775;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16768__$1,(5),inst_16759);
} else {
if((state_val_16769 === (5))){
var inst_16758 = (state_16768[(8)]);
var inst_16753 = (state_16768[(7)]);
var inst_16757 = (state_16768[(9)]);
var inst_16761 = (state_16768[(2)]);
var inst_16762 = (function (){var export_suffix = inst_16753;
var export_endpoint = inst_16757;
var export_url = inst_16758;
var response = inst_16761;
return ((function (export_suffix,export_endpoint,export_url,response,inst_16758,inst_16753,inst_16757,inst_16761,state_val_16769,c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$on_DASH_export_DASH_url,on_export_url,cljs.core.constant$keyword$on_DASH_error,on_error,cljs.core.constant$keyword$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], null)], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_16758,inst_16753,inst_16757,inst_16761,state_val_16769,c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_16763 = [cljs.core.constant$keyword$on_DASH_error,cljs.core.constant$keyword$on_DASH_job_DASH_id,cljs.core.constant$keyword$on_DASH_export_DASH_url];
var inst_16764 = [on_error,inst_16762,on_export_url];
var inst_16765 = cljs.core.PersistentHashMap.fromArrays(inst_16763,inst_16764);
var inst_16766 = milia.api.async_export.handle_response(inst_16761,inst_16765);
var state_16768__$1 = state_16768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16768__$1,inst_16766);
} else {
return null;
}
}
}
}
}
});})(c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__7918__auto__,c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16779 = [null,null,null,null,null,null,null,null,null,null];
(statearr_16779[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16779[(1)] = (1));

return statearr_16779;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16768){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16768);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16780){if((e16780 instanceof Object)){
var ex__7922__auto__ = e16780;
var statearr_16781_16790 = state_16768;
(statearr_16781_16790[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16768);

return cljs.core.constant$keyword$recur;
} else {
throw e16780;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16791 = state_16768;
state_16768 = G__16791;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16768){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__7985__auto__ = (function (){var statearr_16782 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__,vec__16750,map__16751,map__16751__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__7983__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq16747){
var G__16748 = cljs.core.first(seq16747);
var seq16747__$1 = cljs.core.next(seq16747);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16748,seq16747__$1);
});
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){

var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$data_DASH_format,data_format,cljs.core.constant$keyword$on_DASH_export_DASH_url,((function (ch){
return (function (p1__16792_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__16792_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(){
var args__5541__auto__ = [];
var len__5534__auto___16817 = arguments.length;
var i__5535__auto___16818 = (0);
while(true){
if((i__5535__auto___16818 < len__5534__auto___16817)){
args__5541__auto__.push((arguments[i__5535__auto___16818]));

var G__16819 = (i__5535__auto___16818 + (1));
i__5535__auto___16818 = G__16819;
continue;
} else {
}
break;
}

var argseq__5542__auto__ = ((((3) < args__5541__auto__.length))?(new cljs.core.IndexedSeq(args__5541__auto__.slice((3)),(0))):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5542__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){

var c__7983__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7983__auto__){
return (function (){
var f__7984__auto__ = (function (){var switch__7918__auto__ = ((function (c__7983__auto__){
return (function (state_16808){
var state_val_16809 = (state_16808[(1)]);
if((state_val_16809 === (1))){
var inst_16797 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_16808__$1 = state_16808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16808__$1,(2),inst_16797);
} else {
if((state_val_16809 === (2))){
var inst_16799 = (state_16808[(2)]);
var inst_16800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16801 = [http_method,inst_16799];
var inst_16802 = (new cljs.core.PersistentVector(null,2,(5),inst_16800,inst_16801,null));
var inst_16803 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_16802,args);
var inst_16804 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_16803);
var state_16808__$1 = state_16808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16808__$1,(3),inst_16804);
} else {
if((state_val_16809 === (3))){
var inst_16806 = (state_16808[(2)]);
var state_16808__$1 = state_16808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16808__$1,inst_16806);
} else {
return null;
}
}
}
});})(c__7983__auto__))
;
return ((function (switch__7918__auto__,c__7983__auto__){
return (function() {
var milia$api$async_export$state_machine__7919__auto__ = null;
var milia$api$async_export$state_machine__7919__auto____0 = (function (){
var statearr_16813 = [null,null,null,null,null,null,null];
(statearr_16813[(0)] = milia$api$async_export$state_machine__7919__auto__);

(statearr_16813[(1)] = (1));

return statearr_16813;
});
var milia$api$async_export$state_machine__7919__auto____1 = (function (state_16808){
while(true){
var ret_value__7920__auto__ = (function (){try{while(true){
var result__7921__auto__ = switch__7918__auto__(state_16808);
if(cljs.core.keyword_identical_QMARK_(result__7921__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7921__auto__;
}
break;
}
}catch (e16814){if((e16814 instanceof Object)){
var ex__7922__auto__ = e16814;
var statearr_16815_16820 = state_16808;
(statearr_16815_16820[(5)] = ex__7922__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16808);

return cljs.core.constant$keyword$recur;
} else {
throw e16814;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7920__auto__,cljs.core.constant$keyword$recur)){
var G__16821 = state_16808;
state_16808 = G__16821;
continue;
} else {
return ret_value__7920__auto__;
}
break;
}
});
milia$api$async_export$state_machine__7919__auto__ = function(state_16808){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__7919__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__7919__auto____1.call(this,state_16808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__7919__auto____0;
milia$api$async_export$state_machine__7919__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__7919__auto____1;
return milia$api$async_export$state_machine__7919__auto__;
})()
;})(switch__7918__auto__,c__7983__auto__))
})();
var state__7985__auto__ = (function (){var statearr_16816 = (f__7984__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7984__auto__.cljs$core$IFn$_invoke$arity$0() : f__7984__auto__.call(null));
(statearr_16816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7983__auto__);

return statearr_16816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7985__auto__);
});})(c__7983__auto__))
);

return c__7983__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq16793){
var G__16794 = cljs.core.first(seq16793);
var seq16793__$1 = cljs.core.next(seq16793);
var G__16795 = cljs.core.first(seq16793__$1);
var seq16793__$2 = cljs.core.next(seq16793__$1);
var G__16796 = cljs.core.first(seq16793__$2);
var seq16793__$3 = cljs.core.next(seq16793__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__16794,G__16795,G__16796,seq16793__$3);
});
