// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('milia.utils.string');
goog.require('goog.events');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('clojure.string');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = milia.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$post,cljs.core.constant$keyword$put,cljs.core.constant$keyword$patch], null),method);
if(cljs.core.truth_((function (){var and__7924__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options);
if(cljs.core.truth_(and__7924__auto__)){
return stateful_method_QMARK_;
} else {
return and__7924__auto__;
}
})())){
return http_options;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$xhr], null),true);
if(cljs.core.truth_((function (){var and__7924__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__7924__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__7924__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.constant$keyword$t], null),(function (){var G__28088 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28088) : cljs_hash.md5.md5.call(null,G__28088));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 * Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var args__8982__auto__ = [];
var len__8975__auto___28093 = arguments.length;
var i__8976__auto___28094 = (0);
while(true){
if((i__8976__auto___28094 < len__8975__auto___28093)){
args__8982__auto__.push((arguments[i__8976__auto___28094]));

var G__28095 = (i__8976__auto___28094 + (1));
i__8976__auto___28094 = G__28095;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((0) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((0)),(0))):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__8983__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__28090){
var map__28091 = p__28090;
var map__28091__$1 = ((((!((map__28091 == null)))?((((map__28091.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28091.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28091):map__28091);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28091__$1,cljs.core.constant$keyword$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28091__$1,cljs.core.constant$keyword$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28091__$1,cljs.core.constant$keyword$accept_DASH_header);
var temp_token = cljs.core.constant$keyword$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var and__7924__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__7924__auto__)){
return (milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? milia.utils.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : milia.utils.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__7924__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4425__auto__ = (function (){var and__7924__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__7924__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__7924__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var crsf_token = temp__4425__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__7936__auto__ = accept_header;
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq28089){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28089));
});
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(io_obj){
try{return io_obj.getResponseJson();
}catch (e28097){if((e28097 instanceof Error)){
var _ = e28097;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$error,io_obj.getResponseText()], null);
} else {
throw e28097;

}
}});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 * a core.async channel where result message will be put
 * and (optionally) an id to include in the result message. Returns the
 * XhrIo object that can be used to abort request. More XhrIo API
 * docs at:
 * https://closure-library.googlecode.com/git-history/docs/class_goog_net_XhrIo.html
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(){
var args__8982__auto__ = [];
var len__8975__auto___28113 = arguments.length;
var i__8976__auto___28114 = (0);
while(true){
if((i__8976__auto___28114 < len__8975__auto___28113)){
args__8982__auto__.push((arguments[i__8976__auto___28114]));

var G__28115 = (i__8976__auto___28114 + (1));
i__8976__auto___28114 = G__28115;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((2) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((2)),(0))):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8983__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__28102){
var vec__28103 = p__28102;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28103,(0),null);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,id], null):null);
var url = form.action;
var G__28104_28116 = io_obj;
var G__28105_28117 = goog.net.EventType.SUCCESS;
var G__28106_28118 = ((function (G__28104_28116,G__28105_28117,io_obj,data,url,vec__28103,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,true], 0)));
});})(G__28104_28116,G__28105_28117,io_obj,data,url,vec__28103,id))
;
goog.events.listen(G__28104_28116,G__28105_28117,G__28106_28118);

var G__28107_28119 = io_obj;
var G__28108_28120 = goog.net.EventType.ERROR;
var G__28109_28121 = ((function (G__28107_28119,G__28108_28120,io_obj,data,url,vec__28103,id){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.constant$keyword$data,milia.api.io.get_xhr_io_response(io_obj),cljs.core.array_seq([cljs.core.constant$keyword$success_QMARK_,false], 0)));
});})(G__28107_28119,G__28108_28120,io_obj,data,url,vec__28103,id))
;
goog.events.listen(G__28107_28119,G__28108_28120,G__28109_28121);

var G__28110_28122 = io_obj;
var G__28111_28123 = goog.net.EventType.PROGRESS;
var G__28112_28124 = ((function (G__28110_28122,G__28111_28123,io_obj,data,url,vec__28103,id){
return (function (p1__28098_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.constant$keyword$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$length_DASH_computable,p1__28098_SHARP_.lengthComputable,cljs.core.constant$keyword$loaded,p1__28098_SHARP_.loaded,cljs.core.constant$keyword$total,p1__28098_SHARP_.total], null)));
});})(G__28110_28122,G__28111_28123,io_obj,data,url,vec__28103,id))
;
goog.events.listen(G__28110_28122,G__28111_28123,G__28112_28124);

io_obj.send(url,"POST",form);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq28099){
var G__28100 = cljs.core.first(seq28099);
var seq28099__$1 = cljs.core.next(seq28099);
var G__28101 = cljs.core.first(seq28099__$1);
var seq28099__$2 = cljs.core.next(seq28099__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__28100,G__28101,seq28099__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(){
var args__8982__auto__ = [];
var len__8975__auto___28187 = arguments.length;
var i__8976__auto___28188 = (0);
while(true){
if((i__8976__auto___28188 < len__8975__auto___28187)){
args__8982__auto__.push((arguments[i__8976__auto___28188]));

var G__28189 = (i__8976__auto___28188 + (1));
i__8976__auto___28188 = G__28189;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__11625__auto___28190 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___28190,response_channel){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___28190,response_channel){
return (function (state_28160){
var state_val_28161 = (state_28160[(1)]);
if((state_val_28161 === (7))){
var state_28160__$1 = state_28160;
var statearr_28162_28191 = state_28160__$1;
(statearr_28162_28191[(2)] = false);

(statearr_28162_28191[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (1))){
var inst_28128 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_28160__$1 = state_28160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28160__$1,(2),inst_28128);
} else {
if((state_val_28161 === (4))){
var state_28160__$1 = state_28160;
var statearr_28163_28192 = state_28160__$1;
(statearr_28163_28192[(2)] = false);

(statearr_28163_28192[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (13))){
var inst_28150 = (state_28160[(7)]);
var inst_28156 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_28150);
var state_28160__$1 = state_28160;
var statearr_28164_28193 = state_28160__$1;
(statearr_28164_28193[(2)] = inst_28156);

(statearr_28164_28193[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (6))){
var state_28160__$1 = state_28160;
var statearr_28165_28194 = state_28160__$1;
(statearr_28165_28194[(2)] = true);

(statearr_28165_28194[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (3))){
var inst_28130 = (state_28160[(8)]);
var inst_28135 = inst_28130.cljs$lang$protocol_mask$partition0$;
var inst_28136 = (inst_28135 & (64));
var inst_28137 = inst_28130.cljs$core$ISeq$;
var inst_28138 = (inst_28136) || (inst_28137);
var state_28160__$1 = state_28160;
if(cljs.core.truth_(inst_28138)){
var statearr_28166_28195 = state_28160__$1;
(statearr_28166_28195[(1)] = (6));

} else {
var statearr_28167_28196 = state_28160__$1;
(statearr_28167_28196[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (12))){
var inst_28154 = window.location = window.location;
var state_28160__$1 = state_28160;
var statearr_28168_28197 = state_28160__$1;
(statearr_28168_28197[(2)] = inst_28154);

(statearr_28168_28197[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (2))){
var inst_28130 = (state_28160[(8)]);
var inst_28130__$1 = (state_28160[(2)]);
var inst_28132 = (inst_28130__$1 == null);
var inst_28133 = cljs.core.not(inst_28132);
var state_28160__$1 = (function (){var statearr_28169 = state_28160;
(statearr_28169[(8)] = inst_28130__$1);

return statearr_28169;
})();
if(inst_28133){
var statearr_28170_28198 = state_28160__$1;
(statearr_28170_28198[(1)] = (3));

} else {
var statearr_28171_28199 = state_28160__$1;
(statearr_28171_28199[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (11))){
var inst_28150 = (state_28160[(7)]);
var inst_28150__$1 = (state_28160[(2)]);
var inst_28151 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28150__$1,cljs.core.constant$keyword$status);
var inst_28152 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28151,(401));
var state_28160__$1 = (function (){var statearr_28172 = state_28160;
(statearr_28172[(7)] = inst_28150__$1);

return statearr_28172;
})();
if(inst_28152){
var statearr_28173_28200 = state_28160__$1;
(statearr_28173_28200[(1)] = (12));

} else {
var statearr_28174_28201 = state_28160__$1;
(statearr_28174_28201[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (9))){
var inst_28130 = (state_28160[(8)]);
var inst_28147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28130);
var state_28160__$1 = state_28160;
var statearr_28175_28202 = state_28160__$1;
(statearr_28175_28202[(2)] = inst_28147);

(statearr_28175_28202[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (5))){
var inst_28145 = (state_28160[(2)]);
var state_28160__$1 = state_28160;
if(cljs.core.truth_(inst_28145)){
var statearr_28176_28203 = state_28160__$1;
(statearr_28176_28203[(1)] = (9));

} else {
var statearr_28177_28204 = state_28160__$1;
(statearr_28177_28204[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (14))){
var inst_28158 = (state_28160[(2)]);
var state_28160__$1 = state_28160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28160__$1,inst_28158);
} else {
if((state_val_28161 === (10))){
var inst_28130 = (state_28160[(8)]);
var state_28160__$1 = state_28160;
var statearr_28178_28205 = state_28160__$1;
(statearr_28178_28205[(2)] = inst_28130);

(statearr_28178_28205[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28161 === (8))){
var inst_28142 = (state_28160[(2)]);
var state_28160__$1 = state_28160;
var statearr_28179_28206 = state_28160__$1;
(statearr_28179_28206[(2)] = inst_28142);

(statearr_28179_28206[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11625__auto___28190,response_channel))
;
return ((function (switch__11560__auto__,c__11625__auto___28190,response_channel){
return (function() {
var milia$api$io$state_machine__11561__auto__ = null;
var milia$api$io$state_machine__11561__auto____0 = (function (){
var statearr_28183 = [null,null,null,null,null,null,null,null,null];
(statearr_28183[(0)] = milia$api$io$state_machine__11561__auto__);

(statearr_28183[(1)] = (1));

return statearr_28183;
});
var milia$api$io$state_machine__11561__auto____1 = (function (state_28160){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28160);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28184){if((e28184 instanceof Object)){
var ex__11564__auto__ = e28184;
var statearr_28185_28207 = state_28160;
(statearr_28185_28207[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28160);

return cljs.core.constant$keyword$recur;
} else {
throw e28184;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28208 = state_28160;
state_28160 = G__28208;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
milia$api$io$state_machine__11561__auto__ = function(state_28160){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__11561__auto____0.call(this);
case 1:
return milia$api$io$state_machine__11561__auto____1.call(this,state_28160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__11561__auto____0;
milia$api$io$state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__11561__auto____1;
return milia$api$io$state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___28190,response_channel))
})();
var state__11627__auto__ = (function (){var statearr_28186 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28186[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___28190);

return statearr_28186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___28190,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq28125){
var G__28126 = cljs.core.first(seq28125);
var seq28125__$1 = cljs.core.next(seq28125);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__28126,seq28125__$1);
});
