// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 * 2. `generic_xml`
 * 3. `textit`
 * 4. `f2dhis2`
 * 5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following keys in the case of textit:
 * 1. `:service` - Service being configured
 * 2. `:auth_token` - Authentication token
 * 3. `:flow_uuid` - UUID of the flow in textit
 * 4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(){
var args__8982__auto__ = [];
var len__8975__auto___28335 = arguments.length;
var i__8976__auto___28336 = (0);
while(true){
if((i__8976__auto___28336 < len__8975__auto___28335)){
args__8982__auto__.push((arguments[i__8976__auto___28336]));

var G__28337 = (i__8976__auto___28336 + (1));
i__8976__auto___28336 = G__28337;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((3) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((3)),(0))):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8983__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__28333){
var vec__28334 = p__28333;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28334,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$xform,xform_id,cljs.core.constant$keyword$name,name,cljs.core.constant$keyword$service_url,service_url], null),options], 0)),cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq28329){
var G__28330 = cljs.core.first(seq28329);
var seq28329__$1 = cljs.core.next(seq28329);
var G__28331 = cljs.core.first(seq28329__$1);
var seq28329__$2 = cljs.core.next(seq28329__$1);
var G__28332 = cljs.core.first(seq28329__$2);
var seq28329__$3 = cljs.core.next(seq28329__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__28330,G__28331,G__28332,seq28329__$3);
});
/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.constant$keyword$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(id){
return milia.api.http.parse_http(cljs.core.constant$keyword$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
