// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__7924__auto__ = v;
if(cljs.core.truth_(and__7924__auto__)){
return (v > (0));
} else {
return and__7924__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__29207_SHARP_,p2__29206_SHARP_){
var vec__29209 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__29206_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29209,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29209,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29207_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29210_SHARP_){
return cljs_http.client.encode_val(k,p1__29210_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__29211){
var vec__29213 = p__29211;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29213,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29213,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__29214_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__29214_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__7924__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__7924__auto__){
var and__7924__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__7924__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__7924__auto____$1;
}
} else {
return and__7924__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29216 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29216) : client.call(null,G__29216));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29217_SHARP_){
return cljs_http.client.decode_body(p1__29217_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(){
var args__8982__auto__ = [];
var len__8975__auto___29223 = arguments.length;
var i__8976__auto___29224 = (0);
while(true){
if((i__8976__auto___29224 < len__8975__auto___29223)){
args__8982__auto__.push((arguments[i__8976__auto___29224]));

var G__29225 = (i__8976__auto___29224 + (1));
i__8976__auto___29224 = G__29225;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29220){
var vec__29221 = p__29220;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29221,(0),null);
return ((function (vec__29221,default_headers){
return (function (request){
var temp__4423__auto__ = (function (){var or__7936__auto__ = cljs.core.constant$keyword$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var default_headers__$1 = temp__4423__auto__;
var G__29222 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.constant$keyword$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29222) : client.call(null,G__29222));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29221,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq29218){
var G__29219 = cljs.core.first(seq29218);
var seq29218__$1 = cljs.core.next(seq29218);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__29219,seq29218__$1);
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var args__8982__auto__ = [];
var len__8975__auto___29231 = arguments.length;
var i__8976__auto___29232 = (0);
while(true){
if((i__8976__auto___29232 < len__8975__auto___29231)){
args__8982__auto__.push((arguments[i__8976__auto___29232]));

var G__29233 = (i__8976__auto___29232 + (1));
i__8976__auto___29232 = G__29233;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29228){
var vec__29229 = p__29228;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29229,(0),null);
return ((function (vec__29229,accept){
return (function (request){
var temp__4423__auto__ = (function (){var or__7936__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var accept__$1 = temp__4423__auto__;
var G__29230 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29230) : client.call(null,G__29230));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29229,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq29226){
var G__29227 = cljs.core.first(seq29226);
var seq29226__$1 = cljs.core.next(seq29226);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__29227,seq29226__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var args__8982__auto__ = [];
var len__8975__auto___29239 = arguments.length;
var i__8976__auto___29240 = (0);
while(true){
if((i__8976__auto___29240 < len__8975__auto___29239)){
args__8982__auto__.push((arguments[i__8976__auto___29240]));

var G__29241 = (i__8976__auto___29240 + (1));
i__8976__auto___29240 = G__29241;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29236){
var vec__29237 = p__29236;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29237,(0),null);
return ((function (vec__29237,content_type){
return (function (request){
var temp__4423__auto__ = (function (){var or__7936__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var content_type__$1 = temp__4423__auto__;
var G__29238 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29238) : client.call(null,G__29238));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__29237,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq29234){
var G__29235 = cljs.core.first(seq29234);
var seq29234__$1 = cljs.core.next(seq29234);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__29235,seq29234__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var map__29245 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29245__$1 = ((((!((map__29245 == null)))?((((map__29245.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29245.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29245):map__29245);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29245__$1,cljs.core.constant$keyword$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29245__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var G__29247 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29247) : client.call(null,G__29247));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__29252 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__29252__$1 = ((((!((map__29252 == null)))?((((map__29252.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29252.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29252):map__29252);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29252__$1,cljs.core.constant$keyword$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29252__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var transit_decode = ((function (map__29252,map__29252__$1,decoding,decoding_opts){
return (function (p1__29248_SHARP_){
return cljs_http.util.transit_decode(p1__29248_SHARP_,decoding,decoding_opts);
});})(map__29252,map__29252__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__29252,map__29252__$1,decoding,decoding_opts,transit_decode){
return (function (p1__29249_SHARP_){
return cljs_http.client.decode_body(p1__29249_SHARP_,transit_decode,"application/transit+json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__29252,map__29252__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var params = temp__4423__auto__;
var G__29255 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29255) : client.call(null,G__29255));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__29256_SHARP_){
return cljs_http.client.decode_body(p1__29256_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__29261){
var map__29262 = p__29261;
var map__29262__$1 = ((((!((map__29262 == null)))?((((map__29262.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29262.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29262):map__29262);
var req = map__29262__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29262__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__29264 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29264) : client.call(null,G__29264));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__29269){
var map__29270 = p__29269;
var map__29270__$1 = ((((!((map__29270 == null)))?((((map__29270.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29270.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29270):map__29270);
var request = map__29270__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29270__$1,cljs.core.constant$keyword$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29270__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__7924__auto__ = form_params;
if(cljs.core.truth_(and__7924__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__7924__auto__;
}
})())){
var G__29272 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29272) : client.call(null,G__29272));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__29279_29285 = cljs.core.seq(params);
var chunk__29280_29286 = null;
var count__29281_29287 = (0);
var i__29282_29288 = (0);
while(true){
if((i__29282_29288 < count__29281_29287)){
var vec__29283_29289 = chunk__29280_29286.cljs$core$IIndexed$_nth$arity$2(null,i__29282_29288);
var k_29290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29283_29289,(0),null);
var v_29291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29283_29289,(1),null);
form_data.append(cljs.core.name(k_29290),v_29291);

var G__29292 = seq__29279_29285;
var G__29293 = chunk__29280_29286;
var G__29294 = count__29281_29287;
var G__29295 = (i__29282_29288 + (1));
seq__29279_29285 = G__29292;
chunk__29280_29286 = G__29293;
count__29281_29287 = G__29294;
i__29282_29288 = G__29295;
continue;
} else {
var temp__4425__auto___29296 = cljs.core.seq(seq__29279_29285);
if(temp__4425__auto___29296){
var seq__29279_29297__$1 = temp__4425__auto___29296;
if(cljs.core.chunked_seq_QMARK_(seq__29279_29297__$1)){
var c__8720__auto___29298 = cljs.core.chunk_first(seq__29279_29297__$1);
var G__29299 = cljs.core.chunk_rest(seq__29279_29297__$1);
var G__29300 = c__8720__auto___29298;
var G__29301 = cljs.core.count(c__8720__auto___29298);
var G__29302 = (0);
seq__29279_29285 = G__29299;
chunk__29280_29286 = G__29300;
count__29281_29287 = G__29301;
i__29282_29288 = G__29302;
continue;
} else {
var vec__29284_29303 = cljs.core.first(seq__29279_29297__$1);
var k_29304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29284_29303,(0),null);
var v_29305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29284_29303,(1),null);
form_data.append(cljs.core.name(k_29304),v_29305);

var G__29306 = cljs.core.next(seq__29279_29297__$1);
var G__29307 = null;
var G__29308 = (0);
var G__29309 = (0);
seq__29279_29285 = G__29306;
chunk__29280_29286 = G__29307;
count__29281_29287 = G__29308;
i__29282_29288 = G__29309;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__29314){
var map__29315 = p__29314;
var map__29315__$1 = ((((!((map__29315 == null)))?((((map__29315.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29315.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29315):map__29315);
var request = map__29315__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.constant$keyword$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29315__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core.truth_((function (){var and__7924__auto__ = multipart_params;
if(cljs.core.truth_(and__7924__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__7924__auto__;
}
})())){
var G__29317 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$multipart_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29317) : client.call(null,G__29317));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var m = temp__4423__auto__;
var G__29319 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29319) : client.call(null,G__29319));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__29320_SHARP_){
var G__29322 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29320_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29322) : client.call(null,G__29322));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__29328){
var map__29329 = p__29328;
var map__29329__$1 = ((((!((map__29329 == null)))?((((map__29329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29329):map__29329);
var req = map__29329__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29329__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4423__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4423__auto__)){
var spec = temp__4423__auto__;
var G__29331 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4423__auto__,map__29329,map__29329__$1,req,query_params){
return (function (p1__29323_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__29323_SHARP_,query_params], 0));
});})(spec,temp__4423__auto__,map__29329,map__29329__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29331) : client.call(null,G__29331));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var args__8982__auto__ = [];
var len__8975__auto___29337 = arguments.length;
var i__8976__auto___29338 = (0);
while(true){
if((i__8976__auto___29338 < len__8975__auto___29337)){
args__8982__auto__.push((arguments[i__8976__auto___29338]));

var G__29339 = (i__8976__auto___29338 + (1));
i__8976__auto___29338 = G__29339;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__29334){
var vec__29335 = p__29334;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29335,(0),null);
return ((function (vec__29335,credentials){
return (function (req){
var credentials__$1 = (function (){var or__7936__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__29336 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29336) : client.call(null,G__29336));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__29335,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq29332){
var G__29333 = cljs.core.first(seq29332);
var seq29332__$1 = cljs.core.next(seq29332);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__29333,seq29332__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4423__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4423__auto__)){
var oauth_token = temp__4423__auto__;
var G__29341 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__29341) : client.call(null,G__29341));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4423__auto__ = cljs.core.constant$keyword$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4423__auto__)){
var custom_channel = temp__4423__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var args__8982__auto__ = [];
var len__8975__auto___29347 = arguments.length;
var i__8976__auto___29348 = (0);
while(true){
if((i__8976__auto___29348 < len__8975__auto___29347)){
args__8982__auto__.push((arguments[i__8976__auto___29348]));

var G__29349 = (i__8976__auto___29348 + (1));
i__8976__auto___29348 = G__29349;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29344){
var vec__29345 = p__29344;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29345,(0),null);
var G__29346 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29346) : cljs_http.client.request.call(null,G__29346));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq29342){
var G__29343 = cljs.core.first(seq29342);
var seq29342__$1 = cljs.core.next(seq29342);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__29343,seq29342__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var args__8982__auto__ = [];
var len__8975__auto___29355 = arguments.length;
var i__8976__auto___29356 = (0);
while(true){
if((i__8976__auto___29356 < len__8975__auto___29355)){
args__8982__auto__.push((arguments[i__8976__auto___29356]));

var G__29357 = (i__8976__auto___29356 + (1));
i__8976__auto___29356 = G__29357;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29352){
var vec__29353 = p__29352;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29353,(0),null);
var G__29354 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29354) : cljs_http.client.request.call(null,G__29354));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq29350){
var G__29351 = cljs.core.first(seq29350);
var seq29350__$1 = cljs.core.next(seq29350);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__29351,seq29350__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var args__8982__auto__ = [];
var len__8975__auto___29363 = arguments.length;
var i__8976__auto___29364 = (0);
while(true){
if((i__8976__auto___29364 < len__8975__auto___29363)){
args__8982__auto__.push((arguments[i__8976__auto___29364]));

var G__29365 = (i__8976__auto___29364 + (1));
i__8976__auto___29364 = G__29365;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29360){
var vec__29361 = p__29360;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29361,(0),null);
var G__29362 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29362) : cljs_http.client.request.call(null,G__29362));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq29358){
var G__29359 = cljs.core.first(seq29358);
var seq29358__$1 = cljs.core.next(seq29358);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__29359,seq29358__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(){
var args__8982__auto__ = [];
var len__8975__auto___29371 = arguments.length;
var i__8976__auto___29372 = (0);
while(true){
if((i__8976__auto___29372 < len__8975__auto___29371)){
args__8982__auto__.push((arguments[i__8976__auto___29372]));

var G__29373 = (i__8976__auto___29372 + (1));
i__8976__auto___29372 = G__29373;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29368){
var vec__29369 = p__29368;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29369,(0),null);
var G__29370 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$jsonp,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29370) : cljs_http.client.request.call(null,G__29370));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq29366){
var G__29367 = cljs.core.first(seq29366);
var seq29366__$1 = cljs.core.next(seq29366);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__29367,seq29366__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var args__8982__auto__ = [];
var len__8975__auto___29379 = arguments.length;
var i__8976__auto___29380 = (0);
while(true){
if((i__8976__auto___29380 < len__8975__auto___29379)){
args__8982__auto__.push((arguments[i__8976__auto___29380]));

var G__29381 = (i__8976__auto___29380 + (1));
i__8976__auto___29380 = G__29381;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29376){
var vec__29377 = p__29376;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29377,(0),null);
var G__29378 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29378) : cljs_http.client.request.call(null,G__29378));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq29374){
var G__29375 = cljs.core.first(seq29374);
var seq29374__$1 = cljs.core.next(seq29374);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__29375,seq29374__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var args__8982__auto__ = [];
var len__8975__auto___29387 = arguments.length;
var i__8976__auto___29388 = (0);
while(true){
if((i__8976__auto___29388 < len__8975__auto___29387)){
args__8982__auto__.push((arguments[i__8976__auto___29388]));

var G__29389 = (i__8976__auto___29388 + (1));
i__8976__auto___29388 = G__29389;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29384){
var vec__29385 = p__29384;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29385,(0),null);
var G__29386 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29386) : cljs_http.client.request.call(null,G__29386));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq29382){
var G__29383 = cljs.core.first(seq29382);
var seq29382__$1 = cljs.core.next(seq29382);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__29383,seq29382__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var args__8982__auto__ = [];
var len__8975__auto___29395 = arguments.length;
var i__8976__auto___29396 = (0);
while(true){
if((i__8976__auto___29396 < len__8975__auto___29395)){
args__8982__auto__.push((arguments[i__8976__auto___29396]));

var G__29397 = (i__8976__auto___29396 + (1));
i__8976__auto___29396 = G__29397;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29392){
var vec__29393 = p__29392;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29393,(0),null);
var G__29394 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29394) : cljs_http.client.request.call(null,G__29394));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq29390){
var G__29391 = cljs.core.first(seq29390);
var seq29390__$1 = cljs.core.next(seq29390);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__29391,seq29390__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var args__8982__auto__ = [];
var len__8975__auto___29403 = arguments.length;
var i__8976__auto___29404 = (0);
while(true){
if((i__8976__auto___29404 < len__8975__auto___29403)){
args__8982__auto__.push((arguments[i__8976__auto___29404]));

var G__29405 = (i__8976__auto___29404 + (1));
i__8976__auto___29404 = G__29405;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29400){
var vec__29401 = p__29400;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29401,(0),null);
var G__29402 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29402) : cljs_http.client.request.call(null,G__29402));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq29398){
var G__29399 = cljs.core.first(seq29398);
var seq29398__$1 = cljs.core.next(seq29398);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__29399,seq29398__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var args__8982__auto__ = [];
var len__8975__auto___29411 = arguments.length;
var i__8976__auto___29412 = (0);
while(true){
if((i__8976__auto___29412 < len__8975__auto___29411)){
args__8982__auto__.push((arguments[i__8976__auto___29412]));

var G__29413 = (i__8976__auto___29412 + (1));
i__8976__auto___29412 = G__29413;
continue;
} else {
}
break;
}

var argseq__8983__auto__ = ((((1) < args__8982__auto__.length))?(new cljs.core.IndexedSeq(args__8982__auto__.slice((1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8983__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__29408){
var vec__29409 = p__29408;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29409,(0),null);
var G__29410 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__29410) : cljs_http.client.request.call(null,G__29410));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq29406){
var G__29407 = cljs.core.first(seq29406);
var seq29406__$1 = cljs.core.next(seq29406);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__29407,seq29406__$1);
});
