// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__28629 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__28629) : cljs.core.atom.call(null,G__28629));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 * with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4425__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4425__auto__)){
var req = temp__4425__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.constant$keyword$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.constant$keyword$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var seq__28642 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)));
var chunk__28647 = null;
var count__28648 = (0);
var i__28649 = (0);
while(true){
if((i__28649 < count__28648)){
var h_name = chunk__28647.cljs$core$IIndexed$_nth$arity$2(null,i__28649);
var seq__28650_28654 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28651_28655 = null;
var count__28652_28656 = (0);
var i__28653_28657 = (0);
while(true){
if((i__28653_28657 < count__28652_28656)){
var h_val_28658 = chunk__28651_28655.cljs$core$IIndexed$_nth$arity$2(null,i__28653_28657);
xhr.headers.set(h_name,h_val_28658);

var G__28659 = seq__28650_28654;
var G__28660 = chunk__28651_28655;
var G__28661 = count__28652_28656;
var G__28662 = (i__28653_28657 + (1));
seq__28650_28654 = G__28659;
chunk__28651_28655 = G__28660;
count__28652_28656 = G__28661;
i__28653_28657 = G__28662;
continue;
} else {
var temp__4425__auto___28663 = cljs.core.seq(seq__28650_28654);
if(temp__4425__auto___28663){
var seq__28650_28664__$1 = temp__4425__auto___28663;
if(cljs.core.chunked_seq_QMARK_(seq__28650_28664__$1)){
var c__8720__auto___28665 = cljs.core.chunk_first(seq__28650_28664__$1);
var G__28666 = cljs.core.chunk_rest(seq__28650_28664__$1);
var G__28667 = c__8720__auto___28665;
var G__28668 = cljs.core.count(c__8720__auto___28665);
var G__28669 = (0);
seq__28650_28654 = G__28666;
chunk__28651_28655 = G__28667;
count__28652_28656 = G__28668;
i__28653_28657 = G__28669;
continue;
} else {
var h_val_28670 = cljs.core.first(seq__28650_28664__$1);
xhr.headers.set(h_name,h_val_28670);

var G__28671 = cljs.core.next(seq__28650_28664__$1);
var G__28672 = null;
var G__28673 = (0);
var G__28674 = (0);
seq__28650_28654 = G__28671;
chunk__28651_28655 = G__28672;
count__28652_28656 = G__28673;
i__28653_28657 = G__28674;
continue;
}
} else {
}
}
break;
}

var G__28675 = seq__28642;
var G__28676 = chunk__28647;
var G__28677 = count__28648;
var G__28678 = (i__28649 + (1));
seq__28642 = G__28675;
chunk__28647 = G__28676;
count__28648 = G__28677;
i__28649 = G__28678;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__28642);
if(temp__4425__auto__){
var seq__28642__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28642__$1)){
var c__8720__auto__ = cljs.core.chunk_first(seq__28642__$1);
var G__28679 = cljs.core.chunk_rest(seq__28642__$1);
var G__28680 = c__8720__auto__;
var G__28681 = cljs.core.count(c__8720__auto__);
var G__28682 = (0);
seq__28642 = G__28679;
chunk__28647 = G__28680;
count__28648 = G__28681;
i__28649 = G__28682;
continue;
} else {
var h_name = cljs.core.first(seq__28642__$1);
var seq__28643_28683 = cljs.core.seq(cljs.core.vals(headers));
var chunk__28644_28684 = null;
var count__28645_28685 = (0);
var i__28646_28686 = (0);
while(true){
if((i__28646_28686 < count__28645_28685)){
var h_val_28687 = chunk__28644_28684.cljs$core$IIndexed$_nth$arity$2(null,i__28646_28686);
xhr.headers.set(h_name,h_val_28687);

var G__28688 = seq__28643_28683;
var G__28689 = chunk__28644_28684;
var G__28690 = count__28645_28685;
var G__28691 = (i__28646_28686 + (1));
seq__28643_28683 = G__28688;
chunk__28644_28684 = G__28689;
count__28645_28685 = G__28690;
i__28646_28686 = G__28691;
continue;
} else {
var temp__4425__auto___28692__$1 = cljs.core.seq(seq__28643_28683);
if(temp__4425__auto___28692__$1){
var seq__28643_28693__$1 = temp__4425__auto___28692__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28643_28693__$1)){
var c__8720__auto___28694 = cljs.core.chunk_first(seq__28643_28693__$1);
var G__28695 = cljs.core.chunk_rest(seq__28643_28693__$1);
var G__28696 = c__8720__auto___28694;
var G__28697 = cljs.core.count(c__8720__auto___28694);
var G__28698 = (0);
seq__28643_28683 = G__28695;
chunk__28644_28684 = G__28696;
count__28645_28685 = G__28697;
i__28646_28686 = G__28698;
continue;
} else {
var h_val_28699 = cljs.core.first(seq__28643_28693__$1);
xhr.headers.set(h_name,h_val_28699);

var G__28700 = cljs.core.next(seq__28643_28693__$1);
var G__28701 = null;
var G__28702 = (0);
var G__28703 = (0);
seq__28643_28683 = G__28700;
chunk__28644_28684 = G__28701;
count__28645_28685 = G__28702;
i__28646_28686 = G__28703;
continue;
}
} else {
}
}
break;
}

var G__28704 = cljs.core.next(seq__28642__$1);
var G__28705 = null;
var G__28706 = (0);
var G__28707 = (0);
seq__28642 = G__28704;
chunk__28647 = G__28705;
count__28648 = G__28706;
i__28649 = G__28707;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__28709 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$array_DASH_buffer,G__28709)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$blob,G__28709)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$document,G__28709)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$text,G__28709)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$default,G__28709)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__28709)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__28710){
var map__28714 = p__28710;
var map__28714__$1 = ((((!((map__28714 == null)))?((((map__28714.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28714.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28714):map__28714);
var request = map__28714__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28714__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28714__$1,cljs.core.constant$keyword$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28714__$1,cljs.core.constant$keyword$response_DASH_type);
var timeout = (function (){var or__7936__auto__ = cljs.core.constant$keyword$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__28716 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__28716,default_headers);

cljs_http.core.apply_response_type_BANG_(G__28716,response_type);

G__28716.setTimeoutInterval(timeout);

G__28716.setWithCredentials(send_credentials);

return G__28716;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.constant$keyword$no_DASH_error,cljs.core.constant$keyword$abort,cljs.core.constant$keyword$access_DASH_denied,cljs.core.constant$keyword$custom_DASH_error,cljs.core.constant$keyword$http_DASH_error,cljs.core.constant$keyword$ff_DASH_silent_DASH_error,cljs.core.constant$keyword$file_DASH_not_DASH_found,cljs.core.constant$keyword$offline,cljs.core.constant$keyword$exception,cljs.core.constant$keyword$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__28717){
var map__28745 = p__28717;
var map__28745__$1 = ((((!((map__28745 == null)))?((((map__28745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28745):map__28745);
var request = map__28745__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28745__$1,cljs.core.constant$keyword$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28745__$1,cljs.core.constant$keyword$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28745__$1,cljs.core.constant$keyword$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28745__$1,cljs.core.constant$keyword$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28745__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__7936__auto__ = request_method;
if(cljs.core.truth_(or__7936__auto__)){
return or__7936__auto__;
} else {
return cljs.core.constant$keyword$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$status,target.getStatus(),cljs.core.constant$keyword$success,target.isSuccess(),cljs.core.constant$keyword$body,target.getResponse(),cljs.core.constant$keyword$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.constant$keyword$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.constant$keyword$error_DASH_code,(function (){var G__28747 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__28747) : cljs_http.core.error_kw.call(null,G__28747));
})(),cljs.core.constant$keyword$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__11625__auto___28772 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_28758){
var state_val_28759 = (state_28758[(1)]);
if((state_val_28759 === (1))){
var state_28758__$1 = state_28758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28758__$1,(2),cancel);
} else {
if((state_val_28759 === (2))){
var inst_28749 = (state_28758[(2)]);
var inst_28750 = xhr__$1.isComplete();
var inst_28751 = cljs.core.not(inst_28750);
var state_28758__$1 = (function (){var statearr_28760 = state_28758;
(statearr_28760[(7)] = inst_28749);

return statearr_28760;
})();
if(inst_28751){
var statearr_28761_28773 = state_28758__$1;
(statearr_28761_28773[(1)] = (3));

} else {
var statearr_28762_28774 = state_28758__$1;
(statearr_28762_28774[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28759 === (3))){
var inst_28753 = xhr__$1.abort();
var state_28758__$1 = state_28758;
var statearr_28763_28775 = state_28758__$1;
(statearr_28763_28775[(2)] = inst_28753);

(statearr_28763_28775[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28759 === (4))){
var state_28758__$1 = state_28758;
var statearr_28764_28776 = state_28758__$1;
(statearr_28764_28776[(2)] = null);

(statearr_28764_28776[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28759 === (5))){
var inst_28756 = (state_28758[(2)]);
var state_28758__$1 = state_28758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28758__$1,inst_28756);
} else {
return null;
}
}
}
}
}
});})(c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__11560__auto__,c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__11561__auto__ = null;
var cljs_http$core$xhr_$_state_machine__11561__auto____0 = (function (){
var statearr_28768 = [null,null,null,null,null,null,null,null];
(statearr_28768[(0)] = cljs_http$core$xhr_$_state_machine__11561__auto__);

(statearr_28768[(1)] = (1));

return statearr_28768;
});
var cljs_http$core$xhr_$_state_machine__11561__auto____1 = (function (state_28758){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28758);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28769){if((e28769 instanceof Object)){
var ex__11564__auto__ = e28769;
var statearr_28770_28777 = state_28758;
(statearr_28770_28777[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28758);

return cljs.core.constant$keyword$recur;
} else {
throw e28769;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28778 = state_28758;
state_28758 = G__28778;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__11561__auto__ = function(state_28758){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__11561__auto____1.call(this,state_28758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__11561__auto____0;
cljs_http$core$xhr_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__11561__auto____1;
return cljs_http$core$xhr_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__11627__auto__ = (function (){var statearr_28771 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28771[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___28772);

return statearr_28771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___28772,channel,request_url,method,headers__$1,xhr__$1,map__28745,map__28745__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__28779){
var map__28796 = p__28779;
var map__28796__$1 = ((((!((map__28796 == null)))?((((map__28796.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28796.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28796):map__28796);
var request = map__28796__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28796__$1,cljs.core.constant$keyword$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28796__$1,cljs.core.constant$keyword$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28796__$1,cljs.core.constant$keyword$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_28812 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$status,(200),cljs.core.constant$keyword$success,true,cljs.core.constant$keyword$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel))
,((function (channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$jsonp,jsonp__$1,cljs.core.constant$keyword$request,req_28812], null));

if(cljs.core.truth_(cancel)){
var c__11625__auto___28813 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel){
return (function (){
var f__11626__auto__ = (function (){var switch__11560__auto__ = ((function (c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel){
return (function (state_28802){
var state_val_28803 = (state_28802[(1)]);
if((state_val_28803 === (1))){
var state_28802__$1 = state_28802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28802__$1,(2),cancel);
} else {
if((state_val_28803 === (2))){
var inst_28799 = (state_28802[(2)]);
var inst_28800 = jsonp__$1.cancel(req_28812);
var state_28802__$1 = (function (){var statearr_28804 = state_28802;
(statearr_28804[(7)] = inst_28799);

return statearr_28804;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28802__$1,inst_28800);
} else {
return null;
}
}
});})(c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel))
;
return ((function (switch__11560__auto__,c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel){
return (function() {
var cljs_http$core$jsonp_$_state_machine__11561__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__11561__auto____0 = (function (){
var statearr_28808 = [null,null,null,null,null,null,null,null];
(statearr_28808[(0)] = cljs_http$core$jsonp_$_state_machine__11561__auto__);

(statearr_28808[(1)] = (1));

return statearr_28808;
});
var cljs_http$core$jsonp_$_state_machine__11561__auto____1 = (function (state_28802){
while(true){
var ret_value__11562__auto__ = (function (){try{while(true){
var result__11563__auto__ = switch__11560__auto__(state_28802);
if(cljs.core.keyword_identical_QMARK_(result__11563__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__11563__auto__;
}
break;
}
}catch (e28809){if((e28809 instanceof Object)){
var ex__11564__auto__ = e28809;
var statearr_28810_28814 = state_28802;
(statearr_28810_28814[(5)] = ex__11564__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28802);

return cljs.core.constant$keyword$recur;
} else {
throw e28809;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11562__auto__,cljs.core.constant$keyword$recur)){
var G__28815 = state_28802;
state_28802 = G__28815;
continue;
} else {
return ret_value__11562__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__11561__auto__ = function(state_28802){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__11561__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__11561__auto____1.call(this,state_28802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__11561__auto____0;
cljs_http$core$jsonp_$_state_machine__11561__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__11561__auto____1;
return cljs_http$core$jsonp_$_state_machine__11561__auto__;
})()
;})(switch__11560__auto__,c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel))
})();
var state__11627__auto__ = (function (){var statearr_28811 = (f__11626__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11626__auto__.cljs$core$IFn$_invoke$arity$0() : f__11626__auto__.call(null));
(statearr_28811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11625__auto___28813);

return statearr_28811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11627__auto__);
});})(c__11625__auto___28813,req_28812,channel,jsonp__$1,map__28796,map__28796__$1,request,timeout,callback_name,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 * map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__28816){
var map__28819 = p__28816;
var map__28819__$1 = ((((!((map__28819 == null)))?((((map__28819.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28819.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28819):map__28819);
var request__$1 = map__28819__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28819__$1,cljs.core.constant$keyword$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.constant$keyword$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
